;' $Header:   P:/PVCS/386SWAT/INT1/INT1_ESC.ASV   1.7   01 Jul 1997 17:55:52   BOB  $
	title	INT1_ESC -- INT 01h Escape Code Tables
	page	58,122
	name	INT1_ESC

COMMENT|		Module Specifications

Copyright:  (C) Copyright 1988-2001 Qualitas, Inc.  All rights reserved.

Segmentation:  See SWAT_SEG.INC for details.

Program derived from:  None.

Original code by:  Bob Smith, April, 1988.

Modifications by:  None.

|

.386
.xlist
	include MASM.INC
	include BITFLAGS.INC

	include INT1_FNS.INC
	include INT1_TAB.INC
	include SWAT_SEG.INC
.list

PROG	segment use32 byte public 'prog' ; Start PROG segment
	assume	cs:PGROUP

	extrn	@OPCODE:near
	extrn	@OPCODEJCC:near

;;;;;;; extrn	@INT03:near
	extrn	@IFOSP:near
	extrn	@ELSEOSP:near
	extrn	@IFOSP2:near
	extrn	@ELSEOSP2:near
	extrn	@ENDOSP:near
	extrn	@IGNOREOSP:near

	extrn	@IFMOD11:near
	extrn	@ELSEMOD11:near
	extrn	@ENDMOD11:near

	extrn	@R8:near
	extrn	@R16:near
	extrn	@R32:near

	extrn	@RM8:near
	extrn	@RM16:near
	extrn	@RM32:near
	extrn	@RM64:near
	extrn	@R32M16:near

	extrn	@RM8P:near
	extrn	@RM16P:near
	extrn	@RM32P:near

	extrn	@IMM8:near

	extrn	@X64:near
	extrn	@X128:near
	extrn	@XM32:near
	extrn	@XM64:near
	extrn	@XM128:near

	extrn	@STACK1:near

	extrn	@DWIDTH:near

	extrn	@GRP6:near
	extrn	@GRP7:near
	extrn	@GRP8:near
	extrn	@GRP9:near
	extrn	@GRP10:near
	extrn	@GRP12:near
	extrn	@GRP13:near
	extrn	@GRP14:near
	extrn	@GRP15:near
	extrn	@GRP15Z:near
	extrn	@GRP16:near

	extrn	@CR32:near
	extrn	@DR32:near
	extrn	@TR32:near

	extrn	@REL16:near
	extrn	@REL32:near

	extrn	@UNDEF:near
	extrn	@EXIT:near

PROG	ends			; End PROG segment


TEXT	segment use32 byte public 'data' ; Start TEXT segment
	assume	ds:DGROUP

	extrn	TXT_AX:byte
	extrn	TXT_BP:byte
	extrn	TXT_BX:byte
	extrn	TXT_CX:byte
	extrn	TXT_DI:byte
	extrn	TXT_DX:byte
	extrn	TXT_SI:byte
	extrn	TXT_SP:byte

	extrn	TXT_EAX:byte
	extrn	TXT_EBP:byte
	extrn	TXT_EBX:byte
	extrn	TXT_ECX:byte
	extrn	TXT_EDI:byte
	extrn	TXT_EDX:byte
	extrn	TXT_EMMS:byte
	extrn	TXT_ESI:byte
	extrn	TXT_ESP:byte

	extrn	TXT_FS:byte
	extrn	TXT_GS:byte

	extrn	TXT_@CL:byte

	extrn	TXT_ADDPD:byte
	extrn	TXT_ADDPS:byte
	extrn	TXT_ADDSD:byte
	extrn	TXT_ADDSS:byte
	extrn	TXT_ANDNPD:byte
	extrn	TXT_ANDNPS:byte
	extrn	TXT_ANDPD:byte
	extrn	TXT_ANDPS:byte

	extrn	TXT_BSF:byte
	extrn	TXT_BSR:byte
	extrn	TXT_BSWAP:byte
	extrn	TXT_BT:byte
	extrn	TXT_BTC:byte
	extrn	TXT_BTR:byte
	extrn	TXT_BTS:byte

	extrn	TXT_CLTS:byte
	extrn	TXT_CMOVA:byte
	extrn	TXT_CMOVBE:byte
	extrn	TXT_CMOVC:byte
	extrn	TXT_CMOVG:byte
	extrn	TXT_CMOVGE:byte
	extrn	TXT_CMOVL:byte
	extrn	TXT_CMOVLE:byte
	extrn	TXT_CMOVNC:byte
	extrn	TXT_CMOVNO:byte
	extrn	TXT_CMOVNS:byte
	extrn	TXT_CMOVNZ:byte
	extrn	TXT_CMOVO:byte
	extrn	TXT_CMOVPE:byte
	extrn	TXT_CMOVPO:byte
	extrn	TXT_CMOVS:byte
	extrn	TXT_CMOVZ:byte
	extrn	TXT_COMISD:byte
	extrn	TXT_COMISS:byte
	extrn	TXT_CMPPD:byte
	extrn	TXT_CMPPS:byte
	extrn	TXT_CMPSD:byte
	extrn	TXT_CMPSS:byte
	extrn	TXT_CMPXCHG:byte
	extrn	TXT_CPUID:byte
	extrn	TXT_CVTDQ2PD:byte
	extrn	TXT_CVTDQ2PS:byte
	extrn	TXT_CVTPI2PD:byte
	extrn	TXT_CVTPI2PS:byte
	extrn	TXT_CVTPD2DQ:byte
	extrn	TXT_CVTPD2PI:byte
	extrn	TXT_CVTPD2PS:byte
	extrn	TXT_CVTPS2DQ:byte
	extrn	TXT_CVTPS2PD:byte
	extrn	TXT_CVTPS2PI:byte
	extrn	TXT_CVTSD2SI:byte
	extrn	TXT_CVTSD2SS:byte
	extrn	TXT_CVTSI2SD:byte
	extrn	TXT_CVTSI2SS:byte
	extrn	TXT_CVTSS2SD:byte
	extrn	TXT_CVTSS2SI:byte
	extrn	TXT_CVTTPD2DQ:byte
	extrn	TXT_CVTTPD2PI:byte
	extrn	TXT_CVTTPS2DQ:byte
	extrn	TXT_CVTTPS2PI:byte
	extrn	TXT_CVTTSD2SI:byte
	extrn	TXT_CVTTSS2SI:byte

	extrn	TXT_DIVPD:byte
	extrn	TXT_DIVPS:byte
	extrn	TXT_DIVSD:byte
	extrn	TXT_DIVSS:byte

	extrn	TXT_IBTS:byte
	extrn	TXT_IMUL:byte
	extrn	TXT_INVD:byte

	extrn	TXT_JA:byte
	extrn	TXT_JBE:byte
	extrn	TXT_JC:byte
	extrn	TXT_JG:byte
	extrn	TXT_JGE:byte
	extrn	TXT_JL:byte
	extrn	TXT_JLE:byte
	extrn	TXT_JNC:byte
	extrn	TXT_JNO:byte
	extrn	TXT_JNS:byte
	extrn	TXT_JNZ:byte
	extrn	TXT_JO:byte
	extrn	TXT_JPE:byte
	extrn	TXT_JPO:byte
	extrn	TXT_JS:byte
	extrn	TXT_JZ:byte

	extrn	TXT_LAR:byte
	extrn	TXT_LOADALL:byte
	extrn	TXT_LOADALLD:byte
	extrn	TXT_LFS:byte
	extrn	TXT_LGS:byte
	extrn	TXT_LSL:byte
	extrn	TXT_LSS:byte

	extrn	TXT_MASKMOVDQU:byte
	extrn	TXT_MASKMOVQ:byte
	extrn	TXT_MAXPD:byte
	extrn	TXT_MAXPS:byte
	extrn	TXT_MAXSD:byte
	extrn	TXT_MAXSS:byte
	extrn	TXT_MINPD:byte
	extrn	TXT_MINPS:byte
	extrn	TXT_MINSD:byte
	extrn	TXT_MINSS:byte
	extrn	TXT_MOVAPD:byte
	extrn	TXT_MOVAPS:byte
	extrn	TXT_MOV:byte
	extrn	TXT_MOVD:byte
	extrn	TXT_MOVDQ2Q:byte
	extrn	TXT_MOVDQA:byte
	extrn	TXT_MOVDQU:byte
	extrn	TXT_MOVNTDQ:byte
	extrn	TXT_MOVNTQ:byte
	extrn	TXT_MOVQ:byte
	extrn	TXT_MOVHLPS:byte
	extrn	TXT_MOVHPD:byte
	extrn	TXT_MOVHPS:byte
	extrn	TXT_MOVLHPS:byte
	extrn	TXT_MOVLPD:byte
	extrn	TXT_MOVLPS:byte
	extrn	TXT_MOVMSKPD:byte
	extrn	TXT_MOVMSKPS:byte
	extrn	TXT_MOVNTI:byte
	extrn	TXT_MOVNTPD:byte
	extrn	TXT_MOVNTPS:byte
	extrn	TXT_MOVQ2DQ:byte
	extrn	TXT_MOVSD:byte
	extrn	TXT_MOVSS:byte
	extrn	TXT_MOVSX:byte
	extrn	TXT_MOVUPD:byte
	extrn	TXT_MOVUPS:byte
	extrn	TXT_MOVZX:byte
	extrn	TXT_MULPD:byte
	extrn	TXT_MULPS:byte
	extrn	TXT_MULSD:byte
	extrn	TXT_MULSS:byte

	extrn	TXT_ORPD:byte
	extrn	TXT_ORPS:byte

	extrn	TXT_PACKSSDW:byte
	extrn	TXT_PACKSSWB:byte
	extrn	TXT_PACKUSWB:byte
	extrn	TXT_PADDB:byte
	extrn	TXT_PADDD:byte
	extrn	TXT_PADDQ:byte
	extrn	TXT_PADDSB:byte
	extrn	TXT_PADDSW:byte
	extrn	TXT_PADDUSB:byte
	extrn	TXT_PADDUSW:byte
	extrn	TXT_PADDW:byte
	extrn	TXT_PAND:byte
	extrn	TXT_PANDN:byte
	extrn	TXT_PAVGB:byte
	extrn	TXT_PAVGW:byte
	extrn	TXT_PCMPEQB:byte
	extrn	TXT_PCMPEQD:byte
	extrn	TXT_PCMPEQW:byte
	extrn	TXT_PCMPGTB:byte
	extrn	TXT_PCMPGTD:byte
	extrn	TXT_PCMPGTW:byte
	extrn	TXT_PEXTRW:byte
	extrn	TXT_PINSRW:byte
	extrn	TXT_PMADDWD:byte
	extrn	TXT_PMAXUB:byte
	extrn	TXT_PMAXSW:byte
	extrn	TXT_PMINUB:byte
	extrn	TXT_PMINSW:byte
	extrn	TXT_PMOVMSKB:byte
	extrn	TXT_PMULHUW:byte
	extrn	TXT_PMULHW:byte
	extrn	TXT_PMULLUDQ:byte
	extrn	TXT_PMULLW:byte
	extrn	TXT_POP:byte
	extrn	TXT_POPD:byte
	extrn	TXT_POR:byte
	extrn	TXT_PSADBW:byte
	extrn	TXT_PSHUFD:byte
	extrn	TXT_PSHUFHW:byte
	extrn	TXT_PSHUFLW:byte
	extrn	TXT_PSHUFW:byte
	extrn	TXT_PSLLD:byte
	extrn	TXT_PSLLW:byte
	extrn	TXT_PSLLQ:byte
	extrn	TXT_PSRAD:byte
	extrn	TXT_PSRAW:byte
	extrn	TXT_PSRLD:byte
	extrn	TXT_PSRLW:byte
	extrn	TXT_PSRLQ:byte
	extrn	TXT_PSUBB:byte
	extrn	TXT_PSUBD:byte
	extrn	TXT_PSUBQ:byte
	extrn	TXT_PSUBSB:byte
	extrn	TXT_PSUBSW:byte
	extrn	TXT_PSUBUSB:byte
	extrn	TXT_PSUBUSW:byte
	extrn	TXT_PSUBW:byte
	extrn	TXT_PUNPCKHBW:byte
	extrn	TXT_PUNPCKHDQ:byte
	extrn	TXT_PUNPCKHQDQ:byte
	extrn	TXT_PUNPCKHWD:byte
	extrn	TXT_PUNPCKLBW:byte
	extrn	TXT_PUNPCKLDQ:byte
	extrn	TXT_PUNPCKLQDQ:byte
	extrn	TXT_PUNPCKLWD:byte
	extrn	TXT_PUSH:byte
	extrn	TXT_PUSHD:byte
	extrn	TXT_PXOR:byte

	extrn	TXT_RCPPS:byte
	extrn	TXT_RCPSS:byte
	extrn	TXT_RDMSR:byte
	extrn	TXT_RDPMC:byte
	extrn	TXT_RDTSC:byte
	extrn	TXT_RSM:byte
	extrn	TXT_RSQRTPS:byte
	extrn	TXT_RSQRTSS:byte

	extrn	TXT_SETA:byte
	extrn	TXT_SETC:byte
	extrn	TXT_SETG:byte
	extrn	TXT_SETL:byte
	extrn	TXT_SETNA:byte
	extrn	TXT_SETNC:byte
	extrn	TXT_SETNG:byte
	extrn	TXT_SETNL:byte
	extrn	TXT_SETNO:byte
	extrn	TXT_SETNS:byte
	extrn	TXT_SETNZ:byte
	extrn	TXT_SETO:byte
	extrn	TXT_SETPE:byte
	extrn	TXT_SETPO:byte
	extrn	TXT_SETS:byte
	extrn	TXT_SETZ:byte
	extrn	TXT_SHLD:byte
	extrn	TXT_SHRD:byte
	extrn	TXT_SHUFPD:byte
	extrn	TXT_SHUFPS:byte
	extrn	TXT_SQRTPD:byte
	extrn	TXT_SQRTPS:byte
	extrn	TXT_SQRTSD:byte
	extrn	TXT_SQRTSS:byte
	extrn	TXT_SUBPD:byte
	extrn	TXT_SUBPS:byte
	extrn	TXT_SUBSD:byte
	extrn	TXT_SUBSS:byte
	extrn	TXT_SYSENTER:byte
	extrn	TXT_SYSEXIT:byte

	extrn	TXT_UCOMISD:byte
	extrn	TXT_UCOMISS:byte
	extrn	TXT_UD2:byte
	extrn	TXT_UNPCKHPD:byte
	extrn	TXT_UNPCKHPS:byte
	extrn	TXT_UNPCKLPD:byte
	extrn	TXT_UNPCKLPS:byte

	extrn	TXT_WBINVD:byte
	extrn	TXT_WIN06:byte

	extrn	TXT_WRMSR:byte

	extrn	TXT_XADD:byte
	extrn	TXT_XBTS:byte
	extrn	TXT_XORPD:byte
	extrn	TXT_XORPS:byte

	extrn	P@UNDEF:dword

TEXT	ends			; End TEXT segment


ESCOD	segment use32 dword public 'data' ; Start ESCOD segment
	assume	ds:DGROUP

;==============================================================================
; 0F Prefix Table

ELBL	macro	OPC

ESCOD&OPC label dword

	org	ESCOD_TAB+OPC*(type ESCOD_TAB)
	dd	offset DGROUP:ESCOD&OPC
	org	ESCOD&OPC

	endm			; ELBL

	public	ESCOD_TAB
ESCOD_TAB dd	256 dup (offset DGROUP:P@UNDEF) ; Initially all undefined

$$ASP	=	0
$$OSP	=	0
$$MOD11 =	0

	ELBL	0		; 00
	GRP6
	IFOSP2
	RM32P
	ELSEOSP2
	RM16P
	ENDOSP
	EXIT

	ELBL	1		; 01
	GRP7
	IFOSP2
	RM32P
	ELSEOSP2
	RM16P
	ENDOSP
	EXIT

	ELBL	2		; 02
	OPCODE	LAR
	IFOSP
	R32
	RM32
	DWIDTH	WORD
	ELSEOSP
	R16
	RM16
	ENDOSP
	EXIT

	ELBL	3		; 03
	OPCODE	LSL
	IFOSP
	R32
	RM32
	DWIDTH	WORD
	ELSEOSP
	R16
	RM16
	ENDOSP
	EXIT

	ELBL	5		; 05
	OPCODE	LOADALL
	EXIT

	ELBL	6		; 06
	OPCODE	CLTS
	EXIT

	ELBL	7		; 07
	OPCODE	LOADALLD
	EXIT

	ELBL	8		; 08
	OPCODE	INVD
	EXIT

	ELBL	9		; 09
	OPCODE	WBINVD
	EXIT

	ELBL	11		; 0B
	OPCODE	UD2
	EXIT

	ELBL	16		; 10
	IFOSP
	OPCODE	MOVUPD
	ELSEOSP
	OPCODE	MOVUPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	17		; 11
	IFOSP
	OPCODE	MOVUPD
	ELSEOSP
	OPCODE	MOVUPS
	ENDOSP
	XM128
	X128
	EXIT

	ELBL	18		; 12
	IFMOD11
	OPCODE	MOVHLPS
	X128
	XM128
	ELSEMOD11
	IFOSP
	OPCODE	MOVLPD
	ELSEOSP
	OPCODE	MOVLPS
	ENDOSP
	X128
	XM64
	ENDMOD11
	EXIT

	ELBL	19		; 13
	IFMOD11
	UNDEF
	ELSEMOD11
	IFOSP
	OPCODE	MOVLPD
	ELSEOSP
	OPCODE	MOVLPS
	ENDOSP
	XM64
	X128
	ENDMOD11
	EXIT

	ELBL	20		; 14
	IFOSP
	OPCODE	UNPCKLPD
	ELSEOSP
	OPCODE	UNPCKLPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	21		; 15
	IFOSP
	OPCODE	UNPCKHPD
	ELSEOSP
	OPCODE	UNPCKHPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	22		; 16
	IFMOD11
	OPCODE	MOVLHPS
	X128
	XM128
	ELSEMOD11
	IFOSP
	OPCODE	MOVHPD
	ELSEOSP
	OPCODE	MOVHPS
	ENDOSP
	X128
	XM64
	ENDMOD11
	EXIT

	ELBL	23		; 17
	IFOSP
	OPCODE	MOVHPD
	ELSEOSP
	OPCODE	MOVHPS
	ENDOSP
	XM64
	X128
	EXIT

	ELBL	24		; 18
	IFMOD11
	UNDEF
	ELSEMOD11
	GRP16
	RM8
	ENDMOD11
	EXIT

	ELBL	32		; 20
	IGNOREOSP
	OPCODE	MOV
	RM32
	CR32
	EXIT

	ELBL	33		; 21
	IGNOREOSP
	OPCODE	MOV
	RM32
	DR32
	EXIT

	ELBL	34		; 22
	IGNOREOSP
	OPCODE	MOV
	CR32
	RM32
	EXIT

	ELBL	35		; 23
	IGNOREOSP
	OPCODE	MOV
	DR32
	RM32
	EXIT

	ELBL	36		; 24
	IGNOREOSP
	OPCODE	MOV
	RM32
	TR32
	EXIT

	ELBL	38		; 26
	IGNOREOSP
	OPCODE	MOV
	TR32
	RM32
	EXIT

	ELBL	40		; 28
	IFOSP
	OPCODE	MOVAPD
	ELSEOSP
	OPCODE	MOVAPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	41		; 29
	IFOSP
	OPCODE	MOVAPD
	ELSEOSP
	OPCODE	MOVAPS
	ENDOSP
	XM128
	X128
	EXIT

	ELBL	42		; 2A
	IFOSP
	OPCODE	CVTPI2PD
	ELSEOSP
	OPCODE	CVTPI2PS
	ENDOSP
	X128
	XM64
	EXIT

	ELBL	43		; 2B
	IFOSP
	OPCODE	MOVNTPD
	ELSEOSP
	OPCODE	MOVNTPS
	ENDOSP
	XM128
	X128
	EXIT

	ELBL	44		; 2C
	IFOSP
	OPCODE	CVTTPD2PI
	X64
	XM128
	ELSEOSP
	OPCODE	CVTTPS2PI
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	45		; 2D
	IFOSP
	OPCODE	CVTPD2PI
	X64
	XM128
	ELSEOSP
	OPCODE	CVTPS2PI
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	46		; 2E
	IFOSP
	OPCODE	UCOMISD
	X128
	XM64
	ELSEOSP
	OPCODE	UCOMISS
	X128
	XM32
	ENDOSP
	EXIT

	ELBL	47		; 2F
	IFOSP
	OPCODE	COMISD
	X128
	XM64
	ELSEOSP
	OPCODE	COMISS
	X128
	XM32
	ENDOSP
	EXIT

	ELBL	48		; 30
	OPCODE	WRMSR
	EXIT

	ELBL	49		; 31
	OPCODE	RDTSC
	EXIT

	ELBL	50		; 32
	OPCODE	RDMSR
	EXIT

	ELBL	51		; 33
	OPCODE	RDPMC
	EXIT

	ELBL	52		; 34
	OPCODE	SYSENTER
	EXIT

	ELBL	53		; 35
	OPCODE	SYSEXIT
	EXIT

	ELBL	64		; 40
	OPCODE	CMOVO
	IFOSP
	R32
	RM32
	ELSEOSP
	R16
	RM16
	ENDOSP
	EXIT

	ELBL	65		; 41
	OPCODE	CMOVNO
	IFOSP
	R32
	RM32
	ELSEOSP
	R16
	RM16
	ENDOSP
	EXIT

	ELBL	66		; 42
	OPCODE	CMOVC
	IFOSP
	R32
	RM32
	ELSEOSP
	R16
	RM16
	ENDOSP
	EXIT

	ELBL	67		; 43
	OPCODE	CMOVNC
	IFOSP
	R32
	RM32
	ELSEOSP
	R16
	RM16
	ENDOSP
	EXIT

	ELBL	68		; 44
	OPCODE	CMOVZ
	IFOSP
	R32
	RM32
	ELSEOSP
	R16
	RM16
	ENDOSP
	EXIT

	ELBL	69		; 45
	OPCODE	CMOVNZ
	IFOSP
	R32
	RM32
	ELSEOSP
	R16
	RM16
	ENDOSP
	EXIT

	ELBL	70		; 46
	OPCODE	CMOVBE
	IFOSP
	R32
	RM32
	ELSEOSP
	R16
	RM16
	ENDOSP
	EXIT

	ELBL	71		; 47
	OPCODE	CMOVA
	IFOSP
	R32
	RM32
	ELSEOSP
	R16
	RM16
	ENDOSP
	EXIT

	ELBL	72		; 48
	OPCODE	CMOVS
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	73		; 49
	OPCODE	CMOVNS
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	74		; 4A
	OPCODE	CMOVPE
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	75		; 4B
	OPCODE	CMOVPO
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	76		; 4C
	OPCODE	CMOVL
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	77		; 4D
	OPCODE	CMOVGE
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	78		; 4E
	OPCODE	CMOVLE
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	79		; 4F
	OPCODE	CMOVG
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	80		; 50
	IFMOD11
	IFOSP
	OPCODE	MOVMSKPD
	ENDOSP
	OPCODE	MOVMSKPS
	ELSEOSP
	R32
	XM128
	ELSEMOD11
	UNDEF
	ENDMOD11
	EXIT

	ELBL	81		; 51
	IFOSP
	OPCODE	SQRTPD
	ELSEOSP
	OPCODE	SQRTPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	82		; 52
	OPCODE	RSQRTPS
	X128
	XM128
	EXIT

	ELBL	83		; 53
	OPCODE	RCPPS
	X128
	XM128
	EXIT

	ELBL	84		; 54
	IFOSP
	OPCODE	ANDPD
	ELSEOSP
	OPCODE	ANDPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	85		; 55
	IFOSP
	OPCODE	ANDNPD
	ELSEOSP
	OPCODE	ANDNPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	86		; 56
	IFOSP
	OPCODE	ORPD
	ELSEOSP
	OPCODE	ORPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	87		; 57
	IFOSP
	OPCODE	XORPD
	ELSEOSP
	OPCODE	XORPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	88		; 58
	IFOSP
	OPCODE	ADDPD
	ELSEOSP
	OPCODE	ADDPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	89		; 59
	IFOSP
	OPCODE	MULPD
	ELSEOSP
	OPCODE	MULPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	90		; 5A
	IFOSP
	OPCODE	CVTPD2PS
	X128
	XM128
	ELSEOSP
	OPCODE	CVTPS2PD
	X128
	XM64
	ENDOSP
	EXIT

	ELBL	91		; 5B
	IFOSP
	OPCODE	CVTDQ2PS
	ELSEOSP
	OPCODE	CVTPS2DQ
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	92		; 5C
	IFOSP
	OPCODE	SUBPD
	ELSEOSP
	OPCODE	SUBPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	93		; 5D
	IFOSP
	OPCODE	MINPD
	ELSEOSP
	OPCODE	MINPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	94		; 5E
	IFOSP
	OPCODE	DIVPD
	ELSEOSP
	OPCODE	DIVPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	95		; 5F
	IFOSP
	OPCODE	MAXPD
	ELSEOSP
	OPCODE	MAXPS
	ENDOSP
	X128
	XM128
	EXIT

	ELBL	96		; 60
	OPCODE	PUNPCKLBW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM32
	ENDOSP
	EXIT

	ELBL	97		; 61
	OPCODE	PUNPCKLWD
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM32
	ENDOSP
	EXIT

	ELBL	98		; 62
	OPCODE	PUNPCKLDQ
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM32
	ENDOSP
	EXIT

	ELBL	99		; 63
	OPCODE	PACKSSWB
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	100		; 64
	OPCODE	PCMPGTB
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	101		; 65
	OPCODE	PCMPGTW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	102		; 66
	OPCODE	PCMPGTD
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	103		; 67
	OPCODE	PACKUSWB
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	104		; 68
	OPCODE	PUNPCKHBW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	105		; 69
	OPCODE	PUNPCKHWD
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	106		; 6A
	OPCODE	PUNPCKHDQ
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	107		; 6B
	OPCODE	PACKSSDW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	108		; 6C
	IFOSP
	OPCODE	PUNPCKLQDQ
	X128
	XM128
	ELSEOSP
	UNDEF
	ENDOSP
	EXIT

	ELBL	109		; 6D
	IFOSP
	OPCODE	PUNPCKHQDQ
	X128
	XM128
	ELSEOSP
	UNDEF
	ENDOSP
	EXIT

	ELBL	110		; 6E
	OPCODE	MOVD
	IFOSP
	X128
	ELSEOSP
	X64
	ENDOSP
	RM32
	EXIT

	ELBL	111		; 6F
	IFOSP
	OPCODE	MOVDQA
	X128
	XM128
	ELSEOSP
	OPCODE	MOVQ
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	112		; 70
	IFOSP
	OPCODE	PSHUFD
	X128
	XM128
	ELSEOSP
	OPCODE	PSHUFW
	X64
	XM64
	ENDOSP
	IMM8
	EXIT

	ELBL	113		; 71
	IFMOD11
	GRP12
	IFOSP
	X128
	ELSEOSP
	X64
	ENDOSP
	IMM8
	ELSEMOD11
	UNDEF
	ENDMOD11
	EXIT

	ELBL	114		; 72
	IFMOD11
	GRP13
	IFOSP
	X128
	ELSEOSP
	X64
	ENDOSP
	IMM8
	ELSEMOD11
	UNDEF
	ENDMOD11
	EXIT

	ELBL	115		; 73
	IFMOD11
	GRP14
	IFOSP
	X128
	ELSEOSP
	X64
	ENDOSP
	IMM8
	ELSEMOD11
	UNDEF
	ENDMOD11
	EXIT

	ELBL	116		; 74
	OPCODE	PCMPEQB
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	117		; 75
	OPCODE	PCMPEQW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	118		; 76
	OPCODE	PCMPEQD
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	119		; 77
	OPCODE	EMMS
	EXIT

	ELBL	126		; 7E
	OPCODE	MOVD
	IFOSP
	R32
	XM32
	ELSEOSP
	RM32
	X64
	ENDOSP
	EXIT

	ELBL	127		; 7F
	IFOSP
	OPCODE	MOVDQA
	XM128
	X128
	ELSEOSP
	OPCODE	MOVQ
	XM64
	X64
	ENDOSP
	EXIT

	ELBL	128		; 80
	OPCODEJCC JO
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	129		; 81
	OPCODEJCC JNO
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	130		; 82
	OPCODEJCC JC
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	131		; 83
	OPCODEJCC JNC
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	132		; 84
	OPCODEJCC JZ
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	133		; 85
	OPCODEJCC JNZ
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	134		; 86
	OPCODEJCC JBE
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	135		; 87
	OPCODEJCC JA
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	136		; 88
	OPCODEJCC JS
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	137		; 89
	OPCODEJCC JNS
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	138		; 8A
	OPCODEJCC JPE
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	139		; 8B
	OPCODEJCC JPO
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	140		; 8C
	OPCODEJCC JL
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	141		; 8D
	OPCODEJCC JGE
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	142		; 8E
	OPCODEJCC JLE
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	143		; 8F
	OPCODEJCC JG
	IFOSP
	REL32
	ELSEOSP
	REL16
	ENDOSP
	EXIT

	ELBL	144		; 90
	OPCODE	SETO
	RM8P
	EXIT

	ELBL	145		; 91
	OPCODE	SETNO
	RM8P
	EXIT

	ELBL	146		; 92
	OPCODE	SETC
	RM8P
	EXIT

	ELBL	147		; 93
	OPCODE	SETNC
	RM8P
	EXIT

	ELBL	148		; 94
	OPCODE	SETZ
	RM8P
	EXIT

	ELBL	149		; 95
	OPCODE	SETNZ
	RM8P
	EXIT

	ELBL	150		; 96
	OPCODE	SETA
	RM8P
	EXIT

	ELBL	151		; 97
	OPCODE	SETNA
	RM8P
	EXIT

	ELBL	152		; 98
	OPCODE	SETS
	RM8P
	EXIT

	ELBL	153		; 99
	OPCODE	SETNS
	RM8P
	EXIT

	ELBL	154		; 9A
	OPCODE	SETPE
	RM8P
	EXIT

	ELBL	155		; 9B
	OPCODE	SETPO
	RM8P
	EXIT

	ELBL	156		; 9C
	OPCODE	SETL
	RM8P
	EXIT

	ELBL	157		; 9D
	OPCODE	SETNL
	RM8P
	EXIT

	ELBL	158		; 9E
	OPCODE	SETG
	RM8P
	EXIT

	ELBL	159		; 9F
	OPCODE	SETNG
	RM8P
	EXIT

	ELBL	160		; A0
	IFOSP
	OPCODE	PUSHD
	ELSEOSP
	OPCODE	PUSH
	ENDOSP
	OPCODE	FS
	EXIT

	ELBL	161		; A1
	IFOSP
	OPCODE	POPD
	ELSEOSP
	OPCODE	POP
	ENDOSP
	OPCODE	FS
	STACK1	WORD
	EXIT

	ELBL	162		; A2
	OPCODE	CPUID
	EXIT

	ELBL	163		; A3
	OPCODE	BT
	IFOSP
	RM32
	R32
	ELSEOSP
	RM16
	R16
	ENDOSP
	DWIDTH	BTREG
	EXIT

	ELBL	164		; A4
	OPCODE	SHLD
	IFOSP
	RM32
	R32
	ELSEOSP
	RM16
	R16
	ENDOSP
	IMM8
	EXIT

	ELBL	165		; A5
	OPCODE	SHLD
	IFOSP
	RM32
	R32
	ELSEOSP
	RM16
	R16
	ENDOSP
	OPCODE	@CL
	EXIT

	ELBL	166		; A6
	OPCODE	XBTS
	IFOSP
	RM32
	R32
	ELSEOSP
	RM16
	R16
	ENDOSP
	EXIT

	ELBL	167		; A7
	OPCODE	IBTS
	IFOSP
	RM32
	R32
	ELSEOSP
	RM16
	R16
	ENDOSP
	EXIT

	ELBL	168		; A8
	IFOSP
	OPCODE	PUSHD
	ELSEOSP
	OPCODE	PUSH
	ENDOSP
	OPCODE	GS
	EXIT

	ELBL	169		; A9
	IFOSP
	OPCODE	POPD
	ELSEOSP
	OPCODE	POP
	ENDOSP
	OPCODE	GS
	STACK1	WORD
	EXIT

	ELBL	170		; AA -- 386 SL
	OPCODE	RSM
	EXIT

	ELBL	171		; AB
	OPCODE	BTS
	IFOSP
	RM32
	R32
	ELSEOSP
	RM16
	R16
	ENDOSP
	DWIDTH	BTREG
	EXIT

	ELBL	172		; AC
	OPCODE	SHRD
	IFOSP
	RM32
	R32
	ELSEOSP
	RM16
	R16
	ENDOSP
	IMM8
	EXIT

	ELBL	173		; AD
	OPCODE	SHRD
	IFOSP
	RM32
	R32
	ELSEOSP
	RM16
	R16
	ENDOSP
	OPCODE	@CL
	EXIT

	ELBL	174		; AE
	IFMOD11
	GRP15
	ELSEMOD11
	GRP15
	GRP15Z
	ENDMOD11
	EXIT

	ELBL	175		; AF
	OPCODE	IMUL
	IFOSP
	R32
	RM32
	ELSEOSP
	R16
	RM16
	ENDOSP
	EXIT

	ELBL	176		; B0
	OPCODE	CMPXCHG
	RM8
	R8
	EXIT

	ELBL	177		; B1
	OPCODE	CMPXCHG
	IFOSP
	RM32
	R32
	ELSEOSP
	RM16
	R16
	ENDOSP
	EXIT

	ELBL	178		; B2
	OPCODE	LSS
	IFOSP
	R32
	RM32
	DWIDTH	PTR32
	ELSEOSP
	R16
	RM16
	DWIDTH	PTR16
	ENDOSP
	EXIT

	ELBL	179		; B3
	OPCODE	BTR
	IFOSP
	RM32
	R32
	ELSEOSP
	RM16
	R16
	ENDOSP
	DWIDTH	BTREG
	EXIT

	ELBL	180		; B4
	OPCODE	LFS
	IFOSP
	R32
	RM32
	DWIDTH	PTR32
	ELSEOSP
	R16
	RM16
	DWIDTH	PTR16
	ENDOSP
	EXIT

	ELBL	181		; B5
	OPCODE	LGS
	IFOSP
	R32
	RM32
	DWIDTH	PTR32
	ELSEOSP
	R16
	RM16
	DWIDTH	PTR16
	ENDOSP
	EXIT

	ELBL	182		; B6
;;;;;;; INT03
	OPCODE	MOVZX
	IFOSP
	R32
	ELSEOSP
	R16
	ENDOSP
	RM8P
	EXIT

	ELBL	183		; B7
	OPCODE	MOVZX
	R32
	RM16P
	EXIT

	ELBL	185		; B9
	GRP10
	EXIT

	ELBL	186		; BA
	GRP8
	IFOSP
	RM32P
	ELSEOSP
	RM16P
	ENDOSP
	IMM8
	EXIT

	ELBL	187		; BB
	OPCODE	BTC
	IFOSP
	RM32
	R32
	ELSEOSP
	RM16
	R16
	ENDOSP
	DWIDTH	BTREG
	EXIT

	ELBL	188		; BC
	OPCODE	BSF
	IFOSP
	R32
	RM32
	ELSEOSP
	R16
	RM16
	ENDOSP
	EXIT

	ELBL	189		; BD
	OPCODE	BSR
	IFOSP
	R32
	RM32
	ELSEOSP
	R16
	RM16
	ENDOSP
	EXIT

	ELBL	190		; BE
	OPCODE	MOVSX
	IFOSP
	R32
	ELSEOSP
	R16
	ENDOSP
	RM8P
	EXIT

	ELBL	191		; BF
	OPCODE	MOVSX
	R32
	RM16P
	EXIT

	ELBL	192		; C0
	OPCODE	XADD
	RM8
	R8
	EXIT

	ELBL	193		; C1
	OPCODE	XADD
	IFOSP
	RM32
	R32
	ELSEOSP
	RM16
	R16
	ENDOSP
	EXIT

	ELBL	194		; C2
	IFOSP
	OPCODE	CMPPD
	ELSEOSP
	OPCODE	CMPPS
	ENDOSP
	X128
	XM128
	IMM8
	EXIT

	ELBL	195		; C3
	IFMOD11
	UNDEF
	ELSEMOD11
	OPCODE	MOVNTI
	RM32
	R32
	ENDMOD11
	EXIT

	ELBL	196		; C4
	OPCODE	PINSRW
	IFOSP
	X128
	ELSEOSP
	X64
	ENDOSP
	R32M16
	IMM8
	EXIT

	ELBL	197		; C5
	IFMOD11
	OPCODE	PEXTRW
	RM32
	IFOSP
	X128
	ELSEOSP
	X64
	ENDOSP
	IMM8
	ELSEMOD11
	UNDEF
	ENDMOD11
	EXIT

	ELBL	198		; C6
	IFOSP
	OPCODE	SHUFPD
	ELSEOSP
	OPCODE	SHUFPS
	ENDOSP
	X128
	XM128
	IMM8
	EXIT

	ELBL	199		; C7
	GRP9
	RM64
	EXIT

	ELBL	200		; C8
	OPCODE	BSWAP
	IFOSP
	OPCODE	EAX
	ELSEOSP
	OPCODE	AX
	ENDOSP
	EXIT

	ELBL	201		; C9
	OPCODE	BSWAP
	IFOSP
	OPCODE	ECX
	ELSEOSP
	OPCODE	CX
	ENDOSP
	EXIT

	ELBL	202		; CA
	OPCODE	BSWAP
	IFOSP
	OPCODE	EDX
	ELSEOSP
	OPCODE	DX
	ENDOSP
	EXIT

	ELBL	203		; CB
	OPCODE	BSWAP
	IFOSP
	OPCODE	EBX
	ELSEOSP
	OPCODE	BX
	ENDOSP
	EXIT

	ELBL	204		; CC
	OPCODE	BSWAP
	IFOSP
	OPCODE	ESP
	ELSEOSP
	OPCODE	SP
	ENDOSP
	EXIT

	ELBL	205		; CD
	OPCODE	BSWAP
	IFOSP
	OPCODE	EBP
	ELSEOSP
	OPCODE	BP
	ENDOSP
	EXIT

	ELBL	206		; CE
	OPCODE	BSWAP
	IFOSP
	OPCODE	ESI
	ELSEOSP
	OPCODE	SI
	ENDOSP
	EXIT

	ELBL	207		; CF
	OPCODE	BSWAP
	IFOSP
	OPCODE	EDI
	ELSEOSP
	OPCODE	DI
	ENDOSP
	EXIT

	ELBL	209		; D1
	OPCODE	PSRLW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	210		; D2
	OPCODE	PSRLD
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	211		; D3
	OPCODE	PSRLQ
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	212		; D4
	OPCODE	PADDQ
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	213		; D5
	OPCODE	PMULLW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	214		; D6
	IFOSP
	OPCODE	MOVQ
	XM64
	X128
	ELSEOSP
	UNDEF
	ENDOSP
	EXIT

	ELBL	215		; D7
	OPCODE	PMOVMSKB
	IFMOD11
	RM32
	IFOSP
	X128
	ELSEOSP
	X64
	ENDOSP
	ELSEMOD11
	UNDEF
	ENDMOD11
	EXIT

	ELBL	216		; D8
	OPCODE	PSUBUSB
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	217		; D9
	OPCODE	PSUBUSW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	218		; DA
	OPCODE	PMINUB
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	219		; DB
	OPCODE	PAND
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	220		; DC
	OPCODE	PADDUSB
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	221		; DD
	OPCODE	PADDUSW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	222		; DE
	OPCODE	PMAXUB
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	223		; DF
	OPCODE	PANDN
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	224		; E0
	OPCODE	PAVGB
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	225		; E1
	OPCODE	PSRAW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	226		; E2
	OPCODE	PSRAD
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	227		; E3
	OPCODE	PAVGW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	228		; E4
	OPCODE	PMULHUW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	229		; E5
	OPCODE	PMULHW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	230		; E6
	IFOSP
	OPCODE	CVTPD2DQ
	X128
	XM128
	ELSEOSP
	UNDEF
	ENDOSP
	EXIT

	ELBL	231		; E7
	IFMOD11
	UNDEF
	ELSEMOD11
	IFOSP
	OPCODE	MOVNTDQ
	XM128
	ELSEOSP
	OPCODE	MOVNTQ
	XM64
	ENDOSP
	X64
	ENDMOD11
	EXIT

	ELBL	232		; E8
	OPCODE	PSUBSB
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	233		; E9
	OPCODE	PSUBSW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	234		; EA
	OPCODE	PMINSW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	235		; EB
	OPCODE	POR
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	236		; EC
	OPCODE	PADDSB
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	237		; ED
	OPCODE	PADDSW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	238		; EE
	OPCODE	PMAXSW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	239		; EF
	OPCODE	PXOR
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	241		; F1
	OPCODE	PSLLW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	242		; F2
	OPCODE	PSLLD
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	243		; F3
	OPCODE	PSLLQ
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	244		; F4
	OPCODE	PMULLUDQ
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	245		; F5
	OPCODE	PMADDWD
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	246		; F6
	OPCODE	PSADBW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	247		; F7
	IFMOD11
	IFOSP
	OPCODE	MASKMOVDQU
	X128
	XM128
	ELSEOSP
	OPCODE	MASKMOVQ
	X64
	XM64
	ENDOSP
	ELSEMOD11
	UNDEF
	ENDMOD11
	EXIT

	ELBL	248		; F8
	OPCODE	PSUBB
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	249		; F9
	OPCODE	PSUBW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	250		; FA
	OPCODE	PSUBD
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	251		; FB
	OPCODE	PSUBQ
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	252		; FC
	OPCODE	PADDB
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	253		; FD
	OPCODE	PADDW
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	254		; FE
	OPCODE	PADDD
	IFOSP
	X128
	XM128
	ELSEOSP
	X64
	XM64
	ENDOSP
	EXIT

	ELBL	255		; FF
	OPCODE	WIN06
	EXIT


;==============================================================================
; F2 Prefix Table

	purge	ELBL
ELBL	macro	OPC

F2COD&OPC label dword

	org	F2COD_TAB+OPC*(type F2COD_TAB)
	dd	offset DGROUP:F2COD&OPC
	org	F2COD&OPC

	endm			; ELBL

	public	F2COD_TAB
F2COD_TAB dd	256 dup (offset DGROUP:P@UNDEF) ; Initially all undefined

	ELBL	16		; 10
	OPCODE	MOVSD
	X128
	XM64
	EXIT

	ELBL	17		; 11
	OPCODE	MOVSD
	XM64
	X128
	EXIT

	ELBL	42		; 2A
	OPCODE	CVTSI2SD
	X128
	RM32
	EXIT

	ELBL	44		; 2C
	OPCODE	CVTTSD2SI
	R32
	XM64
	EXIT

	ELBL	45		; 2D
	OPCODE	CVTSD2SI
	R32
	XM64
	EXIT

	ELBL	81		; 51
	OPCODE	SQRTSD
	X128
	XM64
	EXIT

	ELBL	88		; 58
	OPCODE	ADDSD
	X128
	XM64
	EXIT

	ELBL	89		; 59
	OPCODE	MULSD
	X128
	XM64
	EXIT

	ELBL	90		; 5A
	OPCODE	CVTSD2SS
	X128
	XM64
	EXIT

	ELBL	92		; 5C
	OPCODE	SUBSD
	X128
	XM64
	EXIT

	ELBL	93		; 5D
	OPCODE	MINSD
	X128
	XM64
	EXIT

	ELBL	94		; 5E
	OPCODE	DIVSD
	X128
	XM64
	EXIT

	ELBL	95		; 5F
	OPCODE	MAXSD
	X128
	XM64
	EXIT

	ELBL	112		; 70
	OPCODE	PSHUFLW
	X128
	XM128
	IMM8
	EXIT

	ELBL	194		; C2
	OPCODE	CMPSD
	X128
	XM64
	IMM8
	EXIT

	ELBL	214		; D6
	IFMOD11
	OPCODE	MOVDQ2Q
	XM64
	X128
	ELSEMOD11
	UNDEF
	ENDMOD11
	EXIT

	ELBL	230		; E6
	OPCODE	CVTTPD2DQ
	X128
	XM128
	EXIT


;==============================================================================
; F3 Prefix Table

	purge	ELBL
ELBL	macro	OPC

F3COD&OPC label dword

	org	F3COD_TAB+OPC*(type F3COD_TAB)
	dd	offset DGROUP:F3COD&OPC
	org	F3COD&OPC

	endm			; ELBL

	public	F3COD_TAB
F3COD_TAB dd	256 dup (offset DGROUP:P@UNDEF) ; Initially all undefined

	ELBL	16		; 10
	OPCODE	MOVSS
	X128
	XM32
	EXIT

	ELBL	17		; 11
	OPCODE	MOVSS
	XM32
	X128
	EXIT

	ELBL	42		; 2A
	OPCODE	CVTSI2SS
	X128
	RM32
	EXIT

	ELBL	44		; 2C
	OPCODE	CVTTSS2SI
	R32
	XM32
	EXIT

	ELBL	45		; 2D
	OPCODE	CVTSS2SI
	R32
	XM32
	EXIT

	ELBL	81		; 51
	OPCODE	SQRTSS
	X128
	XM32
	EXIT

	ELBL	82		; 52
	OPCODE	RSQRTSS
	X128
	XM32
	EXIT

	ELBL	83		; 53
	OPCODE	RCPSS
	X128
	XM128
	EXIT

	ELBL	88		; 58
	OPCODE	ADDSS
	X128
	XM32
	EXIT

	ELBL	89		; 59
	OPCODE	MULSS
	X128
	XM32
	EXIT

	ELBL	90		; 5A
	OPCODE	CVTSS2SD
	X128
	XM128
	EXIT

	ELBL	91		; 5B
	OPCODE	CVTTPS2DQ
	X128
	XM128
	EXIT

	ELBL	92		; 5C
	OPCODE	SUBSS
	X128
	XM32
	EXIT

	ELBL	93		; 5D
	OPCODE	MINSS
	X128
	XM32
	EXIT

	ELBL	94		; 5E
	OPCODE	DIVSS
	X128
	XM32
	EXIT

	ELBL	95		; 5F
	OPCODE	MAXSS
	X128
	XM32
	EXIT

	ELBL	111		; 6F
	OPCODE	MOVDQU
	X128
	XM128
	EXIT

	ELBL	112		; 70
	OPCODE	PSHUFHW
	X128
	XM128
	IMM8
	EXIT

	ELBL	126		; 7E
;;;;;;; INT03
	OPCODE	MOVQ
	X128
	XM64
	EXIT

	ELBL	127		; 7F
	OPCODE	MOVDQU
	XM128
	X128
	EXIT

	ELBL	194		; C2
	OPCODE	CMPSS
	X128
	XM32
	IMM8
	EXIT

	ELBL	214		; D6
	IFMOD11
	OPCODE	MOVQ2DQ
	X128
	XM64
	ELSEMOD11
	UNDEF
	ENDMOD11
	EXIT

	ELBL	230		; E6
	OPCODE	CVTDQ2PD
	X128
	XM64
	EXIT


ESCOD	ends			; End ESCOD segment

	MEND			; End INT1_ESC module
