;' $Header:   P:/PVCS/386SWAT/P87_TABS.ASV   1.4   01 Jul 1997 17:46:18   BOB  $
	 title	 P87_TABS -- POP87 Tables
	 page	 58,122
	 name	 P87_TABS

COMMENT |		 Module Specifications

Copyright:  (C) Copyright 1985-97 Qualitas, Inc.  All rights reserved.

Segmentation:  See SWAT_SEG.INC for details.

Program derived from:  None.

Original code by:  Bob Smith, May 1985.

Modifications by:  None.

|
.386
.xlist
	 include DOS.INC
	 include MASM.INC

	 include SWAT_SEG.INC
	 include POP87.INC
.list

PROG	 segment use32 byte public 'prog' ; Start PROG segment
	 assume  cs:PGROUP

	 extrn	 D_BIT:near
	 extrn	 D_2BIT:near
	 extrn	 D_NIB:near
	 extrn	 D_RC:near
	 extrn	 D_PC:near
	 extrn	 D_PC:near
	 extrn	 D_IC:near
	 extrn	 D_TST:near
	 extrn	 D_REM:near
	 extrn	 D_XAM:near
	 extrn	 D_TAG:near
	 extrn	 D_NUM:near
	 extrn	 D_DEC:near

PROG	 ends			; End PROG segment


DATA	 segment use32 dword public 'data' ; Start DATA segment
	 assume  ds:DGROUP

	 extrn	 CTWD:word,STWD:word,IPDD:word,OPDD:word
	 extrn	 TGW2:word,OCWD:word,OCW2:word
	 extrn	 CSWD:word
	 extrn	 DSWD:word
	 extrn	 STK0:tbyte,STK1:tbyte,STK2:tbyte,STK3:tbyte
	 extrn	 STK4:tbyte,STK5:tbyte,STK6:tbyte,STK7:tbyte

	 public  FL
FL	 equ	 type FSTR

FMAC	 macro	 NAM,T,R,C,LT,RT,UP,DN,TAB,STAB,PV,MSK,PD

	 public  F_&NAM
F_&NAM	 label	 byte

	 extrn	 R:abs,C:abs

	 db	 T		; 0 = display only,   1 = 0 to 1 only
				; 2 = 0 to F only,    3 = 8 to F only
				; 10-17 = 0 to F only (STK elenents)
	 db	 R		; Row offset from upper left corner of SCRN
	 db	 C		; Col offset from upper left corner of SCRN

if T eq 0
	 db	 0,0,0,0,0,0	; No cursor movements
else
	 db	 (F_&LT-FPSTATE)/FL   ; Next field to the left
	 db	 (F_&RT-FPSTATE)/FL   ; Next field to the right
	 db	 (F_&UP-FPSTATE)/FL   ; Next field above
	 db	 (F_&DN-FPSTATE)/FL   ; Next field below
	 db	 (F_&TAB-FPSTATE)/FL  ; Next tab field
	 db	 (F_&STAB-FPSTATE)/FL ; Prev tab field
endif

	 dd	 offset PGROUP:PD ; Pointer to display function for this field
	 dd	 offset DGROUP:PV ; Ptr to value
	 dw	 mask MSK	; Mask on value
	 db	 MSK		; Shift amount for mask
	 extrn	 PR_&NAM:dword
	 dd	 offset DGROUP:PR_&NAM ; Ptr to vector of ptrs to related fields

	 endm


	 public  FPSTATE
FPSTATE  label	 byte
;    Nam, T, Row,  Col,  Lft, Rht,Up,	Dn,  Tab, Stab,Pval, Mask, PDsp
FMAC CW0, 0, R_CW, C_CW0,*,   *,  *,	*,   *,   *,   CTWD,$NB0,  D_NIB; Control word, nibble 0
FMAC CW1, 0, R_CW, C_CW1,*,   *,  *,	*,   *,   *,   CTWD,$NB1,  D_NIB;		       1
FMAC CW2, 0, R_CW, C_CW2,*,   *,  *,	*,   *,   *,   CTWD,$NB2,  D_NIB;		       2
FMAC CW3, 0, R_CW, C_CW3,*,   *,  *,	*,   *,   *,   CTWD,$NB3,  D_NIB;		       3

	 public  F_INIT
F_INIT	 label	 tbyte
FMAC RC0, 1, R_RC, C_RC0,ST7T,RC1,ST7A, IC,  PC0, ST7A,CTWD,$RND0, D_BIT; Rounding control, bit 0
FMAC RC1, 1, R_RC, C_RC1,RC0, PC0,ST7A, IC,  PC0, ST7A,CTWD,$RND1, D_BIT;			1
FMAC @RC, 0, R_@RC,C_@RC,*,   *,  *,	*,   *,   *,   CTWD,$@RC,  D_RC ; Error summary

FMAC PC0, 1, R_PC, C_PC0,RC1, PC1,ST7A, CC0, PM,  RC0, CTWD,$PRC0, D_BIT; Precision control, bit 0
FMAC PC1, 1, R_PC, C_PC1,PC0, PM, ST7A, CC0, PM,  RC0, CTWD,$PRC1, D_BIT;			 1
FMAC @PC, 0, R_@PC,C_@PC,*,   *,  *,	*,   *,   *,   CTWD,$@PC,  D_PC ; Error summary

FMAC IEM, 0, R_IEM,C_IEM,*,   *,  *,	*,   *,   *,   CTWD,$IEM,  D_BIT; Interrupt enable mask
FMAC PM,  1, R_PM, C_PM, PC1, UM, ST7A, PE,  UM,  PC0, CTWD,$XMPRC,D_BIT; Precision mask
FMAC UM,  1, R_UM, C_UM, PM,  OM, ST7A, UE,  OM,  PM,  CTWD,$XMUNF,D_BIT; Underflow mask
FMAC OM,  1, R_OM, C_OM, UM,  ZM, ST7A, OE,  ZM,  UM,  CTWD,$XMOVF,D_BIT; Overflow mask
FMAC ZM,  1, R_ZM, C_ZM, OM,  DM, ST7A, ZE,  DM,  OM,  CTWD,$XMZDV,D_BIT; Zero-divide mask
FMAC DM,  1, R_DM, C_DM, ZM,  IM, ST7A, DE,  IM,  ZM,  CTWD,$XMDOP,D_BIT; Denormal mask
FMAC IM,  1, R_IM, C_IM, DM,  IC, ST7A, IE,  IC,  DM,  CTWD,$XMIOP,D_BIT; Invalid op mask
FMAC IC,  1, R_IC, C_IC, IM,  PE, RC1,	CS0, PE,  IM,  CTWD,$INF,  D_BIT; Infinity control
FMAC @IC, 0, R_@IC,C_@IC,*,   *,  *,	*,   *,   *,   CTWD,$@IC,  D_IC ; Infinity control
FMAC IR,  0, R_IR, C_IR, *,   *,  *,	*,   *,   *,   CTWD,$IR,   D_BIT; Interrupt request
FMAC PE,  1, R_PE, C_PE, IC,  UE, PM,	CC3, UE,  IC,  STWD,$XFPRC,D_BIT; Precision exception
FMAC UE,  1, R_UE, C_UE, PE,  OE, UM,	CC3, OE,  PE,  STWD,$XFUNF,D_BIT; Underflow exception
FMAC OE,  1, R_OE, C_OE, UE,  ZE, OM,	CC3, ZE,  UE,  STWD,$XFOVF,D_BIT; Overflow exception
FMAC ZE,  1, R_ZE, C_ZE, OE,  DE, ZM,	CC3, DE,  OE,  STWD,$XFZDV,D_BIT; Zero-divide exception
FMAC DE,  1, R_DE, C_DE, ZE,  IE, DM,	CC3, IE,  ZE,  STWD,$XFDOP,D_BIT; Denormal exception
FMAC IE,  1, R_IE, C_IE, DE,  CC0,IM,	CC3, CC0, DE,  STWD,$XFIOP,D_BIT; Invalid op exception

FMAC SW0, 0,R_SW, C_SW0, *,   *,  *,	*,   *,   *,   STWD,$NB0,  D_NIB; Status word, nibble 0
FMAC SW1, 0,R_SW, C_SW1, *,   *,  *,	*,   *,   *,   STWD,$NB1,  D_NIB;		      1
FMAC SW2, 0,R_SW, C_SW2, *,   *,  *,	*,   *,   *,   STWD,$NB2,  D_NIB;		      2
FMAC SW3, 0,R_SW, C_SW3, *,   *,  *,	*,   *,   *,   STWD,$NB3,  D_NIB;		      3

FMAC BUSY,0,R_BSY,C_BSY, *,   *,  *,	*,   *,   *,   STWD,$BUSY, D_BIT ; NDP busy

FMAC CC0, 1,R_CC, C_CC0, IE,  CC1,PC1,	OPT0,CS0, IE,  STWD,$C0,   D_BIT ; Condition code, bit 0
FMAC CC1, 1,R_CC, C_CC1, CC0, CC2,PC1,	OPT0,CS0, IE,  STWD,$C1,   D_BIT ;		       1
FMAC CC2, 1,R_CC, C_CC2, CC1, CC3,PC1,	OPT1,CS0, IE,  STWD,$C2,   D_BIT ;		       2
FMAC CC3, 1,R_CC, C_CC3, CC2, CS0,PC1,	OPT2,CS0, IE,  STWD,$C3,   D_BIT ;		       3
FMAC FTST,0,R_TST,C_TST, *,   *,  *,	*,   *,   *,   STWD,$C0,   D_TST ; FTST display
FMAC FREM,0,R_REM,C_REM, *,   *,  *,	*,   *,   *,   STWD,$C0,   D_REM ; FPREM display
FMAC FXAM,0,R_XAM,C_XAM, *,   *,  *,	*,   *,   *,   STWD,$C0,   D_XAM ; FXAM display

FMAC TOP0,0,R_TP, C_TP0, *,   *,   *,	*,   *,   *,   STWD,$ST0,  D_BIT ; Stack top, bit 0
FMAC TOP1,0,R_TP, C_TP1, *,   *,   *,	*,   *,   *,   STWD,$ST1,  D_BIT ;		  1
FMAC TOP2,0,R_TP, C_TP2, *,   *,   *,	*,   *,   *,   STWD,$ST2,  D_BIT ;		  2

FMAC CS0 ,2,R_CS, C_CS0, CC3, CS1, IC,	ST0A,IPT0,CC0, CSWD,$NB0,  D_NIB ; Instr seg, nibble 0
FMAC CS1 ,2,R_CS, C_CS1, CS0, CS2, IC,	ST0A,IPT0,CC0, CSWD,$NB1,  D_NIB ;		     1
FMAC CS2 ,2,R_CS, C_CS2, CS1, CS3, IC,	ST0A,IPT0,CC0, CSWD,$NB2,  D_NIB ;		     2
FMAC CS3 ,2,R_CS, C_CS3, CS2, IPT0,IC,	ST0A,IPT0,CC0, CSWD,$NB3,  D_NIB ;		     3

;    Nam, T, Row,  Col,  Lft, Rht,Up,	Dn,  Tab, Stab,Pval, Mask, PDsp
FMAC IPT0,2,R_IP, C_IP0, CS3, IPT1,IC,	ST0C,DS0, CS0, IPDD,$NB0,  D_NIB ; Instr off, nibble 0
FMAC IPT1,2,R_IP, C_IP1, IPT0,IPT2,IC,	ST0D,DS0, CS0, IPDD,$NB1,  D_NIB ;		     1
FMAC IPT2,2,R_IP, C_IP2, IPT1,IPT3,IC,	ST0E,DS0, CS0, IPDD,$NB2,  D_NIB ;		     2
FMAC IPT3,2,R_IP, C_IP3, IPT2,DS0, IC,	ST0E,DS0, CS0, IPDD,$NB3,  D_NIB ;		     3

FMAC DS0, 2,R_DS, C_DS0, IPT3,DS1, CC0, ST0L,OPT0,IPT0,DSWD,$NB0,  D_NIB ; Operand, nibble 0
FMAC DS1, 2,R_DS, C_DS1, DS0, DS2, CC1, ST0M,OPT0,IPT0,DSWD,$NB1,  D_NIB ;		   1
FMAC DS2, 2,R_DS, C_DS2, DS1, DS3, CC2, ST0M,OPT0,IPT0,DSWD,$NB2,  D_NIB ;		   2
FMAC DS3, 2,R_DS, C_DS3, DS2, OPT0,CC3, ST0N,OPT0,IPT0,DSWD,$NB3,  D_NIB ;		   3

FMAC OPT0,2,R_OF, C_OF0, DS3, OPT1,CC0, ST0P,OPC1,DS0, OPDD,$NB0,  D_NIB ; Operand, nibble 0
FMAC OPT1,2,R_OF, C_OF1, OPT0,OPT2,CC1, ST0Q,OPC1,DS0, OPDD,$NB1,  D_NIB ;		   1
FMAC OPT2,2,R_OF, C_OF2, OPT1,OPT3,CC2, ST0Q,OPC1,DS0, OPDD,$NB2,  D_NIB ;		   2
FMAC OPT3,2,R_OF, C_OF3, OPT2,OPC1,CC3, ST0R,OPC1,DS0, OPDD,$NB3,  D_NIB ;		   3

FMAC OPC0,0,R_OC, C_OC0, *,   *,   *,	*,   *,   *,   OCW2,$NB0,  D_NIB ; Opcode, nibble 0
FMAC OPC1,3,R_OC, C_OC1, OPT3,OPC2,PE,	ST0T,ST0A,OPT0,OCW2,$NB1,  D_NIB ;		  1
FMAC OPC2,2,R_OC, C_OC2, OPC1,OPC3,PE,	ST0T,ST0A,OPT0,OCW2,$NB2,  D_NIB ;		  2
FMAC OPC3,2,R_OC, C_OC3, OPC2,ST0A,PE,	ST0T,ST0A,OPT0,OCW2,$NB3,  D_NIB ;		  3
FMAC DC,  0,R_DC, C_DC,  *,   *,   *,	*,   *,   *,   OCWD,$OPCODE,D_DEC

	 irpc	 X,01234567
FMAC TAG&X,0,R_TG&X,C_TG&X, *,	 *,   *,   *,	*,   *,   TGW2,$T&X,   D_2BIT; Tag word, bits 0-1
FMAC @TG&X,0,R_@T&X,C_@T&X, *,	 *,   *,   *,	*,   *,   TGW2,$T&X,   D_TAG ; Tag word, bits 0-1
	 endm

;;;FMAC SP,  0,R_SP, C_SP,  *,	 *,   *,   *,	*,   *,   STWD,$TOP,  D_SP

	 irpc	 X,01234567
FMAC NM&X,0,R_NM&X,C_NM&X, *,	*,   *,   *,   *,   *,	 STK&X,$T&X, D_NUM
	 endm

;    Nam, T ,Row, Col,	Lft, Rht, Up,  Dn,  Tab, Stab,Pval,  Mask
FMAC ST0A,10,R_S0,C_S0A,OPC3,ST0B,CS3, ST1A,ST1A,OPC1,STK0+9,$NB2, D_NIB; Stack element 0, nibble 0
FMAC ST0B,10,R_S0,C_S0B,ST0A,ST0C,CS3, ST1B,ST1A,OPC1,STK0+9,$NB3, D_NIB;			  1
FMAC ST0C,10,R_S0,C_S0C,ST0B,ST0D,IPT0,ST1C,ST1A,OPC1,STK0+8,$NB2, D_NIB;			  2
FMAC ST0D,10,R_S0,C_S0D,ST0C,ST0E,IPT1,ST1D,ST1A,OPC1,STK0+8,$NB3, D_NIB;			  3

FMAC ST0E,10,R_S0,C_S0E,ST0D,ST0F,IPT3,ST1E,ST1A,OPC1,STK0+7,$NB2, D_NIB;			  4
FMAC ST0F,10,R_S0,C_S0F,ST0E,ST0G,IPT3,ST1F,ST1A,OPC1,STK0+7,$NB3, D_NIB;			  5
FMAC ST0G,10,R_S0,C_S0G,ST0F,ST0H,IPT3,ST1G,ST1A,OPC1,STK0+6,$NB2, D_NIB;			  5
FMAC ST0H,10,R_S0,C_S0H,ST0G,ST0I,IPT3,ST1H,ST1A,OPC1,STK0+6,$NB3, D_NIB;			  5

FMAC ST0I,10,R_S0,C_S0I,ST0H,ST0J,DS0, ST1I,ST1A,OPC1,STK0+5,$NB2, D_NIB;			  5
FMAC ST0J,10,R_S0,C_S0J,ST0I,ST0K,DS0, ST1J,ST1A,OPC1,STK0+5,$NB3, D_NIB;			  5
FMAC ST0K,10,R_S0,C_S0K,ST0J,ST0L,DS0, ST1K,ST1A,OPC1,STK0+4,$NB2, D_NIB;			  5
FMAC ST0L,10,R_S0,C_S0L,ST0K,ST0M,DS0, ST1L,ST1A,OPC1,STK0+4,$NB3, D_NIB;			  5

FMAC ST0M,10,R_S0,C_S0M,ST0L,ST0N,DS2, ST1M,ST1A,OPC1,STK0+3,$NB2, D_NIB;			  5
FMAC ST0N,10,R_S0,C_S0N,ST0M,ST0O,DS3, ST1N,ST1A,OPC1,STK0+3,$NB3, D_NIB;			  5
FMAC ST0O,10,R_S0,C_S0O,ST0N,ST0P,DS3, ST1O,ST1A,OPC1,STK0+2,$NB2, D_NIB;			  5
FMAC ST0P,10,R_S0,C_S0P,ST0O,ST0Q,OPT0,ST1P,ST1A,OPC1,STK0+2,$NB3, D_NIB;			  5

FMAC ST0Q,10,R_S0,C_S0Q,ST0P,ST0R,OPT2,ST1Q,ST1A,OPC1,STK0+1,$NB2, D_NIB;			  5
FMAC ST0R,10,R_S0,C_S0R,ST0Q,ST0S,OPT3,ST1R,ST1A,OPC1,STK0+1,$NB3, D_NIB;			  5
FMAC ST0S,10,R_S0,C_S0S,ST0R,ST0T,OPT3,ST1S,ST1A,OPC1,STK0+0,$NB2, D_NIB;			  5
FMAC ST0T,10,R_S0,C_S0T,ST0S,ST1A,OPC1,ST1T,ST1A,OPC1,STK0+0,$NB3, D_NIB;			  5

;    Nam, T ,Row, Col,	Lft, Rht, Up,  Dn,  Tab, Stab,Pval,  Mask
FMAC ST1A,11,R_S1,C_S1A,ST0T,ST1B,ST0A,ST2A,ST2A,ST0A,STK1+9,$NB2, D_NIB; Stack element 1, nibble 0
FMAC ST1B,11,R_S1,C_S1B,ST1A,ST1C,ST0B,ST2B,ST2A,ST0A,STK1+9,$NB3, D_NIB;			  1
FMAC ST1C,11,R_S1,C_S1C,ST1B,ST1D,ST0C,ST2C,ST2A,ST0A,STK1+8,$NB2, D_NIB;			  2
FMAC ST1D,11,R_S1,C_S1D,ST1C,ST1E,ST0D,ST2D,ST2A,ST0A,STK1+8,$NB3, D_NIB;			  3
FMAC ST1E,11,R_S1,C_S1E,ST1D,ST1F,ST0E,ST2E,ST2A,ST0A,STK1+7,$NB2, D_NIB;			  4
FMAC ST1F,11,R_S1,C_S1F,ST1E,ST1G,ST0F,ST2F,ST2A,ST0A,STK1+7,$NB3, D_NIB;			  5
FMAC ST1G,11,R_S1,C_S1G,ST1F,ST1H,ST0G,ST2G,ST2A,ST0A,STK1+6,$NB2, D_NIB;			  5
FMAC ST1H,11,R_S1,C_S1H,ST1G,ST1I,ST0H,ST2H,ST2A,ST0A,STK1+6,$NB3, D_NIB;			  5
FMAC ST1I,11,R_S1,C_S1I,ST1H,ST1J,ST0I,ST2I,ST2A,ST0A,STK1+5,$NB2, D_NIB;			  5
FMAC ST1J,11,R_S1,C_S1J,ST1I,ST1K,ST0J,ST2J,ST2A,ST0A,STK1+5,$NB3, D_NIB;			  5
FMAC ST1K,11,R_S1,C_S1K,ST1J,ST1L,ST0K,ST2K,ST2A,ST0A,STK1+4,$NB2, D_NIB;			  5
FMAC ST1L,11,R_S1,C_S1L,ST1K,ST1M,ST0L,ST2L,ST2A,ST0A,STK1+4,$NB3, D_NIB;			  5
FMAC ST1M,11,R_S1,C_S1M,ST1L,ST1N,ST0M,ST2M,ST2A,ST0A,STK1+3,$NB2, D_NIB;			  5
FMAC ST1N,11,R_S1,C_S1N,ST1M,ST1O,ST0N,ST2N,ST2A,ST0A,STK1+3,$NB3, D_NIB;			  5
FMAC ST1O,11,R_S1,C_S1O,ST1N,ST1P,ST0O,ST2O,ST2A,ST0A,STK1+2,$NB2, D_NIB;			  5
FMAC ST1P,11,R_S1,C_S1P,ST1O,ST1Q,ST0P,ST2P,ST2A,ST0A,STK1+2,$NB3, D_NIB;			  5
FMAC ST1Q,11,R_S1,C_S1Q,ST1P,ST1R,ST0Q,ST2Q,ST2A,ST0A,STK1+1,$NB2, D_NIB;			  5
FMAC ST1R,11,R_S1,C_S1R,ST1Q,ST1S,ST0R,ST2R,ST2A,ST0A,STK1+1,$NB3, D_NIB;			  5
FMAC ST1S,11,R_S1,C_S1S,ST1R,ST1T,ST0S,ST2S,ST2A,ST0A,STK1+0,$NB2, D_NIB;			  5
FMAC ST1T,11,R_S1,C_S1T,ST1S,ST2A,ST0T,ST2T,ST2A,ST0A,STK1+0,$NB3, D_NIB;			  5

;    Nam, T ,Row, Col,	Lft, Rht, Up,  Dn,  Tab, Stab,Pval,  Mask
FMAC ST2A,12,R_S2,C_S2A,ST1T,ST2B,ST1A,ST3A,ST3A,ST1A,STK2+9,$NB2, D_NIB; Stack element 2, nibble 0
FMAC ST2B,12,R_S2,C_S2B,ST2A,ST2C,ST1B,ST3B,ST3A,ST1A,STK2+9,$NB3, D_NIB;			  1
FMAC ST2C,12,R_S2,C_S2C,ST2B,ST2D,ST1C,ST3C,ST3A,ST1A,STK2+8,$NB2, D_NIB;			  2
FMAC ST2D,12,R_S2,C_S2D,ST2C,ST2E,ST1D,ST3D,ST3A,ST1A,STK2+8,$NB3, D_NIB;			  3
FMAC ST2E,12,R_S2,C_S2E,ST2D,ST2F,ST1E,ST3E,ST3A,ST1A,STK2+7,$NB2, D_NIB;			  4
FMAC ST2F,12,R_S2,C_S2F,ST2E,ST2G,ST1F,ST3F,ST3A,ST1A,STK2+7,$NB3, D_NIB;			  5
FMAC ST2G,12,R_S2,C_S2G,ST2F,ST2H,ST1G,ST3G,ST3A,ST1A,STK2+6,$NB2, D_NIB;			  5
FMAC ST2H,12,R_S2,C_S2H,ST2G,ST2I,ST1H,ST3H,ST3A,ST1A,STK2+6,$NB3, D_NIB;			  5
FMAC ST2I,12,R_S2,C_S2I,ST2H,ST2J,ST1I,ST3I,ST3A,ST1A,STK2+5,$NB2, D_NIB;			  5
FMAC ST2J,12,R_S2,C_S2J,ST2I,ST2K,ST1J,ST3J,ST3A,ST1A,STK2+5,$NB3, D_NIB;			  5
FMAC ST2K,12,R_S2,C_S2K,ST2J,ST2L,ST1K,ST3K,ST3A,ST1A,STK2+4,$NB2, D_NIB;			  5
FMAC ST2L,12,R_S2,C_S2L,ST2K,ST2M,ST1L,ST3L,ST3A,ST1A,STK2+4,$NB3, D_NIB;			  5
FMAC ST2M,12,R_S2,C_S2M,ST2L,ST2N,ST1M,ST3M,ST3A,ST1A,STK2+3,$NB2, D_NIB;			  5
FMAC ST2N,12,R_S2,C_S2N,ST2M,ST2O,ST1N,ST3N,ST3A,ST1A,STK2+3,$NB3, D_NIB;			  5
FMAC ST2O,12,R_S2,C_S2O,ST2N,ST2P,ST1O,ST3O,ST3A,ST1A,STK2+2,$NB2, D_NIB;			  5
FMAC ST2P,12,R_S2,C_S2P,ST2O,ST2Q,ST1P,ST3P,ST3A,ST1A,STK2+2,$NB3, D_NIB;			  5
FMAC ST2Q,12,R_S2,C_S2Q,ST2P,ST2R,ST1Q,ST3Q,ST3A,ST1A,STK2+1,$NB2, D_NIB;			  5
FMAC ST2R,12,R_S2,C_S2R,ST2Q,ST2S,ST1R,ST3R,ST3A,ST1A,STK2+1,$NB3, D_NIB;			  5
FMAC ST2S,12,R_S2,C_S2S,ST2R,ST2T,ST1S,ST3S,ST3A,ST1A,STK2+0,$NB2, D_NIB;			  5
FMAC ST2T,12,R_S2,C_S2T,ST2S,ST3A,ST1T,ST3T,ST3A,ST1A,STK2+0,$NB3, D_NIB;			  5

;    Nam, T ,Row, Col,	Lft, Rht, Up,  Dn,  Tab, Stab,Pval,  Mask
FMAC ST3A,13,R_S3,C_S3A,ST2T,ST3B,ST2A,ST4A,ST4A,ST2A,STK3+9,$NB2, D_NIB; Stack element 3, nibble 0
FMAC ST3B,13,R_S3,C_S3B,ST3A,ST3C,ST2B,ST4B,ST4A,ST2A,STK3+9,$NB3, D_NIB;			  1
FMAC ST3C,13,R_S3,C_S3C,ST3B,ST3D,ST2C,ST4C,ST4A,ST2A,STK3+8,$NB2, D_NIB;			  2
FMAC ST3D,13,R_S3,C_S3D,ST3C,ST3E,ST2D,ST4D,ST4A,ST2A,STK3+8,$NB3, D_NIB;			  3
FMAC ST3E,13,R_S3,C_S3E,ST3D,ST3F,ST2E,ST4E,ST4A,ST2A,STK3+7,$NB2, D_NIB;			  4
FMAC ST3F,13,R_S3,C_S3F,ST3E,ST3G,ST2F,ST4F,ST4A,ST2A,STK3+7,$NB3, D_NIB;			  5
FMAC ST3G,13,R_S3,C_S3G,ST3F,ST3H,ST2G,ST4G,ST4A,ST2A,STK3+6,$NB2, D_NIB;			  5
FMAC ST3H,13,R_S3,C_S3H,ST3G,ST3I,ST2H,ST4H,ST4A,ST2A,STK3+6,$NB3, D_NIB;			  5
FMAC ST3I,13,R_S3,C_S3I,ST3H,ST3J,ST2I,ST4I,ST4A,ST2A,STK3+5,$NB2, D_NIB;			  5
FMAC ST3J,13,R_S3,C_S3J,ST3I,ST3K,ST2J,ST4J,ST4A,ST2A,STK3+5,$NB3, D_NIB;			  5
FMAC ST3K,13,R_S3,C_S3K,ST3J,ST3L,ST2K,ST4K,ST4A,ST2A,STK3+4,$NB2, D_NIB;			  5
FMAC ST3L,13,R_S3,C_S3L,ST3K,ST3M,ST2L,ST4L,ST4A,ST2A,STK3+4,$NB3, D_NIB;			  5
FMAC ST3M,13,R_S3,C_S3M,ST3L,ST3N,ST2M,ST4M,ST4A,ST2A,STK3+3,$NB2, D_NIB;			  5
FMAC ST3N,13,R_S3,C_S3N,ST3M,ST3O,ST2N,ST4N,ST4A,ST2A,STK3+3,$NB3, D_NIB;			  5
FMAC ST3O,13,R_S3,C_S3O,ST3N,ST3P,ST2O,ST4O,ST4A,ST2A,STK3+2,$NB2, D_NIB;			  5
FMAC ST3P,13,R_S3,C_S3P,ST3O,ST3Q,ST2P,ST4P,ST4A,ST2A,STK3+2,$NB3, D_NIB;			  5
FMAC ST3Q,13,R_S3,C_S3Q,ST3P,ST3R,ST2Q,ST4Q,ST4A,ST2A,STK3+1,$NB2, D_NIB;			  5
FMAC ST3R,13,R_S3,C_S3R,ST3Q,ST3S,ST2R,ST4R,ST4A,ST2A,STK3+1,$NB3, D_NIB;			  5
FMAC ST3S,13,R_S3,C_S3S,ST3R,ST3T,ST2S,ST4S,ST4A,ST2A,STK3+0,$NB2, D_NIB;			  5
FMAC ST3T,13,R_S3,C_S3T,ST3S,ST4A,ST2T,ST4T,ST4A,ST2A,STK3+0,$NB3, D_NIB;			  5

;    Nam, T ,Row, Col,	Lft, Rht, Up,  Dn,  Tab, Stab,Pval,  Mask
FMAC ST4A,14,R_S4,C_S4A,ST3T,ST4B,ST3A,ST5A,ST5A,ST3A,STK4+9,$NB2, D_NIB; Stack element 4, nibble 0
FMAC ST4B,14,R_S4,C_S4B,ST4A,ST4C,ST3B,ST5B,ST5A,ST3A,STK4+9,$NB3, D_NIB;			  1
FMAC ST4C,14,R_S4,C_S4C,ST4B,ST4D,ST3C,ST5C,ST5A,ST3A,STK4+8,$NB2, D_NIB;			  2
FMAC ST4D,14,R_S4,C_S4D,ST4C,ST4E,ST3D,ST5D,ST5A,ST3A,STK4+8,$NB3, D_NIB;			  3
FMAC ST4E,14,R_S4,C_S4E,ST4D,ST4F,ST3E,ST5E,ST5A,ST3A,STK4+7,$NB2, D_NIB;			  4
FMAC ST4F,14,R_S4,C_S4F,ST4E,ST4G,ST3F,ST5F,ST5A,ST3A,STK4+7,$NB3, D_NIB;			  5
FMAC ST4G,14,R_S4,C_S4G,ST4F,ST4H,ST3G,ST5G,ST5A,ST3A,STK4+6,$NB2, D_NIB;			  5
FMAC ST4H,14,R_S4,C_S4H,ST4G,ST4I,ST3H,ST5H,ST5A,ST3A,STK4+6,$NB3, D_NIB;			  5
FMAC ST4I,14,R_S4,C_S4I,ST4H,ST4J,ST3I,ST5I,ST5A,ST3A,STK4+5,$NB2, D_NIB;			  5
FMAC ST4J,14,R_S4,C_S4J,ST4I,ST4K,ST3J,ST5J,ST5A,ST3A,STK4+5,$NB3, D_NIB;			  5
FMAC ST4K,14,R_S4,C_S4K,ST4J,ST4L,ST3K,ST5K,ST5A,ST3A,STK4+4,$NB2, D_NIB;			  5
FMAC ST4L,14,R_S4,C_S4L,ST4K,ST4M,ST3L,ST5L,ST5A,ST3A,STK4+4,$NB3, D_NIB;			  5
FMAC ST4M,14,R_S4,C_S4M,ST4L,ST4N,ST3M,ST5M,ST5A,ST3A,STK4+3,$NB2, D_NIB;			  5
FMAC ST4N,14,R_S4,C_S4N,ST4M,ST4O,ST3N,ST5N,ST5A,ST3A,STK4+3,$NB3, D_NIB;			  5
FMAC ST4O,14,R_S4,C_S4O,ST4N,ST4P,ST3O,ST5O,ST5A,ST3A,STK4+2,$NB2, D_NIB;			  5
FMAC ST4P,14,R_S4,C_S4P,ST4O,ST4Q,ST3P,ST5P,ST5A,ST3A,STK4+2,$NB3, D_NIB;			  5
FMAC ST4Q,14,R_S4,C_S4Q,ST4P,ST4R,ST3Q,ST5Q,ST5A,ST3A,STK4+1,$NB2, D_NIB;			  5
FMAC ST4R,14,R_S4,C_S4R,ST4Q,ST4S,ST3R,ST5R,ST5A,ST3A,STK4+1,$NB3, D_NIB;			  5
FMAC ST4S,14,R_S4,C_S4S,ST4R,ST4T,ST3S,ST5S,ST5A,ST3A,STK4+0,$NB2, D_NIB;			  5
FMAC ST4T,14,R_S4,C_S4T,ST4S,ST5A,ST3T,ST5T,ST5A,ST3A,STK4+0,$NB3, D_NIB;			  5

;    Nam, T ,Row, Col,	Lft, Rht, Up,  Dn,  Tab, Stab,Pval,  Mask
FMAC ST5A,15,R_S5,C_S5A,ST4T,ST5B,ST4A,ST6A,ST6A,ST4A,STK5+9,$NB2, D_NIB; Stack element 5, nibble 0
FMAC ST5B,15,R_S5,C_S5B,ST5A,ST5C,ST4B,ST6B,ST6A,ST4A,STK5+9,$NB3, D_NIB;			  1
FMAC ST5C,15,R_S5,C_S5C,ST5B,ST5D,ST4C,ST6C,ST6A,ST4A,STK5+8,$NB2, D_NIB;			  2
FMAC ST5D,15,R_S5,C_S5D,ST5C,ST5E,ST4D,ST6D,ST6A,ST4A,STK5+8,$NB3, D_NIB;			  3
FMAC ST5E,15,R_S5,C_S5E,ST5D,ST5F,ST4E,ST6E,ST6A,ST4A,STK5+7,$NB2, D_NIB;			  4
FMAC ST5F,15,R_S5,C_S5F,ST5E,ST5G,ST4F,ST6F,ST6A,ST4A,STK5+7,$NB3, D_NIB;			  5
FMAC ST5G,15,R_S5,C_S5G,ST5F,ST5H,ST4G,ST6G,ST6A,ST4A,STK5+6,$NB2, D_NIB;			  5
FMAC ST5H,15,R_S5,C_S5H,ST5G,ST5I,ST4H,ST6H,ST6A,ST4A,STK5+6,$NB3, D_NIB;			  5
FMAC ST5I,15,R_S5,C_S5I,ST5H,ST5J,ST4I,ST6I,ST6A,ST4A,STK5+5,$NB2, D_NIB;			  5
FMAC ST5J,15,R_S5,C_S5J,ST5I,ST5K,ST4J,ST6J,ST6A,ST4A,STK5+5,$NB3, D_NIB;			  5
FMAC ST5K,15,R_S5,C_S5K,ST5J,ST5L,ST4K,ST6K,ST6A,ST4A,STK5+4,$NB2, D_NIB;			  5
FMAC ST5L,15,R_S5,C_S5L,ST5K,ST5M,ST4L,ST6L,ST6A,ST4A,STK5+4,$NB3, D_NIB;			  5
FMAC ST5M,15,R_S5,C_S5M,ST5L,ST5N,ST4M,ST6M,ST6A,ST4A,STK5+3,$NB2, D_NIB;			  5
FMAC ST5N,15,R_S5,C_S5N,ST5M,ST5O,ST4N,ST6N,ST6A,ST4A,STK5+3,$NB3, D_NIB;			  5
FMAC ST5O,15,R_S5,C_S5O,ST5N,ST5P,ST4O,ST6O,ST6A,ST4A,STK5+2,$NB2, D_NIB;			  5
FMAC ST5P,15,R_S5,C_S5P,ST5O,ST5Q,ST4P,ST6P,ST6A,ST4A,STK5+2,$NB3, D_NIB;			  5
FMAC ST5Q,15,R_S5,C_S5Q,ST5P,ST5R,ST4Q,ST6Q,ST6A,ST4A,STK5+1,$NB2, D_NIB;			  5
FMAC ST5R,15,R_S5,C_S5R,ST5Q,ST5S,ST4R,ST6R,ST6A,ST4A,STK5+1,$NB3, D_NIB;			  5
FMAC ST5S,15,R_S5,C_S5S,ST5R,ST5T,ST4S,ST6S,ST6A,ST4A,STK5+0,$NB2, D_NIB;			  5
FMAC ST5T,15,R_S5,C_S5T,ST5S,ST6A,ST4T,ST6T,ST6A,ST4A,STK5+0,$NB3, D_NIB;			  5

;    Nam, T ,Row, Col,	Lft, Rht, Up,  Dn,  Tab, Stab,Pval,  Mask
FMAC ST6A,16,R_S6,C_S6A,ST5T,ST6B,ST5A,ST7A,ST7A,ST5A,STK6+9,$NB2, D_NIB; Stack element 6, nibble 0
FMAC ST6B,16,R_S6,C_S6B,ST6A,ST6C,ST5B,ST7B,ST7A,ST5A,STK6+9,$NB3, D_NIB;			  1
FMAC ST6C,16,R_S6,C_S6C,ST6B,ST6D,ST5C,ST7C,ST7A,ST5A,STK6+8,$NB2, D_NIB;			  2
FMAC ST6D,16,R_S6,C_S6D,ST6C,ST6E,ST5D,ST7D,ST7A,ST5A,STK6+8,$NB3, D_NIB;			  3
FMAC ST6E,16,R_S6,C_S6E,ST6D,ST6F,ST5E,ST7E,ST7A,ST5A,STK6+7,$NB2, D_NIB;			  4
FMAC ST6F,16,R_S6,C_S6F,ST6E,ST6G,ST5F,ST7F,ST7A,ST5A,STK6+7,$NB3, D_NIB;			  5
FMAC ST6G,16,R_S6,C_S6G,ST6F,ST6H,ST5G,ST7G,ST7A,ST5A,STK6+6,$NB2, D_NIB;			  5
FMAC ST6H,16,R_S6,C_S6H,ST6G,ST6I,ST5H,ST7H,ST7A,ST5A,STK6+6,$NB3, D_NIB;			  5
FMAC ST6I,16,R_S6,C_S6I,ST6H,ST6J,ST5I,ST7I,ST7A,ST5A,STK6+5,$NB2, D_NIB;			  5
FMAC ST6J,16,R_S6,C_S6J,ST6I,ST6K,ST5J,ST7J,ST7A,ST5A,STK6+5,$NB3, D_NIB;			  5
FMAC ST6K,16,R_S6,C_S6K,ST6J,ST6L,ST5K,ST7K,ST7A,ST5A,STK6+4,$NB2, D_NIB;			  5
FMAC ST6L,16,R_S6,C_S6L,ST6K,ST6M,ST5L,ST7L,ST7A,ST5A,STK6+4,$NB3, D_NIB;			  5
FMAC ST6M,16,R_S6,C_S6M,ST6L,ST6N,ST5M,ST7M,ST7A,ST5A,STK6+3,$NB2, D_NIB;			  5
FMAC ST6N,16,R_S6,C_S6N,ST6M,ST6O,ST5N,ST7N,ST7A,ST5A,STK6+3,$NB3, D_NIB;			  5
FMAC ST6O,16,R_S6,C_S6O,ST6N,ST6P,ST5O,ST7O,ST7A,ST5A,STK6+2,$NB2, D_NIB;			  5
FMAC ST6P,16,R_S6,C_S6P,ST6O,ST6Q,ST5P,ST7P,ST7A,ST5A,STK6+2,$NB3, D_NIB;			  5
FMAC ST6Q,16,R_S6,C_S6Q,ST6P,ST6R,ST5Q,ST7Q,ST7A,ST5A,STK6+1,$NB2, D_NIB;			  5
FMAC ST6R,16,R_S6,C_S6R,ST6Q,ST6S,ST5R,ST7R,ST7A,ST5A,STK6+1,$NB3, D_NIB;			  5
FMAC ST6S,16,R_S6,C_S6S,ST6R,ST6T,ST5S,ST7S,ST7A,ST5A,STK6+0,$NB2, D_NIB;			  5
FMAC ST6T,16,R_S6,C_S6T,ST6S,ST7A,ST5T,ST7T,ST7A,ST5A,STK6+0,$NB3, D_NIB;			  5

;    Nam, T ,Row, Col,	Lft, Rht, Up,  Dn,  Tab, Stab,Pval,  Mask
FMAC ST7A,17,R_S7,C_S7A,ST6T,ST7B,ST6A,RC0, RC0, ST6A,STK7+9,$NB2, D_NIB; Stack element 7, nibble 0
FMAC ST7B,17,R_S7,C_S7B,ST7A,ST7C,ST6B,RC0, RC0, ST6A,STK7+9,$NB3, D_NIB;			  1
FMAC ST7C,17,R_S7,C_S7C,ST7B,ST7D,ST6C,RC0, RC0, ST6A,STK7+8,$NB2, D_NIB;			  2
FMAC ST7D,17,R_S7,C_S7D,ST7C,ST7E,ST6D,RC0, RC0, ST6A,STK7+8,$NB3, D_NIB;			  3
FMAC ST7E,17,R_S7,C_S7E,ST7D,ST7F,ST6E,RC0, RC0, ST6A,STK7+7,$NB2, D_NIB;			  4
FMAC ST7F,17,R_S7,C_S7F,ST7E,ST7G,ST6F,RC0, RC0, ST6A,STK7+7,$NB3, D_NIB;			  5
FMAC ST7G,17,R_S7,C_S7G,ST7F,ST7H,ST6G,RC0, RC0, ST6A,STK7+6,$NB2, D_NIB;			  5
FMAC ST7H,17,R_S7,C_S7H,ST7G,ST7I,ST6H,RC0, RC0, ST6A,STK7+6,$NB3, D_NIB;			  5
FMAC ST7I,17,R_S7,C_S7I,ST7H,ST7J,ST6I,RC0, RC0, ST6A,STK7+5,$NB2, D_NIB;			  5
FMAC ST7J,17,R_S7,C_S7J,ST7I,ST7K,ST6J,RC0, RC0, ST6A,STK7+5,$NB3, D_NIB;			  5
FMAC ST7K,17,R_S7,C_S7K,ST7J,ST7L,ST6K,RC0, RC0, ST6A,STK7+4,$NB2, D_NIB;			  5
FMAC ST7L,17,R_S7,C_S7L,ST7K,ST7M,ST6L,RC0, RC0, ST6A,STK7+4,$NB3, D_NIB;			  5
FMAC ST7M,17,R_S7,C_S7M,ST7L,ST7N,ST6M,RC0, RC0, ST6A,STK7+3,$NB2, D_NIB;			  5
FMAC ST7N,17,R_S7,C_S7N,ST7M,ST7O,ST6N,RC0, RC0, ST6A,STK7+3,$NB3, D_NIB;			  5
FMAC ST7O,17,R_S7,C_S7O,ST7N,ST7P,ST6O,RC0, RC0, ST6A,STK7+2,$NB2, D_NIB;			  5
FMAC ST7P,17,R_S7,C_S7P,ST7O,ST7Q,ST6P,RC0, RC0, ST6A,STK7+2,$NB3, D_NIB;			  5
FMAC ST7Q,17,R_S7,C_S7Q,ST7P,ST7R,ST6Q,RC0, RC0, ST6A,STK7+1,$NB2, D_NIB;			  5
FMAC ST7R,17,R_S7,C_S7R,ST7Q,ST7S,ST6R,RC0, RC0, ST6A,STK7+1,$NB3, D_NIB;			  5
FMAC ST7S,17,R_S7,C_S7S,ST7R,ST7T,ST6S,RC0, RC0, ST6A,STK7+0,$NB2, D_NIB;			  5
FMAC ST7T,17,R_S7,C_S7T,ST7S,RC0, ST6T,RC0, RC0, ST6A,STK7+0,$NB3, D_NIB;			  5

	 public  NFLDS
NFLDS	 equ	 ($-FPSTATE)/FL ; # fields

DATA	 ends			; End DATA segment

	 MEND			; End P87_TABS module
