;' $Header:   P:/PVCS/386SWAT/SWAT.ASV   1.47   27 Oct 1993 15:32:58   BOB  $
	 title	 SWAT -- 386MAX Debugger
	 page	 58,122
	 name	 SWAT
	 include DIRNTRY.INC	; Include the file's directory entry

COMMENT|		Module Specifications

Copyright:  (C) Copyright 1988-93 Qualitas, Inc.  All rights reserved.

Segmentation:  Group PGROUP:
	       Stack   segment STACK,  byte-aligned,  stack,  class 'prog'
	       Program segment PROG,   byte-aligned,  public, class 'prog'
	       Group PCODEZ:
	       Program segment CODEZ,  para-aligned,  public, class 'prog'
	       Group DGROUP:
	       Data    segment DATA,   dword-aligned, public, class 'data'
	       Group WGROUP:
	       Data    segment WTAB,   word-aligned,  public, class 'wdata'
	       Data    segment WPTR,   word-aligned,  public, class 'wdata'
	       Data    segment WTXT,   byte-aligned,  public, class 'wdata'
	       Data    segment WDATAZ, dword-aligned, public, class 'wdataz'
	       Group XGROUP:
	       Program segment XCODE,  byte-aligned,  public, class 'xcode'
	       Data    segment XDATA,  dword-aligned, public, class 'xdata'
	       Data    segment XDATAZ, dword-aligned, public, class 'xdataz'
	       Group NGROUP:
	       Program segment NCODE,  para-aligned,  public, class 'ncode'
	       Group RGROUP:
	       Program segment RCODE,  para-aligned,  public, class 'rcode'
	       Data    segment RDATAZ, dword-aligned, public, class 'rcode'

Program derived from:  None.

Original code by:  Bob Smith, May, 1988.

Modifications by:  None.


|
.386p
.xlist
	 include MASM.INC
	 include 386.INC
	 include PTR.INC
	 include MASM5.MAC
	 include BITFLAGS.INC
	 include CPUFLAGS.INC
	 include LOADALL.INC
	 include KEYCODE.INC
	 include IOPBITS.INC
	 include OPCODES.INC
	 include 8255.INC
	 include 8259.INC
	 include ALLMEM.INC
	 include INTVEC.INC

	 include SWAT_AGR.INC
	 include SWAT_CMD.INC
	 include SWAT_COM.INC
	 include SWAT_DRV.INC
	 include SWAT_FMT.INC
	 include SWAT_SEG.INC
	 include SWAT_VID.INC
.list

PDTGRP	 group	 PDTSEG


PDTSEG	 segment use16 dword at 0 ; Start PDTSEG segment
	 assume  ds:PDTGRP

	 public  OFFPDT
OFFPDT	 label	 dword

PDTSEG	 ends			; End PDTSEG segment


CODEZ	 segment use16 para public 'codez' ; Start CODEZ segment
	 assume  ds:PCODEZ

	 extrn	 ZTAIL:byte

	 db	 5000h dup (0CCh) ; Filler to overcome LINKer bug
				; The constant 5000 must be greater
				; than the size of PGROUP less 64 K.

CODEZ	 ends			; End CODEZ segment


DATA	 segment use16 dword public 'data' ; Start DATA segment
	 assume  ds:DGROUP

	 extrn	 @KEY_CTL_ESC:abs

	 extrn	 UNAMODE:word
	 include SWAT_MOD.INC

	 extrn	 MEMMODE:word
	 extrn	 MEMTYPE:word
	 extrn	 @MEM_TSS:abs
	 extrn	 IOMAP_LINE:word
	 extrn	 IOMAP_LINE_MAX:word

	 extrn	 CURPOSN:word
	 extrn	 CURTYPE:word

	 extrn	 SCROFF:word
	 extrn	 MODOFF:word
	 extrn	 MEMSIZE:word
	 extrn	 ERRATTR:byte
	 extrn	 W_TMP:tbyte

	 extrn	 INSTRLEN:dword
	 extrn	 INSTRLDN:dword
	 extrn	 INSTRPDN:dword
	 extrn	 INSTROUT:byte
	 extrn	 INSTRNLN:byte
	 extrn	 UNAOFF:dword
	 extrn	 UNASEL:word
	 extrn	 UNABASE:dword
	 extrn	 UNAMASK:dword
	 extrn	 UNACR3:dword
	 extrn	 CUR_INSTR:dword
	 extrn	 CUR_INSTR_ARW:word

	 extrn	 FIRST_INSTR:dword
	 extrn	 NEXT_INSTR:dword
	 extrn	 LAST_INSTR:dword
	 extrn	 MEMMASK:dword

	 extrn	 OLDEAX:dword
	 extrn	 OLDEBX:dword
	 extrn	 OLDECX:dword
	 extrn	 OLDEDX:dword
	 extrn	 OLDESI:dword
	 extrn	 OLDEDI:dword
	 extrn	 OLDEBP:dword
	 extrn	 OLDESP:dword
	 extrn	 OLDEIP:dword
	 extrn	 OLDEFL:dword
	 extrn	 OLDCR0:dword
	 extrn	 OLDCR2:dword

	 extrn	 OLDCS:word
	 extrn	 OLDDS:word
	 extrn	 OLDES:word
	 extrn	 OLDFS:word
	 extrn	 OLDGS:word
	 extrn	 OLDSS:word

	 extrn	 CUR_VM_HANDLE:dword
	 extrn	 OLD_CUR_VM_HANDLE:dword
	 extrn	 PCUR_VM_HANDLE:dword

	 extrn	 NLSTBUF:dword
	 extrn	 PLSTBUF_IND:dword
	 extrn	 PPLSTBUF_TAB:dword
	 extrn	 PSCRBUF:dword

	 extrn	 MSGOFF:word
	 extrn	 ROMERR:byte
	 extrn	 NDPERR:byte
	 extrn	 PAGERR:byte

	 extrn	 LCLINT01_FVEC:dword,LCLINT01_ARB:byte
	 extrn	 LCLINT02_FVEC:dword,LCLINT02_ARB:byte
	 extrn	 LCLINT03_FVEC:dword,LCLINT03_ARB:byte
	 extrn	 LCLINT06_FVEC:dword,LCLINT06_ARB:byte
	 extrn	 LCLINT0D_FVEC:dword,LCLINT0D_ARB:byte
	 extrn	 LCLINT0E_FVEC:dword,LCLINT0E_ARB:byte

	 extrn	 OLDINT01_FVEC:dword,OLDINT01_ARB:byte
	 extrn	 OLDINT02_FVEC:dword,OLDINT02_ARB:byte
	 extrn	 OLDINT03_FVEC:dword,OLDINT03_ARB:byte
	 extrn	 OLDINT06_FVEC:dword,OLDINT06_ARB:byte
	 extrn	 OLDINT0D_FVEC:dword,OLDINT0D_ARB:byte
	 extrn	 OLDINT0E_FVEC:dword,OLDINT0E_ARB:byte

	 extrn	 TSSINT01_FVEC:dword,TSSINT01_ARB:byte
	 extrn	 TSSINT02_FVEC:dword,TSSINT02_ARB:byte
	 extrn	 TSSINT03_FVEC:dword,TSSINT03_ARB:byte
	 extrn	 TSSINT06_FVEC:dword,TSSINT06_ARB:byte
	 extrn	 TSSINT0D_FVEC:dword,TSSINT0D_ARB:byte
	 extrn	 TSSINT0E_FVEC:dword,TSSINT0E_ARB:byte

	 extrn	 OLDTSSINT01_FVEC:dword,OLDTSSINT01_ARB:byte
	 extrn	 OLDTSSINT02_FVEC:dword,OLDTSSINT02_ARB:byte
	 extrn	 OLDTSSINT03_FVEC:dword,OLDTSSINT03_ARB:byte
	 extrn	 OLDTSSINT06_FVEC:dword,OLDTSSINT06_ARB:byte
	 extrn	 OLDTSSINT0D_FVEC:dword,OLDTSSINT0D_ARB:byte
	 extrn	 OLDTSSINT0E_FVEC:dword,OLDTSSINT0E_ARB:byte

	 extrn	 TSSINT_FLAG:dword
	 extrn	 MEMGRAN:word
	 extrn	 SYMCOUNT:dword
	 extrn	 @NSYMROWS:abs

	 extrn	 FBROWS_NAME:byte

	 extrn	 ERRLOG_CLINE:word

	 extrn	 SELFDBG:dword

	 extrn	 LaSIGINT_BP:dword
	 extrn	 LaSIGINT_OLD:dword
	 extrn	 SIGINT_OLD:word

; The following structure *MUST* be first in DGROUP

	 public  COMMON
	 include QMAX_FIL.INC
COMMON	 FILE_STR <>		; Common data structure

	 public  SWATINFO
	 include SWAT_INF.INC
SWATINFO SWATINFO_STR <SWATINFO_LEN,		\
		       ?,			\
		       @SWATINFO_VER,		\
		       offset DGROUP:ARG_FLAG,	\
		       offset DGROUP:LCL_FLAG>
SWATINFO_LEN equ $-SWATINFO	; Length of above structure

	 public  SAVE_DR7,FORCE_DR7
	 align	 4		; Ensure dword-alignment
SAVE_DR7 dd	 ?		; Save area for DR7
FORCE_DR7 dd	 0		; Forced bits (GD, that is)

	 public  ROMSKIP_MASK,ROMSKIP_DRN,ROMSKIP_DR7
ROMSKIP_MASK dd  0		; DR7 mask used for ROM single skip (Gn,Ln bits)
ROMSKIP_DRN  dd  0		; Storage for DRn during ROMSKIP
ROMSKIP_DR7  dd  0		; Storage for DR7 during ROMSKIP (Len,R/W bits)

	 public  IRET_VEC
IRET_VEC dd	 ?		; Segment:offset of an IRET in ROM

	 public  GDTOFF,IDTOFF,LDTOFF,MEMOFF
GDTOFF	 dd	 0		; GDT offset
IDTOFF	 dd	 0		; IDT ...
LDTOFF	 dd	 0		; LDT ...
MEMOFF	 dd	 0		; Memory ...

	 public  CON4KB,CON8KB,CON32KB,CON64KB,CON1MB
CON4KB	 dd	    4*1024	; Constant  4KB
CON8KB	 dd	    8*1024	; Constant  8KB
CON32KB  dd	   32*1024	; Constant 32KB
CON64KB  dd	   64*1024	; Constant 64KB
CON1MB	 dd	 1024*1024	; Constant  1MB

	 public  BREAKPT_PTR,BREAKPT_VAL
BREAKPT_PTR dd	 -1		; Breakpoint 32-bit flat address
BREAKPT_VAL db	 ?		; ...	     value

	 DDALIGN COMMON 	; Ensure aligned on dword boundary

	 public  STACK_eSP,STACK_eBP
STACK_eSP dd	 ?		; SS:eSP linear address
STACK_eBP dd	 ?		; SS:eBP ...

	 public  PTE_START,PDE_START
PTE_START dd	 0		; Starting PTE offset for DISP_PTE
PDE_START dd	 0		; ...	   PDE ...	  DISP_PDE

	 public  SYMTAB_START
SYMTAB_START dd  0		; Starting record index into symbol table
				; This value ranges from zero to SYMCOUNT-1

	 public  LSCR_CNT
LSCR_CNT dd	 0		; Counter for last screens

	 public  ARETBASE,ARET_CNT
ARETBASE dd	 ?		; Base address of ARET_STR
ARET_CNT dw	 @ARET_CNT	; Current count of ARET entries

	 public  OLDCS_STK
OLDCS_STK dw	 0		; Old CS for stack width display

	 public  INT_FLAG
;;;;;;;; include SWAT_INT.INC
INT_FLAG dw	 0		; Interrupt flags

	 public  ARG_FLAG
	 include SWAT_ARG.INC
ARG_FLAG dw	 0		; Argument flags (defined in SWAT_ARG.INC)

	 public  AR2_FLAG
;;;;;;;; include SWAT_AR2.INC
AR2_FLAG dw	 0		; Argument flags (defined in SWAT_AR2.INC)

	 public  LCL_FLAG
	 include SWAT_LCL.INC
LCL_FLAG dw	 0		; Local flags

	 public  LC2_FLAG
	 include SWAT_LC2.INC
LC2_FLAG dw	 0		; Local flags #2

	 public  LC3_FLAG
	 include SWAT_LC3.INC
LC3_FLAG dw	 0		; Local flags #3

	 public  PS4IO
PS4IO	 dw	 ?		; Periscope 4 board I/O port

	 public  REG_EAXDS,REG_RETEIP,REG_RETCSF,REG_EIP,REG_CSF,REG_EFL
	 public  REG_ESP,REG_SSF,REG_DSF,REG_ESF,REG_FSF,REG_GSF
REG_EAXDS dq	 ?		; Save area for INT 01h caller's DS:EAX
REG_RETEIP dd	 ?		;				 Return EIP
REG_RETCSF dd	 ?		;				 ...	CS w/filler
REG_EIP  dd	 ?		;				 EIP
REG_CSF  dd	 ?		;				 CS with filler
REG_EFL  dd	 ?		;				 EFL
REG_ESP  dd	 ?		;				 ESP
REG_SSF  dd	 ?		;				 SS with filler
REG_DSF  dd	 ?		;				 DS with filler
REG_ESF  dd	 ?		;				 ES with filler
REG_FSF  dd	 ?		;				 FS with filler
REG_GSF  dd	 ?		;				 GS with filler

	 public  RETFL
RETFL	 dw	 ?		; DISPSINTR caller's flags

	 public  REENTRY
REENTRY  dw	 0		; Re-entry count

	 public  XPMSTK_FVEC
XPMSTK_FVEC df	 ?		; Save area for caller's stack pointer

	 public  LCLSTK_FVEC
LCLSTK_FVEC df	 ?		; Pointer to local stack

	 public  ERRCODE
ERRCODE  dd	 ?		; Caller's error code

	 public  ERRMSG
ERRMSG	 db	 @NCOLS dup (?) ; Save area for error message

	 public  DSP_STATE,DSP_STAT2,DSP_STAT3
DSP_STATE db	 ?		; Screen state
DSP_STAT2 db	 ?		; Secondary screen state for overlays
DSP_STAT3 db	 0		; Prior DSP_STATE value for source debugging
	 align	 2

	 public  DSP_ACT
DSP_ACT  dd	 offset PGROUP:DISP_IREGS ; Display state 0
	 dd	 offset PGROUP:DISP_GDT   ;		  1
	 dd	 offset PGROUP:DISP_IDT   ;		  2
	 dd	 offset PGROUP:DISP_LDT   ;		  3
	 dd	 offset PGROUP:DISP_TSS   ;		  4
	 dd	 offset PGROUP:DISP_PTE   ;		  5
	 dd	 offset PGROUP:DISP_PDE   ;		  6
	 dd	 offset PGROUP:DISP_MEM   ;		  7
	 dd	 offset PGROUP:DISP_DRn   ;		  8
	 dd	 offset PGROUP:DISP_SRCH  ;		  9
	 dd	 offset PGROUP:DISP_BC	  ;		 10
	 dd	 offset PGROUP:DISP_LSCR  ;		 11
	 dd	 offset PGROUP:DISP_SYMTAB ;		 12
	 dd	 offset PGROUP:DISP_FBROWS ;		 13
	 dd	 offset PGROUP:DISP_ERRLOG ;		 14

	 public  SCRUP_ACT
SCRUP_ACT dd	 offset PGROUP:SCRUP_INSTR ; Display state 0
	 dd	 offset PGROUP:SCRUP_GDT   ;		   1
	 dd	 offset PGROUP:SCRUP_IDT   ;		   2
	 dd	 offset PGROUP:SCRUP_LDT   ;		   3
	 dd	 offset PGROUP:SCRUP_TSS   ;		   4
	 dd	 offset PGROUP:SCRUP_PTE   ;		   5
	 dd	 offset PGROUP:SCRUP_PDE   ;		   6
	 dd	 offset PGROUP:SCRUP_MEM   ;		   7
	 dd	 offset PGROUP:SCRUP_DRn   ;		   8
	 dd	 offset PGROUP:SCRUP_SRCH  ;		   9
	 dd	 offset PGROUP:SCRUP_BC    ;		  10
	 dd	 offset PGROUP:SCRUP_LSCR  ;		  11
	 dd	 offset PGROUP:SCRUP_SYMTAB ;		  12
	 dd	 offset PGROUP:SCRUP_FBROWS ;		  13
	 dd	 offset PGROUP:SCRUP_ERRLOG ;		  14

	 public  SCRDN_ACT
SCRDN_ACT dd	 offset PGROUP:SCRDN_INSTR ; Display state 0
	 dd	 offset PGROUP:SCRDN_GDT   ;		   1
	 dd	 offset PGROUP:SCRDN_IDT   ;		   2
	 dd	 offset PGROUP:SCRDN_LDT   ;		   3
	 dd	 offset PGROUP:SCRDN_TSS   ;		   4
	 dd	 offset PGROUP:SCRDN_PTE   ;		   5
	 dd	 offset PGROUP:SCRDN_PDE   ;		   6
	 dd	 offset PGROUP:SCRDN_MEM   ;		   7
	 dd	 offset PGROUP:SCRDN_DRn   ;		   8
	 dd	 offset PGROUP:SCRDN_SRCH  ;		   9
	 dd	 offset PGROUP:SCRDN_BC    ;		  10
	 dd	 offset PGROUP:SCRDN_LSCR  ;		  11
	 dd	 offset PGROUP:SCRDN_SYMTAB ;		  12
	 dd	 offset PGROUP:SCRDN_FBROWS ;		  13
	 dd	 offset PGROUP:SCRDN_ERRLOG ;		  14

	 public  SCRPGUP_ACT
SCRPGUP_ACT dd	 offset PGROUP:SCRPGUP_INSTR ; Display state 0
	 dd	 offset PGROUP:SCRPGUP_GDT   ;		     1
	 dd	 offset PGROUP:SCRPGUP_IDT   ;		     2
	 dd	 offset PGROUP:SCRPGUP_LDT   ;		     3
	 dd	 offset PGROUP:SCRPGUP_TSS   ;		     4
	 dd	 offset PGROUP:SCRPGUP_PTE   ;		     5
	 dd	 offset PGROUP:SCRPGUP_PDE   ;		     6
	 dd	 offset PGROUP:SCRPGUP_MEM   ;		     7
	 dd	 offset PGROUP:SCRPGUP_DRn   ;		     8
	 dd	 offset PGROUP:SCRPGUP_SRCH  ;		     9
	 dd	 offset PGROUP:SCRPGUP_BC    ;		    10
	 dd	 offset PGROUP:SCRPGUP_LSCR  ;		    11
	 dd	 offset PGROUP:SCRPGUP_SYMTAB ; 	    12
	 dd	 offset PGROUP:SCRPGUP_FBROWS ; 	    13
	 dd	 offset PGROUP:SCRPGUP_ERRLOG ; 	    14

	 public  SCRPGDN_ACT
SCRPGDN_ACT dd	 offset PGROUP:SCRPGDN_INSTR ; Display state 0
	 dd	 offset PGROUP:SCRPGDN_GDT   ;		     1
	 dd	 offset PGROUP:SCRPGDN_IDT   ;		     2
	 dd	 offset PGROUP:SCRPGDN_LDT   ;		     3
	 dd	 offset PGROUP:SCRPGDN_TSS   ;		     4
	 dd	 offset PGROUP:SCRPGDN_PTE   ;		     5
	 dd	 offset PGROUP:SCRPGDN_PDE   ;		     6
	 dd	 offset PGROUP:SCRPGDN_MEM   ;		     7
	 dd	 offset PGROUP:SCRPGDN_DRn   ;		     8
	 dd	 offset PGROUP:SCRPGDN_SRCH  ;		     9
	 dd	 offset PGROUP:SCRPGDN_BC    ;		    10
	 dd	 offset PGROUP:SCRPGDN_LSCR  ;		    11
	 dd	 offset PGROUP:SCRPGDN_SYMTAB ; 	    12
	 dd	 offset PGROUP:SCRPGDN_FBROWS ; 	    13
	 dd	 offset PGROUP:SCRPGDN_ERRLOG ; 	    14

	 public  DECLOC_ACT
DECLOC_ACT dd	 offset PGROUP:DECLOC_INSTR ; Display state 0
	 dd	 offset PGROUP:DECLOC_GDT   ;		    1
	 dd	 offset PGROUP:DECLOC_IDT   ;		    2
	 dd	 offset PGROUP:DECLOC_LDT   ;		    3
	 dd	 offset PGROUP:DECLOC_TSS   ;		    4
	 dd	 offset PGROUP:DECLOC_PTE   ;		    5
	 dd	 offset PGROUP:DECLOC_PDE   ;		    6
	 dd	 offset PGROUP:DECLOC_MEM   ;		    7
	 dd	 offset PGROUP:DECLOC_DRn   ;		    8
	 dd	 offset PGROUP:DECLOC_SRCH  ;		    9
	 dd	 offset PGROUP:DECLOC_BC    ;		   10
	 dd	 offset PGROUP:DECLOC_LSCR  ;		   11
	 dd	 offset PGROUP:DECLOC_SYMTAB ;		   12
	 dd	 offset PGROUP:DECLOC_FBROWS ;		   13
	 dd	 offset PGROUP:DECLOC_ERRLOG ;		   14

	 public  INCLOC_ACT
INCLOC_ACT dd	 offset PGROUP:INCLOC_INSTR ; Display state 0
	 dd	 offset PGROUP:INCLOC_GDT   ;		    1
	 dd	 offset PGROUP:INCLOC_IDT   ;		    2
	 dd	 offset PGROUP:INCLOC_LDT   ;		    3
	 dd	 offset PGROUP:INCLOC_TSS   ;		    4
	 dd	 offset PGROUP:INCLOC_PTE   ;		    5
	 dd	 offset PGROUP:INCLOC_PDE   ;		    6
	 dd	 offset PGROUP:INCLOC_MEM   ;		    7
	 dd	 offset PGROUP:INCLOC_DRn   ;		    8
	 dd	 offset PGROUP:INCLOC_SRCH  ;		    9
	 dd	 offset PGROUP:INCLOC_BC    ;		   10
	 dd	 offset PGROUP:INCLOC_LSCR  ;		   11
	 dd	 offset PGROUP:INCLOC_SYMTAB ;		   12
	 dd	 offset PGROUP:INCLOC_FBROWS ;		   13
	 dd	 offset PGROUP:INCLOC_ERRLOG ;		   14

	 public  MSG_BT,MSG_BD,MSG_B0,MSG_B1,MSG_B2,MSG_B3
MSG_BT	 db	 'TSS debug trap',0
MSG_BD	 db	 'GD debug trap',0
MSG_B0	 db	 'DR0 trap',0
MSG_B1	 db	 'DR1 trap',0
MSG_B2	 db	 'DR2 trap',0
MSG_B3	 db	 'DR3 trap',0

	 public  MSG_LAST
MSG_LAST db	 'Last screen-' ; Message when displaying last screen
MSG_LAST0 db	 'xx'
MSG_LAST1 db	 'x'            ; Units digit of #
MSG_LASTLEN equ  $-MSG_LAST	; Length of message

DATA	 ends			; End DATA segment


KEYMAC	 macro	 KEY,ACT,SAV

KEYSEG	 segment use16 word public 'data' ; Start KEYSEG segment
	 assume  ds:DGROUP

	 dw	 @KEY_&KEY

KEYSEG	 ends			; End KEYSEG segment


ACTSEG	 segment use16 dword public 'data' ; Start ACTSEG segment
	 assume  ds:DGROUP

	 public  SWATTER_&ACT
	 dd	 offset PGROUP:SWATTER_&ACT

ACTSEG	 ends			; End ACTSEG segment

	 endm			; KEYMAC


KEYSEG	 segment use16 word public 'data' ; Start KEYSEG segment
	 assume  ds:DGROUP

	 public  KEYVAL
KEYVAL	 label	 word

KEYSEG	 ends			; End KEYSEG segment


ACTSEG	 segment use16 dword public 'data' ; Start ACTSEG segment
	 assume  ds:DGROUP

	 public  KEYACT
KEYACT	 label	 dword

ACTSEG	 ends			; End ACTSEG segment


	 KEYMAC  F1,		HELP	; Display help screen
	 KEYMAC  F2,		GDT	; Display GDT
	 KEYMAC  F3,		LDT	; Display LDT
	 KEYMAC  F4,		IDT	; Display IDT
	 KEYMAC  F5,		PTE	; Display PTEs
	 KEYMAC  F6,		SRCH	; Display search
	 KEYMAC  F7,		MEM	; Display memory
	 KEYMAC  F8,		TSS	; Display TSS
	 KEYMAC  F9,		REGS	; Display registers
	 KEYMAC  F10,		SCR	; Display program screen
	 KEYMAC  F11,		TRACE	; Single-step
	 KEYMAC  F12,		SKIP	; Single-skip

	 KEYMAC  SHF_F1,	AGOTO	; Push current addr, goto addr ref top
	 KEYMAC  SHF_F2,	ARET	; Return from addr
	 KEYMAC  SHF_F3,	BGOTO	; Breakpoint to top line address
;;;;;;;; KEYMAC  SHF_F4,
;;;;;;;; KEYMAC  SHF_F5,
;;;;;;;; KEYMAC  SHF_F6,
;;;;;;;; KEYMAC  SHF_F7,
;;;;;;;; KEYMAC  SHF_F8,
;;;;;;;; KEYMAC  SHF_F9,
;;;;;;;; KEYMAC  SHF_F10,
;;;;;;;; KEYMAC  SHF_F11,
;;;;;;;; KEYMAC  SHF_F12,

	 KEYMAC  ALT_F1,	I01A	; Toggle intercept of INT 01h/03h
	 KEYMAC  ALT_F2,	I02	; Toggle intercept of INT 02h
	 KEYMAC  ALT_F3,	I0D	; Toggle intercept of INT 0Dh
	 KEYMAC  ALT_F4,	I0E	; Toggle intercept of INT 0Eh
	 KEYMAC  ALT_F5,	STK	; Toggle stack display width
	 KEYMAC  ALT_F6,	SCRN	; Toggle screen save on/off
	 KEYMAC  ALT_F7,	VBASE	; Toggle video base address
	 KEYMAC  ALT_F8,	NDP	; Display NDP registers
	 KEYMAC  ALT_F9,	DRn	; Display debug registers
	 KEYMAC  ALT_F10,	LSCR	; Display last screen buffer
;;;;;;;; KEYMAC  ALT_F11,
;;;;;;;; KEYMAC  ALT_F12,

	 KEYMAC  CTL_F1,	I01	; Toggle intercept of INT 01h
	 KEYMAC  CTL_F2,	I03	; ...			  03h
	 KEYMAC  CTL_F3,	I06	; ...			  06h
;;;;;;;; KEYMAC  CTL_F4,
	 KEYMAC  CTL_F5,	PDE	; Display PDE entries
	 KEYMAC  CTL_F6,	SYMTAB	; Display symbol table
	 KEYMAC  CTL_F7,	FBROWS	; Display file browser screen
	 KEYMAC  CTL_F8,	CHAT	; Enter CHAT mode
	 KEYMAC  CTL_F9,	REMDBG	; Enter remote debugging mode
	 KEYMAC  CTL_F10,	ERRLOG	; Display error log screen
;;;;;;;  KEYMAC  CTL_F10,	LCLDBG	; Local debugging of ourselves
;;;;;;;; KEYMAC  CTL_F11,
;;;;;;;; KEYMAC  CTL_F12,

	 KEYMAC  CTL_B, 	MBYTE	; Display memory in byte format
	 KEYMAC  CTL_W, 	MWORD	; ...		    word ...
	 KEYMAC  CTL_D, 	MDWORD	; ...		    dword ...
	 KEYMAC  CTL_V, 	MVECT	; ...		    vector...
	 KEYMAC  CTL_G, 	MGDT	; ...		    GDT ...
	 KEYMAC  CTL_I, 	MIDT	; ...		    IDT ...
	 KEYMAC  CTL_T, 	MTSS	; ...		    TSS ...
	 KEYMAC  CTL_Z, 	ZAP	; Convert top instruction to NOPs

	 KEYMAC  ESC,		ESC	; Quit
	 KEYMAC  CTL_ESC,	CTLESC	; Quit and skip over INT 03h
	 KEYMAC  PADPLUS,	TRACE	; Single-step
	 KEYMAC  PADMINUS,	SKIP	; Single-skip
	 KEYMAC  PADSTAR,	BGOTO	; Breakpoint to top line address
	 KEYMAC  CTL_UP,	DECLOC	; Decrement location
	 KEYMAC  CTL_XUP,	DECLOC	; ...
	 KEYMAC  CTL_DN,	INCLOC	; Increment location
	 KEYMAC  CTL_XDN,	INCLOC	; ...
	 KEYMAC  CTL_HOME,	HOME	; Home to current instruction
	 KEYMAC  CTL_XHOME,	HOME	; Home to current instruction
	 KEYMAC  UP,		SCRUP	; Scroll screen up
	 KEYMAC  XUP,		SCRUP	; Scroll screen up
	 KEYMAC  DN,		SCRDN	; Scroll screen down
	 KEYMAC  XDN,		SCRDN	; Scroll screen down
	 KEYMAC  PGUP,		SCRPGUP ; Scroll screen page up
	 KEYMAC  XPGUP, 	SCRPGUP ; Scroll screen page up
	 KEYMAC  PGDN,		SCRPGDN ; Scroll screen page down
	 KEYMAC  XPGDN, 	SCRPGDN ; Scroll screen page down


KEYSEG	 segment use16 word public 'data' ; Start KEYSEG segment
	 assume  ds:DGROUP

	 public  NKEYVAL
NKEYVAL  equ	 ($-KEYVAL)/(type KEYVAL) ; # valid keystrokes

KEYSEG	 ends			; End KEYSEG segment


WDATAZ	 segment use16 dword public 'wdataz' ; Start WDATAZ segment
	 assume  ds:WGROUP

	 public  DTAIL
DTAIL	 label	 dword

WDATAZ	 ends			; End WDATAZ segment


XCODE	 segment use16 byte public 'xcode' ; Start XCODE segment
	 assume  cs:XGROUP

	 extrn	 INIT_VIRT:far

XCODE	 ends			; End XCODE segment


XDATAZ	 segment use16 para public 'xdataz' ; Start XDATAZ segment
	 assume  ds:XGROUP

	 extrn	 XTAIL:byte

XDATAZ	 ends			; End XDATAZ segment


NCODE	 segment use16 para public 'ncode' ; Start NCODE segment
	 assume  cs:NGROUP

	 extrn	 DEV_INTR_NR:far
	 extrn	 INIT_REAL:far

	 public  PTAIL
PTAIL	 label	 byte		; Note the PARA-alignment of this segment

NCODE	 ends			; End NCODE segment


RCODE	 segment use16 para public 'rcode' ; Start RCODE segment
	 assume  cs:RGROUP

	 extrn	 DEV_STRA:far
	 extrn	 TRP_FLAG:word

RCODE	 ends			; End RCODE segment


PROG	 segment use32 byte public 'prog' ; Start PROG segment
	 assume  cs:PGROUP,ds:PGROUP

	 public  SWATSTART
SWATSTART label  near

	 public  SWATINI
	 include MAXDEV.INC
SWATINI  MD_STR  <,			\
		  @MD_EXE or @MD_VER or @MD_USE32,\
		  '386SWAT ',           \
		  NGROUP:INIT_REAL,	\
		  offset PGROUP:INIT_PROT,\
		  offset PGROUP:REST_PROT,\
		  NGROUP:PTAIL, 	\
		  PCODEZ:ZTAIL, 	\
		  offset PGROUP:SWATTER,\
		  offset PGROUP:SAVEMSG,\
		  @IMRBASE,@IMR2BASE,	\
		  ,			\
		  @APIVER,		\
		  ,			\
		  XGROUP:INIT_VIRT,	\
		  ,			\
		  ,			\
		  ,			\
		  XGROUP:XTAIL>
L1:

; Define segment values in DDs for Seg:Off which the LINKer forgets

	 org	 SWATINI.MD_IREAL.VSEG
	 dw	 seg NGROUP		; For INIT_REAL
	 org	 SWATINI.MD_SIZE.VSEG
	 dw	 seg NGROUP		; For PTAIL
	 org	 SWATINI.MD_DATA.VSEG
	 dw	 seg PCODEZ		; For ZTAIL
	 org	 SWATINI.MD_IVIRT.VSEG
	 dw	 seg XGROUP		; For INIT_VIRT
	 org	 SWATINI.MD_VSIZE.VSEG
	 dw	 seg XGROUP		; For XTAIL

; Define DOS device driver header

	 org	 SWATINI
	 include DEVDRV.INC
	 DD_STR  <,			\
		  DRV_ATTR_CHAR,	\
		  PGROUP:LDEV_STRA-PGROUP:SWATSTART,\
		  PGROUP:LDEV_INTR-PGROUP:SWATSTART,\
		  '386SWAT$'>
	 org	 L1

	 extrn	 INIT_PROT:far
	 extrn	 REST_PROT:far
	 extrn	 SETUP:near

	 extrn	 SAVE_IRQS:near
	 extrn	 ENABLE_IRQS:near
	 extrn	 REST_IRQS:near
	 extrn	 PPI_S2K_K2S:near

;;;;;;;; extrn	 HOUSE_DOG:near
	 extrn	 IZIT286:near

	 extrn	 GETKEY:near

	 extrn	 GETBASE:near
	 extrn	 GETARW:near
	 extrn	 NEXTLINE:near

	 extrn	 DISP_IREGS:near
	 extrn	 DISP_HELP:near
	 extrn	 DISP_GDT:near
	 extrn	 DISP_IDT:near
	 extrn	 DISP_LDT:near
	 extrn	 DISP_TSS:near
	 extrn	 DISP_MEM:near
	 extrn	 DISP_DRn:near
	 extrn	 DISP_SRCH:near
	 extrn	 DISP_NDP:near
	 extrn	 DISP_STK:near
	 extrn	 DISPTXT:near
	 extrn	 DISPASCIIZ:near
	 extrn	 DISP_PTE:near
	 extrn	 DISP_PDE:near
	 extrn	 DISP_SYMTAB:near
	 extrn	 DISP_FBROWS:near
	 extrn	 DISP_ERRLOG:near
	 extrn	 DISP_MSGLINE:near
	 extrn	 DISP_BC:near

	 extrn	 DISPPHYS:near
	 extrn	 DISPVIRT:near

	 extrn	 MEMACT_B:near
	 extrn	 MEMACT_W:near
	 extrn	 MEMACT_D:near
	 extrn	 MEMACT_V:near
	 extrn	 MEMACT_G:near
	 extrn	 MEMACT_I:near
	 extrn	 MEMACT_T:near

	 extrn	 CMD_CHAR:near

	 extrn	 DISP_CMDLINE:near
	 extrn	 CLEAR_MSG:near

	 extrn	 INST_BCVAL:near
	 extrn	 CHECK_BCVAL:near
	 extrn	 REST_BCVAL:near

	 extrn	 SAVE_IMR:near
	 extrn	 REST_IMR:near

	 extrn	 SAVE_SCR:near
	 extrn	 REST_SCR:near
	 extrn	 CHECK_VMOD:near
	 extrn	 REST_VMOD:near

	 extrn	 SAVE_SCRDATA:near
	 extrn	 SET_CURPOS:near
	 extrn	 SET_CURTYP:near

	 extrn	 DISASSEMBLE:near
	 extrn	 BIN2WORD:near
	 extrn	 DD2DEC:near
	 extrn	 WPUT_CSA:near

	 extrn	 CHECKPOINT:near
	 extrn	 BLINK_LED:near
	 extrn	 FLIPVBASE:near

	 extrn	 DECODE_ADDR:near

	 extrn	 DVGASEL0:near
	 extrn	 DVGASEL1:near

	 extrn	 CHECK_PMTSS:near

	 extrn	 ADJUST_SLINE:near
	 extrn	 SYMHASH_SRCH:near

	 extrn	 CMD_CHAT:near
	 extrn	 CMD_REMDBG:near
	 extrn	 SER_INIT:near
	 extrn	 LDISPMSG:near


CHECK	 macro	 NN

	 push	 NN		;; Checkpoint #
	 call	 CHECKPOINT	;; Mark as checkpoint

	 endm			; CHECK

	 FPPROC  DEV_FNS -- Local DEV_STRA and DEV_INTR Routines
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

	 public  DEVLOAD
DEVLOAD  db	 0		; Device load flags

; We need to contruct the following JMPs by hand as the USE32
; setting of this segment produces an OSP when we don't want one.

	 public  LDEV_STRA
LDEV_STRA:
	 FIJMP	 RGROUP:DEV_STRA,<seg RGROUP>

	 public  LDEV_INTR
LDEV_INTR:
	 FIJMP	 NGROUP:DEV_INTR_NR,<seg NGROUP>

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

DEV_FNS  endp			; End DEV_FNS procedure
	 FPPROC  SAVEMSG -- Save Error Message
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Save error message address

Note that this routine returns via RETFD.

|

SAVEMSG_STR struc

	 dd	 ?		; Caller's EBP
SAVEMSG_EIP dd	 ?		; ...	   EIP
SAVEMSG_CSF dw	 ?,?		; ...	   CS with filler
SAVEMSG_VEC df	 ?		; Address of error message
	 dw	 ?		; Filler
SAVEMSG_ERR dd	 ?		; Error code

SAVEMSG_STR ends

	 push	 ebp		; Prepare to address the stack
	 mov	 ebp,esp	; Hello, Mr. Stack

	 REGSAVE <eax,esi,di,ds,es> ; Save registers

	 cld			; Ensure pointing forwards

	 lds	 esi,[ebp].SAVEMSG_VEC ; DS:SI ==> error message
	 assume  ds:nothing	; Tell the assembler about it

	 SETDATA es		; Set data selector into ES
	 assume  es:DGROUP	; Tell the assembler about it

	 lea	 di,ERRMSG	; ES:DI ==> local save area

	 mov	 al,''         ; Save leading separator
S16	 stos	 ERRMSG[di]	; Save in output area

; Copy the message to our local buffer

	 cld			; String ops forwardly
@@:
	 lods	 ds:[esi].LO	; Get the next byte
S16	 stos	 ERRMSG[di]	; Save in output area

	 and	 al,al		; Check for terminator
	 jnz	 short @B	; Jump if more to copy

	 dec	 di		; Backup to terminator

	 mov	 eax,[ebp].SAVEMSG_ERR ; Get caller's error code
	 mov	 ERRCODE,eax	; Save for later use

	 and	 ax,ax		; Izit zero?
	 jz	 short SAVEMSG1 ; Yes, so don't display it

	 push	 ax		; Save for a moment
	 mov	 ax,' :'        ; Separator
S16	 stos	 ERRMSG.ELO[di] ; Save in output area
	 pop	 ax		; Restore

	 call	 BIN2WORD	; Convert AX to hex at ES:DI
SAVEMSG1:
	 mov	 DGROUP:[di].ELO,'' ; Save trailing separator,0

	 push	 offset DGROUP:ERRMSG ; Pass offset of local buffer
	 call	 LDISPMSG	; Send to error log

	 or	 LCL_FLAG,@LCL_MSG ; Mark as received

	 REGREST <es,ds,di,esi,eax> ; Restore
	 assume  ds:nothing,es:nothing ; Tell the assembler about it

; Because the A0-step of the P5 is broken on RETFD n, we use a
; different but equivalent technique

	 push	 [ebp].SAVEMSG_CSF ; Get return CS
	 pop	 [ebp].SAVEMSG_ERR.ELO ; ...on stack

	 push	 [ebp].SAVEMSG_EIP ; Get return EIP
	 pop	 [ebp].SAVEMSG_VEC.FSEL.EDD ; ...on stack

	 pop	 ebp		; Restore

	 add	 esp,4*3	; Strip off arguments

	 retfd			; Return to 32-bit caller

;;;;;;;; retfd	 4*3		; Return to 32-bit caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

SAVEMSG  endp			; End SAVEMSG procedure
	 FPPROC  SWATTER -- SWAT Display
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Display instructions

Note that this routine returns via RETFD.

On entry:

Stack as in DI_STR

|

DI_STR	 struc

DI_RETEIP dd	 ?		; SWATTER caller's EIP
DI_RETCSF dw	 ?,?		; ...		   CS with filler
DI_EIP	 dd	 ?		; INT 01h caller's EIP
DI_CS	 dw	 ?,?		; ...		   CS with filler
DI_EFL	 dd	 ?		; ...		   EFL

; The following elements are valid only in VM86 or TSS mode,
; or if there was a ring transition to our code
; i.e., (DI_CS RPL > CPL) where CPL=0 for us

DI_ESP	 dd	 ?		; INT 01h caller's ESP
DI_SSF	 dd	 ?		; ...		   SS with filler

; The following elements are valid only in VM86 or TSS mode

DI_ESF	 dd	 ?		; ...		   ES with filler
DI_DSF	 dd	 ?		; ...		   DS with filler
DI_FSF	 dd	 ?		; ...		   FS with filler
DI_GSF	 dd	 ?		; ...		   GS with filler

DI_STR	 ends

	 REGSAVE <eax,ds>	; Save for a moment

	 pushf			; Save SWATTER caller's flags

XDI_STR  struc

	 dw	 ?		; Caller's flags
	 dd	 ?		; ...	   DS
	 dd	 ?		; ...	   EAX
XDI_LCL  db	 (size DI_STR) dup (?)

XDI_STR  ends

	 SETDATA ds		; Set data selector into DS
	 assume  ds:DGROUP	; Tell the assembler about it

; Check for trap at SWATTER_DR6 and SWATTER_DR7

	 mov	 ax,cs		; Get our code selector

	 cmp	 ax,[esp].XDI_LCL.DI_CS ; Izit us?
	 jne	 short @F	; Jump if not

	 cmp	 [esp].XDI_LCL.DI_EIP,offset PGROUP:SWATTER_DR6 ; Izit DR6?
	 je	 short SWATTER_CONT ; Jump if so (continue on)

	 cmp	 [esp].XDI_LCL.DI_EIP,offset PGROUP:SWATTER_DR7 ; Izit DR7?
	 je	 short SWATTER_CONT ; Jump if so (continue on)
@@:

; Check for BC trace in effect

	 test	 LC2_FLAG,mask $LC2_BCT ; Is BC trace in effect?
	 jz	 short SWATTER_XBCT ; Jump if not

; Ensure we're coming from single-step

SWATTER_DR6:
	 mov	 eax,dr6	; Get debug status register

	 btr	 eax,$BS	; Test and reset the bit
	 jnc	 short SWATTER_XBCT ; Jump if not single-step

	 and	 LC2_FLAG,not (mask $LC2_BCT) ; Not any more

; Install any previous breakpoint values

	 push	 gs		; Save for a moment

	 mov	 gs,COMMON.FILE_4GB ; Address all of memory
	 assume  gs:AGROUP	; Tell the assembler about it

	 call	 INST_BCVAL	; Install code breakpoints (INT 03)

	 pop	 gs		; Restore
	 assume  gs:nothing	; Tell the assembler about it
SWATTER_CONT:

; Clear the debug status register for next time

	 xor	 eax,eax	; A convenient zero
	 mov	 dr6,eax	; Clear it

; Stop single-stepping

	 and	 [esp].XDI_LCL.DI_EFL.ELO,not (mask $TF) ; Clear the trap flag

	 popf			; Restore

	 stc			; Tell caller to stop single-stepping

	 REGREST <ds,eax>	; Restore
	 assume  ds:nothing	; Tell the assembler about it

	 retfd			; Return to 32-bit caller

SWATTER_XBCT:
	 assume  ds:DGROUP	; Tell the assembler about it

; Check for SIGINT in effect

	 btr	 LC3_FLAG,$LC3_SIGINT ; Izit in effect?
	 jnc	 short @F	; Jump if not

	 REGSAVE <ax,esi,gs>	; Save for a moment

	 mov	 esi,LaSIGINT_OLD ; Get linear address of word to restore
	 mov	 ax,SIGINT_OLD	; Get the word to restore

	 mov	 gs,COMMON.FILE_4GB ; Address all of memory
	 assume  gs:AGROUP	; Tell the assembler about it

	 mov	 AGROUP:[esi],ax ; Restore the value

	 REGREST <gs,esi,ax>	; Restore
	 assume  gs:nothing	; Tell the assembler about it
@@:

; Disable Periscope 4 board if present

	 test	 LC2_FLAG,mask $LC2_PS4 ; Is Periscope 4 board present?
	 jz	 short @F	; Jump if not

	 push	 dx		; Save for a moment

	 mov	 dx,PS4IO	; Get the I/O port #
	 mov	 al,0DBh	; Get stop flag
	 out	 dx,al		; Tell it stop capturing trace info

	 pop	 dx		; Restore
@@:
SWATTER_DR7:
	 mov	 eax,dr7	; Get debug control register
	 or	 eax,FORCE_DR7	; Include any forced bits
	 mov	 SAVE_DR7,eax	; Save for later use
	 xor	 eax,eax	; Clear the bits
	 mov	 dr7,eax	; Disable all triggers

	 pop	 RETFL		; ...for a moment

	 REGREST <REG_EAXDS.EDQHI,REG_EAXDS.EDQLO> ; Save to restore later

; Switch to local stack unless we're re-entering

	 cld			; String ops forwardly

; Increment the re-entry count

	 inc	 REENTRY	; Bump the counter

	 cmp	 REENTRY,1	; Check re-entry level
	 jne	 near ptr SWATTER_XSTK1 ; Jump if we're re-entering

	 mov	 LCLSTK_FVEC.FSEL,ds ; Save as LCL stack selector

COMMENT|

Setup EAX for state testing

If the caller came from VM86 mode or we're using our own TSSs
or there was a ring transition, the values in DI_ESP and DI_SSF are valid.

If the caller came from VM86 mode or we're using our own TSSs
the values in DI_ESF, DI_DSF, DI_FSF, and DI_GSF are also valid.

Because VM86 and TSS mode have the same stack frame, we set the
$VM bit in EAX if we're in TSS mode and test $VM only thereafter.

Because no other bits in EAX are of interest, if the caller came
from PM, we load the caller's CS into AX so we can test its RPL via $PL.
If the caller came from VM86 mode, we zero the RPL bits

|

@VMTSS	 equ	 ((mask $VM) shl 16) ; Mask for VM86 or TSS mode
@VMTSSRT equ	 (@VMTSS or (mask $PL)) ; Mark for VM86 or TSS mode or RPL > 0

	 mov	 eax,[esp].DI_EFL ; Get caller's VM bit into $VM
	 xor	 ax,ax		; In case we're coming from VM86 mode

	 test	 eax,@VMTSS	; Izit VM86 mode?
	 jnz	 short @F	; Jump if so

	 mov	 ax,[esp].DI_CS ; Get caller's RPL into $PL

	 test	 LC2_FLAG,@LC2_TSS ; Izit TSS mode?
	 jz	 short @F	; Jump if not

	 or	 eax,@VMTSS	; Mark as TSS mode
@@:

; Save to restore later

	 pop	 REG_RETEIP	; Caller's EIP
	 pop	 REG_RETCSF	; Caller's CSF
	 pop	 REG_EIP	; INT 01 caller's EIP
	 pop	 REG_CSF	; INT 01 caller's CSF
	 pop	 REG_EFL	; INT 01 caller's EFLAGS

; If we're in VM86 or TSS mode, or there was a ring transition,
; pop the stack selector and offset

	 test	 eax,@VMTSSRT	; Izit VM86 or TSS mode or RPL > 0?
	 jz	 short SWATTER_PM1B ; Jump if not

	 pop	 REG_ESP	; Save to restore later
	 pop	 REG_SSF

; If not in VM86 or TSS mode, skip selector register POPs

	 test	 eax,@VMTSS	; Izit VM86 or TSS mode?
	 jz	 short SWATTER_PM1A ; Jump if not (must be ring transition)

	 pop	 REG_ESF	; Save to restore later
	 pop	 REG_DSF
	 pop	 REG_FSF
	 pop	 REG_GSF

	 mov	 XPMSTK_FVEC.FOFF,esp ; Save caller's stack pointer
	 mov	 XPMSTK_FVEC.FSEL,ss

	 jmp	 short SWATTER_PM1C ; Join common code

; We came through a ring transition and must save our caller's SS:ESP
; to restore later

SWATTER_PM1A:
	 mov	 XPMSTK_FVEC.FOFF,esp ; Save caller's stack pointer
	 mov	 XPMSTK_FVEC.FSEL,ss

; We came from PM or through a ring transition (also PM)

SWATTER_PM1B:
	 push	 REG_EAXDS.EDQHI ; Get caller's DS
	 pop	 REG_DSF	; Save for later use
	 mov	 REG_ESF.ELO,es ; ...
	 mov	 REG_FSF.ELO,fs ; ...
	 mov	 REG_GSF.ELO,gs ; ...

; If we came from PM (but not a ring transition), save caller's SS|ESP

	 test	 eax,@VMTSSRT	; Izit VM86 or TSS mode or RPL > 0?
	 jnz	 short SWATTER_PM1C ; Jump if so

	 mov	 REG_SSF.ELO,ss ; ...
	 mov	 REG_ESP,esp	; ...
SWATTER_PM1C:
	 lss	 esp,LCLSTK_FVEC ; Switch to our own stack
	 assume  ss:nothing	; Tell the assembler about it

	 push	 REG_GSF	; Put onto our own stack
	 push	 REG_FSF
	 push	 REG_DSF
	 push	 REG_ESF
	 push	 REG_SSF
	 push	 REG_ESP
	 push	 REG_EFL	; Put onto our own stack
	 push	 REG_CSF
	 push	 REG_EIP
	 push	 REG_RETCSF
	 push	 REG_RETEIP

; Restore caller's registers

SWATTER_XSTK1:
	 lds	 eax,REG_EAXDS.EDF ; Restore 'em
	 assume  ds:nothing	; Tell the assembler about it

; Save caller's EGP registers

	 pushad 		; Save all EGP registers
	 mov	 ebp,esp	; Hello, Mr. Stack

	 sub	 esp,@BPBACK	; Make room for structure

	 REGSAVE <ds,es,fs,gs>	; Save segment registers

ESP_STR  struc

ESP_GS	 dw	 ?,?		; Caller's GS w/filler
ESP_FS	 dw	 ?,?		; ...	   FS ...
ESP_ES	 dw	 ?,?		; ...	   ES ...
ESP_DS	 dw	 ?,?		; ...	   DS ...

ESP_STR  ends

; Don't push anything else onto the stack until this
; structure has been fully used -- it is addressed via [esp].

; Ensure the above selectors are valid; if not, zero them

VERR_MAC macro	 SREG

	 verr	 [esp].&SREG	; Check selector
	 jmp	 short $+2	; Jump in case bad selector
	 jz	 short @F	; Jump if accessible

	 mov	 [esp].&SREG,0	; Zero the selector
@@:
	 endm			; VERR_MAC

	 VERR_MAC ESP_DS	; Check DS selector
	 VERR_MAC ESP_ES	; ...	ES
	 VERR_MAC ESP_FS	; ...	FS
	 VERR_MAC ESP_GS	; ...	GS
;;;SWATTER_XPM:
	 SETDATA ds		; Set data selector into DS
	 assume  ds:DGROUP	; Tell the assembler about it

	 push	 ds		; Get data selector
	 pop	 es		; Address it
	 assume  es:DGROUP	; Tell the assembler about it

	 xor	 ax,ax		; A convenient zero
	 mov	 fs,ax		; Ensure it's valid
	 assume  fs:nothing	; Tell the assembler about it

	 mov	 gs,COMMON.FILE_4GB ; Address all of memory
	 assume  gs:AGROUP	; Tell the assembler about it

; Restore DR6 and DR7 if called from single-skipping through ROM

	 cmp	 ROMSKIP_MASK,0 ; Might we be coming from ROM single skip?
	 je	 near ptr NOT_ROMSKIP ; Jump if not

; Restore DR7 (turn off the Gn and Ln bits)

	 mov	 eax,ROMSKIP_MASK ; Get DR7 bit mask
	 not	 eax		; Negate to turn off bits
	 and	 SAVE_DR7,eax	; Turn off Debug Control Register bits

; Restore DR7 (replace orig Len and R/W bits for DRn)

	 mov	 eax,ROMSKIP_DR7 ; Get original Len and R/W bits for DRn
	 or	 SAVE_DR7,eax	; ... and store back in DR7

; Restore original DRn linear address

	 mov	 eax,ROMSKIP_DRN ; Get original linear address

	 test	 ROMSKIP_MASK,(mask $G0) or (mask $L0) ; Did we use DR0?
	 jnz	 short REST_DR0 ; Jump if so

	 test	 ROMSKIP_MASK,(mask $G1) or (mask $L1) ; Did we use DR1?
	 jnz	 short REST_DR1 ; Jump if so

	 test	 ROMSKIP_MASK,(mask $G2) or (mask $L2) ; Did we use DR2?
	 jnz	 short REST_DR2 ; Jump if so

REST_DR3:
	 mov	 dr3,eax	; Restore DR3 linear address
	 mov	 ebx,mask $B3	; Set BD bit for comparision

	 jmp	 short REST_DRN ; Join common code

REST_DR2:
	 mov	 dr2,eax	; Restore DR2 linear address
	 mov	 ebx,mask $B2	; Set BD bit for comparision

	 jmp	 short REST_DRN ; Join common code

REST_DR1:
	 mov	 dr1,eax	; Restore DR1 linear address
	 mov	 ebx,mask $B1	; Set BD bit for comparision

	 jmp	 short REST_DRN ; Join common code

REST_DR0:
	 mov	 dr0,eax	; Restore DR0 linear address
	 mov	 ebx,mask $B0	; Set BD bit for comparision

;;;;;;;; jmp	 short REST_DRN ; Join common code

REST_DRN:

; Reset our ROM single skip mask

	 mov	 ROMSKIP_MASK,0 ; Zero our mask

; If the reason we entered SWAT matched the current DR6 bits, clear 'em

	 mov	 eax,dr6	; Get current Debug Status Register

	 test	 eax,ebx	; Is ROMSKIP the reason for entering SWAT?
	 jz	 short NOT_ROMSKIP ; Jump if not

; Restore DR6 - called via ROM single-skip

	 not	 ebx		; Complement to clear
	 and	 eax,ebx	; Clear the specific reason bit
	 mov	 dr6,eax	; Store back in Debug Status Register

NOT_ROMSKIP:

; Save message if called from debug register

	 test	 LCL_FLAG,@LCL_MSG ; Message already received?
	 jnz	 near ptr SWATTER_XMSG ; Jump if so

	 mov	 eax,dr6	; Get debug status register

	 lea	 ebx,MSG_BT	; DS:EBX ==> message to display

	 test	 LC2_FLAG,mask $LC2_TDB ; Izit to be cleared?
	 jnz	 short @F	; Jump if so

	 test	 eax,mask $BT	; Izit TSS trap?
	 jnz	 short SWATTER_MSGCOM1 ; Yes, join common message code
@@:
	 lea	 ebx,MSG_BD	; DS:EBX ==> message to display

	 test	 eax,mask $BD	; Izit GD trap?
	 jnz	 short SWATTER_MSGCOM1 ; Yes, join common message code

	 lea	 ebx,MSG_B3	; DS:EBX ==> message to display
	 mov	 ecx,(mask $G3) or (mask $L3) ; Save for false BD disable

	 test	 eax,mask $B3	; Izit DR3 trap?
	 jnz	 short SWATTER_MSGCOM ; Yes, join common message code

	 lea	 ebx,MSG_B2	; DS:EBX ==> message to display
	 mov	 ecx,(mask $G2) or (mask $L2) ; Save for false BD disable

	 test	 eax,mask $B2	; Izit DR2 trap?
	 jnz	 short SWATTER_MSGCOM ; Yes, join common message code

	 lea	 ebx,MSG_B1	; DS:EBX ==> message to display
	 mov	 ecx,(mask $G1) or (mask $L1) ; Save for false BD disable

	 test	 eax,mask $B1	; Izit DR1 trap?
	 jnz	 short SWATTER_MSGCOM ; Yes, join common message code

	 lea	 ebx,MSG_B0	; DS:EBX ==> message to display
	 mov	 ecx,(mask $G0) or (mask $L0) ; Save for false BD disable

	 test	 eax,mask $B0	; Izit DR0 trap?
	 jz	 short SWATTER_XMSG ; No, join common code
SWATTER_MSGCOM:
	 test	 SAVE_DR7,ecx	; Izit actually enabled?
	 jz	 short SWATTER_XMSG ; Jump if not
SWATTER_MSGCOM1:
	 PUSHD	 0		; Pass pseudo-error code
	 PUSHD	 ds		; Pass message selector
	 push	 ebx		; Pass message offset
	 FCALLD  SAVEMSG	; Call message save routine
SWATTER_XMSG:

; Ensure the IMR is saved

	 call	 SAVE_IMR	; Save it

; Ensure the keyboard and timer are installed and enabled

	 cmp	 REENTRY,1	; Check re-entry level
	 jne	 short @F	; Jump if we're re-entering

	 call	 SAVE_IRQS	; Save original IRQ-specific interrupt handlers,
				; install ours
@@:
	 call	 ENABLE_IRQS	; Enable the IRQs we need

; If we're on an MCA machine, disable the watchdog timer
; to avoid spurious keyboard lockups????
;;;;;;;;
;;;;;;;; test	 SWATINI.MD_ATTR,@MD_MCA ; Izit an MCA-compatible?
;;;;;;;; jz	 short @F	; Not this time
;;;;;;;;
;;;;;;;; call	 HOUSE_DOG	; Disable watchdog timer
;;;@@:

COMMENT|

If we come up without displaying a message (typically on a single-step
or single-skip), don't enable the keyboard as it should already be
enabled.  Moreover, we need to limit the occasions where we do
re-enable the keyboard because some 8042s don't take kindly to being
kicked in the pants and they stop auto-repeating in protest.

Note that messages such as "DRn trap" will cause us to continue to
give the keyboard a kick in the pants and consequently we might stop
autorepeating.

|

	 test	 LCL_FLAG,@LCL_MSG ; Message already received?
	 jz	 short @F	; Jump if not

; Give the keyboard a kick in the pants in case it's disabled

	 test	 SWATINI.MD_ATTR,@MD_XT ; Running on an XT?
	 jnz	 short @F	; Yes, don't bother

	 mov	 ah,@S2K_ENABLE ; Enable command
	 call	 PPI_S2K_K2S	; Send command AH to keyboard, response in AL
				; Ignore response
@@:

; Switch to DVGA screen if specified

	 test	 ARG_FLAG,@ARG_DVGA ; Izit present?
	 jz	 short @F	; Jump if not

	 call	 DVGASEL1	; Select DVGA section 1
@@:

; Save the screen data values

	 call	 SAVE_SCRDATA	; Save screen data

; Set video mode if not in text mode

	 call	 CHECK_VMOD	; Check it out

	 test	 LCL_FLAG,@LCL_SCRN ; Screen restore disabled?
	 jnz	 short @F	; Yes, so don't save it

	 push	 PSCRBUF	; Pass address of screen buffer
	 PUSHD	 1		; Use actual screen
	 call	 SAVE_SCR	; Save all screen text
@@:

; Set new cursor position and type

	 push	 CURPOSN	; Get new cursor position
	 call	 SET_CURPOS	; Set it

	 push	 CURTYPE	; Get new cursor type
	 call	 SET_CURTYP	; Set it

; Save GDTR

	 SGDTD	 [ebp-@BPBACK].BACK_GDT ; Save GDTR

; Save IDTR

	 SIDTD	 [ebp-@BPBACK].BACK_IDT ; Save IDTR

; Save TR

	 str	 ax		; Get current task register

	 test	 LC2_FLAG,@LC2_TSS ; Izit TSS mode?
	 jz	 short @F	; Jump if not

; Get back link from our own TSS

	 push	 ax		; Pass selector as argument
	 call	 GETBASE	; Return with EAX = selector base

	 mov	 ax,AGROUP:[eax].TSS_LINK ; Get our back link
@@:
	 mov	 [ebp-@BPBACK].BACK_TR.DTR_LIM,ax ; Save the value

	 push	 ax		; Pass as argument
	 call	 GETBASE	; Return with EAX = selector base
;;;;;;;; jc	 ???		; Ignore error return
	 mov	 [ebp-@BPBACK].BACK_TR.DTR_BASE,eax ; Save the base address

	 btr	 LC2_FLAG,$LC2_TDB ; Izit to be cleared?
	 jnc	 short @F	; Jump if not

	 btr	 AGROUP:[eax].TSS_DBG,0 ; Clear the debug bit
@@:

; Save LDTR

	 sldt	 ax		; Get current LDT selector

	 test	 LC2_FLAG,@LC2_TSS ; Izit TSS mode?
	 jz	 short SWATTER_XTSS1 ; Jump if not

	 mov	 eax,[ebp-@BPBACK].BACK_TR.DTR_BASE ; Get the task's base address

; Split cases sepending upon 286 vs. 386 TSS

	 push	 ds		; Save for a moment

	 mov	 ds,COMMON.FILE_4GB ; Address all of memory
	 assume  ds:AGROUP	; Tell the assembler about it

	 push	 [ebp-@BPBACK].BACK_TR.DTR_LIM ; Pass the caller's TSS selector
	 call	 IZIT286	; Izit a 286 TSS?
	 pop	 ds		; Restore
	 assume  ds:DGROUP	; Tell the assembler about it
	 jc	 short @F	; Jump if so

	 mov	 ax,AGROUP:[eax].TSS_LDT ; Get the caller's LDTR from 386 TSS

	 jmp	 short SWATTER_XTSS1 ; Join common code

@@:
	 mov	 ax,AGROUP:[eax].TSS2_LDT ; Get the caller's LDTR from 286 TSS
SWATTER_XTSS1:
	 mov	 [ebp-@BPBACK].BACK_LDT.DTR_LIM,ax ; Save selector
	 mov	 [ebp].FORW_LDT,ax ; Save for non-SWATTER calls to GETBASE

	 push	 ax		; Pass as argument
	 call	 GETBASE	; Return with EAX = selector base
;;;;;;;; jc	 ???		; Ignore error return
	 mov	 [ebp-@BPBACK].BACK_LDT.DTR_BASE,eax ; Save the base address

; SETUP may depend upon the LDT base, so don't move it up any earlier

	 call	 SETUP		; Call setup code

 ; Save all segment registers

	 movzx	 eax,[ebp].FORW_CS
	 mov	 [ebp-@BPBACK].BACK_CS.DTR_LIM,ax

	 test	 [ebp].FORW_EFL.EHI,mask $VM ; Izit VM 8086 mode?
	 jz	 short SWATTER_PM2 ; Not this time

; Save VM 8086 Mode segment registers from FORW_STR

	 shl	 eax,4-0	; Convert from paras to bytes
	 mov	 [ebp-@BPBACK].BACK_CS.DTR_BASE,eax

	 movzx	 eax,[ebp].FORW_DS
	 mov	 [ebp-@BPBACK].BACK_DS.DTR_LIM,ax
	 shl	 eax,4-0	; Convert from paras to bytes
	 mov	 [ebp-@BPBACK].BACK_DS.DTR_BASE,eax

	 movzx	 eax,[ebp].FORW_ES
	 mov	 [ebp-@BPBACK].BACK_ES.DTR_LIM,ax
	 shl	 eax,4-0	; Convert from paras to bytes
	 mov	 [ebp-@BPBACK].BACK_ES.DTR_BASE,eax

	 movzx	 eax,[ebp].FORW_FS
	 mov	 [ebp-@BPBACK].BACK_FS.DTR_LIM,ax
	 shl	 eax,4-0	; Convert from paras to bytes
	 mov	 [ebp-@BPBACK].BACK_FS.DTR_BASE,eax

	 movzx	 eax,[ebp].FORW_GS
	 mov	 [ebp-@BPBACK].BACK_GS.DTR_LIM,ax
	 shl	 eax,4-0	; Convert from paras to bytes
	 mov	 [ebp-@BPBACK].BACK_GS.DTR_BASE,eax

	 movzx	 eax,[ebp].FORW_SS
	 mov	 [ebp-@BPBACK].BACK_SS.DTR_LIM,ax
	 shl	 eax,4-0	; Convert from paras to bytes
	 mov	 [ebp-@BPBACK].BACK_SS.DTR_BASE,eax

	 jmp	 SWATTER_COM1	; Join common code

; Save protected mode selectors and their 32-bit linear base addresses

SWATTER_PM2:
	 mov	 ax,[ebp].FORW_CS ; Get caller's CS
	 mov	 [ebp-@BPBACK].BACK_CS.DTR_LIM,ax
	 push	 ax		 ; Pass selector
	 call	 GETBASE	; Return with EAX = selector base
;;;;;;;; jc	 ???		; Ignore error return
	 mov	 [ebp-@BPBACK].BACK_CS.DTR_BASE,eax

	 test	 LC2_FLAG,@LC2_TSS ; Izit TSS mode?
	 jnz	 short SWATTER_TSS1 ; Yes, handle specially

	 mov	 ax,[esp].ESP_DS ; Get caller's DS
	 mov	 [ebp-@BPBACK].BACK_DS.DTR_LIM,ax
	 push	 ax		; Pass selector
	 call	 GETBASE	; Return with EAX = selector base
;;;;;;;; jc	 ???		; Ignore error return
	 mov	 [ebp-@BPBACK].BACK_DS.DTR_BASE,eax

	 mov	 ax,[esp].ESP_ES ; Get caller's ES
	 mov	 [ebp-@BPBACK].BACK_ES.DTR_LIM,ax
	 push	 ax		; Pass selector
	 call	 GETBASE	; Return with EAX = selector base
;;;;;;;; jc	 ???		; Ignore error return
	 mov	 [ebp-@BPBACK].BACK_ES.DTR_BASE,eax

	 mov	 ax,[esp].ESP_FS ; Get caller's FS
	 mov	 [ebp-@BPBACK].BACK_FS.DTR_LIM,ax
	 push	 ax		; Pass selector
	 call	 GETBASE	; Return with EAX = selector base
;;;;;;;; jc	 ???		; Ignore error return
	 mov	 [ebp-@BPBACK].BACK_FS.DTR_BASE,eax

	 mov	 ax,[esp].ESP_GS ; Get caller's GS
	 mov	 [ebp-@BPBACK].BACK_GS.DTR_LIM,ax
	 push	 ax		; Pass selector
	 call	 GETBASE	; Return with EAX = selector base
;;;;;;;; jc	 ???		; Ignore error return
	 mov	 [ebp-@BPBACK].BACK_GS.DTR_BASE,eax

	 jmp	 short SWATTER_PMCOM ; Join common code

; TSS mode

SWATTER_TSS1:
	 mov	 ax,[ebp].FORW_DS ; Get caller's DS
	 mov	 [ebp-@BPBACK].BACK_DS.DTR_LIM,ax
	 push	 ax		; Pass selector
	 call	 GETBASE	; Return with EAX = selector base
;;;;;;;; jc	 ???		; Ignore error return
	 mov	 [ebp-@BPBACK].BACK_DS.DTR_BASE,eax

	 mov	 ax,[ebp].FORW_ES ; Get caller's ES
	 mov	 [ebp-@BPBACK].BACK_ES.DTR_LIM,ax
	 push	 ax		; Pass selector
	 call	 GETBASE	; Return with EAX = selector base
;;;;;;;; jc	 ???		; Ignore error return
	 mov	 [ebp-@BPBACK].BACK_ES.DTR_BASE,eax

	 mov	 ax,[ebp].FORW_FS ; Get caller's FS
	 mov	 [ebp-@BPBACK].BACK_FS.DTR_LIM,ax
	 push	 ax		; Pass selector
	 call	 GETBASE	; Return with EAX = selector base
;;;;;;;; jc	 ???		; Ignore error return
	 mov	 [ebp-@BPBACK].BACK_FS.DTR_BASE,eax

	 mov	 ax,[ebp].FORW_GS ; Get caller's GS
	 mov	 [ebp-@BPBACK].BACK_GS.DTR_LIM,ax
	 push	 ax		; Pass selector
	 call	 GETBASE	; Return with EAX = selector base
;;;;;;;; jc	 ???		; Ignore error return
	 mov	 [ebp-@BPBACK].BACK_GS.DTR_BASE,eax
SWATTER_PMCOM:
	 mov	 ax,ss		; Get current stack selector

	 cmp	 REENTRY,1	; Check re-entry level
	 jne	 short @F	; Jump if we're re-entering

	 mov	 ax,[ebp].FORW_SS ; Get from extended stack
@@:
	 mov	 [ebp-@BPBACK].BACK_SS.DTR_LIM,ax
	 push	 ax		; Pass selector
	 call	 GETBASE	; Return with EAX = selector base
;;;;;;;; jc	 ???		; Ignore error return
	 mov	 [ebp-@BPBACK].BACK_SS.DTR_BASE,eax
SWATTER_COM1:
	 or	 [ebp].FORW_EFL.ELO,mask $TF ; Set the trap flag in case
				; we're called with INT 01h

	 push	 RETFL		; Save SWATTER caller's flags on stack

	 sti			; Allow interrupts

	 call	 SET_CURINSTR	; Set current instruction disassembly values

; Restore any previous breakpoint values

	 call	 REST_BCVAL	; Restore 'em

	 cmp	 BREAKPT_PTR,-1 ; Check for illegal value
	 je	 short SWATTER_NOBP ; No pending breakpoint

	 mov	 esi,BREAKPT_PTR ; AGROUP:ESI ==> breakpoint linear address

	 cmp	 AGROUP:[esi].LO,@OPCOD_INT3 ; Izit an INT 03h?
	 jne	 short @F	; Not this time

	 mov	 al,BREAKPT_VAL ; Get the value to restore
	 mov	 AGROUP:[esi],al ; Save it back
@@:
	 mov	 BREAKPT_PTR,-1 ; Clear any previous breakpoint
SWATTER_NOBP:
	 btr	 LC3_FLAG,$LC3_SERINIT ; Initialize the serial port?
	 jnc	 short @F	; Jump if not

	 call	 SER_INIT	; Initialize it
	 jmp	 near ptr SWATTER_CLC ; We're done

@@:
	 btr	 LC3_FLAG,$LC3_COMMAND ; Was a command specified via Int 67h?
	 jnc	 short @F	; Jump if not

	 mov	 CURPOSN.LO,0	; Move cursor to start of command line
	 mov	 ax,@KEY_CR	; Execute command line already copied in
	 call	 CMD_CHAR	; Process CMD_LINE for CMD_LINE_LEN bytes
	 jmp	 near ptr SWATTER_CLC ; We're done

@@:
	 test	 LC3_FLAG,@LC3_SERINT ; Is serial I/O established?
	 jz	 short @F	; Jump if not

	 btr	 LC3_FLAG,$LC3_PORTINIT ; Was PORTINIT specified?
	 jnc	 short @F	; Jump if not

	 call	 CMD_REMDBG	; Attempt to establish remote connection
@@:
	 test	 LC2_FLAG,@LC2_SRC ; Are we in source browse mode?
	 jz	 short @F	; Jump if not

	 cmp	 FBROWS_NAME,0	; Do we have a file loaded?
	 je	 short @F	; Jump if not

	 cmp	 DSP_STATE,@DSP_FBROWS ; Are we already in the source browser?
	 jne	 short @F	; Jump if not

	 call	 DISP_IREGS	; Display instructions to get current line ptr
	 test	 LC2_FLAG,@LC2_SFND ; Is current line a source line?
	 jnz	 near ptr SWATTER_FBROWS ; Redisplay browser screen if so

	 mov	 DSP_STAT3,@DSP_FBROWS ; Remember where we came from
@@:
	 mov	 DSP_STATE,@DSP_INSTR ; Initial screen state is instructions
	 jmp	 short @F	; Join common code
SWATTER_REGS:
	 mov	 DSP_STAT3,@DSP_INSTR ; Ensure we don't act on it again
@@:
	 call	 DISP_IREGS	; Display instructions

	 mov	 ax,LC2_FLAG	; Get flags
	 and	 ax,@LC2_SRC or @LC2_SFND or @LC2_IGNMOD ; Isolate bits
	 cmp	 ax,@LC2_SRC or @LC2_SFND ; Are we in source browse mode?
	 jne	 short SWATTER_GETKEY ; Jump if not, or not on a source line

	 cmp	 DSP_STAT3,@DSP_FBROWS ; Did we come from source browser?
	 je	 near ptr SWATTER_FBROWS ; Display file browser if so
SWATTER_GETKEY:
	 call	 GETKEY 	; Wait for keystroke, return in AX
	 call	 CLEAR_MSG	; Clear any message text
SWATTER_WAITKEY:
	 lea	 edi,KEYVAL	; ES:EDI ==> valid keystrokes
	 mov	 ecx,NKEYVAL	; ECX = # valid keystrokes
   repne scas	 KEYVAL[edi]	; Search for it
	 je	 short SWATTER_VALID ; Jump if valid

	 call	 CMD_CHAR	; Process as command line character

	 test	 LC3_FLAG,@LC3_SIGINT ; Did we just signal an interrupt
	 jnz	 near ptr SWATTER_SIGINT ; Jump if so

	 btr	 LC2_FLAG,$LC2_ESC ; Should we escape?
	 jc	 near ptr SWATTER_ESC ; Jump if so
SWATTER_WAIT:
	 test	 LCL_FLAG,@LCL_REDI ; Forced re-display of screen?
	 jz	 short SWATTER_GETKEY ; Not this time

	 and	 LCL_FLAG,not @LCL_REDI ; Clear for next time

	 public  SWATTER_REDISP
SWATTER_REDISP:
	 movzx	 ecx,DSP_STATE	; Get primary state
	 movzx	 eax,DSP_STAT2	; Get secondary state
	 call	 DSP_ACT[eax*(type DSP_ACT)] ; Display the corresponding screen

	 cmp	 al,cl		; Primary and secondary the same?
	 je	 short @F	; Yes

	 call	 DSP_ACT[ecx*(type DSP_ACT)] ; Display the corresponding screen
@@:
	 call	 DISP_MSGLINE	; Display the message line

	 jmp	 SWATTER_GETKEY ; Go around again

SWATTER_VALID:
	 sub	 di,2+offset DGROUP:KEYVAL ; Convert to origin-0 in units of words
	 shr	 di,1		; Divide by two to index table of bytes

	 jmp	 KEYACT[edi*(type KEYACT)]  ; Take appropriate action


; Display memory in byte format

SWATTER_MBYTE:
	 call	 MEMACT_B	; Mark as byte format

	 jmp	 short SWATTER_MCOM ; Join common memory display code


; Display memory in word format

SWATTER_MWORD:
	 call	 MEMACT_W	; Mark as word format

	 jmp	 short SWATTER_MCOM ; Join common memory display code


; Display memory in dword format

SWATTER_MDWORD:
	 call	 MEMACT_D	; Mark as dword format

	 jmp	 short SWATTER_MCOM ; Join common memory display code


; Display memory in vector format

SWATTER_MVECT:
	 call	 MEMACT_V	; Mark as vector format

	 jmp	 short SWATTER_MCOM ; Join common memory display code


; Display memory in GDT format

SWATTER_MGDT:
	 call	 MEMACT_G	; Mark as GDT format

	 jmp	 short SWATTER_MCOM ; Join common memory display code


; Display memory in IDT format

SWATTER_MIDT:
	 call	 MEMACT_I	; Mark as IDT format

	 jmp	 short SWATTER_MCOM ; Join common memory display code


; Display memory in TSS format

SWATTER_MTSS:
	 call	 MEMACT_T	; Mark as TSS format

;;;;;;;; jmp	 short SWATTER_MCOM ; Join common memory display code

SWATTER_MCOM:
	 and	 MEMMODE,not @MODE_NEW ; Clear it (used by Dx actions only)

;;;;;;;; jmp	 short SWATTER_MEM ; Join common memory display code


; Display memory

SWATTER_MEM:
	 mov	 al,@DSP_MEM	; Screen state is memory
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Scroll screen up depending upon the current mode

SWATTER_SCRUP:
	 movzx	 eax,DSP_STATE	; Get primary state

	 jmp	 SCRUP_ACT[eax*(type SCRUP_ACT)] ; Take appropriate action


SCRUP_INSTR:
	 mov	 eax,FIRST_INSTR ; Get linear address of top instr
	 call	 GET_LASTILEN	; Return with EAX=length of previous instr
	 sub	 UNAOFF,eax	; Subtract from offset of top instr

	 mov	 eax,UNAMASK	; Get current mask
	 and	 UNAOFF,eax	; Ensure it's within limits

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRUP_GDT:
	 sub	 GDTOFF,size DESC_STR ; Scroll up one
	 jnc	 short @F	; Jump if we didn't sink below zero

	 mov	 GDTOFF,0	; Cut back to zero
@@:
	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRUP_IDT:
	 sub	 IDTOFF,size IDT_STR ; Scroll up one
	 jnc	 short @F	; Jump if we didn't sink below zero

	 mov	 IDTOFF,0	; Cut back to zero
@@:
	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRUP_LDT:
	 sub	 LDTOFF,size DESC_STR ; Scroll up one
	 jnc	 short @F	; Jump if we didn't sink below zero

	 mov	 LDTOFF,0	; Cut back to zero
@@:
	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRUP_MEM:
	 movzx	 eax,MEMSIZE	; Get size of one memory row
	 sub	 MEMOFF,eax	; Skip to previous row
	 mov	 eax,MEMMASK	; Get the mask value
	 and	 MEMOFF,eax	; Mask off wrapped bits (if VM86 mode)

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRUP_DRn:
	 movzx	 eax,DSP_STAT2	; Get secondary state

	 cmp	 al,DSP_STATE	; Same as secondary state?
	 je	 near ptr SWATTER_WAIT ; Yes

	 or	 LCL_FLAG,@LCL_REDI ; Force screen re-display

	 jmp	 SCRUP_ACT[eax*(type SCRUP_ACT)] ; Take appropriate action


SCRUP_SRCH:
	 movzx	 eax,DSP_STAT2	; Get secondary state

	 cmp	 al,@DSP_SRCH	; Same as secondary state?
	 je	 near ptr SWATTER_WAIT ; Yes

	 or	 LCL_FLAG,@LCL_REDI ; Force screen re-display

	 jmp	 SCRUP_ACT[eax*(type SCRUP_ACT)] ; Take appropriate action


SCRUP_PTE:
	 sub	 PTE_START,8*4	; Skip to previous row
	 jnc	 short @F	; Jump if we didn't sink below zero

	 mov	 PTE_START,0	; Cut back to zero
@@:
	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRUP_PDE:
	 sub	 PDE_START,8*4	; Skip to previous row
	 jnc	 short @F	; Jump if we didn't sink below zero

	 mov	 PDE_START,0	; Cut back to zero
@@:
	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRUP_SYMTAB:
	 sub	 SYMTAB_START,1 ; Decrement index into symbol table
	 jnc	 short @F	; Jump if we didn't sink below zero

	 mov	 SYMTAB_START,0 ; Cut back to zero
@@:
	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRUP_FBROWS:
	 mov	 ax,-1		; Subtract 1 from SLINE
	 call	 ADJUST_SLINE	; Check range and adjust pointers

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRUP_LSCR:
	 inc	 LSCR_CNT	; Count in another last screen
	 mov	 eax,NLSTBUF	; Get # last screen buffers

	 cmp	 LSCR_CNT,eax	; Izit below the maximum?
	 jb	 short @F	; Jump if so

	 mov	 LSCR_CNT,0	; Wrap to zero
@@:
	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRUP_ERRLOG:
	 sub	 ERRLOG_CLINE,1 ; Back off by 1 line
	 jnc	 short @F	; Jump if OK

	 mov	 ERRLOG_CLINE,0 ; Minimum value
@@:
	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRUP_TSS:
SCRUP_BC:
	 jmp	 SWATTER_WAIT	; Wait for the next keystroke


; Scroll screen down

SWATTER_SCRDN:
	 movzx	 eax,DSP_STATE	; Get primary state

	 jmp	 SCRDN_ACT[eax*(type SCRDN_ACT)] ; Take appropriate action


SCRDN_INSTR:
	 mov	 eax,INSTRLDN	; Get top instruction's length
	 add	 UNAOFF,eax	; Add into offset of top instr

	 mov	 eax,UNAMASK	; Get current mask
	 and	 UNAOFF,eax	; Ensure it's within limits

	 mov	 al,@DSP_INSTR	; Screen state is instructions
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRDN_GDT:
	 add	 GDTOFF,size DESC_STR ; Skip to next row

	 mov	 al,@DSP_GDT	; Screen state is GDT
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRDN_IDT:
	 add	 IDTOFF,size IDT_STR ; Skip to next row

	 mov	 al,@DSP_IDT	; Screen state is IDT
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRDN_LDT:
	 add	 LDTOFF,size DESC_STR ; Skip to next row

	 mov	 al,@DSP_LDT	; Screen state is LDT
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRDN_MEM:
	 movzx	 eax,MEMSIZE	; Get size of one memory row
	 add	 MEMOFF,eax	; Skip to next row
	 mov	 eax,MEMMASK	; Get the mask value
	 and	 MEMOFF,eax	; Mask off wrapped bits (if VM86 mode)

	 mov	 al,@DSP_MEM	; Screen state is memory
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRDN_DRn:
	 movzx	 eax,DSP_STAT2	; Get secondary state

	 cmp	 al,DSP_STATE	; Same as secondary state?
	 je	 near ptr SWATTER_WAIT ; Yes

	 or	 LCL_FLAG,@LCL_REDI ; Force screen re-display

	 jmp	 SCRDN_ACT[eax*(type SCRDN_ACT)] ; Take appropriate action


SCRDN_SRCH:
	 movzx	 eax,DSP_STAT2	; Get secondary state

	 cmp	 al,@DSP_SRCH	; Same as secondary state?
	 je	 near ptr SWATTER_WAIT ; Yes

	 or	 LCL_FLAG,@LCL_REDI ; Force screen re-display

	 jmp	 SCRDN_ACT[eax*(type SCRDN_ACT)] ; Take appropriate action


SCRDN_PTE:
	 add	 PTE_START,8*4	; Skip to next row

	 mov	 al,@DSP_PTE	; Screen state is PTE
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRDN_PDE:
	 add	 PDE_START,8*4	; Skip to next row

	 mov	 al,@DSP_PDE	; Screen state is PDE
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRDN_SYMTAB:
	 mov	 eax,SYMCOUNT	; Get # symbols in the table

	 sub	 eax,1		; Less one to get maximum value for SYMTAB_START
	 jc	 short @F	; Jump if no symbols

	 inc	 SYMTAB_START	; Skip to next symbol

	 cmp	 eax,SYMTAB_START ; Izit beyond the end?
	 jae	 short @F	; Jump if not

	 mov	 SYMTAB_START,eax ; Truncate to last symbol
@@:
	 mov	 al,@DSP_SYMTAB ; Screen state is SYMTAB
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRDN_FBROWS:
	 mov	 ax,1		; Add 1 to SLINE
	 call	 ADJUST_SLINE	; Check range and adjust pointers

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRDN_LSCR:
	 cmp	 LSCR_CNT,0	; Izit at the minimum?
	 jne	 short @F	; Jump if not

	 mov	 eax,NLSTBUF	; Get # last screen buffers
	 mov	 LSCR_CNT,eax	; Wrap to maximum+1
@@:
	 dec	 LSCR_CNT	; Count out another last screen

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRDN_ERRLOG:
	 inc	 ERRLOG_CLINE	; Count in another line

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRDN_TSS:
SCRDN_BC:
	 jmp	 SWATTER_WAIT	; Wait for the next keystroke


; Scroll screen page up depending upon the current mode

SWATTER_SCRPGUP:
	 movzx	 eax,DSP_STATE	; Get primary state

	 jmp	 SCRPGUP_ACT[eax*(type SCRPGUP_ACT)] ; Take appropriate action


SCRPGUP_INSTR:
	 call	 GET_LASTPLEN	; Return with EAX=length of previous page
	 sub	 UNAOFF,eax	; Subtract from offset of top instr

	 mov	 eax,UNAMASK	; Get current mask
	 and	 UNAOFF,eax	; Ensure it's within limits

	 mov	 al,@DSP_INSTR	; Screen state is instructions
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGUP_GDT:
	 sub	 GDTOFF,(@NROWS-2)*(size DESC_STR) ; Skip to previous page
	 jnc	 short @F	; Jump if we didn't sink below zero

	 mov	 GDTOFF,0	; Cut back to zero
@@:
	 mov	 al,@DSP_GDT	; Screen state is GDT
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGUP_IDT:
	 sub	 IDTOFF,(@NROWS-2)*(size IDT_STR) ; Skip to previous page
	 jnc	 short @F	; Jump if we didn't sink below zero

	 mov	 IDTOFF,0	; Cut back to zero
@@:
	 mov	 al,@DSP_IDT	; Screen state is IDT
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGUP_LDT:
	 sub	 LDTOFF,(@NROWS-2)*(size DESC_STR) ; Skip to previous page
	 jnc	 short @F	; Jump if we didn't sink below zero

	 mov	 LDTOFF,0	; Cut back to zero
@@:
	 mov	 al,@DSP_LDT	; Screen state is LDT
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGUP_MEM:
	 mov	 ax,@NROWS-2	; Get # screen rows in memory display
	 mul	 MEMSIZE	; Times size of one memory row
	 movzx	 eax,ax 	; Zero high-order word
	 sub	 MEMOFF,eax	; Skip to previous page
	 mov	 eax,MEMMASK	; Get the mask value
	 and	 MEMOFF,eax	; Mask off wrapped bits (if VM86 mode)

	 mov	 al,@DSP_MEM	; Screen state is memory
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGUP_DRn:
	 movzx	 eax,DSP_STAT2	; Get secondary state

	 cmp	 al,DSP_STATE	; Same as secondary state?
	 je	 near ptr SWATTER_WAIT ; Yes

	 or	 LCL_FLAG,@LCL_REDI ; Force screen re-display

	 jmp	 SCRPGUP_ACT[eax*(type SCRPGUP_ACT)] ; Take appropriate action


SCRPGUP_SRCH:
	 movzx	 eax,DSP_STAT2	; Get secondary state

	 cmp	 al,@DSP_SRCH	; Same as secondary state?
	 je	 near ptr SWATTER_WAIT ; Yes

	 or	 LCL_FLAG,@LCL_REDI ; Force screen re-display

	 jmp	 SCRPGUP_ACT[eax*(type SCRPGUP_ACT)] ; Take appropriate action


SCRPGUP_PTE:
	 sub	 PTE_START,(@NROWS-2)*(8*4) ; Skip to previous page
	 jnc	 short @F	; Jump if we didn't sink below zero

	 mov	 PTE_START,0	; Cut back to zero
@@:
	 mov	 al,@DSP_PTE	; Screen state is PTE
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGUP_PDE:
	 sub	 PDE_START,(@NROWS-2)*(8*4) ; Skip to previous page
	 jnc	 short @F	; Jump if we didn't sink below zero

	 mov	 PDE_START,0	; Cut back to zero
@@:
	 mov	 al,@DSP_PDE	; Screen state is PDE
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGUP_SYMTAB:
	 sub	 SYMTAB_START,@NSYMROWS ; Skip to previous page
	 jnc	 short @F	; Jump if we didn't sink below zero

	 mov	 SYMTAB_START,0 ; Cut back to zero
@@:
	 mov	 al,@DSP_SYMTAB ; Screen state is SYMTAB
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGUP_FBROWS:
	 mov	 ax,-(@FBROWS_NROWS-1) ; Subtract a page-1 from SLINE
	 call	 ADJUST_SLINE	; Check range and adjust pointers

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGUP_ERRLOG:
	 sub	 ERRLOG_CLINE,(@NROWS-2) ; Subtract a page from current line
	 jnc	 short @F	; Jump if >= 0

	 mov	 ERRLOG_CLINE,0 ; Starting line
@@:
	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGUP_TSS:
SCRPGUP_BC:
SCRPGUP_LSCR:
	 jmp	 SWATTER_WAIT	; Wait for the next keystroke


; Scroll screen page down

SWATTER_SCRPGDN:
	 movzx	 eax,DSP_STATE	; Get primary state

	 jmp	 SCRPGDN_ACT[eax*(type SCRPGDN_ACT)] ; Take appropriate action


SCRPGDN_INSTR:
	 mov	 eax,INSTRPDN	; Get page of instruction's length
	 add	 UNAOFF,eax	; Add into offset of top instr

	 mov	 eax,UNAMASK	; Get current mask
	 and	 UNAOFF,eax	; Ensure it's within limits

	 mov	 al,@DSP_INSTR	; Screen state is instructions
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGDN_GDT:
	 add	 GDTOFF,(@NROWS-2)*(size DESC_STR) ; Skip to next page

	 mov	 al,@DSP_GDT	; Screen state is GDT
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGDN_IDT:
	 add	 IDTOFF,(@NROWS-2)*(size IDT_STR) ; Skip to next page

	 mov	 al,@DSP_IDT	; Screen state is IDT
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGDN_LDT:
	 add	 LDTOFF,(@NROWS-2)*(size DESC_STR) ; Skip to next page

	 mov	 al,@DSP_LDT	; Screen state is LDT
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGDN_MEM:
	 mov	 ax,@NROWS-2	; Get # screen rows in memory display
	 mul	 MEMSIZE	; Times size of one memory row
	 movzx	 eax,ax 	; Zero high-order word
	 add	 MEMOFF,eax	; Skip to next page
	 mov	 eax,MEMMASK	; Get the mask value
	 and	 MEMOFF,eax	; Mask off wrapped bits (if VM86 mode)

	 mov	 al,@DSP_MEM	; Screen state is memory
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGDN_DRn:
	 movzx	 eax,DSP_STAT2	; Get secondary state

	 cmp	 al,DSP_STATE	; Same as secondary state?
	 je	 near ptr SWATTER_WAIT ; Yes

	 or	 LCL_FLAG,@LCL_REDI ; Force screen re-display

	 jmp	 SCRPGDN_ACT[eax*(type SCRPGDN_ACT)] ; Take appropriate action


SCRPGDN_SRCH:
	 movzx	 eax,DSP_STAT2	; Get secondary state

	 cmp	 al,@DSP_SRCH	; Same as secondary state?
	 je	 near ptr SWATTER_WAIT ; Yes

	 or	 LCL_FLAG,@LCL_REDI ; Force screen re-display

	 jmp	 SCRPGDN_ACT[eax*(type SCRPGDN_ACT)] ; Take appropriate action


SCRPGDN_PTE:
	 add	 PTE_START,(@NROWS-2)*(8*4) ; Skip to next page

	 mov	 al,@DSP_PTE	; Screen state is PTE
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGDN_PDE:
	 add	 PDE_START,(@NROWS-2)*(8*4) ; Skip to next page

	 mov	 al,@DSP_PDE	; Screen state is PDE
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGDN_SYMTAB:
	 mov	 eax,SYMCOUNT	; Get # symbols in the table

	 sub	 eax,1		; Less one to get maximum value for SYMTAB_START
	 jc	 short @F	; Jump if no symbols

	 add	 SYMTAB_START,@NSYMROWS ; Skip to next page

	 cmp	 eax,SYMTAB_START ; Izit beyond the end?
	 jae	 short @F	; Jump if not

	 mov	 SYMTAB_START,eax ; Truncate to last symbol
@@:
	 mov	 al,@DSP_SYMTAB ; Screen state is SYMTAB
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGDN_FBROWS:
	 mov	 ax,@FBROWS_NROWS-1 ; Add a page-1 to SLINE
	 call	 ADJUST_SLINE	; Check range and adjust pointers

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGDN_ERRLOG:
	 add	 ERRLOG_CLINE,(@NROWS-2) ; Add a page to current line

	 jmp	 SWATTER_REDISP ; Join common re-display code


SCRPGDN_TSS:
SCRPGDN_BC:
SCRPGDN_LSCR:
	 jmp	 SWATTER_WAIT	; Wait for the next keystroke


; Display debug registers
; Because this is an overlay window, let DISP_DRn handle setting DSP_STAT2

SWATTER_DRn:
	 call	 DISP_DRn	; Display 'em

	 jmp	 SWATTER_WAIT	; Wait for the next keystroke


; Display NDP registers
; Because this is an overlay window, let DISP_NDP handle setting DSP_STAT2

SWATTER_NDP:
	 test	 LC2_FLAG,mask $LC2_NDP ; Izit present
	 jz	 short SWATTER_XNDP ; Jump if not

	 call	 DISP_NDP	; Display 'em

	 jmp	 SWATTER_WAIT	; Wait for the next keystroke

; NDP not present

SWATTER_XNDP:
	 mov	 MSGOFF,offset DGROUP:NDPERR ; Save offset of error message
	 or	 LC2_FLAG,mask $LC2_MSG ; Mark as message to display

	 jmp	 SWATTER_REDISP ; Join common re-display code

; Set the local debug state

SWATTER_LCLDBG:
	 or	 LCL_FLAG,@LCL_DBG ; Set the state

	 jmp	 SWATTER_WAIT	; Wait for the next keystroke


; Toggle the stack display width

SWATTER_STK:
	 xor	 LCL_FLAG,@LCL_STKD ; Toggle the state

	 cmp	 DSP_STATE,@DSP_INSTR ; Are we displaying instructions?
	 jne	 short @F	; No, so don't display the stack

; Display the stack

	 push	 STACK_eSP	; Pass SS:eSP linear address
	 push	 STACK_eBP	; ...  SS:eBP ...
	 call	 DISP_STK	; Display it
@@:
	 jmp	 SWATTER_WAIT	; Wait for the next keystroke


; Toggle the screen restore state

SWATTER_SCRN:
	 xor	 LCL_FLAG,@LCL_SCRN ; Toggle the state

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Home to the current instruction

SWATTER_HOME:
	 mov	 FIRST_INSTR,-1 ; Clobber to force to top
	 call	 SET_CURINSTR	; Set current instruction disassembly values

	 mov	 al,@DSP_INSTR	; Screen state is instructions
	 call	 SET_STATE	; Set new state

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Toggle INT 01h and 03h intercepts

SWATTER_I01A:
	 or	 LCL_FLAG,@LCL_DEBUG ; Mark as doing INT 03h also
SWATTER_I01:

; If we're in device SWAT, toggle the @TRP_Ixx bit

	 test	 DEVLOAD,@DEVL_LOAD ; Izit device load?
	 jz	 short @F	; Jump if not

	 push	 @TRP_I01	; Pass bit to toggle
	 call	 TOGGLE_TRP	; Toggle the @TRP_Ixx bit

	 jmp	 SWATTER_I01TRP ; Join common code

@@:
	 mov	 ebx,[ebp-@BPBACK].BACK_IDT.DTR_BASE ; Get IDTR base

	 test	 LC2_FLAG,mask $LC2_TSS ; Are we using TSSs?
	 jnz	 near ptr SWATTER_I01TSS ; Jump if so

	 test	 LC3_FLAG,@LC3_STEP ; Check state
	 jnz	 near ptr SWATTER_I011 ; Jump if currently intercepted

	 IDTMAC  01h,01,LCL,OLD ; IDT to OLD, LCL to IDT (EAX clobbered)

	 jmp	 short @F	; Join common code

SWATTER_I011:
	 IDTMAC  01h,01,OLD	; OLD to IDT (EAX clobbered)
@@:
SWATTER_I01TRP:
	 xor	 LC3_FLAG,@LC3_STEP ; Toggle state

	 jmp	 short SWATTER_I01COM ; Join common code

SWATTER_I01TSS:
	 btc	 TSSINT_FLAG,01h ; Izit already intercepted?
	 jc	 short SWATTER_I01TSS1 ; Jump if so

	 IDTMAC  01h,01,TSS,OLDTSS ; IDT to OLDTSS, TSS to IDT (EAX clobbered)

	 jmp	 short @F	; Join common code

SWATTER_I01TSS1:
	 IDTMAC  01h,01,OLDTSS	; OLDTSS to IDT (EAX clobbered)
@@:
SWATTER_I01COM:
	 test	 LCL_FLAG,@LCL_DEBUG ; Doing INT 03h also?
	 jnz	 near ptr SWATTER_I03A ; Jump if so

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Toggle INT 02h intercept

SWATTER_I02:

; If we're in device SWAT, toggle the @TRP_Ixx bit

	 test	 DEVLOAD,@DEVL_LOAD ; Izit device load?
	 jz	 short @F	; Jump if not

	 push	 @TRP_I02	; Pass bit to toggle
	 call	 TOGGLE_TRP	; Toggle the @TRP_Ixx bit

	 jmp	 SWATTER_I02TRP ; Join common code

@@:
	 mov	 ebx,[ebp-@BPBACK].BACK_IDT.DTR_BASE ; Get IDTR base

	 test	 LC2_FLAG,mask $LC2_TSS ; Are we using TSSs?
	 jnz	 near ptr SWATTER_I02TSS ; Jump if so

	 test	 LCL_FLAG,@LCL_NMI ; Check state
	 jnz	 near ptr SWATTER_I021 ; Jump if currently intercepted

	 IDTMAC  02h,02,LCL,OLD ; IDT to OLD, LCL to IDT (EAX clobbered)

	 jmp	 short @F	; Join common code

SWATTER_I021:
	 IDTMAC  02h,02,OLD	; OLD to IDT (EAX clobbered)
@@:
SWATTER_I02TRP:
	 xor	 LCL_FLAG,@LCL_NMI ; Toggle state

	 jmp	 SWATTER_REDISP ; Join common re-display code

SWATTER_I02TSS:
	 btc	 TSSINT_FLAG,02h ; Izit already intercepted?
	 jc	 short SWATTER_I02TSS1 ; Jump if so

	 IDTMAC  02h,02,TSS,OLDTSS ; IDT to OLDTSS, TSS to IDT (EAX clobbered)

	 jmp	 short @F	; Join common code

SWATTER_I02TSS1:
	 IDTMAC  02h,02,OLDTSS	; OLDTSS to IDT (EAX clobbered)
@@:
	 jmp	 SWATTER_REDISP ; Join common re-display code


; Toggle INT 03h intercept

SWATTER_I03A:
	 and	 LCL_FLAG,not @LCL_DEBUG ; Clear for next time
SWATTER_I03:

; If we're in device SWAT, toggle the @TRP_Ixx bit

	 test	 DEVLOAD,@DEVL_LOAD ; Izit device load?
	 jz	 short @F	; Jump if not

	 push	 @TRP_I03	; Pass bit to toggle
	 call	 TOGGLE_TRP	; Toggle the @TRP_Ixx bit

	 jmp	 SWATTER_I03TRP ; Join common code

@@:
	 mov	 ebx,[ebp-@BPBACK].BACK_IDT.DTR_BASE ; Get IDTR base

	 test	 LC2_FLAG,mask $LC2_TSS ; Are we using TSSs?
	 jnz	 near ptr SWATTER_I03TSS ; Jump if so

	 test	 LC3_FLAG,@LC3_SKIP ; Check state
	 jnz	 near ptr SWATTER_I031 ; Jump if currently intercepted

	 IDTMAC  03h,03,LCL,OLD ; IDT to OLD, LCL to IDT (EAX clobbered)

	 jmp	 short @F	; Join common code

SWATTER_I031:
	 IDTMAC  03h,03,OLD	; OLD to IDT (EAX clobbered)
@@:
SWATTER_I03TRP:
	 xor	 LC3_FLAG,@LC3_SKIP ; Toggle state

	 jmp	 SWATTER_REDISP ; Join common re-display code

SWATTER_I03TSS:
	 btc	 TSSINT_FLAG,03h ; Izit already intercepted?
	 jc	 short SWATTER_I03TSS1 ; Jump if so

	 IDTMAC  03h,03,TSS,OLDTSS ; IDT to OLDTSS, TSS to IDT (EAX clobbered)

	 jmp	 short @F	; Join common code

SWATTER_I03TSS1:
	 IDTMAC  03h,03,OLDTSS	; OLDTSS to IDT (EAX clobbered)
@@:
	 jmp	 SWATTER_REDISP ; Join common re-display code


; Toggle INT 06h intercept

SWATTER_I06:

; If we're in device SWAT, toggle the @TRP_Ixx bit

	 test	 DEVLOAD,@DEVL_LOAD ; Izit device load?
	 jz	 short @F	; Jump if not

	 push	 @TRP_I06	; Pass bit to toggle
	 call	 TOGGLE_TRP	; Toggle the @TRP_Ixx bit

	 jmp	 SWATTER_I06TRP ; Join common code

@@:
	 mov	 ebx,[ebp-@BPBACK].BACK_IDT.DTR_BASE ; Get IDTR base

	 test	 LC2_FLAG,mask $LC2_TSS ; Are we using TSSs?
	 jnz	 near ptr SWATTER_I06TSS ; Jump if so

	 test	 LC3_FLAG,@LC3_INV ; Check state
	 jnz	 near ptr SWATTER_I061 ; Jump if currently intercepted

	 IDTMAC  06h,06,LCL,OLD ; IDT to OLD, LCL to IDT (EAX clobbered)

	 jmp	 short @F	; Join common code

SWATTER_I061:
	 IDTMAC  06h,06,OLD	; OLD to IDT (EAX clobbered)
@@:
SWATTER_I06TRP:
	 xor	 LC3_FLAG,@LC3_INV ; Toggle state

	 jmp	 SWATTER_REDISP ; Join common re-display code

SWATTER_I06TSS:
	 btc	 TSSINT_FLAG,06h ; Izit already intercepted?
	 jc	 short SWATTER_I06TSS1 ; Jump if so

	 IDTMAC  06h,06,TSS,OLDTSS ; IDT to OLDTSS, TSS to IDT (EAX clobbered)

	 jmp	 short @F	; Join common code

SWATTER_I06TSS1:
	 IDTMAC  06h,06,OLDTSS	; OLDTSS to IDT (EAX clobbered)
@@:
	 jmp	 SWATTER_REDISP ; Join common re-display code


; Toggle INT 0Dh intercept

SWATTER_I0D:

; If we're in device SWAT, toggle the @TRP_Ixx bit

	 test	 DEVLOAD,@DEVL_LOAD ; Izit device load?
	 jz	 short @F	; Jump if not

	 push	 @TRP_I0D	; Pass bit to toggle
	 call	 TOGGLE_TRP	; Toggle the @TRP_Ixx bit

	 jmp	 SWATTER_I0DTRP ; Join common code

@@:
	 mov	 ebx,[ebp-@BPBACK].BACK_IDT.DTR_BASE ; Get IDTR base

	 test	 LC2_FLAG,mask $LC2_TSS ; Are we using TSSs?
	 jnz	 near ptr SWATTER_I0DTSS ; Jump if so

	 test	 LCL_FLAG,@LCL_GENP ; Check state
	 jnz	 near ptr SWATTER_I0D1 ; Jump if currently intercepted

	 IDTMAC  0Dh,0D,LCL,OLD ; IDT to OLD, LCL to IDT (EAX clobbered)

	 jmp	 short @F	; Join common code

SWATTER_I0D1:
	 IDTMAC  0Dh,0D,OLD	; OLD to IDT (EAX clobbered)
@@:
SWATTER_I0DTRP:
	 xor	 LCL_FLAG,@LCL_GENP ; Toggle state

	 jmp	 SWATTER_REDISP ; Join common re-display code

SWATTER_I0DTSS:
	 btc	 TSSINT_FLAG,0Dh ; Izit already intercepted?
	 jc	 short SWATTER_I0DTSS1 ; Jump if so

	 IDTMAC  0Dh,0D,TSS,OLDTSS ; IDT to OLDTSS, TSS to IDT (EAX clobbered)

	 jmp	 short @F	; Join common code

SWATTER_I0DTSS1:
	 IDTMAC  0Dh,0D,OLDTSS	; OLDTSS to IDT (EAX clobbered)
@@:
	 jmp	 SWATTER_REDISP ; Join common re-display code


; Toggle INT 0Eh intercept

SWATTER_I0E:

; If we're in device SWAT, toggle the @TRP_Ixx bit

	 test	 DEVLOAD,@DEVL_LOAD ; Izit device load?
	 jz	 short @F	; Jump if not

	 push	 @TRP_I0E	; Pass bit to toggle
	 call	 TOGGLE_TRP	; Toggle the @TRP_Ixx bit

	 jmp	 SWATTER_I0ETRP ; Join common code

@@:
	 mov	 ebx,[ebp-@BPBACK].BACK_IDT.DTR_BASE ; Get IDTR base

	 test	 LC2_FLAG,mask $LC2_TSS ; Are we using TSSs?
	 jnz	 near ptr SWATTER_I0ETSS ; Jump if so

	 test	 LCL_FLAG,@LCL_PAGE ; Check state
	 jnz	 near ptr SWATTER_I0E1 ; Jump if currently intercepted

	 IDTMAC  0Eh,0E,LCL,OLD ; IDT to OLD, LCL to IDT (EAX clobbered)

	 jmp	 short @F	; Join common code

SWATTER_I0E1:
	 IDTMAC  0Eh,0E,OLD	; OLD to IDT (EAX clobbered)
@@:
SWATTER_I0ETRP:
	 xor	 LCL_FLAG,@LCL_PAGE ; Toggle state

	 jmp	 SWATTER_REDISP ; Join common re-display code

SWATTER_I0ETSS:
	 btc	 TSSINT_FLAG,0Eh ; Izit already intercepted?
	 jc	 short SWATTER_I0ETSS1 ; Jump if so

	 IDTMAC  0Eh,0E,TSS,OLDTSS ; IDT to OLDTSS, TSS to IDT (EAX clobbered)

	 jmp	 short @F	; Join common code

SWATTER_I0ETSS1:
	 IDTMAC  0Eh,0E,OLDTSS	; OLDTSS to IDT (EAX clobbered)
@@:
	 jmp	 SWATTER_REDISP ; Join common re-display code


; Decrement the location

SWATTER_DECLOC:
	 movzx	 eax,DSP_STATE	; Get primary state

	 jmp	 DECLOC_ACT[eax*(type DECLOC_ACT)] ; Take appropriate action


DECLOC_INSTR:
	 call	 GET_CURINSTR	; Return with EAX ==> current instruction
	 call	 GET_LASTILEN	; Return with EAX=length of previous instr

	 sub	 [ebp].FORW_EIP,eax ; Decrement instruction pointer

	 call	 SET_CURINSTR	; Set current instruction disassembly values

;;;;;;;; mov	 al,@DSP_INSTR	; Screen state is instructions
;;;;;;;; call	 SET_STATE	; Set new state
;;;;;;;;
	 jmp	 SWATTER_REDISP ; Join common re-display code


DECLOC_MEM:
	 cmp	 MEMTYPE,@MEM_TSS ; Are we displaying in TSS format?
	 jne	 short @F	; Jump if not
DECLOC_TSS:
	 dec	 IOMAP_LINE	; Skip to previous I/O map line
	 jns	 SWATTER_REDISP ; Join common re-display code

	 mov	 IOMAP_LINE,0	; Oops, we can't decrement below 0

	 jmp	 SWATTER_REDISP ; Join common re-display code

@@:
	 movzx	 eax,MEMGRAN	; Get # bytes in memory display type
	 sub	 MEMOFF,eax	; Skip backward by that amount
	 mov	 eax,MEMMASK	; Get the mask value
	 and	 MEMOFF,eax	; Mask off wrapped bits (if VM86 mode)

	 jmp	 SWATTER_REDISP ; Join common re-display code


DECLOC_GDT:
DECLOC_IDT:
DECLOC_LDT:
DECLOC_PTE:
DECLOC_PDE:
DECLOC_SYMTAB:
DECLOC_FBROWS:
DECLOC_ERRLOG:
DECLOC_DRn:
DECLOC_SRCH:
DECLOC_BC:
DECLOC_LSCR:
	 jmp	 SWATTER_REDISP ; Join common re-display code



; Increment the location

SWATTER_INCLOC:
	 movzx	 eax,DSP_STATE	; Get primary state

	 jmp	 INCLOC_ACT[eax*(type INCLOC_ACT)] ; Take appropriate action


INCLOC_INSTR:
	 mov	 eax,INSTRLEN	; Get current instruction's length
	 add	 [ebp].FORW_EIP,eax ; Increment instruction pointer

	 call	 SET_CURINSTR	; Set current instruction disassembly values

;;;;;;;; mov	 al,@DSP_INSTR	; Screen state is instructions
;;;;;;;; call	 SET_STATE	; Set new state
;;;;;;;;
	 jmp	 SWATTER_REDISP ; Join common re-display code


INCLOC_MEM:
	 cmp	 MEMTYPE,@MEM_TSS ; Are we displaying in TSS format?
	 jne	 short @F	; Jump if not
INCLOC_TSS:
	 mov	 ax,IOMAP_LINE	; Get current line

	 cmp	 ax,IOMAP_LINE_MAX ; Have we reached the end of the map?
	 jae	 SWATTER_REDISP ; Join common re-display code if so

	 inc	 IOMAP_LINE	; Skip to next I/O map line

	 jmp	 SWATTER_REDISP ; Join common re-display code

@@:
	 movzx	 eax,MEMGRAN	; Get # bytes in memory display type
	 add	 MEMOFF,eax	; Skip forward by that amount
	 mov	 eax,MEMMASK	; Get the mask value
	 and	 MEMOFF,eax	; Mask off wrapped bits (if VM86 mode)

	 jmp	 SWATTER_REDISP ; Join common re-display code


INCLOC_GDT:
INCLOC_IDT:
INCLOC_LDT:
INCLOC_PTE:
INCLOC_PDE:
INCLOC_SYMTAB:
INCLOC_FBROWS:
INCLOC_ERRLOG:
INCLOC_DRn:
INCLOC_SRCH:
INCLOC_BC:
INCLOC_LSCR:
	 jmp	 SWATTER_REDISP ; Join common re-display code


; Breakpoint to the address of the instruction on the top line

SWATTER_BGOTO:
	 cmp	 DSP_STATE,@DSP_INSTR ; Ensure we're displaying instructions
	 jne	 short SWATTER_BGOTO_ERR ; Jump if not

	 mov	 edx,FIRST_INSTR ; Get linear address of top instr

	 jmp	 SWATTER_SKIP1	; Join common skip code

SWATTER_BGOTO_ERR:
	 jmp	 SWATTER_REDISP ; Join common re-display code


; Push current address, goto address referenced by the top line
; If the current instruction references an address directly or indirectly,
; display the instructions beginning with that address

SWATTER_AGOTO:
	 cmp	 DSP_STATE,@DSP_INSTR ; Ensure we're displaying instructions
	 jne	 near ptr SWATTER_AGOTO_ERR ; Jump if not

; Ensure there's enough room in the ARET table

	 cmp	 ARET_CNT,0	; Izit at the bottom?
	 je	 near ptr SWATTER_AGOTO_ERR ; Jump if so

; Save the current segment/selector and offset

	 mov	 esi,ARETBASE	; DS:ESI ==> offset into ARET table

	 mov	 eax,UNAOFF	; Get offset of top instr
	 mov	 DGROUP:[esi].ARET_FVEC.FOFF,eax ; Save to restore later
	 mov	 ax,UNASEL	; Get segment of top instr
	 mov	 DGROUP:[esi].ARET_FVEC.FSEL,ax ; Save to restore later

	 mov	 ax,UNAMODE	; Get mode
	 mov	 DGROUP:[esi].ARET_MODE,ax ; Save to restore later
	 mov	 eax,UNAMASK	; Get mask
	 mov	 DGROUP:[esi].ARET_MASK,eax ; Save to restore later
	 mov	 eax,UNABASE	; Get base address of top instr
	 mov	 DGROUP:[esi].ARET_BASE,eax ; Save to restore later

; Decode the first instruction at the top of the screen

	 mov	 esi,FIRST_INSTR ; Get linear address of first instr
	 call	 DECODE_ADDR	; Decode the target address of the instr
				; at AGROUP:ESI
				; BX  = segment/selector (if @ADDR_SEP)
				; EAX = offset
				; CX  = flags
				; EDX = address base	 (if @ADDR_SEP)
	 jc	 short SWATTER_AGOTO_ERR ; Jump if none

; Set new values for UNAOFF, UNASEL, and UNABASE

	 mov	 UNAOFF,eax	; Save as offset of top instr

	 test	 cx,@ADDR_SEP	; Separator specified?
	 jz	 short @F	; Not this time

	 mov	 UNABASE,edx	; Save as base address of top instr
	 mov	 UNASEL,bx	; Save as segment of ...

	 and	 UNAMODE,not @MODE_USE32 ; Assume it's USE16
	 mov	 UNAMASK,0000FFFFh ; ...

	 test	 cx,@ADDR_USE32 ; Izit USE32?
	 jz	 short @F	; Jump if not

	 or	 UNAMODE,@MODE_USE32 ; Mark as USE32
	 mov	 UNAMASK,0FFFFFFFFh ; ...
@@:

; Bump ARET pointers now that we have a new address

	 add	 ARETBASE,size ARET_STR ; Skip to next entry
	 dec	 ARET_CNT	; Count out another one

	 or	 LCL_FLAG,@LCL_REDI ; Mark as forced re-display of screen

;;;;;;;; jmp	 SWATTER_REDISP ; Join common re-display code

SWATTER_AGOTO_ERR:
	 jmp	 SWATTER_REDISP ; Join common re-display code


; Return from an address

SWATTER_ARET:

; Ensure no underflow

	 cmp	 ARET_CNT,@ARET_CNT ; Izit at the maximum?
	 jae	 short SWATTER_ARET_ERR ; Jump if so

; Bump ARET pointers now that we have an old address

	 inc	 ARET_CNT	; Count in another one
	 sub	 ARETBASE,size ARET_STR ; Skip to previous entry

; Restore old values for UNAOFF, UNASEL, and UNABASE

	 mov	 esi,ARETBASE	; DS:ESI ==> offset into ARET table

	 mov	 eax,DGROUP:[esi].ARET_FVEC.FOFF ; Get old value
	 mov	 UNAOFF,eax	; Save as offset of top instr
	 mov	 ax,DGROUP:[esi].ARET_FVEC.FSEL ; Get old value
	 mov	 UNASEL,ax	; Save as segment of top instr

	 mov	 ax,DGROUP:[esi].ARET_MODE ; Get old value
	 mov	 UNAMODE,ax	; Save as mode
	 mov	 eax,DGROUP:[esi].ARET_MASK ; Get old value
	 mov	 UNAMASK,eax	; Save as mask
	 mov	 eax,DGROUP:[esi].ARET_BASE ; Get old value
	 mov	 UNABASE,eax	; Save as base address of top instr

	 or	 LCL_FLAG,@LCL_REDI ; Mark as forced re-display of screen

;;;;;;;; jmp	 SWATTER_REDISP ; Join common re-display code

SWATTER_ARET_ERR:
	 jmp	 SWATTER_REDISP ; Join common re-display code


SWATTER_SIGINT:
	 mov	 edx,LaSIGINT_BP ; Get linear address of SIGINT breakpoint

	 jmp	 short SWATTER_SKIP1 ; Join common code

; Put a breakpoint interrupt (0CCh) at caller's CS:EIP unless the first
; instruction is a jump of any kind (JMP, Jcc, etc.)

SWATTER_SKIP:
	 call	 CHECK_JMPRET	; Check for jump/return instructions
	 jc	 near ptr SWATTER_TRACE ; Trace it instead

	 mov	 edx,NEXT_INSTR ; Get linear address of next instruction
SWATTER_SKIP1:
	 mov	 al,@OPCOD_INT3 ; Breakpoint interrupt
	 xchg	 al,AGROUP:[edx] ; Swap with the data

	 cmp	 AGROUP:[edx].LO,@OPCOD_INT3 ; Did it take?
	 jne	 short SWATTER_SKIPOUT ; Jump if not

	 mov	 BREAKPT_PTR,edx ; Save the offset
	 mov	 BREAKPT_VAL,al ; Save to restore the next time

; Note that breakpoint address may be invalid over an instruction or
; routine which enables paging *FIXME*

	 jmp	 SWATTER_XTF	; Join common trap flag clear code

; The breakpoint was into ROM and did not stick,
; try using a temporary code breakpoint instead.

SWATTER_SKIPOUT:
;;;;;;;; mov	 edx,?? 	; Get breakpoint address (already set)
	 mov	 eax,SAVE_DR7	; Get the Debug Control register

	 mov	 ecx,(mask $G0 or mask $L0) ; Initialize DR7 (Gn/Ln) mask
	 mov	 esi,(mask $LEN0 or mask $RW0) ; Initialize DR7 (Len,R/W) mask
				; Assume DR0 will be used

	 test	 eax,ecx	; Is DR0 in use?
	 jz	 short SWATTER_ROMREG0 ; Jump if available

	 shl	 ecx,(width $L0) + (width $G0) ; Assume DR1 will be used
	 shl	 esi,(width $LEN0) + (width $RW0) ; Assume DR1 will be used

	 test	 eax,ecx	; Is DR1 in use?
	 jz	 short SWATTER_ROMREG1 ; Jump if available

	 shl	 ecx,(width $L0) + (width $G0) ; Assume DR2 will be used
	 shl	 esi,(width $LEN0) + (width $RW0) ; Assume DR2 will be used

	 test	 eax,ecx	; Is DR2 in use?
	 jz	 short SWATTER_ROMREG2 ; Jump if so available

	 shl	 ecx,(width $L0) + (width $G0) ; Assume DR3 will be used
	 shl	 esi,(width $LEN0) + (width $RW0) ; Assume DR3 will be used

	 test	 eax,ecx	; Is DR3 in use?
	 jnz	 short SWATTER_XROMREG ; Jump if not available

SWATTER_ROMREG3:
	 mov	 ebx,dr3	; Save old linear address
	 mov	 dr3,edx	; Set breakpoint at next instr

	 jmp	 SWATTER_ROMREG ; Join common code

SWATTER_ROMREG2:
	 mov	 ebx,dr2	; Save old linear address
	 mov	 dr2,edx	; Set breakpoint at next instr

	 jmp	 SWATTER_ROMREG ; Join common code

SWATTER_ROMREG1:
	 mov	 ebx,dr1	; Save old linear address
	 mov	 dr1,edx	; Set breakpoint at next instr

	 jmp	 SWATTER_ROMREG ; Join common code

SWATTER_ROMREG0:
	 mov	 ebx,dr0	; Save old linear address
	 mov	 dr0,edx	; Set breakpoint at next instr

;;;;;;;; jmp	 SWATTER_ROMREG ; Join common code

SWATTER_ROMREG:

; Save orig DR7 (Len, R/W bits)

	 mov	 eax,esi	; Get DR7 (Len,R/W) mask
	 and	 eax,SAVE_DR7	; Get orig DR7 bits corresponding to our DRn
	 mov	 ROMSKIP_DR7,eax ; Save old DR7 value (Len + R/W)

; Enable beakpoint as CODE, Length=0

	 not	 esi		; Negate DR7 mask
	 and	 SAVE_DR7,esi	; Ensure breakpoint is type CODE, Len=0

; Save orig DRn linear address

	 mov	 ROMSKIP_DRN,ebx ; Save original DR(0-4) linear address

; Save new DR7 (Gn,Ln bits)

	 mov	 ROMSKIP_MASK,ecx ; Save DR7 (Gn,Ln) breakpoint mask

; Enable the available DRn register through DR7

	 or	 SAVE_DR7,ecx	; Enable the available DRn register

	 jmp	 SWATTER_XTF	; Join common trap flag clear code

SWATTER_XROMREG:

; Tell 'em you can't write into ROM

	 mov	 MSGOFF,offset DGROUP:ROMERR ; Save offset of error message
	 or	 LC2_FLAG,mask $LC2_MSG ; Mark as message to display

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Convert the instruction at the top of the screen to NOPs

SWATTER_ZAP:
	 mov	 ecx,INSTRLDN	; Length of instruction at top of screen
	 mov	 eax,FIRST_INSTR ; Get linear address of top instr
@@:
	 mov	 AGROUP:[eax].LO,@OPCOD_NOP ; Convert byte to NOP
	 inc	 eax		; Move to next byte

	 loops	 @B		; Fil in another NOP byte

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Display the help screen

SWATTER_HELP:
	 call	 DISP_HELP	; Display it
	 call	 GETKEY 	; Get and discard a keystroke

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Display the GDT

SWATTER_GDT:
	 mov	 al,@DSP_GDT	; Screen state is GDT
	 mov	 DSP_STATE,al	; Set primary state
	 mov	 DSP_STAT2,al	; ... secondary ...

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Display the IDT

SWATTER_IDT:
	 mov	 al,@DSP_IDT	; Screen state is IDT
	 mov	 DSP_STATE,al	; Set primary state
	 mov	 DSP_STAT2,al	; ... secondary ...

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Display the LDT

SWATTER_LDT:
	 mov	 al,@DSP_LDT	; Screen state is LDT
	 mov	 DSP_STATE,al	; Set primary state
	 mov	 DSP_STAT2,al	; ... secondary ...

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Display the TSS

SWATTER_TSS:
	 mov	 al,@DSP_TSS	; Screen state is TSS
	 mov	 DSP_STATE,al	; Set primary state
	 mov	 DSP_STAT2,al	; ... secondary ...

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Display the PTEs

SWATTER_PTE:

; If paging is disabled, signal an error

	 mov	 eax,cr0	; Get control register

	 test	 eax,mask $PG	; Check for paging enabled
	 jz	 short SWATTER_XPAGE ; Jump if not

	 mov	 al,@DSP_PTE	; Screen state is PTE
	 mov	 DSP_STATE,al	; Set primary state
	 mov	 DSP_STAT2,al	; ... secondary ...

	 jmp	 SWATTER_REDISP ; Join common re-display code

SWATTER_XPAGE:
	 mov	 MSGOFF,offset DGROUP:PAGERR ; Save offset of error message
	 or	 LC2_FLAG,mask $LC2_MSG ; Mark as message to display

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Display the search screen

SWATTER_SRCH:
	 mov	 al,@DSP_SRCH	; Screen state is search
	 mov	 DSP_STATE,al	; Set primary state
	 mov	 DSP_STAT2,al	; ... secondary ...

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Display the PDEs

SWATTER_PDE:

; If paging is disabled, signal an error

	 mov	 eax,cr0	; Get control register

	 test	 eax,mask $PG	; Check for paging enabled
	 jz	 short SWATTER_XPAGE ; Jump if not

	 mov	 al,@DSP_PDE	; Screen state is PDE
	 mov	 DSP_STATE,al	; Set primary state
	 mov	 DSP_STAT2,al	; ... secondary ...

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Display symbol table

SWATTER_SYMTAB:
	 mov	 al,@DSP_SYMTAB ; Screen state is display symtab
	 mov	 DSP_STATE,al	; Set primary state
	 mov	 DSP_STAT2,al	; Set secondary "

	 jmp	 SWATTER_REDISP ; Join common re-display code

; Display file browser

SWATTER_FBROWS:
	 mov	 al,@DSP_FBROWS ; Screen state is display file browser
	 mov	 DSP_STATE,al	; Set primary state
	 mov	 DSP_STAT2,al	; Set secondary "
	 mov	 DSP_STAT3,@DSP_INSTR ; Ensure we don't re-enter browser

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Enter chat mode.  Ctrl-F8 again brings us back to Kansas

SWATTER_CHAT:
	 call	 CMD_CHAT	; Chat with remote SWAT user
	 call	 DISP_CMDLINE	; Re-display the command line

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Enter remote debugging session.  Ctrl-F9 brings us back.

SWATTER_REMDBG:
	 call	 CMD_REMDBG	; Hook up for remote debugging
	 call	 DISP_CMDLINE	; Re-display the command line

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Display error log

SWATTER_ERRLOG:
	 mov	 al,@DSP_ERRLOG ; Screen state is display error log
	 mov	 DSP_STATE,al	; Set primary state
	 mov	 DSP_STAT2,al	; Set secondary "

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Toggle the video base address

SWATTER_VBASE:
	 push	 PSCRBUF	; Pass address of screen buffer
	 call	 REST_SCR	; Restore the original screen

	 call	 FLIPVBASE	; Switch to other video base

	 push	 PSCRBUF	; Pass address of screen buffer
	 PUSHD	 1		; Use actual screen base
	 call	 SAVE_SCR	; Save all screen text

	 call	 DISP_CMDLINE	; Re-display the command line

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Swap screens unless DVGA specified

SWATTER_SCR:
	 test	 ARG_FLAG,@ARG_DVGA ; Izit specified?
	 jnz	 short SWATTER_SCR1 ; Jump if so

	 push	 PSCRBUF	; Pass address of screen buffer
	 call	 REST_SCR	; Restore the original screen

	 call	 REST_VMOD	; Restore video mode if different

	 call	 GETKEY 	; Get and discard a keystroke

	 call	 CHECK_VMOD	; Reset text mode if different

	 push	 CURPOSN	; Get new cursor position
	 call	 SET_CURPOS	; Set it

	 push	 CURTYPE	; Get new cursor type
	 call	 SET_CURTYP	; Set it

	 call	 DISP_CMDLINE	; Re-display the command line
SWATTER_SCR1:
	 jmp	 SWATTER_REDISP ; Join common re-display code


; Display last screen buffer

SWATTER_LSCR:
	 mov	 al,@DSP_LSCR	; Screen state is Last Screen
	 mov	 DSP_STATE,al	; Set primary state
	 mov	 DSP_STAT2,al	; ... secondary ...

	 jmp	 SWATTER_REDISP ; Join common re-display code


; Check for INT or any of the flag changing instructions such as
; POPF, POPFD, IRET, IRETD which might clear the trap flag

SWATTER_TRACE:
	 or	 [ebp].FORW_EFL.ELO,mask $TF ; Set the trap flag to trace

	 mov	 esi,CUR_INSTR ; Get linear address of cur instr
	 lods	 AGROUP:[esi].ELO ; Get the next two instruction bytes

	 mov	 esi,STACK_eSP	; Get caller's stack linear address

; Check for ARPL in VM86 mode

	 test	 [ebp].FORW_EFL.EHI,mask $VM ; Izit VM 8086 mode?
	 jz	 short @F	; Jump if not

	 cmp	 al,@OPCOD_ARPL ; Izit ARPL?
	 je	 near ptr SWATTER_TRACEARPL ; Yes, handle it specially
@@:

; Check for INT 0FFh in VM86 mode

	 test	 [ebp].FORW_EFL.EHI,mask $VM ; Izit VM 8086 mode?
	 jz	 short @F	; Jump if not

	 cmp	 ax,(0FFh shl 8) or @OPCOD_INT ; Izit INT 0FFh?
	 je	 near ptr SWATTER_TRACEINTFF ; Yes, handle it specially
@@:
	 cmp	 al,@OPCOD_INT	; Check for INT
	 je	 near ptr SWATTER_INT ; Good guess

	 cmp	 al,@OPCOD_INT3 ; Check for INT 03h
	 je	 near ptr SWATTER_INT3 ; Good guess

	 test	 [ebp].FORW_EFL.ELO,mask $OF ; Check overflow flag for INTO
	 jz	 short @F	; Jump if clear

	 cmp	 al,@OPCOD_INTO ; Check for INTO
	 je	 near ptr SWATTER_INTO ; Good guess
@@:

; Handle trace over far JMP/CALL which performs a task switch in PM

	 call	 CHECK_PMTSS	; Check for PM TSS task switch
	 jnc	 short SWATTER_TRACE_TSS ; Jump if so with BX = TSS selector

; Handle instruction meaning depending upon the D-bit

	 test	 CUR_INSTR_ARW.HI,mask $DTE_B ; Check for D-bit
	 jz	 short SWATTER_TRACE16 ; Jump if USE16
				       ; Fall through if USE32

	 cmp	 al,@OPCOD_POPF ; Check for POPF
	 je	 near ptr SWATTER_TRACEIT ; Good guess

	 cmp	 ax,@OPCOD_POPFD ; Check for POPFD
	 je	 short SWATTER_TRACEIT ; Good guess

	 add	 esi,2+2	; Skip over IP, CS if USE16 IRET

	 cmp	 ax,@OPCOD_IRETD ; Check for USE16 IRET
	 je	 short SWATTER_IRET ; Good guess

	 add	 esi,2+2	; Skip over EIP, CS, fill

	 cmp	 al,@OPCOD_IRET ; Check for USE32 IRET
	 je	 short SWATTER_IRET ; Good guess
SWATTER_LOADALLD:
	 cmp	 ax,@OPCOD_LOADALLD ; Check for LOADALLD
	 jne	 short @F	; Join common exit code

; Set trap flag in caller's ES:[EDI].LA32_EFL

	 mov	 eax,[ebp-@BPBACK].BACK_ES.DTR_BASE ; Get base of caller's ES
	 add	 eax,[ebp].FORW_EDI ; Plus EDI
	 or	 AGROUP:[eax].LA32_EFL.ELO,mask $TF ; Set TF in caller's EFL
@@:
	 jmp	 SWATTER_CLC	; Join common exit code

SWATTER_TRACE16:
	 cmp	 al,@OPCOD_POPF ; Check for POPF
	 je	 short SWATTER_TRACEIT ; Good guess

	 cmp	 ax,@OPCOD_POPFD ; Check for POPFD
	 je	 short SWATTER_TRACEIT ; Good guess

	 add	 esi,2+2	; Skip over IP, CS if USE16 IRET

	 cmp	 al,@OPCOD_IRET ; Check for USE16 IRET
	 je	 short SWATTER_IRET ; Good guess

	 add	 esi,2+2	; Skip over EIP, CS, fill

	 cmp	 ax,@OPCOD_IRETD ; Check for USE32 IRET
	 jne	 short SWATTER_LOADALLD ; No, check for LOADALLD

; We're about to trace over an IRET or IRETD
; If the NT bit is set, we must set the debug bit in the TSS_DBG flag
; and mark it to be cleared the next time unless it was already set

	 public  SWATTER_IRET
SWATTER_IRET:
	 test	 [ebp].FORW_EFL.EHI,mask $VM ; Izit VM 8086 mode?
	 jnz	 short SWATTER_TRACEIT ; Jump if so

	 test	 [ebp].FORW_EFL.ELO,mask $NT ; Izit NT mode?
	 jz	 short SWATTER_TRACEIT ; Jump if not

	 mov	 eax,[ebp-@BPBACK].BACK_TR.DTR_BASE ; Get base address of TSS
	 mov	 bx,AGROUP:[eax].TSS_LINK ; Get the back link TSS selector
SWATTER_TRACE_TSS:
	 push	 bx		; Pass the TSS selector
	 call	 GETBASE	; Return with EAX = selector base
	 jc	 near ptr SWATTER_CLC ; Jump if something went wrong

	 bts	 AGROUP:[eax].TSS_DBG,0 ; Set and test the debug bit
	 jc	 short @F	   ; Jump if already set

	 or	 LC2_FLAG,mask $LC2_TDB ; Tell SWATTER to clear it the next time
@@:
	 jmp	 SWATTER_XTF	; Join common trap flag clear code
				; so the EFL saved in the current TSS won't
				; have it set.
SWATTER_TRACEIT:
	 or	 AGROUP:[esi].ELO,mask $TF ; Ensure trap flag set

	 jmp	 SWATTER_CLC	; Join common exit code

COMMENT|

Trace through an ARPL instruction by going to the first instruction
in the PM Invalid Opcode handler.  This helps debugging in a Windows
context which uses ARPL to return to PM.

Note we're assuming that this interrupt # is handled by an interrupt,
trap, or 386 task gate.  We do *NOT* handle 286 task gates as yet.

|

SWATTER_TRACEARPL:
	 mov	 ebx,06h	; Set interrupt #

	 jmp	 SWATTER_INTPM1 ; Join common PM interrupt code

COMMENT|

Trace through an INT 0FFh instruction by going to the first
instruction in the PM INT 0FFh handler.  This helps debugging in a
DPMI context which uses this instruction to return to PM.

Note we're assuming that this interrupt # is handled by an interrupt,
trap, or 386 task gate.  We do *NOT* handle 286 task gates as yet.

|

SWATTER_TRACEINTFF:
	 mov	 ebx,0FFh	; Set interrupt #

	 jmp	 SWATTER_INTPM1 ; Join common PM interrupt code

COMMENT|

Simulate INT instruction

On entry:

AH	 =	 interrupt #
GS:ESI	 ==>	 caller's stack

|

SWATTER_INTO:
	 mov	 ah,04h 	; Use interrupt # 04h
	 mov	 ebx,1		; Instruction length

	 jmp	 short SWATTER_INT1 ; Join common code

SWATTER_INT3:
	 mov	 ah,03h 	; Use interrupt # 03h
	 mov	 ebx,1		; Instruction length

	 jmp	 short SWATTER_INT1 ; Join common code

SWATTER_INT:
	 mov	 ebx,2		; Instruction length
SWATTER_INT1:
	 test	 [ebp].FORW_EFL.EHI,mask $VM ; VM 8086 or protected mode?
	 jz	 near ptr SWATTER_INTPM ; Jump if protected mode

; INT/INTO instruction in VM86 mode

; Calculate IRET_VEC

	 test	 LCL_FLAG,@LCL_IRET ; Izit already calculated?
	 jnz	 short SWATTER_INT_XIRET ; Jump if so

	 REGSAVE <ax,ecx,edi,es> ; Save for a moment

	 push	 gs		; Get all memory selector
	 pop	 es		; Address it
	 assume  es:nothing	; Tell the assembler about it

	 mov	 edi,0F0000h	; Get start of ROM
	 mov	 al,@OPCOD_IRET ; Opcode for an IRET
	 mov	 ecx,CON64KB	; We know it's there
   repne scas	 es:[edi].LO	; Search for it
;;;;;;;; jne	 ???		; It can't fail

	 sub	 edi,0F0001h	; Convert to origin-0
	 mov	 IRET_VEC.VOFF,di ; Save for later use
	 mov	 IRET_VEC.VSEG,0F000h ; Set segment address

	 or	 LCL_FLAG,@LCL_IRET ; Mark as calculated

	 REGREST <es,edi,ecx,ax> ; Restore
	 assume  es:DGROUP	; Tell the assembler about it
SWATTER_INT_XIRET:

IRETX_STR struc

IRET1_IP dw	 ?		; IRET in F000 ROM
IRET1_CS dw	 ?
IRET1_FL dw	 ?
IRET2_IP dw	 ?		; INT address from 0:0
IRET2_CS dw	 ?
IRET2_FL dw	 ?

IRETX_STR ends

COMMENT|

Register usage:

AH	 =	 interrupt #
EBX	 =	 instruction length (1 or 2)
GS:ESI	 ==>	 caller's stack

|

	 sub	 [ebp].FORW_ESP.ELO,size IRETX_STR ; Make room for IP, CS, and FL twice

; Note that the middle instruction in the three below must subtract
; from SI, not ESI as we're emulating the 64KB segment wrap.

	 sub	 esi,[ebp-@BPBACK].BACK_SS.DTR_BASE ; Convert to offset
	 sub	 si,size IRETX_STR ; Back off from linear address, too
	 add	 esi,[ebp-@BPBACK].BACK_SS.DTR_BASE ; Convert to linear address

	 movzx	 eax,ah 	; Copy interrupt #

	 assume  gs:INTVEC	; Address the RM IDT (not the redirected IDT)
	 mov	 eax,INT00_VEC[eax*(type INT00_VEC)] ; Get the INT's Seg:Off
	 assume  gs:AGROUP	; Restore the truth
	 mov	 AGROUP:[esi].IRET1_IP.EDD,eax ; Save on stack

	 mov	 eax,IRET_VEC	; Get segment:offset of an IRET
	 xchg	 ax,[ebp].FORW_EIP.ELO ; Swap IP
	 add	 ax,bx		; Skip over INT instruction
	 mov	 AGROUP:[esi].IRET2_IP,ax ; Save on stack

	 shr	 eax,16 	; Shift down segment
	 mov	 [ebp-@BPBACK].BACK_CS.DTR_LIM,ax ; Save for later use
	 xchg	 ax,[ebp].FORW_CS ; Swap CS
	 mov	 AGROUP:[esi].IRET2_CS,ax  ; Save on stack

	 mov	 ax,[ebp].FORW_EFL.ELO ; Get FL
	 or	 ax,mask $TF	; Ensure trap flag set
	 and	 ax,not (mask $IF) ; Ensure IF clear
	 mov	 AGROUP:[esi].IRET1_FL,ax  ; Save on stack
	 mov	 AGROUP:[esi].IRET2_FL,ax ; Save on stack

	 jmp	 SWATTER_CLC	; Join common exit code

; INT instruction in protected mode

COMMENT|

Register usage:

AH	 =	 interrupt #
EBX	 =	 instruction length (1 or 2)
GS:ESI	 ==>	 caller's stack

Note we're assuming that this interrupt # is handled by an interrupt,
trap, or 386 task gate.  We do *NOT* handle 286 task gates as yet.

|

SWATTER_INTPM:
	 movzx	 ebx,ah 	; Copy interrupt #
SWATTER_INTPM1:

; If it's INT 01h or 03h, we must not trace into it

	 cmp	 ebx,01h	; Izit INT 01h?
	 je	 near ptr SWATTER_CLC ; Jump if so

	 cmp	 ebx,03h	; Izit INT 03h?
	 je	 near ptr SWATTER_CLC ; Jump if so

	 mov	 ecx,[ebp-@BPBACK].BACK_IDT.DTR_BASE ; Get IDTR base
	 mov	 dx,AGROUP:[ecx+ebx*(type IDT_STR)].IDT_OFFHI ; Get high-order word of address
	 shl	 edx,16 	; Shift to high-order
	 mov	 dx,AGROUP:[ecx+ebx*(type IDT_STR)].IDT_OFFLO ; Get low-order ...

	 mov	 bx,AGROUP:[ecx+ebx*(type IDT_STR)].IDT_SELECT ; Get selector

	 push	 bx		; Get selector
	 call	 GETARW 	; Return with AX = access rights word

	 test	 al,mask $DT_DC ; Izit code/data?
	 jnz	 short @F	; Jump if so (not TSS)

	 test	 al,mask $DT_P	; Izit present?
	 jz	 short @F	; Jump if not (who cares?)

	 and	 al,not (mask $DT_DPL) ; Clear DPL bits

	 cmp	 al,CPL0_IDLE3	; Izit an idle 386 TSS?
	 je	 near ptr SWATTER_TRACE_TSS ; Jump if so with BX = TSS selector
@@:
	 push	 bx		; Pass selector
	 call	 GETBASE	; Return with EAX = selector base

	 add	 edx,eax	; Add base into offset

	 jmp	 SWATTER_SKIP1	; Join common skip code


SWATTER_CTLESC:
	 mov	 eax,CUR_INSTR	; Get linear address of current instruction

	 cmp	 AGROUP:[eax].LO,@OPCOD_INT3 ; Izit an INT 03h?
	 jne	 short SWATTER_ESC ; Jump if not

	 test	 CUR_INSTR_ARW.HI,mask $DTE_B ; Check for D-bit
	 jz	 short @F	; Jump if USE16

	 inc	 [ebp].FORW_EIP ; Increment USE32 EIP

	 jmp	 short SWATTER_ESC ; Join common code

@@:
	 inc	 [ebp].FORW_EIP.ELO ; Increment USE16 IP
SWATTER_ESC:

; See if the current instruction matches a code breakpoint
; Note that there's a slight chance that we'll miss a breakpoint
; if the current instruction is in BCDATA, we then trace it, but
; an interrupt occurs at that time.  In this case, if the user
; has requested a breakpoint in the interrupt handler, we won't
; have enabled it as yet.

	 call	 CHECK_BCVAL	; Check 'em
	 jnc	 short @F	; Jump if it didn't match

	 or	 LC2_FLAG,mask $LC2_BCT ; Mark as BC trace in effect

	 jmp	 SWATTER_TRACE	; Trace the instruction instead

@@:

; Install any previous breakpoint values

	 call	 INST_BCVAL	; Install 'em

	 and	 [ebp].FORW_EFL.ELO,not (mask $TF) ; Clear the trap flag
	 cli			; Disallow interrupts

	 pop	 RETFL		; Save SWATTER caller's flags
	 or	 RETFL,mask $CF ; Tell the caller to stop single-stepping

	 jmp	 short SWATTER_EXIT ; Join common exit code

SWATTER_XTF:
	 and	 [ebp].FORW_EFL.ELO,not (mask $TF) ; Clear the trap flag
SWATTER_CLC:
	 cli			; Disallow interrupts

	 pop	 RETFL		; Save SWATTER caller's flags
	 and	 RETFL,not (mask $CF) ; Tell the caller to continue single-stepping

; See if the current instruction matches a code breakpoint
; Note that there's a slight chance that we'll miss a breakpoint
; if the current instruction is in BCDATA, we then trace it, but
; an interrupt occurs at that time.  In this case, if the user
; has requested a breakpoint in the interrupt handler, we won't
; have enabled it as yet.

	 test	 LC2_FLAG,mask $LC2_BCT ; Izit already in effect (from ESC)?
	 jnz	 short @F	; Jump if so

	 call	 CHECK_BCVAL	; Check 'em
	 jc	 short @F	; Jump if it matches current instruction

; Install any previous breakpoint values

	 call	 INST_BCVAL	; Install 'em
@@:
SWATTER_EXIT:

; Clear exit flag (set by remote SWAT)

	 and	 LC3_FLAG,not @LC3_EXITSWAT ; Turn off Esc

; Re-save segment register values into FORW_STR if in VM86 mode

	 test	 [ebp].FORW_EFL.EHI,mask $VM ; Izit VM 8086 mode?
	 jz	 short SWATTER_PM3 ; Not this time

	 mov	 ax,[ebp-@BPBACK].BACK_CS.DTR_LIM ; Get new CS
	 mov	 [ebp].FORW_CS,ax ; Save in caller's registers
	 mov	 OLDCS,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_DS.DTR_LIM ; Get new DS
	 mov	 [ebp].FORW_DS,ax ; Save in caller's registers
	 mov	 OLDDS,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_ES.DTR_LIM ; Get new ES
	 mov	 [ebp].FORW_ES,ax ; Save in caller's registers
	 mov	 OLDES,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_FS.DTR_LIM ; Get new FS
	 mov	 [ebp].FORW_FS,ax ; Save in caller's registers
	 mov	 OLDFS,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_GS.DTR_LIM ; Get new GS
	 mov	 [ebp].FORW_GS,ax ; Save in caller's registers
	 mov	 OLDGS,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_SS.DTR_LIM ; Get new SS
	 mov	 [ebp].FORW_SS,ax ; Save in caller's registers
	 mov	 OLDSS,ax	; Save for next time

	 jmp	 SWATTER_PM4	; Join common code

; Protected mode

SWATTER_PM3:
	 test	 LC2_FLAG,@LC2_TSS ; Izit TSS mode?
	 jnz	 short SWATTER_TSS2 ; Yes, handle specially

	 mov	 ax,[ebp-@BPBACK].BACK_DS.DTR_LIM ; Get new DS
	 mov	 [esp].ESP_DS,ax ; Save in caller's registers
	 mov	 OLDDS,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_ES.DTR_LIM ; Get new ES
	 mov	 [esp].ESP_ES,ax ; Save in caller's registers
	 mov	 OLDES,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_FS.DTR_LIM ; Get new FS
	 mov	 [esp].ESP_FS,ax ; Save in caller's registers
	 mov	 OLDFS,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_GS.DTR_LIM ; Get new GS
	 mov	 [esp].ESP_GS,ax ; Save in caller's registers
	 mov	 OLDGS,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_CS.DTR_LIM ; Get new CS
;;;;;;;; mov	 [ebp].FORW_CS,ax ; Save in caller's registers (already the same)
	 mov	 OLDCS,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_SS.DTR_LIM ; Get new SS
	 mov	 OLDSS,ax	; Save for next time

	 jmp	 short SWATTER_PM4 ; Join common code

; TSS mode

SWATTER_TSS2:
	 mov	 ax,[ebp-@BPBACK].BACK_CS.DTR_LIM ; Get new CS
	 mov	 [ebp].FORW_CS,ax ; Save in caller's registers
	 mov	 OLDCS,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_DS.DTR_LIM ; Get new DS
	 mov	 [ebp].FORW_DS,ax ; Save in caller's registers
	 mov	 OLDDS,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_ES.DTR_LIM ; Get new ES
	 mov	 [ebp].FORW_ES,ax ; Save in caller's registers
	 mov	 OLDES,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_FS.DTR_LIM ; Get new FS
	 mov	 [ebp].FORW_FS,ax ; Save in caller's registers
	 mov	 OLDFS,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_GS.DTR_LIM ; Get new GS
	 mov	 [ebp].FORW_GS,ax ; Save in caller's registers
	 mov	 OLDGS,ax	; Save for next time

	 mov	 ax,[ebp-@BPBACK].BACK_SS.DTR_LIM ; Get new SS
	 mov	 [ebp].FORW_SS,ax ; Save in caller's registers
	 mov	 OLDSS,ax	; Save for next time
SWATTER_PM4:
	 mov	 eax,[ebp].FORW_EAX ; Get current EAX
	 mov	 OLDEAX,eax	; Save for next time
	 mov	 eax,[ebp].FORW_EBX ; Get current EBX
	 mov	 OLDEBX,eax	; ...
	 mov	 eax,[ebp].FORW_ECX ; Get current ECX
	 mov	 OLDECX,eax	; ...
	 mov	 eax,[ebp].FORW_EDX ; Get current EDX
	 mov	 OLDEDX,eax	; ...
	 mov	 eax,[ebp].FORW_ESI ; Get current ESI
	 mov	 OLDESI,eax	; ...
	 mov	 eax,[ebp].FORW_EDI ; Get current EDI
	 mov	 OLDEDI,eax	; ...
	 mov	 eax,[ebp].FORW_EBP ; Get current EBP
	 mov	 OLDEBP,eax	; ...
	 mov	 eax,[ebp].FORW_ESP ; Get current ESP
	 mov	 OLDESP,eax	; ...
	 mov	 eax,[ebp].FORW_EIP ; Get current EIP
	 mov	 OLDEIP,eax	; ...
	 mov	 eax,[ebp].FORW_EFL ; Get current EFL
	 mov	 OLDEFL,eax	; ...
	 mov	 eax,cr0	    ; Get current CR0

; If we're device SWAT, and the $VM bit is set, clear the $PE bit
; as we're not really in PM.

	 test	 DEVLOAD,@DEVL_LOAD ; Izit device load?
	 jz	 short @F	; Jump if not

	 test	 eax,mask $VMHI ; Izit VM 8086 mode?
	 jz	 short @F	; Jump if not

	 and	 eax,not (mask $PE) ; PE=0
@@:
	 mov	 OLDCR0,eax	; ...
	 mov	 eax,cr2	    ; Get current CR2
	 mov	 OLDCR2,eax	; ...

	 test	 SWATINI.MD_ATTR,@MD_WIN3 ; Running under Windows?
	 jz	 short @F	; Not this time

	 mov	 eax,CUR_VM_HANDLE	; Get current Cur_VM_Handle
	 mov	 OLD_CUR_VM_HANDLE,eax	; Save for next time
@@:
	 or	 [ebp].FORW_EFL.EHI,mask $RF ; Ensure resume set in case DRs

; Restore the IRQ-specific interrupt handlers

	 cmp	 REENTRY,1	; Check re-entry level
	 jne	 short @F	; Jump if we're re-entering

	 call	 REST_IRQS	; Restore original IRQ-specific interrupt
				; handlers
@@:

; Save the contents of the current screen to display as last screen

	 test	 LC3_FLAG,@LC3_NOLASTSCR ; Are we saving screens?
	 jnz	 short SWATTER_XSAVESCR ; Jump if not

	 mov	 ebx,PLSTBUF_IND ; Get last screen buffer table index
	 inc	 ebx		; Skip to next last screen buffer

	 cmp	 ebx,NLSTBUF	; Izit out of range?
	 jb	 short @F	; Jump if not

	 xor	 ebx,ebx	; Start again at zero
@@:
	 mov	 PLSTBUF_IND,ebx ; Save for next time

	 mov	 eax,PPLSTBUF_TAB ; Get ptr to last screen buffer table
	 push	 DGROUP:[eax+ebx*(type PLSTBUF_STR)].PLSTBUF ; Pass address of last screen buffer
	 PUSHD	 0		; Use VIDBASE
	 call	 SAVE_SCR	; Save all screen text
SWATTER_XSAVESCR:

; Reset the last screen count so we start at the same point each time

	 mov	 LSCR_CNT,0	; Reset it

	 and	 LCL_FLAG,not @LCL_MSG ; Clear error message flag

; Restore the screen unless asked not to

	 test	 LCL_FLAG,@LCL_SCRN ; Screen restore disabled?
	 jnz	 short @F	; Yes, don't restore it

	 push	 PSCRBUF	; Pass address of screen buffer
	 call	 REST_SCR	; Restore all screen text
@@:

; Switch to original VGA screen if specified

	 test	 ARG_FLAG,@ARG_DVGA ; Izit present?
	 jz	 short @F	; Jump if not

	 call	 DVGASEL0	; Select original VGA screen
@@:
	 call	 REST_VMOD	; Restore video mode if different

	 call	 REST_IMR	; Restore IMR to original value

	 REGREST <gs,fs,es,ds>	; Restore
	 assume  ds:nothing,es:nothing ; Tell the assembler about it
	 assume  fs:nothing,gs:nothing ; Tell the assembler about it

	 mov	 esp,ebp	; Strip off structure

	 popad			; Restore

; Decrement the re-entry count

	 REGSAVE <eax,ds>	; Save for a moment

	 SETDATA ds		; Set data selector into DS
	 assume  ds:DGROUP	; Tell the assembler about it

	 REGREST <REG_EAXDS.EDQHI,REG_EAXDS.EDQLO> ; Save to restore later

	 dec	 REENTRY	; Reduce the re-entry counter
	 jnz	 near ptr SWATTER_XSTK2 ; Jump if we're re-entering

; Switch to caller's stack and copy EIP, CS, and EFL unless we're re-entering

	 mov	 eax,[esp].DI_EFL ; Get caller's flags
	 xor	 ax,ax		; In case we're coming from VM86 mode

	 test	 eax,@VMTSS	; Izit VM86 mode?
	 jnz	 short @F	; Jump if so

	 mov	 ax,[esp].DI_CS ; Get caller's RPL into $PL

	 test	 LC2_FLAG,@LC2_TSS ; Izit TSS mode?
	 jz	 short @F	; Jump if not

	 or	 eax,@VMTSS	; Mark as TSS mode
@@:
	 pop	 REG_RETEIP	; Save to restore later
	 pop	 REG_RETCSF
	 pop	 REG_EIP
	 pop	 REG_CSF
	 pop	 REG_EFL
	 pop	 REG_ESP	; Save to restore later
	 pop	 REG_SSF
	 pop	 REG_ESF
	 pop	 REG_DSF
	 pop	 REG_FSF
	 pop	 REG_GSF

; If in VM86 or TSS mode or a ring transition, restore stack from XPMSTK_FVEC

	 test	 eax,@VMTSSRT	; Izit VM86 or TSS mode or RPL > 0?
	 jz	 short SWATTER_PM5 ; Jump if not

	 lss	 esp,XPMSTK_FVEC ; Switch to caller's stack
	 assume  ss:nothing	; Tell the assembler about it

	 jmp	 short SWATTER_PM5A ; Join common code

SWATTER_PM5:
	 lss	 esp,REG_ESP.EDF ; Switch to caller's stack
	 assume  ss:nothing	; Tell the assembler about it
SWATTER_PM5A:

; If not in VM86 or TSS mode, skip selector register PUSHes

	 test	 eax,@VMTSS	; Izit VM86 or TSS mode?
	 jz	 short SWATTER_PM5B ; Jump if not

	 push	 REG_GSF	; Put onto caller's stack
	 push	 REG_FSF
	 push	 REG_DSF
	 push	 REG_ESF
SWATTER_PM5B:

; If we're in VM86 or TSS mode, or there was a ring transition,
; push the stack selector and offset

	 test	 eax,@VMTSSRT	; Izit VM86 or TSS mode or RPL > 0?
	 jz	 short SWATTER_PM5C ; Jump if not

	 push	 REG_SSF	; Put onto caller's stack
	 push	 REG_ESP
SWATTER_PM5C:
	 push	 REG_EFL	; Put onto caller's stack
	 push	 REG_CSF
	 push	 REG_EIP
	 push	 REG_RETCSF
	 push	 REG_RETEIP

; Restore caller's registers

SWATTER_XSTK2:

; Clear DR6 to avoid confusion next time

	 xor	 eax,eax	; A convenient zero
	 mov	 dr6,eax	; Clear it

; Restore original DR7

	 mov	 eax,SAVE_DR7	; Get original DR7
	 mov	 dr7,eax	; Restore it

	 push	 RETFL		; Put return flags onto the stack
	 popf			; ...and into the flags

	 lds	 eax,REG_EAXDS.EDF ; Restore 'em
	 assume  ds:nothing	; Tell the assembler about it

	 retfd			; Return to 32-bit caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

SWATTER  endp			; End SWATTER procedure
	 NPPROC  TOGGLE_TRP -- Toggle The @TRP_Ixx Bit
	 assume  ds:nothing,es:nothing,fs:nothing,gs:AGROUP,ss:nothing
COMMENT|

Toggle the @TRP_Ixx bit

|

TOGGLE_TRP_STR struc

	 dd	 ?		; Caller's EBP
	 dd	 ?		; ...	   EIP
TOGGLE_TRP_FLG dd ?		; @TRP_Ixx bit to toggle

TOGGLE_TRP_STR ends

	 push	 ebp		; Prepare to address the stack
	 mov	 ebp,esp	; Hello, Mr. Stack

	 REGSAVE <ax,ebx>	; Save registers

	 xor	 ebx,ebx	; Zero to use as dword
	 mov	 bx,seg PGROUP	; Get the (relocated) segment of RGROUP
	 shl	 ebx,4-0	; Convert from paras to bytes

	 mov	 ax,[ebp].TOGGLE_TRP_FLG.ELO ; Get the @TRP_Ixx flag

	 assume  gs:RGROUP	; Tell a white lie to get addressibility
	 xor	 TRP_FLAG[ebx],ax ; Toggle the bit
	 assume  gs:AGROUP	; Retract nose

	 REGREST <ebx,ax>	; Restore

	 pop	 ebp		; Restore

	 ret	 (type TOGGLE_TRP_FLG) ; Return to caller, popping argument

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

TOGGLE_TRP endp 		; End TOGGLE_TRP procedure
	 NPPROC  SET_STATE -- Set New State
	 assume  ds:DGROUP,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Set new state taking into account overlays

On entry:

AL	 =	 new state

|

	 REGSAVE <ax>		; Save register

	 mov	 ah,al		; Save new state
	 xchg	 al,DSP_STATE	; Save new state, copy old one

	 cmp	 al,@DSP_BC	; Were we displaying BC values?
	 je	 short @F	; Jump if so

	 cmp	 al,@DSP_DRn	; Were we displaying debug registers?
	 jne	 short SET_STATE1 ; Not this time
@@:
	 xchg	 al,DSP_STATE	; Restore old state
	 mov	 DSP_STAT2,al	; Mark as secondary state

	 jmp	 short SET_STATE_EXIT ; Join common exit code

SET_STATE1:
	 mov	 DSP_STAT2,ah	; Save as secondary state, too
SET_STATE_EXIT:
	 REGREST <ax>		; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

SET_STATE endp			; End SET_STATE procedure
	 NPPROC  CHECK_JMPRET -- Check for JMP/RET Instructions
	 assume  ds:DGROUP,es:DGROUP,fs:nothing,gs:AGROUP,ss:nothing
COMMENT|

Check for jump/return and ARPL instructions.

On exit:

CF	 =	 1 next instruction is a jump or return
	 =	 0 not

|

	 REGSAVE <ax,ebx>	; Save registers

	 mov	 ebx,CUR_INSTR ; Get linear address of cur instr

; Skip over segment overrides, LOCK, ASP, and OSP

CHECK_JMPRET_SEG:
	 inc	 ebx		; Assume override

	 cmp	 AGROUP:[ebx-1].LO,@OPCOD_CS ; Izit CS: ?
	 je	 short CHECK_JMPRET_SEG ; Jump if so

	 cmp	 AGROUP:[ebx-1].LO,@OPCOD_DS ; Izit DS: ?
	 je	 short CHECK_JMPRET_SEG ; Jump if so

	 cmp	 AGROUP:[ebx-1].LO,@OPCOD_ES ; Izit ES: ?
	 je	 short CHECK_JMPRET_SEG ; Jump if so

	 cmp	 AGROUP:[ebx-1].LO,@OPCOD_FS ; Izit FS: ?
	 je	 short CHECK_JMPRET_SEG ; Jump if so

	 cmp	 AGROUP:[ebx-1].LO,@OPCOD_GS ; Izit GS: ?
	 je	 short CHECK_JMPRET_SEG ; Jump if so

	 cmp	 AGROUP:[ebx-1].LO,@OPCOD_SS ; Izit SS: ?
	 je	 short CHECK_JMPRET_SEG ; Jump if so

	 cmp	 AGROUP:[ebx-1].LO,@OPCOD_LOCK ; Izit LOCK: ?
	 je	 short CHECK_JMPRET_SEG ; Jump if so

	 cmp	 AGROUP:[ebx-1].LO,@OPCOD_ASP ; Izit ASP: ?
	 je	 short CHECK_JMPRET_SEG ; Jump if so

	 cmp	 AGROUP:[ebx-1].LO,@OPCOD_OSP ; Izit OSP: ?
	 je	 short CHECK_JMPRET_SEG ; Jump if so

	 dec	 ebx		; Back off

	 mov	 ax,AGROUP:[ebx] ; Get the first two bytes of the instruction

; Check for change to SS

	 cmp	 al,@OPCOD_POPSS ; Izit POP SS?
	 je	 near ptr CHECK_JMPRET_TRACE ; Yes, trace it instead

	 cmp	 al,8Eh 	; Izit MOV Sreg,xx ?
	 jne	 short CHECK_JMPRET_IRET ; Not this time

	 shr	 ax,8		; Move MOD R/M byte to AL

	 and	 al,mask $REG	; Isolate segment register bits

	 cmp	 al,010b shl $REG ; Izit SS?
	 je	 near ptr CHECK_JMPRET_TRACE ; Yes, trace it instead

	 jmp	 CHECK_JMPRET_BP ; No, breakpoint OK

CHECK_JMPRET_IRET:

; Check for IRETs

	 cmp	 al,@OPCOD_IRET ; Izit an IRET?
	 je	 near ptr CHECK_JMPRET_TRACE ; Yes, trace it instead

; Check for RETs

	 cmp	 al,@OPCOD_RET	; Izit a near return?
	 je	 short CHECK_JMPRET_TRACE ; Yes, trace it instead

	 cmp	 al,@OPCOD_RETF ; Izit a far return?
	 je	 short CHECK_JMPRET_TRACE ; Yes, trace it instead

	 cmp	 al,@OPCOD_RETP ; Izit a near return with pop?
	 je	 short CHECK_JMPRET_TRACE ; Yes, trace it instead

	 cmp	 al,@OPCOD_RETFP ; Izit a far return with pop?
	 je	 short CHECK_JMPRET_TRACE ; Yes, trace it instead

; Check for JCXZ and JECXZ

	 cmp	 al,@OPCOD_JCXZ ; Izit JCXZ
	 je	 short CHECK_JMPRET_TRACE ; Yes, trace it instead

; Check for far jumps

	 cmp	 al,@OPCOD_JMPF ; Izit a far jump?
	 je	 short CHECK_JMPRET_TRACE ; Yes, trace it instead

; Check for short jumps

	 cmp	 al,@OPCOD_JMPS ; Izit a short jump?
	 je	 short CHECK_JMPRET_TRACE ; Yes, trace it instead

; Check for near jumps

	 cmp	 al,@OPCOD_JMPN ; Izit a near jump?
	 je	 short CHECK_JMPRET_TRACE ; Yes, trace it instead

; Check for Group 5 jumps

	 cmp	 al,@OPCOD_GRP5 ; Izit a Group 5 instruction?
	 je	 short CHECK_JMPRET_GRP5 ; Yes, handle separately

; Check for near conditional jumps

	 cmp	 al,@OPCOD_2ND	; Izit a secondary escape code?
	 je	 short CHECK_JMPRET_2ND ; Yes, handle separately

; Check for short conditional jumps

	 cmp	 al,70h 	; Izit a conditional jump?
	 jb	 short CHECK_JMPRET_BP ; No, too small

	 cmp	 al,7Fh 	; Izit a conditional jump?
	 jbe	 short CHECK_JMPRET_TRACE ; Yes, trace it instead

; Check for ARPL in VM86 mode

	 test	 [ebp].FORW_EFL.EHI,mask $VM ; Izit VM 8086 mode?
	 jz	 short @F	; Jump if not

	 cmp	 al,@OPCOD_ARPL ; Izit ARPL?
	 je	 short CHECK_JMPRET_TRACE ; Yes, trace it instead
@@:
	 jmp	 short CHECK_JMPRET_BP ; Join common breakpoint code

CHECK_JMPRET_GRP5:
	 shr	 ax,8		; Get next instruction byte
	 and	 al,mask $REG	; Isolate the secondary opcode bits

	 cmp	 al,100b shl $REG ; Check for JMP RM16 or JMP RM32
	 je	 short CHECK_JMPRET_TRACE ; Yes, trace it instead

	 cmp	 al,101b shl $REG ; Check for JMP M16:16 or JMP M16:32
	 je	 short CHECK_JMPRET_TRACE ; Yes, trace it instead

	 jmp	 short CHECK_JMPRET_BP ; Set breakpoint

CHECK_JMPRET_2ND:
	 cmp	 ah,80h 	; Izit a conditional jump?
	 jb	 short CHECK_JMPRET_BP ; No, too small

	 cmp	 ah,8Fh 	; Izit a conditional jump?
	 ja	 short CHECK_JMPRET_BP ; No, too large
CHECK_JMPRET_TRACE:
	 stc			; Indicate we should trace the instruction instead

	 jmp	 short CHECK_JMPRET_EXIT ; Join common exit code

CHECK_JMPRET_BP:
	 clc			; Indicate we can set a breakpoint
CHECK_JMPRET_EXIT:
	 REGREST <ebx,ax>	; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

CHECK_JMPRET endp		; End CHECK_JMPRET procedure
	 NPPROC  GET_LASTILEN -- Get Length of Previous Instruction Line
	 assume  ds:DGROUP,es:DGROUP,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Get length of previous instruction line

On entry:

EAX	 ==>	 instruction
SS:EBP	 ==>	 FORW_STR

On exit:

EAX	 =	 length of previous instruction line

|

	 REGSAVE <ebx,edx,esi,edi,fs> ; Save registers

	 mov	 edi,eax	; Copy to use later

	 push	 UNABASE	; Save base

	 test	 UNAMODE,@MODE_PHYS ; Izit in physical mode?
	 jz	 short @F	; Jump if not

	 push	 UNACR3 	; Pass new CR3 to use (if non-zero)
	 push	 UNABASE	; Pass base memory to use
	 push	 UNAOFF 	; Pass memory offset to use
	 call	 DISPPHYS	; Setup for physical memory display

	 mov	 UNABASE,eax	; Save as new base address
@@:

; Back off by the maximum instruction length plus some slop, and
; disassemble forwards until we meet or exceed EDI.
; Return EDI less the previous offset.

	 mov	 esi,edi	; Get offset of top instruction

	 mov	 fs,COMMON.FILE_4GB ; FS:ESI ==> caller's CS:EIP
	 assume  fs:AGROUP	; Tell the assembler about it

	 sub	 esi,UNABASE	; Less base address of top instr

	 sub	 esi,60 	; Slop for instruction synchronization
	 jae	 short @F	; Jump if no wrap

	 xor	 esi,esi	; Start at zero
@@:
	 add	 esi,UNABASE	; Plus base address of top instr

	 xor	 ebx,ebx	; Zero instruction base
GET_LASTILEN1:

; Disassemble the instruction at FS:ESI into ES:DI using EBX as an offset base

	 mov	 edx,esi	; Save current offset
	 push	 di		; Save for a moment

	 lea	 di,INSTROUT	; ES:DI ==> output line
	 call	 DISASSEMBLE	; Disassemble the next instruction
				; returning FS:ESI ==> next instruction
				; ...	    ES:DI  ==> next output byte
	 pop	 di		; Restore

	 cmp	 esi,edi	; Back where we started?
	 jb	 short GET_LASTILEN1 ; Not as yet

	 mov	 eax,edi	; Get offset of top instruction
	 sub	 eax,edx	; Subtract previous offset

	 test	 UNAMODE,@MODE_PHYS ; Izit in physical mode?
	 jz	 short @F	; Jump if not

	 call	 DISPVIRT	; Restore virtual mode display
@@:
	 pop	 UNABASE	; Restore

	 REGREST <fs,edi,esi,edx,ebx> ; Restore
	 assume  fs:nothing	; Tell the assembler about it

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

GET_LASTILEN endp		; End GET_LASTILEN procedure
	 NPPROC  GET_LASTPLEN -- Get Length of Previous Instruction Page
	 assume  ds:DGROUP,es:DGROUP,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Get length of previous instruction page

On entry:

SS:EBP	 ==>	 FORW_STR

On exit:

EAX	 =	 length of previous instruction page

|

GLP_STR  struc

		db 3 dup (?)	; Filler to keep stack dword-aligned
GLP_INSTRNLN	db ?		; INSTRNLN
GLP_FIRST_INSTR dd ?		; FIRST_INSTR
GLP_UNABASE	dd ?		; UNABASE
GLP_EBP 	dd ?		; Caller's EBP (==> FORW_STR)

GLP_STR  ends

	 push	 ebp		; Save for a moment
	 sub	 esp,(type GLP_STR)-(type GLP_EBP) ; Make room for structure on stack
	 mov	 ebp,esp	; Address it

	 REGSAVE <ebx,ecx,edx,esi,edi,fs> ; Save registers

	 push	 UNABASE	; Save base

	 test	 UNAMODE,@MODE_PHYS ; Izit in physical mode?
	 jz	 short @F	; Jump if not

	 push	 UNACR3 	; Pass new CR3 to use (if non-zero)
	 push	 UNABASE	; Pass base memory to use
	 push	 UNAOFF 	; Pass memory offset to use
	 call	 DISPPHYS	; Setup for physical memory display
@@:
	 mov	 al,INSTRNLN	; Get value
	 mov	 [ebp].GLP_INSTRNLN,al ; Save on stack

	 mov	 eax,FIRST_INSTR ; Get value
	 mov	 [ebp].GLP_FIRST_INSTR,eax ; Save on stack

	 mov	 eax,UNABASE	; Get value
	 mov	 [ebp].GLP_UNABASE,eax ; Save on stack

; Make room on the stack for INSTRNLN dwords

	 movzx	 ecx,[ebp].GLP_INSTRNLN ; Get # lines in instruction window
	 shl	 ecx,2-0	; Convert from dwords to bytes
	 sub	 esp,ecx	; Make room
	 shr	 ecx,2-0	; Convert from bytes to dwords

; Back off by the maximum instruction length plus some slop, and
; disassemble forwards until we meet or exceed FIRST_INSTR.
; Return FIRST_INSTR less the previous offset.

	 mov	 esi,[ebp].GLP_FIRST_INSTR ; Get linear address of top instr

	 mov	 fs,COMMON.FILE_4GB ; Get our all memory selector
	 assume  fs:AGROUP	; Tell the assembler about it

	 sub	 esi,[ebp].GLP_UNABASE ; Less base address of top instr

	 sub	 esi,200	; Slop for instruction synchronization
	 jae	 short @F	; Jump if no wrap

	 xor	 esi,esi	; Start at zero
@@:
	 add	 esi,[ebp].GLP_UNABASE ; Plus base address of top instr
	 xor	 ebx,ebx	; Zero instruction base
	 xor	 edx,edx	; Zero the index

; Disassemble the instruction at FS:ESI into ES:DI using EBX as an offset base

GET_LASTPLEN3:
	 mov	 eax,esi	; Copy linear address for later use
	 mov	 [esp+edx*4],eax ; Save current offset
	 lea	 di,INSTROUT	; ES:DI ==> output line
	 push	 ebp		; Save to address FORW_STR
	 mov	 ebp,[ebp].GLP_EBP ; SS:EBP ==> FORW_STR
	 call	 DISASSEMBLE	; Disassemble the next instruction
				; returning FS:ESI ==> next instruction
				; ...	    ES:DI  ==> next output byte
	 pop	 ebp		; Restore
	 inc	 edx		; Skip to next index

	 cmp	 cx,1		; Izit the last line?
	 je	 short GET_LASTPLEN4 ; Jump if so

; If this line is also a label, duplicate the offset
; on the stack structure of offsets

	 mov	 [esp+edx*4],eax ; Save current offset
	 call	 SYMHASH_SRCH	; Look for EAX in symbol hash table
				; Return with DGROUP:EAX ==> symbol record
	 jc	 short GET_LASTPLEN4 ; Jump if not found

	 dec	 cx		; Account for label line display
	 inc	 edx		; Skip to next index
GET_LASTPLEN4:
	 loops	 GET_LASTPLEN3	; Jump if more instructions to disassemble

	 cmp	 esi,[ebp].GLP_FIRST_INSTR ; Back where we started?
	 jae	 short GET_LASTPLEN_EXIT ; Yes

	 dec	 edx		; Back up one dword

; Move stack structure down one dword

	 mov	 edi,esp	; ES:EDI ==> destin

	 push	 esi		; Save for a moment

	 lea	 esi,[edi+4]	; SS:ESI ==> source
	 movzx	 ecx,[ebp].GLP_INSTRNLN ; Get # lines in instruction window
	 dec	 ecx		; Less one we're overwriting
S32  rep movs	 <es:[edi].EDD,ss:[esi].EDD> ; Move it down

	 pop	 esi		; Restore

	 mov	 cx,1		; Set for above loop

; If this line is also a label, duplicate the offset
; on the stack structure of offsets

	 mov	 [esp+edx*4],eax ; Save current offset
	 call	 SYMHASH_SRCH	; Look for EAX in symbol hash table
				; Return with DGROUP:EAX ==> symbol record
	 jc	 short GET_LASTPLEN3 ; Jump if not found

; Move stack structure down one dword

	 mov	 edi,esp	; ES:EDI ==> destin

	 push	 esi		; Save for a moment

	 lea	 esi,[edi+4]	; SS:ESI ==> source
	 movzx	 ecx,[ebp].GLP_INSTRNLN ; Get # lines in instruction window
	 dec	 ecx		; Less one we're overwriting
S32  rep movs	 <es:[edi].EDD,ss:[esi].EDD> ; Move it down

	 pop	 esi		; Restore

	 mov	 cx,1		; Set for above loop

	 jmp	 short GET_LASTPLEN3 ; Go around again

GET_LASTPLEN_EXIT:
	 mov	 eax,[ebp].GLP_FIRST_INSTR ; Get linear address of top instr
	 sub	 eax,[esp]	; Subtract previous offset

; Strip off the stack INSTRNLN dwords

	 movzx	 ecx,[ebp].GLP_INSTRNLN ; Get # lines in instruction window
	 shl	 ecx,2-0	; Convert from dwords to bytes
	 add	 esp,ecx	; Make room

	 test	 UNAMODE,@MODE_PHYS ; Izit in physical mode?
	 jz	 short @F	; Jump if not

	 call	 DISPVIRT	; Restore virtual mode display
@@:
	 pop	 UNABASE	; Restore base

	 REGREST <fs,edi,esi,edx,ecx,ebx> ; Restore
	 assume  fs:nothing	; Tell the assembler about it

	 add	 esp,(type GLP_STR)-(type GLP_EBP) ; Strip structure from the stack
	 pop	 ebp		; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

GET_LASTPLEN endp		; End GET_LASTPLEN procedure
	 NPPROC  GET_CURINSTR -- Get Current Instruction Offset
	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Get current instruction offset

On entry:

SS:EBP	 ==>	 FORW_STR

On exit:

EAX	 ==>	 current instruction

|

	 mov	 eax,[ebp].FORW_EIP ; EAX = caller's EIP
	 add	 eax,[ebp-@BPBACK].BACK_CS.DTR_BASE ; Plus caller's CS base

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

GET_CURINSTR endp		; End GET_CURINSTR procedure
	 NPPROC  SET_CURINSTR -- Set Current Instruction Disassembly Values
	 assume  ds:DGROUP,es:nothing,fs:nothing,gs:nothing,ss:nothing
COMMENT|

Set current instruction disassembly values.

On entry:

SS:EBP	 ==>	 FORW_STR

|

	 REGSAVE <eax,bx>	; Save registers

; If the current instruction is between FIRST_INSTR and LAST_INSTR
; inclusive, begin the display at FIRST_INSTR

	 call	 GET_CURINSTR	; Get linear address of current instruction
	 mov	 CUR_INSTR,eax	; Save for later use

	 cmp	 eax,FIRST_INSTR ; Check against first one
	 jb	 short SET_CURINSTR1 ; Jump if too small

	 cmp	 eax,LAST_INSTR ; Check against last one
	 jbe	 short SET_CURINSTR2 ; Jump if within range
SET_CURINSTR1:
	 mov	 FIRST_INSTR,eax ; Save as linear address of top instr
SET_CURINSTR2:
	 mov	 ax,[ebp-@BPBACK].BACK_CS.DTR_LIM ; Get caller's CS
	 mov	 UNASEL,ax	; Save as segment of top instr

	 mov	 eax,[ebp-@BPBACK].BACK_CS.DTR_BASE ; Get caller's CS base
	 mov	 UNABASE,eax	; Save as base address of top instr

	 mov	 eax,FIRST_INSTR ; Get linear address of top instr
	 sub	 eax,UNABASE	; Less base ...
	 mov	 UNAOFF,eax	; Save as offset of top instr

COMMENT|

If the code selector from the last time is different from now,
set stack width display to words if VM 8086 mode or B-bit in SS clear,
and to dwords otherwise

In particular,

* If we're in a different mode than last time, set the stack width.
* Otherwise, if we're now in PM and the code selector from last time
  is different from now, set the stack width.

|

	 mov	 bx,[ebp].FORW_CS ; Get current code segment/selector
	 xchg	 bx,OLDCS_STK	; Swap with previous code selector

; * If we're in a different mode than last time, set the stack width.

	 mov	 ax,@MODE_VM	; Assume we're now in VM 8086 mode

	 test	 [ebp].FORW_EFL.EHI,mask $VM ; Izit now VM 8086 mode?
	 jnz	 short @F	; Jump if so

	 xor	 ax,ax		; Mark as not
@@:
	 xor	 ax,UNAMODE	; Merge with previous mode

	 test	 ax,@MODE_VM	; Izit different?
	 jnz	 short SET_CURINSTR_STK ; Yes, set stack width

; * Otherwise, if we're now in PM and the code selector from last time
;   is different from now, set the stack width.

	 test	 [ebp].FORW_EFL.EHI,mask $VM ; Izit VM 8086 mode?
	 jnz	 short SET_CURINSTR_XSTK ; Yes, don't set stack width

	 cmp	 bx,[ebp].FORW_CS ; Izit the same?
	 je	 short SET_CURINSTR_XSTK ; Yes, don't set stack width
SET_CURINSTR_STK:
	 and	 LCL_FLAG,not @LCL_STKD ; Mark as displaying in words

	 test	 [ebp].FORW_EFL.EHI,mask $VM ; Izit VM 8086 mode?
	 jnz	 short SET_CURINSTR_XSTK ; Yes, leave stack width at words

	 push	 [ebp].FORW_SS	; Pass selector as argument
	 call	 GETARW 	; Return with AX = access rights word

	 test	 ah,mask $DTE_B ; Check for B-bit
	 jz	 short SET_CURINSTR_XSTK ; It's clear, so leave stack width at words

	 or	 LCL_FLAG,@LCL_STKD ; Mark as displaying in dwords
SET_CURINSTR_XSTK:

; Set Virtual or Protected Mode flag

	 mov	 ax,gs		; Assume VM 8086 mode
	 or	 UNAMODE,@MODE_VM ; Assume VM 8086 mode

	 test	 [ebp].FORW_EFL.EHI,mask $VM ; Izit VM 8086 mode?
	 jnz	 short @F	; Yes

	 and	 UNAMODE,not @MODE_VM ; It's PM
	 mov	 ax,UNASEL	; Get actual selector
@@:

; Set USE16 or USE32 flag

	 push	 ax		; Pass selector as argument
	 call	 GETARW 	; Return with AX = access rights word

	 test	 [ebp].FORW_EFL.EHI,mask $VM ; Izit VM 8086 mode?
	 jz	 short @F	; No, leave it alone

	 and	 ah,not (mask $DTE_B)	; VM 8086 mode is always USE16
@@:
	 mov	 CUR_INSTR_ARW,ax ; Save for later use
	 and	 UNAMODE,not @MODE_USE32 ; Assume it's USE16
	 mov	 UNAMASK,0000FFFFh ; ...

	 test	 ah,mask $DTE_B ; Check for B-bit
	 jz	 short @F	; Jump if USE16

	 or	 UNAMODE,@MODE_USE32 ; Mark as USE32
	 mov	 UNAMASK,0FFFFFFFFh ; ...
@@:
	 and	 UNAMODE,not @MODE_PHYS ; Mark as no longer PHYSICAL

	 REGREST <bx,eax>	; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

SET_CURINSTR endp		; End SET_CURINSTR procedure
	 NPPROC  DISP_LSCR -- Display Last Screens
	 assume  ds:DGROUP,es:DGROUP,fs:nothing,gs:AGROUP,ss:nothing
COMMENT|

Display last screens

|

	 REGSAVE <eax,ebx,ecx,edx,edi> ; Save registers

; Setup window descriptor for message display

	 xor	 dx,dx		; Zero high-order word for division
	 mov	 ax,MODOFF	; Get offset of mode line
	 mov	 cx,2*@NCOLS	; Get # char/attrs per line
	 div	 cx		; Divide to get row # of mode line
	 mov	 W_TMP.SROW,ax	; Start on mode line
	 mov	 W_TMP.SCOL,(@NCOLS-MSG_LASTLEN)/2-9 ; Centered
	 mov	 W_TMP.NROW,1	; # rows on message line
	 mov	 W_TMP.NCOL,MSG_LASTLEN ; # cols ...

; PLSTBUF_IND contains the index to "LastScreen-000".
; LSCR_CNT contains the # screens back we should display when requested
; to do so.  If that number is zero, we display -000, if it's one,
; we display -001, etc.

	 mov	 ebx,PLSTBUF_IND ; Get last screen buffer table index
	 mov	 eax,LSCR_CNT	; Initialize last screen counter

	 sub	 ebx,eax	; Back off that many screens
	 jnc	 short @F	; Jump if it's within range

	 add	 ebx,NLSTBUF	; Modulo NLSTBUF
@@:
	 mov	 ecx,PPLSTBUF_TAB ; Get ptr to last screen buffer table
	 push	 DGROUP:[ecx+ebx*(type PLSTBUF_STR)].PLSTBUF ; Pass address of last screen buffer
	 call	 REST_SCR	; Restore the original screen

; Display "Last-nnn" text from LSCR_CNT

;;;;;;;; mov	 eax,LSCR_CNT	; Initialize last screen counter (already in AX)
	 mov	 MSG_LAST0.ELO,'00' ; Ensure leading digits filled in
	 lea	 edi,MSG_LAST1	; ES:EDI ==> units digit

	 push	 @DEC_RIGHT	; Mark as right-justified
	 call	 DD2DEC 	; Convert EAX to decimal at ES:EDI

	 mov	 al,ERRATTR	; Get message line attribute
	 push	 ax		; Pass as attribute to smear
	 push	 offset DGROUP:MSG_LAST ; Pass address of message line
	 push	 offset DGROUP:W_TMP ; Pass address of window descriptor
	 call	 WPUT_CSA	; Output the characters, smear attribute

	 REGREST <edi,edx,ecx,ebx,eax> ; Restore

	 ret			; Return to caller

	 assume  ds:nothing,es:nothing,fs:nothing,gs:nothing,ss:nothing

DISP_LSCR endp			; End DISP_LSCR procedure

PROG	 ends			; End PROG segment

	 MEND	 SWATSTART	; End SWAT module
