head	0.53;
access;
symbols;
locks
	BlackPhantom:0.53
	BlackPhantom:0.7.0.1; strict;
comment	@;; @;


0.53
date	2002.05.13.03.00.48;	author BlackPhantom;	state Exp;
branches;
next	0.52;

0.52
date	2001.02.13.04.09.54;	author BlackPhantom;	state Exp;
branches;
next	0.51;

0.51
date	2001.02.12.02.23.02;	author BlackPhantom;	state Exp;
branches;
next	0.50;

0.50
date	2001.02.02.23.44.36;	author BlackPhantom;	state Exp;
branches;
next	0.49;

0.49
date	2001.01.19.19.25.00;	author BlackPhantom;	state Exp;
branches;
next	0.48;

0.48
date	2000.12.27.05.36.43;	author BlackPhantom;	state Exp;
branches;
next	0.47;

0.47
date	2000.11.19.00.48.14;	author BlackPhantom;	state Exp;
branches;
next	0.46;

0.46
date	2000.08.31.02.13.37;	author BlackPhantom;	state Exp;
branches;
next	0.45;

0.45
date	2000.08.15.23.51.37;	author BlackPhantom;	state Exp;
branches;
next	0.44;

0.44
date	2000.03.23.14.09.09;	author BlackPhantom;	state Exp;
branches;
next	0.43;

0.43
date	99.08.10.02.48.18;	author BlackPhantom;	state Exp;
branches;
next	0.42;

0.42
date	99.08.06.16.39.08;	author BlackPhantom;	state Exp;
branches;
next	0.41;

0.41
date	99.07.16.03.18.20;	author BlackPhantom;	state Exp;
branches;
next	0.40;

0.40
date	99.06.05.20.07.01;	author BlackPhantom;	state Exp;
branches;
next	0.39;

0.39
date	99.05.28.22.41.24;	author BlackPhantom;	state Exp;
branches;
next	0.38;

0.38
date	99.05.28.18.27.56;	author BlackPhantom;	state Exp;
branches;
next	0.37;

0.37
date	99.05.28.04.20.40;	author BlackPhantom;	state Exp;
branches;
next	0.36;

0.36
date	99.05.27.22.22.07;	author BlackPhantom;	state Exp;
branches;
next	0.35;

0.35
date	99.05.23.19.52.27;	author BlackPhantom;	state Exp;
branches;
next	0.34;

0.34
date	99.05.23.15.13.32;	author BlackPhantom;	state Exp;
branches;
next	0.33;

0.33
date	99.05.21.02.27.28;	author BlackPhantom;	state Exp;
branches;
next	0.32;

0.32
date	99.05.19.01.13.28;	author BlackPhantom;	state Exp;
branches;
next	0.31;

0.31
date	99.05.17.18.49.52;	author BlackPhantom;	state Exp;
branches;
next	0.30;

0.30
date	99.05.11.17.10.49;	author BlackPhantom;	state Exp;
branches;
next	0.29;

0.29
date	99.05.06.22.37.51;	author BlackPhantom;	state Exp;
branches;
next	0.28;

0.28
date	99.05.05.16.38.55;	author BlackPhantom;	state Exp;
branches;
next	0.27;

0.27
date	99.04.19.21.02.51;	author BlackPhantom;	state Exp;
branches;
next	0.26;

0.26
date	99.04.18.12.54.59;	author BlackPhantom;	state Exp;
branches;
next	0.25;

0.25
date	99.04.17.03.11.27;	author BlackPhantom;	state Exp;
branches;
next	0.24;

0.24
date	99.04.14.18.28.12;	author BlackPhantom;	state Exp;
branches;
next	0.23;

0.23
date	99.04.14.16.43.57;	author BlackPhantom;	state Exp;
branches;
next	0.22;

0.22
date	99.04.12.18.51.50;	author BlackPhantom;	state Exp;
branches;
next	0.21;

0.21
date	99.04.11.12.52.23;	author BlackPhantom;	state Exp;
branches;
next	0.20;

0.20
date	99.04.05.03.15.12;	author BlackPhantom;	state Exp;
branches;
next	0.19;

0.19
date	99.03.30.23.45.44;	author BlackPhantom;	state Exp;
branches;
next	0.18;

0.18
date	99.03.29.18.33.30;	author BlackPhantom;	state Exp;
branches;
next	0.17;

0.17
date	99.03.22.22.40.13;	author BlackPhantom;	state Exp;
branches;
next	0.16;

0.16
date	99.03.18.04.09.05;	author BlackPhantom;	state Exp;
branches;
next	0.15;

0.15
date	99.03.16.02.16.25;	author BlackPhantom;	state Exp;
branches;
next	0.14;

0.14
date	99.03.16.00.23.39;	author BlackPhantom;	state Exp;
branches;
next	0.13;

0.13
date	99.03.13.23.36.05;	author BlackPhantom;	state Exp;
branches;
next	0.12;

0.12
date	99.03.12.22.09.18;	author BlackPhantom;	state Exp;
branches;
next	0.11;

0.11
date	99.03.09.04.23.38;	author BlackPhantom;	state Exp;
branches;
next	0.10;

0.10
date	99.03.01.23.10.12;	author BlackPhantom;	state Exp;
branches;
next	0.9;

0.9
date	99.02.25.21.57.36;	author BlackPhantom;	state Exp;
branches;
next	0.8;

0.8
date	99.02.24.02.20.20;	author BlackPhantom;	state Exp;
branches;
next	0.7;

0.7
date	99.02.18.00.07.41;	author BlackPhantom;	state Exp;
branches
	0.7.0.1;
next	0.6;

0.6
date	99.02.17.17.01.48;	author BlackPhantom;	state Exp;
branches;
next	0.5;

0.5
date	99.02.10.04.40.20;	author BlackPhantom;	state Exp;
branches;
next	;

0.7.0.1
date	99.02.21.04.01.14;	author BlackPhantom;	state Exp;
branches;
next	;


desc
@Debugging primitive routines
@


0.53
log
@Last developed version
@
text
@;=============================================================================
;
;	This source code file is copyright (c) Vadim Drubetsky AKA the 
; Black Phantom. All rights reserved.
;
;	This source code file is a part of the Tripple-DOS project. Your use 
; of this source code must fully comply with the accompanying license file, 
; LICENSE.TXT. You must have this file enclosed with your Tripple-DOS copy in
; order for it to be legal.
;
;	In no event, except for when it is explicitly stated by the applicable 
; law, shall Vadim Drubetsky aka the Black Phantom be liable for any special,
; incidental, indirect, or consequential damages (including but not limited to
; profit loss, business interruption, loss of business information, or any 
; other pecuniary loss) arising out of the use of or inability to use 
; Tripple-DOS, even if he has been advised of the possibility of such damages.
;
;=============================================================================

;=============================================================================
;
;				DEBUG.ASM
;				---------
;
;	Kernel debugging procedures for Tripple-DOS.
;
;=============================================================================

.486p
	INCLUDE	DEBUG.INC
	INCLUDE	DEVICES.INC
	INCLUDE	DEF.INC
	INCLUDE	CORE.INC
	INCLUDE	X86.INC
	INCLUDE	PHLIB32.MCR

	EXTRN	AddExcTrap: near32
	EXTRN	GetScanCode: near32
	EXTRN	GetAsciiCode: near32
	EXTRN	PmGetStr32: near32
	EXTRN	PmClearRow: near32
	EXTRN	PmStrLen: near32
	EXTRN	PmAToHex: near32
	EXTRN	PmStrCmp: near32
	EXTRN	SaveClientRegs: near32
	EXTRN	RestoreClientRegs: near32
	EXTRN	DumpRegs: near32
	EXTRN	SimulateInt: near32
	EXTRN	PointerToLinear: near32
	EXTRN	LinearToPhysical: near32

	EXTRN	ExcEflags: dword
	EXTRN	ExcSeg: word
	EXTRN	ExcOffs: dword

	EXTRN	GdtBase: dword
	EXTRN	CurrLdtBase: dword

	EXTRN	QuitPm: byte
	EXTRN	Start32Esp: dword
	EXTRN	ExcNumber: dword


DATA	SEGMENT	PARA	PUBLIC	USE16	'DATA'
	PUBVAR		TraceFlag, DB, 0
	BkptFlag	DB	0
	MasterMask	DB	?
	SlaveMask	DB	?

; Flag is set when debugger is entered and removed at the IRET.
; Indicates that IRQ handler (kbd) is not to save registers.
	PUBVAR		DebugFlag, DB, 0

	DebuggeeRegs	REG_PACK	<>
	DebuggeeSregs	SREG_PACK	<>
	DbgEsp		DD		?	; Will keep ESP for callback.
	DbgExcNum	DD		?	; Keeps debug exception num.

	I3Here		DB		1
	DbgCommand	Dbg_COMMAND	<>

	CmdField	DB	100 DUP (?)

	CmdTbl		DB	"g", 0
			DB	"t", 0
			DB	"d", 0
			DB	"q", 0
			DB	"b", 0
			DB	"bp", 0
			DB	"phys", 0
			DB	"lin", 0
			DB	"i3here", 0
			DB	"log", 0
			DB	"attr", 0

	CmdValTbl	DB	Dbg_CMD_GO
			DB	Dbg_CMD_TRACE
			DB	Dbg_CMD_DUMP
			DB	Dbg_CMD_QUIT
			DB	Dbg_CMD_BOOT
			DB	Dbg_CMD_BKPT
			DB	Dbg_CMD_PHYS
			DB	Dbg_CMD_LIN
			DB	Dbg_CMD_I3HERE
			DB	Dbg_CMD_LOG
			DB	Dbg_CMD_ATTR
	DBG_COMMANDS	=	$ - offset CmdValTbl
DATA	ENDS

CODE32	SEGMENT	PARA	PUBLIC	USE32	'CODE'
ASSUME	CS:CODE32, DS:FLAT

;-----------------------------------------------------------------------------
;
;	Initializes debugging system (interrupt traps).
;
;-----------------------------------------------------------------------------
PUBLIC	InitDbg
InitDbg		PROC	near32
	
; Set Int3Callback callback.
	mov	eax, 03h		; Trap INT 3.
	mov	ecx, offset DebugCallback
	call	AddExcTrap

	mov	eax, 01h		; Trap INT 1.
	mov	ecx, offset DebugCallback
	call	AddExcTrap

	ret
InitDbg		ENDP


;-----------------------------------------------------------------------------
;
;	I:  DS:ESI -> command.
;
;	Parses debug command and fills command structure.
;
;	(!) DS = ES.
;	(!) Destroys all registers.
;
;-----------------------------------------------------------------------------
GetDbgCmd	PROC	USES eax ebx ecx edx esi edi
	mov	DbgCommand.Command, 0
	mov	DbgCommand.Sel, 0
	mov	DbgCommand.Offs, 0
	mov	DbgCommand.Param1, 0
	mov	DbgCommand.Param2, 0
	mov	DbgCommand.Param3, 0
	mov	DbgCommand.Param4, 0

; Get command string.
	mov	esi, offset CmdField
	mov	eax, 100
	mov	dh, COMMAND_ROW
	sub	dl, dl
	mov	bl, NORMAL_ATTR
	call	PmGetStr32

; Get command.
	call	skip_spaces

	mov	edi, esi
	call	skip_non_spaces
	mov	byte ptr [esi], 0	; Substitute ' ' with 0.

	mov	esi, offset CmdTbl
	mov	ecx, -DBG_COMMANDS
find_cmd:
	call	PmStrCmp
	je	cmd_found

	call	PmStrLen
	lea	esi, [esi+eax+1]
	inc	ecx
	jnz	find_cmd

no_cmd_err:
	mov	esi, edi
	call	skip_non_spaces
	mov	byte ptr [esi], ' '
	mov	DbgCommand.Command, -1
	jmp	end_get_cmd		; Error: no command found!

cmd_found:
	mov	esi, edi
	call	skip_non_spaces
	mov	byte ptr [esi], ' '
	mov	al, CmdValTbl[ ecx + DBG_COMMANDS ]
	mov	DbgCommand.Command, al
	call	skip_non_spaces

; Get address.
	call	skip_spaces

	mov	al, [esi]
	test	al, al
	jz	end_get_cmd

; Check if address is specified.
; If there is ':' separator, then address is specified.
	call	PmStrLen
	mov	edi, esi
	mov	ecx, eax
	mov	al, ':'
		repne	scasb
	jne	get_params		; No address - get parameters.

get_address:
; Get address. First get selector.
	mov	byte ptr [edi-1], 0	; Substitute ':' with 0.
	call	PmAToHex
	jc	wrong_prm_err

	mov	DbgCommand.Sel, ax
	mov	byte ptr [edi-1], ':'	; Return back ':'.
	mov	esi, edi
; Get offset.
	mov	edx, esi
	call	skip_non_spaces
	mov	byte ptr [esi], 0	; Substitute ' ' with 0.
	mov	edi, esi
	mov	esi, edx
	call	PmAToHex
	mov	esi, edi
	mov	byte ptr [esi], ' '	; Return back ' '.
	jc	wrong_prm_err

	mov	DbgCommand.Offs, eax
	call	skip_spaces

get_params:
; Get parameters.
	mov	ecx, offset DbgCommand.Param1
get_next_param:
	cmp	byte ptr [esi], 0
	je	end_get_cmd

	mov	edi, esi
	call	skip_non_spaces
	xchg	esi, edi
	mov	byte ptr [edi], 0
	call	PmAToHex
	mov	byte ptr [edi], ' '
	jnc	next_param_ok

wrong_prm_err:
	mov	DbgCommand.Command, -2		; Error: wrong params!
	jmp	end_get_cmd
next_param_ok:
	mov	esi, edi
	mov	[ecx], eax
	add	ecx, 4
	call	skip_spaces
	jmp	get_next_param

end_get_cmd:
	ret

;;
;; Local subroutines.
;;
skip_spaces:
	cmp	byte ptr [esi], 0
	je	end_skip
	cmp	byte ptr [esi], ' '
	ja	end_skip
	inc	esi
	jmp	skip_spaces

skip_non_spaces:
	cmp	byte ptr [esi], 0
	je	end_skip
	cmp	byte ptr [esi], ' '
	jna	end_skip
	inc	esi
	jmp	skip_non_spaces

end_skip:
	retn
GetDbgCmd	ENDP


;-----------------------------------------------------------------------------
;
;	Callback for INT 1 & 3.
;
;-----------------------------------------------------------------------------
PUBLIC	DebugCallback
DebugCallback	PROC
	mov	DbgEsp, esp
	mov	esp, DBG_STK

	mov	eax, ExcNumber
	mov	DbgExcNum, eax		; Save debug exception number.

; If exception 1 and TraceFlag = 0 then go to simulate instantly.
	cmp	DbgExcNum, 1
	je	@@F

	cmp	I3Here, 0
	jne	handle_exc
	jmp	simulate
@@@@:
	cmp	BkptFlag, 0
	jne	handle_exc

	cmp	TraceFlag, 0
	je	simulate

handle_exc:
; Set in-debug flag
	mov	DebugFlag, 1

; Mask all interrupts for debug wait.
	in	al, PIC_MASTER_MASK
	mov	MasterMask, al
	in	al, PIC_SLAVE_MASK
	mov	SlaveMask, al

	mov	al, 0FFh
	out	PIC_MASTER_MASK, al
	out	PIC_SLAVE_MASK, al

; Save debuggee's registers.
	mov	ebx, offset DebuggeeRegs
	mov	ecx, offset DebuggeeSregs
	call	SaveClientRegs

regs_saved:
; Clear trace flag.
	mov	TraceFlag, 0

; Dump registers.
	call	DumpRegs

key_loop:
	call	GetDbgCmd
	mov	dh, DBG_COMMAND_ROW
	mov	ah, DBG_COMMAND_ATTR
	call	PmClearRow
	mov	al, DbgCommand.Command

	cmp	al, Dbg_CMD_GO
	jne	trace?
; 'g' key.
	jmp	go_on

trace?:
	cmp	al, Dbg_CMD_TRACE
	jne	dump?
; 't' key.
	mov	TraceFlag, 1
	jmp	go_on

dump?:
	cmp	al, Dbg_CMD_DUMP
	jne	bkpt?

; 'd' key.
	mov	si, DbgCommand.Sel
	mov	edi, DbgCommand.Offs
	mov	ebx, DebuggeeRegs.dwEflags
	call	PointerToLinear

	mov	esi, eax
	mov	ecx, DbgCommand.Param1
; If number of bytes not specified, dump 16 bytes.
	test	ecx, ecx
	jnz	@@F

	mov	ecx, 16
@@@@:

; For dump purposes disable breakpoints.
	mov	eax, dr7
	push	eax
	sub	eax, eax
	mov	dr7, eax

	sub	edx, edx
	mov	dh, DBG_COMMAND_ROW
	mov	bl, DBG_COMMAND_ATTR
dump_loop:
	push	ecx
	push	esi
	PM_PRINT_HEX	fs:[esi]
	pop	esi
	pop	ecx

	inc	esi
	add	dl, 3
	cmp	dl, 80
	jb	@@F
	sub	dl, dl
	inc	dh
@@@@:
	dec	ecx
	jnz	dump_loop

; Restore DR7.
	pop	eax
	mov	dr7, eax

	jmp	key_loop

bkpt?:
	cmp	al, Dbg_CMD_BKPT
	jne	phys?
; 'bp' command.
	mov	si, DbgCommand.Sel
	mov	edi, DbgCommand.Offs
	mov	ebx, DebuggeeRegs.dwEflags
	call	PointerToLinear

	mov	dr0, eax	; Set breakpoint address.

	mov	eax, 202h	; Global enable BKPT #0 & global exact bkpt.
	mov	ecx, DbgCommand.Param1
	and	ecx, 3		; Param1 = bkpt type: 0 = exec, 1 = write
				; 2 = I/O, 3 = read/write.
	shl	ecx, 16
	or	eax, ecx

	mov	ecx, DbgCommand.Param2
	and	ecx, 3		; Param2 = bkpt length: 0 = byte, 1 = word
				; 2 = undef, 3 = dword
	shl	ecx, 18
	or	eax, ecx
	mov	dr7, eax	; Breakpoint condition.

	mov	BkptFlag, 1
	jmp	key_loop

phys?:
	cmp	al, Dbg_CMD_PHYS
	jne	lin?
; 'phys' command.
	PM_PRINT_HEX32	DbgCommand.Param1, 0, DBG_COMMAND_ROW, DBG_COMMAND_ATTR
	mov	eax, DbgCommand.Param1
	call	LinearToPhysical
	PM_PRINT_HEX32	, 10, DBG_COMMAND_ROW, DBG_COMMAND_ATTR
	jmp	key_loop

lin?:
	cmp	al, Dbg_CMD_LIN
	jne	i3here?
; 'lin' command.
	mov	si, DbgCommand.Sel
	mov	edi, DbgCommand.Offs
	mov	ebx, DebuggeeRegs.dwEflags
	call	PointerToLinear
	PM_PRINT_HEX32	, 0, DBG_COMMAND_ROW, DBG_COMMAND_ATTR
	jmp	key_loop

i3here?:
	cmp	al, Dbg_CMD_I3HERE
	jne	quit?
	mov	eax, DbgCommand.Param1
	mov	I3Here, al
	jmp	key_loop

quit?:
	cmp	al, Dbg_CMD_QUIT
	jne	boot?
; 'q' key.
EXTRN	core_entry: near32
	mov	QuitPm, 1
	mov	esp, Start32Esp
	jmp	core_entry

boot?:
	cmp	al, Dbg_CMD_BOOT
	jne	log?
; 'b' key.
	mov	al, 0FEh
	out	64h, al
	cli
	hlt

log?:
	cmp	al, Dbg_CMD_LOG
	jne	attr?
	jmp	keys_done

attr?:
	cmp	al, Dbg_CMD_ATTR
	jne	keys_done
; 'attr' command - print segment access rights / attributes.
	mov	eax, DbgCommand.Param1
	mov	ebx, GdtBase
	test	eax, 4				; Which DT?
	jz	@@F
	mov	ebx, CurrLdtBase
@@@@:
	and	eax, NOT 7

	pushad
	PM_PRINT_HEX	(Descriptor386 PTR fs:[ebx][eax]).Access, 0, DBG_COMMAND_ROW, DBG_COMMAND_ATTR
	popad

	mov	al, (Descriptor386 PTR fs:[ebx][eax]).LimitHigh20
	and	al, 0F0h

	pushad
	PM_PRINT_HEX	, 4, DBG_COMMAND_ROW, DBG_COMMAND_ATTR
	popad

keys_done:
	jmp	key_loop

go_on:
; Restore debuggee's registers.

	mov	ebx, offset DebuggeeRegs
	mov	ecx, offset DebuggeeSregs
	call	RestoreClientRegs

; Restore interrupt masks.
	mov	al, MasterMask
	out	PIC_MASTER_MASK, al
	mov	al, SlaveMask
	out	PIC_SLAVE_MASK, al

; Reset in-debug flag.
	mov	DebugFlag, 0

	cmp	DbgExcNum, 1
	je	end_dbg_exc

simulate:
	test	ExcEflags, FL_VM
	jnz	@@F
	test	ExcSeg, 3
	jz	end_dbg_exc
@@@@:
	mov	eax, DbgExcNum
	call	SimulateInt
end_dbg_exc:

; Return.
	mov	esp, DbgEsp
	clc
	ret
DebugCallback	ENDP

CODE32	ENDS
END
@


0.52
log
@Stack segment for Tripple-DOS changed to 32-bit default. 16-bit stack didn't work with DPMI clients that set up stack to 32 bits and ESP > 64K! Now DJGPP stubbed programs work, but there is some problem when they return.
@
text
@d12 1
a12 1
; law, shall Vadim Drubetsky aka the Black Phantoms be liable for any special,
@


0.51
log
@Added general devices synchronization mechanism.
It's implemented for COM1 and COM2.
It causes problems with a keyboard.
@
text
@@


0.50
log
@Fixed HDD/FDD synchronization problem (trapped opcodes were overwriting each other).
@
text
@@


0.49
log
@Fixes version (log for INIT.ASM)
@
text
@@


0.48
log
@Enabled XMS 3.0 inteface
@
text
@@


0.47
log
@DMA partial virtualization is made - Tripple DOS now works with floppy!
@
text
@@


0.46
log
@Fixed a bug that didn't allow Tripple DOS work with DOS loaded HIGH
@
text
@@


0.45
log
@The shareware beta release
@
text
@@


0.44
log
@Bug fixes:
1) Checks for open file name (EDX to DX) problem
2) Reporting of the protected mode exception reboot
@
text
@d3 19
d25 1
a25 1
;	Kernel debugging procedures for MULTIX32.
@


0.43
log
@Bug fixes:
1) Lower word in translation structure on real mode stack was being destroyed - very annoying.
2) Saved exception number was moved to task structure to allow multiple DPMI tasks work.
3 copies of WCC386 worked!
@
text
@@


0.42
log
@1) Added XMS server
2) XMS server is on top DPMI memory manager, so DPMI memory handln are moved
@
text
@@


0.41
log
@Bug fixes:
1) Virtual I/O jump table (very annoying!)
2) IsFileOpen() bug if file name is 0.
@
text
@d11 32
a42 29
		INCLUDE	DEBUG.INC
		INCLUDE	DEVICES.INC
		INCLUDE	DEF.INC
		INCLUDE	CORE.INC
		INCLUDE	X86.INC
		INCLUDE	PHLIB32.MCR

		EXTRN	AddExcTrap: near32
		EXTRN	GetScanCode: near32
		EXTRN	GetAsciiCode: near32
		EXTRN	PmGetStr32: near32
		EXTRN	PmClearRow: near32
		EXTRN	PmStrLen: near32
		EXTRN	PmAToHex: near32
		EXTRN	PmStrCmp: near32
		EXTRN	SaveClientRegs: near32
		EXTRN	RestoreClientRegs: near32
		EXTRN	DumpRegs: near32
		EXTRN	SimulateInt: near32
		EXTRN	PointerToLinear: near32
		EXTRN	LinearToPhysical: near32

		EXTRN	ExcEflags: dword
		EXTRN	ExcSeg: word
		EXTRN	ExcOffs: dword

		EXTRN	QuitPm: byte
		EXTRN	Start32Esp: dword
		EXTRN	ExcNumber: dword
d44 1
d74 2
d86 2
d456 1
a456 1
	jne	keys_done
d462 28
@


0.40
log
@DPMI server fixes:
1) Locker real mode and protected mode stacks usage fixed: reentrancy allowed.
2) Modes switches fixed.
@
text
@@


0.39
log
@Bug fixed: raw mode switches.
@
text
@@


0.38
log
@Bugs fixed:
1) PointerToLinear() check
2) Default interrupt redirection to V86 mode
@
text
@@


0.37
log
@Bug fixed: reflecting PM to VM interrupt.
@
text
@d327 1
a327 1
	mov	Traceflag, 1
@


0.36
log
@Bug fixes:
1) CreatePageTable() called from HeapAllocMem()
2) Zero allocated PDB for new task
@
text
@@


0.35
log
@HeapAllocMem() bug fixed; free DPMI memory allocated fixed.
@
text
@d263 1
d479 2
d482 1
a482 1

@


0.34
log
@Bug fixes:
1) Initial pages map allocation
2) Translation services params
3) DPMI clean up memory release -- almost
4) INT 21h AH=4Ch in protected mode.
@
text
@@


0.33
log
@Initial full release - all DPMI functions are written! Half are not tet.
@
text
@a56 2

PUBLIC	DbgCommand
@


0.32
log
@Translation services work.
@
text
@@


0.31
log
@1) Interrupt redirection works
2) HeapAllocMem() bug fixes
DPMI traps fixed
@
text
@@


0.30
log
@DOS block functions are written and work. Callback to real mode mechanism established. Tests are still brief.
@
text
@@


0.29
log
@First DPMI selector functions work (Hello, world).
@
text
@@


0.28
log
@Initial DPMI switch works.
@
text
@@


0.27
log
@Solves INT 28 block problems (doesn't lock).
@
text
@d5 1
@


0.26
log
@Bugs fixed:
1) Store open file name
2) Store DOS function per process
3) Imperfect INT 13 semaphore handling.
@
text
@@


0.25
log
@Fixed bug in IsFileOpen proc.
@
text
@@


0.24
log
@Removed unnecessary dynamic allocations.
@
text
@@


0.23
log
@1) File sharing handled.
@
text
@@


0.22
log
@1) Fully split task blocking and waiting for event.
2) Annoying bug fixed (TASK_PTR).
@
text
@@


0.21
log
@1) Improved task state handling (nesting allowed due to bit mask).
2) Bugs fixed.
TASK_PTR macro is used.
4) X86.MCR is out of project.
@
text
@@


0.20
log
@Task locks on wait for events are added.
@
text
@@


0.19
log
@Trap wait on keyboard (INT 16h / 0, 10h).
Bug fixes in memory allocation.
@
text
@@


0.18
log
@Keyboard virtualized.
File I/O interface for kernel is added.
@
text
@d452 2
a453 4

	push	0
	lidt	fword ptr [esp]
	int	3
@


0.17
log
@Int 13h locking improvements, bug fixes (NC running)
@
text
@d450 3
@


0.16
log
@Debug improvements (commands); VGA ports partial virtualizing
@
text
@d55 2
d70 1
d80 1
d273 3
d277 2
a278 1

a311 1
;	call	GetAsciiCode
d421 1
a421 1
	jne	quit?
d430 7
d474 1
a474 1
	jne	simulate
a475 2
	test	ExcEflags, FL_TF
	jz	end_dbg_exc
@


0.15
log
@Debug improvements: hardware breakpoint
@
text
@d21 1
d24 1
d30 1
d59 19
a77 1
	CmdTbl		DB	"tgdqbp"
a113 1
PUBLIC	GetDbgCmd
d133 4
a136 3
	mov	al, [esi]
	test	al, al
	jz	no_cmd_err
d138 2
a139 2
	mov	edi, offset CmdTbl
	mov	ecx, SIZEOF CmdTbl
d141 1
a141 1
	cmp	al, [edi]
d144 3
a146 2
	inc	edi
	dec	ecx
d148 1
d150 3
d155 1
d157 4
a303 3
	mov	eax, DATA
	shl	eax, 4
PM_PRINT_HEX32	, 0, 24, 0Fh
d306 3
d341 7
d352 1
d356 2
d367 5
d376 2
a377 2
	jne	quit?
; 'p' key.
d400 21
@


0.14
log
@Bug fixes; debug improvements
@
text
@d39 1
d56 1
a56 1
	CmdTbl		DB	"tgdqb"
d179 4
d184 1
d186 1
d191 1
a192 1
	jc	end_get_cmd
d240 3
d273 3
d294 2
a295 1
	jne	quit?
d326 28
@


0.13
log
@Proper CPL 0 stack management; foreground task boost on event
@
text
@d27 1
a32 2
		EXTRN	ExcEax: dword
		EXTRN	Field: byte
d34 2
a35 2
		EXTRN	Start32Esp: DWORD
		EXTRN	ExcNumber: DWORD
a38 1
	RetAddr		DD	?
d49 1
d51 1
d53 1
d55 1
a55 1
	CmdTbl		DB	"tg"
d70 1
a70 1
	mov	eax, 03h	; Trap INT 3.
d74 1
a74 1
	mov	eax, 01h	; Trap INT 1.
d86 4
a89 1
;	Parses command and 
d92 2
a93 1
GetDbgCmd	PROC	near32
d101 2
d105 3
d114 2
a115 1
	jz	end_get_cmd
d125 3
a127 1
	mov	al, -1				; Error: no command found!
a139 4
	mov	eax, esi
	call	skip_non_spaces
	mov	byte ptr [esi], 0

a140 1
	mov	esi, eax
a144 2
	push	ds
	pop	es
d146 1
a146 3
	je	get_address
	inc	esi
	jmp	get_params
d149 2
a150 3
; Get address.
	mov	byte ptr [edi-1], 0
; Get selector.
d152 2
d155 1
d158 1
a158 1
	mov	eax, esi
d160 3
a162 1
	inc	esi
d164 4
d169 1
a169 2
	call	skip_non_spaces
	inc	esi
d175 3
d180 1
d182 1
d188 1
a188 2
	cmp	byte ptr [esi], 0
	jne	get_next_param
a220 2
;	I: EAX = exception number, ECX = error code presence.
;
d226 3
d230 1
a230 1
	cmp	ExcNumber, 1
d263 3
a265 1
	call	GetAsciiCode
d274 1
a274 1
	jne	quit?
d279 35
d336 1
d347 1
a347 1
; Reset in-debug flag
d350 1
a350 4
	test	ExcEflags, FL_VM
	jz	end_dbg_exc

	cmp	ExcNumber, 1
d356 4
a359 1
	mov	eax, ExcNumber
@


0.12
log
@Bug fixes: 5th task, VGA co40/co80 restore
@
text
@@


0.11
log
@Memory allocation enhance; bug fixes
@
text
@@


0.10
log
@VGA save/restore state fixed; bug fixes
@
text
@d265 1
a265 1
EXTRN	pmode_loop: near32
d268 1
a268 1
	jmp	pmode_loop
@


0.9
log
@VGA state save/restore
@
text
@@


0.8
log
@Synchronization of system services; bug fixes
@
text
@@


0.7
log
@Working preemptive multitasking. Interrupts are reported to ALL tasks. Different tasks cannot work with the same device.
@
text
@@


0.7.0.1
log
@Attempt to synchronize disks with semaphores
@
text
@@


0.6
log
@Working non-preemptive multitasking
@
text
@@


0.5
log
@Working V86 emulation version!
@
text
@d15 1
d33 4
a36 1
		EXTRN	Field:byte
d50 1
a57 1
;ASSUME	CS:CODE32, DS:DATA
d209 12
a220 3
PUBLIC	DebugCallback
DebugCallback	PROC	near32
	pop	RetAddr
a234 3
;	test	ExcEflags, FL_VM
;	jz	regs_saved

a246 1
;	call	GetScanCode
d256 1
a256 1
	jne	keys_done
d261 17
a295 1
if 0
d299 3
a301 9
	movzx	eax, ExcSeg
	shl	eax, 4
	add	eax, ExcOffs
	cmp	byte ptr fs:[eax-1], 0CCh	; INT3?
	jne	test_tf

	mov	eax, 3
	jmp	simulate
test_tf:
a303 1
	mov	eax, 1
d305 2
a306 1
;	call	SimulateInt
a307 1
endif
d310 1
d312 1
a312 1
	jmp	RetAddr
@
