head	0.53;
access;
symbols;
locks
	BlackPhantom:0.53
	BlackPhantom:0.7.0.1; strict;
comment	@;; @;


0.53
date	2002.05.13.03.00.48;	author BlackPhantom;	state Exp;
branches;
next	0.52;

0.52
date	2001.02.13.04.09.54;	author BlackPhantom;	state Exp;
branches;
next	0.51;

0.51
date	2001.02.12.02.23.02;	author BlackPhantom;	state Exp;
branches;
next	0.50;

0.50
date	2001.02.02.23.44.36;	author BlackPhantom;	state Exp;
branches;
next	0.49;

0.49
date	2001.01.19.19.22.34;	author BlackPhantom;	state Exp;
branches;
next	0.48;

0.48
date	2000.12.27.05.36.43;	author BlackPhantom;	state Exp;
branches;
next	0.47;

0.47
date	2000.11.19.00.48.14;	author BlackPhantom;	state Exp;
branches;
next	0.46;

0.46
date	2000.08.31.02.13.37;	author BlackPhantom;	state Exp;
branches;
next	0.45;

0.45
date	2000.08.15.23.51.37;	author BlackPhantom;	state Exp;
branches;
next	0.44;

0.44
date	2000.03.23.14.09.09;	author BlackPhantom;	state Exp;
branches;
next	0.43;

0.43
date	99.08.10.02.48.18;	author BlackPhantom;	state Exp;
branches;
next	0.42;

0.42
date	99.08.06.16.39.08;	author BlackPhantom;	state Exp;
branches;
next	0.41;

0.41
date	99.07.16.03.18.20;	author BlackPhantom;	state Exp;
branches;
next	0.40;

0.40
date	99.06.05.20.07.01;	author BlackPhantom;	state Exp;
branches;
next	0.39;

0.39
date	99.05.28.22.41.24;	author BlackPhantom;	state Exp;
branches;
next	0.38;

0.38
date	99.05.28.18.27.56;	author BlackPhantom;	state Exp;
branches;
next	0.37;

0.37
date	99.05.28.04.20.40;	author BlackPhantom;	state Exp;
branches;
next	0.36;

0.36
date	99.05.27.22.22.07;	author BlackPhantom;	state Exp;
branches;
next	0.35;

0.35
date	99.05.23.19.52.27;	author BlackPhantom;	state Exp;
branches;
next	0.34;

0.34
date	99.05.23.15.13.32;	author BlackPhantom;	state Exp;
branches;
next	0.33;

0.33
date	99.05.21.02.27.28;	author BlackPhantom;	state Exp;
branches;
next	0.32;

0.32
date	99.05.19.01.13.28;	author BlackPhantom;	state Exp;
branches;
next	0.31;

0.31
date	99.05.17.18.49.52;	author BlackPhantom;	state Exp;
branches;
next	0.30;

0.30
date	99.05.11.17.10.49;	author BlackPhantom;	state Exp;
branches;
next	0.29;

0.29
date	99.05.06.22.37.51;	author BlackPhantom;	state Exp;
branches;
next	0.28;

0.28
date	99.05.05.16.38.55;	author BlackPhantom;	state Exp;
branches;
next	0.27;

0.27
date	99.04.19.21.02.51;	author BlackPhantom;	state Exp;
branches;
next	0.26;

0.26
date	99.04.18.12.54.59;	author BlackPhantom;	state Exp;
branches;
next	0.25;

0.25
date	99.04.17.03.11.27;	author BlackPhantom;	state Exp;
branches;
next	0.24;

0.24
date	99.04.14.18.28.12;	author BlackPhantom;	state Exp;
branches;
next	0.23;

0.23
date	99.04.14.16.43.57;	author BlackPhantom;	state Exp;
branches;
next	0.22;

0.22
date	99.04.12.18.51.50;	author BlackPhantom;	state Exp;
branches;
next	0.21;

0.21
date	99.04.11.12.50.45;	author BlackPhantom;	state Exp;
branches;
next	0.20;

0.20
date	99.04.05.03.15.12;	author BlackPhantom;	state Exp;
branches;
next	0.19;

0.19
date	99.03.30.23.45.44;	author BlackPhantom;	state Exp;
branches;
next	0.18;

0.18
date	99.03.29.18.33.30;	author BlackPhantom;	state Exp;
branches;
next	0.17;

0.17
date	99.03.22.22.40.13;	author BlackPhantom;	state Exp;
branches;
next	0.16;

0.16
date	99.03.18.04.09.05;	author BlackPhantom;	state Exp;
branches;
next	0.15;

0.15
date	99.03.16.02.16.25;	author BlackPhantom;	state Exp;
branches;
next	0.14;

0.14
date	99.03.16.00.23.39;	author BlackPhantom;	state Exp;
branches;
next	0.13;

0.13
date	99.03.13.23.36.05;	author BlackPhantom;	state Exp;
branches;
next	0.12;

0.12
date	99.03.12.22.09.18;	author BlackPhantom;	state Exp;
branches;
next	0.11;

0.11
date	99.03.09.04.23.38;	author BlackPhantom;	state Exp;
branches;
next	0.10;

0.10
date	99.03.01.23.10.12;	author BlackPhantom;	state Exp;
branches;
next	0.9;

0.9
date	99.02.25.21.57.36;	author BlackPhantom;	state Exp;
branches;
next	0.8;

0.8
date	99.02.24.02.20.20;	author BlackPhantom;	state Exp;
branches;
next	0.7;

0.7
date	99.02.18.00.07.41;	author BlackPhantom;	state Exp;
branches
	0.7.0.1;
next	0.6;

0.6
date	99.02.17.17.01.48;	author BlackPhantom;	state Exp;
branches;
next	0.5;

0.5
date	99.02.10.04.40.20;	author BlackPhantom;	state Exp;
branches;
next	0.4;

0.4
date	98.12.22.03.04.23;	author BlackPhantom;	state Exp;
branches
	0.4.0.1;
next	0.3;

0.3
date	98.06.05.12.46.26;	author BlackPhantom;	state Exp;
branches;
next	0.2;

0.2
date	98.05.28.02.53.17;	author BlackPhantom;	state Exp;
branches;
next	0.1;

0.1
date	98.05.16.12.40.43;	author BlackPhantom;	state Exp;
branches;
next	;

0.4.0.1
date	98.12.23.01.04.00;	author BlackPhantom;	state Exp;
branches;
next	;

0.7.0.1
date	99.02.21.04.01.14;	author BlackPhantom;	state Exp;
branches;
next	;


desc
@Main file for devices control
@


0.53
log
@Last developed version
@
text
@;=============================================================================
;
;	This source code file is copyright (c) Vadim Drubetsky AKA the 
; Black Phantom. All rights reserved.
;
;	This source code file is a part of the Tripple-DOS project. Your use 
; of this source code must fully comply with the accompanying license file, 
; LICENSE.TXT. You must have this file enclosed with your Tripple-DOS copy in
; order for it to be legal.
;
;	In no event, except for when it is explicitly stated by the applicable 
; law, shall Vadim Drubetsky aka the Black Phantom be liable for any special,
; incidental, indirect, or consequential damages (including but not limited to
; profit loss, business interruption, loss of business information, or any 
; other pecuniary loss) arising out of the use of or inability to use 
; Tripple-DOS, even if he has been advised of the possibility of such damages.
;
;=============================================================================

;=============================================================================
;
;				DEVICES.ASM
;				-----------
;
;	Devices management code for the Tripple-DOS project.
;
;=============================================================================
	EXTRN	AddGdtSegment: near

	EXTRN	Field:byte
	EXTRN	TssBase: dword
	EXTRN	ForegroundTask: dword
	EXTRN	CurrentTask: dword
	EXTRN	CurrTaskPtr: dword
	EXTRN	FirstTask: dword
	EXTRN	VirtualIp: dword
	EXTRN	VirtualIsr: dword
	EXTRN	VirtualImr: dword
	EXTRN	ExcSeg: word
	EXTRN	ExcOffs: dword
	EXTRN	ExcEax: dword
	EXTRN	ExcEbx: dword
	EXTRN	ExcEcx: dword
	EXTRN	ExcEdx: dword
	EXTRN	ExcEsi: dword
	EXTRN	ExcEdi: dword
	EXTRN	ExcEsp: dword
	EXTRN	ExcEbp: dword
	EXTRN	ExcSs: dword
	EXTRN	ExcDs: dword
	EXTRN	ExcEs: dword
	EXTRN	ExcFs: dword
	EXTRN	ExcGs: dword
	EXTRN	ExcEflags: dword

	EXTRN	FddSema4Own: dword

	INCLUDE	PHLIB.INC
	INCLUDE	DEF.INC
	INCLUDE	DEVICES.INC
	INCLUDE	X86.INC
	INCLUDE	TASKMAN.INC
	INCLUDE	CORE.INC
	INCLUDE	PHLIB32.MCR
	INCLUDE	DPMI.INC

	EXTRN	InitErrHandler: near16

	EXTRN	PointerToLinear: near32
	EXTRN	LinearToPhysical: near32
	EXTRN	WriteLog: near32
	EXTRN	SwitchTask: near32
	EXTRN	Sema4Down: near32
	EXTRN	Sema4Up: near32

DATA	SEGMENT	PARA	PUBLIC	USE16	'DATA'
; Video data.
	PUBVAR		CrtId, DB, ?	; Id of the video adapter.
	VideoTxtBuf	DD	?	; Base address for text video buffer.
	VideoGfxBuf	DD	?	; Base address for gfx. video buffer.
	PUBVAR	VBufTextSel, DW, ?	; GDT selector for text video buffer.
	PUBVAR	VBufGfxSel, DW,	?	; GDT selector for gfx. video buffer.
	CrtBase		DW	?	; Base addr. for CRT controller.
	PUBVAR	Rows, DB, ROWS_PER_SCR	; Rows per screen
	PUBVAR	Columns, DB, COLS_PER_ROW	; Columns per row.

	CursorX		DB	0
	CursorY		DB	0

	TempMemMode	DB	?	; Temporary memory mode reg.
	TempMisc	DB	?	; Temporary gfx. misc. reg.

; I/O opcodes help data.
	PUBVAR	OperandSize, DB, ?	; 16/32 bits operand.
	PUBVAR	AddressSize, DB, ?	; 16/32 bits addressing.
	PUBVAR	SegPrefix, DB, ?	; Segment prefix.
	PUBVAR	RepPrefix, DB, ?	; REP prefix specified.

	IoOpcodes	DB	OP_IN8_DX, OP_IN8_IMM, OP_IN16_DX
			DB	OP_IN16_IMM, OP_INSB, OP_INSW
			DB	OP_OUT8_DX, OP_OUT8_IMM, OP_OUT16_DX
			DB	OP_OUT16_IMM, OP_OUTSB, OP_OUTSW
IO_OPCODES	=	$ - offset IoOpcodes

	IoOpcodesJmpTbl	DD	offset _op_in8_dx, offset _op_in8_imm
			DD	offset _op_in16_dx, offset _op_in16_imm
			DD	offset _op_insb, offset _op_insw
			DD	offset _op_out8_dx, offset _op_out8_imm
			DD	offset _op_out16_dx, offset _op_out16_imm
			DD	offset _op_outsb, offset _op_outsw

; Is saved at initial I/O instruction checking.
	IoOpcodesIndex	DD	?

; Keyboard data.
	PUBVAR	KeyExtCode, DB, ?	; Extended key pressed.
	PUBVAR	KeyPressed, DB, ?	; Key pressed.
	PUBVAR	KeyReady, DB, ?		; Key ready flag.
	PUBVAR	ShiftKeys, DB, ?	; Shift keys state.

	PUBVAR	KeyboardQ, DB, ?	; Keyboard queue.
		DB	KEYBOARD_Q_SIZE - 1 DUP (?)
	PUBVAR	KbdQHead, DD, 0		; Pointer to queue head.
	PUBVAR	KbdQTail, DD, 0		; Pointer to queue tail.
	PUBVAR	TempScanCode, DB, ?	; Keeps scan code temporarily.

PUBLIC	ShiftScanTbl
	ShiftScanTbl	DD	Key_LShift, Key_RShift, Key_LAlt, Key_RAlt
			DD	Key_LCtrl, Key_RCtrl, Key_CapsLock, Key_NumLock

PUBLIC	ShiftBitCode	
	ShiftBitCode	DB	Kbd_LShift, Kbd_RShift, Kbd_LAlt, Kbd_RAlt
			DB	Kbd_LCtrl, Kbd_RCtrl, Kbd_CapsLock, Kbd_NumLock

	ScanTbl		DB	1, 2, 3, 4, 5, 6, 7, 8, 9, 0Ah, 0Bh
			DB	1Eh, 30h, 2Eh, 20h, 12h, 21h, 22h, 23h, 17h
			DB	24h, 25h, 26h, 32h, 31h, 18h, 19h, 10h, 13h
			DB	1Fh, 14h, 16h, 2Fh, 11h, 2Dh, 15h, 2Ch, 39h
			DB	1Ch, 0Eh, 0Ch, 0Dh, 1Ah, 1Bh, 27h, 28h, 29h
			DB	2Bh, 33h, 34h, 35h
CHAR_TBL_LEN	EQU	$ - ScanTbl

	AsciiTbl	DB	27, '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'
			DB	'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i'
			DB	'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r'
			DB	's', 't', 'u', 'v', 'w', 'x', 'y', 'z', ' '
			DB	0Dh, 08h, '-', '=', '[', ']', ';', "'", '`'
			DB	'\', ',', '.', '/'

	ShiftAsciiTbl	DB	27, '!', '@@', '#', '$', '%', '^', '&', '*', '(', ')'
			DB	'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I'
			DB	'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R'
			DB	'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' '
			DB	0Dh, 08h, '_', '+', '{', '}', ':', '"', '~'
			DB	'|', '<', '>', '?'

; PIT data.
	PUBVAR	TickCount, DWORD, ?
	PUBVAR	TicksReport, DWORD, ?
	PUBVAR	TickToSec, DWORD, PIT_TICK_TO_SEC

; DMA data.
	PUBVAR	DmaBufSeg, DW, ?
	PUBVAR	DmaBufAddr, DD, ?	; 64K buffer, paragraph aligned

	Dma1BaseAddr	DD	4 DUP (?)
	Dma1Count	DD	4 DUP (?)
	Dma1FlipFlops	DD	?
	Dma1PageAddress	DD	DMA_CH0_PAGE, DMA_CH1_PAGE, DMA_CH2_PAGE, DMA_CH3_PAGE

	DmaCtl		DB	?
	DmaStatus	DB	?
	DmaWriteReq	DB	?
	DmaMask		DB	?
	DmaMode		DB	?
	DmaMasterClear	DB	?
	DmaClearMask	DB	?
	DmaWriteMask	DB	?

	DmaMaskReg	DB	0

PUBLIC	DmaIoRange
	DmaIoRange	DD	MAX_TASKS * 2 DUP ( 0 )

	DmaCount	DB	0
	RetireDmaFlag	DB	0

	FdcStatus	DB	?

; General devices data.
PUBLIC	GenDevices
GenDevices	LABEL	GenDevice
PUBLIC	Com1
	Com1	GenDevice < 8,\
		3F8h, 3F9h, 3FAh, 3FBh, 3FCh, 3FDh, 3FEh, 3FFh,\
		@@REPEAT_DATUM	(MAX_PORTS - 8, -1 )\
		4, <> >
PUBLIC	Com2
	Com2	GenDevice < 8,\
		2F8h, 2F9h, 2FAh, 2FBh, 2FCh, 2FDh, 2FEh, 2FFh,\
		@@REPEAT_DATUM	(MAX_PORTS - 8, -1 )\
		3, <> >
	

N_GEN_DEVICES	EQU	($ - GenDevices) / SIZEOF( GenDevice )

	PUBVAR	NumGenDevs, DWORD, N_GEN_DEVICES
	NoEipUpdate	DB	0

	TimeStr		DB	"xx:xx:xx", 0
	Str1	DB	"Check 1"
	Str2	DB	"Check 2"



DATA	ENDS


CODE	SEGMENT	PARA	PUBLIC	USE16	'CODE'
ASSUME	CS:CODE, DS:DATA

;-----------------------------------------------------------------------------
;
; 	Enable A20 address line.
;
;-----------------------------------------------------------------------------
PUBLIC	EnableA20
EnableA20	PROC	near
	mov	al, CMD_A20_Access
	out	KBD_COMMAND, al
	IODelay
	mov	al, CMD_A20_On
	out	KBD_DATA, al
	IODelay
	ret
EnableA20	ENDP


;-----------------------------------------------------------------------------
;
;	Disable A20 address line.
;
;-----------------------------------------------------------------------------
DisableA20	PROC	near
	mov	al, CMD_A20_Access
	out	KBD_COMMAND, al
	IODelay
	mov	al, CMD_A20_Off
	out	KBD_DATA, al
	IODelay
	ret
DisableA20	ENDP


;-----------------------------------------------------------------------------
;
;	I:  DX = PIC base address(20h=master, A0h=slave)
;	    AH = Start INT # for appropriate IRQ.
;
;	(!) AH must be a multiply of 8.
;
;	Initialize PIC. Done for remapping A3-A7 of INT vector.
;
;-----------------------------------------------------------------------------
PUBLIC	InitPIC
InitPIC		PROC	near
	mov	al, CMD_ICW1
	out	dx, al

	inc	dx
	mov	al, ah
	out	dx, al

	mov	al, CMD_ICW3
	cmp	dx, PIC_MASTER_MASK
	je	put_icw3
	mov	al, CMD_SLAVE_ICW3
put_icw3:
	out	dx, al

	mov	al, CMD_ICW4
	out	dx, al
	ret
InitPIC		ENDP


;-----------------------------------------------------------------------------
;
;	Set up video mode (text) and base address (mono/color).
;
;-----------------------------------------------------------------------------
PUBLIC	SetupVideo
SetupVideo	PROC	near
; Detect CRT type.
	call	DetectCrt
	mov	CrtId, al

; Set base CRT controller and ports addresses.
	mov	CrtBase, 3B0h
	mov	VideoTxtBuf, OS_VIDEO_BUF + 10000h
	mov	VideoGfxBuf, OS_VIDEO_BUF + 10000h
	cmp	al, 1
	jna	crt_set
	add	CrtBase, 20h	; Set CRT to 3D0h.
	mov	VideoTxtBuf, OS_VIDEO_BUF + 18000h
	mov	VideoGfxBuf, OS_VIDEO_BUF
crt_set:
; Allocate GDT selectors for text and graphics video buffers.
	ADD_GDT_SEGMENT	VideoTxtBuf, 7FFFh, DATA_ACCESS
	mov	VBufTextSel, ax
	ADD_GDT_SEGMENT	VideoGfxBuf, 0FFFFh, DATA_ACCESS
	mov	VBufGfxSel, ax

; Set mode 3.
	mov	ax, 3
	int	10h

	cmp	CrtId, 5
	jnb	@@F
	call	InitErrHandler

@@@@:
	ret
SetupVideo	ENDP


;-----------------------------------------------------------------------------
;
;	I:
;	O:  AL = 1: mono
;		 2: CGA
;		 3: EGA
;		 4: MCGA
;		 5: VGA/SVGA
;
;	Detects video adapter according to BIOS video modes that it supports.
;
;-----------------------------------------------------------------------------
PUBLIC	DetectCrt
DetectCrt	PROC	near
	sub	ax, ax
	int	10h
	mov	ah, 0Fh
	int	10h
	test	al, al
	jz	col
	mov	al, 1
	ret
col:
	mov	ax, 13h
	int	10h
	mov	ah, 0Fh
	int	10h
	cmp	al, 13h
	jz	mcgavga
	mov	ax, 0Dh
	int	10h
	mov	ah, 0Fh
	int	10h
	cmp	al, 0Dh
	jz	ega
	mov	al, 2
	ret
ega:
	mov	al, 3
	ret
mcgavga:
	mov	ax, 0Dh
	int	10h
	mov	ah, 0Fh
	int	10h
	cmp	al, 0Dh
	mov	al, 4
	jnz	to_ret
	inc	ax
to_ret:
	ret
DetectCrt	ENDP


;-----------------------------------------------------------------------------
;
; Procedure BEEPs on speaker
;
;-----------------------------------------------------------------------------
Beep		PROC
	push	ax
	push	bx
	push	cx

	in	al, KBD_PORT_B
	push	ax
	mov	cx, 100h
Beep0:
	push	cx
	and	al, 11111100b
	out	KBD_PORT_B, al
	mov	cx, 0C0h
	loop	$
	or	al, 00000010b
	out	KBD_PORT_B, al
	mov	cx, 0C0h
	loop	$
	pop	cx
	loop	Beep0

	pop	ax
	out	KBD_PORT_B, al

	pop	cx
	pop	bx
	pop	ax
	ret
Beep		ENDP


;----------------------------------------------------------------------------
;
;	DS:SI -> String (0 - terminated).
;	DL:DH = column: row
;	BL    = color
;
;	R:	PROTMODE.
;
;-----------------------------------------------------------------------------
PUBLIC	PmWriteStr
PmWriteStr	PROC	near USES es ax cx
	call	StrLen
	mov	cx, ax
	mov	al, dh
	mul	Columns
	add	al, dl
	adc	ah, 0
	shl	ax, 1
	mov	di, ax
	mov	es, VBufTextSel
	mov	ah, bl
	cld
write_loop:
	lodsb
	stosw
	loop	write_loop
	ret
PmWriteStr	ENDP


CODE	ENDS


CODE32	SEGMENT	PARA	PUBLIC	USE32	'CODE'
ASSUME	CS:CODE32, DS:FLAT

;-----------------------------------------------------------------------------
;
;	Waits for key press and returns scan code.
;
;	I:
;	O:	AL = scan code.
;		AH = extended key press code.
;
;-----------------------------------------------------------------------------
PUBLIC	GetScanCode
GetScanCode	PROC
	pushfd
	mov	al, 11111101b
	out	PIC_MASTER_MASK, al

	sti
	mov	KeyReady, 0

wait_key:
	cmp	KeyReady, 0
	je	wait_key

	popfd				; Restore IF.

	mov	al, KeyPressed		; Return key pressed
	mov	ah, KeyExtCode		; Return extended code
	ret
GetScanCode	ENDP


;-----------------------------------------------------------------------------
;
;	Waits for key press and returns ASCII code.
;
;	I:
;	O:	AL = ASCII code.
;		AH = scan code.
;
;-----------------------------------------------------------------------------
PUBLIC	GetAsciiCode
GetAsciiCode	PROC	USES ecx edi
	call	GetScanCode
	mov	edi, offset ScanTbl
	mov	ecx, CHAR_TBL_LEN
	cld
		repne	scasb
	mov	ah, al			; store scan code
	jnz	zero_ascii		; If scan code is not in table.

; If shift was held, change table.
	add	edi, offset AsciiTbl - offset ScanTbl - 1
	test	ShiftKeys, Kbd_LShift OR Kbd_RShift
	jz	@@F
	add	edi, offset ShiftAsciiTbl - offset AsciiTbl
@@@@:
	mov	al, [edi]
	jmp	ascii_gotten
zero_ascii:
	sub	al, al
ascii_gotten:

	ret
GetAsciiCode	ENDP


;-----------------------------------------------------------------------------
;
;	Moves cursor on display.
;
;	I:	AL = column, AH = row
;	O:
;
;-----------------------------------------------------------------------------
PUBLIC	GotoXy
GotoXy		PROC	near32	USES eax ecx edx
	mov	CursorX, al
	mov	CursorY, ah

	mov	edx, V_CLR_CRT_ADDR
	mov	al, ah
	mul	Columns
	add	al, CursorX
	adc	ah, 0
	mov	ecx, eax

	mov	al, V_Crt_CURSOR_ADDR_LSB	; CRT cursor position LSB index
	mov	ah, cl
	out	dx, ax

	mov	al, V_Crt_CURSOR_ADDR_MSB	; CRT cursor position MSB index
	mov	ah, ch
	out	dx, ax

	ret
GotoXy		ENDP


;-----------------------------------------------------------------------------
;
;	Print a character at cursor and advance cursor.
;
;	I:	AL = char
;		AH = attribute
;	O:
;
;-----------------------------------------------------------------------------
PUBLIC	TtyChar
TtyChar		PROC	USES	es eax ecx
	mov	ecx, eax
	mov	al, CursorY
	mul	Columns
	add	al, CursorX
	adc	ah, 0
	shl	eax, 1
	and	eax, 0000FFFFh
	mov	es, VBufTextSel
	mov	es:[eax], cx
	mov	al, CursorX
	mov	ah, CursorY
	inc	eax
	call	GotoXy

	ret
TtyChar		ENDP


;-----------------------------------------------------------------------------
;
;	Initializes PIT with a given divisor.
;
;	I: EAX = counter, valid range is 0 - 0FFFFh. 0 means 65536.
;	   BL = channel (0 - 2).
;	O:
;
;-----------------------------------------------------------------------------
PUBLIC	InitPIT
InitPIT		PROC	USES eax ecx edx
	shl	eax, 16		; Keep counter in high bits of eax.
	mov	al, bl
	shl	al, 6		; counter select.

	or	al, 00110110b	; Send LSB, MSB value; select mode 3.
	out	PIT_CONTROL, al

	shr	eax, 16		; Set back counter in AX.
	mov	edx, PIT_CH0_COUNT
	add	dl, bl

	out	dx, al		; Set LSB
	shr	eax, 8
	out	dx, al		; Set MSB

	ret
InitPIT		ENDP


;-----------------------------------------------------------------------------
;
;	Saves video context.
;
;	I: ES:EDI -> memory area to store context.
;
;-----------------------------------------------------------------------------
PUBLIC	SaveVideoContext
SaveVideoContext	PROC	USES eax ebx ecx edx edi
; Check whether the mode is color or mono. Set EBX to base CRT (3x4) address.
	mov	ebx, V_MONO_CRT_ADDR
	mov	edx, V_MISC_IN
	in	al, dx
	mov	(VIDEO_CONTEXT PTR es:[edi]).MiscOutput, al

	and	eax, 1
	shl	eax, 5
	add	ebx, eax

	cld

; Save CRT registers.
	SAVE_BUNCH_REGS	ebx, V_CRT_REGS

; Save sequencer registers.
	SAVE_BUNCH_REGS	V_SEQ_ADDR, V_SEQ_REGS

; Save graphics controller registers.
	SAVE_BUNCH_REGS	V_GFX_ADDR, V_GFX_REGS

; Save attribute controller registers.
	mov	ecx, ebx
	add	ecx, V_CLR_STS1 - V_CLR_CRT_ADDR
	sub	ah, ah

save_attr_regs:
	mov	edx, ecx
	in	al, dx		; Reset address flip-flop.
	mov	edx, V_ATTR_ADDR

	mov	al, ah
	out	dx, al

	inc	edx
	in	al, dx

	stosb
	inc	ah
	cmp	ah, V_ATTR_REGS - 1
	jb	save_attr_regs
	ja	@@F
	or	ah, V_Attr_SCR_ENABLE
	jmp	save_attr_regs
@@@@:

; Save DAC registers.
	mov	edx, V_DAC_PEL_MASK
	in	al, dx
	stosb				; PEL mask reg.

	mov	edx, V_DAC_READ_ADDR
	sub	al, al
	out	dx, al

	mov	edx, V_DAC_DATA
	mov	ecx, V_DAC_REGS - 1
		rep	insb		; DAC RGB data.

	ret
SaveVideoContext	ENDP


;-----------------------------------------------------------------------------
;
;	Saves video memory (all bit planes).
;
;	I: ES:EDX -> task's structure.
;
; (!) Must be in the context of task being saved.
;
;-----------------------------------------------------------------------------
PUBLIC	SaveVideoMemory
SaveVideoMemory		PROC
	pushad

	mov	ebp, edx
; Set all video memory clocks to CPU interface.
	mov	edx, V_SEQ_ADDR
	mov	al, V_Seq_CLOCK_MODE
	out	dx, al
	inc	edx
	in	al, dx
	movzx	ebx, al
	shl	ebx, 16			; Keep clock mode.
	dec	edx
	mov	ah, al
	mov	al, V_Seq_CLOCK_MODE
	or	ah, 20h
	out	dx, ax			; Give all the time to CPU.

; Check memory mapping.
	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_MISC
	out	dx, al
	inc	edx
	in	al, dx
	test	al, 8			; Text modes?
	jnz	text_modes

; Graphics modes. Check whether current BIOS mode uses bitplanes on the same
; addresses or chains.
	mov	al, fs:[449h]
	cmp	al, 0Dh
	je	plane_modes
	cmp	al, 10h	
	je	plane_modes
	cmp	al, 12h
	je	plane_modes
	cmp	al, 0Eh
	je	plane_modes
	jb	cga_modes

; EGA/VGA chained modes.
	mov	esi, 0A0000h
	mov	eax, 0A0000h SHR 12
	mov	edx, (0A0000h + 10000h) SHR 12
	jmp	@@F

cga_modes:
	mov	esi, 0B8000h
	mov	eax, 0B8000h SHR 12
	mov	edx, (0B8000h + 10000h) SHR 12

@@@@:
	call	copy_mem
	jmp	gfx_exit

plane_modes:
; Set read mode 0.
	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_MODE
	out	dx, al
	inc	edx
	in	al, dx
	mov	bh, al			; Save graphics ctl. mode register.
	dec	edx
	mov	al, V_Gfx_MODE
	and	ah, 01100000b		; Read and write mode 0, no odd/even
					; mode.
	out	dx, ax

	mov	al, V_Gfx_BIT_PLANE_READ
	out	dx, al
	inc	edx
	in	al, dx
	mov	bl, al			; Save previous bit plane (BL).
	dec	edx

	sub	ah, ah			; AH = bit plane.
	mov	ecx, 0A0000h SHR 12

save_bit_plane:
	push	eax

	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_BIT_PLANE_READ
	out	dx, ax

	mov	esi, 0A0000h
	mov	eax, ecx
	mov	edx, ecx
	add	edx, 10000h SHR 12
	call	copy_mem
	pop	eax

	inc	ah
	add	ecx, 10000h SHR 12
	cmp	ah, 4
	jb	save_bit_plane

; Restore mode select.
	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_MODE
	mov	ah, bh
	out	dx, ax

; Restore bit plane select.
	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_BIT_PLANE_READ
	mov	ah, bl
	out	dx, ax

gfx_exit:
; Restore clock mode.
	shr	ebx, 16
	mov	edx, V_SEQ_ADDR
	mov	al, V_Seq_CLOCK_MODE
	mov	ah, bl
	out	dx, ax

	popad
	ret

text_modes:
	mov	TempMisc, al

; Text modes. Reprogram bit plane select to access plane 2/3.
	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_BIT_PLANE_READ
	out	dx, al
	inc	edx
	in	al, dx
	mov	bl, al			; Save previous bit plane (BL).
	dec	edx
	mov	al, V_Gfx_BIT_PLANE_READ
	mov	ah, 2			; Set bit plane 2.
	out	dx, ax

; Enable odd bit planes.
	mov	edx, V_SEQ_ADDR
	mov	al, V_Seq_MEM_MODE
	out	dx, al
	inc	edx
	in	al, dx
	dec	edx
	mov	TempMemMode, al
	mov	ah, al
; VGADOC4B has this one reversed. If set, disables odd bitplanes.
; Enable odd/even mode.
	and	ah, NOT 4
	mov	al, V_Seq_MEM_MODE
	out	dx, ax

; Reprogram memory mapping register.
	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_MISC
	mov	ah, TempMisc
	and	ah, NOT 00001100b	; Map memory to A0000 - BFFFF
	or	ah, 00000010b
	out	dx, ax

; Save character generator tables.
	mov	esi, 0A0000h
	mov	eax, 0A0000h SHR 12
	mov	edx, (0A0000h + 10000h) SHR 12
	call	copy_mem
	mov	esi, 0B0000h
	mov	eax, 0C0000h SHR 12
	mov	edx, (0C0000h + 10000h) SHR 12
	call	copy_mem
; Remap memory back.
	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_MISC
	mov	ah, TempMisc
	out	dx, ax

; Restore bit plane select (0 & 1).
	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_BIT_PLANE_READ
	mov	ah, bl
	out	dx, ax

; Restore sequencer's memory mode reg.
	mov	edx, V_SEQ_ADDR
	mov	al, V_Seq_MEM_MODE
	mov	ah, TempMemMode
	out	dx, ax

	test	TempMisc, 4		; CGA compatible modes?
	jz	mono_modes

	mov	esi, 0B8000h		; Save characters and attributes.
	mov	eax, 0B8000h SHR 12
	mov	edx, (0B8000h + 8000h) SHR 12
	call	copy_mem
	jmp	restore_clock

mono_modes:
	mov	esi, 0B0000h		; Save characters and attributes.
	mov	eax, 0B0000h SHR 12
	mov	edx, (0B0000h + 8000h) SHR 12
	call	copy_mem

restore_clock:
; Restore clock mode.
	shr	ebx, 16
	mov	edx, V_SEQ_ADDR
	mov	al, V_Seq_CLOCK_MODE
	mov	ah, bl
	out	dx, ax

	popad
	ret

copy_mem:
; Copy task's memory at A0000h - BFFFFh to virtual (take from task's
; alias mapping).
	push	ecx

	cld
save_page:

	mov	ecx, 400h			; Number of dwords in 1 page.
	mov	edi, (DosTask PTR es:[ebp]).TaskMapping
	mov	edi, es:[edi+eax*4]		; ES:EDI-> dest page
		rep	movs dword ptr es:[edi], es:[esi]

	inc	eax				; Next page
	cmp	eax, edx
	jb	save_page

	pop	ecx
	ret
SaveVideoMemory		ENDP


;-----------------------------------------------------------------------------
;
;	Restores video memory
;
;	I: ES:EDX -> task's structure.
;
; (!) Must be in the context of task being saved.
;
;-----------------------------------------------------------------------------
PUBLIC	RestoreVideoMemory
RestoreVideoMemory	PROC
	pushad

	mov	ebp, edx
; Set all video memory clocks to CPU interface.
	mov	edx, V_SEQ_ADDR
	mov	al, V_Seq_CLOCK_MODE
	out	dx, al
	inc	edx
	in	al, dx
	movzx	ebx, al
	shl	ebx, 16			; Keep clock mode.
	dec	edx
	mov	ah, al
	mov	al, V_Seq_CLOCK_MODE
	or	ah, 20h
	out	dx, ax			; Give all the time to CPU.

; Check memory mapping.
	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_MISC
	out	dx, al
	inc	edx
	in	al, dx
	test	al, 8			; Text modes?
	jnz	text_modes

; Graphics modes. Check whether current BIOS mode uses bitplanes on the same
; addresses or chains.
	mov	al, fs:[449h]
	cmp	al, 0Dh
	je	plane_modes
	cmp	al, 10h	
	je	plane_modes
	cmp	al, 12h
	je	plane_modes
	cmp	al, 0Eh
	je	plane_modes
	jb	cga_modes

; EGA/VGA chained modes.
	mov	edi, 0A0000h
	mov	eax, 0A0000h SHR 12
	mov	edx, (0A0000h + 10000h) SHR 12
	jmp	@@F

cga_modes:
	mov	edi, 0B8000h
	mov	eax, 0B8000h SHR 12
	mov	edx, (0B8000h + 10000h) SHR 12

@@@@:
	call	restore_mem
	jmp	gfx_exit

plane_modes:
; Set read mode 0.
	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_MODE
	out	dx, al
	inc	edx
	in	al, dx
	mov	bh, al			; Save graphics ctl. mode register.
	dec	edx
	mov	al, V_Gfx_MODE
	and	ah, 01100000b		; Read and write mode 0, no odd/even
					; mode.
	out	dx, ax

; Reprogram bit plane write select to access bit plane 0.
	mov	al, V_Seq_BIT_PLANE_WRITE
	out	dx, al
	inc	edx
	in	al, dx
	dec	edx
	mov	bl, al			; Save previous bit plane mask.

	mov	ah, 1			; Set bit plane 0.
	mov	ecx, 0A0000h SHR 12
restore_bit_plane:
	push	eax

	mov	edx, V_SEQ_ADDR
	mov	al, V_Seq_BIT_PLANE_WRITE
	out	dx, ax

; Copy video memory.
	mov	edi, 0A0000h
	mov	eax, ecx
	mov	edx, ecx
	add	edx, 10000h SHR 12
	call	restore_mem
	pop	eax

	add	ecx, 10000h SHR 12
	shl	ah, 1
	cmp	ah, 00010000b
	jb	restore_bit_plane

; Restore bit plane write enable.
	mov	edx, V_SEQ_ADDR
	mov	al,  V_Seq_BIT_PLANE_WRITE
	mov	ah, bl
	out	dx, ax

; Restore read/write mode.
	mov	edx, V_GFX_ADDR
	mov	al,  V_Gfx_MODE
	mov	ah, bh
	out	dx, ax

gfx_exit:
; Restore clock mode.
	shr	ebx, 16
	mov	edx, V_SEQ_ADDR
	mov	al, V_Seq_CLOCK_MODE
	mov	ah, bl
	out	dx, ax

	popad
	ret

text_modes:
	mov	TempMisc, al

; Save sequencer's memory mode register.
	mov	edx, V_SEQ_ADDR
	mov	al, V_Seq_MEM_MODE
	out	dx, al
	inc	edx
	in	al, dx
	dec	edx
	mov	TempMemMode, al
	mov	ah, al
; VGADOC4B has this one reversed. If set, disables odd bitplanes.
; Enable odd/even mode.
	and	ah, NOT 4
	mov	al, V_Seq_MEM_MODE
	out	dx, ax

; Reprogram bit plane write select to access bit plane 2.
	mov	al, V_Seq_BIT_PLANE_WRITE
	out	dx, al
	inc	edx
	in	al, dx
	dec	edx
	mov	bl, al			; Save previous bit plane mask.
	mov	al, V_Seq_BIT_PLANE_WRITE
	mov	ah, 4
	out	dx, ax			; Set bit plane 2.

; Set read and write mode 0. (EDX = V_GFX_ADDR).
	mov	al, V_Gfx_MODE
	out	dx, al
	inc	edx
	in	al, dx
	mov	bh, al			; Save previous mode (BH).
	dec	edx
	mov	al, V_Gfx_MODE
	sub	ah, ah			; Read mode 0.
	out	dx, ax			; Set read mode.

; Reprogram memory mapping register.
	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_MISC
	mov	ah, TempMisc
	and	ah, NOT 00001100b	; Map memory to A0000 - BFFFF
	or	ah, 00000010b
	out	dx, ax

; Restore character generator tables.
	mov	edi, 0A0000h
	mov	eax, 0A0000h SHR 12
	mov	edx, (0A0000h + 10000h) SHR 12
	call	restore_mem
	mov	edi, 0B0000h
	mov	eax, 0C0000h SHR 12
	mov	edx, (0C0000h + 10000h) SHR 12
	call	restore_mem

; Remap memory back to B8000 - BFFFF
	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_MISC
	mov	ah, TempMisc
	out	dx, ax

; Restore bit plane select (0 & 1).
	mov	edx, V_SEQ_ADDR
	mov	al, V_Seq_BIT_PLANE_WRITE
	mov	ah, bl
	out	dx, ax

; Restore mode register.
	mov	al, bh
	out	dx, ax

; Restore sequencer's memory mode reg.
	mov	edx, V_SEQ_ADDR
	mov	al, V_Seq_MEM_MODE
	mov	ah, TempMemMode
	out	dx, ax

	test	TempMisc, 4		; CGA compatible modes?
	jz	mono_modes

	mov	edi, 0B8000h		; Restore characters and attributes.
	mov	eax, 0B8000h SHR 12
	mov	edx, (0B8000h + 8000h) SHR 12
	call	restore_mem
	jmp	restore_clock

mono_modes:
	mov	edi, 0B0000h		; Restore characters and attributes.
	mov	eax, 0B0000h SHR 12
	mov	edx, (0B0000h + 8000h) SHR 12
	call	restore_mem

restore_clock:
; Restore clock mode.
	shr	ebx, 16
	mov	edx, V_SEQ_ADDR
	mov	al, V_Seq_CLOCK_MODE
	mov	ah, bl
	out	dx, ax

	popad
	ret

restore_mem:
; Copy task's memory at A0000h - BFFFFh from virtual (take from task's
; alias mapping).
	push	ecx

	cld
restore_page:
	mov	ecx, 400h			; Number of dwords in 1 page.
	mov	esi, (DosTask PTR es:[ebp]).TaskMapping
	mov	esi, es:[esi+eax*4]		; ES:ESI-> source page
		rep	movs dword ptr es:[edi], es:[esi]

	inc	eax				; Next page
	cmp	eax, edx
	jb	restore_page

	pop	ecx
	ret
RestoreVideoMemory	ENDP


;-----------------------------------------------------------------------------
;
;	Restores video context.
;
;	I: ES:ESI -> memory area with previously saved context.
;
;-----------------------------------------------------------------------------
PUBLIC	RestoreVideoContext
RestoreVideoContext	PROC	USES eax ebx ecx edx esi
; Restore misc. output register.
	mov	al, (VIDEO_CONTEXT PTR es:[esi]).MiscOutput
	mov	edx, V_MISC_OUT
	out	dx, al

; Check whether the mode is color or mono. Set EBX to base CRT (3x4) address.
	mov	ebx, V_MONO_CRT_ADDR
	mov	edx, V_MISC_IN
	in	al, dx
	and	eax, 1
	shl	eax, 5
	add	ebx, eax

	cld

; Restore CRT registers.

; Enable write to CRT registers 0-7.
	mov	edx, ebx
	mov	al, V_Crt_VERT_RETRACE_END
	out	dx, al
	inc	edx
	in	al, dx
	dec	edx
	and	al, 7Fh
	mov	ah, al
	mov	al, V_Crt_VERT_RETRACE_END
	out	dx, ax

	REST_BUNCH_REGS	ebx, V_CRT_REGS

; Restore sequencer registers.
	REST_BUNCH_REGS	V_SEQ_ADDR, V_SEQ_REGS

; Restore graphics controller registers.
	REST_BUNCH_REGS	V_GFX_ADDR, V_GFX_REGS

; Restore attribute controller registers.
	mov	edx, ebx
	add	edx, V_CLR_STS1 - V_CLR_CRT_ADDR
	in	al, dx		; Reset address flip-flop.
	sub	ah, ah
	mov	edx, V_ATTR_ADDR

restore_attr_regs:
	mov	al, ah
	out	dx, al

	lods	byte ptr es:[esi]
	out	dx, al

	inc	ah
	cmp	ah, V_ATTR_REGS - 1
	jb	restore_attr_regs
	ja	@@F
	or	ah, V_Attr_SCR_ENABLE
	jmp	restore_attr_regs
@@@@:

; Restore DAC registers.
	mov	edx, V_DAC_PEL_MASK
	lods	byte ptr es:[esi]	; PEL mask reg.
	out	dx, al

	mov	edx, V_DAC_WRITE_ADDR
	sub	al, al
	out	dx, al

	mov	edx, V_DAC_DATA
	mov	ecx, V_DAC_REGS - 1
		rep	outs dx, byte ptr es:[esi]	; DAC RGB data.

	ret
RestoreVideoContext	ENDP


;-----------------------------------------------------------------------------
;
;	Traps access to video ports (3B0 - 3DF).
;
;	I: EAX = 0 to allow access
;              = 0FFFFFFFFh to trap access.
;
;-----------------------------------------------------------------------------
PUBLIC	TrapVideoPorts
TrapVideoPorts	PROC	USES ecx edx
	mov	edx, TssBase
	movzx	ecx, (Tss386 PTR fs:[edx]).IoTableBase
	mov	fs:[edx+ecx+3B0h/8], eax	; Trap ports 3B0 - 3CF
	mov	fs:[edx+ecx+3D0h/8], ax		; Trap ports 3D0 - 3DF

	ret
TrapVideoPorts	ENDP


;-----------------------------------------------------------------------------
;
;	Generic I/O instructions trap that saves main chaining on GPF
; handler.
;
;	GPE callback.
;
;-----------------------------------------------------------------------------
PUBLIC	TrapIo
TrapIo		PROC
; If not V86 mode and CPL != 3, return error.
	test	ExcEflags, FL_VM
	jnz	@@F
	test	ExcSeg, 3
	jnz	@@F
	stc
	ret

@@@@:
; Check faulting instruction.
	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebx, ExcEflags
	call	PointerToLinear

; Skip prefixes and set defaults.
	call	SkipPrefixes

;
; Here all prefixes are skipped. Check opcode that failed. If opcode is not
; an I/O opcode, return error.
;
	mov	esi, eax

	mov	al, fs:[esi]

	mov	edi, offset IoOpcodes
	mov	ecx, IO_OPCODES
	cld
		repne	scasb
	je	@@F

	stc
	ret

@@@@:
	not	ecx

	add	ecx, IO_OPCODES
	mov	eax, IoOpcodesJmpTbl[ecx*4]
	mov	IoOpcodesIndex, eax

; Now call all I/O emulation functions. The one that handles request will
; return CF = 0.
	call	EmulateVideoIo
	jc	@@F
	ret
@@@@:
	call	EmulateKbdIo
	jc	@@F
	ret
@@@@:
	call	EmulatePITIo
	jc	@@F
	ret
@@@@:
	call	EmulatePICIo
	jc	@@F
	ret
@@@@:
	call	EmulateDMAIo
	jc	@@F
	ret
@@@@:
	call	EmulateFDCIo
	jc	@@F
	ret
@@@@:
	call	EmulateGenDevIo
	jc	@@F
	ret
@@@@:
; Return error (restricted port access).
	ret
TrapIo		ENDP


;-----------------------------------------------------------------------------
;
;	Emulates video I/O instructions that were caused by access to video
; ports by a background application.
;	This is a GPF callback.
;
;-----------------------------------------------------------------------------
PUBLIC	EmulateVideoIo
EmulateVideoIo	PROC	USES eax ebx ecx edx

; If current task is a foreground task, return error.
	mov	eax, CurrentTask
	cmp	eax, ForegroundTask
	jne	@@F
	stc
	ret
@@@@:
; Call generic I/O emulation procedure.
	mov	eax, offset ReadVideoPort
	mov	ecx, offset WriteVideoPort
	call	EmulateIo

	ret
EmulateVideoIo	ENDP


;-----------------------------------------------------------------------------
;
;	Emulates I/O for generic device.
;
;	I: EAX -> procedure to call to emulate reads.
;	   ECX -> procedure to call to emulate writes.
;	O: CF = 0 - OK
;	   CF = 1 - error.
;
;	(!) If read or write port handlers return CF=1, ExcOffs doesn't get
; updated. This may be used to block the task on an I/O instruction.
;
;-----------------------------------------------------------------------------
EmulateIo	PROC	USES eax ebx ecx edx esi edi
LOCAL	pReadPort: dword, 
	pWritePort: dword

	mov	pReadPort, eax
	mov	pWritePort, ecx

;
; Clear the "no update" flag. This flag may be set by the particular I/O
; handler to prevent updating EIP.
;
	mov	NoEipUpdate, 0

	jmp	IoOpcodesIndex

_op_in8_dx::
; IN AL, DX.
	movzx	eax, word ptr ExcEdx
	call	pReadPort
	jc	err_ret
	mov	byte ptr ExcEax, al
	jmp	update_eip

_op_in8_imm::
	inc	esi
	movzx	eax, byte ptr fs:[esi]
	call	pReadPort
	jc	err_ret
	mov	byte ptr ExcEax, al
	jmp	update_eip

_op_in16_dx::
	cmp	OperandSize, 0
	jne	in32_dx
; IN AX, DX.
	movzx	eax, word ptr ExcEdx
do_in16:
	lea	ecx, [eax+1]
	call	pReadPort
	jc	err_ret
	mov	byte ptr ExcEax, al
	mov	eax, ecx
	call	pReadPort
	jc	err_ret
	mov	byte ptr ExcEax[1], al
	jmp	update_eip

in32_dx:
; IN EAX, DX.
	movzx	eax, word ptr ExcEdx
do_in32:
	lea	ecx, [eax+1]
	call	pReadPort
	jc	err_ret
	mov	byte ptr ExcEax, al
	mov	eax, ecx
	inc	ecx
	call	pReadPort
	jc	err_ret
	mov	byte ptr ExcEax[1], al
	mov	eax, ecx
	inc	ecx
	call	pReadPort
	jc	err_ret
	mov	byte ptr ExcEax[2], al
	mov	eax, ecx
	call	pReadPort
	jc	err_ret
	mov	byte ptr ExcEax[3], al
	jmp	update_eip
	
_op_in16_imm::
; IN (e)AX, IMM.
	inc	esi
	movzx	eax, byte ptr fs:[esi]
	cmp	OperandSize, 0
	je	do_in16
	jmp	do_in32
	
_op_insb::
; Check for segment limit violation.
	movzx	eax, word ptr ExcEdi
	cmp	AddressSize, 0
	je	@@F

	cmp	ExcEdi, 0FFFFh
	ja	err_ret
	mov	eax, ExcEdi

@@@@:
;INSB.
	push	eax
	push	esi
	push	edi

	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebx, ExcEflags
	call	PointerToLinear
	mov	ecx, eax

	pop	edi
	pop	esi
	pop	eax

insb_loop:
	movzx	eax, word ptr ExcEdx
	call	pReadPort
	jc	err_ret
	mov	fs:[ecx], al
	cmp	RepPrefix, 0
	jne	rep_insb

	cmp	AddressSize, 0
	jne	@@F
	inc	word ptr ExcEdi
	jmp	update_eip
@@@@:
	inc	ExcEdi
	jmp	update_eip

rep_insb:
	cmp	OperandSize, 0
	jne	@@F
	inc	word ptr ExcEdi
	inc	ecx
	dec	word ptr ExcEcx
	jnz	insb_loop
	jmp	update_eip

@@@@:
	inc	ExcEdi
	cmp	ExcEdi, 0FFFFh
	ja	err_ret
	inc	ecx
	dec	ExcEcx
	jnz	insb_loop
	jmp	update_eip

_op_insw::
	cmp	OperandSize, 0
	jne	do_insd?

; Check for segment limit violation.
	movzx	eax, word ptr ExcEdi
	cmp	AddressSize, 0
	je	@@F

	cmp	ExcEdi, 0FFFEh
	ja	err_ret
	mov	eax, ExcEdi
	jmp	do_insw

@@@@:
	cmp	ax, 0FFFFh
	je	err_ret

do_insw:
; INSW(D).
	push	eax
	push	esi
	push	edi

	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebx, ExcEflags
	call	PointerToLinear
	mov	ecx, eax

	pop	edi
	pop	esi
	pop	eax

insw_loop:
	movzx	eax, word ptr ExcEdx
	call	pReadPort
	jc	err_ret
	mov	fs:[ecx], al
	movzx	eax, word ptr ExcEdx
	inc	eax
	call	pReadPort
	jc	err_ret
	mov	fs:[ecx+1], al

	cmp	RepPrefix, 0
	jne	rep_insw

	cmp	OperandSize, 0
	jne	@@F
	add	word ptr ExcEdi, 2
	jmp	update_eip
@@@@:
	add	ExcEdi, 2
	jmp	update_eip

rep_insw:
	cmp	OperandSize, 0
	jne	@@F

	add	ecx, 2
	add	word ptr ExcEdi, 2
	cmp	word ptr ExcEdi, 0FFFEh
	ja	err_ret

	dec	word ptr ExcEcx
	jnz	insw_loop
	jmp	update_eip

@@@@:
	add	ExcEdi, 2
	cmp	ExcEdi, 0FFFEh
	ja	err_ret

	add	ecx, 2
	dec	ExcEcx
	jnz	insw_loop
	jmp	update_eip

do_insd?:
; Check for segment limit violation.
	movzx	eax, word ptr ExcEdi
	cmp	AddressSize, 0
	je	@@F

	cmp	ExcEdi, 0FFFCh
	ja	err_ret
	mov	eax, ExcEdi
	jmp	do_insd

@@@@:
	cmp	ax, 0FFFCh
	ja	err_ret

do_insd:
	push	eax
	push	esi
	push	edi

	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebx, ExcEflags
	call	PointerToLinear
	mov	ecx, eax

	pop	edi
	pop	esi
	pop	eax

insd_loop:
	movzx	eax, word ptr ExcEdx
	call	pReadPort
	jc	err_ret
	mov	fs:[ecx], al
	movzx	eax, word ptr ExcEdx
	inc	eax
	call	pReadPort
	jc	err_ret
	mov	fs:[ecx+1], al
	movzx	eax, word ptr ExcEdx
	add	eax, 2
	call	pReadPort
	jc	err_ret
	mov	fs:[ecx+2], al
	movzx	eax, word ptr ExcEdx
	add	eax, 3
	call	pReadPort
	jc	err_ret
	mov	fs:[ecx+3], al

	cmp	RepPrefix, 0
	je	rep_insd

	cmp	OperandSize, 0
	jne	@@F
	add	word ptr ExcEdi, 4
	jmp	update_eip
@@@@:
	add	ExcEdi, 4
	jmp	update_eip

rep_insd:
	cmp	OperandSize, 0
	jne	@@F
	add	word ptr ExcEdi, 4
	cmp	word ptr ExcEdi, 0FFFCh
	ja	err_ret
	add	ecx, 4
	dec	word ptr ExcEcx
	jnz	insd_loop
	jmp	update_eip

@@@@:
	add	ExcEdi, 4
	cmp	ExcEdi, 0FFFCh
	ja	err_ret
	add	ecx, 4
	dec	ExcEcx
	jnz	insd_loop
	jmp	update_eip
	
_op_out8_dx::
; OUT DX, AL.
	movzx	eax, word ptr ExcEdx
	mov	cl, byte ptr ExcEax
	call	pWritePort
	jc	err_ret
	jmp	update_eip

_op_out8_imm::
	inc	esi
	movzx	eax, byte ptr fs:[esi]
	mov	cl, byte ptr ExcEax
	call	pWritePort
	jc	err_ret
	jmp	update_eip

_op_out16_dx::
	cmp	OperandSize, 0
	jne	out32_dx
; OUT DX, AX.
	movzx	eax, word ptr ExcEdx
do_out16:
	mov	cl, byte ptr ExcEax
	call	pWritePort
	jc	err_ret
	movzx	eax, word ptr ExcEdx
	inc	eax
	mov	cl, byte ptr ExcEax[1]
	call	pWritePort
	jc	err_ret
	jmp	update_eip

out32_dx:	
; OUT DX, EAX.
	movzx	eax, word ptr ExcEdx
do_out32:
	mov	cl, byte ptr ExcEax
	call	pWritePort
	jc	err_ret
	movzx	eax, word ptr ExcEdx
	inc	eax
	mov	cl, byte ptr ExcEax[1]
	call	pWritePort
	jc	err_ret
	movzx	eax, word ptr ExcEdx
	add	eax, 2
	mov	cl, byte ptr ExcEax[2]
	call	pWritePort
	jc	err_ret
	movzx	eax, word ptr ExcEdx
	add	eax, 3
	mov	cl, byte ptr ExcEax[3]
	call	pWritePort
	jc	err_ret
	jmp	update_eip

_op_out16_imm::
	inc	esi
	movzx	eax, byte ptr fs:[esi]
	cmp	OperandSize, 0
	je	do_out16
	jmp	do_out32

_op_outsb::
; Check for segment limit violation.
	movzx	eax, word ptr ExcEsi
	cmp	AddressSize, 0
	je	@@F

	cmp	ExcEsi, 0FFFFh
	ja	err_ret
	mov	eax, ExcEsi
@@@@:
;OUTSB. Pick segment (according to override).
	movzx	ebx, word ptr ExcDs
	cmp	SegPrefix, 0
	je	@@F
	movzx	ebx, word ptr ExcEs
	cmp	SegPrefix, OP_ES_PREFIX
	je	@@F
	movzx	ebx, word ptr ExcSeg
	cmp	SegPrefix, OP_CS_PREFIX
	je	@@F
	movzx	ebx, word ptr ExcSs
	cmp	SegPrefix, OP_SS_PREFIX
	je	@@F
	movzx	ebx, word ptr ExcFs
	cmp	SegPrefix, OP_FS_PREFIX
	je	@@F
	movzx	ebx, word ptr ExcGs
@@@@:
	push	eax
	push	esi
	push	edi

	mov	esi, ebx
	mov	edi, eax
	mov	ebx, ExcEflags
	call	PointerToLinear
	mov	ebx, eax

	pop	edi
	pop	esi
	pop	eax

outsb_loop:
	movzx	eax, word ptr ExcEdx
	mov	cl, fs:[ebx]
	call	pWritePort
	cmp	RepPrefix, 0
	jne	rep_outsb

	cmp	AddressSize, 0
	jne	@@F
	inc	word ptr ExcEsi
	jmp	update_eip
@@@@:
	inc	ExcEsi
	jmp	update_eip

rep_outsb:
	cmp	OperandSize, 0
	jne	@@F
	inc	word ptr ExcEsi
	inc	ebx
	dec	word ptr ExcEcx
	jnz	outsb_loop
	jmp	update_eip

@@@@:
	inc	ExcEsi
	cmp	ExcEsi, 0FFFFh
	ja	err_ret
	inc	ebx
	dec	ExcEcx
	jnz	outsb_loop
	jmp	update_eip

_op_outsw::
	cmp	OperandSize, 0
	jne	do_outsd

; Check for segment limit violation.
	movzx	eax, word ptr ExcEsi
	cmp	AddressSize, 0
	je	@@F

	cmp	ExcEsi, 0FFFFh
	jnb	err_ret
	mov	eax, ExcEsi
@@@@:
; OUTSW. Pick segment (according to override).
	movzx	ebx, word ptr ExcDs
	cmp	SegPrefix, 0
	je	@@F
	movzx	ebx, word ptr ExcEs
	cmp	SegPrefix, OP_ES_PREFIX
	je	@@F
	movzx	ebx, word ptr ExcSeg
	cmp	SegPrefix, OP_CS_PREFIX
	je	@@F
	movzx	ebx, word ptr ExcSs
	cmp	SegPrefix, OP_SS_PREFIX
	je	@@F
	movzx	ebx, word ptr ExcFs
	cmp	SegPrefix, OP_FS_PREFIX
	je	@@F
	movzx	ebx, word ptr ExcGs
@@@@:
	push	eax
	push	esi
	push	edi

	mov	esi, ebx
	mov	edi, eax
	mov	ebx, ExcEflags
	call	PointerToLinear
	mov	ebx, eax

	pop	edi
	pop	esi
	pop	eax

outsw_loop:
	movzx	eax, word ptr ExcEdx
	mov	cl, fs:[ebx]
	call	pWritePort
	jc	err_ret
	movzx	eax, word ptr ExcEdx
	inc	eax
	mov	cl, fs:[ebx+1]
	call	pWritePort
	cmp	RepPrefix, 0
	jne	rep_outsw

	cmp	AddressSize, 0
	jne	@@F
	add	word ptr ExcEsi, 2
	jmp	update_eip
@@@@:
	add	ExcEsi, 2
	jmp	update_eip

rep_outsw:
	cmp	OperandSize, 0
	jne	@@F
	add	word ptr ExcEsi, 2
	cmp	word ptr ExcEsi, 0FFFFh
	jnb	err_ret
	add	ebx, 2
	dec	word ptr ExcEcx
	jnz	outsw_loop
	jmp	update_eip

@@@@:
	add	ExcEsi, 2
	cmp	ExcEsi, 0FFFFh
	jnb	err_ret
	add	ebx, 2
	dec	ExcEcx
	jnz	outsw_loop
	jmp	update_eip

do_outsd:
; Check for segment limit violation.
	movzx	eax, word ptr ExcEsi
	cmp	AddressSize, 0
	je	@@F

	cmp	ExcEsi, 0FFFCh
	ja	err_ret
	mov	eax, ExcEsi
@@@@:
; OUTSD. Pick segment (according to override).
	movzx	ebx, word ptr ExcDs
	cmp	SegPrefix, 0
	je	@@F
	movzx	ebx, word ptr ExcEs
	cmp	SegPrefix, OP_ES_PREFIX
	je	@@F
	movzx	ebx, word ptr ExcSeg
	cmp	SegPrefix, OP_CS_PREFIX
	je	@@F
	movzx	ebx, word ptr ExcSs
	cmp	SegPrefix, OP_SS_PREFIX
	je	@@F
	movzx	ebx, word ptr ExcFs
	cmp	SegPrefix, OP_FS_PREFIX
	je	@@F
	movzx	ebx, word ptr ExcGs
@@@@:
	push	eax
	push	esi
	push	edi

	mov	esi, ebx
	mov	edi, eax
	mov	ebx, ExcEflags
	call	PointerToLinear
	mov	ebx, eax

	pop	edi
	pop	esi
	pop	eax

outsd_loop:
	movzx	eax, word ptr ExcEdx
	mov	cl, fs:[ebx]
	call	pWritePort
	jc	err_ret
	movzx	eax, word ptr ExcEdx
	inc	eax
	mov	cl, fs:[ebx+1]
	call	pWritePort
	jc	err_ret
	movzx	eax, word ptr ExcEdx
	add	eax, 2
	mov	cl, fs:[ebx+2]
	call	pWritePort
	jc	err_ret
	movzx	eax, word ptr ExcEdx
	add	eax, 3
	mov	cl, fs:[ebx+3]
	call	pWritePort
	jc	err_ret

	cmp	RepPrefix, 0
	jne	rep_outsd

	cmp	AddressSize, 0
	jne	@@F
	add	word ptr ExcEsi, 4
	jmp	update_eip
@@@@:
	add	ExcEsi, 4
	jmp	update_eip

rep_outsd:
	cmp	OperandSize, 0
	jne	@@F
	add	word ptr ExcEsi, 4
	cmp	word ptr ExcEsi, 0FFFCh
	ja	err_ret
	add	ebx, 4
	dec	word ptr ExcEcx
	jnz	outsd_loop
	jmp	update_eip

@@@@:
	add	ExcEsi, 4
	cmp	ExcEsi, 0FFFCh
	ja	err_ret
	add	ebx, 4
	dec	ExcEcx
	jnz	outsd_loop
;	jmp	update_eip

update_eip:
	cmp	NoEipUpdate, 0
	jne	@@F

	inc	esi

	push	esi
	push	edi

	mov	si, ExcSeg
	sub	edi, edi
	mov	ebx, ExcEflags
	call	PointerToLinear

	pop	edi
	pop	esi

	sub	esi, eax
	mov	ExcOffs, esi
@@@@:
	clc
	ret

err_ret:
	stc
	ret

EmulateIo	ENDP


;-----------------------------------------------------------------------------
;
;	Skips prefixes in opcode.
;
;	I: FS:EAX -> faulting opcode (with prefixes).
;	O: FS:EAX -> faulting opcode (without prefixes).
;
;-----------------------------------------------------------------------------
PUBLIC	SkipPrefixes
SkipPrefixes	PROC
; Default 16 bits, no segment override.
	mov	AddressSize, 0
	mov	OperandSize, 0
	mov	SegPrefix, 0
	mov	RepPrefix, 0

skip_prefixes:
	cmp	byte ptr fs:[eax], OP_CS_PREFIX
	jne	@@F
	mov	SegPrefix, OP_CS_PREFIX
	inc	eax
	jmp	skip_prefixes
@@@@:
	cmp	byte ptr fs:[eax], OP_SS_PREFIX
	jne	@@F
	mov	SegPrefix, OP_SS_PREFIX
	inc	eax
	jmp	skip_prefixes
@@@@:
	cmp	byte ptr fs:[eax], OP_DS_PREFIX
	jne	@@F
	mov	SegPrefix, OP_DS_PREFIX
	inc	eax
	jmp	skip_prefixes
@@@@:
	cmp	byte ptr fs:[eax], OP_ES_PREFIX
	jne	@@F
	mov	SegPrefix, OP_ES_PREFIX
	inc	eax
	jmp	skip_prefixes
@@@@:
	cmp	byte ptr fs:[eax], OP_FS_PREFIX
	jne	@@F
	mov	SegPrefix, OP_FS_PREFIX
	inc	eax
	jmp	skip_prefixes
@@@@:
	cmp	byte ptr fs:[eax], OP_GS_PREFIX
	jne	@@F
	mov	SegPrefix, OP_GS_PREFIX
	inc	eax
	jmp	skip_prefixes
@@@@:
	cmp	byte ptr fs:[eax], OP_OPER_PREFIX
	jne	@@F
	xor	OperandSize, 1
	inc	eax
	jmp	skip_prefixes
@@@@:
	cmp	byte ptr fs:[eax], OP_ADDR_PREFIX
	jne	@@F
	xor	AddressSize, 1
	inc	eax
	jmp	skip_prefixes
@@@@:
	cmp	byte ptr fs:[eax], OP_REPNZ_PREFIX
	jne	@@F
	mov	RepPrefix, OP_REPNZ_PREFIX
	inc	eax
	jmp	skip_prefixes
@@@@:
	cmp	byte ptr fs:[eax], OP_REPZ_PREFIX
	jne	@@F
	mov	RepPrefix, OP_REPZ_PREFIX
	inc	eax
	jmp	skip_prefixes
@@@@:
	ret	
SkipPrefixes	ENDP


;-----------------------------------------------------------------------------
;
;	Reads a virtual video port.
;
;	I: EAX = port
;	O: AL = value.
;	   CF = 0	-	OK
;	        1	-	error (port is not a video port).
;
;-----------------------------------------------------------------------------
ReadVideoPort	PROC	USES ecx edx
; Test if video port.
	cmp	eax, FIRST_VIDEO_PORT
	jnb	@@F
	stc
	ret
@@@@:
	cmp	eax, LAST_VIDEO_PORT
	jb	@@F
	stc
	ret
@@@@:
; Set FS:EDX -> current task's video state structure.
	mov	edx, CurrTaskPtr
	mov	edx, (DosTask PTR fs:[edx]).TaskVideoState

; Test if emulated ports (color/mono).
	test	eax, 10h
	jz	non_emulated

	movzx	ecx, (VIDEO_CONTEXT PTR fs:[edx]).MiscOutput
	and	ecx, 1
	shl	ecx, 5
	test	ecx, eax
	jz	emulated
	mov	al, 0FFh
	clc
	ret

; Read emulated port (3D/Bx)
emulated:
	xor	ecx, 20h
	add	eax, ecx

	cmp	eax, V_CLR_CRT_ADDR
	jne	@@F
; Read CRT controllrer address register.
	mov	al, (VIDEO_CONTEXT PTR fs:[edx]).CrtIndex
	clc
	ret
@@@@:
	cmp	eax, V_CLR_CRT_DATA
	jne	sts1?
; Read CRT controllrer data register.
	cmp	(VIDEO_CONTEXT PTR fs:[edx]).CrtIndex, V_CRT_REGS
	jb	@@F
	mov	al, 0FFh
	clc
	ret
@@@@:
	movzx	eax, (VIDEO_CONTEXT PTR fs:[edx]).CrtIndex
	mov	al, fs:[edx][eax+Crt_Regs]
	clc
	ret

sts1?:
	cmp	eax, V_CLR_STS1
	jne	@@F
; Status = 0: neither vertical nor horizonatal retrace in background.
; Reset attributes controller flip-flop.
	mov	(VIDEO_CONTEXT PTR fs:[edx]).AttrFlipFlop, 0
	sub	al, al
	mov	al, 8
	clc
	ret
@@@@:
	mov	al, 0FFh
	clc
	ret

; Read non-emulated port (3Cx).
non_emulated:
	cmp	eax, V_SEQ_ADDR
	jne	@@F
; Read sequencer address register.
	mov	al, (VIDEO_CONTEXT PTR fs:[edx]).SeqIndex
	clc
	ret
@@@@:
	cmp	eax, V_SEQ_DATA
	jne	gfx_regs?
; Read sequencer data register.
	cmp	(VIDEO_CONTEXT PTR fs:[edx]).SeqIndex, V_SEQ_REGS
	jb	@@F
	mov	al, 0FFh
	clc
	ret
@@@@:
	movzx	eax, (VIDEO_CONTEXT PTR fs:[edx]).SeqIndex
	mov	al, fs:[edx][eax+Seq_Regs]
	clc
	ret

gfx_regs?:
	cmp	eax, V_GFX_ADDR
	jne	@@F
; Read graphics controller address register.
	mov	al, (VIDEO_CONTEXT PTR fs:[edx]).GfxIndex
	clc
	ret
@@@@:
	cmp	eax, V_GFX_DATA
	jne	attr_regs?
; Read graphics controller data register.
	cmp	(VIDEO_CONTEXT PTR fs:[edx]).GfxIndex, V_GFX_REGS
	jb	@@F
	mov	al, 0FFh
	clc
	ret
@@@@:
	movzx	eax, (VIDEO_CONTEXT PTR fs:[edx]).GfxIndex
	mov	al, fs:[edx][eax+Gfx_Regs]
	clc
	ret

attr_regs?:
	cmp	eax, V_ATTR_ADDR
	jne	@@F
; Read attributes controller address register.
	mov	al, (VIDEO_CONTEXT PTR fs:[edx]).AttrIndex
	clc
	ret
@@@@:
	cmp	eax, V_ATTR_IN
	jne	pel_regs?
; Read attributes controller data register.
	and	eax, 1Fh
	cmp	(VIDEO_CONTEXT PTR fs:[edx]).AttrIndex, V_ATTR_REGS
	jb	@@F
	mov	al, 0FFh
	clc
	ret
@@@@:
	movzx	eax, (VIDEO_CONTEXT PTR fs:[edx]).AttrIndex
	mov	al, fs:[edx][eax+Attr_Regs]
	clc
	ret

pel_regs?:
	cmp	eax, V_DAC_READ_ADDR
	jne	@@F
; Read sequencer address register.
	movzx	eax, (VIDEO_CONTEXT PTR fs:[edx]).PelReadIndex
	mov	cl, 3
	div	cl
	clc
	ret
@@@@:
	cmp	eax, V_DAC_DATA
	jne	pel_mask?
; Read DAC data register.
	movzx	eax, (VIDEO_CONTEXT PTR fs:[edx]).PelReadIndex
	mov	al, fs:[edx][eax+Pel_Data]
	inc	(VIDEO_CONTEXT PTR fs:[edx]).PelReadIndex
	cmp	(VIDEO_CONTEXT PTR fs:[edx]).PelReadIndex, 100h * 3
	jb	@@F
	sub	(VIDEO_CONTEXT PTR fs:[edx]).PelReadIndex, 100h * 3
@@@@:
	clc
	ret

pel_mask?:
	cmp	eax, V_DAC_PEL_MASK
	jne	@@F
	mov	al, (VIDEO_CONTEXT PTR fs:[edx]).PelMask
	clc
	ret
@@@@:
	cmp	eax, V_MISC_IN
	jne	@@F
	mov	al, (VIDEO_CONTEXT PTR fs:[edx]).MiscOutput
	clc
	ret
@@@@:
	cmp	eax, V_FEAT_CTL_IN
	jne	@@F
	mov	al, (VIDEO_CONTEXT PTR fs:[edx]).FeatureCtl
	clc
	ret
@@@@:
	cmp	eax, V_STS0
	jne	@@F
	mov	al, (VIDEO_CONTEXT PTR fs:[edx]).MiscOutput
	and	al, 4
	shl	al, 2
	clc
	ret

@@@@:
	mov	al, 0FFh
	clc
	ret
ReadVideoPort	ENDP


;-----------------------------------------------------------------------------
;
;	Writes to a virtual video port.
;
;	I: EAX = port
;	   CL = value.
;	O: CF = 0	-	OK
;	        1	-	error (port is not a video port).
;
;-----------------------------------------------------------------------------
WriteVideoPort	PROC	USES eax ebx edx esi
; Test if video port.
	cmp	eax, FIRST_VIDEO_PORT
	jnb	@@F
	stc
	ret
@@@@:
	cmp	eax, LAST_VIDEO_PORT
	jb	@@F
	stc
	ret
@@@@:

; Set FS:EDX -> current task's video state structure.
	mov	edx, CurrTaskPtr
	mov	edx, (DosTask PTR fs:[edx]).TaskVideoState

; Test if emulated ports (color/mono).
	test	eax, 10h
	jz	non_emulated

	movzx	ebx, (VIDEO_CONTEXT PTR fs:[edx]).MiscOutput
	and	ebx, 1
	shl	ebx, 5
	test	ebx, eax
	jz	emulated
	clc
	ret

; Arite emulated port (3D/Bx)
emulated:
	xor	ebx, 20h
	add	eax, ebx

	cmp	eax, V_CLR_CRT_ADDR
	jne	@@F
; Write CRT controller address register.
	mov	(VIDEO_CONTEXT PTR fs:[edx]).CrtIndex, cl
	clc
	ret
@@@@:
	cmp	eax, V_CLR_CRT_DATA
	jne	feat_ctl?
; Write CRT controller data register.
	cmp	(VIDEO_CONTEXT PTR fs:[edx]).CrtIndex, V_CRT_REGS
	jnb	@@F
	movzx	ebx, (VIDEO_CONTEXT PTR fs:[edx]).CrtIndex
	mov	fs:[edx][ebx+Crt_Regs], cl
@@@@:
	clc
	ret

feat_ctl?:
	clc
	ret

non_emulated:
	cmp	eax, V_SEQ_ADDR
	jne	@@F
; Write sequencer address register.
	mov	(VIDEO_CONTEXT PTR fs:[edx]).SeqIndex, cl
	clc
	ret
@@@@:
	cmp	eax, V_SEQ_DATA
	jne	gfx_regs?
; Write sequencer data register.
	cmp	(VIDEO_CONTEXT PTR fs:[edx]).SeqIndex, V_SEQ_REGS
	jnb	@@F
	movzx	ebx, (VIDEO_CONTEXT PTR fs:[edx]).SeqIndex
	mov	fs:[edx][ebx+Seq_Regs], cl
@@@@:
	clc
	ret

gfx_regs?:
	cmp	eax, V_GFX_ADDR
	jne	@@F
; Write graphics controller address register.
	mov	(VIDEO_CONTEXT PTR fs:[edx]).GfxIndex, cl
	clc
	ret
@@@@:
	cmp	eax, V_GFX_DATA
	jne	attr_regs?
; Write graphics controller data register.
	cmp	(VIDEO_CONTEXT PTR fs:[edx]).GfxIndex, V_GFX_REGS
	jnb	@@F
	movzx	ebx, (VIDEO_CONTEXT PTR fs:[edx]).GfxIndex
	mov	fs:[edx][ebx+Gfx_Regs], cl
@@@@:
	clc
	ret

attr_regs?:
	cmp	eax, V_ATTR_ADDR
	jne	dac_regs?
; Write attribute controller register, according to flip-flop.
	test	(VIDEO_CONTEXT PTR fs:[edx]).AttrFlipFlop, 1
	jnz	attr_data
	mov	(VIDEO_CONTEXT PTR fs:[edx]).AttrIndex, cl
	jmp	@@F
attr_data:
	movzx	ebx, (VIDEO_CONTEXT PTR fs:[edx]).AttrIndex
	and	ebx, 1Fh
	cmp	ebx, V_ATTR_REGS
	jnb	end_attr_regs
	mov	fs:[edx][ebx+Attr_Regs], cl
@@@@:
	xor	(VIDEO_CONTEXT PTR fs:[edx]).AttrFlipFlop, 1
end_attr_regs:
	clc
	ret

dac_regs?:
	cmp	eax, V_DAC_WRITE_ADDR
	jne	@@F
; Write DAC write address register.
	movzx	ebx, cl
	mov	esi, ebx
	add	ebx, esi
	add	ebx, esi
	mov	(VIDEO_CONTEXT PTR fs:[edx]).PelWriteIndex, bx
	clc
	ret
@@@@:
	cmp	eax, V_DAC_READ_ADDR
	jne	@@F
; Write DAC read address register.
	movzx	ebx, cl
	mov	esi, ebx
	add	ebx, esi
	add	ebx, esi
	mov	(VIDEO_CONTEXT PTR fs:[edx]).PelReadIndex, bx
	clc
	ret
@@@@:
	cmp	eax, V_DAC_DATA
	jne	pel_mask?
; Write DAC data registers.
	movzx	ebx, (VIDEO_CONTEXT PTR fs:[edx]).PelWriteIndex
	mov	fs:[edx][ebx+Pel_Data], cl
	inc	(VIDEO_CONTEXT PTR fs:[edx]).PelWriteIndex
	cmp	(VIDEO_CONTEXT PTR fs:[edx]).PelWriteIndex, 100h * 3
	jb	@@F
	sub	(VIDEO_CONTEXT PTR fs:[edx]).PelWriteIndex, 100h * 3
@@@@:
	clc
	ret

pel_mask?:
	cmp	eax, V_DAC_PEL_MASK
	jne	@@F
	mov	(VIDEO_CONTEXT PTR fs:[edx]).PelMask, cl
	clc
	ret

@@@@:
	cmp	eax, V_MISC_OUT
	jne	@@F
	mov	(VIDEO_CONTEXT PTR fs:[edx]).MiscOutput, cl
	clc
	ret
@@@@:
	clc
	ret
WriteVideoPort	ENDP


;-----------------------------------------------------------------------------
;
;	Emulates keyboard I/O. Only Input instructions supported. 
;
;	I:
;	O:
;
;-----------------------------------------------------------------------------
PUBLIC	EmulateKbdIo
EmulateKbdIo	PROC	USES eax ebx ecx edx

; Call emulate generic I/O procedure.
	mov	eax, offset ReadKeyboardPort
	mov	ecx, offset WriteKeyboardPort

	call	EmulateIo
	ret
EmulateKbdIo	ENDP


;-----------------------------------------------------------------------------
;
;	Reads a virtual keyboard port.
;
;	I: EAX = port
;	O: AL = value.
;	   CF = 0	-	OK
;	        1	-	error (port is not a video port).
;
;-----------------------------------------------------------------------------
ReadKeyboardPort	PROC	USES ecx
	cmp	eax, KBD_DATA
	je	read_data
	cmp	eax, KBD_STATUS
	je	read_status
	stc
	ret

read_status:
	sub	al, al			; status = no data.
	mov	ecx, KbdQHead
	cmp	ecx, KbdQTail
	je	@@F
	inc	eax			; status = data for system.
@@@@:
	clc
	ret

read_data:
	mov	ecx, KbdQHead		; Read data at queue head.
	cmp	ecx, KbdQTail		; If already read, return previous
					; code.
	jne	read_new

	dec	ecx
	jnl	@@F
	add	ecx, KEYBOARD_Q_SIZE
@@@@:
	mov	al, KeyboardQ[ ecx ]
	clc
	ret

read_new:
	mov	al, KeyboardQ[ ecx ]	; Read code for the first time.
	inc	ecx			; Update queue head.
	cmp	ecx, KEYBOARD_Q_SIZE
	jb	@@F
	sub	ecx, ecx
@@@@:
	mov	KbdQHead, ecx

	clc
	ret
ReadKeyboardPort	ENDP


;-----------------------------------------------------------------------------
;
;	Filter keyboard port writes.
;
;	I: EAX = port
;	   CL = data
;	O: CF = 0 - OK
;	      = 1 - error (wrong port).
;
;-----------------------------------------------------------------------------
WriteKeyboardPort	PROC	USES eax ecx edx
	cmp	eax, KBD_DATA
	je	write_data
	cmp	eax, KBD_STATUS
	jne	@@F

	mov	ch, cl
	and	ch, 0F0h
	cmp	ch, 0F0h
	jne	write_data
; Prevent program from booting the computer.
	or	cl, 1
	jmp	write_data
@@@@:
	stc
	ret

write_data:
	mov	edx, eax
	mov	al, cl
	out	dx, al

	clc
	ret
WriteKeyboardPort	ENDP


;-----------------------------------------------------------------------------
;
;	Emulate PIT I/O. Trapped to support virtual timers with better than
; 18.2 ticks/sec resolution.
;
;-----------------------------------------------------------------------------
EmulatePITIo	PROC

; Call emulate generic I/O procedure.
	mov	eax, offset ReadPITPort
	mov	ecx, offset WritePITPort

	call	EmulateIo
	ret
EmulatePITIo	ENDP


;-----------------------------------------------------------------------------
;
;	Reads a virtual timer port.
;
;	I: EAX = port
;	O: AL = value.
;	   CF = 0	-	OK
;	        1	-	error (wrong port).
;
;-----------------------------------------------------------------------------
ReadPITPort	PROC	USES edx
; Meanwhile reads are supported.
	cmp	eax, PIT_CH0_COUNT
	jb	@@F
	cmp	eax, PIT_CONTROL
	ja	@@F

; Read.
	mov	edx, eax
	in	al, dx
	clc
	ret

@@@@:
	stc
	ret
ReadPITPort	ENDP


;-----------------------------------------------------------------------------
;
;	Writes a virtual timer port.
;
;	I: EAX = port
;	   CL = value.
;	O: CF = 0	-	OK
;	        1	-	error (wrong port).
;
;-----------------------------------------------------------------------------
WritePITPort	PROC	USES ebx edx
; Meanwhile reads are supported.
	cmp	eax, PIT_CH0_COUNT
	jb	wrong_port
	cmp	eax, PIT_CONTROL
	ja	wrong_port

; If write to channel 1 count, return with error (restricted).
	cmp	eax, PIT_CH1_COUNT
	jne	@@F
	stc
	ret

@@@@:
; Write to control register?
	cmp	eax, PIT_CONTROL
	jne	ch0_count?

; Is channel 1 selected?
	mov	edx, ecx
	and	edx, 11000000b
	cmp	edx, 01000000b
	jne	@@F

; Return with error (restricted).
	stc
	ret
@@@@:
; Is channel 0 selected?
	test	edx, edx
	jz	select_ch0

do_write:
; Write is allowed (channel 2 select or read back cmd).
	mov	edx, eax
	mov	eax, ecx
	out	dx, al
	clc
	ret

select_ch0:

; Only read/write LSB, MSB is implemented
	mov	edx, ecx
	and	edx, 00110000b
	cmp	edx, 00110000b
	jne	do_write

	mov	edx, ecx
	and	edx, 00001110b

; Only mode 2 is supported.
	cmp	edx, 00000110b
	je	@@F

	stc
	ret

@@@@:

; Mode isn't reset for channel 0 - virtual timer is yet simple. Only mark
; channel 0 selected.
	mov	edx, CurrTaskPtr
	inc	(DosTask PTR fs:[edx]).TaskPITCh0Sel
	clc
	ret

ch0_count?:
	cmp	eax, PIT_CH0_COUNT
	jne	ch2_count

; Set new value for reported ticks for this task.
	mov	edx, CurrTaskPtr

; If select is > 1, then LSB is already written. If it's not 1 (0), then
; init is going wrong (channel not selected). Discard byte.
	cmp	(DosTask PTR fs:[edx]).TaskPITCh0Sel, 1
	ja	set_ch0_count
	jz	save_ch0_count_lsb
	clc
	ret

save_ch0_count_lsb:

; Save LSB in TaskTicksReport field.
	mov	byte ptr (DosTask PTR fs:[edx]).TaskTicksReport, cl
	inc	(DosTask PTR fs:[edx]).TaskPITCh0Sel
	clc
	ret

set_ch0_count:
	movzx	eax, cl
	shl	eax, 8
	mov	ebx, (DosTask PTR fs:[edx]).TaskTicksReport
	and	ebx, 0FFh
	or	ebx, eax

; If value is smaller than one kernel tick, set one kernel tick.
	push	edx
	mov	eax, PIT_FREQUENCY
	sub	edx, edx
	div	TickToSec
	pop	edx

	cmp	ebx, eax
	jnb	@@F
	mov	ebx, eax

@@@@:
	sub	edx, edx
	xchg	eax, ebx
	div	ebx
	mov	edx, CurrTaskPtr
	mov	(DosTask PTR fs:[edx]).TaskTicksReport, eax

; Unselect channel 0.
	mov	(DosTask PTR fs:[edx]).TaskPITCh0Sel, 0
	clc
	ret

ch2_count:
	mov	edx, eax
	mov	eax, ecx
	out	dx, al
	clc
	ret

wrong_port:
	stc
	ret
WritePITPort	ENDP


;-----------------------------------------------------------------------------
;
;	Emulate PIC I/O. This will allow full virtual PIC behaviour in the
; system.
;
;-----------------------------------------------------------------------------
EmulatePICIo	PROC

; Call emulate generic I/O procedure.
	mov	eax, offset ReadPICPort
	mov	ecx, offset WritePICPort
	call	EmulateIo
	ret
EmulatePICIo	ENDP



;-----------------------------------------------------------------------------
;
;	Reads a virtual interrupt controller port.
;
;	I: EAX = port
;	O: AL = value.
;	   CF = 0	-	OK
;	        1	-	error (wrong port).
;
;-----------------------------------------------------------------------------
ReadPICPort	PROC	USES edx
	cmp	eax, PIC_MASTER
	je	read

	cmp	eax, PIC_MASTER_MASK
	jne	@@F

	mov	al, byte ptr VirtualImr
	clc
	ret
@@@@:
	cmp	eax, PIC_SLAVE
	je	read

	cmp	eax, PIC_SLAVE_MASK
	jne	@@F
	mov	al, byte ptr VirtualImr[ 1 ]
	clc
	ret
@@@@:
	stc
	ret

read:
	mov	edx, eax
	in	al, dx
	clc
	ret
ReadPICPort	ENDP


;-----------------------------------------------------------------------------
;
;	Writes a virtual interrupt controller port.
;
;	I: EAX = port
;	   CL = value.
;	O: CF = 0	-	OK
;	        1	-	error (wrong port).
;
;-----------------------------------------------------------------------------
WritePICPort	PROC	USES ebx edx
	cmp	eax, PIC_MASTER
	jne	@@F
	cmp	cl, 20h
	jne	write

; Clear the least virtual ISR's bit (first byte).
	movzx	edx, byte ptr VirtualIsr
	dec	edx
	and	byte ptr VirtualIsr, dl
	clc
	ret

@@@@:
	cmp	eax, PIC_SLAVE
	jne	@@F
	cmp	cl, 20h
	jne	write

; Clear the least virtual ISR's bit (second byte).
	movzx	edx, byte ptr VirtualIsr[ 1 ]
	dec	edx
	and	byte ptr VirtualIsr[ 1 ], dl
	clc
	ret

@@@@:
	cmp	eax, PIC_MASTER_MASK
	jne	@@F
	mov	byte ptr VirtualImr, cl
	clc
	ret
@@@@:
	cmp	eax, PIC_SLAVE_MASK
	jne	@@F
	mov	byte ptr VirtualImr[ 1 ], cl
	clc
	ret
@@@@:
	stc
	ret

write:
	mov	edx, eax
	mov	eax, ecx
	out	dx, al
	clc
	ret
WritePICPort	ENDP


;-----------------------------------------------------------------------------
;
;	Emulate DMA. This will allow DOS programs work with DMA.
;
;-----------------------------------------------------------------------------
EmulateDMAIo	PROC
; Call emulate generic I/O procedure.
	mov	eax, offset ReadDMAPort
	mov	ecx, offset WriteDMAPort
	call	EmulateIo
	ret
EmulateDMAIo	ENDP


;-----------------------------------------------------------------------------
;
;	Reads a DMA port.
;
;	I: EAX = port
;	O: AL = value.
;	   CF = 0	-	OK
;	        1	-	error (wrong port).
;
;-----------------------------------------------------------------------------
ReadDMAPort	PROC	USES edx
	cmp	eax, 20h
	jb	dma_port
	cmp	eax, 80h
	jb	not_dma_port
	cmp	eax, 8Fh
	ja	not_dma_port
dma_port:
	mov	edx, eax
	in	al, dx
	clc
	ret
not_dma_port:
	stc
	ret
ReadDMAPort	ENDP


;-----------------------------------------------------------------------------
;
;	Writes a DMA port.
;
;	I: EAX = port
;	   CL = value.
;	O: CF = 0	-	OK
;	        1	-	error (wrong port).
;
;-----------------------------------------------------------------------------
WriteDMAPort	PROC	USES eax ebx ecx edx esi edi
	cmp	eax, 20h
	jb	dma_port
	cmp	eax, 80h
	jb	not_dma_port
	cmp	eax, 8Fh
	ja	not_dma_port

dma_port:
	cmp	eax, DMA1_MASK
	jne	is_dma1_addr_clear?

; A DMA 1 channel is being programmed.
	test	cl, 00000100b
	jnz	do_write

; Unmask virtual register and start programming. CL holds the channel to program.
	mov	DmaMask, cl
	and	cl, 00000011b

;	mov	al, 1
;	shl	al, cl
;	not	al
;	and	DmaMaskReg, al

	mov	ch, DmaMode
	and	ch, 00001100b

; If mode is write to memory, setup DMA range and do the copy later.
	movzx	edx, cl
	cmp	ch, 00000100b
	jne	read_from_mem

	mov	eax, Dma1BaseAddr[ edx * 4 ]
	mov	ebx, CurrentTask
	mov	DmaIoRange[ ebx * 8 ], eax
	mov	eax, Dma1Count[ edx * 4 ]
	inc	eax
	mov	DmaIoRange[ ebx * 8 ][ 4 ], eax
	mov	RetireDmaFlag, 1
	jmp	program_addr
;	jmp	do_unmask

; If mode is read from memory, copy memory to DMA buffer and go on.
read_from_mem:
	push	es
	push	ecx

	push	fs
	pop	es
	mov	esi, Dma1BaseAddr[ edx * 4 ]
	mov	edi, DmaBufAddr
	add	edi, OS_1ST_MB
	cld
	mov	ecx, Dma1Count[ edx * 4 ]
	inc	ecx
		rep	movs byte ptr es:[edi], es:[esi]

	pop	ecx
	pop	es

program_addr:
; Program the addresses.
	movzx	edx, cl
	mov	eax, DmaBufAddr
	shl	edx, 1		; EDX -> base address for appropriate channel.
	out	dx, al
	IODelay
	xchg	al, ah
	out	dx, al
	IODelay
	shr	eax, 16
	mov	edx, Dma1PageAddress[ edx * 2 ]
	out	dx, al
	IODelay

	movzx	edx, cl
	mov	eax, Dma1Count[ edx * 4 ]
	shl	edx, 1
	inc	edx
	out	dx, al
	IODelay
	xchg	al, ah
	out	dx, al
	IODelay

;	clc
;	ret

do_unmask:
; Unmask the channel.
	mov	al, DmaMask
	out	DMA1_MASK, al
; Clear the internal flipflops.
;	mov	Dma1FlipFlops, 0
	clc
	ret

set_mask1:
	jmp	do_write
;	and	cl, 00000011b
;	mov	al, 1
;	shl	al, cl
;	or	DmaMaskReg, al
;	clc
;	ret
	mov	Dma1FlipFlops, 0
	
is_dma1_addr_clear?:
; If a flip flop is cleared, clear it.
	cmp	eax, DMA1_ADDR_CLEAR
	jne	is_dma1_mode?
	mov	Dma1FlipFlops, 0
	jmp	do_write
;	clc
;	ret

is_dma1_mode?:
	cmp	eax, DMA1_MODE
	jne	is_dma1_addr?
	mov	DmaMode, cl
	jmp	do_write

is_dma1_addr?:
; If an address or count register is programmed.
	cmp	eax, DMA1_CMD
	jnb	is_dma1_page?

	test	eax, 1		; Just bypass count registers
	jnz	get_count

; Write address registers.
	mov	edx, eax
	shr	edx, 1
	bt	Dma1FlipFlops, edx
	jc	@@F

	mov	byte ptr Dma1BaseAddr[ edx * 4 ], cl
	bts	Dma1FlipFlops, edx
	clc
	ret
@@@@:
	mov	byte ptr Dma1BaseAddr[ edx * 4 ][ 1 ], cl
	btc	Dma1FlipFlops, edx
	clc
	ret

get_count:
	push	eax
	push	edx

;	mov	edx, eax
;	mov	al, cl
;	out	dx, al

	pop	edx
	pop	eax

	mov	edx, eax
	shr	edx, 1
	mov	eax, edx
	add	edx, 4
	bt	Dma1FlipFlops, edx
	jc	@@F

	mov	byte ptr Dma1Count[ eax * 4 ], cl
	bts	Dma1FlipFlops, edx
	clc
	ret

@@@@:
	mov	byte ptr Dma1Count[ eax * 4 ][ 1 ], cl
	btc	Dma1FlipFlops, edx
	clc
	ret

is_dma1_page?:
	cmp	eax, DMA_CH0_PAGE
	jne	@@F
	mov	byte ptr Dma1BaseAddr[ 2 ], cl
	clc
	ret

@@@@:
	cmp	eax, DMA_CH1_PAGE
	jne	@@F
	mov	byte ptr Dma1BaseAddr[ 4 ][ 2 ], cl
	clc
	ret

@@@@:
	cmp	eax, DMA_CH2_PAGE
	jne	@@F
	mov	byte ptr Dma1BaseAddr[ 8 ][ 2 ], cl
	clc
	ret

@@@@:
	cmp	eax, DMA_CH3_PAGE
	jne	do_write
	mov	byte ptr Dma1BaseAddr[ 12 ][ 2 ], cl
	clc
	ret

do_write:
	mov	edx, eax
	mov	al, cl
	out	dx, al
	clc
	ret

not_dma_port:
	stc
	ret
WriteDMAPort	ENDP


;-----------------------------------------------------------------------------
;
;	Retires a DMA transfer.
;
;	In:	AL = channel
;
;-----------------------------------------------------------------------------
PUBLIC	RetireDma
RetireDma	PROC	USES	es eax ecx edx esi edi
	cmp	RetireDmaFlag, 0
	jne	@@F
	ret

@@@@:
	mov	RetireDmaFlag, 0
	movzx	eax, al

	mov	ecx, MAX_TASKS
	sub	edx, edx
seek_in_process:
	cmp	DmaIoRange[ edx * 8 ][ 4 ], 0
	jne	in_process
	inc	edx
	dec	ecx
	jnz	seek_in_process
	ret

in_process:
	TASK_PTR	FddSema4Own, ebx
	mov	edx, FddSema4Own
	cmp	edx, CurrentTask
	je	@@F

	mov	eax, (DosTask PTR fs:[ebx]).TaskPdb
	mov	cr3, eax

@@@@:

; Copy data from DMA system buffer to program's buffer.
	mov	esi, DmaBufAddr
	add	esi, OS_1ST_MB
	mov	edi, DmaIoRange[ edx * 8 ]
	mov	ecx, DmaIoRange[ edx * 8 ][ 4 ]
	push	fs
	pop	es

	cld
		rep	movs byte ptr es:[ edi ], es:[ esi ]

	TASK_PTR	CurrentTask, ebx
	mov	edx, FddSema4Own
	cmp	edx, CurrentTask
	je	@@F

	mov	eax, (DosTask PTR fs:[ebx]).TaskPdb
	mov	cr3, eax
@@@@:

; Clear in-process indicator (set range = 0)
	mov	DmaIoRange[ edx * 8 ], 0
	mov	DmaIoRange[ edx * 8 ][ 4 ], 0
;	mov	Dma1BaseAddr[ eax * 4  ], 0
;	mov	Dma1Count[ eax * 4 ], 0

; Unblock task.
;	mov	edx, CurrTaskPtr
;	and	(DosTask PTR fs:[edx]).TaskBlock, NOT DMA_REQUEST
;	jnz	@@F
;	and	(DosTask PTR fs:[edx]).TaskState, NOT TASK_BLOCKED
@@@@:
	ret

RetireDma	ENDP


;-----------------------------------------------------------------------------
;
;	DMA timer handler. If some DMA request is in progress, tests if it's
; completed.
;
;-----------------------------------------------------------------------------
PUBLIC	DmaTimer
DmaTimer	PROC
	mov	ecx, MAX_TASKS
	sub	edx, edx
seek_in_process:
	cmp	DmaIoRange[ edx * 8 ][ 4 ], 0
	jne	in_process
	inc	edx
	dec	ecx
	jnz	seek_in_process
	ret

in_process:
IF 0
	mov	cl, DmaMode
	and	cl, 3
	mov	ah, 1
	shl	ah, cl
	in	al, DMA1_STATUS
	test	al, ah
	jnz	complete
	ret

complete:
ENDIF

; Copy data from DMA system buffer to program's buffer.
	mov	esi, DmaBufAddr
	add	esi, OS_1ST_MB
	mov	edi, DmaIoRange[ edx * 8 ]
	mov	ecx, DmaIoRange[ edx * 8 ][ 4 ]
	push	es
	push	fs
	pop	es

	cld
		rep	movs byte ptr es:[ edi ], es:[ esi ]
	pop	es

; Clear in-process indicator (set range = 0)
	mov	DmaIoRange[ edx * 8 ], 0
	mov	DmaIoRange[ edx * 8 ][ 4 ], 0
	mov	Dma1BaseAddr[ 8 ], 0
	mov	Dma1Count[ 8 ], 0

; Unblock task.
	mov	edx, CurrTaskPtr
	and	(DosTask PTR fs:[edx]).TaskBlock, NOT DMA_REQUEST
	jnz	@@F
	and	(DosTask PTR fs:[edx]).TaskState, NOT TASK_BLOCKED
@@@@:
	ret

DmaTimer	ENDP


;-----------------------------------------------------------------------------
;
;	Emulate DMA. This will allow DOS programs work with DMA.
;
;-----------------------------------------------------------------------------
EmulateFDCIo	PROC
; Call emulate generic I/O procedure.
	mov	eax, offset ReadFDCPort
	mov	ecx, offset WriteFDCPort
	call	EmulateIo
	ret
EmulateFDCIo	ENDP


;-----------------------------------------------------------------------------
;
;	Reads a DMA port.
;
;	I: EAX = port
;	O: AL = value.
;	   CF = 0	-	OK
;	        1	-	error (wrong port).
;
;-----------------------------------------------------------------------------
ReadFDCPort	PROC	USES	edx
	cmp	eax, 3F0h
	jnb	@@F
	ret
@@@@:
	cmp	eax, 3F7h
	jna	@@F
	stc
	ret
@@@@:
	mov	edx, eax
	in	al, dx

	cmp	edx, 3F4h
	jne	@@F

	mov	ah, FdcStatus
	and	ah, 80h
	jnz	@@F
	mov	FdcStatus, al
	and	al, 80h
	jz	@@F

	push	eax
	mov	al, 2
	call	RetireDma
	pop	eax

@@@@:
	clc
	ret
ReadFDCPort	ENDP


;-----------------------------------------------------------------------------
;
;	Writes a DMA port.
;
;	I: EAX = port
;	   CL = value.
;	O: CF = 0	-	OK
;	        1	-	error (wrong port).
;
;-----------------------------------------------------------------------------
WriteFDCPort	PROC	USES	eax edx
	cmp	eax, 3F0h
	jnb	@@F
	ret
@@@@:
	cmp	eax, 3F7h
	jna	@@F
	stc
	ret
@@@@:
	mov	edx, eax
	mov	al, cl
	out	dx, al
	clc
	ret
WriteFDCPort	ENDP


;-----------------------------------------------------------------------------
;
;	Traps general devices ports. Patches the TSS I/O permission bitmap
; according to this:
;	1) If the current task is owner of a device, the ports are allowed
;	2) Else, ports are trapped.
;
;-----------------------------------------------------------------------------
PUBLIC	TrapGenDevPorts
TrapGenDevPorts	PROC	USES eax ebx ecx edx esi edi
	mov	ecx, NumGenDevs
	mov	edx, offset GenDevices
	mov	esi, TssBase
	movzx	edi, (Tss386 PTR fs:[esi]).IoTableBase

next_device:
; Device available?
	cmp	(GenDevice PTR [edx]).DevSema4.State, 0
	je	trap_ports

; CurrentTask is the device's owner?
	mov	eax, CurrentTask
	cmp	eax, (GenDevice PTR [edx]).DevSema4.Owner
	jne	trap_ports

; Allow access to ports.
	sub	ebx, ebx
@@@@:
	movzx	eax, (GenDevice PTR [edx]).Ports[ebx*2]
	btc	fs:[esi][edi], eax
	inc	ebx
	cmp	bl, (GenDevice PTR [edx]).NPorts
	jb	@@B
	jmp	cont

trap_ports:
	sub	ebx, ebx
@@@@:
	movzx	eax, (GenDevice PTR [edx]).Ports[ebx*2]
	bts	fs:[esi][edi], eax
	inc	ebx
	cmp	bl, (GenDevice PTR [edx]).NPorts
	jb	@@B

cont:
	add	edx, SIZEOF (GenDevice)
	dec	ecx
	jnz	next_device

	ret
TrapGenDevPorts	ENDP


;-----------------------------------------------------------------------------
;
;	Releases general devices ports and allows access to them.
;
;-----------------------------------------------------------------------------
PUBLIC	RelGenDevPorts
RelGenDevPorts	PROC	USES eax ebx ecx edx esi edi
	mov	ecx, NumGenDevs
	mov	edx, offset GenDevices
	mov	esi, TssBase
	movzx	edi, (Tss386 PTR fs:[esi]).IoTableBase

next_device:
	sub	ebx, ebx
@@@@:
	movzx	eax, (GenDevice PTR [edx]).Ports[ebx*2]
	btc	fs:[esi][edi], eax
	inc	ebx
	cmp	bl, (GenDevice PTR [edx]).NPorts
	jb	@@B

	add	edx, SIZEOF (GenDevice)
	dec	ecx
	jnz	next_device

	ret
RelGenDevPorts	ENDP


;-----------------------------------------------------------------------------
;
;	Releases general devices semaphores trapped by the CurrentTask.
; Called when the task is being deleted.
;
;-----------------------------------------------------------------------------
Public	RelGenDevSema4s
RelGenDevSema4s	PROC	USES	gs eax ebx ecx edx esi edi
	mov	ecx, NumGenDevs
	mov	edx, offset GenDevices
	mov	esi, TssBase
	movzx	edi, (Tss386 PTR fs:[esi]).IoTableBase

next_device:
; If a device is avaliable, go ahead.
	cmp	(GenDevice PTR [edx]).DevSema4.State, 0
	je	cont

; Release a semaphore. If a task wasn't device's owner, go ahead.
	mov	eax, CurrentTask
	mov	ebx, (GenDevice PTR [edx]).DevSema4.Owner

	push	eax
	push	ecx
	push	ds
	pop	gs
	lea	ecx, (GenDevice PTR [edx]).DevSema4
	call	Sema4Up
	pop	ecx
	pop	eax

	cmp	eax, ebx
	jne	cont

IF 0
; A task was semaphore's owner.
	sub	ebx, ebx
@@@@:
	movzx	eax, (GenDevice PTR [edx]).Ports[ebx*2]
	btc	fs:[esi][edi], eax
	inc	ebx
	cmp	bl, (GenDevice PTR [edx]).NPorts
	jb	@@B
ENDIF

cont:
	add	edx, SIZEOF (GenDevice)
	dec	ecx
	jnz	next_device

	ret
RelGenDevSema4s	ENDP



;-----------------------------------------------------------------------------
;
;	Emulate access to general device's port.
;
;-----------------------------------------------------------------------------
EmulateGenDevIo	PROC	USES	edx
; Call emulate generic I/O procedure.
	mov	eax, offset ReadGenDevPort
	mov	ecx, offset WriteGenDevPort
	call	EmulateIo
	ret
EmulateGenDevIo	ENDP


;-----------------------------------------------------------------------------
;
;	Frond-end for read access to general device port.
;
;-----------------------------------------------------------------------------
ReadGenDevPort	PROC	USES edx
	sub	edx, edx
	call	AccessGenDevPort
	ret
ReadGenDevPort	ENDP


;-----------------------------------------------------------------------------
;
;	Frond-end for read access to general device port.
;
;-----------------------------------------------------------------------------
WriteGenDevPort	PROC	USES edx
	mov	edx, 1
	call	AccessGenDevPort
	ret
WriteGenDevPort	ENDP


;-----------------------------------------------------------------------------
;
;	Reads/Writes a general device port.
;
;	I: EAX = port
;	   (CL = value).
;	   DL = access (0 = read, 1 = write).
;	O: CF = 0	-	OK
;	        1	-	error (wrong port).
;
;-----------------------------------------------------------------------------
AccessGenDevPort	PROC	USES	gs ebx ecx edx esi edi
LOCAL	Access: dword,
	Port: dword,
	Value: byte

	mov	Access, edx
	mov	Port, eax
	mov	Value, cl

	mov	edx, offset	GenDevices
	mov	ecx, NumGenDevs
next_device:
	sub	ebx, ebx
next_port:
	movzx	esi, (GenDevice PTR [edx]).Ports[ebx*2]
	cmp	eax, esi
	je	found_port
	inc	ebx
	cmp	bl, (GenDevice PTR [edx]).NPorts
	jb	next_port

	add	edx, SIZEOF (GenDevice)
	dec	ecx
	jnz	next_device

; A port being accessed is not found.
	stc
	ret

found_port:
;
; Try to acquire the semaphore. This may acquire a semaphore or put the task
; to sleep and return in a new context.
;
	mov	eax, CurrentTask
	push	ds
	pop	gs
	lea	ecx, (GenDevice PTR [edx]).DevSema4
	call	Sema4Down

; If the semaphore was acquired, allow access to ports.
	test	al, al			; 0 means acquired.
	jz	@@F

;
; If a semaphore wasn't acquired, the CurrentTask is blocked on an I/O
; instruction. ExcOffs will not be updated.
;
	mov	NoEipUpdate, 1
	jmp	ok_ret

@@@@:
; Allow access to ports.
	mov	esi, TssBase
	movzx	edi, (Tss386 PTR fs:[esi]).IoTableBase

	sub	ebx, ebx
@@@@:
	movzx	eax, (GenDevice PTR [edx]).Ports[ebx*2]
	btc	fs:[esi][edi], eax
	inc	ebx
	cmp	bl, (GenDevice PTR [edx]).NPorts
	jb	@@B

; Now emulate the I/O instruction.
	cmp	Access, 0
	jne	do_write

; Read.
	mov	edx, Port
	in	al, dx
	jmp	ok_ret
do_write:
; Write.
	mov	edx, Port
	mov	al, Value
	out	dx, al

ok_ret:
	clc
	ret
AccessGenDevPort	ENDP


CODE32	ENDS

END
@


0.52
log
@Stack segment for Tripple-DOS changed to 32-bit default. 16-bit stack didn't work with DPMI clients that set up stack to 32 bits and ESP > 64K! Now DJGPP stubbed programs work, but there is some problem when they return.
@
text
@d12 1
a12 1
; law, shall Vadim Drubetsky aka the Black Phantoms be liable for any special,
d160 1
d2793 5
a2797 1
	mov	eax, (PIT_FREQUENCY / PIT_TICK_TO_SEC)
@


0.51
log
@Added general devices synchronization mechanism.
It's implemented for COM1 and COM2.
It causes problems with a keyboard.
@
text
@@


0.50
log
@Fixed HDD/FDD synchronization problem (trapped opcodes were overwriting each other).
@
text
@d73 2
d189 20
d212 3
d1365 4
d1409 3
d1420 6
d2031 3
d2049 1
a3326 1
;int 3
d3432 271
@


0.49
log
@Fixes version includes:
1) variable mapping of DPMI service pages at C0000, D0000, E0000 instead of a hardcoded address.
2) added 2 32-bit XMS functions and XMS service table is fixed.
3) detection and diagnostic is improved.
@
text
@d179 1
d3197 1
d3202 3
a3204 3
; Switch to the task that initiated the operation.
	mov	eax, edx
	call	SwitchTask
d3218 9
d3228 2
a3229 2
;	mov	DmaIoRange[ edx * 8 ], 0
;	mov	DmaIoRange[ edx * 8 ][ 4 ], 0
@


0.48
log
@Enabled XMS 3.0 inteface
@
text
@d67 2
d76 1
a76 1
	CrtId		DB	?
d270 1
d286 10
a349 2
	mov	ax, 3
	int	10h		; Set mode 3.
@


0.47
log
@DMA partial virtualization is made - Tripple DOS now works with floppy!
@
text
@d56 2
d70 1
d3185 8
@


0.46
log
@Fixed a bug that didn't allow Tripple DOS work with DOS loaded HIGH
@
text
@d42 1
d47 2
d63 1
d66 2
d154 27
d182 2
d1316 8
a1323 1

a2664 1

d2669 1
d2678 19
d2720 1
d2734 1
a2734 1
; If valie is smaller than one kernel tick, set one kernel tick.
d2736 1
d2743 1
d2883 475
@


0.45
log
@The shareware beta release
@
text
@d2683 3
@


0.44
log
@Bug fixes:
1) Checks for open file name (EDX to DX) problem
2) Reporting of the protected mode exception reboot
@
text
@d1 27
d37 2
d1278 3
d1282 1
d2698 118
@


0.43
log
@Bug fixes:
1) Lower word in translation structure on real mode stack was being destroyed - very annoying.
2) Saved exception number was moved to task structure to allow multiple DPMI tasks work.
3 copies of WCC386 worked!
@
text
@d70 3
d1185 72
a1271 8
; If not V86 mode, return error.
	test	ExcEflags, FL_VM
	jnz	@@F
	test	ExcSeg, 3
	jnz	@@F
	stc
	ret
@@@@:
d1298 1
a1298 31
; Check faulting instruction.
	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebx, ExcEflags
	call	PointerToLinear

; Skip prefixes and set defaults.
	call	SkipPrefixes

;
; Here all prefixes are skipped. Check opcode that failed. If opcode is not
; an I/O opcode, return error.
;
	mov	esi, eax

	mov	al, fs:[esi]

	mov	edi, offset IoOpcodes
	mov	ecx, IO_OPCODES
	cld
		repne	scasb
	je	@@F

	stc
	ret

@@@@:
	not	ecx

	add	ecx, IO_OPCODES
	jmp	IoOpcodesJmpTbl[ecx*4]
a2395 1
;	This is a GPF callback.
a2403 8
; If not V86 mode, return error.
	test	ExcEflags, FL_VM
	jnz	@@F
	test	ExcSeg, 3
	jnz	@@F
	stc
	ret
@@@@:
a2408 1

d2471 1
a2471 1
;	Dummy procedure instead of write to keyboard ports.
d2504 160
@


0.42
log
@1) Added XMS server
2) XMS server is on top DPMI memory manager, so DPMI memory handln are moved
@
text
@@


0.41
log
@Bug fixes:
1) Virtual I/O jump table (very annoying!)
2) IsFileOpen() bug if file name is 0.
@
text
@@


0.40
log
@DPMI server fixes:
1) Locker real mode and protected mode stacks usage fixed: reentrancy allowed.
2) Modes switches fixed.
@
text
@d7 1
d61 1
a68 1
IO_OPCODES	=	$ - offset IoOpcodes
d1189 1
d1239 1
d1259 1
d1995 2
a1996 7
	push	eax
	mov	eax, CurrentTask
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	mov	edx, (DosTask PTR fs:[eax]).TaskVideoState
	pop	eax
d2044 1
d2107 1
a2107 1
; Read sequencer data register.
a2182 1
;	   FS:EDX -> video context structure.
d2187 1
a2187 1
WriteVideoPort	PROC	USES eax ebx esi
d2201 2
a2202 7
	push	eax
	mov	eax, CurrentTask
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	mov	edx, (DosTask PTR fs:[eax]).TaskVideoState
	pop	eax
d2270 1
a2270 1
	cmp	eax, V_SEQ_DATA
d2293 1
a2293 1
	jnb	@@F
d2297 1
d2367 1
d2379 1
d2381 1
@


0.39
log
@Bug fixed: raw mode switches.
@
text
@@


0.38
log
@Bugs fixed:
1) PointerToLinear() check
2) Default interrupt redirection to V86 mode
@
text
@@


0.37
log
@Bug fixed: reflecting PM to VM interrupt.
@
text
@d66 1
a66 1
			DD	offset _op_outsb, offset op_outsw
d429 1
a429 1
	mov	al, V_CRT_CURSOR_ADDR_LSB	; CRT cursor position LSB index
d433 1
a433 1
	mov	al, V_CRT_CURSOR_ADDR_MSB	; CRT cursor position MSB index
d551 1
a551 1
	or	ah, V_ATTR_SCR_ENABLE
d1139 1
a1139 1
	or	ah, V_ATTR_SCR_ENABLE
@


0.36
log
@Bug fixes:
1) CreatePageTable() called from HeapAllocMem()
2) Zero allocated PDB for new task
@
text
@@


0.35
log
@HeapAllocMem() bug fixed; free DPMI memory allocated fixed.
@
text
@d23 7
a29 7
		INCLUDE	PHLIB.INC
		INCLUDE	DEF.INC
		INCLUDE	DEVICES.INC
		INCLUDE	X86.INC
		INCLUDE	TASKMAN.INC
		INCLUDE	CORE.INC
		INCLUDE	PHLIB32.MCR
d31 2
d1198 2
d1222 1
a1222 1
EmulateIo	PROC	USES eax ecx edx esi edi
d1230 4
a1233 3
	movzx	eax, ExcSeg
	shl	eax, 4
	add	eax, ExcOffs
d1335 14
a1348 3
	movzx	ecx, word ptr ExcEs
	shl	ecx, 4
	add	ecx, eax
d1403 14
a1416 3
	movzx	ecx, word ptr ExcEs
	shl	ecx, 4
	add	ecx, eax
d1478 14
a1491 3
	movzx	ecx, word ptr ExcEs
	shl	ecx, 4
	add	ecx, eax
d1635 13
a1647 2
	shl	ebx, 4
	add	ebx, eax
d1713 13
a1725 2
	shl	ebx, 4
	add	ebx, eax
d1795 13
a1807 2
	shl	ebx, 4
	add	ebx, eax
d1863 12
a1874 2
	movzx	eax, ExcSeg
	shl	eax, 4
d2374 2
@


0.34
log
@Bug fixes:
1) Initial pages map allocation
2) Translation services params
3) DPMI clean up memory release -- almost
4) INT 21h AH=4Ch in protected mode.
@
text
@@


0.33
log
@Initial full release - all DPMI functions are written! Half are not tet.
@
text
@a2 1
	EXTRN	TraceFlag:byte
@


0.32
log
@Translation services work.
@
text
@@


0.31
log
@1) Interrupt redirection works
2) HeapAllocMem() bug fixes
DPMI traps fixed
@
text
@@


0.30
log
@DOS block functions are written and work. Callback to real mode mechanism established. Tests are still brief.
@
text
@@


0.29
log
@First DPMI selector functions work (Hello, world).
@
text
@@


0.28
log
@Initial DPMI switch works.
@
text
@@


0.27
log
@Solves INT 28 block problems (doesn't lock).
@
text
@@


0.26
log
@Bugs fixed:
1) Store open file name
2) Store DOS function per process
3) Imperfect INT 13 semaphore handling.
@
text
@@


0.25
log
@Fixed bug in IsFileOpen proc.
@
text
@@


0.24
log
@Removed unnecessary dynamic allocations.
@
text
@a2356 25
; If keyboard queue is not empty, set interrupt pending.
	cmp	ecx, KbdQTail
	je	happy_ret
; If foreground task is current, set VIP for IRQ 1. Else set foreground 
; task's IRQ 1 pending.
	mov	ecx, ForegroundTask
	cmp	ecx, CurrentTask
	jne	@@F
	or	VirtualIp, 2		; Set IRQ 1 pending.
	jmp	happy_ret

@@@@:
	push	eax
	push	edx

	mov	eax, ForegroundTask
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	mov	(DosTask PTR fs:[eax]).TaskVirtualIp, 2

	pop	edx
	pop	eax

happy_ret:
d2372 1
a2372 1
WriteKeyboardPort	PROC
d2374 1
a2374 1
	je	@@F
d2376 10
a2385 1
	je	@@F
d2389 5
a2393 1
@@@@:
d2397 2
@


0.23
log
@1) File sharing handled.
@
text
@@


0.22
log
@1) Fully split task blocking and waiting for event.
2) Annoying bug fixed (TASK_PTR).
@
text
@@


0.21
log
@1) Inproved task state handling (nesting allowed due to bit mask).
2) TASK_PTR macro used.
3) Bugs fixed.
4) X86.MCR is out of project.
@
text
@@


0.20
log
@Task locks on wait for events are added.
@
text
@a24 1
		INCLUDE	X86.MCR
@


0.19
log
@Trap wait on keyboard (INT 16h / 0, 10h).
Bug fixes in memory allocation.
@
text
@d51 4
a54 4
	OperandSize	DB	?	; 16/32 bits operand.
	AddressSize	DB	?	; 16/32 bits addressing.
	SegPrefix	DB	?	; Segment prefix.
	RepPrefix	DB	?	; REP prefix specified.
a1226 6
; Default 16 bits, no segment override.
	mov	AddressSize, 0
	mov	OperandSize, 0
	mov	SegPrefix, 0
	mov	RepPrefix, 0

d1816 1
d1818 6
d1828 2
d1879 6
a1884 6
;	cmp	byte ptr fs:[eax], OP_REPZ_PREFIX
;	jne	@@F
;	mov	RepPrefix, OP_REPZ_PREFIX
;	inc	eax
;	jmp	skip_prefixes
;@@@@:
@


0.18
log
@Keyboard virtualized.
File I/O interface for kernel is added.
@
text
@@


0.17
log
@Int 13h locking improvements, bug fixes (NC running)
@
text
@d9 1
d22 1
d56 13
d75 6
d1187 2
a1188 2
EmulateVideoIo	PROC	USES eax ecx edx esi
; If current task is a foreground task, return.
d1192 6
a1197 1
int 14h
d1201 26
d1241 2
a1242 2
; Here all prefixes are skipped. Check opcode that failed.
; Opcodes IN/OUT with IMM8 are not checked.
d1245 16
a1260 6
; Set FS:EDX -> current task's video state structure.
	mov	eax, CurrentTask
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	mov	edx, (DosTask PTR fs:[eax]).TaskVideoState
d1262 1
a1262 2
	cmp	byte ptr fs:[esi], OP_IN8_DX
	jne	in16_dx?
d1265 2
a1266 1
	call	ReadVideoPort
d1270 7
a1276 3
in16_dx?:
	cmp	byte ptr fs:[esi], OP_IN16_DX
	jne	insb?
d1278 1
d1283 1
d1285 2
a1286 1
	call	ReadVideoPort
d1289 2
a1290 1
	call	ReadVideoPort
d1293 1
a1293 1
	
d1297 1
d1299 2
a1300 1
	call	ReadVideoPort
d1304 2
a1305 1
	call	ReadVideoPort
d1309 2
a1310 1
	call	ReadVideoPort
d1313 2
a1314 1
	call	ReadVideoPort
d1318 9
a1326 4
insb?:
	cmp	byte ptr fs:[esi], OP_INSB
	jne	insw?

d1343 2
a1344 1
	call	ReadVideoPort
d1375 1
a1375 4
insw?:
	cmp	byte ptr fs:[esi], OP_INSW
	jne	out8_edx?

d1400 2
a1401 1
	call	ReadVideoPort
d1405 2
a1406 1
	call	ReadVideoPort
d1464 2
a1465 1
	call	ReadVideoPort
d1469 2
a1470 1
	call	ReadVideoPort
d1474 2
a1475 1
	call	ReadVideoPort
d1479 2
a1480 1
	call	ReadVideoPort
d1514 1
a1514 3
out8_edx?:
	cmp	byte ptr fs:[esi], OP_OUT8_DX
	jne	out16_edx?
d1518 2
a1519 1
	call	WriteVideoPort
d1522 7
a1528 3
out16_edx?:
	cmp	byte ptr fs:[esi], OP_OUT16_DX
	jne	outsb?
d1530 1
d1535 1
d1537 2
a1538 1
	call	WriteVideoPort
d1542 2
a1543 1
	call	WriteVideoPort
d1547 1
a1547 1
; OUT DX, AX.
d1549 1
d1551 2
a1552 5
	call	WriteVideoPort
	movzx	eax, word ptr ExcEdx
	inc	eax
	mov	cl, byte ptr ExcEax[1]
	call	WriteVideoPort
d1556 2
a1557 1
	call	WriteVideoPort
d1561 2
a1562 1
	call	WriteVideoPort
d1566 2
a1567 1
	call	WriteVideoPort
d1570 6
a1575 3
outsb?:
	cmp	byte ptr fs:[esi], OP_OUTSB
	jne	outsw?
d1577 1
d1611 1
a1611 1
	call	WriteVideoPort
d1641 1
a1641 4
outsw?:
	cmp	byte ptr fs:[esi], OP_OUTSW
	jne	err_ret

d1678 2
a1679 1
	call	WriteVideoPort
d1683 1
a1683 1
	call	WriteVideoPort
d1749 2
a1750 1
	call	WriteVideoPort
d1754 2
a1755 1
	call	WriteVideoPort
d1759 2
a1760 1
	call	WriteVideoPort
d1764 2
a1765 1
	call	WriteVideoPort
d1810 2
a1811 1
EmulateVideoIo	ENDP
a1890 1
;	   FS:EDX -> video state.
d1892 2
d1896 21
a1916 1
ReadVideoPort	PROC	USES ecx
d1927 1
d1939 1
d1948 1
d1953 1
d1963 1
d1967 1
d1976 1
d1985 1
d1990 1
d1998 1
d2007 1
d2012 1
d2020 1
d2030 1
d2035 1
d2045 1
d2058 1
d2065 1
d2071 1
d2077 1
d2085 1
d2090 1
d2102 2
a2103 1
;	O:
d2107 21
d2137 1
d2149 1
d2160 1
d2164 1
d2172 1
d2183 1
d2191 1
d2202 1
d2221 1
d2233 1
d2244 1
d2257 1
d2264 1
d2271 1
d2274 1
d2278 129
@


0.16
log
@Debug improvements (commands); VGA ports partial virtualizing
@
text
@a459 2
	cli

a473 1
	sti
d1171 1
@


0.15
log
@Debug improvements: hardware breakpoint
@
text
@a1151 1
int 3
a1170 1
int 3
@


0.14
log
@Bug fixes; debug improvements
@
text
@@


0.13
log
@Proper CPL 0 stack management; foreground task boost on event
@
text
@d28 1
d39 2
a40 2
	PUBVAR	Rows, DB, 25		; Rows per screen
	PUBVAR	Columns, DB, 80		; Columns per row.
d72 2
d80 2
d83 7
d363 1
a363 1
GetAsciiCode	PROC	USES es ecx edi
a364 2
	push	ds
	pop	es
d371 8
a378 2
	
	mov	al, [edi + (CHAR_TBL_LEN - 1)]
a383 11
IF 0
	pushad
	push	eax
	mov	eax, 0100h
	call	GotoXy
	pop	eax
	mov	ah, 07h
	call	TtyChar
	popad
ENDIF

d408 1
a408 1
	mov	al, V_CRT_ST_ADDR_LSB	; CRT cursor position LSB index
d412 1
a412 1
	mov	al, V_CRT_ST_ADDR_MSB	; CRT cursor position MSB index
d1152 1
d1172 1
@


0.12
log
@Bug fixes: 5th task, VGA co40/co80 restore
@
text
@d498 3
a544 3
; Save CRT registers.
	SAVE_BUNCH_REGS	ebx, V_CRT_REGS

d1076 1
a1076 1
	mov	edi, esi
d1078 3
a1080 2
	mov	edx, V_VGA_ENABLE
	mov	al, 1
d1082 7
d1090 2
a1131 28

; Restore CRT registers.

; Enable write to CRT registers 0-7.
	mov	edx, ebx
	mov	al, V_Crt_VERT_RETRACE_END
	out	dx, al
	inc	edx
	in	al, dx
	dec	edx
	and	al, 7Fh
	mov	ah, al
	mov	al, V_Crt_VERT_RETRACE_END
	out	dx, ax

; Reset display system.
	mov	edx, ebx
	mov	al, V_Crt_MODE_CTL
	out	dx, al
	inc	edx
	in	al, dx
	dec	edx
	and	al, 7Fh
	mov	ah, al
	mov	al, V_Crt_MODE_CTL
	out	dx, ax

	REST_BUNCH_REGS	ebx, V_CRT_REGS
@


0.11
log
@Memory allocation enhance; bug fixes
@
text
@d495 1
a497 3
; Save CRT registers.
	SAVE_BUNCH_REGS	ebx, V_CRT_REGS

d542 3
d589 2
d596 1
a726 1

d833 2
d840 1
d1076 5
a1080 2
; Restore CRT registers.
	REST_BUNCH_REGS	ebx, V_CRT_REGS
d1122 28
@


0.10
log
@VGA save/restore state fixed; bug fixes
@
text
@a0 8
			INCLUDE	PHLIB.INC
			INCLUDE	X86.MCR
			INCLUDE	DEF.INC
			INCLUDE	DEVICES.INC
			INCLUDE	X86.INC
			INCLUDE	TASKMAN.INC


d22 8
d57 9
d82 1
a87 1
.486p
d166 2
a167 2
	mov	VideoTxtBuf, 0B0000h
	mov	VideoGfxBuf, 0B0000h
d171 2
a172 2
	mov	VideoTxtBuf, 0B8000h
	mov	VideoGfxBuf, 0A0000h
d324 2
a325 1
	out	21h, al
a326 1

d351 1
a351 1
GetAsciiCode	PROC
d368 1
d377 1
d396 1
a396 1
	mov	edx, 3D4h
d403 3
a405 6
	mov	al, 0Fh		; CRT cursor position LSB index
	out	dx, al
	inc	edx
	mov	al, cl
	out	dx, al
	dec	edx
d407 3
a409 5
	mov	al, 0Eh		; CRT cursor position MSB index
	out	dx, al
	inc	edx
	mov	al, ch
	out	dx, al
a485 1
	mov	eax, SIZEOF VIDEO_CONTEXT
d490 1
a491 1
	mov	(VIDEO_CONTEXT PTR es:[edi]).MiscOutput, al
d585 11
a595 1
; Graphics modes.
d598 47
a644 1
	mov	edx, (0A0000h + 20000h) SHR 12
d646 18
d665 1
d679 1
a679 1
; Text modes. Reprogram bit plane select to access plane 2.
d688 2
a689 2
	mov	ah, 2
	out	dx, ax			; Set bit plane 2.
d691 1
a691 1
; Disable odd bit planes.
d701 1
a702 1
;	or	ah, 4
d710 1
a710 1
	and	ah, NOT 00001110b	; Map memory to A0000 - BFFFF
d771 2
d775 1
d785 1
d827 11
a837 1
; Graphics modes.
d840 48
a887 1
	mov	edx, (0A0000h + 20000h) SHR 12
d889 18
d908 1
d922 1
a922 1
; Disable odd bit planes.
d932 1
a933 1
;	or	ah, 4
d1028 2
d1041 1
d1055 5
a1062 1
	sub	eax, eax
d1067 1
a1113 5
; Restore misc. output register.
	lods	byte ptr es:[esi]
	mov	edx, V_MISC_OUT
	out	dx, al

d1941 1
a1941 1
WriteVideoPort	PROC	USES ebx esi
@


0.9
log
@VGA state save/restore
@
text
@d13 16
a29 1

d47 6
d61 1
a61 1
			DB	1Fh, 14h, 16h, 2Fh, 11h, 2Dh, 15h, 2Ch
d67 1
a67 1
			DB	's', 't', 'u', 'v', 'w', 'x', 'y', 'z'
d486 1
a486 1
	mov	(VIDEO_CONTEXT PTR es:[edi]).Misc_Output, al
d535 1
d599 12
d621 2
a622 1
	or	ah, 4
a625 11
; Reprogram bit plane select to access planes 2 & 3.
	mov	al, V_Seq_BIT_PLANE_WRITE
	out	dx, al
	inc	edx
	in	al, dx
	dec	edx
	mov	bl, al			; Save previous bit plane mask.
	mov	al, V_Seq_BIT_PLANE_WRITE
	mov	ah, 4
	out	dx, ax			; Set bit plane 2.

d629 3
a631 2
	mov	ah, TempMemMode
	and	ah, NOT 00001100b	; Map memory to A0000 - BFFFF
d639 4
d651 2
a652 2
	mov	edx, V_SEQ_ADDR
	mov	al, V_Seq_BIT_PLANE_WRITE
d772 2
a773 1
	or	ah, 4
d777 2
a778 3
; Text modes. Reprogram bit plane select to access plane 2.
	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_BIT_PLANE_READ
a781 1
	mov	bl, al			; Save previous bit plane mask (BL).
d783 3
a785 2
	mov	al, V_Gfx_BIT_PLANE_READ
	mov	ah, 2
d788 1
a788 1
; Set read mode 0. (EDX = V_GFX_ADDR).
d802 1
a802 1
	mov	ah, TempMemMode
d804 1
d812 4
d824 2
a825 2
	mov	edx, V_GFX_ADDR
	mov	al, V_Gfx_BIT_PLANE_READ
d828 1
d849 3
a851 3
	mov	edi, 0B8000h		; Restore characters and attributes.
	mov	eax, 0B8000h SHR 12
	mov	edx, (0B8000h + 8000h) SHR 12
d942 1
d954 959
@


0.8
log
@Synchronization of system services; bug fixes
@
text
@d6 1
d29 3
d448 469
@


0.7
log
@Working preemptive multitasking. Interrupts are reported to ALL tasks. Different tasks cannot work with the same device.
@
text
@@


0.7.0.1
log
@Attempt to synchronize disks with semaphores
@
text
@@


0.6
log
@Working non-preemptive multitasking
@
text
@d15 1
d28 1
d43 5
d98 1
a101 1
;	IODelay
a105 1
;	IODelay
a112 1
;	IODelay
d411 34
@


0.5
log
@Working V86 emulation version!
@
text
@a9 1
	EXTRN	Emulated:byte
a10 1

a269 1
;ASSUME	CS:CODE32, DS:DATA
d351 1
a351 1
GotoXy		PROC
d389 1
a389 1
TtyChar		PROC	USES	es
@


0.4
log
@First V86 emulation version
@
text
@a0 1
 ~ ~ ~ ~ ~  ~ ~ ~ . n s     ~~~~~~~NS  o:%:%  o:%4_                                                                                                                                                                                                                                                                                                                                                                                                                                                                    .INC
d4 2
d7 9
d25 18
d62 1
d78 1
d96 1
a96 1
	IODelay
d101 1
a101 1
	IODelay
d109 1
a109 1
	IODelay
d269 143
@


0.4.0.1
log
@Bug fix for 0.4
@
text
@d1 1
a4 6
			INCLUDE	DEVICES.INC
			INCLUDE	X86.INC


	EXTRN	AddGdtSegment: near

@


0.3
log
@Port of previous version for 32 bits.
@
text
@d1 1
a1 20
;=============================================================================
;
;				DEVICES.ASM
;				-----------
;	Basic devices programming for MULTIX32.
; Routines in this file initialize various vital devices in real mode and
; re-initialize in 16-bit protected more before switch back to real mode.
;
;	For MASM v6.1x.
;
;=============================================================================

;
; Extern procs.
;
	EXTRN	AddGdtSegment: near


			INCLUDE	DEVICES.INC
			INCLUDE	X86.INC
@


0.2
log
@Support for BIOS calls in V86 mode
@
text
@d5 3
a7 1
;	Basic devices programming for MULTIX32
d23 1
d29 2
a30 2
	VBufTextSel	DW	?	; GDT selector for text video buffer.
	VBufGfxSel	DW	?	; GDT selector for gfx. video buffer.
d32 2
a33 2
	Rows		DB	25	; Rows per screen
	Columns		DB	80	; Columns per row.
@


0.1
log
@16/05/98	Initial chceck-in.
@
text
@a131 30
;----------------------------------------------------------------------------
;
;	DS:SI -> String (0 - terminated).
;	DL:DH = column: row
;	BL    = color
;
;	R:	PROTMODE.
;
;-----------------------------------------------------------------------------
PUBLIC	PmWriteStr
PmWriteStr	PROC	near USES es ax cx
	call	StrLen
	mov	cx, ax
	mov	al, dh
	mul	Columns
	add	al, dl
	adc	ah, 0
	shl	ax, 1
	mov	di, ax
	mov	es, VBufTextSel
	mov	ah, bl
	cld
write_loop:
	lodsb
	stosw
	loop	write_loop
	ret
PmWriteStr	ENDP


d222 30
@
