head	0.53;
access;
symbols;
locks
	BlackPhantom:0.53
	BlackPhantom:0.7.0.1; strict;
comment	@;; @;


0.53
date	2002.05.13.03.00.48;	author BlackPhantom;	state Exp;
branches;
next	0.52;

0.52
date	2001.02.13.04.09.54;	author BlackPhantom;	state Exp;
branches;
next	0.51;

0.51
date	2001.02.12.02.23.02;	author BlackPhantom;	state Exp;
branches;
next	0.50;

0.50
date	2001.02.02.23.44.36;	author BlackPhantom;	state Exp;
branches;
next	0.49;

0.49
date	2001.01.19.19.25.00;	author BlackPhantom;	state Exp;
branches;
next	0.48;

0.48
date	2000.12.27.05.36.43;	author BlackPhantom;	state Exp;
branches;
next	0.47;

0.47
date	2000.11.19.00.48.14;	author BlackPhantom;	state Exp;
branches;
next	0.46;

0.46
date	2000.08.31.02.13.37;	author BlackPhantom;	state Exp;
branches;
next	0.45;

0.45
date	2000.08.15.23.51.37;	author BlackPhantom;	state Exp;
branches;
next	0.44;

0.44
date	2000.03.23.14.09.09;	author BlackPhantom;	state Exp;
branches;
next	0.43;

0.43
date	99.08.10.02.48.18;	author BlackPhantom;	state Exp;
branches;
next	0.42;

0.42
date	99.08.06.17.48.52;	author BlackPhantom;	state Exp;
branches;
next	0.41;

0.41
date	99.07.16.03.18.20;	author BlackPhantom;	state Exp;
branches;
next	0.40;

0.40
date	99.06.05.20.07.01;	author BlackPhantom;	state Exp;
branches;
next	0.39;

0.39
date	99.05.28.22.41.24;	author BlackPhantom;	state Exp;
branches;
next	0.38;

0.38
date	99.05.28.18.27.56;	author BlackPhantom;	state Exp;
branches;
next	0.37;

0.37
date	99.05.28.04.20.40;	author BlackPhantom;	state Exp;
branches;
next	0.36;

0.36
date	99.05.27.22.22.07;	author BlackPhantom;	state Exp;
branches;
next	0.35;

0.35
date	99.05.23.19.52.27;	author BlackPhantom;	state Exp;
branches;
next	0.34;

0.34
date	99.05.23.15.13.32;	author BlackPhantom;	state Exp;
branches;
next	0.33;

0.33
date	99.05.21.02.27.28;	author BlackPhantom;	state Exp;
branches;
next	0.32;

0.32
date	99.05.19.01.13.28;	author BlackPhantom;	state Exp;
branches;
next	0.31;

0.31
date	99.05.17.18.49.52;	author BlackPhantom;	state Exp;
branches;
next	0.30;

0.30
date	99.05.11.17.10.49;	author BlackPhantom;	state Exp;
branches;
next	0.29;

0.29
date	99.05.06.22.37.51;	author BlackPhantom;	state Exp;
branches;
next	0.28;

0.28
date	99.05.05.16.38.55;	author BlackPhantom;	state Exp;
branches;
next	0.27;

0.27
date	99.04.19.21.02.51;	author BlackPhantom;	state Exp;
branches;
next	0.26;

0.26
date	99.04.18.12.54.59;	author BlackPhantom;	state Exp;
branches;
next	0.25;

0.25
date	99.04.17.03.11.27;	author BlackPhantom;	state Exp;
branches;
next	0.24;

0.24
date	99.04.14.18.28.12;	author BlackPhantom;	state Exp;
branches;
next	0.23;

0.23
date	99.04.14.16.43.57;	author BlackPhantom;	state Exp;
branches;
next	0.22;

0.22
date	99.04.12.18.51.50;	author BlackPhantom;	state Exp;
branches;
next	0.21;

0.21
date	99.04.11.12.52.23;	author BlackPhantom;	state Exp;
branches;
next	0.20;

0.20
date	99.04.05.03.15.12;	author BlackPhantom;	state Exp;
branches;
next	0.19;

0.19
date	99.03.30.23.45.44;	author BlackPhantom;	state Exp;
branches;
next	0.18;

0.18
date	99.03.29.18.33.30;	author BlackPhantom;	state Exp;
branches;
next	0.17;

0.17
date	99.03.22.22.40.13;	author BlackPhantom;	state Exp;
branches;
next	0.16;

0.16
date	99.03.18.04.09.05;	author BlackPhantom;	state Exp;
branches;
next	0.15;

0.15
date	99.03.16.02.16.25;	author BlackPhantom;	state Exp;
branches;
next	0.14;

0.14
date	99.03.16.00.23.39;	author BlackPhantom;	state Exp;
branches;
next	0.13;

0.13
date	99.03.13.23.36.05;	author BlackPhantom;	state Exp;
branches;
next	0.12;

0.12
date	99.03.12.22.09.18;	author BlackPhantom;	state Exp;
branches;
next	0.11;

0.11
date	99.03.09.04.23.38;	author BlackPhantom;	state Exp;
branches;
next	0.10;

0.10
date	99.03.01.23.10.12;	author BlackPhantom;	state Exp;
branches;
next	0.9;

0.9
date	99.02.25.21.57.36;	author BlackPhantom;	state Exp;
branches;
next	0.8;

0.8
date	99.02.24.02.20.20;	author BlackPhantom;	state Exp;
branches;
next	0.7;

0.7
date	99.02.18.00.07.41;	author BlackPhantom;	state Exp;
branches
	0.7.0.1;
next	0.6;

0.6
date	99.02.17.17.01.48;	author BlackPhantom;	state Exp;
branches;
next	0.5;

0.5
date	99.02.10.04.40.20;	author BlackPhantom;	state Exp;
branches;
next	0.4;

0.4
date	98.12.23.00.55.44;	author BlackPhantom;	state Exp;
branches;
next	0.3;

0.3
date	98.06.06.00.08.05;	author BlackPhantom;	state Exp;
branches
	0.3.0.1;
next	;

0.3.0.1
date	98.10.06.03.35.57;	author BlackPhantom;	state Exp;
branches;
next	;

0.7.0.1
date	99.02.21.04.01.14;	author BlackPhantom;	state Exp;
branches;
next	;


desc
@Memory management procedures.
@


0.53
log
@Last developed version
@
text
@;=============================================================================
;
;	This source code file is copyright (c) Vadim Drubetsky AKA the 
; Black Phantom. All rights reserved.
;
;	This source code file is a part of the Tripple-DOS project. Your use 
; of this source code must fully comply with the accompanying license file, 
; LICENSE.TXT. You must have this file enclosed with your Tripple-DOS copy in
; order for it to be legal.
;
;	In no event, except for when it is explicitly stated by the applicable 
; law, shall Vadim Drubetsky aka the Black Phantom be liable for any special,
; incidental, indirect, or consequential damages (including but not limited to
; profit loss, business interruption, loss of business information, or any 
; other pecuniary loss) arising out of the use of or inability to use 
; Tripple-DOS, even if he has been advised of the possibility of such damages.
;
;=============================================================================

;=============================================================================
;
;				MEMMAN.ASM
;				----------
;
;	Simple protmode linear memory management services.
;
; In order to access page tables, they are supplied with page tables
; control array. This array has the structure of page directory but
; contain linear addresses of page tables instead of physical. Of course,
; linear addresses must be page-aligned (address of page); value of -1 will
; indicate the entry is not mapped (needed?)
;
;	(!)	DS = INIT_DS for most functions in this file.
;	(!)	Allocated page dirs are never freed (framework IsPageTblEmpty
; is ready).
;
;	Changes:
;	--------
;
;=============================================================================

		PAGES_MAP_SIZE	EQU	20000h

	INCLUDE	X86.INC
	INCLUDE	DEF.INC
	INCLUDE	TASKMAN.INC
	INCLUDE	PHLIB32.MCR

	EXTRN	MemSize: dword
	EXTRN	SysPagesCtl: dword
	EXTRN	SysPdbLin: dword
	EXTRN	SysPdb: dword
	EXTRN	Pdb: dword
	EXTRN	PdbSeg: word
	EXTRN	GdtBase: dword
	EXTRN	CurrLdtBase: dword
	EXTRN	Field: byte
	EXTRN	NumOfTasks: dword
	EXTRN	FirstTask: dword

	EXTRN	InitErrHandler: near

DATA	SEGMENT	PARA	PUBLIC	USE16	'DATA'
	PUBVAR		PagesMapSeg, DW, ?	; Segment address of pages map
	PUBVAR		PagesMap, DD, ?	; linear address of pages map.
	PUBVAR		PagesCtlSeg, DW, ?	; Segment address of pages control 
						; array
	PUBVAR		PagesCtl, DD, ?		; Linear address of pages 
						; control array
	PUBVAR		PdbLin, DD, ?		; PDB linear address.
	PUBVAR		OsHeapEnd, DD, 	OS_HEAP	; Points to the tail of OS heap
						; linear address.
	PUBVAR		OsHeapBitmap, DD, ?	; Linear address of OS heap 
						; bitmap.
	PUBVAR		OsHeapBitmapSeg, DW, ?	; Segment address of OS heap
						; bitmap.
	PUBVAR		OsStartPage, DD, ?	; System start physical
						; address.
	PUBVAR		OsEndPage, DD, ?	; System end physical
						; address.
	PUBVAR		DynPagesTbl2, DD, ?	; A global page table for
						; dynamic page table tables
	PUBVAR		DynPagesTbl2Seg, DW, ?	; Segment address -"-
DATA	ENDS


CODE	SEGMENT	PARA	PUBLIC	USE16	'CODE'
ASSUME	CS:CODE, DS:DATA
.486p

;-----------------------------------------------------------------------------
;
;	Initializes pages availability bit string in real mode. Mask pages
; belonging to OS.
;
;	I: 
;	O: CF=0 - success, 1 - memory allocation error.
;
;-----------------------------------------------------------------------------
PUBLIC	InitPagesMap
InitPagesMap	PROC	USES es

	;
	; Zero pages map.
	;
	mov	es, PagesMapSeg
	sub	di, di
	mov	ecx, MemSize
	shr	ecx, 3
	inc	ecx
	sub	al, al
	cld
		rep	stosb

	;
	; Mark pages belonging to OS busy.
	;
	mov	es, PagesMapSeg
	sub	di, di
	mov	al, 0FFh
	mov	ecx, OsEndPage
	shr	ecx, 12			; ECX = pages count.
	mov	dx, cx			; Keep pages count.
	shr	ecx, 3
	cld
		rep	stosb
	mov	cx, dx
	and	cx, 7
	mov	al, 1
set_mask:
	test	cx, cx
	jz	end_set_mask
	shl	al, 1
	dec	cx
	jmp	set_mask
end_set_mask:
	dec	ax			; Set necessary bits.
	stosb

	;
	; Mark memory A0000 - FFFFF busy.
	;
	mov	ecx, 0Ch		; Mark busy 60h pages.
	mov	di, 0A0000h SHR 15	; At address A0000
	mov	al, -1			; Set all bits (pages) busy.
	cld
		rep	stosb

	;
	; If providing XMS, mark HMA (100000-110000) busy.
	;
IFDEF	PROVIDE_HIMEM
	mov	word ptr es:[8000h SHR 10], -1
ENDIF	; PROVIDE_HIMEM

	;
	; Initialize page table control array. There are 
	; 2 page tables - one maps 1st Mb, the other - OS kernel at 2nd Gb.
	; And one more for dynamic pages table.
	;
	mov	es, PdbSeg
	mov	eax, es:[0]		; 1st Mb page table
	sub	eax, OsStartPage
	or	eax, OS_BASE
	and	eax, 0FFFFF000h		; Linear address is page-aligned (!)

	mov	ecx, es:[OS_BASE SHR 20]	; OS kernel page table
	sub	ecx, OsStartPage
	or	ecx, OS_BASE
	and	ecx, 0FFFFF000h		; Linear address is page-aligned (!)

	mov	di, OS_HEAP SHR 20
	mov	edx, es:[di]		; OS heap page
	mov	ebx, edx
	sub	edx, OsStartPage
	or	edx, OS_BASE
	and	edx, 0FFFFF000h		; Linear address is page-aligned (!)

	mov	esi, es:[OS_DYN_PAGETBLS SHR 20]	; OS kernel page table
	sub	esi, OsStartPage
	or	esi, OS_BASE
	and	esi, 0FFFFF000h		; Linear address is page-aligned (!)

	mov	es, PagesCtlSeg
	mov	es:[0], eax
	mov	es:[OS_BASE SHR 20], ecx
	mov	es:[di], edx
	mov	es:[OS_DYN_PAGETBLS SHR 20], esi

	;
	; Record PDB linear address.
	;
	mov	eax, SysPdb
	sub	eax, OsStartPage
	or	eax, OS_BASE
	mov	SysPdbLin, eax

	;
	; Zero OS heap bitmap.
	;
	mov	es, OsHeapBitmapSeg
	sub	di, di
	mov	cx, 2000h		; Zero 32k
	sub	eax, eax
	cld
		rep	stosd

	;
	; Zero dynamic page tables page table.
	;
	mov	es, DynPagesTbl2Seg
	sub	di, di
	mov	cx, 400h
	sub	eax, eax
	cld
		rep	stosd

	ret
InitPagesMap	ENDP

CODE	ENDS


CODE32	SEGMENT	PARA	PUBLIC	USE32	'CODE'
ASSUME	CS:CODE32, DS:FLAT

;-----------------------------------------------------------------------------
;
;	I: SI:EDI -> Seg:Offs
;	   EBX = Eflags
;	O: EAX = linear address
;
;	Converts pointer to linear address.
;
;-----------------------------------------------------------------------------
PUBLIC PointerToLinear
PointerToLinear	PROC	near	USES edx
	test	ebx, FL_VM
	jz	prot_mode

	mov	eax, esi
	and	eax, 0FFFFh
	shl	eax, 4
	add	eax, edi
	ret
prot_mode:

	mov	edx, esi
	and	edx, 0FFF8h
	test	si, 4		; LDT selector?
	jnz	ldt_sel

	add	edx, GdtBase
	jmp	get_base_address

ldt_sel:
	add	edx, CurrLdtBase
get_base_address:
	mov	eax, dword ptr (Descriptor386 PTR fs:[edx]).BaseHigh32
	mov	edx, dword ptr (Descriptor386 PTR fs:[edx]).BaseLow
	shl	eax, 24
	and	edx, 0FFFFFFh
	add	eax, edx

	add	eax, edi
	ret
PointerToLinear	ENDP


;-----------------------------------------------------------------------------
;
;	Returns physical address for a given linear.
;
;	I: EAX = linear
;	O: CF = 0 - OK, EAX = physical.
;	      = 1 - error, page not present.
;
;-----------------------------------------------------------------------------
PUBLIC	LinearToPhysical
LinearToPhysical	PROC	USES ebx ecx edx
; Check if page table present.
	mov	ebx, PdbLin		; FS:EBX -> current PDB linear address.
	mov	ecx, eax
	shr	ecx, 22			; ECX = page dir. entry
	test	dword ptr fs:[ebx+ecx*4], PAGE_PRESENT
	jnz	page_tbl_present
; Page table not present, linear address invalid.
	stc
	ret

page_tbl_present:
	mov	ecx, eax
	shr	ecx, 22
	mov	ebx, PagesCtl		; fs:[ebx] -> pages array ctl.
	mov	ecx, fs:[ebx+ecx*4]	; ECX = page table linear address.

	mov	edx, eax
	shr	edx, 12
	and	edx, 3FFh		; EDX = page table entry
	mov	ecx, fs:[ecx+edx*4]	; ECX = page physical address.

	test	ecx, PAGE_PRESENT
	jnz	page_exists

; Page not present, linear address invalid.
	stc
	ret

page_exists:
	and	eax, 0FFFh
	and	ecx, NOT 0FFFh		; Clear page attributes.
	or	eax, ecx		; Change page linear address to phys.

	clc
	ret
LinearToPhysical	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = linear address that is mapped by the page table
;
;	O: EAX != 0 - not empty
;	   EAX = 0 - empty
;
;	R:
;	Should be called only for dynamically allocated page tables (heap).
;
;-----------------------------------------------------------------------------
IsPageTblEmpty	PROC	USES fs ecx
	mov	ecx, eax
IF	0
	and	ecx, 0FFFFFFF8h
	or	ecx, 003FFFF8h		; Offset FF8h in last page table
					; entry.
ELSE
	and	ecx, 0FFFFFFFCh
	or	ecx, 003FFFFCh		; Offset FFCh in last page table
					; entry.
ENDIF
	mov	eax, PAGE_PRESENT
test_empty:
	test	fs:[ecx], eax
	jz	test_next
; Return not empty.
	mov	eax, 1
	ret

test_next:
	sub	ecx, 4
	jnl	test_empty
; Return empty.
	sub    eax, eax
	ret

IsPageTblEmpty	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = linear address to be mapped in the directory.
;	(!) the address must be within OS heap linear range.
;
;	O: CF = 0 - success
;		1 - fail
;
;	Creates a new page table directory entry (page table) that will map
; the given linear address (but doesn't map the address itself)
;
;	R:
;	* Page table is always given U = 1, W = 1, P = 1
; (restrictions are applied at page table entry level).
;	* Last entry of page table allocated this way contains itself.
;
;-----------------------------------------------------------------------------
CreatePageTable	PROC	USES eax ebx ecx edx esi edi
	cmp	eax, OS_HEAP
	jb	@@F
	cmp	eax, OS_HEAP + OS_HEAP_SIZE
	jna	create
@@@@:
	stc
	ret

create:
; Check if the page table already exists.
	mov	ecx, eax
	shr	ecx, 22
	mov	edx, SysPdbLin
	test	dword ptr fs:[edx][ecx*4], PAGE_PRESENT
	jz	@@F
	stc
	ret

@@@@:
	mov	ecx, eax
	mov	esi, eax

	;
	; Allocate page for page table entry.
	;
	call	AllocPage
	cmp	eax, -1
	jne	map_page_table
	stc
	ret

map_page_table:
; Set page table's physical address in page dir.
	shr	esi, 22
	or	eax, PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER

; Map new page table in all address spaces.
	mov	edx, SysPdbLin
	mov	fs:[edx][esi*4], eax

	sub	ebx, ebx
	mov	edi, FirstTask
set_pt_in_pdb:
	cmp	ebx, NumOfTasks
	jnb	set_pt_lin

	mov	edx, (DosTask PTR fs:[edi]).TaskPdbLin
	mov	fs:[edx][esi*4], eax
	inc	ebx
	add	edi, SIZEOF DosTask
	jmp	set_pt_in_pdb

; Set page table's page's linear address to its own last element.
set_pt_lin:
	and	eax, NOT PAGE_USER 			; U = 0
IF 0
	and	ecx, NOT 00000FFFh
	or	ecx, 003FF000h

; At this point linear address of the page table (mapped into itself) is
; still not valid, so MapPage _cannot_ be called to map the page directory
; to ifself. Instead _this_ page table physical address will be mapped to
; _temporary_ linear - 003FF000h which is always present.

	push	ecx
	mov	ecx, 3FF000h
	call	MapPage
	pop	ecx

	mov	ebx, PagesCtl
	mov	dword ptr fs:[ebx][esi], 3FF000h
	call	MapPage
ELSE
; Map PT to its element in a DynPagesTbl2.
	sub	ecx, OS_HEAP
	shr	ecx, 10
	and	ecx, NOT 0FFFh
	lea	ecx, [ecx+OS_DYN_PAGETBLS]
	call	MapPage
ENDIF

; Set page table's linear address in page table control array. Must be set
; prior to calling MapPage.
	mov	ebx, SysPagesCtl
	mov	fs:[ebx][esi*4], ecx

; Set the new PT in PagesCtls in all tasks
	mov	eax, FirstTask
	sub	edx, edx
set_pages_ctl:
	cmp	edx, NumOfTasks
	jnb	clear_page_tbl

	mov	ebx, (DosTask PTR fs:[eax]).TaskPageCtl
	mov	fs:[ebx][esi*4], ecx
	inc	edx
	add	eax, SIZEOF DosTask
	jmp	set_pages_ctl

clear_page_tbl:
; Set page table to all 0s.
	mov	esi, 0FFCh
	sub	eax, eax

zero_page_tbl:
	mov	fs:[ecx][esi], eax
	sub	esi, 4
	jnl	zero_page_tbl

IF 0
; Set linear address that maps page table as busy.
	mov	esi, OsHeapBitmap
	mov	eax, ecx
	and	eax, NOT OS_HEAP
	shr	eax, 12
	bts	dword ptr fs:[esi], eax
ENDIF

	clc
	ret

CreatePageTable	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = physical address and attributes to set.
;	   ECX = linear address
;
;	O: CF = 0 - success
;		1 - fail
;
;	Maps given physical page to linear address.
;
;	R:
;	* The physical address must be allocated with AllocPage or otherwise
; set present. 
;	* If page directory is not present the function returns fail.
;	* The attributes in EAX apply to page only and will not be applied
; to appropriate page table directory.
;
;-----------------------------------------------------------------------------
MapPage		PROC	USES eax ebx ecx edx esi

	mov	edx, PdbLin
	mov	ebx, PagesCtl
	;
	; Check if appropriate page table is present.
	;
	mov	esi, ecx
	shr	esi, 20
	and	esi, 00000FFCh
	test	dword ptr fs:[edx][esi], PAGE_PRESENT
	jnz	map_page

cmp	ecx, OS_DYN_PAGETBLS
jb	@@F
int 2
@@@@:
; If not present, return fail.
	stc
	ret

map_page:
	mov	esi, fs:[ebx][esi]		; Page table linear address.
	shr	ecx, 10
	and	ecx, 00000FFCh
	mov	fs:[esi][ecx], eax

	mov	eax, cr3
	mov	cr3, eax			; Invalidate TLB.

	clc
	ret
MapPage		ENDP


;-----------------------------------------------------------------------------
;
;	I:
;	O: CF = 0, EAX = Page physical address.
;		1, EAX = -1 if no free pages.
;
;	Allocates physical page
;
;-----------------------------------------------------------------------------
PUBLIC	AllocPage
AllocPage	PROC	USES ecx edx
	call	FirstFreePage
	cmp	eax, -1
	jne	page_found

	stc
	ret
page_found:
	mov	ecx, PagesMap
	mov	edx, eax
	shr	edx, 12			; EDX = bit offset.
	bts	dword ptr fs:[ecx], edx	; Set bit specified by EDX.

	clc
	ret
AllocPage	ENDP


;-----------------------------------------------------------------------------
;
;	I:
;	O: EAX = physical address.
;		 -1 if no free pages.
;
;	Searches in pages map and returns first free physical page found.
;
;-----------------------------------------------------------------------------
FirstFreePage	PROC	USES ecx edx

	mov	ecx, PagesMap	; FS:ECX -> pages map.
	sub	eax, eax	; EAX = page number (address >> 12)
find_free:
	mov	edx, fs:[ecx]
	cmp	edx, -1
	jne	specify_free

	add	ecx, 4
	add	eax, 32
	cmp	eax, MemSize
	jna	find_free

	mov	eax, -1
	jmp	end_find_free

specify_free:
	shr	edx, 1
	jnc	free_found

	inc	eax
	jmp	specify_free

free_found:
	shl	eax, 12
end_find_free:

	ret
FirstFreePage	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = page to free.
;	O:
;
;	Frees previously allocated page. Doesn't check if the page was
; previously allocated.
;
;-----------------------------------------------------------------------------
PUBLIC	FreePage
FreePage	PROC	USES ecx edx
	mov	ecx, PagesMap
	mov	edx, eax
	shr	edx, 12

	btr	dword ptr fs:[ecx], edx	; Clear bit specified by EDX.
	ret
FreePage	ENDP


;-----------------------------------------------------------------------------
;
;	Returns number of free physical pages left.
;
;	I:
;	O:	EAX = number of pages.
;
; (!) Assumed that linear memory space is always enough.
;
;-----------------------------------------------------------------------------
PUBLIC	LeftFreePages
LeftFreePages	PROC	USES ebx ecx edx esi
	mov	ecx, PagesMap		; FS:ECX -> pages in loop.
	sub	eax, eax		; EAX = count of free pages.
	mov	ebx, MemSize		; EBX = memory count

count_pages:
	mov	edx, fs:[ecx]
	add	ecx, 4
	test	edx, edx
	jz	adjust_ptr

; Count busy pages.
add_count:
	inc	eax
	lea	esi, [edx-1]
	and	edx, esi
	jnz	add_count

adjust_ptr:
	sub	ebx, 32
	jg	count_pages

	neg	eax
	add	eax, MemSize

; Subtract number of pages that would need to page page directories.
	mov	edx, eax
	shr	edx, 10
	inc	edx
	sub	eax, edx

	ret
LeftFreePages	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = attributes
;	O: CF = 0 - OK, EAX = linear address of a page.
;	   CF = 1 - error,
;		EAX = -1 if not enough free pages for page of for page dir.
;		    = -2 if all heap is already used.
;
;	Allocates page from OS heap.
;
;-----------------------------------------------------------------------------
PUBLIC	HeapAllocPage
HeapAllocPage	PROC	USES ecx edx ebx esi edi
	and	eax, 0FFFh
	mov	esi, eax
	call	AllocPage
	cmp	eax, -1
	jne	map_page
	stc
	ret

map_page:
	or	esi, eax
	;
	; Search in OS heap bitmap for first available entry.
	;
	mov	edi, OsHeapBitmap
	mov	ecx, OS_HEAP
find_free:
	mov	edx, fs:[edi]
	cmp	edx, -1
	jne	specify_free

	add	edi, 4
	add	ecx, 20000h
	cmp	ecx, OS_HEAP + OS_HEAP_SIZE - 1
	jna	find_free

	mov	eax, -2
	stc
	ret

specify_free:
	shr	edx, 1
	jnc	free_found

	add	ecx, 1000h
	jmp	specify_free
free_found:
	mov	eax, esi		; Apply given attributes.
	call	MapPage
	mov	eax, ecx
	jnc	set_busy

	call	CreatePageTable
	jnc	free_found

	mov	eax, -1
	ret
set_busy:

	mov	ecx, OsHeapBitmap
	mov	edx, eax
	and	edx, NOT OS_HEAP
	shr	edx, 12			; EDX = bit offset.
	bts	dword ptr fs:[ecx], edx	; Set bit specified by EDX.
end_find_free:

	cmp	eax, OsHeapEnd
	jb	finish
	mov	OsHeapEnd, eax
	add	OsHeapEnd, 1000h	; Update heap end.
finish:
	clc
	ret
HeapAllocPage	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = attributes
;	O: CF = 0 - OK, EAX = linear address of a page.
;	   CF = 1 - error,
;		EAX = -1 if not enough free pages for page of for page dir.
;		    = -2 if all heap is already used.
;
;	Allocates page from OS heap and fill with 0s.
;
;-----------------------------------------------------------------------------
PUBLIC	HeapAllocZPage
HeapAllocZPage	PROC	USES es ecx edi
	call	HeapAllocPage
	jnc	@@F
	ret
@@@@:
	cld
	mov	edi, eax
	push	fs
	pop	es
	mov	ecx, 400h
	sub	eax, eax
		rep	stosd

	lea	eax, [edi - 1000h]	; Restore EAX.

	clc
	ret
HeapAllocZPage	ENDP


;-----------------------------------------------------------------------------
;
;	Frees previously allocated page from OS heap.
;
;	I: EAX = linear address of a page.
;	O: CF = 0 OK
;	        1 wrong page.
;
;-----------------------------------------------------------------------------
PUBLIC	HeapFreePage
HeapFreePage	PROC	USES eax ecx edx

; If page is not within OS_HEAP, return error.
	cmp	eax, OS_HEAP
	jnb	@@F
	stc
	ret

@@@@:
	cmp	eax, OS_HEAP + OS_HEAP_SIZE
	jna	@@F
	stc
	ret

@@@@:
	mov	ecx, OsHeapBitmap
	mov	edx, eax
	and	edx, NOT OS_HEAP
	shr	edx, 12

	btr	dword ptr fs:[ecx], edx	; Clear bit specified by EDX.
	jc	@@F			; If page was allocated, go on.
	stc
	ret

@@@@:
	call	LinearToPhysical	; If page was mappped correctly, go on.
	jnc	@@F
	ret

@@@@:
	call	FreePage
	clc
	ret
HeapFreePage	ENDP


;-----------------------------------------------------------------------------
;
;	Allocates contiguous linear memory from OS heap.
;
;	I: EAX = attributes
;	   ECX = size
;	O: CF = 0 - OK, EAX = linear address of a first page.
;	   CF = 1 - error,
;		EAX = -1 if not enough free pages for page of for page dir.
;		    = -2 if all heap is already used.
;
;	(!) Allocated memory is always page-aligned.
;
;-----------------------------------------------------------------------------
PUBLIC	HeapAllocMem
HeapAllocMem	PROC	USES ebx ecx edx esi edi
LOCAL	HeapCount: DWORD
LOCAL	HeapStart: DWORD

	and	eax, 0FFFh
	mov	esi, eax		; ESI holds attributes.


	mov	eax, ecx
	call	HeapGetRegion
	jnc	@@F
	ret				; Error code is already in EAX.

; Heap region is OK. Allocate physical memory.
@@@@:
	mov	HeapStart, eax
	mov	HeapCount, ecx
	add	HeapCount, eax		; HeapCount = last lin. page to map.

	mov	edi, eax		; Keep start linear address.
	mov	ecx, eax

	mov	edx, NOT OS_HEAP
	and	edx, ecx
	shr	edx, 12			; EDX = pointer in heap bitmap
	mov	ebx, OsHeapBitmap	; FS:EBX -> heap bitmap.

alloc_next:
	call	AllocPage		; Allocate physical page.
	jc	not_enough_physical

map_page:
	or	eax, esi		; Apply atributes.
	call	MapPage
	jnc	set_busy

; MapPage failed: need to create a new page table.
	xchg	eax, ecx
	call	CreatePageTable
	xchg	eax, ecx
	jc	not_enough_physical
	jmp	map_page

set_busy:
	bts	dword ptr fs:[ebx], edx

	add	ecx, 1000h
	inc	edx
	cmp	ecx, HeapCount
	jb	alloc_next

	mov	eax, edi
	clc
	ret

not_enough_physical:
	;
	; Free pages back from ECX to EDI.
	;
	mov	eax, ecx
	call	HeapFreePage
	sub	ecx, 1000h
	cmp	ecx, edi
	jnb	not_enough_physical

	mov	eax, -1
	stc
	ret
HeapAllocMem	ENDP


;-----------------------------------------------------------------------------
;
;	Gets a required amount of linear memory without allocating physical.
;
;	I: EAX = size in bytes.
;	O: CF = 0 - OK, EAX = start address.
;	      = 1 - error, all heap exhausted.
;
;-----------------------------------------------------------------------------
PUBLIC	HeapGetRegion
HeapGetRegion	PROC	USES ebx ecx edx esi edi
LOCAL	HeapCount: dword, BitCount: dword

; Don't do that.
IF 0
; If requested more than 4M - 4K, return error.
	cmp	eax, 3FF000h
	jna	@@F
	mov	eax, -2
	stc
	ret
ENDIF

@@@@:
	;
	; Search in OS heap bitmap for first available entry.
	;
	mov	edi, OsHeapBitmap
	mov	HeapCount, OS_HEAP

	sub	ebx, ebx		; Reset EBX - pages count.
find_free:

	mov	edx, fs:[edi]
	cmp	edx, -1
	jne	check_free

go_on_look:
	add	edi, 4
	add	HeapCount, 20000h
	cmp	HeapCount, OS_HEAP + OS_HEAP_SIZE - 1
	jna	find_free

	mov	eax, -2
	stc
	ret

check_free:
	test	edx, edx
	jnz	reset_bit_count

	mov	esi, ecx
	sub	esi, ebx
	add	esi, HeapCount
	cmp	esi, OS_HEAP + OS_HEAP_SIZE
	jb	@@F

	mov	eax, -2
	stc
	ret

@@@@:
	add	ebx, 20000h
	add	HeapCount, 20000h

	cmp	ebx, ecx
	jnb	mem_found
	add	edi, 4
	jmp	find_free

reset_bit_count:
	mov	BitCount, 32
count_0s:
	shr	edx, 1
	jnc	@@F
	sub	ebx, ebx
	jmp	enough_pages?
@@@@:
	add	ebx, 1000h
enough_pages?:
	add	HeapCount, 1000h
	cmp	ebx, ecx
	jnb	mem_found

	cmp	HeapCount, OS_HEAP + OS_HEAP_SIZE - 1
	jna	count_next_bit

	mov	eax, -2
	stc
	ret

count_next_bit:
	dec	BitCount
	jnz	count_0s

	add	edi, 4
	jmp	find_free

mem_found:
; If region crosses 4M boundary, start looking again from the 4M boundary.
	mov	eax, HeapCount
	and	eax, 3FFFFFh
	cmp	eax, ebx
	jnb	@@F

	sub	ebx, ebx			; Reset page count
	and	HeapCount, NOT 3FFFFFh		; Patch heap count
	mov	edi, HeapCount			; Set bitmap pointer
	sub	edi, OS_HEAP
	shr	edi, 12 + 3
	add	edi, OsHeapBitmap
	jmp	find_free

@@@@:
	;
	; Return start linear address.
	;
	mov	ecx, HeapCount
	sub	ecx, ebx		
	mov	eax, ecx

	clc
	ret
HeapGetRegion	ENDP


;-----------------------------------------------------------------------------
;
;	Frees linear region of memory.
;
;	I: EAX = linear address.
;	   ECX = size (bytes).
;
;-----------------------------------------------------------------------------
PUBLIC	HeapFreeMem
HeapFreeMem	PROC	USES eax ecx
@@@@:
	call	HeapFreePage
	add	eax, 1000h
	sub	ecx, 1000h
	jg	@@B

	ret
HeapFreeMem	ENDP


CODE32	ENDS

END
@


0.52
log
@Stack segment for Tripple-DOS changed to 32-bit default. 16-bit stack didn't work with DPMI clients that set up stack to 32 bits and ESP > 64K! Now DJGPP stubbed programs work, but there is some problem when they return.
@
text
@d12 1
a12 1
; law, shall Vadim Drubetsky aka the Black Phantoms be liable for any special,
@


0.51
log
@Added general devices synchronization mechanism.
It's implemented for COM1 and COM2.
It causes problems with a keyboard.
@
text
@@


0.50
log
@Fixed HDD/FDD synchronization problem (trapped opcodes were overwriting each other).
@
text
@@


0.49
log
@Fixes version (log for INIT.ASM)
@
text
@@


0.48
log
@Enabled XMS 3.0 inteface
@
text
@@


0.47
log
@DMA partial virtualization is made - Tripple DOS now works with floppy!
@
text
@@


0.46
log
@Fixed a bug that didn't allow Tripple DOS work with DOS loaded HIGH
@
text
@@


0.45
log
@The shareware beta release
@
text
@d150 7
@


0.44
log
@Bug fixes:
1) Checks for open file name (EDX to DX) problem
2) Reporting of the protected mode exception reboot
@
text
@d3 19
d27 1
a27 1
; In order to access page tables, they will be supplied with page tables
d34 5
a38 3
;	(!)	In most functions most registers are destroyed. So generally
; the contents of registers after any MEMMAN function call should not be
; predicted (may be changed in future).
d81 3
a83 1

d152 1
d160 1
a160 2
	mov	si, OS_BASE SHR 20
	mov	ecx, es:[si]		; OS kernel page table
d172 5
d179 1
a179 1
	mov	es:[si], ecx
d181 1
d201 10
d325 1
d329 5
a333 1

d355 1
d361 1
a361 1
; the given linear address (but doesn't map the address)
d370 19
d403 1
a403 1
	shr	esi, 20
a404 1
	and	esi, 00000FFCh
d408 1
a408 1
	mov	fs:[edx][esi], eax
d417 1
a417 1
	mov	fs:[edx][esi], eax
d424 2
a427 1
	and	eax, NOT PAGE_USER 			; U = 0
d442 8
d454 1
a454 1
	mov	fs:[ebx][esi], ecx
d456 1
d464 1
a464 1
	mov	fs:[ebx][esi], ecx
d470 2
a471 2
; Set page table to all 0s but the last element.
	mov	esi, 0FF8h
d479 1
d486 1
d525 4
d804 1
a804 1
; If page is below OS_HEAP, return error.
d811 6
d938 2
d946 1
@


0.43
log
@Bug fixes:
1) Lower word in translation structure on real mode stack was being destroyed - very annoying.
2) Saved exception number was moved to task structure to allow multiple DPMI tasks work.
3 copies of WCC386 worked!
@
text
@d9 1
a9 1
; cotrol array. This array will have the structure of page directory but
d202 2
a206 2
	mov	edx, esi
	and	edx, 0FFF8h
a209 6
;	mov	ah, (Descriptor386 PTR fs:[edx]).BaseHigh32
;	mov	al, (Descriptor386 PTR fs:[edx]).BaseHigh24
;	shl	eax, 16
;	mov	ax, (Descriptor386 PTR fs:[edx]).BaseLow
;	add	eax, edi
;	ret
d211 1
a211 23
;	sldt	dx
;	and	edx, 0FFF8h
;
;	add	edx, GdtBase
;
;	mov	ah, (Descriptor386 PTR fs:[edx]).BaseHigh32
;	mov	al, (Descriptor386 PTR fs:[edx]).BaseHigh24
;	shl	eax, 16
;	mov	ax, (Descriptor386 PTR fs:[edx]).BaseLow
;	mov	edx, eax

	mov	edx, CurrLdtBase

; Now fs:EDX -> LDT
	mov	eax, esi
	and	eax, 0FFF8h
	add	edx, eax
; Now fs:EDX -> LDT entry
;	mov	ah, (Descriptor386 PTR fs:[edx]).BaseHigh32
;	mov	al, (Descriptor386 PTR fs:[edx]).BaseHigh24
;	shl	eax, 16
;	mov	ax, (Descriptor386 PTR fs:[edx]).BaseLow

a219 1

@


0.42
log
@1) Added XMS server
2) Memory allocation / deallocation is moved to task creation / deletion
@
text
@a484 1
mov	edx, ecx
@


0.41
log
@Bug fixes:
1) Virtual I/O jump table (very annoying!)
2) IsFileOpen() bug if file name is 0.
@
text
@a201 15
if 1
cmp	si, CODE_32
jne	@@F
cmp	edi, 0FFFFh
jb	@@F
EXTRN	ExcNumber: dword
mov	eax, ExcNumber
EXTRN	ExcSeg: word
mov	bx, ExcSeg
EXTRN	ExcOffs: dword
mov	ecx, ExcOffs
int 3
@@@@:
endif

a248 10
if 1
push	eax
call	LinearToPhysical
pop	eax
jnc	@@F
lea	ebx, [esp+4]
int 3
@@@@:
endif

d485 1
d754 8
a761 6
;	cmp	eax, OS_HEAP
;	jnb	@@F
;	stc
;	ret
;
;@@@@:
d768 10
a777 6
;	jc	@@F			; If page was allocated, go on.
;	stc
;	ret
;
;@@@@:
	call	LinearToPhysical
d991 21
@


0.40
log
@DPMI server fixes:
1) Locker real mode and protected mode stacks usage fixed: reentrancy allowed.
2) Modes switches fixed.
@
text
@d201 16
d263 10
@


0.39
log
@Bug fixed: raw mode switches.
@
text
@@


0.38
log
@Bugs fixed:
1) PointerToLinear() check
2) Default interrupt redirection to V86 mode
@
text
@@


0.37
log
@Bug fixed: reflecting PM to VM interrupt.
@
text
@d257 2
a258 1
;	O: EAX = physical.
d263 9
a271 1
	mov	ebx, PagesCtl		; fs:[ebx] -> pages array ctl.
d273 1
d275 2
a276 1
	shr	ecx, 22			; ECX = page dir. entry
d280 10
a289 2
	shr	edx, 10
	and	edx, 0FFCh		; EDX = page table entry
d291 1
a291 1
	mov	ecx, fs:[ecx+edx]	; ECX = page physical address.
d296 1
@


0.36
log
@Bug fixes:
1) CreatePageTable() called from HeapAllocMem()
2) Zero allocated PDB for new task
@
text
@@


0.35
log
@HeapAllocMem() bug fixed; free DPMI memory allocated fixed.
@
text
@d23 4
a26 3
			INCLUDE	X86.INC
			INCLUDE	DEF.INC
			INCLUDE	TASKMAN.INC
d91 1
d127 1
a127 1
	; Initialize page table control array Initialize. There are 
a421 1
exit:
d468 3
d691 32
d726 2
a727 1
;	O:
d732 6
d744 5
a748 1

d751 1
d773 1
d778 2
d786 1
d808 1
d810 1
d855 8
d871 1
d938 15
d954 1
a954 2
	; Allocate physical pages and map them. HeapCount holds start page +
	; ECX.
@


0.34
log
@Bug fixes:
1) Initial pages map allocation
2) Translation services params
3) DPMI clean up memory release -- almost
4) INT 21h AH=4Ch in protected mode.
@
text
@a37 1
	EXTRN	CurrTaskPtr: dword
d475 2
a476 2
;	O: EAX = Page physical address.
;		 -1 if no free pages.
d486 2
d494 2
d731 1
a731 1
	ret				; Error code is already in EAX>
d798 1
a798 1
HeapGetRegion	PROC	USES ebx ecx edx edi
a806 1
reset_count:
d827 5
a831 2
	add	ebx, 20000h
	add	HeapCount, 20000h
a832 2
	cmp	HeapCount, OS_HEAP + OS_HEAP_SIZE - 1
	jna	@@F
d838 3
d856 1
a859 1
	add	HeapCount, 1000h
d879 1
a879 2
	xchg	ecx, HeapCount
	add	HeapCount, ecx
@


0.33
log
@Initial full release - all DPMI functions are written! Half are not tet.
@
text
@d34 1
d226 1
a226 2
	mov	eax, CurrTaskPtr
	mov	edx, (DosTask PTR fs:[eax]).TaskLdtBase
d350 1
a350 1
;	mov	edx, PdbLin
d366 1
a367 1
; Set page table's page's linear address to its own last element
d508 1
a508 1
	mov	ecx, PagesMap	; ES:ECX -> pages map.
d570 1
a570 2
	mov	ecx, PagesMap		; ES:ECX -> Pages map
	sub	ebx, ebx		; ES:ECX+EBX -> pages in loop.
d572 1
d576 1
a576 1
	add	ebx, 32
d580 1
a580 1
; Count bits (free pages in EDX).
d588 2
a589 3
	add	ecx, 4
	cmp	ebx, MemSize
	jb	count_pages
@


0.32
log
@Translation services work.
@
text
@d37 1
d192 1
d205 1
d207 6
a212 6
	mov	ah, (Descriptor386 PTR fs:[edx]).BaseHigh32
	mov	al, (Descriptor386 PTR fs:[edx]).BaseHigh24
	shl	eax, 16
	mov	ax, (Descriptor386 PTR fs:[edx]).BaseLow
	add	eax, edi
	ret
d214 14
a227 9
	sldt	dx
	and	edx, 0FFF8h
	add	edx, GdtBase
	
	mov	ah, (Descriptor386 PTR fs:[edx]).BaseHigh32
	mov	al, (Descriptor386 PTR fs:[edx]).BaseHigh24
	shl	eax, 16
	mov	ax, (Descriptor386 PTR fs:[edx]).BaseLow
	mov	edx, eax
d233 12
a244 4
	mov	ah, (Descriptor386 PTR fs:[edx]).BaseHigh32
	mov	al, (Descriptor386 PTR fs:[edx]).BaseHigh24
	shl	eax, 16
	mov	ax, (Descriptor386 PTR fs:[edx]).BaseLow
d565 2
d594 7
d608 4
a611 3
;	O: EAX = linear address of a page.
;	       = -1 if not enough free pages for page of for page dir.
;	       = -2 if all heap is already used.
d623 1
d644 1
d662 1
a662 1
	mov	eax, -3
d678 1
d685 2
a689 2
;	Frees previously allocated page from OS heap.
;
d708 2
d712 4
a715 5
;	O: EAX = linear address of a first page.
;	       = -1 if not enough free pages for pages or for page dir.
;	       = -2 if not enough contiguous heap page.
;
;	Allocates contiguous linear memory from OS heap.
d722 1
a722 1
LOCAL	HeapCount: dword, BitCount: dword
d727 72
d819 1
d832 1
d859 1
a876 36
	mov	edi, ecx		; Keep start linear address.

	mov	edx, NOT OS_HEAP
	and	edx, ecx
	shr	edx, 12			; EDX = pointer in heap bitmap
	mov	ebx, OsHeapBitmap	; FS:EBX -> heap bitmap.

alloc_next:
	call	AllocPage		; Allocate physical page.
	jc	not_enough_physical

map_page:
	or	eax, esi		; Apply atributes.
	call	MapPage
	jnc	set_busy

; MapPage failed: need to create a new page table.
	call	CreatePageTable
	jc	not_enough_physical
	jmp	map_page

set_busy:
	bts	dword ptr fs:[ebx], edx

	add	ecx, 1000h
	inc	edx
	cmp	ecx, HeapCount
	jb	alloc_next

	mov	eax, edi
	ret

not_enough_physical:
	;
	; Free pages back from ECX to EDI.
	;
a877 4
	call	HeapFreePage
	sub	ecx, 1000h
	cmp	ecx, edi
	jnb	not_enough_physical
d879 1
a879 1
	mov	eax, -1
d881 1
a881 1
HeapAllocMem	ENDP
@


0.31
log
@1) Interrupt redirection works
2) HeapAllocMem() bug fixes
DPMI traps fixed
@
text
@@


0.30
log
@DOS block functions are written and work. Callback to real mode mechanism established. Tests are still brief.
@
text
@d613 1
a613 1
	cmp	ecx, OS_HEAP + 0FFFFFFFh
d695 2
d702 3
a704 1
	sub	ebx, ebx		; EBX - pages count.
d713 1
a713 1
	cmp	HeapCount, OS_HEAP + 0FFFFFFFh
a719 2
	mov	BitCount, 0
count_free:
d721 1
a721 1
	jz	count_0s
d726 1
a726 1
	cmp	HeapCount, OS_HEAP + 0FFFFFFFh
d734 2
d737 2
d741 8
a748 1
	jnc	count_next0
a749 1
	add	ebx, 1000h
d751 2
a753 2
	cmp	HeapCount, OS_HEAP + 0FFFFFFFh
	jna	@@F
d757 3
a759 9
@@@@:
	cmp	ebx, ecx
	jb	check_next
	jmp	mem_found

count_next0:
	inc	BitCount
	cmp	BitCount, 32
	jb	count_0s
a760 1
check_next:
d762 1
a762 6
	mov	edx, fs:[edi]
	cmp	edx, -1
	jne	check_free

	sub	ebx, ebx		; Reset EBX - pages count.
	jmp	go_on_look
d769 3
a771 2
	neg	ecx
	add	ecx, HeapCount		; ECX = start linear address.
d773 5
a777 1
	mov	esi, eax		; ESI holds attributes.
a793 4
	mov	edx, ecx
	and	edx, NOT OS_HEAP
	shr	edx, 12
	mov	ebx, OsHeapBitmap
d797 1
@


0.29
log
@First DPMI selector functions work (Hello, world).
@
text
@@


0.28
log
@Initial DPMI switch works.
@
text
@@


0.27
log
@Solves INT 28 block problems (doesn't lock).
@
text
@@


0.26
log
@Bugs fixed:
1) Store open file name
2) Store DOS function per process
3) Imperfect INT 13 semaphore handling.
@
text
@@


0.25
log
@Fixed bug in IsFileOpen proc.
@
text
@@


0.24
log
@Removed unnecessary dynamic allocations.
@
text
@@


0.23
log
@1) File sharing handled.
@
text
@@


0.22
log
@1) Fully split task blocking and waiting for event.
2) Annoying bug fixed (TASK_PTR).
@
text
@d553 1
a553 1
	sub	ebx, ebx		; ES:ESX+EBX -> pages in loop.
@


0.21
log
@1) Improved task state handling (nesting allowed due to bit mask).
2) Bugs fixed.
TASK_PTR macro is used.
4) X86.MCR is out of project.
@
text
@@


0.20
log
@Task locks on wait for events are added.
@
text
@@


0.19
log
@Trap wait on keyboard (INT 16h / 0, 10h).
Bug fixes in memory allocation.
@
text
@@


0.18
log
@Keyboard virtualized.
File I/O interface for kernel is added.
@
text
@d25 1
d28 2
d35 2
d38 1
a38 1
	EXTRN	InitErrHandler:NEAR
a44 2
	PUBVAR		SysPagesCtl, DD, ?	; Linear address of system
						; pages control array.
a46 1
	PUBVAR		SysPdbLin, DD, ?	; System PDB linear address.
a174 4
extrn	PmWriteStr32: near32
extrn	PmHex32ToA: near32


a241 2
;	(!) Callable only from the system context.
;
d244 2
a245 4
LinearToPhysical	PROC	USES es ebx ecx edx
	mov	cx, FLAT_DS
	mov	es, cx
	mov	ebx, PagesCtl	; es:[ebx] -> pages array ctl.
d249 1
a249 1
	mov	ecx, es:[ebx+ecx*4]	; ECX = page table linear address.
d255 1
a255 1
	mov	ecx, es:[ecx+edx]	; ECX = page physical address.
a266 1
;	   EBX = Page table control array base
d275 1
a275 4
IsPageTblEmpty	PROC	USES es ecx
	push	FLAT_DS
	pop	es

d283 1
a283 1
	test	es:[ecx], eax
a301 2
;	   EDX = PDB linear address
;	   EBX = Page table control array base
d315 1
a315 4
CreatePageTable	PROC	USES es eax ecx esi
	push	FLAT_DS
	pop	es

d327 1
d333 16
a348 1
	mov	es:[edx][esi], eax
d350 1
d366 2
a367 3
	push	esi
	mov	dword ptr es:[ebx][esi], 3FF000h

a369 2
	pop	esi

d372 14
a385 1
	mov	es:[ebx][esi], ecx
d387 1
d393 1
a393 1
	mov	es:[ecx][esi], eax
d402 1
a402 1
	bts	dword ptr es:[esi], eax
a414 2
;	   EDX = PDB linear address
;	   EBX = Page table control array base
d429 1
a429 3
MapPage		PROC	USES es eax ecx esi
	push	FLAT_DS
	pop	es
d431 2
d439 1
a439 1
	test	dword ptr es:[edx][esi], PAGE_PRESENT
d447 1
a447 1
	mov	esi, es:[ebx][esi]		; Page table linear address.
d450 1
a450 1
	mov	es:[esi][ecx], eax
d467 1
a467 3
AllocPage	PROC	USES es ecx edx
	mov	ax, FLAT_DS
	mov	es, ax
d476 1
a476 1
	bts	dword ptr es:[ecx], edx	; Set bit specified by EDX.
d490 1
a490 3
FirstFreePage	PROC	USES es ecx edx
	mov	ax, FLAT_DS
	mov	es, ax
d495 1
a495 1
	mov	edx, es:[ecx]
d532 1
a532 3
FreePage	PROC	USES es ecx edx
	mov	cx, FLAT_DS
	mov	es, cx
d537 1
a537 1
	btr	dword ptr es:[ecx], edx	; Clear bit specified by EDX.
d551 1
a551 3
LeftFreePages	PROC	USES es ebx ecx edx esi
	mov	cx, FLAT_DS
	mov	es, cx
d557 1
a557 1
	mov	edx, es:[ecx]
d591 1
a591 1
HeapAllocPage	PROC	USES es ecx edx ebx esi edi
a603 2
	mov	cx, FLAT_DS
	mov	es, cx
d607 1
a607 1
	mov	edx, es:[edi]
a626 2
	mov	edx, PdbLin
	mov	ebx, PagesCtl
d642 1
a642 1
	bts	dword ptr es:[ecx], edx	; Set bit specified by EDX.
d663 1
a663 3
HeapFreePage	PROC	USES es eax ecx edx
	mov	cx, FLAT_DS
	mov	es, cx
d669 1
a669 1
	btr	dword ptr es:[ecx], edx	; Clear bit specified by EDX.
a779 2
	mov	edx, PdbLin
	mov	ebx, PagesCtl
@


0.17
log
@Int 13h locking improvements, bug fixes (NC running)
@
text
@@


0.16
log
@Debug improvements (commands); VGA ports partial virtualizing
@
text
@@


0.15
log
@Debug improvements: hardware breakpoint
@
text
@@


0.14
log
@Bug fixes; debug improvements
@
text
@@


0.13
log
@Proper CPL 0 stack management; foreground task boost on event
@
text
@d190 1
a190 1
PointerToLinear	PROC	near	USES es edx
a198 2
	mov	ax, FLAT_DS
	mov	es, ax
d206 2
a207 2
	mov	ah, (Descriptor386 PTR es:[edx]).BaseHigh32
	mov	al, (Descriptor386 PTR es:[edx]).BaseHigh24
d209 1
a209 1
	mov	ax, (Descriptor386 PTR es:[edx]).BaseLow
d217 2
a218 2
	mov	ah, (Descriptor386 PTR es:[edx]).BaseHigh32
	mov	al, (Descriptor386 PTR es:[edx]).BaseHigh24
d220 1
a220 1
	mov	ax, (Descriptor386 PTR es:[edx]).BaseLow
d222 1
a222 1
; Now ES:EDX -> LDT
d226 3
a228 3
; Now ES:EDX -> LDT entry
	mov	ah, (Descriptor386 PTR es:[edx]).BaseHigh32
	mov	al, (Descriptor386 PTR es:[edx]).BaseHigh24
d230 1
a230 1
	mov	ax, (Descriptor386 PTR es:[edx]).BaseLow
@


0.12
log
@Bug fixes: 5th task, VGA co40/co80 restore
@
text
@@


0.11
log
@Memory allocation enhance; bug fixes
@
text
@@


0.10
log
@VGA save/restore state fixed; bug fixes
@
text
@d26 6
a31 5
	EXTRN	MemSize: DWORD
	EXTRN	Pdb: DWORD
	EXTRN	PdbSeg: WORD
	EXTRN	GdtBase: DWORD
	EXTRN	Field: BYTE
d40 5
a44 2
	PUBVAR		PagesCtl, DD, ?	; Linear address of pages control 
						;  array
d52 4
a56 3
	PUBVAR		OsStartPage, DD, ?
	PUBVAR		OsEndPage, DD, ?

d152 1
a152 1
	mov	eax, Pdb
d155 1
a155 1
	mov	PdbLin, eax
d584 1
d680 142
@


0.9
log
@VGA state save/restore
@
text
@@


0.8
log
@Synchronization of system services; bug fixes
@
text
@@


0.7
log
@Working preemptive multitasking. Interrupts are reported to ALL tasks. Different tasks cannot work with the same device.
@
text
@@


0.7.0.1
log
@Attempt to synchronize disks with semaphores
@
text
@@


0.6
log
@Working non-preemptive multitasking
@
text
@@


0.5
log
@Working V86 emulation version!
@
text
@d30 1
a51 2
PUBLIC	Field
	Field		DB	16 DUP (?)
a119 1
int 3
a161 41
	;
	; Set PagesCtl entries for 1st Mb, OS_BASE
	;
; Set all page tables not present.
;	mov	es, PagesCtlSeg
;	sub	di, di
;	mov	eax, -1
;	mov	cx, 400h
;	cld
;		rep	stosd

; Store page table for 1st Mb linear address.
;	mov	fs, PdbSeg
;	mov	eax, fs:[0]
;	sub	eax, OsStartPage
;	or	eax, OS_BASE
;	and	eax, 0FFFFF000h
;	mov	es:[0], eax

; Store page table for OS_BASE linear address.
;	mov	eax, fs:[400h]
;	sub	eax, OsStartPage
;	or	eax, OS_BASE
;	and	eax, 0FFFFF000h
;	mov	es:[400h], eax

; Store page table for OS heap linear address.
;	mov	eax, fs:[800h]
;	sub	eax, OsStartPage
;	or	eax, OS_BASE
;	and	eax, 0FFFFF000h
;	mov	es:[800h], eax

; Set last element of OS heap 1st page to itself.
;	mov	eax, fs:[400h]
;	shr	eax, 8
;	mov	es, ax
;	shl	eax, 8
;	or	eax, PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
;	mov	es:[0FFCh], eax

d173 1
a173 1
ASSUME	CS:CODE32, DS:DATA
d241 1
a241 1
;	(!) Callable only form the system context.
d342 1
a343 1
	or	eax, PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
d612 1
a612 1
	jmp	end_find_free
d632 1
a632 1
	jmp	end_find_free
d643 1
a643 1
	jbe	finish
d660 1
a660 1
HeapFreePage	PROC
d669 3
@


0.4
log
@Basic V86 emulation
@
text
@d121 1
d134 7
d144 1
d168 6
a173 6
	mov	es, PagesCtlSeg
	sub	di, di
	mov	eax, -1
	mov	cx, 400h
	cld
		rep	stosd
d176 6
a181 6
	mov	fs, PdbSeg
	mov	eax, fs:[0]
	sub	eax, OsStartPage
	or	eax, OS_BASE
	and	eax, 0FFFFF000h
	mov	es:[0], eax
d184 5
a188 5
	mov	eax, fs:[400h]
	sub	eax, OsStartPage
	or	eax, OS_BASE
	and	eax, 0FFFFF000h
	mov	es:[400h], eax
d191 5
a195 5
	mov	eax, fs:[800h]
	sub	eax, OsStartPage
	or	eax, OS_BASE
	and	eax, 0FFFFF000h
	mov	es:[800h], eax
d198 6
a203 6
	mov	eax, fs:[400h]
	shr	eax, 8
	mov	es, ax
	shl	eax, 8
	or	eax, PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
	mov	es:[0FFCh], eax
@


0.3
log
@Initial check-in.
@
text
@d8 11
d28 1
d34 14
a47 2
	PagesMapSeg	DW	?
	PagesMap	DD	?
d50 3
d70 125
a194 12
InitPagesMap	PROC
;Allocate pages map.
	mov	ah, 48h
	mov	bx, PAGES_MAP_SIZE / 16
	int	21h
	jnc	alloc_ok
	call	InitErrHandler
alloc_ok:
	mov	PagesMapSeg, ax
	movzx	eax, ax
	shl	eax, 4
	mov	PagesMap, eax
d202 5
a206 1
CODE32	SEGMENT	BYTE	PUBLIC	USE32	'CODE'
a215 1
;	R:	DS = INIT_DS
d218 2
a219 1
PointerToLinear	PROC	USES es edx
d234 1
a234 1
	and	edx, 0FFFFh
d241 1
d245 1
a245 1
	and	edx, 0FFFFh
d255 1
a255 1
	and	eax, 0FFFFh
d262 1
d266 439
@


0.3.0.1
log
@Basic physical pages and heap pages memory management;
Bug fixes and additions tested.
@
text
@a7 11
; In order to access page tables, they will be supplied with page tables
; cotrol array. This array will have the structure of page directory but
; contain linear addresses of page tables instead of physical. Of course,
; linear addresses must be page-aligned (address of page); value of -1 will
; indicate the entry is not mapped (needed?)
;
;	(!)	DS = INIT_DS for most functions in this file.
;	(!)	In most functions most registers are destroyed. So generally
; the contents of registers after any MEMMAN function call should not be
; predicted (may be changed in future).
;
a16 1
	EXTRN	PdbSeg: WORD
d22 2
a23 14
	PUBVAR		PagesMapSeg, DW, ?	; Segment address of pages map
	PUBVAR		PagesMap, DD, ?	; linear address of pages map.
	PUBVAR		PagesCtlSeg, DW, ?	; Segment address of pages control 
						; array
	PUBVAR		PagesCtl, DD, ?	; Linear address of pages control 
					;  array
	PdbLin		DD	?	; PDB linear address.
	OsHeapEnd	DD	OS_HEAP	; Points to the tail of OS heap
					; linear address.
	PUBVAR		OsHeapBitmap, DD, ?	; Linear address of OS heap 
						; bitmap.
	PUBVAR		OsHeapBitmapSeg, DW, ?	; Segment address of OS heap
						; bitmap.

a25 2

	Field		DB	16 DUP (?)
d43 12
a54 125
InitPagesMap	PROC	USES es

	;
	; Zero pages map.
	;
	mov	es, PagesMapSeg
	sub	di, di
	mov	ecx, MemSize
	shr	ecx, 3
	inc	ecx
	sub	al, al
	cld
		rep	stosb
	;
	; Mark pages belonging to OS busy.
	;
	mov	es, PagesMapSeg
	sub	di, di
	mov	al, 0FFh
	mov	ecx, OsEndPage
	shr	ecx, 12			; ECX = pages count.
	mov	dx, cx			; Keep pages count.
	shr	ecx, 3
	cld
		rep	stosb
	mov	cx, dx
	and	cx, 7
	mov	al, 1
set_mask:
	test	cx, cx
	jz	end_set_mask
	shl	al, 1
	dec	cx
	jmp	set_mask
end_set_mask:
	dec	ax			; Set necessary bits.
	stosb

	;
	; Mark memory A0000 - FFFFF busy.
	;
	mov	ecx, 0Ch		; Mark busy 60h pages.
	mov	di, 0A0000h SHR 15	; At address A0000
	mov	al, -1			; Set all bits (pages) busy.
	cld
		rep	stosb

	;
	; Initialize page table control array Initialize. There are 
	; 2 page tables - one maps 1st Mb, the other - OS kernel at 2nd Gb.
	;
	mov	es, PdbSeg
	mov	eax, es:[0]		; 1st Mb page table
	sub	eax, OsStartPage
	or	eax, OS_BASE
	and	eax, 0FFFFF000h		; Linear address is page-aligned (!)

	mov	si, OS_BASE SHR 20
	mov	ecx, es:[si]		; OS kernel page table
	sub	ecx, OsStartPage
	or	ecx, OS_BASE
	and	ecx, 0FFFFF000h		; Linear address is page-aligned (!)

	mov	es, PagesCtlSeg
	mov	es:[0], eax
	mov	es:[si], ecx

	;
	; Record PDB linear address.
	;
	mov	eax, Pdb
	sub	eax, OsStartPage
	or	eax, OS_BASE
	mov	PdbLin, eax

	;
	; Zero OS heap bitmap.
	;
	mov	es, OsHeapBitmapSeg
	sub	di, di
	mov	cx, 2000h		; Zero 32k
	sub	eax, eax
	cld
		rep	stosd

	;
	; Set PagesCtl entries for 1st Mb, OS_BASE
	;
; Set all page tables not present.
	mov	es, PagesCtlSeg
	sub	di, di
	mov	eax, -1
	mov	cx, 400h
	cld
		rep	stosd

; Store page table for 1st Mb linear address.
	mov	fs, PdbSeg
	mov	eax, fs:[0]
	sub	eax, OsStartPage
	or	eax, OS_BASE
	and	eax, 0FFFFF000h
	mov	es:[0], eax

; Store page table for OS_BASE linear address.
	mov	eax, fs:[400h]
	sub	eax, OsStartPage
	or	eax, OS_BASE
	and	eax, 0FFFFF000h
	mov	es:[400h], eax

; Store page table for OS heap linear address.
	mov	eax, fs:[800h]
	sub	eax, OsStartPage
	or	eax, OS_BASE
	and	eax, 0FFFFF000h
	mov	es:[800h], eax

; Set last element of OS heap 1st page to itself.
	mov	eax, fs:[400h]
	shr	eax, 8
	mov	es, ax
	shl	eax, 8
	or	eax, PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
	mov	es:[0FFCh], eax
a61 4
extrn	PmWriteStr32: near32
extrn	PmHex32ToA: near32


d72 1
a119 394


;-----------------------------------------------------------------------------
;
;	I: EAX = linear address that is mapped by the page table
;	   EBX = Page table control array base
;
;	O: EAX != 0 - not empty
;	   EAX = 0 - empty
;
;	R:
;	Should be called only for dynamically allocated page tables (heap).
;
;-----------------------------------------------------------------------------
IsPageTblEmpty	PROC	USES es ecx
	push	FLAT_DS
	pop	es

	mov	ecx, eax
	and	ecx, 0FFFFFFF8h
	or	ecx, 003FFFF8h		; Offset FF8h in last page table
					; entry.

	mov	eax, PAGE_PRESENT
test_empty:
	test	es:[ecx], eax
	jz	test_next
; Return not empty.
	mov	eax, 1
	ret

test_next:
	sub	ecx, 4
	jnl	test_empty
; Return empty.
	sub    eax, eax
	ret

IsPageTblEmpty	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = linear address to be mapped in the directory.
;	   EDX = PDB linear address
;	   EBX = Page table control array base
;
;	O: CF = 0 - success
;		1 - fail
;
;	Creates a new page table directory entry (page table) that will map
; the given linear address (but doesn't map the address)
;
;	R:
;	* Page table is always given U = 1, W = 1, P = 1
; (restrictions are applied at page table entry level).
;	* Last entry of page table allocated this way contains itself.
;
;-----------------------------------------------------------------------------
CreatePageTable	PROC	USES es eax ecx esi
	push	FLAT_DS
	pop	es

	mov	ecx, eax
	mov	esi, eax

	;
	; Allocate page for page table entry.
	;
	call	AllocPage
	cmp	eax, -1
	jne	map_page_table
	stc
	ret
map_page_table:
; Set page table's physical address in page dir.
	shr	esi, 20
	and	esi, 00000FFCh
	or	eax, PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
	mov	es:[edx][esi], eax

; Set page table's page's linear address to its own last element
	and	ecx, NOT 00000FFFh
	or	ecx, 003FF000h
	and	eax, NOT PAGE_USER 			; U = 0

; At this point linear address of the page table (mapped into itself) is
; still not valid, so MapPage _cannot_ be called to map the page directory
; to ifself. Instead _this_ page table physical address will be mapped to
; _temporary_ linear - 003FF000h which is always present.

	push	ecx
	mov	ecx, 3FF000h
	call	MapPage
	pop	ecx

	push	esi
	mov	dword ptr es:[ebx][esi], 3FF000h

	call	MapPage

	pop	esi

; Set page table's linear address in page table control array. Must be set
; prior to calling MapPage.
	mov	es:[ebx][esi], ecx

IF 0
	push	es
	push	ecx
	push	dword ptr es:[ebx][esi]

	push	ds
	pop	es
	mov	edi, offset Field
	call	PmHex32ToA
	mov	dh, 15
	mov	dl, 1
	mov	esi, offset Field
	mov	bl, 0Fh
	call	PmWriteStr32

	pop	eax

	mov	edi, offset Field
	call	PmHex32ToA
	mov	dh, 16
	mov	dl, 1
	mov	esi, offset Field
	mov	bl, 0Fh
	call	PmWriteStr32

	pop	eax

	mov	edi, offset Field
	call	PmHex32ToA
	mov	dh, 17
	mov	dl, 1
	mov	esi, offset Field
	mov	bl, 0Fh
	call	PmWriteStr32
	pop	es
ENDIF

; Set page table to all 0s but the last element.
	mov	esi, 0FF8h
	sub	eax, eax

zero_page_tbl:
	mov	es:[ecx][esi], eax
	sub	esi, 4
	jnl	zero_page_tbl

; Set linear address that maps page table as busy.
	mov	esi, OsHeapBitmap
	mov	eax, ecx
	and	eax, NOT OS_HEAP
	shr	eax, 12
	bts	dword ptr es:[esi], eax

	clc
exit:
	ret

CreatePageTable	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = physical address and attributes to set.
;	   ECX = linear address
;	   EDX = PDB linear address
;	   EBX = Page table control array base
;
;	O: CF = 0 - success
;		1 - fail
;
;	Maps given physical page to linear address.
;
;	R:
;	* The physical address must be allocated with AllocPage or otherwise
; set present. 
;	* If page directory is not present the function returns fail.
;	* The attributes in EAX apply to page only and will not be applied
; to appropriate page table directory.
;
;-----------------------------------------------------------------------------
MapPage		PROC	USES es eax ecx esi
	push	FLAT_DS
	pop	es

	;
	; Check if appropriate page table is present.
	;
	mov	esi, ecx
	shr	esi, 20
	and	esi, 00000FFCh
	test	dword ptr es:[edx][esi], PAGE_PRESENT
	jnz	map_page

; If not present, return fail.
	stc
	ret

map_page:
	mov	esi, es:[ebx][esi]		; Page table linear address.
	shr	ecx, 10
	and	ecx, 00000FFCh
	mov	es:[esi][ecx], eax

	clc
	ret
MapPage		ENDP


;-----------------------------------------------------------------------------
;
;	I:
;	O: EAX = Page physical address.
;		 -1 if no free pages.
;
;	Allocates physical page
;
;-----------------------------------------------------------------------------
PUBLIC	AllocPage
AllocPage	PROC	USES es ecx edx
	mov	ax, FLAT_DS
	mov	es, ax
	call	FirstFreePage
	cmp	eax, -1
	jne	page_found
	ret
page_found:
	mov	ecx, PagesMap
	mov	edx, eax
	shr	edx, 12			; EDX = bit offset.
	bts	dword ptr es:[ecx], edx	; Set bit specified by EDX.
	ret
AllocPage	ENDP


;-----------------------------------------------------------------------------
;
;	I:
;	O: EAX = physical address.
;		 -1 if no free pages.
;
;	Searches in pages map and returns first free physical page found.
;
;-----------------------------------------------------------------------------
FirstFreePage	PROC	USES es ecx edx
	mov	ax, FLAT_DS
	mov	es, ax

	mov	ecx, PagesMap	; ES:ECX -> pages map.
	sub	eax, eax	; EAX = page number (address >> 12)
find_free:
	mov	edx, es:[ecx]
	cmp	edx, -1
	jne	specify_free

	add	ecx, 4
	add	eax, 32
	cmp	eax, MemSize
	jna	find_free

	mov	eax, -1
	jmp	end_find_free

specify_free:
	shr	edx, 1
	jnc	free_found

	inc	eax
	jmp	specify_free

free_found:
	shl	eax, 12
end_find_free:

	ret
FirstFreePage	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = page to free.
;	O:
;
;	Frees previously allocated page. Doesn't check if the page was
; previously allocated.
;
;-----------------------------------------------------------------------------
FreePage	PROC	USES es ecx edx
	mov	cx, FLAT_DS
	mov	es, cx
	mov	ecx, PagesMap
	mov	edx, eax
	shr	edx, 12

	btc	dword ptr es:[ecx], edx	; Clear bit specified by EDX.
	ret
FreePage	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = attributes
;	O: EAX = linear address of a page.
;	       = -1 if not enough free pages for page of for page dir.
;
;	Allocates page from OS heap.
;
;-----------------------------------------------------------------------------
HeapAllocPage	PROC	USES es ecx edx ebx esi edi
	and	eax, 0FFFh
	mov	esi, eax
	call	AllocPage
	cmp	eax, -1
	jne	map_page
	ret

map_page:
	or	esi, eax
	;
	; Search in OS heap bitmap for first available entry.
	;
	mov	cx, FLAT_DS
	mov	es, cx
	mov	edi, OsHeapBitmap
	mov	ecx, OS_HEAP
find_free:
	mov	edx, es:[edi]
	cmp	edx, -1
	jne	specify_free

	add	edi, 4
	add	ecx, 20000h
	cmp	ecx, OS_HEAP + 0FFFFFFFh
	jna	find_free

	mov	eax, -2
	jmp	end_find_free

specify_free:
	shr	edx, 1
	jnc	free_found

	add	ecx, 1000h
	jmp	specify_free
free_found:
	mov	eax, esi		; Apply given attributes.
	mov	edx, PdbLin
	mov	ebx, PagesCtl
	call	MapPage
	mov	eax, ecx
	jnc	set_busy

	call	CreatePageTable
	jnc	free_found

	mov	eax, -3
	jmp	end_find_free
set_busy:

	mov	ecx, OsHeapBitmap
	mov	edx, eax
	and	edx, NOT OS_HEAP
	shr	edx, 12			; EDX = bit offset.
	bts	dword ptr es:[ecx], edx	; Set bit specified by EDX.
end_find_free:
	ret
HeapAllocPage	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = linear address of a page.
;	O:
;
;	Frees previously allocated page from OS heap.
;
;-----------------------------------------------------------------------------
HeapFreePage	PROC
	mov	cx, FLAT_DS
	mov	es, cx
	mov	ecx, OsHeapBitmap
	mov	edx, eax
	and	edx, NOT OS_HEAP
	shr	edx, 12

	btc	dword ptr es:[ecx], edx	; Clear bit specified by EDX.
	ret
HeapFreePage	ENDP
@
