head	0.53;
access;
symbols;
locks
	BlackPhantom:0.53
	BlackPhantom:0.7.0.1; strict;
comment	@;; @;


0.53
date	2002.05.13.03.00.48;	author BlackPhantom;	state Exp;
branches;
next	0.52;

0.52
date	2001.02.13.04.09.54;	author BlackPhantom;	state Exp;
branches;
next	0.51;

0.51
date	2001.02.12.02.23.02;	author BlackPhantom;	state Exp;
branches;
next	0.50;

0.50
date	2001.02.02.23.44.36;	author BlackPhantom;	state Exp;
branches;
next	0.49;

0.49
date	2001.01.19.19.25.00;	author BlackPhantom;	state Exp;
branches;
next	0.48;

0.48
date	2000.12.27.05.36.43;	author BlackPhantom;	state Exp;
branches;
next	0.47;

0.47
date	2000.11.19.00.48.14;	author BlackPhantom;	state Exp;
branches;
next	0.46;

0.46
date	2000.08.31.02.13.37;	author BlackPhantom;	state Exp;
branches;
next	0.45;

0.45
date	2000.08.15.23.51.37;	author BlackPhantom;	state Exp;
branches;
next	0.44;

0.44
date	2000.03.23.14.09.09;	author BlackPhantom;	state Exp;
branches;
next	0.43;

0.43
date	99.08.10.02.48.18;	author BlackPhantom;	state Exp;
branches;
next	0.42;

0.42
date	99.08.06.17.48.52;	author BlackPhantom;	state Exp;
branches;
next	0.41;

0.41
date	99.07.16.03.18.20;	author BlackPhantom;	state Exp;
branches;
next	0.40;

0.40
date	99.06.05.20.07.01;	author BlackPhantom;	state Exp;
branches;
next	0.39;

0.39
date	99.05.28.22.41.24;	author BlackPhantom;	state Exp;
branches;
next	0.38;

0.38
date	99.05.28.18.27.56;	author BlackPhantom;	state Exp;
branches;
next	0.37;

0.37
date	99.05.28.04.20.40;	author BlackPhantom;	state Exp;
branches;
next	0.36;

0.36
date	99.05.27.22.22.07;	author BlackPhantom;	state Exp;
branches;
next	0.35;

0.35
date	99.05.23.19.52.27;	author BlackPhantom;	state Exp;
branches;
next	0.34;

0.34
date	99.05.23.15.13.32;	author BlackPhantom;	state Exp;
branches;
next	0.33;

0.33
date	99.05.21.02.27.28;	author BlackPhantom;	state Exp;
branches;
next	0.32;

0.32
date	99.05.19.01.13.28;	author BlackPhantom;	state Exp;
branches;
next	0.31;

0.31
date	99.05.17.18.49.52;	author BlackPhantom;	state Exp;
branches;
next	0.30;

0.30
date	99.05.11.17.10.49;	author BlackPhantom;	state Exp;
branches;
next	0.29;

0.29
date	99.05.06.22.37.51;	author BlackPhantom;	state Exp;
branches;
next	0.28;

0.28
date	99.05.05.16.38.55;	author BlackPhantom;	state Exp;
branches;
next	0.27;

0.27
date	99.04.19.21.02.51;	author BlackPhantom;	state Exp;
branches;
next	0.26;

0.26
date	99.04.18.12.54.59;	author BlackPhantom;	state Exp;
branches;
next	0.25;

0.25
date	99.04.17.03.11.27;	author BlackPhantom;	state Exp;
branches;
next	0.24;

0.24
date	99.04.14.18.28.12;	author BlackPhantom;	state Exp;
branches;
next	0.23;

0.23
date	99.04.14.16.43.57;	author BlackPhantom;	state Exp;
branches;
next	0.22;

0.22
date	99.04.12.18.51.50;	author BlackPhantom;	state Exp;
branches;
next	0.21;

0.21
date	99.04.11.12.52.23;	author BlackPhantom;	state Exp;
branches;
next	0.20;

0.20
date	99.04.05.03.15.12;	author BlackPhantom;	state Exp;
branches;
next	0.19;

0.19
date	99.03.30.23.45.44;	author BlackPhantom;	state Exp;
branches;
next	0.18;

0.18
date	99.03.29.18.33.30;	author BlackPhantom;	state Exp;
branches;
next	0.17;

0.17
date	99.03.22.22.40.13;	author BlackPhantom;	state Exp;
branches;
next	0.16;

0.16
date	99.03.18.04.09.05;	author BlackPhantom;	state Exp;
branches;
next	0.15;

0.15
date	99.03.16.02.16.25;	author BlackPhantom;	state Exp;
branches;
next	0.14;

0.14
date	99.03.16.00.23.39;	author BlackPhantom;	state Exp;
branches;
next	0.13;

0.13
date	99.03.13.23.36.05;	author BlackPhantom;	state Exp;
branches;
next	0.12;

0.12
date	99.03.12.22.09.18;	author BlackPhantom;	state Exp;
branches;
next	0.11;

0.11
date	99.03.09.04.23.38;	author BlackPhantom;	state Exp;
branches;
next	0.10;

0.10
date	99.03.01.23.10.12;	author BlackPhantom;	state Exp;
branches;
next	0.9;

0.9
date	99.02.25.21.57.36;	author BlackPhantom;	state Exp;
branches;
next	0.8;

0.8
date	99.02.24.02.20.20;	author BlackPhantom;	state Exp;
branches;
next	0.7;

0.7
date	99.02.18.00.07.41;	author BlackPhantom;	state Exp;
branches
	0.7.0.1;
next	0.6;

0.6
date	99.02.17.17.01.48;	author BlackPhantom;	state Exp;
branches;
next	0.5;

0.5
date	99.02.10.04.40.20;	author BlackPhantom;	state Exp;
branches;
next	0.4;

0.4
date	98.12.23.00.55.44;	author BlackPhantom;	state Exp;
branches;
next	0.3;

0.3
date	98.06.05.12.53.08;	author BlackPhantom;	state Exp;
branches;
next	0.1;

0.1
date	98.05.16.12.49.47;	author BlackPhantom;	state Exp;
branches;
next	;

0.7.0.1
date	99.02.21.04.01.14;	author BlackPhantom;	state Exp;
branches;
next	;


desc
@Source file for White & Black Phantoms ASM Library
@


0.53
log
@Last developed version
@
text
@;=============================================================================
;
;	This source code file is copyright (c) Vadim Drubetsky AKA the 
; Black Phantom. All rights reserved.
;
;	This source code file is a part of the Tripple-DOS project. Your use 
; of this source code must fully comply with the accompanying license file, 
; LICENSE.TXT. You must have this file enclosed with your Tripple-DOS copy in
; order for it to be legal.
;
;	In no event, except for when it is explicitly stated by the applicable 
; law, shall Vadim Drubetsky aka the Black Phantom be liable for any special,
; incidental, indirect, or consequential damages (including but not limited to
; profit loss, business interruption, loss of business information, or any 
; other pecuniary loss) arising out of the use of or inability to use 
; Tripple-DOS, even if he has been advised of the possibility of such damages.
;
;=============================================================================

;=============================================================================
;
;				PHLIB.ASM
;				---------
;
;	This is a source for White & Black Phantoms standard library.
;
;	Several general concepts.
;  * "String" always means ASCIIz string.
;  * On input: memory buffer always will be pointed by DS:SI, number - given
;  in AX (AL) register, long integer - in DX:AX register pair.
;  * On output: memory buffer always will be pointed by ES:DI, number will
;  be returned in AX (AL, DX:AX), CF=0 means no error, CF=1 - any error.
;  * Each procedure preserves all CPU registers except used in return.
;	For MASM v6.1
;
;	Project:	Tripple-DOS
;	Copyright (c) White & Black Phantoms 1995, 1996.
;	Written by Black Phantom.
;	Start Project:		(approx.) ??/09/95
;	Last Update:		14/04/96
;
;=============================================================================

WHITEANDBLACKPHANTOMS	EQU	666

			INCLUDE	PHLIB.INC

DATA	SEGMENT	PARA	PUBLIC	USE16	'DATA'
DATA	ENDS

STK	SEGMENT	PARA STACK	USE16	'STACK'
STK	ENDS

CODE	SEGMENT	PARA	PUBLIC	USE16	'CODE'
ASSUME CS:CODE, DS:DATA, SS:STK

;-----------------------------------------------------------------------------
;
;	I:  DS:SI -> source string.
;	O:  nothing
;
;	Prints ASCIIz string.
;
;-----------------------------------------------------------------------------
PrintString	PROC
	push	ax
	push	bx
	push	cx
	push	dx

	call	StrLen
	xchg	ax, cx

	mov	ah, WRITE_HANDLE
	mov	bx, STDOUT
	mov	dx, si
	int	21h

	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret
PrintString	ENDP


;-----------------------------------------------------------------------------
;
;	I:  AL = character
;	O:  nothing
;
;	Prints single char.
;
;-----------------------------------------------------------------------------
PrintChar	PROC	USES ax dx
	mov	ah, 6
	mov	dl, al
	cmp	al, -1
	jz	@@F
	int	21h
@@@@:
	ret
PrintChar	ENDP


;-----------------------------------------------------------------------------
;
;	I:  AL = 1-byte hex, ES:DI -> converted 2 bytes, 0-term.
;	O:  nothing
;
;	Converts number in AL to hex. representation at ES:DI
;
;-----------------------------------------------------------------------------
HexToA		PROC
	push	ax
	push	cx

	mov	ah, al
	and	al, 0F0h
	and	ah, 0Fh
	add	ah, '0'
	cmp	ah, '9'
	jna	@@F
	add	ah, 'A' - '0' - 10
@@@@:
	mov	cl, 4
	shr	al, cl
	add	al, '0'
	cmp	al, '9'
	jna	@@F
	add	al, 'A' - '0' - 10
@@@@:
	mov	es:[di], ax
	mov	byte ptr es:[di+2], 0

	pop	cx
	pop	ax
	ret
HexToA		ENDP


;-----------------------------------------------------------------------------
;
;	I:  AX = 2-byte hex, ES:DI -> converted 4 bytes, 0-term.
;	O:  nothing
;
;	Converts number in AX to hex. representation at ES:DI
;
;-----------------------------------------------------------------------------
Hex16ToA	PROC
	xchg	ah, al
	call	HexToA
	add	di, 2
	xchg	ah, al
	call	HexToA
	sub	di, 2
	ret
Hex16ToA	ENDP


;-----------------------------------------------------------------------------
;
;	I:  DX:AX = 4-byte hex, ES:DI -> converted 8 bytes, 0-term.
;	O:  nothing
;
;	Converts number in DX:AX to hex. representation at ES:DI
;
;-----------------------------------------------------------------------------
Hex32ToA	PROC
	xchg	ax, dx
	call	Hex16ToA
	add	di, 4
	xchg	ax, dx
	call	Hex16ToA
	sub	di, 4
	ret
Hex32ToA	ENDP


;-----------------------------------------------------------------------------
;
;	I:  AX = unsigned integer, ES:DI -> buffer to converted string.
;	O:  ES:DI -> buffer filled.
;
;	Converts unsigned integer to decimal representation string.
;
;-----------------------------------------------------------------------------
UIToA		PROC
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di

	mov	bx, 5

itoa_loop:
	xor	dx, dx
	mov	cx, 10
	div	cx
	add	dl, '0'
	mov	es:[bx+di], dl
	dec	bx
	or	ax, ax
	jnz	itoa_loop

	inc	bx
	mov	si, di
itoa_copy_lp:
	mov	al, es:[bx+di]
	mov	es:[si], al
	inc	si
	inc	bx
	cmp	bx, 5
	jna	itoa_copy_lp

	mov	byte ptr es:[si], 0

	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret

UIToA		ENDP


;-----------------------------------------------------------------------------
;
;	I:  AX = signed integer, ES:DI -> buffer to fill
;	O:  Buffer (ES:DI->) filled.
;
;	Converts signed integer to decimal representation string.
;
;-----------------------------------------------------------------------------
IToA		PROC
	or	ax, ax
	jns	@@F
	push	ax
	push	di
	neg	ax
	mov	byte ptr es:[di], '-'
	inc	di
	call	UIToA
	pop	di
	pop	ax
	ret
@@@@:
	call	UIToA
	ret
IToA		ENDP


;-----------------------------------------------------------------------------
;
;	I:  DX:AX = long unsigned integer, ES:DI -> buffer.
;	O:  Buffer (ES:DI->) filled.
;
;	Converts long unsigned integer to string.
;
;-----------------------------------------------------------------------------
LongUIToA	PROC
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di

	mov	byte ptr es:[di+11], 0
	mov	bx, 10
div10loop:
	call	Div32BitBy10
	add	cl, '0'
	mov	es:[bx+di], cl
	dec	bx
	or	ax, ax
	jnz	div10loop
	or	dx, dx
	jnz	div10loop

	inc	bx
	mov	si, di
copy_res_loop:
	mov	al, es:[bx+di]
	mov	es:[si], al
	inc	bx
	inc	si
	cmp	bx, 11
	jna	copy_res_loop

	mov	byte ptr es:[si], '0'

	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret
LongUIToA	ENDP


;-----------------------------------------------------------------------------
;
;	I:  DX:AX = long signed integer, ES:DI -> buffer.
;	O:  Buffer (ES:DI->) filled.
;
;	Converts long signed integer to string.
;
;-----------------------------------------------------------------------------
LongIToA	PROC
	or	dx, dx
	jns	@@F

	push	ax
	push	dx
	push	di

	not	ax
	not	dx
	add	ax, 1
	adc	dx, 0
	inc	di
	call	LongUIToA

	pop	di
	pop	dx
	pop	ax
	ret
@@@@:
	call	LongUIToA
	ret
LongIToA	ENDP


;-----------------------------------------------------------------------------
;
;	I:  DX:AX = long unsigned integer.
;	O:  DX:AX = result ( DX:AX = DX:AX / 10 ), CX = remainder.
;
;	Pefrorms integer division of 32-bit unsigned value by 10.
;
;-----------------------------------------------------------------------------
Div32BitBy10	PROC
	push	bx
	push	si
	push	di

	xchg	ax, cx
	xchg	ax, dx
	xor	dx, dx
	mov	bx, 10
	div	bx
	xchg	ax, si		; SI:DI - number.

	xchg	ax, dx
	ror	ax, 1
	ror	ax, 1
	ror	ax, 1
	ror	ax, 1
	mov	dx, cx
	shr	dx, 1
	shr	dx, 1
	shr	dx, 1
	shr	dx, 1
	and	ax, 0F000h
	or	ax, dx
	xor	dx, dx
	div	bx
	xchg	ax, di
	shl	di, 1
	shl	di, 1
	shl	di, 1
	shl	di, 1

	xchg	ax, dx
	shl	ax, 1
	shl	ax, 1
	shl	ax, 1
	shl	ax, 1
	and	ax, 00F0h
	mov	dx, cx
	and	dx, 000Fh
	or	ax, dx
	xor	dx, dx
	div	bx
	add	di, ax
	mov	cx, dx
	mov	dx, si
	xchg	ax, di

	pop	di
	pop	si
	pop	bx
	ret

Div32BitBy10	ENDP


;-----------------------------------------------------------------------------
;
;	I:  DS:SI -> decimal-represented number.
;	O:  CF = 0 - success, AX = number. CF = 1 - can't convert.
;
;-----------------------------------------------------------------------------
AToUI		PROC
	push	bx
	push	cx
	push	dx
	push	di

	call	StrLen
	xchg	ax, bx
	dec	bx
	mov	di, 1		; DI = mul operand
	sub	cx, cx		; CX = number
to_int_loop:
	mov	al, [bx+si]
	call	IsDigit
	jc	err_exit
	sub	al, '0'
	sub	ah, ah
	mul	di
	adc	cx, ax
	mov	ax, 10
	mul	di
	xchg	ax, di
	dec	bx
	jns	to_int_loop
	xchg	ax, cx
	clc
err_exit:
	pop	di
	pop	dx
	pop	cx
	pop	bx
	ret
AToUI		ENDP


;-----------------------------------------------------------------------------
;
;	I:  DS:SI -> decimal-represented number.
;	O:  CF = 0 - success, AX = number. CF = 1 - can't convert.
;
;-----------------------------------------------------------------------------
AToI		PROC
	cmp	byte ptr [si], '-'
	jnz	@@F
	inc	si
	call	AToUI
	dec	si
	neg	ax
	ret
@@@@:
	call	AToUI
	ret
AToI		ENDP


;-----------------------------------------------------------------------------
;
;	I:  DS:SI -> Buffer (hex. representation of a number).
;	O:  CF = 0 - success, DX:AX = number. CF = 1 - can't convert.
;
;-----------------------------------------------------------------------------
AToHex		PROC
	push	bx
	push	cx
	push	di

	call	StrLen
	xchg	ax, bx
	dec	bx
	sub	dx, dx
	sub	di, di		; DX:DI = number.
	sub	ax, ax
	xor	cl, cl
to_hex_loop:
	mov	al, [bx+si]
	call	ToUpper
	call	IsDigit16
	jc	err_exit
	sub	al, '0'
	cmp	al, 9
	jna	@@F
	sub	al, 'A' - 10 - '0'
@@@@:
	sub	ah, ah
	rol	ax, cl
	cmp	cl, 16
	jnb	to_hiword
	add	di, ax
	jmp	@@F
to_hiword:
	add	dx, ax
@@@@:
	add	cl, 4
	dec	bx
	jns	to_hex_loop

	xchg	ax, di
err_exit:
	pop	di
	pop	cx
	pop	bx
	ret
AToHex		ENDP


;-----------------------------------------------------------------------------
;
;	I:  DS:SI -> Buffer (int representation of a long integer).
;	O:  DX:AX = number.
;
;-----------------------------------------------------------------------------
AToLongUI	PROC
	push	bx
	push	cx
	push	di

	push	bp
	mov	bp, sp
	sub	sp, 4

	call	StrLen
	xchg	ax, bx
	dec	bx

	sub	cx, cx		; CX:DI = number.
	sub	di, di
	mov	word ptr [bp-4], 1
	mov	word ptr [bp-4][2], 0

to_lint_loop:
	mov	al, [bx+si]
	call	IsDigit
	jc	err_exit
	sub	al, '0'
	cbw
	push	ax

	mul	word ptr [bp-4][2]
	add	cx, ax
	pop	ax
	mul	word ptr [bp-4]
	add	di, ax
	adc	cx, dx

	mov	ax, 10
	push	ax
	mul	word ptr [bp-4][2]
	mov	word ptr [bp-4][2], ax
	pop	ax
	mul	word ptr [bp-4]
	mov	word ptr [bp-4], ax
	add	word ptr [bp-4][2], dx

	dec	bx
	jns	to_lint_loop

	xchg	ax, di
	mov	dx, cx

	clc
err_exit:
	mov	sp, bp
	pop	bp

	pop	di
	pop	cx
	pop	bx
	ret
AToLongUI	ENDP


;-----------------------------------------------------------------------------
;
;	I:  AL = char.
;	O:  CF = 0 - digit, CF = 1 - non-digit.
;
;-----------------------------------------------------------------------------
IsDigit		PROC
	cmp	al, '0'
	jb	@@F
	cmp	al, '9'
	ja	@@F
	clc
	ret
@@@@:
	stc
	ret
IsDigit		ENDP


;-----------------------------------------------------------------------------
;
;	I:  AL = char.
;	O:  CF = 0 - alpha, CF = 1 - non-alpha.
;
;-----------------------------------------------------------------------------
IsAlpha		PROC
	cmp	al, 'A'
	jb	non_alpha
	cmp	al, 'z'
	ja	non_alpha
	cmp	al, 'Z'
	jna	alpha
	cmp	al, 'a'
	jnb	alpha
	cmp	al, '_'
	jnz	non_alpha
alpha:
	clc
	ret
non_alpha:
	stc
	ret
IsAlpha		ENDP


;-----------------------------------------------------------------------------
;
;	I:  AL = char.
;	O:  CF = 0 - alpha or digit, CF = 1 neither of.
;
;-----------------------------------------------------------------------------
IsAlNum		PROC
	call	IsAlpha
	jc	@@F
	call	IsDigit
@@@@:
	ret
IsAlNum		ENDP


;-----------------------------------------------------------------------------
;
;	I:  AL = char
;	O:  CF = 0 if hex. digit, CF = 1 if not.
;
;-----------------------------------------------------------------------------
IsDigit16	PROC
	call	IsDigit
	jnc	digit16
	cmp	al, 'A'
	jb	non_digit16
	cmp	al, 'F'
	jna	digit16
	cmp	al, 'a'
	jb	non_digit16
	cmp	al, 'f'
	ja	non_digit16
digit16:
	clc
	ret
non_digit16:
	stc
	ret
IsDigit16	ENDP


;-----------------------------------------------------------------------------
;
;	I:  AL = char
;	O:  AL = upcase(AL)
;
;-----------------------------------------------------------------------------
ToUpper		PROC
	cmp	al, 'a'
	jb	@@F
	cmp	al, 'z'
	ja	@@F
	sub	al, 'a' - 'A'
@@@@:
	ret
ToUpper		ENDP


;-----------------------------------------------------------------------------
;
;	I:  AL = char
;	O:  AL = lowcase(AL)
;
;-----------------------------------------------------------------------------
ToLower		PROC
	cmp	al, 'A'
	jb	@@F
	cmp	al, 'Z'
	ja	@@F
	add	al, 'a' - 'A'
@@@@:
	ret
ToLower		ENDP


;-----------------------------------------------------------------------------
;
;	I:  DS:SI -> source 0-termin. string.
;	O:  AX = string length.
;
;-----------------------------------------------------------------------------
StrLen		PROC
	push	si

	sub	ax, ax
find_0_loop:
	cmp	byte ptr ds:[si], 0
	jz	found_0
	inc	si
	inc	ax
	jmp	find_0_loop
found_0:
	pop	si
	ret
StrLen		ENDP


;-----------------------------------------------------------------------------
;
;	I:  ES:DI -> buffer for arguments (256 bytes).
;	O:  ES:DI buffer filled, AX = number of params.
;
;-----------------------------------------------------------------------------
GetArguments	PROC USES cx si di
	mov	si, 81h
	xor	cx, cx
	xor	ax, ax
	mov	cl, ds:[80h]
	cld
next:
	jcxz	to_end
	cmp	byte ptr [si], SPACE
	jz	@@F
	cmp	byte ptr [si], TAB
	jnz	get_param
@@@@:
	dec	cx
	inc	si
	jmp	next
get_param:
	movsb
	dec	cx
	jcxz	got_param
	cmp	byte ptr [si], SPACE
	jz	got_param
	cmp	byte ptr [si], TAB
	jnz	get_param
got_param:
	inc	ax
	mov	byte ptr es:[di], NULL
	inc	di
	jmp	next
to_end:
	ret
GetArguments	ENDP


;-----------------------------------------------------------------------------
;
;	I:  DS:SI -> source string (0 - terminated).
;	    ES:DI -> dest string.
;	O:  nothing.
;
;	Procedure copies source string to destination. No checking on strings
; overlap is performed. (If second string overlaps first, function may fail.
; Terminating '\0'is included.
;-----------------------------------------------------------------------------
StrCpy		PROC USES ds es si di ax cx
	push	ds
	push	si
	call	StrLen
	pop	si
	pop	ds
	xchg	ax, cx
	inc	cx
	cld
		rep	movsb
	ret
StrCpy		ENDP

CODE	ENDS

END
@


0.52
log
@Stack segment for Tripple-DOS changed to 32-bit default. 16-bit stack didn't work with DPMI clients that set up stack to 32 bits and ESP > 64K! Now DJGPP stubbed programs work, but there is some problem when they return.
@
text
@d12 1
a12 1
; law, shall Vadim Drubetsky aka the Black Phantoms be liable for any special,
@


0.51
log
@Added general devices synchronization mechanism.
It's implemented for COM1 and COM2.
It causes problems with a keyboard.
@
text
@@


0.50
log
@Fixed HDD/FDD synchronization problem (trapped opcodes were overwriting each other).
@
text
@@


0.49
log
@Fixes version (log for INIT.ASM)
@
text
@@


0.48
log
@Enabled XMS 3.0 inteface
@
text
@@


0.47
log
@DMA partial virtualization is made - Tripple DOS now works with floppy!
@
text
@@


0.46
log
@Fixed a bug that didn't allow Tripple DOS work with DOS loaded HIGH
@
text
@@


0.45
log
@The shareware beta release
@
text
@@


0.44
log
@Bug fixes:
1) Checks for open file name (EDX to DX) problem
2) Reporting of the protected mode exception reboot
@
text
@d3 19
d25 1
a25 1
;	This is a source for Phantoms standard library.
d36 1
a36 1
;	Project:	INSP2
@


0.43
log
@Bug fixes:
1) Lower word in translation structure on real mode stack was being destroyed - very annoying.
2) Saved exception number was moved to task structure to allow multiple DPMI tasks work.
3 copies of WCC386 worked!
@
text
@@


0.42
log
@1) Added XMS server
2) Memory allocation / deallocation is moved to task creation / deletion
@
text
@@


0.41
log
@Bug fixes:
1) Virtual I/O jump table (very annoying!)
2) IsFileOpen() bug if file name is 0.
@
text
@@


0.40
log
@DPMI server fixes:
1) Locker real mode and protected mode stacks usage fixed: reentrancy allowed.
2) Modes switches fixed.
@
text
@@


0.39
log
@Bug fixed: raw mode switches.
@
text
@@


0.38
log
@Bugs fixed:
1) PointerToLinear() check
2) Default interrupt redirection to V86 mode
@
text
@@


0.37
log
@Bug fixed: reflecting PM to VM interrupt.
@
text
@@


0.36
log
@Bug fixes:
1) CreatePageTable() called from HeapAllocMem()
2) Zero allocated PDB for new task
@
text
@@


0.35
log
@HeapAllocMem() bug fixed; free DPMI memory allocated fixed.
@
text
@@


0.34
log
@Bug fixes:
1) Initial pages map allocation
2) Translation services params
3) DPMI clean up memory release -- almost
4) INT 21h AH=4Ch in protected mode.
@
text
@@


0.33
log
@Initial full release - all DPMI functions are written! Half are not tet.
@
text
@@


0.32
log
@Translation services work.
@
text
@@


0.31
log
@1) Interrupt redirection works
2) HeapAllocMem() bug fixes
DPMI traps fixed
@
text
@@


0.30
log
@DOS block functions are written and work. Callback to real mode mechanism established. Tests are still brief.
@
text
@@


0.29
log
@First DPMI selector functions work (Hello, world).
@
text
@@


0.28
log
@Initial DPMI switch works.
@
text
@@


0.27
log
@Solves INT 28 block problems (doesn't lock).
@
text
@@


0.26
log
@Bugs fixed:
1) Store open file name
2) Store DOS function per process
3) Imperfect INT 13 semaphore handling.
@
text
@@


0.25
log
@Fixed bug in IsFileOpen proc.
@
text
@@


0.24
log
@Removed unnecessary dynamic allocations.
@
text
@@


0.23
log
@1) File sharing handled.
@
text
@@


0.22
log
@1) Fully split task blocking and waiting for event.
2) Annoying bug fixed (TASK_PTR).
@
text
@@


0.21
log
@1) Improved task state handling (nesting allowed due to bit mask).
2) Bugs fixed.
TASK_PTR macro is used.
4) X86.MCR is out of project.
@
text
@@


0.20
log
@Task locks on wait for events are added.
@
text
@@


0.19
log
@Trap wait on keyboard (INT 16h / 0, 10h).
Bug fixes in memory allocation.
@
text
@@


0.18
log
@Keyboard virtualized.
File I/O interface for kernel is added.
@
text
@@


0.17
log
@Int 13h locking improvements, bug fixes (NC running)
@
text
@@


0.16
log
@Debug improvements (commands); VGA ports partial virtualizing
@
text
@@


0.15
log
@Debug improvements: hardware breakpoint
@
text
@@


0.14
log
@Bug fixes; debug improvements
@
text
@@


0.13
log
@Proper CPL 0 stack management; foreground task boost on event
@
text
@@


0.12
log
@Bug fixes: 5th task, VGA co40/co80 restore
@
text
@@


0.11
log
@Memory allocation enhance; bug fixes
@
text
@@


0.10
log
@VGA save/restore state fixed; bug fixes
@
text
@@


0.9
log
@VGA state save/restore
@
text
@@


0.8
log
@Synchronization of system services; bug fixes
@
text
@@


0.7
log
@Working preemptive multitasking. Interrupts are reported to ALL tasks. Different tasks cannot work with the same device.
@
text
@@


0.7.0.1
log
@Attempt to synchronize disks with semaphores
@
text
@@


0.6
log
@Working non-preemptive multitasking
@
text
@@


0.5
log
@Working V86 emulation version!
@
text
@@


0.4
log
@Basic V86 emulation
@
text
@@


0.3
log
@Port of previous version to 32 bits
@
text
@d29 6
d36 1
d766 1
@


0.1
log
@16/05/98	Initial checkin
@
text
@@
