head	0.53;
access;
symbols;
locks
	BlackPhantom:0.53
	BlackPhantom:0.7.0.1; strict;
comment	@;; @;


0.53
date	2002.05.13.03.00.48;	author BlackPhantom;	state Exp;
branches;
next	0.52;

0.52
date	2001.02.13.04.09.54;	author BlackPhantom;	state Exp;
branches;
next	0.51;

0.51
date	2001.02.12.02.23.02;	author BlackPhantom;	state Exp;
branches;
next	0.50;

0.50
date	2001.02.02.23.44.36;	author BlackPhantom;	state Exp;
branches;
next	0.49;

0.49
date	2001.01.19.19.25.00;	author BlackPhantom;	state Exp;
branches;
next	0.48;

0.48
date	2000.12.27.05.36.43;	author BlackPhantom;	state Exp;
branches;
next	0.47;

0.47
date	2000.11.19.00.48.14;	author BlackPhantom;	state Exp;
branches;
next	0.46;

0.46
date	2000.08.31.02.13.37;	author BlackPhantom;	state Exp;
branches;
next	0.45;

0.45
date	2000.08.15.23.51.37;	author BlackPhantom;	state Exp;
branches;
next	0.44;

0.44
date	2000.03.23.14.09.09;	author BlackPhantom;	state Exp;
branches;
next	0.43;

0.43
date	99.08.10.02.48.18;	author BlackPhantom;	state Exp;
branches;
next	0.42;

0.42
date	99.08.06.17.48.52;	author BlackPhantom;	state Exp;
branches;
next	0.41;

0.41
date	99.07.16.03.18.20;	author BlackPhantom;	state Exp;
branches;
next	0.40;

0.40
date	99.06.05.20.07.01;	author BlackPhantom;	state Exp;
branches;
next	0.39;

0.39
date	99.05.28.22.41.24;	author BlackPhantom;	state Exp;
branches;
next	0.38;

0.38
date	99.05.28.18.27.56;	author BlackPhantom;	state Exp;
branches;
next	0.37;

0.37
date	99.05.28.04.20.40;	author BlackPhantom;	state Exp;
branches;
next	0.36;

0.36
date	99.05.27.22.22.07;	author BlackPhantom;	state Exp;
branches;
next	0.35;

0.35
date	99.05.23.19.52.27;	author BlackPhantom;	state Exp;
branches;
next	0.34;

0.34
date	99.05.23.15.13.32;	author BlackPhantom;	state Exp;
branches;
next	0.33;

0.33
date	99.05.21.02.27.28;	author BlackPhantom;	state Exp;
branches;
next	0.32;

0.32
date	99.05.19.01.13.28;	author BlackPhantom;	state Exp;
branches;
next	0.31;

0.31
date	99.05.17.18.49.52;	author BlackPhantom;	state Exp;
branches;
next	0.30;

0.30
date	99.05.11.17.10.49;	author BlackPhantom;	state Exp;
branches;
next	0.29;

0.29
date	99.05.06.22.37.51;	author BlackPhantom;	state Exp;
branches;
next	0.28;

0.28
date	99.05.05.16.38.55;	author BlackPhantom;	state Exp;
branches;
next	0.27;

0.27
date	99.04.19.21.02.51;	author BlackPhantom;	state Exp;
branches;
next	0.26;

0.26
date	99.04.18.12.54.59;	author BlackPhantom;	state Exp;
branches;
next	0.25;

0.25
date	99.04.17.03.11.27;	author BlackPhantom;	state Exp;
branches;
next	0.24;

0.24
date	99.04.14.18.28.12;	author BlackPhantom;	state Exp;
branches;
next	0.23;

0.23
date	99.04.14.16.43.57;	author BlackPhantom;	state Exp;
branches;
next	0.22;

0.22
date	99.04.12.18.51.50;	author BlackPhantom;	state Exp;
branches;
next	0.21;

0.21
date	99.04.11.12.50.45;	author BlackPhantom;	state Exp;
branches;
next	0.20;

0.20
date	99.04.05.03.15.12;	author BlackPhantom;	state Exp;
branches;
next	0.19;

0.19
date	99.03.30.23.45.44;	author BlackPhantom;	state Exp;
branches;
next	0.18;

0.18
date	99.03.29.18.33.30;	author BlackPhantom;	state Exp;
branches;
next	0.17;

0.17
date	99.03.22.22.40.13;	author BlackPhantom;	state Exp;
branches;
next	0.16;

0.16
date	99.03.18.04.09.05;	author BlackPhantom;	state Exp;
branches;
next	0.15;

0.15
date	99.03.16.02.16.25;	author BlackPhantom;	state Exp;
branches;
next	0.14;

0.14
date	99.03.16.00.23.39;	author BlackPhantom;	state Exp;
branches;
next	0.13;

0.13
date	99.03.13.23.36.05;	author BlackPhantom;	state Exp;
branches;
next	0.12;

0.12
date	99.03.12.22.09.18;	author BlackPhantom;	state Exp;
branches;
next	0.11;

0.11
date	99.03.09.04.23.38;	author BlackPhantom;	state Exp;
branches;
next	0.10;

0.10
date	99.03.01.23.10.12;	author BlackPhantom;	state Exp;
branches;
next	0.9;

0.9
date	99.02.25.21.57.36;	author BlackPhantom;	state Exp;
branches;
next	0.8;

0.8
date	99.02.24.02.20.20;	author BlackPhantom;	state Exp;
branches;
next	0.7;

0.7
date	99.02.18.00.07.41;	author BlackPhantom;	state Exp;
branches
	0.7.0.1;
next	0.6;

0.6
date	99.02.17.17.01.48;	author BlackPhantom;	state Exp;
branches;
next	0.5;

0.5
date	99.02.10.04.40.20;	author BlackPhantom;	state Exp;
branches;
next	0.4;

0.4
date	98.12.23.00.55.44;	author BlackPhantom;	state Exp;
branches;
next	0.3;

0.3
date	98.06.05.12.46.26;	author BlackPhantom;	state Exp;
branches;
next	0.2;

0.2
date	98.05.28.02.57.28;	author BlackPhantom;	state Exp;
branches;
next	;

0.7.0.1
date	99.02.21.04.01.14;	author BlackPhantom;	state Exp;
branches;
next	;


desc
@Port for 32 bit default code segment of PHLIB library
@


0.53
log
@Last developed version
@
text
@;=============================================================================
;
;	This source code file is copyright (c) Vadim Drubetsky AKA the 
; Black Phantom. All rights reserved.
;
;	This source code file is a part of the Tripple-DOS project. Your use 
; of this source code must fully comply with the accompanying license file, 
; LICENSE.TXT. You must have this file enclosed with your Tripple-DOS copy in
; order for it to be legal.
;
;	In no event, except for when it is explicitly stated by the applicable 
; law, shall Vadim Drubetsky aka the Black Phantom be liable for any special,
; incidental, indirect, or consequential damages (including but not limited to
; profit loss, business interruption, loss of business information, or any 
; other pecuniary loss) arising out of the use of or inability to use 
; Tripple-DOS, even if he has been advised of the possibility of such damages.
;
;=============================================================================

;=============================================================================
;
;				PHLIB32.ASM
;				-----------
;
;	This is a port of PHLIB library for 32-bit code segment.
;
;=============================================================================

		INCLUDE	CORE.INC

.486p
		EXTRN	Columns: BYTE
		EXTRN	VBufTextSel: WORD

		EXTRN	GetAsciiCode: near32
		EXTRN	GotoXy: near32
		EXTRN	TtyChar: near32

CODE32	SEGMENT	BYTE	PUBLIC	USE32	'CODE'
ASSUME	CS:CODE32, DS:FLAT

;-----------------------------------------------------------------------------
;
;	I:  AL = 1-byte hex, ES:EDI -> converted 2 bytes, 0-term.
;	O:  nothing
;
;	Converts number in AL to hex. representation at ES:EDI
;
;-----------------------------------------------------------------------------
PmHexToA	PROC	near	USES es eax
	push	ds
	pop	es

	mov	ah, al
	and	al, 0F0h
	and	ah, 0Fh
	add	ah, '0'
	cmp	ah, '9'
	jna	@@F
	add	ah, 'A' - '0' - 10
@@@@:
	shr	al, 4
	add	al, '0'
	cmp	al, '9'
	jna	@@F
	add	al, 'A' - '0' - 10
@@@@:
	mov	es:[edi], ax
	mov	byte ptr es:[edi+2], 0

	ret
PmHexToA	ENDP


;-----------------------------------------------------------------------------
;
;	I:  AX = 2-byte hex, ES:EDI -> converted 4 bytes, 0-term.
;	O:  nothing
;
;	Converts number in AX to hex. representation at ES:EDI
;
;-----------------------------------------------------------------------------
PmHex16ToA	PROC	near
	xchg	ah, al
	call	PmHexToA
	add	edi, 2
	xchg	ah, al
	call	PmHexToA
	sub	edi, 2
	ret
PmHex16ToA	ENDP


;-----------------------------------------------------------------------------
;
;	I:  EAX = 4-byte hex, ES:EDI -> converted 8 bytes, 0-term.
;	O:  nothing
;
;	Converts number in EAX to hex. representation at ES:EDI
;
;-----------------------------------------------------------------------------
PmHex32ToA	PROC	near
	ror	eax, 16
	call	PmHex16ToA
	add	edi, 4
	ror	eax, 16
	call	PmHex16ToA
	sub	edi, 4
	ret
PmHex32ToA	ENDP


;-----------------------------------------------------------------------------
;
;	I:  AX = unsigned integer, ES:EDI -> buffer to converted string.
;	O:  ES:EDI -> buffer filled.
;
;	Converts unsigned integer to decimal representation string.
;
;-----------------------------------------------------------------------------
PmUIToA		PROC	near	USES eax ebx ecx edx esi edi
	mov	ebx, 5
	mov	ecx, 10
itoa_loop:
	xor	edx, edx
	div	ecx
	add	dl, '0'
	mov	es:[ebx+edi], dl
	dec	ebx
	test	eax, eax
	jnz	itoa_loop

	inc	ebx
	mov	esi, edi
itoa_copy_lp:
	mov	al, es:[ebx+edi]
	mov	es:[esi], al
	inc	esi
	inc	ebx
	cmp	ebx, 5
	jna	itoa_copy_lp

	mov	byte ptr es:[esi], 0

	ret

PmUIToA		ENDP


;-----------------------------------------------------------------------------
;
;	I:  EAX = signed integer, ES:EDI -> buffer to fill
;	O:  Buffer (ES:EDI->) filled.
;
;	Converts signed integer to decimal representation string.
;
;-----------------------------------------------------------------------------
PmIToA		PROC	near	USES eax edi
	test	eax, eax
	jns	@@F

	neg	eax
	mov	byte ptr es:[edi], '-'
	inc	edi
@@@@:
	call	PmUIToA
	ret
PmIToA		ENDP


;-----------------------------------------------------------------------------
;
;	I:  EAX = long unsigned integer, ES:EDI -> buffer.
;	O:  Buffer (ES:EDI->) filled.
;
;	Converts long unsigned integer to string.
;
;-----------------------------------------------------------------------------
PmLongUIToA	PROC	near	USES eax ebx ecx edx esi edi
	mov	byte ptr es:[edi+11], 0
	mov	ebx, 10
	mov	ecx, 10
div10loop:
	xor	edx, edx
	div	ecx
	add	dl, '0'
	mov	es:[ebx+edi], dl
	dec	ebx
	test	eax, eax
	jnz	div10loop
	test	edx, edx
	jnz	div10loop

	inc	ebx
	mov	esi, edi
copy_res_loop:
	mov	al, es:[ebx+edi]
	mov	es:[esi], al
	inc	ebx
	inc	esi
	cmp	ebx, 11
	jna	copy_res_loop

	mov	byte ptr es:[esi], '0'

	ret
PmLongUIToA	ENDP


;-----------------------------------------------------------------------------
;
;	I:  EAX = long signed integer, ES:DI -> buffer.
;	O:  Buffer (ES:DI->) filled.
;
;	Converts long signed integer to string.
;
;-----------------------------------------------------------------------------
PmLongIToA	PROC	near	USES eax edi
	test	eax, eax
	jns	@@F

	neg	eax
	mov	byte ptr es:[edi], '-'
	inc	edi
@@@@:
	call	PmUIToA
	ret

PmLongIToA	ENDP


;-----------------------------------------------------------------------------
;
;	I:  DS:ESI -> decimal-represented number.
;	O:  CF = 0 - success, EAX = number. CF = 1 - can't convert.
;
;-----------------------------------------------------------------------------
PmAToUI		PROC	near	USES ebx ecx edx edi
	call	PmStrLen
	xchg	eax, ebx
	dec	ebx
	mov	edi, 1		; DI = mul operand
	sub	ecx, ecx	; CX = number
to_int_loop:
	mov	al, [ebx+esi]
	call	PmIsDigit
	jc	err_exit

	sub	al, '0'
	movzx	eax, al
	mul	edi
	adc	ecx, eax
	mov	eax, 10
	mul	edi
	xchg	eax, edi
	dec	ebx
	jns	to_int_loop

	xchg	eax, ecx
	clc
err_exit:
	ret
PmAToUI		ENDP


;-----------------------------------------------------------------------------
;
;	I:  DS:ESI -> decimal-represented number.
;	O:  CF = 0 - success, AX = number. CF = 1 - can't convert.
;
;-----------------------------------------------------------------------------
PmAToI		PROC	near
	cmp	byte ptr [esi], '-'
	jnz	@@F

	inc	esi
	call	PmAToUI
	dec	esi
	neg	eax
	ret
@@@@:
	call	PmAToUI
	ret
PmAToI		ENDP


;-----------------------------------------------------------------------------
;
;	I:  DS:ESI -> Buffer (hex. representation of a number).
;	O:  CF = 0 - success, EAX = number. CF = 1 - can't convert.
;
;-----------------------------------------------------------------------------
PmAToHex	PROC	near	USES ebx ecx edi
	call	PmStrLen
	lea	ebx, [eax-1]
	sub	edx, edx		; EDX = number
	sub	eax, eax
	sub	cl, cl
to_hex_loop:
	mov	al, [esi+ebx]
	call	PmToUpper
	call	PmIsDigit16
	jc	err_exit

	sub	al, '0'
	cmp	al, 9
	jna	@@F

	sub	al, 'A' - 10 - '0'
@@@@:
	and	eax, 0FFh
	shl	eax, cl

	add	edx, eax
	add	cl, 4
	dec	ebx
	jns	to_hex_loop

	xchg	eax, edx
	clc
err_exit:
	ret
PmAToHex	ENDP


;-----------------------------------------------------------------------------
;
;	I:  AL = char.
;	O:  CF = 0 - digit, CF = 1 - non-digit.
;
;-----------------------------------------------------------------------------
PmIsDigit	PROC	near
	cmp	al, '0'
	jb	@@F
	cmp	al, '9'
	ja	@@F
	clc
	ret
@@@@:
	stc
	ret
PmIsDigit	ENDP


;-----------------------------------------------------------------------------
;
;	I:  AL = char.
;	O:  CF = 0 - alpha, CF = 1 - non-alpha.
;
;-----------------------------------------------------------------------------
PmIsAlpha	PROC	near
	cmp	al, 'A'
	jb	non_alpha
	cmp	al, 'z'
	ja	non_alpha
	cmp	al, 'Z'
	jna	alpha
	cmp	al, 'a'
	jnb	alpha
	cmp	al, '_'
	jnz	non_alpha
alpha:
	clc
	ret
non_alpha:
	stc
	ret
PmIsAlpha	ENDP


;-----------------------------------------------------------------------------
;
;	I:  AL = char.
;	O:  CF = 0 - alpha or digit, CF = 1 neither of.
;
;-----------------------------------------------------------------------------
PmIsAlNum	PROC	near
	call	PmIsAlpha
	jc	@@F
	call	PmIsDigit
@@@@:
	ret
PmIsAlNum	ENDP


;-----------------------------------------------------------------------------
;
;	I:  AL = char
;	O:  CF = 0 if hex. digit, CF = 1 if not.
;
;-----------------------------------------------------------------------------
PmIsDigit16	PROC	near
	call	PmIsDigit
	jnc	digit16
	cmp	al, 'A'
	jb	non_digit16
	cmp	al, 'F'
	jna	digit16
	cmp	al, 'a'
	jb	non_digit16
	cmp	al, 'f'
	ja	non_digit16
digit16:
	clc
	ret
non_digit16:
	stc
	ret
PmIsDigit16	ENDP


;-----------------------------------------------------------------------------
;
;	I:  AL = char
;	O:  AL = upcase(AL)
;
;-----------------------------------------------------------------------------
PmToUpper	PROC	near
	cmp	al, 'a'
	jb	@@F
	cmp	al, 'z'
	ja	@@F
	sub	al, 'a' - 'A'
@@@@:
	ret
PmToUpper	ENDP


;-----------------------------------------------------------------------------
;
;	I:  AL = char
;	O:  AL = lowcase(AL)
;
;-----------------------------------------------------------------------------
PmToLower	PROC	near
	cmp	al, 'A'
	jb	@@F
	cmp	al, 'Z'
	ja	@@F
	add	al, 'a' - 'A'
@@@@:
	ret
PmToLower	ENDP


;-----------------------------------------------------------------------------
;
;	I:  DS:ESI -> source 0-termin. string.
;	O:  EAX = string length.
;
;-----------------------------------------------------------------------------
PmStrLen	PROC	near	USES esi
	sub	eax, eax
find_0_loop:
	cmp	byte ptr ds:[esi][eax], 0
	jz	found_0
	inc	eax
	jmp	find_0_loop
found_0:
	ret
PmStrLen	ENDP


;-----------------------------------------------------------------------------
;
;	I:  DS:ESI -> source string (0 - terminated).
;	    ES:EDI -> dest string.
;	O:  nothing.
;
;	PROC	nearedure copies source string to destination. No checking on strings
; overlap is performed. (If second string overlaps first, function may fail.
; Terminating '\0'is included.
;
;-----------------------------------------------------------------------------
PmStrCpy	PROC	near USES ds es esi edi eax ecx
	push	ds
	push	esi
	call	PmStrLen
	pop	esi
	pop	ds
	inc	eax
	mov	ecx, eax
	shr	ecx, 2
	and	eax, 3
	cld
		rep	movsd
	mov	ecx, eax
		rep	movsb
	ret
PmStrCpy	ENDP


;----------------------------------------------------------------------------
;
;	I: DS:ESI -> 1st string (0 - terminated).
;	   ES:EDI -> 2nd string (0 - terminated).
;	   ECX = number of bytes to compare.
;	O: comparison result in flags.
;
;----------------------------------------------------------------------------
PUBLIC	PmStrNCmp
PmStrNCmp	PROC	near USES ecx esi edi
	cld
		repne	cmpsb
	ret
PmStrNCmp	ENDP


;----------------------------------------------------------------------------
;
;	I: DS:ESI -> source string (0-terminated)
;	   ES:EDI -> destination string (0-terminated).
;	O: result of comparison (in flags).
;
;----------------------------------------------------------------------------
PUBLIC	PmStrCmp
PmStrCmp	PROC	near USES eax ecx esi edi
	call	PmStrLen
	mov	ecx, eax
	push	ds
	push	esi
	mov	si, es
	mov	ds, si
	mov	esi, edi
	call	PmStrLen
	pop	esi
	pop	ds
	cmp	ecx, eax
	jne	@@F

	cld
		repe	cmpsb
@@@@:
	ret
PmStrCmp	ENDP


;----------------------------------------------------------------------------
;
;	I:  DS:ESI -> String (0 - terminated).
;	    DL:DH = column: row
;	    BL = color
;
;	R:	PROTMODE.
;
;	Prints a color string.
;
;-----------------------------------------------------------------------------
PUBLIC	PmWriteStr32
PmWriteStr32	PROC	near	USES es eax ecx esi edi
	call	PmStrLen
	mov	ecx, eax
	mov	al, dh
	mul	Columns
	add	al, dl
	adc	ah, 0
	shl	eax, 1
	movzx	edi, ax
	mov	es, VBufTextSel
	mov	ah, bl
	cld
write_loop:
	lodsb
	stosw
	loop	write_loop
	ret
PmWriteStr32	ENDP


;-----------------------------------------------------------------------------
;
;	I: AL = char
;	    DL:DH = column: row
;	    BL = color
;	    ECX = number of repetitions.
;
;	Prints a color char.
;
;-----------------------------------------------------------------------------
PUBLIC	PmWriteChar32
PmWriteChar32	PROC	USES es eax ecx edi
	push	eax
	mov	al, dh
	mul	Columns
	add	al, dl
	adc	ah, 0
	shl	eax, 1
	movzx	edi, ax
	mov	es, VBufTextSel
	pop	eax
	mov	ah, bl
	cld
		rep	stosw

	ret
PmWriteChar32	ENDP


;-----------------------------------------------------------------------------
;
;	I: DS:ESI -> string (0-terminated)
;	    DH = row.
;	    BL = color
;	    AL:AH = start:end column.
;
;	R:	PROTMODE.
;
;	Prints a color centered string.
;
;-----------------------------------------------------------------------------
PUBLIC	PmWriteCenteredStr32
PmWriteCenteredStr32	PROC	USES eax ecx edx edi
; Print spaces.
	mov	ecx, eax
	call	PmStrLen
	xchg	eax, ecx	; ECX = str. len.

	mov	edi, ecx
	neg	cl
	add	cl, ah
	sub	cl, al
	inc	cl
	shr	cl, 1

	mov	dl, al
	call	PmWriteChar32

; Print string.
	add	dl, cl
	call	PmWriteStr32

; Print the rest of spaces.
	add	edx, edi
	add	ecx, edi
	neg	cl
	add	cl, ah
	sub	cl, al
	call	PmWriteChar32

	ret
PmWriteCenteredStr32	ENDP


;-----------------------------------------------------------------------------
;
;	I: DH = row
;	   AH = attribute.
;	O:
;
;-----------------------------------------------------------------------------
PUBLIC	PmClearRow
PmClearRow	PROC	near32	USES eax ecx edx
	xchg	eax, edx
	sub	al, al
	call	GotoXy
	xchg	eax, edx
	mov	al, ' '
	mov	ecx, 80
clear_loop:
	call	TtyChar
	dec	ecx
	jnz	clear_loop
	ret
PmClearRow	ENDP


;-----------------------------------------------------------------------------
;
;	I:  DS:ESI -> memory to receive the string.
;	    EAX - max string length (not including terminating 0).
;	    DL:DH = screen X:Y
;	    BL = attribute.
;
;	O:  Buffer filled
;	    EAX = string length.
;
;-----------------------------------------------------------------------------
PUBLIC	PmGetStr32
PmGetStr32	PROC	near32 USES ecx edx esi
LOCAL	X: byte, Y: byte, Char: byte
	mov	X, dl
	mov	Y, dh
	mov	ecx, eax		; ECX = max. length counter.

; Clear row.
	mov	ah, bl			; Attribute.
	call	PmClearRow

	mov	al, X
	mov	ah, Y
	call	GotoXy

	sub	edx, edx		; EDX = string length counter.
	cld
get_str:
	call	GetAsciiCode
	mov	Char, al

	mov	al, Char
	cmp	al, 13
	je	end_get_str

	test	al, al			; Zero ASCII code?
	jz	get_str

	cmp	al, 8			; Backspace?
	jne	normal_ascii

	test	edx, edx		; If at the beginning, go back.
	jz	get_str
; Delete last char.
	dec	X
	mov	al, X
	mov	ah, Y
	call	GotoXy
	mov	al, ' '
	mov	ah, NORMAL_ATTR
	call	TtyChar
	mov	al, X
	mov	ah, Y
	call	GotoXy
; Decrement all counters.
	dec	esi
	dec	edx
	inc	ecx
	jmp	get_str

normal_ascii:
	mov	[esi], al
	mov	ah, NORMAL_ATTR
	call	TtyChar
	inc	esi
	inc	edx
	inc	X
	dec	ecx
	jnz	get_str

end_get_str:
	mov	byte ptr [esi], 0
	mov	eax, edx
	ret
PmGetStr32	ENDP

CODE32	ENDS
END
@


0.52
log
@Stack segment for Tripple-DOS changed to 32-bit default. 16-bit stack didn't work with DPMI clients that set up stack to 32 bits and ESP > 64K! Now DJGPP stubbed programs work, but there is some problem when they return.
@
text
@d12 1
a12 1
; law, shall Vadim Drubetsky aka the Black Phantoms be liable for any special,
@


0.51
log
@Added general devices synchronization mechanism.
It's implemented for COM1 and COM2.
It causes problems with a keyboard.
@
text
@@


0.50
log
@Fixed HDD/FDD synchronization problem (trapped opcodes were overwriting each other).
@
text
@@


0.49
log
@Fixes version (log for INIT.ASM)
@
text
@@


0.48
log
@Enabled XMS 3.0 inteface
@
text
@@


0.47
log
@DMA partial virtualization is made - Tripple DOS now works with floppy!
@
text
@@


0.46
log
@Fixed a bug that didn't allow Tripple DOS work with DOS loaded HIGH
@
text
@@


0.45
log
@The shareware beta release
@
text
@@


0.44
log
@Bug fixes:
1) Checks for open file name (EDX to DX) problem
2) Reporting of the protected mode exception reboot
@
text
@d3 19
@


0.43
log
@Bug fixes:
1) Lower word in translation structure on real mode stack was being destroyed - very annoying.
2) Saved exception number was moved to task structure to allow multiple DPMI tasks work.
3 copies of WCC386 worked!
@
text
@@


0.42
log
@1) Added XMS server
2) Memory allocation / deallocation is moved to task creation / deletion
@
text
@@


0.41
log
@Bug fixes:
1) Virtual I/O jump table (very annoying!)
2) IsFileOpen() bug if file name is 0.
@
text
@d513 1
a513 1
		repne	cmpsb
@


0.40
log
@DPMI server fixes:
1) Locker real mode and protected mode stacks usage fixed: reentrancy allowed.
2) Modes switches fixed.
@
text
@@


0.39
log
@Bug fixed: raw mode switches.
@
text
@@


0.38
log
@Bugs fixed:
1) PointerToLinear() check
2) Default interrupt redirection to V86 mode
@
text
@@


0.37
log
@Bug fixed: reflecting PM to VM interrupt.
@
text
@d699 1
a699 1
	call	TTyChar
@


0.36
log
@Bug fixes:
1) CreatePageTable() called from HeapAllocMem()
2) Zero allocated PDB for new task
@
text
@@


0.35
log
@HeapAllocMem() bug fixed; free DPMI memory allocated fixed.
@
text
@@


0.34
log
@Bug fixes:
1) Initial pages map allocation
2) Translation services params
3) DPMI clean up memory release -- almost
4) INT 21h AH=4Ch in protected mode.
@
text
@@


0.33
log
@Initial full release - all DPMI functions are written! Half are not tet.
@
text
@@


0.32
log
@Translation services work.
@
text
@@


0.31
log
@1) Interrupt redirection works
2) HeapAllocMem() bug fixes
DPMI traps fixed
@
text
@@


0.30
log
@DOS block functions are written and work. Callback to real mode mechanism established. Tests are still brief.
@
text
@@


0.29
log
@First DPMI selector functions work (Hello, world).
@
text
@@


0.28
log
@Initial DPMI switch works.
@
text
@@


0.27
log
@Solves INT 28 block problems (doesn't lock).
@
text
@@


0.26
log
@Bugs fixed:
1) Store open file name
2) Store DOS function per process
3) Imperfect INT 13 semaphore handling.
@
text
@@


0.25
log
@Fixed bug in IsFileOpen proc.
@
text
@@


0.24
log
@Removed unnecessary dynamic allocations.
@
text
@@


0.23
log
@1) File sharing handled.
@
text
@@


0.22
log
@1) Fully split task blocking and waiting for event.
2) Annoying bug fixed (TASK_PTR).
@
text
@@


0.21
log
@1) Inproved task state handling (nesting allowed due to bit mask).
2) TASK_PTR macro used.
3) Bugs fixed.
4) X86.MCR is out of project.
@
text
@@


0.20
log
@Task locks on wait for events are added.
@
text
@d482 1
a482 1
PUBLIC	PmStrNCmp	
d497 1
a497 1
PUBLIC	PmStrCmp	
@


0.19
log
@Trap wait on keyboard (INT 16h / 0, 10h).
Bug fixes in memory allocation.
@
text
@@


0.18
log
@Keyboard virtualized.
File I/O interface for kernel is added.
@
text
@@


0.17
log
@Int 13h locking improvements, bug fixes (NC running)
@
text
@@


0.16
log
@Debug improvements (commands); VGA ports partial virtualizing
@
text
@@


0.15
log
@Debug improvements: hardware breakpoint
@
text
@d276 1
a276 2
	xchg	eax, ebx
	dec	ebx
d279 1
a279 1
	xor	cl, cl
d281 1
a281 1
	mov	al, [ebx+esi]
d292 2
a293 2
	movzx	eax, al
	rol	eax, cl
d301 1
d472 45
@


0.14
log
@Bug fixes; debug improvements
@
text
@d294 1
a294 1
	rol	ax, cl
@


0.13
log
@Proper CPL 0 stack management; foreground task boost on event
@
text
@d10 2
d13 2
a14 2
	EXTRN	Columns: BYTE
	EXTRN	VBufTextSel: WORD
d16 3
a18 3
	EXTRN	GetAsciiCode: near32
	EXTRN	GotoXy: near32
	EXTRN	TtyChar: near32
d583 1
d588 3
a590 3
PmClearRow	PROC	near32	USES eax ecx
	sub	eax, eax
	mov	ah, dh
d592 3
a594 2
	sub	eax, eax
	mov	ecx, 79
d606 3
a608 1
;	    EAX - max string length.
a612 2
;	R:	PROTMODE.
;
d615 15
a629 3
PmGetStr32	PROC	near32 USES ecx edx
	mov	ecx, eax
	sub	edx, edx
d633 3
d638 27
d666 1
a666 1
	mov	ah, 7
d670 1
d673 1
@


0.12
log
@Bug fixes: 5th task, VGA co40/co80 restore
@
text
@@


0.11
log
@Memory allocation enhance; bug fixes
@
text
@d29 1
a29 1
PmHexToA	PROC	near	USES es eax ecx
d41 1
a41 2
	mov	cl, 4
	shr	al, cl
@


0.10
log
@VGA save/restore state fixed; bug fixes
@
text
@d477 1
a477 1
;	    BL    = color
d481 2
d485 1
a485 1
PmWriteStr32	PROC	near	USES es eax ecx edx esi edi
d507 74
d586 1
a586 1
PmClearRow	PROC	near32	USES eax
@


0.9
log
@VGA state save/restore
@
text
@@


0.8
log
@Synchronization of system services; bug fixes
@
text
@@


0.7
log
@Working preemptive multitasking. Interrupts are reported to ALL tasks. Different tasks cannot work with the same device.
@
text
@@


0.7.0.1
log
@Attempt to synchronize disks with semaphores
@
text
@@


0.6
log
@Working non-preemptive multitasking
@
text
@@


0.5
log
@Working V86 emulation version!
@
text
@d15 1
d483 1
a483 1
PmWriteStr32	PROC	near	USES es eax ecx
d501 21
@


0.4
log
@Basic V86 emulation
@
text
@d10 1
d14 2
a16 1
.486p
d18 1
d28 4
a31 1
PmHexToA	PROC	near	USES eax ecx
d474 3
a476 3
;	DS:ESI -> String (0 - terminated).
;	DL:DH = column: row
;	BL    = color
d501 33
@


0.3
log
@Port of previous version for 32 bits.
@
text
@@


0.2
log
@Initial check-in
@
text
@d6 1
a6 1
;	This is a port of PHLIB library for 32-bit segment.
d10 4
d25 1
a25 1
PmHexToA	PROC	USES eax ecx
d56 1
a56 1
PmHex16ToA	PROC
d75 1
a75 1
PmHex32ToA	PROC
d94 1
a94 1
PmUIToA		PROC	USES eax ebx ecx edx esi edi
d131 1
a131 1
PmIToA		PROC	USES eax edi
d152 1
a152 1
PmLongUIToA	PROC	USES eax ebx ecx edx esi edi
d191 1
a191 1
PmLongIToA	PROC	USES eax edi
d211 1
a211 1
PmAToUI		PROC	USES ebx ecx edx edi
d245 1
a245 1
PmAToI		PROC
d266 1
a266 1
PmAToHex	PROC	USES ebx ecx edi
d305 1
a305 1
PmIsDigit	PROC
d324 1
a324 1
PmIsAlpha	PROC
d350 1
a350 1
PmIsAlNum	PROC
d365 1
a365 1
PmIsDigit16	PROC
d391 1
a391 1
PmToUpper	PROC
d408 1
a408 1
PmToLower	PROC
d425 1
a425 1
PmStrLen	PROC	USES esi
d443 1
a443 1
;	Procedure copies source string to destination. No checking on strings
d448 1
a448 1
PmStrCpy	PROC USES ds es esi edi eax ecx
d464 30
@
