head	0.53;
access;
symbols;
locks
	BlackPhantom:0.53
	BlackPhantom:0.7.0.1; strict;
comment	@# @;


0.53
date	2002.05.12.23.10.02;	author BlackPhantom;	state Exp;
branches;
next	0.52;

0.52
date	2001.02.13.04.09.54;	author BlackPhantom;	state Exp;
branches;
next	0.51;

0.51
date	2001.02.12.02.23.02;	author BlackPhantom;	state Exp;
branches;
next	0.50;

0.50
date	2001.02.02.23.44.36;	author BlackPhantom;	state Exp;
branches;
next	0.49;

0.49
date	2001.01.19.19.25.00;	author BlackPhantom;	state Exp;
branches;
next	0.48;

0.48
date	2000.12.27.05.37.22;	author BlackPhantom;	state Exp;
branches;
next	0.47;

0.47
date	2000.11.19.00.48.14;	author BlackPhantom;	state Exp;
branches;
next	0.46;

0.46
date	2000.08.31.02.13.37;	author BlackPhantom;	state Exp;
branches;
next	0.45;

0.45
date	2000.08.15.23.51.37;	author BlackPhantom;	state Exp;
branches;
next	0.44;

0.44
date	2000.03.23.14.09.09;	author BlackPhantom;	state Exp;
branches;
next	0.43;

0.43
date	99.08.10.02.48.18;	author BlackPhantom;	state Exp;
branches;
next	0.42;

0.42
date	99.08.06.17.48.52;	author BlackPhantom;	state Exp;
branches;
next	0.41;

0.41
date	99.07.16.03.18.20;	author BlackPhantom;	state Exp;
branches;
next	0.40;

0.40
date	99.06.05.20.07.01;	author BlackPhantom;	state Exp;
branches;
next	0.39;

0.39
date	99.05.28.22.41.24;	author BlackPhantom;	state Exp;
branches;
next	0.38;

0.38
date	99.05.28.18.27.56;	author BlackPhantom;	state Exp;
branches;
next	0.37;

0.37
date	99.05.28.04.20.40;	author BlackPhantom;	state Exp;
branches;
next	0.36;

0.36
date	99.05.27.22.22.07;	author BlackPhantom;	state Exp;
branches;
next	0.35;

0.35
date	99.05.23.19.52.27;	author BlackPhantom;	state Exp;
branches;
next	0.34;

0.34
date	99.05.23.15.13.32;	author BlackPhantom;	state Exp;
branches;
next	0.33;

0.33
date	99.05.21.02.27.28;	author BlackPhantom;	state Exp;
branches;
next	0.32;

0.32
date	99.05.19.01.13.28;	author BlackPhantom;	state Exp;
branches;
next	0.31;

0.31
date	99.05.17.18.49.52;	author BlackPhantom;	state Exp;
branches;
next	0.30;

0.30
date	99.05.11.17.10.49;	author BlackPhantom;	state Exp;
branches;
next	0.29;

0.29
date	99.05.06.22.37.51;	author BlackPhantom;	state Exp;
branches;
next	0.28;

0.28
date	99.05.05.16.38.55;	author BlackPhantom;	state Exp;
branches;
next	0.27;

0.27
date	99.04.19.21.02.51;	author BlackPhantom;	state Exp;
branches;
next	0.26;

0.26
date	99.04.18.12.54.59;	author BlackPhantom;	state Exp;
branches;
next	0.25;

0.25
date	99.04.17.03.11.27;	author BlackPhantom;	state Exp;
branches;
next	0.24;

0.24
date	99.04.14.18.28.12;	author BlackPhantom;	state Exp;
branches;
next	0.23;

0.23
date	99.04.14.16.43.57;	author BlackPhantom;	state Exp;
branches;
next	0.22;

0.22
date	99.04.12.18.51.50;	author BlackPhantom;	state Exp;
branches;
next	0.21;

0.21
date	99.04.11.12.50.45;	author BlackPhantom;	state Exp;
branches;
next	0.20;

0.20
date	99.04.05.03.17.18;	author BlackPhantom;	state Exp;
branches;
next	0.19;

0.19
date	99.03.30.23.45.44;	author BlackPhantom;	state Exp;
branches;
next	0.18;

0.18
date	99.03.29.18.33.30;	author BlackPhantom;	state Exp;
branches;
next	0.17;

0.17
date	99.03.22.22.40.13;	author BlackPhantom;	state Exp;
branches;
next	0.16;

0.16
date	99.03.18.04.09.05;	author BlackPhantom;	state Exp;
branches;
next	0.15;

0.15
date	99.03.16.02.16.25;	author BlackPhantom;	state Exp;
branches;
next	0.14;

0.14
date	99.03.16.00.23.39;	author BlackPhantom;	state Exp;
branches;
next	0.13;

0.13
date	99.03.13.23.36.05;	author BlackPhantom;	state Exp;
branches;
next	0.12;

0.12
date	99.03.12.22.09.18;	author BlackPhantom;	state Exp;
branches;
next	0.11;

0.11
date	99.03.09.04.23.38;	author BlackPhantom;	state Exp;
branches;
next	0.10;

0.10
date	99.03.01.23.10.12;	author BlackPhantom;	state Exp;
branches;
next	0.9;

0.9
date	99.02.25.21.58.28;	author BlackPhantom;	state Exp;
branches;
next	0.8;

0.8
date	99.02.24.02.21.35;	author BlackPhantom;	state Exp;
branches;
next	0.7;

0.7
date	99.02.18.00.08.43;	author BlackPhantom;	state Exp;
branches
	0.7.0.1;
next	0.6;

0.6
date	99.02.17.17.02.34;	author BlackPhantom;	state Exp;
branches;
next	0.5;

0.5
date	99.02.10.04.44.39;	author BlackPhantom;	state Exp;
branches;
next	0.4;

0.4
date	98.12.23.01.07.23;	author BlackPhantom;	state Exp;
branches;
next	;

0.7.0.1
date	99.02.21.04.01.59;	author BlackPhantom;	state Exp;
branches;
next	;


desc
@Basic V86 emulation
@


0.53
log
@Last developed version
@
text
@;=============================================================================
;
;	This source code file is copyright (c) Vadim Drubetsky AKA the 
; Black Phantom. All rights reserved.
;
;	This source code file is a part of the Tripple-DOS project. Your use 
; of this source code must fully comply with the accompanying license file, 
; LICENSE.TXT. You must have this file enclosed with your Tripple-DOS copy in
; order for it to be legal.
;
;	In no event, except for when it is explicitly stated by the applicable 
; law, shall Vadim Drubetsky aka the Black Phantom be liable for any special,
; incidental, indirect, or consequential damages (including but not limited to
; profit loss, business interruption, loss of business information, or any 
; other pecuniary loss) arising out of the use of or inability to use 
; Tripple-DOS, even if he has been advised of the possibility of such damages.
;
;=============================================================================

;=============================================================================
;
;				TASKMAN.INC
;				-----------
;
;	Include file for task manager (definitions etc.)
;
;=============================================================================

IFNDEF	TASKMAN_INC
 TASKMAN_INC	EQU	1

	INCLUDE		CORE.INC

;
; STRUCTURES.
;
DpmiState	STRUC
	Sregs		SREG_PACK <>	; DPMI alternate mode segment regs.
 	dwEip		DD	?	; DPMI alternate mode EIP.
	dwEsp		DD	?	; DPMI alternate mode ESP.
DpmiState	ENDS


DosTask		STRUC
	TaskPdb		DD	?	; CR3 value to be loaded for task.
	TaskPdbLin	DD	?	; Task's PDB's linear address.
	TaskPageCtl	DD	?	; Linear address of page ctl. array.
	TaskMapping	DD	?	; Linear alias for pages in 1st Mb.
	TaskRegs	REG_PACK <>	; Task's registers state.
	TaskSregs	SREG_PACK <>	; Task's segment registers state.
	TaskVirtualIf	DD	?	; Virtual IF to be saved.
	TaskVirtualIp	DD	?	; Virtual pending ints. to be saved.
	TaskVirtualIsr	DD	?	; Virtual in-service interrupt reg.
	TaskVirtualImr	DD	?	; Virtual interrupt mask reg.
IFDEF	BORROWED_TICKS
	BorrowedTicks	DD	?	; Ticks that a task 'borrows'.
ENDIF
	TaskVideoState	DD	?	; Keeps video state (h/w and color).

	TaskTickCount	DD	?	; Counts task ticks (virtual timer).
	TaskTicksReport	DD	?	; PIT 0 counter.
	TaskPITCh0Sel	DB	?	; Select virtual timer channel 0.

	TaskState	DB	?	; Keeps task state.
	TaskBlock	DB	?	; Task block reason.
	TaskCurrDrive	DB	?	; Keeps current drive per task.
	TaskErrCode	DB	?	; Keeps last error code.
	TaskOpenFiles	DD	?	; Keeps count of open files.
	TaskOFTable	DD	?	; Table of files opened by task.
	Int21TrapOp	DD	?	; 8 bytes keep INT 21h return
			DD	?	; opcode.
	DosFunc		DW	?	; DOS function number is saved.
	TaskPmPsp	DW	?	; Task's protected mode PSP.
	TaskCurrentId	DW	?	; For emulation of DOS PID functions.

	TaskLdt		DW	?	; LDT is allocated when task switches
					; to PM via DPMI.
	TaskLdtBase	DD	?	; LDT base.
	TaskLdtLimit	DW	?	; Actual limit of Task LDT.
	TaskFlags	DD	?	; Task execution flags.

	DpmiDOSBlocks	DD	?	; Array of selectors allocated for DOS blocks.
	DpmiPmInts	DD	?	; Protmode ints callback vectors.
	DpmiPmExcs	DD	?	; Protmode exceptions callback vectors.
	DpmiCallbackArr	DD	?	; Array of DPMI callback addresses allocated.
	DpmiRmSs	DW	?	; Selector for real mode SS for translation services.
	DpmiMemDescrArr	DD	?	; Array of DPMI memory descriptors.

	DpmiRmEsp	DD	?	; Locked RM ESP for real mode callbacks.
	DpmiRmStack	DD	?	; Locked RM stack linear address.
	DpmiPmEsp	DD	?	; Locked PM ESP for protected mode callbacks.
	DpmiPmStack	DD	?	; Locked PM stack linear address.

	DpmiServicePage	DD	?	; linear address of a 4K memory for DPMI needs.
	XmsHmaFlag	DB	?	; if 0, HMA is available.

	DpmiPmStateSave	DD	?	; Save state in PM when doing mode switches.
	DpmiPmStatePtr	DD	?	; Pointer to state saved in PM
	DpmiRmStateSave	DD	?	; Save state in RM when doing mode switches.
	DpmiRmStatePtr	DD	?	; Pointer to state saved in RM
	DpmiRmCallPtr	DD	?	; Pointer to user supplied real mode call structure.

DosTask		ENDS


DpmiStateSave	STRUC
	bFlag	DB	?	; 0 if only DpmiState structure is saved,
				; 1 if general regs also
	sState	DpmiState	<>
	sRegs	GEN_REG_PACK	<>
DpmiStateSave	ENDS



	MAX_FNAME_LEN	EQU	67	; Maximum path name length in DOS.
	CDS_ENTRY_SIZE	EQU	58h	; CDS array element size.

OpenFileRecord	STRUC
	Handle		DW	?
	Owner		DD	?
	FileName	DB	MAX_FNAME_LEN DUP (?)
OpenFileRecord	ENDS

; Maximum number of tasks (consider increasing?)
;	MAX_TASKS	EQU	1000h / SIZEOF DosTask
	MAX_TASKS	EQU	100	; Maximum of 100 tasks.

; Task's states.
	TASK_RUNNING	EQU	1	; Task is currently running.
	TASK_READY	EQU	2	; Task is ready to run.
	TASK_BLOCKED	EQU	4	; Task is blocked (waits for semaphore)
	TASK_WAITING	EQU	8	; Task waits for event.
	TASK_RESUMED	EQU	10h	; Task has received an awaited event.
	TASK_LOCKED	EQU	20h	; Task is locked (cannot be preempted).

; Task's block reasons.
	HDD_SEMA4	EQU	1	; HDD is busy.
	FDD_SEMA4	EQU	2	; FDD is busy.

; Task's awaited events.
	KBD_INPUT	EQU	4	; Waiting for keyboard input.
	INT28_WAIT	EQU	8	; Waiting for DOS busy to begone.
	DMA_REQUEST	EQU	10h	; Waiting for DMA mem write to complete.
	SOME_SEMA4	EQU	20h	; Waiting on some semaphore.

; Task execution flags.
	TASK_32BIT	EQU	1	; 1 = 32 bit task, 0 = 16 bit.

	TASK_RM_STATE_NEED_SAVE	EQU	2	; 1 = real mode state save needed.
	TASK_RM_REGS_NEED_SAVE	EQU	4	; 1 = real mode general regs save needed.
	TASK_PM_STATE_NEED_SAVE	EQU	8	; 1 = protected mode state save needed.
	TASK_PM_REGS_NEED_SAVE	EQU	10h	; 1 = protected mode general regs save needed.

	TASK_RM_STATE_SAVED	EQU	20h	; 1 = real mode state saved.
	TASK_RM_REGS_SAVED	EQU	40h	; 1 = real mode general regs saved.
	TASK_PM_STATE_SAVED	EQU	80h	; 1 = protected mode state saved.
	TASK_PM_REGS_SAVED	EQU	100h	; 1 = protected mode general regs saved.

; DPMI memory size.
	DPMI_MEM_SIZE		EQU	3000h		; In bytes
	DPMI_MEM_PAGES		EQU	3		; In pages

; Needed memory amount to create a new task.

; 0A0000h bytes of base memory.
	TASK_MEMORY_SIZE	=	0A0000h	
; 40000h for additional VGA memory.
	TASK_MEMORY_SIZE	=	TASK_MEMORY_SIZE + 40000h
; 1 page for open files structure
	TASK_MEMORY_SIZE	=	TASK_MEMORY_SIZE + 1000h
; 1 page for page directory
	TASK_MEMORY_SIZE	=	TASK_MEMORY_SIZE + 1000h
; 1 page for pages ctl. array
	TASK_MEMORY_SIZE	=	TASK_MEMORY_SIZE + 1000h
; 1 page for 1st MB page table
	TASK_MEMORY_SIZE	=	TASK_MEMORY_SIZE + 1000h
; 1 page for 1st MB alias mapping
	TASK_MEMORY_SIZE	=	TASK_MEMORY_SIZE + 1000h
; 1 page for VGA regs save/restore.
	TASK_MEMORY_SIZE	=	TASK_MEMORY_SIZE + 1000h
; If providing HIMEM, 64K for HMA.
IFDEF	PROVIDE_HIMEM
	TASK_MEMORY_SIZE	=	TASK_MEMORY_SIZE + 10000h
ENDIF

; And memory for DPMI server needs.
	TASK_MEMORY_SIZE	=	TASK_MEMORY_SIZE + DPMI_MEM_SIZE


TASK_PTR	MACRO	Task, Dest
 IFNB	<Task>
 	mov	eax, SIZEOF DosTask
	mul	Task
 ELSE
 	mov	edx, SIZEOF DosTask
	mul	edx
 ENDIF
	add	eax, FirstTask
 IFNB	<Dest>
 	mov	Dest, eax
 ENDIF
ENDM


Sema4		STRUCT
	ResourceId	DD	?	; Resource that the semaphore guides.
	Owner		DD	?	; Task that owns a semaphore.
	SleepN		DD	?	; Number of tasks that sleep on semaphore.
	TasksSleep	DD	MAX_TASKS DUP (?)	; Array of tasks.
	State		DB	?	; Semaphore's state
Sema4		ENDS

ENDIF	; TASKMAN_INC
@


0.52
log
@Stack segment for Tripple-DOS changed to 32-bit default. 16-bit stack didn't work with DPMI clients that set up stack to 32 bits and ESP > 64K! Now DJGPP stubbed programs work, but there is some problem when they return.
@
text
@d12 1
a12 1
; law, shall Vadim Drubetsky aka the Black Phantoms be liable for any special,
@


0.51
log
@Added general devices synchronization mechanism.
It's implemented for COM1 and COM2.
It causes problems with a keyboard.
@
text
@@


0.50
log
@Fixed HDD/FDD synchronization problem (trapped opcodes were overwriting each other).
@
text
@d29 3
d144 1
d213 1
a213 2


@


0.49
log
@Fixes version (log for INIT.ASM)
@
text
@@


0.48
log
@Enabled XMS 3.0 interface
@
text
@@


0.47
log
@DMA partial virtualization is made - Tripple DOS now works with floppy!
@
text
@d134 2
a135 1
	INT13_SEMA4	EQU	1	; INT 13h (disks) is busy.
d138 3
a140 3
	KBD_INPUT	EQU	2	; Waiting for keyboard input.
	INT28_WAIT	EQU	4	; Waiting for DOS busy to begone.
	DMA_REQUEST	EQU	8	; Waiting for DMA mem write to complete.
d199 12
@


0.46
log
@Fixed a bug that didn't allow Tripple DOS work with DOS loaded HIGH
@
text
@d139 1
@


0.45
log
@The shareware beta release
@
text
@@


0.44
log
@Bug fixes:
1) Checks for open file name (EDX to DX) problem
2) Reporting of the protected mode exception reboot
@
text
@d3 19
d50 2
@


0.43
log
@Bug fixes:
1) Lower word in translation structure on real mode stack was being destroyed - very annoying.
2) Saved exception number was moved to task structure to allow multiple DPMI tasks work.
3 copies of WCC386 worked!
@
text
@d35 5
d49 2
d71 1
a71 2
	DpmiTempExcNum	DD	?	; Exception number is saved across
					; DPMI mode switches.
d73 5
a77 1
	XmsHmaFlag	DB	?	; if 0, HMA is available.
d81 10
d121 10
a130 1
	TASK_RAW_PMODE	EQU	2	; 1 = protected, 0 = V86 mode.
d133 2
a134 2
	DPMI_MEM_SIZE		EQU	9000h		; In bytes
	DPMI_MEM_PAGES		EQU	9		; In pages
@


0.42
log
@1) Added XMS server
2) Memory allocation / deallocation is moved to task creation / deletion
@
text
@d43 1
a43 1
	DosFunc		DW	?
d64 2
@


0.41
log
@Bug fixes:
1) Virtual I/O jump table (very annoying!)
2) IsFileOpen() bug if file name is 0.
@
text
@a25 1
	TaskTss		DD	?	; Linear address of task's TSS.
d64 3
d101 29
@


0.40
log
@DPMI server fixes:
1) Locker real mode and protected mode stacks usage fixed: reentrancy allowed.
2) Modes switches fixed.
@
text
@@


0.39
log
@Bug fixed: raw mode switches.
@
text
@a51 2
	DpmiAltState	DpmiState <>	; DPMI alternate state.
	DpmiAltRegs	REG_PACK <>	; DPMI alternate state general purpose regs.
d59 6
@


0.38
log
@Bugs fixed:
1) PointerToLinear() check
2) Default interrupt redirection to V86 mode
@
text
@@


0.37
log
@Bug fixed: reflecting PM to VM interrupt.
@
text
@@


0.36
log
@Bug fixes:
1) CreatePageTable() called from HeapAllocMem()
2) Zero allocated PDB for new task
@
text
@@


0.35
log
@HeapAllocMem() bug fixed; free DPMI memory allocated fixed.
@
text
@@


0.34
log
@Bug fixes:
1) Initial pages map allocation
2) Translation services params
3) DPMI clean up memory release -- almost
4) INT 21h AH=4Ch in protected mode.
@
text
@@


0.33
log
@Initial full release - all DPMI functions are written! Half are not tet.
@
text
@@


0.32
log
@Translation services work.
@
text
@d57 3
@


0.31
log
@1) Interrupt redirection works
2) HeapAllocMem() bug fixes
DPMI traps fixed
@
text
@d48 1
d53 1
@


0.30
log
@DOS block functions are written and work. Callback to real mode mechanism established. Tests are still brief.
@
text
@d15 7
a49 3
	TaskAltSregs	SREG_PACK <>	; DPMI alternate mode segment regs.
	TaskAltEip	DD	?	; DPMI alternate mode EIP.
	TaskAltEsp	DD	?	; DPMI alternate mode ESP.
d51 1
a52 1
	DpmiRmInts	DD	?	; Real mode ints callback vectors.
@


0.29
log
@First DPMI selector functions work (Hello, world).
@
text
@d38 1
d43 9
@


0.28
log
@Initial DPMI switch works.
@
text
@d40 2
d71 5
@


0.27
log
@Solves INT 28 block problems (doesn't lock).
@
text
@d38 2
@


0.26
log
@Bugs fixed:
1) Store open file name
2) Store DOS function per process
3) Imperfect INT 13 semaphore handling.
@
text
@@


0.25
log
@Fixed bug in IsFileOpen proc.
@
text
@d35 3
d50 2
a51 1
	MAX_TASKS	EQU	1000h / SIZEOF DosTask
@


0.24
log
@Removed unnecessary dynamic allocations.
@
text
@a30 1
	TaskWait	DB	?	; Keeps events that task waits for.
d61 2
a62 2
	KBD_INPUT	EQU	1	; Waiting for keyboard input.
	INT28_WAIT	EQU	2	; Waiting for DOS busy to begone.
@


0.23
log
@1) File sharing handled.
@
text
@d43 1
@


0.22
log
@1) Fully split task blocking and waiting for event.
2) Annoying bug fixed (TASK_PTR).
@
text
@d38 2
d42 2
a43 2
	Handle	DW	?
	FileName	DB	62 DUP (?)
a44 1

@


0.21
log
@1) Inproved task state handling (nesting allowed due to bit mask).
2) TASK_PTR macro used.
3) Bugs fixed.
4) X86.MCR is out of project.
@
text
@d31 1
d51 4
a54 3
	TASK_BLOCKED	EQU	4	; Task is blocked (waits for event/semaphore)
	TASK_UNBLOCKED	EQU	8	; Task was recently released from block
	TASK_LOCKED	EQU	10h	; Task is locked (cannot be preempted).
d58 4
a61 2
	KBD_INPUT	EQU	2	; Waiting for keyboard input.
	INT28_WAIT	EQU	4	; Waiting for DOS busy to begone.
@


0.20
log
@Task locks on wait for events are added.
@
text
@d25 1
d27 1
d31 4
d38 4
a41 4
DosTaskEntry	STRUC
	Task	DosTask	<>	; Task structure
	Next	DD	?	; Ptr to next struc.
DosTaskEntry	ENDS
d48 5
a52 4
	TASK_RUNNING	EQU	1
	TASK_READY	EQU	2
	TASK_BLOCKED	EQU	3
	TASK_UNBLOCKED	EQU	4
d55 18
a72 3
	INT13_SEMA4	EQU	1
	KBD_INPUT	EQU	2
	INT28_WAIT	EQU	3
@


0.19
log
@Trap wait on keyboard (INT 16h / 0, 10h).
Bug fixes in memory allocation.
@
text
@d50 1
@


0.18
log
@Keyboard virtualized.
File I/O interface for kernel is added.
@
text
@d45 1
d49 1
@


0.17
log
@Int 13h locking improvements, bug fixes (NC running)
@
text
@@


0.16
log
@Debug improvements (commands); VGA ports partial virtualizing
@
text
@d27 2
d40 8
@


0.15
log
@Debug improvements: hardware breakpoint
@
text
@@


0.14
log
@Bug fixes; debug improvements
@
text
@@


0.13
log
@Proper CPL 0 stack management; foreground task boost on event
@
text
@@


0.12
log
@Bug fixes: 5th task, VGA co40/co80 restore
@
text
@@


0.11
log
@Memory allocation enhance; bug fixes
@
text
@@


0.10
log
@VGA save/restore state fixed; bug fixes
@
text
@@


0.9
log
@VGA state save/resore
@
text
@a37 8

; Opcodes that generate #GP in VM when IOPL < 3.
	OP_INT		EQU	0CDh
	OP_IRET		EQU	0CFh
	OP_CLI		EQU	0FAh
	OP_STI		EQU	0FBh
	OP_PUSHF	EQU	9Ch
	OP_POPF		EQU	9Dh
@


0.8
log
@Synchronization of system services; bug fixes
@
text
@@


0.7
log
@Working preemptive multitasking. Interrupts are reported to ALL tasks. Different tasks cannot work with the same device.
@
text
@d25 2
@


0.7.0.1
log
@Attempt to synchronize disks with semaphores
@
text
@a24 1
	BorrowedTicks	DD	?	; Ticks that a task 'borrows'.
a33 8
IntSema4	STRUC
	Busy	DB	?
	IntNo	DB	?
	IrqNo	DB	?
	TaskNo	DD	?
IntSema4	ENDS


a35 3

; Maximum number of slices to keep INT 13 semaphore for the same task.
	INT13_SEMA4_SLICES	EQU	50
@


0.6
log
@Working non-preemptive multitasking
@
text
@d23 2
@


0.5
log
@Working V86 emulation version!
@
text
@d10 2
d21 2
@


0.4
log
@Basic V86 emulation
@
text
@@
