(* ---------------------------------------------------------------
Title         Q&D DCLOCK
Author        who cares ?
Overview      see help
Usage         see help
Notes         YACWOT started as enhanced revision of my so old DCLOCK.BAS
              could have been more elegant
Bugs          check full trails display refresh when crossing limits
Wish List     change Xpos after a few rounds as to avoid pixel burning ?

              darn, where's the fun gone now ? :-( with such a state of mind,
              we won't rewrite pretty XCLOCK.BAS before aeons... :-(
              (English meaning of aeon here of course, not the real one)

--------------------------------------------------------------- *)

MODULE dClock;

IMPORT Str;
IMPORT Lib;
IMPORT FIO;
IMPORT SYSTEM;
IMPORT MsMouse;
IMPORT BiosIO;
IMPORT MATHLIB;

FROM IO IMPORT WrStr,WrLn, WrCard;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_VESA IMPORT vesa640x480x8, vesa800x600x8,
vesa640x480x32, vesa800x600x32, vesa1024x768x8, vesa1280x1024x8,
vesa1024x768x32, vesa1280x1024x32, vesa1600x1200x8,
paltriplettype, minpalndx, maxpalndx,
isMonoMode, waitVGAretrace, setDAC,
resetDAC, getDAC, savesystempal, restoresystempal,
SetVesaMode, initVESAlookup, getVESAmodeInfos,
setVESAbank, VESAgetpixel8, VESAgetpixel32, VESAputpixel8,
VESAputpixel32, initVESAhline, updateVESAhline, VESAputpixel8hline,
VESAputpixel32hline, initVESAmode, getVESAgeometry, chkVESAhere,
isModeHere, set80x25, set80x50, getTextmodeDimensions,
getModeFromList;

FROM ModeX IMPORT
Mode_320x200,Mode_320x400,Mode_360x200,Mode_360x400,
Mode_320x240,Mode_320x480,Mode_360x240,Mode_360x480,
SET_VGA_MODEX, SET_MODEX, CLEAR_VGA_SCREEN, SET_POINT, READ_POINT,
FILL_BLOCK, DRAW_LINE, SET_DAC_REGISTER, GET_DAC_REGISTER,
LOAD_DAC_REGISTERS, READ_DAC_REGISTERS,
SET_ACTIVE_PAGE, GET_ACTIVE_PAGE, SET_DISPLAY_PAGE, GET_DISPLAY_PAGE,
SET_WINDOW, GET_X_OFFSET, GET_Y_OFFSET, SYNC_DISPLAY,
GPRINTC, TGPRINTC, PRINT_STR, TPRINT_STR,
SET_DISPLAY_FONT, DRAW_BITMAP, TDRAW_BITMAP, COPY_PAGE, COPY_BITMAP,
mxTrue, mxFalse, mxnil,
c_BLACK, c_BLUE, c_GREEN, c_CYAN, c_RED, c_PURPLE, c_BROWN, c_WHITE,
c_GREY, c_bBLUE, c_bGREEN, c_bCYAN, c_bRED, c_bPURPLE, c_YELLOW, c_bWHITE,
c_BRIGHT,
DOS_PRINT, DOS_PRINTS, SET_VIDEO_MODE,
SCAN_KEYBOARD, RANDOM_INT, INIT_RANDOM, INT_SQR, TIMER_COUNT;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    SPECIAL  = FALSE;

CONST
    cr       = CHR(13);
    lf       = CHR(10);
    nl       = cr+lf;
    nullchar = 0C;
    dquote   = '"';
    ctrlZ    = CHR(26);
    extEXE   = ".EXE";
    extDAT   = ".DAT";
CONST
    progEXEname   = "DCLOCK";
    progTitle     = "Q&D dClock";
    progVersion   = "v1.1f";
    progCopyright = "by PhG";
    Banner        = progTitle+" "+progVersion+" "+progCopyright;
    credit        = "(public domain Mode X v1.04 library by Matt Pritchard)";
CONST
    errNone                = 0;
    errHelp                = 1;
    errOption              = 2;
    errParameter           = 3;
    errBadVal              = 4;
    errBadVideoMode        = 5;
    errIniSize             = 6;
    errIniLine             = 7;
    errBadModeSS           = 8;
    errBadModeHHMM         = 9;
    errBadInfoMode         = 10;
    errBadPaper            = 11;
    errBadTimeFmt          = 12;
    errBadDateFmt          = 13;
    errBadModeHHMMSS       = 14;
    errBadPalette          = 15;
    errBadCirclesMode      = 16;
CONST
    errNoVesaBios          = 32;
    errVesaModeNotAvailable= 33;
    errVesaAbout           = 34;
    errCannotSetVesaMode   = 35;
    errVesaBank            = 36;
    errVesaGranularity     = 37;
    errCannotSetModeX      = 38;
    errImpossibleHiresPb   = 39;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);

    MODULE message;
    IMPORT Str;
    EXPORT msg3;

    PROCEDURE msg3 (VAR R:ARRAY OF CHAR;S1,S2,S3:ARRAY OF CHAR);
    BEGIN
        Str.Concat(R,S1,S2);Str.Append(R,S3);
    END msg3;

    END message;

CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msghelp=
Banner+nl+
nl+
credit+nl+
nl+
"Syntax : "+progEXEname+" [option]..."+nl+
nl+
"  -v:#     video mode (0=320x240, 1=VESA 640x480, 2=VESA 800x600, default is 0)"+nl+
"  -m       terminate program on mouseclick too (if mouse present)"+nl+
"  -x       force use of default sprites, ignoring "+progEXEname+extDAT+" if any"+nl+
"  -i:#     infos mode (0=none, 1=time, 2=date, 3=time and date)"+nl+
"  -t:#     time format (0=##:##:##, 1=##h ##mn ##s)"+nl+
"  -d:#     date format (0=longFR, 1=shortFR, 2=longUS, 3=shortUS, 4=#FR, 5=#US)"+nl+
"  -r       reverse display (HMS from outer to inner instead of standard SMH)"+nl+
"  -p:#     palette ([0..4])"+nl+
"  -p       disable palette rotation at one minute interval"+nl+
"  -c       use alternate marks for seconds"+nl+
"  -a       audio tick"+nl+
"  -t       show hour transition according to minutes (ignored with -m:2)"+nl+
"  -e       show each second mark"+nl+
"  -c:#     mode for circles (0=all but outer and inner, 1=all, 2=none)"+nl+
"  -z       do not show marks for seconds"+nl+
"  -s:#     mode for seconds (0=single dot, 1=dots, 2=trail)"+nl+
"  -m:#     mode for hours and minutes (0=single dot, 1=dots, 2=trail)"+nl+
"  -a:#     mode for hours, minutes and seconds (0=single dot, 1=dots, 2=trail)"+nl+
"  -k:#     background paper color ([0..15], default is 0)"+nl+
"  -f       no page flipping (mode X only)"+nl+
"  -w       do not wait for video retrace"+nl+
"  -dots    shortcut for -s:1 -m:1"+nl+
"  -trails  shortcut for -s:2 -m:2"+nl+
"  -trailz  shortcut for -s:2 -m:2 with added trails"+nl+
"           (day in month, month in year, day in year)"+nl+
"  -y[y[y]] shortcut for -dots, -trails, -trailz"+nl+
"  -$[$]    shortcut for -yy[y] -i:3 -c:2 -e -p:2 -v:1"+nl+
"  -!       create default "+progEXEname+extDAT+" in current directory then terminate"+nl+
nl+
progEXEname+extDAT+" may contain replacement sprites :"+nl+
"it is searched for in current directory first, then in executable directory."+nl+
"While program is running, TAB key changes to next palette."+nl;

VAR
    S : str128;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msghelp);
    | errOption :     msg3(S, "Illegal ",einfo," option !");
    | errParameter :  msg3(S, "Useless ",einfo," parameter !");
    | errBadVal:      msg3(S, "Illegal ",einfo," value !");
    | errBadVideoMode:msg3(S, "Illegal ",einfo," video mode !");
    | errIniSize:     S:= progEXEname+extDAT+" is bigger than expected !";
    | errIniLine:     S:= progEXEname+extDAT+" is not in expected format !";
    | errBadModeSS   :msg3(S, "Illegal ",einfo," seconds mode !");
    | errBadModeHHMM :msg3(S, "Illegal ",einfo," hours and minutes mode !");
    | errBadInfoMode :msg3(S, "Illegal ",einfo," infos mode !");
    | errBadPaper    :msg3(S, "Illegal ",einfo," background paper color !");
    | errBadTimeFmt  :msg3(S, "Illegal ",einfo," time format !");
    | errBadDateFmt  :msg3(S, "Illegal ",einfo," date format !");
    | errBadModeHHMMSS :msg3(S, "Illegal ",einfo," hours, minutes and seconds mode !");
    | errBadPalette:  msg3(S, "Illegal ",einfo," palette !");
    | errBadCirclesMode:  msg3(S, "Illegal ",einfo," circles mode !");

    | errNoVesaBios         : S :="VESA functions are not available !";
    | errVesaModeNotAvailable: msg3(S,einfo," VESA video mode is not available !","");
    | errVesaAbout          : S :=" $104f01 VESA function failure !";
    | errCannotSetVesaMode  : msg3(S,"Cannot set requested ",einfo," VESA video mode !");
    | errVesaBank           : S := "$104f05 VESA function failure !";
    | errVesaGranularity    : S := "Unsupported granularityKB !";
    | errCannotSetModeX     : msg3(S,"Cannot set requested ",einfo," ModeX video mode !");
    | errImpossibleHiresPb  : S := "Unexpected HiresON() error code !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp : ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;

    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE dec2str (v,fix:CARDINAL;pad:CHAR):str16;
CONST
    mapdec = "0123456789";
VAR
    R:str16;
    i,len:CARDINAL;
BEGIN
    R:="";
    len:=0;
    LOOP
        i:=v MOD 10;
        Str.Prepend(R, mapdec[i]);
        INC(len);
        v:=v DIV 10;
        IF v=0 THEN EXIT; END;
    END;
    FOR i:=(len+1) TO fix DO
        Str.Prepend(R,pad);
    END;
    RETURN R;
END dec2str;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

CONST
    keyTAB     = 00900H;
    keyTABshift= 0000FH;
    upperP     = ORD("P") << 8 ;   lowerP     = ORD("p") << 8 ;
    upperO     = ORD("O") << 8 ;   lowerO     = ORD("o") << 8 ;
    upperI     = ORD("I") << 8 ;   lowerI     = ORD("i") << 8 ;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

PROCEDURE mouseclicked (abortonclick:BOOLEAN):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    IF abortonclick=FALSE THEN RETURN FALSE; END;
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclicked;

PROCEDURE getCard (S:ARRAY OF CHAR;VAR v:CARDINAL):BOOLEAN;
VAR
    n:LONGCARD;
BEGIN
    IF GetLongCard(S,n)=FALSE THEN RETURN FALSE; END;
    IF n > MAX(CARDINAL) THEN RETURN FALSE; END;
    v:= CARDINAL(n);
    RETURN TRUE;
END getCard;

PROCEDURE swap (VAR v1,v2:CARDINAL);
VAR
    tmp:CARDINAL;
BEGIN
    tmp := v2;
    v2  := v1;
    v1  := tmp;
END swap;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* taken from NEWFONT *)

CONST
    wichar = 8; (* native mode X and or our 8x8 font *)

CONST
    fontsize50       = 2048;
    firstdatasmall   = 0;
    lastdatasmall    = fontsize50-1;
    middatasmall     = fontsize50 DIV 2; (* modeX splits fonts in 2 128 chars *)
TYPE
    smallFontDef = ARRAY [firstdatasmall..lastdatasmall] OF BYTE;

CONST
    (* apple8.fon *)
    smallFontAPPLE = smallFontDef(
    000H,000H,000H,000H,000H,000H,000H,000H,
    0F7H,0EFH,093H,001H,003H,003H,001H,093H,
    0F7H,0EFH,093H,07DH,07BH,07BH,02DH,093H,
    06CH,0FEH,0FEH,0FEH,07CH,038H,010H,000H,
    010H,038H,07CH,0FEH,07CH,038H,010H,000H,
    038H,07CH,038H,0FEH,0FEH,07CH,038H,07CH,
    010H,010H,038H,07CH,0FEH,07CH,038H,07CH,
    000H,000H,018H,03CH,03CH,018H,000H,000H,
    0FFH,0FFH,0E7H,0C3H,0C3H,0E7H,0FFH,0FFH,
    000H,03CH,066H,042H,042H,066H,03CH,000H,
    0FFH,0C3H,099H,0BDH,0BDH,099H,0C3H,0FFH,
    00FH,007H,00FH,07DH,0CCH,0CCH,0CCH,078H,
    03CH,066H,066H,066H,03CH,018H,07EH,018H,
    03FH,033H,03FH,030H,030H,070H,0F0H,0E0H,
    07FH,063H,07FH,063H,063H,067H,0E6H,0C0H,
    099H,05AH,03CH,0E7H,0E7H,03CH,05AH,099H,
    080H,0E0H,0F8H,0FEH,0F8H,0E0H,080H,000H,
    002H,00EH,03EH,0FEH,03EH,00EH,002H,000H,
    018H,03CH,07EH,018H,018H,07EH,03CH,018H,
    066H,066H,066H,066H,066H,000H,066H,000H,
    07FH,0DBH,0DBH,07BH,01BH,01BH,01BH,000H,
    03EH,063H,038H,06CH,06CH,038H,0CCH,078H,
    000H,000H,000H,000H,07EH,07EH,07EH,000H,
    018H,03CH,07EH,018H,07EH,03CH,018H,0FFH,
    018H,03CH,07EH,018H,018H,018H,018H,000H,
    018H,018H,018H,018H,07EH,03CH,018H,000H,
    000H,018H,00CH,0FEH,00CH,018H,000H,000H,
    000H,030H,060H,0FEH,060H,030H,000H,000H,
    000H,000H,0C0H,0C0H,0C0H,0FEH,000H,000H,
    000H,024H,066H,0FFH,066H,024H,000H,000H,
    000H,018H,03CH,07EH,0FFH,0FFH,000H,000H,
    000H,0FFH,0FFH,07EH,03CH,018H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    010H,010H,010H,010H,010H,000H,010H,000H,
    028H,028H,028H,000H,000H,000H,000H,000H,
    028H,028H,07CH,028H,07CH,028H,028H,000H,
    010H,03CH,050H,038H,014H,078H,010H,000H,
    060H,064H,008H,010H,020H,04CH,00CH,000H,
    020H,050H,050H,020H,054H,048H,034H,000H,
    010H,010H,010H,000H,000H,000H,000H,000H,
    010H,020H,040H,040H,040H,020H,010H,000H,
    010H,008H,004H,004H,004H,008H,010H,000H,
    010H,054H,038H,010H,038H,054H,010H,000H,
    000H,010H,010H,07CH,010H,010H,000H,000H,
    000H,000H,000H,000H,010H,010H,020H,000H,
    000H,000H,000H,07CH,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,010H,000H,
    000H,004H,008H,010H,020H,040H,000H,000H,
    038H,044H,04CH,054H,064H,044H,038H,000H,
    010H,030H,010H,010H,010H,010H,038H,000H,
    038H,044H,004H,018H,020H,040H,07CH,000H,
    07CH,004H,008H,018H,004H,044H,038H,000H,
    008H,018H,028H,048H,07CH,008H,008H,000H,
    07CH,040H,078H,004H,004H,044H,038H,000H,
    01CH,020H,040H,078H,044H,044H,038H,000H,
    07CH,004H,008H,010H,020H,020H,020H,000H,
    038H,044H,044H,038H,044H,044H,038H,000H,
    038H,044H,044H,03CH,004H,008H,070H,000H,
    000H,000H,010H,000H,010H,000H,000H,000H,
    000H,000H,010H,000H,010H,010H,020H,000H,
    008H,010H,020H,040H,020H,010H,008H,000H,
    000H,000H,07CH,000H,07CH,000H,000H,000H,
    020H,010H,008H,004H,008H,010H,020H,000H,
    038H,044H,008H,010H,010H,000H,010H,000H,
    038H,044H,054H,05CH,058H,040H,03CH,000H,
    010H,028H,044H,044H,07CH,044H,044H,000H,
    078H,044H,044H,078H,044H,044H,078H,000H,
    038H,044H,040H,040H,040H,044H,038H,000H,
    078H,044H,044H,044H,044H,044H,078H,000H,
    07CH,040H,040H,078H,040H,040H,07CH,000H,
    07CH,040H,040H,078H,040H,040H,040H,000H,
    03CH,040H,040H,040H,04CH,044H,03CH,000H,
    044H,044H,044H,07CH,044H,044H,044H,000H,
    038H,010H,010H,010H,010H,010H,038H,000H,
    004H,004H,004H,004H,004H,044H,038H,000H,
    044H,048H,050H,060H,050H,048H,044H,000H,
    040H,040H,040H,040H,040H,040H,07CH,000H,
    044H,06CH,054H,054H,044H,044H,044H,000H,
    044H,044H,064H,054H,04CH,044H,044H,000H,
    038H,044H,044H,044H,044H,044H,038H,000H,
    078H,044H,044H,078H,040H,040H,040H,000H,
    038H,044H,044H,044H,054H,048H,034H,000H,
    078H,044H,044H,078H,050H,048H,044H,000H,
    038H,044H,040H,038H,004H,044H,038H,000H,
    07CH,010H,010H,010H,010H,010H,010H,000H,
    044H,044H,044H,044H,044H,044H,038H,000H,
    044H,044H,044H,044H,044H,028H,010H,000H,
    044H,044H,044H,054H,054H,06CH,044H,000H,
    044H,044H,028H,010H,028H,044H,044H,000H,
    044H,044H,028H,010H,010H,010H,010H,000H,
    07CH,004H,008H,010H,020H,040H,07CH,000H,
    07CH,060H,060H,060H,060H,060H,07CH,000H,
    000H,040H,020H,010H,008H,004H,000H,000H,
    07CH,00CH,00CH,00CH,00CH,00CH,07CH,000H,
    000H,000H,010H,028H,044H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,07CH,
    020H,010H,008H,000H,000H,000H,000H,000H,
    000H,000H,038H,004H,03CH,044H,03CH,000H,
    040H,040H,078H,044H,044H,044H,078H,000H,
    000H,000H,03CH,040H,040H,040H,03CH,000H,
    004H,004H,03CH,044H,044H,044H,03CH,000H,
    000H,000H,038H,044H,07CH,040H,03CH,000H,
    018H,024H,020H,078H,020H,020H,020H,000H,
    000H,000H,038H,044H,044H,03CH,004H,038H,
    040H,040H,078H,044H,044H,044H,044H,000H,
    010H,000H,030H,010H,010H,010H,038H,000H,
    008H,000H,018H,008H,008H,008H,048H,030H,
    040H,040H,044H,048H,070H,048H,044H,000H,
    030H,010H,010H,010H,010H,010H,038H,000H,
    000H,000H,06CH,054H,054H,054H,044H,000H,
    000H,000H,078H,044H,044H,044H,044H,000H,
    000H,000H,038H,044H,044H,044H,038H,000H,
    000H,000H,078H,044H,044H,078H,040H,040H,
    000H,000H,03CH,044H,044H,03CH,004H,004H,
    000H,000H,05CH,060H,040H,040H,040H,000H,
    000H,000H,03CH,040H,038H,004H,078H,000H,
    020H,020H,078H,020H,020H,024H,018H,000H,
    000H,000H,044H,044H,044H,04CH,034H,000H,
    000H,000H,044H,044H,044H,028H,010H,000H,
    000H,000H,044H,044H,054H,054H,06CH,000H,
    000H,000H,044H,028H,010H,028H,044H,000H,
    000H,000H,044H,044H,044H,03CH,004H,038H,
    000H,000H,07CH,008H,010H,020H,07CH,000H,
    01CH,030H,030H,060H,030H,030H,01CH,000H,
    010H,010H,010H,010H,010H,010H,010H,010H,
    070H,018H,018H,00CH,018H,018H,070H,000H,
    034H,058H,000H,000H,000H,000H,000H,000H,
    000H,054H,028H,054H,028H,054H,000H,000H,
    038H,044H,040H,040H,040H,044H,038H,010H,
    044H,000H,044H,044H,044H,04CH,034H,000H,
    00CH,000H,038H,044H,07CH,040H,03CH,000H,
    07CH,000H,038H,004H,03CH,044H,03CH,000H,
    044H,000H,038H,004H,03CH,044H,03CH,000H,
    060H,000H,038H,004H,03CH,044H,03CH,000H,
    010H,000H,038H,004H,03CH,044H,03CH,000H,
    000H,000H,03CH,040H,040H,040H,03CH,008H,
    07CH,000H,038H,044H,07CH,040H,03CH,000H,
    044H,000H,038H,044H,07CH,040H,03CH,000H,
    060H,000H,038H,044H,07CH,040H,03CH,000H,
    044H,000H,030H,010H,010H,010H,038H,000H,
    07CH,000H,030H,010H,010H,010H,038H,000H,
    060H,000H,030H,010H,010H,010H,038H,000H,
    044H,000H,010H,028H,044H,07CH,044H,000H,
    010H,000H,010H,028H,044H,07CH,044H,000H,
    008H,010H,07CH,040H,078H,040H,07CH,000H,
    000H,000H,06CH,012H,07EH,090H,07EH,000H,
    02EH,058H,088H,08EH,0F8H,088H,08EH,000H,
    07CH,000H,038H,044H,044H,044H,038H,000H,
    044H,000H,038H,044H,044H,044H,038H,000H,
    060H,000H,038H,044H,044H,044H,038H,000H,
    07CH,000H,044H,044H,044H,04CH,034H,000H,
    060H,000H,044H,044H,044H,04CH,034H,000H,
    044H,000H,044H,044H,044H,03CH,004H,038H,
    044H,038H,044H,044H,044H,044H,038H,000H,
    044H,000H,044H,044H,044H,044H,038H,000H,
    018H,018H,07EH,0C0H,0C0H,07EH,018H,018H,
    038H,06CH,064H,0F0H,060H,0E6H,0FCH,000H,
    0CCH,0CCH,078H,0FCH,030H,0FCH,030H,030H,
    0F8H,0CCH,0CCH,0FAH,0C6H,0CFH,0C6H,0C7H,
    00EH,01BH,018H,03CH,018H,018H,0D8H,070H,
    00CH,000H,038H,004H,03CH,044H,03CH,000H,
    00CH,000H,030H,010H,010H,010H,038H,000H,
    00CH,000H,038H,044H,044H,044H,038H,000H,
    00CH,000H,044H,044H,044H,04CH,034H,000H,
    07CH,000H,078H,044H,044H,044H,044H,000H,
    07CH,000H,044H,064H,054H,04CH,044H,000H,
    03CH,06CH,06CH,03EH,000H,07EH,000H,000H,
    038H,06CH,06CH,038H,000H,07CH,000H,000H,
    030H,000H,030H,060H,0C0H,0CCH,078H,000H,
    000H,000H,000H,0FCH,0C0H,0C0H,000H,000H,
    000H,000H,000H,0FCH,00CH,00CH,000H,000H,
    0C3H,0C6H,0CCH,0DEH,033H,066H,0CCH,00FH,
    0C3H,0C6H,0CCH,0DBH,037H,06FH,0CFH,003H,
    010H,010H,000H,010H,010H,010H,010H,000H,
    000H,022H,044H,088H,044H,022H,000H,000H,
    000H,088H,044H,022H,044H,088H,000H,000H,
    022H,088H,022H,088H,022H,088H,022H,088H,
    055H,0AAH,055H,0AAH,055H,0AAH,055H,0AAH,
    0DBH,077H,0DBH,0EEH,0DBH,077H,0DBH,0EEH,
    018H,018H,018H,018H,018H,018H,018H,018H,
    018H,018H,018H,018H,0F8H,018H,018H,018H,
    018H,018H,0F8H,018H,0F8H,018H,018H,018H,
    036H,036H,036H,036H,0F6H,036H,036H,036H,
    000H,000H,000H,000H,0FEH,036H,036H,036H,
    000H,000H,0F8H,018H,0F8H,018H,018H,018H,
    036H,036H,0F6H,006H,0F6H,036H,036H,036H,
    036H,036H,036H,036H,036H,036H,036H,036H,
    000H,000H,0FEH,006H,0F6H,036H,036H,036H,
    036H,036H,0F6H,006H,0FEH,000H,000H,000H,
    036H,036H,036H,036H,0FEH,000H,000H,000H,
    018H,018H,0F8H,018H,0F8H,000H,000H,000H,
    000H,000H,000H,000H,0F8H,018H,018H,018H,
    018H,018H,018H,018H,01FH,000H,000H,000H,
    018H,018H,018H,018H,0FFH,000H,000H,000H,
    000H,000H,000H,000H,0FFH,018H,018H,018H,
    018H,018H,018H,018H,01FH,018H,018H,018H,
    000H,000H,000H,000H,0FFH,000H,000H,000H,
    018H,018H,018H,018H,0FFH,018H,018H,018H,
    018H,018H,01FH,018H,01FH,018H,018H,018H,
    036H,036H,036H,036H,037H,036H,036H,036H,
    036H,036H,037H,030H,03FH,000H,000H,000H,
    000H,000H,03FH,030H,037H,036H,036H,036H,
    036H,036H,0F7H,000H,0FFH,000H,000H,000H,
    000H,000H,0FFH,000H,0F7H,036H,036H,036H,
    036H,036H,037H,030H,037H,036H,036H,036H,
    000H,000H,0FFH,000H,0FFH,000H,000H,000H,
    036H,036H,0F7H,000H,0F7H,036H,036H,036H,
    018H,018H,0FFH,000H,0FFH,000H,000H,000H,
    036H,036H,036H,036H,0FFH,000H,000H,000H,
    000H,000H,0FFH,000H,0FFH,018H,018H,018H,
    000H,000H,000H,000H,0FFH,036H,036H,036H,
    036H,036H,036H,036H,03FH,000H,000H,000H,
    018H,018H,01FH,018H,01FH,000H,000H,000H,
    000H,000H,01FH,018H,01FH,018H,018H,018H,
    000H,000H,000H,000H,03FH,036H,036H,036H,
    036H,036H,036H,036H,0FFH,036H,036H,036H,
    018H,018H,0FFH,018H,0FFH,018H,018H,018H,
    018H,018H,018H,018H,0F8H,000H,000H,000H,
    000H,000H,000H,000H,01FH,018H,018H,018H,
    0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,
    000H,000H,000H,000H,0FFH,0FFH,0FFH,0FFH,
    0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,
    00FH,00FH,00FH,00FH,00FH,00FH,00FH,00FH,
    0FFH,0FFH,0FFH,0FFH,000H,000H,000H,000H,
    000H,000H,076H,0DCH,0C8H,0DCH,076H,000H,
    000H,078H,0CCH,0F8H,0CCH,0F8H,0C0H,0C0H,
    000H,0FCH,0CCH,0C0H,0C0H,0C0H,0C0H,000H,
    000H,0FEH,06CH,06CH,06CH,06CH,06CH,000H,
    0FCH,0CCH,060H,030H,060H,0CCH,0FCH,000H,
    000H,000H,07EH,0D8H,0D8H,0D8H,070H,000H,
    000H,066H,066H,066H,066H,07CH,060H,0C0H,
    000H,076H,0DCH,018H,018H,018H,018H,000H,
    0FCH,030H,078H,0CCH,0CCH,078H,030H,0FCH,
    038H,06CH,0C6H,0FEH,0C6H,06CH,038H,000H,
    038H,06CH,0C6H,0C6H,06CH,06CH,0EEH,000H,
    01CH,030H,018H,07CH,0CCH,0CCH,078H,000H,
    000H,000H,07EH,0DBH,0DBH,07EH,000H,000H,
    006H,00CH,07EH,0DBH,0DBH,07EH,060H,0C0H,
    038H,060H,0C0H,0F8H,0C0H,060H,038H,000H,
    078H,0CCH,0CCH,0CCH,0CCH,0CCH,0CCH,000H,
    000H,0FCH,000H,0FCH,000H,0FCH,000H,000H,
    030H,030H,0FCH,030H,030H,000H,0FCH,000H,
    060H,030H,018H,030H,060H,000H,0FCH,000H,
    018H,030H,060H,030H,018H,000H,0FCH,000H,
    00EH,01BH,01BH,018H,018H,018H,018H,018H,
    018H,018H,018H,018H,018H,0D8H,0D8H,070H,
    030H,030H,000H,0FCH,000H,030H,030H,000H,
    000H,076H,0DCH,000H,076H,0DCH,000H,000H,
    038H,06CH,06CH,038H,000H,000H,000H,000H,
    000H,000H,000H,018H,018H,000H,000H,000H,
    000H,000H,000H,000H,018H,000H,000H,000H,
    00FH,00CH,00CH,00CH,0ECH,06CH,03CH,01CH,
    078H,06CH,06CH,06CH,06CH,000H,000H,000H,
    070H,018H,030H,060H,078H,000H,000H,000H,
    000H,000H,03CH,03CH,03CH,03CH,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H
    );

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ndxSpriteeraser        = 1; (* don't use 0 *)
    ndxSpriteHH            = 2;
    ndxSpriteMM	           = 3;
    ndxSpriteSS	           = 4;
    ndxSpriteDayInMonth    = 5;
    ndxSpriteMonthInYear   = 6;
    ndxSpriteDayInYear     = 7;
    ndxSpritesmallmarkEven = 8;
    ndxSpritesmallmarkOdd  = 9;
    ndxSpritemarkEven      = 10;
    ndxSpritemarkOdd       = 11;
    ndxSpritemarkEvenCustom= 12;
    ndxSpritemarkOddCustom = 13;

    firstsprite   = ndxSpriteeraser;
    lastsprite    = ndxSpritemarkOddCustom;

CONST
    wiSprite = 13;
    heSprite = 13;
    minSdata = 0;
    maxSdata = (wiSprite * heSprite) -1;
TYPE
    spritetype = RECORD
        sWidth  : CARDINAL;
        sHeight : CARDINAL;
        sData   : ARRAY [minSdata..maxSdata] OF BYTE;
    END;
VAR
    gSprite : ARRAY [firstsprite..lastsprite] OF spritetype;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    myblack = MAX( BYTE ); (* 255 *)

PROCEDURE isOpaque (v:BYTE):BOOLEAN;
BEGIN
    RETURN (v # BYTE(mxnil) );
END isOpaque;

PROCEDURE fixmyblack (VAR ink:CARDINAL  );
BEGIN
    IF ink = mxnil THEN ink:=myblack; END;
END fixmyblack;

PROCEDURE charToColor(ch:CHAR):CARDINAL;
VAR
    c : CARDINAL;
BEGIN
    CASE ch OF
    | "." : c:= mxnil; (* 0 is transparent AND black : depends upon using draw/tdraw *)
    | " " : c:= myblack; (* was c_BLACK *)
    | "_" : c:= myblack; (* was c_BLACK *)
    | "b" : c:= c_BLUE;
    | "g" : c:= c_GREEN;
    | "c" : c:= c_CYAN;
    | "r" : c:= c_RED;
    | "p" : c:= c_PURPLE;
    | "y" : c:= c_BROWN;
    | "w" : c:= c_WHITE;
    | "+" : c:= c_GREY;
    | "B" : c:= c_bBLUE;
    | "G" : c:= c_bGREEN;
    | "C" : c:= c_bCYAN;
    | "R" : c:= c_bRED;
    | "P" : c:= c_bPURPLE;
    | "Y" : c:= c_YELLOW;
    | "W" : c:= c_bWHITE;
    | "*" : c:= c_BRIGHT;
    ELSE
     	c:= mxnil;
    END;
    RETURN c;
END charToColor;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstpalentry = 0;  (* 0 is transparent, id 255 *)
    lastpalentry  = 15;
    firstpalentryx= 8;
    blackentry    = myblack;

TYPE
    triplet = RECORD
        r,g,b:SHORTCARD;
    END;
VAR
    savpal : ARRAY [firstpalentry..lastpalentry] OF triplet;
    newpal : ARRAY [firstpalentry..lastpalentry] OF triplet;

PROCEDURE savepalette (  );
VAR
    i,ndx:CARDINAL;
BEGIN
    FOR i:= firstpalentry TO lastpalentry DO
        getDAC(i, savpal[i].r, savpal[i].g, savpal[i].b);
    END;
END savepalette;

TYPE
    palettetype = (defaultpal, redpal,greenpal, bluepal,cyanpal);
CONST
    firstpal = ORD(defaultpal);
    lastpal  = ORD(cyanpal);

CONST
    black       = LONGCARD(0000000H);
    white       = LONGCARD(03F3F3FH); (* ega/vga range is $00..$3F *)
    red         = LONGCARD(03F1F00H); (* 3f00 *)
    green       = LONGCARD(01F3F00H); (* 003f *)
    darkgreen   = LONGCARD(0002000H);
    blue        = LONGCARD(0002F3FH); (* 003f *)
    darkblue    = LONGCARD(0000020H);
    cyan        = LONGCARD(0001F3FH); (* 2f3f *)
    yellow      = LONGCARD(03F3F00H);
    darkred     = LONGCARD(0200000H);
    orange      = LONGCARD(02F2F00H);
CONST
    egarange = 40H;

PROCEDURE blend (ndx,count:CARDINAL; startink, endink:LONGCARD);
CONST
    rshift = LONGCARD(16);
    gshift = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    i : CARDINAL;
BEGIN
    r1 := INTEGER (startink >> rshift) MOD egarange;
    g1 := INTEGER (startink >> gshift) MOD egarange;
    b1 := INTEGER (startink          ) MOD egarange;
    r2 := INTEGER (endink   >> rshift) MOD egarange;
    g2 := INTEGER (endink   >> gshift) MOD egarange;
    b2 := INTEGER (endink            ) MOD egarange;

    FOR i := 1 TO count DO
        r := r1 + ((r2 - r1) * INTEGER(i) ) DIV INTEGER(count);
        g := g1 + ((g2 - g1) * INTEGER(i) ) DIV INTEGER(count);
        b := b1 + ((b2 - b1) * INTEGER(i) ) DIV INTEGER(count);
        IF r < 0 THEN r:=0; END;
        IF g < 0 THEN g:=0; END;
        IF b < 0 THEN b:=0; END;
        IF r >= egarange THEN r:=egarange-1; END;
        IF g >= egarange THEN g:=egarange-1; END;
        IF b >= egarange THEN b:=egarange-1; END;
        newpal[ndx+i-1].r:=BYTE(r);
        newpal[ndx+i-1].g:=BYTE(g);
        newpal[ndx+i-1].b:=BYTE(b);
    END;
END blend;

(* 16 48 64  2 6 8 *)
(* 16 64 48  2 8 6 *)

PROCEDURE newpalette (pal:palettetype);
CONST
    k1 = 8; (* 4 *)
    k2 = 8; (* 12 *)
VAR
    ndx : CARDINAL;
    i,n : CARDINAL;
    r,g,b:BYTE;
    ir,ig,ib:CARDINAL;
BEGIN
    ndx:=firstpalentry;
    CASE pal OF
    | defaultpal:
        (*
        FOR i:=firstpalentry TO lastpalentry DO
            newpal[i]:=savpal[i];
        END;
        *)
        FOR i:=firstpalentryx TO lastpalentry DO
            newpal[i]:=savpal[i];
            newpal[i-firstpalentryx]:=savpal[i];
        END;
        newpal[firstpalentryx]:=savpal[lastpalentry-3]; (* red *)
    | greenpal:
        n := k1; blend (ndx,n,green,white);   INC(ndx,n);
        n := k2; blend (ndx,n,green,white);
    | cyanpal:
        n := k1; blend (ndx,n,cyan,white);    INC(ndx,n);
        n := k2; blend (ndx,n,cyan,white);
    | redpal:
        n := k1; blend (ndx,n,red,white);     INC(ndx,n);
        n := k2; blend (ndx,n,red,white);
    | bluepal:
        n := k1; blend (ndx,n,blue,white);    INC(ndx,n);
        n := k2; blend (ndx,n,blue,white);
    END;
    SYNC_DISPLAY(); (* reduce noise on screen *)
    setDAC( firstpalentry, 0,0,0); (* make sure black is still black and not dark blue *)
    FOR i:=firstpalentry+1 TO lastpalentry DO
        setDAC( i, newpal[i].r,newpal[i].g,newpal[i].b);
    END;
    setDAC( blackentry, 0,0,0);
END newpalette;

PROCEDURE rotatepalette (pass:CARDINAL);
VAR
    i,j : CARDINAL;
    sav : triplet;
BEGIN
    FOR j:=1 TO pass DO
        FOR i:=firstpalentry+1 TO lastpalentry DO
            CASE i OF
            | firstpalentry+1:
                sav:=newpal[i];
                newpal[i]:=newpal[i+1];
            | lastpalentry:
                newpal[i]:=sav;
            ELSE
                newpal[i]:=newpal[i+1];
            END;
        END;

        SYNC_DISPLAY(); (* reduce noise on screen *)
        setDAC( firstpalentry, 0,0,0); (* make sure black is still black and not dark blue *)
        FOR i:=firstpalentry+1 TO lastpalentry DO
            setDAC( i, newpal[i].r,newpal[i].g,newpal[i].b);
        END;
        setDAC( blackentry, 0,0,0);
    END;
END rotatepalette;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    vrcNone                = 0;
    vrcNoVesaBios          = 1;
    vrcVesaModeNotAvailable= 2;
    vrcVesaAbout           = 3;
    vrcCannotSetVesaMode   = 4;
    vrcVesaBank            = 5;
    vrcVesaGranularity     = 6;
    vrcCannotSetModeX      = 7;

CONST
    modex320x240     = 0;
    vesamode640x480  = 1;
    vesamode800x600  = 2;
    firstvmode       = modex320x240;
    lastvmode        = vesamode800x600;
    defaultvmode     = firstvmode;

CONST
    xmaximum     = 800; (* 360 *)
    ymaximum     = 600; (* 240 *)
    xmin         = 0;
    ymin         = 0;
    PagesVirtual = 2; (* view, work *)
    page1        = 0;
    page2        = 1;
    page3        = 2;

(* globerks *)

VAR
    xcount,ycount,xmax,ymax:CARDINAL;
    (* mode X only *)
    xMaxVirtual,yMaxVirtual,gViewpage,gWorkpage,bkpage : CARDINAL;
    (* to avoid casts *)
    iscreenwidth , iscreenheight : INTEGER;
    ixmax        , iymax         : INTEGER;
    icx          , icy           : INTEGER;
    cx           , cy            : CARDINAL;

(* ------------------------------------------------------------ *)

PROCEDURE setviewwork (view,work:CARDINAL );
BEGIN
    gViewpage := view;
    gWorkpage := work;
    SET_DISPLAY_PAGE (gViewpage);
    SET_ACTIVE_PAGE  (gWorkpage);
END setviewwork;

PROCEDURE swapviewwork (  );
BEGIN
    swap(gViewpage,gWorkpage);
    SET_DISPLAY_PAGE (gViewpage);
    SET_ACTIVE_PAGE  (gWorkpage);
END swapviewwork;

PROCEDURE VESAcls (paper:CARDINAL);
VAR
    x,y:CARDINAL;
BEGIN
    FOR y:=ymin TO ymax DO
        initVESAhline(xcount, SHORTCARD(paper) );
        FOR x:=xmin TO xmax DO
            VESAputpixel8hline(x,y, SHORTCARD(paper) );
        END;
        updateVESAhline(xcount,y);
    END;
END VESAcls;

PROCEDURE modexcls (paper:CARDINAL);
BEGIN
    CLEAR_VGA_SCREEN (paper);
END modexcls;

(* ------------------------------------------------------------ *)

PROCEDURE doCls (usevesa,dosync:BOOLEAN;paper:CARDINAL);
BEGIN
    IF dosync THEN SYNC_DISPLAY(); END;
    IF usevesa THEN
        VESAcls(paper);
    ELSE
        modexcls(paper);
    END;
END doCls;

PROCEDURE plot ( x,y:INTEGER;ink:CARDINAL; usevesa:BOOLEAN  );
BEGIN
    IF usevesa THEN
        VESAputpixel8(x,y, SHORTCARD (ink) );
    ELSE
        SET_POINT(x,y,ink);
    END;
END plot;

PROCEDURE plot8 (cx, cy, xcrd, ycrd : INTEGER; ink: CARDINAL;usevesa:BOOLEAN);
VAR
    vink:SHORTCARD;
BEGIN
    IF usevesa THEN
        vink:=SHORTCARD(ink);
        VESAputpixel8 (cx+ycrd,cy+xcrd, vink );
        VESAputpixel8 (cx-ycrd,cy+xcrd, vink );
        VESAputpixel8 (cx-ycrd,cy-xcrd, vink );
        VESAputpixel8 (cx+ycrd,cy-xcrd, vink );
        VESAputpixel8 (cx+xcrd,cy-ycrd, vink );
        VESAputpixel8 (cx+xcrd,cy+ycrd, vink );
        VESAputpixel8 (cx-xcrd,cy+ycrd, vink );
        VESAputpixel8 (cx-xcrd,cy-ycrd, vink );
    ELSE
        SET_POINT (cx+ycrd,cy+xcrd,ink);
        SET_POINT (cx-ycrd,cy+xcrd,ink);
        SET_POINT (cx-ycrd,cy-xcrd,ink);
        SET_POINT (cx+ycrd,cy-xcrd,ink);
        SET_POINT (cx+xcrd,cy-ycrd,ink);
        SET_POINT (cx+xcrd,cy+ycrd,ink);
        SET_POINT (cx-xcrd,cy+ycrd,ink);
        SET_POINT (cx-xcrd,cy-ycrd,ink);
    END;
END plot8;

PROCEDURE doCircle(xcenter, ycenter,radius,ink:CARDINAL;usevesa:BOOLEAN);
VAR
    xcrd,ycrd,a,b,f,xc,yc,rayon:INTEGER;
BEGIN
    xc  :=INTEGER(xcenter);
    yc  :=INTEGER(ycenter);
    rayon:=INTEGER(radius);
    xcrd:=rayon;
    ycrd:=0;
    a	:=-2*(xcrd+1);
    b	:=1;
    f	:=0;
    REPEAT
        plot8 (xcenter,ycenter,xcrd,ycrd,ink,usevesa);
        INC(ycrd);
        INC( f,b );
        IF f > rayon THEN
            INC( f,a  );
            INC( a,2  );
            DEC( xcrd );
        END;
        INC(b,2);
    UNTIL ( NOT( b <= (-a) ) );
END doCircle;

PROCEDURE doLine(x1, y1, x2, y2, ink : CARDINAL; usevesa:BOOLEAN);
VAR
    i, deltax, deltay, numpixels,
    d, dinc1, dinc2,
    x, xinc1, xinc2,
    y, yinc1, yinc2 : INTEGER;
    vink:SHORTCARD;
BEGIN
    IF NOT(usevesa) THEN
        DRAW_LINE(x1,y1,x2,y2,ink);
        RETURN;
    END;

    vink:=SHORTCARD(ink);

    (* Calculate deltax and deltay for initialisation *)
    deltax := ABS( INTEGER(x2) - INTEGER(x1) );
    deltay := ABS( INTEGER(y2) - INTEGER(y1) );

    (* Initialize all vars based on which is the independent variable *)
    IF deltax >= deltay THEN
        (* x is independent variable *)
        numpixels := deltax + 1;
        d := (2 * deltay) - deltax;
        dinc1 := deltay << 1;
        dinc2 := (deltay - deltax) << 1;
        xinc1 := 1;
        xinc2 := 1;
        yinc1 := 0;
        yinc2 := 1;
    ELSE
        (* y is independent variable *)
        numpixels := deltay + 1;
        d := (2 * deltax) - deltay;
        dinc1 := deltax << 1;
        dinc2 := (deltax - deltay) << 1;
        xinc1 := 0;
        xinc2 := 1;
        yinc1 := 1;
        yinc2 := 1;
    END;

    (* Make sure x and y move in the right directions *)
    IF x1 > x2 THEN
        xinc1 := - xinc1;
        xinc2 := - xinc2;
    END;
    IF y1 > y2 THEN
        yinc1 := - yinc1;
        yinc2 := - yinc2;
    END;

    (* Start drawing at <x1, y1> *)
    x := CARDINAL(x1);
    y := CARDINAL(y1);

    (* Draw the pixels *)
    FOR i := 1 TO numpixels DO
        VESAputpixel8(x,y, vink ); (* //plot *)
        IF d < 0 THEN
            d := d + dinc1;
            x := x + xinc1;
            y := y + yinc1;
        ELSE
            d := d + dinc2;
            x := x + xinc2;
            y := y + yinc2;
        END;
    END;
END doLine;

PROCEDURE doSprite (wleft,wtop,ndx:CARDINAL;usevesa:BOOLEAN   );
VAR
    x,y,xx,ps:CARDINAL;
    vink:BYTE;
BEGIN
    IF usevesa THEN
        ps:=minSdata;
        FOR y:=1 TO gSprite[ndx].sHeight DO
            xx:=wleft;
            FOR x:=1 TO gSprite[ndx].sWidth DO
                vink:= gSprite[ndx].sData[ps];
                IF isOpaque(vink) THEN VESAputpixel8( xx,wtop,vink); END; (* //plot *)
                INC(xx);
                INC(ps);
            END;
            INC(wtop);
        END;
    ELSE
        TDRAW_BITMAP( FarADR( gSprite[ndx].sData ),
                      wleft,wtop,
                      gSprite[ndx].sWidth,gSprite[ndx].sHeight);
    END;
END doSprite;

PROCEDURE doPrintAt (x,y,ink,paper,slen:CARDINAL;usevesa:BOOLEAN; S:ARRAY OF CHAR);
TYPE
    bitmasktype = ARRAY[1..8] OF CARDINAL;
CONST
    charsize = (wichar DIV 8 ) * wichar;
    bitmask = bitmasktype( 80H,40H,20H,10H, 08H,04H,02H,01H);
VAR
    i,p,wi,he,xx,yy,mask:CARDINAL;
    vink,vpaper:BYTE;
BEGIN
    IF usevesa THEN
        vink := BYTE(ink);
        vpaper:=BYTE(paper);
        FOR i:=1 TO slen DO
            p  :=ORD( S[i-1] ) * charsize;
            yy :=y;
            FOR he := 1 TO wichar DO
                xx := x;
                mask:=CARDINAL ( smallFontAPPLE[p] );
                FOR wi:=1 TO 8 DO
                    IF ( mask AND bitmask[wi] ) # 0 THEN
                        VESAputpixel8(xx,yy,vink);
                    ELSE
                        VESAputpixel8(xx,yy,vpaper);
                    END;
                    INC(xx);
                END;
                INC(p);
                INC(yy);
            END;
            INC(x,wichar);
        END;
    ELSE
	    PRINT_STR(FarADR(S),slen,x,y,ink,paper);
    END;
END doPrintAt;

(* ------------------------------------------------------------ *)

(* yes, we should get these infos from mode X or VESA structures... *)

PROCEDURE getModeInfos (vmode:CARDINAL;
                       VAR usevesa:BOOLEAN;
                       VAR wi,he,m:CARDINAL;VAR R:str16):BOOLEAN;
VAR
    rc:BOOLEAN;
BEGIN
    usevesa:=TRUE;
    rc:=TRUE;
    CASE vmode OF
    |modex320x240   : m:=Mode_320x240;  wi:=320;he:=240; R:="320x240x8"; usevesa:=FALSE;
    |vesamode640x480: m:=vesa640x480x8; wi:=640;he:=480; R:="640x480x8";
    |vesamode800x600: m:=vesa800x600x8; wi:=800;he:=600; R:="800x600x8";
    ELSE
                      m:=MAX(CARDINAL); wi:=0;  he:=0;   R:="unknown";
                      rc:=FALSE;
    END;
    RETURN rc;
END getModeInfos;

PROCEDURE HiresON (vmode,paper:CARDINAL;dosync,buffered:BOOLEAN;
                   VAR usevesa,modex,flipmode:BOOLEAN;VAR videoMode:CARDINAL;
                   VAR sMode:str16):CARDINAL;
VAR
    ok:BOOLEAN;
BEGIN
    ok:=getModeInfos(vmode,  usevesa,xcount,ycount,videoMode,sMode); (* already filtered *)
    modex:=NOT(usevesa);
    flipmode:=(modex AND buffered);

    xmax          := xcount-1;
    ymax          := ycount-1;
    cx            := xmax DIV 2;
    cy            := ymax DIV 2;
    (* to avoid casts *)
    icx           := INTEGER(cx);
    icy           := INTEGER(cy);
    iscreenwidth  := INTEGER(xcount);
    iscreenheight := INTEGER(ycount);
    ixmax         := INTEGER(xmax);
    iymax         := INTEGER(ymax);

    IF usevesa THEN
        IF chkVESAhere()=FALSE THEN RETURN vrcNoVesaBios;END;
        IF isModeHere(videoMode)=FALSE THEN RETURN vrcVesaModeNotAvailable;END;
        IF getVESAmodeInfos(videoMode)=FALSE THEN RETURN vrcVesaAbout;END;
        IF SetVesaMode(videoMode) = FALSE THEN RETURN vrcCannotSetVesaMode;END;
        IF initVESAmode(1)=FALSE THEN RETURN vrcVesaBank;END;
        IF initVESAmode(2)=FALSE THEN RETURN vrcVesaGranularity;END;
    ELSE
        xMaxVirtual :=xcount;
        yMaxVirtual :=ycount;
        IF SET_VGA_MODEX(videoMode,xMaxVirtual,yMaxVirtual,PagesVirtual)=0 THEN
            RETURN vrcCannotSetModeX;
        END;

        IF flipmode THEN
            setviewwork(page1,page2);
            doCls(usevesa,dosync,paper); (* cls mode X page 2 *)
            swapviewwork;
        ELSE
            setviewwork(page1,page1);
        END;
    END;

    doCls(usevesa,dosync,paper); (* cls mode X page 1 *)

    RETURN vrcNone;
END HiresON;

PROCEDURE HiresOFF ();
CONST
    biostxtmode = 3; (* 80x25 is always a safe bet, eh eh... *)
BEGIN
    SET_VIDEO_MODE(biostxtmode);
END HiresOFF;

PROCEDURE showpalette (usevesa:BOOLEAN);
CONST
    numpalentries = (lastpalentry-firstpalentry+1);
VAR
    i,n,d,r,x,y,ink:CARDINAL;
BEGIN
    d:=(ymax-ymin+1) DIV numpalentries;
    r:=d DIV 2;
    y:=r;
    x:=r;
    FOR ink:=firstpalentry TO lastpalentry DO
        FOR n:=1 TO r DO
            doCircle(x, y,n,ink,usevesa);
        END;
        doCircle(x,y,r,lastpalentry,usevesa);
        INC(y,d);
    END;
END showpalette;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    defaultSprites = nl+
"; definition order must be respected"+nl+
"; strings may be enclosed with double quotes (blanks NEED to)"+nl+
nl+
'; "."=transparent'+nl+
';  " _"=black   "bB"=blue   "gG"=green  "rR"=red'+nl+
';  "pP"=purple  "yY"=brown  "wW"=white  "+*"=grey'+nl+
nl+
"; color for even minutes"+nl+
nl+
'"r"'+nl+
nl+
"; color for odd minutes"+nl+
nl+
'"g"'+nl+
nl+
"; color for date & time (odd minutes)"+nl+
nl+
'"R"'+nl+
nl+
"; color for date & time (even minutes)"+nl+
nl+
'"G"'+nl+
nl+
"; all sprites must be 13x13"+nl+
nl+
"; eraser for all other sprites"+nl+
"; it MUST be a little bigger than any other sprite"+nl+
"; besides, any color other than transparent will be background color"+nl+
nl+
'"...**+++**..."'+nl+
'"..*++   ++*.."'+nl+
'".*+       +*."'+nl+
'"*+         +*"'+nl+
'"*+         +*"'+nl+
'"+           +"'+nl+
'"+           +"'+nl+
'"+           +"'+nl+
'"*+         +*"'+nl+
'"*+         +*"'+nl+
'".*+       +*."'+nl+
'"..*++   ++*.."'+nl+
'"...**+++**..."'+nl+
nl+
"; hours"+nl+
nl+
"............."+nl+
".....RRR....."+nl+
"...RRRRRRR..."+nl+
"..RRRRRRRRR.."+nl+
"..RRRRRRRRR.."+nl+
".RRRRRRRRRRR."+nl+
".RRRRRRRRRRR."+nl+
".RRRRRRRRRRR."+nl+
"..RRRRRRRRR.."+nl+
"..RRRRRRRRR.."+nl+
"...RRRRRRR..."+nl+
".....RRR....."+nl+
"............."+nl+
nl+
"; minutes"+nl+
nl+
"............."+nl+
".....GGG....."+nl+
"...GGGGGGG..."+nl+
"..GGGGGGGGG.."+nl+
"..GGGGGGGGG.."+nl+
".GGGGGGGGGGG."+nl+
".GGGGGGGGGGG."+nl+
".GGGGGGGGGGG."+nl+
"..GGGGGGGGG.."+nl+
"..GGGGGGGGG.."+nl+
"...GGGGGGG..."+nl+
".....GGG....."+nl+
"............."+nl+
nl+
"; seconds"+nl+
nl+
"............."+nl+
".....YYY....."+nl+
"...YYYYYYY..."+nl+
"..YYYYYYYYY.."+nl+
"..YYYYYYYYY.."+nl+
".YYYYYYYYYYY."+nl+
".YYYYYYYYYYY."+nl+
".YYYYYYYYYYY."+nl+
"..YYYYYYYYY.."+nl+
"..YYYYYYYYY.."+nl+
"...YYYYYYY..."+nl+
".....YYY....."+nl+
"............."+nl+
nl+

"; days in month"+nl+
nl+
"............."+nl+
".....WWW....."+nl+
"...WWWWWWW..."+nl+
"..WWWWWWWWW.."+nl+
"..WWWWWWWWW.."+nl+
".WWWWWWWWWWW."+nl+
".WWWWWWWWWWW."+nl+
".WWWWWWWWWWW."+nl+
"..WWWWWWWWW.."+nl+
"..WWWWWWWWW.."+nl+
"...WWWWWWW..."+nl+
".....WWW....."+nl+
"............."+nl+
nl+
"; month in year"+nl+
nl+
"............."+nl+
".....BBB....."+nl+
"...BBBBBBB..."+nl+
"..BBBBBBBBB.."+nl+
"..BBBBBBBBB.."+nl+
".BBBBBBBBBBB."+nl+
".BBBBBBBBBBB."+nl+
".BBBBBBBBBBB."+nl+
"..BBBBBBBBB.."+nl+
"..BBBBBBBBB.."+nl+
"...BBBBBBB..."+nl+
".....BBB....."+nl+
"............."+nl+
nl+
"; days in year"+nl+
nl+
"............."+nl+
".....PPP....."+nl+
"...PPPPPPP..."+nl+
"..PPPPPPPPP.."+nl+
"..PPPPPPPPP.."+nl+
".PPPPPPPPPPP."+nl+
".PPPPPPPPPPP."+nl+
".PPPPPPPPPPP."+nl+
"..PPPPPPPPP.."+nl+
"..PPPPPPPPP.."+nl+
"...PPPPPPP..."+nl+
".....PPP....."+nl+
"............."+nl+
nl+

"; seconds small mark for even minutes"+nl+
nl+
"............."+nl+
"............."+nl+
"............."+nl+
"............."+nl+
".....rrr....."+nl+
"....r...r...."+nl+
"....r...r...."+nl+
"....r...r...."+nl+
".....rrr....."+nl+
"............."+nl+
"............."+nl+
"............."+nl+
"............."+nl+
nl+
"; seconds small mark for odd minutes"+nl+
nl+
"............."+nl+
"............."+nl+
"............."+nl+
"............."+nl+
".....ggg....."+nl+
"....g...g...."+nl+
"....g...g...."+nl+
"....g...g...."+nl+
".....ggg....."+nl+
"............."+nl+
"............."+nl+
"............."+nl+
"............."+nl+
nl+
"; seconds mark for even minutes"+nl+
nl+
"............."+nl+
".....rrr....."+nl+
"...rr...rr..."+nl+
"..r.......r.."+nl+
"..r.......r.."+nl+
".r.........r."+nl+
".r.........r."+nl+
".r.........r."+nl+
"..r.......r.."+nl+
"..r.......r.."+nl+
"...rr...rr..."+nl+
".....rrr....."+nl+
"............."+nl+
nl+
"; seconds mark for odd minutes"+nl+
nl+
"............."+nl+
".....ggg....."+nl+
"...gg...gg..."+nl+
"..g.......g.."+nl+
"..g.......g.."+nl+
".g.........g."+nl+
".g.........g."+nl+
".g.........g."+nl+
"..g.......g.."+nl+
"..g.......g.."+nl+
"...gg...gg..."+nl+
".....ggg....."+nl+
"............."+nl+
nl+
"; alternate seconds mark for even minutes"+nl+
nl+
(*%F SPECIAL  *)
"............."+nl+
".....rrr....."+nl+
"...rr...rr..."+nl+
"..r.......r.."+nl+
"..r.......r.."+nl+
".r....r....r."+nl+
".r...rrr...r."+nl+
".r....r....r."+nl+
"..r.......r.."+nl+
"..r.......r.."+nl+
"...rr...rr..."+nl+
".....rrr....."+nl+
"............."+nl+
(*%E *)
(*%T SPECIAL *)
"............."+nl+
".....rrr....."+nl+
"...rr...rr..."+nl+
"..r.......r.."+nl+
"..r.......r.."+nl+
".r....r....r."+nl+
".r...rrr...r."+nl+
".r....r....r."+nl+
"..r.......r.."+nl+
"..r.......r.."+nl+
"...rr...rr..."+nl+
".....rrr....."+nl+
"............."+nl+
(*%E *)
nl+
"; alternate seconds mark for odd minutes"+nl+
nl+
(*%F SPECIAL *)
"............."+nl+
".....ggg....."+nl+
"...gg...gg..."+nl+
"..g.......g.."+nl+
"..g.......g.."+nl+
".g....g....g."+nl+
".g...ggg...g."+nl+
".g....g....g."+nl+
"..g.......g.."+nl+
"..g.......g.."+nl+
"...gg...gg..."+nl+
".....ggg....."+nl+
"............."+nl+
(*%E *)
(*%T SPECIAL *)
"............."+nl+
".....ggg....."+nl+
"...gg...gg..."+nl+
"..g.......g.."+nl+
"..g.......g.."+nl+
".g....g....g."+nl+
".g...ggg...g."+nl+
".g....g....g."+nl+
"..g.......g.."+nl+
"..g.......g.."+nl+
"...gg...gg..."+nl+
".....ggg....."+nl+
"............."+nl+
(*%E  *)
nl;

PROCEDURE initSpriteData (genfile:BOOLEAN;paper:CARDINAL;
                         VAR internalsprites:BOOLEAN;
                         VAR colorEven,colorOdd,
                             colorEvenInfo,colorOddInfo:CARDINAL):CARDINAL;

    MODULE grabline;

    IMPORT Str;
    IMPORT nl,nullchar,dquote,LtrimBlanks,RtrimBlanks;
    EXPORT getvalidline;

    PROCEDURE getvalidline (VAR p:CARDINAL; VAR R:ARRAY OF CHAR;
                      dat:ARRAY OF CHAR ):BOOLEAN;
    CONST
        enclosedpat = dquote+"*"+dquote;
    VAR
        q,n:CARDINAL;
    BEGIN
        LOOP
            q:=Str.NextPos(dat,nl,p);
            IF q = MAX(CARDINAL) THEN p:=q; RETURN FALSE; END;
            n := ( q-p );
            Str.Slice (R,dat, p,n);
            p := q+2;
            LtrimBlanks(R);
            RtrimBlanks(R);
            CASE R[0] OF
            | nullchar, ";", "#" :
                ;
            ELSE
                IF Str.Match(R,enclosedpat) THEN
                    Str.Delete(R,0,1);
                    Str.Delete(R,Str.Length(R)-1,1);
                END;
                RETURN TRUE;
            END;
        END;

        RETURN TRUE;
    END getvalidline;

    END grabline;

VAR
    S : str128;
    hnd : FIO.File;
    fsize:LONGCARD;
    ps,len,pdat,got, ndx,x,y, ink:CARDINAL;
    dat:str4096;
    ok:BOOLEAN;
BEGIN
    S:=progEXEname+extDAT;

    IF genfile THEN
        hnd:=FIO.Create(S);
        FIO.WrStr(hnd,defaultSprites);
        FIO.Close(hnd);
        WrStr(S);WrStr(" has been created.");WrLn;
        RETURN errNone;
    END;

    IF FIO.Exists(S)=FALSE THEN     (* does not exist in current directory *)
        Lib.ParamStr(S,0);
        Str.Caps(S); (* useless *)
        Str.Subst(S,extEXE,extDAT); (* give executable directory a chance *)
    END;

    IF internalsprites=FALSE THEN internalsprites:= NOT(FIO.Exists(S)); END;

    IF internalsprites THEN
        Str.Copy(dat, defaultSprites);
        len:=Str.Length(defaultSprites);
    ELSE
        hnd:=FIO.OpenRead(S);
        fsize:=FIO.Size(hnd);
        IF fsize < SIZE(dat) THEN
            got:=FIO.RdBin(hnd, dat, CARDINAL(fsize) );
            len:=got;
        ELSE
            got:=MAX(CARDINAL);
        END;
        FIO.Close(hnd);
        IF got=MAX(CARDINAL) THEN RETURN errIniSize; END;
    END;

    fixmyblack(paper);

    dat[len]:=nullchar;
    (* safety *)
    Str.Subst (dat,ctrlZ,"");
    Str.Append(dat,nl);

    pdat := 0;

    IF getvalidline(pdat,S, dat)=FALSE THEN RETURN errIniLine; END;
    IF Str.Length(S) # 1 THEN RETURN errIniLine;END;
    colorEven := charToColor(S[0]);

    IF getvalidline(pdat,S, dat)=FALSE THEN RETURN errIniLine; END;
    IF Str.Length(S) # 1 THEN RETURN errIniLine;END;
    colorOdd := charToColor(S[0]);

    IF getvalidline(pdat,S, dat)=FALSE THEN RETURN errIniLine; END;
    IF Str.Length(S) # 1 THEN RETURN errIniLine;END;
    colorEvenInfo := charToColor(S[0]);

    IF getvalidline(pdat,S, dat)=FALSE THEN RETURN errIniLine; END;
    IF Str.Length(S) # 1 THEN RETURN errIniLine;END;
    colorOddInfo := charToColor(S[0]);

    FOR ndx := firstsprite TO lastsprite DO
        gSprite[ndx].sWidth := wiSprite;
        gSprite[ndx].sHeight:= heSprite;
        ps := minSdata;
        FOR y := 1 TO heSprite DO
            ok:=getvalidline(pdat,S, dat);
            IF NOT(ok)THEN RETURN errIniLine; END;
            IF Str.Length(S) # wiSprite THEN RETURN errIniLine; END;
            FOR x := 1 TO wiSprite DO
                ink:=charToColor( S[x-1] );

                IF ndx=ndxSpriteeraser THEN
                    IF ink # mxnil THEN ink:=paper;END;
                END;

                gSprite[ndx].sData[ps] := SHORTCARD( ink );
                INC(ps);
            END;
        END;
    END;

    RETURN errNone;
END initSpriteData;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* from CAL v1.0a *)

(*
    gregorian calendar rule : leap 366 years if divisible by 4
    but centurial years NOT divisible by 4 are common
    Leap years are divisible by 400, or by 4 and not by 100
    1900 is common, 2000 is leap
*)

PROCEDURE getDaysInFebruary (annee:CARDINAL):CARDINAL;
CONST
    common = 28;
    leap   = 29;
BEGIN
    IF (annee MOD 400) = 0 THEN RETURN leap; END;
    IF (((annee MOD 4) = 0) AND ((annee MOD 100) # 0)) THEN RETURN leap; END;
    RETURN common;
END getDaysInFebruary;

(* assume month and year are correct *)

PROCEDURE getDaysInMonth (mois,annee:CARDINAL):CARDINAL;
TYPE
    daysinmonthtype = ARRAY [1..12] OF CARDINAL;
CONST
    (*                    JanFevMarAprMayJunJulAugSepOctNovDec *)
    (*                     1  2  3  4  5  6  7  8  9 10 11 12  *)
    dpm = daysinmonthtype(31, 0,31,30,31,30,31,31,30,31,30,31);
VAR
    m : CARDINAL;
BEGIN
    m:= dpm[mois];
    IF m=0 THEN m:=getDaysInFebruary(annee);END;
    RETURN m;
END getDaysInMonth;

PROCEDURE getDaysInYear (annee:CARDINAL):CARDINAL;
VAR
    m,sigma:CARDINAL;
BEGIN
    sigma:=0;
    FOR m:=1 TO 12 DO
        INC (sigma, getDaysInMonth(m,annee) );
    END;
    RETURN sigma;
END getDaysInYear;

PROCEDURE getDaysFromJan1st (jour,mois,annee:CARDINAL):CARDINAL;
VAR
    m,sigma:CARDINAL;
BEGIN
    sigma:=jour;
    FOR m:=1 TO (mois-1) DO
        INC (sigma, getDaysInMonth(m,annee) );
    END;
    RETURN sigma;
END getDaysFromJan1st;

PROCEDURE getMonthsInYear ( annee : CARDINAL ) : CARDINAL;
CONST
    monthsPerYear = 12;
BEGIN
    RETURN monthsPerYear;
END getMonthsInYear;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    (* ah, enumeration is such a nice feature... *)
    modeNormal   = 0;
    modeDots     = 1;
    modeTrail    = 2;
    infosNone    = 0;
    infosTime    = 1;
    infosDate    = 2;
    infosDateTime= 3;
    timeColon    = 0; (* ##:##:## *)
    timeHMS      = 1; (* ##h ##mn ##s *)
    datePlainFRA = 0; (* JJ MMM AAAA *)
    dateAbrevFRA = 1; (* JJ MM AAAA *)
    datePlainUSA = 2; (* MMM DD, YYYY *)
    dateAbrevUSA = 3; (* DD MM YYYY *)
    dateNumFRA   = 4; (* JJ-MM-AAAA *)
    dateNumUSA   = 5; (* MM-DD-YYYY *)
    circlesDefault=0;
    circlesAll   = 1;
    circlesNone  = 2;
CONST
    pole = 180;
    fpole= LONGREAL(pole);
VAR
    PI : LONGREAL; (* globerk, overkill but MATLIB wants this TYPE *)

PROCEDURE initTrigo (  );
BEGIN
    PI := 4.0 * MATHLIB.ATan( 1.0) ;
END initTrigo;

PROCEDURE deg2rad (alpha:LONGREAL):LONGREAL;
BEGIN
    RETURN (alpha * PI / 180.0);
END deg2rad;

PROCEDURE p2r (alf,radius:LONGREAL; VAR dx,dy:LONGREAL);
VAR
    alpha:LONGREAL;
BEGIN
    alpha:=deg2rad(alf);
    dx   :=radius * MATHLIB.Sin( alpha ) ;
    dy   :=radius * MATHLIB.Cos( alpha ) ;
END p2r;

(* ------------------------------------------------------------ *)

CONST
    chkDateLen = 0;
    chkTimeLen = 1;
VAR
    prevDateLen, prevTimeLen : CARDINAL;

PROCEDURE initDrawInfos ();
BEGIN
    prevDateLen := 0;
    prevTimeLen := 0;
END initDrawInfos;

PROCEDURE padDrawInfos (chkWhatLen:CARDINAL; VAR S:ARRAY OF CHAR):CARDINAL;
VAR
    slen,round,whatlen:CARDINAL;
BEGIN
    CASE chkWhatLen OF
    | chkDateLen : whatlen:=prevDateLen;
    | chkTimeLen : whatlen:=prevTimeLen;
    END;
    round:=0;
    LOOP
        slen:=Str.Length(S);
        IF slen >= whatlen THEN EXIT; END;
        IF ODD(round) THEN
            Str.Prepend(S," ");
        ELSE
            Str.Append (S," ");
        END;
        INC(round);
    END;
    CASE chkWhatLen OF
    | chkDateLen : prevDateLen := slen;
    | chkTimeLen : prevTimeLen := slen;
    END;
    RETURN slen;
END padDrawInfos;

PROCEDURE drawInfos (cx,cy,ink,paper, hh,mm,ss,hsecs,day,month,year,
                    infomode,timefmt,datefmt:CARDINAL;usevesa:BOOLEAN);
CONST
    tmonthsFRA= "janvier fvrier mars avril mai juin "+
                "juillet aot septembre octobre novembre dcembre ???";
    tmonthsFr = "Jan Fv Mar Avr Mai Jui Jul Ao Sep Oct Nov Dc ???";
    tmonthsUSA= "january february march april may june "+
                "july august september october november december ???";
    tmonthsUs = "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ???";
    tmonthsNUM= "01 02 03 04 05 06 07 08 09 10 11 12 ??";
CONST
    Ybeautify = wichar DIV 2; (* separate a little more date and time *)
    charhalf  = wichar DIV 2; (* mode X charset is 8x8 *)
    halfsecs  = 50; (* real clock resolution is about 5/100 so blink every 50/100 *)
VAR
    S : str80; (* "hh:mm:ss" & "jj mmmmmmmmm aaaa" *)
    R : str16;
    x,slen:CARDINAL;
    widay,yDate,yTime:CARDINAL;
    tmonths : str128;
BEGIN
    CASE infomode OF
    | infosNone :
        RETURN;
    | infosTime :
        yTime:=cy-charhalf;
    | infosDate :
        yDate:=cy-charhalf;
    | infosDateTime:
        yDate:=cy-wichar;
        yTime:=cy;
        DEC(yDate,Ybeautify);
        INC(yTime,Ybeautify);
    END;

    CASE infomode OF
    | infosDate,infosDateTime:
        (* ##=day $=month, !=year *)
        (* //FIXME : we should handle 1er, 1st, 2nd, 3rd *)

        widay:=1;
        CASE datefmt OF
        | datePlainFRA: S:="# $ !";  tmonths:=tmonthsFRA;
        | dateAbrevFRA: S:="# $ !";  tmonths:=tmonthsFr;
        | datePlainUSA: S:="$ #, !"; tmonths:=tmonthsUSA;
        | dateAbrevUSA: S:="$ #, !"; tmonths:=tmonthsUs;
        | dateNumFRA:   S:="#-$-!";  tmonths:=tmonthsNUM; widay:=2; (* won't work ! *)
        | dateNumUSA:   S:="$-#-!";  tmonths:=tmonthsNUM; widay:=2; (* won't work ! *)
        END;
        Str.Subst(S,"#",dec2str(day,widay,"0"));

        Str.ItemS(R,tmonths," ",month-1);
        Str.Subst(S,"$",R);

        Str.Subst(S,"!",dec2str(year,4,"0"));

        slen:=padDrawInfos(chkDateLen,S);
	    x := cx-(( slen * wichar) DIV 2);
        doPrintAt (x,yDate,ink,paper,slen,usevesa,S);
    END;
    CASE infomode OF
    | infosTime,infosDateTime:
        CASE timefmt OF
        | timeColon: IF hsecs < halfsecs THEN
                         S:="$:$:$";
                     ELSE
                         S:="$ $ $";
                     END;
        | timeHMS:   IF hsecs < halfsecs THEN
                         S:="$h $mn $s";
                     ELSE
                         S:="$h $mn $s";
                     END;
        END;
        Str.Subst(S,"$",dec2str(hh,2,"0"));
        Str.Subst(S,"$",dec2str(mm,2,"0"));
        Str.Subst(S,"$",dec2str(ss,2,"0"));

        slen:=padDrawInfos(chkTimeLen,S);
	    x := cx-(( slen * wichar) DIV 2);
        doPrintAt (x,yTime,ink,paper, slen,usevesa,S);
    END;
END drawInfos;

PROCEDURE drawmarks (cx,cy,r,ink,ndxmark,ndxsmallmark:CARDINAL;
                    showdivisions,showmarks,usevesa:BOOLEAN);
CONST
    degsPerHour = 360 DIV 12; (* 360degs=12hours *)
    degsPerSec  = 360 DIV 60;
VAR
    alpha:CARDINAL;
    alf,radius,dx,dy:LONGREAL;
    wleft,wtop,ofsx,ofsy:INTEGER;
BEGIN
    IF NOT(showmarks) THEN RETURN; END;
    radius:=LONGREAL(r);
    IF showdivisions THEN
        ofsx:=gSprite[ndxsmallmark].sWidth  DIV 2;
        ofsy:=gSprite[ndxsmallmark].sHeight DIV 2;
        FOR alpha := 1 TO 359 DO
            IF alpha MOD degsPerSec = 0 THEN
                alf := LONGREAL(alpha + pole);
                p2r (alf,radius, dx,dy);
                wleft := icx -ofsx - INTEGER(dx);
                wtop  := icy -ofsy + INTEGER(dy);
                doSprite(wleft,wtop, ndxSpriteeraser,usevesa); (* erase old *)
	            doSprite(wleft,wtop, ndxsmallmark, usevesa);
	        END;
	    END;
    END;

    ofsx:=gSprite[ndxmark].sWidth  DIV 2;
    ofsy:=gSprite[ndxmark].sHeight DIV 2;
    FOR alpha := 0 TO 330 BY degsPerHour DO
        alf := LONGREAL(alpha + pole);
        p2r (alf,radius, dx,dy);
        wleft := icx -ofsx - INTEGER(dx);
        wtop  := icy -ofsy + INTEGER(dy);
        doSprite(wleft,wtop, ndxSpriteeraser,usevesa); (* erase old *)
	    doSprite(wleft,wtop, ndxmark, usevesa);
    END;
END drawmarks;

(* ------------------------------------------------------------ *)

CONST
    hhPer360         = (360 DIV 12); (* 12 hours = 360 *)
    mmPer360         = (360 DIV 60);
    ssPer360         = (360 DIV 60);
    FLhhPer360       = LONGREAL(hhPer360);
    FLmmPer360       = LONGREAL(mmPer360);
    FLssPer360       = LONGREAL(ssPer360);
    fl000            = LONGREAL(0.0);
    fl360            = LONGREAL(360.0);
    flHoursPerDay    = LONGREAL(24.0);
    flMinutesPerHour = LONGREAL(60.0);
TYPE
    itemType = RECORD
        transition: BOOLEAN;
        enabled   : BOOLEAN;
        lastx     : INTEGER;
        lasty     : INTEGER;
        ndxsprite : CARDINAL;
        what      : CARDINAL;
        showmode  : CARDINAL; (* normal,dots,trail *)
        radiusint : CARDINAL;
        radius    : LONGREAL;
        deltadot  : LONGREAL;
        deltatrail: LONGREAL;
        prevorgalf: LONGREAL;
        maxval    : LONGREAL;
        currval   : LONGREAL;
        lastval   : LONGREAL;
        prevval   : LONGREAL;
    END;
CONST
    itemHH = 1;
    itemMM = 2;
    itemSS = 3;
    (* trail mode only *)
    itemDayInMonth = 4; (* 31 *)
    itemMonthInYear= 5; (* 12 *)
    itemDayInYear  = 6; (* 365 *)

    firstitem    = itemHH;
    lastitem     = itemSS;
    firstitemJMA = itemDayInMonth;
    lastitemJMA  = itemDayInYear;
VAR
    item : ARRAY[firstitem..lastitemJMA] OF itemType;

(* ------------------------------------------------------------ *)

(* rsafe copied from Display() *)

PROCEDURE showmemento (usevesa,showdatetrail:BOOLEAN);
CONST
    rsafe               = 1; (* pixels *)
    rsafetyModeX        = heSprite (* + heSprite DIV 4*) ;
    rsafetyVESA         = heSprite + heSprite DIV 2;

    first  = itemHH;
    last   = itemDayInYear;
VAR
    S:str80;
    i,ink,paper,rsafety,x,y,delta,slen:CARDINAL;
    ok:BOOLEAN;
BEGIN
    IF usevesa THEN
        rsafety := rsafetyVESA;
    ELSE
        rsafety := rsafetyModeX;
    END;
    delta := (heSprite + rsafety) DIV 2;
    x     := xmax DIV 2;
    y     := delta - (delta DIV 4) + 1;
    ink   := lastpalentry;
    paper := myblack;

    FOR i:=first TO last DO
        CASE i OF
        | itemHH:          S:="        hours";
        | itemMM:          S:="      minutes";
        | itemSS:          S:="      seconds";
        | itemDayInMonth:  S:=" day in month";
        | itemMonthInYear: S:="month in year";
        | itemDayInYear:   S:="  day in year";
        END;
        CASE i OF
        | itemHH,itemMM,itemSS:
            ok:=TRUE;
        ELSE
            ok:=showdatetrail;
        END;
        IF ok THEN
            slen:=Str.Length(S);
            doPrintAt (x,y,ink,paper,slen,usevesa,S);
        END;
        INC(y,delta);
    END;
END showmemento;

(* ------------------------------------------------------------ *)

PROCEDURE drawdot (ndxitem,hh,mm,ss,hsecs:CARDINAL; drawme,usevesa:BOOLEAN);
VAR
    alpha:CARDINAL;
    alf,radius,dx,dy:LONGREAL;
    wleft,wtop,ofsx,ofsy:INTEGER;
    floathh,floatmm,floatss,floatssss:LONGREAL;
    ndx:CARDINAL;
BEGIN
    IF NOT(drawme) THEN
	    doSprite(item[ndxitem].lastx,item[ndxitem].lasty, ndxSpriteeraser, usevesa);
        RETURN;
    END;

    ndx:=item[ndxitem].ndxsprite;

    IF hh >= 12 THEN DEC(hh,12);END;
    IF item[ndxitem].transition THEN
        floathh:=LONGREAL(hh);
        floatmm:=LONGREAL(mm);
        floatss:=LONGREAL(ss);
        floatssss:=floatss+( LONGREAL(hsecs)/100.0);
        (* HH ignores ss, MM ignores hsecs *)
        CASE ndx OF
        | ndxSpriteHH: alf:=(floatmm);
                       alf:=(floathh + alf/60.0)     * FLhhPer360;
        | ndxSpriteMM: alf:=(floatmm + floatss/60.0) * FLmmPer360;
        | ndxSpriteSS: alf:= floatssss * FLssPer360;
        END;
    ELSE
        CASE ndx OF
        | ndxSpriteHH: alpha := hh * hhPer360;
        | ndxSpriteMM: alpha := mm * mmPer360;
        | ndxSpriteSS: alpha := ss * ssPer360;
        END;
        alf := LONGREAL(alpha);
    END;
    ofsx:=gSprite[ndx].sWidth  DIV 2;
    ofsy:=gSprite[ndx].sHeight DIV 2;
    radius:=item[ndxitem].radius;
    alf:=alf+fpole;
    p2r (alf,radius, dx,dy);
    wleft := icx -ofsx - INTEGER(dx);
    wtop  := icy -ofsy + INTEGER(dy);

(*    IF drawme THEN *)
        doSprite(wleft,wtop, ndx, usevesa);
	    item[ndxitem].lastx:=wleft;
	    item[ndxitem].lasty:=wtop;
(*    ELSE
	    doSprite(item[ndxitem].lastx,item[ndxitem].lasty, spriteeraser, usevesa);
    END; *)
END drawdot;

PROCEDURE drawarc (ndxitem,hh,mm,ss,hsecs:CARDINAL; drawme,cleanarc,usevesa:BOOLEAN);
VAR
    alpha:CARDINAL;
    alf,radius,dx,dy:LONGREAL;
    wleft,wtop,ofsx,ofsy:INTEGER;
    floathh,floatmm,floatss:LONGREAL;
    delta,first,last,curr:LONGREAL;
    ndx:CARDINAL;
BEGIN
    CASE item[ndxitem].showmode OF
    | modeNormal : RETURN;
    | modeDots   : delta:=item[ndxitem].deltadot;
    | modeTrail  : delta:=item[ndxitem].deltatrail;
    END;
    ndx:=item[ndxitem].ndxsprite;

    IF hh >= 12 THEN DEC(hh,12);END;

    first:=item[ndxitem].prevorgalf;
    IF item[ndxitem].showmode = modeTrail THEN
        floathh:=LONGREAL(hh);
        floatmm:=LONGREAL(mm);
        floatss:=LONGREAL(ss)+( LONGREAL(hsecs)/100.0);
        CASE ndx OF
        | ndxSpriteHH: alf:=(floatmm+floatss/60.0);
                       alf:=(floathh + alf/60.0)     * FLhhPer360;

        | ndxSpriteMM: alf:=(floatmm + floatss/60.0) * FLmmPer360;

        | ndxSpriteSS: alf:= floatss * FLssPer360;

        END;

        last := alf;
    ELSE
        CASE ndx OF
        | ndxSpriteHH: alpha := hh * hhPer360;
        | ndxSpriteMM: alpha := mm * mmPer360;
        | ndxSpriteSS: alpha := ss * ssPer360;
        END;
        last := LONGREAL(alpha);
    END;
    item[ndxitem].prevorgalf:=last;

    IF cleanarc THEN  (* erase full circle *)
        first:=fl000;
        last :=fl360;
    END;

    curr:=first;
    LOOP
        ofsx:=gSprite[ndx].sWidth  DIV 2;
        ofsy:=gSprite[ndx].sHeight DIV 2;
        radius:=item[ndxitem].radius;
        p2r (curr+fpole,radius, dx,dy);
        wleft := icx -ofsx - INTEGER(dx);
        wtop  := icy -ofsy + INTEGER(dy);
        IF drawme THEN
	        doSprite(wleft,wtop, ndx, usevesa);
     	ELSE
	        doSprite(wleft,wtop, ndxSpriteeraser, usevesa);
    	END;
        curr:=curr+delta;
        IF curr >= last THEN EXIT; END;
    END;

END drawarc;

(* ------------------------------------------------------------ *)

PROCEDURE drawarc360 (ndxitem:CARDINAL; drawme,cleanarc,usevesa:BOOLEAN);
VAR
    radius,dx,dy:LONGREAL;
    wleft,wtop,ofsx,ofsy:INTEGER;
    delta,first,last,curr:LONGREAL;
    ndx:CARDINAL;
BEGIN
    IF item[ndxitem].enabled=FALSE THEN RETURN; END;

    CASE item[ndxitem].showmode OF
    | modeNormal : RETURN;
    | modeDots   : RETURN;
    | modeTrail  : delta:=item[ndxitem].deltatrail;
    END;
    ndx:=item[ndxitem].ndxsprite;

    first:=item[ndxitem].lastval;
    last:=(item[ndxitem].currval / item[ndxitem].maxval ) * fl360;
    (* item[ndxitem].lastval:=last; *)

    IF cleanarc THEN  (* erase full circle *)
        first:=fl000;
        last :=fl360;
    END;

    curr:=first;
    LOOP
        ofsx:=gSprite[ndx].sWidth  DIV 2;
        ofsy:=gSprite[ndx].sHeight DIV 2;
        radius:=item[ndxitem].radius;
        p2r (curr+fpole,radius, dx,dy);
        wleft := icx -ofsx - INTEGER(dx);
        wtop  := icy -ofsy + INTEGER(dy);
        IF drawme THEN
	        doSprite(wleft,wtop, ndx, usevesa);
     	ELSE
	        doSprite(wleft,wtop, ndxSpriteeraser, usevesa);
    	END;
        curr:=curr+delta;
        IF curr >= last THEN EXIT; END;
    END;
END drawarc360;

(* ------------------------------------------------------------ *)

TYPE
    hmszType = RECORD
        hh,mm,ss,hsecs:CARDINAL;
    END;
CONST
    clock1 = 1;
    clock2 = 2;
VAR
    prevclock,currclock:CARDINAL;
    hmsz : ARRAY[clock1..clock2] OF hmszType;

CONST
    minring           = 0;
    countringsHMS     = 2;
    countringsHMSdate = 5;
    countringsplus    = 2;
    countrings        = countringsHMSdate+countringsplus; (* 7 *)

(* out of proc because done once at init *)
VAR
    ring : ARRAY [minring..countrings-1] OF CARDINAL;
    firstring,lastring:CARDINAL;

PROCEDURE getmarkparms (VAR ink,inkinfo,ndxmark,ndxsmallmark:CARDINAL;
                       altmarks:BOOLEAN;
                       mm,colorEven,colorOdd,colorEvenInfo,colorOddInfo:CARDINAL);
BEGIN
    IF ODD(mm) THEN
        ink     := colorOdd;
        inkinfo := colorOddInfo;
        ndxsmallmark:= ndxSpritesmallmarkOdd;
        IF altmarks THEN
            ndxmark := ndxSpritemarkOddCustom;
        ELSE
            ndxmark := ndxSpritemarkOdd;
        END;
    ELSE
        ink     := colorEven;
        inkinfo := colorEvenInfo;
        ndxsmallmark:= ndxSpritesmallmarkEven;
        IF altmarks THEN
            ndxmark := ndxSpritemarkEvenCustom;
        ELSE
            ndxmark := ndxSpritemarkEven;
        END;
    END;
END getmarkparms;

PROCEDURE fixhsecs ( hsecs:CARDINAL  ):CARDINAL;
CONST
    shifthsecs = 3; (* force a cleaner position DIV 8 then MUL 8 *)
    clearbits  = 0F8H; (* 11111000 *)
BEGIN
    (* hsecs:= ( hsecs >> shifthsecs) << shifthsecs); *)
    RETURN (hsecs AND clearbits);
END fixhsecs;

PROCEDURE doDisplay (init,
              usevesa,altmarks,reverseInnerOuter,audioticks,dosync,
              transitionHH,showdivisions,showmarks,showdatetrail,palrot:BOOLEAN;
              infomode,modeSS,modeHHMM,timefmt,datefmt,circlesmode,
              colorEven,colorOdd,colorEvenInfo,colorOddInfo,paper:CARDINAL);
CONST
    rsafe               = 1; (* pixels *)
    rsafetyModeX        = heSprite (* + heSprite DIV 4*) ;
    rsafetyVESA         = heSprite + heSprite DIV 2;
    flSmallDelta        = LONGREAL(1.0);
    FLtotalMonthsInYear = LONGREAL(12.0);
VAR
    i,m,ndx,ink,inkinfo,ndxmark,ndxsmallmark:CARDINAL;
    enabled,fullredraw,doit,rt:BOOLEAN;
    hh,mm,ss,hsecs:CARDINAL;
    prevhh,prevmm,prevss,prevhsecs:CARDINAL;
    day,month,year:CARDINAL;
    dow:Lib.DayType; (* 0=sunday *)
    maxval,currval,fracday,fracmois,fracmonth,deltadot,deltatrail:LONGREAL;
    radius:CARDINAL;
    eraseme:ARRAY[firstitem..lastitemJMA] OF BOOLEAN;
    drawme:ARRAY[firstitem..lastitemJMA] OF BOOLEAN;
    rK,rKalt,rKter,radSS,radMM,radHH:CARDINAL;
    radDiM,radMiY,radDiY:CARDINAL; (* 31 365 *)
    totalDaysInMonth,totalMonthsInYear,totalDaysInYear,elapsedDays:CARDINAL;
    rsafety:CARDINAL;
BEGIN
    IF init THEN (* init *)
        IF NOT(usevesa) THEN
            SET_DISPLAY_FONT (FarADR(smallFontAPPLE[firstdatasmall]),0);
            SET_DISPLAY_FONT (FarADR(smallFontAPPLE[middatasmall]),1);
        END;

        (* kludge required to be able to use c_black which is also transparent c_nil *)
        SET_DAC_REGISTER (myblack, 0,0,0);

        initDrawInfos();
        initTrigo();
        IF usevesa THEN
            rsafety := rsafetyVESA;
        ELSE
            rsafety := rsafetyModeX;
        END;
        rK     := (heSprite + rsafety) DIV 2;
        radSS  := cy - rK ;
        rKalt  := rK + ( rK DIV 2 );
        rKter  := rK - ( rK DIV 4 );

        IF circlesmode=circlesAll THEN DEC(radSS,rsafe); END; (* fix possible artifact *)

        CASE circlesmode OF
        | circlesNone:
            radMM    := radSS - rK;
            radHH    := radMM - rK;
            radDiM   := radHH - rK;
            radMiY   := radDiM- rK;
            radDiY   := radMiY- rK;
        ELSE                               (* was -rK-rK *)
            radMM    := radSS - rKalt;
            radHH    := radMM - rKalt;
            radDiM   := radHH - rKalt;
            radMiY   := radDiM- rKalt;
            radDiY   := radMiY- rKalt;
        END;
                                           (* was -rK *)
        ring[minring+1] := radSS - rKter;
        ring[minring+2] := radMM - rKter;

        ring[minring+3] := radHH - rKter;
        ring[minring+4] := radDiM- rKter;
        ring[minring+5] := radMiY- rKter;

        ring[minring  ] := radSS +rKter;
        ring[minring+6] := radDiY-rKter;


        firstring := minring+1;
        IF showdatetrail THEN
            lastring := firstring+countringsHMSdate-1;
        ELSE
            lastring := firstring+countringsHMS-1;
        END;
        IF circlesmode = circlesAll THEN
            DEC(firstring);
            INC(lastring);
        END;

        (* safety in case resolution would not allow all circles *)
        FOR i:=firstring TO lastring DO
            IF ring[i] > cy THEN ring[i]:=rsafe; END;
        END;

        IF reverseInnerOuter THEN
            IF showdatetrail THEN
                swap(radSS  ,  radDiY );
                swap(radMM  ,  radMiY );
                swap(radHH  ,  radDiM );
            ELSE
                swap(radSS  ,  radHH  );
            END;
        END;
        currclock:=clock1;
        prevclock:=clock2;

        Lib.GetTime( hh,mm,ss,hsecs);
        getmarkparms (ink,inkinfo,ndxmark,ndxsmallmark,
                     altmarks,mm,colorEven,colorOdd,colorEvenInfo,colorOddInfo);

        hmsz[currclock].hh:=hh;
        hmsz[currclock].mm:=mm;
        hmsz[currclock].ss:=ss;
        hmsz[currclock].hsecs:=fixhsecs(hsecs);

        hmsz[prevclock]:=hmsz[currclock];

        FOR i:=firstitem TO lastitem DO
            enabled:=TRUE;
            CASE i OF
            | itemSS: m         := modeSS;
                      deltadot  := FLssPer360;
                      deltatrail:= flSmallDelta;
                      radius    := radSS;
                      ndx       := ndxSpriteSS;
                      rt        := FALSE;
            | itemMM: m         := modeHHMM;
                      deltadot  := FLmmPer360;
                      deltatrail:= flSmallDelta;
                      radius    := radMM;
                      ndx       := ndxSpriteMM;
                      rt        := FALSE;
            | itemHH: m         := modeHHMM;
                      deltadot  := FLhhPer360;
                      deltatrail:= flSmallDelta;
                      radius    := radHH;
                      ndx       := ndxSpriteHH;
                      rt        := transitionHH;
            END;
            item[i].showmode   :=m;
            item[i].deltadot   :=deltadot;
            item[i].deltatrail :=deltatrail;
            item[i].radiusint  :=radius;
            item[i].radius     :=LONGREAL(radius);
            item[i].ndxsprite  :=ndx;
            item[i].transition :=rt;
            item[i].what       :=i;
            item[i].prevorgalf := fl000;
            item[i].enabled    :=enabled;
        END;
        IF showdatetrail THEN (* showdatetrail *)
            Lib.GetDate(year,month,day,dow);
            fracday   := (LONGREAL(hh) + LONGREAL(mm)/flMinutesPerHour) / flHoursPerDay;
            fracmonth := LONGREAL(day) + fracday;

            totalDaysInMonth:= getDaysInMonth(month,year);
            totalMonthsInYear:=getMonthsInYear(year);
            totalDaysInYear := getDaysInYear(year);
            elapsedDays     := getDaysFromJan1st(day,month,year);

            fracmois   := LONGREAL(month-1)+LONGREAL(day)/LONGREAL(totalDaysInMonth);
            fracmois   := LONGREAL(month);

            m          := modeTrail;
            deltatrail := flSmallDelta;
            rt         := FALSE;
            enabled    := showdatetrail;

            FOR i:=firstitemJMA TO lastitemJMA DO
                CASE i OF
                | itemDayInMonth:
                      maxval    := LONGREAL(totalDaysInMonth);
                      currval   := fracmonth;
                      radius    := radDiM;
                      ndx       := ndxSpriteDayInMonth;
                | itemMonthInYear:
                      maxval    := LONGREAL(totalMonthsInYear);
                      currval   := fracmois;
                      radius    := radMiY;
                      ndx       := ndxSpriteMonthInYear;
                | itemDayInYear:
                      maxval    := LONGREAL(totalDaysInYear);
                      currval   := LONGREAL(elapsedDays)+fracday;
                      radius    := radDiY;
                      ndx       := ndxSpriteDayInYear;
                END;
                item[i].maxval     := maxval;
                item[i].currval    := currval;
                item[i].prevval    := currval;
                item[i].lastval    := fl000;
                item[i].showmode   := m;
                item[i].deltadot   := deltatrail; (* won't be used *)
                item[i].deltatrail := deltatrail;
                item[i].radiusint  := radius;
                item[i].radius     := LONGREAL(radius);
                item[i].ndxsprite  := ndx;
                item[i].transition := rt;
                item[i].what       := i;
                item[i].prevorgalf := fl000;
                item[i].enabled    := enabled;
            END;
        ELSE (* not showdatetrail *)
            FOR i:=firstitemJMA TO lastitemJMA DO
                item[i].enabled := FALSE;
            END;
        END; (* we're done with showdatetrail or not *)

        drawmarks (cx,cy,radSS,ink,ndxmark,ndxsmallmark, showdivisions,showmarks,usevesa); (* was router+rK *)

        FOR i:=firstitem TO lastitem DO
            drawarc (i,hh,mm,ss,hsecs,TRUE,FALSE,usevesa);
        END;
        FOR i:=firstitemJMA TO lastitemJMA DO
            drawarc360 (i, TRUE, FALSE,usevesa); (* auto handling of showdatetrail *)
        END;
        FOR i:=firstitem TO lastitem DO
            drawdot (i,hh,mm,ss,hsecs,TRUE,usevesa);
        END;

    ELSE (* not init *)

        CASE infomode OF
        | infosDate,infosDateTime: Lib.GetDate(year,month,day,dow);
        END;
        Lib.GetTime(hh,mm,ss,hsecs);
        getmarkparms (ink,inkinfo,ndxmark,ndxsmallmark,
                      altmarks,mm,colorEven,colorOdd,colorEvenInfo,colorOddInfo);

        hmsz[currclock].hh   :=hh;
        hmsz[currclock].mm   :=mm;
        hmsz[currclock].ss   :=ss;
        hmsz[currclock].hsecs:=fixhsecs( hsecs);

    END; (* we're done with init or not *)

    prevhh   :=hmsz[prevclock].hh;
    prevmm   :=hmsz[prevclock].mm;
    prevss   :=hmsz[prevclock].ss;
    prevhsecs:=hmsz[prevclock].hsecs;

    FOR i:=firstitem TO lastitem DO
        CASE i OF
        | itemSS : doit:=(ss # prevss); fullredraw:=(ss < prevss);
        | itemMM : doit:=(mm # prevmm); fullredraw:=(mm < prevmm);
        | itemHH : IF item[i].transition THEN
                       doit:=(mm # prevmm);
                   ELSE
                       doit:=(hh # prevhh);
                   END;
                   fullredraw:= (hh < prevhh);
        END;
        eraseme[i]:= doit AND (item[i].showmode = modeNormal);
        drawme [i]:= doit;
        IF item[i].showmode # modeNormal THEN
            IF fullredraw THEN
                drawarc (i,hh,mm,ss,hsecs,FALSE,TRUE,usevesa);
                IF i = itemSS THEN
                    drawmarks (cx,cy,item[i].radiusint,ink,ndxmark,ndxsmallmark,showdivisions,showmarks,usevesa); (* was router+rK *)
                END;
            ELSE
                drawarc (i,hh,mm,ss,hsecs,TRUE,FALSE,usevesa);
            END;
        END;
    END;
    IF showdatetrail THEN
        FOR i:=firstitemJMA TO lastitemJMA DO
            doit:=(mm # prevmm);
            eraseme[i]:=doit;
            drawme [i]:=doit;
            IF drawme[i] THEN
                Lib.GetDate(year,month,day,dow);
                fracday   := (LONGREAL(hh) + LONGREAL(mm)/flMinutesPerHour) / flHoursPerDay;
                fracmonth := LONGREAL(day) + fracday;

                totalDaysInMonth := getDaysInMonth(month,year);
                totalMonthsInYear:= getMonthsInYear(year);
                totalDaysInYear  := getDaysInYear(year);
                elapsedDays      := getDaysFromJan1st(day,month,year);

                fracmois  := LONGREAL(month-1)+LONGREAL(day)/LONGREAL(totalDaysInMonth);
                fracmois  := LONGREAL(month);

                CASE i OF
                | itemDayInMonth : currval:=fracmonth;
                | itemMonthInYear: currval:=fracmois;
                | itemDayInYear:   currval:=LONGREAL(elapsedDays)+fracday;
                END;
                fullredraw := ( currval < item[i].prevval ); (* //FIXME : take ABS(delta) < epsilon ? *)
                IF fullredraw THEN
                    drawarc360 (i, FALSE, TRUE,usevesa); (* auto handling of showdatetrail *)
                END;
                item[i].prevval:=item[i].currval;
                item[i].currval:=currval;
                drawarc360 (i, TRUE, FALSE,usevesa); (* auto handling of showdatetrail *)
            END;
        END;
    END;

    IF circlesmode # circlesNone THEN
        FOR i:=firstring TO lastring DO
            doCircle (cx,cy,ring[i],ink,usevesa);
        END;
    END;

    drawInfos (cx,cy,inkinfo,paper, hh,mm,ss,hsecs,day,month,year,
              infomode,timefmt,datefmt,usevesa); (* autoerasing older data *)

    FOR i:=firstitem TO lastitem DO
        IF eraseme[i] THEN
            drawdot (i,prevhh,prevmm,prevss,prevhsecs,FALSE,usevesa);
        END;
    END;

    IF ( drawme[itemSS] AND eraseme[itemSS] ) THEN
        drawmarks (cx,cy,item[itemSS].radiusint,ink,ndxmark,ndxsmallmark,showdivisions,showmarks,usevesa); (* was router+rK *)
    END;

    FOR i:=firstitem TO lastitem DO
        IF drawme[i] THEN drawdot (i,hh,mm,ss,hsecs,TRUE,usevesa); END;
    END;

    IF ss # prevss THEN
        IF audioticks THEN Lib.Sound(111);Lib.Delay(1);Lib.NoSound;END;
        (* IF palrot THEN rotatepalette(2);END; *)
    END;

    IF mm # prevmm THEN
        IF palrot THEN rotatepalette(1);END;
    END;

    swap(currclock,prevclock);
END doDisplay;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstParm = 1;
    maxParm   = 1;
VAR
    parm : ARRAY [firstParm..maxParm] OF str128;
    lastparm:CARDINAL;
    S,R:str128;
    i,v,opt,parmcount:CARDINAL;
VAR
    colorEven,colorOdd,colorEvenInfo,colorOddInfo:CARDINAL;
    vmode:CARDINAL;
    abortonclick,internalsprites,buffered:BOOLEAN;
    altmarks,reverseInnerOuter,audioticks,showdatetrail:BOOLEAN;
    dosync,transitionHH,showdivisions,showmarks,palrot:BOOLEAN;
    infomode,modeSS,modeHHMM,timefmt,datefmt,circlesmode:CARDINAL;
    paper,videoMode:CARDINAL;
    DEBUG,usevesa,modex,flipmode:BOOLEAN;
    sMode:str16;
    palette:palettetype;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck:=FALSE;
    WrLn;               (* ok here *)

    vmode              := firstvmode;
    abortonclick       := FALSE;
    internalsprites    := FALSE;
    buffered           := TRUE;
    infomode           := infosNone;
    altmarks           := FALSE;
    reverseInnerOuter  := FALSE;
    audioticks         := FALSE;
    transitionHH       := FALSE;
    showdivisions      := FALSE;
    showmarks          := TRUE;
    showdatetrail      := FALSE;
    circlesmode        := circlesDefault;
    modeSS             := modeNormal;
    modeHHMM           := modeNormal;
    dosync             := TRUE;
    paper              := c_BLACK;
    palette            := defaultpal;
    palrot             := TRUE;
    timefmt            := timeColon;
    datefmt            := datePlainFRA;
    DEBUG              := FALSE;

    lastparm           := firstParm-1;

    parmcount := Lib.ParamCount();
    (* IF parmcount=0 THEN abort(errHelp,""); END; *)

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "!"+delim+"GENDAT"+delim+
                                  "V:"+delim+"VIDEO:"+delim+
                                  "M"+delim+"MOUSE"+delim+"CLICK"+delim+
                                  "X"+delim+"INTERNAL"+delim+
                                  "F"+delim+"NOFLIP"+delim+
                                  "I:"+delim+"INFOS:"+delim+
                                  "C"+delim+"ALTERNATE"+delim+
                                  "R"+delim+"REVERSE"+delim+
                                  "A"+delim+"AUDIO"+delim+"TICKS"+delim+
                                  "T"+delim+"TRANSITION"+delim+
                                  "S:"+delim+"MODESS"+delim+
                                  "M:"+delim+"MODEHHMM"+delim+
                                  "W"+delim+"RETRACE"+delim+
                                  "K:"+delim+"PAPER:"+delim+
                                  "T:"+delim+"TIME:"+delim+
                                  "D:"+delim+"DATE:"+delim+
                                  "E"+delim+"EACH"+delim+"DIVISIONS"+delim+
                                  "C:"+delim+"CIRCLES:"+delim+
                                  "Z"+delim+"NOMARKS"+delim+
                                  "A:"+delim+"MODEHHMMSS:"+delim+
                                  "Y"+delim+"DOTS"+delim+
                                  "YY"+delim+"TRAILS"+delim+
                                  "YYY"+delim+"TRAILZ"+delim+"ALLTRAILS"+delim+
                                  "$$"+delim+
                                  "$"+delim+
                                  "P:"+delim+"PAL:"+delim+"PALETTE:"+delim+
                                  "P"+delim+"ROTATE"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            | 1,2,3  : abort(errHelp,"");
            | 4,5    : v:= initSpriteData (TRUE,paper,
                                          internalsprites,colorEven,colorOdd,
                                          colorEvenInfo,colorOddInfo);
                       abort(errNone,"");
            | 6,7    : IF getCard(R,v)=FALSE THEN abort(errBadVal,S);END;
                       CASE v OF
                       | firstvmode..lastvmode : vmode:=v;
                       ELSE abort(errBadVideoMode,S);
                       END;
            | 8,9,10 : abortonclick:=TRUE;
            | 11,12  : internalsprites:=TRUE;
            | 13,14  : buffered:=FALSE;
            | 15,16  : IF getCard(R,v)=FALSE THEN abort(errBadVal,S);END;
                       CASE v OF
                       | infosNone,infosTime,infosDate,infosDateTime:
                            infomode:=v;
                       ELSE abort(errBadInfoMode,S);
                       END;
            | 17,18  : altmarks:=TRUE;
            | 19,20  : reverseInnerOuter:=TRUE;
            | 21,22,23:audioticks:=TRUE;
            | 24,25:   transitionHH:=TRUE;
            | 26,27:   IF getCard(R,v)=FALSE THEN abort(errBadVal,S);END;
                       CASE v OF
                       | modeNormal,modeDots,modeTrail : modeSS:=v;
                       ELSE abort(errBadModeSS,S);
                       END;
            | 28,29:   IF getCard(R,v)=FALSE THEN abort(errBadVal,S);END;
                       CASE v OF
                       | modeNormal,modeDots,modeTrail : modeHHMM:=v;
                       ELSE abort(errBadModeHHMM,S);
                       END;
            | 30,31:   dosync := FALSE;
            | 32,33:   IF getCard(R,v)=FALSE THEN abort(errBadVal,S);END;
                       CASE v OF
                       | c_BLACK..c_bWHITE : paper:=v;
                       ELSE abort(errBadPaper,S);
                       END;
            | 34,35:   IF getCard(R,v)=FALSE THEN abort(errBadVal,S);END;
                       CASE v OF
                       | timeColon,timeHMS : timefmt:=v;
                       ELSE abort(errBadTimeFmt,S);
                       END;
            | 36,37:   IF getCard(R,v)=FALSE THEN abort(errBadVal,S);END;
                       CASE v OF
                       | datePlainFRA,dateAbrevFRA,
                         dateNumFRA,dateNumUSA,
                         datePlainUSA,dateAbrevUSA : datefmt:=v;
                       ELSE abort(errBadDateFmt,S);
                       END;
            | 38,39,40:showdivisions:=TRUE;
            | 41,42:   IF getCard(R,v)=FALSE THEN abort(errBadVal,S);END;
                       CASE v OF
                       | circlesDefault,circlesAll,circlesNone: circlesmode:=v;
                       ELSE abort(errBadCirclesMode,S);
                       END;
            | 43,44:   showmarks:=FALSE;
            | 45,46:   IF getCard(R,v)=FALSE THEN abort(errBadVal,S);END;
                       CASE v OF
                       | modeNormal,modeDots,modeTrail : modeHHMM:=v; modeSS:=v;
                       ELSE abort(errBadModeHHMMSS,S);
                       END;
            | 47,48:   modeHHMM:=modeDots;  modeSS:=modeDots;
            | 49,50:   modeHHMM:=modeTrail; modeSS:=modeTrail;
            | 51,52,53:modeHHMM:=modeTrail; modeSS:=modeTrail; showdatetrail:=TRUE;
            | 54:      modeHHMM:=modeTrail; modeSS:=modeTrail; showdatetrail:=TRUE;
                       infomode:=infosDateTime;
                       circlesmode:=circlesNone;
                       showdivisions:=TRUE;
                       palette:=greenpal;
                       vmode:=vesamode640x480;
            | 55:      modeHHMM:=modeTrail; modeSS:=modeTrail;
                       infomode:=infosDateTime;
                       circlesmode:=circlesNone;
                       showdivisions:=TRUE;
                       palette:=greenpal;
                       vmode:=vesamode640x480;
            | 56,57,58:IF getCard(R,v)=FALSE THEN abort(errBadVal,S);END;
                       CASE v OF
                       | firstpal..lastpal : palette:=palettetype(v);
                       ELSE abort(errBadPalette,S);
                       END;
            | 59,60:   palrot:= FALSE;
            | 61:      DEBUG := TRUE;
            ELSE
                       abort(errOption,S);
            END;
        ELSE
            abort(errParameter,S);
            (*
            INC(lastparm);
            IF lastparm > maxParm THEN abort(errParameter,S);END;
            Str.Copy(parm[lastparm],R);
            *)
        END;
    END;

    (* here, we could abort telling user about aesthetics *)
    IF modeHHMM=modeDots THEN transitionHH:=FALSE; END;

    IF abortonclick THEN abortonclick:= ( MsMouse.Reset() # MAX(INTEGER) );END;
    i:= initSpriteData  (FALSE,paper,
                        internalsprites,colorEven,colorOdd,colorEvenInfo,colorOddInfo);
    IF i # errNone THEN abort(i,"");END;

    v:=HiresON (vmode,paper,dosync,buffered,
               usevesa,modex,flipmode,videoMode,sMode);
    IF v # vrcNone THEN HiresOFF();END;
    CASE v OF
    | vrcNone: ;
    | vrcNoVesaBios:          abort(errNoVesaBios,"");
    | vrcVesaModeNotAvailable:abort(errVesaModeNotAvailable,sMode);
    | vrcVesaAbout :          abort(errVesaAbout,"");
    | vrcCannotSetVesaMode :  abort(errCannotSetVesaMode,sMode);
    | vrcVesaBank:            abort(errVesaBank,"");
    | vrcVesaGranularity :    abort(errVesaGranularity,"");
    | vrcCannotSetModeX:      abort(errCannotSetModeX,sMode);
    ELSE
                              abort(errImpossibleHiresPb,"");
    END;

    savepalette();
    newpalette(palette);

    flushKeyboard();

    doDisplay (TRUE,
              usevesa,altmarks,reverseInnerOuter,audioticks,dosync,
              transitionHH,showdivisions,showmarks,showdatetrail,palrot,
              infomode,modeSS,modeHHMM,timefmt,datefmt,circlesmode,
              colorEven,colorOdd,colorEvenInfo,colorOddInfo,paper);

    LOOP
        IF dosync THEN SYNC_DISPLAY(); END;
        IF flipmode THEN
            COPY_PAGE(gWorkpage,gViewpage); (* brutal update the Q&D way *)
            swapviewwork();
        END;

        doDisplay (FALSE,
                  usevesa,altmarks,reverseInnerOuter,audioticks,dosync,
                  transitionHH,showdivisions,showmarks,showdatetrail,palrot,
                  infomode,modeSS,modeHHMM,timefmt,datefmt,circlesmode,
                  colorEven,colorOdd,colorEvenInfo,colorOddInfo,paper);

        IF getKeyboardCode(i) THEN
            CASE i OF
            | keyTAB :
                IF ORD(palette) = lastpal THEN
                    palette:=palettetype(firstpal);
                ELSE
                    INC(palette);
                END;
                newpalette(palette);
            | keyTABshift:
                IF ORD(palette) = firstpal THEN
                    palette:=palettetype(lastpal);
                ELSE
                    DEC(palette);
                END;
                newpalette(palette);
            | upperP,lowerP:
                IF DEBUG THEN showpalette(usevesa); END;
            | upperO,lowerO:
                IF DEBUG THEN showmemento(usevesa,showdatetrail);END;
            | upperI,lowerI:
                IF DEBUG THEN rotatepalette(1);END;
            ELSE
                EXIT;
            END;
        END;
        IF mouseclicked(abortonclick) THEN EXIT; END;
    END;

    HiresOFF();

    abort(errNone,"");
END dClock.

(*

stamp 31/12/2009 23:59:55
dclock /debug /$$
stamp /r

stamp 15/6/2009 23:59:55
dclock /debug /$$
stamp /r

stamp 31/12/2009 23:59:55
dclock /debug /$
stamp /r

stamp 15/6/2009 23:59:55
dclock /debug /$
stamp /r

stamp 31/12/2009 18:45:55
dclock /debug /$$
stamp /r

stamp 15/6/2009 18:45:55
dclock /debug /$$
stamp /r

stamp 31/12/2009 18:45:55
dclock /debug /$
stamp /r

stamp 15/6/2009 18:45:55
dclock /debug /$
stamp /r

*)

