(* ---------------------------------------------------------------
Title         Q&D Gematria
Overview      see help
Usage         see help
Notes         very, very, very quick & dirty... :-(
              v1.0c = "isl342" then "dynamic pool limit" !
              it's madness ! NOT cured BY just importing used functions !
              can be cured by removing stdini1 and stdini2
              OR by creating a segment name FOR PROCEDURE now including constant strings
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE Gematria;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT Storage;
IMPORT IO;

FROM IO IMPORT WrStr, WrLn,WrCard,WrLngCard;

FROM QD_ASCII IMPORT dash, slash, nullchar, tabchar, cr, lf, nl, bs,
space, dot, deg, doublequote, quote, colon, percent, vbar,
blank, equal, dquote, charnull, singlequote, antislash, dollar,
star, backslash, coma, question, underscore, tabul, hbar,
comma, semicolon, diese, pound, openbracket, closebracket, tilde, exclam,
stardotstar, dotdot, escCh, escSet, letters, digits;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits, metaproc, getCli, argc, argv;

(* ------------------------------------------------------------ *)

CONST
    tab         = CHR(9);
    alphanum    = letters+digits;
CONST
    sectionmarker  = ":::";
    sectionpattern = sectionmarker+"*"+sectionmarker+"*";
    setpattern     = "[*]";
    strpattern     = '"*"';
TYPE
    casifyleveltype = (notdefined,nochange,
                      lcaseNoAccents,lcaseWithAccents,
                      ucaseNoAccents,ucaseWithAccents);


CONST
    ProgEXEname   = "GEMATRIA";
    ProgTitle     = "Q&D Gematria";
    ProgVersion   = "v1.0c";
    ProgCopyright = "par PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    extEXE = ".EXE"; (* upper CASE *)
    extDAT = ".DAT";
    extLOG = ".LOG";
    extBAK = ".BAK";
CONST
    errNone           = 0;
    errHelp           = 1;
    errOption         = 2;
    errParameter      = 3;
    errNotFound       = 4;
    errTooManyMatches = 5;
    errNoMatch        = 6;
    errEmpty          = 7;
    errRoom           = 8;
    errFormat         = 9;
    errWhere          = 10;
    errRedefined      = 11;
    errCasify         = 12;
    errCmd            = 13;
    errRO             = 14;
    errSyntax         = 15;
    errFmt            = 16;
    errAborted        = 17;
    errCrash          = 18;
    errMoreHelp       = 128;

(* ------------------------------------------------------------ *)


CONST
    msgMoreHelp = nl+
"(* Format du fichier "+ProgEXEname+extDAT+" *)"+nl+
nl+
'Une ligne commenant par ";" ou "#" sera ignore.'+nl+
nl+
'En-tte : "::: nom ::: [description]"'+nl+
"Entre  : caractre, chane ou ensemble, puis sparateur, puis formule."+nl+
nl+
'Les guillemets signalent une chane de caractres (exemple : "ch").'+nl+
"Les crochets signalent un ensemble de caractres (exemple : [ij])."+nl+
'Le suffixe "*" signale une chane  chercher en dbut de mot (exemple : "ch*").'+nl+
'Le prfixe "*" signale une chane  chercher en fin de mot (exemple : "*s").'+nl+
nl+
"L'option -r respecte l'ordre des dfinitions sans les rorganiser."+nl+
"En droite logique, l'ordre devrait tre : chanes  chercher en dbut de mot,"+nl+
"chanes  chercher en fin de mot, puis chanes verbatim"+nl+
"(les chanes tant numres par ordre de longueur dans chaque catgorie)."+nl+
nl+
"Les codes utilisables vont de 32  255,"+nl+
'mais "*", "[" et "]" devraient tre vits.'+nl+
nl+
"Sans l'option -k"+', le programme convertit les codes "" et "" en "ae" et "AE".'+nl+
"L'option -v prserve les signes diacritiques (accents et cdille)."+nl+
"L'option -vv prserve les signes diacritiques et la casse."+nl+
"L'option -u convertit les textes en haut de casse sans signes diacritiques."+nl+
"L'option -uu convertit les textes en haut de casse avec signes diacritiques."+nl+
nl+
'Dans une formule, "%" correspond au code ASCII de la lettre.'+nl+
'Dans une formule, "!" correspond au code ASCII de la lettre en haut de casse.'+nl+
'Dans une formule, "" correspond au code ASCII de la lettre en bas de casse.'+nl+
'Dans une formule, "$?" correspond au code ASCII de la lettre qui suit.'+nl+
"L'option -f vite aux formules d'tre converties comme les textes."+nl+
nl+
"Les rsultats seront conformes au degr d'attention prt aux options ! ;-)"+nl;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);

    MODULE message;
    IMPORT Str;
    EXPORT msg3;

    PROCEDURE msg3 (VAR R:ARRAY OF CHAR;S1,S2,S3:ARRAY OF CHAR);
    BEGIN
        Str.Concat(R,S1,S2);Str.Append(R,S3);
    END msg3;

    END message;

CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp= Banner+nl+
nl+
"Syntaxe : "+ProgEXEname+" <table> [fichier(s)] [option]..."+nl+
nl+
"Ce programme calcule des valeurs numrologiques  partir de lignes"+nl+
"extraites d'un fichier, ou saisies au clavier."+nl+
nl+
"-l[l] afficher la liste des tables (-ll = ne pas afficher les commentaires)"+nl+
"-t    afficher une table (option recommande pour tout diagnostic !)"+nl+
"-u[u] convertir les textes en haut de casse (-uu = avec signes diacritiques)"+nl+
"-v[v] mode verbatim respectant les signes diacritiques (-vv = signes et casse)"+nl+
"-s    afficher la rduction du rsultat  l'intervalle [0..9]"+nl+
"-a    slectionner l'ancienne prsentation"+nl+
"-x    slectionner la prsentation sur une seule ligne (-e automatique)"+nl+
"-e    ne pas afficher les tapes intermdiaires"+nl+
"-r    ne pas rorganiser la table"+nl+
"-d    autoriser les redfinitions"+nl+
"-f    ne pas convertir les formules"+nl+
'-k    ne pas convertir "" et "" en "ae" et "AE"'+nl+
"-n    ne pas ajouter la session interactive au fichier journal "+ProgEXEname+extLOG+nl+
"-g    crer un fichier "+ProgEXEname+extDAT+" standard dans le rpertoire en cours"+nl+
"-y    raccourci pour -s -u -d"+nl+
"-??   afficher un cran d'aide plus dtaill"+nl+
nl+
"a) Les tables figurent dans le fichier "+ProgEXEname+extDAT+nl+
"   (recherch dans le rpertoire en cours puis dans celui de l'excutable)."+nl+
"b) Le programme exploite le jeu ASCII PC, et non le jeu Windows OEM."+nl+
"c) Par dfaut, le programme convertit les donnes vers l'ensemble [a..z0..9]."+nl+
'd) En droite "logique"'+", le recours  l'option -u devrait tre systmatique. ;-)"+nl+
"e) Attention ! Seuls les caractres dfinis sont pris en compte."+nl+
"f) Le programme traitera jusqu' 1000 fichiers."+nl+
"g) Les options dnues de sens avec une commande sont ignores."+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msgHelp);
    | errMoreHelp:
        WrStr(msgHelp);
        WrStr(msgMoreHelp);
        e := errHelp;
    | errOption :
        msg3(S,'Option "',einfo,'" inconnue !');
    | errParameter :
        msg3(S,'Paramtre "',einfo,'" inutile !');
    | errNotFound:
        msg3(S,'Le fichier "',einfo,'" est introuvable !');
    | errTooManyMatches:
        msg3(S,'Trop de fichiers correspondent  "',einfo,'" !');
    | errNoMatch:
        msg3(S,'Aucun fichier ne correspond  "',einfo,'" !');
    | errEmpty:
        msg3(S,'La section "',einfo,'" est vide !');
    | errRoom  :
        msg3(S,'Trop de lignes dans la table"',einfo,'" !');
    | errFormat:
        msg3(S,'Erreur dans la ligne "',einfo,'" !');
    | errWhere:
        msg3(S,'La section "',einfo,'" est introuvable !');
    | errRedefined:
        msg3(S,'La ligne "',einfo,'" contient une redfinition !');
    | errCasify:
        S:="Les options -v[v] et -u[u] s'excluent mutuellement !";
    | errCmd:
        S:="Les options -l, -t et -g s'excluent mutuellement !";
    | errRO:
        msg3(S,'Le fichier "',einfo,'" est protg contre'+" l'effacement !");
    | errSyntax:
        msg3(S,"Syntaxe incorecte pour l'option ",einfo," !");
    | errFmt:
        S:="Les options -a et -x s'excluent mutuellement !";
    | errAborted:
        S:="Excution interrompue par l'utilisateur !";
    | errCrash:
        msg3(S,'Problme dans la procdure "',einfo,'" !');
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp : ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE fixAEall(VAR S:ARRAY OF CHAR);
CONST
    lcAE = CHR(145); lcAEnew = "ae";
    ucAE = CHR(146); ucAEnew = "AE";
VAR
    i : CARDINAL;
    c:CHAR;snew:str16;
BEGIN
    FOR i := 1 TO 2 DO
        CASE i OF
        | 1 : c:=lcAE; snew:=lcAEnew;
        | 2 : c:=ucAE; snew:=ucAEnew;
        END;
        LOOP
            IF Str.CharPos(S,c)=MAX(CARDINAL) THEN EXIT; END;
            Str.Subst(S,c,snew);
        END;
    END;
END fixAEall;

PROCEDURE wrq (S:ARRAY OF CHAR);
BEGIN
    WrStr(doublequote);WrStr(S);WrStr(doublequote);
END wrq;

PROCEDURE pad (wi:INTEGER;padchar:CHAR; VAR R:ARRAY OF CHAR);
VAR
    i:CARDINAL;
BEGIN
    FOR i:=Str.Length(R)+1 TO ABS(wi) DO
        IF wi < 0 THEN
            Str.Append(R,padchar);
        ELSE
            Str.Prepend(R,padchar);
        END;
    END;
END pad;

(* ------------------------------------------------------------ *)

CONST
    firstfile = 1;
    maxfile   = 1000;
VAR
    filename  : ARRAY [firstfile..maxfile] OF str16;

PROCEDURE readMatching(spec:ARRAY OF CHAR;VAR lastfile:CARDINAL);
VAR
    found : BOOLEAN;
    entry : FIO.DirEntry;
BEGIN
    lastfile := firstfile-1;
    found := FIO.ReadFirstEntry(spec,allfiles,entry);
    WHILE found DO
        INC(lastfile);
        IF lastfile > maxfile THEN RETURN;END;
        Str.Copy(filename[lastfile],entry.Name);
        found := FIO.ReadNextEntry(entry);
    END;
END readMatching;

(* fix common cases  : "." -- "*\" -- "\*.*" *)

PROCEDURE fixdirspec (VAR R : ARRAY OF CHAR  );
VAR
    len : CARDINAL;
BEGIN
    len := Str.Length(R);
    IF len = 0 THEN RETURN; END; (* no risk ! *)
    IF same(R,dot) THEN Str.Copy(R,stardotstar); RETURN; END;        (* "." becomes "*.*" *)
    IF R[len-1]=backslash THEN Str.Append(R,stardotstar);RETURN;END; (* "*\" becomes "*\*.*" *)
END fixdirspec;

PROCEDURE buildbase (spec:ARRAY OF CHAR;VAR base:ARRAY OF CHAR);
VAR
    u,d,f8,e3 : str128; (* oversized just in CASE -- e3 include dot ! *)
BEGIN
    Lib.SplitAllPath(spec,u,d,f8,e3);
    Lib.MakeAllPath(base,u,d,"","");
END buildbase;

PROCEDURE buildFile (e3: ARRAY OF CHAR;VAR path,f8e3:ARRAY OF CHAR);
VAR
    exe,u,d,n,e:str128;
    p:CARDINAL;
BEGIN
    Lib.ParamStr(exe,0);
    p:=Str.CharPos(exe,dot);
    exe[p]:=0C;
    Str.Append(exe,e3);
    Lib.SplitAllPath(exe,u,d,n,e);
    Lib.MakeAllPath(path,u,d,"","");
    Lib.MakeAllPath(f8e3,"","",n,e);
END buildFile;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
VAR
    inBuffer,outBuffer : ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
TYPE
    modetype  = (initial,final,verbatim); (* order DOES matter : by priority ! internal was removed *)
    seqentrytype = RECORD
        seq   : str80;
        value : LONGINT;
        ischar: BOOLEAN;
        len   : CARDINAL;
        mode  : modetype;
    END;
CONST
    firstseq  = 1;
    maxseq    = 500; (* should do *)
VAR
    seqentry  : ARRAY [firstseq..maxseq] OF seqentrytype;

(* ------------------------------------------------------------ *)

PROCEDURE doSwapSeq (i,j:CARDINAL);
VAR
    tmp : seqentrytype;
BEGIN
    tmp        :=seqentry[i];
    seqentry[i]:=seqentry[j];
    seqentry[j]:=tmp;
END doSwapSeq;

TYPE
    whattype = (bylen,byalpha,byvalue,bymode);

PROCEDURE bubblesort (last: CARDINAL;what:whattype);
VAR
    ok,swapped : BOOLEAN;
    i,j : CARDINAL;
BEGIN
    IF last=firstseq THEN RETURN; END;
    REPEAT
        swapped := FALSE;
        FOR i := firstseq TO (last-1) DO
            j:=i+1;
            CASE what OF
            | byalpha:ok:= (Str.Compare(seqentry[i].seq,seqentry[j].seq) > 0);
            | byvalue:ok:= (seqentry[i].value < seqentry[j].value);
            | bylen:  ok:= (seqentry[i].len < seqentry[j].len);
            | bymode: ok:= (ORD(seqentry[i].mode) > ORD(seqentry[j].mode));
            END;
            IF ok THEN doSwapSeq(i,j); swapped := TRUE; END;
        END;
    UNTIL swapped=FALSE;
END bubblesort;

(* mode(initial,final,verbatim), length, valeur, ascii *)

PROCEDURE sortGlossary (last:CARDINAL  );
BEGIN
    (* Lib.QSort(last,isLess,doSwapSeq); *)

    bubblesort(last,byalpha );
    (* bubblesort(last,byvalue ); *)
    bubblesort(last,bylen );
    bubblesort(last,bymode );
END sortGlossary;

(* ------------------------------------------------------------ *)

PROCEDURE showGlossarySections (showrem:BOOLEAN; ini:ARRAY OF CHAR);
VAR
    S:str256;
    hin:FIO.File;
    n,p : CARDINAL;
    id  : str128;
BEGIN
    WrStr("Tables disponibles dans le fichier ");WrStr(ini);WrLn;
    WrLn;
    hin:=FIO.OpenRead(ini);
    FIO.AssignBuffer(hin,inBuffer);
    n:=0;
    LOOP
        IF FIO.EOF THEN EXIT;END;
        FIO.RdStr(hin,S);
        IF Str.Match(S,sectionpattern) THEN
            Str.Subst(S,sectionmarker,"");
            p:=Str.Pos(S,sectionmarker);
            Str.Slice(id,S,0,p-1);
            Str.Delete(S,0,p-1);
            Str.Subst(S,sectionmarker,"");
            LtrimBlanks(id);
            RtrimBlanks(id);
            LtrimBlanks(S);
            RtrimBlanks(S);
            (* IO.WrCard(n+1,3);WrStr(" : "); *)
            WrStr(id);
            IF showrem THEN
                IF same(S,"")=FALSE THEN WrStr(" ; ");WrStr(S);END;
            END;
            WrLn;
            INC(n);
        END;
    END;
    FIO.Close(hin);
    IF n=0 THEN WrStr("Aucune !");WrLn;END;
END showGlossarySections;

CONST
    wimode      = 2+8;
    wivalue     = 2+7;
    msgText     = "Texte     : ";
    msgRaw      = "Avant     : ";
    msgCooked   = "Aprs     : ";
    msgBar      = "==========="+"========="; (* +wivalue i.e. +2+7 *)
    msgResult   = "Valeur    :";             (* yes, no space *)
    msgHeader   = "          =";             (* idem *)

PROCEDURE showGlossary (sorted:BOOLEAN;last:CARDINAL;section:ARRAY OF CHAR );
CONST
    windx    = 3;
    wiischar = 2+9;
VAR
    i : CARDINAL;
    S : str128;
BEGIN
    IF sorted THEN
        S:="Table $ (dfinitions rorganises par le programme)";
    ELSE
        S:="Table $ (dfinitions dans l'ordre original)";
    END;
    Str.Subst(S,"$",section);
    WrStr(S);WrLn;
    WrLn;
    WrStr("ndx");
    S:="type";    pad(wiischar," ",S);WrStr(S);
    S:="position";pad(wimode," ",S);WrStr(S);
    S:="valeur";  pad(wivalue," ",S);WrStr(S);
    S:="  squence";WrStr(S);WrLn;
    WrLn;

    FOR i:=firstseq TO last DO
        IO.WrCard(i,windx);
        CASE seqentry[i].ischar OF
        | TRUE:  S:="caractre";
        | FALSE: S:="   chane";
        END;
        pad(wiischar," ",S);WrStr(S);
        CASE seqentry[i].mode OF
        | verbatim: S:="verbatim";
        | initial:  S:="au dbut";
        | final:    S:=" la fin";
        END;
        pad(wimode," ",S);WrStr(S);
        IO.WrLngInt(seqentry[i].value,wivalue);
        WrStr("  ");WrStr('"');WrStr(seqentry[i].seq);WrStr('"');WrLn;
    END;
END showGlossary;

(* ------------------------------------------------------------ *)

TYPE
    tokenType = (number,
                 add, sub, mul, divi,
                 leftParen, rightParen,
                 done);

    treeType = POINTER TO treeRecordType;

    treeRecordType = RECORD
        CASE kind:tokenType OF
        | number :
            numberValue : LONGINT;
        | add,sub,mul,divi :
            left  : treeType;
            right : treeType;
        END;
    END;

    syntacticType = (init, expr, term, factor);

VAR
    globerk          : CARDINAL;
    globcli          : str128;
    globndx          : CARDINAL;
    globc            : CHAR;
    globtoken        : tokenType;
    globtokenNumberValue : LONGINT;

PROCEDURE getchar (  ):CHAR ;
BEGIN
    INC(globndx);
    RETURN globcli[globndx-1];
END getchar;

PROCEDURE readtoken;
VAR
    S:str128;
    i:CARDINAL;
    ok:BOOLEAN;
    oldc:CHAR;
BEGIN
    LOOP
        oldc := globc;
        globc := getchar();
        CASE oldc OF
        | ' ' : ;
        | '+' : globtoken := add; EXIT;
        | '-' : globtoken := sub; EXIT;
        | '*' : globtoken := mul; EXIT;
        | '/' : globtoken := divi;EXIT;
        | '(' : globtoken := leftParen; EXIT;
        | ')' : globtoken := rightParen; EXIT;
        | CHR(0), CHR(10),CHR(13),CHR(26) : globtoken := done; EXIT;
        | '0'..'9' :
            S[0] := oldc;
            i := 1;
            WHILE (globc >= '0') AND (globc <= '9') DO
                S[i] := globc;
                INC(i);
                globc := getchar();
            END;
            S[i] := CHR(0);
            globtokenNumberValue := Str.StrToInt(S, 10,ok);
            IF NOT (ok) THEN INC(globerk); END;
            globtoken := number;
            EXIT;
        ELSE
            INC(globerk);
        END;
    END;
END readtoken;

PROCEDURE parse(what:syntacticType):treeType;
VAR
    t,t1:treeType;
BEGIN
    CASE what OF
    | factor :
        IF globtoken = leftParen THEN
            readtoken;
            t := parse(expr);
            IF globtoken = rightParen THEN
                readtoken;
            ELSE
                INC(globerk);
            END;
        ELSIF globtoken = number THEN
            Storage.ALLOCATE(t, SIZE(t^));
            t^.kind := number;
            t^.numberValue := globtokenNumberValue;
            readtoken;
        ELSE
            INC(globerk);
        END;
    | term:
        t := parse(factor);
        WHILE (globtoken = mul) OR (globtoken = divi) DO
            t1 := t;
            Storage.ALLOCATE(t, SIZE(t^));
            t^.kind := globtoken;
            readtoken;
            t^.left := t1;
            t^.right := parse(factor);
        END;
    | expr:
        t := parse(term);
        WHILE (globtoken = add) OR (globtoken = sub) DO
            t1 := t;
            Storage.ALLOCATE(t, SIZE(t^));
            t^.kind := globtoken;
            readtoken;
            t^.left := t1;
            t^.right := parse(term);
        END;
    | init:
        globerk:= 0;
        globndx:= 0;
        globc := getchar();
        readtoken;
        t := parse(expr);
        IF (globtoken # done) THEN
            INC(globerk);
        END;
     END;
     RETURN t;
END parse;

PROCEDURE eval(t:treeType):LONGINT;
BEGIN
    CASE t^.kind OF
    | number : RETURN t^.numberValue;
    | add    : RETURN eval(t^.left) + eval(t^.right);
    | sub    : RETURN eval(t^.left) - eval(t^.right);
    | mul    : RETURN eval(t^.left) * eval(t^.right);
    | divi   : RETURN eval(t^.left) DIV eval(t^.right);
    ELSE
        abort(errCrash,"eval()");
    END;
END eval;

PROCEDURE evalint (S:ARRAY OF CHAR):LONGINT;
VAR
    result:LONGINT;
    t:treeType;
BEGIN
    Str.Copy(globcli,S);
    t := parse(init);
    result := eval(t);
    IF globerk # 0 THEN result:=MAX(LONGINT);END;
    RETURN result;
END evalint;

(* ------------------------------------------------------------ *)

PROCEDURE redefined (last:CARDINAL):BOOLEAN ;
VAR
    i:CARDINAL;
BEGIN
    FOR i:=firstseq TO (last-1) DO
        IF same(seqentry[i].seq,seqentry[last].seq) THEN
            IF seqentry[i].ischar=seqentry[last].ischar THEN
                IF seqentry[i].mode=seqentry[last].mode THEN RETURN TRUE;END;
            END;
        END;
    END;
    RETURN FALSE;
END redefined;

PROCEDURE chToStr (ch:CHAR;VAR R : ARRAY OF CHAR);
VAR
    ok:BOOLEAN;
BEGIN
    Str.CardToStr( LONGCARD(ORD(ch)),R,10,ok);
END chToStr;

CONST
    pb = MAX(CARDINAL);

PROCEDURE seqstore (last:CARDINAL;seq,formula:ARRAY OF CHAR):BOOLEAN;
CONST
    asciime     ="%";
    asciimeupper="!";
    asciimelower="";
    ascii       ="$";
VAR
    CC,V:str16;
    len,p : CARDINAL;
    num:LONGINT;
    m:modetype;
    ch:CHAR;
BEGIN
    len:=Str.Length(seq);
    m:=verbatim;
    IF len > 1 THEN
        p:=Str.CharPos(seq,"*");
        IF p=0 THEN
            m := final;
            Str.Delete(seq,0,1);
(*
            p:=Str.RCharPos(seq,"*"); (* from right now *)
            IF p=(len-1) THEN
                m:=internal;
                seq[p]:=0C;
                Str.Delete(seq,0,1);
            ELSE
                m:=initial;
                Str.Delete(seq,0,1);
            END;
*)
        ELSIF p=(len-1) THEN
            m := initial;
            seq[p]:=0C;
        END;
    END;
    seqentry[last].mode := m;

    len:=Str.Length(seq); (* may have changed *)
    IF len=0 THEN RETURN FALSE;END;
    FOR p:=1 TO len DO
        CASE seq[p-1] OF
        | CHR(0)..CHR(ORD(blank)-1) : RETURN FALSE;
        END;
    END;
    seqentry[last].len := len;

    Str.Copy(seqentry[last].seq,seq);
    seqentry[last].ischar   := ( len=1 );
    IF seqentry[last].ischar THEN
        (* replace "%" with seq asc code *)
        ch:=seq[0];
        chToStr(ch,V);
        LOOP
            IF Str.CharPos(formula,asciime)=MAX(CARDINAL) THEN EXIT; END;
            Str.Subst(formula,asciime,V);
        END;
        (* replace "!" with seq asc code *)
        ch:=seq[0];UpperCaseAlt(ch);
        chToStr(ch,V);
        LOOP
            IF Str.CharPos(formula,asciimeupper)=MAX(CARDINAL) THEN EXIT; END;
            Str.Subst(formula,asciimeupper,V);
        END;

        (* replace "" with seq asc code *)
        ch:=seq[0];LowerCaseAlt(ch);
        chToStr(ch,V);
        LOOP
            IF Str.CharPos(formula,asciimelower)=MAX(CARDINAL) THEN EXIT; END;
            Str.Subst(formula,asciimelower,V);
        END;
    ELSE
        ;
    END;

    (* replace $? with char asc code *)
    LOOP
        p:=Str.CharPos(formula,ascii);
        IF p=MAX(CARDINAL) THEN EXIT; END;
        Str.Concat(CC,ascii,formula[p+1]);
        IF Str.Length(CC)=2 THEN
            chToStr(formula[p+1],V);
            Str.Subst(formula,CC,V);
        END;
    END;
    IF formula[0]="-" THEN Str.Prepend(formula,"0");END; (* parser does not like direct negative numbers ! *)
    num:=evalint(formula);
    IF num = MAX(LONGINT) THEN RETURN FALSE; END;
    seqentry[last].value := num;
    RETURN TRUE;
END seqstore;

(* section was uppercased when parsing command line *)

PROCEDURE readGlossary (allowredefine,fixAEcode,fixformulae:BOOLEAN; casifylevel:casifyleveltype;
                       ini,section:ARRAY OF CHAR;
                       VAR errcode:CARDINAL;VAR einfo:ARRAY OF CHAR):CARDINAL;
VAR
    last:CARDINAL;
    hin:FIO.File;
    S:str256;
    p,len:CARDINAL;
    state:(searching,grabbing);
    seq,str:str128;
    charmode,ok:BOOLEAN;
BEGIN
    hin:=FIO.OpenRead(ini);
    FIO.AssignBuffer(hin,inBuffer);
    state := searching;
    last  := firstseq-1;
    LOOP
        IF FIO.EOF THEN EXIT;END;
        FIO.RdStr(hin,S);
        LtrimBlanks(S);
        RtrimBlanks(S);
        Str.Copy(einfo,S);
        CASE S[0] OF
        | ";","#",0C :
            ok:=FALSE;
        ELSE
            ok:=TRUE;
        END;
        IF ok THEN
            CASE state OF
            | searching:
                IF Str.Match(S,sectionpattern) THEN
                    Str.Subst(S,sectionmarker,"");
                    p:=Str.Pos(S,sectionmarker);
                    S[p]:=0C;
                    LtrimBlanks(S);
                    RtrimBlanks(S);
                    UpperCase(S);
                    IF same(S,section) THEN state:=grabbing;END; (* section is already UpperCaseD *)
                END;
            | grabbing:
                IF Str.Match(S,sectionpattern) THEN EXIT; END;
                argv(seq, S, 1, TRUE);
                Str.Subst(S,seq,"");

                IF fixAEcode THEN fixAEall(seq); END;
                CASE casifylevel OF
                | lcaseNoAccents   :LowerCase(seq);
                | lcaseWithAccents: LowerCaseAlt(seq);
                | ucaseNoAccents:   UpperCase(seq);
                | ucaseWithAccents: UpperCaseAlt(seq);
                | nochange: ;
                END;

                LtrimBlanks(S);
                RtrimBlanks(S);
              IF fixformulae THEN
                CASE casifylevel OF
                | lcaseNoAccents   :LowerCase(S);
                | lcaseWithAccents: LowerCaseAlt(S);
                | ucaseNoAccents:   UpperCase(S);
                | ucaseWithAccents: UpperCaseAlt(S);
                | nochange: ;
                END;
              END;

                IF Str.Match(seq,strpattern) THEN
                    ReplaceChar(seq,doublequote,"");
                END;
                IF Str.Match(seq,setpattern) THEN
                    ReplaceChar(seq,"[","");
                    ReplaceChar(seq,"]","");
                    len:=Str.Length(seq);
                    charmode:=TRUE;
                ELSE
                    len:=1;
                    charmode:=FALSE;
                END;
                FOR p:=1 TO len DO
                    INC(last);
                    IF last > maxseq THEN
                        errcode:=errRoom;
                        Str.Copy(einfo,section);
                        FIO.Close(hin);
                        RETURN pb;
                    END;
                    IF charmode THEN
                        Str.Copy(str,seq[p-1]);
                    ELSE
                        Str.Copy(str,seq);
                    END;
                    IF seqstore(last,str,S)=FALSE THEN
                        errcode:=errFormat;
                        FIO.Close(hin);
                        RETURN pb;
                    END;
                    IF NOT(allowredefine) THEN
                        IF redefined(last) THEN
                            errcode:=errRedefined;
                            FIO.Close(hin);
                            RETURN pb;
                        END;
                    END;
                END;
            END;
        END;
    END;
    FIO.Close(hin);
    IF state=searching THEN
        errcode:=errWhere;
        Str.Copy(einfo,section);
        RETURN pb;
    ELSE
        CASE last OF
        | firstseq-1:
            errcode:=errEmpty;
            Str.Copy(einfo,section);
            RETURN pb;
        ELSE
            RETURN last;
        END;
    END;
END readGlossary;

(* ------------------------------------------------------------ *)

(*#save *)
(*#call (seg_name=>glocode) *)

PROCEDURE createDefaultGlossary (ini:ARRAY OF CHAR);
CONST
    stdini1 =
nl+
'::: COMBAS ::: trange mthode "Pierre de Combas" (voir Sol Invictus, p. 347)'+nl+
nl+
'; deux bizarreries : X et Y sont ignors, et "Pierre de Combas" donne 147'+nl+
'; au lieu de 144 (sauf  intervertir les valeurs des "s" au dbut et en fin)'+nl+
nl+
'"sch"   21'+nl+
'"sh"    21'+nl+
'"th"    22'+nl+
'"ph"    17'+nl+
'"ch"    11'+nl+
'"ou"    16'+nl+
'a       1'+nl+
'b       2'+nl+
'g       3'+nl+
'd       4'+nl+
'e       5'+nl+
'[vw]    6'+nl+
'z       7'+nl+
'h       8'+nl+
't       9'+nl+
'[ij]    10'+nl+
'c       11'+nl+
'l       12'+nl+
'm       13'+nl+
'n       14'+nl+
'[ou]    16'+nl+
'[pf]    17'+nl+
'[qk]    19'+nl+
'r       20'+nl+
'; s en dbut ou fin de mot, ou au milieu (autrement dit : verbatim)'+nl+
'; erreur dans Sol Invictus ? s* = 18 et *s = 15, ce qui donne bien 144 ?'+nl+
's*      15'+nl+
'*s      18'+nl+
's       18'+nl+
'[xy]    0'+nl+
nl+
"::: RANG ::: rang dans l'alphabet (A=1, B=2, etc.)"+nl+
nl+
'[ABCDEFGHIJKLMNOPQRSTUVWXYZ]    %-$a+1'+nl+
nl+
"::: INVERSERANG ::: rang invers dans l'alphabet (A=26, B=25, etc.)"+nl+
nl+
'[ABCDEFGHIJKLMNOPQRSTUVWXYZ]    $z-%+1'+nl+
nl+
"::: SIX ::: formule : (rang dans l'alphabet * 6) (A=6, B=12, etc.)"+nl+
nl+
'[ABCDEFGHIJKLMNOPQRSTUVWXYZ]    ((%-$a+1)*6)'+nl+
nl+
"::: NEUF ::: formule : (rang dans l'alphabet * 9) (A=9, B=18, etc.)"+nl+
nl+
'[ABCDEFGHIJKLMNOPQRSTUVWXYZ]    ((%-$a+1)*9)'+nl+
nl+
'::: ASCII ::: code ASCII PC respectant la casse'+nl+
nl+
'[ABCDEFGHIJKLMNOPQRSTUVWXYZ]    %'+nl+
nl+
'::: ASCIIHDC ::: code ASCII PC haut de casse ("A"=65, "B"=66, etc.)'+nl+
nl+
'[ABCDEFGHIJKLMNOPQRSTUVWXYZ]    !'+nl+
nl+
'::: ASCIIBDC ::: code ASCII PC bas de casse ("a"=97, "b"=98, etc.)'+nl+
nl+
'[ABCDEFGHIJKLMNOPQRSTUVWXYZ]    '+nl+
nl+
'::: HEBRAISANT ::: why not ? ;-) mthode BFI'+nl+
nl+
'a	1'+nl+
'b	2'+nl+
'c	3'+nl+
'd	4'+nl+
'e	5'+nl+
'f	6'+nl+
'g	7'+nl+
'h	8'+nl+
'i	9'+nl+
'j	10'+nl+
'k	20'+nl+
'l	30'+nl+
'm	40'+nl+
'n	50'+nl+
'o	60'+nl+
'p	70'+nl+
'q	80'+nl+
'r	90'+nl+
's	100'+nl+
't	200'+nl+
'u	300'+nl+
'v	400'+nl+
'w	500'+nl+
'x	600'+nl+
'y	700'+nl+
'z	800'+nl+
nl+
'::: HEBRAIQUE ::: why not too ? ;-) mthode Q&D'+nl+
nl+
'[abcdefghi]		(%-$a)+1'+nl+
'[jklmnopqr]		((%-$j)+1)*10'+nl+
'[stuvwxyz]		((%-$s)+1)*100'+nl+
nl+
'::: TESTSIX :::'+nl+
nl+
'[ABCDEFGHIJKLMNOPQRSTUVWXYZ]    ((%-$A+1)*6)'+nl+
'[abcdefghijklmnopqrstuvwxyz]    ((%-$a+1)*6)'+nl+
nl+
'::: BASCOM ::: COMBAS dans le dsordre (test de rorganisation)'+nl+
nl+
'"sh"    21'+nl+
's*      15'+nl+
'"th"    22'+nl+
'"ph"    17'+nl+
'"ch"    11'+nl+
'[ij]    10'+nl+
'"ou"    16'+nl+
'a       1'+nl+
'b       2'+nl+
'g       3'+nl+
'*s      18'+nl+
'd       4'+nl+
'e       5'+nl+
'[vw]    6'+nl+
'z       7'+nl+
'"sch"   21'+nl+
'h       8'+nl+
't       9'+nl+
'c       11'+nl+
'l       12'+nl+
'm       13'+nl+
'n       14'+nl+
'[ou]    16'+nl+
'[pf]    17'+nl+
'[qk]    19'+nl+
'r       20'+nl+
'[xy]    0'+nl+
's       18'+nl+
nl+
'::: ALPHANUM ::: lettres et chiffres'+nl+
nl+
'"0"  48'+nl+
'"1"  49'+nl+
'"2"  50'+nl+
'"3"  51'+nl+
'"4"  52'+nl+
'"5"  53'+nl+
'"6"  54'+nl+
'"7"  55'+nl+
'"8"  56'+nl+
'"9"  57'+nl+
nl+
'"A"  65'+nl+
'"B"  66'+nl+
'"C"  67'+nl+
'"D"  68'+nl+
'"E"  69'+nl+
'"F"  70'+nl+
'"G"  71'+nl+
'"H"  72'+nl+
'"I"  73'+nl+
'"J"  74'+nl+
'"K"  75'+nl+
'"L"  76'+nl+
'"M"  77'+nl+
'"N"  78'+nl+
'"O"  79'+nl+
'"P"  80'+nl+
'"Q"  81'+nl+
'"R"  82'+nl+
'"S"  83'+nl+
'"T"  84'+nl+
'"U"  85'+nl+
'"V"  86'+nl+
'"W"  87'+nl+
'"X"  88'+nl+
'"Y"  89'+nl+
'"Z"  90'+nl+
nl+
'"a"  97'+nl+
'"b"  98'+nl+
'"c"  99'+nl+
'"d"  100'+nl+
'"e"  101'+nl+
'"f"  102'+nl+
'"g"  103'+nl+
'"h"  104'+nl+
'"i"  105'+nl+
'"j"  106'+nl+
'"k"  107'+nl+
'"l"  108'+nl+
'"m"  109'+nl+
'"n"  110'+nl+
'"o"  111'+nl+
'"p"  112'+nl+
'"q"  113'+nl+
'"r"  114'+nl+
'"s"  115'+nl+
'"t"  116'+nl+
'"u"  117'+nl+
'"v"  118'+nl+
'"w"  119'+nl+
'"x"  120'+nl+
'"y"  121'+nl+
'"z"  122'+nl+
nl+
'""  128'+nl+
'""  129'+nl+
'""  130'+nl+
'""  131'+nl+
'""  132'+nl+
'""  133'+nl+
'""  134'+nl+
'""  135'+nl+
'""  136'+nl+
'""  137'+nl+
'""  138'+nl+
'""  139'+nl+
'""  140'+nl+
'""  141'+nl+
'""  142'+nl+
'""  143'+nl+
'""  144'+nl+
'""  145'+nl+
'""  146'+nl+
'""  147'+nl+
'""  148'+nl+
'""  149'+nl+
'""  150'+nl+
'""  151'+nl+
'""  152'+nl+
'""  153'+nl+
'""  154'+nl+
nl+
'""  160'+nl+
'""  161'+nl+
'""  162'+nl+
'""  163'+nl+
'""  164'+nl+
'""  165'+nl+
nl+
"::: STD ::: table standard (rang dans l'alphabet)"+nl+
nl+
'[ABCDEFGHIJKLMNOPQRSTUVWXYZ] %-$A+1'+nl+
'[abcdefghijklmnopqrstuvwxyz] %-$a+1'+nl+
'[]                    $A-$A+1'+nl+
'[]                      $E-$A+1'+nl+
'[]                       $I-$A+1'+nl+
'[]                      $O-$A+1'+nl+
'[]                      $U-$A+1'+nl+
'[]                          $Y-$A+1'+nl+
'[]                         $C-$A+1'+nl+
'[]                         $N-$A+1'+nl+
nl;


    stdini2 =
"::: CAGLIOSTRO ::: table de Cagliostro selon Colin Wilson"+nl+
nl+
"[aiqjy] 1"+nl+
"[bkr]   2"+nl+
"[cgls]  3"+nl+
"[dmt]   4"+nl+
"[ehn]   5"+nl+
"[uvwx]  6"+nl+
"[oz]    7"+nl+
"[fp]    8"+nl+
nl+
"::: WILSON ::: table de Cagliostro modernise selon Colin Wilson"+nl+
nl+
"[ajs]   1"+nl+
"[bkt]   2"+nl+
"[clu]   3"+nl+
"[dmv]   4"+nl+
"[enw]   5"+nl+
"[fox]   6"+nl+
"[gpy]   7"+nl+
"[hqz]   8"+nl+
"[ir]    9"+nl+
nl;

CONST
    lennl = 2;
VAR
    hout:FIO.File;
    R:str128;
    p,q:CARDINAL;
    sIni:ARRAY [0..8192-1] OF CHAR;
BEGIN
    Str.Concat(sIni, stdini1,stdini2); (* avoid nasty and weird "isl.args" quirk *)

    hout:=FIO.Create(ini);
    FIO.AssignBuffer(hout,outBuffer);
    p:=0;
    LOOP
        q:=Str.NextPos(msgMoreHelp,nl,p);
        IF q = MAX(CARDINAL) THEN EXIT; END;
        Str.Slice(R,msgMoreHelp,p,q-p+lennl);
        IF same(R,nl) THEN
            Str.Prepend(R,";");
        ELSE
            Str.Prepend(R,"; ");
        END;
        FIO.WrStr(hout,R);
        p:=q+lennl;
    END;
    FIO.WrStr(hout,";"+nl);

    p:=0;
    LOOP
        q:=Str.NextPos(sIni,nl,p);
        IF q = MAX(CARDINAL) THEN EXIT; END;
        Str.Slice(R,sIni,p,q-p+lennl);
        FIO.WrStr(hout,R);
        p:=q+lennl;
    END;

    FIO.Close(hout);
END createDefaultGlossary;
(*#restore *)

(* ------------------------------------------------------------ *)

PROCEDURE int2str (v:LONGINT;wi:INTEGER):str80;
VAR
    ok:BOOLEAN;
    S:str80;
BEGIN
    Str.IntToStr ( v, S, 10, ok);
    pad (wi," ",S);
    RETURN S;
END int2str;

PROCEDURE wri (hout:FIO.File;savelog,flagnl:BOOLEAN;S:ARRAY OF CHAR);
BEGIN
    WrStr(S); IF flagnl THEN WrLn;END;
    IF savelog THEN
        FIO.WrStr(hout,S);IF flagnl THEN FIO.WrLn(hout); END;
    END;
END wri;

(* allow older more verbose format *)

PROCEDURE showseq (oldformat,savelog:BOOLEAN;hout:FIO.File;i:CARDINAL);
VAR
    S : str128;
BEGIN
        Str.Concat(S,msgHeader,int2str(seqentry[i].value,wivalue));
        wri(hout,savelog,FALSE,S);

        IF oldformat THEN
            CASE seqentry[i].mode OF
            | verbatim: S:="verbatim";
            | initial:  S:="au dbut";
            | final:    S:=" la fin";
            END;
            pad(wimode," ",S);Str.Append(S,"  "+doublequote);
            Str.Append(S,seqentry[i].seq);Str.Append(S,doublequote);
        ELSE
            Str.Concat(S,"  "+doublequote,seqentry[i].seq);
            Str.Append(S,doublequote);
            CASE seqentry[i].mode OF
            | initial:  Str.Append(S,"  (au dbut)");
            | final:    Str.Append(S,"  ( la fin)");
            END;
        END;
        wri(hout,savelog,TRUE,S);
END showseq;

(* assume seqentry is sorted but try every possibility just in case ! *)
(* well, what about a word which is just a final sequence ? *)

PROCEDURE processWord (oneline,oldformat,showsteps,savelog:BOOLEAN;hout:FIO.File;
                      last:CARDINAL;S:ARRAY OF CHAR):LONGINT;
VAR
    i,p,len,seqlen,oldi,oldseqlen,ifinal : CARDINAL;
    m :modetype;
    ch:CHAR;
    sum:LONGINT;
    finalwashere:BOOLEAN;
BEGIN
    sum:=0;

    (* process initial *)

    oldseqlen:=0;
    i:=firstseq;
    LOOP
        IF seqentry[i].mode = initial THEN
            IF Str.Pos(S,seqentry[i].seq)=0 THEN
                seqlen:=seqentry[i].len;
                IF NOT(seqlen < oldseqlen) THEN
                    oldseqlen:=seqlen;
                    oldi:=i;
                END;
            END;
        END;
        INC(i);
        IF i > last THEN EXIT; END;
    END;
    IF oldseqlen # 0 THEN
        INC(sum,seqentry[oldi].value);
        Str.Delete(S,0,oldseqlen);
        IF showsteps THEN showseq(oldformat,savelog,hout,oldi);END;
    END;

    (* process final *)

    len:=Str.Length(S);
    oldseqlen:=0;
    i:=firstseq;
    LOOP
        IF seqentry[i].mode = final THEN
            seqlen:=seqentry[i].len;
            IF NOT (len < seqlen) THEN
                p:=len-seqlen+1-1;
                IF Str.NextPos(S,seqentry[i].seq,p)=p THEN
                    IF NOT(oldseqlen > seqlen) THEN
                        oldseqlen:=seqlen;
                        oldi:=i;
                    END;
                END;
            END;
        END;
        INC(i);
        IF i > last THEN EXIT; END;
    END;
    IF oldseqlen # 0 THEN
        INC(sum,seqentry[oldi].value);
        S[len-oldseqlen+1-1]:=0C;

        finalwashere:=TRUE;
        IF showsteps THEN ifinal:=oldi;END;
    ELSE
        finalwashere:=FALSE;
    END;

    (* process verbatim *)

    len:=Str.Length(S);
    p:=0;
    WHILE (p <= len) DO
        oldseqlen:=0;
        i:=firstseq;
        LOOP
            IF seqentry[i].mode = verbatim THEN
                seqlen:=seqentry[i].len;
                IF Str.NextPos(S,seqentry[i].seq,p)=p THEN
                    IF NOT(oldseqlen > seqlen) THEN
                        oldseqlen:=seqlen;
                        oldi:=i;
                    END;
                END;
            END;
            INC(i);
            IF i > last THEN EXIT; END;
        END;
        IF oldseqlen # 0 THEN
            INC(sum,seqentry[oldi].value);
            INC(p,oldseqlen);
            IF showsteps THEN showseq(oldformat,savelog,hout,oldi);END;
        ELSE
            INC(p); (* skip CHAR not found *)
        END;
    END;

    IF showsteps THEN
        IF finalwashere THEN showseq(oldformat,savelog,hout,ifinal);END;
    END;

    RETURN sum;
END processWord;

PROCEDURE process (casifylevel:casifyleveltype;
                  oneline,oldformat,showsteps,fixAEcode,reductio,savelog:BOOLEAN;
                  hout:FIO.File;last:CARDINAL;cli:ARRAY OF CHAR);
VAR
    zecli : str4096;
    S,R : str128;
    i   : CARDINAL;
    grandsum,currsum : LONGINT;
BEGIN
    IF oneline THEN
        Str.Concat(zecli,doublequote,cli);Str.Append(zecli,doublequote);
    ELSE
        wri(hout,savelog,TRUE,"");
    END;
    grandsum:=0;
    FOR i:=1 TO argc(cli,TRUE ) DO
        argv(S,  cli, i, TRUE);
        IF NOT(oneline) THEN
            IF oldformat THEN
                Str.Concat(R,msgRaw+doublequote,S);Str.Append(R,doublequote);
            ELSE
                Str.Concat(R,msgText+doublequote,S);Str.Append(R,doublequote);
            END;
            wri(hout,savelog,TRUE,R);
        END;
        IF fixAEcode THEN fixAEall(S); END;
        CASE casifylevel OF
        | lcaseNoAccents   : LowerCase(S);
        | lcaseWithAccents : LowerCaseAlt(S);
        | ucaseNoAccents:    UpperCase(S);
        | ucaseWithAccents:  UpperCaseAlt(S);
        | nochange : ;
        END;
        IF oldformat THEN
            Str.Concat(R,msgCooked+doublequote,S);Str.Append(R,doublequote);
            wri(hout,savelog,TRUE,R);
        END;
        INC( grandsum,processWord(oneline,oldformat,showsteps,savelog,hout,last,S) );
    END;
    IF reductio THEN
        currsum:=ABS(grandsum);
        LOOP
            Str.Copy(R,int2str(currsum,1));
            currsum:=0;
            FOR i:=1 TO Str.Length(R) DO
                INC(currsum, LONGINT( ORD(R[i-1])-ORD("0") ) );
            END;
            IF currsum < 10 THEN EXIT; END;
        END;
    END;
    IF oneline THEN
        Str.Prepend(zecli," : ");
        IF reductio THEN
            Str.Prepend(zecli,")");
            Str.Prepend(zecli,int2str(currsum,1)); (* 1..9 *)
            Str.Prepend(zecli," (");
        END;
        Str.Prepend(zecli,int2str(grandsum,wivalue));
        wri(hout,savelog,TRUE,zecli);
    ELSE
        (* wri(hout,savelog,TRUE,""); *)
        wri(hout,savelog,TRUE,msgBar);
        Str.Concat(R,msgResult,int2str(grandsum,wivalue));
        IF reductio THEN
            Str.Append(R,"  ("); (* yes, 2 spaces here *)
            Str.Append(R,int2str(currsum,1));
            Str.Append(R,")");
        END;
        wri(hout,savelog,TRUE, R);
        wri(hout,savelog,TRUE,"");
    END;
END process;

PROCEDURE procfile (casifylevel:casifyleveltype;
                   oneline,oldformat,showsteps,fixAEcode,reductio,savelog:BOOLEAN;
                   hout:FIO.File;last:CARDINAL;f:ARRAY OF CHAR):BOOLEAN;

VAR
    hin:FIO.File;
    S:str4096; (* better safe than sorry *)
    esc:BOOLEAN;
BEGIN
    WrStr("(* Fichier ");WrStr(f);WrStr(" *)");WrLn;
    WrLn;
    esc:=FALSE;
    FIO.EOF:=FALSE;
    hin:=FIO.OpenRead(f);
    FIO.AssignBuffer(hin,inBuffer);
    LOOP
        IF FIO.EOF THEN EXIT;END;
        FIO.RdStr(hin,S);
        LtrimBlanks(S);
        RtrimBlanks(S);
        IF same(S,"") = FALSE THEN
            process (casifylevel,oneline,oldformat,showsteps,fixAEcode,reductio,
                    savelog,hout,last,S);
        END;
        IF ChkEscape() THEN esc:=TRUE; EXIT;END;
    END;
    FIO.Close(hin);
    RETURN esc;
END procfile;

(* ------------------------------------------------------------ *)

PROCEDURE memento (casifylevel:casifyleveltype;
                  dosort,savelog:BOOLEAN;hout:FIO.File;glo:ARRAY OF CHAR);
CONST
    mark = "; ";
VAR
    S:str128;
BEGIN
    Str.Concat(S,"Donnes gnres avec la table ",glo);Str.Append(S,".");
    IF savelog THEN Str.Prepend(S,mark);END;
    wri(hout,savelog,TRUE,S);
    IF dosort THEN
        S:="Les dfinitions ont t rorganises par le programme.";
    ELSE
        S:="Les dfinitions sont dans leur ordre original.";
    END;
    IF savelog THEN Str.Prepend(S,mark);END;
    wri(hout,savelog,TRUE,S);

    CASE casifylevel OF
    | lcaseNoAccents:   S:="Casse indiffrente, signes diacritiques ignors.";
    | lcaseWithAccents: S:="Casse indiffrente, signes diacritiques conservs.";
    | nochange:         S:="Caractres traits verbatim.";
    | ucaseNoAccents:   S:="Caractres en haut de casse, signes diacritiques ignors.";
    | ucaseWithAccents: S:="Caractres en haut de casse, signes diacritiques conservs.";
    END;
    IF savelog THEN Str.Prepend(S,mark);END;
    wri(hout,savelog,TRUE,S);

    wri(hout,savelog,TRUE,"");
END memento;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

VAR
    hout:FIO.File;
    cmd:(nocmd,compute,listfull,list,test,create);
    showrem,savelog,fromfile,showsteps,dosort,allowredefine:BOOLEAN;
    oneline,oldformat,reductio,fixAEcode,fixformulae:BOOLEAN;
    casifylevel:casifyleveltype;
    state : (waiting,gotglo,gotspec);
    parmcount,i,opt:CARDINAL;
    S,R:str128;
    ini,log,glossary,spec,base:str128;
    lastfile,lastseq:CARDINAL;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    WrLn;

    cmd           := nocmd;
    casifylevel   := notdefined;
    savelog       := TRUE;
    showsteps     := TRUE;
    dosort        := TRUE;
    allowredefine := FALSE;
    fixAEcode     := TRUE;
    fixformulae   := TRUE;
    reductio      := FALSE;
    oldformat     := FALSE;
    oneline       := FALSE;

    state := waiting;
    parmcount := Lib.ParamCount();
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "??"+delim+
                                  "L"+delim+"LIST"+delim+
                                  "T"+delim+"SHOW"+delim+
                                  "V"+delim+"VERBATIM"+delim+
                                  "N"+delim+"NOSAVE"+delim+
                                  "LL"+delim+
                                  "VV"+delim+
                                  "E"+delim+"NOSTEPS"+delim+
                                  "R"+delim+"NOSORT"+delim+
                                  "D"+delim+"REDEFINED"+delim+
                                  "K"+delim+"NOFIXAE"+delim+
                                  "U"+delim+"UPPER"+delim+
                                  "UU"+delim+
                                  "F"+delim+"FORMULA"+delim+
                                  "S"+delim+"REDUCTIO"+delim+
                                  "A"+delim+"ALTERNATE"+delim+
                                  "G"+delim+"CREATE"+delim+
                                  "X"+delim+"ONELINE"+delim+
                                  "Y"
                                  );
            CASE opt OF
            | 1,2,3   : abort(errHelp,"");
            | 4       : abort(errMoreHelp,"");
            | 5,6     : CASE cmd OF
                        | nocmd,listfull: cmd := listfull;
                        ELSE abort(errCmd,""); END;
            | 7,8     : CASE cmd OF
                        | nocmd,test:     cmd := test;
                        ELSE abort(errCmd,""); END;
            | 9,10    : CASE casifylevel OF
                        | notdefined,lcaseWithAccents: casifylevel:=lcaseWithAccents;
                        ELSE abort(errCasify,""); END;
            | 11,12   : savelog   := FALSE;
            | 13      : CASE cmd OF
                        | nocmd,list:     cmd := list;
                        ELSE abort(errCmd,"");END;
            | 14      : CASE casifylevel OF
                        | notdefined,nochange:         casifylevel:=nochange;
                        ELSE abort(errCasify,""); END;
            | 15,16   : showsteps := FALSE;
            | 17,18   : dosort    := FALSE;
            | 19,20   : allowredefine:=TRUE;
            | 21,22   : fixAEcode := FALSE;
            | 23,24   : CASE casifylevel OF
                        | notdefined,ucaseNoAccents:   casifylevel:=ucaseNoAccents;
                        ELSE abort(errCasify,""); END;
            | 25      : CASE casifylevel OF
                        | notdefined,ucaseWithAccents: casifylevel:=ucaseWithAccents;
                        ELSE abort(errCasify,""); END;
            | 26,27   : fixformulae:=FALSE;
            | 28,29   : reductio:=TRUE;
            | 30,31   : oldformat:=TRUE;
            | 32,33   : CASE cmd OF
                        | nocmd,create:   cmd := create;
                        ELSE abort(errCmd,"");END;
            | 34,35   : oneline := TRUE;
            | 36      : allowredefine:=TRUE; (* -d *)
                        CASE casifylevel OF  (* -u *)
                        | notdefined,ucaseNoAccents:   casifylevel:=ucaseNoAccents;
                        ELSE abort(errCasify,""); END;
                        reductio:=TRUE;      (* -s *)
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE state OF
            | waiting : Str.Copy(glossary,R);
            | gotglo  : Str.Copy(spec,R);
            ELSE
                abort(errParameter,S);
            END;
            INC(state);
        END;
    END;

    CASE cmd OF
    | nocmd    : cmd := compute;
    | listfull : showrem := TRUE;  cmd:=list;
    | list     : showrem := FALSE;
    END;

    IF casifylevel = notdefined THEN casifylevel:=lcaseNoAccents;END;

    CASE state OF
    | waiting :
        CASE cmd OF
        | list,create :  ;
        | test:    abort(errSyntax,"-t");
        | compute: abort(errHelp,"");
        END;
    | gotglo  :
        CASE cmd OF
        | list:   abort(errSyntax,"-l[l]");
        | create: abort(errSyntax,"-g");
        | test: ;
        | compute:    fromfile:=FALSE;
        END;
    | gotspec :
        CASE cmd OF
        | list:   abort(errSyntax,"-l[l]");
        | create: abort(errSyntax,"-g");
        | test:   abort(errSyntax,"-t");
        | compute :   fromfile:=TRUE;
        END;
    END;

    buildFile(extDAT,S,ini);
    IF FIO.Exists(ini)=FALSE THEN
        Str.Prepend(ini,S);
        IF FIO.Exists(ini)=FALSE THEN
            IF cmd # create THEN abort(errNotFound,ini); END;
        END;
    END;

    CASE cmd OF
    | list:
        showGlossarySections(showrem,ini);
    | test:
        lastseq:=readGlossary(allowredefine,fixAEcode,fixformulae,casifylevel,ini,glossary, i,R);
        IF lastseq=pb THEN abort(i,R);END;
        memento(casifylevel,dosort,FALSE,FIO.StandardOutput,glossary);
        showGlossary(FALSE,lastseq,glossary);
        IF dosort THEN
            sortGlossary(lastseq);
            WrLn;
            showGlossary(TRUE,lastseq,glossary);
        END;
    | create:
        buildFile(extDAT,S,ini);
        IF FIO.Exists(ini) THEN
            buildFile(extBAK,S,R);
            IF FIO.Exists(R) THEN
                IF isReadOnly(R) THEN abort(errRO,R);END; (* yes, we could use setreadwrite... *)
                FIO.Erase(R);
            END;
            FIO.Rename(ini,R);
        END;
        createDefaultGlossary(ini);
        Str.Concat(S,"Le fichier ",ini);
        Str.Append(S," a t cr.");
        WrStr(S);WrLn;
    | compute:
        IF oneline THEN
            IF oldformat THEN abort(errFmt,"");END;
            showsteps := FALSE;
        END;
        lastseq:=readGlossary(allowredefine,fixAEcode,fixformulae,casifylevel,ini,glossary, i,R);
        IF lastseq=pb THEN abort(i,R);END;
        IF dosort THEN sortGlossary(lastseq); END;

        IF fromfile THEN
            fixdirspec(spec);
            readMatching(spec,lastfile);
            IF lastfile > maxfile THEN abort(errTooManyMatches,spec);END;
                   IF lastfile < firstfile THEN abort(errNoMatch,spec);END;
            buildbase(spec,base);

            savelog:=FALSE;
            hout:=FIO.StandardOutput;
            memento(casifylevel,dosort,savelog,hout,glossary);
            FOR i := firstfile TO lastfile DO
                Str.Concat(S,base,filename[i]);
                IF procfile (casifylevel,oneline,oldformat,showsteps,fixAEcode,reductio,
                            savelog,hout,lastseq,S) THEN abort(errAborted,"");END;
            END;
        ELSE
            IF savelog THEN
                buildFile(extLOG,S,log);
                IF FIO.Exists(log) THEN
                    hout:=FIO.Append(log);
                ELSE
                    hout:=FIO.Create(log);
                END;
                FIO.AssignBuffer(hout,outBuffer);
            ELSE
                hout:=FIO.StandardOutput; (* social-fascism or communism : pass it, don't use it *)
            END;
            memento(casifylevel,dosort,savelog,hout,glossary);

            LOOP

                WrStr("Texte ([$*]=fin) ? ");TerminalReadString(S);
                LtrimBlanks(S);
                RtrimBlanks(S);
                IF same(S,"*") THEN EXIT; END;
                IF same(S,"$") THEN EXIT; END;
                IF same(S,"")=FALSE THEN
                    IF oneline THEN WrLn;END; (* video only *)
                    process (casifylevel,oneline,oldformat,showsteps,fixAEcode,reductio,
                            savelog,hout,lastseq,S);
                    IF oneline THEN WrLn;END; (* video only *)
                END;
            END;
            IF savelog THEN
                FIO.Close(hout);
                WrLn;
                Str.Concat(S,"Le fichier journal ",log);
                Str.Append(S," a t mis  jour.");
                WrStr(S);WrLn;
            END;
        END;
    END;

    abort(errNone,"");
END Gematria.
