$if 0
---------------------------------------------------------------
Title         Q&D Iago
Author        PhG
Overview      Yet another useless weak Othello game...
Usage         IAGO
Notes         very, very minimal error checking
              assume normal color palette
              port of my old 1984, 1987 Apple ][ 6502 code
Bugs          very weak game... er, is it a bug or a feature ?
Wish List     add a log file for each game ?
              a text mode ?

---------------------------------------------------------------
$endif

$CPU            80286

$OPTIMIZE       SIZE
$COMPILE        EXE

$DEBUG MAP      OFF
$DEBUG PBDEBUG  OFF

$LIB COM        OFF
$LIB CGA        OFF
$LIB EGA        ON
$LIB VGA        OFF
$LIB HERC       OFF
$LIB LPT        OFF
$LIB IPRINT     OFF
$LIB FULLFLOAT  ON

$ERROR BOUNDS   Off
$ERROR NUMERIC  Off
$ERROR OVERFLOW Off
$ERROR STACK    Off

$FLOAT          PROCEDURE

$COM            0
$STRING         16
$STACK          8192 ' big stack for big local array in SUB
$SOUND          1

$DIM            ARRAY

$DYNAMIC

$OPTION         CNTLBREAK ON ' OFF in final EXE

'--------------------------------------------------------------------

DEFINT A-Z
OPTION ARRAY BASE 0
OPTION BINARY BASE 0

' %False = 0
' %True  = NOT %False

'--------------------------------------------------------------------
' external functions

$LINK       "PHGTOOLS.PBU"
$INCLUDE    "PHGTOOLS.DEF"

$LINK       "MODEX.PBL"
$INCLUDE    "MODEX.INC"

'--------------------------------------------------------------------
' internal functions

DECLARE SUB GetStrLoc() ' PowerBasic runtime library

SUB StdOut ( BYVAL Text AS STRING )
! push DS                    ; save DS FOR PowerBASIC
! push WORD Ptr Text         ; push STRING handle on stack
! CALL GetStrLoc
! jcxz ExitStdOut
! mov  DS, DX
! mov  DX, AX
! mov  AH, &H40              ; DOS WRITE TO file
! mov  BX, 1                 ; file handle 1 is CONS
! INT  &H21
ExitStdOut:
! pop  DS
END SUB

SUB StdOutLn( BYVAL s$ )
CALL StdOut (s$ + CHR$(13, 10) )
END SUB

'--------------------------------------------------------------------

%biggrid = %false ' true=10x10, false=8x8

'--------------------------------------------------------------------

%maxWidthSprite = 24
%maxHeightSprite= 24

%blackWinner = 0
%blackEqual  = 1
%blackLoser  = 2
%whiteWinner = 3
%whiteEqual  = 4
%whiteLoser  = 5
%grayCircle  = 6
%grayEmpty   = 7
%grayCheckered=8

%firstSprite = %blackWinner
%lastSprite  = %grayCheckered

TYPE SpriteType
    sData   AS STRING * %maxWidthSprite*%maxHeightSprite ' must be FIRST in structure
    sWidth  AS INTEGER
    sHeight AS INTEGER
END TYPE

%vtabtitle  = 1

$if %biggrid ' 360x400

%vtabmsg    = 48
%vtabstatus = 23
%htabplayer     = 1
%htabcomputer   = 39

$else ' 320x240

%vtabmsg    = 29
%vtabstatus = 14
%htabplayer     = 1
%htabcomputer   = 34

$endif

%title          = 1
%changeorplay   = 2
%helpchange     = 3
%whatcolor      = 4
%whostarts      = 5
%playerhelp     = 6
%computerthinking= 7
%playerpass     = 8
%computerpass   = 9
%docomputer     = 10
%playerwin      = 11
%computerwin    = 12
%nowinner       = 13
%again          = 14
%thinking       = 15

%firstMsg       = %title
%lastMsg        = %thinking

infos:
' *** = left, updown, right arrows
' $$  = left, right arrows
' !!  = Return

'     0         1         2         3
'     0....'....0....'....0....'....0....'....
data "Apple ][ Weak Othello by PhG 1984, 1987"
data "[!!]-play, [Space]-change board"
data "[***]-move, [!!]-cycle, [G]-go"
data "[!!]-player Red, [Space]-player Blue"
data "[!!]-player starts, [Space]-PC starts"
data "[$$]-move, [h|*]-hint, [!!]-play"
data "Please wait : computer fakes thinking !"
data "[!!]-player must pass !"
data "[!!]-computer must pass !"
data "[!!]-accept computer move
data "[!!]-you win the game !"
data "[!!]-computer wins the game !"
data "[!!]-no winner : it's a draw !"
data "[!!]-play again, [Esc]-exit to DOS"
data "Please wait : finding best move !"

'--------------------------------------------------------------------

$if %biggrid

%xcount = 10
%ycount = 10

$else

%xcount = 8
%ycount = 8

$endif

%xycount= %xcount * %ycount

%empty  = 0
%black  = 1
%white  = 2

'--------------------------------------------------------------------
' global

dim sprite(%firstsprite:%lastSprite) as shared spritetype

dim einfo as shared string
dim exename as shared string
dim banner as shared string
dim credit as shared string

dim board(1:%xcount,1:%ycount) as shared integer
dim tscore(1:%xcount,1:%ycount) as shared integer
dim blackcount      as shared integer
dim whitecount      as shared integer
dim playercolor     as shared integer
dim computercolor   as shared integer
dim playercount     as shared integer
dim computercount   as shared integer
dim ink             as shared integer
dim paper           as shared integer
dim msg(%firstMsg:%lastMsg) as shared string
dim confirm         as shared integer
dim audio           as shared integer
dim grafmode        as shared integer
dim mono			as shared integer

'--------------------------------------------------------------------
'
ON ERROR GOTO Abort

GOTO Start: ' jump to main() ;-)

'--------------------------------------------------------------------
' error handling

%eNone      = 100
%eHelp      = %eNone+1
%eBadOpt    = %eNone+2
%eBadParm   = %eNone+3
%eNeedVGA   = %eNone+4
%eCannotSet = %eNone+5
%eAborted   = %eNone+6

Abort:
if err=%eAborted then settextmode ' if we exit from graphics mode...
IF ERR = %eHelp THEN
    stdoutln ""
    stdoutln Banner$
    stdoutln ""
    stdoutln credit$
    stdoutln ""
$if %biggrid
    stdoutln "Yet another useless weak 10x10 Othello game..."
$else
    stdoutln "Yet another useless weak 8x8 Othello game..."
$endif
    stdoutln ""
    stdoutln "Syntax : "+ExeName$+" [-c] [-a] [-m]"
    stdoutln ""
    stdoutln "  -c confirm computer move with [Return]"
    stdoutln "  -a audio warning for computer move"
    stdoutln "  -m alternate color scheme"
    ' stdoutln "  -t text mode (not yet implemented : probably NeverWare)"
    stdoutln ""
    stdoutln "Note hints may vary, for identical scores are randomized."
END IF
SELECT CASE ERR
CASE %eBadOpt
    e$="Unknown "+einfo$+" option !"
CASE %eBadParm
    e$="Unknown "+einfo$+" parameter !"
case %eNeedVGA
    e$="VGA card required !"
case %eCannotSet
    e$="Cannot set required hires video mode !"
case %eAborted
    e$="Aborted by user !"

CASE ELSE
    e$=HEX$(ERADR) ' ERADR is a longint (7fFFffFF)
    e$=MID$("00000000",1,8-LEN(e$))+e$
    e$= "Error #"+MID$(STR$(ERR),2)+" at $"+e$+" !"
END SELECT
e$=exeName$+" : "+e$
IF err <> %eHelp AND err <> %eNone THEN
    stdoutln ""
    stdoutln e$
end if
END ERR-%eNone

sub printfile(byval s$)
hnd=freefile
open "a",#hnd,exename$+".log"
print #hnd,s$
close #hnd
end sub

'--------------------------------------------------------------------

FUNCTION IsVGA()
IF BIT (pbvScrnCard,5) = 0 THEN
    IsVGA = %False
ELSE
    IsVGA = %True
END IF
END FUNCTION

SUB WaitVGARetrace
!   mov dx,&h03DA
l1:
!   in al,dx
!   and al,&h08
!   jnz l1
l2:
!   in al,dx
!   and al,&h08
!   jz  l2
END SUB

%text = 0
%cga  = 2 ' 640x200 CGA

SUB setTextMode
CALL Set.Video.Mode (3)
SCREEN %cga ' reset width to 80
SCREEN %text
END SUB

$if %biggrid

%vmode  = %mode360x400
%xmax   = 360-1
%ymax   = 400-1

$else

%vmode  = %mode320x240 ' 1:1 aspect ratio
%xmax   = 320-1
%ymax   = 240-1

$endif

%xmin   = 0
%ymin   = 0

%page1          = 0
%PagesVirtual   = 1 ' request only one page

%xMaxVirtual    = %xmax+1
%yMaxVirtual    = %ymax+1

function setHiresMode()
IF Set.VGA.ModeX%(%vmode,%xMaxVirtual,%yMaxVirtual,%PagesVirtual) = 0 THEN
    rc=%false
else
    rc=%true
END IF
setHiresMode=rc
end function

%myBLACK = 255

' weird : reading %c.black does not work so use force kludge
sub fixPalette
CALL SET.DAC.REGISTER (%MyBLACK, 0,0,0) ' force 0,0,0 use this (c.black is c.nil)
end sub

sub ClearScreen(byval paper)
if paper = %c.BLACK THEN paper = %MyBLACK
CALL Clear.VGA.Screen (paper)
end sub

sub setViewWork (byval vpage, byval wpage)
CALL Set.Active.Page (wpage)
CALL Set.Display.Page(vpage)
end sub

%charWidth  =8
%charHeight =8

sub centerprint (byval y, byval s$, byval ink, byval paper)
maxhtab=(%xmax+1) \ %charwidth
maxvtab=(%ymax+1) \ %charheight

vtab=(y-1) * %charHeight

sp$=space$(maxhtab)
charcount =len(sp$)
segment=strseg(sp$)
offset =strptr(sp$)
htab=( (maxhtab-charcount) \ 2 )* %charwidth
call PRINT.STR (segment,offset, charcount, htab, vtab, ink,paper)

charcount =len(s$)
segment=strseg(s$)
offset =strptr(s$)
htab=( (maxhtab-charcount) \ 2 )* %charwidth
call PRINT.STR (segment,offset, charcount, htab, vtab, ink,paper)
end sub

sub gprint (byval x, byval y, byval s$, byval ink, byval paper)
maxhtab=(%xmax+1) \ %charwidth
maxvtab=(%ymax+1) \ %charheight

htab=(x-1) * %charWidth
vtab=(y-1) * %charHeight
charcount =len(s$)

sp$=space$(charcount)
segment=strseg(sp$)
offset =strptr(sp$)
call PRINT.STR (segment,offset, charcount, htab, vtab, ink,paper)

segment=strseg(s$)
offset =strptr(s$)
call PRINT.STR (segment,offset, charcount, htab, vtab, ink,paper)
end sub

'--------------------------------------------------------------------

FUNCTION GetSpriteColor(byval mono,BYVAL c$)
SELECT CASE c$
CASE "."
    c=%nil      : k=c   ' 0 is transparent AND black!!!
CASE " "
    c=%MyBLACK  : k=c   ' was %c.BLACK
CASE "b"
    c=%c.BLUE   : k=c
CASE "g"
    c=%c.GREEN  : k=c
CASE "c"
    c=%c.CYAN   : k=c
CASE "r"
    c=%c.RED    : k=c
CASE "p"
    c=%c.PURPLE : k=c
CASE "y"
    c=%c.BROWN  : k=c
CASE "w"
    c=%c.WHITE  : k=c
CASE "+"
    c=%c.GREY   : k=c
CASE "B"
    c=%c.bBLUE  : k=%c.purple
CASE "G"
    c=%c.bGREEN : k=c
CASE "C"
    c=%c.bCYAN  : k=c
CASE "R"
    c=%c.bRED   : k=%c.yellow
CASE "P"
    c=%c.bPURPLE: k=c
CASE "Y"
    c=%c.YELLOW : k=c
CASE "W"
    c=%c.bWHITE : k=c
CASE "*"
    c=%c.BRIGHT : k=c
CASE ELSE
    c=%nil      : k=c
END SELECT
if mono=%true then
    GetSpriteColor=k
else
    GetSpriteColor=c
end if
END FUNCTION

sub BuildSprite (BYVAL n, byval mono)
DIM Grid(1:%maxWidthSprite,1:%maxHeightSprite)
RESTORE SpriteDef
i=%firstsprite
DO
    y = 1
    do
        READ s$
        if s$="EOF" then exit loop
        w=len(s$)
        FOR x = 1 TO w
            c$=MID$(s$,x,1)
            Grid(x,y)=GetSpriteColor(mono,c$)
        NEXT
        incr y
    loop
    h=y-1
    IF i=n THEN EXIT LOOP
    incr i
LOOP
s$=STRING$(w*h,%nil)
ndx=1
FOR y=1 TO h
    FOR x = 1 TO w
        MID$(s$,ndx,1)=CHR$(Grid(x,y))
        INCR ndx
    NEXT
NEXT
sprite(n).sWidth=w
sprite(n).sHeight=h
sprite(n).sData=s$
erase grid

' assume consistent width !
' .=transparent (color 0 for mask)
'  =black b=blue g=green r=red p=purple y=brown w=white +=grey
'         B      G       R     P        Y       W       *

SpriteDef:

'black i.e. blue
data "wWWWWWWWWWWWWWWWWWWWWWWw"
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwww      wwwwwwww "
data "Wwwwwww  BBBBBB  wwwwww "
data "Wwwwww BBBBBBBBBB wwwww "
data "Wwwww BBBBBBBBBBBB wwww "
data "Wwww BBB   BB   BBB www "
data "Wwww BBB   BB   BBB www "
data "Www BBBB   BB   BBBB ww "
data "Www BBBBBBBBBBBBBBBB ww "
data "Www BBBBBBBBBBBBBBBB ww "
data "Www B BBBBBBBBBBBB B ww "
data "Www B BBBBBBBBBBBB B ww "
data "Www BB BBBBBBBBBB BB ww "
data "Wwww BB BBBBBBBB BB www "
data "Wwww BBB  BBBB  BBB www "
data "Wwwww BBBB    BBBB wwww "
data "Wwwwww BBBBBBBBBB wwwww "
data "Wwwwwww  BBBBBB  wwwwww "
data "Wwwwwwwww      wwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "w                      w"
DATA "EOF"

data "wWWWWWWWWWWWWWWWWWWWWWWw"
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwww      wwwwwwww "
data "Wwwwwww  BBBBBB  wwwwww "
data "Wwwwww BBBBBBBBBB wwwww "
data "Wwwww BBBBBBBBBBBB wwww "
data "Wwww BBBB BBBB BBBB www "
data "Wwww BBBB BBBB BBBB www "
data "Www BBBBB BBBB BBBBB ww "
data "Www BBBBBBBBBBBBBBBB ww "
data "Www BBBBBBBBBBBBBBBB ww "
data "Www BBBBBBBBBBBBBBBB ww "
data "Www BBBBBBBBBBBBBBBB ww "
data "Www BBBBBBBBBBBBBBBB ww "
data "Wwww BBBBBBBBBBBBBB www "
data "Wwww BBBBBBBBBBBBBB www "
data "Wwwww BBBB    BBBB wwww "
data "Wwwwww BBBBBBBBBB wwwww "
data "Wwwwwww  BBBBBB  wwwwww "
data "Wwwwwwwww      wwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "w                      w"
DATA "EOF"

data "wWWWWWWWWWWWWWWWWWWWWWWw"
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwww      wwwwwwww "
data "Wwwwwww  BBBBBB  wwwwww "
data "Wwwwww BBBBBBBBBB wwwww "
data "Wwwww BBBBBBBBBBBB wwww "
data "Wwww BBBB BBBB BBBB www "
data "Wwww BBB   BB   BBB www "
data "Www BBBBB BBBB BBBBB ww "
data "Www BBBBBBBBBBBBBBBB ww "
data "Www BBBBBBBBBBBBBBBB ww "
data "Www BBBBBBBBBBBBBBBB ww "
data "Www BBBBBBBBBBBBBBBB ww "
data "Www BBBBBBBBBBBBBBBB ww "
data "Wwww BBBBBBBBBBBBBB www "
data "Wwww BBBBBB  BBBBBB www "
data "Wwwww BBBB BB BBBB wwww "
data "Wwwwww BBBBBBBBBB wwwww "
data "Wwwwwww  BBBBBB  wwwwww "
data "Wwwwwwwww      wwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "w                      w"
data "EOF"

'white i.e. red
data "wWWWWWWWWWWWWWWWWWWWWWWw"
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwww      wwwwwwww "
data "Wwwwwww  RRRRRR  wwwwww "
data "Wwwwww RRRRRRRRRR wwwww "
data "Wwwww RRRRRRRRRRRR wwww "
data "Wwww RRR   RR   RRR www "
data "Wwww RRR   RR   RRR www "
data "Www RRRR   RR   RRRR ww "
data "Www RRRRRRRRRRRRRRRR ww "
data "Www RRRRRRRRRRRRRRRR ww "
data "Www R RRRRRRRRRRRR R ww "
data "Www R RRRRRRRRRRRR R ww "
data "Www RR RRRRRRRRRR RR ww "
data "Wwww RR RRRRRRRR RR www "
data "Wwww RRR  RRRR  RRR www "
data "Wwwww RRRR    RRRR wwww "
data "Wwwwww RRRRRRRRRR wwwww "
data "Wwwwwww  RRRRRR  wwwwww "
data "Wwwwwwwww      wwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "w                      w"
DATA "EOF"

data "wWWWWWWWWWWWWWWWWWWWWWWw"
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwww      wwwwwwww "
data "Wwwwwww  RRRRRR  wwwwww "
data "Wwwwww RRRRRRRRRR wwwww "
data "Wwwww RRRRRRRRRRRR wwww "
data "Wwww RRRR RRRR RRRR www "
data "Wwww RRRR RRRR RRRR www "
data "Www RRRRR RRRR RRRRR ww "
data "Www RRRRRRRRRRRRRRRR ww "
data "Www RRRRRRRRRRRRRRRR ww "
data "Www RRRRRRRRRRRRRRRR ww "
data "Www RRRRRRRRRRRRRRRR ww "
data "Www RRRRRRRRRRRRRRRR ww "
data "Wwww RRRRRRRRRRRRRR www "
data "Wwww RRRRRRRRRRRRRR www "
data "Wwwww RRRR    RRRR wwww "
data "Wwwwww RRRRRRRRRR wwwww "
data "Wwwwwww  RRRRRR  wwwwww "
data "Wwwwwwwww      wwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "w                      w"
DATA "EOF"

data "wWWWWWWWWWWWWWWWWWWWWWWw"
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwww      wwwwwwww "
data "Wwwwwww  RRRRRR  wwwwww "
data "Wwwwww RRRRRRRRRR wwwww "
data "Wwwww RRRRRRRRRRRR wwww "
data "Wwww RRRR RRRR RRRR www "
data "Wwww RRR   RR   RRR www "
data "Www RRRRR RRRR RRRRR ww "
data "Www RRRRRRRRRRRRRRRR ww "
data "Www RRRRRRRRRRRRRRRR ww "
data "Www RRRRRRRRRRRRRRRR ww "
data "Www RRRRRRRRRRRRRRRR ww "
data "Www RRRRRRRRRRRRRRRR ww "
data "Wwww RRRRRRRRRRRRRR www "
data "Wwww RRRRRR  RRRRRR www "
data "Wwwww RRRR RR RRRR wwww "
data "Wwwwww RRRRRRRRRR wwwww "
data "Wwwwwww  RRRRRR  wwwwww "
data "Wwwwwwwww      wwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "w                      w"
data "EOF"

' board
data "wWWWWWWWWWWWWWWWWWWWWWWw"
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwww      wwwwwwww "
data "Wwwwwww  wwwwww  wwwwww "
data "Wwwwww wwwwwwwwww wwwww "
data "Wwwww wwwwwwwwwwww wwww "
data "Wwww wwwwwwwwwwwwww www "
data "Wwww wwwwwwwwwwwwww www "
data "Www wwwwwwwwwwwwwwww ww "
data "Www wwwwwwwwwwwwwwww ww "
data "Www wwwwwwwwwwwwwwww ww "
data "Www wwwwwwwwwwwwwwww ww "
data "Www wwwwwwwwwwwwwwww ww "
data "Www wwwwwwwwwwwwwwww ww "
data "Wwww wwwwwwwwwwwwww www "
data "Wwww wwwwwwwwwwwwww www "
data "Wwwww wwwwwwwwwwww wwww "
data "Wwwwww wwwwwwwwww wwwww "
data "Wwwwwww  wwwwww  wwwwww "
data "Wwwwwwwww      wwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "w                      w"
DATA "EOF"

data "wWWWWWWWWWWWWWWWWWWWWWWw"
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "Wwwwwwwwwwwwwwwwwwwwwww "
data "w                      w"
DATA "EOF"

data "wWWWWWWWWWWWWWWWWWWWWWWw"
data "W w w w w w w w w w w w "
data "Ww w w w w w w w w w w  "
data "W w w w w w w w w w w w "
data "Ww w w w w w w w w w w  "
data "W w w w w w w w w w w w "
data "Ww w w w w w w w w w w  "
data "W w w w w w w w w w w w "
data "Ww w w w w w w w w w w  "
data "W w w w w w w w w w w w "
data "Ww w w w w w w w w w w  "
data "W w w w w w w w w w w w "
data "Ww w w w w w w w w w w  "
data "W w w w w w w w w w w w "
data "Ww w w w w w w w w w w  "
data "W w w w w w w w w w w w "
data "Ww w w w w w w w w w w  "
data "W w w w w w w w w w w w "
data "Ww w w w w w w w w w w  "
data "W w w w w w w w w w w w "
data "Ww w w w w w w w w w w  "
data "W w w w w w w w w w w w "
data "Ww w w w w w w w w w w  "
data "w                      w"
DATA "EOF"


END sub

sub initSprites (byval mono%)
for i = %firstSprite to %LastSprite
    call buildSprite(i,mono%)
next
end sub

'--------------------------------------------------------------------


sub initboard
for x = 1 to %xcount
    for y = 1 to %ycount
        board(x,y)=%empty
    next
next
x = (%xcount) \ 2
y = (%ycount) \ 2
board(x,y)=%white
x = (%xcount) \ 2 +1
y = (%ycount) \ 2 +1
board(x,y)=%white

x = (%xcount) \ 2
y = (%ycount) \ 2 +1
board(x,y)=%black
x = (%xcount) \ 2 +1
y = (%ycount) \ 2
board(x,y)=%black
end sub

function getSpriteIndex(byval content, byval blackcount, byval whitecount)
select case content
case %empty
    ndx=%grayEmpty
case %black
    select case blackcount
    case < whitecount
        ndx=%blackLoser
    case = whitecount
        ndx=%blackEqual
    case > whitecount
        ndx=%blackWinner
    end select
case %white
    select case blackcount
    case < whitecount
        ndx=%whiteWinner
    case = whitecount
        ndx=%whiteEqual
    case > whitecount
        ndx=%whiteLoser
    end select
end select
getSpriteIndex=ndx
end function

sub putSprite(byval x, byval y, byval id)
xorigin=%xmin + (%xmax-%maxWidthSprite * %xcount) \ 2
yorigin=%ymin + (%ymax-%maxHeightSprite* %ycount) \ 2
wleft = xorigin + (x-1) * %maxWidthSprite
wtop  = yorigin + (y-1) * %maxHeightSprite
w=sprite(id).swidth
h=sprite(id).sheight
CALL tdraw.Bitmap ( sprite(id).sData, wleft, wtop, w, h )
end sub

sub showboard
call centerprint (%vtabtitle, msg$(%title), ink, paper)
for x = 1 to %xcount
    for y = 1 to %ycount
        id=getspriteindex( board(x,y), blackcount, whitecount)
        call putsprite(x,y,id)
    next
next
end sub

sub refreshboard
for x = 1 to %xcount
    for y = 1 to %ycount
        if board(x,y) <> %empty then
            id=getspriteindex( board(x,y), blackcount, whitecount)
            call putsprite(x,y,id)
        end if
    next
next
end sub

sub initMessages
restore infos
for i = %firstMsg to %lastMsg
    read s$
    if instr(s$,"***") > 0 then
        replace "***" with chr$(27,18,26) in s$
    end if
    if instr(s$,"$$") > 0 then
        replace "$$" with chr$(27,26) in s$
    end if
    if instr(s$,"!!") > 0 then
        replace "!!" with chr$(17,190) in s$
    end if
    msg$(i)=s$
next
end sub

sub refreshcounts
blackcount=0
whitecount=0
for xx=1 to %xcount
    for yy=1 to %ycount
        select case board(xx,yy)
        case %black
            incr blackcount
        case %white
            incr whitecount
        end select
    next
next
end sub

sub initcolors
ink = %c.bgreen
paper=%c.black
end sub

'--------------------------------------------------------------------

sub changeorplay
call centerprint (%vtabmsg,msg$(%changeorplay),ink,paper)
do
    select case getkeypress$(%true) ' flush
    case chr$(27)
        error %eAborted
    case chr$(13)
        exit loop
    case " "
        call customboard
        exit loop
    case else
        biperr
    end select
loop
end sub

sub customboard
call centerprint (%vtabmsg,msg$(%helpchange),ink,paper)
xpos=1
ypos=1
do
    do
        call putsprite(xpos,ypos,%grayCheckered)
        for i = 1 to 8
            call waitvgaretrace ' else need delay 0.2
        next
        id=getspriteindex( board(xpos,ypos), blackcount, whitecount) ' always get neutral instead ?
        call putsprite(xpos,ypos,id)
        for i = 1 to 8
            call waitvgaretrace ' else need delay 0.2
        next
    loop until instat
    select case getkeypress$(%false)
    case chr$(27)
        error %eAborted
    case chr$(13)
        select case board(xpos,ypos)
        case %empty
            newcontent=%black
        case %black
            newcontent=%white
        case %white
            newcontent=%empty
        end select
        board(xpos,ypos)=newcontent
        call refreshcounts
        call refreshboard
    case "B","b"
        board(xpos,ypos)=%black
        call refreshcounts
        call refreshboard
    case "W","w","R","r"
        board(xpos,ypos)=%white
        call refreshcounts
        call refreshboard
    case " "
        board(xpos,ypos)=%empty
        call refreshcounts
        call refreshboard
    case chr$(0,72) ' up arrow
        decr ypos
        if ypos < 1 then
            ypos=%ycount
            decr xpos
            if xpos < 1 then xpos=%xcount
        end if
    case chr$(0,80) ' down arrow
        incr ypos
        if ypos > %ycount then
            ypos=1
            incr xpos
            if xpos > %xcount then xpos=1
        end if
    case chr$(0,75) ' left arrow
        decr xpos
        if xpos < 1 then
            xpos=%xcount
            decr ypos
            if ypos < 1 then ypos=%ycount
        end if
    case chr$(0,77) ' right arrow
        incr xpos
        if xpos > %xcount then
            xpos=1
            incr ypos
            if ypos > %ycount then ypos=1
        end if
    case "G","g"
        ' check start position always set ?
        exit loop
    case else
        biperr
    end select
    call flushkbd
loop
end sub

function getcolor(byval blackorwhite, byval mono)
select case blackorwhite
case %black
    n=GetSpriteColor(mono, "B")
case %white
    n=GetSpriteColor(mono, "R")
end select
getcolor=n
end function

sub showscore
s$=mid$(str$(playercount),2)
s$=left$("   ",3-len(s$))+s$
call gprint (%htabplayer  ,%vtabstatus+3,s$,getcolor(playercolor,mono),paper)
s$=mid$(str$(computercount),2)
s$=left$("   ",3-len(s$))+s$
call gprint (%htabcomputer,%vtabstatus+3,s$,getcolor(computercolor,mono),paper)
end sub

sub whatcolor
call centerprint (%vtabmsg,msg$(%whatcolor),ink,paper)
do
    select case getkeypress$(%true) ' flush
    case chr$(27)
        error %eAborted
    case " "  ' "B","b"
        playercolor=%black
        computercolor=%white
        playercount=blackcount
        computercount=whitecount
        exit loop
    case chr$(13) ' "W","w"
        playercolor=%white
        computercolor=%black
        playercount=whitecount
        computercount=blackcount
        exit loop
    case else
        biperr
    end select
loop
call gprint (%htabplayer  ,%vtabstatus,"Player",getcolor(playercolor,mono),paper)
call gprint (%htabcomputer,%vtabstatus," Iago ",getcolor(computercolor,mono),paper)
call showscore
end sub

%player     = 0
%computer   = 1

sub showcurrentplayer(byval whosgonnaplay)
select case whosgonnaplay
case %player
    call gprint (%htabplayer  ,%vtabstatus,"Player",paper,getcolor(playercolor,mono))
    call gprint (%htabcomputer,%vtabstatus," Iago ",getcolor(computercolor,mono),paper)
case %computer
    call gprint (%htabplayer  ,%vtabstatus,"Player",getcolor(playercolor,mono),paper)
    call gprint (%htabcomputer,%vtabstatus," Iago ",paper,getcolor(computercolor,mono))
end select
end sub

function nextplayer(byval whowasplaying)
select case whowasplaying
case %player
    whosgonnaplay=%computer
case %computer
    whosgonnaplay=%player
end select
nextplayer=whosgonnaplay
end function

function whoseturn
call centerprint (%vtabmsg,msg$(%whostarts),ink,paper)
do
    select case getkeypress$(%true) ' flush
    case chr$(27)
        error %eAborted
    case chr$(13)
        whosgonnaplay=%player
        exit loop
    case " "
        whosgonnaplay=%computer
        exit loop
    case else
        biperr
    end select
loop
whoseturn=whosgonnaplay
end function

sub playermove (Imustpass)
Imustpass=mustpass(playercolor)
if Imustpass=%true then
    call centerprint (%vtabmsg,msg$(%playerpass),ink,paper)
    do
        select case getkeypress$(%true)
        case chr$(27)
            error %eAborted
        case chr$(13)
            exit loop
        case else
            biperr
        end select
    loop
else
    call centerprint (%vtabmsg,msg$(%playerhelp),ink,paper)
    ypos=1
    xpos=1
    motion=1 ' 1=forward, -1=backward, 0=none
    do
        if possible(playercolor,xpos,ypos)=%true then
            do
                call putsprite(xpos,ypos,%grayCheckered)
                for i = 1 to 8
                    call waitvgaretrace ' else need delay 0.2
                next
                call putsprite(xpos,ypos,%grayEmpty)
                for i = 1 to 8
                    call waitvgaretrace ' else need delay 0.2
                next
            loop until instat
            select case getkeypress$(%false)
            case chr$(27)
                error %eAborted
            case chr$(13)
                call updateboard(playercolor,xpos,ypos)
                exit loop
            case chr$(0,75) ' left arrow
                motion = -1
            case chr$(0,77) ' right arrow
                motion = 1
            case "H","h","*" ' hint
                call centerprint (%vtabmsg,msg$(%thinking),ink,paper)
                call bestmove (playercolor, xpos, ypos)
                ' delay 1 ' see message
                call centerprint (%vtabmsg,msg$(%playerhelp),ink,paper)
                motion = 0
            case else
                biperr
                motion = 0
            end select
        end if
        select case motion
        case -1
            decr xpos
            if xpos < 1 then
                xpos=%xcount
                decr ypos
                if ypos < 1 then
                    ypos=%ycount
                end if
            end if
        case 1
            incr xpos
            if xpos > %xcount then
                xpos=1
                incr ypos
                if ypos > %ycount then
                    ypos=1
                end if
            end if
        case 0
            ' nada !
        end select
    loop
end if
end sub

sub computermove(Imustpass)
Imustpass=mustpass(computercolor)
if Imustpass=%true then
    call centerprint (%vtabmsg,msg$(%computerpass),ink,paper)
    if audio =%true then biptiny
    do
        select case confirm
        case %true
            c$=getkeypress$(%true)
        case %false
            delay 2! ' two seconds are enough
            c$=chr$(13)
        end select

        select case c$
        case chr$(27)
            error %eAborted
        case chr$(13)
            exit loop
        case else
            biperr
        end select
    loop
else
    call centerprint (%vtabmsg,msg$(%computerthinking),ink,paper)
    call bestmove(computercolor,xpos,ypos)
    call centerprint (%vtabmsg,msg$(%docomputer),ink,paper)
    if audio=%true then biptiny
    do
        org!=timer
        do
            call putsprite(xpos,ypos,%grayCheckered)
            for i = 1 to 8
                call waitvgaretrace ' else need delay 0.2
            next
            call putsprite(xpos,ypos,%grayEmpty)
            for i = 1 to 8
                call waitvgaretrace ' else need delay 0.2
            next

            select case confirm
            case %true
                if instat then
                    goon=%true
                else
                    goon=%false
                end if
            case %false
                now!=timer
                if (now!-org!) > 1! then ' one second is enough
                    goon=%true
                else
                    goon=%false
                end if
            end select
        loop until goon=%true

        select case confirm
        case %true
            c$=getkeypress$(%false)
        case %false
            c$=chr$(13)
        end select

        select case c$
        case chr$(27)
            error %eAborted
        case chr$(13)
            call updateboard(computercolor,xpos,ypos)
            exit loop
        case else
            biperr
        end select
    loop
end if
end sub

function possible(byval currentcolor,byval x,byval y)
select case board(x,y)
case %empty
    taken=0
    incr taken,scanline(x,y, 0,-1,currentcolor)
    incr taken,scanline(x,y, 0, 1,currentcolor)
    incr taken,scanline(x,y,-1, 0,currentcolor)
    incr taken,scanline(x,y, 1, 0,currentcolor)
    incr taken,scanline(x,y,-1,-1,currentcolor)
    incr taken,scanline(x,y, 1,-1,currentcolor)
    incr taken,scanline(x,y,-1, 1,currentcolor)
    incr taken,scanline(x,y, 1, 1,currentcolor)
    if taken=0 then
        possible=%false
    else
        possible=%true
    end if
case else
    possible=%false
end select
end function

function mustpass(byval currentcolor)
ypos=1
xpos=1
do
    if possible(currentcolor,xpos,ypos)=%true then
        rc=%false
        exit loop
    end if
    incr xpos
    if xpos > %xcount then
        xpos=1
        incr ypos
        if ypos > %ycount then
            rc=%true
            exit loop
        end if
    end if
loop
mustpass=rc
end function

function scanline(byval x, byval y, byval mvx, byval mvy, byval currentcolor)
eaten=0
sandwich=%false
do
    incr x,mvx
    incr y,mvy
    if x < 1 then exit loop
    if x > %xcount then exit loop
    if y < 1 then exit loop
    if y > %ycount then exit loop
    select case board(x,y)
    case %empty
        exit loop
    case currentcolor
        sandwich=%true
        exit loop
    case else
        incr eaten
    end select
loop
if sandwich=%false then eaten=0
scanline=eaten
end function

sub updateboard(byval currentcolor,byval x,byval y)
call capture(x,y, 0,-1,currentcolor)
call capture(x,y, 0, 1,currentcolor)
call capture(x,y,-1, 0,currentcolor)
call capture(x,y, 1, 0,currentcolor)
call capture(x,y,-1,-1,currentcolor)
call capture(x,y, 1,-1,currentcolor)
call capture(x,y,-1, 1,currentcolor)
call capture(x,y, 1, 1,currentcolor)
board(x,y)=currentcolor ' now we can do it ! capture(x,y,0,0,currentcolor) would NOT do the job
call refreshcounts ' blackcount and whitecount
select case playercolor
case %black
    playercount=blackcount
    computercount=whitecount
case %white
    playercount=whitecount
    computercount=blackcount
end select
call refreshboard
call showscore
end sub

sub capture(byval x, byval y, byval mvx, byval mvy, byval currentcolor)
if scanline(x,y,mvx,mvy,currentcolor) <> 0 then
    do
        incr x,mvx
        incr y,mvy
        if x < 1 then exit loop
        if x > %xcount then exit loop
        if y < 1 then exit loop
        if y > %ycount then exit loop
        select case board(x,y)
        case %empty
            exit loop
        case currentcolor
            exit loop
        case else
            board(x,y)=currentcolor
        end select
    loop
end if
end sub

sub bestmove (byval currentcolor, x, y) ' x and y will contain best move
ypos=1
xpos=1
bestscore=-1 ' even 0 score will be better than -1 !
do
    if possible(currentcolor,xpos,ypos)=%true then
        thisscore=eval(currentcolor,xpos,ypos)
        select case thisscore
        case < bestscore
            betterscore=%false
        case = bestscore
            if rnd < 0.5 then
                betterscore=%true
            else
                betterscore=%false
            end if
        case > bestscore
            betterscore=%true
        end select
        if betterscore = %true then
            bestscore=thisscore
            xbest=xpos
            ybest=ypos
        end if
    end if
    incr xpos
    if xpos > %xcount then
        xpos=1
        incr ypos
        if ypos > %ycount then
            x=xbest
            y=ybest
            exit loop
        end if
    end if
loop
end sub

sub initengine
restore tscoredata
for y = 1 to %ycount
    read s$
    for x = 1 to %xcount
        c$=mid$(s$,x,1)
        tscore(x,y)=val(c$)
    next
next

tscoredata:

$if %biggrid

' experimental for 10x10 !

data "6255555526"
data "2011111102"
data "5143333415"
data "5137777315"
data "5137777315"
data "5137777315"
data "5137777315"
data "5143333415"
data "2011111102"
data "6255555526"

$else

data "62555526"
data "20111102"
data "51433415"
data "51377315"
data "51377315"
data "51433415"
data "20111102"
data "62555526"

$endif

end sub

function eval(byval currentcolor,byval x, byval y)
taken=0
incr taken,scanline(x,y, 0,-1,currentcolor)
incr taken,scanline(x,y, 0, 1,currentcolor)
incr taken,scanline(x,y,-1, 0,currentcolor)
incr taken,scanline(x,y, 1, 0,currentcolor)
incr taken,scanline(x,y,-1,-1,currentcolor)
incr taken,scanline(x,y, 1,-1,currentcolor)
incr taken,scanline(x,y,-1, 1,currentcolor)
incr taken,scanline(x,y, 1, 1,currentcolor)
select case tscore(x,y)
case 0
    if x < %xcount \ 2 then
        x=1
    else
        x=%xcount
    end if
    if y < %ycount \ 2 then
        y=1
    else
        y=%ycount
    end if
    select case board(x,y)
    case %empty
        plus=0
    case else
        plus=8
    end select
case 1
    plus=1
    select case x
    case <= 2
        addx=-1
    case >= 6
        addx=1
    case else
        addx=0
    end select
    select case y
    case <= 2
        addy=-1
    case >= 6
        addy=1
    case else
        addy=0
    end select
    ' x+dx, y+dy
    if board(x+addx,y+addy) <> currentcolor then decr plus,2
    ' x+dx-dy, y+dy-dx
    if board(x+addx-addy,y+addy-addx) <> currentcolor then decr plus,2
    ' x+dx+dy, y+dy+dx
    if board(x+addx+addy,y+addy+addx) <> currentcolor then decr plus,2
case 2
    if x < %xcount \ 2 then
        x=1
    else
        x=%xcount
    end if
    if y < %ycount \ 2 then
        y=1
    else
        y=%ycount
    end if
    select case board(x,y)
    case %empty
        plus=0
    case currentcolor
        plus=16
    case else
        plus=2
    end select
case 3
    plus=4
case 4
    plus=8
case 5
    plus=16
case 6
    plus=32
case 7
    plus=0
end select
incr taken,plus
if taken < 0 then taken=0 ' handle case 1 weird weight !
eval=taken
end function

function endgame(byval playerpass,byval computerpass)
cond1=(playercount=0) or (computercount=0)
cond2=(playercount+computercount=%xycount)
cond3=(playerpass=%true and computerpass=%true)

if cond1 or cond2 or cond3 then
    select case playercount
    case < computercount
        n=%computerwin
    case = computercount
        n=%nowinner
    case > computercount
        n=%playerwin
    end select
    call centerprint (%vtabmsg,msg$(n),ink,paper)
    do
        select case getkeypress$(%true)
        case chr$(27)
            error %eAborted
        case chr$(13)
            exit loop
        case else
            biperr
        end select
    loop
    endgame=%true
else
    endgame=%false
end if
end function

function playagain()
call centerprint (%vtabmsg,msg$(%again),ink,paper)
do
    select case getkeypress$(%true)
    case chr$(27)
        rc=%false
        exit loop
    case chr$(13)
        rc=%true
        exit loop
    case else
        biperr
    end select
loop
playagain=rc
end function

'--------------------------------------------------------------------

Start:

EXEName$        = "IAGO"
ProgramName$    = "Q&D Iago"
Version$        = "v1.04"
Copyright$      = "by PhG 1984 (Apple ][), 1998 (VGA mode X)"
Banner$         = ProgramName$+" "+Version$+" "+Copyright$
credit$ = "(public domain Mode X v1.04 library by Matt Pritchard)"

confirm         = %false
audio           = %false
mono            = %false
grafmode		= %true

cli$=command$
parmcount = argC(cli$)
for i = 1 to parmcount
    einfo$=argv$(cli$,i)
    r$=upper$(einfo$)
    select case left$(r$,1)
    case "/","-"
        r$=mid$(r$,2)
        select case r$
        case "?","H","HELP"
            error %eHelp
        case "C"
            confirm = %true
        case "A"
            audio = %true
        case "M"
            mono = %true
        case else
            error %eBadOpt
        end select
    case else
        error %eBadParm
    end select
next

if isVGA =%false then error %eNeedVGA
if SetHiresMode = %false then error %eCannotSet

RANDOMIZE TIMER

do

    initcolors
    initMessages
    call initSprites (mono)
   	fixPalette
  	call setViewWork(%page1,%page1)
   	call clearScreen(paper)

    call initengine
    call initboard
    call refreshcounts

    call showboard

    call changeorplay
    call whatcolor
    who = whoseturn

    playerpass=%false
    computerpass=%false

    do
        if endgame(playerpass,computerpass)=%true then exit loop
        call showcurrentplayer(who)
        select case who
        case %player
            call playermove (playerpass)
        case %computer
            call computermove (computerpass)
        end select
        who=nextplayer(who)
    loop
    if playagain=%false then exit loop
loop

SetTextMode
error %eNone
