
(* ---------------------------------------------------------------
Title         see help
Overview      see help
Usage         see help
Notes         as usual
              remember ModeX library requires LARGE model
              remember modex.obj must be specified in project !
              assume all pcx files share the exact same (undithered) palette :
              thanks to the great PicLab !
Bugs          in ModeX library, GET_DAC_REGISTER does not work at all !
              (glad I never used it !)
Wish List     load pictures in XMS ? ah ! we must be joking !
              a script system, eh ? ROFL !

--------------------------------------------------------------- *)

MODULE LavaLamp;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT IO;
IMPORT MsMouse;
IMPORT SYSTEM;
IMPORT BiosIO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs,
completedInit, completedShow, completedSHOW, completedEnd, completed;

FROM ModeX IMPORT
Mode_320x200,Mode_320x400,Mode_360x200,Mode_360x400,
Mode_320x240,Mode_320x480,Mode_360x240,Mode_360x480,
SET_VGA_MODEX, SET_MODEX, CLEAR_VGA_SCREEN, SET_POINT, READ_POINT,
FILL_BLOCK, DRAW_LINE, SET_DAC_REGISTER, GET_DAC_REGISTER,
LOAD_DAC_REGISTERS, READ_DAC_REGISTERS,
SET_ACTIVE_PAGE, GET_ACTIVE_PAGE, SET_DISPLAY_PAGE, GET_DISPLAY_PAGE,
SET_WINDOW, GET_X_OFFSET, GET_Y_OFFSET, SYNC_DISPLAY,
GPRINTC, TGPRINTC, PRINT_STR, TPRINT_STR,
SET_DISPLAY_FONT, DRAW_BITMAP, TDRAW_BITMAP, COPY_PAGE, COPY_BITMAP,
mxTrue, mxFalse, mxnil,
c_BLACK, c_BLUE, c_GREEN, c_CYAN, c_RED, c_PURPLE, c_BROWN, c_WHITE,
c_GREY, c_bBLUE, c_bGREEN, c_bCYAN, c_bRED, c_bPURPLE, c_YELLOW, c_bWHITE,
c_BRIGHT,
DOS_PRINT, DOS_PRINTS, SET_VIDEO_MODE,
SCAN_KEYBOARD, RANDOM_INT, INIT_RANDOM, INT_SQR, TIMER_COUNT;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    dosEXEheaderType = RECORD (* well, a portion of... *)
        magic1 : CHAR;
        magic2 : CHAR;
        sizemod512 : CARDINAL;
        sizediv512 : CARDINAL; (* -1 required before *512 ! *)
    END;
    (*
    fsize := FIO.Size(exefile);
    exe.sizemod512 := CARDINAL(fsize) MOD 512;
    exe.sizediv512 := CARDINAL((fsize+511) DIV 512);
    *)

PROCEDURE bagage (VAR datapos:LONGCARD; VAR datafile:ARRAY OF CHAR):BOOLEAN;
VAR
    currsize,orgsize:LONGCARD;
    hnd:FIO.File;
    got:CARDINAL;
    hexe:dosEXEheaderType;
BEGIN
    Lib.ParamStr(datafile,0);
    currsize:=getFileSize(datafile);

    hnd:=FIO.OpenRead(datafile);
    got := FIO.RdBin(hnd,ADDRESS(hexe),SIZE(hexe));
    orgsize := 512*LONGCARD(hexe.sizediv512 -1 )+LONGCARD(hexe.sizemod512); (* remember -1 ! *)
    IF orgsize < currsize THEN
        datapos:=orgsize; (* 1 is already added because seek is 0-based *)
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END bagage;

PROCEDURE fmtVal (n:LONGCARD;base,digits:CARDINAL;padchar:CHAR;VAR R:ARRAY OF CHAR);
VAR
    ok: BOOLEAN;
    i:CARDINAL;
BEGIN
    Str.CardToStr( n, R, base, ok);
    FOR i:=Str.Length(R)+1 TO digits DO
        Str.Prepend(R,padchar);
    END;
END fmtVal;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    progEXEname   = "LAVALAMP";
    progEXEspac   = "        ";
    progTitle     = "Q&D Lava Lamp";
    progVersion   = "v1.0d";
    progCopyright = "by PhG";
    Banner        = progTitle+" "+progVersion+" "+progCopyright;
    credit        = "(public domain Mode X v1.04 library by Matt Pritchard)";

CONST
    extPCX        = ".PCX";
    extBIN        = ".BIN";
    extPAL        = ".PAL";
    extEXE        = ".EXE";
    extTMP        = ".TMP";
    fileDigits    = 3;                  (* ###.PCX *)
    fileBackground= "000"+extPCX;
    baseFileBank  = progEXEname+extBIN;
    filePal       = progEXEname+extPAL;
    fileTmp       = progEXEname+extTMP;
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
    dot           = ".";

CONST
    errNone             = 0;
    errHelp             = 1;
    errOption           = 2;
    errTooManyParameters= 3;
    errBadVal           = 4;
    errFound            = 5;
    errTooManyMatches   = 6;
    errNoMatch          = 7;
    errNotPicture       = 8;
    errNonsense         = 9;
    errNotFound         = 10;
    errReadError        = 11;
    errFormat           = 12;
    errModeXproblem     = 13;
    errBadMode          = 14;
    errBadPaper         = 15;
    errBadSpeed         = 16;
    errDimensions       = 17;
    errBadColor         = 18;
    errBadCycles        = 19;
    errOversized        = 20;
    errNoVesa           = 21;
    errNotAvailable     = 22;
    errVesaProblem      = 23;
    err104F01           = 24;
    err104F05           = 25;

    errHelper           = 64;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
msgHelp =
Banner+nl+
nl+
credit+nl+
nl+
"Syntax 1 : "+progEXEname+" [-mouse] [-mode:#] [-cycles:#] [-center] [-speed:#] [-fast]"+nl+
"           "+progEXEspac+" [-paper:#] [-red:#] [-green:#] [-blue:#]"+nl+
"           "+progEXEspac+" [-rg] [-rb] [-gb] [-keep] [-external]"+nl+
nl+
"    -m   exit on mouse click"+nl+
"    -m:# video mode"+nl+
"         0=320x240 (default), 1=360x240, 2=640x480 (VESA), 3=800x600 (VESA)"+nl+
"    -c:# change color interval ([0..5000], default is 10)"+nl+
"    -c   centered display"+nl+
"    -s:# speed ([0..31], default is 4)"+nl+
"    -f   no page-flipping"+nl+
"    -p:# background color ([0..255])"+nl+
"    -r:# red component (-255..+255)"+nl+
"    -g:# green component (-255..+255)"+nl+
"    -b:# blue component (-255..+255)"+nl+
"    -rg  swap red and green"+nl+
"    -rb  swap red and blue"+nl+
"    -gb  swap green and blue"+nl+
"    -k   do not mutate colors"+nl+
"    -e   force program to use "+baseFileBank+", ignoring EXE bagage if any"+nl+
nl+
"    While program is running, interaction is possible using these keys :"+nl+
nl+
"    [F1|F2]-red  [F3|F4]-green  [F5|F6]-blue  [F9|F10|F11]-swap R,G,B colors"+nl+
"    [F8]-reset palette  [+|-]-speed  [Tab|C]-position  [Escape|Return]-quit"+nl+
nl+
"Syntax 2 : "+progEXEname+" <-build> [-x:#] [-y:#] [-overwrite] [-verbose]"+nl+
nl+
"    Build "+baseFileBank+" from up to 1000 ###"+extPCX+" sequentially numbered files."+nl+
"    "+fileBackground+" is background whose palette will be used for all pictures."+nl+
nl+
"    -x:# picture left position (relative to background picture)"+nl+
"    -y:# picture top position (relative to background picture)"+nl+
"    -o   overwrite existing "+baseFileBank+nl+
nl+
"Syntax 3 : "+progEXEname+" <-list> [-overwrite]"+nl+
nl+
"    List files from "+baseFileBank+" (redirected output is batch-ready)."+nl+
nl+
'    -o   append "-o" to XTRACT commands in redirected output'+nl;

VAR
    S : str256;
    datapos:LONGCARD;
    hex:str16;
BEGIN
    CASE e OF
    | errHelp,errHelper :
        WrStr(msgHelp);
        IF e=errHelper THEN
            IF bagage(datapos,S) THEN
                Str.Prepend(S,nl+"Note ");
                Str.Append(S," contains binary data at $");
                fmtVal (datapos,16,8,"0",hex);
                Str.Lows(hex);
                Str.Append(S,hex);
                Str.Append(S,"."+nl);
                WrStr(S);
            END;
            e:=errHelp;
        END;
    | errOption :
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errTooManyParameters:
        Str.Concat(S,einfo," is just one parameter too many !");
    | errBadVal:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," value !");
    | errFound:
        Str.Concat(S,einfo," already exists !");
    | errTooManyMatches:
        S := "Too many PCX files !";
    | errNoMatch:
        S := "No PCX file found !";
    | errNotPicture:
        Str.Concat(S,einfo," file format is unsupported or unknown !");
    | errNonsense:
        S:="-build, -list and -show commands are mutually exclusive !";
    | errNotFound:
        Str.Concat(S,einfo," does not exist !");
    | errReadError :
        Str.Concat(S,einfo," seems corrupted !");
    | errFormat :
        Str.Concat(S,einfo," is not a Lava Lamp file !");
    | errModeXproblem:
        Str.Concat(S,"Cannot set requested ",einfo);Str.Append(S," video mode !");
    | errBadMode:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," video mode !");
    | errBadPaper:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," paper color !");
    | errBadSpeed:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," speed !");
    | errDimensions:
        Str.Concat(S,einfo," will not fit any video mode !");
    | errBadColor:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," RGB modifier !");
    | errBadCycles:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," number of cycles !");
    | errOversized:
        Str.Concat(S,"Background ",einfo);Str.Append(S," will not fit selected vide mode !");
    | errNoVesa:
        S:="VESA functions are not available !";
    | errNotAvailable:
        Str.Concat(S,einfo," video mode is not available !");
    | errVesaProblem:
        Str.Concat(S,einfo," video mode would not initialize !");
    | err104F01:
        S := "$104F01 VESA function failure !";
    | err104F05:
        S := "$104F05 VESA function failure !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp :
        ;
    ELSE
        WrStr(progEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

PROCEDURE getCard (S:ARRAY OF CHAR;VAR v:CARDINAL):BOOLEAN;
VAR
    n:LONGCARD;
BEGIN
    IF GetLongCard(S,n)=FALSE THEN RETURN FALSE; END;
    IF n > MAX(CARDINAL) THEN RETURN FALSE; END;
    v:= CARDINAL(n);
    RETURN TRUE;
END getCard;

PROCEDURE getInt (S:ARRAY OF CHAR;VAR v:INTEGER):BOOLEAN;
VAR
    n:LONGINT;
BEGIN
    IF GetLongInt(S,n)=FALSE THEN RETURN FALSE; END;
    IF n > MAX(INTEGER) THEN RETURN FALSE; END;
    IF n < MIN(INTEGER) THEN RETURN FALSE; END;
    v:= INTEGER(n);
    RETURN TRUE;
END getInt;

PROCEDURE getrndrange ( lower,upper:CARDINAL ):CARDINAL;
VAR
    range : CARDINAL;
BEGIN
    range := upper-lower+1 ;
    RETURN lower+ RANDOM_INT(range);
END getrndrange;

PROCEDURE swap (VAR v1,v2:CARDINAL);
VAR
    tmp:CARDINAL;
BEGIN
    tmp := v2;
    v2  := v1;
    v1  := tmp;
END swap;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

(* ------------------------------------------------------------ *)

CONST
    keyESC     = 01B00H;
    keySPACE   = 02000H;
    keyCR      = 00D00H;
    keyF1      = 0003BH;
    keyF2      = 0003CH;
    keyF3      = 0003DH;
    keyF4      = 0003EH;
    keyF5      = 0003FH;
    keyF6      = 00040H;

    keyF8      = 00042H;
    keyF9      = 00043H;
    keyF10     = 00044H;
    keyF11     = 00085H;

    keyMinus   = ORD("-") << 8;
    keyPlus    = ORD("+") << 8;
    keyTab     = 00900H;
    keyLowerC  = ORD("c") << 8;
    keyUpperC  = ORD("C") << 8;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    ioBuffer, ioBufferOut : ioBufferType;

CONST
    minDataBufferByte = 0;
    maxDataBufferByte = (8 * 512)-1; (* 8 seems best, 4 is ok *)
    dataBufferSize    = maxDataBufferByte-minDataBufferByte+1;
TYPE
    databuffertype = ARRAY [minDataBufferByte..maxDataBufferByte] OF BYTE;
VAR
    databuffer : databuffertype;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    v640x480x8 = 0101H;
    v800x600x8 = 0103H;

(*# save *)
(*# data(near_ptr => off)  *)
TYPE
    vpointer = POINTER TO WORD; (* well, glad M2 is case-sensitive ! *)
    pchar   = POINTER TO CHAR;
(*# restore *)

TYPE
    vesamainbuffertype = RECORD
        id             : ARRAY [0..3] OF CHAR;
        majmin         : WORD;
        pOEMname       : LONGWORD;  (* asciiz *)
        capabilities   : LONGWORD;
        pList          : LONGWORD;
        VRAM64KBblocks :WORD;
        OEMmajmin      : WORD;
        pOEM           : LONGWORD;
        pProduct       : LONGWORD;
        pRevision      : LONGWORD;
        VBEAFversion   : WORD;
        pAcceleratedModes:LONGWORD;
        dummy          : ARRAY [1..216] OF BYTE;
        OEMdummy       : ARRAY [1..256] OF BYTE;
    END;

VAR
    Buffer : vesamainbuffertype;

PROCEDURE CheckVesaHere (forceVBE2:BOOLEAN;VAR listPtr : vpointer) : BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    IF forceVBE2 THEN
        Buffer.id[0]:="V";
        Buffer.id[1]:="B";
        Buffer.id[2]:="E";
        Buffer.id[3]:="2";
    END;
    R.AX := 4F00H;
    R.ES := Seg(Buffer); (* buffer segment *)
    R.DI := Ofs(Buffer); (* buffer offset *)
    Lib.Intr(R,10H);
    IF R.AL # 4FH THEN RETURN FALSE; END;
    IF R.AH # 00H THEN RETURN FALSE; END;
    IF Buffer.id[0] # "V" THEN RETURN FALSE; END;
    IF Buffer.id[1] # "E" THEN RETURN FALSE; END;
    IF Buffer.id[2] # "S" THEN RETURN FALSE; END;
    IF Buffer.id[3] # "A" THEN RETURN FALSE; END;
    (* Lib.Move (ADR(Buffer[0EH]),ADR(listPtr),4); (* set pointer to list ADDRESS *) *)
    Lib.Move (ADR(Buffer.pList),ADR(listPtr),SIZE(Buffer.pList));
    RETURN TRUE;
END CheckVesaHere;

(* warning ! a mode may be supposed "available" while not being implemented ! matrox idiosyncrasy ! *)

PROCEDURE ModeAvailable (listPtr : vpointer; mode : CARDINAL) : BOOLEAN;
BEGIN
    LOOP
        IF listPtr^ = WORD(0FFFFH) THEN EXIT; END;
        IF listPtr^ = WORD(mode) THEN RETURN TRUE; END;
        Lib.IncFarAddr(listPtr,SIZE(WORD));
    END;
    RETURN FALSE;
END ModeAvailable;

PROCEDURE SetVesaMode (mode : CARDINAL) : BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AX := 4F02H;
    R.BX := mode;
    Lib.Intr(R,10H);
    IF R.AL # 4FH THEN RETURN FALSE; END;
    IF R.AH # 00H THEN RETURN FALSE; END;
    RETURN TRUE;
END SetVesaMode;

(* ------------------------------------------------------------ *)

(* vesamodeinfobuffertype MUST be 256 bytes *)

TYPE
    vesamodeinfobuffertype = RECORD
        modeattributes      : WORD; (* 79 *)
        wA                  : BYTE; (* 81 *)
        wB                  : BYTE; (* id *)
        wgranularityKB      : WORD;
        wsizeKB             : WORD;
        segmentwA           : WORD; (* 0 if unsupported *)
        segmentwB           : WORD; (* id *)
        wpositioningfunction: LONGWORD;
        bytesperscanline    : WORD;
    (* ---remainder is optional for VESA modes in v1.0/1.1, needed for OEM modes--- *)
        width               : WORD; (* pixels or chars *)
        height              : WORD; (* id *)
        wcell               : BYTE;
        hcell               : BYTE;
        memplanes           : BYTE;
        bpp                 : BYTE;
        banks               : BYTE;
        memorymodeltype     : BYTE; (* 82 *)
        banksizeKB          : BYTE;
        imagepages          : BYTE; (* -1 *)
        reservedflag        : BYTE; (* 1 for VBE 3.0, ELSE 0 *)
    (* ---VBE v1.2+ --- *)
        rmasksize           : BYTE;
        rfield              : BYTE;
        gmasksize           : BYTE;
        gfield              : BYTE;
        bmasksize           : BYTE;
        bfield              : BYTE;
        reservedmasksize    : BYTE;
        reservedmaskposition: BYTE;
        directcolormode     : BYTE; (* bits 0 and 1 *)
    (* ---VBE v2.0+ --- *)
        linearvideobufferaddr: LONGWORD;
        offscreenmemoryaddr : LONGWORD;
        offscreenmemoryKB   : WORD;
    (* ---VBE v3.0 --- *)
        bytesperscanlinelinear:WORD;
        imagesforbankedmodes: BYTE; (* -1 *)
        imagesforlinearmodes: BYTE; (* -1 *)
        rmasklinear         : BYTE;
        rmaskLSBlinear      : BYTE;
        gmasklinear         : BYTE;
        gmaskLSBlinear      : BYTE;
        bmasklinear         : BYTE;
        bmaskLSBlinear      : BYTE;
        reservedmasklinear  : BYTE;
        reservedmaskLSBlinear:BYTE;
        maxclockHz          : LONGWORD;
        unused              : ARRAY [1..190] OF BYTE;
    END;

CONST
    vesaminy = 0;
    vesamaxy = 1024-1; (* 1280x1024 at most *)
VAR
    currbank:CARDINAL; (* a word in fact *)
    binfos : vesamodeinfobuffertype;

VAR
    vesabaseaddr : ARRAY [vesaminy..vesamaxy] OF LONGCARD;

PROCEDURE initVESAlookup (  );
VAR
    y : CARDINAL;
    addr,wi : LONGCARD;
BEGIN
    addr:=0;
    wi:=LONGCARD(binfos.width);
    FOR y:=vesaminy TO vesamaxy DO
        vesabaseaddr[y]  := addr;
        INC (addr, wi);
    END;
END initVESAlookup;

PROCEDURE getVESAmodeInfos (mode:CARDINAL):BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    Lib.Fill(ADR(binfos),SIZE(binfos),00H);

    R.AX := 4F01H;      (* GET SuperVGA MODE INFORMATION *)
    R.CX := WORD(mode);
    R.ES := Seg(binfos); (* buffer segment *)
    R.DI := Ofs(binfos); (* buffer offset *)
    Lib.Intr(R,10H);

    IF R.AL # 4FH THEN RETURN FALSE; END; (* unsupported function *)
    IF R.AH = 00H THEN initVESAlookup; END; (* ok, init if needed *)
    RETURN (R.AH=00H); (* FALSE if function failure *)
END getVESAmodeInfos;

PROCEDURE initVESAbank (  ):BOOLEAN;
VAR
    R:SYSTEM.Registers;
BEGIN
    currbank := 0000H;
    R.AX := 04F05H;
    R.BH := 00H;     (* select video memory window -- dx = window address in granularity units *)
    R.BL := 00H;     (* window A should always work *)
    R.DX := currbank;
    Lib.Intr(R,10H);
    IF R.AL # 4FH THEN RETURN FALSE; END;
    RETURN (R.AH=00H);
END initVESAbank;

PROCEDURE VESAputpixel (x,y,n:CARDINAL);
VAR
    addr:LONGCARD;
    bank,offset:CARDINAL;
    R:SYSTEM.Registers;
BEGIN
    addr  := LONGCARD(x)+vesabaseaddr[y];
    bank  := CARDINAL (addr >> 16);
    offset:= CARDINAL (addr MOD 65536);
    IF currbank # bank THEN
        currbank := bank;
        R.AX := 04F05H;
        R.BH := 00H;
        R.BL := 00H;
        R.DX := currbank;
        Lib.Intr(R,10H); (* assume ok *)
    END;
    (* ugly hack *)
    Lib.FarFill([binfos.segmentwA:offset],1,BYTE(n));
END VESAputpixel;

PROCEDURE VESAgetpixel (x,y:CARDINAL):BYTE;
VAR
    addr:LONGCARD;
    bank,offset:CARDINAL;
    R:SYSTEM.Registers;
    n:BYTE;
BEGIN
    addr  := LONGCARD(x)+vesabaseaddr[y];
    bank  := CARDINAL (addr >> 16);
    offset:= CARDINAL (addr MOD 65536);
    IF currbank # bank THEN
        currbank := bank;
        R.AX := 04F05H;
        R.BH := 00H;
        R.BL := 00H;
        R.DX := currbank;
        Lib.Intr(R,10H); (* assume ok *)
    END;
    (* ugly hack *)
    Lib.FarMove([binfos.segmentwA:offset],FarADR(n),1);
    RETURN n;
END VESAgetpixel;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstvmode = 0;
    lastvmode  = 3;
CONST
    xmaximum = 800; (* 360 *)
    ymaximum = 600; (* 240 *)
    Ky_SPACE = 0020H;
    Ky_lowerC= ORD("c");
    Ky_upperC= ORD("C");
    xmin=0;
    ymin=0;
    PagesVirtual=3; (* view, work, background *)
    page1=0;
    page2=1;
    page3=2;
VAR
    xcount,ycount,xmax,ymax,xMaxVirtual,yMaxVirtual:CARDINAL;
    viewpage,workpage,bkpage:CARDINAL;
    videoMode : CARDINAL;
    sMode : str16; (* oversized ! *)
    (* to avoid casts *)
    iscreenwidth  : INTEGER;
    iscreenheight : INTEGER;
    ixmax         : INTEGER;
    iymax         : INTEGER;
    cx,cy:INTEGER;

PROCEDURE getModeInfos (vmode:CARDINAL;   VAR usevesa:BOOLEAN;
                       VAR wi,he,m:CARDINAL;VAR R:str16):BOOLEAN;
BEGIN
    usevesa:=FALSE; (* default is mode X *)
    CASE vmode OF
    |0: m:=Mode_320x240; wi:=320;he:=240; R:="320x240";
    |1: m:=Mode_360x240; wi:=360;he:=240; R:="360x240";
    (*
    |2: m:=Mode_320x200; wi:=320;he:=200; R:="320x200";
    |3: m:=Mode_360x200; wi:=360;he:=200; R:="360x200";
    *)
    |2: m:=v640x480x8;   wi:=640;he:=480; R:="640x480"; usevesa:=TRUE;
    |3: m:=v800x600x8;   wi:=800;he:=600; R:="800x600"; usevesa:=TRUE;
    ELSE
        m:=MAX(CARDINAL);wi:=0;  he:=0;   R:="unknown";
        RETURN FALSE;
    END;
    RETURN TRUE;
END getModeInfos;

PROCEDURE HiresON (vmode:CARDINAL):BOOLEAN;
VAR
    ok:BOOLEAN;
    usevesa:BOOLEAN;
BEGIN
    ok:=getModeInfos(vmode,  usevesa,xcount,ycount,videoMode,sMode);
    IF NOT(ok) THEN RETURN FALSE; END;
    xmax:=xcount-1;
    ymax:=ycount-1;
    xMaxVirtual :=xcount;
    yMaxVirtual :=ycount;
    cx          := INTEGER(xmax DIV 2);
    cy          := INTEGER(ymax DIV 2);
    (* to avoid casts *)
    iscreenwidth  := INTEGER(xcount);
    iscreenheight := INTEGER(ycount);
    ixmax         := INTEGER(xmax);
    iymax         := INTEGER(ymax);
    Str.Append(sMode,"x256");
    RETURN (SET_VGA_MODEX(videoMode,xMaxVirtual,yMaxVirtual,PagesVirtual) # 0);
END HiresON;

PROCEDURE HiresOFF ();
CONST
    biostxtmode = 3;
BEGIN
    SET_VIDEO_MODE(biostxtmode);
END HiresOFF;

PROCEDURE setviewwork (view,work:CARDINAL );
BEGIN
    SET_DISPLAY_PAGE(view);
    SET_ACTIVE_PAGE(work);
END setviewwork;

PROCEDURE modexcls (paper:CARDINAL);
BEGIN
    CLEAR_VGA_SCREEN (paper);
END modexcls;

PROCEDURE VESAcls (paper:CARDINAL);
VAR
    x,y:CARDINAL;
BEGIN
    FOR y:=ymin TO ymax DO
        FOR x:=xmin TO xmax DO
            VESAputpixel(x,y,paper);
        END;
    END;
END VESAcls;

PROCEDURE cls (usevesa:BOOLEAN;paper:CARDINAL);
BEGIN
    SYNC_DISPLAY();
    IF usevesa THEN
        VESAcls(paper);
    ELSE
        modexcls(paper);
    END;
END cls;

PROCEDURE setDAC(index:CARDINAL;red,green,blue:BYTE);
CONST
    DACWriteIndex  = 03C8H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACWriteIndex,SHORTCARD(index));
    SYSTEM.Out (DACDataRegister, red);
    SYSTEM.Out (DACDataRegister, green);
    SYSTEM.Out (DACDataRegister, blue);
END setDAC;

PROCEDURE getDAC (index:CARDINAL;VAR r,g,b:SHORTCARD);
CONST
    DACReadIndex   = 03C7H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACReadIndex,SHORTCARD(index));
    r:=SYSTEM.In (DACDataRegister);
    g:=SYSTEM.In (DACDataRegister);
    b:=SYSTEM.In (DACDataRegister);
END getDAC;

(* ------------------------------------------------------------ *)

PROCEDURE setvesamoderange (vmode:CARDINAL;VAR R:ARRAY OF CHAR);
BEGIN
    CASE vmode OF
    | v640x480x8:xcount:=640;ycount:=480;Str.Copy(R,"640x480x8");
    | v800x600x8:xcount:=800;ycount:=600;Str.Copy(R,"800x600x8");
    END;
    xmax:=xcount-1;
    ymax:=ycount-1;
END setvesamoderange;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    PCXrgbType = RECORD
        red,green,blue:BYTE;
    END;

    (* (almost) useless fields are indented again *)

    PCXheaderType = RECORD
     manufacturer    : BYTE; (* constant 10=$0A=ZSoft *)
     version         : BYTE; (* constant 5=PC Paintbrush v3.0+ *)
     encoding        : BYTE; (* constant 1=RLE *)
    bitsPerPixel     : BYTE; (* 1, 2, 4 or 8, i.e. mono, 4, 16 OR 256 colors  *)
	                  (* window, i.e. image dimensions : xmin, ymin, xmax, ymax *)
    leftmargin       : WORD;
    uppermargin      : WORD;
    rightmargin      : WORD; (* do not use xmax-xmin ! *)
    lowermargin      : WORD;
     hDPIresolution  : WORD; (* put 300 for instance *)
     vDPIresolution  : WORD; (* idem *)
    colormap         : ARRAY[0..15] OF PCXrgbType;
     reserved1       : BYTE; (* must be 0 *)
    NCP              : BYTE; (* number of color planes, 1 or 4 *)
    NBS              : WORD; (* number of bytes per scanline, always even *)
                            (* from here, fields may contain rubbish *)
     paletteInfo     : WORD; (* 1=color or BW, 2=grayscale *)
     hscreensize     : WORD;
     vscreensize     : WORD;
     reserved2       : ARRAY[0..53] OF BYTE; (* must be 0 *)
    END;

CONST
    palID = BYTE(0CH); (* 12=$0C *)
    palidsize=1;
    palsize = 3 * 256;

PROCEDURE chkPCX256 (S:ARRAY OF CHAR;VAR picwidth,picheight:CARDINAL):BOOLEAN;
CONST
    kTen = BYTE(0AH);
    kOne = BYTE(1);
    kZero= BYTE(0);
CONST
    kFour= BYTE(4);
    kOneW= WORD(1); (* all tests being in the same proc now... *)
    kEight=BYTE(8);
VAR
    n : CARDINAL;
    h : PCXheaderType;
    hnd:FIO.File;
BEGIN
    hnd:=FIO.OpenRead(S);
    FIO.AssignBuffer(hnd,ioBuffer);
    n:=FIO.RdBin(hnd,h,SIZE(PCXheaderType));
    FIO.Close(hnd);
    IF n < SIZE(PCXheaderType) THEN RETURN FALSE; END;
    IF h.manufacturer # kTen THEN RETURN FALSE; END;
    IF h.encoding # kOne THEN RETURN FALSE;END;
    IF h.reserved1 # kZero THEN RETURN FALSE; END;
    (*
    FOR n:=0 TO 53 DO
        IF h.reserved2[n] # kZero THEN RETURN FALSE; END;
    END;
    *)
    IF h.bitsPerPixel > kEight THEN RETURN FALSE; END;
    IF h.NCP > kFour THEN RETURN FALSE; END;
    IF h.paletteInfo # kOneW THEN RETURN FALSE; END;
    CASE CARDINAL(h.NCP) OF
    | 1:
        CASE CARDINAL(h.bitsPerPixel) OF
        | 8 :
            picwidth  := CARDINAL(h.rightmargin-h.leftmargin)+1;
            picheight := CARDINAL(h.lowermargin-h.uppermargin)+1;
            RETURN TRUE;
        ELSE
            RETURN FALSE;
        END;
    ELSE
        RETURN FALSE;
    END;
END chkPCX256;

PROCEDURE newpalette (hnd:FIO.File;datapos,pos:LONGCARD);
VAR
    i,n:CARDINAL;
    r,g,b:SHORTCARD;
BEGIN
    FIO.Seek(hnd,datapos+pos);
    FOR i := 0 TO 255 DO
        n:=FIO.RdBin(hnd,r,SIZE(r));
        n:=FIO.RdBin(hnd,g,SIZE(g));
        n:=FIO.RdBin(hnd,b,SIZE(b));
        (* we must reduce to EGA range : [$00..$3F] *)
        r:=r >> 2;
        g:=g >> 2;
        b:=b >> 2;
        SET_DAC_REGISTER(i,CARDINAL(r),CARDINAL(g),CARDINAL(b) );
    END;
    SET_DAC_REGISTER(0,00H,00H,00H); (* index 0 stays black because of border *)
END newpalette;

TYPE
    paltype = (plusR,minusR,plusG,minusG,plusB,minusB,
               swapRG,swapRB,swapGB,original);

PROCEDURE changepalette (cmd:paltype);
CONST
    minpalval = 0;
    maxpalval = 03FH;

    MODULE arithm;
    IMPORT minpalval,maxpalval;
    EXPORT i,d;
    PROCEDURE i (k:CARDINAL; VAR v:CARDINAL);
    BEGIN
        IF (v+k) <= maxpalval THEN
            INC(v,k);
        ELSE
            v:=maxpalval;
        END;
    END i;

    PROCEDURE d (k:CARDINAL; VAR v:CARDINAL);
    BEGIN
        IF v >= k THEN
            DEC(v,k);
        ELSE
            v:=minpalval;
        END;
    END d;
    END arithm;

CONST
    k = 1;
VAR
    ndx:CARDINAL;
    rr,gg,bb:SHORTCARD;
    r,g,b:CARDINAL;
BEGIN
    FOR ndx:=0 TO 255 DO
        (* GET_DAC_REGISTER (ndx,  r,g,b) is a nono ! *)

        getDAC(ndx, rr,gg,bb);
        r:=CARDINAL(rr);
        g:=CARDINAL(gg);
        b:=CARDINAL(bb);

        CASE cmd OF
        | plusR: i(k,r);
        | minusR:d(k,r);
        | plusG: i(k,g);
        | minusG:d(k,g);
        | plusB: i(k,b);
        | minusB:d(k,b);
        | swapRG: swap(r,g);
        | swapRB: swap(r,b);
        | swapGB: swap(g,b);
        END;
        SET_DAC_REGISTER(ndx, r,g,b);
    END;
    SET_DAC_REGISTER(0,00H,00H,00H); (* index 0 stays black because of border *)
END changepalette;

(* ------------------------------------------------------------ *)

CONST
    maxPlanes = 4;
    maxpixels = 1280;
    firstcode = 0;
    (* maxcode   = (1280 DIV 8) * maxPlanes -1; (* in bytes *) *)
    maxcode   = maxpixels * maxPlanes-1;
TYPE
    imgtype = RECORD
        picwidth : CARDINAL ;
        picheight: CARDINAL ;
        decodebuffer : ARRAY [firstcode..maxcode] OF BYTE;
    END;
VAR
    img : imgtype;
CONST
    PCXCOUNTFLAG = BYTE(0C0H); (* 11000000 *)
    PCXCOUNTMASK = BYTE(03FH); (* 00111111 *)
    PCXMAXCOUNT  = 03FH;

PROCEDURE decodeScanline (hnd:FIO.File;wibytecount:CARDINAL);
VAR
    databyte:BYTE;
    p,count,n : CARDINAL;
BEGIN
    p := firstcode;
    WHILE p <= wibytecount DO
        n:=FIO.RdBin(hnd,databyte,1);
        IF (databyte AND PCXCOUNTFLAG) = PCXCOUNTFLAG THEN
            count := CARDINAL(databyte AND PCXCOUNTMASK);
            n := FIO.RdBin(hnd,databyte,1);
            FOR n := 1 TO count DO
                img.decodebuffer[p]:=databyte;
                INC(p);
            END;
        ELSE
            img.decodebuffer[p]:=databyte;
            INC(p);
        END;
    END;
END decodeScanline;

(* valid for 256 colors -- 8 bpp ONLY ! *)

PROCEDURE decodePCX (hnd:FIO.File;datapos,pos:LONGCARD;left,top:CARDINAL;usevesa:BOOLEAN);
VAR
    n,wibytecount : CARDINAL;
    h : PCXheaderType;
    lastx,lasty,x,y:CARDINAL;
BEGIN
    FIO.Seek(hnd,datapos+pos);
    n:=FIO.RdBin(hnd,h,SIZE(PCXheaderType));

    lastx    := CARDINAL (h.rightmargin-h.leftmargin);
    lasty    := CARDINAL (h.lowermargin-h.uppermargin);
    wibytecount := CARDINAL(h.NCP) * CARDINAL(h.NBS) -1;

    (*
        alternatively, we could directly decode to video screen,
        using Graph.Line for runs of the same color value...
        DRAW_LINE(x0,y0,x1,y1,n);
    *)

    FOR y := ymin TO lasty DO
        decodeScanline(hnd,wibytecount);
        FOR x := xmin TO lastx DO
            n := CARDINAL(img.decodebuffer[x]);
            (* IF ((x <= xmax) AND (y <= ymax)) THEN Graph.Plot(x,y,n);END; *)
            IF usevesa THEN
                VESAputpixel(left+x,top+y,n);
            ELSE
                SET_POINT(left+x,top+y,n);
            END;
        END;
    END;
END decodePCX;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    picdatatype = RECORD
        picaddr:LONGCARD;
        picsize:LONGCARD;
    END;

CONST
    firstpic = 1;     (* "000" *)
    maxpic   = 1000;  (* "999" *)
VAR
    lastpic : CARDINAL;
    picdata : ARRAY [firstpic..maxpic] OF picdatatype;

PROCEDURE buildpicname (digits,n:CARDINAL;ext:ARRAY OF CHAR; VAR R:ARRAY OF CHAR);
VAR
    ok:BOOLEAN;
    i:CARDINAL;
BEGIN
    Str.CardToStr( LONGCARD(n), R, 10,ok);
    FOR i:=Str.Length(R)+1 TO digits DO
        Str.Prepend(R,"0");
    END;
    Str.Append(R,ext);
END buildpicname;

PROCEDURE concatfile (hout:FIO.File;remaining:LONGCARD; S:ARRAY OF CHAR);
VAR
    hnd:FIO.File;
    wanted,got:CARDINAL;
BEGIN
    hnd:=FIO.OpenRead(S);
    FIO.AssignBuffer(hnd,ioBuffer);
    FIO.EOF:=FALSE;
    (*
    LOOP
        got:=FIO.RdBin(hnd,databuffer,dataBufferSize);
        IF got = 0 THEN EXIT; END;
        FIO.WrBin(hout,databuffer,got);
        IF got # dataBufferSize THEN EXIT; END;
    END;
    *)
    (* now, we need to take size of extracted data into account [0..n[ ! *)
    LOOP
        IF remaining = 0 THEN EXIT; END;
        IF remaining > dataBufferSize THEN
            wanted := dataBufferSize;
            DEC(remaining,dataBufferSize);
        ELSE
            wanted := CARDINAL(remaining);
            remaining := 0;
        END;
        got := FIO.RdBin(hnd,databuffer,wanted);
        FIO.WrBin(hout,databuffer,got);
    END;
    FIO.Close(hnd);
END concatfile;

(* ------------------------------------------------------------ *)

CONST
    bytesPerKB = 1024;
    remark = "REM ";
    bankMAGIC = "Q&D"+CHR(01AH);
    minspeed = 0;
    maxspeed = 31;
    defspeed = 4;
    mincycles= 0;
    maxcycles= 5000;
    defcycles= 10;
TYPE
    bankheadertype = RECORD
        ID    : ARRAY [0..3] OF CHAR;
        count : CARDINAL;
        ofsx  : CARDINAL;
        ofsy  : CARDINAL;
        samepal:BOOLEAN;  (* if same palette for all PCX *)
        wi,he : CARDINAL; (* background dimensions *)
    END;
    (* next is an array [1..count] of offsets,size in bank file for each picture *)
VAR
    S,R:str128;
    parmcount,i,opt,v1,v2:CARDINAL;
    state:(waiting);
    cmd:(unspecified,build,list,show);
    overwrite,verbose,batchmode,samepal,stopmouse,centered,buffered:BOOLEAN;
    singlestep,chk:BOOLEAN;
    ofsx,ofsy,wi,he,xpos,ypos,xxx,yyy,got,keycode,vmode,paper,speed,cycles,currcycle:CARDINAL;
    bankheader:bankheadertype;
    hout,hin:FIO.File;
    datapos,addr,paladdr:LONGCARD;
    fileBank : str128;
    xr,xg,xb:INTEGER;
    ignoreBagage,ok,flagRG,flagRB,flagGB,rndcolor:BOOLEAN;
    fsize:LONGCARD;
    usevesa,modex,doflip:BOOLEAN;
    wibytecount:CARDINAL;
    listPtr : vpointer;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    WrLn; (* here for pretty output *)

    parmcount := Lib.ParamCount();
    (* IF parmcount = 0 THEN abort(errHelp,"");END; *)

    fileBank  := baseFileBank; (* MUST be done ! *)
    cmd       := unspecified;
    overwrite := FALSE;
    verbose   := FALSE;
    stopmouse := FALSE;
    buffered  := TRUE;
    centered  := FALSE;
    samepal   := TRUE;
    singlestep:= FALSE;
    speed     := defspeed; (* was 6 for previous smaller data set *)
    vmode     := 0; (* was 3=360x200, now 320x240 *)
    paper     := 0; (* c_BLACK *)
    xr        := 0;
    xg        := 0;
    xb        := 0;
    flagRG    := FALSE;
    flagRB    := TRUE;
    flagGB    := FALSE;
    ofsx      := 0;
    ofsy      := 0; (* 23 with original files *)
    cycles    := defcycles;
    rndcolor  := TRUE;
    ignoreBagage:=FALSE;

    state     := waiting;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "B"+delim+"BUILD"+delim+
                                  "O"+delim+"OVERWRITE"+delim+
                                  "X:"+delim+
                                  "Y:"+delim+
                                  "V"+delim+"VERBOSE"+delim+
                                  "L"+delim+"LIST"+delim+
                                  "S"+delim+"SHOW"+delim+
                                  "M"+delim+"MOUSE"+delim+
                                  "M:"+delim+"MODE:"+delim+
                                  "P:"+delim+"PAPER:"+delim+
                                  "C"+delim+"CENTER"+delim+
                                  "S:"+delim+"SPEED:"+delim+
                                  "F"+delim+"FAST"+delim+
                                  "R:"+delim+"RED:"+delim+
                                  "G:"+delim+"GREEN:"+delim+
                                  "B:"+delim+"BLUE:"+delim+
                                  "RG"+delim+
                                  "RB"+delim+
                                  "GB"+delim+
                                  "C:"+delim+"CYCLES:"+delim+"N:"+delim+
                                  "K"+delim+"KEEP"+delim+
                                  "E"+delim+"EXTERNAL"+delim+
                                  "??"
                              );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5   : CASE cmd OF
                      | unspecified,build:cmd:=build;
                      ELSE abort(errNonsense,"");
                      END;
            | 6,7   : overwrite:=TRUE;
            | 8     : IF getCard(R,ofsx)=FALSE THEN abort(errBadVal,S);END;
            | 9     : IF getCard(R,ofsy)=FALSE THEN abort(errBadVal,S);END;
            | 10,11 : verbose:=TRUE;
            | 12,13 : CASE cmd OF
                      | unspecified,list:cmd:=list;
                      ELSE abort(errNonsense,"");
                      END;
            | 14,15 : CASE cmd OF
                      | unspecified,show:cmd:=show;
                      ELSE abort(errNonsense,"");
                      END;
            | 16,17:  stopmouse:=TRUE;
            | 18,19:  IF getCard(R,vmode)=FALSE THEN abort(errBadVal,S);END;
                      CASE vmode OF
                      | firstvmode..lastvmode : ;
                      ELSE abort(errBadMode,S);
                      END;
            | 20,21:  IF getCard(R,paper)=FALSE THEN abort(errBadVal,S);END;
                      CASE paper OF
                      | 0..255 : ;
                      ELSE abort(errBadPaper,S);
                      END;
            | 22,23:  centered:=TRUE;
            | 24,25:  IF getCard(R,speed)=FALSE THEN abort(errBadVal,S);END;
                      CASE speed OF
                      | minspeed..maxspeed : ;
                      ELSE abort(errBadSpeed,S);
                      END;
            | 26,27:  buffered:=FALSE;
            | 28,29:  IF getInt(R,xr)=FALSE THEN abort(errBadVal,S);END;
                      IF ABS(xr) > (255+1) THEN abort(errBadColor,S);END;
            | 30,31:  IF getInt(R,xg)=FALSE THEN abort(errBadVal,S);END;
                      IF ABS(xg) > (255+1) THEN abort(errBadColor,S);END;
            | 32,33:  IF getInt(R,xb)=FALSE THEN abort(errBadVal,S);END;
                      IF ABS(xb) > (255+1) THEN abort(errBadColor,S);END;
            | 34:     flagRB:=NOT(flagRB);
            | 35:     flagRG:=NOT(flagRG);
            | 36:     flagGB:=NOT(flagGB);
            | 37,38,39: IF getCard(R,cycles)=FALSE THEN abort(errBadVal,S);END;
                      CASE cycles OF
                      | mincycles..maxcycles : ;
                      ELSE abort(errBadCycles,S);
                      END;
            | 40,41:  rndcolor := FALSE;
            | 42,43:  ignoreBagage:=TRUE;
            | 44:     abort(errHelper,"");
            ELSE
                abort(errOption,S);
            END;
        ELSE
            CASE state OF
            | waiting :
                IF same(R,"?") THEN abort(errHelp,""); END;
                (*
                Str.Copy(source,R); (* keep upper case here *)
            ELSE
                *)
                abort(errTooManyParameters,S);
            END;
            INC(state);
        END;
    END;
    IF cmd=unspecified THEN cmd:=show;END;
    CASE cmd OF
    | build:
        IF FIO.Exists(fileBank) THEN
            IF overwrite=FALSE THEN abort(errFound,fileBank);END;
        END;
        lastpic:=firstpic-1;
        LOOP
            INC(lastpic);
            buildpicname(fileDigits,lastpic-1,extPCX,S);
            IF FIO.Exists(S)=FALSE THEN EXIT; END;
            IF lastpic > maxpic THEN abort(errTooManyMatches,"");END;
            IF chkPCX256(S,v1,v2)=FALSE THEN abort(errNotPicture,S);END;
            IF ((v1 > xmaximum) OR (v2 > ymaximum)) THEN abort(errDimensions,S);END;
            IF lastpic=firstpic THEN wi:=v1; he:=v2; END;
            picdata[lastpic].picsize:=getFileSize(S);
            IF samepal THEN
                IF lastpic # firstpic THEN
                    DEC(picdata[lastpic].picsize,palsize+palidsize);
                END;
            END;
        END;
        DEC(lastpic);
        IF lastpic < firstpic THEN abort(errNoMatch,"");END;

        (* IF verbose THEN WrLn;END; *)

        WrStr(Banner);WrLn;
        WrLn;

        bankheader.ID      := bankMAGIC;
        bankheader.count   := lastpic;
        bankheader.ofsx    := ofsx;
        bankheader.ofsy    := ofsy;
        bankheader.samepal := samepal;
        bankheader.wi      := wi;
        bankheader.he      := he;

        hout:=FIO.Create(fileBank);
        FIO.AssignBuffer(hout,ioBufferOut);
        FIO.WrBin(hout,bankheader,SIZE(bankheader));
        addr:=SIZE(bankheader)+ LONGCARD(lastpic) * SIZE(picdatatype);
        FOR i:=firstpic TO lastpic DO
            picdata[i].picaddr:=addr;
            FIO.WrBin(hout,picdata[i],SIZE(picdata[i]));
            IF verbose THEN
                IO.WrCard(i,fileDigits);WrStr(" : ");
                fmtVal(picdata[i].picaddr,16,8,"0",S);WrStr("addr=$");WrStr(S);
                fmtVal(picdata[i].picsize,10,8," ",S);WrStr("  L=");WrStr(S);
                fmtVal(picdata[i].picsize,16,8,"0",S);WrStr("  ($");WrStr(S);WrStr(")");WrLn;
            END;
            INC(addr,picdata[i].picsize);
        END;

        IF verbose THEN WrLn;END;

        (* now concatenate PCX files *)

        FOR i:=firstpic TO lastpic DO
            buildpicname(fileDigits,i-1,extPCX,S);
            concatfile(hout,picdata[i].picsize,S);
        END;

        FIO.Flush(hout);
        FIO.Close(hout);

        WrStr(fileBank);WrStr(" has been created.");WrLn;
    | list:
        IF FIO.Exists(fileBank)=FALSE THEN abort(errNotFound,fileBank);END;
        batchmode:=IsRedirected();
        hin:=FIO.OpenRead(fileBank);
        FIO.AssignBuffer(hin,ioBuffer);
        got:=FIO.RdBin(hin,bankheader,SIZE(bankheader));
        IF got # SIZE(bankheader) THEN
            FIO.Close(hin);
            abort(errReadError,fileBank);
        END;
        IF same(bankheader.ID,bankMAGIC)=FALSE THEN
            FIO.Close(hin);
            abort(errFormat,fileBank);
        END;
        lastpic:=bankheader.count;
        got:=FIO.RdBin(hin, picdata, lastpic * SIZE(picdatatype) );
        FIO.Close(hin);

        samepal:=bankheader.samepal;

        ofsx:=bankheader.ofsx;
        ofsy:=bankheader.ofsy;
        fmtVal( LONGCARD(ofsx),10,4," ",S);Str.Prepend(S,"ofsx = ");
        fmtVal( LONGCARD(ofsy),10,4," ",R);Str.Prepend(R,"ofsy = ");
        IF batchmode THEN
            Str.Prepend(S,remark);
            Str.Prepend(R,remark);
            WrStr("@ECHO OFF");WrLn;
            WrLn;
        END;
        WrStr(S);WrLn;
        WrStr(R);WrLn;
        WrLn;

        IF (samepal AND batchmode) THEN
            paladdr:= picdata[firstpic].picaddr+picdata[firstpic].picsize-palsize-palidsize;
            S:=filePal;
            Str.Prepend(S," ");
            Str.Prepend(S,baseFileBank);
            Str.Prepend(S,"-o ");
            Str.Prepend(S,"XTRACT ");
            fmtVal(paladdr,16,8,"0",R);
            Str.Append(S," $");Str.Append(S,R);
            fmtVal(palsize+palidsize,10,8,"",R);
            Str.Append(S," L");Str.Append(S,R);
            WrStr(S);WrLn;
            WrLn;
        END;
        FOR i:=firstpic TO lastpic DO
            IF batchmode THEN
                IF (samepal AND (i # firstpic)) THEN
                    S:=fileTmp;
                    Str.Prepend(S," ");
                    Str.Prepend(S,baseFileBank);
                    Str.Prepend(S,"-o ");
                    Str.Prepend(S,"XTRACT ");

                    fmtVal(picdata[i].picaddr,16,8,"0",R);
                    Str.Append(S," $");Str.Append(S,R);
                    fmtVal(picdata[i].picsize,10,8,"",R);
                    Str.Append(S," L");Str.Append(S,R);
                    WrStr(S);WrLn;

                    buildpicname(fileDigits,i-1,extPCX,S);
                    Str.Prepend(S,"COPY /B "+fileTmp+"+"+filePal+" ");
                    WrStr(S);WrLn;
                ELSE
                    buildpicname(fileDigits,i-1,extPCX,S);
                    Str.Prepend(S," ");
                    Str.Prepend(S,baseFileBank);
                    IF overwrite THEN Str.Prepend(S,"-o ");END;
                    Str.Prepend(S,"XTRACT ");

                    fmtVal(picdata[i].picaddr,16,8,"0",R);
                    Str.Append(S," $");Str.Append(S,R);
                    fmtVal(picdata[i].picsize,10,8,"",R);
                    Str.Append(S," L");Str.Append(S,R);
                    WrStr(S);WrLn;
                END;
            ELSE
                IO.WrCard(i,fileDigits);WrStr(" : ");
                fmtVal(picdata[i].picaddr,16,8,"0",S);WrStr("addr=$");WrStr(S);
                fmtVal(picdata[i].picsize,10,8," ",S);WrStr("  L=");WrStr(S);
                fmtVal(picdata[i].picsize,16,8,"0",S);WrStr("  ($");WrStr(S);WrStr(")");WrLn;
            END;
        END;
        IF (samepal AND batchmode) THEN
            WrLn;
            WrStr("DEL "+filePal);WrLn;
            WrStr("DEL "+fileTmp);WrLn;
        END;
        IF batchmode THEN
            WrLn;
            WrStr("ECHO Done !");WrLn;
        END;

    | show:
        datapos:=0; (* default for external BINary data *)
        IF FIO.Exists(fileBank)=FALSE THEN
            Lib.ParamStr(fileBank,0);
            UpperCase(fileBank);
            Str.Subst(fileBank,extEXE,extBIN);
            IF FIO.Exists(fileBank)=FALSE THEN
                IF ignoreBagage THEN abort(errNotFound,fileBank);END;
                IF bagage(datapos,R) THEN
                    Str.Copy(fileBank,R);
                ELSE
                    abort(errNotFound,fileBank);
                END;
            END;
        END;
        hin:=FIO.OpenRead(fileBank);
        FIO.AssignBuffer(hin,ioBuffer);
        FIO.Seek(hin,datapos);
        got:=FIO.RdBin(hin,bankheader,SIZE(bankheader));
        IF got # SIZE(bankheader) THEN
            FIO.Close(hin);
            abort(errReadError,fileBank);
        END;
        IF same(bankheader.ID,bankMAGIC)=FALSE THEN
            FIO.Close(hin);
            abort(errFormat,fileBank);
        END;

        ok:=getModeInfos(vmode,  usevesa,xcount,ycount,videoMode,sMode);
        IF bankheader.wi > xcount THEN abort(errOversized,"width");END;
        IF bankheader.he > ycount THEN abort(errOversized,"height");END;

        lastpic:=bankheader.count;
        got:=FIO.RdBin(hin, picdata, lastpic * SIZE(picdatatype) );

        IF stopmouse THEN
            IF MsMouse.Reset()=MAX(INTEGER) THEN stopmouse := FALSE; END;
        END;

        IF usevesa THEN
            setvesamoderange(vmode,S);
            IF CheckVesaHere(FALSE,listPtr)=FALSE THEN abort(errNoVesa,""); END;
            IF ModeAvailable(listPtr,videoMode)=FALSE THEN abort(errNotAvailable,S); END;
            IF SetVesaMode(videoMode) = FALSE THEN HiresOFF; abort(errVesaProblem,S); END;
            IF getVESAmodeInfos (videoMode)=FALSE THEN abort(err104F01,"");END;
            IF initVESAbank()=FALSE THEN abort(err104F05,"");END;
        ELSE
            IF HiresON(vmode)=FALSE THEN HiresOFF;abort(errModeXproblem,sMode);END;

            IF buffered THEN
                viewpage:=page1;
                workpage:=page2;
                bkpage  :=page3;
                setviewwork(viewpage,workpage);
                cls(usevesa,paper);
            ELSE
                viewpage:=page1;
                workpage:=page1;
                bkpage  :=page1;
            END;
            setviewwork(viewpage,viewpage);
        END;
        modex :=NOT(usevesa);
        doflip:=( modex AND buffered );

        cls(usevesa,paper);
        IF doflip THEN
            COPY_PAGE(viewpage,workpage);
            setviewwork(viewpage,workpage);
        END;

        ofsx    :=bankheader.ofsx;
        ofsy    :=bankheader.ofsy;
        wi      :=bankheader.wi;
        he      :=bankheader.he;

        paladdr:= picdata[firstpic].picaddr+picdata[firstpic].picsize
                  -palsize-palidsize;
        INC(paladdr,palidsize); (* we don't need $0C marker ! *)
        newpalette(hin,datapos,paladdr);

        (* predefined order ! *)

        IF flagRG THEN changepalette(swapRG);END;
        IF flagRB THEN changepalette(swapRB);END;
        IF flagGB THEN changepalette(swapGB);END;

        FOR i:=1 TO ABS(xr) DO
            IF xr < 0 THEN
                changepalette(minusR);
            ELSE
                changepalette(plusR);
            END;
        END;
        FOR i:=1 TO ABS(xg) DO
            IF xg < 0 THEN
                changepalette(minusG);
            ELSE
                changepalette(plusG);
            END;
        END;
        FOR i:=1 TO ABS(xb) DO
            IF xb < 0 THEN
                changepalette(minusB);
            ELSE
                changepalette(plusB);
            END;
        END;

        INIT_RANDOM();
        FOR i:=1 TO RANDOM_INT(256) DO opt:=RANDOM_INT(256); END; (* warm me up *)

        IF centered THEN
           xpos:=(xcount-wi) DIV 2;
           ypos:=(ycount-he) DIV 2;
        ELSE
           xpos:=getrndrange ( xmin,xcount-wi);
           ypos:=getrndrange ( ymin,ycount-he);
        END;

        addr:=picdata[firstpic].picaddr;
        decodePCX (hin,datapos,addr,xpos,ypos,usevesa);
        IF doflip THEN COPY_PAGE(workpage,bkpage); END;
        i:=firstpic;

        IF centered THEN cycles:=0; END;
        currcycle:=cycles;

        flushKeyboard();

        LOOP
            FOR opt:=1 TO speed DO SYNC_DISPLAY(); END;
            IF doflip THEN
                swap(viewpage,workpage);
                setviewwork(viewpage,workpage);
                COPY_BITMAP (bkpage,   xpos,ypos,xpos+wi-1,ypos+he-1,
                            workpage, xpos,ypos);
            END;
            IF i = firstpic THEN
                xxx:=xpos;
                yyy:=ypos;
            ELSE
                xxx:=xpos+ofsx;
                yyy:=ypos+ofsy;
            END;
            addr:=picdata[i].picaddr;
            decodePCX (hin,datapos,addr,xxx,yyy,usevesa);

            (* read and process key *)
            IF singlestep THEN
                WHILE getKeyboardCode(keycode)=FALSE DO
                END;
                chk:=(keycode # keySPACE);
                singlestep:=NOT(chk);
            ELSE
                chk:=getKeyboardCode(keycode);
            END;
            IF chk THEN
                CASE keycode OF
                | keyESC   : EXIT;
                | keyCR    : EXIT;
                | keySPACE : singlestep:=NOT (singlestep);
                | keyF8    : newpalette(hin,datapos,paladdr);

                | keyF1    : changepalette(plusR);
                | keyF2    : changepalette(minusR);
                | keyF3    : changepalette(plusG);
                | keyF4    : changepalette(minusG);
                | keyF5    : changepalette(plusB);
                | keyF6    : changepalette(minusB);

                | keyF9    : changepalette(swapRG);
                | keyF10   : changepalette(swapRB);
                | keyF11   : changepalette(swapGB);

                | keyMinus : IF speed < maxspeed THEN INC(speed);END;
                | keyPlus  : IF speed > minspeed THEN DEC(speed);END;

                | keyTab   :
                             xpos:=getrndrange ( xmin,xcount-wi);
                             ypos:=getrndrange ( ymin,ycount-he);
                             IF modex THEN setviewwork(viewpage,viewpage); END;

                             IF rndcolor THEN
                                 CASE RANDOM_INT(2) OF
                                 | 0 : changepalette(swapRG);
                                 | 1 : changepalette(swapRB);
                                 | 2 : changepalette(swapGB);
                                 END;
                             END;

                             cls(usevesa,paper);
                             IF doflip THEN
                                 COPY_PAGE(viewpage,workpage);
                                 setviewwork(viewpage,workpage);
                             END;
                             addr:=picdata[firstpic].picaddr;
                             decodePCX (hin,datapos,addr,xpos,ypos,usevesa);
                             IF doflip THEN COPY_PAGE(workpage,bkpage); END;
                             i:=firstpic;
                | keyLowerC,keyUpperC   :
                             xpos:=(xcount-wi) DIV 2;
                             ypos:=(ycount-he) DIV 2;
                             IF modex THEN setviewwork(viewpage,viewpage); END;
                             cls(usevesa,paper);
                             IF doflip THEN
                                 COPY_PAGE(viewpage,workpage);
                                 setviewwork(viewpage,workpage);
                             END;
                             addr:=picdata[firstpic].picaddr;
                             decodePCX (hin,datapos,addr,xpos,ypos,usevesa);
                             IF doflip THEN COPY_PAGE(workpage,bkpage); END;
                             i:=firstpic;
                END;
            END;

            IF stopmouse THEN
                IF mouseclick() THEN EXIT; END;
            END;
            INC(i);
            IF i > lastpic THEN
                i:=firstpic;
                IF cycles # 0 THEN
                    DEC(currcycle);
                    IF currcycle=0 THEN
                             xpos:=getrndrange ( xmin,xcount-wi);
                             ypos:=getrndrange ( ymin,ycount-he);
                             IF modex THEN setviewwork(viewpage,viewpage); END;

                             IF rndcolor THEN
                                 CASE RANDOM_INT(2) OF
                                 | 0 : changepalette(swapRG);
                                 | 1 : changepalette(swapRB);
                                 | 2 : changepalette(swapGB);
                                 END;
                             END;

                             cls(usevesa,paper);

                             IF doflip THEN
                                 COPY_PAGE(viewpage,workpage);
                                 setviewwork(viewpage,workpage);
                             END;
                             addr:=picdata[firstpic].picaddr;
                             decodePCX (hin,datapos,addr,xpos,ypos,usevesa);
                             IF doflip THEN COPY_PAGE(workpage,bkpage); END;
                             (* i:=firstpic; *)

                             currcycle:=cycles;
                    END;
                END;
            END;
        END;

        FIO.Close(hin);

        HiresOFF();

    END;

    abort(errNone,"");
END LavaLamp.

