
(* ---------------------------------------------------------------
Title         Q&D Plasma Fire demo
Author        PhG
Overview      tsk tsk...
Usage         see help
Notes         
              minimal error messages and checking, etc.
              model should definitely be LARGE
              use even coarser "pixels" ?
              another random generator providing integers ?
Bugs          still a weird effect when going downwards :
              a thin flickering at first 1/4 of screen

Wish List     tsk tsk...

--------------------------------------------------------------- *)

MODULE pFire;

IMPORT Lib;
IMPORT SYSTEM;
IMPORT IO;
IMPORT Str;
IMPORT BiosIO;
IMPORT MATHLIB;
IMPORT MsMouse;

FROM IO IMPORT WrStr, WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode;

FROM Lib IMPORT FarFill,FarWordMove;
FROM Storage IMPORT ALLOCATE;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    TSRAND = TRUE ; (* TRUE = M2 random generator, FALSE = homemade *)

CONST
    ProgEXEname   = "PFIRE";
    ProgTitle     = "Q&D Plasma Fire demo";
    ProgVersion   = "v1.1b";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone           = 0;
    errHelp           = 1;
    errIllegalParm    = 2;
    errUnknownOpt     = 3;
    errRange          = 4;
    errNeedBoth       = 5;
    errMissingRounds  = 6;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr         = CHR(13);
    lf         = CHR(10);
    nl         = cr+lf;
CONST
    (*
     00000000011111111112222222222333333333344444444445555555555666666666677777777778
     1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
    *)
    helpmsg =
    Banner+nl+
    nl+
    "Syntax : "+ProgEXEname+" [option]..."+nl+
    nl+
    "  -a   show palette until keypress or 10 seconds"+nl+
    "  -z   end on mouseclick too"+nl+
    "  -p:# color palette (0..9=rgbRGB1230)"+nl+
    "  -i:# intensity"+nl+
    "  -c   coarser resolution"+nl+
    "  -l:# lower intensity"+nl+
    "  -u:# upper intensity"+nl+
    "  -r:# rounds"+nl+
    "  -d   downwards"+nl+
    nl+
    "[rgbRGB1230]-palette, [d]-toggle direction, [c]-toggle coarseness"+nl+
    "[PageUp|PageDown|Home|End]-intensity, [Space]-pause, [Escape|Enter]-end"+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errIllegalParm :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," parameter !");
    | errUnknownOpt :
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errRange :
        Str.Concat(S,"Value for ",einfo);
        Str.Append(S," not in legal range !");
    | errNeedBoth:
        S := "Both lower and upper intensities are needed !";
    | errMissingRounds:
        S := "Number of rounds is needed !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        (* nada *)
    ELSE
        WrStr(ProgEXEname+" : ");
        WrStr(S);
        WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    keyEscape  = 01B00H;
    keySpace   = 02000H;
    keyCR      = 00D00H;
    upperR     = ORD("R") << 8 ;
    lowerR     = ORD("r") << 8 ;
    upperG     = ORD("G") << 8 ;
    lowerG     = ORD("g") << 8 ;
    upperB     = ORD("B") << 8 ;
    lowerB     = ORD("b") << 8 ;
    keyPageUp  = 00049H;
    keyPageDn  = 00051H;
    keyEnd     = 0004FH;
    keyHome    = 00047H;
    upperD     = ORD("D") << 8 ;
    lowerD     = ORD("d") << 8 ;
    upperC     = ORD("C") << 8 ;
    lowerC     = ORD("c") << 8 ;
    key1       = ORD("1") << 8 ;
    key2       = ORD("2") << 8 ;
    key3       = ORD("3") << 8 ;
    key0       = ORD("0") << 8 ;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

PROCEDURE input (maxWait:LONGINT); (* in seconds *)
VAR
    keycode:CARDINAL;
    h,m,s,ss:CARDINAL;
    start : LONGINT;
    now   : LONGINT;
BEGIN
    Lib.GetTime(h,m,s,ss);
    start := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
    LOOP
        IF getKeyboardCode(keycode) THEN EXIT; END;
        Lib.GetTime(h,m,s,ss);
        now := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
        IF ABS(now-start) > maxWait THEN EXIT; END;
    END;
END input;

(* ------------------------------------------------------------ *)

(*%T TSRAND *)

PROCEDURE getrndrange (lower,upper:CARDINAL):CARDINAL;
VAR
    range : CARDINAL;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN CARDINAL(rnd);
END getrndrange;

PROCEDURE doRandomize (  );
BEGIN
    Lib.RANDOMIZE;
END doRandomize;

(*%E  *)

(* ------------------------------------------------------------ *)

(*%F TSRAND *)

MODULE alea;
IMPORT Lib;
EXPORT doRandomize,getrndrange;

PROCEDURE XOR (b1,b2 : CARDINAL) : CARDINAL;
BEGIN
    RETURN CARDINAL ( (BITSET (b1) / BITSET (b2)) );
END XOR;

VAR
    seed : INTEGER;

PROCEDURE doRandomize (  );
VAR
    biosTimerTicksSinceMidnightLo [0040H:006CH] : CARDINAL; (* lohi=dword *)
    biosTimerTicksSinceMidnightHi [0040H:006EH] : CARDINAL;
    h,m,s,ss:CARDINAL;
BEGIN
    Lib.GetTime(h,m,s,ss);
    seed := XOR(biosTimerTicksSinceMidnightLo, s);
END doRandomize;

PROCEDURE getrndint ():INTEGER ;
BEGIN
    seed := (seed * 259 + 3) AND 32767;
    RETURN seed; (* [0..32767] *)
END getrndint;

PROCEDURE getrndrange (lower,upper:CARDINAL):CARDINAL;
VAR
    range : CARDINAL;
    v     : CARDINAL;
BEGIN
    range := upper-lower+1;
    v := lower + ( CARDINAL (getrndint()) MOD range );
    RETURN v;
END getrndrange;

END alea;

(*%E *)

(* ------------------------------------------------------------ *)

PROCEDURE ivalue (S:ARRAY OF CHAR;min,max:INTEGER;VAR r:INTEGER):BOOLEAN;
VAR
    v : LONGINT;
BEGIN
    IF GetLongInt(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGINT(min) THEN RETURN FALSE; END;
    IF v > LONGINT(max) THEN RETURN FALSE; END;
    r := INTEGER(v);
    RETURN TRUE;
END ivalue;

PROCEDURE value (S:ARRAY OF CHAR;min,max:CARDINAL;VAR r:CARDINAL):BOOLEAN;
VAR
    v : LONGCARD;
BEGIN
    IF GetLongCard(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGCARD(min) THEN RETURN FALSE; END;
    IF v > LONGCARD(max) THEN RETURN FALSE; END;
    r := CARDINAL(v);
    RETURN TRUE;
END value;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

(* ------------------------------------------------------------ *)

CONST
    maxWaitInSeconds = 10;
TYPE
    palettetype = (redpal,greenpal,bluepal,rpal,gpal,bpal,
                   palrouge,palvert,palbleu,palgris);

CONST
    hires       = 13H; (* 320x200x256 *)
    text        = 03H; (* 80x25 *)
    xcount      = 320;
    ycount      = 200;
    xmin        = 0;
    xmax        = xcount-1;
    ymin        = 0;
    ymax        = ycount-1;
    screensize  = xcount * ycount + xcount; (* added REQUIRED safety *)
    screensizeW =(screensize DIV 2);
    k           = 2;
    xcountX2    = xcount * k;
    birthcells  = 1; (* was 3 *)
    birthcellsX2= birthcells * k;
    ycountbirth      = ycount + birthcellsX2;
    ymaxbirth        = ymax   + birthcellsX2;
    screensizebirth  = xcount * ycountbirth;
    screensizebirthW = (screensizebirth DIV 2);
TYPE
    screenType = ARRAY [0..screensizebirth-1 +1] OF BYTE;   (* 320x200=64000 with security PLUS room for birth *)
VAR
    Screen        : POINTER TO screenType;
    SmoothScreen  : POINTER TO screenType;
VAR
    videoscreen [0A000H:0000H] : ARRAY [0..screensize-1] OF BYTE;
    Ybase                      : ARRAY [ymin..ymaxbirth] OF CARDINAL;

(* ------------------------------------------------------------ *)

PROCEDURE initYbase ();
VAR
    i,p:CARDINAL;
BEGIN
    p := 0;
    FOR i := ymin TO ymaxbirth DO
        Ybase[i]:=p;
        INC(p,xcount);
    END;
END initYbase;

PROCEDURE setVideoMode (mode:CARDINAL);
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AH := 00H;
    R.AL := BYTE(mode);
    Lib.Intr(R,10H);
END setVideoMode;

PROCEDURE WaitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END WaitVGAretrace;

(* ------------------------------------------------------------ *)

CONST
    black       = LONGCARD(0000000H);
    white       = LONGCARD(03F3F3FH); (* ega/vga range is $00..$3F *)
    red         = LONGCARD(03F0000H);
    green       = LONGCARD(0003F00H);
    darkgreen   = LONGCARD(0002000H);
    blue        = LONGCARD(000003FH);
    darkblue    = LONGCARD(0000020H);
    cyan        = LONGCARD(0002F3FH);
    yellow      = LONGCARD(03F3F00H);
    darkred     = LONGCARD(0200000H);
    orange      = LONGCARD(02F2F00H);
CONST
    egarange = 40H;
    mininkindex = 0;
    maxinkindex = 256-1;
    ndxblack = mininkindex;

PROCEDURE setDAC(index:CARDINAL;red,green,blue:BYTE);
CONST
    DACWriteIndex  = 03C8H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACWriteIndex,SHORTCARD(index));
    SYSTEM.Out (DACDataRegister, red);
    SYSTEM.Out (DACDataRegister, green);
    SYSTEM.Out (DACDataRegister, blue);
END setDAC;

PROCEDURE readDACrgb (index:CARDINAL):LONGCARD;
CONST
    DACReadIndex   = 03C7H;
    DACDataRegister= 03C9H;
VAR
    r,g,b:SHORTCARD;
    rgb : LONGCARD;
BEGIN
    SYSTEM.Out (DACReadIndex,SHORTCARD(index));
    r:=SYSTEM.In (DACDataRegister);
    g:=SYSTEM.In (DACDataRegister);
    b:=SYSTEM.In (DACDataRegister);
    rgb := (LONGCARD(r) << 16) + (LONGCARD(g) << 8) + LONGCARD(b);
    RETURN rgb;
END readDACrgb;

PROCEDURE resetdac (index,red,green,blue:CARDINAL);
BEGIN
    setDAC(index,BYTE(red),BYTE(green),BYTE(blue));
END resetdac;

PROCEDURE blend (ndx,count:CARDINAL; startink, endink:LONGCARD);
CONST
    rshift = LONGCARD(16);
    gshift = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    i : CARDINAL;
BEGIN
    IF count=0 THEN count := 1; END; (* safety to avoid division by 0 ! *)

    r1 := INTEGER (startink >> rshift) MOD egarange;
    g1 := INTEGER (startink >> gshift) MOD egarange;
    b1 := INTEGER (startink          ) MOD egarange;
    r2 := INTEGER (endink   >> rshift) MOD egarange;
    g2 := INTEGER (endink   >> gshift) MOD egarange;
    b2 := INTEGER (endink            ) MOD egarange;

    FOR i := 1 TO count DO
        r := r1 + ((r2 - r1) * INTEGER(i) ) DIV INTEGER(count);
        g := g1 + ((g2 - g1) * INTEGER(i) ) DIV INTEGER(count);
        b := b1 + ((b2 - b1) * INTEGER(i) ) DIV INTEGER(count);
        IF r < 0 THEN r:=0; END;
        IF g < 0 THEN g:=0; END;
        IF b < 0 THEN b:=0; END;
        IF r >= egarange THEN r:=egarange-1; END;
        IF g >= egarange THEN g:=egarange-1; END;
        IF b >= egarange THEN b:=egarange-1; END;
        setDAC(ndx+i-1,BYTE(r),BYTE(g),BYTE(b));
    END;
END blend;

PROCEDURE normalize (VAR lc:LONGCARD);
VAR
    r,g,b:CARDINAL;
BEGIN
    r := CARDINAL(lc MOD 100H);
    g := CARDINAL(lc DIV 100H) MOD 100H;
    b := CARDINAL(lc DIV 10000H);
    r := r >> 2; (* MOD egarange; *)
    g := g >> 2;
    b := b >> 2;
    lc := LONGCARD(b) << 16 + LONGCARD(g) << 8 + LONGCARD(r);
END normalize;

PROCEDURE newPalette (pal:palettetype);
CONST
    mypal = TRUE;
VAR
    ndx : CARDINAL;
    n   : CARDINAL;
    i,j  : CARDINAL;
    r,g,b:BYTE;
BEGIN
    WaitVGAretrace(); (* reduce noise on screen *)
    CASE pal OF
(*%F mypal  *)
    | redpal:
        ndx := 0;         n := 32;
        blend (ndx,n,01F1F03H,02F0804H);
        INC(ndx,n);       n := 96;
        blend (ndx,n,02F0804H,03F2F2FH);
        INC(ndx,n);       n := 128;
        blend (ndx,n,03F2F2FH,03F3F3FH);
    | greenpal:
        ndx := 0;         n := 32;
        blend (ndx,n,00F1F03H,0082F04H);
        INC(ndx,n);       n := 128;
        blend (ndx,n,0082F04H,01F3F1FH);
        INC(ndx,n);       n := 96;
        blend (ndx,n,01F3F1FH,03F3F3FH);
    | bluepal:
        ndx := 0;         n := 32;
        blend (ndx,n,00F1F03H,004082FH);
        INC(ndx,n);       n := 128;
        blend (ndx,n,004082FH,01F1F3FH);
        INC(ndx,n);       n := 96;
        blend (ndx,n,01F1F3FH,03F3F3FH);
    | rpal:
        ndx := 0;         n := 32;
        blend (ndx,n,01F1F03H,02F0804H);
        INC(ndx,n);       n := 128;
        blend (ndx,n,02F0804H,yellow);
        INC(ndx,n);       n := 96;
        blend (ndx,n,yellow,white);
    | gpal:
        ndx := 0;         n := 32;
        blend (ndx,n,00F1F03H,0082F04H);
        INC(ndx,n);       n := 128;
        blend (ndx,n,0082F04H,yellow);
        INC(ndx,n);       n := 96;
        blend (ndx,n,yellow,white);
    | bpal:
        ndx := 0;         n := 32;
        blend (ndx,n,00F1F03H,004082FH);
        INC(ndx,n);       n := 128;
        blend (ndx,n,004082FH,cyan);
        INC(ndx,n);       n := 96;
        blend (ndx,n,cyan,white);
(*%E  *)
(*%T mypal  *)
    | redpal :
	FOR i:= 0 TO 84 DO
	    resetdac(i      ,0+(i*63)DIV 85,0        ,0); (* black red *)
	END;
	FOR i:= 0 TO 84 DO
	    resetdac(i+85   ,255      ,0+(i*63)DIV 85,0); (* red yellow *)
	END;
	FOR i:= 0 TO 84 DO
	    resetdac(i+85+85,255      ,255      ,0+(i*63)DIV 85); (* yellow white *)
	END;
    | greenpal:
	FOR i:= 0 TO 84 DO
	    resetdac(i      ,0        ,0+(i*63) DIV 85,0); (* black green *)
	END;
	FOR i:= 0 TO 84 DO
	    resetdac(i+85   ,0+(i*63) DIV 85,255      ,0); (* green yellow *)
	END;
	FOR i:= 0 TO 84 DO
	    resetdac(i+85+85,255      ,255      ,0+(i*63) DIV 85); (* yellow white *)
	END;
    | bluepal:
	FOR i:= 0 TO 84 DO
	    resetdac(i      ,0        ,0        ,0+(i*63) DIV 85); (* black blue *)
	END;
	FOR i:= 0 TO 84 DO
	    resetdac(i+85   ,0        ,0+(i*63) DIV 85,255); (* blue cyan *)
	END;
	FOR i:= 0 TO 84 DO
	    resetdac(i+85+85,0+(i*63) DIV 85,255      ,255); (* cyan white *)
	END;
    | rpal:
        ndx := 0;         n := 16;
        FOR i := 1 TO n DO resetdac(ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 64;
        blend (ndx,n,black,red);
        INC(ndx,n);       n := 48;
        blend (ndx,n,red,yellow);
        INC(ndx,n);       n := 128;
        blend (ndx,n,yellow,white);
    | gpal:
        ndx := 0;         n := 16;
        FOR i := 1 TO n DO resetdac(ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 64;
        blend (ndx,n,black,green);
        INC(ndx,n);       n := 48;
        blend (ndx,n,green,yellow);
        INC(ndx,n);       n := 128;
        blend (ndx,n,yellow,white);
    | bpal:
        ndx := 0;         n := 16;
        FOR i := 1 TO n DO resetdac(ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 64;
        blend (ndx,n,black,blue);
        INC(ndx,n);       n := 48;
        blend (ndx,n,blue,cyan);
        INC(ndx,n);       n := 128;
        blend (ndx,n,cyan,white);
    | palrouge:
        n := 0;
	    FOR i:=32 TO 64 DO
            r:= BYTE(i) ; g:= 0; b:= 0;
            FOR j:=1 TO 8 DO; setDAC(n,r,g,b);INC(n); END;
        END;
    | palvert:
        n := 0;
	    FOR i:=32 TO 64 DO
		    r:= 0; g:= BYTE(i); b:= 0;
            FOR j:=1 TO 8 DO; setDAC(n,r,g,b);INC(n); END;
        END;
    | palbleu:
        n := 0;
	    FOR i:=32 TO 64 DO
		    r:= 0; g:= 0; b:= BYTE(i);
            FOR j:=1 TO 8 DO; setDAC(n,r,g,b);INC(n); END;
        END;
    | palgris:
        n := 0;
	    FOR i:=32 TO 64 DO
		    r:= BYTE(i); g:= BYTE(i); b:= BYTE(i);
            FOR j:=1 TO 8 DO; setDAC(n,r,g,b);INC(n); END;
        END;
(*%E  *)
    END;
    CASE pal OF
    | palrouge,palvert,palbleu,palgris:
    ELSE
        setDAC(ndxblack,00H,00H,00H);
        setDAC(maxinkindex,3FH,3FH,3FH);
    END;
END newPalette;

PROCEDURE clearscreen (inkndx:CARDINAL);
BEGIN
    Lib.FarWordFill(FarADR(videoscreen[0]),screensizeW,(inkndx << 8 + inkndx));
END clearscreen;

PROCEDURE showPalette (  );
VAR
   i    : CARDINAL;
   xpos : CARDINAL;
   ypos : CARDINAL;
   p    : CARDINAL;
BEGIN
   clearscreen(ndxblack); (* index of sky, so black *)
   FOR i := 0 TO 255 DO
       FOR ypos := ymin TO ymax DO
           p := Ybase[ypos] + i; (* was ypos * xcount + i *)
           videoscreen[p]:=BYTE(i);
       END;
   END;
   input (maxWaitInSeconds);
END showPalette;

(* ------------------------------------------------------------ *)

PROCEDURE clearworkscreen();
BEGIN
    Lib.FarWordFill(FarADR(Screen^),screensizebirthW,(ndxblack << 8 + ndxblack)); (* zero flame buffer *)
END clearworkscreen;

PROCEDURE clearsmooth (  );
BEGIN
    Lib.FarWordFill(FarADR(SmoothScreen^),screensizebirthW,(ndxblack<<8 + ndxblack));
END clearsmooth;

PROCEDURE updatescreen();
BEGIN
    WaitVGAretrace;
    FarWordMove(FarADR(SmoothScreen^),FarADR(videoscreen[0]),screensizeW);
    FarWordMove(FarADR(SmoothScreen^),FarADR(Screen^),screensizebirthW);
END updatescreen;

PROCEDURE zplot (x,y:CARDINAL;ink:BYTE);
BEGIN
    Screen^[Ybase[y]+x]:=ink;
END zplot;

(* ------------------------------------------------------------ *)

PROCEDURE smooth (falling:BOOLEAN);
VAR
    x,y:CARDINAL;
    ink,inkl,inkr,inku,inkd:CARDINAL;
    inklu,inkld,inkru,inkrd:CARDINAL;
    p,px:CARDINAL;
BEGIN
    clearsmooth;
  IF falling THEN
    FOR y := ymin+1 TO ymaxbirth-1 DO
        p := Ybase[y];
        FOR x := xmin+1 TO xmax-1 DO
            px := p+x;
            ink :=CARDINAL(Screen^[px])   ;
            inkl:=CARDINAL(Screen^[px-1]) ;
            inkr:=CARDINAL(Screen^[px+1]) ;
            inku:=CARDINAL(Screen^[px-xcount]) ; (* x,y-1 *)
            ink := (ink + inkl +inkr + inku) >> 2;
            (* 255+255+255+255 DIV 4 = 255 ! *)
            (* IF ink > maxinkindex THEN ink := maxinkindex; END;  *)
            SmoothScreen^[px+xcount]:=BYTE(ink); (* plot at x,y+1 *)
        END;
    END;
  ELSE
    FOR y := ymin+1 TO ymaxbirth-1 DO
        p := Ybase[y]; (* useless to add +xcount ! -- was xcount * y *)
        FOR x := xmin+1 TO xmax-1 DO
            px := p+x;
            ink :=CARDINAL(Screen^[px])   ;
            inkl:=CARDINAL(Screen^[px-1]) ;
            inkr:=CARDINAL(Screen^[px+1]) ;
            inkd:=CARDINAL(Screen^[px+xcount]) ; (* x,y+1 *)
            ink := (ink + inkl +inkr + inkd) >> 2;
            (* 255+255+255+255 DIV 4 = 255 ! *)
            (* IF ink > maxinkindex THEN ink := maxinkindex; END;  *)
            SmoothScreen^[px-xcount]:=BYTE(ink); (* plot at x,y-1 *)
        END;
    END;
  END;
END smooth;

PROCEDURE burn (intensity:CARDINAL;falling:BOOLEAN );
VAR
    x,y:CARDINAL;
    newink:BYTE;
BEGIN
    updatescreen;
  IF falling THEN
    FOR x := xmin TO xmax DO
        newink := 0;
        IF getrndrange(0,99) < intensity THEN
           (* newink:=BYTE(getrndrange(0,255)); *)
            newink := maxinkindex;
        END;
        FOR y := ymin TO ymin+birthcells DO (* birth at top *)
            zplot(x,y,newink);
        END;
    END;
  ELSE
    FOR x := xmin TO xmax DO
        newink := 0;
        IF getrndrange(0,99) < intensity THEN
           (* newink:=BYTE(getrndrange(0,255)); *)
            newink := maxinkindex;
        END;
        FOR y := ymax+1 TO ymaxbirth DO (* birth at bottom *)
            zplot(x,y,newink);
        END;
    END;
  END;
END burn;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE smoothX2 (falling:BOOLEAN);
VAR
    x,y:CARDINAL;
    ink,inkl,inkr,inku,inkd:CARDINAL;
    inklu,inkld,inkru,inkrd:CARDINAL;
    p,px:CARDINAL;
BEGIN
    clearsmooth;
  IF falling THEN
    FOR y := ymin+k TO ymaxbirth-k BY k DO
        p := Ybase[y];
        FOR x := xmin+k TO xmax-k BY k DO
            px := p+x;
            ink :=CARDINAL(Screen^[px])   ;
            inkl:=CARDINAL(Screen^[px-k]) ;
            inkr:=CARDINAL(Screen^[px+k]) ;
            inku:=CARDINAL(Screen^[px-xcountX2]) ; (* dot up *)
            ink := (ink + inkl +inkr + inku) >> 2;
            (* 255+255+255+255 DIV 4 = 255 ! *)
            (* IF ink > maxinkindex THEN ink := maxinkindex; END;  *)
            SmoothScreen^[px+xcountX2]:=BYTE(ink);   (* plot at x  ,y+k *)
            SmoothScreen^[px+xcountX2+1]:=BYTE(ink);
            SmoothScreen^[px+xcountX2+xcount]:=BYTE(ink);
            SmoothScreen^[px+xcountX2+xcount+1]:=BYTE(ink);
        END;
    END;
  ELSE
    FOR y := ymin+k TO ymaxbirth-k BY k DO
        p := Ybase[y]; (* useless to add +xcount ! -- was xcount * y *)
        FOR x := xmin+k TO xmax-k BY k DO
            px := p+x;
            ink :=CARDINAL(Screen^[px])   ;
            inkl:=CARDINAL(Screen^[px-k]) ;
            inkr:=CARDINAL(Screen^[px+k]) ;
            inkd:=CARDINAL(Screen^[px+xcountX2]) ; (* dot down *)
            ink := (ink + inkl +inkr + inkd) >> 2;
            (* 255+255+255+255 DIV 4 = 255 ! *)
            (* IF ink > maxinkindex THEN ink := maxinkindex; END;  *)
            SmoothScreen^[px-xcountX2]:=BYTE(ink);   (* plot at x  ,y-k *)
            SmoothScreen^[px-xcountX2+1]:=BYTE(ink);
            SmoothScreen^[px-xcountX2-xcount]:=BYTE(ink);
            SmoothScreen^[px-xcountX2-xcount+1]:=BYTE(ink);
        END;
    END;
  END;
END smoothX2;

PROCEDURE burnX2 (intensity:CARDINAL;falling:BOOLEAN );
VAR
    x,y:CARDINAL;
    newink:BYTE;
BEGIN
    updatescreen;
  IF falling THEN
    FOR x := xmin TO xmax BY k DO
        newink := 0;
        IF getrndrange(0,99) < intensity THEN
           (* newink:=BYTE(getrndrange(0,255)); *)
            newink := maxinkindex;
        END;
        FOR y := ymin TO ymin+birthcellsX2 BY k DO (* birth at top *)
            zplot(x  ,y  ,newink); zplot(x+1,y  ,newink);
            zplot(x  ,y+1,newink); zplot(x+1,y+1,newink);
        END;
    END;
  ELSE
    FOR x := xmin TO xmax BY k DO
        newink := 0;
        IF getrndrange(0,99) < intensity THEN
           (* newink:=BYTE(getrndrange(0,255)); *)
            newink := maxinkindex;
        END;
        FOR y := ymax-k TO ymaxbirth-k BY k DO (* birth at bottom *)
            zplot(x  ,y  ,newink); zplot(x+1,y  ,newink);
            zplot(x  ,y+1,newink); zplot(x+1,y+1,newink);
        END;
    END;
  END;
END burnX2;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    minIntensity     = 5;
    maxIntensity     = 95;
    defaultIntensity = 35;
    intensitystep    = 5;
    undefined        = minIntensity-1;
    minRound         = 1;
    maxRound         = 1000;
VAR
    parmcount   : CARDINAL;
    i           : CARDINAL;
    opt         : CARDINAL;
    S           : str128;
    R           : str128;
    v           : CARDINAL;

    palette     : palettetype;
    stopmouse   : BOOLEAN;
    showpal     : BOOLEAN;
    intensity   : CARDINAL;
    coarse      : BOOLEAN;
    lowerintensity,upperintensity:CARDINAL;
    motion      : (none,plus,minus);
    lastround   : CARDINAL;
    rounds      : CARDINAL;
    falling     : BOOLEAN;

    keycode     : CARDINAL;
    singlestep  : BOOLEAN;
    chk         : BOOLEAN;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;                       (* must be here for pretty ulterior display ! *)

    palette      := redpal;
    stopmouse    := FALSE;
    showpal      := FALSE;
    intensity    := defaultIntensity;
    coarse       := FALSE;
    lowerintensity :=undefined;
    upperintensity :=undefined;
    lastround      :=0;
    falling        := FALSE;

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R)=TRUE THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "A"+delim+"SHOWPAL"+delim+
                                   "Z"+delim+"MOUSE"+delim+
                                   "P:"+delim+"PALETTE:"+delim+
                                   "I:"+delim+"INTENSITY:"+delim+
                                   "C"+delim+"COARSE"+delim+
                                   "L:"+delim+"LOWER:"+delim+
                                   "U:"+delim+"UPPER:"+delim+
                                   "R:"+delim+"ROUNDS:"+delim+
                                   "F"+delim+"FALL"
                               );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5 :
                showpal := TRUE;
            | 6,7:
                stopmouse:=TRUE;
            | 8,9:
                IF value(R,ORD(redpal),ORD(palgris),v)=FALSE THEN
                    abort(errRange,"palette");
                END;
                palette:=palettetype(v);
            | 10,11:
                IF value(R,minIntensity,maxIntensity,intensity)=FALSE THEN
                    abort(errRange,"intensity");
                END;
            | 12,13:
                coarse:=TRUE;
            | 14,15:
                IF value(R,minIntensity,maxIntensity,lowerintensity)=FALSE THEN
                    abort(errRange,"lower intensity");
                END;
            | 16,17:
                IF value(R,minIntensity,maxIntensity,upperintensity)=FALSE THEN
                    abort(errRange,"upper intensity");
                END;
            | 18,19:
                IF value(R,minRound,maxRound,lastround)=FALSE THEN
                    abort(errRange,"rounds");
                END;
            | 20,21:
                falling:=TRUE;
            ELSE
                abort(errUnknownOpt,S);
            END;
        ELSE
            abort(errIllegalParm,S);
        END;
    END;
    IF lowerintensity = undefined THEN
        IF upperintensity = undefined THEN
            motion := none;
        ELSE
            abort(errNeedBoth,"");
        END;
    ELSE
        IF upperintensity = undefined THEN
            abort(errNeedBoth,"");
        ELSE
            IF lastround = 0 THEN abort(errMissingRounds,"");END;
            rounds:=minRound;
            IF lowerintensity > upperintensity THEN
                i:=lowerintensity;
                lowerintensity:=upperintensity;
                upperintensity:=i;
            END;
            IF ABS(upperintensity-lowerintensity+1)<=intensitystep THEN
                upperintensity:=lowerintensity+intensitystep+1;
                IF upperintensity > maxIntensity THEN
                    upperintensity := maxIntensity;
                    lowerintensity := upperintensity-intensitystep-1;
                END;
            END;
            intensity := lowerintensity;
            motion := plus;
        END;
    END;

    doRandomize;

    initYbase;
    NEW(Screen);
    NEW(SmoothScreen);

    setVideoMode(hires);
    newPalette(palette);
    clearscreen(ndxblack);

    IF showpal THEN
        showPalette;
        clearscreen(ndxblack);
    END;

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    flushKeyboard;

    clearworkscreen;

    singlestep := FALSE;

    LOOP
        (* screen update *)
        IF coarse THEN
            smoothX2(falling);
            burnX2(intensity,falling);
        ELSE
            smooth(falling);
            burn(intensity,falling);
        END;
        (* auto motion *)
        CASE motion OF
        | none :
        | plus:
            INC(rounds);
            IF rounds>=lastround THEN
                rounds:=minRound;
                INC(intensity);
                IF intensity>=upperintensity THEN motion:=minus;END;
            END;
        | minus:
            INC(rounds);
            IF rounds>=lastround THEN
                rounds:=minRound;
                DEC(intensity);
                IF intensity<=lowerintensity THEN motion:=plus;END;
            END;
        END;
        (* read and process key *)
        IF singlestep THEN
            WHILE getKeyboardCode(keycode)=FALSE DO
            END;
            chk:=(keycode # keySpace);
            singlestep:=NOT(chk);
        ELSE
            chk:=getKeyboardCode(keycode);
        END;
        IF chk THEN
            CASE keycode OF
            | lowerR        : newPalette(redpal);
            | lowerG        : newPalette(greenpal);
            | lowerB        : newPalette(bluepal);
            | upperR        : newPalette(rpal);
            | upperG        : newPalette(gpal);
            | upperB        : newPalette(bpal);
            | key1          : newPalette(palrouge);
            | key2          : newPalette(palvert);
            | key3          : newPalette(palbleu);
            | key0          : newPalette(palgris);
            | keySpace      : singlestep:=NOT (singlestep);
            | keyEscape     : EXIT;
            | keyCR         : EXIT;
            | keyPageUp     : FOR i:=1 TO intensitystep DO
                                  IF intensity < maxIntensity THEN INC(intensity);END;
                              END;
            | keyPageDn     : FOR i:=1 TO intensitystep DO
                                  IF intensity > minIntensity THEN DEC(intensity);END;
                              END;
            | keyHome       : intensity := maxIntensity;
            | keyEnd        : intensity := minIntensity;
            | lowerD,upperD : falling := NOT(falling);
            | lowerC,upperC : coarse := NOT(coarse);
            END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;
    END;
    IF keycode = keyCR THEN
        FOR i := 1 TO 128 DO
            IF coarse THEN
                smoothX2(falling);
            ELSE
                smooth(falling);
            END;
            updatescreen;
        END;
    END;

    setVideoMode(text);
    WrStr("Intensity was ");
    IF intensity < 10 THEN
        IO.WrCard(intensity,1);
    ELSE
        IO.WrCard(intensity,2);
    END;
    WrLn;
    abort(errNone,"");
END pFire.
