(* ---------------------------------------------------------------
Title         see help
Author        see help
Overview      see help
Usage         see help
Notes         small model cannot be used, compact model recommended
              background should be black/index=0
              color indexes should be about egarange i.e. 64
              best (m, b1, b2) :
              2 0 0
              2 1 0
              2 0 1
              3 0 1
              4 1 1
              5
              6

              well, IN fact : 5 and 2 0 1

              bah, don't bother... just keep A B D M

Bugs          see help... er...
Wish List

--------------------------------------------------------------- *)

MODULE qdTitle;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;
IMPORT MsMouse;
IMPORT SYSTEM;
IMPORT BiosIO;
IMPORT MATHLIB;
IMPORT Graph;

FROM IO IMPORT WrStr,WrLn,WrCard;
FROM Lib IMPORT FarFill,FarWordMove;
FROM Storage IMPORT ALLOCATE;

FROM QD_ASCII IMPORT dash, slash, nullchar, tabchar, cr, lf, nl, bs,
space, dot, deg, doublequote, quote, colon, percent, vbar,
blank, equal, dquote, charnull, singlequote, antislash, dollar,
star, backslash, coma, question, underscore, tabul, hbar,
comma, semicolon, diese, pound, openbracket, closebracket, tilde, exclam,
stardotstar, dotdot, escCh, escSet, letters, digits,
lettersUpp, lettersLow, openbrace, closebrace;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits, metaproc, getCli, argc, argv;

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "TITLE";
    ProgTitle     = "Q&D PCX Title";
    ProgVersion   = "v1.0c";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    extPCX        = ".PCX";
    extEXE        = ".EXE";
    basepcx       = "PCX"+extPCX;
CONST
    errNone             = 0;
    errHelp             = 1;
    errSyntax           = 2;
    errNoJokers         = 3;
    errNotFound         = 4;
    errNotPCX           = 5;
    errUnsupportedPCX   = 6;
    errCannotLoadPCX    = 7; (* catch'em all ! *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    msgHelp =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [source["+extPCX+"]]"+nl+
nl+
"a) Source picture file must be a 320x200x256 PCX file ;"+nl+
"   it may be appended to executable using CONCAT utility in binary mode."+nl+
"b) A pixel is on or off : its color is ignored ;"+nl+
"   for best effect, a black background is recommended."+nl;



VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msgHelp);
    | errSyntax:
        S:="Syntax error, please check help screen !";
    | errNoJokers:
        S:="Jokers are not supported in <source> specification !";
    | errNotFound:
        Str.Concat(S,einfo," does not exist !");
    | errNotPCX:
        Str.Concat(S,einfo," does not seem to be a v5.0 RLE encoded PCX file !");
    | errUnsupportedPCX:
        Str.Concat(S,einfo," is not a 320x200x256 PCX file !");
    | errCannotLoadPCX:
        S:="Error while trying to load PCX file !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp:
        ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE getrndrangeint (lower,upper:INTEGER):INTEGER;
VAR
    range : INTEGER;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN INTEGER(rnd);
END getrndrangeint;

PROCEDURE getrndrange (lower,upper:CARDINAL):CARDINAL;
VAR
    range : CARDINAL;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN CARDINAL(rnd);
END getrndrange;

PROCEDURE doRandomize (  );
BEGIN
    Lib.RANDOMIZE;
END doRandomize;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

CONST
    keyEscape  = 01B00H;
    keySpace   = 02000H;
    keyCR      = 00D00H;
    upperR     = ORD("R") << 8 ;
    lowerR     = ORD("r") << 8 ;
    upperG     = ORD("G") << 8 ;
    lowerG     = ORD("g") << 8 ;
    upperB     = ORD("B") << 8 ;
    lowerB     = ORD("b") << 8 ;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
VAR
    ioBuffer : ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    hnd      : FIO.File; (* globerk *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    dosEXEheaderType = RECORD (* well, a portion of... *)
        magic1 : CHAR;
        magic2 : CHAR;
        sizemod512 : CARDINAL;
        sizediv512 : CARDINAL; (* -1 required before *512 ! *)
    END;
    (*
    fsize := FIO.Size(exefile);
    exe.sizemod512 := CARDINAL(fsize) MOD 512;
    exe.sizediv512 := CARDINAL((fsize+511) DIV 512);
    *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE setVideoMode (mode:CARDINAL);
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AH := 00H;
    R.AL := BYTE(mode);
    Lib.Intr(R,10H);
END setVideoMode;

PROCEDURE waitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END waitVGAretrace;

PROCEDURE pause (n:CARDINAL);
VAR
    i:CARDINAL;
BEGIN
    FOR i := 1 TO n DO
        waitVGAretrace();
    END;
END pause;

(* ------------------------------------------------------------ *)

TYPE
    fixedpal64type = ARRAY [0..64*3-1] OF BYTE;
CONST
    fixedfirepal = fixedpal64type(
     0, 0, 0,
     1, 0, 0,
     2, 0, 0,
    10, 0, 0,
    18, 0, 0,
    26, 0, 0,
    32, 0, 0,
    36, 0, 0,
    39, 0, 0,
    42, 0, 0,
    46, 1, 0,
    50, 3, 0,
    54, 5, 0,
    58, 7, 0,
    63, 9, 0,
    63,11, 0,
    63,13, 0,
    63,15, 0,
    63,17, 0,
    63,19, 0,
    63,21, 0,
    63,23, 0,
    63,25, 0,
    63,27, 0,
    63,29, 0,
    63,31, 0,
    63,33, 0,
    63,35, 0,
    63,38, 0,
    63,40, 0,
    63,42, 0,
    63,44, 0,
    63,46, 0,
    63,48, 0,
    63,50, 0,
    63,52, 0,
    63,53, 0,
    63,54, 0,
    63,54, 0,
    63,55, 0,
    63,56, 0,
    63,57, 0,
    63,58, 0,
    63,59, 0,
    63,60, 0,
    63,61, 0,
    63,62, 0,
    63,63, 1,
    63,63, 5,
    63,63, 9,
    63,63,12,
    63,63,16,
    63,63,20,
    63,63,23,
    63,63,27,
    63,63,31,
    63,63,34,
    63,63,38,
    63,63,42,
    63,63,45,
    63,63,49,
    63,63,52,
    63,63,56,
    63,63,60);

CONST
    black       = LONGCARD(0000000H);
    white       = LONGCARD(03F3F3FH); (* ega/vga range is $00..$3F *)
    red         = LONGCARD(03F0000H);
    green       = LONGCARD(0003F00H);
    darkgreen   = LONGCARD(0002000H);
    blue        = LONGCARD(000003FH);
    darkblue    = LONGCARD(0000020H);
    cyan        = LONGCARD(0002F3FH);
    yellow      = LONGCARD(03F3F00H);
    darkred     = LONGCARD(0200000H);
    orange      = LONGCARD(02F2F00H);

CONST
    egarange     = 40H;
    mininkindex  = 0;
    maxinkindex  = 256-1;
    ndxblack     = mininkindex;
    maxcolorindex=egarange-1; (* we use 64 colors palette here *)
    ndxwhite     = maxinkindex;

TYPE
    triplet = RECORD
        r,g,b:SHORTCARD;
    END;
VAR
    orgpal     : ARRAY [0..255] OF triplet;

PROCEDURE setDAC(index:CARDINAL;red,green,blue:BYTE);
CONST
    DACWriteIndex  = 03C8H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACWriteIndex,SHORTCARD(index));
    SYSTEM.Out (DACDataRegister, red);
    SYSTEM.Out (DACDataRegister, green);
    SYSTEM.Out (DACDataRegister, blue);
END setDAC;

PROCEDURE resetdac(slow:BOOLEAN;index,red,green,blue:CARDINAL);
BEGIN
    IF slow THEN pause(1);END;
    setDAC(index,BYTE(red),BYTE(green),BYTE(blue));
END resetdac;

PROCEDURE getDAC (index:CARDINAL;VAR r,g,b:SHORTCARD);
CONST
    DACReadIndex   = 03C7H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACReadIndex,SHORTCARD(index));
    r:=SYSTEM.In (DACDataRegister);
    g:=SYSTEM.In (DACDataRegister);
    b:=SYSTEM.In (DACDataRegister);
END getDAC;

PROCEDURE readDACrgb (index:CARDINAL):LONGCARD;
VAR
    r,g,b:SHORTCARD;
    rgb : LONGCARD;
BEGIN
    getDAC(index,r,g,b);
    rgb := (LONGCARD(r) << 16) + (LONGCARD(g) << 8) + LONGCARD(b);
    RETURN rgb;
END readDACrgb;

PROCEDURE savesystempal (  );
VAR
    i:CARDINAL;
BEGIN
    FOR i := 0 TO 255 DO
        getDAC(i,orgpal[i].r,orgpal[i].g,orgpal[i].b);
    END;
END savesystempal;

PROCEDURE blend (slow:BOOLEAN;ndx,count:CARDINAL; startink, endink:LONGCARD);
CONST
    rshift = LONGCARD(16);
    gshift = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    i : CARDINAL;
BEGIN
    IF count=0 THEN count := 1; END; (* safety to avoid division by 0 ! *)

    r1 := INTEGER (startink >> rshift) MOD egarange;
    g1 := INTEGER (startink >> gshift) MOD egarange;
    b1 := INTEGER (startink          ) MOD egarange;
    r2 := INTEGER (endink   >> rshift) MOD egarange;
    g2 := INTEGER (endink   >> gshift) MOD egarange;
    b2 := INTEGER (endink            ) MOD egarange;

    FOR i := 1 TO count DO
        r := r1 + ((r2 - r1) * INTEGER(i) ) DIV INTEGER(count);
        g := g1 + ((g2 - g1) * INTEGER(i) ) DIV INTEGER(count);
        b := b1 + ((b2 - b1) * INTEGER(i) ) DIV INTEGER(count);
        IF r < 0 THEN r:=0; END;
        IF g < 0 THEN g:=0; END;
        IF b < 0 THEN b:=0; END;
        IF r >= egarange THEN r:=egarange-1; END;
        IF g >= egarange THEN g:=egarange-1; END;
        IF b >= egarange THEN b:=egarange-1; END;
        IF slow THEN pause(1);END;
        setDAC(ndx+i-1,BYTE(r),BYTE(g),BYTE(b));
    END;
END blend;

TYPE
    palettetype = (firepal,rpal,gpal,bpal,blackpal,whitepal,
                   rougepal,vertpal,bleupal,
                   systempal);

PROCEDURE newPalette64 (pal:palettetype;slow:BOOLEAN);
VAR
    ndx,n,i,j   : CARDINAL;
    r,g,b:BYTE;
    ir,ig,ib:CARDINAL;
BEGIN
    pause(1); (* reduce noise on screen *)
    CASE pal OF
    | rpal:
        ndx := 0;         n := 2;
        FOR i := 1 TO n DO resetdac(slow,ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 8;
        blend (slow,ndx,n,black,darkred);
        INC(ndx,n);       n := 19;
        blend (slow,ndx,n,darkred,red);
        INC(ndx,n);       n := 19;
        blend (slow,ndx,n,red,yellow);
        INC(ndx,n);       n := 16;
        blend (slow,ndx,n,yellow,white);
    | gpal:
        ndx := 0;         n := 2;
        FOR i := 1 TO n DO resetdac(slow,ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 12;
        blend (slow,ndx,n,black,darkgreen);
        INC(ndx,n);       n := 14;
        blend (slow,ndx,n,darkgreen,green);
        INC(ndx,n);       n := 20;
        blend (slow,ndx,n,green,yellow);
        INC(ndx,n);       n := 16;
        blend (slow,ndx,n,yellow,white);
    | bpal:                           (* 2 18 14 30 *)
        ndx := 0;         n := 2;
        FOR i := 1 TO n DO resetdac(slow,ndx+i-1,00H,00H,00H);END;
        INC(ndx,n);       n := 8;
        blend (slow,ndx,n,black,darkblue);
        INC(ndx,n);       n := 8;
        blend (slow,ndx,n,darkblue,blue);
        INC(ndx,n);       n := 20;
        blend (slow,ndx,n,blue,cyan);
        INC(ndx,n);       n := 26;
        blend (slow,ndx,n,cyan,white);
    | firepal:
        FOR ndx:= 0 TO egarange-1 DO
            IF slow THEN pause(1);END;
            n := ndx*3;
            setDAC(ndx,fixedfirepal[n],fixedfirepal[n+1],fixedfirepal[n+2]);
        END;
    | blackpal:
        FOR ndx:= 0 TO egarange-1 DO
            IF slow THEN pause(1);END;
            setDAC(ndx,0,0,0);
        END;
    | whitepal:
        FOR ndx:= 0 TO egarange-1 DO
            IF slow THEN pause(1);END;
            setDAC(ndx,3FH,3FH,3FH);
        END;
    | rougepal:
        ndx:=0;
        FOR i := 32 TO 64 DO
            r:= BYTE(i); g:= 0; b:= 0; j:=i DIV 2;
            FOR j:= 1 TO 4 DO setDAC(ndx,r,g,b);INC(ndx);END;
        END;
    | vertpal:
        ndx:=0;
        FOR i := 32 TO 64 DO
		    r:= 0; g:= BYTE(i); b:= 0; j:= (i+64) DIV 2;
            FOR j:= 1 TO 4 DO setDAC(ndx,r,g,b);INC(ndx);END;
        END;
    | bleupal:
        ndx:=0;
        FOR i := 32 TO 64 DO
		    r:= 0; g:= 0; b:= BYTE(i); j := (i+128) DIV 2;
            FOR j:= 1 TO 4 DO setDAC(ndx,r,g,b);INC(ndx);END;
		END;
    | systempal: (* assume it was saved ! *)
        FOR i := 0 TO 255 DO
            setDAC(i,orgpal[i].r,orgpal[i].g,orgpal[i].b);
        END;
    END;
    setDAC(ndxblack,00H,00H,00H);    (* safety 0=black *)
    (* setDAC(ndxwhite,3FH,3FH,3FH);    (* safety 63=white *) *)
    n := maxinkindex-egarange+1;
    blend (FALSE,egarange,n,black,black);  (* 64..255=black *)
END newPalette64;

PROCEDURE palfadeto (r,g,b:SHORTCARD);
VAR
    i,changed:CARDINAL;
    rr,gg,bb:SHORTCARD;
BEGIN
    LOOP
        changed:=0;
        pause(1);
        FOR i:=mininkindex TO maxinkindex DO
            getDAC (i, rr,gg,bb);
            IF rr # r THEN
                IF rr < r THEN
                    INC(rr);
                ELSE
                    DEC(rr);
                END;
                INC(changed);
            END;
            IF gg # g THEN
                IF gg < g THEN
                    INC(gg);
                ELSE
                    DEC(gg);
                END;
                INC(changed);
            END;
            IF bb # b THEN
                IF bb < b THEN
                    INC(bb);
                ELSE
                    DEC(bb);
                END;
                INC(changed);
            END;

            setDAC(i, rr,gg,bb);
        END;
        IF changed=0 THEN EXIT; END;
    END;
END palfadeto;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    hires       = 13H; (* 320x200x256 *)
    text        = 03H; (* 80x25 *)
    xcount      = 320;
    ycount      = 200;
    xmin        = 0;
    xmax        = xcount-1;
    ymin        = 0;
    ymax        = ycount-1;
    cx          = xmax DIV 2;
    cy          = ymax DIV 2;
    screensize  = xcount * ycount;
    screensizeW =(screensize DIV 2);
TYPE
    screenType = ARRAY [0..screensize-1 +xcount] OF BYTE;   (* 320x200=64000 with security *)
VAR
    WorkScreen    : POINTER TO screenType;
    NextWorkScreen: POINTER TO screenType; (* for double buffer *)
    SmoothScreen  : POINTER TO screenType;
VAR
    videoscreen [0A000H:0000H] : ARRAY [0..screensize-1] OF BYTE;
    Ybase                      : ARRAY [ymin..ymax] OF CARDINAL;

PROCEDURE initYbase ();
VAR
    i,p:CARDINAL;
BEGIN
    p := 0;
    FOR i := ymin TO ymax DO
        Ybase[i]:=p;
        INC(p,xcount);
    END;
END initYbase;

TYPE
    plotproc = PROCEDURE(CARDINAL,CARDINAL,BYTE);

PROCEDURE vplot (x,y:CARDINAL;ink:BYTE);
BEGIN
    videoscreen[Ybase[y]+x]:=ink;
END vplot;

PROCEDURE vpoint (x,y:CARDINAL):BYTE;
BEGIN
    RETURN videoscreen[Ybase[y]+x];
END vpoint;

PROCEDURE wplot (x,y:CARDINAL;ink:BYTE);
BEGIN
    WorkScreen^[Ybase[y]+x]:=ink;
END wplot;

PROCEDURE splot (x,y:CARDINAL;ink:BYTE);
BEGIN
    SmoothScreen^[Ybase[y]+x]:=ink;
END splot;

PROCEDURE clearworkscreen(inkndx:CARDINAL );
BEGIN
    Lib.FarWordFill(FarADR(WorkScreen^),screensizeW,(inkndx << 8 + inkndx));
END clearworkscreen;

PROCEDURE clearsmoothscreen(inkndx:CARDINAL);
BEGIN
    Lib.FarWordFill(FarADR(SmoothScreen^),screensizeW,(inkndx << 8 + inkndx));
END clearsmoothscreen;

PROCEDURE clearvideoscreen (inkndx:CARDINAL);
BEGIN
    Lib.FarWordFill(FarADR(videoscreen),screensizeW,(inkndx << 8 + inkndx));
END clearvideoscreen;

PROCEDURE clearvideoscreenline (y,inkndx:CARDINAL);
CONST
    hlinesizeW = (xcount DIV 2);
VAR
    p:CARDINAL;
BEGIN
    p:=Ybase[y];
    Lib.FarWordFill(FarADR(videoscreen[p]),hlinesizeW,(inkndx << 8 + inkndx));
END clearvideoscreenline;

PROCEDURE smooth2video();
BEGIN
    pause(1);
    FarWordMove(FarADR(SmoothScreen^),FarADR(videoscreen),screensizeW);
END smooth2video;

PROCEDURE video2smooth();
BEGIN
    pause(1);
    FarWordMove(FarADR(videoscreen),FarADR(SmoothScreen^),screensizeW);
END video2smooth;

PROCEDURE work2video();
BEGIN
    pause(1);
    FarWordMove(FarADR(WorkScreen^),FarADR(videoscreen),screensizeW);
END work2video;

PROCEDURE smooth2workscreen ();
BEGIN
    FarWordMove(FarADR(SmoothScreen^),FarADR(WorkScreen^),screensizeW);
END smooth2workscreen;

PROCEDURE clearnextworkscreen(inkndx:CARDINAL);
BEGIN
    Lib.FarWordFill(FarADR(NextWorkScreen^),screensizeW,(inkndx << 8 + inkndx));
END clearnextworkscreen;

PROCEDURE nextworkscreen2workscreen ();
BEGIN
    FarWordMove(FarADR(NextWorkScreen^),FarADR(WorkScreen^),screensizeW);
END nextworkscreen2workscreen;

PROCEDURE workscreen2nextworkscreen ();
BEGIN
    FarWordMove(FarADR(WorkScreen^),FarADR(NextWorkScreen^),screensizeW);
END workscreen2nextworkscreen;

PROCEDURE nextworkscreen2smooth();
BEGIN
    FarWordMove(FarADR(NextWorkScreen^),FarADR(SmoothScreen^),screensizeW);
END nextworkscreen2smooth;

PROCEDURE smooth2nextworkscreen ();
BEGIN
    FarWordMove(FarADR(SmoothScreen^),FarADR(NextWorkScreen^),screensizeW);
END smooth2nextworkscreen;

PROCEDURE workscreen2smooth();
BEGIN
    FarWordMove(FarADR(WorkScreen^),FarADR(SmoothScreen^),screensizeW);
END workscreen2smooth;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    minalpha = 0;
    maxalpha = 90;
    k        = 255;
VAR
    tcos : ARRAY [minalpha..maxalpha] OF INTEGER;
    tsin : ARRAY [minalpha..maxalpha] OF INTEGER;

PROCEDURE initcostable (  );
VAR
    pi,deg2rad,angle,d1,d2:LONGREAL;
    i : CARDINAL;
BEGIN
    pi := 4.0 * MATHLIB.ATan(1.0);
    deg2rad := pi / 180.0;
    FOR i := 0 TO 90 DO
        angle := LONGREAL(i) * deg2rad;
        d1 := MATHLIB.Cos(angle);
        tcos[i] := INTEGER(d1 * LONGREAL(k) );

        angle := LONGREAL(i) * deg2rad;
        d2 := MATHLIB.Sin(angle);
        tsin[i] := INTEGER(d2 * LONGREAL(k) );
    END;
END initcostable;

PROCEDURE zline(x1, y1, x2, y2 : CARDINAL; ink:BYTE);
VAR
    i, deltax, deltay, numpixels,
    d, dinc1, dinc2,
    x, xinc1, xinc2,
    y, yinc1, yinc2 : INTEGER;
BEGIN
    (* Calculate deltax and deltay for initialisation *)
    deltax := ABS( INTEGER(x2) - INTEGER(x1) );
    deltay := ABS( INTEGER(y2) - INTEGER(y1) );

    (* Initialize all vars based on which is the independent variable *)
    IF deltax >= deltay THEN
        (* x is independent variable *)
        numpixels := deltax + 1;
        d := (2 * deltay) - deltax;
        dinc1 := deltay << 1;
        dinc2 := (deltay - deltax) << 1;
        xinc1 := 1;
        xinc2 := 1;
        yinc1 := 0;
        yinc2 := 1;
    ELSE
        (* y is independent variable *)
        numpixels := deltay + 1;
        d := (2 * deltax) - deltay;
        dinc1 := deltax << 1;
        dinc2 := (deltax - deltay) << 1;
        xinc1 := 0;
        xinc2 := 1;
        yinc1 := 1;
        yinc2 := 1;
    END;

    (* Make sure x and y move in the right directions *)
    IF x1 > x2 THEN
        xinc1 := - xinc1;
        xinc2 := - xinc2;
    END;
    IF y1 > y2 THEN
        yinc1 := - yinc1;
        yinc2 := - yinc2;
    END;

    (* Start drawing at <x1, y1> *)
    x := CARDINAL(x1);
    y := CARDINAL(y1);

    (* Draw the pixels *)
    FOR i := 1 TO numpixels DO
        vplot(x,y,ink);
        IF d < 0 THEN
            d := d + dinc1;
            x := x + xinc1;
            y := y + yinc1;
        ELSE
            d := d + dinc2;
            x := x + xinc2;
            y := y + yinc2;
        END;
    END;
END zline;

PROCEDURE clipxy (VAR x,y:INTEGER);
BEGIN
    IF x < xmin THEN
        x:=xmin;
    ELSIF x > xmax THEN
        x:=xmax;
    END;
    IF y < ymin THEN
        y:=ymin;
    ELSIF y > ymax THEN
        y:=ymax;
    END;
END clipxy;

PROCEDURE zplot (x,y:CARDINAL;ink:BYTE);
BEGIN
    IF x < xmin THEN RETURN; END;
    IF x > xmax THEN RETURN; END;
    IF y < ymin THEN RETURN; END;
    IF y > ymax THEN RETURN; END;
    vplot(x,y,ink);
END zplot;

PROCEDURE plotsym (filled:BOOLEAN; cx,cy,dx,dy:INTEGER;ink:BYTE);
VAR
    x1,y1,x2,y2:INTEGER;
BEGIN
  IF filled THEN
    x1:=cx-dx;
    y1:=cy-dy;
    x2:=cx+dx;
    y2:=cy-dy;
    clipxy(x1,y1);
    clipxy(x2,y2);
    zline(x1,y1,x2,y2,ink);

    x1:=cx-dx;
    y1:=cy+dy;
    x2:=cx+dx;
    y2:=cy+dy;
    clipxy(x1,y1);
    clipxy(x2,y2);
    zline(x1,y1,x2,y2,ink);
  ELSE
    x1:=cx-dx;
    y1:=cy-dy;
    zplot(x1,y1,ink);
    x2:=cx+dx;
    y2:=cy-dy;
    zplot(x2,y2,ink);

    x1:=cx-dx;
    y1:=cy+dy;
    zplot(x1,y1,ink);
    x2:=cx+dx;
    y2:=cy+dy;
    zplot(x2,y2,ink);
  END;
END plotsym;

PROCEDURE aellipse (filled:BOOLEAN; cx,cy,rx,ry:INTEGER;ink:BYTE);
VAR
    i:CARDINAL;
    dx,dy,cosinus,sinus:INTEGER;
BEGIN
    FOR i:=minalpha TO maxalpha DO
        cosinus := tcos[i];
        dx := (cosinus * rx) DIV k;
        sinus   := tsin[i];
        dy := (  sinus * ry) DIV k;
        plotsym(filled,cx,cy,dx,dy,ink);
    END;
END aellipse;

PROCEDURE zcircle (filled:BOOLEAN; cx,cy,r:INTEGER;ink:BYTE);
BEGIN
    aellipse(filled,cx,cy,r,r,ink);
END zcircle;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    PCXrgbType = RECORD
        red,green,blue:BYTE;
    END;

    (* (almost) useless fields are indented again *)

    PCXheaderType = RECORD
     manufacturer    : BYTE; (* constant 10=$0A=ZSoft *)
     version         : BYTE; (* constant 5=PC Paintbrush v3.0+ *)
     encoding        : BYTE; (* constant 1=RLE *)
    bitsPerPixel     : BYTE; (* 1, 2, 4 or 8, i.e. mono, 4, 16 OR 256 colors  *)
	                  (* window, i.e. image dimensions : xmin, ymin, xmax, ymax *)
    leftmargin       : WORD;
    uppermargin      : WORD;
    rightmargin      : WORD; (* do not use xmax-xmin ! *)
    lowermargin      : WORD;
     hDPIresolution  : WORD; (* put 300 for instance *)
     vDPIresolution  : WORD; (* idem *)
    colormap         : ARRAY[0..15] OF PCXrgbType;
     reserved1       : BYTE; (* must be 0 *)
    NCP              : BYTE; (* number of color planes, 1 or 4 *)
    NBS              : WORD; (* number of bytes per scanline, always even *)
                            (* from here, fields may contain rubbish *)
     paletteInfo     : WORD; (* 1=color or BW, 2=grayscale *)
     hscreensize     : WORD;
     vscreensize     : WORD;
     reserved2       : ARRAY[0..53] OF BYTE; (* must be 0 *)
    END;

PROCEDURE chkPCX (S:ARRAY OF CHAR;VAR h:PCXheaderType):BOOLEAN ;
CONST
    kTen = BYTE(0AH);
    kOne = BYTE(1);
    kZero= BYTE(0);
VAR
    n : CARDINAL;
BEGIN
    hnd:=FIO.OpenRead(S);
    FIO.AssignBuffer(hnd,ioBuffer);
    n:=FIO.RdBin(hnd,h,SIZE(PCXheaderType));
    FIO.Close(hnd);
    IF n < SIZE(PCXheaderType) THEN RETURN FALSE; END;
    IF h.manufacturer # kTen  THEN RETURN FALSE; END;
    IF h.encoding     # kOne  THEN RETURN FALSE; END;
    IF h.reserved1    # kZero THEN RETURN FALSE; END;
    (*
    FOR n:=0 TO 53 DO
        IF h.reserved2[n] # kZero THEN RETURN FALSE; END;
    END;
    *)
    RETURN TRUE;
END chkPCX;

(* 320x200x256 *)

PROCEDURE chkColors (h:PCXheaderType;excepted:CARDINAL):BOOLEAN;
CONST
    kFour = BYTE(4);
    kOne  = WORD(1);
    kEight= BYTE(8);
VAR
    colors : CARDINAL;
BEGIN
    IF h.bitsPerPixel > kEight THEN RETURN FALSE; END;
    IF h.NCP          > kFour  THEN RETURN FALSE; END;
    IF h.paletteInfo  # kOne   THEN RETURN FALSE; END;
    CASE CARDINAL(h.NCP) OF
    | 1:CASE CARDINAL(h.bitsPerPixel) OF
        | 1 : colors :=2;
        | 8 : colors :=256;
        ELSE
              colors :=MAX(CARDINAL);
        END;
    | 4:CASE CARDINAL(h.bitsPerPixel) OF
        | 1 : colors :=16;
        ELSE
              colors :=MAX(CARDINAL);
        END;
    ELSE
        colors:=MAX(CARDINAL);
    END;
    RETURN (colors = excepted);
END chkColors;

PROCEDURE chkDimensions (h:PCXheaderType;xcount,ycount:CARDINAL):BOOLEAN;
VAR
    picwidth,picheight:CARDINAL;
BEGIN
    picwidth  := CARDINAL(h.rightmargin-h.leftmargin )+1 ;
    picheight := CARDINAL(h.lowermargin-h.uppermargin)+1 ;
    IF picwidth  # xcount THEN RETURN FALSE;END;
    IF picheight # ycount THEN RETURN FALSE;END;
    RETURN TRUE;
END chkDimensions;

CONST
    maxPlanes = 4;
    maxpixels = 1280;
    firstcode = 0;
    (* maxcode   = (1280 DIV 8) * maxPlanes -1; (* in bytes *) *)
    maxcode   = maxpixels * maxPlanes-1;
TYPE
    imgtype = RECORD
        picwidth : CARDINAL ;
        picheight: CARDINAL ;
        decodebuffer : ARRAY [firstcode..maxcode] OF BYTE;
    END;
VAR
    img : imgtype;

PROCEDURE decodeScanline (lastcode:CARDINAL);
CONST
    PCXCOUNTFLAG = BYTE(0C0H); (* 11000000 *)
    PCXCOUNTMASK = BYTE(03FH); (* 00111111 *)
    PCXMAXCOUNT  = 03FH;
VAR
    databyte:BYTE;
    p,count,n : CARDINAL;
BEGIN
    p := firstcode;
    WHILE p <= lastcode DO
        n:=FIO.RdBin(hnd,databyte,1);
        IF (databyte AND PCXCOUNTFLAG) = PCXCOUNTFLAG THEN
            count := CARDINAL(databyte AND PCXCOUNTMASK);
            n := FIO.RdBin(hnd,databyte,1);
            FOR n := 1 TO count DO
                img.decodebuffer[p]:=databyte;
                INC(p);
            END;
        ELSE
            img.decodebuffer[p]:=databyte;
            INC(p);
        END;
    END;
END decodeScanline;

(* ignore PCX palette... which means in fact we only care about lit/unlit *)

PROCEDURE loadPCX (external:BOOLEAN; source:ARRAY OF CHAR;plot:plotproc):BOOLEAN;
VAR
    h:PCXheaderType;
    n,lastcode:CARDINAL;
    x,y:CARDINAL;
    ink:BYTE;
    orgsize,currsize:LONGCARD;
    hexe : dosEXEheaderType;
    got  : CARDINAL;
BEGIN
    currsize:=getFileSize(source);
    hnd:=FIO.OpenRead(source);
    FIO.AssignBuffer(hnd,ioBuffer);

    IF external=FALSE THEN (* assume EXE ! *)
        got := FIO.RdBin(hnd,ADDRESS(hexe),SIZE(hexe));
        orgsize := 512*LONGCARD(hexe.sizediv512 -1 )+LONGCARD(hexe.sizemod512); (* remember -1 ! *)
        IF orgsize < currsize THEN
            FIO.Seek(hnd,orgsize); (* 1 is already added because seek is 0-based *)
        ELSE
            FIO.Close(hnd);
            Str.Subst(source,extEXE,extPCX);
            IF FIO.Exists(source)=FALSE THEN RETURN FALSE; END;
            (* assume pcx file is ok *)
            hnd:=FIO.OpenRead(source);
            FIO.AssignBuffer(hnd,ioBuffer);
        END;
    END;

    n:=FIO.RdBin(hnd,h,SIZE(PCXheaderType));

    lastcode := CARDINAL(h.NCP) * CARDINAL(h.NBS) -1;

    FOR y := ymin TO ymax DO
        decodeScanline(lastcode);
        FOR x := xmin TO xmax DO
            ink := img.decodebuffer[x];
            (* IF ((x <= xmax) AND (y <= ymax)) THEN *)
            IF ink # BYTE(0) THEN ink := egarange-1; END;
            plot(x,y,ink);
        END;
    END;
    FIO.Close(hnd);
    RETURN TRUE;
END loadPCX;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE buildpicname (S:ARRAY OF CHAR;VAR num:CARDINAL; VAR pic:ARRAY OF CHAR);
VAR
    N:str128;
    v:LONGCARD;
    ok:BOOLEAN;
    p,len:CARDINAL;
    unit,dir,f8,e3,newf8:str128;
BEGIN
    Lib.SplitAllPath(S,unit,dir,f8,e3);
    LOOP
        Str.CardToStr(LONGCARD(num),N,10,ok);
        len:=Str.Length(N);
        p:=Str.Length(f8);
        IF (p+len) > 8 THEN
            Str.Delete(f8,8-len,p+len-8);
        END;
        Str.Concat(newf8,f8,N);
        Lib.MakeAllPath(pic,unit,dir,newf8,e3);
        IF FIO.Exists(pic)=FALSE THEN EXIT; END;
        INC(num);
    END;
END buildpicname;

TYPE
    palette16=ARRAY[1..16] OF LONGCARD;
CONST
    pal16=palette16(
    Graph._BLACK    ,
    Graph._BLUE      ,
    Graph._GREEN     ,
    Graph._CYAN      ,
    Graph._RED       ,
    Graph._MAGENTA   ,
    Graph._BROWN     ,
    Graph._WHITE     ,
    Graph._GRAY     ,
    Graph._LIGHTBLUE ,
    Graph._LIGHTGREEN,
    Graph._LIGHTCYAN ,
    Graph._LIGHTRED  ,
    Graph._LIGHTMAGENTA,
    Graph._LIGHTYELLOW ,
    Graph._BRIGHTWHITE ); (* crire la palette dans l'ordre original de dfinition des couleurs ! *)

(* remember $FC >> 2 = $3F, but $FF >> 2 = $3F too ! *)

PROCEDURE PCXpal (VAR v:BYTE);
VAR
    i : CARDINAL;
BEGIN
    i := CARDINAL(v) << 2;
    IF i >= 0FCH THEN i := 0FFH; END; (* we lose $FC but it's better here ! *)
    v := BYTE(i);
END PCXpal;

PROCEDURE buildPCXheader (xmin,ymin,xmax,ymax,colors:CARDINAL):PCXheaderType;
VAR
    h : PCXheaderType;
    i : CARDINAL;
    r,g,b:BYTE;
    bgr:LONGCARD;
BEGIN
    h.manufacturer   := BYTE(0AH);
    h.version        := BYTE(5);
    h.encoding       := BYTE(1);
    i:=8;
    h.bitsPerPixel   := BYTE(i);
    h.leftmargin     := xmin;
    h.uppermargin    := ymin;
    h.rightmargin    := xmax;
    h.lowermargin    := ymax;
    h.hDPIresolution := 300;    (* reasonable but useless default *)
    h.vDPIresolution := 300;
        FOR i := 0 TO 15 DO
            bgr := pal16[i+1];
            r := BYTE( bgr        MOD 100H);
            g := BYTE((bgr >>  8) MOD 100H);
            b := BYTE((bgr >> 16) MOD 100H);
            PCXpal(r); PCXpal(g); PCXpal(b);
            h.colormap[i].red   := r;
            h.colormap[i].green := g;
            h.colormap[i].blue  := b;
        END;
    h.reserved1      := BYTE(0);
    h.NCP            := BYTE(1);
    i := (xmax-xmin+1) ; (*  8 bits per pixel, so DIV 8 then * 8 *)
    h.NBS            := i;
    h.paletteInfo    := 1;
    h.hscreensize    := 0; (* xmax-xmin+1 *)
    h.vscreensize    := 0; (* ymax-ymin+1 *)
    FOR i := 0 TO 53 DO
        h.reserved2[i] := BYTE(0);
    END;

    RETURN h;
END buildPCXheader;

CONST
    PCXMAXCOUNT  = 03FH;
    PCXCOUNTFLAG = BYTE(0C0H); (* 11000000 *)

PROCEDURE encodeScanline256 (y,xmin,xmax:CARDINAL   ) : CARDINAL ;
VAR
    oldink,ink : BYTE;
    x,count:CARDINAL;
    p:CARDINAL; (* in img.decodebuffer[] *)
BEGIN
    oldink:= vpoint(xmin,y);
    count := 1;
    p := firstcode;
    x := xmin+1;
    LOOP
        ink := vpoint(x,y);
        IF ink=oldink THEN
            IF count = PCXMAXCOUNT THEN (* flush ! *)
                img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(count));
                INC(p);
                img.decodebuffer[p]:=oldink;
                INC(p);
                count:=1; (* write 63, write byte, restart at 1 *)
            ELSE
                INC(count);
            END;
        ELSE
            IF count > 1 THEN
                img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(count));
                INC(p);
                count:=1; (* write count, restart at 1 *)
            ELSE (* count is 1 here *)
                IF (oldink AND PCXCOUNTFLAG) = PCXCOUNTFLAG THEN
                    img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(01H));
                    INC(p); (* write 1 *)
                END;
            END;
            img.decodebuffer[p]:=oldink;
            INC(p); (* write byte *)
            oldink:=ink; (* restart at 1 with new byte *)
        END;

        INC(x);
        IF x > xmax THEN EXIT; END;
    END;

            IF count > 1 THEN
                img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(count));
                INC(p); (* write count *)
            ELSE (* count is 1 here *)
                IF (oldink AND PCXCOUNTFLAG) = PCXCOUNTFLAG THEN
                    img.decodebuffer[p]:=(PCXCOUNTFLAG OR BYTE(01H));
                    INC(p); (* write 1 *)
                END;
            END;
            img.decodebuffer[p]:=oldink;
            INC(p); (* write byte *)
    RETURN (p-firstcode); (* p is already +1, so useless to -1 *)
END encodeScanline256;

CONST
    palID     = BYTE(0CH); (* 12=$0C *)
    palidsize = 1;

PROCEDURE savePCXpal256 (hnd:FIO.File);
VAR
    i : CARDINAL;
    r,g,b:SHORTCARD; (* BYTE ! *)
    bgr:LONGCARD;
BEGIN
    FIO.WrBin(hnd,palID,palidsize);
        FOR i := 0 TO 255 DO

            getDAC(i,r,g,b);
            PCXpal(r); PCXpal(g); PCXpal(b);
            FIO.WrBin(hnd,r,1);
            FIO.WrBin(hnd,g,1);
            FIO.WrBin(hnd,b,1);
        END;
END savePCXpal256;

(* uses many globerks ! xmin, ymin, xmax, ymax, etc. *)

VAR
    every,everylimit : CARDINAL;

PROCEDURE savePCX (S:ARRAY OF CHAR; VAR num:CARDINAL);
VAR
    pic:str128;
    hnd:FIO.File;
VAR
    x,y,count,colors:CARDINAL;
VAR
    h : PCXheaderType;
BEGIN
    INC(every);
    IF every < everylimit THEN RETURN;END;
    every:=0;

    buildpicname(S,num,pic);
    colors:=256;

    hnd:=FIO.Create(pic);
    FIO.AssignBuffer(hnd,ioBuffer);
    h := buildPCXheader(xmin,ymin,xmax,ymax,colors);
    FIO.WrBin(hnd,h,SIZE(PCXheaderType));
    FOR y := ymin TO ymax DO
        count:=encodeScanline256(y,xmin,xmax);
        FIO.WrBin(hnd, img.decodebuffer, count);
    END;
    savePCXpal256(hnd);
    FIO.Flush(hnd);
    FIO.Close(hnd);
    INC(num); (* next ! *)
END savePCX;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE videoFadeToBlack (wait:BOOLEAN);
VAR
    changed,x,y,p,px,ink:CARDINAL;
BEGIN
    LOOP
        IF wait THEN pause(1); END;
        changed:=0;
        FOR y:=ymin TO ymax DO
            p := Ybase[y];
            FOR x:=xmin TO xmax DO
                px  := p+x;
                ink :=CARDINAL(videoscreen[px]);
                IF ink > ndxblack THEN
                    videoscreen[px]:=BYTE(ink-1);
                    INC(changed);
                END;
            END;
        END;
        IF changed=0 THEN EXIT; END;
    END;
END videoFadeToBlack;

PROCEDURE videoFadeToWhite (wait:BOOLEAN );
VAR
    changed,x,y,p,px,ink:CARDINAL;
BEGIN
    LOOP
        IF wait THEN pause(1); END;
        changed:=0;
        FOR y:=ymin TO ymax DO
            p := Ybase[y];
            FOR x:=xmin TO xmax DO
                px  := p+x;
                ink :=CARDINAL(videoscreen[px]);
                IF ink < ndxwhite THEN
                    videoscreen[px]:=BYTE(ink+1);
                    INC(changed);
                END;
            END;
        END;
        IF changed=0 THEN EXIT; END;
    END;
END videoFadeToWhite;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE grTVOFF (init,savescr:BOOLEAN;VAR ndx:CARDINAL );
CONST
    blanc= maxinkindex;
    gris = blanc-1;
    noir = ndxblack;
    xbytes=(xcount DIV 2);
    speed = 6;
    disquiet = 16; (* was 32 *)
VAR
    i,x,y:CARDINAL;
BEGIN
    everylimit := 8;

    i:=0;
    pause(1);
    resetdac(FALSE, blanc,i,i,i); (* en fait, redfini en noir *)

    i:=3*(egarange DIV 4); (* 015H *)
    pause(1);
    resetdac(FALSE,gris,i,i,i);

    IF init THEN
        clearvideoscreen(blanc); (* cran noir *)

        FOR i:= 0 TO egarange-1 DO
            pause(1);
            resetdac(FALSE,blanc,i,i,i);
            IF savescr THEN savePCX(basepcx,ndx);END;
        END;
        (* maintenant, l'cran est vraiment blanc *)
        pause(disquiet);
    END;

    (* from topbot to center *)

    FOR i:=ymin TO (ymax DIV 2) DO
        IF (i MOD speed) = 0 THEN pause(1); END;
        clearvideoscreenline(i,noir);
        clearvideoscreenline(ymax-i,noir);

        clearvideoscreenline(i+1,gris);
        clearvideoscreenline(ymax-i-1,gris);

        IF savescr THEN savePCX(basepcx,ndx);END;

    END;
    i:=(ymax DIV 2)+1;
    clearvideoscreenline(i,noir);

    (* from leftright to center *)

    y:=(ymax DIV 2);
    FOR i:=xmin TO (xmax DIV 2) DO
        IF (i MOD speed) = 0 THEN pause(1); END;
        vplot(i,y,noir);
        vplot(xmax-i,y,noir);

        IF savescr THEN savePCX(basepcx,ndx);END;

    END;
    vplot(cx,cy,gris);

    (* twinkle *)

    FOR i:=1 TO 4 DO
        pause(4);
        zcircle (FALSE, cx,cy, i  ,gris);
        zcircle (TRUE,  cx,cy, i-1,blanc);

        IF savescr THEN savePCX(basepcx,ndx);END;

    END;

    FOR i:=4 TO 2 BY -1 DO
        pause(4);
        zcircle (FALSE, cx,cy, i  ,noir);
        zcircle (TRUE,  cx,cy, i-1,gris);
        zcircle (TRUE,  cx,cy, i-2,blanc);

        IF savescr THEN savePCX(basepcx,ndx);END;

    END;

    pause(disquiet << 2 );

    FOR i:=2 TO 0 BY -1 DO
        pause(4);
        zcircle (FALSE, cx,cy, i  ,noir);

        IF savescr THEN savePCX(basepcx,ndx);END;

    END;

    pause(disquiet);

END grTVOFF;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE wavemotion (savescr:BOOLEAN;VAR ndx:CARDINAL);
VAR
    y,yy,ydo,delta,psrc,pdest,x:CARDINAL;
BEGIN
    everylimit:=32;
    FOR y := ymax TO ymin BY -1 DO
        yy    := y;
        ydo   := y;
        delta := 1;
        pause(2);
        LOOP
            psrc :=Ybase[ydo];
            pdest:=Ybase[yy];
            FOR x:=xmin TO xcount DO
                videoscreen[pdest+x]:=WorkScreen^[psrc+x];
            END;
            IF yy < delta THEN EXIT; END;
            DEC (yy,delta);
            INC (delta);
            IF ydo > ymin THEN
                DEC(ydo);
            ELSE
                EXIT;
            END;

            IF savescr THEN savePCX(basepcx,ndx);END;

        END;
    END;
END wavemotion;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    gr = ARRAY [1..9] OF INTEGER; (* 3x3 *)
    matrixtype = RECORD
        grid : gr;
        divisor:INTEGER;
    END;
CONST
    matrix1 = matrixtype( gr(  0,  1,  0,
                               1,  4,  1,
                               0,  1,  0) , 9);
    matrix2 = matrixtype( gr(  0,  1,  0,
                               1,  2,  1,
                               0,  1,  0) , 6);
    matrix3 = matrixtype( gr(  1,  1,  1,
                               1,  1,  1,
                               1,  1,  1) , 12);
CONST
    safe=2;

PROCEDURE smooth (method:CARDINAL;b1,b2:BOOLEAN):BOOLEAN;
VAR
    x,y,notblacks:CARDINAL;
    ink,inkl,inkr,inku,inkd:CARDINAL;
    inklu,inkld,inkru,inkrd:CARDINAL;
    p,px:CARDINAL;
    pu,pd:CARDINAL;
    bink:BYTE;
    divisor:CARDINAL;
    net,maxblur,DOUBLEBUFFER:BOOLEAN;
    xx,yy,color,j,pp:CARDINAL;
    matrix: matrixtype;
    sum,k:INTEGER;
BEGIN
notblacks:=0;
CASE method OF
| 1:
    divisor := 5;
    video2smooth;
    FOR y := ymin+safe TO ymax-safe DO
        p := Ybase[y];
        FOR x := xmin+safe TO xmax-safe DO
            px   := p+x;
            ink  :=CARDINAL(WorkScreen^[px]);             (* x  ,y   *)

            inkl :=CARDINAL(WorkScreen^[px-1]) ;          (* x-1,y   *)
            inkr :=CARDINAL(WorkScreen^[px+1]) ;          (* x+1,y   *)
            inku :=CARDINAL(WorkScreen^[px-xcount]);      (* x  ,y-1 *)
            inkd :=CARDINAL(WorkScreen^[px+xcount]);      (* x  ,y+1 *)
            ink  :=(ink + inkl +inkr + inku + inkd) DIV divisor;
            IF ink > maxcolorindex THEN ink:=maxcolorindex-1; END;
            IF ink > mininkindex THEN INC(notblacks);END;
            bink:=BYTE(ink);
            (* NextWorkScreen^[px] :=BYTE(ink); *)
            SmoothScreen^[px]         :=bink;

            SmoothScreen^[px-xcount]:=bink;
            SmoothScreen^[px+xcount]:=bink;

        END;
    END;
    smooth2workscreen;
| 2,3 :
    net     := b1;
    maxblur := b2;
    IF maxblur THEN
        divisor := 6; (* 6 *)
    ELSE
        divisor := 5; (* 5 *)
    END;

    (* clearsmoothscreen(ndxblack); *)
    FOR y := ymin+safe TO ymax-safe DO
        p := Ybase[y];
        FOR x := xmin+safe TO xmax-safe DO
            px := p+x;
            ink :=CARDINAL(WorkScreen^[px])   ;
            IF method = 3 THEN
                IF getrndrange(1,5) > 3 THEN
                    xx:=getrndrange(x-2,x+2);
                    yy:=getrndrange(y-2,y+2);
                    IF ink > ndxblack THEN
                        inkl:=ink-1;
                    ELSE
                        inkl:=ndxblack;
                    END;
                    IF ink<maxcolorindex THEN
                        inku:=ink+1;
                    ELSE
                        inku:=maxcolorindex;
                    END;
                    color:=getrndrange(inkl,inku);
                    wplot(xx,yy,BYTE(ink));
                END;
            END;
            IF net THEN
                inklu:=CARDINAL(WorkScreen^[px-1-xcount]) ;
                inkru:=CARDINAL(WorkScreen^[px+1-xcount]) ;
                inkld:=CARDINAL(WorkScreen^[px-1+xcount]) ;
                inkrd:=CARDINAL(WorkScreen^[px+1+xcount]) ;
                ink := (ink + inklu+inkru+inkld+inkrd ) DIV divisor;
            ELSE
                inkl:=CARDINAL(WorkScreen^[px-1]) ;
                inkr:=CARDINAL(WorkScreen^[px+1]) ;
                inku:=CARDINAL(WorkScreen^[px-xcount]) ;
                inkd:=CARDINAL(WorkScreen^[px+xcount]) ;
                ink := (ink + inkl +inkr + inku + inkd ) DIV divisor;
            END;
            IF ink > maxcolorindex THEN ink:=maxcolorindex-1; END;
            IF ink > mininkindex THEN INC(notblacks);END;
            bink:=BYTE(ink);
            SmoothScreen^[px]:=bink;

        END;
    END;
    smooth2workscreen;
| 4:
    divisor:=8;
    DOUBLEBUFFER := b1;
    FOR y := ymin+safe TO ymax-safe DO
        p := Ybase[y];
        FOR x := xmin+safe TO xmax-safe DO
            px := p+x;
            ink  :=CARDINAL(WorkScreen^[px]);            (* x  ,y   *)
            inku :=CARDINAL(WorkScreen^[px-xcount]);     (* x  ,y-1 *)
            inklu:=CARDINAL(WorkScreen^[px-xcount-1]);   (* x-1,y-1 *)
            inkru:=CARDINAL(WorkScreen^[px-xcount+1]);   (* x+1,y-1 *)
            inkl :=CARDINAL(WorkScreen^[px-1]) ;         (* x-1,y   *)
            inkr :=CARDINAL(WorkScreen^[px+1]) ;         (* x+1,y   *)
            inkd :=CARDINAL(WorkScreen^[px+xcount]);     (* x  ,y+1 *)
            ink := (ink + inkl +inkr + inku + inkd+inklu + inkru) DIV divisor;
            IF ink > maxcolorindex THEN ink:=maxcolorindex-1; END;
            IF ink > mininkindex THEN INC(notblacks); END;
            bink:=BYTE(ink);
            IF DOUBLEBUFFER THEN
                NextWorkScreen^[px]:=bink;
            ELSE
                WorkScreen^[px]:=bink;
            END;
            SmoothScreen^[px]:=bink;
        END;

    END;
    IF DOUBLEBUFFER THEN nextworkscreen2workscreen; END;
| 5,6,7:
    CASE method OF
    | 5 : matrix:=matrix1;
    | 6 : matrix:=matrix2;
    | 7 : matrix:=matrix3;
    END;
    FOR y := ymin+safe TO ymax-safe DO
        p := Ybase[y];
        FOR x := xmin+safe TO xmax-safe DO
            px:=p+x;
            sum:=0;
            FOR j:=1 TO 9 DO
                k:=matrix.grid[j];
                CASE j OF
                | 1: pp:=px-xcount-1;
                | 2: pp:=px-xcount;
                | 3: pp:=px-xcount+1;
                | 4: pp:=px-1; (* left *)
                | 5: pp:=px; (* center *)
                | 6: pp:=px+1; (* right *)
                | 7: pp:=px+xcount-1;
                | 8: pp:=px+xcount;
                | 9: pp:=px+xcount+1;
                END;
                sum:=sum+k * INTEGER( WorkScreen^[pp] );
            END;
            sum:=sum DIV matrix.divisor;
            IF sum < mininkindex THEN sum:=mininkindex;END;
            ink:=CARDINAL(sum);

            IF ink > maxcolorindex THEN ink:=maxcolorindex-1; END;
            IF ink > mininkindex THEN INC(notblacks);END;
            bink:=BYTE(ink);
            (* NextWorkScreen^[px] :=BYTE(ink); *)
            SmoothScreen^[px]         :=bink;
        END;
    END;
    smooth2workscreen;

END;
RETURN (notblacks=0);
END smooth;

(* ------------------------------------------------------------ *)

PROCEDURE toggle (VAR tf:BOOLEAN   );
BEGIN
    tf := NOT(tf);
END toggle;

CONST
    firstcount= 2;
    firstwait = 8; (* was 128 i.e. about 1 second *)
    normalwait= 2;  (* was 4 *)
    maxrounds = 192;
VAR
    parmcount,i,opt:CARDINAL;
    S,R,R2:str128;
    state : (waiting,gotsource);
    source:str128;
    picheader : PCXheaderType;
    method,keycode,rounds,x,y,n:CARDINAL;
    ok,usemouse,singlestep,chk,external,b1,b2 : BOOLEAN;
    effect : ARRAY [1..20] OF BOOLEAN;
    pal:palettetype;
    savescr:BOOLEAN;
    ndxpcx :CARDINAL;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    WrLn; (* here for pretty output *)

    savescr:=FALSE;
    ndxpcx :=1;
    every  :=MAX(CARDINAL)-1;

    method :=2;
    b1     :=TRUE;
    b2     :=FALSE;
    pal    :=gpal;
    FOR i:=1 TO 20 DO effect[i]:=FALSE;END;
    (* A B D M *)
    effect[1]:=TRUE;
    effect[2]:=TRUE;
    effect[4]:=TRUE;
    effect[13]:=TRUE;

    parmcount := Lib.ParamCount();
    (* IF parmcount = 0 THEN abort(errHelp,"");END; *)

    state := waiting;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"HELP"+delim+"HELP"+delim+
                                   "P:"+delim+"PALETTE:"+delim+
                                   "M:"+delim+"METHOD:"+delim+
                                   "B1:"+delim+
                                   "B2:"+delim+
                                   "A"+delim+
                                   "B"+delim+
                                   "C"+delim+
                                   "D"+delim+
                                   "E"+delim+
                                   "F"+delim+
                                   "G"+delim+
                                   "H"+delim+
                                   "I"+delim+
                                   "J"+delim+
                                   "K"+delim+
                                   "L"+delim+
                                   "M"+delim+
                                   "N"+delim+
                                   "S"+delim+"SAVE"
                               );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5:
                GetString(R,R2);
                CASE R2[0] OF
                | "R","1" : pal:=rpal;
                | "G","2" : pal:=gpal;
                | "B","3" : pal:=bpal;
                | "F","4" : pal:=firepal;
                | "U","5" : pal:=rougepal;
                | "V","6" : pal:=vertpal;
                | "E","7" : pal:=bleupal;
                END;
            | 6,7:
                GetString(R,R2);
                CASE R2[0] OF
                | "1","A": method:=1;
                | "2","B": method:=2;
                | "3","C": method:=3;
                | "4","D": method:=4;
                | "5","E": method:=5;
                | "6","F": method:=6;
                | "7","G": method:=7;
                END;
            | 8:
                GetString(R,R2);
                CASE R2[0] OF
                | "0","F"     : b1:=FALSE;
                | "1","T","V" : b1:=TRUE;
                END;
            | 9:
                GetString(R,R2);
                CASE R2[0] OF
                | "0","F"     : b2:=FALSE;
                | "1","T","V" : b2:=TRUE;
                END;
            | 10: toggle(effect[1]);
            | 11: toggle(effect[2]);
            | 12: toggle(effect[3]);
            | 13: toggle(effect[4]);
            | 14: toggle(effect[5]);
            | 15: toggle(effect[6]);
            | 16: toggle(effect[7]);
            | 17: toggle(effect[8]);
            | 18: toggle(effect[9]);
            | 19: toggle(effect[10]);
            | 20: toggle(effect[11]);
            | 21: toggle(effect[12]);
            | 22: toggle(effect[13]);
            | 23: toggle(effect[14]);
            | 24: savescr := TRUE;
            ELSE
                abort(errSyntax,S);
            END;
        ELSE
            CASE state OF
            | waiting :
                IF same(R,"?") THEN abort(errHelp,""); END;
                Str.Copy(source,R); (* keep upper case here *)
            ELSE
                abort(errSyntax,S);
            END;
            INC(state);
        END;
    END;
    CASE state OF
    | waiting:
        external:=FALSE;

        Lib.ParamStr(source,0);
        UpperCase(source);

        (* Str.Subst(source,extEXE,extPCX); *)

    | gotsource:
        external:=TRUE;
    END;

    IF external THEN
        IF chkJoker(source) THEN abort(errNoJokers,"");END;
        IF Str.CharPos(source,dot)=MAX(CARDINAL) THEN Str.Append(source,extPCX);END;
        IF FIO.Exists(source)=FALSE THEN abort(errNotFound,source);END;
        IF chkPCX(source,picheader)=FALSE THEN abort(errNotPCX,source);END;
        IF chkColors(picheader,256)=FALSE THEN abort(errUnsupportedPCX,source);END;
        IF chkDimensions(picheader,xcount,ycount)=FALSE THEN abort(errUnsupportedPCX,source);END;
    END;

    NEW(WorkScreen);
    NEW(NextWorkScreen); (* for double buffer *)
    NEW(SmoothScreen);

    doRandomize;
    initcostable;
    initYbase;

    (* decode to workscreen buffer *)
    IF loadPCX(external,source,wplot)=FALSE THEN abort(errCannotLoadPCX,"");END;

    savesystempal();

    setVideoMode(hires);
    newPalette64(pal,FALSE);

    pause(1);
    clearvideoscreen(ndxblack);

    clearnextworkscreen(ndxblack);
    clearsmoothscreen(ndxblack);

    usemouse:= ( MsMouse.Reset() # MAX(INTEGER) );
    flushKeyboard();

(* A *)
    IF effect[1] THEN
        FOR i:=1 TO firstcount DO ok:=smooth(method,b1,b2); END;
    END;

(* B *)
    IF effect[2] THEN
        newPalette64(pal,FALSE);
        wavemotion(savescr,ndxpcx);
        pause(firstwait);
    END;

(* C *)
    IF effect[3] THEN
        newPalette64(blackpal,FALSE);
        pause(1);
        smooth2video;
        newPalette64(pal,TRUE);
        pause(firstwait);
    END;
(* D *)
    IF effect[4] THEN
        singlestep := FALSE;
        rounds:=0;
        LOOP
            ok:=smooth(method,b1,b2);
            pause(normalwait);
            smooth2video;

            (*

            (* read and process key *)
            IF singlestep THEN
                WHILE getKeyboardCode(keycode)=FALSE DO
                END;
                chk:=(keycode # keySpace);
                singlestep:=NOT(chk);
            ELSE
                chk:=getKeyboardCode(keycode);
            END;
            IF chk THEN
                CASE keycode OF
                | lowerR        : newPalette64(firepal,FALSE);
                | upperR        : newPalette64(rpal,FALSE);
                | upperG,lowerG : newPalette64(gpal,FALSE);
                | upperB,lowerB : newPalette64(bpal,FALSE);
                | keySpace      : singlestep:=NOT (singlestep);
                | keyEscape     : EXIT;
                | keyCR         : EXIT;
                END;
            END;
            IF usemouse THEN
                IF mouseclick() THEN EXIT; END;
            END;

            *)

            IF ok THEN EXIT; END;
            INC(rounds);
            IF rounds > maxrounds THEN EXIT; END; (* safety *)
       END;
    END;

    (* here, screen is original picture or is ndxblack *)

    IF effect[5] THEN videoFadeToBlack(FALSE); END;     (* E *)
    IF effect[6] THEN videoFadeToWhite(FALSE); END;     (* F *)

    IF effect[7] THEN newPalette64(blackpal,TRUE);END;  (* G *)
    IF effect[8] THEN newPalette64(whitepal,TRUE);END;  (* H *)

    IF effect[9]  THEN palfadeto(00H,00H,00H);END;      (* I *)
    IF effect[10] THEN palfadeto(3FH,3FH,3FH);END;      (* J *)

    IF effect[11] THEN clearvideoscreen(ndxblack); END; (* K *)
    IF effect[12] THEN clearvideoscreen(ndxwhite); END; (* L *)

(* palfadeto(0,0,0); *)

    IF effect[13] THEN grTVOFF(TRUE ,savescr,ndxpcx); END; (* M *)
    IF effect[14] THEN grTVOFF(FALSE,savescr,ndxpcx); END; (* N *)

    newPalette64(systempal,FALSE);

    setVideoMode(text);

    abort(errNone,"");
END qdTitle.
