(* ---------------------------------------------------------------
Title         Q&D Text Generator
Author        PhG
Overview      another useless program
Notes         minimal error messages and checking, etc.
              too many globerks... ;-)
Bugs          getSentence is not bullet-proof (prevTag and Tag)
              yet another silly TopSpeed M2 bug in heap* (see WORDFREQ.MOD) :
              result is in paragraphs, not in bytes !
              crash if (#) seems too high a value...
              but no logical reason for it !
              (culprit is CRITIQUE.DAT with 15 and 45 count values)
              problem is not solved by large model or longcards count !
Wish List     an operator to put a full word in CAPS ?
              allow change of separators ~ \ / |
              better support for French (ah ah, only serious !)
              read quoted string instead of trimmed verbatim ?
              a real two-passes interpreter with variables and classes ?

              handle more French exceptions (/au, etc.) or add a special
              flag for French/English processing (" de le " --> " du ",
              "  le " --> " au ", etc.)
              un flag global avertissant que le texte est  prparer
              en fonction d'une langue (" de le " --> " du ", etc.)
              ou une section rserve avec les remplacements  faire, comme :
              " que  le avenir " --> " qu' l'avenir "

              support for the rather nice "net.charabia.generation"
              written in (yerk !) java by a (smart) Rodrigo Reyes

              a full rewrite with vars and functions
              (so we can easily add markov ?)

--------------------------------------------------------------- *)

MODULE TextGen;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;
IMPORT SYSTEM;
IMPORT MsMouse;
IMPORT BiosIO;
IMPORT IO;

FROM Storage IMPORT Available,ALLOCATE,DEALLOCATE,HeapTotalAvail,MainHeap;

FROM QD_ASCII IMPORT dash, slash, nullchar, tabchar, (* cr, lf, nl, bs, *)
space, dot, deg, doublequote, quote, colon, percent, vbar,
blank, equal, dquote, charnull, singlequote, antislash, dollar,
star, backslash, coma, question, underscore, tabul, hbar,
comma, semicolon, diese, pound, openbracket, closebracket, tilde, exclam,
stardotstar, dotdot, escCh, escSet, letters, digits,
lettersUpp, lettersLow, openbrace, closebrace;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits, metaproc, getCli, argc, argv;

FROM QD_rand IMPORT InitRnd, GetRnd, GetRndCardRange, GetRndLngCardRange;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileExistsAlt,
fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose, fileFlush, fileSupportLFN;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_Text IMPORT
colortype, cursorshapetype, scrolltype,
ff, cr, lf, bs, tab, nl, mincolor, maxcolor,
BW40, CO40, BW80, CO80, CO80x43, CO80x50, MONO,
vesa80x60, vesa132x25, vesa132x43, vesa132x50, vesa132x60,
selectCursorEmulation,
setCursorShape,
handleVesa, setBrightPaper, setBlinkMode,
setFillChar, setFillInk, setFillPaper,
setFillInkPaper, setTxtInk, setTxtPaper, setTxtInkPaper, setWrapMode,
setUseBiosMode, setTabWidth, getScreenData, setWindow,
setMode, restoreMode,
gotoXY, xyToHtabVtab, home, setVisualPage, setActivePage,
scrollWindow, fillTextAttr, cls, writeStr, writeLn, getScreenWidth,
getScreenHeight, getScreenMinX, getScreenMinY, getScreenMaxX, getScreenMaxY,
getMinHtab, getMaxHtab, getMinVtab, getMaxVtab, getUseBiosMode,
getMinHtab, getMaxHtab, getMinVtab, getMaxVtab, getHtab, getVtab,
getWindowWidth, getWindowHeight,
initScreenConsole,
findInkPaperAtStartup, getInkAtStartup, getPaperAtStartup,
setFullScreenWindow, gotoFullScreenXY;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    str32    = ARRAY [0..31] OF CHAR;
    strHUGE  = str4096;
CONST
    ProgEXEname   = "TEXTGEN";
    ProgTitle     = "Q&D Text Generator";
    ProgVersion   = "v1.1";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    extEXE        = ".EXE";
    extDAT        = ".TX"; (* was ".DAT" *)
    exclamation   = "!";
    opencurly     = "{";
    closecurly    = "}";
    openparen     = "(";
    closeparen    = ")";
    commercial    = "&";
    arrobas       = "@";
    plus          = "+";
    (* british       = ""; *)
    herit         = slash+commercial;
    suppress      = slash+slash;
    (* moneymarker   = "$$$"; *)
    newlinemarker = backslash+exclamation;
    capmarker     = backslash+arrobas;
    lowmarker     = backslash+dollar;
    suffixmarker  = backslash+commercial; (* was +british *)
    elisionmarker = backslash+singlequote; (* in fact, we handle "?\' ?" sequence *)
    articlemarker = backslash+dash; (* in fact, we handle "a\- ?" sequence *)
    concatenate   = backslash+plus;
    lenconcatenate= 2;
CONST
    alphanum        = letters+digits;
    legalforcategory= alphanum+underscore; (* // was letters prior to v1.0d, alphanum prior to v1.0e *)
    legalfortag     = alphanum+commercial;
CONST
    vowels          = "AEIOUY";
    elisionRequired = vowels+"H";
    possibleElision = "?"+elisionmarker+space+"?";
CONST
    possibleArticle = "A"+articlemarker+space+"?";
    articleRequired = "AEIOU";
CONST
    minpause            = 0;
    maxpause            = 30;
    defaultpause        = 1;
    defaultalwayspause  = 2; (* always pause 1 seconds PLUS # s per line *)
CONST
    commentchar1 = semicolon;
    commentchar2 = pound;
    comment1     = "//";
    comment2     = ":::";
    comment3     = "(*";
    comment3a    = "*)";
CONST
    extBAK          = ".BK!";
    extCOM          = ".COM";
    (* extEXE          = ".EXE"; *)
    extDLL          = ".DLL";
    extOVR          = ".OVR";
    extOVL          = ".OVL";
    extDRV          = ".DRV";
    extZIP          = ".ZIP";
    extARJ          = ".ARJ";
    extLZH          = ".LZH";
    extOBJ          = ".OBJ";
    skippedextensions=extBAK+delim+extCOM+delim+extEXE+delim+
                      extDLL+delim+extOVR+delim+extOVL+delim+extDRV+delim+
                      extZIP+delim+extARJ+delim+extLZH+delim+
                      extOBJ;

(* ------------------------------------------------------------ *)

CONST
    (* aliases for our own procedures *)
    WrStr ::= writeStr;
    WrLn  ::= writeLn;
    WrChar::= writeStr;

CONST
    progink   = cyan;
    progpaper = darkblue;

PROCEDURE colorhelp ();
BEGIN
    setTxtInk(getInkAtStartup());      (* was green *)
    setTxtPaper(getPaperAtStartup());  (* was black *)
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colorhelp;

PROCEDURE colortext (ink,paper:CARDINAL );
BEGIN
    setTxtInk   (VAL(colortype,ink));
    setTxtPaper (VAL(colortype,paper));
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colortext;

(* ------------------------------------------------------------ *)

CONST
    errNone           = 0;
    errHelp           = 1;
    errOption         = 2;
    errParameter      = 3;
    errBadNumber      = 4;
    errInkRange       = 5;
    errPaperRange     = 6;
    errCountRange     = 7;
    errMALLOC         = 8;
    errFormat         = 9;
    errSentenceTooBig = 10;
    errWidthRange     = 11;
    errJoker          = 12;
    errNotFound       = 13;
    errLoading        = 14;
    errReallyNotFound = 15;
    errVerboseHelp    = 16;
    errPauseRange     = 17;
    errNotInSaverMode = 18;
    errNotInNormalMode= 19;
    errTooManyFiles   = 20;
    errVerboserHelp   = 21;
    errBadJokers      = 22;
    errOnlyForList    = 23;
    errProcSpec       = 24;  (* base *)
    errNetwork        = errProcSpec+0;
    errColon          = errProcSpec+1;
    errUnit           = errProcSpec+2;
    errNoParent       = errProcSpec+3;
    errEmpty          = errProcSpec+4;
    errInnerParent    = errProcSpec+5;
    errDirJoker       = errProcSpec+6;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
    (*
    MODULE message;
    IMPORT Str;
    EXPORT msg3;

    PROCEDURE msg3 (VAR R:ARRAY OF CHAR;S1,S2,S3:ARRAY OF CHAR);
    BEGIN
        Str.Concat(R,S1,S2);Str.Append(R,S3);
    END msg3;

    END message;
    *)
CONST
    placeholder = vbar;
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
     helpmsg=
Banner+nl+
nl+
"Syntax 1 : "+ProgEXEname+" [datafile["+extDAT+"]] [option]..."+nl+
"Syntax 2 : "+ProgEXEname+" <-list> [datafile(s)["+extDAT+"]]"+nl+
nl+
'  -l     show first title line in datafile(s) (default pattern is "'+star+extDAT+'")'+nl+
"  -n:#   count"+nl+
"  -k     remove space from space+{"+semicolon+colon+exclamation+question+"} sequences"+nl+
"  -f:#   frame type (0=none, 1=single, 2=double, 3=raw), default is 0"+nl+
"  -w[w]  wait for keypress or mouseclick (-ww = -w -m)"+nl+
"  -m     ignore mouse if present"+nl+
"  -p[p]  -w[w] with French prompt"+nl+
"  -n     add a newline (CR+LF) in order to beautify display (useful with PEXEC)"+nl+
"  -g     glue output data (no newline added if count > 1 and -f:0)"+nl+
"  -i:#   ink [0..15], default is cyan"+nl+
"  -p:#   paper [0..15], default is dark blue"+nl+
"  -b     monochrome BIOS output (no colors)"+nl+
"  -w:#   set line width, default is screen width"+nl+
"  -s     screensaver mode, end on Escape or Return"+nl+
"  -s:#   in screensaver mode, pause [0..30] in seconds per line, default is 1"+nl+
"  -m:#   in screensaver mode, minimum pause [0..30] in seconds, default is 2"+nl+
"  -z     in screensaver mode, next = left click, quit = right click"+nl+
"  -r     in screensaver mode, randomize position, default is center"+nl+
"  -c     in screensaver mode, do not clear screen at exit"+nl+
"  -x     disable LFN support even if available"+nl+
"  -??[?] verbose(r) help, including file format and an example"+nl+
nl+
"a) Unless it is specified with a path or with -list option,"+nl+
'   datafile (default is "'+ProgEXEname+extDAT+'") is searched for'+nl+
"   first in current directory, then in executable directory."+nl+
"b) By design, this program does not handle language exceptions"+nl+
'   (such as " de le " becoming " du ", "  le " becoming " au ", etc.).'+nl+
'c) For syntax 2, a legal title line can be "'+commentchar1+" "+comment1+'", "'+
"  "+commentchar1+" "+comment2+'" or "'+commentchar1+" "+comment3+" ... "+comment3a+'".'+nl+
"   Note -list option only displays the first matching title line."+nl+
"d) Any file with any of the following extensions will be ignored :"+nl+
"   "+skippedextensions+nl+
"e) Dark [0..7] : black, blue, green, cyan, red, magenta, brown and gray."+nl+
"   Bright [8..15] : gray, blue, green, cyan, red, magenta, yellow and white."+nl+
"f) With DR-DOS 6.0 or Novell DOS 7.0, "+ProgEXEname+" can be called after each"+nl+
"   external command by setting SET PEXEC=path\"+ProgEXEname+extEXE+" -n and PROMPT $x$p$g"+nl;

    morehelpmsg=
"DATA FILE FORMAT :"+nl+
nl+
"   ~class{variant|...}"+nl+
"   {variant|...}entry{variant|...}"+nl+
nl+
"   Use \class to include a class in a class definition."+nl+
"   Use \class to invoke, \class/variant id letter."+nl+
nl+
'a) A category is defined by an ID beginning with a "'+tilde+'" marker, with an optional'+nl+
'   suffix : a set of variants (identified by a single letter) between "'+opencurly+closecurly+'".'+nl+
"   Last category defines the final output. Program can handle 500 categories."+nl+
"b) Each category entry is on its own line, with optional variants specified"+nl+
'   between "'+opencurly+closecurly+'" and separated with inner "'+vbar+'"'+nl+
'   according to "{[0][|1][|#]...}" pattern (note first letter variant is 1).'+nl+
'   "('+pound+')" prefix duplicates the entry # times.'+nl+
'c) A long paragraph can be built from individual lines ending with "'+concatenate+'" marker'+nl+
"   until a line without ending marker."+nl+
'd) "'+backslash+'" prefix includes a category, an optional variant being specified with "'+slash+'"'+nl+
'   followed by its single letter ID ("'+herit+'" forces use of calling variant).'+nl+
'e) "'+newlinemarker+'" forces a newline, "'+capmarker+'" forces next word initial to upper case,'+nl+
'   "'+suffixmarker+'" glues two text units, and "'+lowmarker+'" forces next word initial to lower case.'+nl+
'f) If last character of "'+possibleElision+'" sequence belongs to ['+elisionRequired+'] set,'+nl+
"   first character and space will be replaced with a single quote (French)."+nl+
'g) If last character of "'+possibleArticle+'" sequence belongs to ['+articleRequired+'] set,'+nl+
'   the article "a" will be replaced with the article "an" (English).'+nl+
"h) -dump, -steps and -chkmem options may be of some use for diagnostics."+nl+
"j) Check companion *.TX datafiles to see what can be done using TEXTGEN !"+nl; (* yes, yes, what's the use defining constants AND NOT using them ? ;-) *)

    evenmorehelpmsg =
"EXAMPLE :"+nl+
nl+
"; // this is a mere test for Latin"+nl+
"; nominatif,vocatif,accusatif,gnitif,datif,ablatif SINGULIER = abcdef"+nl+
"; nominatif,vocatif,accusatif,gnitif,datif,ablatif PLURIEL   = ghijkl"+nl+
"~radixRosa"+nl+
"ros"+nl+
"poet"+nl+
"~radixDominus"+nl+
"domin"+nl+
"amic"+nl+
"~declRosa{abcdefghijkl}"+nl+
"{|a|a|am|ae|ae|a|ae|ae|as|arum|is|is}"+nl+
"~declDominus{abcdefghijkl}"+nl+
"{|us|e|um|i|o|o|i|i|os|orum|is|is}"+nl+
"~nom{abcdefghijkl}"+nl+
"\radixRosa\declRosa/&"+nl+
"\radixDominus\declDominus/&"+nl+
"~test"+nl+
"\@\nom/a amat \nom/c"+nl+
"(2)\@\nom/i \nom/g amant"+nl+
"\!\!\@this is a mere test for Latin\!\!"+nl;

VAR
    S : strHUGE; (* was str256 but we may get a huge string here *)
BEGIN
    colorhelp();
    CASE e OF
    | errHelp,errVerboseHelp,errVerboserHelp :
        WrLn;
        WrStr(helpmsg);
        CASE e OF
        | errVerboseHelp,errVerboserHelp:
            WrLn;
            WrStr(morehelpmsg);
        END;
        IF e = errVerboserHelp THEN
            WrLn;
            WrStr(evenmorehelpmsg);
        END;
        e:=errHelp;
    | errOption :      S:='Illegal "'+placeholder+'" option !';
    | errParameter :   S:='"'+placeholder+'" is just one parameter too many !';
    | errBadNumber:    S:='Illegal value in "'+placeholder+'" option !';
    | errInkRange:     S:="Ink range is [0..15] !";
    | errPaperRange:   S:="Paper range is [0..15] !";
    | errCountRange:   S:="Count range is [1..1000] !";
    | errMALLOC:       S:="Storage.ALLOCATE() failed !";
    | errFormat:       S:='Illegal tilde command ("'+placeholder+'") !';
    | errSentenceTooBig:S:="Formatted sentence is too big !";
    | errWidthRange:   S:="Illegal line width !";
    | errJoker:        S:='At least one illegal joker in "'+placeholder+'" !';
    | errNotFound:     S:='No valid file matches "'+placeholder+'" specification !';
    | errLoading:      S:='Error while loading "'+placeholder+'" !';
    | errReallyNotFound:S:='No valid file matches "'+placeholder+'" specification !';
    | errPauseRange:   S:="Pause range is [0..30] !";
    | errNotInSaverMode: Str.Copy(S,einfo);
    | errNotInNormalMode:Str.Copy(S,einfo);
    | errTooManyFiles: S:='Too many files match "'+placeholder+'" specification !';
    | errBadJokers:    S:='At least one invalid joker in "'+placeholder+'" !';
    | errOnlyForList:  S:='-list option is required to process "'+placeholder+'" !'; (* containing at least one joker ! *)

    | errNetwork:      S:='Illegal network reference in "'+placeholder+'" !';
    | errColon:        S:='":" problem in "'+placeholder+'" !';
    | errUnit:         S:='Illegal unit in "'+placeholder+'" !';
    | errNoParent:     S:='"'+placeholder+'" has no parent directory !';
    | errEmpty:        S:='"'+placeholder+'" contains only unit part !';
    | errInnerParent:  S:='Illegal inner parent in "'+placeholder+'" !';
    | errDirJoker:     S:='At least one illegal joker in "'+placeholder+'" path !';
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp: ;
    ELSE
        Str.Subst(S,placeholder,einfo);
        WrLn;
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* taken almost verbatim from OLDNEW v1.1f and TRIM v1.1 code, out of weariness *)

TYPE
    pFname = POINTER TO fnameType;
    fnameType = RECORD
        next      : pFname;
        slen      : CARDINAL; (* a SHORTCARD could do but who knows ? *)
        str       : CHAR;
    END;

PROCEDURE initList (VAR anchor : pFname );
BEGIN
    anchor := NIL;
END initList;

PROCEDURE freeList (anchor : pFname);
VAR
    needed : CARDINAL;
    p      : pFname;
BEGIN
    (* p:=anchor; *)
    WHILE anchor # NIL DO
        needed := SIZE(fnameType) - SIZE(anchor^.str) + anchor^.slen;
        p := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=p;
    END
END freeList;

PROCEDURE buildNewPtr (VAR anchor,p:pFname; len:CARDINAL):BOOLEAN;
VAR
    needed : CARDINAL;
BEGIN
    needed := SIZE(fnameType) - SIZE(p^.str) + len;
    IF Available(needed)=FALSE THEN RETURN FALSE; END;
    IF anchor = NIL THEN
        ALLOCATE(anchor,needed);
        p:=anchor;
    ELSE
        p:=anchor;
        WHILE p^.next # NIL DO
            p:=p^.next;
        END;
        ALLOCATE(p^.next,needed);
        p:=p^.next;
    END;
    p^.next := NIL;
    RETURN TRUE;
END buildNewPtr;

(* assume p is valid *)

PROCEDURE getStr (VAR S : pathtype; p:pFname);
VAR
    len:CARDINAL;
BEGIN
    len := p^.slen;
    Lib.FastMove( ADR(p^.str),ADR(S),len);
    S[len] := nullchar; (* REQUIRED safety ! *)
END getStr;

(* ------------------------------------------------------------ *)

(* Str.Match is not case sensitive *)

PROCEDURE isReservedPattern (S,skipthem:ARRAY OF CHAR):BOOLEAN;
VAR
    e3 : str16;
    n:CARDINAL;
    rc:BOOLEAN;
BEGIN
    rc:=FALSE;
    n:=0;
    LOOP
        isoleItemS(e3, skipthem,delim,n);
        IF same(e3,"") THEN EXIT; END;
        Str.Prepend(e3,"*");
        IF Str.Match(S,e3) THEN rc:=TRUE;EXIT; END;
        INC(n);
    END;
    RETURN rc;
END isReservedPattern;

PROCEDURE isReservedEntry (S:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isReservedEntry;

PROCEDURE buildFileList (VAR anchor:pFname;
                        noskip,useLFN,DEBUG :BOOLEAN;
                        spec:pathtype):CARDINAL;
VAR
    count:CARDINAL; (* should do ! *)
    ok,found:BOOLEAN;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    entry : FIO.DirEntry;
    dosattr:FIO.FileAttr;
    entryname:pathtype;
    len : CARDINAL;
    pp:pFname;
    excludeme1,excludeme2:BOOLEAN;
BEGIN
    count:=0;
    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        excludeme1 := isReservedEntry   (entryname);  (* skip "." and ".." *)
        IF noskip THEN
            excludeme2 := FALSE;
        ELSE
            excludeme2 := isReservedPattern (entryname,skippedextensions );
        END;
        IF NOT(excludeme1 OR excludeme2) THEN
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=entry.attr;
            END;
            IF NOT (aD IN dosattr) THEN
                (* if file has no extension, add it as a marker *)
                IF Str.RCharPos(entryname,".")=MAX(CARDINAL) THEN
                    Str.Append(entryname,".");
                END;
                IF DEBUG THEN WrStr("Included : ");WrStr(entryname);WrLn; END;
                len:=Str.Length(entryname);
                IF buildNewPtr(anchor,pp,len)=FALSE THEN
                    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN MAX(CARDINAL); (* errStorage *)
                END;
                INC(count);
                pp^.slen      := len;
                Lib.FastMove ( ADR(entryname),ADR(pp^.str),len );
            ELSE
                IF DEBUG THEN WrStr("Ignored  : ");WrStr(entryname);WrLn;END;
            END;
        ELSE
            IF DEBUG THEN WrStr("Excluded : ");WrStr(entryname);WrLn;END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN count;
END buildFileList;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBuffer  = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    bufferIn  : ioBuffer;

CONST
    mincount    = 1;
    maxcount    = 1000;
    frameNone   = 0;
    frameSingle = 1;
    frameDouble = 2;
    frameRaw    = 3;
    minframe    = frameNone;
    maxframe    = frameRaw;
    msgWait     = "Hit any key to continue... ";
    msgWaitMouse  = "Hit any key or click any mouse button to continue... ";
    msgWaitFR     = "Appuyez sur une touche pour continuer... ";
    msgWaitMouseFR= "Appuyez sur une touche ou sur un bouton pour continuer... ";

(* ------------------------------------------------------------ *)

(*
PROCEDURE genMoney  (VAR S : ARRAY OF CHAR);
VAR
    ok:BOOLEAN;
    n :CARDINAL;
    amount:str16;
BEGIN
    LOOP
        IF Str.Pos(S,moneymarker)=MAX(CARDINAL) THEN EXIT; END;
        n:=GetRndCardRange(1,10000);
        Str.CardToStr(LONGCARD(n),amount,10,ok);
        Str.Subst(S,moneymarker,amount);
    END;
END genMoney;
*)

PROCEDURE pack (VAR S : ARRAY OF CHAR;older,newer:ARRAY OF CHAR);
BEGIN
    LOOP
        IF Str.Pos(S,older)=MAX(CARDINAL) THEN EXIT; END;
        Str.Subst(S,older,newer);
    END;
END pack;

(*
    almost useless, for data was already verified,
    but as our dmpTTX proc does not check punctuation marks...
*)

PROCEDURE cleanstring (fullclean:BOOLEAN; VAR S : ARRAY OF CHAR);
BEGIN
    pack(S,space+space      ,space);
    pack(S,space+dot        ,dot);
    pack(S,space+comma      ,comma);
    IF fullclean THEN
    pack(S,space+semicolon  ,semicolon);
    pack(S,space+colon      ,colon);
    pack(S,space+exclamation,exclamation);
    pack(S,space+question   ,question);
    END;
END cleanstring;

CONST
    firstline = 1;
    maxline   = 500; (* was 50, already oversized ! *)
VAR
    sline  : ARRAY [firstline..maxline] OF str128; (* str144 would create too large an object *)
    slen   : ARRAY [firstline..maxline] OF CARDINAL;

CONST
    (*            012345     *)
    sSingle    = "ڳ";
    sDouble    = "ɺͼ";
    sNone      = "      ";
    wiHORIZ    = 4; (* bar, space, ... , space, bar *)
    wiVERTI    = 4; (* line, filler, ... , filler, line *)
    wiHORIZalt = 2; (* space, ... , space *)
    wiVERTIalt = 2; (* filler, ... , filler *)

PROCEDURE dmpSentence (screenwidth,linewidth,doFrame:CARDINAL;
                      redirected,doBeautify,glue:BOOLEAN;
                      lastline,longest:CARDINAL);
VAR
    plus,len,i,j,k    : CARDINAL;
    frameChars   : str16;
    S            : str128;
    neednl:BOOLEAN;
BEGIN
    len := longest;

    CASE doFrame OF
    | frameNone   : frameChars := sNone;   plus:=0;
    | frameSingle : frameChars := sSingle; plus:=2;
    | frameDouble : frameChars := sDouble; plus:=2;
    END;

    CASE doFrame OF
    | frameRaw :
        IF NOT(glue) THEN WrLn;END;

        FOR j:=firstline TO lastline DO
            WrStr(sline[j]);
            neednl :=( slen[j] < linewidth );
            neednl :=(neednl OR redirected);
            neednl :=(neednl OR (linewidth # screenwidth) ); (* < *)
            IF neednl THEN WrLn; END;
        END;

    ELSE
        neednl := ((1+len+plus+1) < linewidth );
        neednl := (neednl OR redirected);
        neednl := (neednl OR (linewidth # screenwidth)); (* < *)

        WrLn;
        WrChar(frameChars[0]);
        FOR i:=1 TO (len+plus) DO WrChar(frameChars[4]); END;
        WrChar(frameChars[2]);
        IF neednl THEN WrLn; END;

        IF doFrame # frameNone THEN
            WrChar(frameChars[1]);
            FOR i:=1 TO (len+plus) DO WrChar(space); END;
            WrChar(frameChars[1]);
            IF neednl THEN WrLn; END;
        END;

        FOR j:=firstline TO lastline DO
            WrChar(frameChars[1]);
            IF doFrame # frameNone THEN WrChar(space); END;
            WrStr(sline[j]);
            FOR k:=Str.Length(sline[j])+1 TO len DO
                WrChar(space);
            END;
            IF doFrame # frameNone THEN WrChar(space); END;
            WrChar(frameChars[1]);
            IF neednl THEN WrLn; END;
        END;

        IF doFrame # frameNone THEN
            WrChar(frameChars[1]);
            FOR i:=1 TO (len+plus) DO WrChar(space); END;
            WrChar(frameChars[1]);
            IF neednl THEN WrLn; END;
        END;

        WrChar(frameChars[3]);
        FOR i:=1 TO (len+plus) DO WrChar(frameChars[4]); END;
        WrChar(frameChars[5]);
        IF neednl THEN WrLn; END;
    END;
    IF doBeautify THEN WrLn; END;
END dmpSentence;

PROCEDURE cleanescaped (VAR S:ARRAY OF CHAR);
BEGIN
    pack(S,backslash+backslash      ,backslash);
    pack(S,backslash+slash          ,slash);
    pack(S,backslash+tilde          ,tilde);
    (* pack(S,backslash+commercial     ,commercial); *)
    pack(S,backslash+semicolon      ,semicolon);   (* for rem at start of line *)
    pack(S,backslash+pound          ,pound);       (* for rem at start of line *)
    pack(S,backslash+openparen      ,openparen);
    (* others ? *)
END cleanescaped;

PROCEDURE autocapitalize (VAR S : ARRAY OF CHAR);
VAR
    p : CARDINAL;
    c : CHAR;
BEGIN
    LOOP
        p:=Str.Pos(S,capmarker);
        IF p=MAX(CARDINAL) THEN EXIT; END;
        Str.Subst(S,capmarker,"");
        c:=S[p];
        IF c # CHR(0) THEN
            UpperCase(c);
            S[p]:=c;
        END;
    END;
END autocapitalize;

PROCEDURE autolow (VAR S : ARRAY OF CHAR);
VAR
    p : CARDINAL;
    c : CHAR;
BEGIN
    LOOP
        p:=Str.Pos(S,lowmarker);
        IF p=MAX(CARDINAL) THEN EXIT; END;
        Str.Subst(S,lowmarker,"");
        c:=S[p];
        IF c # CHR(0) THEN
            LowerCase(c);
            S[p]:=c;
        END;
    END;
END autolow;

(* identical to pack("\","") ! *)

PROCEDURE autosuffix (VAR S : ARRAY OF CHAR);
VAR
    p : CARDINAL;
    c : CHAR;
BEGIN
    LOOP
        p:=Str.Pos(S,suffixmarker);
        IF p=MAX(CARDINAL) THEN EXIT; END;
        Str.Subst(S,suffixmarker,"");
    END;
END autosuffix;

(*
   handle "?\' ?" sequence only, i.e. character, elision marker, space, character
           01234
*)

PROCEDURE autoelision (VAR S : ARRAY OF CHAR);
VAR
    prevp,p : CARDINAL;
    c       : CHAR;
    seq     : str16;
BEGIN
    IF Str.Length(S)=0 THEN RETURN; END; (* don't bother ! *)
    prevp:=1; (* ignore possible "\'" at the beginning of S *)
    LOOP
        p:=Str.NextPos(S,elisionmarker,prevp);
        IF p= MAX(CARDINAL) THEN EXIT; END;
        Str.Slice(seq, S, p-1, 5);
        IF Str.Match(seq,possibleElision) THEN
            c:=S[p-1+4];
            UpperCase(c);
            IF Belongs(elisionRequired,c) THEN
                Str.Delete(S,p-1,4);           (* remove "?\' " *)
                Str.Insert(S,singlequote,p-1); (* insert "'" *)
                prevp:=p;                      (* restart after the single quote we just inserted *)
            ELSE
                Str.Delete(S,p,2); (* just remove elision marker, leaving first character and space *)
                prevp:=p; (* yes, we could restart after last character...  *)
            END;
        ELSE
            prevp:=p+2; (* skip "\'" marker *)
        END;
    END;
END autoelision;

(*
   handle "A\- ?" sequence only, i.e. "a", article marker, space, character
           01234
*)

PROCEDURE autoarticle (VAR S : ARRAY OF CHAR);
VAR
    prevp,p : CARDINAL;
    c,ourA,ourN : CHAR;
    seq     : str16;
BEGIN
    IF Str.Length(S)=0 THEN RETURN; END; (* don't bother ! *)
    prevp:=1; (* ignore possible "\-" at the beginning of S *)
    LOOP
        p:=Str.NextPos(S,articlemarker,prevp);
        IF p= MAX(CARDINAL) THEN EXIT; END;
        Str.Slice(seq, S, p-1, 5);
        UpperCase(seq);
        IF Str.Match(seq,possibleArticle) THEN
            c:=S[p-1+4];
            UpperCase(c);
            IF Belongs(articleRequired,c) THEN
                ourA := S[p-1];
                (* it's "A" or "a" *)
                IF ourA = "A" THEN
                    ourN := "n"; (* too smart ! *)
                ELSE
                    ourN := "n";
                END;
                Str.Delete(S,p,2);     (* remove "\-" *)
                Str.Insert(S,ourN,p);  (* insert "N" or "n" *)
                prevp:=p+1;            (* restart after the added letter *)
            ELSE
                Str.Delete(S,p,2); (* just remove article marker *)
                prevp:=p; (* yes, we could restart after last character...  *)
            END;
        ELSE
            prevp:=p+2; (* skip "\-" marker *)
        END;
    END;
END autoarticle;

PROCEDURE formatSentence (LineWidth,doFrame:CARDINAL;fullclean:BOOLEAN;
                          VAR lastline,longest:CARDINAL;S:ARRAY OF CHAR):BOOLEAN;
VAR
    tmplen  : CARDINAL;
    tmp               : str256;   (* could be str128 but... *)
    splitagain        : BOOLEAN;
    p                 : CARDINAL;
    Z                 : strHUGE;  (* just in case *)
BEGIN
    (* genMoney(S); *)
    cleanstring(fullclean,S);
    cleanescaped(S);
    autocapitalize(S);
    autolow(S);
    autosuffix(S);
    autoelision(S); (* FR *)
    autoarticle(S); (* US *)

    CASE doFrame OF
    | frameRaw : ;
    | frameNone:
        DEC(LineWidth,wiHORIZalt); (* string + 2 spaces *)
    ELSE
        DEC(LineWidth,wiHORIZ);    (* string + 2 spaces + 2 bars *)
    END;

    lastline  := firstline-1;
    longest   := 0;

    LOOP
        p:=Str.Pos(S,newlinemarker);
        IF p = MAX(CARDINAL) THEN EXIT; END;
        Str.Slice(Z,S,0,p);
        Str.Delete(S,0,p+1+1); (* "\!" CRLF marker takes two characters *)

        splitagain:=dmpTTX(Z,LineWidth,tmp,TRUE);
        WHILE splitagain DO
            Str.Copy(sline[firstline+lastline],tmp);
            tmplen:=Str.Length(tmp);
            slen[firstline+lastline]:=tmplen;
            IF tmplen > longest THEN longest := tmplen; END;
            INC(lastline);
            IF lastline >= maxline THEN RETURN FALSE; END;
            splitagain:=dmpTTX(Z,LineWidth,tmp,FALSE);
        END;
        IF Str.Pos(S,newlinemarker)=0 THEN
            Str.Copy(sline[firstline+lastline], "");
            slen[firstline+lastline]:=0;
            INC(lastline);
            IF lastline >= maxline THEN RETURN FALSE; END;
        END;
    END;

        splitagain:=dmpTTX(S,LineWidth,tmp,TRUE);
        WHILE splitagain DO
            Str.Copy(sline[firstline+lastline],tmp);
            tmplen:=Str.Length(tmp);
            slen[firstline+lastline]:=tmplen;
            IF tmplen > longest THEN longest := tmplen; END;
            INC(lastline);
            IF lastline >= maxline THEN RETURN FALSE; END;
            splitagain:=dmpTTX(S,LineWidth,tmp,FALSE);
        END;

    RETURN TRUE;
END formatSentence;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* ripped FROM MPAUSE *)

PROCEDURE MouseDriverHere ( ) : BOOLEAN;
CONST
    MouseInt   = 033H;
CONST
    InstallChk = 00000H;
VAR
    R : SYSTEM.Registers;
BEGIN
    (*
    R.AX := InstallChk;
    Lib.Intr(R,MouseInt);
    RETURN (R.AX # 0);
    *)
    RETURN (MsMouse.Reset() # MAX(INTEGER) ); (* InstallChk is Reset ! *)
END MouseDriverHere;

(* ------------------------------------------------------------ *)

CONST
    delai       = 100; (* 0.1 second *)
    delaimickey = 300; (* avoid too fast a change with a mouseclick *)
TYPE
    mousebuttonstype = SET OF (leftbutton,rightbutton,middlebutton);
VAR
    which : mousebuttonstype;

PROCEDURE mouseclick ( ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    which:=mousebuttonstype{};
    IF msdata.left_pressed   THEN INCL(which,leftbutton); END;
    IF msdata.right_pressed  THEN INCL(which,rightbutton); END;
    IF msdata.middle_pressed THEN INCL(which,middlebutton);END;
    RETURN (which # mousebuttonstype{} );
END mouseclick;

PROCEDURE getLastPressed (  ):mousebuttonstype;
BEGIN
    Lib.Delay(delaimickey); (* force a small delay *)
    RETURN which;
END getLastPressed;

CONST
    keyEscape  = 01B00H;
    keySpace   = 02000H;
    keyCR      = 00D00H;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

PROCEDURE forcepause (stopmouse:BOOLEAN; alwayspause,pause,first,last:CARDINAL );
VAR
    i,j:CARDINAL;
BEGIN
    FOR i := 1 TO alwayspause*10 DO
        IF BiosIO.KeyPressed() THEN RETURN;END;
        IF stopmouse THEN
            IF mouseclick() THEN RETURN;  END;
        END;
        Lib.Delay(delai);
    END;
    FOR j:=first TO last DO
        FOR i := 1 TO pause*10 DO
            IF BiosIO.KeyPressed() THEN RETURN; END;
            IF stopmouse THEN
                IF mouseclick() THEN RETURN; END;
            END;
            Lib.Delay(delai);
        END;
    END;
END forcepause;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* yes, yes, we know we should have rewritten dmpSentence in a more general way... *)

PROCEDURE dmpSentenceAt (doFrame:CARDINAL;
                         lastline,longest:CARDINAL;
                         alwayspause,pause:CARDINAL; atrandompos,stopmouse:BOOLEAN );
VAR
    plus,len,i,j,k    : CARDINAL;
    frameChars   : str16;
    S            : str128;
VAR
    mini,maxi,wi,ws,v,htab,vtab : CARDINAL;
BEGIN
    mini := getMinHtab(); (* 0.. *)
    maxi := getMaxHtab();
    wi := maxi-mini+1;
    ws := longest;
    CASE doFrame OF
    | frameRaw : ;
    | frameNone:
        INC(ws,wiHORIZalt);
    ELSE
        INC(ws,wiHORIZ);
    END;
    IF wi > ws THEN
        IF atrandompos THEN
            v:=GetRndCardRange(1,wi-ws) -1;
        ELSE
            v:=(wi-ws) DIV 2;
        END;
    ELSE
        v := 0;
    END;
    htab := mini+v;
(*
WrLn;IO.WrCard(mini,4);IO.WrCard(maxi,4);
WrLn;IO.WrCard(wi,4);
WrLn;IO.WrCard(longest,4);IO.WrCard(ws,4);
WrLn;IO.WrCard(v,4);
WrLn;IO.WrCard(htab,4);
WrLn;
*)
    mini := getMinVtab(); (* 0.. *)
    maxi := getMaxVtab();
    wi := maxi-mini+1;
    ws := lastline-firstline+1;
    CASE doFrame OF
    | frameRaw : ;
    | frameNone:
        INC(ws,wiVERTIalt);
    ELSE
        INC(ws,wiVERTI);
    END;
    IF wi > ws THEN
        IF atrandompos THEN
            v:=GetRndCardRange(1,wi-ws) -1;
        ELSE
            v:=(wi-ws) DIV 2;
        END;
    ELSE
        v := 0;
    END;
    vtab := mini+v;

    len := longest;
    CASE doFrame OF
    | frameNone   : frameChars := sNone;   plus:=0;
    | frameSingle : frameChars := sSingle; plus:=2;
    | frameDouble : frameChars := sDouble; plus:=2;
    END;

    CASE doFrame OF
    | frameRaw :
        FOR j:=firstline TO lastline DO
            gotoXY(htab,vtab);
            WrStr(sline[j]);
            INC(vtab);
        END;
    ELSE
        gotoXY(htab,vtab);
        WrChar(frameChars[0]);
        FOR i:=1 TO (len+plus) DO WrChar(frameChars[4]); END;
        WrChar(frameChars[2]);
        INC(vtab);

        IF doFrame # frameNone THEN
            gotoXY(htab,vtab);
            WrChar(frameChars[1]);
            FOR i:=1 TO (len+plus) DO WrChar(space); END;
            WrChar(frameChars[1]);
            INC(vtab);
        END;

        FOR j:=firstline TO lastline DO
            gotoXY(htab,vtab);
            WrChar(frameChars[1]);
            IF doFrame # frameNone THEN WrChar(space); END;
            WrStr(sline[j]);
            FOR k:=Str.Length(sline[j])+1 TO len DO
                WrChar(space);
            END;
            IF doFrame # frameNone THEN WrChar(space); END;
            WrChar(frameChars[1]);
            INC(vtab);
        END;

        IF doFrame # frameNone THEN
            gotoXY(htab,vtab);
            WrChar(frameChars[1]);
            FOR i:=1 TO (len+plus) DO WrChar(space); END;
            WrChar(frameChars[1]);
            INC(vtab);
        END;

        gotoXY(htab,vtab);
        WrChar(frameChars[3]);
        FOR i:=1 TO (len+plus) DO WrChar(frameChars[4]); END;
        WrChar(frameChars[5]);
        INC(vtab);
    END;
    forcepause(stopmouse,alwayspause,pause,firstline,lastline);
END dmpSentenceAt;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    MAXHASH = MAX(CARDINAL); (* 65535 *)
TYPE
    ptrEntry = POINTER TO entryType;
    entryType = RECORD
        next     : ptrEntry;
        len      : CARDINAL; (* was SHORTCARD but now we accept long sentences... *)
        string   : CHAR;       (* here, after other data, because variable length *)
    END;
TYPE
    categoryType = RECORD
        anchor      : ptrEntry;
        count       : CARDINAL; (* // LONGCARD is useless *)
        hash        : CARDINAL;
        id          : str32;
        tags        : str32;
    END;
CONST
    firstcategory = 1;   (* must be 1 *)
    maxcategory   = 500;
VAR
    category     : ARRAY [firstcategory..maxcategory] OF categoryType;
    lastcategory : CARDINAL;

(* ------------------------------------------------------------ *)

(*
   0=first tag i.e. text between open curly and first vbar,
   1=2nd tag i.e. text between first vbar and next terminator (other vbar or close curly)
*)

PROCEDURE findvariant (wanted:CARDINAL;VAR S : ARRAY OF CHAR);
VAR
    len,p:CARDINAL;
    R:strHUGE;
    state:(waiting,incurly,escaped);
    c:CHAR;
    currtag:CARDINAL;
BEGIN
    len:=Str.Length(S);
    IF len=0 THEN RETURN;END; (* should never happen *)
    Str.Copy(R,"");
    state:=waiting;
    p:=0;
    WHILE p < len DO
        c:=S[p];
        CASE state OF
        | waiting:
            CASE c OF
            | opencurly:
                state:=incurly; currtag:=0;
            ELSE
                Str.Append(R,c);
            END;
        | incurly:
            CASE c OF
            | backslash: Str.Append(R,c);state:=escaped;
            | closecurly:state:=waiting;
            | vbar:INC(currtag);
            ELSE
                IF currtag=wanted THEN Str.Append(R,c);END;
            END;
        | escaped:
            Str.Append(R,c);
            state:=incurly;
        END;
        INC(p);
    END;
    Str.Copy(S, R);
END findvariant;

(* ------------------------------------------------------------ *)

PROCEDURE getnextkeywords (len:CARDINAL;S:ARRAY OF CHAR;
                           VAR p,basep,count:CARDINAL;
                           VAR W,T:ARRAY OF CHAR ):BOOLEAN ;
VAR
    state:(waiting,chkescaped,incategory,intag);
    c:CHAR;
BEGIN
    (* "\xxx", "\xxx/x" *)

    basep:=p;
    count:=0;

    Str.Copy(W,"");
    Str.Copy(T,"");

    state:=waiting;
    LOOP
        IF NOT (p<len) THEN EXIT; END;
        c := S[p];
        UpperCase(c);
        CASE state OF
        | waiting:
            CASE c OF
            | backslash: Str.Copy(W,c);state:=chkescaped;
            ELSE
                INC (count);
            END;
        | chkescaped:
            IF Belongs(legalforcategory,c) THEN (* // was alphanum *)
                Str.Append(W,c);
                state:=incategory;
            ELSE
                INC(count,2);    (* pass "\?" *)
                state:=waiting;
                Str.Copy(W,"");  (* just in case *)
            END;
        | incategory:
            IF Belongs(legalforcategory,c) THEN (* // was alphanum  *)
                Str.Append(W,c);
            ELSE
                CASE c OF
                | backslash:RETURN TRUE; (* "\xx\" *)
                | slash:    Str.Copy(T,c);state:=intag; (* "\xx/" *)
                ELSE
                    RETURN TRUE; (* "\xx?" *)
                END;
            END;
        | intag:
            IF Belongs(legalfortag,c) THEN (* // was alphanum+commercial *)
                Str.Append(T,c);
                INC(p); (* pass char *)
                RETURN TRUE; (* only one letter or digit or & after "/" i.e. "\xx/?" *)
            ELSE
                (* "\xx/?" assume empty tag *)
                RETURN TRUE;
            END;
        END;
        INC(p);
    END;
    CASE state OF
    | waiting    : RETURN FALSE; (* nothing was found *)
    | chkescaped : RETURN FALSE; (* "*\" *)
    | incategory : RETURN TRUE;  (* "*\x" *)
    | intag      : RETURN TRUE;  (* "\xx/" *)
    END;
END getnextkeywords;

PROCEDURE docapskeywords (VAR S:ARRAY OF CHAR  );
VAR
    R,TMP : strHUGE;
    len,p,basep,count : CARDINAL;
    W,T : str128;
BEGIN
    len:=Str.Length(S);
    IF len=0 THEN RETURN;END; (* should never happen *)

    Str.Copy(R,"");
    p:=0;
    WHILE getnextkeywords(len,S, p,basep,count, W,T) DO
        Str.Slice (TMP, S, basep,count);
        Str.Append(R,TMP);
        Str.Append(R,W);
        Str.Append(R,T);
    END;
    Str.Slice (TMP, S,basep,count);
    Str.Append(R,TMP);

    Str.Copy(S, R);
END docapskeywords;

(* ------------------------------------------------------------ *)

PROCEDURE isoleweight (VAR S : ARRAY OF CHAR):CARDINAL ;
VAR
    p,q,n:CARDINAL ;
    S2 : str32;
    v  : LONGCARD;
    ok: BOOLEAN;
BEGIN
    IF S[0]=openparen THEN
        p:=0;
        q:=Str.CharPos(S,closeparen);
        IF q = MAX(CARDINAL) THEN RETURN MAX(CARDINAL);END; (* "(..." *)
        Str.Slice(S2,S,p+1,q-p-1);
        IF verifyString(S2,digits)=FALSE THEN RETURN MAX(CARDINAL);END; (* we could return 1 but use (1)(...) trick instead *)
        Str.Delete(S,p,q-p+1); (* S[p]:=CHR(0); *)
        v:=Str.StrToCard(S2,10,ok);
        IF ok = FALSE THEN RETURN MAX(CARDINAL);END;
        IF v > MAX(SHORTCARD) THEN RETURN MAX(CARDINAL);END;
        n:=CARDINAL(v);
    ELSE
        n:=1;
    END;
    RETURN n;
END isoleweight;

PROCEDURE data (doanchor:BOOLEAN; i:CARDINAL;
                VAR newInList:ptrEntry;VAR problems:CARDINAL;
                S:ARRAY OF CHAR);
VAR
    len,needed:CARDINAL;
    p : ptrEntry;
BEGIN
    problems:=0;
    len    := Str.Length(S);
    needed := SIZE(entryType)-SIZE(CHAR)+len;
    IF Available(needed)=FALSE THEN INC(problems);RETURN;END;
    IF doanchor THEN
        ALLOCATE( p,needed);
        newInList := p;
        category[i].anchor := p;
    ELSE
        ALLOCATE(newInList^.next,needed);
        newInList :=newInList^.next;
    END;
    Lib.FastMove( ADR(S),ADR(newInList^.string),len);
    newInList^.len       := len;
    newInList^.next      := NIL;
    INC( category[i].count);
END data;

(* S is category, S2 is tags between curlies *)

PROCEDURE isoletags (VAR S,S2:ARRAY OF CHAR ):BOOLEAN ;
VAR
    p,q:CARDINAL;
BEGIN
    Str.Copy(S2,""); (* default *)
    Str.Delete(S,0,1); (* remove tilde *)
    p:=Str.CharPos(S,opencurly);
    q:=Str.RCharPos(S,closecurly);
    IF p = MAX(CARDINAL) THEN
        IF q # MAX(CARDINAL) THEN RETURN FALSE;END; (* } alone *)
    ELSE
        IF q = MAX(CARDINAL) THEN RETURN FALSE;END; (* { alone *)
        IF p > q THEN RETURN FALSE; END; (* }*{ *)
        Str.Slice(S2,S,p+1,q-p-1);
        Str.Delete(S,p,q-p+1); (* S[p]:=CHR(0); *)
    END;
    IF Str.Length(S)  > SIZE(str32) THEN RETURN FALSE; END;
    UpperCase(S);
    IF verifyString(S ,legalforcategory)=FALSE THEN RETURN FALSE;END; (* // was alphanum *)

    IF Str.Length(S2) > SIZE(str32) THEN RETURN FALSE; END;
    UpperCase(S2);
    IF verifyString(S2,legalfortag)=FALSE THEN RETURN FALSE;END; (* // was alphanum *)
    RETURN TRUE;
END isoletags;

PROCEDURE readScript (debug,useLFN:BOOLEAN; datafile:pathtype) : BOOLEAN;
VAR
    hin : FIO.File;
    S,SPLUS   : strHUGE;  (* oversized just in CASE *)
    rc,ateof  : BOOLEAN;
    i,problems,j,weight,position,len: CARDINAL;
    p   : ptrEntry;
    S2  : str32;
    currline : CARDINAL;
BEGIN
    FOR i := firstcategory TO maxcategory DO
        category[i].anchor := NIL;
        category[i].count  := MAX(CARDINAL);
    END;

    i:=firstcategory-1;
    p:=NIL;
    rc:=TRUE;
    currline := 0;

    hin := fileOpenRead(useLFN,datafile);
    FIO.AssignBuffer(hin,bufferIn);

    FIO.EOF:=FALSE;
    LOOP
        IF FIO.EOF THEN EXIT; END;
        FIO.RdStr(hin,S);
        IF FIO.EOF THEN EXIT; END;
        LtrimBlanks(S);
        RtrimBlanks(S);
        (* handle multiline here but we won't bother to check for 4096 chars limit ! *)
        position:=Str.Pos(S,concatenate);
        len := Str.Length(S);
        IF ( (position # MAX(CARDINAL)) AND (len >= lenconcatenate) ) THEN
        (* do not test directly with len-2 ! it would confuse single character entry ! *)
          IF position=(len-lenconcatenate) THEN
            ateof := FALSE;
            LOOP
                FIO.RdStr(hin,SPLUS);
                IF FIO.EOF THEN ateof:=TRUE; EXIT; END;
                LtrimBlanks(SPLUS);
                RtrimBlanks(SPLUS);
                Str.Subst(S,concatenate,""); (* was space *)
                Str.Append(S,SPLUS);
                position:=Str.Pos(S,concatenate);
                len := Str.Length(S);
                IF ( (position=MAX(CARDINAL)) OR (len<lenconcatenate) ) THEN EXIT; END;
                IF position # (len-lenconcatenate) THEN EXIT; END;
            END;
            IF ateof THEN EXIT; END;
          END;
        END;

        (* resume normal operation *)
        INC(currline);
        IF debug THEN IO.WrCard(currline,5);WrStr(" : ");WrStr(S);WrLn;END;
        CASE S[0] OF
        | CHR(0),semicolon,pound: ; (* empty or comment *)
        | tilde:
            INC(i);
            IF i > maxcategory THEN rc:=FALSE;EXIT;END;
            IF isoletags(S,S2)=FALSE THEN rc:=FALSE;EXIT;END;
            Str.Copy(category[i].id,S);
            Str.Copy(category[i].tags,S2);
            category[i].hash := Lib.HashString(S,MAXHASH);
            category[i].count:= 0;
        ELSE
            (* // LONGCARD was useless ! *)
            CASE category[i].count OF
            | MAX(CARDINAL): rc:=FALSE;EXIT;
            | 0 :
                weight:=isoleweight(S);
                IF weight=MAX(CARDINAL) THEN rc:=FALSE;EXIT; END;
                docapskeywords(S);
                data(TRUE, i, p,problems,S);
            ELSE
                weight:=isoleweight(S);
                IF weight=MAX(CARDINAL) THEN rc:=FALSE;EXIT; END;
                docapskeywords(S);
                data(FALSE,i, p,problems,S);
            END;
            IF problems # 0 THEN rc:=FALSE;EXIT;END;
            FOR j:=1 TO weight-1 DO
                IF problems=0 THEN data(FALSE,i, p,problems,S); END;
            END;
        END;
    END;
    fileClose(useLFN,hin);
    IF debug THEN WrLn;END;
    lastcategory := i;
    RETURN rc;
END readScript;

(* ------------------------------------------------------------ *)

PROCEDURE dumpquoted (S:ARRAY OF CHAR   );
BEGIN
    WrStr('"');
    WrStr(S);
    WrStr('"');
END dumpquoted;

PROCEDURE dumpit (i:CARDINAL);
CONST
    msgIndex    = "Index    : ";
    msgCount    = "Count    : ";
    msgCategory = "Category : ";
    msgTags     = "Tags     : ";
    msgEntry    = "           ";
VAR
    firstInList,newInList : ptrEntry;
    S     : strHUGE;  (* huge just in case ! *)
    len,p : CARDINAL;
    tags,Z: str128; (* should do *)
BEGIN
    WrStr(msgIndex);IO.WrCard(i,4);WrLn;
    WrStr(msgCount);IO.WrCard(category[i].count,4);WrLn; (* // WrLngCard 8 *)
    WrStr(msgCategory);dumpquoted(category[i].id);WrLn;
    WrStr(msgTags);dumpquoted(category[i].tags);WrLn;
    WrLn;

    firstInList := category[i].anchor;
    newInList := firstInList;
    WHILE newInList # NIL DO
        firstInList := firstInList^.next;
        len         := CARDINAL(newInList^.len);
        Lib.FastMove( ADR(newInList^.string),ADR(S),len);
        S[len]      := nullchar; (* REQUIRED safety ! *)
        WrStr(msgEntry);dumpquoted(S);WrLn;
        newInList := firstInList;
    END;
    WrLn;

    Str.Copy(tags,category[i].tags);

    IF same(tags,"") THEN RETURN; END;

    FOR p:=0 TO Str.Length(tags) DO
        Z:="::: Caller : "+antislash+vbar;
        CASE p OF
        | 0 :
            Str.Subst(Z,vbar,category[i].id); (* calling without any tag *)
        ELSE
            Str.Append(Z,slash+vbar);
            Str.Subst(Z,vbar,category[i].id);
            Str.Subst(Z,vbar,category[i].tags[p-1]); (* \category/tagletter *)
        END;
        WrStr(msgEntry);dumpquoted(Z);WrLn;
        WrLn;

        firstInList := category[i].anchor;
        newInList := firstInList;
        WHILE newInList # NIL DO
            firstInList := firstInList^.next;
            len         := CARDINAL(newInList^.len);
            Lib.FastMove( ADR(newInList^.string),ADR(S),len);
            S[len]      := nullchar; (* REQUIRED safety ! *)
            (* variant using p index *)
            findvariant (p,S);
            WrStr(msgEntry);dumpquoted(S);WrLn;
            newInList := firstInList;
        END;
        WrLn;
    END;

END dumpit;

PROCEDURE dumpall (  );
VAR
    i : CARDINAL;
BEGIN
    FOR i := firstcategory TO lastcategory DO
        dumpit(i);
    END;
END dumpall;

PROCEDURE freeit ( i : CARDINAL);
VAR
    len,needed      : CARDINAL;
    firstInList,newInList   : ptrEntry;
BEGIN
    firstInList := category[i].anchor;
    newInList := firstInList;
    WHILE newInList # NIL DO
         len         := CARDINAL(newInList^.len);
         needed      := SIZE(entryType)-SIZE(CHAR)+len;
         firstInList := firstInList^.next;
         DEALLOCATE (newInList,needed);
         newInList := firstInList;
    END
END freeit;

PROCEDURE freeall ();
VAR
    i : CARDINAL;
BEGIN
    FOR i := firstcategory TO lastcategory DO
        freeit(i);
    END;
END freeall;

(* ------------------------------------------------------------ *)

(* assume there's enough room in R ! *)

PROCEDURE loadString (ndx:CARDINAL;VAR R:ARRAY OF CHAR);
VAR
    firstInList,newInList:ptrEntry;
    i,n, len:CARDINAL;
BEGIN
    IF category[ndx].count=0 THEN Str.Copy(R,"");RETURN;END; (* returning "???" was useless *)
    n := GetRndCardRange (1,category[ndx].count);
    (* n := GetRndLngCardRange (1,category[ndx].count); *)
    firstInList := category[ndx].anchor;
    newInList := firstInList;
    DEC(n); (* trick to force to anchor if 1, and locate correct string if > 1 *)
    FOR i:= 1 TO n DO
        firstInList := firstInList^.next;
        newInList := firstInList;
    END;
    len := CARDINAL(newInList^.len);
    Lib.FastMove( ADR(newInList^.string),ADR(R),len);
    R[len] := nullchar; (* REQUIRED safety ! *)
END loadString;

PROCEDURE findcategoryindex (VAR i : CARDINAL;W:ARRAY OF CHAR):BOOLEAN;
VAR
    hash:CARDINAL;
BEGIN
    Str.Delete(W,0,1); (* remove marker *)
    hash:=Lib.HashString(W,MAXHASH);
    i:=firstcategory;
    LOOP
        IF category[i].hash=hash THEN
            IF same(W,category[i].id) THEN RETURN TRUE; END;
        END;
        INC(i);
        IF i > lastcategory THEN RETURN FALSE;END;
    END;
END findcategoryindex;

PROCEDURE getVariant (i:CARDINAL;T:ARRAY OF CHAR;VAR R:ARRAY OF CHAR);
VAR
    wanted : CARDINAL;
BEGIN
    loadString(i,R);
    Str.Delete(T,0,1); (* remove marker *)
    IF Str.Length(T)=0 THEN RETURN;END;
    wanted:=Str.CharPos(category[i].tags,T[0]);
    IF wanted = MAX(CARDINAL) THEN
        wanted:=0; (* keep "{*|" if any *)
    ELSE
        INC(wanted);
    END;
    findvariant(wanted,R);
END getVariant;

PROCEDURE getSentence (debug:BOOLEAN; VAR R : ARRAY OF CHAR):BOOLEAN;
VAR
    len,p,basep,count:CARDINAL;
    i:CARDINAL;
    msg : strHUGE;
    W,T,prevT : str128;
    rc : BOOLEAN;
BEGIN
    loadString(lastcategory,R); (* main string *)
    Str.Copy(prevT,"");
    rc:=TRUE;
    LOOP
        len:=Str.Length(R);
        p:=0;
        IF getnextkeywords(len,R, p,basep,count, W,T)=FALSE THEN EXIT;END;
        IF debug THEN
            WrStr("tag0: ");dumpquoted(prevT);WrLn;
            WrStr("str : ");dumpquoted(R);WrLn;
            WrStr("cat : ");dumpquoted(W);WrLn;
            WrStr("tag : ");dumpquoted(T);WrLn;
        END;
        IF findcategoryindex(i,W)=FALSE THEN rc:=FALSE; EXIT; END;
        IF same(T,"") THEN
            getVariant(i,suppress,msg); (* force an impossible tag to remove text between curlies *)
            Str.Subst(R,W,msg);
            (* Str.Copy(prevT,T); *)
        ELSIF same(T,herit) THEN
            IF same(prevT,"") THEN
                getVariant(i,suppress,msg);
            ELSE
                getVariant(i,prevT,msg);
            END;
            Str.Subst(R,T,"");
            Str.Subst(R,W,msg);
        ELSE
            getVariant(i,T,msg);
            Str.Subst(R,T,"");
            Str.Subst(R,W,msg);
            Str.Copy(prevT,T);
        END;
    END;
    RETURN rc;
END getSentence;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE showmem();
VAR
    heapsize    : CARDINAL; (* in PARAGRAPHS and not in bytes ! help is wrong ! *)
    n           : LONGCARD;
BEGIN
    heapsize :=HeapTotalAvail(MainHeap);
    WrStr("Available : ");
    n :=16 * LONGCARD(heapsize);
    IO.WrLngCard(n,6);WrLn;
END showmem;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE padstr (VAR S:ARRAY OF CHAR;alt:BOOLEAN;mini,maxi:CARDINAL);
VAR
    i:CARDINAL;
BEGIN
    FOR i := mini TO maxi DO
        IF alt THEN
            Str.Prepend(S,space);
        ELSE
            Str.Append(S,space);
        END;
    END;
END padstr;

CONST
              (* "fff.e       " *)
              (* "      ff.ee " *)
              (* "ffffffff.eee" if DOS f8e3 *)
    sBase      = "; Directory";
    sepabout   =  " : ";

PROCEDURE fmtFileName ( VAR R:pathtype;
                      useLFN,altdisplay:BOOLEAN; maxlenfilename:CARDINAL;
                      S : pathtype );
CONST
    f8len      = 8;
    e3len      = 3;
    rightalign = TRUE; (* prettier *)
VAR
    p:CARDINAL;
BEGIN
    Str.Copy(R,S);
    IF Str.RCharPos(R,dot)=MAX(CARDINAL) THEN Str.Append(R,dot);END;

    IF useLFN THEN
        padstr(R, rightalign,  Str.Length(R)+1, maxlenfilename);
    ELSE
        p:=Str.RCharPos(R,dot);
        padstr(R, rightalign,  p+1,f8len);
        p:=Str.RCharPos(R,dot);
        padstr(R, FALSE,       Str.Length(R)+1,f8len+1+e3len);
    END;
END fmtFileName;

(* assume file exists *)

PROCEDURE showtitle (maxlenfilename,linewidth:CARDINAL;
                    redirected,useLFN,DEBUG:BOOLEAN;
                    zebase,zefile:pathtype);
CONST
    msgUndefined = "(undefined or not a "+ProgEXEname+" script)";
    msgMore      = "...";
    lenMsgMore   = 3;
    maxtryline   = 10;
VAR
    hin:FIO.File;
    S : strHUGE;
    state:(waiting,gottitle);
    F,F2:pathtype;
    remopen,remclose:str16;
    i,len,slen,currline:CARDINAL;
BEGIN
    fmtFileName(F, useLFN,TRUE,maxlenfilename,zefile);
    Str.Append(F,sepabout);
    Str.Concat(F2,zebase,zefile);
    IF DEBUG THEN
        WrStr("F showtitle : ");WrStr(F);WrLn;
        WrStr("F2 showtitle: ");WrStr(F2);WrLn;
    END;

    hin := fileOpenRead(useLFN,F2);
    FIO.AssignBuffer(hin,bufferIn);

    currline:=0;
    state:=waiting;
    FIO.EOF:=FALSE;
    LOOP
        IF FIO.EOF THEN EXIT; END;
        FIO.RdStr(hin,S);
        IF FIO.EOF THEN EXIT; END;
        LtrimBlanks(S);
        RtrimBlanks(S);
        CASE S[0] OF
        | commentchar1,commentchar2:
            Str.Delete(S,0,1);
            LtrimBlanks(S);
            FOR i:=1 TO 3 DO
                CASE i OF
                | 1 : remopen:=comment1; remclose:="";        (* //  *)
                | 2 : remopen:=comment2; remclose:="";        (* ::: *)
                | 3 : remopen:=comment3; remclose:=comment3a; (*     *)
                END;
                IF Str.Pos(S,remopen)=0 THEN
                    IF same(remclose,"") THEN
                        INC(state);
                    ELSE
                        slen:=Str.Length(S);
                        len :=Str.Length(remclose);
                        IF slen >= len THEN
                            Str.Slice(F2,S,slen-len,len);
                            IF same(F2,remclose) THEN
                                S[slen-len]:=CHR(0);
                                RtrimBlanks(S);
                                INC(state);
                            END;
                        END;
                    END;
                END;
                IF state # waiting THEN EXIT; END;
            END;
        END;
        INC(currline);
        IF currline > maxtryline THEN EXIT; END;
    END;
    fileClose(useLFN,hin);
    CASE state OF
    | waiting :
        F2:=msgUndefined;
    | gottitle:
        Str.Delete(S,0,Str.Length(remopen));
        LtrimBlanks(S);
        Str.Copy(F2,S);
    END;
    Str.Append(F,F2);
    IF redirected THEN
        WrStr(F);WrLn;
    ELSE
        slen:=Str.Length(F);
        IF slen >= linewidth THEN
            F[linewidth-lenMsgMore-1]:=CHR(0); (* brutal *)
            Str.Append(F,msgMore);
        END;
        WrStr(F);WrLn;
    END;
END showtitle;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE initDefaultFilenames(VAR exedir,currdir,defaultdatfile:pathtype; ext:ARRAY OF CHAR);
VAR
    exe,u,d,f8,e3:str128; (* str128 was already oversized for DOS library used here *)
    currunit:SHORTCARD;
BEGIN
    Lib.ParamStr(exe,0);
    UpperCaseAlt(exe); (* useless but... *)
    Lib.SplitAllPath(exe,u,d,f8,e3);
    Lib.MakeAllPath(exedir,u,d,"","");
    Lib.MakeAllPath(defaultdatfile,"","",f8,ext);
    currunit:=FIO.GetDrive(); (* 1=A etc. *)
    FIO.GetDir(currunit,currdir); (* "\*" *)
    Str.Prepend(currdir,colon);
    Str.Prepend(currdir, CHR( CARDINAL(currunit)+ORD("A")-1) );
    fixDirectory(currdir); (* add trailing "\" *)
END initDefaultFilenames;

PROCEDURE dbg (DEBUG,useLFN:BOOLEAN;varname,varcontent:ARRAY OF CHAR);
CONST
    wi = 25;
VAR
    i:CARDINAL;
BEGIN
    IF DEBUG THEN
        WrStr("// ");WrStr(varname);
        IF same(varcontent,"") = FALSE THEN
            FOR i:=Str.Length(varname)+1 TO wi DO WrStr(" ");END;
            WrStr(" = ");
            IF useLFN THEN WrStr(dquote);END;
            WrStr(varcontent);
            IF useLFN THEN WrStr(dquote);END;
        END;
        WrLn;
    END;
END dbg;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* //BUGJPI : Lib.SplitAllPath eats extension in directory part if path is fixed with a trailing "\" ! *)

PROCEDURE splitFileExt (VAR f,e:pathtype;S:pathtype):BOOLEAN;
VAR
    p:CARDINAL;
BEGIN
    p:=Str.RCharPos(S,dot);
    CASE p OF
    | 0 :
        RETURN FALSE; (* nonsense : extension without file ! *)
    | MAX(CARDINAL) :
        Str.Copy(f,S);
        Str.Copy(e,"");
    ELSE
        Str.Slice(f,S,0,p);
        Str.Copy(e,S);
        Str.Delete(e,0,p+1);
    END;
    RETURN TRUE;
END splitFileExt;

(* currdir is "\" or "\*\" *)

PROCEDURE fileBuildParent (VAR parentdir:pathtype; currdir:pathtype):BOOLEAN;
VAR
    p:CARDINAL;
BEGIN
    IF Str.Match(currdir,antislash) THEN RETURN FALSE; END;
    unfixDirectory(currdir);
    p:=Str.RCharPos(currdir,antislash);
    Str.Slice(parentdir,currdir,0,p+1); (* keep final "\" *)
    RETURN TRUE;
END fileBuildParent;

(* drive is never 0 i.e. default here  *)

PROCEDURE fileGetCurrdir (VAR sUnit:str2; VAR currdir:pathtype;
                         useLFN:BOOLEAN;drive:SHORTCARD);
VAR
    rc:CARDINAL;
    longform:pathtype;
BEGIN
    Str.Concat(sUnit, CHR( ORD("A")-1+ORD(drive) ),colon);

    FIO.GetDir(drive,currdir); (* "\path" without "u:" nor trailing "\" except at root *)
    IF currdir[1] # colon THEN Str.Prepend(currdir,sUnit); END; (* safety *)
    IF useLFN THEN
        IF w9XshortToLong(currdir,rc,longform) THEN (* if error, keep DOS current *)
            Str.Copy(currdir,longform);
        END;
    END;
    (* LFN function seems to always return "u:\*" form except at root *)
    IF currdir[1] = colon THEN Str.Delete(currdir,0,2);END; (* safety *)
    fixDirectory(currdir);
END fileGetCurrdir;

CONST
    rcNone            = 0;
    rcNetwork         = 1;
    rcColon           = 2;
    rcUnit            = 3;
    rcNoParent        = 4;
    rcEmpty           = 5;
    rcInnerParent     = 6;
    rcDirJoker        = 7;
    rcEntryIsFile     = 100; (* mere warning *)
    rcEntryNotFound   = 101; (* mere warning *)

PROCEDURE getErrcode (rc:CARDINAL  ):CARDINAL ;
VAR
    e:CARDINAL;
BEGIN
    CASE rc OF
    | rcNetwork       : e:=errNetwork;
    | rcColon         : e:=errColon;
    | rcUnit          : e:=errUnit;
    | rcNoParent      : e:=errNoParent;
    | rcEmpty         : e:=errEmpty;
    | rcInnerParent   : e:=errInnerParent;
    | rcDirJoker      : e:=errDirJoker;
    ELSE
                        e:=errNone;
    END;
    RETURN e;
END getErrcode;

(*
    remember dirs can have an extension, and LFNs can have inner dots
    we handle, whether u: or not

    *\\*                    network                     ok
    .                       current                     ok
    ..                      parent                      ok
    \                       root
    ""                      empty or u:                 ok

    .\xxx                   current\xxx   F/D           ok
    ..\xxx                  parent\xxx    F/D           ok

    xxx\                    current\xxx\                ok
    xxx\.                   current\xxx\                ok
    xxx\..                  parent                      ok
    xxx                     current\xxx   F/D           ok

    \xxx\                   \xxx\                       ok
    \xxx                    \xxx          F/D           ok

    *..*                    inner parent

*)

PROCEDURE fileFixSpec (VAR zebase,zespec:pathtype;
                      DEBUG,useLFN:BOOLEAN;
                      raw,defaultspec,defaultext:pathtype):CARDINAL;
VAR
    drive:SHORTCARD;
    rc,len,p:CARDINAL;
    u:CHAR;
    S:pathtype;
    currdir:pathtype; (* "\" or "\*\" *)
    parentdir:pathtype;
    sUnit:str2; (* "u:" *)
    okparent:BOOLEAN;
BEGIN
    Str.Copy(S,raw);

    IF Str.Pos(S,antislash+antislash) # MAX(CARDINAL) THEN RETURN rcNetwork;END;
    rc:=rcNone;
    (* process u: in S *)

    CASE CharCount(S,colon) OF
    | 0 :
        drive := FIO.GetDrive();
    | 1 :
        IF Str.CharPos(S,colon) = 1 THEN
            u:=CAP( S[0] );
            CASE u OF
            | "A".."Z" :
                drive := SHORTCARD( ORD(u) - ORD("A") +1 );
                Str.Delete(S,0,2); (* remove u: *)
            ELSE
                rc:=rcUnit;
            END;
        ELSE
            rc:=rcUnit;
        END;
    ELSE
        rc:=rcColon;
    END;
    IF rc # rcNone THEN RETURN rc; END;
    dbg(DEBUG,useLFN,"S without unit",S);

    IF same(S,"") THEN RETURN rcEmpty;END; (* should NEVER happen *)

    (* find current directory from (un)specified unit -- note S no longer has u: *)

    fileGetCurrdir(sUnit,currdir,  useLFN,drive); (* "u:" and "\" or "\*\" *)
    dbg(DEBUG,useLFN,"sUnit",sUnit);
    dbg(DEBUG,useLFN,"currdir",currdir);
    okparent:=fileBuildParent(parentdir, currdir);
    IF okparent THEN
    dbg(DEBUG,useLFN,"parentdir",parentdir);
    ELSE
    dbg(DEBUG,useLFN,"no parent !","");
    END;

    (* handle classic cases : "."  ".."  ".\*"  "..\*"  "*"  "*\."  "*\.." *)

    IF same(S,dot) THEN Str.Copy(S,currdir);END;
    dbg(DEBUG,useLFN,"S against .",S);

    IF same(S,dotdot) THEN
        IF NOT(okparent) THEN RETURN rcNoParent; END;
        Str.Copy(S,parentdir);
    END;
    dbg(DEBUG,useLFN,"S against ..",S);

    IF Str.Match(S,dot+antislash+star) THEN Str.Subst(S,dot+antislash,currdir); END;
    dbg(DEBUG,useLFN,"S against .\*",S);

    IF Str.Match(S,dotdot+antislash+star) THEN
        IF NOT(okparent) THEN RETURN rcNoParent; END;
        Str.Subst(S,dotdot+antislash,parentdir);
    END;
    dbg(DEBUG,useLFN,"S against ..\*",S);

    IF Str.Match(S,antislash+star)=FALSE THEN Str.Prepend(S,currdir);END;
    dbg(DEBUG,useLFN,"S against * not from root",S);

    IF Str.Match(S,star+antislash+dot) THEN
        (* S[Str.Length(S)-1]:=0C; *)
        len:=Str.Length(S);
        Str.Delete(S,len-1,1);
    END;
    dbg(DEBUG,useLFN,"S against *\.",S);

    IF Str.Match(S,star+antislash+dotdot) THEN
        IF NOT(okparent) THEN RETURN rcNoParent;END;
        Str.Copy(S,parentdir);
    END;
    dbg(DEBUG,useLFN,"S against *\..",S);

    (* we don't want inner or trailing ".." now *)
    IF Str.Pos(S,dotdot) # MAX(CARDINAL) THEN RETURN rcInnerParent;END;

    (* base = "u:\xxx\" and spec = "xxx" *)

    (* handle "*\" OR "* *)

    IF Str.Match(S,star+antislash) THEN
        Str.Concat(zebase,sUnit,S);
        Str.Copy(zespec,defaultspec);
        dbg(DEBUG,useLFN,"zebase1",zebase);
        dbg(DEBUG,useLFN,"zespec1",zespec);
        IF same(defaultext,"")=FALSE THEN
            IF Str.CharPos(zespec,dot)=MAX(CARDINAL) THEN Str.Append(zespec,defaultext);END;
        END;
        dbg(DEBUG,useLFN,"zeSPEC1",zespec);
        IF chkJoker(zebase) THEN RETURN rcDirJoker; END;
    ELSE
        Str.Prepend(S,sUnit);
        (* S is u:[\xxx]... without trailing "\" *)
        len:=Str.Length(S);
        p:=Str.RCharPos(S,antislash);
        Str.Slice(zebase,S,0,p+1);
        Str.Slice(zespec,S,p+1,len-p);
        dbg(DEBUG,useLFN,"zebase2",zebase);
        dbg(DEBUG,useLFN,"zespec2",zespec);
        IF same(defaultext,"")=FALSE THEN
            IF Str.CharPos(zespec,dot)=MAX(CARDINAL) THEN Str.Append(zespec,defaultext);END;
        END;
        dbg(DEBUG,useLFN,"zeSPEC2",zespec);
        IF chkJoker(zebase) THEN RETURN rcDirJoker; END;

        IF chkJoker(zespec)=FALSE THEN (* if spec has joker(s), assume files *)
            (* spec has no joker : dir or file ? *)
            IF fileIsDirectorySpec(useLFN,S) THEN
                Str.Copy(zebase,S);
                fixDirectory(zebase); (* safety *)
                Str.Copy(zespec,defaultspec);
            ELSE
                (* either entry not found, or found a file *)
                IF fileExists(useLFN,S) THEN
                    IF Str.RCharPos(zespec,dot)=MAX(CARDINAL) THEN
                        Str.Append(zespec,dot); (* file extension *)
                    END;
                    RETURN rcEntryIsFile;
                ELSE
                    RETURN rcEntryNotFound;
                END;
            END;
            dbg(DEBUG,useLFN,"zebase3",zebase);
            dbg(DEBUG,useLFN,"zespec3",zespec);
        END;
    END;
    RETURN rcNone; (* OR rc *)
END fileFixSpec;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    defaultpat = star+extDAT; (* "*"+".TX" or "" ? *)
    mincolumns = 1+1+1+1+1;
    noskip     = FALSE; (* no reason FOR this TO be TRUE here *)
VAR
    parmcount,i,opt   : CARDINAL;
    S,R               : pathtype;
    state             : (waiting,gotparm1);
VAR
    doFrame : CARDINAL;
    doWait,doBeautify,doList : BOOLEAN;
    DODUMP,DOSTEPS,CHKMEM : BOOLEAN;
    screenwidth,maxcolumns,LineWidth:CARDINAL;
    exedir,currdir,defaultdatafile,datafile:pathtype;
    rawfilespec,zebase,zespec: pathtype;
    savermode,stopmouse,atrandompos,docls:BOOLEAN;
    DEBUG,useLFN,glue,FRprompt,usemouse,fullclean:BOOLEAN;
    pause,alwayspause:CARDINAL;
    maxlenfilename,thislen,filecount:CARDINAL;
    anchor,ptr      : pFname;
    rc,lastpass:CARDINAL;
VAR
    v                 : LONGCARD;
    c1,c2             : CHAR;
    ink,paper,count   : CARDINAL;
    lastline,longest  : CARDINAL;
    hugestring        : strHUGE;  (* really huge sentence, just in case... *)
    redirected,chk               : BOOLEAN;
    keycode           : CARDINAL;
    mousebuttons:mousebuttonstype;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck:=FALSE;

    (* handleVesa; *) (* useless, because we won't change video mode *)
    setUseBiosMode ( IsRedirected() );
    findInkPaperAtStartup();
    colorhelp;

    redirected := IsRedirected();

    screenwidth:= getWindowWidth(); (* 80 no longer becomes 79 *)

    useLFN      := TRUE;
    DEBUG       := FALSE;
    LineWidth   := screenwidth;
    maxcolumns  := screenwidth;
    doFrame     := frameNone;
    doWait      := FALSE;
    doBeautify  := FALSE;
    ink         := ORD(progink);
    paper       := ORD(progpaper);
    count       := mincount;
    DODUMP      := FALSE;
    DOSTEPS     := FALSE;
    CHKMEM      := FALSE;
    savermode   := FALSE;
    pause       := defaultpause;
    alwayspause := defaultalwayspause;
    stopmouse   := FALSE;
    atrandompos := FALSE;
    docls       := TRUE ;
    glue        := FALSE;
    doList      := FALSE;
    FRprompt    := FALSE;
    fullclean   := FALSE;
    usemouse    := TRUE;

    state     := waiting;
    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S); cleantabs(R);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "F:"+delim+"FRAME:"+delim+
                                   "W"+delim+"WAIT"+delim+
                                   "N"+delim+"NEWLINE"+delim+"CR"+delim+"CRLF"+delim+
                                   "I:"+delim+"INK:"+delim+
                                   "P:"+delim+"PAPER:"+delim+
                                   "B"+delim+"BIOS"+delim+
                                   "W:"+delim+"WIDTH:"+delim+
                                   "N:"+delim+"COUNT:"+delim+
                                   "DUMP"+delim+
                                   "STEPS"+delim+
                                   "??"+delim+"HH"+delim+"FORMAT"+delim+
                                   "S"+delim+"SAVER"+delim+"SHOW"+delim+
                                   "S:"+delim+"PAUSE:"+delim+
                                   "Z"+delim+"MOUSECLICK"+delim+
                                   "R"+delim+"RANDOMPOS"+delim+
                                   "C"+delim+
                                   "CHKMEM"+delim+
                                   "M:"+delim+"MINIMUM:"+delim+
                                   "G"+delim+"GLUE"+delim+
                                   "L"+delim+"LIST"+delim+
                                   "M"+delim+"MOUSE"+delim+
                                   "WW"+delim+"WM"+delim+
                                   "P"+delim+
                                   "PP"+delim+
                                   "K"+delim+"CLEAN"+delim+
                                   "X"+delim+"LFN"+delim+
                                   "???"+delim+"HHH"+delim+
                                   "DEBUG"
                               );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5 :
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < minframe) OR (v > maxframe) ) THEN abort(errBadNumber,S); END;
                doFrame:=CARDINAL(v);
            | 6,7 :
                doWait  := TRUE;
            | 8,9,10,11:
                doBeautify  := TRUE;
            | 12,13:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolor) OR (v > maxcolor) ) THEN abort(errInkRange,"");END;
                ink:=CARDINAL(v);
            | 14,15:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolor) OR (v > maxcolor) ) THEN abort(errPaperRange,"");END;
                paper:=CARDINAL(v);
            | 16,17:
                setUseBiosMode ( TRUE );
            | 18,19:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolumns) OR (v > LONGCARD(maxcolumns)) ) THEN abort(errWidthRange,"");END;
                LineWidth:=CARDINAL(v);
            | 20,21:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincount) OR (v > maxcount) ) THEN abort(errCountRange,"");END;
                count:=CARDINAL(v);
            | 22: DODUMP:=TRUE;
            | 23: DOSTEPS:=TRUE;
            | 24,25,26:
                abort(errVerboseHelp,"");
            | 27,28,29:
                savermode:=TRUE;
            | 30,31:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < minpause) OR (v > maxpause) ) THEN abort(errPauseRange,"");END;
                pause:=CARDINAL(v);
            | 32,33:
                stopmouse := TRUE;
            | 34,35:
                atrandompos:=TRUE;
            | 36:
                docls := FALSE;
            | 37:
                CHKMEM:=TRUE;
            | 38,39:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < minpause) OR (v > maxpause) ) THEN abort(errPauseRange,"");END;
                alwayspause:=CARDINAL(v);
            | 40,41:
                glue:=TRUE;
            | 42,43:
                doList:=TRUE;
            | 44,45:
                usemouse:=FALSE;
            | 46,47:
                doWait:=TRUE; usemouse:=FALSE;
            | 48:
                doWait:=TRUE;                  FRprompt:=TRUE;
            | 49:
                doWait:=TRUE; usemouse:=FALSE; FRprompt:=TRUE;
            | 50,51:
                fullclean := TRUE;
            | 52,53:
                useLFN:=FALSE;
            | 54,55:
                abort(errVerboserHelp,"");
            | 56:
                DEBUG := TRUE;
            ELSE
                abort(errOption,S);
            END;
        ELSE
            CASE state OF
            | waiting :
                (*
                IF same(R,"?") THEN abort(errHelp,""); END;
                IF same(R,"??") THEN abort(errVerboseHelp,"");END;
                *)
                Str.Copy(rawfilespec,S); (* keep org case *)
            | gotparm1 :
                abort(errParameter,S);
            END;
            INC(state);
        END;
    END;

    useLFN := ( useLFN AND fileSupportLFN() );
    initDefaultFilenames(exedir,currdir,defaultdatafile, extDAT);

    dbg(DEBUG,useLFN,"exedir",exedir);
    dbg(DEBUG,useLFN,"currdir",currdir);
    dbg(DEBUG,useLFN,"defaultdatafile",defaultdatafile);

    IF state = waiting THEN
        IF doList THEN
            rawfilespec:=star;
        ELSE
            rawfilespec:=defaultdatafile;
        END;
    END;
    dbg(DEBUG,useLFN,"rawfilespec 1",rawfilespec);

    rc:=fileFixSpec(zebase,zespec,DEBUG,useLFN,rawfilespec,defaultpat,extDAT);
    dbg(DEBUG,useLFN,"ZEbase",zebase);
    dbg(DEBUG,useLFN,"ZEspec",zespec);
    rc:=getErrcode(rc);
    IF rc # errNone THEN abort(rc,rawfilespec);END;

    IF Str.CharPos(rawfilespec,antislash)=MAX(CARDINAL) THEN (* filename without path *)
        IF Str.Match(currdir,exedir) THEN (* case-insensitive *)
            lastpass:=1;
        ELSE
            lastpass:=2; (* we'll try exe dir *)
        END;
    ELSE
        lastpass:=1;
    END;

    initList(anchor);
    i:=1;
    LOOP
        CASE i OF
        | 1:
            IF DEBUG THEN WrStr("// step1"+nl);END;
        | 2:
            IF DEBUG THEN WrStr("// step2"+nl);END;
            freeList(anchor);
            initList(anchor);
            Str.Copy(zebase,exedir); (* try exe dir as base now *)
        END;
        Str.Concat(datafile,zebase,zespec);
        dbg(DEBUG,useLFN,"full datafile",datafile);

        filecount := buildFileList(anchor,noskip,useLFN,DEBUG,datafile);
        CASE filecount OF
        | 0 :
            IF i = lastpass THEN abort(errNotFound,datafile); END;
        | 1:
            getStr(zespec,anchor);
            Str.Concat(datafile,zebase,zespec);
            dbg(DEBUG,useLFN,"single file",datafile);
            EXIT;
        | MAX(CARDINAL) :
            abort(errTooManyFiles,datafile);
        ELSE
            IF doList THEN
                EXIT;
            ELSE
                abort(errOnlyForList,datafile);
            END;
        END;
        INC(i);
        IF i > lastpass THEN EXIT; END;
    END;

    (* handle -list command *)

    IF doList THEN
        WrLn;
        WrStr(sBase+sepabout);
        IF useLFN THEN WrStr(dquote);END;
        WrStr(zebase);
        IF useLFN THEN WrStr(dquote);END;
        WrLn;

        WrLn;
        maxlenfilename:=0;
        FOR i:=1 TO 2 DO
            ptr:=anchor;
            WHILE ptr # NIL DO
                getStr(datafile,ptr);
                CASE i OF
                | 1 :
                    thislen:=Str.Length(datafile);
                    IF thislen > maxlenfilename THEN maxlenfilename:=thislen;END;
                | 2 :
                    showtitle (maxlenfilename,LineWidth,
                              redirected,useLFN,DEBUG,zebase,datafile);
                END;
                ptr:=ptr^.next;
            END;
        END;
        freeList(anchor);

        abort(errNone,"");
    END;

    (* -list command has been handled : handle single file *)

    getStr(zespec,anchor);
    Str.Concat(datafile,zebase,zespec);

    IF CHKMEM THEN showmem; END;
    IF readScript(DODUMP,useLFN,datafile)=FALSE THEN abort(errLoading,datafile); END; (* was errMALLOC *)
    IF CHKMEM THEN showmem; END;
    IF DODUMP THEN dumpall(); END;

    InitRnd();

    CASE savermode OF
    | FALSE:
        IF atrandompos THEN
            abort(errNotInNormalMode,"-r option is a nonsense without -s option !");
        END;
        IF stopmouse THEN
            abort(errNotInNormalMode,"-z option is a nonsense without -s option !");
        END;
        IF count = mincount THEN glue:=FALSE;END;
        IF glue THEN WrLn;END;
        FOR i := mincount TO count DO
            colortext( ink,paper );
            IF getSentence(DOSTEPS,hugestring)=FALSE THEN
                abort(errFormat,hugestring);
            END;
            IF formatSentence(LineWidth,doFrame,fullclean,lastline,longest,hugestring)=FALSE THEN
                abort(errSentenceTooBig,"");
            END;
            dmpSentence(screenwidth,LineWidth,doFrame,redirected,doBeautify,glue,lastline,longest);
            colorhelp;
            IF doWait THEN
                IF usemouse THEN usemouse:=MouseDriverHere();END;
                IF usemouse THEN
                    IF FRprompt THEN
                        S:=msgWaitMouseFR;
                    ELSE
                        S:=msgWaitMouse;
                    END;
                ELSE
                    IF FRprompt THEN
                        S:=msgWaitFR;
                    ELSE
                        S:=msgWait;
                    END;
                END;
                video(S,TRUE);
                (* BiosWaitkey(c1,c2); *)
                LOOP
                    IF usemouse THEN
                        IF mouseclick() THEN EXIT; END;
                    END;
                    IF getKeyboardCode(keycode) THEN EXIT; END;
                END;
                video(S,FALSE);
            END;
        END;
    | TRUE:
        IF redirected THEN
             abort(errNotInSaverMode,"Redirection is a nonsense in screensaver mode !");
        END;
        flushKeyboard;
        setCursorShape(invisiblecursor);
        IF stopmouse THEN stopmouse:=MouseDriverHere();END;
        LOOP
            colorhelp;
            cls;
            colortext( ink,paper );
            (* here, ignore all errors *)
            IF getSentence(DOSTEPS,hugestring) THEN
                IF formatSentence(LineWidth,doFrame,fullclean,lastline,longest,hugestring) THEN
                    dmpSentenceAt (doFrame,lastline,longest,
                                  alwayspause,pause,atrandompos,stopmouse);
                END;
            END;
            chk:=getKeyboardCode(keycode);
            IF chk THEN
                CASE keycode OF
                | keyEscape     : EXIT;
                (* | keyCR         : EXIT; *)
                END;
            END;
            IF stopmouse THEN
                (* IF mouseclick() THEN EXIT; END; *)
                mousebuttons:=getLastPressed();
                IF (rightbutton IN mousebuttons) THEN EXIT; END;
            END;
        END;
        colorhelp;
        IF docls THEN cls; ELSE WrLn; END;
        setCursorShape(oldcursor);
    END;

    (* useless but good practice *)

    IF  CHKMEM THEN showmem; END;
    freeall();
    IF CHKMEM THEN showmem; END;

    abort(errNone,"");
END TextGen.

