(* --------------------------------------------------------------
Title         Q&D Vectors
Author        PhG
Overview      tsk tsk...
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
              could be the base of yet another clock...
Bugs

Wish List     tsk tsk...

--------------------------------------------------------------- *)

MODULE Vectors;

IMPORT Str;
IMPORT Lib;
IMPORT MsMouse;
IMPORT SYSTEM;
IMPORT BiosIO;
IMPORT MATHLIB;

FROM IO IMPORT WrStr,WrLn,WrCard;

FROM QD_ASCII IMPORT dash, slash, nullchar, tabchar, cr, lf, nl, bs,
space, dot, deg, doublequote, quote, colon, percent, vbar,
blank, equal, dquote, charnull, singlequote, antislash, dollar,
star, backslash, coma, question, underscore, tabul, hbar,
comma, semicolon, diese, pound, openbracket, closebracket, tilde, exclam,
stardotstar, dotdot, escCh, escSet, letters, digits,
lettersUpp, lettersLow, openbrace, closebrace;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits, metaproc, getCli, argc, argv;

FROM ModeX IMPORT Mode_320x200,Mode_320x400,Mode_360x200,Mode_360x400,
Mode_320x240,Mode_320x480,Mode_360x240,Mode_360x480,
SET_VGA_MODEX, SET_MODEX, CLEAR_VGA_SCREEN, SET_POINT, READ_POINT,
FILL_BLOCK, DRAW_LINE, SET_DAC_REGISTER, GET_DAC_REGISTER,
LOAD_DAC_REGISTERS, READ_DAC_REGISTERS,
SET_ACTIVE_PAGE, GET_ACTIVE_PAGE, SET_DISPLAY_PAGE, GET_DISPLAY_PAGE,
SET_WINDOW, GET_X_OFFSET, GET_Y_OFFSET, SYNC_DISPLAY,
GPRINTC, TGPRINTC, PRINT_STR, TPRINT_STR,
SET_DISPLAY_FONT, DRAW_BITMAP, TDRAW_BITMAP, COPY_PAGE, COPY_BITMAP,
mxTrue, mxFalse, mxnil,
c_BLACK, c_BLUE, c_GREEN, c_CYAN, c_RED, c_PURPLE, c_BROWN, c_WHITE,
c_GREY, c_bBLUE, c_bGREEN, c_bCYAN, c_bRED, c_bPURPLE, c_YELLOW, c_bWHITE,
c_BRIGHT,
Ky_F1, Ky_F2, Ky_F3, Ky_F4, Ky_F5, Ky_F6, Ky_F7, Ky_F8, Ky_F9, Ky_F10,
Ky_Up, Ky_Left, Ky_Right, Ky_Down,
Ky_SUp, Ky_SLeft, Ky_SRight, Ky_SDown,
Ky_Home, Ky_End, Ky_PgUp, Ky_PgDn,
Ky_SHome, Ky_SEnd, Ky_SPgUp, Ky_SPgDn,
Ky_Ins, Ky_Del, Ky_SIns, Ky_SDel, Ky_Tab, Ky_RvsTab, Ky_STab,
Ky_BS, Ky_CR, Ky_ESC, Ky_Clr, Ky_Plus, Ky_Minus,
Ky_AltA, Ky_AltB, Ky_AltC, Ky_AltD, Ky_AltE, Ky_AltF, Ky_AltG,
Ky_AltH, Ky_AltI, Ky_AltJ, Ky_AltK, Ky_AltL, Ky_AltM, Ky_AltN,
Ky_AltO, Ky_AltP, Ky_AltQ, Ky_AltR, Ky_AltS, Ky_AltT, Ky_AltU,
Ky_AltV, Ky_AltW, Ky_AltX, Ky_AltY, Ky_AltZ,
DOS_PRINT, DOS_PRINTS, SET_VIDEO_MODE,
SCAN_KEYBOARD, RANDOM_INT, INIT_RANDOM, INT_SQR, TIMER_COUNT;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "VECTORS";
    ProgTitle     = "Q&D Vectors demo";
    ProgVersion   = "v1.0b";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
    credit        = "(public domain Mode X v1.04 library by Matt Pritchard)";

CONST
    errNone           = 0;
    errHelp           = 1;
    errIllegalParm    = 2;
    errUnknownOpt     = 3;
    errRange          = 4;
    errCannotSetModeX = 5;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    (*
     00000000011111111112222222222333333333344444444445555555555666666666677777777778
     1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
    *)
    helpmsg =
    Banner+nl+
    nl+
    credit+nl+
    nl+
    "Syntax : "+ProgEXEname+" [option]..."+nl+
    nl+
    "  -k    end on keypress only"+nl+
    "  -o:#  object ([0..14], default is 0)"+nl+
    "  -p:#  palette ([0..5], default is 0)"+nl+
    "  -f    flat 2D dots"+nl+
    nl+
    "[P][+]-next palette  [O][PgDn]-next object  [F]-flat 2D  [Space]-single step"+nl+
    "[Escape|Enter]-exit"+nl+
    nl+
    "This code, although greatly cleaned, rewritten and enhanced, was based upon"+nl+
    "very rough QuickBASIC code (VBOB1.BAS) found in an old Simtel SWAG archive."+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errIllegalParm :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," parameter !");
    | errUnknownOpt :
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errRange :
        Str.Concat(S,"Value for ",einfo);
        Str.Append(S," not in legal range !");
    | errCannotSetModeX:
        Str.Concat(S,"Cannot set required ",einfo);
        Str.Append(S," video mode X !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        (* nada *)
    ELSE
        WrStr(ProgEXEname+" : ");
        WrStr(S);
        WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    xmin         = 0;
    ymin         = 0;
    PagesVirtual = 2;
    page1        = 0;
    page2        = 1;
VAR
    sMode        : str16;
    hires        : CARDINAL;
    screenwidth  : CARDINAL;
    screenheight : CARDINAL;
    xmax         : CARDINAL;
    ymax         : CARDINAL;
    xMaxVirtual  : CARDINAL;
    yMaxVirtual  : CARDINAL;
    cx,cy        : INTEGER;
    (* to avoid casts *)
    iscreenwidth  : INTEGER;
    iscreenheight : INTEGER;
    ixmax         : INTEGER;
    iymax         : INTEGER;
    viewpage, workpage : CARDINAL;

PROCEDURE initHires (lores:BOOLEAN ); (* lores is happily ignored *)
BEGIN

        Str.Copy(sMode,"320x240x256");
        hires        := Mode_320x240;
        screenwidth  := 320;
        screenheight := 240;

    xmax        := screenwidth  -1;
    ymax        := screenheight -1;
    xMaxVirtual := screenwidth;
    yMaxVirtual := screenheight;
    cx          := INTEGER(xmax DIV 2);
    cy          := INTEGER(ymax DIV 2);
    (* to avoid casts *)
    iscreenwidth  := INTEGER(screenwidth);
    iscreenheight := INTEGER(screenheight);
    ixmax         := INTEGER(xmax);
    iymax         := INTEGER(ymax);
    viewpage      := page1;
    workpage      := page2;
END initHires;

PROCEDURE HiresON ():BOOLEAN;
BEGIN
    RETURN (SET_VGA_MODEX(hires,xMaxVirtual,yMaxVirtual,PagesVirtual) # 0);
END HiresON;

PROCEDURE HiresOFF ();
CONST
    biostxtmode = 3;
BEGIN
    SET_VIDEO_MODE(biostxtmode);
END HiresOFF;

PROCEDURE WaitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END WaitVGAretrace;

PROCEDURE clearPage(paperindex:CARDINAL);
BEGIN
    CLEAR_VGA_SCREEN(paperindex);
END clearPage;

PROCEDURE setviewwork (view,work:CARDINAL );
BEGIN
    SET_DISPLAY_PAGE(view);
    SET_ACTIVE_PAGE(work);
END setviewwork;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ndxinkmin   = 0; (* 0 is reserved as black *)
    ndxinkmax   = 256-1;
    ndxinkblack = ndxinkmin;
    colorrange  = 64;
CONST
    black       = LONGCARD(0000000H);
    white       = LONGCARD(03F3F3FH); (* ega/vga range is $00..$3F *)
    blue        = LONGCARD(000003FH);
    darkblue    = LONGCARD(0000020H);
    red         = LONGCARD(03F0000H);
    darkred     = LONGCARD(0200000H);
    green       = LONGCARD(0003F00H);
    darkgreen   = LONGCARD(0002000H);
    yellow      = LONGCARD(03F3F00H);
    orange      = LONGCARD(02F2F00H);
    cyan        = LONGCARD(0002F3FH);

PROCEDURE setDAC(index:CARDINAL;red,green,blue:BYTE);
CONST
    DACWriteIndex  = 03C8H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACWriteIndex,SHORTCARD(index));
    SYSTEM.Out (DACDataRegister, red);
    SYSTEM.Out (DACDataRegister, green);
    SYSTEM.Out (DACDataRegister, blue);
END setDAC;

PROCEDURE blend (ndx,count:CARDINAL; startink, endink:LONGCARD);
CONST
    egarange = 40H;  (* EGA/VGA is limited to $00..$3F *)
    rshift   = LONGCARD(16);
    gshift   = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    i : CARDINAL;
BEGIN
    r1 := INTEGER (startink >> rshift) MOD egarange;
    g1 := INTEGER (startink >> gshift) MOD egarange;
    b1 := INTEGER (startink          ) MOD egarange;
    r2 := INTEGER (endink   >> rshift) MOD egarange;
    g2 := INTEGER (endink   >> gshift) MOD egarange;
    b2 := INTEGER (endink            ) MOD egarange;

    FOR i := 1 TO count DO
        r := r1 + ((r2 - r1) * INTEGER(i) ) DIV INTEGER(count);
        g := g1 + ((g2 - g1) * INTEGER(i) ) DIV INTEGER(count);
        b := b1 + ((b2 - b1) * INTEGER(i) ) DIV INTEGER(count);
        IF r < 0 THEN r:=0; END;
        IF g < 0 THEN g:=0; END;
        IF b < 0 THEN b:=0; END;
        IF r > egarange-1 THEN r:=egarange-1; END;
        IF g > egarange-1 THEN g:=egarange-1; END;
        IF b > egarange-1 THEN b:=egarange-1; END;
        setDAC(ndx+i-1,BYTE(r),BYTE(g),BYTE(b));
    END;
END blend;

TYPE
    paltype = (rpal,gpal,bpal,rrpal,ggpal,bbpal);
CONST
    minpal       = ORD(rpal);
    maxpal       = ORD(bbpal);
    defaultpal   = minpal;

PROCEDURE MakePalette (pal:paltype);
VAR
    ndx : CARDINAL;
    n   : CARDINAL;
    c1,c2,c3:LONGCARD;
BEGIN
    WaitVGAretrace;
    CASE pal OF
    | rpal:  c2 := red;
    | gpal:  c2 := green;
    | bpal:  c2 := blue;
    | rrpal: c2 := darkred;
    | ggpal: c2 := darkgreen;
    | bbpal: c2 := darkblue;
    END;
    c1 := black;
    c3 := white;
    ndx := 0;              n := 8;
    blend (ndx,n,c1,c2);
    INC(ndx,n);            n := 8;
    blend (ndx,n,c2,c3);
    setDAC(ndxinkblack, 00H,00H,00H); (* reset black *)
END MakePalette;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE doRandomize (  );
BEGIN
    Lib.RANDOMIZE;
END doRandomize;

PROCEDURE getrndrange (lower,upper:CARDINAL):CARDINAL;
VAR
    range : CARDINAL;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN CARDINAL(rnd);
END getrndrange;

PROCEDURE getrndrangeint (lower,upper:INTEGER):INTEGER;
VAR
    range : INTEGER;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN INTEGER(rnd);
END getrndrangeint;

(* ------------------------------------------------------------ *)

PROCEDURE value (S:ARRAY OF CHAR;min,max:CARDINAL;VAR r:CARDINAL):BOOLEAN;
VAR
    v : LONGCARD;
BEGIN
    IF GetLongCard(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGCARD(min) THEN RETURN FALSE; END;
    IF v > LONGCARD(max) THEN RETURN FALSE; END;
    r := CARDINAL(v);
    RETURN TRUE;
END value;

PROCEDURE ivalue (S:ARRAY OF CHAR;min,max:INTEGER;VAR r:INTEGER):BOOLEAN;
VAR
    v : LONGINT;
BEGIN
    IF GetLongInt(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGINT(min) THEN RETURN FALSE; END;
    IF v > LONGINT(max) THEN RETURN FALSE; END;
    r := INTEGER(v);
    RETURN TRUE;
END ivalue;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    minalpha = 0;
    maxalpha = 360-1;
VAR
    deg2rad : LONGREAL;
    sinval  : ARRAY[minalpha..maxalpha] OF LONGREAL;
    cosval  : ARRAY[minalpha..maxalpha] OF LONGREAL;

PROCEDURE initTrigo (  );
VAR
    alpha  : CARDINAL;
    sinus,cosinus,lr : LONGREAL;
BEGIN
    deg2rad := 4.0 * MATHLIB.ATan(1.0) / 180.0; (* pi/180 *)
    FOR alpha := minalpha TO maxalpha DO
        lr := LONGREAL(alpha) * deg2rad;
        sinus   := MATHLIB.Sin( lr );
        cosinus := MATHLIB.Cos( lr );
        sinval[alpha] := sinus;
        cosval[alpha] := cosinus;
    END;
END initTrigo;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* note we retrieve 0..16 value from a..b *)

PROCEDURE getDotColor (ch:CHAR):BYTE ;
VAR
    v:CARDINAL;
BEGIN
    CASE ch OF
    | "." : v := mxnil;
    | " " : v := c_BLACK;
    | "a" : v := c_BLUE;
    | "b" : v := c_GREEN;
    | "c" : v := c_CYAN;
    | "d" : v := c_RED;
    | "e" : v := c_PURPLE;
    | "f" : v := c_BROWN;
    | "g" : v := c_WHITE;
    | "h" : v := c_GREY;
    | "i" : v := c_bBLUE;
    | "j" : v := c_bGREEN;
    | "k" : v := c_bCYAN;
    | "l" : v := c_bRED;
    | "m" : v := c_bPURPLE;
    | "n" : v := c_YELLOW;
    | "o" : v := c_bWHITE;
    | "p" : v := c_BRIGHT;
    ELSE
            v := mxnil;
    END;
    RETURN BYTE(v);
END getDotColor;

(* all sprites MUST be 16x16 here ! *)

CONST
    spriteWidth  = 16;
    spriteHeight = 16;

    firstsprite  = 0;   (* eraser, index MUST be 0 *)
    lastsprite   = 6;   (* 1..6 = from small to normal *)

CONST
    datasprites =
    (* 0 *)
"................"+
"................"+
"................"+
"................"+
"................"+
"................"+
"................"+
"................"+
"................"+
"................"+
"................"+
"................"+
"................"+
"................"+
"................"+
"................"+
    (* 1 *)
"................"+
"................"+
"................"+
"................"+
"................"+
"................"+
"......cffc......"+
"......fnff......"+
"......ffff......"+
"......cffc......"+
"................"+
"................"+
"................"+
"................"+
"................"+
"................"+
    (* 2 *)
"................"+
"................"+
"................"+
"................"+
"................"+
"......dffd......"+
".....dljffd....."+
".....fjffff....."+
".....ffffee....."+
".....dffedd....."+
"......dfed......"+
"................"+
"................"+
"................"+
"................"+
"................"+
    (* 3 *)
"................"+
"................"+
"................"+
"................"+
".....bdffdb....."+
"....bejhffeb...."+
"....djkgfffd...."+
"....fhggfffe...."+
"....fffffffe...."+
"....dfffffed...."+
"....befffeeb...."+
".....bdeedb....."+
"................"+
"................"+
"................"+
"................"+
    (* 4 *)
"................"+
"................"+
"................"+
".....cdffdc....."+
"....cfnnfffc...."+
"...cfmkfffffc..."+
"...dnkffffffd..."+
"...fnfffffffe..."+
"...ffffffffee..."+
"...dffffffeed..."+
"...cffffffeec..."+
"....cfffeeec...."+
".....cdeedc....."+
"................"+
"................"+
"................"+
    (* 5 *)
"................"+
"................"+
".....bdffdb....."+
"....dknniffd...."+
"...dmmkiffffd..."+
"..bkmkiffffffb.."+
"..dnkiffffffee.."+
"..fnifffffffee.."+
"..fifffffffeee.."+
"..dffffffffeed.."+
"..bfffffffeeeb.."+
"...dffffeeeed..."+
"....deeeeeed...."+
".....bdeedb....."+
"................"+
"................"+
    (* 6 *)
"................"+
"....bdeffedb...."+
"...dnnniiiffd..."+
"..dnkknnnhhffd.."+
".bfkmmknhhffffb."+
".dnkmkknffffffd."+
".ennkknffffffee."+
".finnnfffffffee."+
".finhfffffffeee."+
".eihhfffffffeee."+
".dfhfffffffeeed."+
".bfffffffeeeeeb."+
"..dfffeeeeeeed.."+
"...deeeeeeeed..."+
"....bdeeeedb...."+
"................";

TYPE
    dotstype   = ARRAY [0..spriteWidth*spriteHeight-1] OF BYTE;
    spritetype = RECORD
        width  : INTEGER;
        height : INTEGER;
        dots   : dotstype;
    END;

VAR
    sprite : ARRAY [firstsprite..lastsprite] OF spritetype;

PROCEDURE initSprites (  );
VAR
    i     : CARDINAL;
    tmp   : dotstype;
    x,y   : CARDINAL;
    psource,ptarget : CARDINAL;
    ch       : CHAR;
    dotcolor : BYTE;
BEGIN
    FOR i := firstsprite TO lastsprite DO
        psource := i * (spriteWidth*spriteHeight) ;
        ptarget := 0;
        FOR y := 1 TO spriteHeight DO
            FOR x := 1 TO spriteWidth DO
                ch := datasprites[psource];
                dotcolor := getDotColor(ch);
                tmp[ptarget]:=dotcolor;
                INC(psource);
                INC(ptarget);
            END;
        END;

        sprite[i].width := spriteWidth;
        sprite[i].height:= spriteHeight;

        Lib.Move (ADR(tmp),ADR(sprite[i].dots),SIZE(dotstype)); (* not str copy ! *)
    END;
END initSprites;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstpoint = 1;
    maxpoint   = 500; (* should be enough *)

    ViewDist   = 250; (* viewing distance *)
    DistCorr   = 30;  (* height/width distortion correction *)

TYPE
    vectortype = RECORD
        x,y,z:INTEGER;
    END;
    vectorarraytype = ARRAY [firstpoint..maxpoint] OF vectortype;

VAR
    lastpoint   : CARDINAL; (* number of points in the object *)
    translation : vectortype; (* trx,try,trz *)
    world,        (* px,py,pz    i.e. world coordinates *)
    rotation,     (* yaw,pit,rol i.e. point rotations *)
    screen        (* nx,ny,nz    i.e. screen coordinates  *)
                : vectorarraytype;

TYPE
    objtype = (cube,plan,diamond,gon,skull,
               shark,me262,ju287,basetop,base,tower,frigate,jet,mothership,
               point);

CONST
    minobj       = ORD(cube);
    maxobj       = ORD(point);
    defaultobj   = minobj;

PROCEDURE vec (x,y,z:INTEGER);
BEGIN
    world[lastpoint].x := x; (* px *)
    world[lastpoint].y := y; (* py *)
    world[lastpoint].z := z; (* p *)
    IF lastpoint < maxpoint THEN INC(lastpoint); END;
END vec;

PROCEDURE floatvec (k,x,y,z:REAL);
BEGIN
    world[lastpoint].x := INTEGER(k*x); (* px *)
    world[lastpoint].y := INTEGER(k*y); (* py *)
    world[lastpoint].z := INTEGER(k*z); (* p *)
    IF lastpoint < maxpoint THEN INC(lastpoint); END;
END floatvec;

PROCEDURE intvec (k:REAL;x,y,z:INTEGER);
BEGIN
    world[lastpoint].x := INTEGER(k* REAL(x)); (* px *)
    world[lastpoint].y := INTEGER(k* REAL(y)); (* py *)
    world[lastpoint].z := INTEGER(k* REAL(z)); (* p *)
    IF lastpoint < maxpoint THEN INC(lastpoint); END;
END intvec;

PROCEDURE floatvectortype (k,x,y,z:REAL):vectortype;
VAR
    r : vectortype;
BEGIN
    r.x := INTEGER(k*x);
    r.y := INTEGER(k*y);
    r.z := INTEGER(k*z);
    RETURN r;
END floatvectortype;

(* ------------------------------------------------------------ *)

PROCEDURE plusTower (k:REAL);
BEGIN
        intvec(k,0,0,0);
        intvec(k,0,0,336);
        intvec(k,0,50,336);
        intvec(k,0,160,225);
        intvec(k,0,400,150);
        intvec(k,0,1775,150);
        intvec(k,0,2075,225);
        intvec(k,0,2125,320);
        intvec(k,0,2175,320);
        intvec(k,235,0,235);
        intvec(k,235,50,235);
        intvec(k,159,160,159);
        intvec(k,106,400,106);
        intvec(k,106,1775,106);
        intvec(k,159,2075,159);
        intvec(k,231,2125,224);
        intvec(k,231,2175,224);
        intvec(k,336,0,0);
        intvec(k,336,50,0);
        intvec(k,225,160,0);
        intvec(k,150,400,0);
        intvec(k,150,1775,0);
        intvec(k,225,2075,0);
        intvec(k,330,2125,0);
        intvec(k,330,2175,0);
        intvec(k,235,0,-238);
        intvec(k,235,50,-238);
        intvec(k,159,160,-160);
        intvec(k,106,400,-107);
        intvec(k,106,1775,-107);
        intvec(k,159,2075,-160);
        intvec(k,231,2125,-227);
        intvec(k,231,2175,-227);
        intvec(k,0,0,-336);
        intvec(k,0,50,-336);
        intvec(k,0,160,-225);
        intvec(k,0,400,-150);
        intvec(k,0,1775,-150);
        intvec(k,0,2075,-225);
        intvec(k,0,2125,-320);
        intvec(k,0,2175,-320);
        intvec(k,-238,0,-238);
        intvec(k,-238,50,-238);
        intvec(k,-160,160,-160);
        intvec(k,-107,400,-107);
        intvec(k,-107,1775,-107);
        intvec(k,-160,2075,-160);
        intvec(k,-234,2125,-227);
        intvec(k,-234,2175,-227);
        intvec(k,-336,0,0);
        intvec(k,-336,50,0);
        intvec(k,-225,160,0);
        intvec(k,-150,400,0);
        intvec(k,-150,1775,0);
        intvec(k,-225,2075,0);
        intvec(k,-330,2125,0);
        intvec(k,-330,2175,0);
        intvec(k,-238,0,235);
        intvec(k,-238,50,235);
        intvec(k,-160,160,159);
        intvec(k,-107,400,106);
        intvec(k,-107,1775,106);
        intvec(k,-160,2075,159);
        intvec(k,-234,2125,224);
        intvec(k,-234,2175,224);
END plusTower;

PROCEDURE plusShark (k:REAL   );
BEGIN
        intvec(k,173, 33, 50);
        intvec(k,163, 18, 19);
        intvec(k,126, 21, 22);
        intvec(k,126, -19, 22);
        intvec(k,163, -16, 19);
        intvec(k,173, -31, 50);
        intvec(k,-76, 35, 12);
        intvec(k,-28, 35, 12);
        intvec(k,-26, 81, 58);
        intvec(k,2, 88, 65);
        intvec(k,2, -85, 65);
        intvec(k,-26, -77, 58);
        intvec(k,-28, -31, 12);
        intvec(k,-76, -31, 12);
        intvec(k,330, 1, 46);
        intvec(k,286, 1, 9);
        intvec(k,362, 1, 54);
        intvec(k,378, 1, -96);
        intvec(k,280, 1, -9);
        intvec(k,428, 1, -111);
        intvec(k,57, 0, -36);
        intvec(k,-17, 0, -36);
        intvec(k,29, 0, -85);
        intvec(k,69, 0, -100);
        intvec(k,-159, 28, -12);
        intvec(k,-170, 27, -12);
        intvec(k,-174, 24, -17);
        intvec(k,-163, 26, -17);
        intvec(k,-218, 19, -26);
        intvec(k,-203, 27, 8);
        intvec(k,-203, -24, 8);
        intvec(k,-218, -16, -26);
        intvec(k,-280, 2, -16);
        intvec(k,-163, -21, -17);
        intvec(k,-174, -19, -17);
        intvec(k,-170, -22, -12);
        intvec(k,-159, -23, -12);
        intvec(k,189, 2, -45);
        intvec(k,184, 2, -21);
        intvec(k,147, 2, -26);
        intvec(k,-176, -15, 21);
        intvec(k,-176, 18, 21);
        intvec(k,73, 35, 15);
        intvec(k,70, 14, -35);
        intvec(k,70, -11, -35);
        intvec(k,72, -31, 15);
        intvec(k,72, -11, 37);
        intvec(k,72, 14, 37);
        intvec(k,-120, 17, 38);
        intvec(k,-120, -13, 38);
        intvec(k,-127, -31, 10);
        intvec(k,-143, -13, -32);
        intvec(k,-145, 17, -32);
        intvec(k,-127, 35, 10);
        intvec(k,345, 1, 0);
END plusShark;

PROCEDURE plusMe262 ( k:REAL  );
BEGIN
        intvec(k,-291,-18,-2);
        intvec(k,-291,-29,25);
        intvec(k,-112,-65,42);
        intvec(k,-95,-41,-18);
        intvec(k,348,-8,3);
        intvec(k,-74,-26,-29);
        intvec(k,-291,-11,-13);
        intvec(k,342,-8,-111);
        intvec(k,304,-8,-111);
        intvec(k,63,-26,-29);
        intvec(k,193,-8,-25);
        intvec(k,-113,-17,-35);
        intvec(k,-332,-13,14);
        intvec(k,-332,-13,2);
        intvec(k,65,-65,42);
        intvec(k,65,-42,-13);
        intvec(k,65,29,-13);
        intvec(k,65,52,42);
        intvec(k,-332,0,2);
        intvec(k,-332,0,14);
        intvec(k,-113,4,-35);
        intvec(k,63,13,-29);
        intvec(k,-291,-2,-13);
        intvec(k,-74,13,-29);
        intvec(k,-95,28,-18);
        intvec(k,-112,52,42);
        intvec(k,-291,15,25);
        intvec(k,-291,5,-2);
        intvec(k,-82,-17,-53);
        intvec(k,-82,3,-53);
        intvec(k,63,3,-49);
        intvec(k,63,-17,-49);
        intvec(k,52,-146,35);
        intvec(k,97,-406,17);
        intvec(k,142,-395,17);
        intvec(k,244,-9,-47);
        intvec(k,338,-9,-47);
        intvec(k,297,-130,-47);
        intvec(k,332,-130,-47);
        intvec(k,332,114,-47);
        intvec(k,297,114,-47);
        intvec(k,338,-7,-47);
        intvec(k,244,-7,-47);
        intvec(k,142,380,17);
        intvec(k,97,390,17);
        intvec(k,52,130,35);
        intvec(k,83,-8,-45);
        intvec(k,92,-8,-43);
        intvec(k,104,-8,-94);
        intvec(k,-183,-149,38);
        intvec(k,-183,-194,34);
        intvec(k,90,-194,34);
        intvec(k,90,-149,38);
        intvec(k,90,-154,89);
        intvec(k,90,-199,85);
        intvec(k,-183,-199,85);
        intvec(k,-183,-154,89);
        intvec(k,-184,-162,54);
        intvec(k,-184,-183,52);
        intvec(k,-184,-185,76);
        intvec(k,-184,-164,77);
        intvec(k,-184,149,77);
        intvec(k,-184,170,76);
        intvec(k,-184,168,52);
        intvec(k,-184,147,54);
        intvec(k,-183,138,89);
        intvec(k,-183,183,85);
        intvec(k,90,183,85);
        intvec(k,90,138,89);
        intvec(k,90,134,38);
        intvec(k,90,179,34);
        intvec(k,-183,179,34);
        intvec(k,-183,134,38);
END plusMe262;

PROCEDURE plusJu287 (k:REAL   );
BEGIN
        intvec(k,169,0,68);
        intvec(k,-75,-1,68);
        intvec(k,-296,54,759);
        intvec(k,-215,54,759);
        intvec(k,-104,10,240);
        intvec(k,-104,14,285);
        intvec(k,168,14,285);
        intvec(k,168,10,240);
        intvec(k,168,-41,244);
        intvec(k,168,-37,289);
        intvec(k,-104,-37,289);
        intvec(k,-104,-41,244);
        intvec(k,-105,-5,253);
        intvec(k,-105,-3,274);
        intvec(k,-105,-27,276);
        intvec(k,-105,-29,255);
        intvec(k,-517,-50,80);
        intvec(k,-517,-50,101);
        intvec(k,-517,-27,101);
        intvec(k,-517,-27,80);
        intvec(k,-516,-61,68);
        intvec(k,-516,-61,113);
        intvec(k,-243,-61,113);
        intvec(k,-243,-61,68);
        intvec(k,-243,-10,68);
        intvec(k,-243,-10,113);
        intvec(k,-516,-10,113);
        intvec(k,-516,-10,68);
        intvec(k,-516,-10,-69);
        intvec(k,-516,-10,-114);
        intvec(k,-243,-10,-114);
        intvec(k,-243,-10,-69);
        intvec(k,-243,-61,-69);
        intvec(k,-243,-61,-114);
        intvec(k,-516,-61,-114);
        intvec(k,-516,-61,-69);
        intvec(k,-517,-27,-81);
        intvec(k,-517,-27,-102);
        intvec(k,-517,-50,-102);
        intvec(k,-517,-50,-81);
        intvec(k,-105,-29,-251);
        intvec(k,-105,-27,-272);
        intvec(k,-105,-3,-270);
        intvec(k,-105,-5,-249);
        intvec(k,-104,-41,-241);
        intvec(k,-104,-37,-286);
        intvec(k,168,-37,-286);
        intvec(k,168,-41,-241);
        intvec(k,168,10,-236);
        intvec(k,168,14,-281);
        intvec(k,-104,14,-281);
        intvec(k,-104,10,-236);
        intvec(k,645,67,275);
        intvec(k,698,67,275);
        intvec(k,702,67,-1);
        intvec(k,698,67,-272);
        intvec(k,645,67,-272);
        intvec(k,565,67,-1);
        intvec(k,-441,70,67);
        intvec(k,180,70,67);
        intvec(k,180,-50,67);
        intvec(k,-441,-50,67);
        intvec(k,-544,12,55);
        intvec(k,-544,-43,55);
        intvec(k,-611,-26,22);
        intvec(k,-628,14,14);
        intvec(k,-496,83,59);
        intvec(k,-544,83,55);
        intvec(k,-598,61,30);
        intvec(k,-598,61,-32);
        intvec(k,-544,83,-56);
        intvec(k,-496,83,-61);
        intvec(k,-628,14,-15);
        intvec(k,-611,-26,-23);
        intvec(k,-544,-43,-56);
        intvec(k,-544,12,-56);
        intvec(k,-441,-50,-68);
        intvec(k,180,-50,-68);
        intvec(k,180,70,-68);
        intvec(k,-441,70,-68);
        intvec(k,-215,54,-756);
        intvec(k,-296,54,-756);
        intvec(k,-75,-1,-69);
        intvec(k,169,0,-69);
        intvec(k,548,69,-1);
        intvec(k,659,236,-1);
        intvec(k,714,236,-1);
        intvec(k,743,40,-1);
END plusJu287;

PROCEDURE plusFrigate (k:REAL   );
BEGIN
        intvec(k,25,90,-322);
        intvec(k,25,79,-332);
        intvec(k,25,79,-401);
        intvec(k,25,90,-401);
        intvec(k,-18,90,-401);
        intvec(k,-18,79,-401);
        intvec(k,-18,79,-332);
        intvec(k,-18,90,-322);
        intvec(k,-33,100,-237);
        intvec(k,-33,100,-311);
        intvec(k,40,100,-311);
        intvec(k,40,100,-237);
        intvec(k,40,60,-237);
        intvec(k,40,60,-349);
        intvec(k,-33,60,-349);
        intvec(k,-33,60,-237);
        intvec(k,-84,184,18);
        intvec(k,85,184,18);
        intvec(k,85,200,18);
        intvec(k,-84,200,18);
        intvec(k,-16,62,17);
        intvec(k,0,62,41);
        intvec(k,15,62,17);
        intvec(k,0,322,27);
        intvec(k,42,233,-147);
        intvec(k,42,233,-39);
        intvec(k,-50,233,-39);
        intvec(k,-50,233,-147);
        intvec(k,0,323,247);
        intvec(k,15,139,243);
        intvec(k,0,139,267);
        intvec(k,-16,139,243);
        intvec(k,33,114,-96);
        intvec(k,33,114,-23);
        intvec(k,16,203,-96);
        intvec(k,16,203,-59);
        intvec(k,-22,203,-59);
        intvec(k,-22,203,-96);
        intvec(k,-38,114,-23);
        intvec(k,-38,114,-96);
        intvec(k,-53,111,0);
        intvec(k,-53,112,-187);
        intvec(k,56,112,-187);
        intvec(k,56,111,0);
        intvec(k,25,61,0);
        intvec(k,25,60,-146);
        intvec(k,-29,60,-146);
        intvec(k,-29,61,0);
        intvec(k,-34,61,145);
        intvec(k,-34,61,52);
        intvec(k,40,61,52);
        intvec(k,40,61,145);
        intvec(k,40,170,177);
        intvec(k,40,170,83);
        intvec(k,-34,170,83);
        intvec(k,-34,170,177);
        intvec(k,-53,138,370);
        intvec(k,-53,138,183);
        intvec(k,56,138,183);
        intvec(k,56,138,370);
        intvec(k,56,61,370);
        intvec(k,56,61,183);
        intvec(k,-53,61,183);
        intvec(k,-53,61,370);
        intvec(k,87,59,-414);
        intvec(k,87,59,566);
        intvec(k,82,-18,-414);
        intvec(k,82,-18,566);
        intvec(k,3,-18,643);
        intvec(k,3,59,651);
        intvec(k,3,-18,-609);
        intvec(k,3,59,-666);
        intvec(k,3,-71,566);
        intvec(k,3,-71,-414);
        intvec(k,-74,-18,566);
        intvec(k,-74,-18,-414);
        intvec(k,-79,59,566);
        intvec(k,-79,59,-414);
END plusFrigate;

PROCEDURE plusJet (k:REAL   );
BEGIN
        intvec(k,30,191,96);
        intvec(k,-1,177,38);
        intvec(k,-62,148,38);
        intvec(k,-93,134,96);
        intvec(k,-62,148,155);
        intvec(k,-1,177,155);
        intvec(k,114,-70,155);
        intvec(k,53,-99,155);
        intvec(k,22,-113,96);
        intvec(k,53,-99,38);
        intvec(k,114,-70,38);
        intvec(k,145,-56,96);
        intvec(k,145,-56,-100);
        intvec(k,114,-70,-41);
        intvec(k,53,-99,-41);
        intvec(k,22,-113,-100);
        intvec(k,53,-99,-159);
        intvec(k,114,-70,-159);
        intvec(k,-1,177,-159);
        intvec(k,-62,148,-159);
        intvec(k,-93,134,-100);
        intvec(k,-62,148,-41);
        intvec(k,-1,177,-41);
        intvec(k,30,191,-100);
        intvec(k,-75,31,-378);
        intvec(k,259,31,-378);
        intvec(k,259,-15,-378);
        intvec(k,-75,-15,-378);
        intvec(k,-75,-15,-338);
        intvec(k,259,-15,-338);
        intvec(k,259,31,-338);
        intvec(k,-75,31,-338);
        intvec(k,207,13,-338);
        intvec(k,136,13,-338);
        intvec(k,-349,-47,-39);
        intvec(k,-337,25,-39);
        intvec(k,-181,36,-39);
        intvec(k,-169,87,-3);
        intvec(k,-113,83,-3);
        intvec(k,16,36,-39);
        intvec(k,236,30,-3);
        intvec(k,419,151,-3);
        intvec(k,503,151,-3);
        intvec(k,532,9,-3);
        intvec(k,4,-51,-39);
        intvec(k,-201,-59,-39);
        intvec(k,-278,66,-3);
        intvec(k,-201,-59,33);
        intvec(k,4,-51,33);
        intvec(k,16,36,33);
        intvec(k,-181,36,33);
        intvec(k,-337,25,33);
        intvec(k,-349,-47,33);
        intvec(k,-137,13,-160);
        intvec(k,164,13,-160);
        intvec(k,-431,-22,-23);
        intvec(k,-431,-22,17);
        intvec(k,-431,4,-23);
        intvec(k,-431,4,17);
        intvec(k,164,13,156);
        intvec(k,-137,13,156);
        intvec(k,136,13,333);
        intvec(k,207,13,333);
        intvec(k,-75,31,333);
        intvec(k,259,31,333);
        intvec(k,259,-15,333);
        intvec(k,-75,-15,333);
        intvec(k,-75,-15,373);
        intvec(k,259,-15,373);
        intvec(k,259,31,373);
        intvec(k,-75,31,373);
        intvec(k,-288,-52,-1);
        intvec(k,-251,-55,-1);
        intvec(k,-321,-179,-1);
        intvec(k,-343,-179,-1);
        intvec(k,-252,-180,-23);
        intvec(k,-252,-180,19);
        intvec(k,136,-180,-204);
        intvec(k,136,-180,-246);
        intvec(k,46,-179,-224);
        intvec(k,68,-179,-224);
        intvec(k,109,12,-224);
        intvec(k,62,12,-224);
        intvec(k,61,12,227);
        intvec(k,108,12,227);
        intvec(k,66,-180,227);
        intvec(k,45,-180,227);
        intvec(k,135,-180,205);
        intvec(k,135,-180,247);
END plusJet;

PROCEDURE plusBasetop(k:REAL);
BEGIN
        intvec(k,484,0,-1224);
        intvec(k,484,240,-1224);
        intvec(k,297,600,-756);
        intvec(k,-525,0,-1214);
        intvec(k,-525,240,-1214);
        intvec(k,-328,600,-751);
        intvec(k,-1228,0,-494);
        intvec(k,-1228,240,-494);
        intvec(k,-760,600,-307);
        intvec(k,-1224,0,516);
        intvec(k,-1224,240,516);
        intvec(k,-760,600,319);
        intvec(k,-496,0,1221);
        intvec(k,-496,240,1221);
        intvec(k,-314,600,753);
        intvec(k,504,0,1214);
        intvec(k,504,240,1214);
        intvec(k,309,600,748);
        intvec(k,1219,0,489);
        intvec(k,1219,240,489);
        intvec(k,748,600,304);
        intvec(k,1207,0,-513);
        intvec(k,1207,240,-513);
        intvec(k,739,600,-319);
        intvec(k,-680,0,40);
        intvec(k,0,0,-700);
        intvec(k,720,0,0);
        intvec(k,0,0,740);
END plusBasetop;

PROCEDURE plusBase ( k:REAL  );
BEGIN
        intvec(k,386,0,-390);
        intvec(k,386,200,-390);
        intvec(k,238,350,-241);
        intvec(k,-4,0,-551);
        intvec(k,-4,200,-551);
        intvec(k,-3,350,-341);
        intvec(k,-391,0,-389);
        intvec(k,-391,200,-389);
        intvec(k,-241,350,-241);
        intvec(k,-553,0,-1);
        intvec(k,-553,200,-1);
        intvec(k,-343,350,-1);
        intvec(k,-389,0,388);
        intvec(k,-389,200,388);
        intvec(k,-243,350,238);
        intvec(k,-4,0,549);
        intvec(k,-4,200,549);
        intvec(k,-3,350,338);
        intvec(k,388,0,387);
        intvec(k,388,200,387);
        intvec(k,238,350,239);
        intvec(k,547,0,0);
        intvec(k,547,200,0);
        intvec(k,336,350,-1);
END plusBase;

PROCEDURE plusMothership ( k:REAL  );
BEGIN
        intvec(k,-109,66,493);
        intvec(k,-171,66,396);
        intvec(k,-171,66,-604);
        intvec(k,-171,-32,-603);
        intvec(k,-109,-32,422);
        intvec(k,-171,-32,364);
        intvec(k,-117,-64,-584);
        intvec(k,-117,-64,352);
        intvec(k,-171,-64,352);
        intvec(k,-171,-64,-584);
        intvec(k,-171,-100,313);
        intvec(k,-171,-80,-584);
        intvec(k,-40,66,396);
        intvec(k,-40,66,-604);
        intvec(k,-47,-32,-603);
        intvec(k,-47,-32,364);
        intvec(k,-101,-64,-584);
        intvec(k,-101,-64,352);
        intvec(k,-47,-64,352);
        intvec(k,-47,-64,-584);
        intvec(k,-47,-100,313);
        intvec(k,-47,-80,-584);
        intvec(k,109,66,493);
        intvec(k,171,66,396);
        intvec(k,171,66,-604);
        intvec(k,171,-32,-603);
        intvec(k,109,-32,422);
        intvec(k,171,-32,364);
        intvec(k,117,-64,-584);
        intvec(k,117,-64,352);
        intvec(k,171,-64,352);
        intvec(k,171,-64,-584);
        intvec(k,171,-100,313);
        intvec(k,171,-80,-584);
        intvec(k,40,66,396);
        intvec(k,40,66,-604);
        intvec(k,47,-32,-603);
        intvec(k,47,-32,364);
        intvec(k,101,-64,-584);
        intvec(k,101,-64,352);
        intvec(k,47,-64,352);
        intvec(k,47,-64,-584);
        intvec(k,47,-100,313);
        intvec(k,47,-80,-584);
        intvec(k,-171,66,-500);
        intvec(k,171,66,-500);
        intvec(k,-40,66,-500);
        intvec(k,40,66,-500);
        intvec(k,-96,70,319);
        intvec(k,-96,70,159);
        intvec(k,-96,116,319);
        intvec(k,-96,116,159);
        intvec(k,-117,131,355);
        intvec(k,-117,131,159);
        intvec(k,96,70,319);
        intvec(k,96,70,159);
        intvec(k,96,116,319);
        intvec(k,96,116,159);
        intvec(k,117,131,355);
        intvec(k,117,131,159);
        intvec(k,0,123,162);
        intvec(k,-40,32,-500);
        intvec(k,40,32,-500);
        intvec(k,-40,32,362);
        intvec(k,40,32,362);
        intvec(k,-96,66,-352);
        intvec(k,-96,66,-160);
        intvec(k,96,66,-160);
        intvec(k,96,66,-352);
END plusMothership;

(* ------------------------------------------------------------ *)

(* some objects moved out of procedure as to avoid dreadful "dynamic pool exceeded" *)

PROCEDURE initObject (obj:objtype);
VAR
    i : CARDINAL;
    k : REAL;
BEGIN
    lastpoint := firstpoint;
    CASE obj OF
    | cube:
        translation := vectortype(0,-60,0);

        vec(40,40,40);
        vec(40,40,-40);
        vec(-40,40,-40);
        vec(-40,40,40);
        vec(40,-40,40);
        vec(40,-40,-40);
        vec(-40,-40,-40);
        vec(-40,-40,40);

    | plan:
        translation := vectortype(0,30,0);

        vec(30,0,30);
        vec(20,0,30);
        vec(10,0,30);
        vec(0,0,30);
        vec(-10,0,30);
        vec(-20,0,30);
        vec(-30,0,30);

        vec(30,0,20);
        vec(20,0,20);
        vec(10,0,20);
        vec(0,0,20);
        vec(-10,0,20);
        vec(-20,0,20);
        vec(-30,0,20);

        vec(30,0,10);
        vec(20,0,10);
        vec(10,0,10);
        vec(0,0,10);
        vec(-10,0,10);
        vec(-20,0,10);
        vec(-30,0,10);

        vec(30,0,0);
        vec(20,0,0);
        vec(10,0,0);
        vec(0,0,0);
        vec(-10,0,0);
        vec(-20,0,0);
        vec(-30,0,0);

        vec(30,0,-10);
        vec(20,0,-10);
        vec(10,0,-10);
        vec(0,0,-10);
        vec(-10,0,-10);
        vec(-20,0,-10);
        vec(-30,0,-10);

        vec(30,0,-20);
        vec(20,0,-20);
        vec(10,0,-20);
        vec(0,0,-20);
        vec(-10,0,-20);
        vec(-20,0,-20);
        vec(-30,0,-20);

        vec(30,0,-30);
        vec(20,0,-30);
        vec(10,0,-30);
        vec(0,0,-30);
        vec(-10,0,-30);
        vec(-20,0,-30);
        vec(-30,0,-30);

    | diamond:
        k := 20.0;
        translation := floatvectortype( k, 0.0, 0.0, 0.0);

        floatvec(k,3.5, 2.5, -2.5);
        floatvec(k,1.5, 2.5, -2.5);
        floatvec(k,2.5, 3.5, -2.5);
        floatvec(k,2.5, 1.5, -2.5);
        floatvec(k,2.5, 2.5, -1.5);
        floatvec(k,2.5, 2.5, -3.5);

    | gon:
        k := 20.0;
        translation := floatvectortype( k, 0.0, 0.0, 0.0);

        floatvec(k,3.118034, -0.881966, 2.5);
        floatvec(k,1.881966, -0.881966, 2.5);
        floatvec(k,3.118034, -4.118034, 2.5);
        floatvec(k,1.881966, -4.118034, 2.5);
        floatvec(k,4.118034, -2.5, 3.118034);
        floatvec(k,4.118034, -2.5, 1.881966);
        floatvec(k,0.881966, -2.5, 3.118034);
        floatvec(k,0.881966, -2.5, 1.881966);
        floatvec(k,2.5, -1.881966, 4.118034);
        floatvec(k,2.5, -3.118034, 4.118034);
        floatvec(k,2.5, -1.881966, 0.881966);
        floatvec(k,2.5, -3.118034, 0.881966);

    | skull:
        k := 0.8;
        translation := floatvectortype( k, 0.0, 30.0, 0.0);

        floatvec (k,    2.0,  -41.3,  -10.9);
        floatvec (k,    1.9,   -7.7,  -18.1);
        floatvec (k,  -13.9,  -25.6,  -16.7);
        floatvec (k,  -12.6,   23.8,  -24.5);
        floatvec (k,   15.7,   24.4,  -23.7);
        floatvec (k,    1.6,   21.4,  -14.6);
        floatvec (k,    1.9,   15.4,  -13.7);
        floatvec (k,    2.1,   34.3,  -38.8);
        floatvec (k,    1.9,   31.2,  -35.4);
        floatvec (k,  -15.7,   42.0,  -50.7);
        floatvec (k,   19.4,   42.6,  -49.8);
        floatvec (k,    2.0,   70.0,  -63.8);
        floatvec (k,  -13.0,   40.4,  -38.7);
        floatvec (k,   16.2,   40.7,  -38.3);
        floatvec (k,   -7.1,   14.7,  -11.4);
        floatvec (k,   10.6,   14.2,  -10.8);
        floatvec (k,  -11.8,   16.3,  -13.3);
        floatvec (k,   15.0,   16.2,  -12.6);
        floatvec (k,  -28.6,    7.3,  -19.2);
        floatvec (k,   32.8,    6.8,  -18.9);
        floatvec (k,  -31.4,   -8.7,  -13.5);
        floatvec (k,   37.1,   -9.0,  -13.2);
        floatvec (k,  -28.3,   46.4,  -49.7);
        floatvec (k,  -45.9,   57.1,  -38.6);
        floatvec (k,  -46.6,  -21.3,  -20.3);
        floatvec (k,  -55.7,  -18.4,  -11.5);
        floatvec (k,  -50.3,  -42.6,   20.3);
        floatvec (k,   50.8,  -20.6,  -21.7);
        floatvec (k,   59.4,  -17.6,  -11.8);
        floatvec (k,   54.7,  -42.5,   21.2);
        floatvec (k,   62.9,    2.0,    4.2);
        floatvec (k,   58.4,    0.0,    0.0);
        floatvec (k,   65.2,   33.0,  -11.7);
        floatvec (k,   57.0,   52.7,  -12.3);
        floatvec (k,   50.7,   69.3,    6.2);
        floatvec (k,   45.3,   77.8,   24.8);
        floatvec (k,   55.1,   42.2,   28.0);
        floatvec (k,   52.1,   51.6,   26.8);
        floatvec (k,   52.0,   54.5,   58.1);
        floatvec (k,   68.1,    2.2,   50.4);
        floatvec (k,   49.3,   57.1,  -37.7);
        floatvec (k,   32.7,   47.1,  -49.9);
        floatvec (k,   23.4,   35.7,  -27.7);
        floatvec (k,    2.6,  -73.5,   24.0);
        floatvec (k,    2.5,  -75.5,   57.9);
        floatvec (k,    1.3,  -58.5,   85.8);
        floatvec (k,   -1.4,   20.8,  111.5);
        floatvec (k,   -0.4,   44.5,  100.0);
        floatvec (k,  -51.8,   52.1,   57.0);
        floatvec (k,  -52.0,   50.9,   24.4);
        floatvec (k,  -53.8,   42.4,   25.4);
        floatvec (k,  -62.4,   32.7,  -13.4);
        floatvec (k,  -55.3,   52.9,  -13.8);
        floatvec (k,  -50.5,   69.3,    5.2);
        floatvec (k,  -66.6,   -0.9,   50.7);
        floatvec (k,  -46.7,   68.1,  -11.3);
        floatvec (k,  -36.0,   72.0,  -25.0);
        floatvec (k,  -43.5,   80.1,    3.8);
        floatvec (k,   -8.9,   80.3,   -6.2);
        floatvec (k,   -8.2,   83.4,   -4.0);
        floatvec (k,  -45.5,   77.7,   23.1);
        floatvec (k,  -58.9,    0.6,    3.3);
        floatvec (k,  -54.8,    0.0,    0.0);
        floatvec (k,    0.7,   96.3,   24.8);
        floatvec (k,    0.0,   90.1,    0.0);
        floatvec (k,    0.3,   95.3,    7.9);
        floatvec (k,   45.7,   67.1,   -9.4);
        floatvec (k,   36.9,   72.2,  -24.1);
        floatvec (k,   43.9,   79.5,    5.4);
        floatvec (k,    9.3,   80.3,   -6.2);
        floatvec (k,    8.8,   83.5,   -3.6);
        floatvec (k,    1.7,   74.1,  -67.1);
        floatvec (k,    1.5,   76.7,  -54.5);
        floatvec (k,    0.0,   75.4,  -50.4);
        floatvec (k,   13.1,   75.8,  -41.6);
        floatvec (k,  -11.5,   75.2,  -41.9);
        floatvec (k,  -20.5,   36.1,  -27.3);
        floatvec (k,   19.3,  -25.8,  -16.9);
        floatvec (k,   57.4,   18.0,  -14.6);
        floatvec (k,   39.4,   12.6,  -14.6);
        floatvec (k,   58.6,   14.2,  -10.0);
        floatvec (k,   39.7,    8.2,   -9.4);
        floatvec (k,   54.3,    4.1,   -7.1);
        floatvec (k,   37.8,    6.4,   -8.7);
        floatvec (k,   48.0,   11.6,   -4.9);
        floatvec (k,  -54.2,   17.8,  -15.1);
        floatvec (k,  -36.6,   13.6,  -15.1);
        floatvec (k,  -55.2,   13.4,   -9.9);
        floatvec (k,  -36.3,    7.8,   -8.8);
        floatvec (k,  -50.9,    4.0,   -6.9);
        floatvec (k,  -35.3,    5.8,   -7.1);
        floatvec (k,  -45.8,   11.2,   -5.4);
        floatvec (k,  -45.6,   40.1,  -18.6);
        floatvec (k,  -47.1,   18.8,  -25.8);
        floatvec (k,  -56.6,   11.5,  -16.9);
        floatvec (k,  -48.9,    3.9,  -14.9);
        floatvec (k,  -42.3,   -4.6,  -62.0);
        floatvec (k,  -42.7,   36.5,  -35.6);
        floatvec (k,    1.6,   66.2,  -76.2);
        floatvec (k,    2.2,   63.6,  -82.4);
        floatvec (k,    2.6,   62.3,  -94.8);
        floatvec (k,    3.4,   52.1, -101.6);
        floatvec (k,   48.7,   40.9,  -16.6);
        floatvec (k,   50.7,   19.8,  -25.0);
        floatvec (k,   59.4,   11.4,  -15.0);
        floatvec (k,   50.6,    3.0,  -13.1);
        floatvec (k,   49.2,   -3.3,  -60.8);
        floatvec (k,   46.5,   38.7,  -33.9);
        floatvec (k,   47.5,   14.8,  -11.6);
        floatvec (k,  -45.4,   14.6,  -12.1);
        floatvec (k,    1.1,   80.8,  -51.9);
        floatvec (k,   44.5,   19.7,  -14.0);
        floatvec (k,   47.3,   12.8,   -7.7);
        floatvec (k,  -42.0,   19.2,  -14.6);
        floatvec (k,  -45.1,   12.8,   -8.2);
        floatvec (k,    0.0,   58.4,   -3.3);
        floatvec (k,    0.0,   38.8,    4.7);
        floatvec (k,    0.0,   26.8,    4.0);
        floatvec (k,    0.0,    0.0,    0.0);
        floatvec (k,    0.0,    0.0,    0.0);
        floatvec (k,    0.0,    0.0,    0.0);
        floatvec (k,    0.0,    0.0,    0.0);
        floatvec (k,    0.0,   93.3,   52.2);
        floatvec (k,    0.0,   -8.1,  115.4);
        floatvec (k,    0.0,  -77.0,   35.6);
        floatvec (k,    0.0,   89.9,   20.4);
        floatvec (k,    0.0,   21.9,  104.9);
        floatvec (k,    0.0,  -69.1,   59.7);
        floatvec (k,    0.0,  -40.4,   -7.3);
        floatvec (k,  -66.6,   -5.1,   82.9);
        floatvec (k,   67.8,   -6.3,   72.9);
        floatvec (k,    0.0,  -77.0,    0.0);
        floatvec (k,    0.0,   96.3,    0.0);
        floatvec (k,  -66.6,    0.0,    0.0);
        floatvec (k,   68.1,    0.0,    0.0);
        floatvec (k,    0.0,    0.0,  101.6);
        floatvec (k,    0.0,    0.0, -115.4);
    | shark:
        k := 0.25;
        translation := vectortype(0,0,0);
        plusShark(k);
    | me262 :
        k:= 0.2;
        translation := vectortype(0,0,0);
        plusMe262(k);
    | ju287 :
        k:= 0.1;
        translation := vectortype(0,0,0);
        plusJu287(k);
    | basetop :
        k:= 0.05;
        translation := vectortype(0,0,0);
        plusBasetop(k);
    | base :
        k:= 0.15;
        translation := vectortype(0,0,0);
        plusBase(k);
    | tower :
        k:= 0.05;
        translation := vectortype(0,0,0);
        plusTower(k);
    | frigate :
        k:= 0.2;
        translation := vectortype(0,0,0);
        plusFrigate(k);
    | jet :
        k:= 0.2;
        translation := vectortype(0,0,0);
        plusJet(k);
    | mothership :
        k:= 0.2;
        translation := vectortype(0,0,0);
        plusMothership(k);
    | point:
        translation := vectortype(-60,-60,-60);

        vec (0,0,0);
    END;
    DEC(lastpoint); (* we were past real lastpoint... except if we have past it ! *)

    FOR i := firstpoint TO lastpoint DO
        rotation[i] := vectortype(0,0,0);
    END;
END initObject;

PROCEDURE translate3D (VAR p:vectortype; t:vectortype);
BEGIN
    INC(p.x,t.x);
    INC(p.y,t.y);
    INC(p.z,t.z);
END translate3D;

PROCEDURE rotate3D (VAR p:vectortype; r:vectortype);
VAR
    s,q : vectortype;
BEGIN
    (* roll Z *)

    s.x := INTEGER( LONGREAL(p.y) * sinval[r.z] + LONGREAL(p.x) * cosval[r.z] );
    s.y := INTEGER( LONGREAL(p.y) * cosval[r.z] - LONGREAL(p.x) * sinval[r.z] );
    s.z := p.z;

    (* pitch Y *)

    q.x := s.x;
    q.y := INTEGER( LONGREAL(s.z) * sinval[r.y] - LONGREAL(s.y) * cosval[r.y] );
    q.z := INTEGER( LONGREAL(s.z) * cosval[r.y] + LONGREAL(s.y) * sinval[r.y] );

    (* yaw X *)
    p.x := INTEGER( LONGREAL(q.z) * sinval[r.x] + LONGREAL(q.x) * cosval[r.x] );
    p.y := q.y;
    p.z := INTEGER( LONGREAL(q.z) * cosval[r.x] - LONGREAL(q.x) * sinval[r.x] );
END rotate3D;

PROCEDURE project3D (VAR p:vectortype; SCX,SCY:INTEGER);
BEGIN
    p.x := SCX + (ViewDist * p.x) DIV (p.z + ViewDist);
    p.y := SCY + (ViewDist * p.y) DIV (p.z + ViewDist + DistCorr);
END project3D;

(* do bubble sort by nz% (z-depth sort) so that vector bobs will overlap correctly *)

PROCEDURE sort3D (VAR p : vectorarraytype; numpoints : CARDINAL);
VAR
    swapped : BOOLEAN;
    i       : CARDINAL;
    tmp     : vectortype;
BEGIN
    REPEAT
        swapped := FALSE;
        FOR i := firstpoint TO (numpoints-1) DO
            IF p[i].z < p[i+1].z THEN
                tmp     := p[i];
                p[i]    := p[i+1];
                p[i+1]  := tmp;
                swapped := TRUE;
            END;
        END;
    UNTIL swapped=FALSE;
END sort3D;

(* we probably should be stricter on boundaries *)

PROCEDURE drawBobs3D (p : vectorarraytype; numpoints:CARDINAL; flatmode:BOOLEAN );
VAR
    i  : CARDINAL;
    spritesize: INTEGER;
BEGIN
    FOR i := firstpoint TO numpoints DO
        (*
        nz% ranges from -100 to 100 (approx.)
        size% is calculated by reversing nz%, then
        adding 100 to shift to 0-200, then dividing by
        40 to keep between 0-5.
        *)
        IF flatmode THEN
            spritesize := firstsprite;
        ELSE
            spritesize := (-p[i].z + 100) DIV 40;
            IF spritesize < firstsprite THEN
                spritesize := firstsprite;
            ELSIF spritesize > lastsprite THEN
                spritesize := firstsprite;
            END;
        END;
        INC(spritesize); (* 0..5 --> 1..6 *)
        IF (p[i].x >= xmin) AND ((p[i].x + spriteWidth) <= ixmax) THEN
            IF (p[i].y >= ymin) AND ((p[i].y + spriteHeight) <= iymax) THEN
                TDRAW_BITMAP (FarADR(sprite[spritesize].dots),p[i].x,p[i].y, spriteWidth,spriteHeight );
            END;
        END;
    END;
END drawBobs3D;

PROCEDURE newrotation (VAR r : vectortype; rotx,roty,rotz:INTEGER);
CONST
    circ = maxalpha + 1; (* 360 *)
BEGIN
    INC(r.x,rotx);
    IF r.x > maxalpha THEN
        r.x := circ - r.x;
    ELSIF r.x < minalpha THEN
        r.x := circ + r.x;
    END;

    INC(r.y,roty);
    IF r.y > maxalpha THEN
        r.y := circ - r.y;
    ELSIF r.x < minalpha THEN
        r.y := circ + r.y;
    END;

    INC(r.z,rotz);
    IF r.z > maxalpha THEN
        r.z := circ - r.z;
    ELSIF r.z < minalpha THEN
        r.z := circ + r.z;
    END;
END newrotation;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE newangle (VAR v : INTEGER; k:INTEGER);
BEGIN
    v := v + k;
    v := v MOD 6;
END newangle;

PROCEDURE swapcard (VAR a,b:CARDINAL);
VAR
    tmp : CARDINAL;
BEGIN
    tmp := a;
    a   := b;
    b   := tmp;
END swapcard;

CONST
    keySpace   = 02000H;
    keyESC     = 01B00H;
    keyCR      = 00D00H;
    keyPageUp  = 00049H;
    keyPageDn  = 00051H;
    keyEnd     = 0004FH;
    keyHome    = 00047H;
    keyDel     = 00800H;
    keyLeft    = 0004BH;
    keyRight   = 0004DH;
    keyStar    = ORD("*") << 8 ;
    keyDivide  = ORD("/") << 8 ;
    keyUpperP  = ORD("P") << 8 ;
    keyLowerP  = ORD("p") << 8 ;
    keyUpperO  = ORD("O") << 8 ;
    keyLowerO  = ORD("o") << 8 ;
    keyUpperX  = ORD("X") << 8 ;
    keyLowerX  = ORD("x") << 8 ;
    keyUpperY  = ORD("Y") << 8 ;
    keyLowerY  = ORD("y") << 8 ;
    keyUpperZ  = ORD("Z") << 8 ;
    keyLowerZ  = ORD("z") << 8 ;
    keyUpperF  = ORD("F") << 8 ;
    keyLowerF  = ORD("f") << 8 ;
    keyPlus    = ORD("+") << 8 ;
    keyMinus   = ORD("-") << 8 ;
VAR
    parmcount, i, opt, v : CARDINAL;
    S, R                 : str128;

    stopmouse, lores, flatmode : BOOLEAN;
    object, palette       : CARDINAL;

    singlestep,chk        : BOOLEAN;
    keycode               : CARDINAL;

    t : vectortype;
    rotx,roty,rotz : INTEGER;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;                       (* must be here for pretty ulterior display ! *)

    stopmouse    := TRUE;
    lores        := TRUE;
    flatmode    := FALSE;
    object       := defaultobj;
    palette      := defaultpal;

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R)=TRUE THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "K"+delim+"KEYPRESS"+delim+
                                   "O:"+delim+"OBJECT:"+delim+
                                   "P:"+delim+"PALETTE:"+delim+
                                   "F"+delim+"FLAT"
                               );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5 :
                stopmouse:=FALSE;
            | 6,7:
                IF value(R,minobj,maxobj,object)=FALSE THEN
                    abort(errRange,"object");
                END;
            | 8,9:
                IF value(R,minpal,maxpal,palette)=FALSE THEN
                    abort(errRange,"palette");
                END;
            |10,11:
                flatmode:=TRUE;
            ELSE
                abort(errUnknownOpt,S);
            END;
        ELSE
            abort(errIllegalParm,S);
        END;
    END;

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    initHires(lores);
    IF HiresON()=FALSE THEN
        HiresOFF;
        abort(errCannotSetModeX,sMode);
    END;

    MakePalette(paltype(palette)); (* after hires ! *)

    flushKeyboard;
    doRandomize;

    initTrigo;
    initSprites;
    initObject(objtype(object));

    setviewwork(viewpage,workpage);
    clearPage (ndxinkblack);

    singlestep := FALSE;

    rotx := 1;
    roty := 1;
    rotz := 1;
    LOOP
        clearPage (ndxinkblack);    (* erase work screen *)

        (* calculate the position of the new image *)
        FOR i := firstpoint TO lastpoint DO
            t := world[i];                  (* get a point *)
            translate3D(t,translation);
            rotate3D(t,rotation[i]);
            project3D(t, cx, cy); (* project the point onto the screen *)
            screen[i] := t;       (* put the point into the draw list *)
            (* rotate the points *)
            (* newrotation(rotation[i],3,4,5); *)
            newrotation(rotation[i],rotx,roty,rotz);
        END;
        sort3D(screen,lastpoint);      (* sort the points in z-depth order *)
        drawBobs3D(screen,lastpoint,flatmode);  (* draw the new image *)

        WaitVGAretrace;
        setviewwork(workpage,viewpage);
        swapcard(viewpage,workpage);

        (* read and process key *)
        IF singlestep THEN
            WHILE getKeyboardCode(keycode)=FALSE DO
            END;
            chk:=(keycode # keySpace);
            singlestep:=NOT(chk);
        ELSE
            chk:=getKeyboardCode(keycode);
        END;
        IF chk THEN
            CASE keycode OF
            | keyESC :
                EXIT;
            | keyCR :
                EXIT;
            | keyUpperP,keyLowerP:
                IF palette = maxpal THEN
                    palette := minpal;
                ELSE
                    INC(palette);
                END;
                MakePalette (paltype(palette));
            | keyUpperO,keyLowerO:
                IF object = maxobj THEN
                    object := minobj;
                ELSE
                    INC(object);
                END;
                initObject (objtype(object));
            | keyUpperF, keyLowerF :
                flatmode := NOT(flatmode);
            | keySpace:
                singlestep := NOT(singlestep);
            | keyPageDn:
                IF object = maxobj THEN
                    object := minobj;
                ELSE
                    INC(object);
                END;
                initObject (objtype(object));
            | keyPageUp:
                IF object = minobj THEN
                    object := maxobj;
                ELSE
                    DEC(object);
                END;
                initObject (objtype(object));
            | keyPlus:
                IF palette = maxpal THEN
                    palette := minpal;
                ELSE
                    INC(palette);
                END;
                MakePalette (paltype(palette));
            | keyMinus:
                IF palette = minpal THEN
                    palette := maxpal;
                ELSE
                    DEC(palette);
                END;
                MakePalette (paltype(palette));
            (*
            | keyUpperX: newangle(rotx,-1);
            | keyLowerX: newangle(rotx,1);
            | keyUpperY: newangle(roty,-1);
            | keyLowerY: newangle(roty,1);
            | keyUpperZ: newangle(rotz,-1);
            | keyLowerZ: newangle(rotz,1);
            *)
            END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;
    END;

    HiresOFF;
    abort(errNone,"");
END Vectors.

(*

for future extension with polygons, we may use this format :

- objectName
- vertexes
- polygons

then for each vertex (0..vertices-1) :

- x y z

then for each polygon :

- number of points
- indexes of each point

example :

triangle
3
1

10 10 10
-10 10 60
110 0 -10

3
0 1 2



*)

