(* ---------------------------------------------------------------
Title         Q&D Voxel demo
Author        PhG
Overview      tsk tsk...
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
              plasma algorithm is rather good (clearly not VERY good :
              not enough control on parms such as roughness etc.)
              model should definitely be LARGE
Bugs

Wish List     tsk tsk... load external palette file ?

--------------------------------------------------------------- *)

MODULE Voxel;

IMPORT Lib;
IMPORT SYSTEM;
IMPORT IO;
IMPORT Str;
IMPORT BiosIO;
IMPORT MATHLIB;
IMPORT MsMouse;

FROM IO IMPORT WrStr, WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,cleantabs;

FROM Lib IMPORT Fill,FarWordMove;
FROM Storage IMPORT ALLOCATE;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    maxWait = 10; (* seconds *)

CONST
    cr         = CHR(13);
    lf         = CHR(10);
    nl         = cr+lf;

CONST
    ProgEXEname   = "VOXEL";
    ProgTitle     = "Q&D Voxel demo";
    ProgVersion   = "v1.0d";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone           = 0;
    errHelp           = 1;
    errIllegalParm    = 2;
    errUnknownOpt     = 3;
    errRange          = 4;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    (*
     00000000011111111112222222222333333333344444444445555555555666666666677777777778
     1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
    *)
    helpmsg =
    Banner+nl+
    nl+
    "Syntax : "+ProgEXEname+" [option]..."+nl+
    nl+
    "    -p   show palette until keypress or 10 seconds"+nl+
    "    -w   show world until keypress or 10 seconds"+nl+
    "    -s:# sky color (default is black)"+nl+
    "    -a   absolute altitude (do not stick to ground)"+nl+
    "    -h:# initial altitude above ground (default=100)"+nl+
    "    -r   random autopilot"+nl+
    "    -z   end on mouseclick too"+nl+
    "    -c:# color palette"+nl+
    "    -f   smoother (but ugly) display"+nl+
    nl+
    "This program is a poor man's Comanche demo ;-)"+nl+
    "By the way : the Novalogic Comanche series was excellent."+nl+
    nl+
    "left/right, up/down=forwards/backwards, pgUp/pgDn=altitude, /=toggle smoothing"+nl+
    "*=toggle absolute_altitude/stick_to_ground, r=toggle auto, Space, Escape/Enter"+nl+
    nl+
    "This code, although greatly cleaned, rewritten and enhanced, was based upon"+nl+
    "very rough MODULA-2 code found in XTDLI104.ZIP archive created by"+nl+
    "a Marco van de Voort, who himself had ported PASCAL code by a Bas van Gaalen."+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errIllegalParm :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," parameter !");
    | errUnknownOpt :
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errRange :
        Str.Concat(S,"Value for ",einfo);
        Str.Append(S," not in legal range !");

    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        (* nada *)
    ELSE
        WrStr(ProgEXEname+" : ");
        WrStr(S);
        WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    hires = 13H; (* 320x200x256 *)
    text  = 03H; (* 80x25 *)
    xcount = 320;
    ycount = 200;
    xmin = 0;
    xmax = xcount-1;
    ymin = 0;
    ymax = ycount-1;
    xcenter = xmax DIV 2;
    ycenter = ymax DIV 2;
    screensize = xcount * ycount;

VAR
    videoscreen [0A000H:0000H] : ARRAY [0..screensize-1] OF BYTE;
    Ybase : ARRAY [ymin..ymax] OF CARDINAL;

PROCEDURE initYbase ();
VAR
    i,p:CARDINAL;
BEGIN
    p := 0;
    FOR i := ymin TO ymax DO
        Ybase[i]:=p;
        INC(p,xcount);
    END;
END initYbase;

PROCEDURE setVideoMode (mode:CARDINAL);
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AH := 00H;
    R.AL := BYTE(mode);
    Lib.Intr(R,10H);
END setVideoMode;

PROCEDURE setDAC(index:CARDINAL;red,green,blue:BYTE);
CONST
    DACWriteIndex  = 03C8H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACWriteIndex,SHORTCARD(index));
    SYSTEM.Out (DACDataRegister, red);
    SYSTEM.Out (DACDataRegister, green);
    SYSTEM.Out (DACDataRegister, blue);
END setDAC;

PROCEDURE WaitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END WaitVGAretrace;

PROCEDURE getrndrange (lower,upper:INTEGER):INTEGER;
VAR
    range : INTEGER;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN INTEGER(rnd);
END getrndrange;

PROCEDURE waitKeyboardCode (  ):CARDINAL;
VAR
    c1,c2:CHAR;
BEGIN
    REPEAT
    UNTIL BiosIO.KeyPressed();
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    RETURN ORD(c1)*256 + ORD(c2);
END waitKeyboardCode;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := ORD(c1)*256 + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE input (  );
VAR
    keycode:CARDINAL;
    h,m,s,ss:CARDINAL;
    start : LONGINT;
    now   : LONGINT;
BEGIN
    Lib.GetTime(h,m,s,ss);
    start := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
    LOOP
        IF getKeyboardCode(keycode) THEN EXIT; END;
        Lib.GetTime(h,m,s,ss);
        now := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
        IF ABS(now-start) > maxWait THEN EXIT; END;
    END;
END input;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    palettetype = (normalpal,darkerpal,martianpal,redpal,greenpal,
    terrain1,terrain2,terrain3);
CONST
    minpal = ORD(normalpal);
    maxpal = ORD(terrain3);
VAR
    palette : palettetype;

PROCEDURE blend (ndx,count:CARDINAL; startink, endink:LONGCARD);
CONST
    rshift = LONGCARD(16);
    gshift = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    i : CARDINAL;
BEGIN
    r1 := INTEGER (startink >> rshift) MOD 40H;
    g1 := INTEGER (startink >> gshift) MOD 40H;
    b1 := INTEGER (startink          ) MOD 40H;
    r2 := INTEGER (endink   >> rshift) MOD 40H;
    g2 := INTEGER (endink   >> gshift) MOD 40H;
    b2 := INTEGER (endink            ) MOD 40H;

    FOR i := 1 TO count DO
        r := r1 + ((r2 - r1) * INTEGER(i) ) DIV INTEGER(count);
        g := g1 + ((g2 - g1) * INTEGER(i) ) DIV INTEGER(count);
        b := b1 + ((b2 - b1) * INTEGER(i) ) DIV INTEGER(count);
        IF r < 0 THEN r:=0; END;
        IF g < 0 THEN g:=0; END;
        IF b < 0 THEN b:=0; END;
        IF r > 3FH THEN r:=3FH; END;
        IF g > 3FH THEN g:=3FH; END;
        IF b > 3FH THEN b:=3FH; END;
        setDAC(ndx+i-1,BYTE(r),BYTE(g),BYTE(b));
    END;
END blend;

PROCEDURE swap (VAR a,b:INTEGER );
VAR
    tmp : INTEGER;
BEGIN
    IF b < a THEN
        tmp := a;
        a   := b;
        b   := tmp;
    END;
END swap;

PROCEDURE zblend (ndx,count:CARDINAL; startink, endink:LONGCARD);
CONST
    rshift = LONGCARD(16);
    gshift = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    i : CARDINAL;
BEGIN
    r1 := INTEGER (startink >> rshift) MOD 256;
    g1 := INTEGER (startink >> gshift) MOD 256;
    b1 := INTEGER (startink          ) MOD 256;
    r2 := INTEGER (endink   >> rshift) MOD 256;
    g2 := INTEGER (endink   >> gshift) MOD 256;
    b2 := INTEGER (endink            ) MOD 256;

    FOR i := 1 TO count DO
        r := r1 + ((r2 - r1) * INTEGER(i) ) DIV INTEGER(count);
        g := g1 + ((g2 - g1) * INTEGER(i) ) DIV INTEGER(count);
        b := b1 + ((b2 - b1) * INTEGER(i) ) DIV INTEGER(count);

        setDAC(ndx+i-1,BYTE(r >>2 ),BYTE(g>>2 ),BYTE(b>>2 ));
    END;
END zblend;

CONST
    black       = LONGCARD(0000000H);
    white       = LONGCARD(03F3F3FH); (* ega/vga range is $00..$3F *)
    red         = LONGCARD(03F0000H);
    green       = LONGCARD(0003F00H);
    darkgreen   = LONGCARD(0002000H);
    blue        = LONGCARD(000003FH);
    darkblue    = LONGCARD(0000020H);
    yellow      = LONGCARD(03F3F00H);
    darkred     = LONGCARD(0200000H);
    orange      = LONGCARD(02F2F00H);
CONST
    blanc       = LONGCARD(0F7F3FBH);
    blancmoyen  = LONGCARD(0CFC3BAH);
    marronclair = LONGCARD(0CFA665H);
    marronfonce = LONGCARD(0AE8665H);
    vertclair   = LONGCARD(000EF00H);
    vertfonce   = LONGCARD(000B600H);

PROCEDURE reduce (rr,gg,bb:CARDINAL; VAR r,g,b:BYTE);
BEGIN
    r := BYTE ( rr << 1);
    g := BYTE ( gg << 1);
    b := BYTE ( bb << 1);
END reduce;

PROCEDURE newPalette (  );
VAR
    ndx,n,i,j : CARDINAL;
    r,g,b:BYTE;
BEGIN
    CASE palette OF
    | normalpal :
        ndx := 0;         n := 32;
        blend (ndx,n,darkblue,blue);

        INC(ndx,n);       n := 32;
        blend (ndx,n,darkgreen,green);

        INC(ndx,n);       n := 32;
        blend (ndx,n,green,yellow);

        INC(ndx,n);       n := 16;
        blend (ndx,n,yellow,red);

        INC(ndx,n);       n := 16;
        blend (ndx,n,red,white);
    | darkerpal:
        ndx := 0;         n := 32;
        blend (ndx,n,darkblue,blue);

        INC(ndx,n);       n := 64;
        blend (ndx,n,darkgreen,green);

        INC(ndx,n);       n := 8;
        blend (ndx,n,green,orange);

        INC(ndx,n);       n := 16;
        blend (ndx,n,orange,red);

        INC(ndx,n);       n := 8;
        blend (ndx,n,red,yellow);
    | martianpal:
        ndx := 0;         n := 32;
        blend (ndx,n,darkblue,blue);

        INC(ndx,n);       n := 48;
        blend (ndx,n,orange,red);

        INC(ndx,n);       n := 32;
        blend (ndx,n,red,yellow);

        INC(ndx,n);       n := 16;
        blend (ndx,n,yellow,white);
    | redpal:
        ndx := 0;         n := 16;
        blend (ndx,n,01F1F03H,02F0804H);

        INC(ndx,n);       n := 48;
        blend (ndx,n,02F0804H,03F2F2FH);

        INC(ndx,n);       n := 64;
        blend (ndx,n,03F2F2FH,03F3F3FH);
    | greenpal:
        ndx := 0;         n := 16;
        blend (ndx,n,00F1F03H,0082F04H);

        INC(ndx,n);       n := 64;
        blend (ndx,n,0082F04H,01F3F1FH);

        INC(ndx,n);       n := 48;
        blend (ndx,n,01F3F1FH,03F3F3FH);
    | terrain1:
        ndx := 0;         n := 64;
        zblend (ndx,n,marronfonce,marronclair);
        INC(ndx,n);       n := 64;
        zblend (ndx,n,marronclair,blanc);
    | terrain2:
        ndx := 0;         n := 32;
        zblend (ndx,n,vertclair,vertfonce);
        INC(ndx,n);       n := 48;
        zblend (ndx,n,marronclair,blancmoyen);
        INC(ndx,n);       n := 48;
        zblend (ndx,n,blancmoyen,blanc);
    | terrain3:
        ndx := 0;         n := 32;
        blend (ndx,n,darkblue,blue);
        INC(ndx,n);       n := 40;
        zblend (ndx,n,vertclair,vertfonce);
        INC(ndx,n);       n := 24;
        zblend (ndx,n,marronclair,blancmoyen);
        INC(ndx,n);       n := 32;
        zblend (ndx,n,blancmoyen,blanc);
    END;
END newPalette;

(* ------------------------------------------------------------ *)

TYPE
    skycolortype = (skyblack,skyblue,skyred,skyblueR,skyredR);
VAR
    skycolor : skycolortype;

PROCEDURE newSkyPalette (  );
VAR
    n : CARDINAL;
    ndx : CARDINAL;
BEGIN
    (* default is black for 128..255 and 0 *)
    FOR n := 1 TO 128 DO
        setDAC(128+n-1,00H,00H,00H);
    END;
    setDAC(0,00H,00H,00H);

    CASE skycolor OF
    | skyblack :
        (* done *)
    | skyblue  :
        ndx := 128;         n := ymax DIV 2;
        blend (ndx,n,darkblue,blue);
    | skyred   :
        ndx := 128;         n := ymax DIV 2;
        blend (ndx,n,darkred,red);
    | skyblueR  :
        ndx := 128;         n := ymax DIV 2;
        blend (ndx,n,blue,darkblue);
    | skyredR   :
        ndx := 128;         n := ymax DIV 2;
        blend (ndx,n,red,darkred);
    END;
END newSkyPalette;

PROCEDURE showPalette (  );
VAR
   i    : CARDINAL;
   xpos : CARDINAL;
   ypos : CARDINAL;
   p    : CARDINAL;
BEGIN
   Fill(ADR(videoscreen[0]),screensize,00H); (* index of sky, so black *)
   FOR i := 0 TO 255 DO
       FOR ypos := ymin TO ymax DO
           p := ypos * xcount + i ;
           videoscreen[p]:=BYTE(i);
       END;
   END;
   input;
END showPalette;

(* ------------------------------------------------------------ *)

CONST
    degToRad = REAL(3.1415 / 180.0);

PROCEDURE sinus (alphadeg:INTEGER):REAL;
BEGIN
    RETURN REAL(MATHLIB.Sin(LONGREAL(REAL(alphadeg)*degToRad)));
END sinus;

PROCEDURE cosinus (alphadeg:INTEGER):REAL;
BEGIN
    RETURN REAL(MATHLIB.Cos(LONGREAL(REAL(alphadeg)*degToRad)));
END cosinus;

(* ------------------------------------------------------------ *)

CONST
    ROUGHNESS   = 4; (* 4 *)
    RANDOMRANGE = 2; (* 2 *)

CONST
    worldside = 256;  (* world is a square *)
    worldsize = worldside*worldside-1; (* 65535=256*256-1 *)
TYPE
    worldType  = ARRAY [0..worldsize -1] OF BYTE; (* 256*256...< 64Kb *)
    screenType = ARRAY [0..screensize-1 +1] OF BYTE;   (* 320x200=64000 with security *)

VAR
    World      : POINTER TO worldType;
    Screen     : POINTER TO screenType;
    SmoothScreen:POINTER TO screenType;

    ScreenLine : ARRAY[xmin..xmax] OF BYTE;

PROCEDURE allocateThem;
BEGIN
    NEW(World);
    NEW(Screen);
    NEW(SmoothScreen);
END allocateThem;

PROCEDURE newColorIndex(mc,n,dvd:INTEGER):BYTE; (* based on average colors plus a random value *)
CONST
    minink = 5;
    maxink = 250;
VAR
    ink:INTEGER;
BEGIN
    ink:=(mc+n-INTEGER( Lib.RANDOM(RANDOMRANGE*n))) DIV dvd;
    IF ink > maxink THEN ink := maxink; END;
    IF ink < minink THEN ink := minink; END;
    RETURN BYTE(ink);
END newColorIndex;

PROCEDURE Plasma(x1,y1,x2,y2:CARDINAL);
VAR
    xn,yn,dxy   : CARDINAL;
    ink1,ink2,ink3,ink4 : CARDINAL;
BEGIN
    IF (x2-x1<2) AND (y2-y1<2) THEN RETURN; END;

    ink1:=CARDINAL(World^[worldside*y1+x1]); (* color of x1,y1 *)
    ink2:=CARDINAL(World^[worldside*y2+x1]); (* color of x1,y2 *)
    ink3:=CARDINAL(World^[worldside*y1+x2]); (* color of x2,y1 *)
    ink4:=CARDINAL(World^[worldside*y2+x2]); (* color of x2,y2 *)

    xn:=(x1+x2) >> 1; (* fast DIV 2 *)
    yn:=(y1+y2) >> 1; (* fast DIV 2 *)

    dxy:=5*(x2-x1+y2-y1) DIV 3;

    IF World^[worldside*y1+xn]=BYTE(0) THEN
        World^[worldside*y1+xn]:=newColorIndex(ink1+ink3,dxy,2);
    END;
    IF World^[worldside*yn+x1]=BYTE(0) THEN
        World^[worldside*yn+x1]:=newColorIndex(ink1+ink2,dxy,2);
    END;
    IF World^[worldside*yn+x2]=BYTE(0) THEN
        World^[worldside*yn+x2]:=newColorIndex(ink3+ink4,dxy,2);
    END;
    IF World^[worldside*y2+xn]=BYTE(0) THEN
        World^[worldside*y2+xn]:=newColorIndex(ink2+ink4,dxy,2);
    END;

    World^[worldside*yn+xn]    :=newColorIndex(ink1+ink2+ink3+ink4,dxy,ROUGHNESS);
    Plasma(x1,y1,xn,yn);
    Plasma(xn,y1,x2,yn);
    Plasma(x1,yn,xn,y2);
    Plasma(xn,yn,x2,y2);
END Plasma;

PROCEDURE newWorld ();
BEGIN
    Fill(ADR(World^),worldsize,0); (* does not like worldsize-1 here *)

    (* set the corners even though probably useless *)

    World^[                  0]:= BYTE(getrndrange(1,127)); (* color indexes *)
    World^[          worldside]:= BYTE(getrndrange(1,127));
    World^[worldside*worldside]:= BYTE(getrndrange(1,127));
    World^[          worldsize]:= BYTE(getrndrange(1,127));

    Plasma(0,0,255+1,255+1); (* +1 required ??? *)
END newWorld;

PROCEDURE showWorld (  );
VAR
   i    : CARDINAL;
   xpos : CARDINAL;
   ypos : CARDINAL;
   p    : CARDINAL;
   ofs  : CARDINAL;
BEGIN
   Fill(ADR(videoscreen[0]),screensize,00H); (* index of sky, so black *)
   ofs := (xcount-256) DIV 2;
   i := 0;
   FOR ypos := ymin TO ymax DO
       FOR xpos := 0 TO 255 DO
           (* p := ypos * xcount + xpos; *)
           videoscreen[ ofs+xpos+Ybase[ypos] ]:=World^[i];
           INC(i);
       END;
   END;
   input;

   (* show part remaining *)

   i :=worldside*(worldside-ymax);

   Fill(ADR(videoscreen[0]),screensize,00H); (* index of sky, so black *)
   FOR ypos := ymin TO ymax DO
       FOR xpos := 0 TO 255 DO
           (* p := ypos * xcount + xpos; *)
           videoscreen[ ofs+xpos+Ybase[ypos] ]:=World^[i];
           INC(i);
       END;
   END;
   input;
END showWorld;

(* ------------------------------------------------------------ *)

PROCEDURE smoothIt (  );
VAR
    x,y:CARDINAL;
    ink,inkl,inkr,inku,inkd:CARDINAL;
    inklu,inkld,inkru,inkrd:CARDINAL;
    p:CARDINAL;
BEGIN
    Fill(ADR(SmoothScreen^),screensize,0);

    FOR y := ymin+1 TO ymax-1 DO
        p := Ybase[y]; (* was xcount * y *)
        FOR x := xmin+1 TO xmax-1 DO
            ink :=CARDINAL(Screen^[p+x])   ;

            inkl:=CARDINAL(Screen^[p+x-1]) ;
            inkr:=CARDINAL(Screen^[p+x+1]) ;

            inku:=CARDINAL(Screen^[p+x-xcount]) ;
            inkd:=CARDINAL(Screen^[p+x+xcount]) ;
(*
            inklu:=CARDINAL(Screen^[p+x-1-xcount]) ;
            inkru:=CARDINAL(Screen^[p+x+1-xcount]) ;
            inkld:=CARDINAL(Screen^[p+x-1+xcount]) ;
            inkrd:=CARDINAL(Screen^[p+x+1+xcount]) ;
            ink := (ink + inkl +inkr + inku + inkd + inklu+inkru+inkld+inkrd ) DIV 5;
*)
            ink := (ink + inkl +inkr + inku + inkd ) DIV 5;
            SmoothScreen^[p+x]:=BYTE(ink);
        END;
    END;
    FarWordMove(FarADR(SmoothScreen^),FarADR(Screen^),screensize DIV 2);
END smoothIt;

PROCEDURE Draw(xp,yp,AlphaDeg,altitude:INTEGER;stick,smooth:BOOLEAN);
CONST
    (*
    won't bother to find out what these values correspond to :
    maybe someday ? after all, MvdV AND BvG did not bother either !
    *)

    ke = xmin;  (* left limit *)
    kc = xmax;  (* right limit, was xmax-2 *)
    kh = 30;    (* flattening / individual voxel h ? *)
    kf = 360;   (* field of view *)
    kd = xmax DIV 6;    (* was 55 *)
    kg = xmax DIV 6;    (* voxel w ? was 47 *)

    ka = 4;
    kb = xmax - ka; (* was -20 *)

VAR
    z,zobs,ix,iy,iy1,iyp,ixp,xpos,ypos,s,csf,snf,MPc,i,j:INTEGER;

    vtab,posvtab:CARDINAL;
    inkvtab:BYTE;
BEGIN
    Fill(ADR(ScreenLine),SIZE(ScreenLine),ycount);

    zobs:=altitude; (* absolute flight altitude *)
    IF stick THEN INC(zobs,INTEGER(World^[worldside*yp+xp])); END; (* stick to ground at constant altitude *)

    csf:=INTEGER( 256.0 * cosinus(AlphaDeg));
    snf:=INTEGER( 256.0 * sinus  (AlphaDeg));

    CASE skycolor OF
    | skyblack:
        Fill(ADR(Screen^),screensize,0);
    ELSE
        posvtab:=0;
        inkvtab:=128;
        FOR vtab := ymin TO (ymax DIV 2) DO
            Fill(ADR(Screen^[posvtab]),xcount,inkvtab);
            INC(posvtab,xcount);
            Fill(ADR(Screen^[posvtab]),xcount,inkvtab);
            INC(posvtab,xcount);
            INC(inkvtab);
        END;
    END;

    FOR iy:=yp TO yp+kd DO
        iy1 := 1+2*(iy-yp);
        s   := ka+kb DIV iy1;
        FOR ix:=xp+yp-iy TO xp-yp+iy DO
            ixp:=xp+((ix-xp)*csf+(iy-yp)*snf) >> 8;
            iyp:=yp+((iy-yp)*csf-(ix-xp)*snf) >> 8;
            xpos:=xcenter+kf*(ix-xp) DIV iy1;
            IF (xpos>=ke) AND (xpos+s<=kc) THEN
               z:=INTEGER(World^[iyp << 8+ixp]);
               MPc:=z >> 1;
               IF z < kg THEN
                   z:=kg-1;
               END;
               ypos:=ycenter+(zobs-z)*kh DIV iy1;
               IF (ypos<=ymax) AND (ypos>=ymin) THEN
                   FOR j:=xpos TO xpos+s DO
                       FOR i:=ypos TO INTEGER(ScreenLine[j]) DO
                           Screen^[xcount*i+j]:=BYTE(MPc);
                       END;
                       IF BYTE(ypos)<ScreenLine[j] THEN
                           ScreenLine[j]:=BYTE(ypos)
                       END;
                   END;
               END;
            END;
        END;
    END;
    IF smooth THEN smoothIt; END;
    FarWordMove(FarADR(Screen^),[0A000H:0],screensize DIV 2);
END Draw;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE newval (VAR val:INTEGER; plus, min,max : INTEGER);
VAR
    v:INTEGER;
BEGIN
    v := val+plus;
    IF ((v < min) OR (v > max)) THEN

    ELSE
        val := v;
    END;
END newval;

PROCEDURE ivalue (S:ARRAY OF CHAR;min,max:INTEGER;VAR r:INTEGER):BOOLEAN;
VAR
    v : LONGINT;
BEGIN
    IF GetLongInt(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGINT(min) THEN RETURN FALSE; END;
    IF v > LONGINT(max) THEN RETURN FALSE; END;
    r := INTEGER(v);
    RETURN TRUE;
END ivalue;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

(* ------------------------------------------------------------ *)

CONST
    upArrow    = 00048H;
    downArrow  = 00050H;
    rightArrow = 0004DH;
    leftArrow  = 0004BH;
    pageUp     = 00049H;
    pageDown   = 00051H;
    escape     = 01B00H;
    space      = 02000H;
    keyMinus   = 02D00H; (* - *)
    keyStar    = 02A00H; (* * *)
    keyCR      = 00D00H;
    keySlash   = 02F00H; (* / *)
    keyUpperR  = ORD("R") << 8;
    keyLowerR  = ORD("r") << 8;
CONST
    kTurn       = 1;
    kMotion     = REAL(2.0); (* less would be useless ! *)
    kAltitude   = 5;
    minAltitude = 5;
    maxAltitude = 555;
    defaultAltitude = 100;
VAR
    flagPalette : BOOLEAN;
    flagWorld   : BOOLEAN;
    keycode     : CARDINAL;
    stick       : BOOLEAN;
    smooth      : BOOLEAN;
    xpos        : INTEGER;
    ypos        : INTEGER;
    dx          : INTEGER;
    dy          : INTEGER;
    AlphaDeg    : INTEGER;
    altitude    : INTEGER;
    motion      : (forward,backward,turnright,turnleft);
    pause       : BOOLEAN;
    auto        : BOOLEAN;
    autocount   : CARDINAL;
    autoturn    : CARDINAL;
    stopmouse   : BOOLEAN;
VAR
    parmcount   : CARDINAL;
    i           : CARDINAL;
    opt         : CARDINAL;
    S           : str128;
    R           : str128;
    v           : INTEGER;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;                       (* must be here for pretty ulterior display ! *)

    flagPalette  := FALSE;
    flagWorld    := FALSE;
    skycolor     := skyblue;
    stick        := TRUE;
    smooth       := FALSE;
    altitude     := defaultAltitude;
    auto         := FALSE;
    stopmouse    := FALSE;
    palette      := terrain3;

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "P"+delim+"PALETTE"+delim+
                                   "W"+delim+"WORLD"+delim+
                                   "S:"+delim+"SKY:"+delim+
                                   "A"+delim+"ABSOLUTE"+delim+
                                   "H:"+delim+"ALTITUDE:"+delim+
                                   "R"+delim+"RANDOM"+delim+
                                   "Z"+delim+"MOUSE"+delim+
                                   "C:"+delim+"COLORS:"+delim+
                                   "F"+delim+"SMOOTH"
                               );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5 :
                flagPalette := TRUE;
            | 6,7 :
                flagWorld   := TRUE;
            | 8,9 :
                IF ivalue(R,ORD(skyblack),ORD(skyredR),v)=FALSE THEN
                    abort(errRange,"sky color");
                END;
                skycolor:=skycolortype(v);
            | 10,11 :
                stick := FALSE;
            | 12,13:
                IF ivalue(R,minAltitude,maxAltitude,altitude)=FALSE THEN
                    abort(errRange,"maximum speed");
                END;
            | 14,15 :
                auto:=TRUE;
            | 16,17:
                stopmouse:=TRUE;
            | 18,19:
                IF ivalue(R,minpal,maxpal,v)=FALSE THEN
                    abort(errRange,"palette");
                END;
                palette:=palettetype(v);
            | 20,21 :
                smooth := TRUE;
            ELSE
                abort(errUnknownOpt,S);
            END;
        ELSE
            abort(errIllegalParm,S);
        END;
    END;

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    initYbase;

    Lib.RANDOMIZE;
    setVideoMode(hires);

    allocateThem;

    newPalette;
    newSkyPalette;
    IF flagPalette THEN showPalette; END;

    newWorld;
    IF flagWorld THEN showWorld; END;

    flushKeyboard;

    xpos      := xcenter;
    ypos      := ycenter;
    AlphaDeg  := 0;
    motion    := forward;
    pause     := FALSE;

    autocount := 0;
    autoturn  := 0;

    LOOP
        WaitVGAretrace;
        Draw(xpos,ypos,AlphaDeg,altitude,stick,smooth);
        IF auto THEN
            INC(autocount);
            INC(autoturn);
            CASE motion OF
            | forward :
                IF autocount >= 100 THEN
                    autocount := 0;
                    autoturn  := getrndrange(5,50);
                    CASE getrndrange(1,10) OF
                    | 1..3 : motion := turnleft;
                    | 8..10: motion := turnright;
                    END;
                END;
            | turnleft,turnright :
                IF autoturn >= 50 THEN
                    autocount := 0;
                    autoturn  := getrndrange(5,50);
                    CASE getrndrange(1,10) OF
                    | 1..2 : motion := forward;
                    END;
                END;
            | backward:
                IF autocount >= 100 THEN
                    autocount := 0;
                    autoturn  := getrndrange(5,50);
                    CASE getrndrange(1,10) OF
                    | 1..2 : motion := turnleft;
                    | 9..10: motion := turnright;
                    | 5    : motion := forward;
                    END;
                END;

            END;
        END;
        IF getKeyboardCode(keycode) THEN
            CASE keycode OF
            | downArrow  : motion := backward;
            | upArrow    : motion := forward;
            | rightArrow : motion := turnright;
            | leftArrow  : motion := turnleft;
            | pageUp     : newval(altitude, kAltitude,  minAltitude,maxAltitude);
            | pageDown   : newval(altitude,-kAltitude,  minAltitude,maxAltitude);
            | keyStar    : stick  := NOT(stick);
            | space      : pause:=NOT(pause);
            | keySlash   : smooth := NOT (smooth);
            | keyUpperR,keyLowerR: auto:=NOT(auto);
            | escape,keyCR : EXIT;
            END;
            IF keycode # space THEN pause := FALSE; END;
        END;
        IF pause=FALSE THEN
            CASE motion OF
            | turnright :
                INC(AlphaDeg,kTurn); AlphaDeg := AlphaDeg MOD 360;
            | turnleft :
                DEC(AlphaDeg,kTurn); AlphaDeg := AlphaDeg MOD 360;
            | forward :
                dx := INTEGER( kMotion *sinus  (AlphaDeg));
                dy := INTEGER( kMotion *cosinus(AlphaDeg));
                INC(xpos,dx);
                INC(ypos,dy);
            | backward :
                dx := INTEGER( kMotion *sinus  (AlphaDeg));
                dy := INTEGER( kMotion *cosinus(AlphaDeg));
                DEC(xpos,dx);
                DEC(ypos,dy);
            END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;
    END;
    setVideoMode(text);

    abort(errNone,"");
END Voxel.

