(* --------------------------------------------------------------
Title         Q&D Stars
Author        PhG
Overview      tsk tsk...
Usage         see help
Notes         
              not very pretty.. :-(
              could experiment random density for birth ?
              mode should be at last LARGE
              threshold must be set at 16384
              ugly hyperdrive, for we should use a linked list of positions
              and maybe completely forbid creation of stars while trailing
Bugs          seems there are remnant stars sometimes...

Wish List     tsk tsk...
--------------------------------------------------------------- *)

MODULE Warp;

IMPORT Lib;
IMPORT IO;
IMPORT Str;
IMPORT SYSTEM;
IMPORT MsMouse;
IMPORT BiosIO;
IMPORT MATHLIB;

FROM IO IMPORT WrStr,WrLn,WrCard;

FROM ModeX IMPORT
Mode_320x200,Mode_320x400,Mode_360x200,Mode_360x400,
Mode_320x240,Mode_320x480,Mode_360x240,Mode_360x480,
SET_VGA_MODEX, SET_MODEX, CLEAR_VGA_SCREEN, SET_POINT, READ_POINT,
FILL_BLOCK, DRAW_LINE, SET_DAC_REGISTER, GET_DAC_REGISTER,
LOAD_DAC_REGISTERS, READ_DAC_REGISTERS,
SET_ACTIVE_PAGE, GET_ACTIVE_PAGE, SET_DISPLAY_PAGE, GET_DISPLAY_PAGE,
SET_WINDOW, GET_X_OFFSET, GET_Y_OFFSET, SYNC_DISPLAY,
GPRINTC, TGPRINTC, PRINT_STR, TPRINT_STR,
SET_DISPLAY_FONT, DRAW_BITMAP, TDRAW_BITMAP, COPY_PAGE, COPY_BITMAP,
mxTrue, mxFalse, mxnil,
c_BLACK, c_BLUE, c_GREEN, c_CYAN, c_RED, c_PURPLE, c_BROWN, c_WHITE,
c_GREY, c_bBLUE, c_bGREEN, c_bCYAN, c_bRED, c_bPURPLE, c_YELLOW, c_bWHITE,
c_BRIGHT,
Ky_F1, Ky_F2, Ky_F3, Ky_F4, Ky_F5, Ky_F6, Ky_F7, Ky_F8, Ky_F9, Ky_F10,
Ky_Up, Ky_Left, Ky_Right, Ky_Down,
Ky_SUp, Ky_SLeft, Ky_SRight, Ky_SDown,
Ky_Home, Ky_End, Ky_PgUp, Ky_PgDn,
Ky_SHome, Ky_SEnd, Ky_SPgUp, Ky_SPgDn,
Ky_Ins, Ky_Del, Ky_SIns, Ky_SDel, Ky_Tab, Ky_RvsTab, Ky_STab,
Ky_BS, Ky_CR, Ky_ESC, Ky_Clr, Ky_Plus, Ky_Minus,
Ky_AltA, Ky_AltB, Ky_AltC, Ky_AltD, Ky_AltE, Ky_AltF, Ky_AltG,
Ky_AltH, Ky_AltI, Ky_AltJ, Ky_AltK, Ky_AltL, Ky_AltM, Ky_AltN,
Ky_AltO, Ky_AltP, Ky_AltQ, Ky_AltR, Ky_AltS, Ky_AltT, Ky_AltU,
Ky_AltV, Ky_AltW, Ky_AltX, Ky_AltY, Ky_AltZ,
DOS_PRINT, DOS_PRINTS, SET_VIDEO_MODE,
SCAN_KEYBOARD, RANDOM_INT, INIT_RANDOM, INT_SQR, TIMER_COUNT;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim, str16,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows, cleantabs,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    V100 = FALSE; (* if TRUE, revert to v1.0 uglier hyperdrive *)
CONST
    ProgEXEname   = "WARP";
    ProgTitle     = "Q&D Stars demo";
    credit        = "(public domain Mode X v1.04 library by Matt Pritchard)";

(*%F V100  *)
    ProgVersion   = "v1.0b";
(*%E  *)
(*%T V100  *)
    ProgVersion   = "v1.0";
(*%E  *)
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone           = 0;
    errHelp           = 1;
    errIllegalParm    = 2;
    errUnknownOpt     = 3;
    errRange          = 4;
    errCannotSetModeX = 5;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr         = CHR(13);
    lf         = CHR(10);
    nl         = cr+lf;
CONST
    (*
     00000000011111111112222222222333333333344444444445555555555666666666677777777778
     1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
    *)
    helpmsg =
    Banner+nl+
    nl+
    credit+nl+
    nl+
    "Syntax : "+ProgEXEname+" [stars] [option]..."+nl+
    nl+
    "  -k    end on keypress only"+nl+
    "  -c    colored stars"+nl+
    "  -s:#  speed ([1..100], default is 10)"+nl+
    "  -x    320x240 video mode X (default is 360x480)"+nl+
    "  -r    random hyperdrive"+nl+
    "  -t:#  threshold percentage for random hyperdrive ([1..1000], default is 5)"+nl+
    "  -n:#  trails ([0..128], default is 64)"+nl+
    "  -o    use concentration"+nl+
    "  -a:#  concentration factor ([1..89], default is 45)"+nl+
    "  -v    verbose"+nl+
    nl+
    "Number of stars belongs to [1..3500] interval, default is 300."+nl+
    nl+
    "[PgUp|PgDn|*]  [Left|Right|/]  [Space]  [C]  [O]  [Escape|Enter]"+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errIllegalParm :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," parameter !");
    | errUnknownOpt :
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errRange :
        Str.Concat(S,"Value for ",einfo);
        Str.Append(S," not in legal range !");
    | errCannotSetModeX:
        Str.Concat(S,"Cannot set required ",einfo);
        Str.Append(S," video mode X !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ; (* nada *)
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE doRandomize (  );
BEGIN
    Lib.RANDOMIZE;
END doRandomize;

PROCEDURE getrndrange (lower,upper:CARDINAL):CARDINAL;
VAR
    range : CARDINAL;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN CARDINAL(rnd);
END getrndrange;

PROCEDURE getrndrangeint (lower,upper:INTEGER):INTEGER;
VAR
    range : INTEGER;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN INTEGER(rnd);
END getrndrangeint;

PROCEDURE value (S:ARRAY OF CHAR;min,max:CARDINAL;VAR r:CARDINAL):BOOLEAN;
VAR
    v : LONGCARD;
BEGIN
    IF GetLongCard(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGCARD(min) THEN RETURN FALSE; END;
    IF v > LONGCARD(max) THEN RETURN FALSE; END;
    r := CARDINAL(v);
    RETURN TRUE;
END value;

PROCEDURE ivalue (S:ARRAY OF CHAR;min,max:INTEGER;VAR r:INTEGER):BOOLEAN;
VAR
    v : LONGINT;
BEGIN
    IF GetLongInt(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGINT(min) THEN RETURN FALSE; END;
    IF v > LONGINT(max) THEN RETURN FALSE; END;
    r := INTEGER(v);
    RETURN TRUE;
END ivalue;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

CONST
    keyEscape  = 01B00H;
    keySpace   = 02000H;
    keyCR      = 00D00H;
    keyPageUp  = 00049H;
    keyPageDn  = 00051H;
    keyEnd     = 0004FH;
    keyHome    = 00047H;
    keyStar    = ORD("*") << 8 ;
    keyDivide  = ORD("/") << 8 ;
    keyDel     = 00800H;
    keyLeft    = 0004BH;
    keyRight   = 0004DH;
    keyUpperC  = ORD("C") << 8 ;
    keyLowerC  = ORD("c") << 8 ;
    keyUpperO  = ORD("O") << 8 ;
    keyLowerO  = ORD("o") << 8 ;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    xmin         = 0;
    ymin         = 0;
    viewpage     = 0;
    workpage     = 0;
    PagesVirtual = 1;
    zmin         = 0;

VAR
    sMode        : str16;
    hires        : CARDINAL;
    screenwidth  : CARDINAL;
    screenheight : CARDINAL;
    xmax         : CARDINAL;
    ymax         : CARDINAL;
    xMaxVirtual  : CARDINAL;
    yMaxVirtual  : CARDINAL;
    cx,cy        : INTEGER;
    zmax         : CARDINAL;
    (* to avoid casts *)
    iscreenwidth  : INTEGER;
    iscreenheight : INTEGER;
    ixmax         : INTEGER;
    iymax         : INTEGER;

PROCEDURE initHires (lores:BOOLEAN);
BEGIN
    IF lores THEN
        Str.Copy(sMode,"320x240x256");
        hires        := Mode_320x240;
        screenwidth  := 320;
        screenheight := 240;
        zmax         := screenwidth DIV 2; (* was screenheight, higher values are not pretty *)
    ELSE
        Str.Copy(sMode,"360x480x256");
        hires        := Mode_360x480;
        screenwidth  := 360;
        screenheight := 480;
        zmax         := screenwidth DIV 2;
    END;
    xmax        := screenwidth  -1;
    ymax        := screenheight -1;
    xMaxVirtual := screenwidth;
    yMaxVirtual := screenheight;
    cx          := INTEGER(xmax DIV 2);
    cy          := INTEGER(ymax DIV 2);
    (* to avoid casts *)
    iscreenwidth  := INTEGER(screenwidth);
    iscreenheight := INTEGER(screenheight);
    ixmax         := INTEGER(xmax);
    iymax         := INTEGER(ymax);
END initHires;


PROCEDURE HiresON ():BOOLEAN;
BEGIN
    RETURN (SET_VGA_MODEX(hires,xMaxVirtual,yMaxVirtual,PagesVirtual) # 0);
END HiresON;

PROCEDURE HiresOFF ();
CONST
    biostxtmode = 3;
BEGIN
    SET_VIDEO_MODE(biostxtmode);
END HiresOFF;

PROCEDURE ClearPage(paperindex:CARDINAL);
BEGIN
    CLEAR_VGA_SCREEN(paperindex);
END ClearPage;

PROCEDURE setviewwork (view,work:CARDINAL );
BEGIN
    SET_DISPLAY_PAGE(view);
    SET_ACTIVE_PAGE(work);
END setviewwork;

PROCEDURE WaitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END WaitVGAretrace;

(* ------------------------------------------------------------ *)

CONST
    ndxinkmin   = 0; (* 0 is reserved as black *)
    ndxinkmax   = 256-1;
    ndxinkblack = ndxinkmin;
    colorrange  = 64;
    colorpals   = 4;
CONST
    black       = LONGCARD(0000000H);
    white       = LONGCARD(03F3F3FH); (* ega/vga range is $00..$3F *)
    blue        = LONGCARD(000003FH);
    darkblue    = LONGCARD(0000020H);
    red         = LONGCARD(03F0000H);
    darkred     = LONGCARD(0200000H);
    green       = LONGCARD(0003F00H);
    darkgreen   = LONGCARD(0002000H);
    yellow      = LONGCARD(03F3F00H);
    orange      = LONGCARD(02F2F00H);
    cyan        = LONGCARD(0002F3FH);

PROCEDURE setDAC(index:CARDINAL;red,green,blue:BYTE);
CONST
    DACWriteIndex  = 03C8H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACWriteIndex,SHORTCARD(index));
    SYSTEM.Out (DACDataRegister, red);
    SYSTEM.Out (DACDataRegister, green);
    SYSTEM.Out (DACDataRegister, blue);
END setDAC;

PROCEDURE blend (ndx,count:CARDINAL; startink, endink:LONGCARD);
CONST
    egarange = 40H;  (* EGA/VGA is limited to $00..$3F *)
    rshift   = LONGCARD(16);
    gshift   = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    i : CARDINAL;
BEGIN
    r1 := INTEGER (startink >> rshift) MOD egarange;
    g1 := INTEGER (startink >> gshift) MOD egarange;
    b1 := INTEGER (startink          ) MOD egarange;
    r2 := INTEGER (endink   >> rshift) MOD egarange;
    g2 := INTEGER (endink   >> gshift) MOD egarange;
    b2 := INTEGER (endink            ) MOD egarange;

    FOR i := 1 TO count DO
        r := r1 + ((r2 - r1) * INTEGER(i) ) DIV INTEGER(count);
        g := g1 + ((g2 - g1) * INTEGER(i) ) DIV INTEGER(count);
        b := b1 + ((b2 - b1) * INTEGER(i) ) DIV INTEGER(count);
        IF r < 0 THEN r:=0; END;
        IF g < 0 THEN g:=0; END;
        IF b < 0 THEN b:=0; END;
        IF r > egarange-1 THEN r:=egarange-1; END;
        IF g > egarange-1 THEN g:=egarange-1; END;
        IF b > egarange-1 THEN b:=egarange-1; END;
        setDAC(ndx+i-1,BYTE(r),BYTE(g),BYTE(b));
    END;
END blend;

PROCEDURE MakePalette (multicolor:BOOLEAN);
VAR
    ndx : CARDINAL;
    n   : CARDINAL;
BEGIN
    WaitVGAretrace;
    IF multicolor THEN
        ndx := 0;                       n := 32;
        blend (ndx,n,darkblue,blue);
        INC(ndx,n);                     n := 32;
        blend (ndx,n,blue,white);

        INC(ndx,n);                     n := 32;
        blend (ndx,n,darkred,red);
        INC(ndx,n);                     n := 32;
        blend (ndx,n,red,white);

        INC(ndx,n);                     n := 32;
        blend (ndx,n,darkgreen,green);
        INC(ndx,n);                     n := 32;
        blend (ndx,n,green,white);

        INC(ndx,n);                     n := 32;
        blend (ndx,n,orange,yellow);
        INC(ndx,n);                     n := 32;
        blend (ndx,n,yellow,white);
    ELSE
        (* smooth from deep blue to white *)
        ndx := 0;
        n   := 128;
        blend (ndx,n,darkblue,blue);
        INC(ndx,n);
        blend (ndx,n,blue,white);
    END;
    setDAC(ndxinkblack, 00H,00H,00H); (* reset black *)
END MakePalette;

(* ------------------------------------------------------------ *)

CONST
    minfactor           = 1;
    maxfactor           = 89;
    defaultfactor       = 45;
    factorincrement     = 2;

    mintrails        = 0;
    maxtrails        = 128; (* should not be too big : 64 is already ugly, 255 leaves trails for too long a time *)
    defaultrails     = 64;

    firststar        = 1;
    maxstar          = 3500; (* more is overcrowded anyway ! *)
    defaultstar      = 300;
    starstep         = 50;

    minspeed         = 1;
    maxspeed         = 100;
    defaultspeed     = 10;
    speedstep        = 1;

    velocitymin      = 1;
    velocitymax      = 2;
    fademin          = 1;
    fademax          = 2;
    mindensity       = 1;
    maxdensity       = 1; (* too concentrated if 8 *)
    (* density should be 1 else result is stars in wave -- higher values should concentrate zone of births *)
    defaultdensity   = 1;

    minthreshold     = 1;
    maxthreshold     = 1000;
    defaultthreshold = 5;

TYPE
    starType = RECORD
        x        : INTEGER;
        y        : INTEGER;
        z        : INTEGER;
        velocity : CARDINAL; (* act upon z coor every velocity turn *)
        ink      : SHORTCARD;
        inklimit : SHORTCARD;
        fade     : CARDINAL;        (* act upon ink every fade turn *)
        lastxpos : CARDINAL;
        lastypos : CARDINAL;
        yestrail : BOOLEAN;
    END;
    arrayofstars = ARRAY[firststar..maxstar] OF starType;
VAR
    star      : arrayofstars;
    startrail : arrayofstars;

PROCEDURE newstar(i,d:CARDINAL;colored,yestrail:BOOLEAN);
VAR
    x,y,z,density,xpos,ypos : INTEGER;
    n : CARDINAL;
BEGIN
    density   := INTEGER(d);
    x         := getrndrangeint( -cx DIV density, cx DIV density );
    y         := getrndrangeint( -cy DIV density, cy DIV density );
    z         := zmax;
    star[i].x := x;
    star[i].y := y;
    star[i].z := z;
    star[i].velocity := getrndrange(velocitymin,velocitymax);
    IF colored THEN
        n                := getrndrange(0,colorpals-1); (* 0=blue, 1=red, 2=green *)
        star[i].inklimit := SHORTCARD( (n+1) * colorrange-1 );
        star[i].ink      := SHORTCARD( (n * colorrange) + getrndrange(0,colorrange-1) );
        star[i].fade     := colorpals * getrndrange(fademin,fademax);
    ELSE
        star[i].inklimit := ndxinkmax;
        star[i].ink      := SHORTCARD( getrndrange(ndxinkmin+32,ndxinkmax) ); (* begin at deep blue *)
        star[i].fade     := getrndrange(fademin,fademax);
    END;
    xpos             := cx +(iscreenwidth  * x DIV z);
    ypos             := cy +(iscreenheight * y DIV z);
    star[i].lastxpos := xpos;
    star[i].lastypos := ypos;
    star[i].yestrail := yestrail;
END newstar;

PROCEDURE initStars (last:CARDINAL;colored:BOOLEAN );
VAR
    i,density : CARDINAL;
BEGIN
    FOR i := firststar TO last DO
        (* density := getrndrange(mindensity,maxdensity); *)
        newstar(i,defaultdensity,colored,TRUE);
    END;
END initStars;

PROCEDURE updatestars (last,turn:CARDINAL;colored,usefactor:BOOLEAN;
                       sine,cosine:LONGREAL;
                       VAR trails:CARDINAL);
VAR
    i,density     : CARDINAL;
    xpos, ypos    : INTEGER;
    x,y,z         : INTEGER;
    ink,inklimit  : CARDINAL;
    fade,velocity : CARDINAL;
BEGIN
    FOR i := firststar TO last DO
        velocity := star[i].velocity;
        IF (turn MOD velocity) = 0 THEN
            xpos:=star[i].lastxpos;
   	        ypos:=star[i].lastypos;
(*%F V100 *)   	
   	        IF (trails=mintrails) OR (NOT(star[i].yestrail)) THEN
(*%E  *)
(*%T V100 *)   	
   	        IF (trails=mintrails) THEN
(*%E  *)   	
                SET_POINT(CARDINAL(xpos),CARDINAL(ypos),ndxinkblack); (* erase *)
            END;

            DEC (star[i].z);

            IF star[i].z > zmin THEN
                x    := star[i].x;
                y    := star[i].y;
                z    := star[i].z;
                IF usefactor THEN
     	            xpos := cx+ INTEGER (sine  *LONGREAL(iscreenwidth  * x)) DIV z;
  	                ypos := cy+ INTEGER (cosine*LONGREAL(iscreenheight * y)) DIV z;
                ELSE
     	            xpos := cx+ (iscreenwidth  * x DIV z);
  	                ypos := cy+ (iscreenheight * y DIV z);
  	            END;
            ELSE
                xpos := xmax+1;  (* force death of star *)
            END;
            IF (xpos < xmin) OR (xpos > ixmax) OR (ypos < ymin) OR (ypos > iymax) THEN
                (* density := getrndrange(mindensity,maxdensity); *)
(*%F V100  *)
                IF trails=mintrails THEN
	                newstar(i,defaultdensity,colored,TRUE); (* a star is born *)
	            ELSE
	                (* while trailing, new stars cannot leave a trail *)
	                newstar(i,defaultdensity,colored,FALSE);
	            END;
(*%E  *)	
(*%T V100  *)
	            newstar(i,defaultdensity,colored,TRUE); (* a star is born *)
(*%E  *)	

	            xpos := star[i].lastxpos;
	            ypos := star[i].lastypos;
            END;
            ink      := CARDINAL( star[i].ink );
            fade     := star[i].fade;
            inklimit := CARDINAL( star[i].inklimit );
            IF (turn MOD fade)=0 THEN
                IF ink < inklimit THEN
                    INC(ink);
                END;
                star[i].ink:=SHORTCARD(ink);
            END;
            SET_POINT(CARDINAL(xpos),CARDINAL(ypos),ink);
            star[i].lastxpos := xpos;
            star[i].lastypos := ypos;
        END;
    END;
    IF trails > mintrails THEN DEC(trails);END;
END updatestars;

PROCEDURE updatetrails (last,turn:CARDINAL;colored,usefactor:BOOLEAN;
                        sine,cosine:LONGREAL;
                        VAR trails:CARDINAL);
VAR
    i,density     : CARDINAL;
    xpos, ypos    : INTEGER;
    x,y,z         : INTEGER;
    velocity      : CARDINAL;
BEGIN
    FOR i := firststar TO last DO
        velocity := startrail[i].velocity;
        IF (turn MOD velocity) = 0 THEN
            xpos:=startrail[i].lastxpos;
   	        ypos:=startrail[i].lastypos;

            IF (xpos < xmin) OR (xpos > ixmax) OR (ypos < ymin) OR (ypos > iymax) THEN
                (* nothing to do *)
            ELSE
                SET_POINT(CARDINAL(xpos),CARDINAL(ypos),ndxinkblack); (* erase *)
            END;

            DEC (startrail[i].z);

            IF startrail[i].z > zmin THEN
                x    := startrail[i].x;
                y    := startrail[i].y;
                z    := startrail[i].z;
                IF usefactor THEN
     	            xpos := cx+ INTEGER (sine  *LONGREAL(iscreenwidth  * x)) DIV z;
  	                ypos := cy+ INTEGER (cosine*LONGREAL(iscreenheight * y)) DIV z;
                ELSE
     	            xpos := cx+ (iscreenwidth  * x DIV z);
  	                ypos := cy+ (iscreenheight * y DIV z);
  	            END;
            ELSE
                xpos := xmax+1;  (* force death of star *)
            END;
            startrail[i].lastxpos := xpos;
            startrail[i].lastypos := ypos;
        END;
    END;
    IF trails > mintrails THEN DEC(trails);END;
END updatetrails;

(* ------------------------------------------------------------ *)

VAR
    deg2rad : LONGREAL;

PROCEDURE inittrigo (  );
BEGIN
    deg2rad    := 4.0 * MATHLIB.ATan(1.0) / 180.0; (* pi/180 *)
END inittrigo;

PROCEDURE newsincos (angle:CARDINAL ;VAR sinus,cosinus:LONGREAL);
VAR
    alpha : LONGREAL;
BEGIN
    alpha := LONGREAL(angle) * deg2rad;
    sinus := MATHLIB.Sin( alpha );
    cosinus:=MATHLIB.Cos( alpha );
END newsincos;

(* ------------------------------------------------------------ *)

VAR
    parmcount   : CARDINAL;
    i           : CARDINAL;
    opt         : CARDINAL;
    S           : str128;
    R           : str128;
    v           : CARDINAL;

    stopmouse   : BOOLEAN;
    colored     : BOOLEAN;
    speed       : CARDINAL;
    laststar    : CARDINAL;
    verbose     : BOOLEAN;
    lores       : BOOLEAN;
    randomwarp  : BOOLEAN;

    turn        : CARDINAL;
    hyperdrive  : BOOLEAN;
    trails      : CARDINAL;
    reftrails   : CARDINAL;
    refturn     : CARDINAL;
    keycode     : CARDINAL;
    oldlaststar : CARDINAL;
    singlestep  : BOOLEAN;
    chk         : BOOLEAN;
    threshold   : CARDINAL;
    trailings   : CARDINAL;
    usefactor      : BOOLEAN;
    factor         : CARDINAL;
    sinfactor,cosfactor:LONGREAL;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;                       (* must be here for pretty ulterior display ! *)

    stopmouse    := TRUE;
    colored      := FALSE;
    speed        := defaultspeed;
    laststar     := defaultstar;
    verbose      := FALSE;
    lores        := FALSE;
    randomwarp   := FALSE;
    threshold    := defaultthreshold;
    trailings    := defaultrails;
    usefactor       := FALSE;
    factor          := defaultfactor;

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R); cleantabs(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "K"+delim+"KEYPRESS"+delim+
                                   "C"+delim+"COLORED"+delim+
                                   "S:"+delim+"SPEED:"+delim+
                                   "V"+delim+"VERBOSE"+delim+
                                   "X"+delim+"320X240"+delim+
                                   "R"+delim+"HYPERDRIVE"+delim+
                                   "T:"+delim+"THRESHOLD:"+delim+
                                   "N:"+delim+"TRAILS:"+delim+
                                   "A:"+delim+"ALPHA:"+delim+
                                   "O"+delim+"CONCENTRATION"
                               );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5 :
                stopmouse:=FALSE;
            | 6,7:
                colored := TRUE;
            | 8,9:
                IF value(R,minspeed,maxspeed,speed)=FALSE THEN
                    abort(errRange,"speed");
                END;
            | 10,11:
                verbose:=TRUE;
            | 12,13:
                lores := TRUE;
            | 14,15:
                randomwarp:=TRUE;
            | 16,17:
                IF value(R,minthreshold,maxthreshold,threshold)=FALSE THEN
                    abort(errRange,"threshold");
                END;
            | 18,19:
                IF value(R,mintrails,maxtrails,trailings)=FALSE THEN
                    abort(errRange,"number of trails");
                END;
            | 20,21:
                IF value(R,minfactor,maxfactor,factor)=FALSE THEN
                    abort(errRange,"concentration factor");
                END;
            | 22,23:
                usefactor := TRUE;
            ELSE
                abort(errUnknownOpt,S);
            END;
        ELSE
            Str.Prepend(R,"N:");
            IF value(R,firststar,maxstar,laststar)=FALSE THEN
                abort(errRange,"number of stars");
            END;
            (* abort(errIllegalParm,S); *)
        END;
    END;

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    doRandomize;

    initHires(lores);

    IF HiresON() = FALSE THEN
        HiresOFF;
        abort(errCannotSetModeX,sMode);
    END;
    setviewwork(viewpage,workpage);
    MakePalette(colored);
    ClearPage (ndxinkblack);

    initStars(laststar,colored);

    flushKeyboard();
    singlestep := FALSE;
    turn       := 0;
    hyperdrive := FALSE;
    trails     := mintrails;

    inittrigo();
    newsincos  (factor,sinfactor,cosfactor);

    LOOP
        (* WaitVGAretrace; *)
        Lib.Delay(speed); (* milliseconds *)

        updatestars ( laststar,turn,colored,
                      usefactor,sinfactor,cosfactor,trails);

        INC (turn);
        turn := turn MOD 256; (* just in case *)

        IF hyperdrive THEN
            IF trails=mintrails THEN
                updatetrails ( laststar,refturn,colored,
                               usefactor,sinfactor,cosfactor,reftrails);
                INC(refturn);
                refturn:=refturn MOD 256;
                IF reftrails=mintrails THEN
                    hyperdrive:=FALSE;
(*%T V100  *)
                    (* no longer useful thanks to yestrail field *)
                    ClearPage(ndxinkblack); (* avoid ugly remnants *)
(*%E  *)
                END;
            END;
        END;

        (* read and process key *)
        IF singlestep THEN
            WHILE getKeyboardCode(keycode)=FALSE DO
            END;
            chk:=(keycode # keySpace);
            singlestep:=NOT(chk);
        ELSE
            chk:=getKeyboardCode(keycode);
        END;
        IF chk THEN
            CASE keycode OF
            | keyEscape     : EXIT;
            | keyCR         : EXIT;
            | keyPageDn     : FOR i:=1 TO speedstep DO
                                  IF speed < maxspeed THEN INC(speed); END;
                              END;
            | keyPageUp     : FOR i:=1 TO speedstep DO
                                  IF speed > minspeed THEN DEC(speed);END;
                              END;
            | keyStar       : speed:=defaultspeed;
            | keyDel        : singlestep:=NOT (singlestep);
            | keySpace      : IF NOT(hyperdrive) THEN
                                  hyperdrive := TRUE;
                                  trails     := trailings;
                                  reftrails  := trailings;
                                  refturn    := turn;
                                  startrail  := star; (* keep original array *)
                              END;
            | keyLeft       : IF NOT(hyperdrive) THEN
                                  IF factor >= (minfactor+factorincrement) THEN
                                      DEC(factor,factorincrement);
                                      newsincos(factor,sinfactor,cosfactor);
                                  END;
                              END;
            | keyRight      : IF NOT(hyperdrive) THEN
                                  IF factor <= (maxfactor-factorincrement) THEN
                                      INC(factor,factorincrement);
                                      newsincos(factor,sinfactor,cosfactor);
                                  END;
                              END;
            | keyDivide     : IF NOT(hyperdrive) THEN
                                  factor := defaultfactor;newsincos(factor,sinfactor,cosfactor);
                              END;
            | keyUpperC,keyLowerC :
                              colored:=NOT(colored);
                              MakePalette(colored);
            | keyUpperO,keyLowerO:
                              IF NOT(hyperdrive) THEN
                                  usefactor := NOT(usefactor);
                              END;
            END;
        END;
        IF randomwarp THEN
            IF getrndrange(minthreshold,maxthreshold) <= threshold THEN
                IF NOT(hyperdrive) THEN
                    hyperdrive := TRUE;
                    trails     := trailings;
                    reftrails  := trailings;
                    refturn    := turn;
                    startrail  := star; (* keep original array *)
                END;
            END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;
    END;
    HiresOFF;
    IF verbose THEN
        WrStr("Stars : ");IO.WrCard(laststar,5);WrLn;
        WrStr("Speed : ");IO.WrCard(speed,5);WrLn;
        WrStr("Angle : ");IO.WrInt(factor,5);WrLn;
    END;
    abort(errNone,"");
END Warp.
