
(* very very old code, slightly revised for QDTOOLS *)

MODULE YingYang;

IMPORT Graph,BiosIO,MATHLIB,SYSTEM;
IMPORT Lib,Str;
FROM IO IMPORT WrStr,WrLn;

(* ------------------------------------------------------------ *)

PROCEDURE retrace ();
VAR
    i:CARDINAL;
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END retrace;

PROCEDURE line (delay:CARDINAL;  x1,y1,x2,y2:LONGREAL; ink:CARDINAL );
VAR
    xx1,yy1,xx2,yy2:CARDINAL;
BEGIN
    xx1:=VAL(CARDINAL,x1);
    yy1:=VAL(CARDINAL,y1);
    xx2:=VAL(CARDINAL,x2);
    yy2:=VAL(CARDINAL,y2);
    Graph.Line( xx1,yy1,xx2,yy2, ink );
    IF delay # 0 THEN Lib.Delay(delay); END;
END line;

PROCEDURE plot (x,y:LONGREAL; ink:CARDINAL );
VAR
    xx,yy:CARDINAL;
BEGIN
    xx:=VAL(CARDINAL,x);
    yy:=VAL(CARDINAL,y);
    Graph.Plot( xx,yy, ink );
END plot;

PROCEDURE disc ( x,y,r:LONGREAL;ink:CARDINAL  );
VAR
    xx,yy,rr:CARDINAL;
BEGIN
    xx:=VAL(CARDINAL,x);
    yy:=VAL(CARDINAL,y);
    rr:=VAL(CARDINAL,r);
    Graph.Disc(xx,yy,rr,ink);
END disc;

(* ------------------------------------------------------------ *)

CONST
    gmode        = Graph._VRES16COLOR;
    tmode        = Graph._DEFAULTMODE;
CONST
    bkcolor=Graph.Graph._LIGHTRED;
    white = 15;
    black = 8;
CONST
    mindelay=0;
    maxdelay=100;
    defaultdelay = 8;
    maxpause = 1000;
CONST
    bigradius   = 120;
    smallradius = LONGREAL(bigradius DIV 8);
CONST
    firstangle = LONGREAL(90.0);
    halfcircle = LONGREAL(180.0);
    increment  = LONGREAL(0.5);   (* smaller means less gaps in teardrops *)
VAR
    rc: BOOLEAN;
    oldbk:LONGCARD;
    V  : Graph.VideoConfig;
    xmin,xmax,ymin,ymax:CARDINAL;
    cx,cy:LONGREAL;
    ch:CHAR;
    halfradius,PI,s,c,deg2rad,alphadeg,e,radius,dx,dy,lastdx,lastdy:LONGREAL;
    zlastdx,zlastdy:LONGREAL;
    x1,y1,x2,y2,x0,y0:LONGREAL;
    S:ARRAY[0..15] OF CHAR;
    v:LONGCARD;
    delay,pause:CARDINAL;
BEGIN
    delay:=defaultdelay;
    IF Lib.ParamCount() # 0 THEN
         Lib.ParamStr(S,1);
         CASE S[0] OF
         | "-","/","?":
             WrLn;
             WrStr("Q&D Ying-Yang v1.0a by PhG");WrLn;
             WrLn;
             WrStr("Syntax : YINGYANG [pause]");WrLn;
             WrLn;
             WrStr("Program waits [pause] milliseconds when drawing a line");WrLn;
             WrStr("([0..100], default is 8).");WrLn;
             Lib.SetReturnCode(0);
             HALT;
         ELSE
             v:=Str.StrToCard(S,10,rc);
             IF rc THEN
                 IF ( (v >= LONGCARD(mindelay)) AND (v <= LONGCARD(maxdelay)) ) THEN
                     delay:=CARDINAL(v);
                 END;
             END;
         END;
    END;

    rc:=Graph.SetVideoMode(gmode);
    Graph.GetVideoConfig(V);
    xmin:=0; xmax:=V.numxpixels-1;
    ymin:=0; ymax:=V.numypixels-1;
    cx:=LONGREAL(V.numxpixels DIV 2);
    cy:=LONGREAL(V.numypixels DIV 2);
    oldbk:=Graph.SetBkColor(bkcolor);
    Graph.ClearScreen(Graph._GWINDOW);

    PI := 4.0 * MATHLIB.ATan(1.0);
    deg2rad := PI / halfcircle;

    e        := LONGREAL(1.0); (* ellipse *)
    radius   := VAL(LONGREAL,bigradius);

    alphadeg := firstangle;
    lastdx := radius * MATHLIB.Cos( alphadeg * deg2rad) * e;
    lastdy := radius * MATHLIB.Sin( alphadeg * deg2rad);
    halfradius := radius / 2.0;
    zlastdx:=lastdx;
    zlastdy:=lastdy;

    LOOP
        alphadeg:=alphadeg + increment;
        IF alphadeg > (firstangle+halfcircle) THEN EXIT; END; (* clockwise, bottom to top *)
        c := MATHLIB.Cos( alphadeg * deg2rad);
        s := MATHLIB.Sin( alphadeg * deg2rad);

        dx := c * radius * e;
        dy := s * radius;

        x1 := cx+lastdx;
        y1 := cy+lastdy;
        x2 := cx+dx;
        y2 := cy+dy;
        line (delay,x1,y1,x2,y2, white); (* left half-circle *)
        x0 := cx-lastdx; (* symetric *)
        y0 := cy-lastdy;
        lastdx := dx;
        lastdy := dy;

        dx := c * halfradius;
        dy := s * halfradius;
        x1 := cx + dx;
        y1 := cy + dy + halfradius;
        x2 := cx + dx;
        y2 := cy - dy + halfradius;
        line(delay,x1,y1,x2,y2,white); (* left half-disk *)

        x1 := x0;
        y1 := y0;
        x2 := cx - dx;
        y2 := cy - dy - halfradius;

        line (delay,x1,y1,x2,y2,white); (* right teardrop *)

        (* uneeded but just to check *)

        dx := c * radius * e;
        dy := s * radius;

        x1 := cx-zlastdx;
        y1 := cy-zlastdy;
        x2 := cx-dx;
        y2 := cy-dy;
        line (delay,x1,y1,x2,y2, black); (* right half-circle *)
        x0 := cx+zlastdx; (* symetric *)
        y0 := cy+zlastdy;
        zlastdx := dx;
        zlastdy := dy;

        dx := c * halfradius;
        dy := s * halfradius;
        x1 := cx - dx;
        y1 := cy - dy - halfradius;
        x2 := cx - dx;
        y2 := cy + dy - halfradius;
        line(delay,x1,y1,x2,y2,black); (* right half-disk *)

        x1 := x0;
        y1 := y0;
        x2 := cx + dx;
        y2 := cy + dy + halfradius;

        line (delay,x1,y1,x2,y2,black); (* left teardrop *)

    END;

    x1 := cx;
    y1 := cy - halfradius;
    disc(x1,y1, smallradius, white);

    x1 := cx;
    y1 := cy + halfradius;
    disc(x1,y1, smallradius, black);

    pause:=0;
    LOOP
        retrace();
        IF BiosIO.KeyPressed() THEN
            ch:=BiosIO.RdKey();IF ch=CHR(0) THEN ch:=BiosIO.RdKey();END;
            EXIT;
        END;
        INC(pause);
        IF pause >= maxpause THEN EXIT; END;
    END;
    rc:=Graph.SetVideoMode(tmode);
    Lib.SetReturnCode(0);
    HALT;
END YingYang.

