(* ---------------------------------------------------------------
Title         tsk tsk...
Overview      tsk tsk...
Usage         see help
Notes         I'm probably the only programmer in the world
              still writing little utilities for DOS...
Bugs          we don't bother to check MSCDEX is v2.10 or better
              due to M$ silly limitations, we were first able to handle only one unit !
              (see infra for 2F1510 bits of knowledge)
              force pause before requiring status ?
              check for door status before lock/unlock/reset ?
              status seems unreliable with win9x
              seems bit 10 for audio playing is unreliable at least with our CDROM driver
Wish List     play/stop audio track ?

--------------------------------------------------------------- *)

MODULE CDcmd;

IMPORT Lib;
IMPORT Str;
IMPORT SYSTEM;
IMPORT FIO;

FROM Storage IMPORT ALLOCATE;

FROM IO IMPORT WrStr, WrLn, WrCard;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory,cleantabs,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;

(* ------------------------------------------------------------ *)

CONST
    cr        = CHR(13);
    lf        = CHR(10);
    nl        = cr+lf;
    blank     = " ";
    colon     = ":";
    star      = "*";
CONST
    minletter = 1;  (* "A" *)
    maxletter = 26; (* "Z" *)
TYPE
    cmdtype = (nada,closetray,opentray,cdinfos,cdreset,cdlock,cdunlock,cdabout);

CONST
    progEXEname   = "CDCMD";
    progTitle     = "Q&D CDROM Command";
    progVersion   = "v1.0b";
    progCopyright = "by PhG";
    banner        = progTitle+" "+progVersion+" "+progCopyright;

CONST
    errNone            = 0;
    errHelp            = 1;
    errUnknownOption   = 2;
    err9X              = 3;
    errSyntax          = 4;
    errCDROM           = 5;
    errBadParm         = 6;
    errNotCDROMunit    = 7;
    errConflict        = 8;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)

errmsg =
banner+nl+
nl+
"Syntax 1 : "+progEXEname+" <-o|-e|-c|-r|-l|-u|-s> [u[u]...:]...|*]"+nl+
"Syntax 2 : "+progEXEname+" <-i>"+nl+
nl+
"Allowed operations : open, eject, close, reset, lock, unlock, status, infos."+nl+
nl+
"Default unit is first CDROM unit ; -x option forces support of first CDROM unit"+nl+
"calling $214403 function (by handle) instead of more powerful $2F1510 function."+nl;

VAR
    S  : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(errmsg);
    | errUnknownOption:
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | err9X:
        Str.Concat(S,"$214402 CDROM function won't work with ",einfo);
        Str.Append(S," driver !");
    | errSyntax:
        S:="Syntax error !";
    | errCDROM:
        Str.Copy(S,einfo);
    | errBadParm:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S,": unit specification !");
    | errNotCDROMunit:
        Str.Concat(S,"Non-CDROM unit in ",einfo);Str.Append(S,": specification !");
    | errConflict:
        S := "Mutually exclusive commands !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* Table 01680 : values for DOS extended error code *)

PROCEDURE getExtendedErrorMessage(errcode:CARDINAL; VAR R:ARRAY OF CHAR);
VAR
    S:str128;
BEGIN
    (* DOS 2.0+  *)
    CASE errcode OF
    | 00H : S:="no error";
    | 01H : S:="function number invalid";
    | 02H : S:="file not found";
    | 03H : S:="path not found";
    | 04H : S:="too many open files (no handles available)";
    | 05H : S:="access denied";
    | 06H : S:="invalid handle";
    | 07H : S:="memory control block destroyed";
    | 08H : S:="insufficient memory";
    | 09H : S:="memory block address invalid";
    | 0AH : S:="environment invalid (usually >32K in length)";
    | 0BH : S:="format invalid";
    | 0CH : S:="access code invalid";
    | 0DH : S:="data invalid";
    | 0EH : S:="reserved"+nl+"(PTS-DOS 6.51+, S/DOS 1.0+) fixup overflow";
    | 0FH : S:="invalid drive";
    | 10H : S:="attempted to remove current directory";
    | 11H : S:="not same device";
    | 12H : S:="no more files";
    (* DOS 3.0+ (INT 24 errors) *)
    | 13H : S:="disk write-protected";
    | 14H : S:="unknown unit";
    | 15H : S:="drive not ready";
    | 16H : S:="unknown command";
    | 17H : S:="data error (CRC)";
    | 18H : S:="bad request structure length";
    | 19H : S:="seek error";
    | 1AH : S:="unknown media type (non-DOS disk)";
    | 1BH : S:="sector not found";
    | 1CH : S:="printer out of paper";
    | 1DH : S:="write fault";
    | 1EH : S:="read fault";
    | 1FH : S:="general failure";
    | 20H : S:="sharing violation";
    | 21H : S:="lock violation";
    | 22H : S:="disk change invalid (ES:DI -> media ID structure)";
    | 23H : S:="FCB unavailable"+nl+"(PTS-DOS 6.51+, S/DOS 1.0+) bad FAT";
    | 24H : S:="sharing buffer overflow";
    | 25H : S:="(DOS 4.0+) code page mismatch";
    | 26H : S:="(DOS 4.0+) cannot complete file operation (EOF / out of input)";
    | 27H : S:="(DOS 4.0+) insufficient disk space";
    | 28H..31H:S:="reserved";
    (* OEM network errors (INT 24) *)
    | 32H : S:="network request not supported";
    | 33H : S:="remote computer not listening";
    | 34H : S:="duplicate name on network";
    | 35H : S:="network name not found";
    | 36H : S:="network busy";
    | 37H : S:="network device no longer exists";
    | 38H : S:="network BIOS command limit exceeded";
    | 39H : S:="network adapter hardware error";
    | 3AH : S:="incorrect response from network";
    | 3BH : S:="unexpected network error";
    | 3CH : S:="incompatible remote adapter";
    | 3DH : S:="print queue full";
    | 3EH : S:="queue not full";
    | 3FH : S:="not enough space to print file";
    | 40H : S:="network name was deleted";
    | 41H : S:="network: Access denied"+nl+"(DOS 3.0+) codepage switching not possible";
    | 42H : S:="network device type incorrect";
    | 43H : S:="network name not found";
    | 44H : S:="network name limit exceeded";
    | 45H : S:="network BIOS session limit exceeded";
    | 46H : S:="temporarily paused";
    | 47H : S:="network request not accepted";
    | 48H : S:="network print/disk redirection paused";
    | 49H : S:="network software not installed"+nl+"(LANtastic) invalid network version";
    | 4AH : S:="unexpected adapter close"+nl+"(LANtastic) account expired";
    | 4BH : S:="(LANtastic) password expired";
    | 4CH : S:="(LANtastic) login attempt invalid at this time";
    | 4DH : S:="(LANtastic v3+) disk limit exceeded on network node";
    | 4EH : S:="(LANtastic v3+) not logged in to network node";
    | 4FH : S:="reserved";
    (* end of errors reportable via INT 24 *)
    | 50H : S:="file exists";
    | 51H : S:="(undoc) duplicated FCB";
    | 52H : S:="cannot make directory";
    | 53H : S:="fail on INT 24h";
    (* network-related errors (non-INT 24) *)
    | 54H : S:="(DOS 3.3+) too many redirections / out of structures";
    | 55H : S:="(DOS 3.3+) duplicate redirection / already assigned";
    | 56H : S:="(DOS 3.3+) invalid password";
    | 57H : S:="(DOS 3.3+) invalid parameter";
    | 58H : S:="(DOS 3.3+) network write fault";
    | 59H : S:="(DOS 4.0+) function not supported on network / no process slots available";
    | 5AH : S:="(DOS 4.0+) required system component not installed / not frozen";
    | 5BH : S:="(DOS 4.0+,NetWare4) timer server table overflowed";
    | 5CH : S:="(DOS 4.0+,NetWare4) duplicate in timer service table";
    | 5DH : S:="(DOS 4.0+,NetWare4) no items to work on";
    | 5FH : S:="(DOS 4.0+,NetWare4) interrupted / invalid system call";
    | 64H : S:="(MSCDEX) unknown error"+nl+"(DOS 4.0+,NetWare4) open semaphore limit exceeded";
    | 65H : S:="(MSCDEX) not ready"+nl+"(DOS 4.0+,NetWare4) exclusive semaphore is already owned";
    | 66H : S:="(MSCDEX) EMS memory no longer valid"+nl+"(DOS 4.0+,NetWare4) semaphore was set when close attempted";
    | 67H : S:="(MSCDEX) not High Sierra or ISO-9660 format"+nl+"(DOS 4.0+,NetWare4) too many exclusive semaphore requests";
    | 68H : S:="(MSCDEX) door open"+nl+"(DOS 4.0+,NetWare4) operation invalid from interrupt handler";
    | 69H : S:="(DOS 4.0+,NetWare4) semaphore owner died";
    | 6AH : S:="(DOS 4.0+,NetWare4) semaphore limit exceeded";
    | 6BH : S:="(DOS 4.0+,NetWare4) insert drive B: disk into A: / disk changed";
    | 6CH : S:="(DOS 4.0+,NetWare4) drive locked by another process";
    | 6DH : S:="(DOS 4.0+,NetWare4) broken pipe";
    | 6EH : S:="(DOS 5.0+,NetWare4) pipe open/create failed";
    | 6FH : S:="(DOS 5.0+,NetWare4) pipe buffer overflowed";
    | 70H : S:="(DOS 5.0+,NetWare4) disk full";
    | 71H : S:="(DOS 5.0+,NetWare4) no more search handles";
    | 72H : S:="(DOS 5.0+,NetWare4) invalid target handle for dup2";
    | 73H : S:="(DOS 5.0+,NetWare4) bad user virtual address / protection violation";
    | 74H : S:="(DOS 5.0+) VIOKBD request"+nl+"(NetWare4) error on console I/O";
    | 75H : S:="(DOS 5.0+,NetWare4) unknown category code for IOCTL";
    | 76H : S:="(DOS 5.0+,NetWare4) invalid value for verify flag";
    | 77H : S:="(DOS 5.0+,NetWare4) level four driver not found by DOS IOCTL";
    | 78H : S:="(DOS 5.0+,NetWare4) invalid / unimplemented function number";
    | 79H : S:="(DOS 5.0+,NetWare4) semaphore timeout";
    | 7AH : S:="(DOS 5.0+,NetWare4) buffer too small to hold return data";
    | 7BH : S:="(DOS 5.0+,NetWare4) invalid character or bad file-system name";
    | 7CH : S:="(DOS 5.0+,NetWare4) unimplemented information level";
    | 7DH : S:="(DOS 5.0+,NetWare4) no volume label found";
    | 7EH : S:="(DOS 5.0+,NetWare4) module handle not found";
    | 7FH : S:="(DOS 5.0+,NetWare4) procedure address not found";
    | 80H : S:="(DOS 5.0+,NetWare4) CWait found no children";
    | 81H : S:="(DOS 5.0+,NetWare4) CWait children still running";
    | 82H : S:="(DOS 5.0+,NetWare4) invalid operation for direct disk-access handle";
    | 83H : S:="(DOS 5.0+,NetWare4) attempted seek to negative offset";
    | 84H : S:="(DOS 5.0+,NetWare4) attempted to seek on device or pipe";
    (* JOIN/SUBST errors *)
    | 85H : S:="(DOS 5.0+,NetWare4) drive already has JOINed drives";
    | 86H : S:="(DOS 5.0+,NetWare4) drive is already JOINed";
    | 87H : S:="(DOS 5.0+,NetWare4) drive is already SUBSTed";
    | 88H : S:="(DOS 5.0+,NetWare4) can not delete drive which is not JOINed";
    | 89H : S:="(DOS 5.0+,NetWare4) can not delete drive which is not SUBSTed";
    | 8AH : S:="(DOS 5.0+,NetWare4) can not JOIN to a JOINed drive";
    | 8BH : S:="(DOS 5.0+,NetWare4) can not SUBST to a SUBSTed drive";
    | 8CH : S:="(DOS 5.0+,NetWare4) can not JOIN to a SUBSTed drive";
    | 8DH : S:="(DOS 5.0+,NetWare4) can not SUBST to a JOINed drive";
    | 8EH : S:="(DOS 5.0+,NetWare4) drive is busy";
    | 8FH : S:="(DOS 5.0+,NetWare4) can not JOIN/SUBST to same drive";
    | 90H : S:="(DOS 5.0+,NetWare4) directory must not be root directory";
    | 91H : S:="(DOS 5.0+,NetWare4) can only JOIN to empty directory";
    | 92H : S:="(DOS 5.0+,NetWare4) path is already in use for SUBST";
    | 93H : S:="(DOS 5.0+,NetWare4) path is already in use for JOIN";
    | 94H : S:="(DOS 5.0+,NetWare4) path is in use by another process";
    | 95H : S:="(DOS 5.0+,NetWare4) directory previously SUBSTituted";
    | 96H : S:="(DOS 5.0+,NetWare4) system trace error";
    | 97H : S:="(DOS 5.0+,NetWare4) invalid event count for DosMuxSemWait";
    | 98H : S:="(DOS 5.0+,NetWare4) too many waiting on mutex";
    | 99H : S:="(DOS 5.0+,NetWare4) invalid list format";
    | 9AH : S:="(DOS 5.0+,NetWare4) volume label too large";
    | 9BH : S:="(DOS 5.0+,NetWare4) unable to create another TCB";
    | 9CH : S:="(DOS 5.0+,NetWare4) signal refused";
    | 9DH : S:="(DOS 5.0+,NetWare4) segment discarded";
    | 9EH : S:="(DOS 5.0+,NetWare4) segment not locked";
    | 9FH : S:="(DOS 5.0+,NetWare4) invalid thread-ID address"+nl+"(DOS 5.0+) bad arguments"+nl+"(NetWare4) bad environment pointer";
    |0A1H : S:="(DOS 5.0+,NetWare4) invalid pathname passed to EXEC";
    |0A2H : S:="(DOS 5.0+,NetWare4) signal already pending";
    |0A3H : S:="(DOS 5.0+) uncertain media"+nl+"(NetWare4) ERROR_124 mapping";
    |0A4H : S:="(DOS 5.0+) maximum number of threads reached"+nl+"(NetWare4) no more process slots";
    |0A5H : S:="(NetWare4) ERROR_124 mapping";
    |0B0H : S:="(MS-DOS 7.0) volume is not locked";
    |0B1H : S:="(MS-DOS 7.0) volume is locked in drive";
    |0B2H : S:="(MS-DOS 7.0) volume is not removable";
    |0B4H : S:="(MS-DOS 7.0) lock count has been exceeded"+nl+"(NetWare4) invalid segment number";
    |0B5H : S:="(MS-DOS 7.0) a valid eject request failed"+nl+"(DOS 5.0-6.0,NetWare4) invalid call gate";
    |0B6H : S:="(DOS 5.0+,NetWare4) invalid ordinal";
    |0B7H : S:="(DOS 5.0+,NetWare4) shared segment already exists";
    |0B8H : S:="(DOS 5.0+,NetWare4) no child process to wait for";
    |0B9H : S:="(DOS 5.0+,NetWare4) NoWait specified and child still running";
    |0BAH : S:="(DOS 5.0+,NetWare4) invalid flag number";
    |0BBH : S:="(DOS 5.0+,NetWare4) semaphore does not exist";
    |0BCH : S:="(DOS 5.0+,NetWare4) invalid starting code segment";
    |0BDH : S:="(DOS 5.0+,NetWare4) invalid stack segment";
    |0BEH : S:="(DOS 5.0+,NetWare4) invalid module type (DLL can not be used as application)";
    |0BFH : S:="(DOS 5.0+,NetWare4) invalid EXE signature";
    |0C0H : S:="(DOS 5.0+,NetWare4) EXE marked invalid";
    |0C1H : S:="(DOS 5.0+,NetWare4) bad EXE format (e.g. DOS-mode program)";
    |0C2H : S:="(DOS 5.0+,NetWare4) iterated data exceeds 64K";
    |0C3H : S:="(DOS 5.0+,NetWare4) invalid minimum allocation size";
    |0C4H : S:="(DOS 5.0+,NetWare4) dynamic link from invalid Ring";
    |0C5H : S:="(DOS 5.0+,NetWare4) IOPL not enabled";
    |0C6H : S:="(DOS 5.0+,NetWare4) invalid segment descriptor privilege level";
    |0C7H : S:="(DOS 5.0+,NetWare4) automatic data segment exceeds 64K";
    |0C8H : S:="(DOS 5.0+,NetWare4) Ring2 segment must be moveable";
    |0C9H : S:="(DOS 5.0+,NetWare4) relocation chain exceeds segment limit";
    |0CAH : S:="(DOS 5.0+,NetWare4) infinite loop in relocation chain";
    |0CBH : S:="(NetWare4) environment variable not found";
    |0CCH : S:="(NetWare4) not current country";
    |0CDH : S:="(NetWare4) no signal sent";
    |0CEH : S:="(NetWare4) file name not 8.3";
    |0CFH : S:="(NetWare4) Ring2 stack in use";
    |0D0H : S:="(NetWare4) meta expansion is too long";
    |0D1H : S:="(NetWare4) invalid signal number";
    |0D2H : S:="(NetWare4) inactive thread";
    |0D3H : S:="(NetWare4) file system information not available";
    |0D4H : S:="(NetWare4) locked error";
    |0D5H : S:="(NetWare4) attempted to execute non-family API call in DOS mode";
    |0D6H : S:="(NetWare4) too many modules";
    |0D7H : S:="(NetWare4) nesting not allowed";
    |0E6H : S:="(NetWare4) non-existent pipe, or bad operation";
    |0E7H : S:="(NetWare4) pipe is busy";
    |0E8H : S:="(NetWare4) no data available for nonblocking read";
    |0E9H : S:="(NetWare4) pipe disconnected by server";
    |0EAH : S:="(NetWare4) more data available";
    |0FFH : S:="(NetWare4) invalid drive";
    ELSE
           S:="(undefined)";
    END;
    Str.Concat(R,"Explanation : ",S);
END getExtendedErrorMessage;

PROCEDURE getDevDrvrErrorMessage(errcode:CARDINAL; VAR R:ARRAY OF CHAR);
VAR
    S:str128;
BEGIN
    CASE errcode OF
    | 00H : S:="write-protect violation";
    | 01H : S:="unknown unit";
    | 02H : S:="drive not ready";
    | 03H : S:="unknown command";
    | 04H : S:="CRC error";
    | 05H : S:="bad drive request structure length";
    | 06H : S:="seek error";
    | 07H : S:="unknown media";
    | 08H : S:="sector not found";
    | 09H : S:="printer out of paper";
    | 0AH : S:="write fault";
    | 0BH : S:="read fault";
    | 0CH : S:="general failure";
    | 0DH : S:="reserved";
    | 0EH : S:="(CD-ROM) media unavailable";
    | 0FH : S:="invalid disk change";
    ELSE
            S:="(undefined)";
    END;
    Str.Concat(R,"Explanation : ",S);
END getDevDrvrErrorMessage;

(* ------------------------------------------------------------ *)

PROCEDURE sound (freq,duration,pause:CARDINAL);
BEGIN
    Lib.Sound(freq);
    Lib.Delay(duration);
    Lib.NoSound();
    Lib.Delay(pause);
END sound;

PROCEDURE alert (  );
BEGIN
    sound(111,22,100);
    sound(111,22,10);
END alert;

PROCEDURE card2str (value,base,digits:CARDINAL;pad:CHAR): str16;
VAR
    S : str16;
    ok: BOOLEAN;
BEGIN
    Str.CardToStr(LONGCARD(value),S,base,ok);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    IF base=16 THEN
        Str.Lows(S);
        Str.Prepend(S,"$");
    END;
    RETURN S;
END card2str;

(* ------------------------------------------------------------ *)

CONST
    multiplex = 02FH;

PROCEDURE getMSCDEXversion (major,minor:CARDINAL;
                           VAR S:ARRAY OF CHAR   ):BOOLEAN;
VAR
    R:SYSTEM.Registers;
    gotmaj,gotmin:CARDINAL;
BEGIN
    R.AX := 0150CH;
    R.BX := 00000H;
    Lib.Intr(R,multiplex);
    gotmaj:=CARDINAL(R.BH);
    gotmin:=CARDINAL(R.BL);
    Str.Copy  (S, card2str( gotmaj,10,1,"0") );
    Str.Append(S, ".");
    Str.Append(S, card2str( gotmin,10,2,"0") ); (* 1="01", 10="10", 100="100" *)
    Str.Prepend(S,"MSCDEX v");
    RETURN ( (major >= gotmaj) AND (minor >= gotmin) );
END getMSCDEXversion;

PROCEDURE chkCDROMdrive (ch:CHAR; VAR S:ARRAY OF CHAR):BOOLEAN;
VAR
    u:CARDINAL;
    rc:BOOLEAN;
    R:SYSTEM.Registers;
BEGIN
    u:= ORD(ch)-ORD("A");

    R.AX := 0150BH;
    R.CX := u;
    Lib.Intr( R, multiplex);

    Str.Copy(S,", MSCDEX ");
    IF R.BX = 0ADADH THEN
        Str.Append(S,"installed");
    ELSE
        Str.Append(S,"not installed");
    END;

    IF R.AX = 00000H THEN
        rc:=FALSE; Str.Prepend(S,"drive not supported");
    ELSE
        rc:=TRUE;  Str.Prepend(S,"drive supported");
    END;

    RETURN rc;
END chkCDROMdrive;

TYPE
    CDROMdataType = RECORD
        subunit:SHORTCARD;
        driverName:str16; (* 1..8 would do *)
    END;
VAR
    CDROMdata:ARRAY[minletter..maxletter] OF CDROMdataType; (* oversized *)

PROCEDURE getCDROMdata(ch:CHAR;VAR subunit:SHORTCARD;VAR R:ARRAY OF CHAR);
VAR
    ndx:CARDINAL;
BEGIN
    ndx:=ORD(ch)-ORD("A") +1; (* [1.. *)
    subunit:=CDROMdata[ndx].subunit;
    Str.Copy(R,CDROMdata[ndx].driverName);
END getCDROMdata;

PROCEDURE fmtCDROMdata (ch:CHAR;VAR R:ARRAY OF CHAR);
VAR
    subunit:SHORTCARD;
    id:str16;
BEGIN
    getCDROMdata(ch, subunit, id);
    Str.Copy(R,"unit ");
    Str.Append(R,card2str ( CARDINAL(subunit),10,1,"0"));
    Str.Append(R,', "'); Str.Append(R,id); Str.Append(R,'"');
END fmtCDROMdata;

(* remember we need FAR pointers here ! *)

PROCEDURE getAllCDROMdriverNames (allowed:ARRAY OF CHAR);
TYPE
    devdrvheadertype = RECORD
        pNextDriver   : FarADDRESS; (* ofs=$FFFF for last driver *)
        attributes    : CARDINAL;
        strategypoint : CARDINAL;
        entrypoint    : CARDINAL;
        (* character device only *)
        devname       : ARRAY [0..8-1] OF CHAR; (* blank padded *)
    END;
TYPE
    letterinfotype = RECORD
        subunit                   : SHORTCARD;
(*# save *)
(*# data(near_ptr => off)  *)
        deviceDriverHeaderAddress : POINTER TO devdrvheadertype;
(*# restore *)
    END;
VAR
    R:SYSTEM.Registers;
    buf:ARRAY [minletter..maxletter] OF letterinfotype;
    hletter:letterinfotype;
    hdevice:devdrvheadertype;
    i,ndx,j:CARDINAL;
BEGIN
    FOR i:=minletter TO maxletter DO
        CDROMdata[i].subunit:=0; (* 255 would be better *)
        Str.Copy(CDROMdata[i].driverName,"");
    END;

    R.AX := 01501H;     (* GET DRIVE DEVICE LIST *)
    R.ES := Seg(buf);
    R.BX := Ofs(buf);
    Lib.Intr(R,multiplex);
    (* buffer filled for each successive letter allowed by redirector *)

    FOR i:=1 TO Str.Length(allowed) DO (* this length is number of units *)
        hletter:=buf[i];
        hdevice:=hletter.deviceDriverHeaderAddress^;
        ndx:=ORD(allowed[i-1])-ORD("A");
        INC(ndx); (* minletter is 1, not 0 *)

        CDROMdata[ndx].subunit:=hletter.subunit;

        FOR j:=0 TO 8-1 DO
            CDROMdata[ndx].driverName[j]:=hdevice.devname[j];
        END;
        CDROMdata[ndx].driverName[8]:=CHR(0); (* brutal ! *)
        Rtrim(CDROMdata[ndx].driverName,blank); (* right padded with spaces *)
    END;
END getAllCDROMdriverNames;

PROCEDURE Win9XdriverHere (allowed:ARRAY OF CHAR; VAR S:ARRAY OF CHAR):BOOLEAN;
VAR
    i:CARDINAL;
    subunit:SHORTCARD;
    R,R2:str16;
BEGIN
    FOR i:=1 TO Str.Length(allowed) DO
        getCDROMdata( allowed[i-1],  subunit,R);
        Str.Copy(R2,R);
        Str.Lows(R2);
        IF same(R,R2) THEN RETURN TRUE; END;
    END;
    RETURN FALSE;
END Win9XdriverHere;

(* ------------------------------------------------------------ *)

PROCEDURE showAction (cmd:cmdtype;ch:CHAR);
VAR
    S:str128;
BEGIN
    CASE cmd OF
    | opentray:  S:="Opening";
    | closetray: S:="Closing";
    | cdreset:   S:="Resetting";
    | cdlock:    S:="Locking";
    | cdunlock:  S:="Unlocking";
    END;
    Str.Append(S," ");Str.Append(S,ch);Str.Append(S,": unit...");
    WrStr(S);
END showAction;

(*
    darn : $4403 and $4402 cannot distinguish between subunits !
	use INT 2F/AX=1510h or INT 2F/AX=0802h instead
*)

CONST
    maxretries        = 5; (* useless in fact *)
CONST
    ioctlEject        = 0;
	ioctlLockUnlock   = 1;  ioctlUnlock=0; ioctlLock=1;
    ioctlReset        = 2;
    ioctlClose        = 5;
CONST
    ioctlDeviceStatus = 6;
    ioctlMediaChange  = 9;
TYPE
    controlBlockType = ARRAY[0..1] OF SHORTCARD; (* Q&D : make it simpler *)

PROCEDURE doCDout (cmd:cmdtype;ch:CHAR):BOOLEAN;
VAR
    hnd:FIO.File;
    subunit:SHORTCARD;
    id:str16;
    controlBlock:controlBlockType; (* ARRAY 0..1 *)
    R:SYSTEM.Registers;
    func,subfunc:SHORTCARD;
    count,errcode,retries:CARDINAL;
    rc:BOOLEAN;
    S:str256; (* errmsg *)
BEGIN

    showAction(cmd,ch);

    getCDROMdata(ch, subunit, id);
    hnd:=FIO.OpenRead(id);

retries:=1;
LOOP

    subfunc:=0;
    count  :=1;
    CASE cmd OF
    | opentray:  func:=ioctlEject;
    | closetray: func:=ioctlClose;
    | cdreset:   func:=ioctlReset;
    | cdlock:    func:=ioctlLockUnlock; subfunc:=ioctlLock;  count:=2;
    | cdunlock:  func:=ioctlLockUnlock; subfunc:=ioctlUnlock;count:=2;
    END;

    controlBlock[0]:=func;
    controlBlock[1]:=subfunc;
    R.AX:=04403H;
    R.BX:=hnd;
    R.CX:=count;
	R.DS:=Seg(controlBlock);
	R.DX:=Ofs(controlBlock);
    Lib.Dos(R);

    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        INC(retries);
        IF retries > maxretries THEN
            errcode:=R.AX; (* GET EXTENDED ERROR INFORMATION, DOS 2159, BX=0000, table 01680 *)
            Str.Copy(S,card2str(errcode,16,2,"0") );
            WrLn;
            WrLn;
            WrStr("$214403 CDROM function returned error code ");WrStr(S);WrStr(".");WrLn;
            getExtendedErrorMessage(errcode,S);
            WrStr(S);WrLn;
            rc:=FALSE;
            EXIT;
        END;
    ELSE
        WrStr(" Done.");WrLn;
        rc:=TRUE;
        EXIT;
    END;
END;
    FIO.Close(hnd);
    RETURN rc;
END doCDout;

CONST
    DRIVENOTREADY = 15H;
    MEDIANONSENSE = 80H;

TYPE
    controlBlockINtype = RECORD
        request : SHORTCARD;
        CASE : BOOLEAN OF
        | TRUE:
            deviceParameters : SET OF [0..32-1]; (* LONGCARD *)
        | FALSE:
            mediastatus : SHORTCARD;
        END;
    END;

PROCEDURE doCDin (ch:CHAR;func:SHORTCARD;
                 VAR doorClosed,diskInUnit:BOOLEAN):BOOLEAN ;
VAR
    ctlBlockIN:controlBlockINtype; (* Q&D : make it simpler *)
    hnd:FIO.File;
    R:SYSTEM.Registers;
    wanted,errcode,retries:CARDINAL;
    subunit:SHORTCARD;
    id:str16;
    rc:BOOLEAN;
    S:str256; (* errmsg can be long *)
BEGIN

    getCDROMdata(ch, subunit, id);
    hnd:=FIO.OpenRead(id);

retries:=1;
LOOP
    CASE func OF
    | ioctlDeviceStatus:wanted:=4;
    | ioctlMediaChange: wanted:=1;
    END;

    ctlBlockIN.request:=func;

    R.AX:=04402H;
    R.BX:=hnd;
    R.CX:=wanted;
	R.DS:=Seg(ctlBlockIN);
	R.DX:=Ofs(ctlBlockIN);
    Lib.Dos(R);

    (* hack ! intercept "drive not ready" error and force our private MEDIANONSENSE
    if checking media change without disk or door closed -- using boolean provided by prior call *)

    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        IF func=ioctlMediaChange THEN
            IF R.AX=DRIVENOTREADY THEN
                IF ( (doorClosed=FALSE) OR (diskInUnit=FALSE) ) THEN
                    EXCL(R.Flags,SYSTEM.CarryFlag);
                    ctlBlockIN.mediastatus:=MEDIANONSENSE;
                END;
            END;
        END;
    END;

    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        INC(retries);
        IF retries > maxretries THEN
            errcode:=R.AX; (* GET EXTENDED ERROR INFORMATION, DOS 2159, BX=0000, table 01680 *)
            Str.Copy(S,card2str(errcode,16,2,"0") );
            WrStr("$214402 CDROM function returned error code ");WrStr(S);WrStr(".");WrLn;
            WrLn;
            getExtendedErrorMessage(errcode,S);
            WrStr(S);WrLn;
            rc:=FALSE;
            EXIT;
        END;
    ELSE
        CASE func OF
        | ioctlDeviceStatus:
            IF (0 IN ctlBlockIN.deviceParameters) THEN
                S:="Door opened";    doorClosed:=FALSE;
            ELSE
                S:="Door closed";  doorClosed:=TRUE;
            END;
            WrStr(S);WrLn;

            IF (1 IN ctlBlockIN.deviceParameters) THEN
                S:="Door unlocked";
            ELSE
                S:="Door locked";
            END;
            WrStr(S);WrLn;

            IF (11 IN ctlBlockIN.deviceParameters) THEN
                S:="No disk in unit"; diskInUnit:=FALSE;
            ELSE
                S:="Disk in unit";    diskInUnit:=TRUE;
            END;
            WrStr(S);WrLn;

            (* unreliable : don't use it *)
            (*
            IF (10 IN ctlBlockIN.deviceParameters) THEN
                S:="Playing audio";
            ELSE
                S:="Not playing audio";
            END;
            WrStr(S);WrLn;
            (* WrLn;WrLngHex( LONGCARD(ctlBlockIN.deviceParameters),20);WrLn; *)
            *)
        | ioctlMediaChange:
            CASE CARDINAL(ctlBlockIN.mediastatus) OF
            | 000H :S:="Media change unknown"; (* don't know *)
            | 001H :S:="Media unchanged";
            | 0FFH :S:="Media has been changed";
            | MEDIANONSENSE:S:="Media change not applicable (door opened or no disk in unit)";
            END;
            WrStr(S);WrLn;
        END;
        rc:=TRUE;
        EXIT;
    END;
END;
    FIO.Close(hnd);
    RETURN rc;
END doCDin;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    devDrvrRequestHeaderType = RECORD
        count   : SHORTCARD;
        subunit : SHORTCARD;
        cmdcode : SHORTCARD;
        status  : SET OF [0..16-1]; (* CARDINAL *)
        rsvd    : ARRAY [1..4] OF BYTE;
        rsvdPtr : LONGCARD;
        (* for $0C IOctl function *)
        mediadescriptor : SHORTCARD; (* block devices only *)
        transferAddress : FarADDRESS;
        countBytes      : CARDINAL; (* read/write *)
    END;
CONST
    IOCTLINPUT  = 03H;
    IOCTLOUTPUT = 0CH;

PROCEDURE doCDdriverRequestOUT (cmd:cmdtype;ch:CHAR):BOOLEAN;
VAR
    controlBlock:controlBlockType; (* ARRAY 0..1 *)
    h : devDrvrRequestHeaderType;
    R:SYSTEM.Registers;
    unit,errcode,count:CARDINAL;
    id:str16;
    func,subfunc,subunit:SHORTCARD;
    rc:BOOLEAN;
    S:str128; (* should do *)
    retries,ourunit:CARDINAL;
BEGIN

    showAction(cmd,ch);

retries:=1;
LOOP

    getCDROMdata(ch, subunit, id);

    subfunc:=0;
    count  :=1;
    CASE cmd OF
    | opentray:  func:=ioctlEject;
    | closetray: func:=ioctlClose;
    | cdreset:   func:=ioctlReset;
    | cdlock:    func:=ioctlLockUnlock; subfunc:=ioctlLock;  count:=2;
    | cdunlock:  func:=ioctlLockUnlock; subfunc:=ioctlUnlock;count:=2;
    END;

    ourunit:=ORD(ch)-ORD("A");

    controlBlock[0]:=func;
    controlBlock[1]:=subfunc;

    h.count           := SIZE(h);
    h.subunit         := subunit;
    h.cmdcode         := IOCTLOUTPUT;
    h.transferAddress := FarADR(controlBlock);
    h.countBytes      := count;

    R.AX:=01510H;                   (* SEND DEVICE DRIVER REQUEST *)
    R.CX:=ourunit;
    R.ES:=Seg(h);
    R.BX:=Ofs(h);

    Lib.Intr(R,multiplex);
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        INC(retries);
        IF retries > maxretries THEN
            WrLn;
            WrLn;
            WrStr("Device NOT called by $2F1510 IOctl function. Error code : ");
            errcode:=R.AX;
            Str.Copy(S,card2str(errcode,16,2,"0") );
            (*
            CASE errcode OF
            | 01H : Str.Append(S," (invalid function)");
            | 0FH : Str.Append(S," (invalid drive)");
            END;
            *)
            WrStr(S);WrLn;
            rc:=FALSE;
            EXIT;
        END;
    ELSE
        (* check header status for possible error *)
        IF (15 IN h.status) THEN
            INC(retries);
            IF retries > maxretries THEN
                WrLn;
                WrLn;
                WrStr("Device called by $2F1510 IOctl function. Error code : ");
                errcode:=( CARDINAL(h.status) AND 00FFH);
                Str.Copy(S,card2str(errcode,16,2,"0") );
                WrStr(S);WrLn;
                WrLn;
                getDevDrvrErrorMessage(errcode, S);
                WrStr(S);WrLn;
                rc:=FALSE;
                EXIT;
            END;
        ELSE
            (* 9=busy, 8=done *)
            WrStr(" Done.");WrLn;
            rc:=TRUE;
            EXIT;
        END;
    END;
END;
    RETURN rc;
END doCDdriverRequestOUT;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    DEVDRVDRIVENOTREADY = 02H;

PROCEDURE doCDdriverRequestIN (ch:CHAR;func:SHORTCARD;
                              VAR doorClosed,diskInUnit:BOOLEAN):BOOLEAN ;
VAR
    ctlBlockIN:controlBlockINtype; (* Q&D : make it simpler *)
    R:SYSTEM.Registers;
    wanted,ourunit,retries,errcode:CARDINAL;
    subunit:SHORTCARD;
    id:str16;
    h : devDrvrRequestHeaderType;
    S : str128;
    rc: BOOLEAN;
BEGIN

retries:=1;
LOOP

    getCDROMdata(ch, subunit, id);

    CASE func OF
    | ioctlDeviceStatus:wanted:=4;
    | ioctlMediaChange: wanted:=1;
    END;

    ctlBlockIN.request:=func;

    ourunit:=ORD(ch)-ORD("A");

    h.count           := SIZE(h);
    h.subunit         := subunit;
    h.cmdcode         := IOCTLINPUT;
    h.transferAddress := FarADR(ctlBlockIN);
    h.countBytes      := wanted;

    R.AX:=01510H;                   (* SEND DEVICE DRIVER REQUEST *)
    R.CX:=ourunit;
    R.ES:=Seg(h);
    R.BX:=Ofs(h);

    Lib.Intr(R,multiplex);

    (* hack ! intercept devdrvr "drive not ready" error and force our private MEDIANONSENSE
    if checking media change without disk or door closed -- using boolean provided by prior call *)

    IF (SYSTEM.CarryFlag IN R.Flags)=FALSE THEN
        IF (15 IN h.status) THEN
            IF func=ioctlMediaChange THEN
                IF (CARDINAL(h.status) AND 00FFH)=DEVDRVDRIVENOTREADY THEN
                    IF ( (doorClosed=FALSE) OR (diskInUnit=FALSE) ) THEN
                        EXCL(h.status,15);
                        ctlBlockIN.mediastatus:=MEDIANONSENSE;
                    END;
                END;
            END;
        END;
    END;

    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        INC(retries);
        IF retries > maxretries THEN
            WrLn;
            WrStr("Device NOT called by $2F1510 IOctl function. Error code : ");
            errcode:=R.AX;
            Str.Copy(S,card2str(errcode,16,2,"0") );
            (*
            CASE errcode OF
            | 01H : Str.Append(S," (invalid function)");
            | 0FH : Str.Append(S," (invalid drive)");
            END;
            *)
            WrStr(S);WrLn;
            rc:=FALSE;
            EXIT;
        END;
    ELSE
        (* check header status for possible error *)
        IF (15 IN h.status) THEN
            INC(retries);
            IF retries > maxretries THEN
                WrLn;
                WrStr("Device called by $2F1510 IOctl function. Error code : ");
                errcode:=( CARDINAL(h.status) AND 00FFH);
                Str.Copy(S,card2str(errcode,16,2,"0") );
                WrStr(S);WrLn;
                WrLn;
                getDevDrvrErrorMessage(errcode, S);
                WrStr(S);WrLn;
                rc:=FALSE;
                EXIT;
            END;
        ELSE
            (* 9=busy, 8=done *)
            CASE func OF
            | ioctlDeviceStatus:
                IF (0 IN ctlBlockIN.deviceParameters) THEN
                    S:="Door opened";    doorClosed:=FALSE;
                ELSE
                    S:="Door closed";  doorClosed:=TRUE;
                END;
                WrStr(S);WrLn;

                IF (1 IN ctlBlockIN.deviceParameters) THEN
                    S:="Door unlocked";
                ELSE
                    S:="Door locked";
                END;
                WrStr(S);WrLn;

                IF (11 IN ctlBlockIN.deviceParameters) THEN
                    S:="No disk in unit"; diskInUnit:=FALSE;
                ELSE
                    S:="Disk in unit";    diskInUnit:=TRUE;
                END;
                WrStr(S);WrLn;

                (* unreliable : don't use it *)
                (*
                IF (10 IN ctlBlockIN.deviceParameters) THEN
                    S:="Playing audio";
                ELSE
                    S:="Not playing audio";
                END;
                WrStr(S);WrLn;
                (* WrLn;WrLngHex( LONGCARD(ctlBlockIN.deviceParameters),20);WrLn; *)
                *)
            | ioctlMediaChange:
                CASE CARDINAL(ctlBlockIN.mediastatus) OF
                | 000H :S:="Media change unknown"; (* don't know *)
                | 001H :S:="Media unchanged";
                | 0FFH :S:="Media has been changed";
                | MEDIANONSENSE:S:="Media change not applicable (door opened or no disk in unit)";
                END;
                WrStr(S);WrLn;
           END;
           rc:=TRUE;
           EXIT;
        END;
    END;
END;
    RETURN rc;
END doCDdriverRequestIN;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE doCDcommand (callhandle:BOOLEAN;cmd:cmdtype;thisunit:CHAR);
VAR
    rc:BOOLEAN;
BEGIN
    IF callhandle THEN
        rc:= doCDout(cmd,thisunit);
    ELSE
        rc:= doCDdriverRequestOUT(cmd,thisunit);
    END;
END doCDcommand;

PROCEDURE doCDabout (callhandle:BOOLEAN; ch:CHAR);
VAR
    rc:BOOLEAN;
    S:str128;
    doorClosed,diskInUnit:BOOLEAN;
BEGIN
    WrStr("::: ");WrStr(ch);WrStr(": unit status");WrLn;
    WrLn;
    IF callhandle THEN
        rc:=doCDin(ch,ioctlDeviceStatus,  doorClosed,diskInUnit);
        rc:=doCDin(ch,ioctlMediaChange,   doorClosed,diskInUnit);
    ELSE
        rc:=doCDdriverRequestIN(ch,ioctlDeviceStatus,  doorClosed,diskInUnit);
        rc:=doCDdriverRequestIN(ch,ioctlMediaChange,   doorClosed,diskInUnit);
    END;
END doCDabout;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE clicmd (VAR cmd:cmdtype; newcmd:cmdtype );
BEGIN
    IF ( (cmd = nada) OR (cmd = newcmd) ) THEN
        cmd:=newcmd;
    ELSE
        abort(errConflict,"");
    END;
END clicmd;

VAR
    S,R:str128;
    i,opt,parmcount : CARDINAL;
    state:(waiting,waitingover);
    cmd:cmdtype;
    ch:CHAR;
    who:(undefined,defaultunit,allunits,selectedunits);
VAR
    rc:BOOLEAN;
    ncd,cdcount:CARDINAL;
    cdfirst:CHAR;
    wanted,sCDROMletters,sCDROM:str80; (* oversized *)
    callhandle:BOOLEAN;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck:=FALSE; (* very important ! *)
    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    callhandle:=FALSE;
    Str.Copy(wanted,"");
    who:=undefined;
    cmd:=nada;

    state:=waiting;
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "C"+delim+"CLOSE"+delim+
                                  "O"+delim+"OPEN"+delim+"E"+delim+"EJECT"+delim+
                                  "I"+delim+"INFOS"+delim+
                                  "R"+delim+"RESET"+delim+
                                  "L"+delim+"LOCK"+delim+
                                  "U"+delim+"UNLOCK"+delim+
                                  "S"+delim+"STATUS"+delim+
                                  "X"+delim+"HANDLE"
                              );
            CASE opt OF
            | 1,2,3   : abort(errHelp,"");
            | 4,5     : clicmd(cmd,closetray);
            | 6,7,8,9 : clicmd(cmd,opentray);
            | 10,11   : clicmd(cmd,cdinfos);
            | 12,13   : clicmd(cmd,cdreset);
            | 14,15   : clicmd(cmd,cdlock);
            | 16,17   : clicmd(cmd,cdunlock);
            | 18,19   : clicmd(cmd,cdabout);
            | 20      : callhandle:=TRUE;
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            IF state=waiting THEN state:=waitingover;END;
            (* remember Str.Match idiosyncrasies about "?"=1, "*"=0 or more ! *)
            IF same(R,star)=FALSE THEN
                IF Str.Match(R,"?*"+colon)=FALSE THEN
                    Str.Subst(R,colon,""); (* added by error display *)
                    abort(errBadParm,R);
                END;
            END;
            Str.Subst(R,colon,"");
            Str.Append(wanted,R);
            state:=waitingover;
        END;
    END;
    CASE cmd OF
    | nada    :
        abort(errSyntax,"");
    | cdinfos :
        IF state # waiting THEN abort(errSyntax,"");END;
        who:=allunits;
    ELSE
        IF Str.CharPos(wanted,star) # MAX(CARDINAL) THEN
            IF same(wanted,star)=FALSE THEN abort(errBadParm,wanted);END;
            who:=allunits;
        ELSIF same(wanted,"") THEN
            who:=defaultunit;
        ELSE
            removeDups (wanted);
            who:=selectedunits;
        END;
    END;

    (* ok, let's go *)

    getCDROMletters(cdcount, cdfirst, sCDROMletters);
    IF cdcount < 1 THEN abort(errCDROM,"No available CDROM unit !");END;
    getAllCDROMdriverNames(sCDROMletters);
    IF callhandle THEN
        IF Win9XdriverHere (sCDROMletters,  S) THEN abort(err9X,S);END;
    END;

    CASE who OF
    | defaultunit   : Str.Copy(sCDROM,cdfirst);
    | allunits      : Str.Copy(sCDROM,sCDROMletters);
    | selectedunits : Str.Copy(sCDROM,wanted);
    END;
    IF verifyString(sCDROM,sCDROMletters)=FALSE THEN
        abort(errNotCDROMunit,sCDROM);
    END;

    CASE cmd OF
    | cdlock,cdunlock,cdreset,closetray,opentray:
        ncd:=Str.Length(sCDROM);
        FOR i:=1 TO ncd DO
            doCDcommand(callhandle,cmd,sCDROM[i-1]);
        END;
    | cdabout:
        ncd:=Str.Length(sCDROM);
        FOR i:=1 TO ncd DO
           doCDabout(callhandle,sCDROM[i-1]);
           IF i < ncd THEN WrLn;END;
        END;
    | cdinfos:
        WrStr(banner);WrLn;
        WrLn;
        rc:=getMSCDEXversion(2,10,S); (* we should check it's v2.10 or better *)
        WrStr(S);WrStr(", handling ");
        WrCard(cdcount,1);WrStr(" CDROM unit(s) starting at ");
        WrStr(cdfirst);WrStr(":");WrLn;
        WrLn;
        FOR i:=1 TO cdcount DO
            ch:=sCDROMletters[i-1];
            WrStr(ch);WrStr(": ");
            rc:=chkCDROMdrive(ch, S);

            fmtCDROMdata(ch,R);
            Str.Append(S,", ");Str.Append(S,R);
            WrStr(S);WrLn;
        END;
    END;

    abort(errNone,"");
END CDcmd.
