'--------------------------------------------------------------------
' Title    : CheckIOPorts Map Generator
' Author   : who cares ?
' Overview : creates a map from a CHKIO report file
' Future   : no ! ;-)
' Notes    : _very_ minimal checks (later : readonly, redirection, free space...)
' Bugs     : well... writing it ?
'--------------------------------------------------------------------

$CPU            8086 ' for old XTs!

$OPTIMIZE       SIZE
$COMPILE        EXE

$DEBUG MAP      OFF
$DEBUG PBDEBUG  OFF

$LIB COM        OFF
$LIB CGA        OFF
$LIB EGA        OFF
$LIB VGA        OFF
$LIB HERC       OFF
$LIB LPT        OFF
$LIB IPRINT     OFF
$LIB FULLFLOAT  OFF

$ERROR BOUNDS   OFF
$ERROR NUMERIC  OFF
$ERROR OVERFLOW OFF
$ERROR STACK    OFF

$FLOAT          PROCEDURE

$COM            0
$STRING         1 ' 1K strings is enough here
$STACK          2048
$SOUND          1

$DIM            ARRAY

$DYNAMIC

$OPTION         CNTLBREAK OFF

'--------------------------------------------------------------------

DEFINT A-Z
OPTION ARRAY BASE 0
OPTION BINARY BASE 0

%False = 0
%True  = NOT %False

'--------------------------------------------------------------------
'--------------------------------------------------------------------
' needed by Upper$, Lower$, argC, argV$

%quote = &H22 ' CHR$(34) is ["]

' needed by argC, argV$

%blank = &H20 ' CHR$(32) is [space]
%empty = 0
%intoken = 1
%instring = 2

'--------------------------------------------------------------------
' l$ = Upper$(s$)

FUNCTION Upper$ (BYVAL s$) PUBLIC
table$ = table$ + "                                "
table$ = table$ + " !"
table$ = table$ + CHR$(%quote)
table$ = table$ +    "#$%&'()*+,-./0123456789:;<=>?"
table$ = table$ + "@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_"
table$ = table$ + "`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~"
table$ = table$ + "CUEAAAACEEEIIIAAE  OOOUUYOU     "
table$ = table$ + "AIOUNN                          "
table$ = table$ + "                                "
table$ = table$ + "                                "
new$ = ""
sPos = 1
DO UNTIL sPos > LEN(s$)
    char$ = MID$(s$, sPos, 1)
    code = ASC(char$)
    cap$ = MID$(table$, code+1, 1)
    IF cap$=" " THEN
        new$ = new$ + char$
    ELSE
        new$ = new$ + cap$
    END IF
    INCR sPos
LOOP
Upper$ = new$
END FUNCTION

'--------------------------------------------------------------------
' paramcount = argC (cli$)

FUNCTION ArgC (BYVAL s$) PUBLIC
cli$=LTRIM$(RTRIM$(s$))
cliLen = LEN(cli$)
cliPos = 1
argCount = 0
state=%empty
DO UNTIL cliPos > cliLen
    char$=MID$(cli$,cliPos,1)
    code = ASC(char$)
    SELECT CASE state
    CASE %empty
        SELECT CASE code
        CASE %quote
            state=%instring ' begin new string
            arg$=char$
            INCR argCount
        CASE > %blank ' quote already trapped
            state=%intoken ' begin new token
            arg$=char$
            INCR argCount
        END SELECT
    CASE %intoken
        SELECT CASE code
        CASE %quote ' quote in token
            state=%instring ' if string in parameter
            arg$=arg$+char$
        CASE > %blank
            arg$=arg$+char$
        CASE ELSE
            state=%empty ' end of token
        END SELECT
    CASE %instring
        SELECT CASE code
        CASE %quote
            arg$=arg$+char$
            state=%empty ' end of string
        CASE > %blank
            arg$=arg$+char$
        CASE ELSE
            arg$=arg$+CHR$(%blank) ' remove TAB if any
        END SELECT
    END SELECT
    INCR cliPos
LOOP
ArgC = argCount
END FUNCTION

'--------------------------------------------------------------------
' param$ = ArgV$ (cli$, parmnumber) you must take care yourself of case

FUNCTION ArgV$ (BYVAL s$, BYVAL n) PUBLIC
IF n < 1 OR n > ArgC(s$) THEN
    argV$=""
    EXIT FUNCTION
END IF
cli$=LTRIM$(RTRIM$(s$))
cliLen = LEN(cli$)
cliPos = 1
argCount = 0
state=%empty
DO UNTIL cliPos > cliLen
    char$=MID$(cli$,cliPos,1)
    code = ASC(char$)
    SELECT CASE state
    CASE %empty
        IF n = argCount THEN ' argV$ test
            EXIT DO
        END IF
        SELECT CASE code
        CASE %quote
            state=%instring ' begin new string
            arg$=char$
            INCR argCount
        CASE > %blank ' quote already trapped
            state=%intoken ' begin new token
            arg$=char$
            INCR argCount
        END SELECT
    CASE %intoken
        SELECT CASE code
        CASE %quote ' quote in token
            state=%instring ' if string in parameter
            arg$=arg$+char$
        CASE > %blank
            arg$=arg$+char$
        CASE ELSE
            state=%empty ' end of token
        END SELECT
    CASE %instring
        SELECT CASE code
        CASE %quote
            arg$=arg$+char$
            state=%empty ' end of string
        CASE > %blank
            arg$=arg$+char$
        CASE ELSE
            arg$=arg$+CHR$(%blank) ' remove TAB if any
        END SELECT
    END SELECT
    INCR cliPos
LOOP
ArgV$ = arg$
END FUNCTION

'--------------------------------------------------------------------
' ok = Exist(filename$)

FUNCTION Exist(BYVAL filename$) PUBLIC
IF LEN(DIR$(filename$)) > 0 THEN
    Exist = %True
ELSE
    Exist = %False
END IF
END FUNCTION

'--------------------------------------------------------------------
'--------------------------------------------------------------------

' constants

%FirstPort = &H0000
%LastPort  = &H03FF
%DefaultFirstPort = &h0200 ' better safe than sorry

%nada=0
%free=1
%used=2
%skipped=3

'--------------------------------------------------------------------
' externals

DECLARE SUB GetStrLoc() ' PB 3.1 runtime routine for locating strings

'--------------------------------------------------------------------
' global array
DIM STATIC IOport (%FirstPort:%LastPort) ' compile time
SHARED IOport()

'--------------------------------------------------------------------
' global variables

SHARED Programname$,Exename$,Version$,Copyright$
SHARED Banner$

'--------------------------------------------------------------------

Programname$ = "Q&D CheckIOPorts Map Generator"
Exename$     = "CHKIOMAP"
Version$     = "v1.0"
Copyright$   = "by PhG"
Banner$      =Programname$+" "+Version$+" "+Copyright$

'
ON ERROR GOTO Abort

GOTO Start: ' jump to main() ;-)

'--------------------------------------------------------------------
' error handling

%eNone      = 100
%eUsage     = 101
%ejoker     = 102
%ebadfilename=103
%eNotFound  = 104

'--------------------------------------------------------------------

Abort:
IF ERR = %eUsage THEN
    stdoutln Banner$
    stdoutln ""
    stdoutln "Syntax : "+Exename$+" <redirected report> [ > report ]"
    END %eUsage-%eNone
END IF
SELECT CASE ERR
CASE %eUsage
    E$="How can such things be ?" ' praise Bierce !
CASE %ejoker
    E$="No joker allowed in filename"
CASE %ebadfilename
    E$="Illegal filename"
case %eNotFound
    e$="File not found"
CASE ELSE
    E$=HEX$(ERADR) ' ERADR is a longint (7fFFffFF)
    h$="00000000"
    padcount=len(h$)-len(e$)
    hexa$=MID$(h$,1,padcount)
    e$=hexa$+E$
    E$= "Error #"+MID$(STR$(ERR),2)+" at address $"+E$
END SELECT
E$=exename$+" : "+E$+" !"
stdoutln E$
END ERR-%eNone

'--------------------------------------------------------------------

SUB StdOut ( BYVAL Text AS STRING )
! push DS                    ; save DS FOR PowerBASIC
! push WORD Ptr Text         ; push STRING handle ON stack
! CALL GetStrLoc
! jcxz ExitStdOut
! mov  DS, DX
! mov  DX, AX
! mov  AH, &H40              ; DOS WRITE TO file
! mov  BX, 1                 ; file handle 1 is CONS
! INT  &H21
ExitStdOut:
! pop  DS
END SUB

SUB StdOutLn( BYVAL Text AS STRING )
StdOut Text$ + CHR$(13, 10)
END SUB

'--------------------------------------------------------------------

FUNCTION Padhex$ (BYVAL v,BYVAL padcount)
Padstr$ = "0000000000000000" ' 16 digits
padcount = padcount MOD 16 ' better safe than sorry!
S$=HEX$(v)
Padhex$=MID$(Padstr$,1,padcount-LEN(S$))+S$
END FUNCTION

'--------------------------------------------------------------------
' main()

Start:
stdoutln ""
Cli$=Upper$(COMMAND$)
argcount=argc(Cli$)
IF argcount <> 1 THEN ERROR %eusage
f$=ArgV$(cli$,1)
IF LEFT$(f$,1)="/" OR LEFT$(f$,1)="-" THEN ERROR %eusage
SELECT CASE f$
CASE "?","H","HELP","SOS"
	ERROR %eUsage
CASE ELSE
    IF INSTR(F$,ANY "*?") > 0 THEN ERROR %eJoker
    IF TALLY(F$,".") > 1 THEN ERROR %ebadfilename
    if not exist(f$) then error %eNotFound
END SELECT
FOR i = %firstport TO %lastPort
    ioport(i)=%nada
NEXT
hnd=freefile
open "i",#hnd,f$
do until eof(hnd)
    line input #hnd,s$
    ' ?s$
    s$=Upper$(s$)
    ' now this is UGLY ! where's the Code Police ?
    i=instr(s$,"I/O PORT $") ' "I/O port $"
    z$=mid$(s$,i+10+1,4)
    i=val("&h"+z$)
    if     instr(s$,"SAFETY") > 0 THEN '   " was *not* tested, for safety"
        v=%skipped
    ELSEIF instr(s$,"NOT FREE") > 0 THEN ' " is probably NOT free ($"
        v=%used
    ELSEIF instr(s$,"FREE") > 0 THEN '     " is probably free ($"
        v=%free
    else
        v=%nada
    END IF
    ioport(i)=v
loop
close #hnd

chf$="f"
chu$="U"
chx$="!"
chv$="."

hnd=freefile
s$="Numbers are in hexadecimal, "+chf$+"=probably free, "+chu$+"=probably used, "+chx$+"=skipped"
call stdoutln(s$)
call stdoutln("")
s$="base 0123456789ABCDEF 0123456789ABCDEF 0123456789ABCDEF 0123456789ABCDEF"
CALL StdOutLn(s$)
call stdoutln("")
for i=%firstport to %lastport step (4*16)
    s$=padhex$(i,4)
    for j=0 to 3
        s$=s$+" "
        for k=0 to 15
            select case ioport(i+j*16+k)
            case %skipped
                c$=chx$
            case %free
                c$=chf$
            case %used
                c$=chu$
            case %nada
                c$=chv$
            end select
            s$=s$+c$
        next
    next
    call stdoutln(s$)
next
END %eNone-%eNone
