(* ---------------------------------------------------------------
Title         Q&D Date & Time
Author        PhG
Overview      see help
Notes         test with
              dt -f:"$d $m $yy $0d $0m $yyyy $dd $mm h m s 0h 0m 0s !d !0d"
Bugs          not really : implementation quirk
              as we do a global find/replace, we cannot handle "\\"...
              and we do not care about it ! ;-)
              even though we're not proud of it either...
              check centered when format includes escaped chars
Wish List

--------------------------------------------------------------- *)

MODULE DT;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetString, CharCount, same,
aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything,str16,cleantabs;

FROM QD_Text IMPORT
colortype, cursorshapetype, scrolltype,
ff, cr, lf, bs, tab, nl, mincolor, maxcolor,
BW40, CO40, BW80, CO80, CO80x43, CO80x50, MONO,
vesa80x60, vesa132x25, vesa132x43, vesa132x50, vesa132x60,
selectCursorEmulation,
setCursorShape,
handleVesa, setBrightPaper, setBlinkMode,
setFillChar, setFillInk, setFillPaper,
setFillInkPaper, setTxtInk, setTxtPaper, setTxtInkPaper, setWrapMode,
setUseBiosMode, setTabWidth, getScreenData, setWindow,
setMode, restoreMode,
gotoXY, xyToHtabVtab, home, setVisualPage, setActivePage,
scrollWindow, fillTextAttr, cls, writeStr, writeLn, getScreenWidth,
getScreenHeight, getScreenMinX, getScreenMinY, getScreenMaxX, getScreenMaxY,
getMinHtab, getMaxHtab, getMinVtab, getMaxVtab, getUseBiosMode,
getMinHtab, getMaxHtab, getMinVtab, getMaxVtab, getHtab, getVtab,
getWindowWidth, getWindowHeight,
initScreenConsole,
findInkPaperAtStartup, getInkAtStartup, getPaperAtStartup;

IMPORT SYSTEM;
IMPORT Lib;
IMPORT Str;
IMPORT IO;
IMPORT FIO;

(* ------------------------------------------------------------ *)

CONST
    (* aliases for our own procedures *)
    WrStr ::= writeStr;
    WrLn  ::= writeLn;
    WrChar::= writeStr;

CONST
    defaultink  = white;
    defaultpaper= black;

PROCEDURE colorhelp (  );
BEGIN
    setTxtInk(getInkAtStartup());      (* was green *)
    setTxtPaper(getPaperAtStartup());  (* was black *)
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colorhelp;

PROCEDURE color (ink,paper:CARDINAL );
BEGIN
    setTxtInk   (VAL(colortype,ink));
    setTxtPaper (VAL(colortype,paper));
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END color;

(* ------------------------------------------------------------ *)

TYPE
    languagetype = (nolanguageyet,french,english);
CONST
    escch   = "\";
    chDT    = "h"; (* lower case required for pretty display in help *)
    chCRLF  = "n";
    chTAB   = "t";
    chPERCENT="p";

    ChDT    = "H";
    ChCRLF  = "N";
    ChTAB   = "T";
    ChPERCENT="P";

    fmtDT     = escch+chDT;    (* almost C-like ! berk... *)
    fmtCRLF   = escch+chCRLF;    (* C-like ! berk... *)
    fmtTAB    = escch+chTAB;    (* ditto ! *)
    fmtPERCENT= escch+chPERCENT;
    (*
    nl      = CHR(13) + CHR(10);
    tab     = CHR(9);
    *)
    doublequote = '"';
    space       = " ";
    percent     = "%";
    defaultFmtFR           = "$dd !d $mm $yyyy  0hh 0mmn 0ss";
    defaultFmtUS           = "$dd, $mm $d, $yyyy at 0h:0m:0s";
    defaultFmtFRfilestamp  = "!d $mm $yyyy  0hh 0mmn 0ss";
    defaultFmtUSfilestamp  = "$mm $d, $yyyy at 0h:0m:0s";
    undeterminedDayFR      = "<indfini>";
    undeterminedDayUS      = "<undetermined>";
CONST
    ProgEXEname   = "DT";
    ProgTitle     = "Q&D Date & Time";
    ProgVersion   = "v1.0j";
    ProgCopyright = "by PhG";
CONST
    errNone         = 0;
    errHelp         = 1;
    errUnknownOpt   = 2;
    errTooManyParms = 3;
    errBadNumber    = 4;
    errInkRange     = 5;
    errPaperRange   = 6;
    errHtabRange    = 7;
    errVtabRange    = 8;
    errCenterHTAB   = 9;
    errLanguage     = 10;
    errNotFound     = 11;
    errJoker        = 12;
    errMoreHelp     = 13;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
(*
 .........1.........2.........3.........4.........5.........6.........7.........8
 12345678901234567890123456789012345678901234567890123456789012345678901234567890
*)
CONST
    placeholder = "|";
    helpmsg = nl+
ProgTitle+" "+ProgVersion+" "+ProgCopyright+nl+
nl+
"Syntax : "+ProgEXEname+" [-n:$] [-f:$] [-us] [-i:#] [-p:#] [-b] [-c] [-x:#] [-y:#] [string]"+nl+
nl+
"This program prints current or filename date and time."+nl+
nl+
'-f:$  format string (tokens listed in -?? help screen)'+nl+  (* "$[0]<d|m>", "$dd", "$mm", "$yy", "$yyyy", "[0]<h|m|s>" *)
'      French default is "'+defaultFmtFR+'"'+nl+
'      English default is "'+defaultFmtUS+'"'+nl+
"-fr   French (default)"+nl+
"-us   English"+nl+
"-i:#  ink [0..15] -- default is white"+nl+
"-p:#  paper [0..15] -- default is black"+nl+
"-b    monochrome BIOS output (no colors)"+nl+
"-c    center output, valid only if output is a oneliner without any tab"+nl+
"-x:#  horizontal position (htab), valid only if output is a oneliner"+nl+
"-y:#  vertical position (vtab), valid only if output is a oneliner"+nl+
"-n:$  use date and time from f8e3 filename instead of PC clock"+nl+
"-n    append a CRLF to message"+nl+
"-??   more help (to be read at least once !)"+nl+
nl+
"Dark [0..7] : black, blue, green, cyan, red, magenta, brown and gray."+nl+
"Bright [8..15] : gray, blue, green, cyan, red, magenta, yellow and white."+nl+
nl+
"a) String, if specified, should be delimited with double quotes."+nl+
"b) Default program behavior is to append date and time to string,"+nl+
"   unless string contains "+doublequote+fmtDT+doublequote+", which stands for date and time."+nl+
'   Other special substrings are "'+fmtPERCENT+'" for "%", "'+fmtCRLF+'" for CRLF, and "'+fmtTAB+'" for TAB.'+nl+
'c) With -n:$ option, default format strings will not include "$dd" token ;'+nl+
'   "$dd" token will be either "'+undeterminedDayFR+'" or "'+undeterminedDayUS+'".'+nl+
nl+
"Examples : "+ProgEXEname+nl+
"           "+ProgEXEname+" "+doublequote+"Date et heure actuelles : "+doublequote+nl+
"           "+ProgEXEname+" -us ***"+fmtCRLF+fmtTAB+fmtDT+fmtCRLF+"***"+nl+
"           "+ProgEXEname+' -f:"'+"!d.$m.$yyyy"+'"'+nl+
"           "+ProgEXEname+' -f:"'+"$0d-$0m-$yyyy"+'"'+nl+
"           "+ProgEXEname+' -f:"'+"Roman date : $!"+'"'+nl+
"           "+ProgEXEname+' -f:"$d $m $yy $0d $0m $yyyy $dd $mm h m s 0h 0m 0s !d !0d"'+nl+
"           "+ProgEXEname+' -n:C:\WINDOWS\ndislog.TXT -us "Previous boot was "'+nl;

CONST
    morehelpmsg = nl+
"Tokens allowed in format string are :"+nl+
nl+
"$dd     lundi..dimanche / monday..sunday"+nl+
"$d      1..31 (ordinal)"+nl+
"$0d     01..31"+nl+
"$mm     janvier..dcembre / january..december"+nl+
"$m      1..12"+nl+
"$0m     01..12"+nl+
"$yyyy   ####"+nl+
"$yy     00..99"+nl+
"!d      1er..31 (cardinal)"+nl+
"!0d     1er..31"+nl+
"h      0..23"+nl+
"0h     00..23"+nl+
"m      0..59"+nl+
"0m     00..59"+nl+
"s      0..59"+nl+
"0s     00..59"+nl+
"$!      Latin date"+nl;

VAR
    S : str256;
BEGIN
    colorhelp;
    CASE e OF
    | errHelp,errMoreHelp :
        WrStr(helpmsg);
        IF e = errMoreHelp THEN
            WrStr(morehelpmsg);
            e:=errHelp;
        END;
    | errUnknownOpt :
        S := "Illegal "+placeholder+" option !";
        Str.Subst(S,placeholder,einfo);
    | errTooManyParms :
        (* Str.Concat(S,einfo," is just one parameter too many !"); *)
        S := "Enclose string with double quotes !";
    | errBadNumber:
        S := "Illegal value in "+placeholder+" option !";
        Str.Subst(S,placeholder,einfo);
    | errInkRange:
        S := "Ink range is [0..15] !";
    | errPaperRange:
        S := "Paper range is [0..15] !";
    | errHtabRange:
        S := "Horizontal position (htab) is not in legal range !";
    | errVtabRange:
        S := "Vertical position (vtab) is not in legal range !";
    | errCenterHTAB :
        S := "-c and -x:# options are mutually exclusive !";
    | errLanguage:
        S := "-french and -english options are mutually exclusive !";
    | errNotFound:
        S := "Specified "+placeholder+" file does not exist !";
        Str.Subst(S,placeholder,einfo);
    | errJoker:
        S := "At least one illegal joker in "+placeholder+" option !";
        Str.Subst(S,placeholder,einfo);
    ELSE
        S := "This is illogical, Captain !!!";
    END;
    CASE  e OF
    | errNone, errHelp : ;
    ELSE
        WrLn;
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE substring (S1,S2:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    Str.Caps(S2);
    IF Str.Pos(S1,S2) # MAX(CARDINAL) THEN RETURN TRUE; END;
    Str.Lows(S2);
    IF Str.Pos(S1,S2) # MAX(CARDINAL) THEN RETURN TRUE; END;
    RETURN FALSE;
END substring;

PROCEDURE newstring (VAR R:ARRAY OF CHAR; old,new:ARRAY OF CHAR);
BEGIN
    Str.Caps(old);
    IF Str.Pos(R,old) # MAX(CARDINAL) THEN
        Str.Subst(R,old,new);
    ELSE
        Str.Lows(old);
        IF Str.Pos(R,old) = MAX(CARDINAL) THEN RETURN; END;
        Str.Subst(R,old,new);
    END;
END newstring;

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str80;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str80;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    IF pad="" THEN RETURN S; END;
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

TYPE
    datetype = RECORD
        day   : CARDINAL;
        month : CARDINAL;
        year  : CARDINAL;
        dayOfWeek  : Lib.DayType;
    END;
    timetype = RECORD
        hours   : CARDINAL;
        minutes : CARDINAL;
        seconds : CARDINAL;
    END;

PROCEDURE getDateNow (VAR d : datetype);
VAR
    dayOfWeek : Lib.DayType;
BEGIN
    Lib.GetDate(d.year,d.month,d.day,d.dayOfWeek);
END getDateNow;

PROCEDURE getTimeNow (VAR t : timetype);
VAR
    hundredth : CARDINAL;
BEGIN
    Lib.GetTime(t.hours,t.minutes,t.seconds,hundredth);
END getTimeNow;

CONST
    jours   = "dimanche lundi mardi mercredi jeudi vendredi samedi "+
               undeterminedDayFR;
    mois    = "janvier fvrier mars avril mai juin "+
              "juillet aot septembre octobre novembre dcembre";
CONST
    joursUS = "Sunday Monday Tuesday Wednesday Thursday Friday Saturday "+
               undeterminedDayUS;
    moisUS  = "January February March April May June "+
              "July August September October November December";

(* ------------------------------------------------------------ *)

TYPE
    dttype = RECORD
        CASE : BOOLEAN OF
        | TRUE  :
            t : CARDINAL; (* hms is low  *)
            d : CARDINAL; (* ymd is high *)
        | FALSE :
            dt : LONGCARD;
        END;
    END;

(*
Year stored relative to 1980 (ex. 1988 stores as 8)
    year      month    day   

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number

Seconds are 0 to 29 -- DOS stores nearest even / 2
  hours    minutes   seconds 

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

CONST
    DOSbaseyear  = 1980;
CONST
    yyMask=BITSET{9..15};    yyShft=9;
    moMask=BITSET{5..8};     moShft=5;
    ddMask=BITSET{0..4};     ddShft=0;
CONST
    hhMask=BITSET{11..15};   hhShft=11;
    miMask=BITSET{5..10};    miShft=5;
    ssMask=BITSET{0..4};     ssShft=0;

PROCEDURE unpackDate (ymd:CARDINAL;VAR y,m,d:CARDINAL);
BEGIN
    y :=  CARDINAL(BITSET(ymd) * yyMask) >> yyShft ;
    m :=  CARDINAL(BITSET(ymd) * moMask) >> moShft ;
    d :=  CARDINAL(BITSET(ymd) * ddMask) >> ddShft ;
    INC(y,DOSbaseyear);
END unpackDate;

PROCEDURE unpackTime (hms:CARDINAL;VAR h,m,s:CARDINAL);
BEGIN
    h :=  CARDINAL(BITSET(hms) * hhMask) >> hhShft ;
    m :=  CARDINAL(BITSET(hms) * miMask) >> miShft ;
    s :=  CARDINAL(BITSET(hms) * ssMask) >> ssShft ;
    s := s << 1; (* yes, yes, "* 2" works too... *)
END unpackTime;

PROCEDURE getfilestamp (VAR dmy:datetype; VAR hms:timetype;
                       S:ARRAY OF CHAR);
VAR
    hnd:FIO.File;
    rc:BOOLEAN;
    stamp:dttype;
BEGIN
    hnd:=FIO.OpenRead(S);
    IF hnd = MAX(CARDINAL) THEN (* not trapped by fileGetFileStamp() *)
        rc:=FALSE;
    ELSE
        stamp.dt:=FIO.GetFileDate(hnd);
        rc:=TRUE;
    END;
    FIO.Close(hnd);

    unpackDate(stamp.d , dmy.year  ,dmy.month  ,dmy.day );
    (* we should compute dayOfWeek but we're fed up *)
    dmy.dayOfWeek := Lib.DayType(Lib.Saturday);
    INC( dmy.dayOfWeek); (* force undetermined day *)

    unpackTime(stamp.t , hms.hours ,hms.minutes,hms.seconds );
END getfilestamp;

(* ------------------------------------------------------------ *)

(*
    gregorian calendar rule : leap 366 years if divisible by 4
    but centurial years NOT divisible by 4 are common
    Leap years are divisible by 400, or by 4 and not by 100
    1900 is common, 2000 is leap
*)

PROCEDURE getDaysInFebruary (annee:CARDINAL):CARDINAL;
CONST
    common = 28;
    leap   = 29;
BEGIN
    IF (annee MOD 400) = 0 THEN RETURN leap; END;
    IF (((annee MOD 4) = 0) AND ((annee MOD 100) # 0)) THEN RETURN leap; END;
    RETURN common;
END getDaysInFebruary;

PROCEDURE getDaysInMonth (mois,annee:INTEGER):INTEGER;
TYPE
    daysinmonthtype = ARRAY [1..12] OF INTEGER;
CONST
    (*                    JanFevMarAprMayJunJulAugSepOctNovDec *)
    (*                     1  2  3  4  5  6  7  8  9 10 11 12  *)
    dpm = daysinmonthtype(31, 0,31,30,31,30,31,31,30,31,30,31);
VAR
    m : INTEGER;
BEGIN
    m:= dpm[mois];
    IF m=0 THEN m:=getDaysInFebruary(annee);END;
    RETURN m;
END getDaysInMonth;

PROCEDURE latinDate (jour,mois,annee:CARDINAL):str80;
CONST
    calendes = 1;
    nones    = 5;
    ides     = 13;
    veille   = "PRID.";
    sKAL     = "KAL.";
    sNON     = "NON.";
    sID      = "ID.";
CONST
    (* 31-13=18 so go to 20 for safety *)
    countLAT= veille+" III IV V VI VII VIII IX "+
              "X XI XII XIII XIV XV XVI XVII XVIII XIX XX";
    moisLAT = "IAN. FEB. MART. APR. MAI. IUN. "+
              "IUL. AUG. SEPT. OCT. NOV. DEC.";
VAR
    j,m,R:str80;
    v:CARDINAL;
BEGIN
    v:=mois-1;
    Str.ItemS(m,moisLAT," ",v);

    CASE jour OF
    | calendes :
        j:=sKAL;
    | calendes+1..nones-1:
        Str.Prepend(m,sNON);
        v:=(nones-jour)-1;
        Str.ItemS(j,countLAT," ",v);
        IF same(j,veille)=FALSE THEN Str.Prepend(j,"A.D."); END;
    | nones :
        j:=sNON;
    | nones+1..ides-1 :
        Str.Prepend(m,sID);
        v:=(ides-jour)-1;
        Str.ItemS(j,countLAT," ",v);
        IF same(j,veille)=FALSE THEN Str.Prepend(j,"A.D."); END;
    | ides :
        j:=sID;
    ELSE
        v:=getDaysInMonth(mois,annee);
        IF v < jour THEN
            j:="???";
        ELSE
            v:=((v+1)-jour)-1;
            Str.ItemS(j,countLAT," ",v);
        END;
        IF same(j,veille)=FALSE THEN Str.Prepend(j,"A.D."); END;
        INC(mois);
        IF mois > 12 THEN mois := 1; END;
        v:=mois-1;
        Str.ItemS(m,moisLAT," ",v);
        Str.Prepend(m,sKAL);
    END;
    IF j[Str.Length(j)-1] # "." THEN Str.Append(j," ");END;
    Str.Concat(R,j,m);
    RETURN R;
END latinDate;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE oldnew (sOld,sNew:ARRAY OF CHAR;VAR R:ARRAY OF CHAR);
BEGIN
    LOOP
        IF substring(R,sOld)=FALSE THEN EXIT;END;
        newstring(R,sOld,sNew);
    END;
END oldnew;

(*

    order matters !!!

    $dd     lundi..dimanche / monday..sunday
    $d      1..31 (ordinal)
    $0d     01..31
    $mm     janvier..dcembre / january..december
    $m      1..12
    $0m     01..12

    $yyyy   ####
    $yy     00..99

    !d      1er..31 (cardinal)
    !0d     1er..31

    h      0..23
    0h     00..23
    m      0..59
    0m     00..59
    s      0..59
    0s     00..59

    $!      Latin date

*)

PROCEDURE formatNowFormat (usefilestamp:BOOLEAN;
                           refpath,format:ARRAY OF CHAR;language:languagetype;
                           VAR R : ARRAY OF CHAR  );
VAR
    dmy,dmyCHK : datetype;
    hms : timetype;
    S,T    : str16;
    pad    : CHAR;
    v      : CARDINAL;
BEGIN
    IF usefilestamp THEN
        getfilestamp (dmy,hms,refpath);
    ELSE
        getDateNow(dmy);
        getTimeNow(hms);
        (* check midnight crossing *)
        getDateNow(dmyCHK);
        IF NOT (dmy=dmyCHK) THEN getTimeNow(hms); END;
    END;

    Str.Copy(R,format);

    v := ORD(dmy.dayOfWeek);
    CASE language OF
    | french:   Str.ItemS(T,jours," ",v);
    | english:  Str.ItemS(T,joursUS," ",v);
    END;
    (*
    IF usefilestamp THEN
        oldnew("$dd","",R);
    ELSE
    *)
        oldnew("$dd",T,R);
    (*
    END;
    *)

    v:=dmy.day;
    pad := "";   oldnew("$d",    using(v,2,pad), R);
    pad := "0";  oldnew("$0d",   using(v,2,pad), R);

    IF v=1 THEN
    pad := "";   oldnew("!d",    "1er"         , R);
    pad := "0";  oldnew("!0d",   "1er"         , R);
    ELSE
    pad := "";   oldnew("!d",    using(v,2,pad), R);
    pad := "0";  oldnew("!0d",   using(v,2,pad), R);
    END;

    v := dmy.month-1;
    CASE language OF
    | french:   Str.ItemS(T,mois," ",v);
    | english:  Str.ItemS(T,moisUS," ",v);
    END;
    oldnew("$mm",T,R);

    v := dmy.month;
    pad := "";  oldnew("$m",    using(v,2,pad), R);
    pad := "0"; oldnew("$0m",   using(v,2,pad), R);

    v := dmy.year;
    pad := "";  oldnew("$yyyy", using(v,4,pad), R);
    pad := "0";
    IF v >= 1900 THEN (* always here *)
        v  := dmy.year - 1900;IF v > 100 THEN DEC(v,100);END;
    END;
                oldnew("$yy",   using(v,2,pad), R);

    (* getTimeNow() was here *)

    v := hms.hours;
    pad := "";   oldnew("h",    using(v,2,pad), R);
    pad := "0";  oldnew("0h",   using(v,2,pad), R);

    v := hms.minutes;
    pad := "";   oldnew("m",    using(v,2,pad), R);
    pad := "0";  oldnew("0m",   using(v,2,pad), R);

    v := hms.seconds;
    pad := "";   oldnew("s",    using(v,2,pad), R);
    pad := "0";  oldnew("0s",   using(v,2,pad), R);

    (* we could handle some escaped chars here, such as "\n", "\t", "\p" *)

    oldnew ("$!", latinDate(dmy.day,dmy.month,dmy.year), R);

END formatNowFormat;

PROCEDURE computeHtab (len:CARDINAL ):CARDINAL ;
VAR
    mini,maxi,wi,value : CARDINAL;
BEGIN
    mini := getMinHtab(); (* 0.. *)
    maxi := getMaxHtab();
    wi := maxi-mini+1;
    IF wi > len THEN
        value:=(wi-len) DIV 2;
    ELSE
        value := 0;
    END;
    RETURN (mini+value);
END computeHtab;

(* ------------------------------------------------------------ *)

VAR
    parmcount,i,opt : CARDINAL;
    S,R       : str128;
    state     : (waiting,gotstring);
    language  : languagetype;

    ink,paper : CARDINAL;
    centered,addnl  : BOOLEAN;
    htab,vtab : CARDINAL;
    usefilestamp : BOOLEAN;

    refpath   : str128;
    msg       : str128;
    lookfor   : str128;
    replacewith : str128;
    format      : str128;

    len       : CARDINAL;
    dtwashere : BOOLEAN;
    ch        : CHAR;
    getting   : (grab,gotesc);
    v         : LONGCARD;
    DEBUG     : BOOLEAN;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    (* WrLn; not here ! *)
    Str.Copy(msg,"");

    (* handleVesa; *) (* useless, because we won't change video mode *)
    setUseBiosMode ( IsRedirected() );
    findInkPaperAtStartup();
    ink   := ORD(defaultink);
    paper := ORD(defaultpaper);
    centered := FALSE;
    addnl    := FALSE;
    htab := MAX(CARDINAL); (* remember it starts at 0 ! *)
    vtab := MAX(CARDINAL);

    Str.Copy(refpath,"");
    Str.Copy(format,"");
    language     := nolanguageyet;
    state        := waiting;
    usefilestamp := FALSE;

    DEBUG   := FALSE;

    parmcount := Lib.ParamCount();
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        cleantabs(R);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "US"+delim+"UK"+delim+"ENGLISH"+delim+
                                   "I:"+delim+"INK:"+delim+
                                   "P:"+delim+"PAPER:"+delim+
                                   "B"+delim+"BIOS"+delim+
                                   "F:"+delim+"FORMAT:"+delim+
                                   "C"+delim+"CENTER"+delim+
                                   "X:"+delim+"HTAB:"+delim+
                                   "Y:"+delim+"VTAB"+delim+
                                   "FR"+delim+"FRENCH"+delim+
                                   "N:"+delim+"NAME:"+delim+"FILE:"+delim+
                                   "N"+delim+"CRLF"+delim+"NL"+delim+"NEWLINE"+delim+
                                   "??"+delim+"HH"+delim+"MOREHELP"+delim+
                                   "DEBUG"
                               );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5,6:
                CASE language OF
                | nolanguageyet,english : language := english;
                ELSE
                    abort(errLanguage,"");
                END;
            | 7,8:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolor) OR (v > maxcolor) ) THEN abort(errInkRange,"");END;
                ink:=CARDINAL(v);
            | 9,10:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolor) OR (v > maxcolor) ) THEN abort(errPaperRange,"");END;
                paper:=CARDINAL(v);
            | 11,12:
                setUseBiosMode ( TRUE );
            | 13,14:
                GetString(S,format); (* keep case *)
            | 15,16:
                centered:=TRUE;
            | 17,18:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF v >= MAX(CARDINAL) THEN abort(errHtabRange,"");END;
                len := CARDINAL(v);
                IF ( (len < getMinHtab()) OR (len > getMaxHtab()) ) THEN abort(errHtabRange,"");END;
                htab:=len;
            | 19,20:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF v >= MAX(CARDINAL) THEN abort(errVtabRange,"");END;
                len := CARDINAL(v);
                IF ( (len < getMinVtab()) OR (len > getMaxVtab()) ) THEN abort(errVtabRange,"");END;
                vtab:=len;
            | 21,22:
                CASE language OF
                | nolanguageyet,french : language := french;
                ELSE
                    abort(errLanguage,"");
                END;
            | 23,24,25:
                GetString(S,refpath);
                IF chkJoker(refpath) THEN abort(errJoker,S);END;
                IF FIO.Exists(refpath)=FALSE THEN abort(errNotFound,S);END;
                usefilestamp := TRUE;
            | 26,27,28,29:
                addnl := TRUE;
            | 30,31,32:
                abort(errMoreHelp,"");
            | 33:
                DEBUG := TRUE;
            ELSE
                abort(errUnknownOpt,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE state OF
            | waiting :
                Str.Copy(msg,S);
            ELSE
                abort(errTooManyParms,S);
            END;
            INC(state);
        END;
    END;
    IF (centered AND (htab # MAX(CARDINAL)) ) THEN abort(errCenterHTAB,"");END;

    IF language=nolanguageyet THEN language:=french;END;

    color(ink,paper);

    IF same(format,"") THEN
        IF usefilestamp THEN
            CASE language OF
            | french  : Str.Copy(format,defaultFmtFRfilestamp);
            | english : Str.Copy(format,defaultFmtUSfilestamp);
            END;
        ELSE
            CASE language OF
            | french  : Str.Copy(format,defaultFmtFR);
            | english : Str.Copy(format,defaultFmtUS);
            END;
        END;
    END;
    IF DEBUG THEN
        WrStr("msg    : ");WrStr(doublequote);WrStr(msg);WrStr(doublequote);WrLn;
        WrStr("format : ");WrStr(format);WrLn;
    END;
    formatNowFormat(usefilestamp,refpath,format,language,S);

    dtwashere:=FALSE;
    getting:=grab;
    Str.Copy(R,"");

    len := Str.Length(msg);
    i:=0;
    WHILE i < len DO
        ch := msg[i];
        CASE getting OF
        | grab :
            IF ch = escch THEN
                getting:=gotesc;
            ELSE
                Str.Append(R,ch);
            END;
        | gotesc:
            CASE ch OF
            | chDT,ChDT     : Str.Append(R,S); dtwashere:=TRUE;
            | chCRLF,ChCRLF : Str.Append(R,nl);
            | chTAB,ChTAB   :
                IF getUseBiosMode() THEN
                    Str.Append(R,tab);
                ELSE
                    Str.Append(R,tab); (* we did not handle tab, but v1.0e should be ok *)
                END;
            | escch         : Str.Append(R,escch); (* \\ becomes \ *)
            | chPERCENT,ChPERCENT:
                Str.Append(R,percent);
            ELSE
                Str.Append(R,escch); Str.Append(R,ch);
            END;
            getting := grab;
        END;
        INC(i);
    END;
    IF htab=MAX(CARDINAL) THEN htab := getHtab();END;
    IF vtab=MAX(CARDINAL) THEN vtab := getVtab();END;
    IF dtwashere THEN
        len:=Str.Length(R);
        IF centered THEN htab := computeHtab(len);END;
        gotoXY(htab,vtab);
        WrStr(R);
    ELSE
        len:=Str.Length(R)+Str.Length(S);
        IF centered THEN htab := computeHtab(len);END;
        gotoXY(htab,vtab);
        WrStr(R);WrStr(S);
    END;
    colorhelp;
    IF addnl THEN WrLn;END;

    abort(errNone,"");
END DT.


