(* ---------------------------------------------------------------
Title         Q&D Environment Variable
Overview      tsk tsk...
Usage         see help
Notes         I'm probably the only programmer in the world
              still writing little utilities for DOS...
              yes, I know, a mere batch would do...
Bugs          from WinXP, TMP does not match value given by SET
              (PSP access ?)
Wish List

--------------------------------------------------------------- *)

MODULE EV;

IMPORT Lib;
IMPORT Str;

FROM IO IMPORT WrStr, WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory, cleantabs;

(* ------------------------------------------------------------ *)

CONST
    cr = CHR(13);
    lf = CHR(10);
    nl = cr+lf;
CONST
    progEXEname   = "EV";
    progTitle     = "Q&D Environment variable";
    progVersion   = "v1.0c";
    progCopyright = "by PhG";
    banner        = progTitle+" "+progVersion+" "+progCopyright;
CONST
    errNone            = 0;
    errHelp            = 1;
    errUnknownOption   = 2;
    errOnlyOneCommand  = 3;
    errSyntax          = 4;
    errMatchJoker      = 5;

    rcTrue         = 128;
    rcFalse        = 255;
    Strue          = "128";
    Sfalse         = "255";

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)

errmsg =
banner+nl+
nl+
"Syntax 1 : "+progEXEname+" -s [-v] [-t] [-q] [-a] <variable>"+nl+
"Syntax 2 : "+progEXEname+" <*> [-q] [-r]"+nl+
"Syntax 3 : "+progEXEname+" -e [-v] [-t] [-q] [-a] <variable>"+nl+
"Syntax 4 : "+progEXEname+" -i [-v] [-t] [-q] [-a] [-u] <variable> <value>"+nl+
nl+
"  -s  show environment variable value (default)"+nl+
"  -e  if environment variable exists, return code 128, else return code 255"+nl+
"  -i  if environment variable=value, return code 128, else return code 255"+nl+
nl+
"  -a  search for environment variable is case sensitive"+nl+
"  -u  search for environment variable value is case sensitive"+nl+
"  -t  trim environment variable value"+nl+
"  -q  delimit environment variable value with double quotes"+nl+
"  -r  raw display of all variables (similar to SET command)"+nl+
"  -v  verbose (-vv = very verbose)"+nl+
nl+
"With WinXP, values returned may not match those shown by SET command."+nl;

VAR
    S  : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(errmsg);
    | errUnknownOption:
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errOnlyOneCommand:
        S := "Syntax error !"; (* command conflict or missing parameter(s) ! *)
    | errSyntax :
        Str.Copy(S,einfo);
    | errMatchJoker:
        S := 'At least one illegal joker in "|" variable !';
        Str.Subst(S,"|",einfo);
     ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp,rcTrue,rcFalse:
        ;
    ELSE
        WrStr(progEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE chkMatchJokers (S:ARRAY OF CHAR   ):BOOLEAN ;
BEGIN
    IF Str.CharPos(S,"*") # MAX(CARDINAL) THEN RETURN TRUE;END;
    RETURN (Str.CharPos(S,"?") # MAX(CARDINAL) );
END chkMatchJokers;

PROCEDURE getval (ignorecase:BOOLEAN;VAR what:ARRAY OF CHAR;
                  trim:BOOLEAN; VAR R:ARRAY OF CHAR);
BEGIN
    IF ignorecase THEN Str.Caps(what);END;
    Lib.EnvironmentFind(what,R);
    IF trim THEN LtrimBlanks(R);RtrimBlanks(R);END;
END getval;

PROCEDURE printval (delimit:BOOLEAN;S:ARRAY OF CHAR);
BEGIN
    IF delimit THEN WrStr('"');END;
    WrStr(S);
    IF delimit THEN WrStr('"');END;
END printval;

PROCEDURE infoVarEmpty (varname:ARRAY OF CHAR  );
BEGIN
    WrStr(varname);
    WrStr(" is not defined !");
    WrLn;
END infoVarEmpty;

PROCEDURE showrc (rc:CARDINAL);
VAR
    S,S2 : str128;
BEGIN
    CASE rc OF
    | rcTrue:
        S:=Strue; S2:=" (TRUE)";
    | rcFalse:
        S:=Sfalse;S2:=" (FALSE)";
    ELSE
        S:="undefined";S2:="";
    END;
    WrLn;
    WrStr("Return code will be ");
    WrStr(S);IF same(S2,"")=FALSE THEN WrStr(S2);END;
    WrStr(".");WrLn;
END showrc;

PROCEDURE infoVarVal (varname:ARRAY OF CHAR;
                      delimit:BOOLEAN;varvalue:ARRAY OF CHAR   );
BEGIN
    WrStr(varname);
    WrStr("=");
    printval(delimit,varvalue);
    WrLn;
END infoVarVal;

PROCEDURE infoVarDiff (varname:ARRAY OF CHAR;
                       delimit:BOOLEAN;varvalue,valuefound:ARRAY OF CHAR   );
BEGIN
    WrStr(varname);
    WrStr("=");
    printval(delimit,varvalue);
    WrLn;

    WrStr(varname);
    WrStr("=");
    printval(delimit,valuefound);
    WrLn;
END infoVarDiff;

PROCEDURE showAllVars ( reformat,delimit:BOOLEAN );
CONST
    blank = " ";
    equal = "=";
    dquote= '"';
VAR
    i,pass,lastpass,maxp,p : CARDINAL;
    cmd : Lib.CommandType; (* remember this is a pointer ! *)
    S,R : str128;
BEGIN
    maxp:=0;
    IF reformat THEN
        lastpass:=2;
    ELSE
        lastpass:=1;
    END;
    FOR pass:=1 TO lastpass DO
        i:=0;
        LOOP
            cmd:=Lib.Environment(i);
            Lib.FarMove( FarADR(cmd^), FarADR(S), SIZE(cmd^) );
            IF same(S,"") THEN EXIT; END;

            CASE pass OF
            | 1 : IF reformat THEN
                      p:=Str.CharPos(S,equal);
                      IF p # MAX(CARDINAL) THEN (* very, very, very unlikely ! *)
                          IF p > maxp THEN maxp:=p;END;
                      END;
                  ELSE
                      IF delimit THEN
                          Str.Subst(S,equal,equal+dquote);
                          Str.Append(S,dquote);
                      END;
                      WrStr(S);WrLn;
                  END;
            | 2 : (* if lastpass = 2, reformat was true *)
                  p:=Str.CharPos(S,equal);
                  IF p # MAX(CARDINAL) THEN
                      Str.Slice(R,S,0,p-1+1);
                      Str.Delete(S,0,p+1);
                      FOR p:=Str.Length(R)+1 TO maxp DO
                          Str.Append(R,blank);
                      END;
                      Str.Append(R,blank+blank+equal+blank+blank);
                      IF delimit THEN Str.Append(R,dquote);Str.Append(S,dquote);END;

                      Str.Prepend(S,R);
                  END;
                  WrStr(S);WrLn;
            END;

            INC(i);
        END;
    END;
END showAllVars;

(* ------------------------------------------------------------ *)

VAR
    i,opt,parmcount  : CARDINAL;
    S,R              : str128;
    state            : (waiting,gotvar,gotval);
VAR
    varname,varvalue : str128;
    cmd              : (cmdDefault,cmdShowVar,cmdChkVar,cmdChkVarVal);
    veryverbose,verbose,trim,delimit,ignorecasevar,ignorecaseval,reformat:BOOLEAN;
    rc : CARDINAL;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    ignorecasevar := TRUE;
    ignorecaseval := TRUE;
    trim          := FALSE;
    delimit       := FALSE;
    verbose       := FALSE;
    reformat      := TRUE;
    veryverbose   := FALSE;

    cmd   := cmdDefault;
    state := waiting;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "S"+delim+"SHOW"+delim+
                                  "E"+delim+"EXISTS"+delim+
                                  "I"+delim+"IDENTICAL"+delim+
                                  "A"+delim+"CASEVAR"+delim+
                                  "U"+delim+"CASEVALUE"+delim+
                                  "V"+delim+"VERBOSE"+delim+
                                  "T"+delim+"TRIM"+delim+
                                  "Q"+delim+"QUOTED"+delim+
                                  "R"+delim+"RAW"+delim+
                                  "VV"
                              );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5:    IF cmd # cmdShowVar THEN
                          IF cmd # cmdDefault THEN abort(errOnlyOneCommand,"");END;
                      END;
                      cmd := cmdShowVar;
            | 6,7:    IF cmd # cmdChkVar THEN
                          IF cmd # cmdDefault THEN abort(errOnlyOneCommand,"");END;
                      END;
                      cmd := cmdChkVar;
            | 8,9:    IF cmd # cmdChkVarVal THEN
                          IF cmd # cmdDefault THEN abort(errOnlyOneCommand,"");END;
                      END;
                      cmd := cmdChkVarVal;
            |10,11:   ignorecasevar := FALSE;
            |12,13:   ignorecaseval := FALSE;
            |14,15:   verbose:=TRUE;
            |16,17:   trim:=TRUE;
            |18,19:   delimit:=TRUE;
            |20,21:   reformat:=FALSE;
            |22:      verbose:=TRUE;veryverbose:=TRUE;
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            CASE state OF
            | waiting: Str.Copy(varname,S);
            | gotvar : Str.Copy(varvalue,S);
            | gotval : abort(errSyntax,"Parameter overflow !");
            END;
            INC(state);
        END;
    END;
    IF cmd=cmdDefault THEN cmd:=cmdShowVar;END;
    CASE state OF
    | waiting:
        CASE cmd OF
        | cmdShowVar   : abort(errSyntax,"Missing <variable> !");
        | cmdChkVar    : abort(errSyntax,"Missing <variable> !");
        | cmdChkVarVal : abort(errSyntax,"Missing <variable> <value> !");
        END;
    | gotvar:
        CASE cmd OF
        | cmdShowVar   : ;
        | cmdChkVar    : ;
        | cmdChkVarVal : abort(errSyntax,"Missing <value> !");
        END;
    | gotval:
        CASE cmd OF
        | cmdShowVar   : abort(errSyntax,"Unexpected <value> !");
        | cmdChkVar    : abort(errSyntax,"Unexpected <value> !");
        | cmdChkVarVal : ;
        END;
    END;

    CASE cmd OF
    | cmdShowVar:
        IF same(varname,"*") THEN
            showAllVars(reformat,delimit);
        ELSE
            IF chkMatchJokers(varname) THEN abort(errMatchJoker,varname);END;
            getval(ignorecasevar,varname, trim,varvalue);
            IF same(varvalue,"") THEN
                infoVarEmpty(varname);
            ELSE
                infoVarVal(varname,delimit,varvalue);
            END;
        END;
        rc:=errNone;
    | cmdChkVar:
        IF chkMatchJokers(varname) THEN abort(errMatchJoker,varname);END;
        getval(ignorecasevar,varname, trim,varvalue);
        IF same(varvalue,"") THEN
            IF verbose THEN infoVarEmpty(varname);END;
            rc:=rcFalse;
        ELSE
            IF verbose THEN infoVarVal(varname,delimit,varvalue); END;
            rc:=rcTrue;
        END;
        IF veryverbose THEN showrc(rc);END;
    | cmdChkVarVal:
        IF chkMatchJokers(varname) THEN abort(errMatchJoker,varname);END;
        IF ignorecaseval THEN Str.Caps(varvalue);END;
        IF trim THEN LtrimBlanks(varvalue);RtrimBlanks(varvalue);END;
        getval(ignorecasevar,varname, trim,S);
        IF ignorecaseval THEN Str.Caps(S);END;
        IF same(S,"") THEN
            IF verbose THEN infoVarEmpty(varname);END;
            rc:=rcFalse;
        ELSIF same(S,varvalue) THEN
            IF verbose THEN infoVarVal(varname,delimit,varvalue); END;
            rc:=rcTrue;
        ELSE
            IF verbose THEN infoVarDiff(varname,delimit,varvalue,S);END;
            rc:=rcFalse;
        END;
        IF veryverbose THEN showrc(rc);END;
    END;
    abort(rc,"");
END EV.

