(* ---------------------------------------------------------------
Title         Q&D Power OFF for Advanced Power Management BIOSes
Author        PhG
Overview      self-explanatory !
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE PowerOFF;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetString, CharCount, same,
aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles;

IMPORT Lib;
IMPORT Str;
IMPORT IO;
IMPORT SYSTEM;

FROM IO IMPORT WrStr, WrLn;

(* ------------------------------------------------------------ *)

CONST
    sAPM = "Advanced Power Management";
CONST
    ProgEXEname   = "POWEROFF";
    ProgTitle     = "Q&D Power OFF for "+sAPM+" BIOSes";
    ProgVersion   = "v1.0a";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    errNone             = 0;
    errHelp             = 1;
    errOption           = 2;
    errParameter        = 3;
    errAPMnotAvailable  = 4;
    errAPMversion       = 5;
    errAPMdisabled      = 6;
    errAPMinform        = 7;
    errAPMenable        = 8;
    errAPMconnect       = 9;
    errCommand          = 10;
    errDOIT             = 11;
    errTest             = 12;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr = CHR(13);
    lf = CHR(10);
    nl = cr+lf;
(*
    00000000011111111112222222222333333333344444444445555555555666666666677777777778
    1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp =
    Banner+nl+
    nl+
    "Syntax : "+ProgEXEname+" <-yes|-test> [-override]"+nl+
    nl+
    "-y[y|o] do actually turn system off (safety measure)"+nl+
    "-t      do not actually turn system off (test mode)"+nl+
    "-o[o|y] enable APM BIOS functionality even if it is currently disabled"+nl+
    nl+
    'Note -y[y|o] and -o[o|y] options stand for "-y -o" command line.'+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msgHelp);
    | errOption :
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errParameter :
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," parameter !");
    | errAPMnotAvailable:
        S := sAPM+" NOT available !";
    | errAPMversion:
        Str.Concat(S,sAPM+" version ",einfo);Str.Append(S," or later required !");
    | errAPMdisabled:
        S := sAPM+" BIOS power management disabled !";
    | errAPMinform:
        S := sAPM+" BIOS would not accept version information !";
    | errAPMenable:
        S := sAPM+" enable request denied !";
    | errAPMconnect:
        S := sAPM+" real-mode interface not connected !";
    | errCommand:
        S := "Either -y or -t option must be specified !";
    | errDOIT:
        S := "Missing required -y option !";
    | errTest:
        S := "System not turned off, as -t option was specified !";

    ELSE
        S := "This is illogical, Captain !";
    END;
    IF (e <> errNone) AND (e <> errHelp) THEN
        WrStr(ProgEXEname+" : ");
        WrStr(S);
        WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

CONST
    bitAPMdisabled      = 3;
    APMversion10        = 0100H;
    APMversion11        = 0101H;
    APMversion12        = 0102H;
    APMversionRequired  = APMversion11;
    sAPMversionRequired = "1.1";
CONST
    devBIOS          =  0000H; (* BIOS device ID *)
    devAll           =  0001H; (* device ID for all power-managed devices : APM 1.1+ *)
    devAll10         = 0FFFFH; (* same for APM 1.0 *)
    iAPM             =  15H;
VAR
    R : SYSTEM.Registers;

(* 1.0+ *)

PROCEDURE chkAPM (VAR apmMajorMinor,apmStatus,apmError : CARDINAL ) : BOOLEAN;
BEGIN
    R.AX := 5300H;
    R.BX := devBIOS;
    Lib.Intr(R,iAPM);
    apmMajorMinor  := R.AX; (* if success *)
    apmStatus      := R.CX;
    apmError       := CARDINAL(R.AH); (* if error ! *)
    RETURN NOT (SYSTEM.CarryFlag IN R.Flags);
END chkAPM;

(* 1.0+ *)

PROCEDURE connectAPM () : BOOLEAN;
BEGIN
    R.AX := 5301H;
    R.BX := devBIOS;
    Lib.Intr(R,iAPM);
    (* may be already in effect ! *)
    IF NOT (SYSTEM.CarryFlag IN R.Flags) THEN RETURN TRUE; END;
    RETURN (R.AH = 02H); (* interface connection already in effect ? okay ! *)
END connectAPM;

(* 1.1+ *)

PROCEDURE informAPMversion (version:CARDINAL ) : BOOLEAN;
BEGIN
    R.AX := 530EH;
    R.BX := devBIOS;
    R.CX := version;
    Lib.Intr(R,iAPM);
    RETURN NOT (SYSTEM.CarryFlag IN R.Flags);
END informAPMversion;

(* 1.0+ *)

PROCEDURE enableAPM (allDevicesID:CARDINAL):BOOLEAN ;
BEGIN
    R.AX := 5308H;
    R.BX := allDevicesID; (* or only BIOS ??? *)
    R.CX := 0001H; (* enabled *)
    Lib.Intr(R,iAPM);
    RETURN NOT (SYSTEM.CarryFlag IN R.Flags);
END enableAPM;

(* 1.2+ only, maybe 1.1+ too *)

PROCEDURE turnSystemOFF (  );
BEGIN
	R.AX := 5307H;
	R.CX := 0003H;
	R.BX := devAll;
    Lib.Intr(R,iAPM);
END turnSystemOFF;

(* ------------------------------------------------------------ *)

VAR
    parmcount : CARDINAL;
    i,opt     : CARDINAL;
    S,U       : str128;
    apmMajorMinor,apmStatus,apmError : CARDINAL;
    cmd       : (none,doit,test);
    override  : BOOLEAN;
BEGIN
    Lib.DisableBreakCheck();

    WrLn;

    cmd       := none;
    override  := FALSE;

    parmcount := Lib.ParamCount();

    IF parmcount = 0 THEN abort(errHelp,"");END;

    FOR i := 1 TO parmcount DO (* for future extension ! *)
        Lib.ParamStr(S,i);
        Str.Copy(U,S);
        UpperCase(U);
        IF isOption(U) THEN
            opt := GetOptIndex(U, "?"+delim+"H"+delim+"HELP"+delim+
                                  "O"+delim+"OVERRIDE"+delim+
                                  "Y"+delim+"YES"+delim+
                                  "T"+delim+"TEST"+delim+
                                  "YY"+delim+"YO"+delim+"OO"+delim+"OY");
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5:
                override := TRUE;
            | 6,7:
                IF cmd # none THEN abort(errCommand,""); END;
                cmd := doit;
            | 8,9 :
                IF cmd # none THEN abort(errCommand,""); END;
                cmd := test;
            | 10,11,12,13:
                override := TRUE;
                IF cmd # none THEN abort(errCommand,""); END;
                cmd := doit;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            abort(errParameter,S);
        END;
    END;

    IF cmd=none THEN abort(errCommand,"");END;

    WrStr(Banner);WrLn;
    WrLn;

    IF chkAPM(apmMajorMinor,apmStatus,apmError)=FALSE THEN abort(errAPMnotAvailable,"");END;

    IF apmMajorMinor < APMversionRequired THEN abort(errAPMversion,sAPMversionRequired); END;

    IF (bitAPMdisabled IN BITSET(apmStatus)) THEN (* could check apmError=01H power management functionality disabled *)
        IF override=FALSE THEN abort(errAPMdisabled,""); END;
    END;

    IF connectAPM()=FALSE THEN abort(errAPMconnect,"");END;

    IF apmMajorMinor >= APMversion11 THEN
        IF informAPMversion(apmMajorMinor)=FALSE THEN abort(errAPMinform,"");END;
    END;

    IF apmMajorMinor=APMversion10 THEN
        opt:=devAll10;
    ELSE
        opt:=devAll;
    END;
    IF enableAPM(opt)=FALSE THEN abort(errAPMenable,"");END;

    IF cmd=test THEN abort(errTest,"");END;

    IF apmMajorMinor < APMversion12 THEN
        turnSystemOFF();
    ELSE
        turnSystemOFF();
    END;

    (* should, of course, never pass this point ! *)

    abort(errNone,"");
END PowerOFF.

