
(* ---------------------------------------------------------------
Title         Q&D Random Number Generator
Author        PhG
Overview
Notes         minimal error messages and checking, etc.
Bugs
Wish List     are you kidding ?

--------------------------------------------------------------- *)

MODULE rndgen;

IMPORT Lib;
IMPORT Str;
IMPORT IO;
IMPORT FIO;

FROM IO IMPORT WrStr, WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, cleantabs;

FROM QD_rand IMPORT InitRnd, GetRnd,
GetRndCardRange, GetRndLngCardRange,
GetRndLngRealRange, GetRndRealRange;

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "RNDGEN";
    ProgTitle     = "Q&D Random Number Generator";
    ProgVersion   = "v1.0a";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone       = 0;
    errHelp       = 1;
    errOption     = 2;
    errParameter  = 3;
    errRange      = 4;
    errInterval   = 5;
    errBadNum     = 6;
    errSyntax     = 7;
    errJoker      = 8;
    errExists     = 9;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr = CHR(13);
    lf = CHR(10);
    nl = cr+lf;
CONST
(*
        00000000011111111112222222222333333333344444444445555555555666666666677777777778
        1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp =
        Banner+nl+
        nl+
        "Syntax : "+ProgEXEname+" <lower> <upper> [<length> <file> [-o]] [-v[v]] [-alternate]"+nl+
        nl+
        "This program returns in errorlevel a random number in [lower..upper] range."+nl+
        "<lower> and <upper> must belong to the [0..255] range (recommanded for file)."+nl+
        nl+
        "Please note program always returns 0 after an error or after help screen !"+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrLn;
        WrStr(msgHelp);
    | errOption :
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errParameter :
        Str.Concat(S,"Useless ",einfo);Str.Append(S," parameter !");
    | errRange :
        Str.Concat(S,einfo," must be in the [0..255] range !");
    | errInterval :
        S := "<lower> and <upper> should be different !";
    | errBadNum :
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," number !");
    | errSyntax:
        S := "Syntax error !";
    | errJoker:
        Str.Concat(S,einfo," contains at least one joker !");
    | errExists:
        Str.Concat(S,einfo," already exists !");

    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp :
        ;
    ELSE
        WrLn;
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;

    (* Lib.SetReturnCode(SHORTCARD(e)); *)
    Lib.SetReturnCode(errNone); (* force 0 in any case ! *)
    HALT;
END abort;

PROCEDURE chkRange (val:LONGCARD;min,max:CARDINAL):BOOLEAN;
BEGIN
    RETURN ( (val >= LONGCARD(min) ) AND (val <= LONGCARD(max) ) );
END chkRange;

PROCEDURE swapCards (VAR a,b:CARDINAL);
VAR
    tmp:CARDINAL;
BEGIN
    tmp := a;
    a   := b;
    b   := tmp;
END swapCards;

PROCEDURE genrnd (lower,upper:CARDINAL;alternate:BOOLEAN): REAL ;
VAR
    v: REAL;
BEGIN
    IF alternate THEN
        v := REAL( GetRndCardRange( lower,upper ) );
    ELSE
        v := (REAL(upper)-REAL(lower)+1.0) * Lib.RAND() + REAL(lower);
    END;
    RETURN v;
END genrnd;

(* ------------------------------------------------------------ *)

CONST
    minNum = 0;
    maxNum = 255;
    warmup = 32;
    firstio = 0;
    lastio  = 16*512-1+FIO.BufferOverhead;
VAR
    parmcount,i,opt   : CARDINAL;
    S,R           : str128;
    state       : (waiting,gotlower,gotupper,gotcount,gotfile);
    lower,upper : CARDINAL;
    verbose,veryverbose,alternate,overwrite : BOOLEAN;
    lc,flen : LONGCARD;
    rndfile:str128;
    hout : FIO.File;
    v:REAL;
    iobuffer : ARRAY [firstio..lastio] OF BYTE;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck:=FALSE;

    Lib.RANDOMIZE;
    InitRnd;

    FOR i := 1 TO warmup DO
        v := Lib.RAND();
        v := GetRnd();
    END;

    verbose   := FALSE;
    veryverbose:=FALSE;
    alternate := FALSE;
    overwrite := FALSE;

    parmcount := Lib.ParamCount();
    state     := waiting;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "V"+delim+"VERBOSE"+delim+
                                  "VV"+delim+"VERYVERBOSE"+delim+
                                  "A"+delim+"ALTERNATE"+delim+
                                  "O"+delim+"OVERWRITE"
                              );
            CASE opt OF
            | 1,2,3 :  abort(errHelp,"");
            | 4,5 :    verbose:=TRUE;
            | 6,7 :    verbose:=TRUE; veryverbose:=TRUE;
            | 8,9 :    alternate:=TRUE;
            | 10,11:   overwrite:=TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE state OF
            | waiting :
                IF GetLongCard(R,lc)=FALSE THEN abort(errBadNum,S);END;
                IF chkRange(lc,minNum,maxNum)=FALSE THEN abort(errRange,S);END;
                lower := CARDINAL(lc);
            | gotlower:
                IF GetLongCard(R,lc)=FALSE THEN abort(errBadNum,S);END;
                IF chkRange(lc,minNum,maxNum)=FALSE THEN abort(errRange,S);END;
                upper := CARDINAL(lc);
            | gotupper:
                IF GetLongCard(R,flen)=FALSE THEN abort(errBadNum,S);END;
            | gotcount:
                IF chkJoker(R) THEN abort(errJoker,S);END;
                Str.Copy(rndfile,R);
            | gotfile:
                abort(errParameter,S);
            END;
            INC(state);
        END;
    END;
    CASE state OF
    | gotupper:
        IF lower=upper THEN abort(errInterval,""); END;
        IF upper < lower THEN swapCards(lower,upper);END;
        v:=genrnd(lower,upper,alternate);

        IF verbose THEN
            WrLn;
            IF veryverbose THEN
                WrStr("Method : ");
                IF alternate THEN
                    WrStr("QD_Rand");
                ELSE
                    WrStr("TopSpeed");
                END;
                WrLn;
                WrStr("Lower  : ");IO.WrCard(lower,3);WrLn;
                WrStr("Upper  : ");IO.WrCard(upper,3);WrLn;
                WrStr("Random : ");IO.WrShtCard(SHORTCARD(v),3);WrLn;
            ELSE
                IO.WrShtCard( SHORTCARD(v),3);WrLn;
            END;
        END;

        Lib.SetReturnCode(SHORTCARD(v));
        HALT;
    | gotfile:
        IF overwrite=FALSE THEN
            IF FIO.Exists(rndfile) THEN abort(errExists,rndfile);END;
        END;

        (* IF lower=upper THEN abort(errInterval,""); END; *)
        IF upper < lower THEN swapCards(lower,upper);END;

        WrLn;
        WrStr("Creating ");WrStr(rndfile);WrStr(", please wait...");

        hout:=FIO.Create(rndfile);
        FIO.AssignBuffer(hout,iobuffer);
        lc:=0;
        LOOP
            INC(lc);
            IF lc > flen THEN EXIT; END;
            v:=genrnd(lower,upper,alternate);
            FIO.WrBin(hout,SHORTCARD(v),SIZE(SHORTCARD));
        END;
        FIO.Close(hout);
        WrStr(" Done !");WrLn;

        abort(errNone,"");
    ELSE
        abort(errSyntax,"");
    END;

END rndgen.
