(* ---------------------------------------------------------------
Title         Q&D Stamp
Author        PhG
Overview
Notes         ugly code but will stay as is
Bugs
Wish List     mono-user and mono-task by design !
              yes, we could change that... but what for ?

--------------------------------------------------------------- *)

MODULE Stamp;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT IO;
IMPORT SYSTEM;

FROM IO IMPORT WrStr, WrLn;

(* ------------------------------------------------------------ *)

CONST
    extEXE          = ".EXE"; (* upper case *)
    extCURRENT      = ".C!";  (* saved current date/time *)
    extREFERENCE    = ".R!";  (* saved reference date/time *)
    extCHRONO       = ".B!";  (* saved current date/time for chrono *)
    sNunc           = "*";
    sRemRedir       = "; ";
    sCodeAllDead    = "255";
    sCodeNotAllDead = "192";
CONST
    alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    digits   = "0123456789";
    dash     = "-";
    slash    = "/";
    colon    = ":";
    capitalH = "H";
TYPE
    datetype = RECORD
        day   : CARDINAL;
        month : CARDINAL;
        year  : CARDINAL;
    END;
    timetype = RECORD
        hours   : CARDINAL;
        minutes : CARDINAL;
        seconds : CARDINAL;
    END;
    dttype = RECORD
        CASE : BOOLEAN OF
        | TRUE  :
            t : CARDINAL; (* hms is low  *)
            d : CARDINAL; (* ymd is high *)
        | FALSE :
            dt : LONGCARD;
        END;
    END;

CONST
    ProgEXEname   = "STAMP";
    ProgTitle     = "Q&D Stamp";
    ProgVersion   = "v1.0f";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone         = 0;
    errHelp         = 1;
    errUnknownOpt   = 2;
    errParmOverflow = 3;
    errBadDate      = 4;
    errBadTime      = 5;
    errOpening      = 6;
    errGetting      = 7;
    errDosVersion   = 8;
    errSettingDate  = 9;
    errSettingTime  = 10;
    errWriteProtected=11;
    errSyntax       = 12;
    errMissing      = 13;
    errRestoreFirst = 14;
    errBadQuantieme = 15;
    errNonsenseHere = 16;
    errConflict     = 17;
    errElapsedChronoFirst = 18;
    errOneOfUsIsAlive= 192;
    errWeAreAllDead  = 254;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr=CHR(13);
    lf=CHR(10);
    nl=cr+lf;
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg=
Banner+nl+
nl+
"Syntax 1 : "+ProgEXEname+" [-k] <dd-mm-yyyy|"+sNunc+"> [hh:mm[:ss]] [-c]"+nl+
"Syntax 2 : "+ProgEXEname+" <-r> [-q]"+nl+
"Syntax 3 : "+ProgEXEname+" <-s> [-t] [-f]"+nl+
"Syntax 4 : "+ProgEXEname+" <-e> [-t] [-f]"+nl+
"Syntax 5 : "+ProgEXEname+" <-z[z]>"+nl+
"Syntax 6 : "+ProgEXEname+" <-v[v]>"+nl+
nl+
"This program changes current date/time (syntax 1),"+nl+
"restores changed date/time stamp (syntax 2), starts a chrono (syntax 3),"+nl+
"ends started chrono (syntax 4), resets program state (syntax 5),"+nl+
"or checks if any data file used by program exists (syntax 6)."+nl+

nl+
"-k       set new date/time (default)"+nl+
"-r       restore from saved "+ProgEXEname+" filestamp"+nl+
"-s[s|t]  start chrono (-ss = -st = -s -t)"+nl+
"-e[e|t]  end chrono and show elapsed time (-ee = -et = -e -t)"+nl+
"-z[z]    reset program state then terminate"+nl+
"-v[v]    check if any data file used by program exists then terminate"+nl+
nl+
"-q       when restoring, query to change system date/time (use with caution !)"+nl+
"-c       when parsing date, add 2000 to year [0..79] and 1900 to year [80..99]"+nl+
"         (default is add 1900 to year [0..99])"+nl+
"-t       terse mode (syntax 3 and syntax 4 only)"+nl+
'-f       prefix -s and -e with "'+sRemRedir+'"'+nl+
nl+
"a) DOS 3.2 or later is required."+nl+
'b) Date separator is "'+dash+'" or "'+slash+'". Time separator is "'+colon+'" or "'+capitalH+'".'+nl+
'   "'+sNunc+'" means now (current date or time), thus allowing chrono-like function.'+nl+
"c) Program uses "+ProgEXEname+extCURRENT+", "+ProgEXEname+extREFERENCE+" and "+ProgEXEname+extCHRONO+" data files"+nl+
"   (located in executable directory, and all deleted by -z option)."+nl+
"d) -z[z] and -v[v] options ignore any other option or parameter ;"+nl+
"   both options return "+sCodeAllDead+" if no data file exists, else "+sCodeNotAllDead+nl+
"   (-zz and -vv are verbose forms of -z and -v options, showing return code)."+nl+
"e) Note this DOS program is mono-user and mono-task by design :"+nl+
"   running several instances of "+ProgEXEname+" is not recommended,"+nl+
"   for date and time conflicts are sure to happen."+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errUnknownOpt :
        Str.Concat(S,einfo," is not a legal option !");
    | errParmOverflow:
        Str.Concat(S,einfo," is one parameter too many !");
    | errBadDate :
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," date !");
    | errBadTime :
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," time !");
    | errOpening :
        Str.Concat(S,"Problem while opening ",einfo);Str.Append(S," !");
    | errGetting :
        Str.Concat(S,"Problem while retrieving date/time stamp from ",einfo);
        Str.Append(S," !");
    | errDosVersion :
        Str.Concat(S,"DOS version should be at least ",einfo);Str.Append(S," !");
    | errSettingDate :
        S := "Problem while setting new system date, please restore original !";
    | errSettingTime :
        S := "Problem while setting new system time, please restore original !"
    | errWriteProtected :
        Str.Concat(S,einfo," must not be read-only !");
    | errSyntax :
        Str.Concat(S,"Syntax error for ",einfo);Str.Append(S," option !");
    | errMissing :
        Str.Concat(S,einfo," does not exist !");
    | errRestoreFirst :
        S := "Date/Time already altered, use -r option first !";
    | errBadQuantieme:
        S := "Specified day is later than last day in month !";
    | errNonsenseHere:
        Str.Concat(S,einfo," option is a nonsense here !");
    | errConflict:
        S:="-k, -r, -s, -e, -z and -v options are mutually exclusive !";
    | errElapsedChronoFirst:
        S:= "Chrono already started, use -e option first !";
    | errOneOfUsIsAlive:
        S:="";
    | errWeAreAllDead:
        S:="";
    ELSE
        (* S := "How Can Such A Thing B(i)e(rce) ???"; *)
        S:="This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp : ;
    | errOneOfUsIsAlive,errWeAreAllDead: ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(*
PROCEDURE dbgcard (S:ARRAY OF CHAR;v:CARDINAL );
BEGIN
    WrStr(S);WrStr(" ");IO.WrCard(v,4);WrStr(" ");
END dbgcard;

PROCEDURE dbgreal (S: ARRAY  OF  CHAR ; v:LONGREAL   );
VAR
    R:str16;
    ok:BOOLEAN;
BEGIN
    WrStr(S);WrStr(" ");
    Str.FixRealToStr(v,4,R,ok);
    WrStr(R);WrStr(" ");
END dbgreal;
*)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(*
    gregorian calendar rule : leap 366 years if divisible by 4
    but centurial years NOT divisible by 4 are common
    Leap years are divisible by 400, or by 4 and not by 100
    1900 is common, 2000 is leap
*)

PROCEDURE getDaysInFebruary (annee:CARDINAL):CARDINAL;
CONST
    common = 28;
    leap   = 29;
BEGIN
    IF (annee MOD 400) = 0 THEN RETURN leap; END;
    IF (((annee MOD 4) = 0) AND ((annee MOD 100) # 0)) THEN RETURN leap; END;
    RETURN common;
END getDaysInFebruary;

PROCEDURE getDaysInMonth (mois,annee:CARDINAL):CARDINAL;
TYPE
    daysinmonthtype = ARRAY [1..12] OF CARDINAL;
CONST
    (*                    JanFevMarAprMayJunJulAugSepOctNovDec *)
    (*                     1  2  3  4  5  6  7  8  9 10 11 12  *)
    dpm = daysinmonthtype(31, 0,31,30,31,30,31,31,30,31,30,31);
VAR
    m : INTEGER;
BEGIN
    m:= dpm[mois];
    IF m=0 THEN m:=getDaysInFebruary(annee);END;
    RETURN m;
END getDaysInMonth;

(* ------------------------------------------------------------ *)

PROCEDURE SetDate(Year,Month,Day:CARDINAL):BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AH := 2BH; (* or AX=2B00 ? *)
    R.CX := Year;
    R.DH := SHORTCARD(Month);
    R.DL := SHORTCARD(Day);
(*%T _WINDOWS *)
    R.DS := Seg(R);
    R.ES := Seg(R);
(*%E *)
    Lib.Dos(R);
    (* silly bug in Lib tests AX !!! *)
    IF R.AL=0 THEN
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END SetDate;

PROCEDURE SetTime(Hrs,Mins,Secs,Hsecs:CARDINAL):BOOLEAN;
VAR
   R : SYSTEM.Registers;
BEGIN
    R.AH := 2DH;
    R.CH := SHORTCARD(Hrs);
    R.CL := SHORTCARD(Mins);
    R.DH := SHORTCARD(Secs);
    R.DL := SHORTCARD(Hsecs);
    Lib.Dos(R);
    (* silly bug in Lib tests AX !!! *)
    IF R.AL=0 THEN
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END SetTime;

PROCEDURE AtLeastDosVersion (minmajor,minminor:CARDINAL) : BOOLEAN;
VAR
    R             : SYSTEM.Registers;
    minDosVersion : CARDINAL;
    major         : CARDINAL;
    minor         : CARDINAL;
    thisDosVersion: CARDINAL;
BEGIN
    minDosVersion := (minmajor << 8) + minminor;
    R.AX := 3000H;
    Lib.Dos(R);
    major := CARDINAL(R.AL);
    minor := CARDINAL(R.AH);
    thisDosVersion := (major << 8) + minor;
    IF thisDosVersion < minDosVersion THEN RETURN FALSE; END;
    RETURN TRUE;
END AtLeastDosVersion;

PROCEDURE CreateIfNeeded (S : ARRAY OF CHAR);
VAR
    hnd:FIO.File;
BEGIN
    IF FIO.Exists(S)=TRUE THEN RETURN; END;
    hnd:=FIO.Create(S);
    FIO.WrStr(hnd,S); (* anything to avoid 0-length file *)
    FIO.Close(hnd);
END CreateIfNeeded;

PROCEDURE CanWrite (S : ARRAY OF CHAR) : BOOLEAN;
CONST
    spex = FIO.FileAttr{FIO.readonly,FIO.hidden,FIO.system,FIO.archive};
VAR
    D  : FIO.DirEntry;
    rc : BOOLEAN;
BEGIN
    IF FIO.Exists(S)=FALSE THEN RETURN TRUE; END;
    rc := FIO.ReadFirstEntry(S,spex,D); (* assume file exists ! *)
    IF FIO.readonly IN D.attr THEN RETURN FALSE; END;
    RETURN TRUE;
END CanWrite;

PROCEDURE answerY (prompt : ARRAY OF CHAR) : BOOLEAN;
CONST
    yes = str2("Y");
    no  = str2("N");
    oui = str2("O");
    non = str2("N");
VAR
    key : str2;
    rc  : BOOLEAN;
BEGIN
    WrStr(prompt);
    WrStr(" (yes/no) ? ");
    Flushkey;
    key := Waitkey();
    UpperCase(key);
    IF same(key,yes) OR same(key,oui) THEN
        WrStr("Yes");
        rc := TRUE;
    ELSE
        WrStr("No");
        rc := FALSE;
    END;
    RETURN rc;
END answerY;

(* ------------------------------------------------------------ *)

(*
Year stored relative to 1980 (ex. 1988 stores as 8)
    year      month    day   

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

PROCEDURE PackDMY (d,m,y : CARDINAL  ) : CARDINAL;
CONST
    yyMask=BITSET{9..15};
    yyShft=9;
    mmMask=BITSET{5..8};
    mmShft=5;
    ddMask=BITSET{0..4};
    ddShft=0;
BEGIN
    y := (y - 1980) << yyShft;
    m :=          m << mmShft;
    RETURN (y + m + d);
END PackDMY;

(*
Seconds are 0 to 29 -- DOS stores nearest even / 2
  hours    minutes   seconds 

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

PROCEDURE PackHMS (h,m,s:CARDINAL  ) : CARDINAL;
CONST
    hhMask=BITSET{11..15};
    hhShft=11;
    mmMask=BITSET{5..10};
    mmShft=5;
    ssMask=BITSET{0..4};
    ssShft=0;
BEGIN
    h := h << hhShft;
    m := m << mmShft;
    s := s >> 1;
    RETURN (h + m + s);
END PackHMS;

(* ------------------------------------------------------------ *)

PROCEDURE getDateNow (VAR d : datetype);
VAR
    dayOfWeek : Lib.DayType;
BEGIN
    Lib.GetDate(d.year,d.month,d.day,dayOfWeek);
END getDateNow;

PROCEDURE getTimeNow (VAR t : timetype);
VAR
    hundredth : CARDINAL;
BEGIN
    Lib.GetTime(t.hours,t.minutes,t.seconds,hundredth);
END getTimeNow;

PROCEDURE GetDateTimeNow (VAR d : datetype;VAR t : timetype);
VAR
    dayOfWeek : Lib.DayType;
    hundredth : CARDINAL;
BEGIN
    Lib.GetDate(d.year,d.month,d.day,dayOfWeek);
    (* we do not care and do not round hundredth of seconds *)
    Lib.GetTime(t.hours,t.minutes,t.seconds,hundredth);
END GetDateTimeNow;

PROCEDURE PackDateTime (d:datetype;t:timetype) : dttype;
VAR
    dt : dttype;
BEGIN
    dt.d := PackDMY(d.day,d.month,d.year);
    dt.t := PackHMS(t.hours,t.minutes,t.seconds);
    RETURN dt;
END PackDateTime;

PROCEDURE FixSeconds (VAR t : FIO.FileStamp );
BEGIN
    t.Sec:=t.Sec*2; (* this damn GetFileStamp lets seconds DIV 2 = 0..31 ! *)
    IF t.Sec > 59 THEN (* in case it's a weird seconds field : 61 seconds ! *)
        t.Sec := 59;
    END;
END FixSeconds;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    century1900 = 1900;
    century2000 = 2000;
    (* century = 1900; *)

PROCEDURE parseDate (fix2000:BOOLEAN; S : ARRAY OF CHAR;
                     VAR date : datetype) : BOOLEAN;
CONST
    separator=dash;
    legaldateset = digits+separator+alphabet;
    mindd=1;
    maxdd=31;
    minmm=1;
    maxmm=12;
    minyy=1980; (* base year for messdos *)
    maxyy=2099;
VAR
    i : CARDINAL;
    R : str80;
    v : LONGCARD;
    ok: BOOLEAN;
BEGIN
    IF same(S,sNunc) THEN
        getDateNow (date);
        RETURN TRUE;
    END;

    UpperCase(S); (* in case months would be letters *)
    ReplaceChar(S,slash,separator);
    FOR i := 0 TO (Str.Length(S)-1) DO
        IF Str.CharPos(legaldateset,S[i])=MAX(CARDINAL) THEN RETURN FALSE; END;
    END;
    IF CharCount(S,separator) # 2 THEN RETURN FALSE; END;

    Str.ItemS(R,S,separator,0);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF (v < mindd) OR (v > maxdd) THEN RETURN FALSE; END;
    date.day := CARDINAL(v);

    Str.ItemS(R,S,separator,1);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN
        Str.Prepend(R,dash); (* fake command line parameter ! *)
        i := GetOptIndex(R,"JAN"+delim+"JAN"+delim+
                           "FEB"+delim+"FEV"+delim+
                           "MAR"+delim+"MAR"+delim+
                           "APR"+delim+"AVR"+delim+
                           "MAY"+delim+"MAI"+delim+
                           "JUN"+delim+"JUN"+delim+
                           "JUL"+delim+"JUI"+delim+
                           "AUG"+delim+"AOU"+delim+
                           "SEP"+delim+"SEP"+delim+
                           "OCT"+delim+"OCT"+delim+
                           "NOV"+delim+"NOV"+delim+
                           "DEC"+delim+"DEC");
        CASE i OF
        | 1..24 :
            v := LONGCARD(i+1) DIV 2;
        ELSE
            RETURN FALSE;
        END;
    END;
    IF (v < minmm) OR (v > maxmm) THEN RETURN FALSE; END;
    date.month := CARDINAL(v);

    Str.ItemS(R,S,separator,2);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;

    IF fix2000 THEN
        IF v < 100 THEN
            IF v < 80 THEN
                INC(v,century2000);
            ELSE
                INC(v,century1900);
            END;
        END;
    ELSE
        IF v < 100 THEN INC(v,century1900); END;
    END;

    IF (v < minyy) OR (v > maxyy) THEN RETURN FALSE; END;
    date.year := CARDINAL(v);
    RETURN TRUE;
END parseDate;

(* ------------------------------------------------------------ *)

PROCEDURE parseTime (S : ARRAY OF CHAR;
                     VAR time : timetype) : BOOLEAN;
CONST
    separator=colon;
    separatoralt=capitalH;
    legaltimeset = digits+separator+separatoralt;
    minhh=0;
    maxhh=23;
    minmm=0;
    maxmm=59;
    minss=0;
    maxss=59;
VAR
    i : CARDINAL;
    R : str80;
    v : LONGCARD;
    ok: BOOLEAN;
BEGIN
    IF same(S,sNunc) THEN
        getTimeNow (time);
        RETURN TRUE;
    END;

    FOR i := 0 TO (Str.Length(S)-1) DO
        IF Str.CharPos(legaltimeset,S[i])=MAX(CARDINAL) THEN RETURN FALSE; END;
    END;
    LOOP
        IF Str.CharPos(S,separatoralt) = MAX(CARDINAL) THEN EXIT; END;
        Str.Subst(S,separatoralt,separator);
    END;
    i := CharCount(S,separator);
    IF (i # 1) AND (i # 2) THEN RETURN FALSE; END;

    Str.ItemS(R,S,separator,0);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF (v < minhh) OR (v > maxhh) THEN RETURN FALSE; END;
    time.hours := CARDINAL(v);

    Str.ItemS(R,S,separator,1);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF (v < minmm) OR (v > maxmm) THEN RETURN FALSE; END;
    time.minutes := CARDINAL(v);

    CASE i OF
    | 1 :
        time.seconds := minss;
    | 2 :
        Str.ItemS(R,S,separator,2);
        v := Str.StrToCard(R,10,ok);
        IF ok=FALSE THEN RETURN FALSE; END;
        IF (v < minss) OR (v > maxss) THEN RETURN FALSE; END;
        time.seconds := CARDINAL(v);
    END;

    RETURN TRUE;
END parseTime;

(* ------------------------------------------------------------ *)

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str80;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str80;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

PROCEDURE fmtDate (d,m,y:CARDINAL):str80;
CONST
    separator = dash;
    pad="0";
    tmonths ="Jan Fv Mar Avr Mai Jun Jui Ao Sep Oct Nov Dc ";
    tmonths2="Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ";
VAR
    S,S2 : str80;
BEGIN
    Str.Concat(S,using(d,2,pad),separator);
    Str.ItemS(S2,tmonths2," ",m-1);
    Str.Append(S,S2);
    Str.Append(S,separator);
    Str.Append(S,using(y,4,pad));
    RETURN S;
END fmtDate;

PROCEDURE fmtTime (h,m,s:CARDINAL  ):str80;
CONST
    separator = colon;
    pad="0";
VAR
    S : str80;
BEGIN
    Str.Concat(S,using(h,2,pad),separator);
    Str.Append(S,using(m,2,pad));
    Str.Append(S,separator);
    Str.Append(S,using(s,2,pad));
    RETURN S;
END fmtTime;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* ---------------------------------------------------------------
   input  : value
   output : int(value) ie int(0.95) gives 0 (no rounding)

   TRUNC(n) gives only a CARDINAL without rounding either
--------------------------------------------------------------- *)

PROCEDURE int (v : LONGREAL) : LONGREAL;
VAR
    tmp : LONGINT; (* this should be enough! *)
BEGIN
    tmp := VAL(LONGINT,v); (* as intended, does NOT perform any rounding *)
    RETURN VAL(LONGREAL,tmp);
END int;

(* ---------------------------------------------------------------
   input  : value
   output : frac(value)

   frac keeps sign
--------------------------------------------------------------- *)

PROCEDURE frac (v : LONGREAL) : LONGREAL;
BEGIN
    RETURN (v - int (v));
END frac;

(* ---------------------------------------------------------------
   assume day with decimal, and whole date is ok
   valid only for JD >= 0 i.e. NOT before 1.5 Jan -4712 !
   input  : day (with decimals), month, year
   output : JD
--------------------------------------------------------------- *)

PROCEDURE DateToJD (Day,Month,Year:LONGREAL) : LONGREAL;
VAR
    YYYYMMDD  : LONGREAL;
    A,gregorian : LONGREAL; (* gregorian correction *)
    JD        : LONGREAL;
BEGIN
(* dbgreal("DateToJD :: day=",Day);dbgreal("month=",Month);dbgreal("year=",Year); *)
    YYYYMMDD := Year * 10000.0 + Month * 100.0 + Day;
    IF Month < 2.5 THEN
        Year  := Year - 1.0;
        Month := Month + 12.0;
    END;
    IF YYYYMMDD < 15821015.0 THEN (* before 15 october 1582, julian calendar *)
        gregorian := 0.0;
    ELSE
        A         := int (Year / 100.0);
        gregorian := 2.0 - A + int (A / 4.0);
    END;
    JD := int (365.25 * (Year + 4716.0)) + int (30.6001 * (Month + 1.0));
    JD := JD + Day + gregorian - 1524.5;
(* dbgreal("JD=",JD);WrLn; *)
    RETURN JD;
END DateToJD;

(* ---------------------------------------------------------------
   assume JD >= 0
   input  : JD
   output : day (with decimals), month, year
--------------------------------------------------------------- *)

PROCEDURE JDtoDate (JD : LONGREAL; VAR Day,Month,Year : LONGREAL);
VAR
    Z,F,A,alf,B,C,D,E:LONGREAL;
BEGIN
(* dbgreal("JDtoDate :: JD=",JD); *)
    JD := JD + 0.5;
    Z := int(JD);
    F := frac(JD);
    IF Z < 2299161.0 THEN
        A := Z;
    ELSE
        alf := int( (Z - 1867216.25) / 36524.25);
        A := Z + 1.0 + alf - int( alf / 4.0 );
    END;
    B := A + 1524.0;
    C := int ( (B - 122.1) / 365.25);
    D := int ( 365.25 * C );
    E := int ( (B - D) / 30.6001 );
    Day := B - D - int( 30.6001 * E) + F;
    IF E < 13.5 THEN
        Month := E - 1.0;
    ELSE
        Month := E - 13.0;
    END;
    IF Month > 2.5 THEN
        Year := C - 4716.0;
    ELSE
        Year := C - 4715.0;
    END;
(* dbgreal("day=",Day);dbgreal("month=",Month);dbgreal("year=",Year);WrLn; *)
END JDtoDate;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    hoursPerDay      = 24.0;
    minutesPerHour   = 60.0;
    secondsPerMinute = 60.0;

PROCEDURE makeMyDay (dd,hh,mm,ss:CARDINAL ) : LONGREAL;
VAR
    k : LONGREAL;
BEGIN
(* dbgcard("makeMyDay :: dd=",dd);dbgcard("hh=",hh);dbgcard("mm=",mm);dbgcard("ss=",ss); *)
    k := LONGREAL(mm) + LONGREAL(ss) / secondsPerMinute;
    k := LONGREAL(hh) + LONGREAL(k) / minutesPerHour;
    k := LONGREAL(dd) + LONGREAL(k) / hoursPerDay;
(* dbgreal("k=",k);WrLn; *)
    RETURN k;
END makeMyDay;

PROCEDURE unmakeMyDay(fracday:LONGREAL; VAR dd,hh,mm,ss : CARDINAL);
VAR
    day : LONGREAL;
    seconds : LONGCARD; (* 24*60*60=86400 so CARDINAL is not enough *)
BEGIN
(* dbgreal("unmakeMyDay :: fracday=",fracday); *)
    day := int(fracday);
    dd  := CARDINAL(day);
    day := frac(fracday);
    seconds := VAL(LONGCARD, (day * hoursPerDay * minutesPerHour * secondsPerMinute + 0.5) );
    hh := CARDINAL(seconds DIV 3600); (* 60*60 *)
    mm := CARDINAL( (seconds MOD 3600) DIV 60);
    ss := CARDINAL(seconds MOD 60);
    IF hh > 23 THEN (* if this happens... do not bother too much ! *)
        hh := 23;
        mm := 59;
        ss := 59;
    END;
(* dbgcard("dd=",dd);dbgcard("hh=",hh);dbgcard("mm=",mm);dbgcard("ss=",ss);WrLn; *)
END unmakeMyDay;

(* ------------------------------------------------------------ *)

(*
   note we have to add 1900 to DOS filestamp year component
   else we'd get 106 instead of 2006
   furthermore, year being a SHORTCARD, we add century AFTER cast
*)

PROCEDURE SavedPlusElapsed (VAR newdate : datetype;
                            VAR newtime : timetype ;
                            dtsaved : FIO.FileStamp;
                            dtbase  : FIO.FileStamp ):LONGREAL;
CONST
    (* time in days of these operations undetermined for now, assume 1 second *)
    overheadprocesstime = ((1.0 / secondsPerMinute) / minutesPerHour) / hoursPerDay;
VAR
    JDsaved,JDbase,JDnow,delta : LONGREAL;
    d,m,y : LONGREAL;
BEGIN
    d := makeMyDay(CARDINAL(dtsaved.Day),
                   CARDINAL(dtsaved.Hour),
                   CARDINAL(dtsaved.Min),
                   CARDINAL(dtsaved.Sec));
    m := LONGREAL(dtsaved.Month);
    y := LONGREAL(dtsaved.Year)+LONGREAL(century1900); (* +1900 required *)
    JDsaved := DateToJD(d,m,y);

(* dbgreal("JDsaved=",JDsaved);WrLn; *)

    d := makeMyDay(CARDINAL(dtbase.Day),
                   CARDINAL(dtbase.Hour),
                   CARDINAL(dtbase.Min),
                   CARDINAL(dtbase.Sec));
    m := LONGREAL(dtbase.Month);
    y := LONGREAL(dtbase.Year)+LONGREAL(century1900); (* +1900 required *)
    JDbase  := DateToJD(d,m,y);

(* dbgreal("JDbase=",JDbase);WrLn; *)

    GetDateTimeNow(newdate,newtime);
    d := makeMyDay(newdate.day,newtime.hours,newtime.minutes,newtime.seconds);
    m := LONGREAL(newdate.month);
    y := LONGREAL(newdate.year);
    JDnow   := DateToJD(d,m,y);

(* dbgreal("JDnow=",JDnow);WrLn; *)

    delta := JDnow-JDbase;
    JDsaved := JDsaved + delta + overheadprocesstime;
    JDtoDate(JDsaved,d,m,y);
    unmakeMyDay(d,newdate.day,newtime.hours,newtime.minutes,newtime.seconds);
    newdate.year := CARDINAL(y);
    newdate.month:= CARDINAL(m);

(* dbgreal("JDsaved2=",JDsaved);WrLn; *)
(* dbgreal("delta=",delta);WrLn; *)


    RETURN delta;
END SavedPlusElapsed;

(* ------------------------------------------------------------ *)

PROCEDURE plural (v:LONGCARD;S:ARRAY OF CHAR):str128;
CONST
    marker = "$";
VAR
    ok:BOOLEAN;
    R:str128;
BEGIN
    Str.CardToStr(v,R,10,ok);
    Str.Append(R,S);
    IF v > 1 THEN
        Str.Subst(R,marker,"s");
    ELSE
        Str.Subst(R,marker,"");
    END;
    RETURN R;
END plural;

PROCEDURE fmtDHMS (days:LONGREAL):str128;
VAR
    jours,heures,minutes,seconds:LONGCARD;
    R:str128;
    v:LONGREAL;
BEGIN
    v:=ABS(days);
    jours    := VAL(LONGCARD,v); (* as intended, does NOT perform any rounding *)
    v        := frac(v) * hoursPerDay;
    heures   := VAL(LONGCARD,v);
    v        := frac(v) * minutesPerHour;
    minutes  := VAL(LONGCARD,v);
    v        := frac(v) * secondsPerMinute;
    seconds  := VAL(LONGCARD,v+0.5);

    IF seconds >= 60 THEN seconds:=59; END;

    Str.Copy  (R,plural(jours  ," day$, "));
    Str.Append(R,plural(heures ," hour$, "));
    Str.Append(R,plural(minutes," minute$ and "));
    Str.Append(R,plural(seconds," second$"));

    RETURN R;
END fmtDHMS;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    cmdtype = (doUndefined,
              doSave,doRestore,
              doStartChrono,doEndChrono,
              doReset,doCheckState);

PROCEDURE newcmd (VAR cmd:cmdtype;wanted:cmdtype  ):BOOLEAN ;
BEGIN
    IF ( (cmd=doUndefined) OR (cmd=wanted) ) THEN
        cmd:=wanted;
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END newcmd;

(* ------------------------------------------------------------ *)

CONST
    msgStartedChrono  = "Base chrono       : ";
    msgElapsed        = "Interval          : ";
    msgElapsedChrono  = "Elapsed interval  : ";
    msgSaved          = "Saved date/time   : ";
    msgBase           = "Base date/time    : ";
    msgCurrent        = "Current date/time : ";
    msgAt             = " at ";
    msgNewDate        = "New date          : ";
    msgNewTime        = "New time          : ";
    msgPromptDate     = (* "jj-MMM-aaaa" *)     " -- Confirm";
    msgPromptTime     = (* "hh:mm:ss" *)    "   "+msgPromptDate;
CONST
    firstParm  = 1;
    maxParm    = 2;
VAR
    parmcount,i,opt,lastparm : CARDINAL;
    S,R : str128;
    meSave,meBase,meStartedChrono : str128;
    verbose,doQuery,doFix2000,dorem : BOOLEAN;
    dateparm,datenow  : datetype;
    timeparm,timenow  : timetype;
    hnd : FIO.File;
    Fdtsaved,Fdtbase,Fdtchrono,Fdtnow : FIO.FileStamp;
    dtnow,dtbase     : dttype;
    verboserc,ok : BOOLEAN;
    elapsed:LONGREAL;
    n,rc:CARDINAL;
    parm : ARRAY [firstParm..maxParm] OF str128;
    cmd:cmdtype;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    WrLn;

    cmd       := doUndefined;
    doFix2000 := FALSE;
    doQuery   := FALSE;
    verbose   := TRUE;
    dorem     := FALSE;

    Str.Copy(parm[1],sNunc); (* default is now *)
    Str.Copy(parm[2],sNunc); (* idem *)

    Lib.ParamStr(meSave,0);
    Str.Caps(meSave);Str.Subst(meSave,extEXE,extCURRENT);
    Lib.ParamStr(meBase,0);
    Str.Caps(meBase);Str.Subst(meBase,extEXE,extREFERENCE);
    Lib.ParamStr(meStartedChrono,0);
    Str.Caps(meStartedChrono);Str.Subst(meStartedChrono,extEXE,extCHRONO);

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;

    IF AtLeastDosVersion(3,20)=FALSE THEN abort(errDosVersion,"3.20"); END; (* warn now *)

    lastparm:=firstParm-1;
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "R"+delim+"RESTORE"+delim+
                                 "Q"+delim+"QUERY"+delim+
                                 "C"+delim+"2000"+delim+"XXI"+delim+
                                 "S"+delim+"START"+delim+
                                 "E"+delim+"END"+delim+
                                 "K"+delim+"KEEP"+delim+
                                 "T"+delim+"TERSE"+delim+
                                 "SS"+delim+"ST"+delim+
                                 "EE"+delim+"ET"+delim+
                                 "Z"+delim+"ZERO"+delim+"RESET"+delim+"CLEAR"+delim+
                                 "V"+delim+"VERIFY"+delim+"CHECK"+delim+
                                 "ZZ"+delim+
                                 "VV"+delim+
                                 "F"+delim+"REM"
                                 );
            CASE opt OF
            | 1,2,3 :  abort(errHelp,"");
            | 4,5 :    IF newcmd(cmd,doRestore)=FALSE THEN abort(errConflict,S);END;
            | 6,7 :    doQuery := TRUE;
            | 8,9,10:  doFix2000 := TRUE;
            | 11,12:   IF newcmd(cmd,doStartChrono)=FALSE THEN abort(errConflict,S);END;
            | 13,14:   IF newcmd(cmd,doEndChrono)=FALSE THEN abort(errConflict,S);END;
            | 15,16:   IF newcmd(cmd,doSave)=FALSE THEN abort(errConflict,S);END;
            | 17,18:   verbose := FALSE;
            | 19,20:   IF newcmd(cmd,doStartChrono)=FALSE THEN abort(errConflict,S);END;
                       verbose := FALSE;
            | 21,22:   IF newcmd(cmd,doEndChrono)=FALSE THEN abort(errConflict,S);END;
                       verbose := FALSE;
            | 23,24,25,26:
                       IF newcmd(cmd,doReset)=FALSE THEN abort(errConflict,S);END;
            | 27,28,29:IF newcmd(cmd,doCheckState)=FALSE THEN abort(errConflict,S);END;
            | 30:      IF newcmd(cmd,doReset)=FALSE THEN abort(errConflict,S);END;
                       verboserc:=TRUE;
            | 31:      IF newcmd(cmd,doCheckState)=FALSE THEN abort(errConflict,S);END;
                       verboserc:=TRUE;
            | 32,33:   dorem := TRUE;
            ELSE
                abort(errUnknownOpt,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            INC (lastparm);
            IF lastparm > maxParm THEN abort(errParmOverflow,S);END;
            Str.Copy(parm[lastparm],R);
        END;
    END;
    IF cmd=doUndefined THEN cmd:=doSave;END;

    CASE cmd OF
    | doSave:
        IF doQuery THEN abort(errNonsenseHere,"-q");END;
        IF dorem   THEN abort(errNonsenseHere,"-f");END;

        CASE lastparm OF
        | 1,2 :
            IF parseDate(doFix2000, parm[1],dateparm) = FALSE THEN abort(errBadDate,parm[1]);END;
            IF dateparm.day > getDaysInMonth (dateparm.month,dateparm.year) THEN
                abort(errBadQuantieme,"");
            END;
            IF parseTime( parm[2],timeparm) = FALSE THEN abort(errBadTime,parm[2]);END;
            IF FIO.Exists(meSave) THEN abort(errRestoreFirst,"");END;
            IF FIO.Exists(meBase) THEN abort(errRestoreFirst,"");END;
            CreateIfNeeded(meSave);
            CreateIfNeeded(meBase);
        ELSE
            abort(errSyntax,"-k");
        END;
    | doRestore:
        IF lastparm # 0 THEN abort(errSyntax,"-r");END;

        IF doFix2000 THEN abort(errNonsenseHere,"-c");END;
        IF dorem     THEN abort(errNonsenseHere,"-f");END;

        IF FIO.Exists(meSave)=FALSE THEN abort(errMissing,meSave); END;
        IF FIO.Exists(meBase)=FALSE THEN abort(errMissing,meBase); END;
    | doStartChrono:
        IF lastparm # 0 THEN abort(errSyntax,"-s");END;
        IF doQuery THEN abort(errNonsenseHere,"-s");END;
        IF doFix2000 THEN abort(errNonsenseHere,"-s");END;
        IF FIO.Exists(meStartedChrono) THEN abort(errElapsedChronoFirst,"");END;
        CreateIfNeeded(meStartedChrono);
    | doEndChrono:
        IF lastparm # 0 THEN abort(errSyntax,"-e");END;
        IF doQuery THEN abort(errNonsenseHere,"-e");END;
        IF doFix2000 THEN abort(errNonsenseHere,"-e");END;
        IF FIO.Exists(meStartedChrono)=FALSE THEN abort(errMissing,meStartedChrono);END;
    END;

    (*
    WrStr(Banner);WrLn;
    WrLn;
    *)

    CASE cmd OF
    | doSave:
        dtbase:=PackDateTime(dateparm,timeparm);
        hnd:=FIO.OpenRead(meBase);
        IF hnd = MAX(CARDINAL) THEN abort(errOpening,meBase); END;
        FIO.SetFileDate(hnd,dtbase.dt);
        FIO.Close(hnd);

        GetDateTimeNow(datenow,timenow);
        dtnow:=PackDateTime(datenow,timenow);
        hnd:=FIO.OpenRead(meSave);
        IF hnd = MAX(CARDINAL) THEN abort(errOpening,meSave); END;
        FIO.SetFileDate(hnd,dtnow.dt);
        FIO.Close(hnd);

        Str.Concat(S,msgSaved,fmtDate(datenow.day,datenow.month,datenow.year));
        Str.Append(S,msgAt);
        Str.Append(S,fmtTime(timenow.hours,timenow.minutes,timenow.seconds));
        WrStr(S);WrLn;
        WrLn;
        Str.Concat(S,msgNewDate, fmtDate(dateparm.day,dateparm.month,dateparm.year));
        WrStr(S);WrLn;
        Str.Concat(S,msgNewTime, fmtTime(timeparm.hours,timeparm.minutes,timeparm.seconds));
        WrStr(S);WrLn;

        ok := SetDate(dateparm.year,dateparm.month,dateparm.day);
        IF ok = FALSE THEN abort(errSettingDate,""); END;
        ok := SetTime(timeparm.hours,timeparm.minutes,timeparm.seconds,0);
        IF ok = FALSE THEN abort(errSettingTime,""); END;

    | doRestore:
        hnd:=FIO.OpenRead(meBase);
        IF hnd = MAX(CARDINAL) THEN abort(errOpening,meBase); END;
        ok:= FIO.GetFileStamp(hnd,Fdtbase);
        FIO.Close(hnd);
        IF NOT(ok) THEN abort(errGetting,meBase);END;
        FixSeconds(Fdtbase);

        hnd:=FIO.OpenRead(meSave);
        IF hnd = MAX(CARDINAL) THEN abort(errOpening,meSave); END;
        ok:= FIO.GetFileStamp(hnd,Fdtsaved) ;
        FIO.Close(hnd);
        IF NOT(ok) THEN abort(errGetting,meSave); END;
        FixSeconds(Fdtsaved);

        Str.Concat(S,msgSaved, fmtDate (CARDINAL(Fdtsaved.Day),
                               CARDINAL(Fdtsaved.Month),
                               CARDINAL(Fdtsaved.Year)+century1900) ); (* century *)
        Str.Append(S,msgAt);
        Str.Append(S, fmtTime (CARDINAL(Fdtsaved.Hour),
                      CARDINAL(Fdtsaved.Min),
                      CARDINAL(Fdtsaved.Sec)) );
        WrStr(S);WrLn;

        Str.Concat(S,msgBase,  fmtDate (CARDINAL(Fdtbase.Day),
                               CARDINAL(Fdtbase.Month),
                               CARDINAL(Fdtbase.Year)+century1900) ); (* century *)
        Str.Append(S,msgAt);
        Str.Append(S, fmtTime (CARDINAL(Fdtbase.Hour),
                      CARDINAL(Fdtbase.Min),
                      CARDINAL(Fdtbase.Sec)) );
        WrStr(S);WrLn;

        GetDateTimeNow(datenow,timenow);
        Str.Concat(S,msgCurrent, fmtDate(datenow.day,datenow.month,datenow.year));
        Str.Append(S,msgAt);
        Str.Append(S,fmtTime(timenow.hours,timenow.minutes,timenow.seconds));
        WrStr(S);WrLn;
        WrLn;

        elapsed:=SavedPlusElapsed(dateparm,timeparm,  Fdtsaved,Fdtbase);

        Str.Concat(S,msgNewDate, fmtDate(dateparm.day,dateparm.month,dateparm.year));
        WrStr(S);
        CASE doQuery OF
        | FALSE :
            ok := TRUE;
        | TRUE :
            ok := answerY(msgPromptDate);
        END;
        WrLn;
        IF ok THEN
            ok := SetDate(dateparm.year,dateparm.month,dateparm.day);
            IF ok = FALSE THEN abort(errSettingDate,""); END;
        END;

        Str.Concat(S,msgNewTime, fmtTime(timeparm.hours,timeparm.minutes,timeparm.seconds));
        WrStr(S);
        CASE doQuery OF
        | FALSE :
            ok := TRUE;
        | TRUE :
            ok := answerY(msgPromptTime);
        END;
        WrLn;
        IF ok THEN
            ok := SetTime(timeparm.hours,timeparm.minutes,timeparm.seconds,0);
            IF ok = FALSE THEN abort(errSettingTime,""); END;
        END;

        WrLn;
        Str.Concat(S,msgElapsed,fmtDHMS(elapsed));
        WrStr(S);WrLn;

        FIO.Erase(meSave);
        FIO.Erase(meBase);
    | doStartChrono:
        GetDateTimeNow(datenow,timenow);
        dtnow:=PackDateTime(datenow,timenow);
        hnd:=FIO.OpenRead(meStartedChrono);
        IF hnd = MAX(CARDINAL) THEN abort(errOpening,meStartedChrono); END;
        FIO.SetFileDate(hnd,dtnow.dt);
        FIO.Close(hnd);

        Str.Concat(S,msgStartedChrono,fmtDate(datenow.day,datenow.month,datenow.year));
        Str.Append(S,msgAt);
        Str.Append(S,fmtTime(timenow.hours,timenow.minutes,timenow.seconds));
        IF dorem THEN Str.Prepend(S,sRemRedir);END;
        IF verbose THEN WrStr(S);WrLn; END;
    | doEndChrono:
        hnd:=FIO.OpenRead(meStartedChrono);
        IF hnd = MAX(CARDINAL) THEN abort(errOpening,meStartedChrono); END;
        ok:= FIO.GetFileStamp(hnd,Fdtchrono);
        FIO.Close(hnd);
        IF NOT(ok) THEN abort(errGetting,meStartedChrono);END;
        FixSeconds(Fdtchrono);

        Str.Concat(S,msgStartedChrono,  fmtDate (CARDINAL(Fdtchrono.Day),
                               CARDINAL(Fdtchrono.Month),
                               CARDINAL(Fdtchrono.Year)+century1900) ); (* century *)
        Str.Append(S,msgAt);
        Str.Append(S, fmtTime (CARDINAL(Fdtchrono.Hour),
                      CARDINAL(Fdtchrono.Min),
                      CARDINAL(Fdtchrono.Sec)) );
        IF dorem THEN Str.Prepend(S,sRemRedir);END;
        IF verbose THEN WrStr(S);WrLn; END;

        GetDateTimeNow(datenow,timenow);
        Str.Concat(S,msgCurrent, fmtDate(datenow.day,datenow.month,datenow.year));
        Str.Append(S,msgAt);
        Str.Append(S,fmtTime(timenow.hours,timenow.minutes,timenow.seconds));
        IF dorem THEN Str.Prepend(S,sRemRedir);END;
        IF verbose THEN WrStr(S);WrLn; WrLn; END;

        Fdtnow.Day     :=SHORTCARD(datenow.day);
        Fdtnow.Month   :=SHORTCARD(datenow.month);
        Fdtnow.Year    :=SHORTCARD(datenow.year);
        Fdtnow.Hour    :=SHORTCARD(timenow.hours);
        Fdtnow.Min     :=SHORTCARD(timenow.minutes);
        Fdtnow.Sec     :=SHORTCARD(timenow.seconds);

        elapsed:=SavedPlusElapsed(dateparm,timeparm,  Fdtnow,Fdtchrono);
        Str.Concat(S,msgElapsedChrono,fmtDHMS(elapsed));
        IF dorem THEN Str.Prepend(S,sRemRedir);END;
        WrStr(S);WrLn;

        FIO.Erase(meStartedChrono);
    | doReset,doCheckState:
        n:=0;
        FOR i:=1 TO 3 DO
            CASE i OF
            | 1: Str.Copy(S,meSave);
            | 2: Str.Copy(S,meBase);
            | 3: Str.Copy(S,meStartedChrono);
            END;
            R:="::: | |.";
            Str.Subst(R,"|",S);
            IF FIO.Exists(S) THEN
                IF cmd=doReset THEN
                    FIO.Erase(S);
                    S:="was deleted";
                ELSE
                    S:="exists";
                END;
                INC(n);
            ELSE
                S:="does not exist";
            END;
            Str.Subst(R,"|",S);
            WrStr(R);WrLn;
        END;
        IF n=0 THEN
            rc:=errWeAreAllDead;   S:=sCodeAllDead;
        ELSE
            rc:=errOneOfUsIsAlive; S:=sCodeNotAllDead;
        END;
        R:="::: Returning | error code.";
        Str.Subst(R,"|",S);
        IF verboserc THEN
            WrLn;
            WrStr(R);WrLn;
        END;
        abort(rc,"");
    END;

    abort(errNone,"");
END Stamp.

