
(* ---------------------------------------------------------------
Title         see help
Overview      see help
Usage         see help
Notes         
              minimal error messages and checking, etc.
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE XEmem;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT SYSTEM;
IMPORT IO;
IMPORT LIM;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096;

FROM XMS IMPORT XMScheckInstalled, XMSgetDriverFarAddress,
XMSversion, XMSdriverVersion,
XMSproblem, XMSgetErrorCode,
XMSqueryTotalFreeKB, XMSqueryLargestFreeKB,
XMSallocateKB, XMSdeallocateKB, XMSprepareMove, XMSdoMove,
XMSprepareMoveToXMS, XMSprepareMoveFromXMS,
XMSlockBlock, XMSunlockBlock, XMSreAllocateKB,
XMSgetInfoFound, XMSgetInfoBlockSizeKB, XMSgetInfoFreeHandles;

FROM IO IMPORT WrStr, WrLn;

(* ------------------------------------------------------------ *)

CONST
    progEXEname     = "XEMEM";
    progTitle       = "Q&D XMS/EMS Memory";
    progVersion     = "v1.0";
    progCopyright   = "by PhG";
    banner          = progTitle+" "+progVersion+" "+progCopyright;
CONST
    cr              = CHR(13);
    lf              = CHR(10);
    nl              = cr+lf;
    extLOG          = ".LOG";
CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errTooManyParms = 3;
    errBadCmd       = 4;
    errBadMemtype   = 5;
    errBadNumber    = 6;
    errSyntax       = 7;
    errXMS          = 8;
    errLIM          = 9;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)

errmsg =
banner+nl+
nl+
"Syntax 1 : "+progEXEname+" <xms|ems> <grab> <Kb>"+nl+
"Syntax 2 : "+progEXEname+" <xms|ems> <release> <handle>"+nl+
"Syntax 3 : "+progEXEname+" <xms|ems> <status>"+nl+
nl+
progEXEname+extLOG+" contains successful grab or release results."+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(errmsg);
    | errOption:
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errTooManyParms:
        Str.Concat(S,einfo," parameter is one too many !");
    | errBadCmd:
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," command !");
    | errBadMemtype:
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," memory type !");
    | errBadNumber:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," number !");
    | errSyntax:
        S := "Syntax error in command line !";
    | errXMS:
        Str.Concat(S,einfo," !");
    | errLIM:
        Str.Concat(S,einfo," !");

    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp:
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE fmt (base,v,digits:CARDINAL;padchar:CHAR; VAR R : ARRAY OF CHAR);
VAR
    ok : BOOLEAN;
    i  : CARDINAL;
BEGIN
    Str.CardToStr(LONGCARD(v), R, base, ok);
    FOR i:= 1 TO digits DO
        IF Str.Length(R) < digits THEN Str.Prepend(R,padchar);END;
    END;
    IF base=16 THEN Str.Prepend(R,"$");END;
END fmt;

PROCEDURE log (S:ARRAY OF CHAR);
VAR
    hnd:FIO.File;
    F : str16;
BEGIN
    Str.Concat(F,progEXEname,extLOG);
    IF FIO.Exists(F) THEN
        hnd:=FIO.Append(F);
    ELSE
        hnd:=FIO.Create(F);
    END;
    FIO.WrStr(hnd,S);
    FIO.WrLn(hnd);
    FIO.Close(hnd);
END log;

(* ------------------------------------------------------------ *)

PROCEDURE XMSchk (lastcall:ARRAY OF CHAR);
VAR
    S:str128;
    ec:SHORTCARD;
BEGIN
    IF XMSproblem()=FALSE THEN RETURN; END;
    ec:=XMSgetErrorCode();
    fmt(16, CARDINAL(ec),2,"0", S);
    Str.Prepend(S,"XMS error code ");
    Str.Append(S," after ");
    Str.Append(S,lastcall);
    Str.Append(S," call");
    abort(errXMS,S);
END XMSchk;

PROCEDURE XMSmem ();
CONST
    msgTF  = "Total free memory  : ";
    msgLF  = "Largest free block : ";
VAR
    S : str128;
    v : CARDINAL;
BEGIN
    v := XMSqueryTotalFreeKB();
    XMSchk("XMSqueryTotalFreeKB()");
    fmt(10, v,5," ", S);
    Str.Prepend(S,msgTF);Str.Append(S," Kb");
    WrStr(S);WrLn;

    v := XMSqueryLargestFreeKB();
    XMSchk("XMSqueryLargestFreeKB()");
    fmt(10, v,5," ", S);
    Str.Prepend(S,msgLF);Str.Append(S," Kb");
    WrStr(S);WrLn;
END XMSmem;

PROCEDURE XMSinfos (  );
CONST
    msgV   = "XMS version        : ";
    msgDV  = "XMS driver version : ";
    msgADDR= "XMS driver address : ";
(*
*)
VAR
    S : str128;
    v : CARDINAL;
    addr:LONGCARD;
BEGIN
    v := XMSversion();
    fmt(16, v,4,"0", S);
    Str.Prepend(S,msgV);
    WrStr(S);WrLn;

    v := XMSdriverVersion();
    fmt(16, v,4,"0", S);
    Str.Prepend(S,msgDV);
    WrStr(S);WrLn;

    addr:=XMSgetDriverFarAddress();
    (* IO.WrLngHex(addr,10);WrLn; *)
    fmt(16, CARDINAL (addr DIV 65536),4,"0",  S);
    Str.Delete(S,0,1); (* remove $ *)
    Str.Prepend(S,msgADDR);
    WrStr(S);
    fmt(16, CARDINAL (addr MOD 65536),4,"0",  S);
    S[0]:=":"; (* replace $ with : *)
    WrStr(S);WrLn;
    WrLn;
    XMSmem();
END XMSinfos;

(* ------------------------------------------------------------ *)

CONST
    LIMsizePage   = 16384; (* for LIM *)
    bytesPerKB    = 1024;

PROCEDURE LIMchk (lastcall:ARRAY OF CHAR);
VAR
    S:str128;
    ec:SHORTCARD;
BEGIN
    ec := LIM.GetStatus();
    IF ec = 00H THEN RETURN; END;
    fmt(16, CARDINAL(ec),2,"0", S);
    Str.Prepend(S,"LIM error code ");
    Str.Append(S," after ");
    Str.Append(S,lastcall);
    Str.Append(S," call");
    abort(errLIM,S);
END LIMchk;

PROCEDURE LIMgetFreeKB( ):CARDINAL ;
VAR
    freePages : CARDINAL;
    totalbytes: LONGCARD;
    free      : CARDINAL; (* in Kb i.e. 1024 bytes *)
BEGIN
    freePages := LIM.FreePages();
    LIMchk("LIM.GetFreePages()");

    totalbytes := LIMsizePage * LONGCARD(freePages);
    free := CARDINAL ( totalbytes DIV bytesPerKB);

    RETURN free;
END LIMgetFreeKB;

PROCEDURE LIMmem ();
CONST
    msgPF    = "Pages free             : ";
    msgBF    = "Free memory            : ";
VAR
    freePages : CARDINAL;
    totalbytes: LONGCARD;
    free      : CARDINAL; (* in Kb i.e. 1024 bytes *)
    S         : str128;
BEGIN
    freePages := LIM.FreePages();
    LIMchk("LIM.GetFreePages()");

    fmt(10, freePages,5," ", S);
    Str.Prepend(S,msgPF);
    WrStr(S);WrLn;

    totalbytes := LIMsizePage * LONGCARD(freePages);
    free  := CARDINAL ( totalbytes DIV bytesPerKB);
    fmt(10, free,5," ", S);
    Str.Prepend(S,msgBF);
    Str.Append(S," Kb");
    WrStr(S);WrLn;
END LIMmem;

PROCEDURE LIMinfos (  );
CONST
    msgPADDR = "LIM page frame address : ";
VAR
    pageFrame : CARDINAL;
    S         : str128;
BEGIN
    pageFrame := LIM.GetPageFrame();
    LIMchk("LIM.GetPageFrame()");

    fmt(16, pageFrame,4,"0", S);
    Str.Prepend(S,msgPADDR);
    WrStr(S);WrLn;
    LIMmem;
END LIMinfos;

(* ------------------------------------------------------------ *)

PROCEDURE convertCard (S:ARRAY OF CHAR;VAR n:CARDINAL ):BOOLEAN ;
VAR
    base: CARDINAL;
    ok  : BOOLEAN;
    v   : LONGCARD;
BEGIN
    CASE S[0] OF
    | "$":
        Str.Delete(S,0,1);
        base := 16;
    ELSE
        base := 10;
    END;
    v:=Str.StrToCard(S,base,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF v > MAX(CARDINAL) THEN RETURN FALSE; END;
    n := CARDINAL(v);
    RETURN TRUE;
END convertCard;

(* ------------------------------------------------------------ *)

CONST
    msgXMSallocated  = " Kb allocated to XMS handle     ";
    msgXMSdeallocated= " Kb deallocated from XMS handle ";

    msgLIMallocated  =     " KB allocated to LIM handle     ";
    msgLIMdeallocated="Memory deallocated from LIM handle   ";

VAR
    state   : (waiting,gotmem,gotcmd,gotparm);
    cmd     : (none,grab,release,infos);
    memtype : (conventional,xms,ems);
    svalue  : str16;
    wanted  : CARDINAL;
    handle  : CARDINAL;
    rc      : BOOLEAN;
    lc      : LONGCARD;
VAR
    parmcount,i,opt,n : CARDINAL;
    S,R               : str128;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;
    state     := waiting;
    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"
                               );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE state OF
            | waiting :
                n:=getStrIndex(delim,R,"XMS,X,EMS,E,LIM,L");
                CASE n OF
                | 1, 2       : memtype := xms;
                | 3, 4, 5, 6 : memtype := ems;
                ELSE
                    abort(errBadMemtype,S);
                END;
            | gotmem:
                n:=getStrIndex(delim,R, "GRAB,G,ALLOCATE,A,"+
                                        "RELEASE,R,DEALLOCATE,D,"+
                                        "I,INFOS,S,STATUS");
                CASE n OF
                | 1, 2, 3, 4 : cmd:=grab;
                | 5, 6, 7, 8 : cmd:=release;
                | 9, 10,11,12: cmd:=infos;
                ELSE
                    abort(errBadCmd,S);
                END;
            | gotcmd:
                GetString(R,svalue);
                IF convertCard(svalue,wanted)=FALSE THEN abort(errBadNumber,S);END;
            | gotparm:
                abort(errTooManyParms,S);
            END;
            INC(state);
        END;
    END;
    (* check nonsense *)
    CASE state OF
    | gotparm:
        IF cmd = infos THEN abort(errSyntax,"");END;
    | gotcmd:
        IF cmd # infos THEN abort(errSyntax,"");END;
    ELSE
        abort(errSyntax,"");
    END;

    WrStr(banner);WrLn;
    WrLn;

    CASE memtype OF
    | xms:
        IF XMScheckInstalled()=FALSE THEN abort(errXMS,"XMS not available");END;
        CASE cmd OF
        | infos:
            XMSinfos;
        | grab:
            IF wanted > XMSqueryLargestFreeKB() THEN (* ignore unlikely error *)
                abort(errXMS,"Largest free block is smaller than required XMS block");
            END;

            XMSmem;WrLn;

            handle := XMSallocateKB(wanted);
            XMSchk("XMSallocateKB()");

            fmt(10,  wanted,5," ", S);
            fmt(10,  handle,5," ", R);
            Str.Append(S,msgXMSallocated);
            Str.Append(S,R);Str.Append(S," !");
            WrStr(S);WrLn;
            log(S);

            WrLn;XMSmem;
        | release:
            rc:=XMSgetInfoFound(wanted);
            (* XMSchk("XMSgetInfoFound()"); *)
            IF rc=FALSE THEN
                abort(errXMS,"XMS handle to deallocate does not exist");
            END;
            n:=XMSgetInfoBlockSizeKB(wanted);
            XMSchk("XMSgetInfoBlockSizeKB()");

            XMSmem;WrLn;

            XMSdeallocateKB(wanted);
            XMSchk("XMSdeallocateKB()");

            fmt(10,       n,5," ",S);
            fmt(10,  wanted,5," ",R);
            Str.Append(S,msgXMSdeallocated);
            Str.Append(S,R);Str.Append(S," !");
            WrStr(S);WrLn;
            log(S);

            WrLn; XMSmem;
        END;
    | ems:
        IF LIM.LIMPresent = FALSE THEN abort(errLIM,"EMS not available");END;
        CASE cmd OF
        | infos:
            LIMinfos;
        | grab:

            IF wanted > LIMgetFreeKB() THEN
                abort(errLIM,"Free memory is smaller than required LIM memory");
            END;

            LIMmem;WrLn;

            lc:=LONGCARD(wanted) * bytesPerKB;
            lc:=lc DIV LIMsizePage;
            handle := LIM.AllocatePages( CARDINAL(lc) );
            LIMchk("LIM.AllocatePages()");

            fmt(10,  wanted,5," ", S);
            fmt(10,  handle,5," ", R);
            Str.Append(S,msgLIMallocated);
            Str.Append(S,R);Str.Append(S," !");
            WrStr(S);WrLn;
            log(S);

            WrLn;LIMmem;

        | release:

            LIMmem;WrLn;

            LIM.DeAllocatePages(wanted);
            LIMchk("LIM.DeAllocatePages()");

            fmt(10,  wanted,5," ",R);
            Str.Copy(S,msgLIMdeallocated);
            Str.Append(S,R);Str.Append(S," !");
            WrStr(S);WrLn;
            log(S);

            WrLn; LIMmem;

        END;
    END;

    abort(errNone,"");
END XEmem.

