(* ---------------------------------------------------------------
Title         Q&D HTML to ASCII
Author        PhG
Overview      try and convert an HTML file to mere ASCII
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
              using data from HTMSTRIP.INI
              warning : hash can be unique for different strings ! check twice !
              keep case for entities
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE HTM2ASC;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT IO;

FROM IO IMPORT WrStr, WrLn;

FROM Storage IMPORT ALLOCATE,DEALLOCATE,Available;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileIsDirectorySpec,
fileClose;

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "HTM2ASC";
    ProgTitle     = "Q&D HTML to ASCII";
    ProgVersion   = "v1.2b";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    imgMarker     = "<[i]>";
CONST
    extHTM        = ".HTM";
    extASC        = ".ASC";
    extTXT        = ".TXT";
    extKOD        = ".KOD";
CONST
    extINI        = ".INI";
    extBAK        = ".BK!";
    extCOM        = ".COM";
    extEXE        = ".EXE";
    extDLL        = ".DLL";
    extOVR        = ".OVR";
    extOVL        = ".OVL";
    extDRV        = ".DRV";
    extZIP        = ".ZIP";
    extARJ        = ".ARJ";
    extLZH        = ".LZH";
    skippedextensions = extINI+delim+extBAK+delim+extCOM+delim+extEXE+delim+
                        extDLL+delim+extOVR+delim+extOVL+delim+extDRV+delim+
                        extZIP+delim+extARJ+delim+extLZH;
CONST
    dquote   = '"';
    nullchar = 0C;
    dot      = ".";
    dotdot   = dot+dot;
    cr       = CHR(13);
    lf       = CHR(10);
    nl       = cr+lf;
    tab      = CHR(9);
    nltab    = nl+tab;
    space    = " ";
CONST
    lennl    = 2;
    lennltab = 3;
CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errTooManyParms = 3;
    errMissingName  = 4;
    errTooManyFiles = 5;
    errNoMatch      = 6;
    errMissingIni   = 7;
    errTooManyEntities=8;
    errEntityParse  = 9;
    errTooManyCodes = 10;
    errProcessConflict=11;
    errBadExt       = 12;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
CONST
    msghelp=
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" <file["+extHTM+"]> [option]..."+nl+
nl+
"This program converts HTML to ASCII, ignoring all formatting."+nl+
nl+
"   -p   convert <P> to a CR,LF sequence"+nl+
"   -t   convert <P> to a CR,LF,TAB sequence"+nl+
"   -tr  convert <TR> and </TR> to a CR,LF sequence"+nl+
"   -oem convert entities to Windows ANSI OEM"+nl+
"   -wp  keep <B>, <I> and <EM> text attributes for word processing"+nl+
"        (find and replace $b_..._b$, $i_..._i$ and $e_..._e$ codes)"+nl+
"   -i   keep <IMG*> references (-ii = insert "+imgMarker+" marker)"+nl+
"   -f   filter out CRs and LFs found in HTML codes"+nl+
"   -o   overwrite existing target"+nl+
"   -r   reverse processing (dump HTML codes, ignoring script code if any)"+nl+
"   -d   while processing, dump HTML codes to screen"+nl+
"   -s   dump script code (if any) with text"+nl+
"   -x   disable LFN support even if available"+nl+
nl+
skippedextensions+" files will be ignored."+nl+
nl+
"Created files will have the following extensions (according to options) :"+nl+
'"'+extASC+'" (DOS), "'+extTXT+'" (Windows) and "'+extKOD+'" (codes).'+nl;
VAR
    S : str1024;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msghelp);
    | errOption :
        Str.Concat(S,"Option ",einfo);
        Str.Append(S," is illegal !");
    | errTooManyParms :
        Str.Concat(S,einfo," is just one parameter too far !");
    | errMissingName :
        S := "Missing file specification !";
    | errTooManyFiles :
        Str.Concat(S,einfo," specification is matched by too many files !");
    | errNoMatch :
        Str.Concat(S,"No file matches ",einfo);
        Str.Append(S," specification !");
    | errMissingIni :
        Str.Concat(S,"Missing ",einfo);
        Str.Append(S," file !");
    | errTooManyEntities :
        S:="Too many entities are defined !";
    | errEntityParse :
        Str.Concat(S,"Parsing error ! ",einfo);
    | errTooManyCodes:
        S:="Too many codes are defined !";
    | errProcessConflict:
        S:="-p and -t options are mutually exclusive !";
    | errBadExt :
        S:="File extension would prevent file(s) from being processed !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp: ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE legalextension (S,skipthem:ARRAY OF CHAR):BOOLEAN;
VAR
    e3 : str16;
    n:CARDINAL;
    rc:BOOLEAN;
BEGIN

    Str.Caps(S); (* ah, lowercase LFNs... *)

    rc:=TRUE;
    n:=0;
    LOOP
        isoleItemS(e3, skipthem,delim,n);
        IF same(e3,"") THEN EXIT; END;
        IF Str.Pos(S,e3) # MAX(CARDINAL) THEN rc:=FALSE;EXIT; END;
        INC(n);
    END;
    RETURN rc;
END legalextension;

(* ------------------------------------------------------------ *)

TYPE
    pFname = POINTER TO fnameType;
    fnameType = RECORD
        next      : pFname;
        slen      : SHORTCARD;
        str       : CHAR;
    END;

PROCEDURE initList (VAR anchor : pFname );
BEGIN
    anchor := NIL;
END initList;

PROCEDURE freeList (anchor : pFname);
VAR
    needed : CARDINAL;
    p      : pFname;
BEGIN
    (* p:=anchor; *)
    WHILE anchor # NIL DO
        needed := SIZE(fnameType) - SIZE(anchor^.str) + CARDINAL(anchor^.slen);
        p := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=p;
    END
END freeList;

PROCEDURE buildNewPtr (VAR anchor,p:pFname; len:CARDINAL):BOOLEAN;
VAR
    needed : CARDINAL;
BEGIN
    needed := SIZE(fnameType) - SIZE(p^.str) + len;
    IF Available(needed)=FALSE THEN RETURN FALSE; END;
    IF anchor = NIL THEN
        ALLOCATE(anchor,needed);
        p:=anchor;
    ELSE
        p:=anchor;
        WHILE p^.next # NIL DO
            p:=p^.next;
        END;
        ALLOCATE(p^.next,needed);
        p:=p^.next;
    END;
    p^.next := NIL;
    RETURN TRUE;
END buildNewPtr;

(* assume p is valid *)

PROCEDURE getStr (VAR S : pathtype; p:pFname);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(p^.slen);
    Lib.FastMove( ADR(p^.str),ADR(S),len);
    S[len] := nullchar; (* REQUIRED safety ! *)
END getStr;

(* ------------------------------------------------------------ *)

PROCEDURE isReservedEntry (S:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isReservedEntry;

PROCEDURE buildFileList (VAR anchor:pFname;
                        useLFN:BOOLEAN;spec:pathtype;skipext:ARRAY OF CHAR):CARDINAL;
VAR
    count:CARDINAL; (* should do ! *)
    ok,found:BOOLEAN;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    entry : FIO.DirEntry;
    dosattr:FIO.FileAttr;
    entryname:pathtype;
    len : CARDINAL;
    pp:pFname;
    includeme:BOOLEAN;
BEGIN
    count:=0;
    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        includeme := NOT( isReservedEntry(entryname) ); (* skip "." and ".." *)
        includeme := includeme AND legalextension(entryname,skipext);
        IF includeme THEN
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=entry.attr;
            END;
            IF NOT (aD IN dosattr) THEN
                (* if file has no extension, add it as a marker *)
                IF Str.RCharPos(entryname,".")=MAX(CARDINAL) THEN
                    Str.Append(entryname,".");
                END;
                len:=Str.Length(entryname);
                IF buildNewPtr(anchor,pp,len)=FALSE THEN
                    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN MAX(CARDINAL); (* errStorage *)
                END;
                INC(count);
                pp^.slen      := SHORTCARD(len);
                Lib.FastMove ( ADR(entryname),ADR(pp^.str),len );
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN count;
END buildFileList;

PROCEDURE buildPath (VAR path:pathtype; spec:pathtype);
VAR
    u,d,n,e:pathtype;
BEGIN
    Lib.SplitAllPath(spec, u,d,n,e);
    Str.Concat(path, u,d);
    fixDirectory(path); (* safety *)
END buildPath;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBuffer  = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    bufferIn,bufferOut : ioBuffer;

(* ------------------------------------------------------------ *)

CONST
    MAXHASH= 65535; (* max(cardinal) is really enough ! *)
TYPE
    str8 = ARRAY [1-1..8-1] OF CHAR;
    str4 = ARRAY [1-1..4-1] OF CHAR;
TYPE
    entitytype = RECORD
                     hash : CARDINAL;
                     string : str8;
                     DOSreplacement : str4;
                     WINreplacement : str4;
                 END;
CONST
    maxstring = 8;
    maxnew    = 4;
    firstEntity = 1;
    lastEntity  = 500;
    maxEntity   = lastEntity-firstEntity+1;
VAR
    entity : ARRAY[firstEntity..lastEntity] OF entitytype;
    countEntity : CARDINAL;

(* ------------------------------------------------------------ *)

PROCEDURE gotstr (S : ARRAY OF CHAR; VAR R : ARRAY OF CHAR) : BOOLEAN;
CONST
    markdec  = "\";
    markhex1 = "&";
    markhex2 = "H";
    decdigits="0123456789";
    hexdigits=decdigits+"ABCDEF";
VAR
    new    : str128;
    i      : CARDINAL;
    len    : CARDINAL;
    p      : CARDINAL;
    ch     : CHAR;
    status : (waiting,indec,inhex1,inhex2);
    number : str16;
    n      : LONGCARD;
    ok     : BOOLEAN;
BEGIN
    len    := Str.Length(S);
    i      := 0;
    p      := 0;
    status := waiting;
    LOOP
        IF i = len THEN EXIT; END;
        ch := S[i];
        CASE status OF
        | waiting :
            CASE ch OF
            | markdec :
                status:=indec;
                number:="";
            | markhex1:
                status:=inhex1;
                number:="";
            ELSE
                new[p]:=ch;
                INC(p);
            END;
            INC(i);
        | indec :
            IF Str.CharPos(decdigits,ch)#MAX(CARDINAL)THEN
                Str.Append(number,ch);
                INC(i);
            ELSE
                IF same(number,"") THEN
                    new[p]:=markdec;
                ELSE
                    n:=Str.StrToCard(number,10,ok);
                    IF ok=FALSE THEN RETURN FALSE; END;
                    n := n MOD 256;
                    new[p]:=CHR( CARDINAL(n));
                END;
                INC(p);
                status:=waiting;
            END;
        | inhex1 :
            IF ch=markhex2 THEN
                status:=inhex2;
                INC(i);
            ELSE
                new[p]:=markhex1;
                INC(p);
                status:=waiting;
            END;
        | inhex2 :
            IF Str.CharPos(hexdigits,ch)#MAX(CARDINAL)THEN
                Str.Append(number,ch);
                INC(i);
            ELSE
                IF same(number,"") THEN
                    new[p]:=markhex1;
                    INC(p);
                    new[p]:=markhex2;
                ELSE
                    n:= Str.StrToCard(number,16,ok);
                    IF ok=FALSE THEN RETURN FALSE; END;
                    n := n MOD 256;
                    new[p]:=CHR( CARDINAL(n));
                END;
                INC(p);
                status:=waiting;
            END;
        END;
    END;
    CASE status OF
    | indec :
        IF same(number,"") THEN
            new[p]:=markdec;
        ELSE
            n:=Str.StrToCard(number,10,ok);
            IF ok=FALSE THEN RETURN FALSE; END;
            n := n MOD 256;
            new[p]:=CHR( CARDINAL(n));
        END;
        INC(p);
    | inhex1 :
        new[p]:=markhex1;
        INC(p);
    | inhex2 :
        IF same(number,"") THEN
            new[p]:=markhex1;
            INC(p);
            new[p]:=markhex2;
        ELSE
            n:=Str.StrToCard(number,16,ok);
            IF ok=FALSE THEN RETURN FALSE; END;
            n := n MOD 256;
            new[p]:=CHR( CARDINAL(n));
        END;
        INC(p);
    END;
    IF p > maxnew THEN RETURN FALSE; END;
    new[p]:=CHR(0);
    Str.Copy(R,new);
    RETURN TRUE;
END gotstr;

PROCEDURE parseAndStoreEntity (S : ARRAY OF CHAR;index:CARDINAL) : BOOLEAN;
CONST
    sep = "_";
VAR
    R : str128;
    i : CARDINAL;
    newDOS : str4;
    newWIN : str4;
    tmp : str128;
BEGIN
    Str.ItemS(R,S,space+tab,0);
    IF Str.Length(R) > maxstring THEN RETURN FALSE; END;
    entity[index].hash:=Lib.HashString(R,MAXHASH);
    entity[index].string:=str8(R);
    Str.ItemS(R,S,space+tab,2);     (* skip the = sign ! *)
    i := CharCount(R,sep);
    IF i >= 4 THEN (* _7bit_DOS_WIN_ *)
        Str.ItemS(tmp,R,sep,1);
        IF gotstr(tmp,newDOS)=FALSE THEN RETURN FALSE; END;
        Str.ItemS(tmp,R,sep,2);
        IF gotstr(tmp,newWIN)=FALSE THEN RETURN FALSE; END;
    ELSE (* char or \### *)
        IF gotstr(R,newDOS)=FALSE THEN RETURN FALSE; END;
        Str.Copy(newWIN,newDOS);
    END;
    entity[index].DOSreplacement:=newDOS;
    entity[index].WINreplacement:=newWIN;
    RETURN TRUE;
END parseAndStoreEntity;

(* ------------------------------------------------------------ *)

PROCEDURE readEntities (VAR sErr: ARRAY OF CHAR;
                       useLFN:BOOLEAN;ini : pathtype):CARDINAL;
CONST
    rem1 = "#";
    rem2 = ";";
VAR
    hnd : FIO.File;
    S   : str128;
    i   : CARDINAL;
    rc:CARDINAL;
BEGIN
    rc:=errNone;
    Str.Copy(sErr,"");

    countEntity := 0;
    hnd := fileOpenRead(useLFN,ini);
    FIO.AssignBuffer(hnd,bufferIn);
    FIO.EOF:=FALSE;
    LOOP
        IF FIO.EOF=TRUE THEN EXIT; END;
        FIO.RdStr(hnd,S);
        Ltrim(S,space);
        Rtrim(S,space);
        Ltrim(S,tab);
        Rtrim(S,tab);
        IF same(S,"")=FALSE THEN
            IF ( (S[0] # rem1) AND (S[0] # rem2) ) THEN
                IF countEntity >= maxEntity THEN (* = was enough ! ;-) *)
                    rc:=errTooManyEntities;
                    EXIT;
                END;
                IF parseAndStoreEntity(S,(countEntity+firstEntity))=FALSE THEN
                    Str.Copy(sErr,S);
                    rc:=errEntityParse;
                    EXIT;
                END;
                INC(countEntity);
            END;
        END;
    END;
    fileClose(useLFN,hnd);
    RETURN rc;
END readEntities;

(* ------------------------------------------------------------ *)

TYPE
    entrycode = RECORD
        org : str16;
        new : str16;
        len : CARDINAL;
    END;
CONST
    firstcode = 1; (* must be 1 because may be decreased *)
    maxcode   = 32;
VAR
    lastcode  : CARDINAL;
    code      : ARRAY [firstcode..maxcode] OF entrycode;

PROCEDURE addit (find,replace:ARRAY OF CHAR; VAR current:CARDINAL):BOOLEAN;
VAR
    S : str16;
BEGIN
    IF current > maxcode THEN RETURN FALSE; END;
    Str.Concat(S,"<",find);
    Str.Append(S,">");
    Str.Copy(code[current].org, S);
    Str.Copy(code[current].new,replace);
    code[current].len := Str.Length(replace);
    INC(current);
    RETURN TRUE;
END addit;

(* should never return FALSE *)

PROCEDURE initWPlist (wp,tr:BOOLEAN ) : BOOLEAN;
BEGIN
    lastcode := firstcode;
    (* always handle forced line break ! *)
    IF addit( "BR"   , nl     ,lastcode)=FALSE THEN RETURN FALSE; END;

    IF tr THEN
        IF addit( "TR"   , nl     ,lastcode)=FALSE THEN RETURN FALSE; END;
        IF addit("/TR"   , nl     ,lastcode)=FALSE THEN RETURN FALSE; END;
    END;

    IF wp THEN
        IF addit(  "B"   , "$b_"  ,lastcode)=FALSE THEN RETURN FALSE; END;
        IF addit( "/B"   , "_b$"  ,lastcode)=FALSE THEN RETURN FALSE; END;
        IF addit(  "I"   , "$i_"  ,lastcode)=FALSE THEN RETURN FALSE; END;
        IF addit( "/I"   , "_i$"  ,lastcode)=FALSE THEN RETURN FALSE; END;
        IF addit( "EM"   , "$e_"  ,lastcode)=FALSE THEN RETURN FALSE; END;
        IF addit("/EM"   , "_e$"  ,lastcode)=FALSE THEN RETURN FALSE; END;
        IF addit(  "P"   , tab    ,lastcode)=FALSE THEN RETURN FALSE; END;
    END;

    DEC(lastcode);
    RETURN TRUE;
END initWPlist;

(* ------------------------------------------------------------ *)

PROCEDURE wrQ (useLFN:BOOLEAN;S:ARRAY OF CHAR   );
BEGIN
    IF useLFN THEN WrStr(dquote);END;
    WrStr(S);
    IF useLFN THEN WrStr(dquote);END;
END wrQ;

PROCEDURE doConvert (source,target:pathtype;
                   oem,verbose,wp,para,paratab,keepcodes,keepscript,
                   keepimg,imgabrev,filterCRLF,useLFN:BOOLEAN);
CONST
    steps = 10;
    animcmd=animShow;
CONST
    entityON ="&";
    entityOFF=";";
    codeON   ="<";
    codeOFF  =">";
    scriptON = codeON+"SCRIPT"+codeOFF;
    scriptOFF= codeON+"/SCRIPT"+codeOFF;
    highest  = 1023;
    paracode = codeON+"P"+codeOFF;
    imgcode  = codeON+"IMG"; (* trailing space ? *)
    lenimgcode=4;
VAR
    lastportion,portion,currportion:LONGCARD;
VAR
    hndIn : FIO.File;
    hndOut: FIO.File;
    got   : CARDINAL;
    ch	  : CHAR;

    status: (waiting,inentity,incode);
    tmp   : ARRAY [0..highest] OF CHAR;
    i     : CARDINAL;
    hash  : CARDINAL;
    n     : CARDINAL;
    ndx   : CARDINAL;
    ch4   : str4;
    addr  : LONGCARD;
    normal: BOOLEAN;
    dmp   : BOOLEAN; (* flag for <script>..</script> *)
    S2    : str16;
BEGIN
    dmp   :=TRUE; (* obvious default ! *)
    normal:=NOT(keepcodes);
    IF verbose=FALSE THEN
        (* Work(cmdInit); *)
        (* completed (completedInit, getFileSize(source)); *)
        animInit(steps, "[", "]", CHR(46), "", "\/" );
        portion:=fileGetFileSize(useLFN,source) DIV steps; INC(portion); (* avoid DIV 0 ! *)
        lastportion := steps+1;

        addr := 0;
    END;
    IF verbose THEN
        WrLn;
        WrStr("Source file : "); wrQ(useLFN,source); WrLn;
        WrStr("Target file : "); wrQ(useLFN,target); WrLn;
        WrLn;
    END;
    hndIn :=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hndIn,bufferIn);
    hndOut:=fileCreate(useLFN,target);
    FIO.AssignBuffer(hndOut,bufferOut);
    FIO.EOF:=FALSE;
    status:=waiting;
    LOOP
        IF FIO.EOF THEN EXIT; END;
        got:=FIO.RdBin(hndIn,ch,1);
        IF got # 1 THEN EXIT;END;
        CASE status OF
        | waiting :
            CASE ch OF
            | entityON :
                tmp[0]:=ch;
                i:=1;
                status:=inentity;
            | codeON :
                tmp[0]:=ch;
                i:=1;
                status:=incode;
            ELSE
                IF (normal AND dmp) THEN
                    (*
                    IF filterCRLF THEN
                        CASE ch OF
                        | cr,lf : ;
                        ELSE
                        FIO.WrBin(hndOut,ch,1);
                        END;
                    ELSE
                        FIO.WrBin(hndOut,ch,1);
                    END;
                    *)
                    FIO.WrBin(hndOut,ch,1);
                END;
            END;
        | inentity :
            IF i < maxstring THEN
                tmp[i]:=ch;
                INC(i);
                IF ch = entityOFF THEN
                    tmp[i]:=CHR(0); (* maxstring < highest, so always mark end of string *)
                    hash:=Lib.HashString(tmp,MAXHASH);
                    n:=0;
                    LOOP
                        IF n >= countEntity THEN EXIT; END;
                        IF hash=entity[n+firstEntity].hash THEN
                            IF same(tmp,entity[n+firstEntity].string) THEN EXIT; END;
                        END;
                        INC(n);
                    END;
                    IF n >= countEntity THEN
                        IF normal THEN FIO.WrBin(hndOut,tmp,i); END;
                        status:=waiting;
                    ELSE
                        CASE oem OF
                        | FALSE :
                            ch4:=entity[n+firstEntity].DOSreplacement;
                        | TRUE :
                            ch4:=entity[n+firstEntity].WINreplacement;
                        END;
                        IF normal THEN FIO.WrStr(hndOut,ch4); END;
                        status:=waiting;
                    END;
                END;
            ELSE
                IF normal THEN
                    FIO.WrBin(hndOut,tmp,maxstring);
                    FIO.WrBin(hndOut,ch,1);
                END;
                status:=waiting;
            END;
        | incode :
            IF i < highest THEN
                tmp[i]:=ch;
                INC(i);
                IF ch=codeOFF THEN
                    IF i < highest THEN tmp[i]:=CHR(0); END;
                    Str.Caps(tmp);
                    IF filterCRLF THEN
                        WHILE Str.CharPos(tmp,cr) # MAX(CARDINAL) DO
                             Str.Subst(tmp,cr,"");
                        END;
                        WHILE Str.CharPos(tmp,lf) # MAX(CARDINAL) DO
                             Str.Subst(tmp,lf,"");
                        END;
                    END;

                    IF keepscript=FALSE THEN
                        IF same(tmp,scriptON) THEN
                            dmp:=FALSE;
                        ELSIF same(tmp,scriptOFF) THEN
                            dmp:=TRUE;
                        END;
                    END;

                    (* <BR> is always handled now *)

                    (* IF wp THEN *)
                        ndx := firstcode;
                        LOOP
                            IF ndx > lastcode THEN EXIT; END;
                            IF same(tmp,code[ndx].org) THEN
                                IF normal THEN
                                    FIO.WrBin(hndOut,code[ndx].new,code[ndx].len);
                                END;
                            END;
                            INC(ndx);
                        END;
                    (* END; *)

                    IF keepimg THEN
                        Str.Slice(S2,tmp,0,lenimgcode);
                        IF same(S2,imgcode) THEN
                            IF normal THEN
                                IF imgabrev THEN
                                    FIO.WrStr(hndOut,imgMarker);
                                ELSE
                                    FIO.WrStr(hndOut,tmp);
                                END;
                                FIO.WrLn(hndOut);
                            END;
                        END;
                    END;

                    IF para THEN
                        IF same(tmp,paracode) THEN
                            IF normal THEN FIO.WrBin(hndOut,nl,lennl); END;
                        END;
                    END;
                    IF paratab THEN
                        IF same(tmp,paracode) THEN
                            IF normal THEN FIO.WrBin(hndOut,nltab,lennltab); END;
                        END;
                    END;

                    IF keepcodes THEN
                        FIO.WrStr(hndOut,tmp);FIO.WrLn(hndOut);
                    END;

                    IF verbose THEN
                        IF normal THEN WrStr(tmp);WrLn; END;
                    END;
                    status:=waiting;
                END;
            ELSE                          (* too long for an html code ! *)
                IF (normal AND dmp) THEN
                    FIO.WrBin(hndOut,tmp,highest);
                    FIO.WrBin(hndOut,ch,1);
                END;
                status:=waiting;
            END;
        END;
        IF verbose=FALSE THEN
            (* Work(cmdShow); *)
            (* completed(completedSHOW,addr); *)
            anim(animcmd);
            currportion:=addr DIV portion;
            IF currportion # lastportion THEN
                anim(animAdvance);
                lastportion:=currportion;
            END;

            INC(addr);
        END;
    END;

    FIO.Flush(hndOut);
    fileClose(useLFN,hndOut);
    fileClose(useLFN,hndIn);
    IF verbose=FALSE THEN
        (* Work(cmdStop); *)
        (* completed(completedEnd,0); *)
        anim(animEnd);anim(animClear);
    END;
END doConvert;

(* ------------------------------------------------------------ *)

VAR
    verbose,oem,flagOverwrite : BOOLEAN;
    wp,para,paratab,TRpara : BOOLEAN;
    keepcodes,keepscript,keepimg,imgabrev,filterCRLF : BOOLEAN;
    DEBUG : BOOLEAN;

PROCEDURE InitDefault ();
BEGIN
    verbose       := FALSE;
    oem           := FALSE;
    flagOverwrite := FALSE;
    wp            := FALSE;
    para          := FALSE;
    paratab       := FALSE;
    TRpara        := FALSE;
    keepcodes     := FALSE;
    keepscript    := FALSE;
    keepimg       := FALSE;
    imgabrev      := FALSE;
    filterCRLF    := FALSE;
    DEBUG         := FALSE;
END InitDefault;

(* ------------------------------------------------------------ *)

CONST
    msgProcessing  = "::: Processing : ";
    msgCreated     = "+++ Created    : ";
    msgSkipping    = "::: Skipping   : ";
    msgAlready     = "--- (exists !) : ";
VAR
    parmcount,i,opt : CARDINAL;
    S,R,spec,path,inifile         : pathtype;
    state     : (waiting,gotspec);
    useLFN    : BOOLEAN;

    j,countFile : CARDINAL;
    anchor,ptr:pFname;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    WrLn;

    InitDefault;
    useLFN := TRUE;
    state:=waiting;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "D"+delim+"DUMP"+delim+
                                 "OEM"+delim+"WIN"+delim+
                                 "O"+delim+"OVERWRITE"+delim+
                                 "WP"+delim+"CHARFORMAT"+delim+
                                 "P"+delim+"CRLF"+delim+
                                 "T"+delim+"CRLFTAB"+delim+
                                 "R"+delim+"REVERSE"+delim+
                                 "S"+delim+"SCRIPT"+delim+
                                 "I"+delim+"IMAGE"+delim+"IMG"+delim+
                                 "II"+delim+
                                 "F"+delim+"NOCRLF"+delim+
                                 "TR"+delim+
                                 "X"+delim+"LFN"+delim+
                                 "DEBUG"
                              );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5 :   verbose:=TRUE;
            | 6,7 :   oem:=TRUE;
            | 8,9 :   flagOverwrite := TRUE;
            | 10,11:  wp:=TRUE;
            | 12,13:  para:=TRUE;
            | 14,15:  paratab:=TRUE;
            | 16,17:  keepcodes:=TRUE;
            | 18,19:  keepscript:=TRUE;
            | 20,21,22:keepimg:=TRUE; imgabrev:=FALSE;
            | 23:      keepimg:=TRUE; imgabrev:=TRUE;
            | 24,25:  filterCRLF:=TRUE;
            | 26:     TRpara:=TRUE;
            | 27,28:  useLFN:=FALSE;
            | 29:     DEBUG:=TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE state OF
            | waiting : Str.Copy(spec,S);
            | gotspec : abort(errTooManyParms,S);
            END;
            INC(state);
        END;
    END;

    useLFN := ( useLFN AND w9XsupportLFN() );

    (* check nonsense *)

    IF state=waiting THEN abort(errMissingName,""); END;

    IF (para AND paratab) THEN abort(errProcessConflict,"");END;

    Lib.ParamStr(inifile,0);
    Str.Subst(inifile,extEXE,extINI);
    IF fileExists(useLFN,inifile)=FALSE THEN abort(errMissingIni,inifile); END;

    IF legalextension (spec,skippedextensions)=FALSE THEN abort(errBadExt,"");END;

    IF same(spec,".") THEN spec:="*"+extHTM; END;
    IF Str.Match(spec,"*\") THEN Str.Append(spec,"*"+extHTM); END;
    IF Str.Match(spec,"*\.") THEN
        i:=Str.Length(spec);
        spec[i-1]:=nullchar;
        Str.Append(spec,"*"+extHTM);
    END;
    IF Str.RCharPos(spec,dot)=MAX(CARDINAL) THEN Str.Append(spec,extHTM);END;

    initList(anchor);
    countFile:=buildFileList(anchor,useLFN,spec,skippedextensions);
    IF countFile=MAX(CARDINAL) THEN abort(errTooManyFiles,spec);END; (* errStorage *)
    IF countFile=0 THEN abort(errNoMatch,spec); END;

    buildPath(path,  spec);

    WrStr(Banner);WrLn;
    WrLn;

    i:=readEntities(S,useLFN,inifile);
    IF i # errNone THEN abort(i,S);END;

IF DEBUG THEN
    FOR i:=0 TO (countEntity-1) DO
        j:=i+firstEntity;
        IO.WrCard(i,4);                     WrStr(tab);
        IO.WrCard(j,4);                     WrStr(tab);
        WrStr(entity[j].string);            WrStr(tab);
        IO.WrCard(entity[j].hash,6);        WrStr(tab);
        WrStr(entity[j].DOSreplacement);    WrStr(tab);
        WrStr(entity[j].WINreplacement);    WrLn;
    END;
END;

    IF initWPlist(wp,TRpara)=FALSE THEN abort(errTooManyCodes,""); END;

    ptr:=anchor;
    WHILE ptr # NIL DO
        getStr(R,ptr);
        i := Str.RCharPos(R,dot);
        IF i # MAX(CARDINAL) THEN
            Str.Slice(S,R,0,i);
            Str.Copy(R,S);
        END;

        IF keepcodes THEN
            Str.Append(R,extKOD);
        ELSE
            CASE oem OF
            | FALSE : Str.Append(R,extASC);
            | TRUE :  Str.Append(R,extTXT);
            END;
        END;
        Str.Prepend(R,path);

        getStr(S,ptr);
        Str.Prepend(S,path);

        i := 0;
        IF fileExists(useLFN,R) THEN
            IF fileIsRO(useLFN,R)=FALSE THEN
                IF flagOverwrite=FALSE THEN
                    i:=1;
                END;
            ELSE
                i:=1;
            END;
        END;
        IF same(S,R) THEN INC(i); END;

        IF i=0 THEN
            WrStr(msgProcessing);wrQ(useLFN,S);
            doConvert (S,R,
                      oem,verbose,wp,para,paratab,
                      keepcodes,keepscript,keepimg,imgabrev,filterCRLF,useLFN);
            WrLn;
            WrStr(msgCreated);wrQ(useLFN,R);WrLn;
        ELSE
            WrStr(msgSkipping);wrQ(useLFN,S);WrLn;
            WrStr(msgAlready);wrQ(useLFN,R);WrLn;
        END;

        ptr:=ptr^.next;
    END;

    freeList(anchor);

    abort(errNone,"");
END HTM2ASC.

