(* ---------------------------------------------------------------
Title         Q&D Keep Unique Lines
Overview      self-explanatory !
Notes
Bugs
Wish List     disk-based Btree ? ah ah, in another life...
              put reference in memory as to go faster ? (xlarge then ?)
              as DUPLINES, allow check on selected portion of string
              added and/or deleted ?

--------------------------------------------------------------- *)

MODULE keepUnique;

IMPORT Str;
IMPORT Lib;
IMPORT FIO;
IMPORT SYSTEM;

FROM IO IMPORT WrStr, WrLn;

FROM QD_ASCII IMPORT dash, slash, nullchar, tabchar, cr, lf, nl, bs,
space, dot, deg, doublequote, quote, colon, percent, vbar,
blank, equal, dquote, charnull, singlequote, antislash, dollar,
star, backslash, coma, question, underscore, tabul, hbar,
comma, semicolon, diese, pound, openbracket, closebracket, tilde, exclam,
stardotstar, dotdot, escCh, escSet, letters, digits,
lettersUpp, lettersLow, openbrace, closebrace;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits, metaproc, getCli, argc, argv;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileExistsAlt,
fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose, fileSupportLFN;

(* ------------------------------------------------------------ *)

CONST
    sTMP          = "TMP";
    sTEMP         = "TEMP";
    sTMPDIR       = "TMPDIR";
    sTEMPDIR      = "TEMPDIR";
CONST
    sNDX          = "$INDEX$.TMP";  (* very unlikely to exist ! *)
    sTMPNAME      = "$_TMP_$.TMP";
    sINFO         = "::: ";
    sWIN32VERSION = "KEEPUNIQ32 v1.0a";
CONST
    extBAK        = ".BK!";
    extBK1        = ".BK1"; (* simple way to avoid backup collision *)
    extBK2        = ".BK2";
    extCOM        = ".COM";
    extEXE        = ".EXE";
    extDLL        = ".DLL";
    extOVR        = ".OVR";
    extOVL        = ".OVL";
    extDRV        = ".DRV";
    extZIP        = ".ZIP";
    extARJ        = ".ARJ";
    extLZH        = ".LZH";
    sSkippedExtensions = extBAK+delim+extBK1+delim+extBK2+delim+
                         extCOM+delim+extEXE+delim+
                         extDLL+delim+extOVR+delim+extOVL+delim+extDRV+delim+
                         extZIP+delim+extARJ+delim+extLZH;
CONST
    progEXEname   = "KEEPUNIQ";
    progTitle     = "Q&D Keep unique lines";
    progVersion   = "v1.0d";
    progCopyright = "by PhG";
    banner        = progTitle+" "+progVersion+" "+progCopyright;

CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errParmOverflow = 3;
    errExpected     = 4;
    errJoker        = 5;
    errNotFound     = 6;
    errExt          = 7;
    errNotFile      = 8;
    errAborted      = 9;
    errCollision    = 10;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
banner+nl+
nl+
"Syntax : "+progEXEname+" <textfile1> <textfile2> [option]..."+nl+
nl+
"  -k case-sensitive"+nl+
"  -w take tabs and spaces into account"+nl+
"  -n keep empty lines"+nl+
"  -i invert operation (keep lines common to both files)"+nl+
"  -x do not modify <textfile1>"+nl+
"  -b do not create <textfile1>"+extBK1+" and <textfile2>"+extBK2+" backups"+nl+
"  -s do not update <textfile1> and <textfile2> date/time stamps"+nl+
"  -q quiet mode (no eyecandy)"+nl+
"  -v verbose (show parameters at start)"+nl+
"  -w force temporary files to be created in current directory"+nl+
"  -l disable LFN support even if available"+nl+
nl+
"This program removes text lines common to both <textfile1> and <textfile2>"+nl+
"(unless -i option is specified to keep only them instead)."+nl+
nl+
"a) Temporary files are created in directory specified by, in that order,"+nl+
"   "+sTMP+", "+sTEMP+", "+sTMPDIR+", "+sTEMPDIR+" environment variables"+nl+
"   (if none of these variables is defined, or if -w option is specified,"+nl+
"   current directory will be used instead)."+nl+
"b) "+sSkippedExtensions+" are illegal."+nl+
"c) DOS character set is assumed."+nl+
"d) For compatibility reasons, these "+sWIN32VERSION+" options"+nl+
"   are supported, although they will have no effect : -t and -c:#,#."+nl+
"e) Note this program was not created with speed in mind : it is very slow. :-("+nl+
"   Brute Force and Laziness ! ;-)"+nl;

VAR
    S : str128;
BEGIN
    CASE e OF
    | errHelp :       WrStr(helpmsg);
    | errOption :     Str.Concat(S,"Illegal ",einfo);Str.Append(S," option !");
    | errParmOverflow:Str.Concat(S,einfo," is one parameter too many !");
    | errExpected:    Str.Concat(S,einfo," expected !");
    | errJoker:       Str.Concat(S,einfo," cannot contain any joker !");
    | errNotFound:    Str.Concat(S,einfo," does not exist !");
    | errExt:         Str.Concat(S,einfo," contains an illegal extension !");
    | errNotFile:     Str.Concat(S,einfo," is not a file !");
    | errAborted:     S := "Aborted by user !";
    | errCollision:   S := "<textfile1> and <textfile2> are identical !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp :
        ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

(* as usual, buffers must be outside procedure, else program bombs ! *)

CONST
    IObufferSize      = (16 * 512) + FIO.BufferOverhead;
    firstIObufferByte = 1;
    lastIObufferByte  = IObufferSize;
TYPE
    ioBufferType      = ARRAY [firstIObufferByte..lastIObufferByte] OF BYTE; (* for private M2 IO *)
VAR
    ioBufferIn, ioBufferOut, ioBufferNdx, ioBufferRef : ioBufferType;

(* ------------------------------------------------------------ *)

PROCEDURE fmtlc (v:LONGCARD;base:CARDINAL;wi:INTEGER;ch,prefix:CHAR) : str80;
VAR
    R : str80;
    ok: BOOLEAN;
    i : CARDINAL;
BEGIN
    Str.CardToStr(v,R,base,ok);
    FOR i:= Str.Length(R)+1 TO ABS(wi) DO
        IF wi < 0 THEN
            Str.Append(R,ch);
        ELSE
            Str.Prepend(R,ch);
        END;
    END;
    IF base=16 THEN Str.Lows(R);END;
    Str.Prepend(R,prefix);
    RETURN R;
END fmtlc;

PROCEDURE fmt (v:CARDINAL;base:CARDINAL;wi:INTEGER;ch,prefix:CHAR) : str80;
BEGIN
    RETURN fmtlc(LONGCARD(v),base,wi,ch,prefix);
END fmt;

(* we don't check for TMP validity *)

PROCEDURE getWorkDir (forcecurrent:BOOLEAN; VAR workdir:ARRAY OF CHAR);
CONST
    numvars = 4;
VAR
    i:CARDINAL;
    D:str128;
    drive:SHORTCARD;
    unit:str2;
    current:str128;
BEGIN
    IF forcecurrent THEN
        i:=numvars+1;
    ELSE
        i:=1;
        LOOP
            CASE i OF
            | 1: D:=sTMP;
            | 2: D:=sTEMP;
            | 3: D:=sTMPDIR;
            | 4: D:=sTEMPDIR;
            END;
            Lib.EnvironmentFind(D,workdir);
            IF same(workdir,"")=FALSE THEN EXIT; END;
            INC(i);
            IF i > numvars THEN EXIT; END;
        END;
    END;
    IF i > numvars THEN
        drive := FIO.GetDrive();
        Str.Concat(unit, CHR(drive+ORD("A")-1),":");
        FIO.GetDir(drive,current); (* \path without u: nor trailing \ except at root *)
        IF current[1] = ":" THEN
            Str.Copy(workdir,current);
        ELSE
            Str.Concat(workdir,unit,current);
        END;
    END;
    fixDirectory(workdir);
END getWorkDir;

PROCEDURE chkExt (S,skipem:ARRAY OF CHAR ):BOOLEAN;
VAR
    p,pb,n : CARDINAL;
    ext:str16;
BEGIN
    p:=Str.RCharPos(S, "." );
    IF p=MAX(CARDINAL) THEN RETURN TRUE; END;
    Str.Delete(S, 0,p+1);
    Str.Caps(S);

    pb:=0;
    n:=0;
    LOOP
        isoleItemS(ext, skipem,delim,n);
        Str.Subst(ext, "." , "" ); (* remove leading dot *)
        IF same(ext,"") THEN EXIT; END;
        IF same(ext,S) THEN INC(pb);END;
        INC(n);
    END;
    RETURN (pb=0);
END chkExt;

PROCEDURE newext (VAR R:ARRAY OF CHAR;S,e:ARRAY OF CHAR );
VAR
    p : CARDINAL;
BEGIN
    p:=Str.RCharPos(S,".");
    IF p = MAX(CARDINAL) THEN
        Str.Copy(R,S);
    ELSE
        Str.Slice(R,S,0,p);
    END;
    Str.Append(R,e);
END newext;

CONST
    wi=15;

PROCEDURE dmpbool (S,Y,N:ARRAY OF CHAR;v:BOOLEAN);
VAR
    R:str128;
    i : CARDINAL;
BEGIN
    Str.Concat(R,sINFO,S);
    FOR i:=Str.Length(S)+1 TO wi DO Str.Append(R," ");END;
    Str.Append(R," : ");
    IF v THEN
        Str.Append(R,Y);
    ELSE
        Str.Append(R,N);
    END;
    WrStr(R);WrLn;
END dmpbool;

PROCEDURE dmp (S,S2:ARRAY OF CHAR);
VAR
    R:str128;
    i : CARDINAL;
BEGIN
    Str.Concat(R,sINFO,S);
    FOR i:=Str.Length(S)+1 TO wi DO Str.Append(R," ");END;
    Str.Append(R," : ");
    Str.Append(R,S2);
    WrStr(R);WrLn;
END dmp;

PROCEDURE dmpnew (DEBUG:BOOLEAN;F1,F2:ARRAY OF CHAR);
BEGIN
    IF DEBUG THEN
        WrStr("\\\ old name : ");WrStr(F1);WrLn;
        WrStr("/// new name : ");WrStr(F2);WrLn;
    END;
END dmpnew;

PROCEDURE splitcanon (VAR pa,fi:pathtype; F:pathtype);
VAR
    p:CARDINAL;
BEGIN
    p:=Str.RCharPos(F,antislash);
    IF p = MAX(CARDINAL) THEN
        p:=Str.RCharPos(F,slash); (* unlikely nix form *)
    END;
    IF p = MAX(CARDINAL) THEN
        Str.Copy(pa,"");
        Str.Copy(fi,F);
    ELSE
        Str.Copy(fi,F);
        Str.Slice(pa,F,0,p+1);
        Str.Delete(fi,0,p+1);
    END;
END splitcanon;

PROCEDURE unpath (F:pathtype  ):pathtype;
VAR
    pa,fi:pathtype;
BEGIN
    (*
    splitcanon(pa,fi,F);
    RETURN fi;
    *)
    RETURN F;
END unpath;

(* note rename requires newname to be a mere f8e3 ! *)

PROCEDURE swapnames (DEBUG,useLFN:BOOLEAN;tmpname,F,bak:pathtype);
VAR
    pa,fi,tmp:pathtype;
BEGIN
    Str.Copy(tmp,tmpname);
    splitcanon(pa,fi,bak);
    Str.Prepend(tmp,pa);

    IF DEBUG THEN
        WrStr("!!! ");WrStr(F);WrStr(" <==> ");WrStr(bak);WrLn;
    END;
    dmpnew(DEBUG,F,tmp );
    fileRename(useLFN,F, tmp );   (* foo becomes tmp *)

    dmpnew(DEBUG,bak, unpath(F) );
    fileRename(useLFN,bak, unpath(F) );        (* bar becomes foo *)

    dmpnew(DEBUG,tmp, unpath(bak) );
    fileRename(useLFN,tmp, unpath(bak) ); (* tmp becomes bar *)
END swapnames;

TYPE
    dtoptype = (dtget,dtset);

PROCEDURE doStampOp (VAR stamp:LONGCARD; cmd:dtoptype;useLFN:BOOLEAN;S:pathtype);
VAR
    hnd:FIO.File;
BEGIN
    hnd:=fileOpenRead(useLFN,S);
    CASE cmd OF
    | dtget:
        stamp:=FIO.GetFileDate(hnd);
    | dtset:
        FIO.SetFileDate(hnd,stamp);
    END;
    fileClose(useLFN,hnd);
END doStampOp;

(* ------------------------------------------------------------ *)

PROCEDURE preprocess (keepcase,keepblanks:BOOLEAN;VAR S:ARRAY OF CHAR);
BEGIN
    IF NOT(keepcase) THEN LowerCaseAlt(S);END; (* keep accents *)
    IF NOT(keepblanks) THEN
        ReplaceChar(S,blank,"");
        ReplaceChar(S,tabul,"");
    END;
END preprocess;

CONST
    MAXHASH = MAX(CARDINAL)-1;
TYPE
    lineType = RECORD
        fpos : LONGCARD;
        hash : CARDINAL;
    END;

PROCEDURE rebuild (DEBUG,useLFN,
                  keepcase,keepblanks,keepempty,keepstamps,candy,invertop:BOOLEAN;
                  bak,source,F,workdir:pathtype):CARDINAL;
CONST
    msgIndexing  = "Please wait while indexing ";
    msgWorking   = "Please wait while processing ";
    msgSep       = " ";
    CHKEVERY     = 16;
VAR
    matches,fpos:LONGCARD;
    S,SORG,S2:str4096;
    entry : lineType;
    msg,FNDX:pathtype;
    hin,hout,hndx,href:FIO.File;
    dmpit,readeof,alcatraz:BOOLEAN;
    len,errcode,chkrounds,hash,got:CARDINAL;
    stamp:LONGCARD;
BEGIN
    IF keepstamps THEN doStampOp(stamp,dtget,useLFN,source); END;

    alcatraz:=FALSE;
    chkrounds:=0;

    Str.Concat(FNDX, workdir,sNDX);
    IF fileExists(useLFN,FNDX) THEN
        IF fileIsRO(useLFN,FNDX) THEN fileSetRW(useLFN,FNDX);END;
    END;

    IF DEBUG THEN
        dmp("1) FNDX",FNDX);
        dmp("1) F",F);
    END;

    hndx:=fileCreate(useLFN,FNDX);
    FIO.AssignBuffer(hndx,ioBufferNdx);

    href:=fileOpenRead(useLFN,F);
    FIO.AssignBuffer(href,ioBufferIn);

    Str.Concat(msg,msgIndexing,F); Str.Append(msg,blank);
    video(msg,TRUE);
    IF candy THEN Work(cmdInit); END;
    readeof:=FALSE;
    LOOP
        IF candy THEN Work(cmdShow); END;
        IF readeof THEN EXIT; END;
        INC(chkrounds);
        IF (chkrounds MOD CHKEVERY) = 0 THEN alcatraz:=ChkEscape(); END;
        IF alcatraz THEN EXIT; END;

        fpos:=FIO.GetPos(href);
        FIO.RdStr(href,S);
        readeof:=FIO.EOF;
        preprocess(keepcase,keepblanks,S);
        len:=Str.Length(S);
        IF len # 0 THEN
            hash       := Lib.HashString(S,MAXHASH);
            entry.fpos := fpos;
            entry.hash := hash;
            FIO.WrBin(hndx,entry,SIZE(entry));
        END;
    END;
    IF candy THEN Work(cmdStop); END;
    video(msg,FALSE);
    fileClose(useLFN,href);
    fileClose(useLFN,hndx);

    IF fileExists(useLFN,bak) THEN
        IF fileIsRO(useLFN,bak) THEN fileSetRW(useLFN,bak);END;
        fileErase(useLFN,bak); (* useless safety *)
    END;

    IF DEBUG THEN
        dmp("2) bak",bak);
        dmp("2) FNDX",FNDX);
        dmp("2) F",F);
        dmp("2) source",source);
    END;

    hout:=fileCreate(useLFN,bak);
    FIO.AssignBuffer(hout,ioBufferOut);

    hndx:=fileOpenRead(useLFN,FNDX);
    FIO.AssignBuffer(hndx,ioBufferNdx);

    href:=fileOpenRead(useLFN,F);
    FIO.AssignBuffer(href,ioBufferRef);

    hin:=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hin,ioBufferIn);

    Str.Concat(msg,msgWorking,source);Str.Append(msg,blank); (* for animation *)
    video(msg,TRUE);
    IF candy THEN completed(completedInit,FIO.Size(hin)); END;

    readeof:=FALSE;
    LOOP
        IF candy THEN completed(completedShow,FIO.GetPos(hin)); END;
        IF readeof THEN EXIT; END;
        INC(chkrounds);
        IF (chkrounds MOD CHKEVERY) = 0 THEN alcatraz:=ChkEscape(); END;
        IF alcatraz THEN EXIT; END;

        FIO.RdStr(hin,S); Str.Copy(SORG,S);
        readeof:=FIO.EOF;
        dmpit:=NOT(readeof);
        preprocess(keepcase,keepblanks,S);
        len:=Str.Length(S);
        IF len = 0 THEN
            dmpit:= ( dmpit AND keepempty );
        ELSE
            hash := Lib.HashString(S,MAXHASH);
            matches:=0;
            FIO.Seek(hndx,0);
            IF candy THEN video(msgSep,TRUE);Work(cmdInit); END; (* much, much faster than Animation() *)
            LOOP
                IF candy THEN Work(cmdShow); END;
                INC(chkrounds);
                IF (chkrounds MOD CHKEVERY) = 0 THEN alcatraz:=ChkEscape(); END;
                IF alcatraz THEN EXIT; END;

                got:=FIO.RdBin(hndx,entry,SIZE(entry));
                IF got # SIZE(entry) THEN EXIT; END;
                IF hash = entry.hash THEN
                    FIO.Seek(href,entry.fpos);
                    FIO.RdStr(href,S2);
                    preprocess(keepcase,keepblanks,S2);
                    IF same(S,S2) THEN INC(matches);EXIT; END; (* we just care about first match *)
                END;
            END;
            IF candy THEN Work(cmdStop); video(msgSep,FALSE); END;
            IF matches = 0 THEN
                dmpit:= dmpit AND NOT(invertop) ; (* unique *)
            ELSE
                dmpit:= dmpit AND invertop;       (* at least one match *)
            END;
        END;
        IF dmpit THEN FIO.WrStr(hout,SORG);FIO.WrLn(hout); END;
    END;
    IF candy THEN completed(completedEnd,0); END;
    video(msg,FALSE);
    fileClose(useLFN,hin);
    fileClose(useLFN,href);
    fileClose(useLFN,hndx);
    fileClose(useLFN,hout);

    fileErase(useLFN,FNDX);

    IF alcatraz THEN
        errcode:=errAborted;
    ELSE
        errcode:=errNone;
    END;
    IF keepstamps THEN
        doStampOp(stamp,dtset,useLFN,bak); (* will be later swapped with source *)
    END;
    RETURN errcode;
END rebuild;

(* ------------------------------------------------------------ *)

VAR
    i,opt,parmcount:CARDINAL;
    S,R:pathtype;
    keepcase,keepblanks,keepempty,keepbak,invertop,keepstamps:BOOLEAN;
    verbose,candy,protected,forcecurrent:BOOLEAN;
    file1,file2,bak1,bak2:pathtype;
    workdir:pathtype;
    state:(waiting,gotfile1,gotfile2);
    DEBUG,useLFN,notwithDOS:BOOLEAN;
BEGIN
    WrLn;
    FIO.IOcheck:=FALSE;

    keepcase   :=FALSE;
    keepblanks :=FALSE;
    keepempty  :=FALSE;
    keepbak    :=TRUE;
    invertop   :=FALSE;
    candy      :=TRUE;
    protected  :=FALSE;
    forcecurrent:=FALSE;
    keepstamps :=FALSE;
    useLFN     :=TRUE;
    notwithDOS :=TRUE;
    DEBUG      :=FALSE;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    state:=waiting;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R,"?"+delim+"H"+delim+"HELP"+delim+
                                  "K"+delim+"CASE"+delim+
                                  "W"+delim+"BLANKS"+delim+
                                  "N"+delim+"CRLF"+delim+
                                  "I"+delim+"INVERT"+delim+
                                  "B"+delim+"NOBAK"+delim+
                                  "Q"+delim+"QUIET"+delim+
                                  "X"+delim+"PROTECTED"+delim+
                                  "L"+delim+"LFN"+delim+
                                  "W"+delim+"FORCECURRENT"+delim+
                                  "V"+delim+"VERBOSE"+delim+
                                  "S"+delim+"STAMPS"+delim+
                                  "L"+delim+"LFN"+delim+
                                  "C:"+delim+"COLOR:"+delim+
                                  "DEBUG"
                               );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5   : keepcase:=TRUE;
            | 6,7   : keepblanks:=TRUE;
            | 8,9   : keepempty:=TRUE;
            | 10,11 : invertop:=TRUE;
            | 12,13 : keepbak:=FALSE;
            | 14,15 : candy:=FALSE;
            | 16,17 : protected:=TRUE;
            | 18,19 : useLFN:=FALSE;
            | 20,21 : forcecurrent:=TRUE;
            | 22,23 : verbose:=TRUE;
            | 24,25 : keepstamps:=TRUE;
            | 26,27 : notwithDOS:=TRUE; (* dummy *)
            | 28,29 : notwithDOS:=TRUE; (* dummy *)
            | 30    : DEBUG:=TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE state OF
            | waiting:   Str.Copy(file1,R);
            | gotfile1:  Str.Copy(file2,R);
            | gotfile2:  abort(errParmOverflow,S);
            END;
            INC(state);
        END;
    END;
    CASE state OF
    | waiting:  abort(errExpected,"<textfile1> <textfile2>");
    | gotfile1: abort(errExpected,"<textfile2>");
    | gotfile2: ;
    END;

    useLFN := ( useLFN AND fileSupportLFN() );

    IF chkJoker(file1) THEN abort(errJoker,file1);END;
    IF chkJoker(file2) THEN abort(errJoker,file2);END;
    IF fileExists(useLFN,file1)=FALSE THEN abort(errNotFound,file1);END;
    IF fileExists(useLFN,file2)=FALSE THEN abort(errNotFound,file2);END;
    IF fileIsDirectorySpec(useLFN,file1) THEN abort(errNotFile,file1);END;
    IF fileIsDirectorySpec(useLFN,file2) THEN abort(errNotFile,file2);END;
    IF chkExt(file1,sSkippedExtensions)=FALSE THEN abort(errExt,file1);END;
    IF chkExt(file2,sSkippedExtensions)=FALSE THEN abort(errExt,file2);END;

    IF same(file1,file2) THEN abort (errCollision,"");END;

    newext(bak1, file1,extBK1);
    newext(bak2, file2,extBK2);

    getWorkDir(forcecurrent,workdir);

    IF verbose THEN
        dmp     ("File1",file1);
        dmp     ("File2",file2);
        WrLn;
        dmpbool ("Common lines"    , "kept"     , "removed"     , invertop);
        dmpbool ("Case"            , "kept"     , "ignored"     , keepcase);
        dmpbool ("Tabs and spaces" , "kept"     , "ignored"     , keepblanks);
        dmpbool ("Empty lines"     , "kept"     , "removed"     , keepempty);
        dmpbool ("File1"           , "not modified","processed" , protected);
        dmpbool ("Backups"         , "created"  , "not created" , keepbak);
        dmpbool ("Date/Time stamps", "kept"     , "updated"     , keepstamps);
        dmpbool ("LFN filesystem"  , "yes"      , "no"          , useLFN);
        WrLn;

        IF keepbak THEN
            IF protected THEN
                dmp ("File1 backup","not created");
            ELSE
                dmp ("File1 backup",bak1);
            END;
            dmp ("File2 backup",bak2);
        END;
        dmp     ("Workdir",workdir);
        WrLn;
    END;

    IF NOT(protected) THEN
    i:=rebuild (DEBUG,useLFN,
               keepcase,keepblanks,keepempty,keepstamps,candy,invertop,
               bak1,file1,file2,workdir);
    IF i # errNone THEN abort(i,"");END;
    END;
    i:=rebuild (DEBUG,useLFN,
               keepcase,keepblanks,keepempty,keepstamps,candy,invertop,
               bak2,file2,file1,workdir);
    IF i # errNone THEN abort(i,"");END;

    (* now, we can do it *)

    IF NOT(protected) THEN
        swapnames( DEBUG,useLFN,sTMPNAME, file1,bak1);
        IF keepbak THEN
            WrStr(sINFO+"Original "); WrStr(file1);
            WrStr(" was kept as ");WrStr(bak1);WrLn;
        END;
    END;
    swapnames(DEBUG, useLFN,sTMPNAME, file2,bak2);
    IF keepbak THEN
            WrStr(sINFO+"Original "); WrStr(file2);
            WrStr(" was kept as ");WrStr(bak2);WrLn;
        WrLn;
    ELSE
        IF NOT(protected) THEN fileErase(useLFN,bak1); END;
        fileErase(useLFN,bak2);
    END;

    S:=sINFO+"Lines common to both files have been ";
    IF invertop THEN
        Str.Append(S,"kept in ");
    ELSE
        Str.Append(S,"removed from ");
    END;
    IF protected THEN
        Str.Append(S,"File2 only.");
    ELSE
        Str.Append(S,"File1 and File2.");
    END;
    WrStr(S);WrLn;
    IF protected THEN
        S:=sINFO+"File1 was not modified.";
        WrStr(S);WrLn;
    END;
    IF keepstamps THEN
        S:=sINFO+"Date/Time stamps have not been updated.";
        WrStr(S);WrLn;
    END;

    abort(errNone,"");
END keepUnique.






(*

(*
    FIO.File is in fact a CARDINAL created by DOS int $21 function

    this is 214406 function (DOS 2+ - IOCTL - GET INPUT STATUS)

    - files may not register as being at EOF if positioned there by AH=42h
    - under DOS 5.0, on a successful return, AH contains either the next
    character which will be read or 1Ah if at EOF
    - under a Windows95 DOS box, AH seems to be either unchanged or 00h

    assume we always test a file

    1 = EOF, -1 = error, 0 = anything else

    utterly unreliable unless we perform a FIO.Size when testing !
    yet, this code matches JPI RTL !
*)

PROCEDURE isEOF (hnd:FIO.File;VAR errcode:CARDINAL):INTEGER;
VAR
    R : SYSTEM.Registers;
    rc: INTEGER;
    ok:BOOLEAN;
BEGIN
    R.AX := 04406H;
    R.BX := CARDINAL(hnd);
    Lib.Dos(R);
    errcode:=R.AX;
    IF (SYSTEM.CarryFlag IN R.Flags) THEN
        (* error can be $01 $05 $06 $0d : see #01680 *)
        rc:=-1;
    ELSE
        CASE R.AL OF
        | 000H : rc:=1; (* not ready (device) or at EOF (file) *)
        | 0FFH : rc:=0; (* ready *)
        ELSE
                 rc:=0; (* not supposed to ever happen *)
        END;
    END;
    RETURN rc;
END isEOF;

*)


