(* -----------------------------------------------------------

Wish list : process for reserved ?

------------------------------------------------------------ *)

MODULE kGroup;

IMPORT Str,Lib,FIO, IO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileExistsAlt,
fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose, fileSupportLFN;

(* ------------------------------------------------------------ *)

CONST
    cr = CHR(13);
    lf = CHR(10);
    nl = cr+lf;
CONST
    errNone             = 0;
    errHelp             = 1;
    errOpt              = 2;
    errParm             = 3;
    errExpect           = 4;
    errNotFound         = 5;
    errJoker            = 6;
    errNonsense         = 7;

CONST
    exe     = "KGROUP";
    version = "v1.0";
    msgHelp =
"Q&D Keep Group "+version+" by PhG"+nl+
nl+
"Syntax : "+exe+" <source> <text> [option]..."+nl+
nl+
"This program shows groups of lines where at least one line contains <text>."+nl+
nl+
"    -i inverse filter"+nl+
"    -j search for pattern containing jokers (default is verbatim search)"+nl+
"    -k case-sensitive search"+nl+
nl+
"a) Output should be redirected to a file."+nl+
"b) A group is one or more successive lines without an empty line."+nl+
'c) Jokers may be "?" (any character) or "*" (any sequence, empty or not).'+nl+
"d) Accents are always ignored. Pattern search always ignores case."+nl+
nl+
"Exemples : "+exe+' dups.log "*patches\"'+nl+
"           "+exe+" dups.log -k PatcheS"+nl+
"           "+exe+" dups.log -j *patches*.zip?"+nl;

PROCEDURE abort (rc:CARDINAL;S:ARRAY OF CHAR);
BEGIN
    CASE rc OF
    | errNone: ;
    | errHelp: WrStr(msgHelp);;
    ELSE
        IF Str.Length(S) # 0 THEN WrStr(exe+" : ");WrStr(S);WrLn;END;
    END;
    Lib.SetReturnCode( SHORTCARD(rc) );
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType    = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    ioBufferIn : ioBufferType;

(* ------------------------------------------------------------ *)

PROCEDURE chktxt (DEBUG,patmode,keepcase:BOOLEAN;S,txt:ARRAY OF CHAR):BOOLEAN;
CONST
    NOTFOUND = MAX(CARDINAL);
VAR
    ok:BOOLEAN;
    US:str4096;
    utxt:str128;
BEGIN
    IF (patmode OR NOT(keepcase)) THEN
        Str.Copy(US,S);
        Str.Copy(utxt,txt);
        UpperCase(US);
        UpperCase(utxt);
    END;
    IF patmode THEN
        ok := Str.Match(US,utxt);
    ELSE
        IF keepcase THEN
            ok := ( Str.Pos(S,txt) # NOTFOUND );
        ELSE
            ok := ( Str.Pos(US,utxt) # NOTFOUND );
        END;
    END;
    RETURN ok;
END chktxt;

PROCEDURE doGroup(DEBUG,useLFN,inverse,patmode,keepcase:BOOLEAN;src,txt:ARRAY OF CHAR);
VAR
    F:pathtype;
    hin:FIO.File;
    anchor:LONGCARD;
    S:str4096;
    state:(waiting,ingroup,dmpgroup);
    count,matches : CARDINAL;
    dmpme:BOOLEAN;
    Z:str128;
BEGIN
    Str.Copy(F,src);
    hin:=fileOpenRead(useLFN,F);
    FIO.AssignBuffer(hin,ioBufferIn);

    anchor:=FIO.GetPos(hin); (*  0 ! *)
    state:=ingroup;
    count:=1-1; (* in fact, we've got nothing for now *)
    matches:=0;

    FIO.EOF:=FALSE;
    LOOP
        IF FIO.EOF THEN EXIT; END;
        IF state = waiting THEN anchor:=FIO.GetPos(hin); END;
        FIO.RdStr(hin,S);
        LtrimBlanks(S);
        RtrimBlanks(S);
        IF ( S[0] = 0C ) AND FIO.EOF THEN EXIT; END;
        CASE state OF
        | waiting:
            CASE S[0] OF
            | 0C: ;
            ELSE
                count:=1;
                matches:=0;
                IF chktxt(DEBUG,patmode,keepcase,S,txt) THEN INC(matches);END;
                state:=ingroup;
            END;
        | ingroup:
            CASE S[0] OF
            | 0C:
                dmpme := (matches # 0);
                IF inverse THEN dmpme:=NOT(dmpme);END;
                IF dmpme THEN
                    FIO.Seek(hin,anchor);
                    state:=dmpgroup;
                ELSE
                    state:=waiting;
                END;
            ELSE
                INC(count);
                IF chktxt(DEBUG,patmode,keepcase,S,txt) THEN INC(matches);END;
            END;
        | dmpgroup:
            IF count > 0 THEN
                WrStr(S);WrLn;
                DEC(count);
            ELSE
                WrLn;
                state:=waiting;
            END;
        END;
    END;

    CASE state OF
    | waiting : ;
    | ingroup :
                dmpme := (matches # 0);
                IF inverse THEN dmpme:=NOT(dmpme);END;
                IF dmpme THEN
                    FIO.Seek(hin,anchor);
                    LOOP
                        FIO.RdStr(hin,S);
                        IF count < 1 THEN WrLn;EXIT;END;
                        WrStr(S); WrLn;
                        DEC(count);
                    END;
                END;
    |dmpgroup: ;
    END;
    fileClose(useLFN,hin);
END doGroup;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstparm = 1;
    maxparm   = 2;
VAR
    parm : ARRAY [firstparm..maxparm] OF pathtype;
    i,opt,parmcount,lastparm:CARDINAL;
    S,R,src:pathtype;
    txt:str128;
    useLFN,inverse,patmode,keepcase,DEBUG:BOOLEAN;
BEGIN
    FIO.IOcheck := FALSE; (* don't let topspeed handle problems *)
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)
    WrLn;

    inverse := FALSE;
    patmode := FALSE;
    keepcase:= FALSE;
    DEBUG   := FALSE;

    lastparm        := firstparm-1;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,msgHelp);END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "I"+delim+"INVERSE"+delim+
                                  "J"+delim+"JOKER"+delim+
                                  "K"+delim+"KEEPCASE"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            | 1,2,3   : abort(errHelp,msgHelp);
            | 4,5     : inverse :=TRUE;
            | 6,7     : patmode :=TRUE;
            | 8,9     : keepcase:=TRUE;
            | 10      : DEBUG   :=TRUE;
            ELSE
                abort(errOpt,"Unknown option !");
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errParm,"Too many parameters !");END;
            Str.Copy(parm[lastparm],S); (* keep case *)
        END;
    END;
    CASE lastparm OF
    | firstparm-1 : abort(errExpect,"<source> <text> expected !");
    | firstparm   : abort(errExpect,         "<text> expected !");
    END;

    IF (patmode AND keepcase) THEN abort(errNonsense,"<-k> is a nonsense with -<j> option !"); END;

    Str.Copy(src,parm[firstparm]);
    Str.Copy(txt,parm[firstparm+1]);

    IF chkJoker(src) THEN abort(errJoker,"Illegal joker(s) in <source> !");END;
    useLFN:=fileSupportLFN();
    IF fileExists(useLFN,src)=FALSE THEN abort(errNotFound,"<source> does not exist !");END;

    doGroup(DEBUG,useLFN,inverse,patmode,keepcase,src,txt);

    abort(errNone,"");
END kGroup.





