(* -----------------------------------------------------------

Notes     : small model cannot pass str1024 strings
Wish list :

------------------------------------------------------------ *)

MODULE opGroup;

IMPORT Str,Lib,FIO, IO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileExistsAlt,
fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose, fileSupportLFN;

(* ------------------------------------------------------------ *)

CONST
    cr      = CHR(13);
    lf      = CHR(10);
    nl      = cr+lf;
    blank   = " ";
    tabul   = CHR(9);
    hbar    = "|";
    dquote  = '"';
    prefix  = "FCOMP"+blank;
    prefixbatch= "FCOMP -i"+blank;
    testbatch  = "if not errorlevel 255 MPAUSE";

    rembase = "REM"+blank;
    remark  = "rem"+blank;
CONST
    errNone             = 0;
    errHelp             = 1;
    errOpt              = 2;
    errParm             = 3;
    errExpecting        = 4;
    errNotFound         = 5;
    errJoker            = 6;
    errOp               = 7;
    errUnexpected       = 8;

CONST
    exe     = "OPGROUP";
    version = "v1.0d";
    msgHelp =
"Q&D Operation on groups of lines "+version+" by PhG"+nl+
nl+
"Syntax 1 : "+exe+" <source> [-g] [option]..."+nl+
"Syntax 2 : "+exe+" <source> <-n> [-k]"+nl+
"Syntax 3 : "+exe+" <source> <string> [-z] [-m]"+nl+
nl+
"This program glues groups of lines for later processing with FCOMP (syntax 1)"+nl+
"inserts an empty line in order to separate groups of lines (syntax 2),"+nl+
"or filters out groups not containing <string> (syntax 3)."+nl+
nl+
"    -t    glue components with tabulation (default is space)"+nl+
"    -e    enclose components with double quotes"+nl+
"    -r    keep components as remarks"+nl+
"    -b    batch mode (check error code forcing a pause if mismatch)"+nl+
"    -n[n] insert en empty line between groups of lines (-nn = -n -k)"+nl+
"    -k    convert text to lowercase before comparing arguments"+nl+
"    -m    process only groups with exact (case sensitive) <string> matches"+nl+
nl+
"a) A group is two or more successive lines without an empty line."+nl+
"   Note lines alone are ignored."+nl+
"b) Syntax 1 output assumes FCOMP exists (-b option assumes MPAUSE exists too)."+nl+
"c) Syntax 2 creates groups based upon first argument in each <source> line,"+nl+
"   from first character to first blank (existing empty lines are preserved)."+nl+
'   This function is best used on lists created with "NEWLINE -u -- -o:1..33".'+nl+
"d) Any option irrelevant to syntax is silently ignored."+nl+
"e) Output should be redirected to a batch file."+nl+
nl+
"Examples : "+exe+" dups.f -q -r"+nl+
"           "+exe+" dups.f -b"+nl;

CONST
    msgOp = "-g, -n and -z options are mutually exclusive !";

PROCEDURE abort (rc:CARDINAL;S:ARRAY OF CHAR);
BEGIN
    CASE rc OF
    | errNone: ;
    | errHelp:
        WrLn; (* not done at program start *)
        WrStr(msgHelp);;
    ELSE
        IF Str.Length(S) # 0 THEN
            WrLn; (* not done at program start *)
            WrStr(exe+" : ");WrStr(S);WrLn;
        END;
    END;
    Lib.SetReturnCode( SHORTCARD(rc) );
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType    = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    ioBufferIn : ioBufferType;

(* ------------------------------------------------------------ *)

PROCEDURE doquote (enquote:BOOLEAN;VAR S:ARRAY OF CHAR   );
BEGIN
    IF enquote THEN
        Str.Prepend(S,dquote);
        Str.Append(S,dquote);
    END;
END doquote;

PROCEDURE dmp ( keeporg:BOOLEAN;rem,S:ARRAY OF CHAR  );
BEGIN
    IF keeporg THEN
        WrStr(rem);WrStr(S);WrLn;
    END;
END dmp;

PROCEDURE dbg (ok:BOOLEAN;S:ARRAY OF CHAR   );
BEGIN
    IF ok THEN
        WrStr("/// ");WrStr(S);WrLn;
    END;
END dbg;

PROCEDURE procJoin ( DEBUG,useLFN,enquote,keeporg,batchmode:BOOLEAN;sepa:CHAR;
                     prefix,src:ARRAY OF CHAR  );
VAR
    F:pathtype;
    hin:FIO.File;
    S,BASE,Z:str1024;
    state:(waiting,ingroup);
BEGIN
    Str.Copy(F,src);
    hin:=fileOpenRead(useLFN,F);
    FIO.AssignBuffer(hin,ioBufferIn);

    IF batchmode THEN
        WrStr("@ECHO OFF");WrLn;
        WrLn;
    END;

    state:=waiting; (* //V10B FIXED *)

    FIO.EOF:=FALSE;
    LOOP
        IF FIO.EOF THEN EXIT; END;
        FIO.RdStr(hin,S);
        LtrimBlanks(S);
        RtrimBlanks(S);
        dbg(DEBUG,S);
        IF ( S[0] = 0C ) AND FIO.EOF THEN EXIT; END;
        CASE state OF
        | waiting:
dbg(DEBUG,"waiting");
            CASE S[0] OF
            | 0C: ;
            ELSE
                dmp(keeporg,rembase,S);
                doquote(enquote,S);
                BASE:=S;
                state:=ingroup;
            END;
        | ingroup:
dbg(DEBUG,"ingroup");
            CASE S[0] OF
            | 0C:
                WrLn;
                state:=waiting;
            ELSE
                dmp(keeporg,remark,S);
                doquote(enquote,S);
                Z:="||||";
                IF batchmode THEN
                Str.Subst(Z,hbar,prefixbatch);
                ELSE
                Str.Subst(Z,hbar,prefix);
                END;
                Str.Subst(Z,hbar,BASE);
                Str.Subst(Z,hbar,sepa);
                Str.Subst(Z,hbar,S);
                WrStr(Z);WrLn;
                IF batchmode THEN
                WrStr(testbatch);WrLn;
                END;
            END;
        END;
    END;

    CASE state OF
    | waiting : ;
    | ingroup:
            CASE S[0] OF
            | 0C:
                WrLn;
            ELSE
                dmp(keeporg,remark,S);
                doquote(enquote,S);
                Z:="||||";
                Str.Subst(Z,hbar,prefix);
                Str.Subst(Z,hbar,BASE);
                Str.Subst(Z,hbar,sepa);
                Str.Subst(Z,hbar,S);
                WrStr(Z);WrLn;
            END;
    END;
    fileClose(useLFN,hin);
END procJoin;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE procSplit ( DEBUG,useLFN,lower:BOOLEAN;src:ARRAY OF CHAR  );
VAR
    F:pathtype;
    hin:FIO.File;
    S,REF,NOW:str1024; (* both oversized just in case *)
    p:CARDINAL;
    currline:LONGCARD;
    ok:BOOLEAN;
BEGIN
    Str.Copy(F,src);
    hin:=fileOpenRead(useLFN,F);
    FIO.AssignBuffer(hin,ioBufferIn);
    currline:=0;
    REF := "";
    FIO.EOF:=FALSE;
    LOOP
        IF FIO.EOF THEN EXIT; END;
        FIO.RdStr(hin,S);
        (*
        LtrimBlanks(S);
        RtrimBlanks(S);
        *)
        IF ( S[0] = 0C ) AND FIO.EOF THEN EXIT; END;
        IF same(S,"") THEN
            WrLn;
            REF := "";
        ELSE
            p:=Str.CharPos(S,blank);
            IF p = MAX(CARDINAL) THEN
                Str.Copy(NOW,S);
            ELSE
                Str.Slice(NOW,S,0,p);
            END;
            IF lower THEN LowerCase(NOW);END;
            IF same(REF,NOW) THEN
                WrStr(S);WrLn;
            ELSE
                ok:=(currline # 0);
                ok:=(ok AND NOT(same(REF,"")) );
                IF ok THEN WrLn;END;
                WrStr(S);WrLn;
                Str.Copy(REF,NOW);
            END;
        END;
        INC(currline);
    END;
    fileClose(useLFN,hin);
END procSplit;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE procKeep ( DEBUG,useLFN,keepcase:BOOLEAN;src,str:ARRAY OF CHAR  );
VAR
    F:pathtype;
    hin:FIO.File;
    ORGS,S,what:str1024;
    state:(waiting,ingroup);
    fpos,anchor:LONGCARD;
    nfound:CARDINAL;
BEGIN
    Str.Copy(what,str);
    IF NOT(keepcase) THEN LowerCase(what);END;

    Str.Copy(F,src);
    hin:=fileOpenRead(useLFN,F);
    FIO.AssignBuffer(hin,ioBufferIn);

    state:=waiting;

    FIO.EOF:=FALSE;
    LOOP
        IF FIO.EOF THEN EXIT; END;
        fpos:=FIO.GetPos(hin);
        FIO.RdStr(hin,ORGS);
        Str.Copy(S,ORGS);
        LtrimBlanks(S);
        RtrimBlanks(S);
        dbg(DEBUG,ORGS);
        IF NOT(keepcase) THEN LowerCase(S);END;
        IF ( S[0] = 0C ) AND FIO.EOF THEN EXIT; END;
        CASE state OF
        | waiting:
dbg(DEBUG,"waiting");
            CASE S[0] OF
            | 0C: ;
            ELSE
                nfound:=0;
                IF Str.Pos(S,what) # MAX(CARDINAL) THEN INC (nfound);END;
                anchor:=fpos;
                state:=ingroup;
            END;
        | ingroup:
dbg(DEBUG,"ingroup");
            CASE S[0] OF
            | 0C:
                IF nfound # 0 THEN
                    FIO.Seek(hin,anchor);
                    LOOP
                        FIO.RdStr(hin,S);
                        WrStr(S);WrLn;
                        IF FIO.GetPos(hin) > fpos THEN EXIT; END;
                    END;
                END;
                state:=waiting;
            ELSE
                IF Str.Pos(S,what) # MAX(CARDINAL) THEN INC(nfound);END;
            END;
        END;
    END;

    CASE state OF
    | waiting : ;
    | ingroup:
                IF nfound # 0 THEN
                    FIO.Seek(hin,anchor);
                    LOOP
                        FIO.RdStr(hin,S);
                        WrStr(S);WrLn;
                        IF FIO.GetPos(hin) > fpos THEN EXIT; END;
                    END;
                END;
    END;
    fileClose(useLFN,hin);
END procKeep;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstparm = 1;
    maxparm   = 2;
VAR
    parm : ARRAY [firstparm..maxparm] OF pathtype;
    i,opt,parmcount,lastparm:CARDINAL;
    S,R,src:pathtype;
    useLFN,DEBUG:BOOLEAN;
    batchmode,enquote,keeporg,lower,ignorecase,keepcase:BOOLEAN;
    sepa : CHAR;
    op : (opNone,opJoin,opSplit,opKeep);
BEGIN
    FIO.IOcheck := FALSE; (* don't let topspeed handle problems *)
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)
    (* WrLn;  not here because of redirection *)

    op      := opNone;
    enquote := FALSE;
    keeporg := FALSE;
    batchmode:=FALSE;
    sepa    := blank;
    lower   := FALSE;
    keepcase:= FALSE;
    DEBUG   := FALSE;

    lastparm        := firstparm-1;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,msgHelp);END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "T"+delim+"TAB"+delim+
                                  "E"+delim+"ENQUOTE"+delim+
                                  "R"+delim+"REM"+delim+
                                  "B"+delim+"BATCH"+delim+

                                  "N"+delim+"NEWLINE"+delim+
                                  "K"+delim+"LOWERCASE"+delim+
                                  "NN"+delim+"NK"+delim+"KN"+delim+
                                  "M"+delim+"CASE"+delim+
                                  "G"+delim+"GLUE"+delim+
                                  "Z"+delim+"KEEP"+delim+"ONLY"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            | 1,2,3   : abort(errHelp,msgHelp);
            | 4,5     : sepa:=tabul;
            | 6,7     : enquote:=TRUE;
            | 8,9     : keeporg:=TRUE;
            | 10,11   : batchmode:=TRUE;

            | 12,13   : CASE op OF
                        | opNone,opSplit:op:=opSplit;
                        ELSE
                            abort(errOp,msgOp);
                        END;
            | 14,15   : lower  := TRUE;
            | 16,17,18: CASE op OF
                        | opNone,opSplit:op:=opSplit;
                        ELSE
                            abort(errOp,msgOp);
                        END;
                        lower:=TRUE;
            | 19,20   : keepcase:=TRUE;
            | 21,22   : CASE op OF
                        | opNone,opJoin:op:=opJoin;
                        ELSE
                            abort(errOp,msgOp);
                        END;
            | 23,24,25: CASE op OF
                        | opNone,opKeep:op:=opKeep;
                        ELSE
                            abort(errOp,msgOp);
                        END;
            | 26      : DEBUG  :=TRUE;
            ELSE
                abort(errOpt,"Unknown option !");
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errParm,"Too many parameters !");END;
            Str.Copy(parm[lastparm],S); (* keep case *)
        END;
    END;
    CASE lastparm OF
    | firstparm-1 : abort(errExpecting,"<source> parameter expected !");
    | firstparm   : CASE op OF
                    | opKeep : abort(errExpecting,"<string> parameter expected !");
                    ELSE
                        ;
                    END;
    | firstparm+1 : CASE op OF
                    | opKeep : ;
                    | opNone : op:=opKeep; (* 2 parms force -z *)
                    ELSE
                        abort(errUnexpected,"Unexpected <string> parameter !");
                    END;
    ELSE                (* already trapped *)
                    ;
    END;
    IF op=opNone THEN op:=opJoin;END; (* default is -g *)

    Str.Copy(src,parm[firstparm]);
    IF chkJoker(src) THEN abort(errJoker,"Illegal joker(s) in <source> !");END;
    useLFN:=fileSupportLFN();
    IF fileExists(useLFN,src)=FALSE THEN abort(errNotFound,"<source> does not exist !");END;

    CASE op OF
    | opSplit:
        procSplit(DEBUG,useLFN,lower,src);
    | opJoin:
        procJoin(DEBUG,useLFN,enquote,keeporg,batchmode,sepa,prefix,src);
    | opKeep:
        procKeep(DEBUG,useLFN,keepcase,src,parm[firstparm+1]);
    END;

    abort(errNone,"");
END opGroup.





