(* -----------------------------------------------------------

Notes     :
Wish list :
            RTF format seems "\*" tokens
            inner letters seem "\'#" hex tokens in words xxx\'##xxx

------------------------------------------------------------ *)

MODULE unrtf;

IMPORT FIO,Lib,Str;

FROM IO IMPORT WrStr,WrLn,WrLngCard;

FROM QD_ASCII IMPORT dash, slash, nullchar, tabchar, cr, lf, nl, bs,
space, dot, deg, doublequote, quote, colon, percent, vbar,
blank, equal, dquote, charnull, singlequote, antislash, dollar,
star, backslash, coma, question, underscore, tabul, hbar,
comma, semicolon, diese, pound, openbracket, closebracket, tilde, exclam,
stardotstar, dotdot, escCh, escSet, letters, digits,
lettersUpp, lettersLow, openbrace, closebrace;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits, metaproc, getCli, argc, argv;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileExistsAlt,
fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose, fileSupportLFN;

(* shortened list *)

FROM QD_LFN IMPORT unicodeConversionFlagType, findDataRecordType,
w9XfindFirst, w9XfindClose, w9XfindNext, w9XshortToLong;

FROM Storage IMPORT ALLOCATE, DEALLOCATE, Available,
HeapTotalAvail, MainHeap;

(* ------------------------------------------------------------ *)

CONST
    extRTF              = ".RTF";
    extTXT              = ".TXT";
    extINI              = ".INI";
CONST
    errNone             = 0;
    errHelp             = 1;
    errOpt              = 2;
    errParm             = 3;
    errExpecting        = 4;
    errBadSpec          = 5;
    errNoMatch          = 6;
    errTooMany          = 7;
    errAborted          = 8;
    errIni              = 9;
    errCmd              = 10;
CONST
    exe     = "UNRTF";
    version = "v0.9";
    who     = "PhG";
CONST
    msgHelp =
"Q&D RTF to TXT converter "+version+" by "+who+nl+
nl+
"Syntax : "+exe+" <source["+extRTF+"]> [option]..."+nl+
nl+
"This program tries and retrieves raw text data from RTF files,"+nl+
"ignoring any formatting."+nl+
nl+
"  -d    dump converted data to screen without creating matching text file"+nl+
"  -o    overwrite existing matching text file (default is to skip overwriting)"+nl+
"  -![!] create default "+exe+extINI+" then terminate (-!! = -! -o)"+nl+
"  -x    disable LFN support even if available"+nl+
nl+
"a) Matching "+extTXT+" text files are created in current directory."+nl+
"b) Output is DOS ASCII."+nl+
"c) \'## sequences will be translated only if "+exe+extINI+" exists"+nl+
"   in executable directory. Else, they will be written as undefined."+nl+
"d) -![!] option ignores any other option (except -o) or parameter."+nl+
"   "+exe+extINI+" is created in executable directory."+nl+
"e) Note this program is still in alpha stage : output is ugly. :-("+nl;

PROCEDURE abort (rc:CARDINAL;S:ARRAY OF CHAR);
BEGIN
    CASE rc OF
    | errNone: ;
    | errHelp:
        WrStr(msgHelp);;
    ELSE
        IF Str.Length(S) # 0 THEN
            WrStr(exe+" : ");WrStr(S);WrLn;
        END;
    END;
    Lib.SetReturnCode( SHORTCARD(rc) );
    HALT;
END abort;

PROCEDURE dbg ( ok,enquote:BOOLEAN; S1,S2,S3:ARRAY OF CHAR  );
BEGIN
    IF ok THEN
        WrStr("/// ");WrStr(S1);
        WrStr("::: ");WrStr(S2);
        WrStr(" : ");
        IF enquote THEN WrStr(dquote);END;
        WrStr(S3);
        IF enquote THEN WrStr(dquote);END;
        WrLn;
    END;
END dbg;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType    = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    ioBufferIn,ioBufferOut : ioBufferType;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE showmem(debug:BOOLEAN; S:ARRAY OF CHAR );
VAR
    heapsize    : CARDINAL; (* in PARAGRAPHS and not in bytes ! help is wrong ! *)
    n           : LONGCARD;
BEGIN
    IF debug THEN
        heapsize :=HeapTotalAvail(MainHeap);
        n := 16 * LONGCARD(heapsize);
        WrStr("/// ");
        WrLngCard(n,6);
        WrStr(" byte(s) free -- ");WrStr(S);WrLn;
    END;
END showmem;

(* ------------------------------------------------------------ *)

TYPE
    pFname = POINTER TO fnameType;
    fnameType = RECORD
        next      : pFname;
        slen      : CARDINAL; (* a SHORTCARD could do but who knows ? *)
        str       : CHAR;     (* variable length *)
    END;

PROCEDURE initList (VAR anchor : pFname );
BEGIN
    anchor := NIL;
END initList;

PROCEDURE freeList (anchor : pFname);
VAR
    needed : CARDINAL;
    p      : pFname;
BEGIN
    (* p:=anchor; *)
    WHILE anchor # NIL DO
        needed := SIZE(fnameType) - SIZE(anchor^.str) + anchor^.slen;
        p := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=p;
    END
END freeList;

PROCEDURE buildNewPtr (VAR anchor,p:pFname; len:CARDINAL):BOOLEAN;
VAR
    needed : CARDINAL;
BEGIN
    needed := SIZE(fnameType) - SIZE(p^.str) + len;
    IF Available(needed)=FALSE THEN RETURN FALSE; END;
    IF anchor = NIL THEN
        ALLOCATE(anchor,needed);
        p:=anchor;
    ELSE
        p:=anchor;
        WHILE p^.next # NIL DO
            p:=p^.next;
        END;
        ALLOCATE(p^.next,needed);
        p:=p^.next;
    END;
    p^.next := NIL;
    RETURN TRUE;
END buildNewPtr;

(* assume p is valid *)

PROCEDURE getStr (VAR S : pathtype; p:pFname);
VAR
    len:CARDINAL;
BEGIN
    len := p^.slen;
    Lib.FastMove( ADR(p^.str),ADR(S),len);
    S[len] := nullchar; (* REQUIRED safety ! *)
END getStr;

(* ------------------------------------------------------------ *)

PROCEDURE isReservedEntry (S:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isReservedEntry;

PROCEDURE buildFileList (VAR anchor:pFname;
                        useLFN,DEBUG :BOOLEAN;spec:pathtype):CARDINAL;
VAR
    count:CARDINAL; (* should do ! *)
    ok,found:BOOLEAN;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    entry : FIO.DirEntry;
    dosattr:FIO.FileAttr;
    entryname:pathtype;
    len : CARDINAL;
    pp:pFname;
    excludeme:BOOLEAN;
BEGIN
    count:=0;
    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        excludeme := isReservedEntry   (entryname);  (* skip "." and ".." *)
        IF NOT(excludeme) THEN
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=entry.attr;
            END;
            IF NOT (aD IN dosattr) THEN
                (* if file has no extension, add it as a marker *)
                IF Str.RCharPos(entryname,".")=MAX(CARDINAL) THEN
                    Str.Append(entryname,".");
                END;
                IF DEBUG THEN WrStr("Included : ");WrStr(entryname);WrLn; END;
                len:=Str.Length(entryname);
                IF buildNewPtr(anchor,pp,len)=FALSE THEN
                    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN MAX(CARDINAL); (* errStorage *)
                END;
                INC(count);
                pp^.slen      := len;
                Lib.FastMove ( ADR(entryname),ADR(pp^.str),len );
            ELSE
                IF DEBUG THEN WrStr("Ignored  : ");WrStr(entryname);WrLn;END;
            END;
        ELSE
            IF DEBUG THEN WrStr("Excluded : ");WrStr(entryname);WrLn;END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN count;
END buildFileList;

PROCEDURE doGetCurrent (useLFN:BOOLEAN;drive:SHORTCARD;
                       VAR unit:str2; VAR current:pathtype);
VAR
    rc:CARDINAL;
    longform:pathtype;
BEGIN
    Str.Concat(unit, CHR( ORD("A")-1+ORD(drive) ),colon);

    FIO.GetDir(drive,current); (* \path without u: nor trailing \ except at root *)
    IF current[1] # colon THEN Str.Prepend(current,unit); END; (* safety *)
    IF useLFN THEN
        IF w9XshortToLong(current,rc,longform) THEN (* if error, keep DOS current *)
            Str.Copy(current,longform);
        END;
    END;
    (* LFN function seems to always return "u:\*" form except at root *)
    IF current[1] = colon THEN Str.Delete(current,0,2);END; (* safety *)
    fixDirectory(current);
END doGetCurrent;

PROCEDURE makebase (useLFN:BOOLEAN;spec:pathtype;VAR basepath:pathtype);
VAR
    u,d,n,e,current:pathtype;
    unit:str2;
    drive:SHORTCARD;
BEGIN
    Lib.SplitAllPath(spec,u,d,n,e);
    Str.Concat(basepath,u,d);
    IF same(basepath,"") THEN
        drive:=FIO.GetDrive(); (* yes we could use 0 as default drive *)
        doGetCurrent(useLFN,drive,  unit,current); (* "u:" and "\" or "\*\" *)
        Str.Concat(basepath, unit,current);
    END;
END makebase;

PROCEDURE WrQuoted (S:ARRAY OF CHAR);
BEGIN
    WrStr(dquote);  WrStr(S);  WrStr(dquote);
END WrQuoted;

PROCEDURE WrFname (useLFN:BOOLEAN;S:pathtype );
BEGIN
    IF useLFN THEN
        WrQuoted(S);
    ELSE
        WrStr(S);
    END;
END WrFname;

PROCEDURE chkUD (S:pathtype):BOOLEAN ;
VAR
    u,d,n,e:pathtype;
    pb:CARDINAL;
BEGIN
    Lib.SplitAllPath(S , u,d,n,e);
    pb:=0;
    IF chkJoker(u) THEN INC(pb);END;
    IF chkJoker(d) THEN INC(pb);END;
    RETURN (pb=0);
END chkUD;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    gloups = MAX(CARDINAL);

PROCEDURE strtoval (S:ARRAY OF CHAR ):CARDINAL;
VAR
    ok:BOOLEAN;
    base:CARDINAL;
    v:LONGCARD;
BEGIN
    CASE S[0] OF
    | dollar:
        Str.Delete(S,0,1);
        Str.Caps(S); (* important ! *)
        base:=16;
    ELSE
        base:=10;
    END;
    v:=Str.StrToCard(S,base,ok);
    IF ok=FALSE THEN RETURN gloups;END;
    IF v > MAX(CARDINAL) THEN RETURN gloups;END;
    RETURN CARDINAL(v);
END strtoval;

PROCEDURE valtostr (v:LONGCARD;base:CARDINAL ):str16;
CONST
    problemo = "--- ERROR !";
VAR
    R:str16;
    ok:BOOLEAN;
BEGIN
    Str.CardToStr ( v, R, base, ok);
    IF ok THEN
        IF base=16 THEN Str.Lows(R);Str.Prepend(R,dollar);END;
    ELSE
        R:=problemo;
    END;
    RETURN R;
END valtostr;

PROCEDURE newExt (VAR S:pathtype;ext:str16);
VAR
    R:pathtype;
    p:CARDINAL;
BEGIN
    Str.Copy(R,S);
    p:=Str.RCharPos(R,dot);
    IF p # MAX(CARDINAL) THEN R[p]:=nullchar;END;
    Str.Concat(S,R,ext);
END newExt;

TYPE
    xlatcharentry = RECORD
        defined   : BOOLEAN;
        len       : CARDINAL; (* a SHORTCARD would do *)
        newstr    : str16;
    END;
    xlatstrentry = RECORD
        defined   : BOOLEAN;
        len       : CARDINAL; (* a SHORTCARD would do *)
        tokRTF    : str16; (* should DO *)
        newstr    : str16;
    END;
CONST
    minchar  = 0;
    maxchar  = 255;
    minstr   = 1;
    maxstr   = 100;
VAR
    xlatchar : ARRAY [minchar..maxchar] OF xlatcharentry; (* "\'##" *)
    xlatstr  : ARRAY [minstr..maxstr] OF xlatstrentry;    (* "\$ " *)

PROCEDURE initini (  );
VAR
    i:CARDINAL ;
BEGIN
    FOR i:=minchar TO maxchar DO xlatchar[i].defined:=FALSE;END;
    FOR i:=minstr TO maxstr DO xlatstr[i].defined:=FALSE;END;
END initini;

PROCEDURE loadini ( VAR currline : CARDINAL;
                  useLFN,DEBUG:BOOLEAN;ini:pathtype ):BOOLEAN;
CONST
    me = "loadini()";
VAR
    i,laststr:CARDINAL;
    hin:FIO.File;
    S:str128;
    P1,P2:str16;
    rc:BOOLEAN;
BEGIN
    currline:=0;
    laststr:=minstr-1; (* 1-1 *)
    hin:=fileOpenRead(useLFN,ini);
    FIO.AssignBuffer(hin,ioBufferIn);
    FIO.EOF:=FALSE;
    rc:=TRUE;
    LOOP
        IF FIO.EOF THEN EXIT; END;
        FIO.RdStr(hin,S);
        LtrimBlanks(S);
        RtrimBlanks(S);
        dbg(DEBUG,TRUE,  me,"org",S);
        INC(currline);
        CASE S[0] OF
        | nullchar,semicolon,pound: (* ignore empty OR comment *)
            ;
        | star: (* ignore everything after EOD *)
            EXIT;
        ELSE
            IF argc(S,TRUE) # 2 THEN rc:=FALSE;EXIT;END;
            argv(P1,S,1,FALSE); (* $## hex value , or string *)
            argv(P2,S,2,FALSE); (* CHAR *)
            IF DEBUG THEN S:="~ => ~";Str.Subst(S,tilde,P1);Str.Subst(S,tilde,P2); END;
            dbg(DEBUG,FALSE,  me,"code translation",S);

            IF P2[0] = dollar THEN
                i:=strtoval(P2);
                CASE i OF
                | minchar..maxchar:
                    Str.Copy(P2, CHR(i) );
                ELSE
                    rc:=FALSE;EXIT;
                END;
            END;

            CASE P1[0] OF
            | dollar:
                i:=strtoval(P1);
                CASE i OF
                | minchar..maxchar:
                    IF xlatchar[i].defined THEN rc:=FALSE;EXIT;END;
                    xlatchar[i].defined  :=TRUE;
                    Str.Copy(xlatchar[i].newstr,P2);
                    xlatchar[i].len := Str.Length(P2);
                ELSE
                    rc:=FALSE; EXIT;
                END;
            ELSE
                INC(laststr);
                IF laststr > maxstr THEN rc:=FALSE; EXIT;END;
                xlatstr[laststr].defined := TRUE;
                S:="\~ "; (* //FIX force string TO look like one found IN crappy RTF steam *)
                Str.Subst(S,tilde,P1);
                Str.Copy(xlatstr[laststr].tokRTF ,S);
                Str.Copy(xlatstr[laststr].newstr,P2);
                xlatstr[laststr].len:=Str.Length(P2);
            END;
        END;
        IF ( (S[0] = nullchar) AND FIO.EOF ) THEN EXIT; END;
    END;
    fileClose(useLFN,hin);
    RETURN rc;
END loadini;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE proctok (hout:FIO.File;DEBUG:BOOLEAN;token,me:ARRAY OF CHAR);
VAR
    i:CARDINAL;
BEGIN
dbg(DEBUG,TRUE,me,"token",token);
    i:=minstr-1;
    LOOP
        INC(i);
        IF i > maxstr THEN EXIT;END;
        IF xlatstr[i].defined THEN
            IF same(token,xlatstr[i].tokRTF) THEN
                FIO.WrBin(hout, xlatstr[i].newstr, xlatstr[i].len);
                EXIT;
            END;
        END;
    END;
END proctok;

PROCEDURE procRTF ( useLFN,onlydump,DEBUG:BOOLEAN;source,target:pathtype);
CONST
    me="procRTF()";
    allLetters = lettersUpp+lettersLow;
    wanted=SIZE(CHAR);
VAR
    hin,hout:FIO.File;
    token,param:str128; (* should DO *)
    i,code,got:CARDINAL;
    fpos:LONGCARD;
    state:(waiting,tilldelim,grabparm,grabhex1,grabhex2);
    ch:CHAR;
    hx:ARRAY[0..2] OF CHAR; (* $## *)
    Z:str16;
    ok:BOOLEAN;
BEGIN
    hin:=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hin,ioBufferIn);
    IF onlydump THEN
        hout:=FIO.StandardOutput;
    ELSE
        hout:=fileCreate(useLFN,target);
        FIO.AssignBuffer(hout,ioBufferOut);
    END;

    state:=waiting;
    fpos:=0;
    LOOP
        got:=FIO.RdBin(hin,ch,wanted);
        IF got # wanted THEN EXIT; END;
        INC(fpos);
        CASE state OF
        | waiting:
dbg(DEBUG,TRUE,me,"state waiting",ch);
            CASE ch OF
            | openbrace,closebrace:
                ;
            | antislash:
                Str.Copy(token,ch);
                state:=tilldelim;
            ELSE
                FIO.WrBin(hout,ch,wanted);
            END;
        | tilldelim:
dbg(DEBUG,TRUE,me,"state tilldelim",ch);
            CASE ch OF
            | blank,star:
                Str.Append(token,ch);
                proctok(hout,DEBUG,token,me);
                i:=getStrIndex(delim,token,"\panose ,\cell ");
                CASE i OF
                | 1 :
                    param:="";
                    state:=grabparm;
                | 2 :
                    param:="";
                    state:=grabparm;
                    FIO.WrBin(hout,tabul,wanted);
                ELSE
                    state:=waiting;
                END;
            | "0".."9", dash :
                Str.Copy(param,ch);
                state:=grabparm;
            | "a".."z" :
                Str.Append(token,ch);
            | openbrace,closebrace:
                FIO.WrBin(hout,ch,wanted);
                state:=waiting;
            | tilde:
                FIO.WrBin(hout,blank,wanted);
                state:=waiting;
            | singlequote:
                state:=grabhex1(* wants ## *)
            ELSE
                proctok(hout,DEBUG,token,me);
                DEC(fpos);
                FIO.Seek(hin,fpos);
                state:=waiting;
dbg(DEBUG,FALSE,me,"rewind from tilldelim",valtostr(fpos,16));
            END;
        | grabparm:
dbg(DEBUG,TRUE,me,"state grabparm",ch);
            CASE ch OF
            | "0".."9":
                Str.Append(param,ch);
            ELSE
dbg(DEBUG,TRUE,me,"token+",token);
dbg(DEBUG,TRUE,me,"param",param);
                DEC(fpos);
                FIO.Seek(hin,fpos);
                state:=waiting;
dbg(DEBUG,FALSE,me,"rewind from grabparm",valtostr(fpos,16));
            END;
        | grabhex1:
            Str.Concat(hx,dollar,ch);
            state:=grabhex2;
        | grabhex2:
            Str.Append(hx,ch);
            Str.Caps(hx);
            code:=strtoval(hx);
            CASE code OF
            | minchar..maxchar:
                ok:=xlatchar[code].defined;
            ELSE
                ok:=FALSE;
            END;
            IF ok THEN
                Str.Copy(token,xlatchar[code].newstr);
            ELSE
                token:=" --- ERROR ! UNDEFINED ~ VALUE ! --- ";
                Str.Subst(token,tilde,hx);
            END;
            FIO.WrBin(hout,token,Str.Length(token));
            state:=waiting;
        END;
    END;
    (* handle pending commands *)

    IF onlydump=FALSE THEN fileClose(useLFN,hout); END;
    fileClose(useLFN,hin);
END procRTF;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    defaultIniFile = nl+
"; translate 256 hexadecimal values found as \'## in plain text"+nl+
"; format : $## hexcode then single char or $## hex value or string (16 chars)"+nl+
nl+
"$e8 "+nl+
"$e9 "+nl+
"$e0 "+nl+
"$ea "+nl+
"$e7 "+nl+
"$e2 "+nl+
"$b0 "+nl+
"$f4 "+nl+
"$ee "+nl+
"$ef "+nl+
"$b7 $fe"+nl+
"$f9 "+nl+
"$fb "+nl+
"$ab $ae"+nl+
"$bb $af"+nl+
'$93 "'+nl+
'$94 "'+nl+
"$85 ..."+nl+
"$80 dollaros"+nl+
"$eb "+nl+
"$9c oe"+nl+
"$a3 $9c"+nl+
"$f6 "+nl+
"$b4 '"+nl+
"$ae (r)"+nl+
"$99 TM"+nl+
"$fc "+nl+
"$c9 $90"+nl+
"$9a s"+nl+
"$e4 "+nl+
"$bd $ab"+nl+
"$c7 $80"+nl+
"$bc $f3"+nl+
"$fd $ec"+nl+
"$8e Z"+nl+
nl+
"; translate up to 100 special codes found as \string"+nl+
"; these codes cannot start with any of $;#*"+nl+
nl+
"rquote '"+nl+
"tab $09"+nl+
nl+
"*"+nl+
nl;




PROCEDURE createini (useLFN:BOOLEAN;ini:pathtype );
VAR
    hout:FIO.File;
BEGIN
    hout:=fileCreate(useLFN,ini);
    FIO.AssignBuffer(hout,ioBufferOut);

    FIO.WrStr(hout,defaultIniFile);

    fileClose(useLFN,hout);
END createini;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstparm = 1;
    maxparm   = 1;
VAR
    parm : ARRAY [firstparm..maxparm] OF pathtype;
    i,opt,parmcount,lastparm:CARDINAL;
    S,R,filespec,basedir,source,target,ini:pathtype;
    ok,onlydump,overwrite,useLFN,DEBUG:BOOLEAN;
    ptr,anchor:pFname;
    countFile:CARDINAL;
    poll,currpoll:CARDINAL;
    cmd:(undefinedfornow,processrtf,generate);
BEGIN
    FIO.IOcheck := FALSE; (* don't let topspeed handle problems *)
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)
    WrLn;

    cmd      :=undefinedfornow;
    onlydump :=FALSE;
    overwrite:=FALSE;
    useLFN   :=TRUE;
    DEBUG    := FALSE;

    lastparm := firstparm-1;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,msgHelp);END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "D"+delim+"DUMP"+delim+
                                  "X"+delim+"LFN"+delim+
                                  "O"+delim+"OVERWRITE"+delim+
                                  "!"+delim+"GEN"+delim+
                                  "!!"+delim+"!O"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            | 1,2,3   : abort(errHelp,msgHelp);
            | 4,5     : onlydump := TRUE;
            | 6,7     : useLFN   := FALSE;
            | 8,9     : overwrite:= TRUE;
            | 10,11   : CASE cmd OF
                        | undefinedfornow,generate:
                            cmd:=generate;
                        ELSE
                            abort(errCmd,"-![!] option is exclusive !");
                        END;
            | 12,13   : overwrite:= TRUE;
                        CASE cmd OF
                        | undefinedfornow,generate:
                            cmd:=generate;
                        ELSE
                            abort(errCmd,"-![!] option is exclusive !");
                        END;
            | 14:       DEBUG    := TRUE;
            ELSE
                abort(errOpt,"Unknown option !");
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errParm,"Too many parameters !");END;
            Str.Copy(parm[lastparm],S); (* keep case *)
        END;
    END;

    useLFN := ( useLFN AND fileSupportLFN() );

    initini();
    Lib.ParamStr(ini,0);
    newExt(ini,extINI);

    IF cmd = undefinedfornow THEN cmd:=processrtf; END;
    IF cmd = generate THEN
        IF fileExists(useLFN,ini) THEN
            IF overwrite THEN
                ok:=TRUE; S:="::: Overwrite existing ~";
            ELSE
                ok:=FALSE;S:="::: Skip existing ~";
            END;
        ELSE
                ok:=TRUE; S:="::: Create ~";
        END;
        Str.Subst(S,tilde,dquote+tilde+dquote);
        Str.Subst(S,tilde,ini);
        WrStr(S);WrLn;
        IF ok THEN createini(useLFN,ini);END;
        abort(errNone,"");
    END;

    (* processrtf *)

    CASE lastparm OF
    | firstparm-1 : abort(errExpecting,"<source["+extRTF+"]> parameter expected !");
    ELSE                (* already trapped *)
                    ;
    END;

    useLFN:=(useLFN AND fileSupportLFN() );
    Str.Copy(filespec,parm[firstparm]);

    (* a few q&d sanity checks *)

    IF chkUD(filespec)=FALSE THEN abort(errBadSpec,"Illegal <source> !");END;
    IF same(filespec,dot) THEN Str.Copy(filespec,star+extRTF); END;
    IF same(filespec,star) THEN Str.Copy(filespec,star+extRTF); END;
    IF Str.Match(filespec,"*"+antislash) THEN Str.Append(filespec,stardotstar); END;
    IF Str.CharPos(filespec,dot)=MAX(CARDINAL) THEN Str.Append(filespec,extRTF);END;
    IF chkJoker(filespec)=FALSE THEN
        IF fileIsDirectorySpec ( useLFN,filespec) THEN
            fixDirectory(filespec);
            Str.Append(filespec,stardotstar);
        END;
    END;
    makebase(useLFN,filespec,basedir);

    IF fileExists(useLFN,ini) THEN
        IF loadini(i, useLFN,DEBUG,ini)=FALSE THEN
            S:='Problem at line ~ in "~" !';
            Str.Subst(S,tilde,valtostr( LONGCARD(i) , 10 ));
            Str.Subst(S,tilde,ini);
            abort(errIni,S);
        END;
        S:="::: ~ found : escaped characters and tokens will be translated.";
    ELSE
        (*  abort(errNoMatch,exe+extINI+" does not exist !"); *)
        S:="::: ~ not found : escaped characters and tokens will not be translated.";
    END;
    Str.Subst(S,tilde,"INI");
    IF NOT(onlydump) THEN WrStr(S);WrLn;END;

    showmem(DEBUG,"Before buildFileList()");

    initList(anchor);
    countFile := buildFileList(anchor,useLFN,DEBUG,filespec);

    showmem(DEBUG,"After buildFileList()");

    CASE countFile OF
    | 0 :            abort(errNoMatch,"<source> does not exist !");
    | 1 : ;
    | MAX(CARDINAL): abort(errTooMany,"Too many files match <source> !");
    END;

    IF useLFN THEN
        poll := 50; (* vindoze does not like frequent calls TO chkEscape() *)
    ELSE
        poll := 5;
    END;
    currpoll:=0;

    ptr:=anchor;
    WHILE ptr # NIL DO
        getStr(target,ptr);
        Str.Concat(source,basedir,target);
        newExt(target,extTXT);

        IF fileExists(useLFN,target) THEN
            IF overwrite THEN
                ok:=TRUE; S:="::: Overwrite existing ~";
            ELSE
                ok:=FALSE;S:="::: Skip existing ~";
            END;
        ELSE
                ok:=TRUE; S:="::: Create ~";
        END;
        Str.Subst(S,tilde,dquote+tilde+dquote);
        Str.Subst(S,tilde,target);
        IF NOT(onlydump) THEN WrStr(S);WrLn; END;

        IF ok THEN procRTF(useLFN,onlydump,DEBUG,source,target); END;

        INC(currpoll);
        IF (currpoll MOD poll) = 0 THEN
            IF ChkEscape() THEN
                freeList(anchor);
                abort(errAborted,"Aborted by user !");
            END;
            currpoll:=0;
        END;

        ptr:=ptr^.next;
    END;
    freeList(anchor);

    showmem(DEBUG,"After freeList()");

    abort(errNone,"");
END unrtf.





(*

crappy format !

tokens :

\par (trailing blank or [0..9-])
\tab
\cell

escaped characters :

\'##

*)

