(* ---------------------------------------------------------------
Title         see help
Overview      see help
Usage         see help

Notes         adler32 is not so fast as advertised !
              but yes, it's coded in m2 for now...
              should we zero adler32 buffer out of safety ?
              don't use NEW() to allocate arrays, for it crashes ungracefully
              note win9X accepts multiple dots in filenames (q&d hack/fix)

                         flushed cache   no cache   (500 files, 50Mb)
              crc32            19s          21s
              adler32          17s          19s
              fletcher         19s          21s
              fsize             2s           2s
              chkdata          20s          23s
              chkdata -g       18s          20s

              note xlarge model is much slower than compact :-(

              compact v1.3k   0mn 2.15s     1mn 22.06s
              xlarge  v1.3l   0mn 4.51s     3mn 30.42s
              compact v1.3m   0mn 2.36s     1mn 29.70s (adler and fletcher disabled)

              funny : MD5 collisions have been discovered,
              and now many bozos say "horror ! unsecure ! obsolete !"
              they don't seem to have thought of using MORE than one method
              in order to check data (CRC32+MD5, MD5+SHA, etc.)
              finding collisions able to fool several checksums/digests
              would require at least a god ! once again, common sense...

              we use SHA-1 here

              v1.3p options -! and -b are NOT checked for noNonsense

Bugs          well, implementation quirk in fact : as we use CARDINALs,
              we won't check more than 65535-1 files even with -d option

              weird compiler bug : now we've added MD5, xlarge model
              with -v forces a random log not found error !!!

              not really a bug but when computing checksums,
              CS bargraph display is pertinent to directories,
              NOT to files !

              warning ! listModified() should be checked :
              when in quick (unsafe) mode, when using disk,
              we can flag as "##" files which have not changed
              (related to crc=0 or same size found elsewhere ?)
              (csquick displays modified files which have not changed,
              while csall works !)

              with XP crap, extremely complex and/or deep directory structures
              may force errorinf.$$$ creation and other crashes about farheap corrupted
              (who said it was foolish to expect real DOS console support from m$ ?)

              setting useINLINE to TRUE in QD_MD5 would add 12Kb !

Wish List     ignore path ? change unit ? (see CHKDATA)
              count number of log entries to autoset -d if more than 10000 files ?
              working() when comparing without redirection ?
              chkEscape() while comparing logs ?
              we'll need more pathtype vars
              alternate log line format : "method value path" without header ?
              (i.e. "CRC32 [$]######## u:...")
              autofind checksum type even without header ?
              yes, rebuild could be smarter using a file list and a method

--------------------------------------------------------------- *)

MODULE cs;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT IO;
IMPORT QD_Box; (* required for "candy" local submodule *)

FROM IO IMPORT WrStr, WrLn, WrLngCard;

FROM Storage IMPORT Available,ALLOCATE,DEALLOCATE,
HeapTotalAvail, MainHeap;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed;

FROM QD_CRC IMPORT ComputeCRC32, ComputeCRCval, setSigmaUse,
SegmentFileComputeCRC32;

FROM QD_MD5 IMPORT MD5str, MD5digestType,
MD5toString, stringToMD5, ComputeMD5;

FROM QD_SHA IMPORT SHAstr, SHAdigestType,
SHAtoString, stringToSHA, ComputeSHA;

FROM QD_Adler IMPORT ComputeAdler32;

FROM QD_FCS IMPORT ComputeFletcherCheckSum;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XsupportLFN;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    (*
    memory model has to be changed according to this directive
    from v1.3m, should be FALSE as to user faster compact model
    if true, program must use SLOWER xlarge model
    *)
    ADLERFLETCHER = FALSE;
TYPE
    pathtype   = path9X; (* longer than str128 *)
CONST
    firstmethod  = 1; (* crc *)
    lastmethod   = 7; (* subdirs *)
TYPE
    cmdtype = (undefined,
               crc,md5,sha,adler,fletcher,unsafe,subdirs,
               verify,compare,rebuild);

CONST
    maxPath   = 5000; (* should do for both DOS and Win9X *)
    sMaxPath  = "5000";
CONST
    maphex      = "0123456789abcdef"; (* MD5 / SHA *)
    nl          = CHR(13)+CHR(10);
    tab         = CHR(9);
    colon       = ":";
    dot         = ".";
    backslash   = "\";
    dotdot      = dot+dot;
    dollar      = "$";
    star        = "*";
    stardotstar = star+dot+star;
    netslash    = backslash+backslash;
    blank       = " ";
    seps        = blank+tab;
    nullchar    = CHR(0);
    singlequote = "'";
    doublequote = '"';
    extLOG      = ".LOG";
    extTMP      = ".TMP";
    extBAK      = ".BK!";
    wifsize     = 10; (* was 9 *)
CONST
    tmprebuild  = "~DEL_ME~";     (* f8 for -r[r] *)
    tmpold      = "~OLD"+extTMP;
    tmpnew      = "~NEW"+extTMP;
    extEXE      = ".EXE";
    extINI      = ".INI";
    semicolon   = ";";
    REMCHAR     = semicolon;
    OPENSECTION = "[";
    CLOSESECTION= "]";
    (* both lowercase *)
    sectionExclude = OPENSECTION+"exclude"+CLOSESECTION;
    sectionSelect  = OPENSECTION+"select"+CLOSESECTION;
    sectionInclude = OPENSECTION+"include"+CLOSESECTION; (* in fact, select mode *)
CONST
    msgLFN       = "Win9X LFNs        : ";
CONST
    msgOldLog    = "Older logfile     : ";
    msgNewLog    = "Newer logfile     : ";
    msgUseDisk   = "Indexes storage   : ";
CONST
    msgDefault   = "Default directory : ";
    msgBaseDir   = "Base directory    : ";
    msgSpec      = "Specification     : ";
    msgINI       = "INI file          : ";
CONST (* no spaces within strings here, for tabsep's sake ! *)
    bl2          = "  ";
    bl4          = bl2+bl2;
    bl8          = bl4+bl4;
    dash8        = "--------";

    sFiller      = "$$$$$$$$$";

    sCRC         = "CRC32    ";
    sMD5         = "MD5      "+bl8+bl8+bl8;     (* $ + 32 chars *)
    sSHA         = "SHA-1    "+bl8+bl8+bl8+bl8; (* $ + 40 chars *)
    sADLER       = "Adler-32 ";
    sFLETCHER    = "Fletcher ";
    sUNSAFE      = "Q&D      ";
    sSUBDIRS     = "<DIR>    ";
    sHeader0     =          "  ----------  ---------------";
    sHeader1     = sFiller+ "  Length      Path";
    sHeader2     = "---------"+sHeader0;
    sHeader2md5  = "-"+dash8+dash8+dash8+dash8+sHeader0; (* message digest *)
    sHeader2sha  = "-"+dash8+dash8+dash8+dash8+dash8+sHeader0; (* message digest *)
    msgMissing   = "Not found ! ";
    msgSizePb    = "Size      ! ";
    msgCpb       = "CRC32     ! ";
    msgMpb       = "MD5       ! ";
    msgSpb       = "SHA-1     ! ";
    msgApb       = "Adler-32  ! ";
    msgFpb       = "Fletcher  ! ";
CONST
    longDeleted  = "Deleted   ! ";
    longAdded    = "Added     ! ";
    longSize     = "Size      ! ";
    longModified = "Modified  ! ";
    shortDeleted = "-- ";
    shortAdded   = "++ ";
    shortModified= "## ";
CONST
    dash10       = "----------";
    dashDeleted  = REMCHAR+" Deleted";
    dashAdded    = REMCHAR+" Added";
    dashModified = REMCHAR+" Modified";
    dashline     = REMCHAR+dash10+dash10+dash10+dash10+dash10+dash10+dash10;

    dashStarted  = REMCHAR+" Report started on ";
    dashCompleted= REMCHAR+" Report completed on ";
    dashElapsed  = REMCHAR+" Elapsed time was ";
    dasholder    = REMCHAR+" Older logfile (";
    dashnewer    = REMCHAR+" Newer logfile (";
    dashsep      = ") : ";

    dashmethod   = REMCHAR+" Method : ";
    dashinfo1    = REMCHAR+" 8ung ! Files excluded when creating logfiles CANNOT be checked here !";
    dashinfo2    = REMCHAR+" 8ung ! For obvious reasons, report is best viewed in 132 columns mode !";

    dashSummary  = REMCHAR+" Summary";
    msgDeleted   = "Entries deleted  : ";
    msgAdded     = "Entries added    : ";
    msgChanged   = "Entries modified : ";

CONST
    searchingDeleted  = "Step 1/3 : looking for deleted entries... ";
    searchingAdded    = "Step 2/3 : looking for added entries... ";
    searchingModified = "Step 3/3 : looking for modified entries... ";
CONST
    msgEverythingGoes     = "All files checked. No problem detected.";
    msgEverythingWentFine = "All files analyzed.";
    msgProcessing    = "Please wait while processing ";
    msgChecking      = "Please wait while checking...";
    msgRebuilding    = "Please wait while analyzing...";
    msgIndexing      = "Please wait while indexing "; (* name will follow *)
    msgScanningMethod= "Please wait while scanning "; (* name will follow *)
CONST
    sTMP        = "TMP";
    sTEMP       = "TEMP";
    sTMPDIR     = "TMPDIR";
    sTEMPDIR    = "TEMPDIR";
    sOLDNDX     = "~DELME1~.TMP"; (* very unlikely to exist ! *)
    sNEWNDX     = "~DELME2~.TMP";
CONST
    sSwapWin92  = "*\386spart.par";  (* lowercase *)
    sSwapWin98  = "*\win386.swp";
    sSwapWinXP  = "*\pagefile.sys";

CONST
    progEXEname   = "CS";
    progTitle     = "Q&D CheckSum";
    progVersion   = "v1.3s";
    progCopyright = "by PhG";
    Banner        = progTitle+" "+progVersion+" "+progCopyright;

CONST
    errNone              = 0;
    errHelp              = 1;
    errOption            = 2;
    errSyntax            = 3;
    errBadSpec           = 4;
    errTooManyDirs       = 5;
    errMethod            = 6;
    errNonsense          = 7;
    errJoker             = 8;
    errNotFound          = 9;
    errBadFormat         = 10;
    errBadLine           = 11;
    errBadLog            = 12;
    errTooManyINIentries = 13;
    errIllegalINIsection = 14;
    errMissingINIsection = 15;
    errExclusive         = 16;
    errMethods           = 17;
    errMEM               = 18;
    errOverflow          = 19;
    errMaybeWare         = 20;
    errChkMethod         = 21;
    errDiskRequiredForMD5= 22; (* obsolete *)
    errDiskRequiredForSHA= 23; (* obsolete *)

    errAbortedByUser     = 64;

    errMissingEntries    = 128;
    errDifferences       = 129;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);

    MODULE message;
    IMPORT Str;
    EXPORT msg3;

    PROCEDURE msg3 (VAR R:ARRAY OF CHAR;S1,S2,S3:ARRAY OF CHAR);
    BEGIN
        Str.Concat(R,S1,S2);Str.Append(R,S3);
    END msg3;

    END message;

CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)

    msghelp=
Banner+nl+
nl+
(*%T ADLERFLETCHER *)
"Syntax 1 : "+progEXEname+" <file(s)> <-c|-m|-$|-a|-f|-z|-s> [-l-n-g-t[-x[x]|-e|-j]-u-q-w]"+nl+
"Syntax 2 : "+progEXEname+" <log["+extLOG+"]> <-v[cm$afzs]> [-p-u-q-w-b]"+nl+
"Syntax 3 : "+progEXEname+" <log1["+extLOG+"]> <log2["+extLOG+"]> <-k[cm$afzs]> [-d-y-i-u-q-w]"+nl+
(*%E *)
(*%F ADLERFLETCHER *)
"Syntax 1 : "+progEXEname+" <file(s)> <-c|-m|-$|-z|-s> [-l-n-g-t[-x[x]|-e|-j]-u-q-w]"+nl+
"Syntax 2 : "+progEXEname+" <log["+extLOG+"]> <-v[cm$zs]> [-p-u-q-w-b]"+nl+
"Syntax 3 : "+progEXEname+" <log1["+extLOG+"]> <log2["+extLOG+"]> <-k[cm$zsd]> [-d-y-i-u-q-w]"+nl+
(*%E *)
"Syntax 4 : "+progEXEname+" <log["+extLOG+"]> <-r[r]> [-p-u-q-w]"+nl+
nl+
"This program computes checksums (syntax 1), verifies checksums (syntax 2),"+nl+
"compares two logs (syntax 3), or rebuilds data for each log entry (syntax 4)."+nl+
nl+
"-c    compute CRC 32 checksums (default)"+nl+
(*%F ADLERFLETCHER *)
"-m|-$ compute MD5 or SHA-1 message digests (-d forced with syntax 3)"+nl+
(*%E *)
(*%T ADLERFLETCHER *)
"-m|-$ compute MD5 or SHA-1 message digests (-d forced with syntax 3)"+nl+
"-a|-f compute Adler 32 or Fletcher 16 checksums (not recommended)"+nl+
(*%E *)
"-z    quick unsafe mode (for each file, only filesize is tracked)"+nl+
"-s    do not process files but subdirectories (-x forced and -n ignored)"+nl+
"-v[?] verify log previously created with redirected ouput (128=FNF, 129=#)"+nl+
"-k[?] compare two logs, assuming oldest is reference (-kd = -k -d)"+nl+
"-r[r] rebuild data from log (method header assumed, -rr keeps no backup)"+nl+
(* nl+ *)
"-!    ignore filesize check for MD5 or SHA methods"+nl+
"-b    store relative paths (default is to store canonical paths)"+nl+
"-l    disable LFN support even if available"+nl+
"-n    do not include subdirectories (default is to include subdirectories)"+nl+
"-d    store indexes on disk instead of RAM"+nl+
"      (slower but allowing more than 10000 entries, forced with -k[m$] -m|-$)"+nl+
"-g    exclude method header (default is to include method header)"+nl+
"-t    use tab as a separator"+nl+
"-x[x] ignore entries listed in "+progEXEname+extINI+", if any (-xx = -x but still ignoring"+nl+
'      "'+sSwapWin92+'", "'+sSwapWin98+'", "'+sSwapWinXP+')"'+nl+
"-e    reverse search order for "+progEXEname+extINI+nl+
"-j    force select mode for "+progEXEname+extINI+" entries (default is exclude mode)"+nl+
"-u    paths in uppercase (default is lowercase)"+nl+
"-p    ignore path in log entries (ignored if log was created with -s)"+nl+
'-y    use "'+longDeleted+'", "'+longAdded+'" and "'+longModified+'" long prefixes'+nl+
'      (default is "'+shortDeleted+'", "'+shortAdded+'" and "'+shortModified+'" short prefixes)'+nl+
"-i    add final report"+nl+
"-q    quiet redirected mode (no eyecandy)"+nl+
"-w    audio warning"+nl+
nl+
"a) Headerless logs can be processed using -<v|k><"+
(*%T ADLERFLETCHER *)
"cm$afz"+
(*%E *)
(*%F ADLERFLETCHER *)
"cm$z"+
(*%E *)
"> option variants."+nl+
"b) "+progEXEname+extINI+" may contain up to 100 entries (syntax 1 only)"+nl+
"   specifying files to be excluded (default) or selected (with -j option) :"+nl+
"   it is first searched for in current directory, then in executable directory."+nl+
(* "   (unless -e option was specified to reverse default search order)."+nl+ *)
"c) With syntax 1, output, if redirected, should not belong to scanned domain."+nl+
"d) Syntax 3 cannot process more than 10000 entries in a valid log, unless"+nl+
"   -d option is specified to create temporary files in directory specified by,"+nl+
"   in that order, "+sTMP+", "+sTEMP+", "+sTMPDIR+", "+sTEMPDIR+" environment variables"+nl+
"   (if none of these variables is defined, current directory will be used)."+nl+
"e) Program returns 255 if Escape key was used to abort syntax 1 or syntax 2 ;"+nl+
"   but for log integrity, Escape key is disabled if output is redirected."+nl+
'f) Whatever the operation, lines beginning with "'+REMCHAR+'" will be ignored.'+nl+
"g) Even if LFN support is available, log(s) must be specified in DOS format."+nl;
(* "This DOS utility has very limited LFN support : let command line user beware !"+nl; *)

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :        WrStr(msghelp);
    | errOption :      msg3(S,"Illegal ",einfo," option !");
    | errSyntax :      S:="Illegal command line, check syntax !";
    | errBadSpec :     msg3(S,"Illegal ",einfo," specification !");
    | errTooManyDirs : msg3(S,"Memory full or more than "+sMaxPath+" directories from ",einfo," !");
    | errMethod :
                       (*%T ADLERFLETCHER *)
                       S:="-c, -m, -$, -a, -f, -z, -s, -v, -r[r] and -k are mutually exclusive !";
                       (*%E *)
                       (*%F ADLERFLETCHER *)
                       S:="-c, -m, -$, -z, -s, -v, -r[r] and -k are mutually exclusive !";
                       (*%E *)
    | errNonsense:  msg3(S,einfo," option is a nonsense with specified command !","");
    | errJoker:     msg3(S,"Illegal joker(s) in ",einfo," log !");
    | errNotFound:  msg3(S,einfo," log does not exist !","");
    | errBadFormat:
                    (*%T ADLERFLETCHER  *)
                    msg3(S,"Unrecognized ",einfo," log format !");
                    (*%E *)
                    (*%F ADLERFLETCHER  *)
                    msg3(S,"Unrecognized ",einfo," log format or unsupported method !");
                    (*%E *)
    | errBadLine:   msg3(S,"Unexpected (",einfo,") line format !");
    | errBadLog:    msg3(S,"Unexpected problem (format or line) with ",einfo," log !");
    | errTooManyINIentries: msg3(S,"Too many entries in ",einfo," file !");
    | errIllegalINIsection: msg3(S,"Illegal section in ",einfo," !");
    | errMissingINIsection: msg3(S,"Sections do not exist in ",einfo," !");
    | errExclusive: S:="-x[x] and -j options are mutually exclusive !";
    | errMethods  : S:="Method mismatch between logs to compare !";
    | errMEM      : msg3(S,"Storage.ALLOCATE() failure for ",einfo," !");
    | errOverflow : msg3(S,"Too many entries in ",einfo," log !");
    | errAbortedByUser:S:="Aborted by user !";
    | errMaybeWare:S:="-m option is not yet implemented !";
    | errChkMethod :
                     (*%T ADLERFLETCHER *)
                     S:="-vc, -vm, -v$, -va, -vf and -vz are mutually exclusive !";
                     (*%E *)
                     (*%F ADLERFLETCHER *)
                     S:="-vc, -vm, -v$ and -vz are mutually exclusive !";
                     (*%E *)
    | errDiskRequiredForMD5:S:="-d option is required to compare MD5 logs !";
    | errDiskRequiredForSHA:S:="-d option is required to compare SHA-1 logs !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp : ;
    | errMissingEntries,errDifferences : ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

    MODULE candy;
    FROM QD_Box IMPORT animInit, anim, animAdvance, animEnd, animClear;
    EXPORT doEyecandy, CANDYinit,CANDYshow,CANDYdone,CANDYsave,CANDYrestore;

    CONST
        CANDYinit    = 0;
        CANDYshow    = 1;
        CANDYdone    = 2;
        CANDYsave    = 3;
        CANDYrestore = 4;

        steps     = 10;
    VAR
        range,current,savecurrent:LONGCARD;
        advanced,i:CARDINAL;

    PROCEDURE doEyecandy (bargraf:BOOLEAN;what:CARDINAL;v:LONGCARD);
    BEGIN
       IF bargraf THEN
           CASE what OF
           | CANDYinit: (* v is total count *)
               animInit(steps, "[", "]", CHR(46), "", "\/" );
               range:=v DIV steps; INC(range); (* avoid DIV 0 ! *)
               current:=1;
               advanced:=0;
           | CANDYshow: (* v is current i *)
               IF (v DIV range) # current THEN
                   anim(animAdvance);
                   current:=(v DIV range);
                   INC(advanced);
               END;
           | CANDYdone:
               anim(animEnd);anim(animClear);
           | CANDYsave:
               anim(animEnd);anim(animClear);
               savecurrent:=current;
           | CANDYrestore:
               animInit(steps, "[", "]", CHR(46), "", "\/" );
               current:=savecurrent;
               FOR i:=1 TO advanced DO
                   anim(animAdvance);
               END;
           END;
      END;
    END doEyecandy;

    END candy;

(* ------------------------------------------------------------ *)

PROCEDURE sound (freq,duration,pause:CARDINAL);
BEGIN
    Lib.Sound(freq);
    Lib.Delay(duration);
    Lib.NoSound();
    Lib.Delay(pause);
END sound;

PROCEDURE alarm (  );
BEGIN
    sound(55,55,100);
    sound(55,55,10);
END alarm;

PROCEDURE alert (  );
BEGIN
    sound(550,55,100);
    sound(550,55,10);
END alert;

PROCEDURE showmem(S:ARRAY OF CHAR );
VAR
    heapsize    : CARDINAL; (* in PARAGRAPHS and not in bytes ! help is wrong ! *)
    n           : LONGCARD;
BEGIN
    heapsize :=HeapTotalAvail(MainHeap);
    n :=16 * LONGCARD(heapsize);
    WrStr("::: ");WrLngCard(n,6); WrStr(" byte(s) free -- ");WrStr(S);WrLn;
END showmem;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ioBufferSize      = (8 * 512) + FIO.BufferOverhead; (* 8 is enough *)
    firstioBufferByte = 1;
    lastioBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstioBufferByte..lastioBufferByte] OF BYTE;
VAR
    ioInBuffer        : ioBufferType; (* buildINIentries, procLog, doIndex::called_by_compareLogs *)
    ioOld             : ioBufferType; (* compareLogs *)
    ioNew             : ioBufferType; (* compareLogs, procLog *)
    ioDskOld,ioDskNew : ioBufferType; (* doIndex::called_by_compareLogs *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstPath = 1;    (* was 0, but 1 required by Lib.QSort and by firstPath-1 of course ! *)

TYPE
    ptrToEntry = POINTER TO entrytype;
    entrytype  = RECORD
        slen : SHORTCARD;
        string:CHAR; (* variable length *)
    END;
VAR
    Path      : ARRAY[firstPath..maxPath] OF ptrToEntry;
    lastPath  : CARDINAL;

PROCEDURE getentry (i:CARDINAL; VAR R : pathtype);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(Path[i]^.slen);
    Lib.FastMove( ADR(Path[i]^.string),ADR(R),len);
    R[len]:=nullchar; (* REQUIRED safety ! *)
END getentry;

PROCEDURE setentry (i:CARDINAL; S : pathtype ) : BOOLEAN ;
VAR
    len,needed:CARDINAL;
BEGIN
    len    := Str.Length(S);
    needed := SIZE(entrytype)-SIZE(CHAR)+len;
    IF Available(needed) THEN
        ALLOCATE(Path[i],needed);
        Path[i]^.slen := SHORTCARD(len);
        Lib.FastMove( ADR(S),ADR(Path[i]^.string),len);
    ELSE
        Path[i]:=NIL;
    END;
    RETURN (Path[i] # NIL);
END setentry;

PROCEDURE freePaths (lastpath:CARDINAL);
VAR
    i,len,needed:CARDINAL ;
BEGIN
    FOR i := firstPath TO lastpath DO
        IF Path[i] # NIL THEN (* useless safety *)
            len := CARDINAL( Path[i]^.slen);
            needed := SIZE(entrytype)-SIZE(CHAR)+len;
            DEALLOCATE(Path[i],needed);
        END;
        Path[i]:=NIL;
    END;
END freePaths;

(*
(* // accents handling ? *)

PROCEDURE isLess (i,j : CARDINAL) : BOOLEAN;
VAR
    SI,SJ:pathtype;
BEGIN
    getentry(i,SI);
    getentry(j,SJ);
    IF Str.Compare(SI,SJ) < 0 THEN (* -1 is less *)
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END isLess;

PROCEDURE doSwap (i,j : CARDINAL);
VAR
    S : ptrToEntry;
BEGIN
    S:=Path[i];
    Path[i]:=Path[j];
    Path[j]:=S;
END doSwap;
*)

(* ------------------------------------------------------------ *)

PROCEDURE fixDirPath (VAR S : ARRAY OF CHAR);
VAR
    len : CARDINAL;
BEGIN
    len := Str.Length(S);
    IF len = 0 THEN
        Str.Copy(S,backslash);
    ELSE
        IF S[len-1] # backslash THEN
            Str.Append(S,backslash);
        END;
    END;
END fixDirPath;

PROCEDURE isDirEntry (S : ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isDirEntry;

CONST
    nothingRequired = FIO.FileAttr{};

PROCEDURE doDir (root : pathtype;useLFN,eyecandy:BOOLEAN;
                 VAR index:CARDINAL;VAR err:BOOLEAN);
VAR
    path    : pathtype;
    S       : pathtype;
    entry   : FIO.DirEntry;
    found   : BOOLEAN;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    rc : BOOLEAN;
    full:pathtype;
    dosattr:FIO.FileAttr;
BEGIN
    IF index > maxPath THEN
        err:=TRUE;
        RETURN;
    END;
    fixDirPath(root); (* add required "\" here *)
    IF setentry(index,root)=FALSE THEN
        err:=TRUE;
        RETURN;
    END;
    Str.Copy(path,root); (* "\" already added *)
    Str.Append(path,stardotstar); (* root\*.* *)

    IF useLFN THEN
        found := w9XfindFirst (path,SHORTCARD(everything),SHORTCARD(nothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(path,everything,entry);
    END;
    WHILE found DO
        IF eyecandy THEN Work(cmdShow); END;
        Str.Copy(S,root);
        fixDirPath(S);

        IF useLFN THEN
            Str.Copy(full,w9Xentry.fullfilename);
        ELSE
            Str.Copy(full,entry.Name);
        END;
        Str.Append(S,full); (* root\f8e3 *)
        IF isDirEntry(full)=FALSE THEN (* skip . AND .. *)
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=entry.attr;
            END;
            IF (aD IN dosattr) THEN
                INC(index);
                doDir(S,useLFN,eyecandy,index,err);
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
END doDir;

PROCEDURE BuildPathList (useLFN,recurse:BOOLEAN; rootdir : pathtype) : CARDINAL;
CONST
    msg1 = "Building list of ";
    msg2 = "Windows 9X ";
    msg3 = "directories for ";
VAR
    found    : BOOLEAN;
    i        : CARDINAL;
    prompt   : pathtype; (* we may have a long filename *)
    error    : BOOLEAN;
BEGIN
    i        := firstPath;
    error    := FALSE;
IF recurse THEN
    Str.Copy(prompt,msg1);
    IF useLFN THEN Str.Append(prompt,msg2);END;
    Str.Append(prompt,msg3);
    Str.Append(prompt,rootdir);

    video (prompt,TRUE);
    Work(cmdInit);

    doDir(rootdir,useLFN,TRUE,i,error);

    Work(cmdStop);
    video (prompt,FALSE);
ELSE
    IF setentry(i,rootdir)=FALSE THEN error:=TRUE;END;
END;
    IF error THEN i:=MAX(CARDINAL); END;
    RETURN i;
END BuildPathList;

(* ------------------------------------------------------------ *)

(* adapted from QD_BOX.MOD dated 4 Oct 03 *)

PROCEDURE w9XisDirectory (S : path9X) : BOOLEAN;
VAR
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    found,rc : BOOLEAN;
    dosattr:FIO.FileAttr;
BEGIN
    unfixDirectory(S);
    CASE Str.Length(S) OF
    | 2 : (* avoid "u:" alone ! *)
        IF S[1]=colon THEN RETURN TRUE; END; (* always but we do not check for its real life *)
    | 3 : (* avoid "u:\" alone ! *)
        IF S[1]=colon THEN
            IF S[2]=backslash THEN RETURN TRUE; END; (* always but we do not check for its real life *)
        END;
    END;
    found := w9XfindFirst (S,SHORTCARD(everything),SHORTCARD(nothingRequired),
                          unicodeconversion,w9Xentry,w9Xhandle,errcode);
    rc:=w9XfindClose(w9Xhandle,errcode);
    IF found = FALSE THEN RETURN FALSE; END;
    dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
    RETURN (aD IN dosattr);
END w9XisDirectory;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE s2lc (VAR v : LONGCARD; base:CARDINAL;S:ARRAY OF CHAR):BOOLEAN ;
VAR
    ok:BOOLEAN;
BEGIN
    UpperCase(S);
    IF base=16 THEN
        ReplaceChar(S,dollar,"");
    END;
    v:=Str.StrToCard(S,base,ok);
    RETURN ok;
END s2lc;

PROCEDURE dotab (VAR R:ARRAY OF CHAR);
BEGIN
    LOOP
        IF Str.Pos(R,"  ")=MAX(CARDINAL) THEN EXIT;END;
        Str.Subst(R,"  "," ");
    END;
    LOOP
        IF Str.CharPos(R," ")=MAX(CARDINAL) THEN EXIT;END;
        Str.Subst(R," ",tab);
    END;
END dotab;

PROCEDURE valToStr (base,digits:CARDINAL;prefix,pad:CHAR;v:LONGCARD):str16;
VAR
    S : str16;
    ok: BOOLEAN;
BEGIN
    Str.CardToStr(v,S,base,ok);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    Str.Prepend(S,prefix);
    IF base=16 THEN LowerCase(S); END;
    RETURN S;
END valToStr;

(* return TRUE if no dot in \f8.e3 part *)

PROCEDURE needTrailingDot (S:ARRAY OF CHAR):BOOLEAN;
VAR
    u,d,n,e,ne:pathtype; (* we may get a long filename *)
BEGIN
    Lib.SplitAllPath(S,u,d,n,e);
    Lib.MakeAllPath(ne,"","",n,e);
    RETURN Str.CharPos(ne,dot)=MAX(CARDINAL);
END needTrailingDot;

PROCEDURE unquote(bothquotes:BOOLEAN ; VAR S:ARRAY OF CHAR);
VAR
    len,last,i:CARDINAL;
    ch:CHAR;
    pat:str16;
BEGIN
    IF bothquotes THEN
        last:=2;
    ELSE
        last:=1;
    END;
    i:=1;
    LOOP
        CASE i OF
        | 1: ch:=doublequote;
        | 2: ch:=singlequote;
        END;
        Str.Concat(pat,ch,"*");Str.Append(pat,ch);
        IF Str.Match(S,pat) THEN
            Str.Delete(S,0,1); (* first doublequote *)
            len:=Str.Length(S);
            Str.Delete(S,len-1,1);
            EXIT;
        END;
        INC(i);
        IF i > last THEN EXIT; END;
    END;
END unquote;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(*

;
; in fact, this file is CHKDATA.INI
;
; files excluded by CS when computing checksums
;
; 386spart.par should ALWAYS be excluded for obvious reasons
;

[exclude]

*\386spart.par
*\pagefile.sys
*\win386.swp

?:\diskmap.*
?:\image.*
?:\treeinfo.*
?:\tmp\*
*.{*
*.$$$
*.tmp
*.bak
*.bk2
*.chk
*.ndx
*.swp
*.lnk
*.jbf
*\when.log
?:\sentry\*
?:\recycled\*
?:\hibrn8.dat
*\chkdata._?_
?:\snapshot.log
?:\snapshot.txt
?:\order.txt
c:\selectit\selit.cfg
*\index.dat
*\temp\*
*\chkfiles.all
*\netscape\*.db
*.old
*.new
?:\cs*.crc
?:\cs*.rpt
?:\cs*.log

[select]

*.exe
*.com

*)

(* hashing was tested, without any gain in speed *)

CONST
    firstINIentry = 1;
    maxINIentry   = 100; (* at least 3 ! *)
TYPE
    INIentryArray = ARRAY [firstINIentry..maxINIentry] OF str128;
    ptrToINIentryArray = POINTER TO INIentryArray;
VAR
    pINIentry     : ptrToINIentryArray;
    lastINIentry : CARDINAL;

PROCEDURE includeIt (excludemode:BOOLEAN; file:ARRAY OF CHAR):BOOLEAN; (* do NOT modify them ! *)
VAR
    i : CARDINAL;
    rc,ok,nope:BOOLEAN;
    S:str128;
BEGIN
    IF excludemode THEN
        ok  :=TRUE;
        nope:=FALSE;
    ELSE
        ok  :=FALSE;
        nope:=TRUE;
    END;

    i := firstINIentry;
    LOOP
        IF i > lastINIentry THEN rc:=ok;EXIT; END;
        IF Str.Match(file,pINIentry^[i]) THEN rc:=nope;EXIT; END;
        INC(i);
    END;
    RETURN rc;
END includeIt;

(* do not forget to convert entries to lowercase after unquoting them !!! *)

PROCEDURE buildINIentries (ignoreini,stillavoidswapfiles,excludemode:BOOLEAN;
                          inifile:ARRAY OF CHAR):CARDINAL;
VAR
    state : (waiting,gotexclude,gotselect,overflow,illegal); (* // *)
    i   : CARDINAL;
    S   : str128;
    hnd : FIO.File;
    processme:BOOLEAN;
BEGIN
    i := firstINIentry;

    IF ignoreini THEN
        IF stillavoidswapfiles THEN
            S:=sSwapWin92;
            Str.Copy(pINIentry^[i],S);
            INC(i);
            S:=sSwapWin98;
            Str.Copy(pINIentry^[i],S);
            INC(i);
            S:=sSwapWinXP;
            Str.Copy(pINIentry^[i],S);
            INC(i);
        END;
        lastINIentry := i-1;
        RETURN errNone; (* not very bright, we should always add "386spart.par" *)
    END;

    IF FIO.Exists(inifile)=FALSE THEN
        lastINIentry := i-1;
        RETURN errNone; (* not very bright, we should always add "386spart.par" *)
    END;

    state:=waiting;

    FIO.EOF := FALSE; (* safety fix for flag seems set to true by fio.exists ! *)

    hnd:=FIO.OpenRead(inifile);
    FIO.AssignBuffer(hnd,ioInBuffer);
    LOOP
        IF FIO.EOF THEN EXIT; END;
        FIO.RdStr(hnd,S);
        LtrimBlanks(S);RtrimBlanks(S);
        unquote(TRUE,S);
        LowerCaseAlt(S);
        (* IF same(S,"")=FALSE THEN *)
            CASE S[0] OF
            | nullchar,REMCHAR :
                ;
            | OPENSECTION :
                (* we could remove brackets and spaces here but... *)
                IF    same(S,sectionExclude) THEN
                    state:=gotexclude;
                ELSIF same(S,sectionSelect) THEN
                    state:=gotselect;
                ELSIF same(S,sectionInclude) THEN
                    state:=gotselect;
                ELSE
                    state:=illegal;EXIT;
                END;
            ELSE
                processme:=FALSE;
                CASE state OF
                | gotexclude:
                    processme:=excludemode;
                | gotselect:
                    processme:=NOT(excludemode);
                END;
                IF processme THEN
                    (* no check is made for specification here ! *)
                    IF i > maxINIentry THEN state:=overflow;EXIT;END;
                    Str.Copy(pINIentry^[i],S);
                    INC(i);
                END;
            END;
        (* END; *)
    END;
    FIO.Close(hnd);
    CASE state OF
    | waiting:  RETURN errMissingINIsection;
    | overflow: RETURN errTooManyINIentries;
    | illegal:  RETURN errIllegalINIsection;
    END;

    lastINIentry := i-1;
    RETURN errNone;
END buildINIentries;

PROCEDURE doHeader (cmd:cmdtype; tabsep:BOOLEAN );
VAR
    S,R:str128;
BEGIN
    Str.Copy(S,sHeader1);
    CASE cmd OF
    | crc:       R:=sCRC;
    | md5:       R:=sMD5;
    | sha:       R:=sSHA;
    | adler:     R:=sADLER;
    | fletcher:  R:=sFLETCHER;
    | unsafe:    R:=sUNSAFE;
    | subdirs:   R:=sSUBDIRS;
    END;
    Str.Subst(S,sFiller,R);
    CASE cmd OF
    | md5 :
        Str.Copy(R,sHeader2md5);
    | sha :
        Str.Copy(R,sHeader2sha);
    ELSE
        Str.Copy(R,sHeader2);
    END;
    IF tabsep THEN
        dotab(S);
        dotab(R);
    END;
    WrStr(S);WrLn;
    WrStr(R);WrLn;
END doHeader;

PROCEDURE casify(lowercase:BOOLEAN;VAR S:ARRAY OF CHAR);
BEGIN
    IF lowercase THEN
        LowerCaseAlt(S);
    ELSE
        UpperCaseAlt(S);
    END;
END casify;

PROCEDURE computeLogs (cmd:cmdtype;
                      useLFN,lowercase,excludemode,
                      special,redir,includeBaseDir:BOOLEAN;
                      separ:ARRAY OF CHAR; R,spec,basedir:pathtype):BOOLEAN;
VAR
    found:BOOLEAN;
    entry:FIO.DirEntry;
    S:pathtype;
    msg:pathtype;
    thispath,removeMe:pathtype;
    v,fsize:LONGCARD;
    wi,chksum,cszero:CARDINAL;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    rc : BOOLEAN;
    canonical,shortform:pathtype;
    MD5digest : MD5digestType;
    MD5digeststr : MD5str;
    SHAdigest : SHAdigestType;
    SHAdigeststr : SHAstr;
BEGIN
IF cmd = subdirs THEN
    fsize:=0; wi:=4; v:=0;
    WrStr(valToStr(16,wi,dollar,"0",v)); WrStr(bl4);
    WrStr(separ); WrStr( valToStr(10,wifsize,""," ",fsize));WrStr(separ);
    casify(lowercase,R);
    WrStr(R);WrLn;
    IF redir=FALSE THEN
        IF ChkEscape() THEN
            RETURN FALSE;
        END;
    END;
    RETURN TRUE;
ELSE

    IF includeBaseDir = FALSE THEN
        Str.Copy(removeMe,basedir);
        LowerCaseAlt(removeMe);
        casify(lowercase,removeMe);
    END;

    Str.Concat(msg,msgProcessing,R);
    IF special THEN video(msg,TRUE); END;
    Str.Concat(thispath,R,spec);
    IF useLFN THEN
        found := w9XfindFirst (thispath,SHORTCARD(allfiles),SHORTCARD(nothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(thispath,allfiles,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Concat(canonical, R,w9Xentry.fullfilename);
            rc:=w9XlongToShort (canonical, errcode,S); (* allow LFN filtering *)
            LowerCaseAlt(canonical); (* don't assume anything about case *)
            LowerCaseAlt(S);
        ELSE
            Str.Concat(canonical, R,entry.Name);
            LowerCaseAlt(canonical); (* don't assume anything about case *)
            Str.Copy(S,canonical);
        END;
        IF includeIt (excludemode, canonical) THEN
            fsize := getFileSize(S);
            CASE cmd OF
            | crc      : wi:=8; v:=ComputeCRC32(S);
            | adler    : wi:=8;
                                (*%T ADLERFLETCHER *)
                                v:=ComputeAdler32(S);
                                (*%E *)
                                (*%F ADLERFLETCHER *)
                                v:=0;
                                (*%E *)
            | fletcher : wi:=4;
                                (*%T ADLERFLETCHER *)
                                ComputeFletcherCheckSum(S,chksum,cszero);v:=LONGCARD(chksum);
                                (*%E *)
                                (*%F ADLERFLETCHER *)
                                v:=0;
                                (*%E *)
            | unsafe   : wi:=4; v:=0;
            | md5      : wi:=2; ComputeMD5(MD5digest,S);
            | sha      : wi:=2; ComputeSHA(SHAdigest,S);
            END;
            CASE cmd OF
            | crc,adler       : WrStr(valToStr(16,wi,dollar,"0",v));
            | fletcher,unsafe : WrStr(valToStr(16,wi,dollar,"0",v)); WrStr(bl4);
            | md5             : MD5toString(MD5digeststr, MD5digest);
                                WrStr(dollar); WrStr(MD5digeststr);
            | sha             : SHAtoString(SHAdigeststr, SHAdigest);
                                WrStr(dollar); WrStr(SHAdigeststr);
            END;
            (* yes, we know digests already take size into account *)
            WrStr(separ); WrStr( valToStr (10,wifsize,""," ",fsize) );
            WrStr(separ);
            casify(lowercase,canonical);
            IF includeBaseDir = FALSE THEN
                Str.Subst(canonical,removeMe,"");
            END;
            WrStr(canonical);WrLn;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
        IF redir=FALSE THEN
            IF ChkEscape() THEN
                IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
                IF special THEN video(msg,FALSE);END;
                RETURN FALSE;
            END;
        END;
    END;
    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
    IF special THEN video(msg,FALSE);END;
    RETURN TRUE;
END;
END computeLogs;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* match our ugly but historic CHKDATA display -- ah, the 80s... *)

PROCEDURE warnUser (crbefore,audiowarn:BOOLEAN; missing,mismatches:LONGCARD);
CONST
    msgborder   ="********************************************";
    msgempty    ="*                                          *";
    msgModified ="* FATAL WARNING ! Modified file(s) : $$$$$ *";
    msgMissing  ="* WARNING ! Missing file(s) :        $$$$$ *";
    placeholder ="$$$$$";
VAR
    Z : ARRAY [1..3] OF str80;
    i : CARDINAL;
BEGIN
    IF audiowarn THEN alarm; END;
    Z[1]:=msgborder;
    (* Z[2]:=msgempty;
    Z[4]:=msgempty; *)
    Z[3]:=msgborder;
    IF mismatches # 0 THEN
        Z[2]:=msgModified;
        Str.Subst(Z[2],placeholder, valToStr(10,5,""," ",mismatches) );
    END;
    IF missing # 0 THEN
        Z[2]:=msgMissing;
        Str.Subst(Z[2],placeholder, valToStr(10,5,""," ",missing) );
    END;
    IF crbefore THEN WrLn;END;
    FOR i:=1 TO 3 DO WrStr( Z[i] ); WrLn; END;
END warnUser;

PROCEDURE chkAnyDigestString (VAR sval:ARRAY OF CHAR;what:cmdtype):BOOLEAN;
CONST
    MD5expectedlen = 16;
    SHAexpectedlen = 20;
VAR
    expectedlen : CARDINAL;
BEGIN
    CASE what OF
    | md5 : expectedlen := MD5expectedlen;
    | sha : expectedlen := SHAexpectedlen;
    END;
    expectedlen := (expectedlen << 1); (* *2 because hex digit is 2 chars *)

    LowerCase(sval);
    IF sval[0] # dollar THEN RETURN FALSE; END;
    Str.Delete(sval,0,1);
    IF Str.Length(sval) # expectedlen THEN RETURN FALSE; END;
    RETURN verifyString(sval,maphex);
END chkAnyDigestString;

(*
    verifyLog() took about 2.4 K code
    renamed to procLog() because it can also rebuild data
    missing files entries are rewritten as they were

    it's overkill safety, but rebuild keeps previous version as a backup
    we're too lazy to rebuild from a list of canonical entries "-r[r] -method" :
    some hand editing using dummy values required !
    computers don't have to do all the work, eh eh...
    rebuild is just a CHKDATA-like hack for check at startup
*)

PROCEDURE procLog (useLFN,lowercase,usepath,audiowarn,
                  special,bargraf,redir,killprev,performFsizeChk:BOOLEAN;
                  cmd,forcedmethod:cmdtype;logfile:ARRAY OF CHAR;
                  VAR einfo:ARRAY OF CHAR ):CARDINAL;

VAR
    R,sval,ssize,message,msg,msgDone:str128;
    udne,u,d,n,e,f8e3 : pathtype;
    hin,hout:FIO.File;
    S,S2,orgS : str1024; (* better safe than sorry *)
    i : CARDINAL;
    mismatches,missing,fsize0,v0,fsize,v:LONGCARD;
    readstate : (gotnada,gotmethod,gotdashes,aborted);
    EOFstate, pb, ok, fsizemismatch:BOOLEAN;
    chksum,cszero:CARDINAL;
    canonical : pathtype;
    errcode:CARDINAL;
    MD5digest:MD5digestType;
    MD5digeststr:MD5str;
    SHAdigest:SHAdigestType;
    SHAdigeststr:SHAstr;
    tabsep,recreate,pollEsc:BOOLEAN;
    baklogfile,tmplogfile,logfilesmall:str128; (* should do for good old DOS pathname *)
    wi:CARDINAL;
    separ : str16;
BEGIN
    (* v1.3n IF useLFN THEN usepath:=TRUE; END; (* we cannot get F8E3 from a partial LFN *) *)

    recreate := (cmd=rebuild);
    special  := NOT(bargraf);

    Lib.SplitAllPath(logfile,u,d,n,e);
    Lib.MakeAllPath(logfilesmall,"","",n,e); (* not used anyway ! *)
    IF recreate THEN
        msg:=msgRebuilding;
        msgDone:=msgEverythingWentFine;
        pollEsc := FALSE;                (* safety for log integrity *)

        Lib.MakeAllPath(baklogfile,u,d,n,extBAK);
        Lib.MakeAllPath(tmplogfile,u,d,tmprebuild,extTMP);

        IF isReadOnly(baklogfile) THEN setReadWrite(baklogfile);END; (* who knows etc. *)

        hout:=FIO.Create(baklogfile);
        FIO.AssignBuffer(hout,ioNew ); (* safe : see usage supra *)
    ELSE
        msg:=msgChecking;
        msgDone:=msgEverythingGoes;
        pollEsc := (redir = FALSE);
    END;

    hin:=FIO.OpenRead(logfile);
    FIO.AssignBuffer(hin,ioInBuffer);

    pb:=FALSE; (* format problem *)
    mismatches:=0;
    missing   :=0;
    IF forcedmethod = undefined THEN
        readstate:=gotnada;   (* we need to check header *)
    ELSE
        cmd:=forcedmethod;
        readstate:=gotdashes; (* assume no header, cannot happen with rebuild *)
    END;

    Flushkey;

    IF special THEN video(msg,TRUE); END;
    doEyecandy(bargraf,CANDYinit, FIO.Size(hin) );
    LOOP
        doEyecandy(bargraf,CANDYshow, FIO.GetPos(hin) );
        FIO.RdStr(hin,orgS);
        IF FIO.EOF THEN EXIT; END;
        Str.Copy(S,orgS);
        LtrimBlanks(S);RtrimBlanks(S);
        CASE S[0] OF
        | nullchar:
            IF recreate THEN FIO.WrLn(hout);END;
        | REMCHAR:
            IF recreate THEN FIO.WrStr(hout,orgS);FIO.WrLn(hout);END;
        ELSE
            CASE readstate OF
            | gotnada:
                casify(lowercase,S);
                i:=firstmethod;
                LOOP
                    CASE i OF
                    | 1: cmd:=crc;      R:=sCRC;
                    | 2: cmd:=adler;    R:=sADLER;
                    | 3: cmd:=fletcher; R:=sFLETCHER;
                    | 4: cmd:=unsafe;   R:=sUNSAFE;
                    | 5: cmd:=md5;      R:=sMD5;
                    | 6: cmd:=sha;      R:=sSHA;
                    | 7: cmd:=subdirs;  R:=sSUBDIRS;
                    END;
                    ReplaceChar(R,blank,"");
                    LtrimBlanks(R); (* should be useless ! *)
                    RtrimBlanks(R);
                    casify(lowercase,R);
                    IF Str.Pos(S,R) # MAX(CARDINAL) THEN EXIT; END;
                    INC(i);
                    IF i > lastmethod THEN cmd:=undefined;EXIT; END;
                END;
                (*%F ADLERFLETCHER *)
                CASE cmd OF
                | adler,fletcher : cmd:=undefined; (* unsupported *)
                END;
                (*%E *)
                IF cmd # undefined THEN
                    INC(readstate);
                    IF recreate THEN FIO.WrStr(hout,orgS);FIO.WrLn(hout);END;
                END;
                IF cmd = subdirs THEN usepath := TRUE; END; (* the once and future safety : ignore -p *)
            | gotmethod:
                R:=sHeader2; (* will do whatever the method *)
                i:=Str.CharPos(R,blank);
                R[i]:=nullchar;
                IF Str.Pos(S,R) # MAX(CARDINAL) THEN
                    INC(readstate);
                    IF recreate THEN FIO.WrStr(hout,orgS);FIO.WrLn(hout);END;
                END;
            | gotdashes:
                tabsep:= ( Str.CharPos(S,tab) # MAX(CARDINAL) );
                IF tabsep THEN
                    separ:=tab;
                ELSE
                    separ:=bl2;
                END;

                Str.ItemS(sval,  S, seps, 0);
                Str.ItemS(ssize, S, seps, 1);

                (* Str.ItemS(udne,  S, seps, 2); fix for inner blanks *)
                Str.Copy(S2,S);
                Str.Subst(S2,sval,"");Str.Subst(S2,ssize,"");
                LtrimBlanks(S2);RtrimBlanks(S2);
                Str.Copy(udne,S2); (* this is original trailing path *)

                CASE cmd OF
                | md5:
                    IF chkAnyDigestString(sval,cmd)=FALSE THEN pb:=TRUE; EXIT; END;
                | sha:
                    IF chkAnyDigestString(sval,cmd)=FALSE THEN pb:=TRUE; EXIT; END;
                ELSE
                    IF s2lc(v0    ,16,sval )=FALSE THEN pb:=TRUE;  EXIT; END;
                END;
                IF s2lc(fsize0,10,ssize)=FALSE THEN pb:=TRUE;  EXIT; END;

                Str.Copy(canonical, udne);
                IF useLFN THEN
                    (*
                    v1.3o fix : if we don't use original path,
                    we must find DOS path using filename alone here
                    *)
                    IF NOT (usepath) THEN
                        Lib.SplitAllPath(canonical,u,d,n,e);
                        Lib.MakeAllPath(canonical,"","",n,e);
                    END;
                    ok:=w9XlongToShort (canonical, errcode,udne);
                ELSE
                    ok:=TRUE;
                END;
                Str.Copy(S,udne);
                casify(lowercase,S);

                IF usepath THEN
                    Lib.SplitAllPath(S,u,d,n,e);
                    Lib.MakeAllPath(f8e3,"","",n,e);
                ELSE
                    Lib.SplitAllPath(S,u,d,n,e);
                    Lib.MakeAllPath(S,"","",n,e); (* we'll check S as filename alone *)
                    Str.Copy(f8e3,S);
                END;

                IF cmd = subdirs THEN
                    unfixDirectory(S); (* yes, we could test "u:\*\." but... *)
                ELSE
                    IF needTrailingDot(f8e3) THEN (* JPI does not keep trailing dot *)
                        Str.Append(S,dot);
                        Str.Append(f8e3,dot);
                    END;
                END;
                IF recreate THEN (* rebuild log *)
                    IF ok THEN ok:=FIO.Exists(S); END;
                    IF ok THEN
                        message:=""; (* fake ok for everything *)
                        IF cmd = subdirs THEN
                            fsize := 0;
                        ELSE
                            fsize := getFileSize(S);
                        END;
                        EOFstate:=FIO.EOF; (* very important ! *)
                        CASE cmd OF
                        | crc      : wi:=8; v:=ComputeCRC32(S);
                        | adler    : wi:=8;
                                            (*%T ADLERFLETCHER *)
                                            v:=ComputeAdler32(S);
                                            (*%E *)
                                            (*%F ADLERFLETCHER *)
                                            v:=0;
                                            (*%E *)
                        | fletcher : wi:=4;
                                            (*%T ADLERFLETCHER *)
                                            ComputeFletcherCheckSum(S,chksum,cszero);v:=LONGCARD(chksum);
                                            (*%E *)
                                            (*%F ADLERFLETCHER *)
                                            v:=0;
                                            (*%E *)
                        | unsafe   : wi:=4; v:=0;
                        | md5      : wi:=2; ComputeMD5(MD5digest,S);
                        | sha      : wi:=2; ComputeSHA(SHAdigest,S);
                        | subdirs  : wi:=4; v:=0; (* see computeLog *)
                        END;
                        FIO.EOF:=EOFstate; (* very important ! *)
                        CASE cmd OF
                        | crc,adler       : Str.Copy(S,valToStr(16,wi,dollar,"0",v));
                        | fletcher,unsafe : Str.Concat(S,valToStr(16,wi,dollar,"0",v),bl4);
                        | md5             : MD5toString(MD5digeststr, MD5digest);
                                            Str.Concat(S,dollar,MD5digeststr);
                        | sha             : SHAtoString(SHAdigeststr, SHAdigest);
                                            Str.Concat(S,dollar,SHAdigeststr);
                        | subdirs         : Str.Concat(S,valToStr(16,wi,dollar,"0",v),bl4);
                        END;
                        Str.Append(S,separ);Str.Append(S,valToStr(10,wifsize,""," ",fsize));
                        Str.Append(S,separ);Str.Append(S,canonical); (* rewrite original entry path *)
                    ELSE
                        message := msgMissing; INC(missing); (* tell user about problem *)
                        Str.Copy(S,orgS); (* not found : rewrite original *)
                    END;
                    FIO.WrStr(hout,S);FIO.WrLn(hout);

                ELSE (* verify log *)

                    IF ok THEN ok:=FIO.Exists(S); END;
                    IF ok THEN
                        message:="";
                        IF cmd = subdirs THEN
                            fsize := 0;
                            fsize0:= 0; (* safety : anyway, this should be so ! *)
                        ELSE
                            fsize := getFileSize(S);
                        END;
                        EOFstate:=FIO.EOF; (* very important ! *)

                        (* if fsize changed, useless to check anything else *)
                        CASE cmd OF
                        | md5,sha:
                            IF performFsizeChk THEN
                                fsizemismatch := ( fsize # fsize0 );
                            ELSE
                                fsizemismatch := FALSE; (* ignore fsize here, and force file verify *)
                            END;
                        ELSE
                            fsizemismatch := ( fsize # fsize0 );
                        END;
                        IF fsizemismatch THEN
                            message:=msgSizePb;
                        ELSE
                            EOFstate:=FIO.EOF; (* very important ! *)
                            CASE cmd OF
                            | crc      : v:=ComputeCRC32(S);
                                         IF v # v0 THEN message:=msgCpb;END;
                            | adler    :
                                         (*%T ADLERFLETCHER *)
                                         v:=ComputeAdler32(S);
                                         (*%E *)
                                         (*%F ADLERFLETCHER *)
                                         v:=v0;
                                         (*%E *)
                                         IF v # v0 THEN message:=msgApb;END;
                            | fletcher :
                                         (*%T ADLERFLETCHER *)
                                         ComputeFletcherCheckSum(S,chksum,cszero);v:=LONGCARD(chksum);
                                         (*%E *)
                                         (*%F ADLERFLETCHER *)
                                         v:=v0;
                                         (*%E *)
                                         IF v # v0 THEN message:=msgFpb;END;
                            | unsafe   : ; (* size already checked *)
                            | md5      : ComputeMD5(MD5digest,S);
                                         MD5toString(MD5digeststr, MD5digest);
                                         IF same(MD5digeststr,sval)=FALSE THEN (* both lowercased and without "$" *)
                                              message:=msgMpb;
                                         END;
                            | sha      : ComputeSHA(SHAdigest,S);
                                         SHAtoString(SHAdigeststr, SHAdigest);
                                         IF same(SHAdigeststr,sval)=FALSE THEN (* both lowercased and without "$" *)
                                             message:=msgSpb;
                                         END;
                            | subdirs  : ; (* do nothing *)
                            END;
                            FIO.EOF:=EOFstate;
                        END;
                        IF same(message,"")=FALSE THEN INC(mismatches);END;
                    ELSE
                        message:=msgMissing; INC(missing);
                        IF cmd = subdirs THEN fixDirectory(S);END;
                    END;
                END;

                IF same(message,"")=FALSE THEN
                    doEyecandy(bargraf,CANDYsave,0);
                    IF special THEN video(msg,FALSE); END;
                    WrStr(message);
                    IF NOT(usepath) THEN (* verifying ignoring path *)
                        WrStr("(");  WrStr(f8e3);  WrStr(") ");
                    END;
                    WrStr(canonical); WrLn;
                    IF special THEN video(msg,TRUE); END;
                    doEyecandy(bargraf,CANDYrestore, 0);
                END;
            END;
        END;
        IF FIO.EOF THEN EXIT;END;
        IF pollEsc THEN
            IF ChkEscape() THEN readstate:=aborted;EXIT;END;
        END;
    END;
    FIO.Close(hin);
    IF recreate THEN
        FIO.Close(hout);

        IF isReadOnly(tmplogfile) THEN setReadWrite(tmplogfile);END; (* who knows etc. *)
        IF FIO.Exists(tmplogfile) THEN FIO.Erase(tmplogfile);END;

        IF isReadOnly(logfile) THEN setReadWrite(logfile);END; (* who knows etc. *)

        (* use full paths here *)
        FIO.Rename(logfile,tmplogfile);
        FIO.Rename(baklogfile,logfile);
        IF killprev THEN
            FIO.Erase(tmplogfile);
        ELSE
            FIO.Rename(tmplogfile,baklogfile);
        END;
    END;
    doEyecandy(bargraf,CANDYdone,0);
    IF special THEN video(msg,FALSE); END;

    Str.Copy(einfo,""); (* who knows etc. *)
    CASE readstate OF
    | gotnada,gotmethod :
        i:=errBadFormat; Str.Copy(einfo,logfile);
    | aborted :
        i:=errAbortedByUser;
    | gotdashes :
        IF pb THEN
            i:=errBadLine;Str.Copy(einfo,S);
        ELSE
            IF recreate THEN
                IF missing = 0 THEN
                    i:=errNone;
                    WrStr(msgDone);WrLn;
                ELSE
                    i:=errMissingEntries;
                    warnUser(TRUE, audiowarn, missing,0);
                END;
            ELSE
                IF mismatches=0 THEN
                    IF missing = 0 THEN
                        i:=errNone;
                        WrStr(msgDone);WrLn;
                    ELSE
                        i:=errMissingEntries;
                        warnUser(TRUE, audiowarn, missing,0);
                    END;
                ELSE
                    i:=errDifferences;
                    IF missing = 0 THEN
                        warnUser(TRUE, audiowarn, 0,mismatches);
                    ELSE
                        warnUser(TRUE, audiowarn, 0,mismatches);
                        warnUser(FALSE,FALSE    , missing,0);
                    END;
                END;
            END;
        END;
    END;
    RETURN i;
END procLog;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str80;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str80;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

PROCEDURE fmtDate (d,m,y:SHORTCARD) : str80;
CONST
    dash = "-";
    separator = dash;
    pad="0";
    baseyear = 1900;
    tmonths ="Jan Fv Mar Avr Mai Jun Jui Ao Sep Oct Nov Dc ???";
    tmonths2="Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ???";
VAR
    R : str80;
BEGIN
    IF ((m < 1) OR (m > 12)) THEN m := 13; END;
    Str.ItemS(R,tmonths2," ",CARDINAL(m)-1);
    Str.Prepend(R,separator);
    Str.Prepend(R,using(CARDINAL(d),2,pad));
    Str.Append(R,separator);
    Str.Append(R,using(baseyear+CARDINAL(y),4,pad));
    RETURN R;
END fmtDate;

PROCEDURE fmtTime (h,m,s:SHORTCARD) : str80;
CONST
    separator = colon;
    pad="0";
VAR
    R : str80;
BEGIN
    R := using(CARDINAL(h),2,pad);
    Str.Append(R,separator);
    Str.Append(R,using(CARDINAL(m),2,pad));
    Str.Append(R,separator);
    Str.Append(R,using(CARDINAL(s),2,pad));
    RETURN R;
END fmtTime;

PROCEDURE dtf (S, sep: ARRAY OF CHAR) : str256;
VAR
    hnd      : FIO.File;
    stamp    : FIO.FileStamp;
    ok       : BOOLEAN;
    R        : str256;
BEGIN
    hnd:=FIO.OpenRead(S);
    ok:=FIO.GetFileStamp(hnd,stamp);
    FIO.Close(hnd);
    Str.Copy  (R, fmtDate(stamp.Day,stamp.Month,stamp.Year) );
    Str.Append(R,", ");
    Str.Append(R,fmtTime(stamp.Hour,stamp.Min,stamp.Sec));
    Str.Append(R,sep);
    Str.Append(R,S);
    RETURN R;
END dtf;

PROCEDURE fmtVal (v:CARDINAL) : str16;
VAR
    S : str16;
    ok:BOOLEAN;
BEGIN
    Str.CardToStr(LONGCARD(v),S,10,ok);
    RETURN S;
END fmtVal;

TYPE
    chronoType = RECORD
        Year,Month,Day : CARDINAL;
        DayOfWeek      : Lib.DayType;
        H,M,S,ss       : CARDINAL; (* ss = (worthless) hundredths of second *)
    END;

VAR (* kolossal kludge *)
    globalchronostart : chronoType;
    globalchronostop  : chronoType;

PROCEDURE fmtDateTimeUS (VAR chrono:chronoType):str80;
TYPE
    tDays   = ARRAY [1..7] OF str16;
    tMonths = ARRAY [1..12] OF str16;
CONST
    strFmtDT    = "~, ~ ~ ~ at ~h ~mn ~s";
    placeholder = "~";
CONST
    tJours = tDays("Sunday","Monday","Tuesday","Wednesday",
                   "Thursday","Friday","Saturday"
                  );
    tMois = tMonths("January","February","March","April",
                    "May","June","July","August",
                    "September","October","November","December"
                   );
VAR
    R : str80;
BEGIN
    (* yes, we know it's not very american a date/time format... so what ? *)
WITH chrono DO
    Lib.GetDate (Year,Month,Day,DayOfWeek);
    Lib.GetTime (H,M,S,ss);

    R:=strFmtDT;
    Str.Subst(R,placeholder,tJours[ORD(DayOfWeek)+1]);
    Str.Subst(R,placeholder,fmtVal(Day));
    Str.Subst(R,placeholder,tMois[Month]);
    Str.Subst(R,placeholder,fmtVal(Year));
    Str.Subst(R,placeholder,fmtVal(H));
    Str.Subst(R,placeholder,fmtVal(M));
    Str.Subst(R,placeholder,fmtVal(S));
END;
    RETURN R;
END fmtDateTimeUS;

(*
    gregorian calendar rule : leap 366 years if divisible by 4
    but centurial years NOT divisible by 4 are common
    Leap years are divisible by 400, or by 4 and not by 100
    1900 is common, 2000 is leap
*)

PROCEDURE getDaysInFebruary (annee:CARDINAL):CARDINAL;
CONST
    common = 28;
    leap   = 29;
BEGIN
    IF (annee MOD 400) = 0 THEN RETURN leap; END;
    IF (((annee MOD 4) = 0) AND ((annee MOD 100) # 0)) THEN RETURN leap; END;
    RETURN common;
END getDaysInFebruary;

(* assume month and year are correct *)

PROCEDURE getDaysInMonth (mois,annee:CARDINAL):CARDINAL;
TYPE
    daysinmonthtype = ARRAY [1..12] OF CARDINAL;
CONST
    (*                    JanFevMarAprMayJunJulAugSepOctNovDec *)
    (*                     1  2  3  4  5  6  7  8  9 10 11 12  *)
    dpm = daysinmonthtype(31, 0,31,30,31,30,31,31,30,31,30,31);
VAR
    m : CARDINAL;
BEGIN
    m:= dpm[mois];
    IF m=0 THEN m:=getDaysInFebruary(annee);END;
    RETURN m;
END getDaysInMonth;

(* jan 1 = 1, etc. *)

PROCEDURE getCountOfDays (jour,mois,annee:CARDINAL):CARDINAL;
VAR
    n,i : CARDINAL;
BEGIN
    n:=jour;
    FOR i:= 1 TO (mois-1) DO
        INC(n, getDaysInMonth(mois,annee) );
    END;
    RETURN n;
END getCountOfDays;

(* out of lazyness, reasonably assume process won't take more than 24 hours ! *)

PROCEDURE fmtDeltaDT (started,ended:chronoType):str80;
CONST
    strFmtTime  = "~h ~mn ~s";
    placeholder = "~";
CONST
    minutesPerHour   = 60;
    secondsPerMinute = 60;
    hundred          = 100;
    midnight         = 24*minutesPerHour*secondsPerMinute*hundred;
    baseyear         = 1980; (* historic ! *)
VAR
    R : str80;
    n,hmsStart,hmsEnd,jmaStart,jmaEnd : LONGCARD; (* in hundredths of seconds *)
    delta : chronoType;
    i,v:CARDINAL;
BEGIN
    n := LONGCARD(started.H) * minutesPerHour + LONGCARD(started.M);
    n := n * secondsPerMinute + LONGCARD(started.S);
    n := n * hundred + LONGCARD(started.ss);
    hmsStart := n;

    n := LONGCARD(ended.H)   * minutesPerHour + LONGCARD(ended.M);
    n := n * secondsPerMinute + LONGCARD(ended.S);
    n := n * hundred + LONGCARD(ended.ss);
    hmsEnd := n;

    n:=LONGCARD ( getCountOfDays(started.Day,started.Month,started.Year) );
    v:=started.Year-1;
    FOR i:= baseyear TO v DO
         INC (n, LONGCARD ( getCountOfDays(31,12,i) ) );
    END;
    jmaStart:=n;

    n:=LONGCARD ( getCountOfDays(ended.Day,ended.Month,ended.Year) );
    v:=ended.Year-1;
    FOR i:= baseyear TO v DO
         INC (n, LONGCARD ( getCountOfDays(31,12,i) ) );
    END;
    jmaEnd:=n;

    IF jmaEnd # jmaStart THEN (* assume no more than one day ! *)
        hmsEnd := hmsEnd + midnight;
    END;
    n := hmsEnd-hmsStart; (* always >= 0 *)
    delta.H   :=CARDINAL (n DIV (minutesPerHour*secondsPerMinute*hundred) );
    delta.M   :=CARDINAL((n DIV (               secondsPerMinute*hundred) ) MOD 60 );
    delta.S   :=CARDINAL((n DIV (                                hundred) ) MOD 60 );
    delta.ss  :=CARDINAL (n MOD hundred);

    R:=strFmtTime;
    Str.Subst(R,placeholder, fmtVal(delta.H));
    Str.Subst(R,placeholder, fmtVal(delta.M));
    Str.Subst(R,placeholder, fmtVal(delta.S));

    RETURN R;
END fmtDeltaDT;

(* ------------------------------------------------------------ *)

PROCEDURE getTMPdir (default:ARRAY OF CHAR; VAR tmpdir:ARRAY OF CHAR);
VAR
    i:CARDINAL;
    D:str128;
BEGIN
    i:=1;
    LOOP
        CASE i OF
        | 1: D:=sTMP;
        | 2: D:=sTEMP;
        | 3: D:=sTMPDIR;
        | 4: D:=sTEMPDIR;
        END;
        Lib.EnvironmentFind(D,tmpdir);
        IF same(tmpdir,"")=FALSE THEN EXIT; END;
        INC(i);
        IF i > 4 THEN Str.Copy(tmpdir,default); EXIT; END; (* tmpdir will be empty *)
    END;
    UpperCaseAlt(tmpdir); (* probably useless *)
    fixDirectory(tmpdir);
END getTMPdir;

(* ------------------------------------------------------------ *)

(* ugly but this way, we'll stay under the 64 Kb limit *)

CONST
    MAXHASH       = MAX(CARDINAL)-1;
    firstndx      = 1;
    maxndx        = 10000; (* was 16383, but should do anyway *)
    (* maxdsklastndx = MAX(CARDINAL)-1; (* yes, we know, 65535-1 may be too small *) *)
    oldndx        = 1;
    newndx        = 2;
TYPE
    cardArrayType      = ARRAY [firstndx..maxndx] OF CARDINAL;
    longcardArrayType  = ARRAY [firstndx..maxndx] OF LONGCARD;
    ptrToCardArray     = POINTER TO cardArrayType;
    ptrToLongCardArray = POINTER TO longcardArrayType;
VAR
    hashIDold              : ptrToCardArray;
    hashIDnew              : ptrToCardArray;
    fposold,flenold,CRCold : ptrToLongCardArray;
    fposnew,flennew,CRCnew : ptrToLongCardArray;

TYPE
    hackdigestype = RECORD
        CASE : BOOLEAN OF
        | TRUE : md5dig : MD5digestType; (* required for MD5 / SHA *)
        | FALSE: shadig : SHAdigestType; (* required for SHA *)
        END;
    END;
    fileentrytype = RECORD
        hashID : CARDINAL;
        fpos   : LONGCARD;
        flen   : LONGCARD;
        CRC    : LONGCARD;
        digest : hackdigestype;
    END;

PROCEDURE doIndex (VAR overflowed:BOOLEAN;
                  VAR cmd:cmdtype; VAR lastndx:CARDINAL;
                  VAR dsklastndx:LONGCARD; VAR dskhnd:FIO.File;
                  VAR dsk:ARRAY OF CHAR;
                  forcedmethod:cmdtype;
                  usedisk:BOOLEAN; which:CARDINAL; logfile,tmpdir:ARRAY OF CHAR):BOOLEAN;
VAR
    hin:FIO.File;
    S,S2:str1024; (* better safe than sorry *)
    R,sval,ssize,msg:str128;
    udne:pathtype;
    here,v0,fsize0:LONGCARD;
    readstate : (gotnada,gotmethod,gotdashes);
    i,hash : CARDINAL;
    pb:BOOLEAN;
    fileentry:fileentrytype;
BEGIN
    Str.Concat(msg,msgIndexing,logfile);
    hin:=FIO.OpenRead(logfile);
    FIO.AssignBuffer(hin,ioInBuffer);

    IF usedisk THEN
        CASE which OF
        | oldndx: S:=tmpold;
        | newndx: S:=tmpnew;
        END;
        Str.Prepend(S,tmpdir);
        dskhnd:=FIO.Create(S);
        Str.Copy(dsk,S);
        CASE which OF
        | oldndx : FIO.AssignBuffer(dskhnd,ioDskOld);
        | newndx : FIO.AssignBuffer(dskhnd,ioDskNew);
        END;
        dsklastndx:=firstndx-1;
    ELSE
        lastndx:=firstndx-1;
    END;

    pb:=FALSE;
    overflowed:=FALSE;

    IF forcedmethod = undefined THEN
        readstate:=gotnada;   (* we need to check header *)
    ELSE
        cmd:=forcedmethod;
        readstate:=gotdashes; (* assume no header, cannot happen with rebuild *)
    END;

    video(msg,TRUE);
    LOOP
        here:=FIO.GetPos(hin);
        FIO.RdStr(hin,S);
        IF FIO.EOF THEN EXIT; END;
        LtrimBlanks(S);RtrimBlanks(S);
        CASE S[0] OF
        | nullchar,REMCHAR :
            ;
        ELSE
            CASE readstate OF
            | gotnada:
                casify(TRUE ,S);
                i:=firstmethod;
                LOOP
                    CASE i OF
                    | 1: cmd:=crc;      R:=sCRC;
                    | 2: cmd:=adler;    R:=sADLER;
                    | 3: cmd:=fletcher; R:=sFLETCHER;
                    | 4: cmd:=unsafe;   R:=sUNSAFE;
                    | 5: cmd:=md5;      R:=sMD5;
                    | 6: cmd:=sha;      R:=sSHA;
                    | 7: cmd:=subdirs;  R:=sSUBDIRS;
                    END;
                    ReplaceChar(R,blank,"");
                    LtrimBlanks(R); (* should be useless ! *)
                    RtrimBlanks(R);
                    casify(TRUE,R);
                    IF Str.Pos(S,R) # MAX(CARDINAL) THEN EXIT; END;
                    INC(i);
                    IF i > lastmethod THEN cmd:=undefined;EXIT; END;
                END;
                (*%F ADLERFLETCHER *)
                CASE cmd OF
                | adler,fletcher : cmd:=undefined; (* unsupported *)
                END;
                (*%E *)
                IF cmd # undefined THEN INC(readstate); END;
            | gotmethod:
                R:=sHeader2; (* will do whatever the method *)
                i:=Str.CharPos(R,blank);
                R[i]:=nullchar;
                IF Str.Pos(S,R) # MAX(CARDINAL) THEN INC(readstate);END;
            | gotdashes:
                Str.ItemS(sval,  S, seps, 0);
                Str.ItemS(ssize, S, seps, 1);

                (* Str.ItemS(udne,  S, seps, 2); *)
                Str.Copy(S2,S);
                Str.Subst(S2,sval,"");Str.Subst(S2,ssize,"");
                LtrimBlanks(S2);RtrimBlanks(S2);
                Str.Copy(udne,S2);

                CASE cmd OF
                | md5:
                    IF chkAnyDigestString(sval,cmd)=FALSE THEN pb:=TRUE; EXIT; END;
                | sha:
                    IF chkAnyDigestString(sval,cmd)=FALSE THEN pb:=TRUE; EXIT; END;
                ELSE
                    IF s2lc(v0    ,16,sval )=FALSE THEN pb:=TRUE;  EXIT; END;
                END;
                IF s2lc(fsize0,10,ssize)=FALSE THEN pb:=TRUE;  EXIT; END;

                (*
                i:=Str.CharPos(udne,colon);
                IF i # MAX(CARDINAL) THEN Str.Delete(udne,0,i+1);END; (* remove u: *)
                *)
                IF cmd # subdirs THEN
                    IF needTrailingDot(udne) THEN (* JPI does not keep trailing dot *)
                        Str.Append(udne,dot);
                    END;
                END;
                casify(TRUE,udne);
                hash:=Lib.HashString(udne,MAXHASH); (* hash same case *)

                IF usedisk THEN
                    INC(dsklastndx);
                    (* IF dsklastndx > maxdsklastndx THEN overflowed:=TRUE; EXIT;END; *)
                    fileentry.hashID := hash;
                    fileentry.fpos   := here;
                    fileentry.flen   := fsize0;
                    fileentry.CRC    := v0;
                    fileentry.digest.md5dig := stringToMD5( MD5str(sval) );
                    fileentry.digest.shadig := stringToSHA( SHAstr(sval) );
                    FIO.WrBin(dskhnd, fileentry, SIZE(fileentry));
                ELSE
                    INC(lastndx);
                    IF lastndx > maxndx THEN overflowed:=TRUE; EXIT; END;
                    CASE which OF
                    | oldndx:
                        hashIDold^ [lastndx]:=hash;
                        fposold^   [lastndx]:=here;
                        flenold^   [lastndx]:=fsize0;
                        CRCold^    [lastndx]:=v0;
                    | newndx:
                        hashIDnew^ [lastndx]:=hash;
                        fposnew^   [lastndx]:=here;
                        flennew^   [lastndx]:=fsize0;
                        CRCnew^    [lastndx]:=v0;
                    END;
                END;
            END;
        END;
        IF FIO.EOF THEN EXIT;END;
    END;
    FIO.Close(hin);

    video(msg,FALSE);
    IF pb THEN RETURN FALSE; END;
    IF readstate # gotdashes THEN RETURN FALSE; END;
    IF cmd = undefined THEN RETURN FALSE; END;
    IF overflowed THEN RETURN FALSE; END;
    RETURN TRUE;
END doIndex;

(* assume S in legal form and udne not empty ! *)

PROCEDURE getStrDisk (lowercase:BOOLEAN;fpos:LONGCARD;hnd:FIO.File;
                     VAR udne:pathtype);
VAR
    S:str1024; (* better safe than sorry *)
    len:CARDINAL;
    sval,ssize:str128;
BEGIN
    FIO.Seek(hnd,fpos);
    FIO.RdStr(hnd,S);

    (* Str.ItemS(udne,  S, seps, 2); *)
    Str.ItemS(sval ,  S, seps, 0);
    Str.ItemS(ssize,  S, seps, 1);
    Str.Subst(S,sval,"");Str.Subst(S,ssize,"");
    LtrimBlanks(S);RtrimBlanks(S);
    Str.Copy(udne,S);

    len:=Str.Length(udne);
    IF len > 0 THEN
        IF udne[len-1] # backslash THEN (* no trailing "\", this is not a directory but a file *)
            IF needTrailingDot(udne) THEN (* JPI does not keep trailing dot *)
                Str.Append(udne,dot); (* everywhere ! *)
            END;
        END;
    END;
    casify(lowercase,udne); (* required ! *)
END getStrDisk;

PROCEDURE doSection (S:ARRAY OF CHAR);
BEGIN
    WrStr(dashline);WrLn;
    WrStr(S);WrLn;
    WrStr(dashline);WrLn;
    WrLn;
END doSection;

PROCEDURE doSectionHeader (cmd:cmdtype;older,newer:ARRAY OF CHAR);
VAR
    R:str128;
    S:str2048; (* oversized for safety *)
BEGIN
    CASE cmd OF
    | crc:       R:=sCRC;
    | md5:       R:=sMD5;
    | sha:       R:=sSHA;
    | adler:     R:=sADLER;
    | fletcher:  R:=sFLETCHER;
    | unsafe:    R:=sUNSAFE;
    | subdirs:   R:=sSUBDIRS;
    END;
    Str.Concat(S,REMCHAR,nl);
    Str.Append(S,REMCHAR+blank+Banner+nl);
    Str.Append(S,REMCHAR+nl);

  IF cmd # subdirs THEN
    Str.Append(S,dashStarted);Str.Append(S,fmtDateTimeUS(globalchronostart));Str.Append(S,nl);
    Str.Append(S,REMCHAR+nl);
  END;

    Str.Append(S,dasholder); Str.Append(S,dtf(older,dashsep)); Str.Append(S,nl);
    Str.Append(S,dashnewer); Str.Append(S,dtf(newer,dashsep)); Str.Append(S,nl);
    Str.Append(S,REMCHAR+nl);
    Str.Append(S,dashmethod);Str.Append(S,R); Str.Append(S,nl);
    Str.Append(S,REMCHAR+nl);
    IF cmd # subdirs THEN
        Str.Append(S,dashinfo1+nl);
        Str.Append(S,dashinfo2+nl);
        Str.Append(S,REMCHAR+nl);
    END;
    WrStr(S);WrLn;
END doSectionHeader;

PROCEDURE doSectionTrailer (cmd:cmdtype;ndeleted,nadded,nmodified:LONGCARD);
BEGIN
    doSection(dashSummary);
    WrStr(msgDeleted); WrStr( valToStr(10,6,""," ",ndeleted));WrLn;
    WrStr(msgAdded);   WrStr( valToStr(10,6,""," ",nadded  ));WrLn;
    IF cmd # subdirs THEN
        WrStr(msgChanged); WrStr( valToStr(10,6,""," ",nmodified));WrLn;
    END;
    WrLn;
END doSectionTrailer;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* created from doIndex() *)

PROCEDURE getLogMethod (VAR cmd:cmdtype;
                       maxscannedlines:CARDINAL; logfile:ARRAY OF CHAR):BOOLEAN;
VAR
    hin:FIO.File;
    R,msg:str128;
    i,currline:CARDINAL;
    S:str1024; (* better safe than sorry *)
BEGIN
    Str.Concat(msg,msgScanningMethod,logfile);
    hin:=FIO.OpenRead(logfile);
    FIO.AssignBuffer(hin,ioInBuffer);

    currline:=0;
    cmd:=undefined;
    video(msg,TRUE);
    LOOP
        FIO.RdStr(hin,S);
        IF FIO.EOF THEN EXIT; END;
        LtrimBlanks(S);RtrimBlanks(S);
        CASE S[0] OF
        | nullchar,REMCHAR :
            ;
        ELSE
            INC(currline);
            IF currline > maxscannedlines THEN EXIT; END;
                casify(TRUE ,S);
                i:=firstmethod;
                LOOP
                    CASE i OF
                    | 1: cmd:=crc;      R:=sCRC;
                    | 2: cmd:=adler;    R:=sADLER;
                    | 3: cmd:=fletcher; R:=sFLETCHER;
                    | 4: cmd:=unsafe;   R:=sUNSAFE;
                    | 5: cmd:=md5;      R:=sMD5;
                    | 6: cmd:=sha;      R:=sSHA;
                    | 7: cmd:=subdirs;  R:=sSUBDIRS;
                    END;
                    ReplaceChar(R,blank,"");
                    LtrimBlanks(R); (* should be useless ! *)
                    RtrimBlanks(R);
                    casify(TRUE,R);
                    IF Str.Pos(S,R) # MAX(CARDINAL) THEN EXIT; END;
                    INC(i);
                    IF i > lastmethod THEN cmd:=undefined;EXIT; END;
                END;
                (*%F ADLERFLETCHER *)
                CASE cmd OF
                | adler,fletcher : cmd:=undefined; (* unsupported *)
                END;
                (*%E *)
                IF cmd # undefined THEN EXIT;END;

        END;
        IF FIO.EOF THEN EXIT;END;
    END;
    FIO.Close(hin);
    video(msg,FALSE);

    RETURN (cmd # undefined);
END getLogMethod;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE listDeleted  (VAR ndeleted:LONGCARD;
                       lowercase,special,bargraf,usedisk:BOOLEAN;
                       lastold,lastnew:CARDINAL;dsklastold,dsklastnew:LONGCARD;
                       hndold,hndnew,dskhndold,dskhndnew:FIO.File;
                       sDeleted:ARRAY OF CHAR);
VAR
    msg:str128;
    ii,jj:LONGCARD;
    got:CARDINAL;
    fileentry:fileentrytype;
    hashold,hashnew:CARDINAL;
    hereold,herenew:LONGCARD;
    i,j:CARDINAL;
    sOLD,sNEW : pathtype;
    found: BOOLEAN;
BEGIN

    (* deleted files : found in old, not found in new *)

    doSection(dashDeleted);

    Str.Copy(msg,searchingDeleted);
    IF special THEN video(msg,TRUE); END;
    doEyecandy(bargraf,CANDYinit, dsklastold  );
    ii:=firstndx-1;
    IF usedisk THEN
        FIO.Seek(dskhndold,0);
    ELSE
        dsklastold:=LONGCARD(lastold);
    END;
    LOOP
        INC(ii);
        IF ii > dsklastold THEN EXIT; END;
        doEyecandy(bargraf,CANDYshow, ii );
        IF usedisk THEN
            got:=FIO.RdBin(dskhndold,fileentry,SIZE(fileentry));
            hashold  :=fileentry.hashID;
            hereold  :=fileentry.fpos;
        ELSE
            i:=CARDINAL(ii);
            hashold  :=hashIDold^[i];
            hereold  :=fposold^[i];
        END;
        getStrDisk(lowercase,hereold,hndold,sOLD);

        found:=FALSE;
        jj:=firstndx-1;
        IF usedisk THEN
            FIO.Seek(dskhndnew,0);
        ELSE
            dsklastnew:=LONGCARD(lastnew);
        END;
        LOOP
            INC(jj);
            IF jj > dsklastnew THEN EXIT; END;
            IF usedisk THEN
                got:=FIO.RdBin(dskhndnew,fileentry,SIZE(fileentry));
                hashnew  :=fileentry.hashID;
                herenew  :=fileentry.fpos;
            ELSE
                j:=CARDINAL(jj);
                hashnew  :=hashIDnew^[j];
                herenew  :=fposnew^[j];
            END;
            IF hashnew=hashold THEN (* same hashes, check same strings *)
                getStrDisk(lowercase,herenew,hndnew,sNEW);
                IF same(sOLD,sNEW) THEN found:=TRUE; EXIT; END;
            END;
        END;
        IF found=FALSE THEN
            doEyecandy(bargraf,CANDYsave,0);
            IF special THEN video(msg,FALSE); END;
            casify(lowercase,sOLD);
            WrStr(sDeleted);WrStr(sOLD);WrLn;
            IF special THEN video(msg,TRUE); END;
            doEyecandy(bargraf,CANDYrestore,0);
            INC(ndeleted);
        END;
    END;
    doEyecandy(bargraf,CANDYdone,0);
    IF special THEN video(msg,FALSE); END;
    IF ndeleted # 0 THEN WrLn;END;
END listDeleted;

PROCEDURE listAdded    (VAR nadded:LONGCARD;
                       lowercase,special,bargraf,usedisk:BOOLEAN;
                       lastold,lastnew:CARDINAL;dsklastold,dsklastnew:LONGCARD;
                       hndold,hndnew,dskhndold,dskhndnew:FIO.File;
                       sAdded:ARRAY OF CHAR);
VAR
    msg:str128;
    ii,jj:LONGCARD;
    got:CARDINAL;
    fileentry:fileentrytype;
    hashold,hashnew:CARDINAL;
    hereold,herenew:LONGCARD;
    i,j:CARDINAL;
    sOLD,sNEW : pathtype;
    found: BOOLEAN;
BEGIN

    (* added files : found in new, not found in old *);

    doSection(dashAdded);

    Str.Copy(msg,searchingAdded);
    IF special THEN video(msg,TRUE); END;
    doEyecandy(bargraf,CANDYinit, dsklastnew  );
    ii:=firstndx-1;
    IF usedisk THEN
        FIO.Seek(dskhndnew,0);
    ELSE
        dsklastnew:=LONGCARD(lastnew);
    END;
    LOOP
        INC(ii);
        IF ii > dsklastnew THEN EXIT;END;
        doEyecandy(bargraf,CANDYshow, ii );
        IF usedisk THEN
            got:=FIO.RdBin(dskhndnew,fileentry,SIZE(fileentry));
            hashnew  :=fileentry.hashID;
            herenew  :=fileentry.fpos;
        ELSE
            i:=CARDINAL(ii);
            hashnew  :=hashIDnew^[i];
            herenew  :=fposnew^[i];
        END;
        getStrDisk(lowercase,herenew,hndnew,sNEW);

        found:=FALSE;
        jj:=firstndx-1;
        IF usedisk THEN
            FIO.Seek(dskhndold,0);
        ELSE
            dsklastold:=LONGCARD(lastold);
        END;
        LOOP
            INC(jj);
            IF jj > dsklastold THEN EXIT; END;
            IF usedisk THEN
                got:=FIO.RdBin(dskhndold,fileentry,SIZE(fileentry));
                hashold  :=fileentry.hashID;
                hereold  :=fileentry.fpos;
            ELSE
                j:=CARDINAL(jj);
                hashold  :=hashIDold^[j];
                hereold  :=fposold^[j];
            END;
            IF hashold=hashnew THEN (* same hashes, check same strings *)
                getStrDisk(lowercase,hereold,hndold,sOLD);
                IF same(sOLD,sNEW) THEN found:=TRUE; EXIT; END;
            END;
        END;
        IF found=FALSE THEN
            doEyecandy(bargraf,CANDYsave,0);
            IF special THEN video(msg,FALSE); END;
            casify(lowercase,sNEW);
            WrStr(sAdded);WrStr(sNEW);WrLn;
            IF special THEN video(msg,TRUE); END;
            doEyecandy(bargraf,CANDYrestore,0);
            INC(nadded);
        END;
    END;
    doEyecandy(bargraf,CANDYdone,0);
    IF special THEN video(msg,FALSE); END;
    IF nadded # 0 THEN WrLn;END;
END listAdded;


PROCEDURE listModified (VAR nmodified:LONGCARD;
                       lowercase,special,bargraf,usedisk,useMD5digest,useSHAdigest:BOOLEAN;
                       lastold,lastnew:CARDINAL;dsklastold,dsklastnew:LONGCARD;
                       hndold,hndnew,dskhndold,dskhndnew:FIO.File;
                       sModified:ARRAY OF CHAR);
VAR
    msg:str128;
    ii,jj:LONGCARD;
    got:CARDINAL;
    fileentry:fileentrytype;
    hashold,hashnew:CARDINAL;
    hereold,herenew:LONGCARD;
    i,j:CARDINAL;
    sOLD,sNEW : pathtype;
    found,different: BOOLEAN;
    fsizeold,csold:LONGCARD;
    fsizenew,csnew:LONGCARD;
    MD5digestold,MD5digestnew:MD5digestType;
    SHAdigestold,SHAdigestnew:SHAdigestType;
BEGIN

    (* modified files : found in old, found in new, but length or CRC mismatch *)

    doSection(dashModified);

    Str.Copy(msg,searchingModified);
    IF special THEN video(msg,TRUE); END;
    doEyecandy(bargraf,CANDYinit, dsklastold  );
    ii:=firstndx-1;
    IF usedisk THEN
        FIO.Seek(dskhndold,0);
    ELSE
        dsklastold:=LONGCARD(lastold);
    END;
    LOOP
        INC(ii);
        IF ii > dsklastold THEN EXIT;END;
        doEyecandy(bargraf,CANDYshow, ii);
        IF usedisk THEN
            got:=FIO.RdBin(dskhndold,fileentry,SIZE(fileentry));
            hashold  :=fileentry.hashID;
            hereold  :=fileentry.fpos;
            fsizeold :=fileentry.flen;
            csold    :=fileentry.CRC;
            MD5digestold:=fileentry.digest.md5dig;
            SHAdigestold:=fileentry.digest.shadig;
        ELSE
            i:=CARDINAL(ii);
            hashold  :=hashIDold^[i];
            hereold  :=fposold^[i];
            fsizeold :=flenold^[i];
            csold    :=CRCold^[i];
        END;
        getStrDisk(lowercase,hereold,hndold,sOLD);

        found:=FALSE;
        jj:=firstndx-1;
        IF usedisk THEN
            FIO.Seek(dskhndnew,0);
        ELSE
            dsklastnew:=LONGCARD(lastnew);
        END;
        LOOP
            INC(jj);
            IF jj > dsklastnew THEN EXIT; END;
            IF usedisk THEN
                got:=FIO.RdBin(dskhndnew,fileentry,SIZE(fileentry));
                hashnew  :=fileentry.hashID;
                herenew  :=fileentry.fpos;
                fsizenew :=fileentry.flen;
                csnew    :=fileentry.CRC;
                MD5digestnew:=fileentry.digest.md5dig;
                SHAdigestnew:=fileentry.digest.shadig;
            ELSE
                j:=CARDINAL(jj);
                hashnew  :=hashIDnew^[j];
                herenew  :=fposnew^[j];
                fsizenew :=flennew^[j];
                csnew    :=CRCnew^[j];
            END;
            IF hashnew=hashold THEN (* same hashes, check same strings *)
                getStrDisk(lowercase,herenew,hndnew,sNEW);
                IF same(sOLD,sNEW) THEN found:=TRUE; EXIT; END;
            END;
        END;
        IF found THEN
            different := ((fsizeold # fsizenew) OR (csold # csnew));
            IF useMD5digest THEN
                different:=(different OR (MD5digestold # MD5digestnew));
            ELSIF useSHAdigest THEN
                different:=(different OR (SHAdigestold # SHAdigestnew));
            END;
            IF different THEN
                doEyecandy(bargraf,CANDYsave,0);
                IF special THEN video(msg,FALSE); END;
                casify(lowercase,sOLD);
                WrStr(sModified);WrStr(sOLD);WrLn;
                IF special THEN video(msg,TRUE); END;
                doEyecandy(bargraf,CANDYrestore,0);
                INC(nmodified);
            END;
        END;
    END;
    doEyecandy(bargraf,CANDYdone,0);
    IF special THEN video(msg,FALSE); END;
END listModified;

(*
    scanning for deleted/added/modified entries is no longer inline (well... infunction)
    avoiding modified subdirs forced a very cryptic isl:342 error !
*)

PROCEDURE compareLogs (lowercase,plainprefix,summary,
                      audiowarn,special,bargraf,usedisk:BOOLEAN;
                      forcedmethod : cmdtype;
                      oldlog,newlog,tmpdir:ARRAY OF CHAR;
                      VAR einfo:ARRAY OF CHAR ) : CARDINAL;
CONST
    maxscannedlines = 1; (* should always be first line ! *)
VAR
    cmdold,cmdnew:cmdtype;
    lastold,lastnew:CARDINAL;
    dskhndold,dskhndnew:FIO.File;
    dsklastold,dsklastnew:LONGCARD; (* allow more than 65536 files after all *)
    dskold,dsknew:str128;
    sAdded,sDeleted,sModified:str16;
    ndeleted,nadded,nmodified:LONGCARD;
    hndold,hndnew:FIO.File;
    overflowed,useMD5digest,useSHAdigest:BOOLEAN;
BEGIN
    (* //v1.3r fixes *)
    CASE forcedmethod OF
    | md5,sha:
        usedisk:=TRUE;
    | undefined:
        Str.Copy(einfo,oldlog);
        IF getLogMethod(cmdold,maxscannedlines,oldlog)=FALSE THEN RETURN errBadLog;END;
        Str.Copy(einfo,newlog);
        IF getLogMethod(cmdnew,maxscannedlines,newlog)=FALSE THEN RETURN errBadLog;END;
        IF cmdold # cmdnew THEN RETURN errMethods; END;
        CASE cmdnew OF
        | md5 :
            (* IF usedisk=FALSE THEN RETURN errDiskRequiredForMD5; END; *)
            usedisk := TRUE; (* help user even if he had forgotten TOO LATE ! *)
        | sha :
            (* IF usedisk=FALSE THEN RETURN errDiskRequiredForSHA; END; *)
            usedisk := TRUE; (* help user even if he had forgotten TOO LATE ! *)
        END;
    END;

    IF doIndex (overflowed,cmdold,lastold, dsklastold,dskhndold,dskold,
               forcedmethod, usedisk,oldndx,oldlog,tmpdir) = FALSE THEN
        Str.Copy(einfo,oldlog);
        IF overflowed THEN
            RETURN errOverflow;
        ELSE
            RETURN errBadLog;
        END;
    END;
    IF doIndex (overflowed,cmdnew,lastnew, dsklastnew,dskhndnew,dsknew,
               forcedmethod, usedisk,newndx,newlog,tmpdir) = FALSE THEN
        Str.Copy(einfo,newlog);
        IF overflowed THEN
            RETURN errOverflow;
        ELSE
            RETURN errBadLog;
        END;
    END;

    IF cmdold # cmdnew THEN RETURN errMethods; END; (* useless safety here *)

    useMD5digest := (cmdnew=md5);
    useSHAdigest := (cmdnew=sha);

    IF plainprefix THEN
        sAdded   :=longAdded;
        sDeleted :=longDeleted;
        sModified:=longModified;
    ELSE
        sAdded   :=shortAdded;
        sDeleted :=shortDeleted;
        sModified:=shortModified;
    END;

    special:=bargraf;

    ndeleted  :=0;
    nadded    :=0;
    nmodified :=0;

    hndold:=FIO.OpenRead(oldlog);
    FIO.AssignBuffer(hndold,ioOld);
    hndnew:=FIO.OpenRead(newlog);
    FIO.AssignBuffer(hndnew,ioNew);

    doSectionHeader(cmdold,oldlog,newlog);

    (* deleted files : found in old, not found in new *)

    listDeleted      (ndeleted,
                     lowercase,special,bargraf,usedisk,
                     lastold,lastnew, dsklastold,dsklastnew,
                     hndold,hndnew, dskhndold,dskhndnew,
                     sDeleted);

    (* added files : found in new, not found in old *)

    listAdded        (nadded,
                     lowercase,special,bargraf,usedisk,
                     lastold,lastnew, dsklastold,dsklastnew,
                     hndold,hndnew, dskhndold,dskhndnew,
                     sAdded);

    (* modified files : found in old, found in new, but length or CRC mismatch *)

    IF (cmdold # subdirs) THEN
        listModified (nmodified,
                     lowercase,special,bargraf,usedisk,useMD5digest,useSHAdigest,
                     lastold,lastnew, dsklastold,dsklastnew,
                     hndold,hndnew, dskhndold,dskhndnew,
                     sModified);
    END;

    FIO.Close(hndnew);
    FIO.Close(hndold);

    IF usedisk THEN
        FIO.Close(dskhndnew);
        FIO.Close(dskhndold);
        FIO.Erase(dsknew);
        FIO.Erase(dskold);
    END;

    (* always show completion date/time *)

    IF nmodified # 0 THEN WrLn;END;
    WrStr(REMCHAR+nl);
    WrStr(dashCompleted);WrStr(fmtDateTimeUS(globalchronostop));WrLn;
    WrStr(REMCHAR+nl);
  IF cmdold # subdirs THEN
    WrStr(dashElapsed);WrStr(fmtDeltaDT(globalchronostart,globalchronostop));WrLn;
    WrStr(REMCHAR+nl);
  END;
    WrLn;

    IF summary THEN
        doSectionTrailer(cmdold,ndeleted,nadded,nmodified);
    END;

    IF audiowarn THEN alarm; END;

    RETURN errNone;
END compareLogs;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE chkSpec (useLFN:BOOLEAN;defaultdir:ARRAY OF CHAR;
                  VAR basedir,spec:pathtype):BOOLEAN;
VAR
    u,d,n,e:pathtype; (* "u:" "\*\" "" "" *)
BEGIN
    IF Str.Pos(spec,netslash) # MAX(CARDINAL) THEN RETURN FALSE; END;
    IF same(spec,dot) THEN Str.Copy(spec,stardotstar);END;
    IF Str.Match(spec,"*\") THEN Str.Append(spec,stardotstar);END;
    CASE CharCount(spec,colon) OF
    | 0 : ;
    | 1 : IF Str.CharPos(spec,colon) # 1 THEN RETURN FALSE; END; (* only "?:*" allowed *)
    ELSE
        RETURN FALSE;
    END;

    IF Str.Match(spec,"?:\*") THEN
        ;
    ELSIF Str.Match(spec,"?:*") THEN
        RETURN FALSE;
    ELSIF Str.Match(spec,"\*") THEN
        Str.Prepend(spec,colon);
        Str.Prepend(spec,defaultdir[0]);
    ELSE
        Str.Prepend(spec,defaultdir);
    END;

    IF chkJoker(spec)=FALSE THEN
        IF useLFN THEN
            IF w9XisDirectory(spec) THEN Str.Append(spec,backslash+stardotstar);END;
        ELSE
            IF isDirectory(spec) THEN Str.Append(spec,backslash+stardotstar);END;
        END;
    END;

    Lib.SplitAllPath(spec,u,d,n,e);
    Lib.MakeAllPath(basedir,u,d,"","");
    Lib.MakeAllPath(spec,"","",n,e);
    RETURN TRUE;
END chkSpec;

PROCEDURE getStamp (S : ARRAY OF CHAR) : LONGREAL;
CONST
    k10e4 =   10000;
    k10e2 =     100;
    k10e6 = 1000000.0;
VAR
    hnd      : FIO.File;
    stamp    : FIO.FileStamp;
    ok       : BOOLEAN;
    yyyymmdd : LONGCARD;
    hhmmss   : LONGCARD;
    n        : LONGREAL;
BEGIN
    hnd:=FIO.OpenRead(S);
    ok:=FIO.GetFileStamp(hnd,stamp);
    FIO.Close(hnd);
    yyyymmdd:=k10e4*LONGCARD(stamp.Year)+k10e2*LONGCARD(stamp.Month)+LONGCARD(stamp.Day);
    hhmmss  :=k10e4*LONGCARD(stamp.Hour)+k10e2*LONGCARD(stamp.Min)+LONGCARD(stamp.Sec);
    RETURN LONGREAL(yyyymmdd)+(LONGREAL(hhmmss)/k10e6);
END getStamp;

PROCEDURE selectIni (VAR inifile:ARRAY OF CHAR;
                    reverseinisearchorder:BOOLEAN;inidir:ARRAY OF CHAR);
VAR
    u,d,n,e,R,f8e3:str128; (* oversized just in case *)
BEGIN
    Lib.ParamStr(inifile,0);
    UpperCaseAlt(inifile); (* we must be sure we're uppercased here *)
    Str.Subst(inifile,extEXE,extINI);

    Lib.SplitAllPath(inifile, u,d,n,e);
    Lib.MakeAllPath(f8e3,"","",n,e);

    Str.Copy(R,inidir);
    UpperCaseAlt(R); (* safety *)
    fixDirectory(R);
    Str.Append(R,f8e3);

    (* inifile = executable directory, R = current directory *)

    IF reverseinisearchorder THEN (* executable then current *)
        IF FIO.Exists(inifile)=FALSE THEN Str.Copy(inifile,R);END; (* favor executable *)
    ELSE (* default : current then executable *)
        IF FIO.Exists(R) THEN Str.Copy(inifile,R);END; (* favor local *)
    END;
END selectIni;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE showLFN (VAR R:ARRAY OF CHAR;  availableLFN,disableLFN:BOOLEAN);
BEGIN
    Str.Copy(R,msgLFN);
    IF availableLFN THEN
        IF disableLFN THEN
            Str.Append(R,"disabled");
        ELSE
            Str.Append(R,"enabled");
        END;
    ELSE
        Str.Append(R,"not available");
    END;
END showLFN;

PROCEDURE newcmd (VAR cmd:cmdtype; specified:cmdtype);
BEGIN
    IF ( (cmd=undefined) OR (cmd=specified) ) THEN
        cmd:=specified;
    ELSE
        abort(errMethod,"");
    END;
END newcmd;

PROCEDURE newmethod (VAR cmd:cmdtype; specified:cmdtype);
BEGIN
    IF ( (cmd=undefined) OR (cmd=specified) ) THEN
        cmd:=specified;
    ELSE
        abort(errChkMethod,"");
    END;
END newmethod;

(* help us spare less than 50 bytes ! *)

PROCEDURE noNonsense (shouldnotbetrue:BOOLEAN;S:ARRAY OF CHAR);
BEGIN
    IF shouldnotbetrue THEN abort(errNonsense,S);END;
END noNonsense;

(* ------------------------------------------------------------ *)

VAR
    S,R:pathtype; (* was str128 *)
    parmcount,opt,i:CARDINAL;
    state:(waiting,gotparm1,gotparm2);
    cmd,forcedmethod:cmdtype;
VAR
    disableLFN,useLFN,availableLFN : BOOLEAN;
    uppercase,lowercase,usepath,recurse,showheader,eyecandy,killprev:BOOLEAN;
    tabsep,redir,ignoreini,reverseinisearchorder,stillavoidswapfiles:BOOLEAN;
    excludemode,unpacked,summary, performFsizeChk,includeBaseDir:BOOLEAN;
    audiowarn,usedisk:BOOLEAN;
    needed:CARDINAL;
    DEBUG,rc,bargraf,special:BOOLEAN;
    currdrive:SHORTCARD;
    currdir,logfile,tmpdir,inifile,parm2,inidir:str128;
    oldlog,newlog:str128;
    basedir : pathtype;
    parm1,spec,fullpath,defaultdir : pathtype;
VAR
    separ:str16;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)
    WrLn;

    setSigmaUse(FALSE); (* safety : we won't use crcsigma *)

    cmd       := undefined;
    recurse   := TRUE;
    showheader:= TRUE;
    tabsep    := FALSE;
    uppercase := FALSE;
    usepath   := TRUE;
    ignoreini := FALSE;
    reverseinisearchorder:=FALSE;
    excludemode:=TRUE;
    unpacked  := FALSE;
    summary   := FALSE;
    audiowarn := FALSE;
    eyecandy  := TRUE;
    usedisk   := FALSE;
    disableLFN:= FALSE;
    killprev  := FALSE;
    performFsizeChk:=TRUE;
    includeBaseDir :=TRUE;
    redir     := IsRedirected();
    DEBUG     := FALSE;
    forcedmethod := undefined; (* must be default for -v, -k and -r[r] *)
    stillavoidswapfiles:=FALSE;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,""); END;

    state:=waiting;
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S); (* yes, we could clean R instead *)
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
(* available: "bo" *)
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "C"+delim+"CRC"+delim+"CRC32"+delim+
                                   "A"+delim+"ADLER"+delim+"ADLER32"+delim+
                                   "F"+delim+"FLETCHER"+delim+"FLETCHER16"+delim+
                                   "G"+delim+"METHOD"+delim+
                                   "T"+delim+"TAB"+delim+
                                   "N"+delim+"NORECURSE"+delim+
                                   "U"+delim+"UPPERCASE"+delim+
                                   "V"+delim+"VERIFY"+delim+
                                   "P"+delim+"PATH"+delim+
                                   "K"+delim+"COMPARE"+delim+
                                   "Z"+delim+"SIZE"+delim+
                                   "M"+delim+"MD5"+delim+"DIGEST"+delim+
                                   "X"+delim+"IGNORE"+delim+
                                   "J"+delim+"ONLY"+delim+"INCL"+delim+"INCLUDE"+delim+
                                   "Y"+delim+"PREFIX"+delim+
                                   "I"+delim+"REPORT"+delim+
                                   "W"+delim+"AUDIO"+delim+"WARN"+delim+
                                   "Q"+delim+"QUIET"+delim+
                                   "D"+delim+"DISK"+delim+
                                   "KD"+delim+
                                   "S"+delim+"DIRECTORIES"+delim+
                                   "L"+delim+"LFN"+delim+"F8E3"+delim+
                                   "VC"+delim+
                                   "VM"+delim+
                                   "VA"+delim+
                                   "VF"+delim+
                                   "VZ"+delim+
                                   "E"+delim+"EXE"+delim+
                                   "XX"+delim+
                                   "$"+delim+"SHA"+delim+
                                   "V$"+delim+
                                   "R"+delim+"REBUILD"+delim+"REFRESH"+delim+
                                   "RR"+delim+

                                   "KC"+delim+
                                   "KM"+delim+
                                   "K$"+delim+
                                   "KZ"+delim+
                                   "KA"+delim+
                                   "KF"+delim+

                                   "!"+delim+"FSIZECHECK"+delim+
                                   "B"+delim+"USEBASE"+delim+
                                   "DEBUG"
                               );
            CASE opt OF
            | 1,2,3     : abort(errHelp,"");
            | 4,5,6     : newcmd (cmd,crc);
            | 7,8,9     :
                          (*%T ADLERFLETCHER *)
                          newcmd (cmd,adler);
                          (*%E *)
                          (*%F ADLERFLETCHER *)
                          abort(errOption,S);
                          (*%E *)
            | 10,11,12  :
                          (*%T ADLERFLETCHER *)
                          newcmd (cmd,fletcher);
                          (*%E *)
                          (*%F ADLERFLETCHER *)
                          abort(errOption,S);
                          (*%E *)
            | 13,14     : showheader:=FALSE;
            | 15,16     : tabsep:=TRUE;
            | 17,18     : recurse:=FALSE;
            | 19,20     : uppercase:=TRUE;
            | 21,22     : newcmd (cmd,verify);
            | 23,24     : usepath:=FALSE;
            | 25,26     : newcmd (cmd,compare);
            | 27,28     : newcmd (cmd,unsafe);
            | 29,30,31  : newcmd (cmd,md5);
            | 32,33     : ignoreini:=TRUE;
            | 34,35,36,37:excludemode:=FALSE;
            | 38,39     : unpacked:=TRUE;
            | 40,41     : summary:=TRUE;
            | 42,43,44  : audiowarn:=TRUE;
            | 45,46     : eyecandy:=FALSE;
            | 47,48     : usedisk:=TRUE;
            | 49        : newcmd (cmd,compare);
                          usedisk:=TRUE;
            | 50,51     : newcmd (cmd,subdirs);
            | 52,53,54  : disableLFN:=TRUE;
            | 55        : newcmd(cmd,verify); newmethod(forcedmethod,crc);
            | 56        : newcmd(cmd,verify); newmethod(forcedmethod,md5);
            | 57        :
                          (*%T ADLERFLETCHER *)
                          newcmd(cmd,verify); newmethod(forcedmethod,adler);
                          (*%E *)
                          (*%F ADLERFLETCHER *)
                          abort(errOption,S);
                          (*%E *)
            | 58        :
                          (*%T ADLERFLETCHER *)
                          newcmd(cmd,verify); newmethod(forcedmethod,fletcher);
                          (*%E *)
                          (*%F ADLERFLETCHER *)
                          abort(errOption,S);
                          (*%E *)
            | 59        : newcmd(cmd,verify); newmethod(forcedmethod,unsafe);
            | 60,61     : reverseinisearchorder:=TRUE;
            | 62        : ignoreini:=TRUE; stillavoidswapfiles:=TRUE;
            | 63,64     : newcmd (cmd,sha);
            | 65        : newcmd(cmd,verify); newmethod(forcedmethod,sha);
            | 66,67,68  : newcmd (cmd,rebuild);
            | 69        : newcmd (cmd,rebuild); killprev:=TRUE;

            | 70        : newcmd(cmd,compare); newmethod(forcedmethod,crc);
            | 71        : newcmd(cmd,compare); newmethod(forcedmethod,md5);
            | 72        : newcmd(cmd,compare); newmethod(forcedmethod,sha);
            | 73        : newcmd(cmd,compare); newmethod(forcedmethod,unsafe);
            | 74        :
                          (*%T ADLERFLETCHER *)
                          newcmd(cmd,compare); newmethod(forcedmethod,adler);
                          (*%E *)
                          (*%F ADLERFLETCHER *)
                          abort(errOption,S);
                          (*%E *)
            | 75        :
                          (*%T ADLERFLETCHER *)
                          newcmd(cmd,compare); newmethod(forcedmethod,fletcher);
                          (*%E *)
                          (*%F ADLERFLETCHER *)
                          abort(errOption,S);
                          (*%E *)

            | 76,77     : performFsizeChk:=FALSE;
            | 78,79     : includeBaseDir:=FALSE;
            | 80        : DEBUG:=TRUE;
            ELSE
                abort(errOption,S);
            END;
        ELSE
            CASE state OF
            | waiting:
                Str.Copy(parm1,R);
            | gotparm1:
                Str.Copy(parm2,R);
            ELSE
                abort(errSyntax,S);
            END;
            INC(state);
        END;
    END;

    availableLFN := w9XsupportLFN();
    IF availableLFN THEN
        useLFN := NOT(disableLFN);
    ELSE
        useLFN := FALSE;
    END;

    currdrive := FIO.GetDrive(); (* 1=A, etc. *)
    FIO.GetDir(currdrive,currdir); (* we could use 0 for default drive *)
    (* we have unit letter and "\xxx" directory now *)

    Str.Copy(defaultdir,CHR(ORD("A")-1+currdrive));
    Str.Append(defaultdir,colon);
    Str.Append(defaultdir,currdir);
    Str.Copy(inidir,defaultdir); (* for possible later use *)
    IF useLFN THEN
        Str.Copy(fullpath,defaultdir);
        rc:=w9XshortToLong (fullpath, i, defaultdir);
    END;
    UpperCaseAlt(defaultdir); (* probably useless *)
    fixDirectory(defaultdir);      (* add required trailing "\" *)

    CASE cmd OF
    | undefined :
        cmd:=crc;
    | subdirs : (* safety : ignore INI, force recurse *)
        ignoreini := TRUE; (* force -x *)
        recurse   := TRUE; (* ignore -n *)
    END;

    CASE state OF
    | waiting : abort(errHelp,"");
    | gotparm1:
        CASE cmd OF
        | compare :
            abort(errSyntax,"");
        | verify:
            Str.Copy(spec,parm1);
        ELSE
            Str.Copy(spec,parm1);
            IF chkSpec(useLFN,defaultdir, basedir,spec)=FALSE THEN abort(errBadSpec,R);END;
        END;
    | gotparm2:
        CASE cmd OF
        | compare:
            Str.Copy(S,parm1);
            IF needTrailingDot(S) THEN Str.Append(S,extLOG);END;
            IF chkJoker(S) THEN abort(errJoker,S);END;
            IF FIO.Exists(S)=FALSE THEN abort(errNotFound,S);END;
            Str.Copy(oldlog,S);

            Str.Copy(S,parm2);
            IF needTrailingDot(S) THEN Str.Append(S,extLOG);END;
            IF chkJoker(S) THEN abort(errJoker,S);END;
            IF FIO.Exists(S)=FALSE THEN abort(errNotFound,S);END;
            Str.Copy(newlog,S);

            IF getStamp(newlog) < getStamp(oldlog) THEN (* silently swap names *)
                Str.Copy(S,newlog);
                Str.Copy(newlog,oldlog);
                Str.Copy(oldlog,S);
            END;
        ELSE
            abort(errSyntax,"");
        END;
    END;

    lowercase:=NOT(uppercase);

    IF redir THEN
        special  :=NOT(eyecandy); (* quiet redirected forces minimal eyecandy *)
        bargraf  :=eyecandy;      (* verbose redirected forces maximal eyecandy *)
    ELSE
        special  :=FALSE;
        bargraf  :=FALSE;
    END;

    CASE cmd OF
    | compare:
        noNonsense( (recurse=FALSE)       ,"-n");
        noNonsense( (showheader=FALSE)    ,"-g");
        noNonsense( tabsep                ,"-t");
        noNonsense( ignoreini             ,"-x[x]");
        noNonsense( reverseinisearchorder ,"-e");
        noNonsense( (excludemode=FALSE)   ,"-j");
        noNonsense( (usepath=FALSE)       ,"-p");
        noNonsense( disableLFN            ,"-l");

        getTMPdir(defaultdir, tmpdir);
        IF DEBUG THEN
            showLFN(S,availableLFN,disableLFN);
            WrStr(S);WrLn;
            WrStr(msgOldLog);WrStr(oldlog);WrLn;
            WrStr(msgNewLog);WrStr(newlog);WrLn;
            WrStr(msgUseDisk);
            IF usedisk THEN
                Str.Concat(S,"Disk (",tmpdir);Str.Append(S,")");
            ELSE
                S:="RAM";
            END;
            WrStr(S);WrLn;
            WrLn;
        END;

        IF NOT(usedisk) THEN

            IF DEBUG THEN showmem("prior to first allocate");END;
            (* NEW(hashIDold); *)
            needed := SIZE(hashIDold^);
            IF Available(needed)=FALSE THEN abort(errMEM,"hashIDold");END;
            ALLOCATE(hashIDold,needed);
            IF DEBUG THEN showmem("1 ok");END;

            needed := SIZE(fposold^);
            IF Available(needed)=FALSE THEN abort(errMEM,"fposold");END;
            ALLOCATE(fposold,needed);
            IF DEBUG THEN showmem("2 ok");END;

            needed := SIZE(flenold^);
            IF Available(needed)=FALSE THEN abort(errMEM,"flenold");END;
            ALLOCATE(flenold,needed);
            IF DEBUG THEN showmem("3 ok");END;

            needed := SIZE(CRCold^);
            IF Available(needed)=FALSE THEN abort(errMEM,"CRCold");END;
            ALLOCATE(CRCold,needed);
            IF DEBUG THEN showmem("4 ok");END;

            needed := SIZE(hashIDnew^);
            IF Available(needed)=FALSE THEN abort(errMEM,"hashIDnew");END;
            ALLOCATE(hashIDnew,needed);
            IF DEBUG THEN showmem("5 ok");END;

            needed := SIZE(fposnew^);
            IF Available(needed)=FALSE THEN abort(errMEM,"fposnew");END;
            ALLOCATE(fposnew,needed);
            IF DEBUG THEN showmem("6 ok");END;

            needed := SIZE(flennew^);
            IF Available(needed)=FALSE THEN abort(errMEM,"flennew");END;
            ALLOCATE(flennew,needed);
            IF DEBUG THEN showmem("7 ok");END;

            needed := SIZE(CRCnew^);
            IF Available(needed)=FALSE THEN abort(errMEM,"CRCnew");END;
            ALLOCATE(CRCnew,needed);
            IF DEBUG THEN showmem("after last allocate");END;

        END;

        IF DEBUG THEN showmem("prior to comparing");END;

        i:=compareLogs (lowercase,unpacked,
                       summary,audiowarn,special,bargraf,usedisk,
                       forcedmethod,
                       oldlog,newlog,tmpdir,  R);

        IF DEBUG THEN showmem("after comparing");END;

        IF i # errNone THEN abort(i,R); END;

    | verify,rebuild:
        noNonsense( (recurse=FALSE)       ,"-n");
        noNonsense( (showheader=FALSE)    ,"-g");
        noNonsense( tabsep                ,"-t");
        noNonsense( ignoreini             ,"-x[x]");
        noNonsense( reverseinisearchorder ,"-e");
        noNonsense( (excludemode=FALSE)   ,"-j");
        noNonsense( unpacked              ,"-y");
        noNonsense( summary               ,"-i");
        noNonsense( usedisk               ,"-d");
        noNonsense( disableLFN            ,"-l");

        Str.Concat(logfile,basedir,spec);

        IF needTrailingDot(logfile) THEN Str.Append(logfile,extLOG);END;
        IF chkJoker(logfile) THEN abort(errJoker,logfile);END;
        IF FIO.Exists(logfile)=FALSE THEN abort(errNotFound,logfile);END;

        IF DEBUG THEN
            IF cmd=verify THEN
                S:="verifying";
            ELSE
                S:="rebuilding";
            END;
            Str.Prepend(S,"prior to ");
            showmem(S);
        END;

        i:=procLog (useLFN,lowercase,usepath,audiowarn,
                   special,bargraf,redir,killprev,performFsizeChk,
                   cmd,forcedmethod,logfile,  R);

        IF DEBUG THEN
            IF cmd=verify THEN
                S:="verifying";
            ELSE
                S:="rebuilding";
            END;
            Str.Prepend(S,"after ");
            showmem(S);
        END;

        IF i # errNone THEN abort(i,R); END;

    ELSE
        noNonsense( (usepath=FALSE)   ,"-p");
        noNonsense( unpacked          ,"-y");
        noNonsense( summary           ,"-i");
        noNonsense( usedisk           ,"-d");

        IF (ignoreini AND (excludemode=FALSE)) THEN abort(errExclusive,"");END;

        IF DEBUG THEN showmem("before INI allocate");END;
        (* NEW(pINIentry); *)
        needed := SIZE(pINIentry^);
        IF Available(needed)=FALSE THEN abort(errMEM,"pINIentry");END;
        ALLOCATE(pINIentry,needed);
        IF DEBUG THEN showmem("after INI allocate");END;

        lastPath := BuildPathList (useLFN,recurse, basedir);
        IF lastPath=MAX(CARDINAL) THEN abort(errTooManyDirs,basedir);END;

        selectIni(inifile,reverseinisearchorder,inidir);

        i:=buildINIentries(ignoreini,stillavoidswapfiles,excludemode,inifile);
        IF i # errNone THEN abort(i,inifile);END;

        IF DEBUG THEN
            showLFN(S,availableLFN,disableLFN);
            WrStr(S);WrLn;
            WrStr(msgDefault); WrStr(defaultdir);WrLn;
            WrStr(msgBaseDir); WrStr(basedir);WrLn;
            WrStr(msgSpec);    WrStr(spec);WrLn;
            WrStr(msgINI);     WrStr(inifile);WrLn;
            WrLn;
            FOR i:=firstINIentry TO lastINIentry DO
                IO.WrCard(i,3);WrStr(" : ");WrStr(pINIentry^[i]);WrLn;
            END;
            WrLn;
            FOR i:=firstPath TO lastPath DO
                getentry(i,fullpath);
                IO.WrCard(i,3);WrStr(" : ");WrStr(fullpath);WrLn;
            END;
            WrLn;
        END;

        (* IF redir THEN verbose:=TRUE; END; *)

        IF showheader THEN doHeader(cmd,tabsep); END;

        IF tabsep THEN
            separ:=tab;
        ELSE
            separ:=bl2;
        END;

        Flushkey;

        IF DEBUG THEN showmem("prior to computing");END;

        doEyecandy(bargraf,CANDYinit, LONGCARD(lastPath) );
        FOR i:=firstPath TO lastPath DO
            getentry(i,fullpath);
            rc:=computeLogs (cmd,
                            useLFN,lowercase,excludemode,
                            special,redir,includeBaseDir,
                            separ,fullpath,spec,basedir);
            doEyecandy(bargraf,CANDYshow, LONGCARD(i) );
            IF rc=FALSE THEN
                freePaths (lastPath);
                doEyecandy(bargraf,CANDYdone, 0 );
                abort(errAbortedByUser,"");
            END;
        END;

        IF DEBUG THEN showmem("after computing");END;

        freePaths (lastPath);

        needed := SIZE(pINIentry^);
        DEALLOCATE(pINIentry,needed);

        IF DEBUG THEN showmem("final");END;

        doEyecandy(bargraf,CANDYdone, 0 );
        IF audiowarn THEN alarm; END;
    END;

    abort(errNone,"");
END cs.

