(* ---------------------------------------------------------------
Title         Q&D Directory to Batch
Author        who cares ?
Overview      see help
Usage         see help
Notes         yes, could have been a directory list builder but who cares ? ;-)
              assume archives are valid
              $x allows for a poor man's LFNBK-like function
              we could use case ($c = LFN, $C = DOS) but too unixian a way
              we crashed with a Storage.ALLOCATE() failure because
              we were computing SIZE(PathEntryType) instead of SIZE(entrytype) !!!
Bugs          vindoze 9X LFNs can lead to a very, very long command line,
              which is likely to crash the program -- we won't check for that,
              for it should not occur with good old DOS limits

              odd thing : whatever $c, $u$d$f, $x,
              "menu dmarrer" gives menude~1

Wish List     read auto-extractable archives ? bah...
              check lzh level 2 archive

              make buildPathList a clever separate unit ? bah, too late

              use QD_LFN functions to fully list Win9X contents ?
              color-coded extensions ? leave it to future DD

              /c to fix century ? ah, already taken, and what for anyway ?
              use fmtAttr in listmode ?

              a more flexible format string for list entry display ?

              support for .ace and .7z (useful but unlikely) archives ?

--------------------------------------------------------------- *)

MODULE DirBat;

IMPORT Str;
IMPORT Lib;
IMPORT FIO;
IMPORT Storage;

FROM IO IMPORT WrStr,WrLn,WrCard, WrLngHex,WrLngCard;

FROM Storage IMPORT Available,ALLOCATE,DEALLOCATE;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs,
completedInit, completedShow, completedSHOW, completedEnd, completed;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XsupportLFN;

(* ------------------------------------------------------------ *)

TYPE
    pathtype = path9X;

CONST
    dbg        = FALSE;
    dbgarj     = FALSE;
    dbgzip     = FALSE;
    dbglzh     = FALSE;
    dbg7z      = FALSE;
    dbgrar     = FALSE;
    memdebug   = FALSE;
    RECURSEDIR = TRUE; (* if true, store full paths *)
TYPE
    scantype = (normalandspecial,normal,special,directoriesonly);
CONST
    nl          = CHR(13)+CHR(10);
    colon       = ":";
    dot         = ".";
    backslash   = "\";
    dotdot      = dot+dot;
    star        = "*";
    stardotstar = star+dot+star;
    netslash    = backslash+backslash;
CONST
    equal       = "=";
    dash        = "-";
    blank       = " ";
    coma        = ",";
    slash       = "/";
CONST
    dquote     = '"';
    singlequote= "'";
    dollar     = "$";
    underscore = "_";
    percent    = "%";
    pound      = "#";
    question   = "?";
    extBAT     = ".BAT";
    BATCH      = "PROCTHEM"+extBAT;
    (* archive extensions must be uppercase *)
    extZIP     = ".ZIP";
    extARJ     = ".ARJ";
    extLZH     = ".LZH";
    extRAR     = ".RAR";
    ext7Z      = ".7Z";
CONST
    idarchive     = "++"; (* two chars *)
    bigsep        = "    ";
    separc        = " "+idarchive+" "; (* same length as sep in showdata *)
    separcneat    = separc+"   "; (* indent ? or leave separc ? *)
    smallsep      = "  ";
    separcprefix  = idarchive+" "; (* no leading space *)
    separcsuffix  =      " "; (* the missing space *)
CONST
    cDollar   = dollar;
    cCRLF     = underscore;
    cPound    = pound;
    cQuestion = question;
    cPercent  = "p";
    cU        = "u";
    cD        = "d";
    cB        = "b";
    cN        = "n";
    cE        = "e";
    cF        = "f";
    cC        = "c";
    cQ        = "q";
    cX        = "x";
CONST
    escch       = dollar;
    fmtDOLLAR   = escch+cDollar;
    fmtCRLF     = escch+cCRLF;
    fmtPERCENT  = escch+cPercent;
    fmtPOUND    = escch+cPound;
    fmtQUESTION = escch+cQuestion;
CONST
    fmtU        = escch+cU;
    fmtD        = escch+cD;
    fmtB        = escch+cB;
    fmtN        = escch+cN;
    fmtE        = escch+cE;
    fmtF        = escch+cF;
    fmtC        = escch+cC;
    fmtQ        = escch+cQ;
    fmtX        = escch+cX;
CONST
    cmdremark    = "REM ";
    cmdechoOFF   = "@ECHO OFF";
    cmdechoON    = "@ECHO ON";
    cmdpause     = "@PAUSE";
    cmdpausefull = cmdpause+" Hit Ctrl-Break or Ctrl-C if you want to abort now !";
CONST
    progEXEname   = "DIRBAT";
    progTitle     = "Q&D Directory to Batch";
    progVersion   = "v1.2k";
    progCopyright = "by PhG";
    Banner        = progTitle+" "+progVersion+" "+progCopyright;

CONST
    errNone           = 0;
    errHelp           = 1;
    errOption         = 2;
    errParameter      = 3;
    errBadAttrib      = 4;
    errSyntax         = 5;
    errBadSpec        = 6;
    errTooManyDirs    = 7;
    errBadBatch       = 8;
    errNotIfDir       = 9;
    errRecursion      = 10;
    errCmdSyntax      = 11;
    errSizeRange      = 12;
    errDateRange      = 13;
    errNonsense       = 14;
    errCmdSyntaxList  = 15;
    errNonsenseList   = 16;
    errNonsenseBatch  = 17;
    errList           = 18;
    errNonsenseArc    = 19;
    errNonsenseLS     = 20;
    errAbortedByUser  = 21;
    errHelper         = 22;

(* ------------------------------------------------------------ *)

PROCEDURE showmem(S:ARRAY OF CHAR );
VAR
    heapsize    : CARDINAL; (* in PARAGRAPHS and not in bytes ! help is wrong ! *)
    n           : LONGCARD;
BEGIN
    heapsize :=Storage.HeapTotalAvail(Storage.MainHeap);
    n :=16 * LONGCARD(heapsize);
    WrStr("::: ");WrLngCard(n,6); WrStr(" byte(s) free -- ");WrStr(S);WrLn;
END showmem;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);

    MODULE message;
    IMPORT Str;
    EXPORT msg3;

    PROCEDURE msg3 (VAR R:ARRAY OF CHAR;S1,S2,S3:ARRAY OF CHAR);
    BEGIN
        Str.Concat(R,S1,S2);Str.Append(R,S3);
    END msg3;

    END message;

CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msghelp=
Banner+nl+
nl+
"Syntax 1 : "+progEXEname+' <filespec>... [option]... <"batch command">'+nl+
"Syntax 2 : "+progEXEname+' -list <filespec>... [option]...'+nl+
nl+
"This program lists files (-list) or creates a "+BATCH+" (default) batch."+nl+
nl+
"  -n      list only normal files (H and S excluded, default is -n -z)"+nl+
"  -z      list only special files (H or S required, default is -n -z)"+nl+
"  -d      list only directories (H or S included)"+nl+
'  -d:$    filter entries according to specified "lower[:|..]upper" date range'+nl+
'          ("*"=today, "$"=same date, ":$"=before or on, "$:"=on or after)'+nl+
'  -z:$    filter entries according to specified "lower[-|:|..]upper" size range'+nl+
'          ("#"=same size, ":#"=size less or equal, "#:"=size equal or more)'+nl+
"  -l[a]   list mode (-la = -l -a)"+nl+
"  -ll[a]  list mode including supported archives using archive extension"+nl+
"  -lll[a] list mode including supported archives ignoring extension"+nl+
"  -ls     list mode prepending short filename to each LFN entry (-a forced)"+nl+
"  -s      include subdirectories (valid if only one filespec was specified)"+nl+
"  -u      force filenames to uppercase (list mode only)"+nl+
"  -a      alternate file display (list mode only, no effect with LFNs)"+nl+
"  -t      filenames only terse listing (list mode only)"+nl+
"  -c      do not alter original archive filename case (list mode only)"+nl+
"  -p      paging (list mode only, and ignored if output is redirected)"+nl+
"  -k      force filenames to lowercase in batch file"+nl+
'  -e      begin batch with "'+cmdechoON+'" (default is "'+cmdechoOFF+'")'+nl+
'  -w      begin batch with "'+cmdpause+'"'+nl+
"  -b:$    specify alternate batch filename (default extension is "+extBAT+")"+nl+
"  -m      do not overwrite existing batch file but append commands to it"+nl+
"  -v[v]   (very) verbose (in list mode, include final file stats)"+nl+
"  -i[i]   immediately run batch file (-ii = delete batch after run)"+nl+
"  -lfn    disable LFN support even if available (token replacement ONLY !)"+nl+
"  -dir[s] shortcut for -l -t [-s]"+nl+
"  -??     more help"+nl+
nl+
"a) Even if LFN support is available, <filespec> MUST be in f8e3 DOS form."+nl+
'b) With -ll[l] command, archive contents is highlighted with "'+idarchive+'" marker'+nl+
"   (archive contents is entirely listed, without any filter)."+nl+
"c) Supported archive formats are ZIP, ARJ, LZH and RAR."+nl+
"d) Note LFN support is limited to display (token replacement ONLY !)."+nl;
   msgHelper =
'e) Batch tokens for "batch command" (double quotes required) are :'+nl+
nl+
"  "+fmtCRLF     +"  newline"+nl+
"  "+fmtPERCENT  +"  percent character"+nl+
"  "+fmtDOLLAR   +"  dollar character"+nl+
"  "+fmtU        +"  unit"+nl+
"  "+fmtD        +"  directory"+nl+
"  "+fmtB        +'  directory without trailing "\"'+nl+
"  "+fmtN        +"  file"+nl+
"  "+fmtE        +"  extension (without dot)"+nl+
"  "+fmtF        +"  file.extension"+nl+
"  "+fmtC        +"  shortcut for "+fmtU+fmtD+fmtF+" (any LFN automagically becomes "+fmtQ+fmtC+fmtQ+")"+nl+
"  "+fmtX        +"  shortcut for "+fmtU+fmtD+fmtF+" (forced to DOS format even with LFN support)"+nl+
"  "+fmtQ        +"  double quote"+nl+
"  "+fmtPOUND    +"  auto-incremented ##### decimal number starting from 1"+nl+
"  "+fmtQUESTION +'  auto-incremented ??? string starting from "AAA"'+nl+
nl+
"f) Though auto-incrementation is global, it should not be used with -s option."+nl+
"g) If LFN support is available, and if -lfn option was NOT specified,"+nl+
"   program will replace each original f8e3 token with its matching LFN form :"+nl+
"   in list mode, each LFN is automagically enclosed with double quotes ;"+nl+
"   in batch mode, by design, this is NOT the case, so careful use of "+fmtQ+" token"+nl+
"   is highly recommended in order to avoid unexpected side effects"+nl+
"   (note only "+fmtC+" token automagically encloses LFN with double quotes)."+nl+
nl+
"Examples : "+progEXEname+' *.tmp -s "DEL '+fmtU+fmtD+fmtN+dot+fmtE+'"'+nl+
"           "+progEXEname+' c:\bat\*.exe c:\tools\*.exe "COPY '+fmtU+fmtD+fmtN+dot+fmtE+' G:\tmp"'+nl+
"           "+progEXEname+' c:\*.* -s -z:0 "DEL '+fmtC+'"'+nl+
"           "+progEXEname+' c:\*.* -s -d:* "COPY '+fmtC+' %TMP%"'+nl+
"           "+progEXEname+" -l *.exe *.com -d:1/2/1993"+nl+
"           "+progEXEname+" \ /s /ll"+nl+
"           "+progEXEname+' \windows /s /i "echo '+fmtC+" ::: "+fmtX+'"'+nl+
"           "+progEXEname+' *.zip "MD '+fmtQ+fmtN+fmtQ+fmtCRLF+"CD "+fmtQ+fmtN+fmtQ+fmtCRLF+"PKUNZIP "+fmtQ+"..\"+fmtN+fmtQ+fmtCRLF+"CD .."+fmtCRLF+'"'+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp,errHelper :
        WrStr(msghelp);
        IF e=errHelper THEN
            WrStr(msgHelper);
            e:=errHelp;
        END;
    | errOption :      msg3(S,"Illegal ",einfo," option !");
    | errParameter :   msg3(S,"Useless ",einfo," parameter !");
    | errBadAttrib :   msg3(S,"Illegal attribute in ",einfo," option !");
    | errSyntax :      S:="Syntax error !";
    | errBadSpec :     msg3(S,"Illegal ",einfo," specification !");
    | errTooManyDirs : msg3(S,"Storage.ALLOCATE() failure", " or more than 3000 directories", " !"); (* "from ",einfo," !" *)
(*%T memdebug  *)
                       showmem("errTooManyDirs");
(*%E  *)
    | errBadBatch    : msg3(S,"Illegal ",einfo," batch specification !");
    | errNotIfDir    : S:="Recursion unsupported with -a:D option !";
    | errRecursion   : S:="Recursion supported if only one filespec was specified !";
    | errCmdSyntax   : S:="Batch command must be delimited with double quotes !";
    | errSizeRange   : msg3(S,"Illegal ",einfo," size range !");
    | errDateRange   : msg3(S,"Illegal ",einfo," date range !");
    | errNonsense    : S:="-p and -i[i] options are mutually exclusive !";
    | errCmdSyntaxList:S:="-l[l[l]] and batch command are mutually exclusive !";
    | errNonsenseList: S:="-l[l[l]] and batch-specific options are mutually exclusive !";
    | errNonsenseBatch:S:="-t, -u, -a, -c, -p and batch command are mutually exclusive !";
    | errList        : S:="-n, -z and -d options are mutually exclusive !";
    | errNonsenseArc : S:="-ll[l] and -t options are mutually exclusive !";
    | errNonsenseLS  : msg3(S,"-ls and ",einfo," options are mutually exclusive !");
    | errAbortedByUser:S:="Listing aborted by user !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp : ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;

    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    initpagingcounter = 1; (* account for message *)
VAR
    lastRow               : CARDINAL;
    rowcount              : CARDINAL;

PROCEDURE dumpline (paging:BOOLEAN; S:ARRAY OF CHAR);
CONST
    kbdmsg = "Hit (almost) any key to continue or Escape to abort listing : ";
    cancel = str2( CHR(27) );
VAR
    key:str2;
BEGIN
    WrStr(S);WrLn;
    IF paging THEN
        INC(rowcount);
        IF rowcount >= lastRow THEN (* = is enough but who knows what evil lurks in the heart of BIOS *)
            rowcount := initpagingcounter;
            video(kbdmsg,TRUE);
            Flushkey;
            key:=Waitkey();
            video(kbdmsg,FALSE);
            IF same(key,cancel) THEN abort(errAbortedByUser,"");END;
        END;
    ELSE
        IF ChkEscape() THEN abort(errAbortedByUser,"");END;
    END;
END dumpline;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    HUGECARD = LONGREAL;
CONST
    HUGEZERO = LONGREAL(0.0);

PROCEDURE HUGEINC (VAR r:HUGECARD;n:HUGECARD );
BEGIN
    r := r + n;
END HUGEINC;

PROCEDURE fmthc (v : HUGECARD; pad:CHAR; sep:CHAR) : str80;
CONST
    field = 10+3; (* #,###,###,### *) (* 1Gb+ file okay now *)
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.FixRealToStr( LONGREAL(v),0,S,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmthc;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    ioBufferOut : ioBufferType;

(* ------------------------------------------------------------ *)

CONST
    firstPath = 1;   (* was 0, but 1 required by Lib.QSort and by firstPath-1 of course ! *)
    maxPath   = 5000; (* // 7500 *)

TYPE
    ptrToEntry = POINTER TO pathEntrytype;
    pathEntrytype  = RECORD
(*%F RECURSEDIR  *)
        father:CARDINAL;
(*%E *)
        slen : SHORTCARD;
        string:CHAR; (* variable length *)
    END;
VAR
    Path      : ARRAY[firstPath..maxPath] OF ptrToEntry;
    lastPath  : CARDINAL;

PROCEDURE freePathList (  );
VAR
    i,len,needed:CARDINAL;
BEGIN
    FOR i:=firstPath TO lastPath DO
         IF Path[i] # NIL THEN
             len := CARDINAL(Path[i]^.slen);
             needed := SIZE(pathEntrytype)-SIZE(CHAR)+len;
             DEALLOCATE(Path[i],needed);
         END;
    END;
END freePathList;

(* ------------------------------------------------------------ *)

PROCEDURE fixDirPath (VAR S : ARRAY OF CHAR);
VAR
    len : CARDINAL;
BEGIN
    len := Str.Length(S);
    IF len = 0 THEN
        Str.Copy(S,backslash);
    ELSE
        IF S[len-1] # backslash THEN
            Str.Append(S,backslash);
        END;
    END;
END fixDirPath;

PROCEDURE isDirEntry (S : ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isDirEntry;

(*%T RECURSEDIR  *)

PROCEDURE getentry (i:CARDINAL; VAR R : ARRAY OF CHAR);
CONST
    nullchar=CHR(0);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(Path[i]^.slen);
    Lib.FastMove( ADR(Path[i]^.string),ADR(R),len);
    R[len]:=nullchar; (* REQUIRED safety ! *)
END getentry;

PROCEDURE setentry (i:CARDINAL; S : ARRAY OF CHAR  ) : BOOLEAN ;
VAR
    len,needed:CARDINAL;
BEGIN
    len    := Str.Length(S);
    needed := SIZE(pathEntrytype)-SIZE(CHAR)+len;
    IF Available(needed) THEN
        ALLOCATE(Path[i],needed);
        Path[i]^.slen := SHORTCARD(len);
        Lib.FastMove( ADR(S),ADR(Path[i]^.string),len);
    ELSE
        Path[i]:=NIL;
    END;
    RETURN (Path[i] # NIL);
END setentry;

PROCEDURE doDir (root : ARRAY OF CHAR;eyecandy:BOOLEAN;
                 VAR index:CARDINAL;VAR err:BOOLEAN);
VAR
    path    : str128;
    S       : str128;
    entry   : FIO.DirEntry;
    found   : BOOLEAN;
BEGIN
    IF index > maxPath THEN
        err:=TRUE;
        RETURN;
    END;
    fixDirPath(root); (* add required "\" here *)
    IF setentry(index,root)=FALSE THEN
        err:=TRUE;
        RETURN;
    END;

    Str.Copy(path,root);
    (* fixDirPath(path); (* add required \ *) was done a few lines earlier *)
    Str.Append(path,stardotstar); (* root\*.* *)

    found := FIO.ReadFirstEntry(path,everything,entry);
    WHILE found DO
        IF eyecandy THEN Work(cmdShow); END;
        Str.Copy(S,root);
        fixDirPath(S);
        Str.Append(S,entry.Name); (* root\f8e3 *)
        IF isDirEntry(entry.Name)=FALSE THEN (* skip . and .. *)
            IF aD IN entry.attr THEN
                INC(index);
                doDir(S,eyecandy,index,err);
            END;
        END;
        found :=FIO.ReadNextEntry(entry);
    END;
END doDir;

(*%E  *)

(*%F RECURSEDIR  *)

PROCEDURE getentry (i:CARDINAL; VAR R : ARRAY OF CHAR);
CONST
    nullchar=CHR(0);
VAR
    len,father:CARDINAL;
    S : str128;
BEGIN
    len := CARDINAL(Path[i]^.slen);
    Lib.FastMove( ADR(Path[i]^.string),ADR(R),len);
    R[len]:=nullchar; (* REQUIRED safety ! *)
    LOOP
        i:=Path[i]^.father;
        IF i = MAX(CARDINAL) THEN EXIT;END;
        len := CARDINAL(Path[i]^.slen);
        Lib.FastMove( ADR(Path[i]^.string),ADR(S),len);
        S[len]:=nullchar; (* REQUIRED safety ! *)
        Str.Prepend(R,S);
    END;
END getentry;

PROCEDURE setentry (i,father:CARDINAL; S : ARRAY OF CHAR  ) : BOOLEAN ;
VAR
    len,needed:CARDINAL;
BEGIN
    len    := Str.Length(S);
    needed := SIZE(pathEntrytype)-SIZE(CHAR)+len;
    IF Available(needed) THEN
        ALLOCATE(Path[i],needed);
        Path[i]^.father:= father;
        Path[i]^.slen := SHORTCARD(len);
        Lib.FastMove( ADR(S),ADR(Path[i]^.string),len);
    ELSE
        Path[i]:=NIL;
    END;
    RETURN (Path[i] # NIL);
END setentry;

PROCEDURE doDir (root : ARRAY OF CHAR;eyecandy:BOOLEAN;
                 VAR index:CARDINAL;VAR err:BOOLEAN);
VAR
    S,sdyn:str128;
    i:CARDINAL;
    found:BOOLEAN;
    entry:FIO.DirEntry;
BEGIN
    i:=MAX(CARDINAL);
    IF index > maxPath THEN
        err:=TRUE;
        RETURN;
    END;
    fixDirPath(root); (* add required "\" here *)
    IF setentry(index,i,root)=FALSE THEN
        err:=TRUE;
        RETURN;
    END;
    i := index; (* firstPath *)
    LOOP
        Str.Copy(S,root);
        Str.Append(S,stardotstar);
        found := FIO.ReadFirstEntry(S,everything,entry);
        WHILE found DO
            IF eyecandy THEN Work(cmdShow); END;
            IF isDirEntry(entry.Name)=FALSE THEN
                IF aD IN entry.attr THEN
                    INC(index);
                    IF index > maxPath THEN
                        err:=TRUE;
                        RETURN;
                    END;
                    (* GOOD
                    Str.Concat(sdyn,root,entry.Name);
                    fixDirectory(sdyn);
                    *)
                    Str.Copy(sdyn,entry.Name);
                    fixDirectory(sdyn);
                    IF setentry(index,i,sdyn)=FALSE THEN
                        err:=TRUE;
                        RETURN;
                    END;
                END;
            END;
            found:=FIO.ReadNextEntry(entry);
        END;
        INC(i);
        IF i > index THEN EXIT; END; (* better safe than sorry *)
        getentry(i,root);
    END;
END doDir;

(*%E  *)

PROCEDURE BuildPathList (rootdir : ARRAY OF CHAR) : CARDINAL;
CONST
    msg1 = "Building list of directories for ";
VAR
    found    : BOOLEAN;
    i        : CARDINAL;
    prompt   : str128;
    error    : BOOLEAN;
BEGIN
    Str.Concat(prompt,msg1,rootdir);

    video (prompt,TRUE);
    Work(cmdInit);

    i        := firstPath;
    error    := FALSE;

    doDir(rootdir,TRUE,i,error);

    Work(cmdStop);
    video (prompt,FALSE);
    IF error THEN i:=MAX(CARDINAL); END;
    RETURN i;
END BuildPathList;

(* won't convert jokers *)

PROCEDURE LFNtoShort (VAR dosform:pathtype;longform:pathtype);
VAR
    rc:CARDINAL;
    LFNform:pathtype;
BEGIN
    Str.Copy(LFNform,longform);
    IF w9XlongToShort (LFNform, rc,dosform)=FALSE THEN
         Str.Copy(dosform,LFNform); (* hide problem *)
    END;
END LFNtoShort;

(* ------------------------------------------------------------ *)

PROCEDURE wrbool (flag:BOOLEAN);
BEGIN
    IF flag THEN
        WrStr("yes");
    ELSE
        WrStr("no");
    END;
END wrbool;

PROCEDURE fmtnum (VAR R:ARRAY OF CHAR; num,base,digits:CARDINAL;pad:CHAR);
VAR
    ok:BOOLEAN;
    i:CARDINAL;
BEGIN
    Str.CardToStr( LONGCARD(num), R, base, ok );
    FOR i:=Str.Length(R)+1 TO digits DO
        Str.Prepend(R,pad);
    END;
END fmtnum;

PROCEDURE fixQuotedString (VAR S:ARRAY OF CHAR);
VAR
    n,len:CARDINAL;
BEGIN
    n:=0;
    IF Str.Match(S,dquote+"*"+dquote) THEN INC(n);END;
    IF Str.Match(S,singlequote+"*"+singlequote) THEN INC(n);END;
    IF n # 0 THEN
        Str.Delete(S,0,1); (* first doublequote *)
        len:=Str.Length(S);
        Str.Delete(S,len-1,1);
    END;
END fixQuotedString;

PROCEDURE chkSpec (VAR basedir,spec:ARRAY OF CHAR;
                  LFNhere:BOOLEAN;defaultdir:ARRAY OF CHAR):BOOLEAN;
VAR
    u,d,n,e:str128; (* "u:" "\*\" "" "" *)
    longform,dosform:pathtype;
BEGIN
    fixQuotedString(spec);
    Str.Copy(longform,spec);
    IF LFNhere THEN
        LFNtoShort(dosform, longform);
        Str.Copy(spec,dosform);
        UpperCase(spec);
    END;

    IF Str.Pos(spec,netslash) # MAX(CARDINAL) THEN RETURN FALSE; END;
    IF same(spec,dot) THEN Str.Copy(spec,stardotstar);END;
    IF Str.Match(spec,"*\") THEN Str.Append(spec,stardotstar);END;
    CASE CharCount(spec,colon) OF
    | 0 : ;
    | 1 : IF Str.CharPos(spec,colon) # 1 THEN RETURN FALSE; END; (* only "?:*" allowed *)
    ELSE
        RETURN FALSE;
    END;

    IF Str.Match(spec,"?:\*") THEN
        ;
    ELSIF Str.Match(spec,"?:*") THEN
        RETURN FALSE;
    ELSIF Str.Match(spec,"\*") THEN
        Str.Prepend(spec,colon);
        Str.Prepend(spec,defaultdir[0]);
    ELSE
        Str.Prepend(spec,defaultdir);
    END;

    IF chkJoker(spec)=FALSE THEN
        IF isDirectory(spec) THEN Str.Append(spec,backslash+stardotstar);END;
    END;

    Lib.SplitAllPath(spec,u,d,n,e);
    Lib.MakeAllPath(basedir,u,d,"","");
    Lib.MakeAllPath(spec,"","",n,e);
    RETURN TRUE;
END chkSpec;

(* assume legal "???" string *)

TYPE
    str3 = ARRAY [0..2] OF CHAR;
CONST
    orgnumalpha  = str3("AA"+CHR(ORD("A")-1)); (* same as 1-1 ! *)

PROCEDURE incalpha (VAR S:str3);
VAR
    i,code:CARDINAL;
    carry:BOOLEAN;
BEGIN
    i:=Str.Length(S);
    IF i = 0 THEN RETURN; END; (* should never happen but... *)
    LOOP
        DEC(i);
        code:=ORD(S[i]);
        INC(code);
        IF code > ORD("Z") THEN
            IF i=0 THEN
                code:=ORD("_"); (* safety *)
            ELSE
                code:=ORD("A");
            END;
            carry:=TRUE;
        ELSE
            carry:=FALSE;
        END;
        S[i]:=CHR(code);
        IF carry=FALSE THEN EXIT; END;
        IF i=0 THEN EXIT; END;
    END;
END incalpha;

(* ------------------------------------------------------------ *)

(*
Year stored relative to 1980 (ex. 1988 stores as 8)
    year      month    day   

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

CONST
    yyMask=BITSET{9..15};
    yyShft=9;
    mmMask=BITSET{5..8};
    mmShft=5;
    ddMask=BITSET{0..4};
    ddShft=0;
    mindd=1;
    maxdd=31;
    minmm=1;
    maxmm=12;
    minyy=1980; (* base year for messdos *)
    maxyy=minyy+127; (* was 2099 *)
    baseyear=minyy;  (* 1980 *)

PROCEDURE PackDMY (d,m,y : CARDINAL  ) : CARDINAL;
BEGIN
    IF y < baseyear THEN
        y:=baseyear;
    END;
    DEC(y,baseyear);
    IF y > 127 THEN y:=127; END; (* %1111111 i.e. $7f max *)
    y := y << yyShft;
    m := m << mmShft;
    RETURN (y + m + d);
END PackDMY;

PROCEDURE UnpackDMY (dmy:CARDINAL;VAR d,m,y:CARDINAL);
BEGIN
    y := CARDINAL(BITSET(dmy) * yyMask) >> yyShft;
    m := CARDINAL(BITSET(dmy) * mmMask) >> mmShft;
    d := CARDINAL(BITSET(dmy) * ddMask) >> ddShft;
    INC(y,baseyear);
END UnpackDMY;

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str80;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str80;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

PROCEDURE fmtDate (dmy:CARDINAL) : str80;
CONST
    separator = dash;
    pad="0";
    baseyear = 1900;
    tmonths ="Jan Fv Mar Avr Mai Jun Jui Ao Sep Oct Nov Dc ???";
    tmonths2="Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ???";
VAR
    R : str80;
    d,m,y:CARDINAL;
BEGIN
    UnpackDMY(dmy,d,m,y);
    IF ((m < minmm) OR (m > maxmm)) THEN m := 13; END;
    Str.ItemS(R,tmonths2," ",m-1);
    Str.Prepend(R,separator);
    Str.Prepend(R,using(d,2,pad));
    Str.Append(R,separator);
    Str.Append(R,using(y,4,pad));
    RETURN R;
END fmtDate;

PROCEDURE fmtSize (v : LONGCARD; pad:CHAR; sep:CHAR) : str80;
CONST
    field = 10+3; (* #,###,###,### *) (* what if file is one giga+, eh ? *)
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr(v,S,10,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtSize;

PROCEDURE parseDate (S : ARRAY OF CHAR;
                     VAR dmy : CARDINAL) : BOOLEAN;
CONST
    century = 1900;
CONST
    digits   = "0123456789";
    alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
CONST
    separator=dash;
    legaldateset = digits+separator+alphabet;
VAR
    i,day,month,year : CARDINAL;
    R : str80;
    v : LONGCARD;
    ok: BOOLEAN;
BEGIN
    UpperCase(S); (* in case months would be letters *)
    ReplaceChar(S,slash,separator);
    FOR i := 0 TO (Str.Length(S)-1) DO
        IF Str.CharPos(legaldateset,S[i])=MAX(CARDINAL) THEN RETURN FALSE; END;
    END;
    IF CharCount(S,separator) # 2 THEN RETURN FALSE; END;

    Str.ItemS(R,S,separator,0);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF (v < mindd) OR (v > maxdd) THEN RETURN FALSE; END;
    day := CARDINAL(v);

    Str.ItemS(R,S,separator,1);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN
        Str.Prepend(R,dash); (* fake command line parameter ! *)
        i := GetOptIndex(R,"JAN"+delim+"JAN"+delim+
                           "FEB"+delim+"FEV"+delim+
                           "MAR"+delim+"MAR"+delim+
                           "APR"+delim+"AVR"+delim+
                           "MAY"+delim+"MAI"+delim+
                           "JUN"+delim+"JUN"+delim+
                           "JUL"+delim+"JUI"+delim+
                           "AUG"+delim+"AOU"+delim+
                           "SEP"+delim+"SEP"+delim+
                           "OCT"+delim+"OCT"+delim+
                           "NOV"+delim+"NOV"+delim+
                           "DEC"+delim+"DEC");
        CASE i OF
        | 1..24 :
            v := LONGCARD(i+1) DIV 2;
        ELSE
            RETURN FALSE;
        END;
    END;
    IF (v < minmm) OR (v > maxmm) THEN RETURN FALSE; END;
    month := CARDINAL(v);

    Str.ItemS(R,S,separator,2);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF v < 100 THEN INC(v,century); END;
    IF (v < minyy) OR (v > maxyy) THEN RETURN FALSE; END;
    year := CARDINAL(v);
    dmy:=PackDMY (day,month,year);
    RETURN TRUE;
END parseDate;

(* ------------------------------------------------------------ *)

(* see GetLongCard() in QD_Box *)

PROCEDURE removeOption (VAR R:ARRAY OF CHAR);
VAR
    p:CARDINAL;
BEGIN
    Str.Subst(R,equal,colon); (* command line option xxx= becomes xxx: *)
    p := Str.CharPos(R,colon);
    IF p # MAX(CARDINAL) THEN Str.Delete(R,0,p+1); END;
END removeOption;

PROCEDURE parseSizeRange (S:ARRAY OF CHAR;VAR losize,hisize:LONGCARD ):BOOLEAN ;
VAR
    rc:BOOLEAN;
    p:CARDINAL;
    S1,S2:str128;
BEGIN
    removeOption(S); (* we had gotten an option "$:*" *)
    rc:=FALSE;
    ReplaceChar(S,dash, colon); (* change possible "*-*" range to "*:*" *)
    Str.Subst(S,dotdot,colon);  (* change possible "*..*" range to "*:*" *)
    p:=Str.CharPos(S,colon);
    IF p=MAX(CARDINAL) THEN
        Str.Concat(S1,colon,S);
        rc:=GetLongCard(S1,losize);
        hisize:=losize;                          (* "$" means exact size *)
    ELSE
        Str.Slice(S1,S,0,p); Str.Prepend(S1,colon);
        Str.Delete(S,0,p+1); Str.Concat(S2,colon,S);

        IF same(S1,colon) THEN                   (* ":$" means $ and less *)
            losize:=MIN(LONGCARD); (* complicated ways to mean 0 ! *)
            rc:=GetLongCard(S2,hisize);
        ELSIF same(S2,colon) THEN                (* "$:" means $ and more *)
            hisize:=MAX(LONGCARD);
            rc:=GetLongCard(S1,losize);
        ELSE
            rc:=GetLongCard(S1,losize);
            IF rc THEN rc:=GetLongCard(S2,hisize); END;
        END;
    END;
    IF rc THEN
        rc:=(losize <= hisize); (* safety check *)
    END;
    RETURN rc;
END parseSizeRange;

PROCEDURE wrSizeRange (losize,hisize:LONGCARD);
VAR
    R : str128;
BEGIN
(*
    IF losize = hisize THEN
                        WrLngCard(losize,1);
    ELSE
        WrStr("[");     WrLngCard(losize,1);
        WrStr(dotdot);  WrLngCard(hisize,1);
        WrStr("]");
    END;
*)
    IF losize = hisize THEN
        Str.Copy(R,       fmtSize(losize,blank,coma) );
    ELSE
        Str.Concat(R,"[", fmtSize(losize,blank,coma) );
        Str.Append(R,dotdot);
        Str.Append(R,     fmtSize(hisize,blank,coma) );
        Str.Append(R,"]");
    END;
    ReplaceChar(R,blank,"");
    WrStr(R);
END wrSizeRange;

(* ------------------------------------------------------------ *)

PROCEDURE parseDateRange (S:ARRAY OF CHAR;VAR lodate,hidate:CARDINAL):BOOLEAN;
VAR
    rc:BOOLEAN;
    p:CARDINAL;
    S1,S2:str128;
    d,m,y:CARDINAL;
    dow:Lib.DayType;
BEGIN
    removeOption(S); (* we had gotten an option "$:*" *)
    rc:=FALSE;

    (* not here, because dash can be a date separator ! *)
    (* ReplaceChar(S,dash, colon); (* change possible "*-*" range TO "*:*" *) *)

    Str.Subst(S,dotdot,colon);  (* change possible "*..*" range to "*:*" *)
    p:=Str.CharPos(S,colon);

    IF p=MAX(CARDINAL) THEN
        IF same(S,"*") THEN                      (* today *)
            Lib.GetDate(y,m,d,dow);
            lodate:=PackDMY(d,m,y);
            rc:=TRUE;
        ELSE
            rc:=parseDate(S,lodate);
        END;
        hidate:=lodate;                          (* "$" means same *)
    ELSE
        Str.Slice(S1,S,0,p);
        Str.Delete(S,0,p+1); Str.Copy(S2,S);

        IF same(S1,"") THEN                      (* ":$" means before/on *)
            lodate:=PackDMY(1,1,0000);
            rc:=parseDate(S2,hidate);
        ELSIF same(S2,"") THEN                   (* "$:" means on/after *)
            hidate:=PackDMY(31,12,9999);
            rc:=parseDate(S1,lodate);
        ELSE
            rc:=parseDate(S1,lodate);
            IF rc THEN rc:=parseDate(S2,hidate); END;
        END;
    END;
    IF rc THEN
        rc:=(lodate <= hidate); (* safety check *)
    END;
    RETURN rc;
END parseDateRange;

PROCEDURE wrDateRange (lodate,hidate:CARDINAL);
VAR
    R:str128;
BEGIN
    IF lodate = hidate THEN
        Str.Copy(R,       fmtDate(lodate) );
    ELSE
        Str.Concat(R,"[", fmtDate(lodate) );
        Str.Append(R,dotdot);
        Str.Append(R,     fmtDate(hidate) );
        Str.Append(R,"]");
    END;
    WrStr(R);
END wrDateRange;

(* ------------------------------------------------------------ *)

(*
Seconds are 0 to 29 -- DOS stores nearest even / 2
  hours    minutes   seconds 

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

PROCEDURE fmtTime (timedata:CARDINAL) : str128;
CONST
    hhMask=BITSET{11..15};
    hhShft=11;
    mmMask=BITSET{5..10};
    mmShft=5;
    ssMask=BITSET{0..4};
    ssShft=0;
CONST
    separator = colon;
    padhours = blank;
    pad="0";
VAR
    h,m,s : CARDINAL;
    R : str128;
BEGIN
    h := CARDINAL(BITSET(timedata) * hhMask) >> hhShft;
    m := CARDINAL(BITSET(timedata) * mmMask) >> mmShft;
    s := CARDINAL(BITSET(timedata) * ssMask) >> ssShft;
    s := s << 1; (* FIXED ! yes, yes, "* 2" works too... *)
    Str.Copy(R, using(h,2,padhours) );
    Str.Append(R,separator);
    Str.Append(R,using(m,2,pad));
    Str.Append(R,separator);
    Str.Append(R,using(s,2,pad));
    RETURN R;
END fmtTime;

PROCEDURE fmtFileName ( altdisplay:BOOLEAN; S : ARRAY OF CHAR ) : str128;
VAR
    p : CARDINAL;
    R : str128;
    i : CARDINAL;
BEGIN
    IF Str.CharPos(S,dot) = MAX(CARDINAL) THEN
        Str.Append(S,dot);
    END;

    p := Str.CharPos(S,dot);
    Str.Slice(R,S,0,p);
    FOR i := 1 TO (8-p) DO
        IF altdisplay THEN
            Str.Prepend(R,blank);
        ELSE
            Str.Append(R,blank);
        END;
    END;
    Str.Append(R,dot);
    Str.Delete(S,0,p+1);
    p:=Str.Length(S);
    Str.Append(R,S);
    FOR i := 1 TO (3-p) DO
        Str.Append(R,blank);
    END;
    RETURN R;
END fmtFileName;

PROCEDURE sbool (tf:BOOLEAN;sT,sF:ARRAY OF CHAR):str16;
VAR
    R:str16;
BEGIN
    IF tf THEN
        Str.Copy(R,sT);
    ELSE
        Str.Copy(R,sF);
    END;
    RETURN R;
END sbool;

PROCEDURE fmtAttr (attr:FIO.FileAttr) : str16;
VAR
    S : str16;
BEGIN
    Str.Copy  (S, sbool( (aD IN attr),"D","-") );
    Str.Append(S, sbool( (aR IN attr),"R","-") );
    Str.Append(S, sbool( (aH IN attr),"H","-") );
    Str.Append(S, sbool( (aS IN attr),"S","-") );
    Str.Append(S, sbool( (aA IN attr),"A","-") );
    RETURN S;
END fmtAttr;

(* LFN listing will be a little different from good old DOS *)

PROCEDURE showdata (entry:FIO.DirEntry;root:ARRAY OF CHAR;
                    upperlist,terse,orgcase,altdisplay,paging:BOOLEAN;
                    prependshort,useLFN:BOOLEAN;
                    VAR totalcount:CARDINAL;
                    VAR totalsize:HUGECARD);
VAR
    R,CANON:str1024; (* was str256 but with LFNs, "hey, you never know...", as the lottery ad says : better safe than sorry *)
    longform,shortform:pathtype;
    rc:CARDINAL;
    beautify:BOOLEAN;
    fname:str16; (* good old DOS f8e3 *)
BEGIN
    Str.Copy(CANON,entry.Name);
    Str.Copy(R,     fmtFileName( altdisplay, CANON ));
    Str.Copy(fname, fmtFileName( TRUE,       CANON )); (* force -a here *)
    Str.Prepend(CANON,root);

    beautify:=TRUE;
    IF useLFN THEN
        Str.Copy(shortform,CANON);
        IF w9XshortToLong(shortform,rc,longform) THEN
            Str.Concat(CANON,dquote,longform);Str.Append(CANON,dquote);
            beautify:=FALSE; (* we'll use LFN capitalization without change *)
        END;
    END;
    IF beautify THEN
        IF upperlist THEN (* hey, you never know... *)
            UpperCase(R);
            UpperCase(CANON);
            UpperCase(root);
        ELSE
            LowerCase(R);
            LowerCase(CANON);
            LowerCase(root);
        END;
    END;

    IF terse THEN
        (* ReplaceChar(CANON,blank,""); useless now *)
        Str.Copy(R,CANON);
    ELSE
        IF useLFN THEN
            IF prependshort THEN
                Str.Concat(R,fname,bigsep);
                IF upperlist THEN
                    UpperCase(R);
                ELSE
                    LowerCase(R);
                END;
            ELSE
                Str.Copy(R,"");
            END;
        ELSE
            Str.Append(R,bigsep);
        END;
        Str.Append(R,fmtSize(entry.size,blank,coma));
        Str.Append(R,smallsep);
        Str.Append(R,fmtDate(entry.date));
        Str.Append(R,smallsep);
        Str.Append(R,fmtTime(entry.time));

        Str.Append(R,bigsep);
        IF useLFN THEN
            Str.Append(R,CANON);
        ELSE
            Str.Append(R,root);
        END;
    END;
    dumpline(paging,R);
    INC(totalcount);
    HUGEINC(totalsize, HUGECARD(entry.size) );
END showdata;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ARJ_MAGIC       = 0EA60H;
    ARJ_M_VERSION   = 6; (* ARJ version that supports modified date. *)
CONST
    ZIP_LOCAL_MAGIC = 04034B50H;
    ZIP_SPECIAL_BIT = 08H; (* special case if bit 3 is set *)
CONST
    Z7ZMAGIC1       = 0AFBC7A37H;
    Z7ZMAGIC2       = 01C27H;
CONST
    RARMAGIC1       = 06152H;
    RARMAGIC2       = 072H;
    RARMAGIC3       = 01A21H;
    RARMAGIC4       = 00007H;
    RARFILEHEADER   = 074H;
    RARDIRMASK      = 0E0H; (* bits 7 6 5 = 1 1 1 = file is directory *)
TYPE
    RARcommonType = RECORD      (* comon to all RAR blocks *)
        HEAD_CRC   : CARDINAL;
        HEAD_TYPE  : SHORTCARD;
        HEAD_FLAGS : CARDINAL;
        HEAD_SIZE  : CARDINAL;
        (*
        ADD_SIZE   : LONGCARD;   Optional field - added block size
        Field ADD_SIZE present only if (HEAD_FLAGS & 0x8000) != 0
        Total block size is HEAD_SIZE if (HEAD_FLAGS & 0x8000) == 0
        AND HEAD_SIZE+ADD_SIZE if the field ADD_SIZE is present - when
        (HEAD_FLAGS & 0x8000) != 0.
        *)
    END;

    RARmarkerBlockType = RECORD  (* MARK_HEAD *)
        HEAD_CRC   : CARDINAL;   (* Always 0x6152 *)
        HEAD_TYPE  : SHORTCARD;  (* Header type: 0x72 *)
        HEAD_FLAGS : CARDINAL;   (* Always 0x1a21 *)
        HEAD_SIZE  : CARDINAL;   (* block size = 0x0007 *)
    END;

    RARarchiveHeaderType = RECORD (* MAIN_HEAD *)
        HEAD_CRC : CARDINAL; (*  CRC of fields HEAD_TYPE to RESERVED2 *)
        HEAD_TYPE : SHORTCARD; (*      Header type: 0x73 *)
        HEAD_FLAGS: CARDINAL; (*      Bit flags: *)
                (*
                0x01    - Volume attribute (archive volume)
                0x02    - Archive comment present
                0x04    - Archive lock attribute
                0x08    - Solid attribute (solid archive)
                0x10    - Unused
                0x20    - Authenticity information present
                *)
        HEAD_SIZE : CARDINAL; (*     Archive header total size including archive comments *)
        RESERVED1 : CARDINAL;
        RESERVED2 : LONGCARD;
    END;

    RARfileHeaderType = RECORD (* file IN archive *)
        (*
        HEAD_CRC : CARDINAL; (* CRC of fields from HEAD_TYPE to FILEATTR *)
        HEAD_TYPE: SHORTCARD; (*      Header type: 0x74 *)
        HEAD_FLAGS: CARDINAL; (*  Bit flags: *)
                (*
                0x01 - file continued from previous volume
                0x02 - file continued in next volume
                0x04 - file encrypted with password
                0x08 - file comment present
                0x10 - information from previous files is used (solid flag)
                       (for RAR 2.0 and later)

                bits 7 6 5 (for RAR 2.0 and later)

                     0 0 0    - dictionary size   64 Kb
                     0 0 1    - dictionary size  128 Kb
                     0 1 0    - dictionary size  256 Kb
                     0 1 1    - dictionary size  512 Kb
                     1 0 0    - dictionary size 1024 Kb
                     1 0 1    - reserved
                     1 1 0    - reserved
                     1 1 1    - file is directory

                (HEAD_FLAGS & 0x8000) == 1, because full
                block size is HEAD_SIZE + PACK_SIZE
                *)
        HEAD_SIZE:CARDINAL; (*  File header full size including file name and comments *)
        PACK_SIZE: LONGCARD; (*    Compressed file SIZE *)
        *)
        UNP_SIZE : LONGCARD; (*    Uncompressed file SIZE *)
        HOST_OS : SHORTCARD; (*        Operating system used for archiving *)
                            (*
                       0 - MS DOS
                       1 - OS/2
                       2 - Win32
                       3 - Unix
                       *)
        FILE_CRC:LONGCARD; (*         File CRC *)

        (*
        FTIME : LONGCARD; (*       Date and time in standard MS DOS format *)
        *)
        HMS:CARDINAL;
        DMY:CARDINAL;

        UNP_VER : SHORTCARD; (*         RAR version needed to extract file *)
        METHOD : SHORTCARD; (*          Packing method *)
        NAME_SIZE : CARDINAL; (*       File name SIZE *)
        ATTR : LONGCARD; (*       File attributes *)
        (*
        FILE_NAME : CHAR; (*     File name - string of NAME_SIZE bytes SIZE *)
        *)
    END;


(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    idZIP    = 0;
    idARJ    = 1;
    idLZH    = 2;
    idRAR    = 3;
    id7Z     = 4;
    idNOTARC = MAX(CARDINAL);

VAR
    ioBufferARC : ioBufferType;
    harc:FIO.File; (* globerk *)

PROCEDURE getArcType (detectarchive:BOOLEAN; S:ARRAY OF CHAR):CARDINAL;
CONST
    arcexts = extZIP+delim+extARJ+delim+extLZH+delim+
              extRAR+delim+ext7Z; (* same order as id??? codes *)
VAR
    i,got:CARDINAL;
    R:str16;
    buf:ARRAY [0..10] OF CHAR; (* should do *)
BEGIN
    UpperCase(S); (* should be done but who knows what evil etc. *)
  CASE detectarchive OF
  | FALSE: (* rely on extension *)
    i:=0;
    LOOP
        isoleItemS(R, arcexts, delim, i);
        IF same(R,"") THEN i:=idNOTARC;EXIT; END;
        UpperCase(R);
        IF Str.Pos(S,R) # MAX(CARDINAL) THEN EXIT; END;
        INC(i);
    END;
  | TRUE: (* read enough data to be quite sure of archive TYPE *)
        FOR i:= 0 TO 10 DO buf[i]:=CHR(00H);END;

        i:=idNOTARC;
        harc:=FIO.OpenRead(S);
        FIO.AssignBuffer(harc,ioBufferARC);
        got:=FIO.RdBin(harc,buf,SIZE(buf));
        CASE buf[0] OF
        | "P":
            IF buf[1]="K" THEN i:=idZIP;END;
        | CHR(060H) :
            IF buf[1]=CHR(0EAH) THEN i:=idARJ;END;
        (* //FIXME 7Z *)
        | "7" :
            IF buf[1]="z" THEN
                IF buf[2]=CHR(0BCH) THEN
                    IF buf[3]=CHR(0AFH) THEN
                        IF buf[4]=CHR(27H) THEN
                            IF buf[5]=CHR(1CH) THEN i:=id7Z;END;
                        END;
                    END;
                END;
            END;
        | "R" :
            IF buf[1]="a" THEN
                IF buf[2]="r" THEN
                    IF buf[3]="!" THEN
                       IF buf[4]=CHR(1AH) THEN
                           IF buf[5]=CHR(07H) THEN
                               IF buf[6]=CHR(00H) THEN i:=idRAR;END;
                           END;
                       END;
                    END;
                END;
            END;
        ELSE
            IF ((buf[2+0]="-") AND (buf[2+1]="l") AND (buf[2+4]="-")) THEN i:=idLZH;END;
        END;
        FIO.Close(harc);
  END;
    RETURN i;
END getArcType;

PROCEDURE getb ( VAR b: SHORTCARD ):BOOLEAN;
VAR
    got,len:CARDINAL;
BEGIN
    len:=SIZE(b);
    got:=FIO.RdBin(harc,b,len);
(*%T dbg *) WrLngHex(FIO.GetPos(harc),9);WrCard(CARDINAL(b),9);WrStr(" b");WrLn; (*%E *)
    RETURN (got=len);
END getb;

PROCEDURE getw( VAR w: CARDINAL ):BOOLEAN;
VAR
    got,len:CARDINAL;
BEGIN
    len:=SIZE(w);
    got:=FIO.RdBin(harc,w,len);
(*%T dbg *)  WrLngHex(FIO.GetPos(harc),-9);WrCard(w,-9);WrStr(" w");WrLn; (*%E *)
    RETURN (got=len);
END getw;

PROCEDURE getdw( VAR dw: LONGCARD):BOOLEAN;
VAR
    got,len:CARDINAL;
BEGIN
    len:=SIZE(dw);
    got:=FIO.RdBin(harc,dw,len);
(*%T dbg *)  WrLngHex(FIO.GetPos(harc),-9);WrLngCard(dw,-9);WrStr(" dw");WrLn; (*%E *)
    RETURN (got=len);
END getdw;

PROCEDURE skip (n:CARDINAL):BOOLEAN;
VAR
    got,len:CARDINAL;
    b:SHORTCARD;
BEGIN
    len:=SIZE(b);
    LOOP
        IF n=0 THEN EXIT; END;
        got:=FIO.RdBin(harc,b,len);
        IF got # len THEN RETURN FALSE; END;
        DEC(n);
    END;
    RETURN TRUE;
END skip;

PROCEDURE getcstr (store:BOOLEAN; VAR R : ARRAY OF CHAR   ):BOOLEAN;
VAR
    i,got,len:CARDINAL;
    c:CHAR;
BEGIN
    i:=0;
    len:=SIZE(c);
    LOOP
        got:=FIO.RdBin(harc,c,len);
        IF got # len THEN RETURN FALSE; END;
        IF store THEN R[i]:=c; END;
        IF c=CHR(0) THEN EXIT;END;
        INC(i);
    END;
(*%T dbg *)  IF store THEN WrStr(R);WrLn;END; (*%E *)
    RETURN TRUE;
END getcstr;

PROCEDURE getstr (len:CARDINAL; VAR R : ARRAY OF CHAR   ):BOOLEAN;
VAR
    got:CARDINAL;
BEGIN
    got:=FIO.RdBin(harc,R,len);
    IF got # len THEN RETURN FALSE; END;
    R[len]:=CHR(0);
(*%T dbg *)  WrStr(R);WrLn; (*%E *)
    RETURN TRUE;
END getstr;

PROCEDURE getbuf (count:CARDINAL; VAR R : ARRAY OF BYTE ):BOOLEAN;
VAR
    got:CARDINAL;
BEGIN
    got:=FIO.RdBin(harc,R,count);
    IF got # count THEN RETURN FALSE; END;
    RETURN TRUE;
END getbuf;

PROCEDURE readArcEntry (firsttime:BOOLEAN; id:CARDINAL;
                       VAR orgsize:LONGCARD;VAR dmy,hms:CARDINAL;
                       VAR R:ARRAY OF CHAR):BOOLEAN;
VAR
    got,len,i:CARDINAL;
    compsize,crc,here,anchor,skipme:LONGCARD;
    b,lenlocal,diff:SHORTCARD;
    flag,namelen:CARDINAL;
    thislen,level:SHORTCARD;
    method:ARRAY[0..4] OF CHAR;
    ok1,ok2:BOOLEAN;
VAR
    RARarchiveHeader : RARarchiveHeaderType;
    RARmarker : RARmarkerBlockType;
    RARcommon : RARcommonType;
    RARfileHeader : RARfileHeaderType; (* modified for first fields have been read and name will be after *)
BEGIN
    CASE id OF
    | idZIP :
        IF getdw(here)=FALSE THEN RETURN FALSE;END;
        IF here # ZIP_LOCAL_MAGIC THEN RETURN FALSE;END;

        IF getw(got)=FALSE THEN RETURN FALSE; END;
        IF getw(flag)=FALSE THEN RETURN FALSE; END; (* general purpose bit flag *)
        IF getw(got)=FALSE THEN RETURN FALSE; END;
        IF getw(hms)=FALSE THEN RETURN FALSE; END;
        IF getw(dmy)=FALSE THEN RETURN FALSE; END;
        IF getdw(crc)=FALSE THEN RETURN FALSE;END;
(*%T dbgzip *)  WrStr("crc = ");WrLngHex(crc,9);WrLn; (*%E *)
        IF getdw(compsize)=FALSE THEN RETURN FALSE;END;
(*%T dbgzip *)  WrStr("compsize = ");WrLngHex(compsize,9);WrLn; (*%E *)
        IF getdw(orgsize)=FALSE THEN RETURN FALSE;END;
        IF getw(namelen)=FALSE THEN RETURN FALSE; END;
        IF getw(len)=FALSE THEN RETURN FALSE; END; (* extra field length *)
        IF getstr(namelen,R)=FALSE THEN RETURN FALSE; END;
        IF skip(len)=FALSE THEN RETURN FALSE; END;

        here:=FIO.GetPos(harc);
        INC(here,compsize);
        FIO.Seek(harc,here);
(*%T dbgzip *)  WrStr("seek = ");WrLngHex(here,9);WrLn; (*%E *)
        IF (flag AND ZIP_SPECIAL_BIT) # 0 THEN
(*%T dbgzip *) WrStr("special case : bit 3 ON");WrLn; (*%E  *)
            IF getdw(crc)=FALSE THEN RETURN FALSE;END;
            IF getdw(compsize)=FALSE THEN RETURN FALSE;END;
            IF getdw(orgsize)=FALSE THEN RETURN FALSE;END;
        END;
    | idARJ :
        (* main *)
        IF firsttime THEN
            IF getw(got)=FALSE THEN RETURN FALSE;END;
            IF got # ARJ_MAGIC THEN RETURN FALSE;END;
            IF getw(len)=FALSE THEN RETURN FALSE;END;
            IF len=0 THEN RETURN FALSE; END;
            IF skip(len)=FALSE THEN RETURN FALSE;END;
            IF getdw(crc)=FALSE THEN RETURN FALSE;END;
(*%T dbgarj *)  WrStr("crc = ");WrLngHex(crc,9);WrLn; (*%E *)
            LOOP
                IF getw(len)=FALSE THEN RETURN FALSE;END;
                IF len=0 THEN EXIT;END;
                IF skip(len)=FALSE THEN RETURN FALSE;END;
                IF skip( SIZE(crc) )=FALSE THEN RETURN FALSE;END; (* crc *)
            END;
        END;
        (* local *)
(*%T dbgarj *)  WrStr("archive");WrLn; (*%E *)
        IF getw(got)=FALSE THEN RETURN FALSE;END;
        IF got # ARJ_MAGIC THEN RETURN FALSE;END;

        IF getw(len)=FALSE THEN RETURN FALSE;END;
        IF len=0 THEN RETURN FALSE; END;
        anchor:=FIO.GetPos(harc);
        FOR i:=1 TO 8 DO
            IF getb(b)=FALSE THEN RETURN FALSE;END;
            IF i=1 THEN lenlocal:=b;END;
        END;
        IF getw(hms)=FALSE THEN RETURN FALSE;END;
        IF getw(dmy)=FALSE THEN RETURN FALSE;END;
        IF getdw(compsize)=FALSE THEN RETURN FALSE;END;
        IF getdw(orgsize)=FALSE THEN RETURN FALSE;END;
        IF getdw(crc)=FALSE THEN RETURN FALSE;END;
(*%T dbgarj *)  WrStr("crc = ");WrLngHex(crc,9);WrLn; (*%E *)
        FOR i:=1 TO 2 DO
            IF getw(got)=FALSE THEN RETURN FALSE;END;
        END;
        FOR i:=1 TO 2 DO
            IF getb(b)=FALSE THEN RETURN FALSE;END;
        END;
        diff:=SHORTCARD( FIO.GetPos(harc)-anchor );
(*%T dbgarj  *) WrStr("lenlocal = ");WrCard(CARDINAL(lenlocal),8);WrStr("diff = ");WrCard(CARDINAL(diff),8);WrLn;(*%E  *)
        IF lenlocal > diff THEN
            IF skip( CARDINAL(lenlocal-diff) )=FALSE THEN RETURN FALSE;END;
        END;
        IF getcstr(TRUE,R)=FALSE THEN RETURN FALSE;END;
        IF getcstr(FALSE,R)=FALSE THEN RETURN FALSE;END;
        IF getdw(crc)=FALSE THEN RETURN FALSE;END;
(*%T dbgarj *)  WrStr("crc = ");WrLngHex(crc,9);WrLn; (*%E *)
        LOOP
            IF getw(len)=FALSE THEN RETURN FALSE;END;
            IF len=0 THEN EXIT;END;
            IF skip(len)=FALSE THEN RETURN FALSE;END;
            IF skip( SIZE(crc) )=FALSE THEN RETURN FALSE;END; (* crc *)
        END;
        here:=FIO.GetPos(harc);
        INC(here,compsize);
        FIO.Seek(harc,here);
(*%T dbgarj *)  WrStr("seek = ");WrLngHex(here,9);WrLn; (*%E *)
    | idLZH :
        IF getb(thislen)=FALSE THEN RETURN FALSE;END;
        IF getb(b)=FALSE THEN RETURN FALSE;END;
        IF getstr(5,method)=FALSE THEN RETURN FALSE;END;
        IF method[0] # "-" THEN RETURN FALSE;END;
        IF method[1] # "l" THEN RETURN FALSE;END;
        IF method[4] # "-" THEN RETURN FALSE;END;
        IF getdw(compsize)=FALSE THEN RETURN FALSE; END;
        IF getdw(orgsize)=FALSE THEN RETURN FALSE; END;
        IF getw(hms)=FALSE THEN RETURN FALSE;END;
        IF getw(dmy)=FALSE THEN RETURN FALSE;END;
        IF getb(b)=FALSE THEN RETURN FALSE;END;
        IF getb(level)=FALSE THEN RETURN FALSE;END; (* 0, 1, 2 *)
(*%T dbglzh *) WrStr("level "); WrCard(CARDINAL(level),4); WrLn;(*%E *)
        IF getb(thislen)=FALSE THEN RETURN FALSE;END;
        IF getstr( CARDINAL(thislen),R)=FALSE THEN RETURN FALSE;END;
        IF getw(got)=FALSE THEN RETURN FALSE;END;

        CASE level OF
        | 0 :
            ;
        | 1,2:
            IF getb(b)=FALSE THEN RETURN FALSE;END;
            IF getw(got)=FALSE THEN RETURN FALSE;END;
            IF got # 0 THEN
                LOOP
                    IF skip(got-SIZE(CARDINAL))=FALSE THEN RETURN FALSE; END;
                    IF getw(got)=FALSE THEN RETURN FALSE; END;
                    IF got=0 THEN EXIT;END;
                END;
            END;
            (*
            LOOP
                IF getw(got)=FALSE THEN RETURN FALSE; END;
                IF got=0 THEN EXIT; END;
                IF skip(got)=FALSE THEN RETURN FALSE;END;
            END;
            *)
        ELSE
            RETURN FALSE;
        END;

        here:=FIO.GetPos(harc);
        INC(here,compsize);
        FIO.Seek(harc,here);
    | idRAR:
        IF firsttime THEN
            (* 1. Read and check marker block *)
            (* signature which is, IN fact, a block ! *)
            IF getbuf(SIZE(RARmarker),RARmarker)=FALSE THEN RETURN FALSE;END;

            IF RARmarker.HEAD_CRC   # RARMAGIC1 THEN RETURN FALSE;END;
            IF RARmarker.HEAD_TYPE  # RARMAGIC2 THEN RETURN FALSE;END;
            IF RARmarker.HEAD_FLAGS # RARMAGIC3 THEN RETURN FALSE;END;
            IF RARmarker.HEAD_SIZE  # RARMAGIC4 THEN RETURN FALSE;END;

            (* 2. Read archive header *)
            anchor:=FIO.GetPos(harc);
            IF getbuf(SIZE(RARarchiveHeader),RARarchiveHeader)=FALSE THEN RETURN FALSE;  END;

            (* 3. Read or skip HEAD_SIZE-sizeof(MAIN_HEAD) bytes *)
            here:=LONGCARD(RARarchiveHeader.HEAD_SIZE-SIZE(RARarchiveHeaderType) );
            FIO.Seek(harc,anchor+here);
        END;
        LOOP
            anchor:=FIO.GetPos(harc);
            IF getbuf(SIZE(RARcommon),RARcommon)=FALSE THEN RETURN FALSE;END;
            here:=LONGCARD(RARcommon.HEAD_SIZE);
            IF (RARcommon.HEAD_FLAGS AND 08000H) # 0 THEN
                IF getdw(skipme)=FALSE THEN RETURN FALSE; END;
                INC(here,skipme);
            END;
            ok1:=( RARcommon.HEAD_TYPE = RARFILEHEADER);
            ok2:=( ( RARcommon.HEAD_FLAGS AND RARDIRMASK) # RARDIRMASK ) ;
            IF (ok1 AND ok2) THEN
                IF getbuf(SIZE(RARfileHeader),RARfileHeader) = FALSE THEN RETURN FALSE; END;
                orgsize:=RARfileHeader.UNP_SIZE;
                dmy:=RARfileHeader.DMY;
                hms:=RARfileHeader.HMS;
                IF getstr(RARfileHeader.NAME_SIZE,R)=FALSE THEN RETURN FALSE; END;
                FIO.Seek(harc,anchor+here);
                (* don't show directories *)
                EXIT;
            ELSE
                FIO.Seek(harc,anchor+here);
            END;
        END;
    (* //FIXME 7Z *)
    | id7Z :
        IF firsttime THEN
            IF getdw(here)=FALSE THEN RETURN FALSE;END;
            IF here # Z7ZMAGIC1 THEN RETURN FALSE;END;
            IF getw(got)=FALSE THEN RETURN FALSE;END;
            IF got # Z7ZMAGIC2 THEN RETURN FALSE;END;
            Str.Copy(R,"7z format is unsupported ! ;-(");
            orgsize:= MAX(LONGCARD) ;
            orgsize:= 0;
            dmy:=0;
            hms:=0;
        ELSE
            RETURN FALSE;
        END;
    END;
    ReplaceChar(R,slash,backslash);
    RETURN TRUE;
END readArcEntry;

(* ------------------------------------------------------------ *)

(* format now slightly different with LFNs, see showdata() too *)

PROCEDURE showARCdata (entry:FIO.DirEntry;root:ARRAY OF CHAR;
                       upperlist,detectarchive,orgcase,
                       altdisplay,paging,useLFN,terse:BOOLEAN;
                       VAR totalcountarc:CARDINAL;
                       VAR totalsizearc:HUGECARD);
VAR
    R,R0,CANON,CANONLFN:str1024; (* was str256 but can be very long here : better safe than sorry *)
    sArc:str1024;
    id,dmy,hms:CARDINAL;
    flen:LONGCARD;
    found:BOOLEAN;
    longform,shortform:pathtype;
    rc:CARDINAL;
BEGIN
    Str.Copy(CANON,entry.Name);
    Str.Copy(R, fmtFileName( altdisplay, CANON ));
    Str.Prepend(CANON,root);

    id:=getArcType(detectarchive,CANON);
    IF id = idNOTARC THEN RETURN; END;

    IF useLFN THEN
        Str.Copy(shortform,CANON);
        IF w9XshortToLong(shortform,rc,longform) THEN
            Str.Concat(CANONLFN,dquote,longform);Str.Append(CANONLFN,dquote);
        END;
    END;
    IF upperlist THEN (* hey, you never know... *)
        UpperCase(R);
        UpperCase(CANON);
        UpperCase(root);
    ELSE
        LowerCase(R);
        LowerCase(CANON);
        LowerCase(root);
    END;
    Str.Copy(R0,R); (* showARCdata specific, R0 not used with LFN *)

    harc:=FIO.OpenRead(CANON);
    FIO.AssignBuffer(harc,ioBufferARC);

    found:=readArcEntry(TRUE, id,flen,dmy,hms,sArc);
    WHILE found DO
        IF NOT(orgcase) THEN
            IF upperlist THEN
                UpperCase(sArc);
            ELSE
                LowerCase(sArc);
            END;
        END;
        IF terse THEN
            IF useLFN THEN
                Str.Concat(R,separcprefix,CANONLFN);
            ELSE
                Str.Concat(R,separcprefix,CANON);
            END;
            Str.Append(R,separc);
            Str.Append(R,sArc);
        ELSE
            IF useLFN THEN
                Str.Copy(R,"");
            ELSE
                Str.Concat(R,separcprefix,R0); Str.Append(R,separcsuffix); (* indent *)
            END;
            Str.Append(R,fmtSize(flen,blank,coma));
            Str.Append(R,smallsep);
            Str.Append(R,fmtDate(dmy));
            Str.Append(R,smallsep);
            Str.Append(R,fmtTime(hms));

            Str.Append(R,bigsep);
            IF useLFN THEN
                Str.Append(R,separcprefix);Str.Append(R,CANONLFN);Str.Append(R,separcsuffix);
            END;
            Str.Append(R,separcprefix); (* indent *)
            Str.Append(R,sArc);
        END;

        dumpline(paging,R);
        INC(totalcountarc);
        HUGEINC(totalsizearc, HUGECARD(flen) );
        found:=readArcEntry(FALSE, id,flen,dmy,hms,sArc);
    END;
    FIO.Close(harc);
END showARCdata;

(* ------------------------------------------------------------ *)

PROCEDURE procCmd (useLFN,veryverbose:BOOLEAN;hnd:FIO.File;
                   numauto:CARDINAL;numalpha:str3;
                   udne,cmd:ARRAY OF CHAR );
VAR
    shortform,longform:pathtype;
    u,d,dd,n,e,ext:pathtype; (* was str128 *)
    R:str2048; (* really oversized ! *)
    i,len,rc:CARDINAL;
    ch,lowch:CHAR;
    getting:(grab,gotesc);
    snum:str16;
BEGIN
    IF useLFN THEN
        Str.Copy(shortform,udne);
        IF w9XshortToLong(shortform,rc,longform) THEN
            Lib.SplitAllPath(longform,u,d,n,e);
        ELSE
            Lib.SplitAllPath(shortform,u,d,n,e);
        END;
    ELSE
        Lib.SplitAllPath(udne,u,d,n,e); (* "u:" "\*\" "f" ".e" *) (* handles multiple dots *)
    END;
    Str.Copy(dd,d);
    unfixDirectory(dd);
    Str.Copy(ext,e); Str.Subst(ext,dot,"");
    R:="";
    getting:=grab;
    len := Str.Length(cmd);
    i:=0;
    WHILE i < len DO
        ch := cmd[i];
        CASE getting OF
        | grab :
            IF ch = escch THEN
                getting:=gotesc;
            ELSE
                Str.Append(R,ch);
            END;
        | gotesc:
            lowch:=ch; Str.Lows(ch);
            CASE lowch OF
            | cDollar :  Str.Append(R,dollar);
            | cCRLF:     Str.Append(R,nl);
            | cPercent:  Str.Append(R,percent);
            | cU:        Str.Append(R,u);
            | cD:        Str.Append(R,d);
            | cB:        Str.Append(R,dd);
            | cN:        Str.Append(R,n);
            | cE:        Str.Append(R,ext);
            | cF:        Str.Append(R,n);Str.Append(R,e);
            | cC:        IF useLFN THEN Str.Append(R,dquote);END;
                         Str.Append(R,u);
                         Str.Append(R,d);
                         Str.Append(R,n);Str.Append(R,e);
                         IF useLFN THEN Str.Append(R,dquote);END;
            | cX:        Str.Append(R,udne);
            | cQ:        Str.Append(R,dquote);
            | cPound:    fmtnum(snum,numauto,10,5,"0");Str.Append(R,snum);
            | cQuestion: Str.Append(R,numalpha);
            ELSE
                Str.Append(R,escch); Str.Append(R,ch);
            END;
            getting := grab;
        END;
        INC(i);
    END;
    IF veryverbose THEN WrStr(R);WrLn;END;
    Str.Append(R,nl);
    FIO.WrStr(hnd,R);
END procCmd;

(* ------------------------------------------------------------ *)

TYPE
    options      = (orgcaseX,altdisplayX,pagingX,
                   lowerKaseX,verboseX,veryverboseX,
                   detectarchiveX,terseX,upperlistX,
                   listmodeX,listarcX,
                   sizerangeX,daterangeX,prependshortX);

    setOfOptions = SET OF options;

(* never include zebatch in generated list ! *)

PROCEDURE procDir (useLFN:BOOLEAN; hnd:FIO.File; scanmode:scantype;
                  zebatch:ARRAY OF CHAR;
                  root,spec,cmd:ARRAY OF CHAR;
                  losize,hisize:LONGCARD;
                  lodate,hidate:CARDINAL;
                  theflags:setOfOptions;
                  VAR numalpha:str3; VAR numauto:CARDINAL;
                  VAR totalcount,totalcountarc:CARDINAL;
                  VAR totalsize,totalsizearc:HUGECARD);
VAR
    candy,found,onlydirs,useit,ok:BOOLEAN;
    entry:FIO.DirEntry;
    S,R, currcanonical:str128;
    orgcase,altdisplay,paging:BOOLEAN;
    lowerKase,verbose,veryverbose:BOOLEAN;
    detectarchive,terse,upperlist,prependshort:BOOLEAN;
    listmode,listarc:BOOLEAN;
    sizerange,daterange:BOOLEAN;
BEGIN
    orgcase    :=(orgcaseX IN theflags);
    altdisplay :=(altdisplayX IN theflags);
    paging     :=(pagingX  IN theflags);
    lowerKase  :=(lowerKaseX IN theflags);
    verbose    :=(verboseX IN theflags);
    veryverbose:=(veryverboseX IN theflags);
    detectarchive:=(detectarchiveX IN theflags);
    terse      :=(terseX IN theflags);
    upperlist  :=(upperlistX IN theflags);
    listmode   :=(listmodeX IN theflags);
    listarc    :=(listarcX IN theflags);
    sizerange  :=(sizerangeX IN theflags);
    daterange  :=(daterangeX IN theflags);
    prependshort:=( (prependshortX IN theflags) AND useLFN);

    UpperCase(zebatch); (* unecessary safety but who knows what evil lurks in the hears of canonical paths ? *)

    onlydirs := (scanmode=directoriesonly);

    candy:=(verbose AND NOT(veryverbose) );

    fixDirectory(root);
    IF candy THEN video(root,TRUE); END;
    Str.Concat(S,root,spec);
    found := FIO.ReadFirstEntry(S, everything ,entry); (* was wanted *)
    WHILE found DO

      Str.Concat(currcanonical,root,entry.Name); (* assume we glue "ud\" and "f8e3" *)
      useit:=NOT( same(zebatch,currcanonical) );

      IF daterange THEN
          ok   :=( (entry.date >= lodate) AND (entry.date <= hidate) );
          useit:=( useit AND ok );
      END;

      IF sizerange THEN
          ok   :=( (entry.size >= losize) AND (entry.size <= hisize) );
          useit:=( useit AND ok );
      END;

      CASE scanmode OF
      | special:          ok:=((aH IN entry.attr) OR (aS IN entry.attr));
                          ok:=( ok AND (NOT (aD IN entry.attr)) );
      | normal :          ok:=NOT ((aH IN entry.attr) OR (aS IN entry.attr));
                          ok:=( ok AND (NOT (aD IN entry.attr)) );
      | normalandspecial: ok:=NOT (aD IN entry.attr);
      | directoriesonly:  ok:=(aD IN entry.attr);
      END;
      useit := (useit AND ok);

      IF useit THEN

        IF onlydirs THEN
            IF isDirEntry (entry.Name)=FALSE THEN (* even here, "." and ".." do not apply as directories *)
                IF listmode THEN
                    showdata (entry,root,upperlist,terse,orgcase,altdisplay,
                             paging,prependshort,useLFN,
                             totalcount,totalsize);
                ELSE
                    Str.Concat(R,root,entry.Name);
                    IF lowerKase THEN
                        LowerCase(R);
                    ELSE
                        UpperCase(R); (* should be done already but... *)
                    END;

                    INC(numauto);
                    incalpha(numalpha);

                    procCmd(useLFN,veryverbose,hnd,numauto,numalpha,R,cmd);
                END;
            END;
        ELSE
            IF listmode THEN
                showdata (entry,root,upperlist,terse,orgcase,altdisplay,
                         paging,prependshort,useLFN,
                         totalcount,totalsize);
                IF listarc THEN
                    showARCdata (entry,root,upperlist,detectarchive,
                                orgcase,altdisplay,paging,useLFN,terse,
                                totalcountarc,totalsizearc);
                END;

            ELSE
                Str.Concat(R,root,entry.Name);
                IF lowerKase THEN
                    LowerCase(R);
                ELSE
                    UpperCase(R); (* should be done already but... *)
                END;

                INC(numauto);
                incalpha(numalpha);

                procCmd(useLFN,veryverbose,hnd,numauto,numalpha,R,cmd);
            END;
        END;
      END;
        found :=FIO.ReadNextEntry(entry);
    END;
    IF candy THEN video(root,FALSE); END;
END procDir;

(* ------------------------------------------------------------ *)

PROCEDURE getCli (VAR R : ARRAY OF CHAR);
VAR
    i : CARDINAL;
    S : str256;
BEGIN
    S := "";
    i := 0;
    LOOP
        S[i] := Lib.CommandLine^[i];
        IF S[i] = CHR(0) THEN EXIT; END;
        INC(i);
    END;
    Str.Copy(R,S);
END getCli;

PROCEDURE chkQuotedLastParm (  ):BOOLEAN;
VAR
    i:CARDINAL;
    cli:str128;
BEGIN
    i := 0;
    LOOP
        cli[i] := Lib.CommandLine^[i];
        IF cli[i] = CHR(0) THEN EXIT; END;
        INC(i);
    END;
    IF i=0 THEN RETURN FALSE; END;
    cleantabs(cli);
    LtrimBlanks(cli);
    RtrimBlanks(cli);
    IF cli[Str.Length(cli)-1] # dquote THEN RETURN FALSE; END;
    i:=CharCount(cli,dquote);
    RETURN ( (i >= 2 ) AND NOT ODD(i) ); (* was = before v1.2k *)
END chkQuotedLastParm;

(* ------------------------------------------------------------ *)

CONST           (* "## -                : " *)
    msgDefault   = "Default directory   : ";
    msgBaseDir   =   " - Base directory : ";
    msgSpec      =   " - Specification  : ";
    msgCmd       = "Batch command       : ";
    msgRecurse   = "Recursion           : ";
    msgLowerCase = "LowerCase           : ";

    msgAttributes= "Filter              : ";
    msgDateRange = "Date range          : ";
    msgSizeRange = "Size range          : ";

TYPE
    parmentrytype = RECORD
        basedir : pathtype;
        spec    : pathtype;
    END;
CONST
    firstSpec = 1;
    maxSpec   = 32+1; (* allow for final command *)
VAR
    parmentry : ARRAY [firstSpec..maxSpec] OF parmentrytype;

VAR
    vrows  [00040H:0084H] : SHORTCARD; (* add 1 *)
    spec,cmd,currdir,defaultdir,basedir,zebatch  : str128;
    recurse,echo,addpause:BOOLEAN;
    immediate,killbatch: BOOLEAN;
    newbatch:BOOLEAN;
    losize,hisize:LONGCARD;
    lodate,hidate:CARDINAL;
    totalcount,totalcountarc:CARDINAL;
    totalsize,totalsizearc:HUGECARD;
    hout:FIO.File;
    currdrive:SHORTCARD;
    lastSpec :CARDINAL;
    scanmode:scantype;
    theflags : setOfOptions;
    rc:BOOLEAN;
    paging:BOOLEAN;
    LFNhere,useLFN:BOOLEAN;
    mergemode,wasalive:BOOLEAN;
    numauto:CARDINAL;
    numalpha:str3;
VAR
    parmcount,i,j,opt:CARDINAL;
    S,R:pathtype;
    ATTR:str128;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)

    WrLn; (* here now for ulterior help, error, etc. display *)
(*%T memdebug  *)
    showmem("program start");
(*%E  *)

    recurse   := FALSE;
    echo      := FALSE;
    addpause  := FALSE;
    Str.Copy(zebatch,BATCH);
    immediate  :=FALSE;
    killbatch  :=FALSE;
    newbatch   :=FALSE;
    scanmode   :=normalandspecial;
    totalcount    :=0;
    totalsize     :=HUGEZERO;
    totalcountarc :=0;
    totalsizearc  :=HUGEZERO;
    theflags := setOfOptions{};
    paging   := FALSE;
    useLFN   := TRUE;
    mergemode:= FALSE;

    lastSpec   := firstSpec-1;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,""); END;

    currdrive := FIO.GetDrive(); (* 1=A, etc. *)
    FIO.GetDir(currdrive,currdir); (* we could use 0 for default drive *)
    (* we have unit letter and "\xxx" directory now *)

    Str.Copy(defaultdir,CHR(ORD("A")-1+currdrive));
    Str.Append(defaultdir,colon);
    Str.Append(defaultdir,currdir);
    UpperCase(defaultdir); (* probably useless *)
    fixDirectory(defaultdir);      (* add required trailing "\" *)

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "N"+delim+"NORMAL"+delim+
                                  "Z"+delim+"SPECIAL"+delim+
                                  "D"+delim+"DIRECTORIES"+delim+
                                  "S"+delim+"RECURSE"+delim+
                                  "K"+delim+"LOWERCASE"+delim+
                                  "E"+delim+"ECHO"+delim+
                                  "B:"+delim+"BATCH:"+delim+
                                  "V"+delim+"VERBOSE"+delim+
                                  "VV"+delim+"VERYVERBOSE"+delim+
                                  "I"+delim+"IMMEDIATE"+delim+
                                  "II"+delim+
                                  "D:"+delim+"DATE:"+delim+
                                  "Z:"+delim+"SIZE:"+delim+
                                  "W"+delim+"WAIT"+delim+"PAUSE"+delim+
                                  "L"+delim+"LIST"+delim+
                                  "T"+delim+"TERSE"+delim+
                                  "U"+delim+"UPPERCASE"+delim+
                                  "LL"+delim+"LISTARC"+delim+
                                  "LLL"+delim+
                                  "C"+delim+"ORGCASE"+delim+
                                  "A"+delim+"ALTERNATE"+delim+
                                  "LA"+delim+
                                  "LLA"+delim+
                                  "LLLA"+delim+
                                  "P"+delim+"PAGING"+delim+
                                  "LFN"+delim+"9X"+delim+"X"+delim+
                                  "DIR"+delim+
                                  "DIRS"+delim+
                                  "M"+delim+"MERGE"+delim+"APPEND"+delim+
                                  "LS"+delim+
                                  "??"
                              );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5   : CASE scanmode OF
                      | normalandspecial,normal:
                          scanmode:=normal;
                      ELSE
                          abort(errList,"");
                      END;
            | 6,7   : CASE scanmode OF
                      | normalandspecial,special:
                          scanmode:=special;
                      ELSE
                          abort(errList,"");
                      END;
            | 8,9   : CASE scanmode OF
                      | normalandspecial,directoriesonly:
                          scanmode:=directoriesonly;
                      ELSE
                          abort(errList,"");
                      END;
            | 10,11 : recurse   :=TRUE;
            | 12,13 : INCL(theflags,lowerKaseX);
            | 14,15 : echo      :=TRUE;
            | 16,17 : GetString(R,zebatch);
                      IF Str.Length(zebatch)=0 THEN abort(errBadBatch,S);END;
                      IF Str.CharPos(zebatch,dot)=MAX(CARDINAL) THEN
                          Str.Append(zebatch,extBAT);
                      END;
                      newbatch :=TRUE;
            | 18,19 : INCL(theflags,verboseX);
            | 20,21 : INCL(theflags,verboseX);INCL(theflags,veryverboseX);
            | 22,23 : immediate := TRUE; killbatch := FALSE;
            | 24    : immediate := TRUE; killbatch := TRUE;
            | 25,26 : rc:=parseDateRange(R,lodate,hidate);
                      IF rc=FALSE THEN abort(errDateRange,S);END;
                      INCL(theflags,daterangeX);
            | 27,28 : rc:=parseSizeRange(R,losize,hisize);
                      IF rc=FALSE THEN abort(errSizeRange,S);END;
                      INCL(theflags,sizerangeX);
            | 29,30,31 : addpause:=TRUE;
            | 32,33 : INCL(theflags,listmodeX);
            | 34,35 : INCL(theflags,terseX);
            | 36,37 : INCL(theflags,upperlistX);
            | 38,39 : INCL(theflags,listmodeX);INCL(theflags,listarcX);
            | 40    : INCL(theflags,listmodeX);INCL(theflags,listarcX);INCL(theflags,detectarchiveX);
            | 41,42 : INCL(theflags,orgcaseX);
            | 43,44 : INCL(theflags,altdisplayX);
            | 45:     INCL(theflags,altdisplayX);INCL(theflags,listmodeX)
            | 46:     INCL(theflags,altdisplayX);INCL(theflags,listmodeX);INCL(theflags,listarcX);
            | 47:     INCL(theflags,altdisplayX);INCL(theflags,listmodeX);INCL(theflags,listarcX);INCL(theflags,detectarchiveX);
            | 48,49:  INCL(theflags,pagingX);
            | 50,51,52:  useLFN:=FALSE;
            | 53:     INCL(theflags,listmodeX);INCL(theflags,terseX);
            | 54:     INCL(theflags,listmodeX);INCL(theflags,terseX);recurse:=TRUE;
            | 55,56,57:mergemode:=TRUE;
            | 58:     INCL(theflags,listmodeX); INCL(theflags,prependshortX);
            | 59:     abort(errHelper,"");
            ELSE
                abort(errOption,S);
            END;
        ELSE
           INC(lastSpec);
           IF lastSpec > maxSpec THEN abort(errParameter,S);END;
           Str.Copy(parmentry[lastSpec].spec,S);
        END;
    END;

    LFNhere:=w9XsupportLFN();
    useLFN := ( useLFN AND LFNhere );

    IF (listmodeX IN theflags) THEN
        IF lastSpec < firstSpec THEN abort(errSyntax,"");END; (* not even a filespec *)
        (* IF chkQuotedLastParm() THEN abort(errCmdSyntaxList,"");END; *)
        IF (lowerKaseX IN theflags) THEN abort(errNonsenseList,"");END;
        IF echo THEN abort(errNonsenseList,"");END;
        IF addpause THEN abort(errNonsenseList,"");END;
        IF newbatch THEN abort(errNonsenseList,"");END;
        IF (prependshortX IN theflags) THEN
            IF (listarcX IN theflags) THEN abort(errNonsenseLS,"-ll[l]");END;
            IF (terseX   IN theflags) THEN abort(errNonsenseLS,"-t");END;
        END;
        (*
        IF (verboseX IN theflags) THEN abort(errNonsenseList,"");END;
        IF ( (listarcX IN theflags) AND (terseX IN theflags) ) THEN abort(errNonsenseArc,"");END;
        *)
        IF immediate THEN abort(errNonsenseList,"");END;
        IF (pagingX IN theflags) THEN
            lastRow  := CARDINAL(vrows)+1; (* 25, 43, 50, etc. *)
            rowcount := initpagingcounter;
            IF IsRedirected() THEN EXCL(theflags,pagingX); END;
            paging:=(pagingX IN theflags);
        END;
    ELSE
        IF lastSpec < firstSpec THEN abort(errSyntax,"");END; (* not even a filespec *)
        IF lastSpec = firstSpec THEN abort(errSyntax,"");END; (* filespec without a command *)
        IF chkQuotedLastParm()=FALSE THEN abort(errCmdSyntax,"");END;
        IF (addpause AND immediate) THEN abort(errNonsense,"");END;
        IF (terseX IN theflags) THEN abort(errNonsenseBatch,"");END;
        IF (upperlistX IN theflags) THEN abort(errNonsenseBatch,"");END;
        IF (altdisplayX IN theflags) THEN abort(errNonsenseBatch,"");END;
        IF (orgcaseX IN theflags) THEN abort(errNonsenseBatch,"");END;
        IF (pagingX IN theflags) THEN abort(errNonsenseBatch,"");END;

        Str.Copy(cmd,parmentry[lastSpec].spec);
        DEC(lastSpec);

    END;

    IF recurse THEN
        IF lastSpec # firstSpec THEN abort(errRecursion,"");END;
    END;

    FOR i:=firstSpec TO lastSpec DO
        Str.Copy(spec,parmentry[i].spec);
        UpperCase(spec);
        IF chkSpec(basedir,spec,  LFNhere,defaultdir)=FALSE THEN abort(errBadSpec,spec);END;
        Str.Copy(parmentry[i].basedir,basedir);
        Str.Copy(parmentry[i].spec,spec);
    END;

(*
    IF ( (aD IN wanted) AND recurse ) THEN abort(errNotIfDir,"");END;
*)

IF NOT( listmodeX IN theflags) THEN
    WrStr(Banner);WrLn;
    WrLn;

    IF (verboseX IN theflags) THEN
        WrStr(msgDefault);WrStr(defaultdir);WrLn;
        WrLn;
        FOR i:=firstSpec TO lastSpec DO
            WrCard(i,2);WrStr(msgBaseDir);
            WrStr(parmentry[i].basedir);WrLn;
            WrCard(i,2);WrStr(msgSpec);
            WrStr(parmentry[i].spec);WrLn;
        END;
        WrLn;
        WrStr(msgCmd);WrStr(dquote);WrStr(cmd);WrStr(dquote);WrLn;
        WrLn;
        WrStr(msgRecurse);wrbool(recurse);WrLn;
        WrStr(msgLowerCase);wrbool( (lowerKaseX IN theflags) );WrLn;

        WrStr(msgAttributes);
        CASE scanmode OF
        | normalandspecial: S:="all files, including normal and special";
        | normal:           S:="normal files, excluding hidden or system files";
        | special:          S:="hidden or system files";
        | directoriesonly:  S:="directories only";
        END;
        WrStr(S);WrLn;
        IF (daterangeX IN theflags) THEN WrStr(msgDateRange);wrDateRange(lodate,hidate);WrLn;END;
        IF (sizerangeX IN theflags) THEN WrStr(msgSizeRange);wrSizeRange(losize,hisize);WrLn;END;
        WrLn;
    END;
END;

    IF recurse THEN
(*%T memdebug  *)
    showmem("before buildpathlist");
(*%E  *)
        Str.Copy(spec,parmentry[firstSpec].spec);
        lastPath := BuildPathList (parmentry[firstSpec].basedir);
(*%T memdebug  *)
    showmem("after buildpathlist");
(*%E  *)
        IF lastPath=MAX(CARDINAL) THEN abort(errTooManyDirs,parmentry[firstSpec].basedir);END;
    END;
IF (listmodeX IN theflags) THEN
    hout:=FIO.ErrorOutput; (* dummy *)

(*
    IF ( verboseX IN theflags) THEN
        dumpline(paging,"Files matching specification(s)");
        dumpline(paging,"");
    END;
*)

ELSE
    Str.Prepend(zebatch,defaultdir);
    IF mergemode THEN
        wasalive:=FIO.Exists(zebatch);
        IF wasalive THEN
            hout:=FIO.Append(zebatch);
        ELSE
            hout:=FIO.Create(zebatch);
        END;
    ELSE
        hout:=FIO.Create(zebatch);
    END;
    FIO.AssignBuffer(hout,ioBufferOut);

    IF NOT(mergemode) THEN
        IF echo THEN
            (* IF veryverbose THEN WrStr(cmdechoON);WrLn;WrLn; END; *)
            FIO.WrStr(hout,cmdechoON);
        ELSE
            (* IF veryverbose THEN WrStr(cmdechoOFF);WrLn;WrLn; END; *)
            FIO.WrStr(hout,cmdechoOFF);
        END;
        FIO.WrLn(hout);
    END;

    FIO.WrLn(hout);
    Str.Concat(S,cmdremark,progEXEname);Str.Append(S," ");
    FIO.WrStr(hout,S);
    getCli(S);
    FIO.WrStr(hout,S);FIO.WrLn(hout);
    FIO.WrLn(hout);

    IF addpause THEN
        (* IF veryverbose THEN WrStr(cmdpausefull);WrLn;WrLn; END; *)
        FIO.WrStr(hout,cmdpausefull);FIO.WrLn(hout);FIO.WrLn(hout);
    END;
END;

    numauto:=1-1; (* just in case we would need it *)
    numalpha:=orgnumalpha;

    IF recurse THEN
        FOR i:=firstPath TO lastPath DO
            getentry( i, S );
            procDir( useLFN,hout,scanmode,zebatch,
                     S, spec,cmd,
                     losize,hisize,lodate,hidate,
                     theflags,
                     numalpha,numauto,
                     totalcount,totalcountarc,totalsize,totalsizearc);
        END;
(*%T memdebug  *)
    showmem("before freePathList");
(*%E  *)
        freePathList;
(*%T memdebug  *)
    showmem("after freePathList");
(*%E  *)
    ELSE
        FOR i:=firstSpec TO lastSpec DO
            procDir( useLFN,hout,scanmode,zebatch,
                     parmentry[i].basedir,parmentry[i].spec, cmd,
                     losize,hisize,lodate,hidate,
                     theflags,
                     numalpha,numauto,
                     totalcount,totalcountarc,totalsize,totalsizearc);
        END;
    END;
IF (listmodeX IN theflags) THEN
    IF ( verboseX IN theflags) THEN
        IF totalcount # 0 THEN dumpline(paging,""); END;
        WrCard(totalcount,5);  WrStr(" file(s)"); WrStr("    ");
        (* Str.Copy(S,fmtSize(totalsize,blank,coma)); *)
        Str.Copy(S,fmthc(totalsize,blank,coma));
        WrStr(S);
        dumpline(paging," byte(s)");
        IF ( (listarcX IN theflags) AND (totalcountarc # 0) ) THEN
            WrCard(totalcountarc,5);WrStr(" file(s)");WrStr("    ");
            Str.Copy(S,fmthc(totalsizearc,blank,coma));
            WrStr(S); dumpline(paging," byte(s) in archive(s)");
        END;
    END;
ELSE
    IF (veryverboseX IN theflags) THEN WrLn;END;
    FIO.Flush(hout);
    FIO.Close(hout);
    WrStr(zebatch);WrStr(" has been ");
    IF mergemode THEN
        IF wasalive THEN
            WrStr("updated");
        ELSE
            WrStr("created");
        END;
    ELSE
        WrStr("created");
    END;
    WrStr(".");
    WrLn;

    IF immediate THEN
        WrLn;
        WrStr("::: Running ");WrStr(zebatch);WrLn;
        WrLn;
        i:=Lib.ExecCmd(zebatch);
        WrLn;
        WrStr("::: Batch returned code ");WrCard(i,1);WrLn;
        IF killbatch THEN FIO.Erase(zebatch);END; (* safer WITH mode ! *)
    END;
END;

(*%T memdebug  *)
    showmem("errNone");
(*%E  *)
    abort(errNone,"");
END DirBat.








(*
see unarj.c

     Structure of main header (low order byte first):

     Bytes Description
     ----- -------------------------------------------------------------------
       2   header id (main and local file) = 0x60 0xEA
       2   basic header size (from 'first_hdr_size' thru 'comment' below)
                 = first_hdr_size + strlen(filename) + 1 + strlen(comment) + 1
                 = 0 if end of archive
                 maximum header size is 2600

       1   first_hdr_size (size up to and including 'extra data')
       1   archiver version number
       1   minimum archiver version to extract
       1   host OS   (0 = MSDOS, 1 = PRIMOS, 2 = UNIX, 3 = AMIGA, 4 = MAC-OS)
                     (5 = OS/2, 6 = APPLE GS, 7 = ATARI ST, 8 = NEXT)
                     (9 = VAX VMS, 10 = WIN95, 11 = WIN32)
       1   arj flags
                     (0x01 = GARBLED_FLAG)
                     (0x02 = OLD_SECURED_FLAG) obsolete
                     (0x02 = ANSIPAGE_FLAG) indicates ANSI codepage used by
                                            ARJ32
                     (0x04 = VOLUME_FLAG)   indicates presence of succeeding
                                            volume
                     (0x08 = ARJPROT_FLAG)
                     (0x10 = PATHSYM_FLAG)  indicates archive name translated
                                            ("\" changed to "/")
                     (0x20 = BACKUP_FLAG)   obsolete
                     (0x40 = SECURED_FLAG)
                     (0x80 = ALTNAME_FLAG)  indicates dual-name archive
       1   security version (2 = current)
       1   file type        (must equal 2)
       1   reserved
       4   date time when original archive was created
       4   date time when archive was last modified
       4   archive size (currently used only for secured archives)
       4   security envelope file position
       2   filespec position in filename
       2   length in bytes of security envelope data
       1   encryption version (0 and 1 = old, 2 = new)
                              (3 = reserved)
                              (4 = 40 bit key GOST)
       1   last chapter

       ?   extra data
           1   arj protection factor
           1   arj flags (second series)
                     (0x01 = ALTVOLNAME_FLAG) indicates special volume naming
                                              option
                     (0x02 = reserved bit)
           2   spare bytes

       ?   filename of archive when created (null-terminated string)
       ?   archive comment  (null-terminated string)

       4   basic header CRC

       2   1st extended header size (0 if none)
       ?   1st extended header (currently not used)
       4   1st extended header's CRC (not present when 0 extended header size)


     Structure of local file header (low order byte first):

     Bytes Description
     ----- -------------------------------------------------------------------
       2   header id (main and local file) = 0x60 0xEA
       2   basic header size (from 'first_hdr_size' thru 'comment' below)
                 = first_hdr_size + strlen(filename) + 1 + strlen(comment) + 1
                 = 0 if end of archive
                 maximum header size is 2600

       1   first_hdr_size (size up to and including 'extra data')
       1   archiver version number
       1   minimum archiver version to extract
       1   host OS   (0 = MSDOS, 1 = PRIMOS, 2 = UNIX, 3 = AMIGA, 4 = MAC-OS)
                     (5 = OS/2, 6 = APPLE GS, 7 = ATARI ST, 8 = NEXT)
                     (9 = VAX VMS, 10 = WIN95, 11 = WIN32)
       1   arj flags (0x01 = GARBLED_FLAG) indicates passworded file
                     (0x02 = NOT USED)
                     (0x04 = VOLUME_FLAG)  indicates continued file to next
                                           volume (file is split)
                     (0x08 = EXTFILE_FLAG) indicates file starting position
                                           field (for split files)
                     (0x10 = PATHSYM_FLAG) indicates filename translated
                                           ("\" changed to "/")
                     (0x20 = BACKUP_FLAG)  obsolete
       1   method    (0 = stored, 1 = compressed most ... 4 compressed fastest)
                     (8 = no data, no CRC, 9= no data)
       1   file type (0 = binary,    1 = 7-bit text)
                     (3 = directory, 4 = volume label)
                     (5 = chapter label)
       1   reserved
       4   date time modified
       4   compressed size
       4   original size (this will be different for text mode compression and
                          for split files)
       4   original file's CRC
       2   filespec position in filename
       2   file access mode
       1   first chapter of file's lifespan
       1   last chapter of file's lifespan
       ?   extra data
           4 bytes for extended file position

           the following twelve bytes may be present in ARJ 2.62 and above
           4 bytes for date-time accessed
           4 bytes for date-time created
           4 bytes for original file size even for volumes


       ?   filename (null-terminated string)
       ?   comment  (null-terminated string)

       4   basic header CRC

       2   1st extended header size (0 if none)
       ?   1st extended header (currently not used)
       4   1st extended header's CRC (not present when 0 extended header size)

       ...

       ?   compressed file


     Structure of archive chapter header (low order byte first):

     Bytes Description
     ----- -------------------------------------------------------------------
       2  header id (comment and local file) = 0xEA60 or 60000U
       2  basic header size (from 'first_hdr_size' thru 'comment' below)
                = first_hdr_size + strlen(filename) + 1 + strlen(comment) + 1
                = 0 if end of archive

       1  first_hdr_size (size up to 'extra data')
       1  archiver version number
       1  minimum archiver version to extract
       1  host OS   (0 = MSDOS, 1 = PRIMOS, 2 = UNIX, 3 = AMIGA, 4 = MACDOS)
                    (5 = OS/2, 6 = APPLE GS, 7 = ATARI ST, 8 = NEXT)
                     (9 = VAX VMS, 10 = WIN95, 11 = WIN32)
       1  arj flags (0x01 = GARBLED_FLAG, 0x02 = RESERVED)
                    (0x04 = VOLUME_FLAG,  0x08 = EXTFILE_FLAG)
                    (0x10 = PATHSYM_FLAG,
                    (0x20 = BACKUP_FLAG)   OBSOLETE < 2.50a
                    (0x40 = RESERVED)
       1  method    (0 = stored, 1 = compressed most ... 4 compressed fastest)
       1  file type (0 = binary, 1 = text, 2 = comment header, 3 = directory)
                    (4 = label, 5 = chapter)
       1  ?
       4  date time stamp created
       4  ?
       4  ?
       4  original file's CRC
       2  entryname position in filename
       2  file access mode
       1  chapter range start
       1  chapter range end
       ?  extra data
          4 bytes for extended file position

       ?  filename (null-terminated)
       ?  comment  (null-terminated)

       4  basic header CRC

       2  1st extended header size (0 if none)
       ?  1st extended header
       4  1st extended header's CRC

       ...


     Time stamp format:

        31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16
       |<---- year-1980 --->|<- month ->|<--- day ---->|

        15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
       |<--- hour --->|<---- minute --->|<- second/2 ->|


*)



(*
see appnotes.txt

General Format of a ZIP file
----------------------------

  Files stored in arbitrary order.  Large zipfiles can span multiple
  diskette media.

  Overall zipfile format:

    [local file header + file data + data_descriptor] . . .
    [central directory] end of central directory record


  A.  Local file header:

        local file header signature     LONGCARD  (0x04034b50)
        version needed to extract       CARDINAL
        general purpose bit flag        CARDINAL
        compression method              CARDINAL
        last mod file time              CARDINAL
        last mod file date              CARDINAL
        crc-32                          LONGCARD
        compressed size                 LONGCARD
        uncompressed size               LONGCARD
        filename length                 CARDINAL
        extra field length              CARDINAL

        filename (variable size)
        extra field (variable size)


  B.  Data descriptor:

        crc-32                          LONGCARD
        compressed size                 LONGCARD
        uncompressed size               LONGCARD

      This descriptor exists only if bit 3 of the general
      purpose bit flag is set (see below).  It is byte aligned
      and immediately follows the last byte of compressed data.
      This descriptor is used only when it was not possible to
      seek in the output zip file, e.g., when the output zip file
      was standard output or a non seekable device.

  C.  Central directory structure:

      [file header] . . .  end of central dir record

      File header:

        central file header signature   LONGCARD  (0x02014b50)
        version made by                 CARDINAL
        version needed to extract       CARDINAL
        general purpose bit flag        CARDINAL
        compression method              CARDINAL
        last mod file time              CARDINAL
        last mod file date              CARDINAL
        crc-32                          LONGCARD
        compressed size                 LONGCARD
        uncompressed size               LONGCARD
        filename length                 CARDINAL
        extra field length              CARDINAL
        file comment length             CARDINAL
        disk number start               CARDINAL
        internal file attributes        CARDINAL
        external file attributes        LONGCARD
        relative offset of local header LONGCARD

        filename (variable size)
        extra field (variable size)
        file comment (variable size)

      End of central dir record:

        end of central dir signature    LONGCARD  (0x06054b50)
        number of this disk             CARDINAL
        number of the disk with the
        start of the central directory  CARDINAL
        total number of entries in
        the central dir on this disk    CARDINAL
        total number of entries in
        the central dir                 CARDINAL
        size of the central directory   LONGCARD
        offset of start of central
        directory with respect to
        the starting disk number        LONGCARD
        zipfile comment length          CARDINAL
        zipfile comment (variable size)


  D.  Explanation of fields:

      version made by (CARDINAL)

          The upper byte indicates the compatibility of the file
          attribute information.  If the external file attributes
          are compatible with MS-DOS and can be read by PKZIP for
          DOS version 2.04g then this value will be zero.  If these
          attributes are not compatible, then this value will identify
          the host system on which the attributes are compatible.
          Software can use this information to determine the line
          record format for text files etc.  The current
          mappings are:

          0 - MS-DOS and OS/2 (FAT / VFAT / FAT32 file systems)
          1 - Amiga                     2 - VAX/VMS
          3 - Unix                      4 - VM/CMS
          5 - Atari ST                  6 - OS/2 H.P.F.S.
          7 - Macintosh                 8 - Z-System
          9 - CP/M                     10 - Windows NTFS
         11 thru 255 - unused

          The lower byte indicates the version number of the
          software used to encode the file.  The value/10
          indicates the major version number, and the value
          mod 10 is the minor version number.

      version needed to extract (CARDINAL)

          The minimum software version needed to extract the
          file, mapped as above.

      general purpose bit flag: (CARDINAL)

          Bit 0: If set, indicates that the file is encrypted.

          (For Method 6 - Imploding)
          Bit 1: If the compression method used was type 6,
                 Imploding, then this bit, if set, indicates
                 an 8K sliding dictionary was used.  If clear,
                 then a 4K sliding dictionary was used.
          Bit 2: If the compression method used was type 6,
                 Imploding, then this bit, if set, indicates
                 an 3 Shannon-Fano trees were used to encode the
                 sliding dictionary output.  If clear, then 2
                 Shannon-Fano trees were used.

          (For Method 8 - Deflating)
          Bit 2  Bit 1
            0      0    Normal (-en) compression option was used.
            0      1    Maximum (-ex) compression option was used.
            1      0    Fast (-ef) compression option was used.
            1      1    Super Fast (-es) compression option was used.

          Note:  Bits 1 and 2 are undefined if the compression
                 method is any other.

          Bit 3: If this bit is set, the fields crc-32, compressed size
                 and uncompressed size are set to zero in the local
                 header.  The correct values are put in the data descriptor
                 immediately following the compressed data.  (Note: PKZIP
                 version 2.04g for DOS only recognizes this bit for method 8
                 compression, newer versions of PKZIP recognize this bit
                 for any compression method.)

          The upper three bits are reserved and used internally
          by the software when processing the zipfile.  The
          remaining bits are unused.

      compression method: (CARDINAL)

          (see accompanying documentation for algorithm
          descriptions)

          0 - The file is stored (no compression)
          1 - The file is Shrunk
          2 - The file is Reduced with compression factor 1
          3 - The file is Reduced with compression factor 2
          4 - The file is Reduced with compression factor 3
          5 - The file is Reduced with compression factor 4
          6 - The file is Imploded
          7 - Reserved for Tokenizing compression algorithm
          8 - The file is Deflated
          9 - Reserved for enhanced Deflating
         10 - PKWARE Date Compression Library Imploding

      date and time fields: (2 bytes each)

          The date and time are encoded in standard MS-DOS format.
          If input came from standard input, the date and time are
          those at which compression was started for this data.

      CRC-32: (LONGCARD)

          The CRC-32 algorithm was generously contributed by
          David Schwaderer and can be found in his excellent
          book "C Programmers Guide to NetBIOS" published by
          Howard W. Sams & Co. Inc.  The 'magic number' for
          the CRC is 0xdebb20e3.  The proper CRC pre and post
          conditioning is used, meaning that the CRC register
          is pre-conditioned with all ones (a starting value
          of 0xffffffff) and the value is post-conditioned by
          taking the one's complement of the CRC residual.
          If bit 3 of the general purpose flag is set, this
          field is set to zero in the local header and the correct
          value is put in the data descriptor and in the central
          directory.

      compressed size: (LONGCARD)
      uncompressed size: (LONGCARD)

          The size of the file compressed and uncompressed,
          respectively.  If bit 3 of the general purpose bit flag
          is set, these fields are set to zero in the local header
          and the correct values are put in the data descriptor and
          in the central directory.

      filename length: (CARDINAL)
      extra field length: (CARDINAL)
      file comment length: (CARDINAL)

          The length of the filename, extra field, and comment
          fields respectively.  The combined length of any
          directory record and these three fields should not
          generally exceed 65,535 bytes.  If input came from standard
          input, the filename length is set to zero.


      disk number start: (CARDINAL)

          The number of the disk on which this file begins.

      internal file attributes: (CARDINAL)

          The lowest bit of this field indicates, if set, that
          the file is apparently an ASCII or text file.  If not
          set, that the file apparently contains binary data.
          The remaining bits are unused in version 1.0.

      external file attributes: (LONGCARD)

          The mapping of the external attributes is
          host-system dependent (see 'version made by').  For
          MS-DOS, the low order byte is the MS-DOS directory
          attribute byte.  If input came from standard input, this
          field is set to zero.

      relative offset of local header: (LONGCARD)

          This is the offset from the start of the first disk on
          which this file appears, to where the local header should
          be found.

      filename: (Variable)

          The name of the file, with optional relative path.
          The path stored should not contain a drive or
          device letter, or a leading slash.  All slashes
          should be forward slashes '/' as opposed to
          backwards slashes '\' for compatibility with Amiga
          and Unix file systems etc.  If input came from standard
          input, there is no filename field.

      extra field: (Variable)

          This is for future expansion.  If additional information
          needs to be stored in the future, it should be stored
          here.  Earlier versions of the software can then safely
          skip this file, and find the next file or header.  This
          field will be 0 length in version 1.0.

          In order to allow different programs and different types
          of information to be stored in the 'extra' field in .ZIP
          files, the following structure should be used for all
          programs storing data in this field:

          header1+data1 + header2+data2 . . .

          Each header should consist of:

            Header ID - CARDINAL
            Data Size - CARDINAL

          Note: all fields stored in Intel low-byte/high-byte order.

          The Header ID field indicates the type of data that is in
          the following data block.

          Header ID's of 0 thru 31 are reserved for use by PKWARE.
          The remaining ID's can be used by third party vendors for
          proprietary usage.

          The current Header ID mappings defined by PKWARE are:

          0x0007        AV Info
          0x0009        OS/2
          0x000c        VAX/VMS
          0x000d        reserved for Unix

          Several third party mappings commonly used are:

          0x4b46        FWKCS MD5 (see below)
          0x07c8        Macintosh
          0x4341        Acorn/SparkFS
          0x4453        Windows NT security descriptor (binary ACL)
          0x4704        VM/CMS
          0x470f        MVS
          0x4c41        OS/2 access control list (text ACL)
          0x4d49        Info-ZIP VMS (VAX or Alpha)
          0x5455        extended timestamp
          0x5855        Info-ZIP Unix (original, also OS/2, NT, etc)
          0x6542        BeOS/BeBox
          0x756e        ASi Unix
          0x7855        Info-ZIP Unix (new)
          0xfd4a        SMS/QDOS

          The Data Size field indicates the size of the following
          data block. Programs can use this value to skip to the
          next header block, passing over any data blocks that are
          not of interest.

          Note: As stated above, the size of the entire .ZIP file
                header, including the filename, comment, and extra
                field should not exceed 64K in size.

          In case two different programs should appropriate the same
          Header ID value, it is strongly recommended that each
          program place a unique signature of at least two bytes in
          size (and preferably LONGCARD or bigger) at the start of
          each data area.  Every program should verify that its
          unique signature is present, in addition to the Header ID
          value being correct, before assuming that it is a block of
          known type.

         -OS/2 Extra Field:

          The following is the layout of the OS/2 attributes "extra" block.
          (Last Revision  09/05/95)

          Note: all fields stored in Intel low-byte/high-byte order.


          Value         Size            Description
          -----         ----            -----------
  (OS/2)  0x0009        Short           Tag for this "extra" block type
          TSize         Short           Size for the following data block
          BSize         Long            Uncompressed Block Size
          CType         Short           Compression type
          EACRC         Long            CRC value for uncompress block
          (var)         variable        Compressed block


        The OS/2 extended attribute structure (FEA2LIST) is compressed and then stored
        in it's entirety within this structure.  There will only ever be one "block" of data
        in VarFields[].

         -VAX/VMS Extra Field:

          The following is the layout of the VAX/VMS attributes "extra"
          block.  (Last Revision 12/17/91)

          Note: all fields stored in Intel low-byte/high-byte order.

          Value         Size            Description
          -----         ----            -----------
  (VMS)   0x000c        Short           Tag for this "extra" block type
          TSize         Short           Size of the total "extra" block
          CRC           Long            32-bit CRC for remainder of the block
          Tag1          Short           VMS attribute tag value #1
          Size1         Short           Size of attribute #1, in bytes
          (var.)        Size1           Attribute #1 data
          .
          .
          .
          TagN          Short           VMS attribute tage value #N
          SizeN         Short           Size of attribute #N, in bytes
          (var.)        SizeN           Attribute #N data

          Rules:

          1. There will be one or more of attributes present, which will
             each be preceded by the above TagX & SizeX values.  These
             values are identical to the ATR$C_XXXX and ATR$S_XXXX constants
             which are defined in ATR.H under VMS C.  Neither of these values
             will ever be zero.

          2. No word alignment or padding is performed.

          3. A well-behaved PKZIP/VMS program should never produce more than
             one sub-block with the same TagX value.  Also, there will never
             be more than one "extra" block of type 0x000c in a particular
             directory record.

          - FWKCS MD5 Extra Field:

          The FWKCS Contents_Signature System, used in
          automatically identifying files independent of filename,
          optionally adds and uses an extra field to support the
          rapid creation of an enhanced contents_signature:

              Header ID = 0x4b46
              Data Size = 0x0013
              Preface   = 'M','D','5'
              followed by 16 bytes containing the uncompressed
                  file's 128_bit MD5 hash(1), low byte first.

          When FWKCS revises a zipfile central directory to add
          this extra field for a file, it also replaces the
          central directory entry for that file's uncompressed
          filelength with a measured value.

          FWKCS provides an option to strip this extra field, if
          present, from a zipfile central directory. In adding
          this extra field, FWKCS preserves Zipfile Authenticity
          Verification; if stripping this extra field, FWKCS
          preserves all versions of AV through PKZIP version 2.04g.

          FWKCS, and FWKCS Contents_Signature System, are
          trademarks of Frederick W. Kantor.

          (1) R. Rivest, RFC1321.TXT, MIT Laboratory for Computer
              Science and RSA Data Security, Inc., April 1992.
              ll.76-77: "The MD5 algorithm is being placed in the
              public domain for review and possible adoption as a
              standard."

      file comment: (Variable)

          The comment for this file.

      number of this disk: (CARDINAL)

          The number of this disk, which contains central
          directory end record.

      number of the disk with the start of the central directory: (CARDINAL)

          The number of the disk on which the central
          directory starts.

      total number of entries in the central dir on this disk: (CARDINAL)

          The number of central directory entries on this disk.

      total number of entries in the central dir: (CARDINAL)

          The total number of files in the zipfile.


      size of the central directory: (LONGCARD)

          The size (in bytes) of the entire central directory.

      offset of start of central directory with respect to
      the starting disk number:  (LONGCARD)

          Offset of the start of the central directory on the
          disk on which the central directory starts.

      zipfile comment length: (CARDINAL)

          The length of the comment for this zipfile.

      zipfile comment: (Variable)

          The comment for this zipfile.


  D.  General notes:

      1)  All fields unless otherwise noted are unsigned and stored
          in Intel low-byte:high-byte, low-word:high-word order.

      2)  String fields are not null terminated, since the
          length is given explicitly.

      3)  Local headers should not span disk boundaries.  Also, even
          though the central directory can span disk boundaries, no
          single record in the central directory should be split
          across disks.

      4)  The entries in the central directory may not necessarily
          be in the same order that files appear in the zipfile.

*)



(*


// are level 2 infos valid or not ?


level-0
+------------+
| LZH header |
+------------+
| compressed |
| data       |
+------------+
...

level-1, level-2
+------------+
| LZH header |
+------------+
| extension  |
| header     |
+------------+
| extension  |
| header     |
+------------+
| ...        |
+------------+
| compressed |
| data       |
+------------+
...

level-0
Offset   Length   Contents
  0      1 byte   Size of archived file header (h)
  1      1 byte   Header checksum
  2      5 bytes  Method ID
  7      4 bytes  Compressed size (n)
 11      4 bytes  Uncompressed size
 15      4 bytes  Original file date/time (Generic time stamp)
 19      1 byte   File attribute
 20      1 byte   Level (0x00)
 21      1 byte   Filename / path length in bytes (f)
 22     (f)bytes  Filename / path
 22+(f)  2 bytes  CRC-16 of original file

 24+(f) (n)bytes  Compressed data



level-1
Offset   Length   Contents
  0      1 byte   Size of archived file header (h)
  1      1 byte   Header checksum
  2      5 bytes  Method ID
  7      4 bytes  Compressed size (n)
 11      4 bytes  Uncompressed size
 15      4 bytes  Original file date/time (Generic time stamp)
 19      1 byte   0x20
 20      1 byte   Level (0x01)
 21      1 byte   Filename / path length in bytes (f)
 22     (f)bytes  Filename / path
 22+(f)  2 bytes  CRC-16 of original file

 24+(f)  1 byte   OS ID
 25+(f)  2 bytes  Next header size(x) (0 means no extension header)
[ // Extension headers
         1 byte   Extension type
     (x)-3 bytes  Extension fields
         2 bytes  Next header size(x) (0 means no next extension header)
]*
        (n)bytes  Compressed data



level-2
Offset   Length   Contents
  0      2 byte   Total size of archived file header (h)
  2      5 bytes  Method ID
  7      4 bytes  Compressed size (n)
 11      4 bytes  Uncompressed size
 15      4 bytes  Original file time stamp(UNIX type, seconds since 1970)
 19      1 byte   Reserved
 20      1 byte   Level (0x02)
 21      2 bytes  CRC-16 of original file
 23      1 byte   OS ID
 24      2 bytes  Next header size(x) (0 means no extension header)
[
         1 byte   Extension type
     (x)-3 bytes  Extension fields
         2 bytes  Next header size(x) (0 means no next extension header)
]*
        (n)bytes  Compressed data



Extension header
Common header:
         1 byte   Extension type (0x00)
         2 bytes  CRC-16 of header
        [1 bytes  Information] (Optional)
         2 bytes  Next header size

File name header:
         1 byte   Extension type (0x01)
         ? bytes  File name
         2 bytes  Next header size

Directory name header:
         1 byte   Extension type (0x02)
         ? bytes  Directory name
         2 bytes  Next header size

Comment header:
         1 byte   Extension type (0x3f)
         ? bytes  Comments
         2 bytes  Next header size

UNIX file permission:
         1 byte   Extension type (0x50)
         2 bytes  Permission value
         2 bytes  Next header size

UNIX file group/user ID:
         1 byte   Extension type (0x51)
         2 bytes  Group ID
         2 bytes  User ID
         2 bytes  Next header size

UNIX file group name:
         1 byte   Extension type (0x52)
         ? bytes  Group name
         2 bytes  Next header size

UNIX file user name:
         1 byte   Extension type (0x53)
         ? bytes  User name
         2 bytes  Next header size

UNIX file last modified time:
         1 byte   Extension type (0x54)
         4 bytes  Last modified time in UNIX time
         2 bytes  Next header size



Method ID

    "-lh0-"     No compression
    "-lh1-"     4k sliding dictionary(max 60 bytes) + dynamic Huffman + fixed encoding
                of position
    "-lh2-"     8k sliding dictionary(max 256 bytes) + dynamic Huffman (Obsoleted)
    "-lh3-"     8k sliding dictionary(max 256 bytes) + static Huffman (Obsoleted)
    "-lh4-"     4k sliding dictionary(max 256 bytes) + static Huffman + improved
                encoding of position and trees
    "-lh5-"     8k sliding dictionary(max 256 bytes) + static Huffman + improved
                encoding of position and trees
    "-lzs-"     2k sliding dictionary(max 17 bytes)
    "-lz4-"     No compression
    "-lh6-"     32k sliding dictionary(max 256 bytes) + static Huffman + improved
                encoding of position and trees
    "-lh7-"     64k sliding dictionary + static Huffman
    "-lhd-"     Directory (no compressed data)


Generic time stamp:
 31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16
|<------ year ------>|<- month ->|<---- day --->|

 15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
|<--- hour --->|<---- minute --->|<- second/2 ->|


Offset   Length   Contents
 0       7 bits   year     years since 1980
 7       4 bits   month    [1..12]
11       5 bits   day      [1..31]
16       5 bits   hour     [0..23]
21       6 bits   minite   [0..59]
27       5 bits   second/2 [0..29]

OS ID
    'M'                 MS-DOS
    '2'                 OS/2
    '9'                 OS9
    'K'                 OS/68K
    '3'                 OS/386
    'H'                 HUMAN
    'U'                 UNIX
    'C'                 CP/M
    'F'                 FLEX
    'm'                 Mac
    'R'                 Runser

*)



(*

sig = "R" "a"  "r"  "!"  1aH  07H  00 (not so a sig than a special block !

   Archive file consists of variable length blocks. The order of these
blocks may vary, but the first block must be a marker block followed by
an archive header block.

   Each block begins with the following fields:

HEAD_CRC       2 bytes     CRC of total block or block part
HEAD_TYPE      1 byte      Block type
HEAD_FLAGS     2 bytes     Block flags
HEAD_SIZE      2 bytes     Block size

ADD_SIZE       4 bytes     Optional field - added block size

   Field ADD_SIZE present only if (HEAD_FLAGS & 0x8000) != 0

   Total block size is HEAD_SIZE if (HEAD_FLAGS & 0x8000) == 0
and HEAD_SIZE+ADD_SIZE if the field ADD_SIZE is present - when
(HEAD_FLAGS & 0x8000) != 0.

   In each block the followings bits in HEAD_FLAGS have the same meaning:

  0x4000 - if set, older RAR versions will ignore the block
           and remove it when the archive is updated.
           if clear, the block is copied to the new archive
           file when the archive is updated;

  0x8000 - if set, ADD_SIZE field is present and the full block
           size is HEAD_SIZE+ADD_SIZE.

  Declared block types:

HEAD_TYPE=0x72          marker block
HEAD_TYPE=0x73          archive header
FILEHEADER_HEAD_TYPE=0x74          file header             <== NEEDED
HEAD_TYPE=0x75          comment header
HEAD_TYPE=0x76          extra information
HEAD_TYPE=0x77          subblock
HEAD_TYPE=0x78          recovery record

   Comment block is actually used only within other blocks and doesn't
exist separately.

   Archive processing is made in the following manner:

1. Read and check marker block
2. Read archive header
3. Read or skip HEAD_SIZE-sizeof(MAIN_HEAD) bytes
4. If end of archive encountered then terminate archive processing,
   else read 7 bytes into fields HEAD_CRC, HEAD_TYPE, HEAD_FLAGS,
   HEAD_SIZE.
5. Check HEAD_TYPE.
   In case block read needed:
         if HEAD_TYPE==0x74
           read file header ( first 7 bytes already read )
           read or skip HEAD_SIZE-sizeof(FILE_HEAD) bytes
           read or skip FILE_SIZE bytes
         else
           read corresponding HEAD_TYPE block:
             read HEAD_SIZE-7 bytes
             if (HEAD_FLAGS & 0x8000)
               read ADD_SIZE bytes
   In case block skip needed:
         skip HEAD_SIZE-7 bytes
         if (HEAD_FLAGS & 0x8000)
           skip ADD_SIZE bytes
6. go to 4.


*)





(*

sig = "7" "z"  0BCH 0AFH 27H  1CH


*)








