(* ---------------------------------------------------------------
Title         Q&D Even Odd
Overview      see help
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
Bugs
Wish List     are you kidding ?
              more general a splitter ?
              replace missing bytes with random data in split files ?
              check for target AND split files paths ?

--------------------------------------------------------------- *)

MODULE EvenOdd;

IMPORT Str;
IMPORT Lib;
IMPORT FIO;
IMPORT IO;
IMPORT SYSTEM;

FROM QD_ASCII IMPORT dash, slash, nullchar, tabchar, cr, lf, nl, bs,
space, dot, deg, doublequote, quote, colon, percent, vbar,
blank, equal, dquote, charnull, singlequote, antislash, dollar,
star, backslash, coma, question, underscore, tabul, hbar,
comma, semicolon, diese, pound, openbracket, closebracket, tilde, exclam,
stardotstar, dotdot, escCh, escSet, letters, digits,
lettersUpp, lettersLow, openbrace, closebrace;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits, metaproc, getCli, argc, argv;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileExistsAlt,
fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose, fileFlush, fileSupportLFN;

FROM IO IMPORT WrStr, WrLn;

(* ------------------------------------------------------------ *)

CONST
    progEXEname     = "EVENODD";
    progTitle       = "Q&D EvenOdd";
    progVersion     = "v1.1";
    progCopyright   = "by PhG";
    banner          = progTitle+" "+progVersion+" "+progCopyright;
CONST
    ctrlz           = CHR(26);
CONST
    extEVEN         = ".0"; (* could be .EVN *)
    extODD          = ".1"; (* could be .ODD *)

CONST
    errNone             = 0;
    errHelp             = 1;
    errOption           = 2;
    errParmOverflow     = 3;
    errNotBoth          = 4;
    errMissingCommand   = 5;
    errMissingParms     = 6;
    errSplitSyntax      = 7;
    errNotFound         = 8;
    errReservedExt      = 9;
    errNoJoker          = 10;
    errCollision        = 11;
    errReadOnly         = 12;
    errExists           = 13;
    errNotEO            = 14;
    errNotEOeven        = 15;
    errNotEOodd         = 16;
    errDTmismatch       = 17;
    errNAMEmismatch     = 18;
    errBuildSyntax      = 19;
    errBadDelta         = 20;
    errHeaderMismatch   = 21;
    errFsizeMismatch    = 22;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    placeholder = vbar;
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)

errmsg =
banner+nl+
nl+
"Syntax 1 : "+progEXEname+" <-s> <source> [<evenfile> <oddfile>] [option]..."+nl+
"Syntax 2 : "+progEXEname+" <-c> <target> [<evenfile> <oddfile>] [option]..."+nl+
nl+
"    -s[s[s]] split (-ss = -so = -s -o ; -sss = -sor = -soo = -s -o -r)"+nl+
"    -c[c[c]] create (-cc = -co = -c -o ; -ccc = -cor = -coo = -c -o -r)"+nl+
nl+
"    -o  overwrite (-oo = -o -r)"+nl+
"    -r  ignore read-only attribute"+nl+
"    -i  create headerless split files"+nl+
"    -v  verbose"+nl+
"    -a  alternate final display"+nl+
"    -x  disable LFN support even if available"+nl+
nl+
"This program either saves <source> even and odd bytes to split files,"+nl+
"or creates <target> merging even and odd bytes from split files."+nl+
nl+
"a) Default split files are <source"+extEVEN+"> and <source"+extODD+"> (syntax 1),"+nl+
"   or <target"+extEVEN+"> and <target"+extODD+"> (syntax 2)."+nl+
"   If specified, <evenfile> and <oddfile> have "+extEVEN+" and "+extODD+" default extensions."+nl+
"b) <source> or <target> cannot be more than 2Gb long."+nl+
"b) This program is best used to process compressed and/or encrypted files"+nl+
"   for added security when sending data in two seperate operations."+nl+
nl+
"Examples : "+progEXEname+" -s c:\z\foo.bin"+nl+
"           "+progEXEname+" -s foo.bin pair.dat impair.dat"+nl+
"           "+progEXEname+" -c foo.bin"+nl+
"           "+progEXEname+" -c foo.bin f:\tmp\pair f:\tmp\impair"+nl;

VAR
    S : str1024; (* in case we get a LFN *)
BEGIN
    CASE e OF
    | errHelp :
        WrStr(errmsg);
    | errOption:
        S:="Unknown "+placeholder+" option !";
    | errParmOverflow:
        S := placeholder+" is one parameter too many !";
    | errNotBoth:
        S := "-split and -create commands are mutually exclusive !";
    | errMissingCommand:
        S := "Either -split or -create command must be specified !";
    | errMissingParms:
        S := "No parameter was specified !";
    | errSplitSyntax:
        S := "Illegal syntax for -split command !";
    | errNotFound:
        S:=placeholder+" does not exist !";
    | errReservedExt:
        S:="Illegal reserved extension in "+placeholder+" <source> !";
    | errNoJoker:
        S:=placeholder+" should no contain any joker !";
    | errCollision:
        S := "Filenames cannot be identical !";
    | errReadOnly:
        S:=placeholder+" is read-only !";
    | errExists:
        S:=placeholder+" already exists !";
    | errNotEO :
        S:=placeholder+" is not in expected format !";
    | errNotEOeven:
        S:=placeholder+" does not contain data for even bytes !";
    | errNotEOodd :
        S:=placeholder+" does not contain data for odd bytes !";
    | errDTmismatch:
        S := "Date and time stamps for even and odd bytes do not match !";
    | errNAMEmismatch:
        S := "Filenames for even and odd bytes do not match !";
    | errBuildSyntax:
        S := "Illegal syntax for -create command !";
    | errBadDelta:
        S := "Even split file should be same size as, or one byte larger than, odd split file !";
    | errHeaderMismatch:
        S := "Both even and odd split files must have a header or be headerless !";
    | errFsizeMismatch:
        S := "Filesize for even and odd bytes do not match !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp:
        ;
    ELSE
        Str.Prepend(einfo,dquote);
        Str.Append(einfo,dquote);
        Str.Subst(S,placeholder,einfo);
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
VAR
    ioBuffer1 : ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
    ioBufferE : ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
    ioBufferO : ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
CONST
    dataBufferSize      = 256;
    firstDataBufferByte = 0;
    maxDataBufferByte   = dataBufferSize-1;
    maxBigDataBufferByte= (dataBufferSize*2)-1;
VAR
    databuffer  : ARRAY [firstDataBufferByte..maxBigDataBufferByte] OF BYTE;
    databufferE : ARRAY [firstDataBufferByte..maxDataBufferByte] OF BYTE;
    databufferO : ARRAY [firstDataBufferByte..maxDataBufferByte] OF BYTE;

(* ------------------------------------------------------------ *)

PROCEDURE zesame (S1,S2:ARRAY OF CHAR ):BOOLEAN;
BEGIN
    LowerCaseAlt(S1);
    LowerCaseAlt(S2);
    RETURN same(S1,S2);
END zesame;

PROCEDURE wrq (S:ARRAY OF CHAR);
BEGIN
    WrStr(dquote);WrStr(S);WrStr(dquote);
END wrq;

PROCEDURE dbg (DEBUG:BOOLEAN;S1,S2:ARRAY OF CHAR   );
CONST
    wi = 20;
VAR
    i:CARDINAL;
BEGIN
    IF DEBUG THEN
        IF same(S2,"") THEN
            WrStr("PROC ");
        ELSE
            WrStr("  // ");
        END;
        WrStr(S1);
        IF same(S2,"") THEN
            WrStr("()");
        ELSE
            FOR i:=Str.Length(S1)+1 TO wi DO WrStr(" ");END;
            WrStr(" = ");
            WrStr(S2);
        END;
        WrLn;
    END;
END dbg;

PROCEDURE dmpstr (S1,S2:ARRAY OF CHAR   );
BEGIN
    WrStr(S1);
    WrStr(" : ");
    wrq(S2);WrLn;
END dmpstr;

PROCEDURE dmpbool (S:ARRAY OF CHAR; tf:BOOLEAN );
BEGIN
    WrStr(S);
    WrStr(" : ");
    IF tf THEN
        WrStr("yes");
    ELSE
        WrStr("no");
    END;
    WrLn;
END dmpbool;

(* ------------------------------------------------------------ *)

CONST
    kmagic = 01021963H;
TYPE
    EOheaderType = RECORD
        aeof   : CHAR;
        magic  : LONGCARD;
        orgdt  : LONGCARD;
        orgfsize:LONGCARD;
        isEven : BOOLEAN;
        namelen: CARDINAL;
    END;
    (* original filename follows *)

PROCEDURE getEOheader (VAR H : EOheaderType; VAR Hname:pathtype;
                      DEBUG,useLFN:BOOLEAN;S:pathtype):BOOLEAN;
VAR
    hnd : FIO.File;
    pb,got : CARDINAL;
    Htmp:pathtype;
BEGIN
    dbg(DEBUG,"getEOheader","");
    pb:=0;
    hnd :=fileOpenRead(useLFN,S);
    got:=FIO.RdBin(hnd,H,SIZE(H));
    IF got <> SIZE(H) THEN INC(pb);END;
    IF H.aeof <> ctrlz THEN INC(pb);END;
    IF H.magic <> kmagic THEN INC(pb);END;
    IF pb = 0 THEN
        got:=FIO.RdBin(hnd,Htmp,H.namelen);
        IF got # H.namelen THEN
            INC(pb);
            Str.Copy(Hname,"(* ERROR *)" );
        ELSE
            IF H.namelen < SIZE(pathtype) THEN Htmp[H.namelen]:=nullchar;END;
            Str.Copy(Hname,Htmp);
        END;
    END;
    fileClose(useLFN,hnd);
    dbg(DEBUG,"Hname",Hname);
    RETURN (pb = 0);
END getEOheader;

PROCEDURE buildEOheader (VAR H:EOheaderType;
                        isEven:BOOLEAN;hnd:FIO.File;Hname:pathtype);
BEGIN
    H.aeof     := ctrlz;
    H.magic    := kmagic;
    H.orgdt    := FIO.GetFileDate(hnd);
    H.orgfsize := FIO.Size(hnd);
    H.isEven   := isEven;
    H.namelen  := Str.Length(Hname);
END buildEOheader;

(*
    because of offsets, if filesize is odd, data file for even bytes
    will always be larger than data file for odd bytes : .0 > .1 by one byte
          even odd
    a     a    nada
    ab    a    b
    abc   ac   b
    abcd  ac   bd
*)

PROCEDURE doSplitEO (DEBUG,useLFN,eyecandy,useheader:BOOLEAN;
                     source,datafileEven,datafileOdd:pathtype);
CONST
    msg = "Splitting ";
VAR
    hndIn,hndE,hndO:FIO.File;
    H : EOheaderType;
    i,got,ndxE,ndxO : CARDINAL;
BEGIN
    dbg(DEBUG,"splitEO","");
    dbg(DEBUG,"Source",source);
    dbg(DEBUG,"datafileEven",datafileEven);
    dbg(DEBUG,"datafileOdd",datafileOdd);

    video(msg,TRUE);video(source,TRUE);
    IF eyecandy THEN Work(cmdInit);END;

    hndIn:=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hndIn,ioBuffer1);
    hndE :=fileCreate(useLFN,datafileEven);
    FIO.AssignBuffer(hndE,ioBufferE);
    hndO :=fileCreate(useLFN,datafileOdd);
    FIO.AssignBuffer(hndO,ioBufferO);

    IF useheader THEN
        buildEOheader(H,TRUE, hndIn,source);
        FIO.WrBin(hndE,H,SIZE(H));
        FIO.WrBin(hndE,source,Str.Length(source));

        buildEOheader(H,FALSE,hndIn,source);
        FIO.WrBin(hndO,H,SIZE(H));
        FIO.WrBin(hndO,source,Str.Length(source));
    END;

    FIO.EOF := FALSE;
    LOOP
        IF eyecandy THEN Work(cmdShow);END;
        got:=FIO.RdBin(hndIn,databuffer,dataBufferSize);
        IF got = 0 THEN EXIT; END;
        ndxE:=firstDataBufferByte;
        ndxO:=firstDataBufferByte;
        FOR i:= firstDataBufferByte TO (got-1) DO (* always > 0 here *)
            IF ODD(i) THEN
                databufferO[ndxO]:=databuffer[i];
                INC(ndxO);
            ELSE
                databufferE[ndxE]:=databuffer[i];
                INC(ndxE);
            END;
        END;
        IF ndxE > firstDataBufferByte THEN
            FIO.WrBin(hndE,databufferE,ndxE);
        END;
        IF ndxO > firstDataBufferByte THEN
            FIO.WrBin(hndO,databufferO,ndxO);
        END;

        IF got # dataBufferSize THEN EXIT; END;
    END;

    fileClose(useLFN,hndE);
    fileClose(useLFN,hndO);
    fileClose(useLFN,hndIn);

    IF eyecandy THEN Work(cmdStop);END;
    video(source,FALSE);video(msg,FALSE);
END doSplitEO;

PROCEDURE doRebuildEO (DEBUG,useLFN,eyecandy,useheader:BOOLEAN;
                       datafileEven,datafileOdd,target:pathtype);
CONST
    msg = "Building ";
VAR
    hndE,hndO,hndOut:FIO.File;
    H : EOheaderType;
    i,p,gotEv,gotOd : CARDINAL;
    Htmp,HEname,HOname:pathtype;
BEGIN
    dbg(DEBUG,"rebuildEO","");
    dbg(DEBUG,"Target",target);
    dbg(DEBUG,"datafileEven",datafileEven);
    dbg(DEBUG,"datafileOdd",datafileOdd);

    video(msg,TRUE);video(target,TRUE);
    IF eyecandy THEN Work(cmdInit);END;

    hndOut:=fileCreate(useLFN,target);
    FIO.AssignBuffer(hndOut,ioBuffer1);
    hndE  :=fileOpenRead(useLFN,datafileEven);
    FIO.AssignBuffer(hndE,ioBufferE);
    hndO  :=fileOpenRead(useLFN,datafileOdd);
    FIO.AssignBuffer(hndO,ioBufferO);

    IF useheader THEN
        i := FIO.RdBin(hndE,H,SIZE(H));
        i := FIO.RdBin(hndE,Htmp,H.namelen);
        IF H.namelen < SIZE(pathtype) THEN Htmp[H.namelen]:=nullchar;END;
        Str.Copy(HEname,Htmp);

        i := FIO.RdBin(hndO,H,SIZE(H));
        i := FIO.RdBin(hndO,Htmp,H.namelen);
        IF H.namelen < SIZE(pathtype) THEN Htmp[H.namelen]:=nullchar;END;
        Str.Copy(HOname,Htmp);
    END;

    FIO.EOF := FALSE;
    LOOP
        IF eyecandy THEN Work(cmdShow);END;

        gotEv:=FIO.RdBin(hndE,databufferE,dataBufferSize);
        IF gotEv = 0 THEN EXIT; END;
        gotOd:=FIO.RdBin(hndO,databufferO,dataBufferSize);
        IF gotOd = 0 THEN EXIT; END;

        p := firstDataBufferByte;
        FOR i:=0 TO (gotEv-1) DO
            databuffer[p]:=databufferE[i];
            INC(p,2);
        END;
        p := firstDataBufferByte;
        INC(p);
        FOR i:=0 TO (gotOd-1) DO
            databuffer[p]:=databufferO[i];
            INC(p,2);
        END;

        FIO.WrBin(hndOut,databuffer,gotEv+gotOd);

        IF gotEv # dataBufferSize THEN EXIT; END;
        IF gotOd # dataBufferSize THEN EXIT; END;
    END;
    (* there can be only one pending even byte now *)
    IF gotEv = 1 THEN FIO.WrBin(hndOut,databufferE[0],gotEv);END;

    fileClose(useLFN,hndE);
    fileClose(useLFN,hndO);
    fileClose(useLFN,hndOut);

    IF useheader THEN
        hndOut := fileOpen(useLFN,target);
        FIO.SetFileDate(hndOut,H.orgdt);
        fileClose(useLFN,hndOut);
    END;

    IF eyecandy THEN Work(cmdStop);END;
    video(target,FALSE);video(msg,FALSE);
END doRebuildEO;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE getExtension (S:pathtype):pathtype;
VAR
    u,d,n,e:pathtype;
BEGIN
    Lib.SplitAllPath(S,u,d,n,e);
    RETURN e;
END getExtension;

CONST
    alwaysforceNEWEXT = 1;
    forceNEWEXTifNone = 2;

PROCEDURE buildnewfilename (VAR R:pathtype;
                           S:pathtype;ext:ARRAY OF CHAR; DEBUG:BOOLEAN;how:CARDINAL);
VAR
    u,d,n,e,ne:pathtype;
BEGIN
    dbg(DEBUG,"buildnewfilename","");
    dbg(DEBUG,"S",S);
    Lib.SplitAllPath(S,u,d,n,e);
    CASE how OF
    | alwaysforceNEWEXT:
        dbg(DEBUG,"how","alwaysforceNEWEXT");
        Lib.MakeAllPath(R,u,d,n,ext);
    | forceNEWEXTifNone:
        dbg(DEBUG,"how","forceNEWEXTifNone");
        Lib.MakeAllPath(ne,"","",n,e);
        IF Str.RCharPos(ne,dot)=MAX(CARDINAL) THEN (* no extension *)
            Lib.MakeAllPath(R,u,d,n,ext);
        ELSE
            Str.Copy(R,S);
        END;
    END;
    dbg(DEBUG,"R",R);
END buildnewfilename;

PROCEDURE chkFile (S:pathtype;useLFN,OVERWRITE,IGNORERO:BOOLEAN):CARDINAL ;
VAR
    rc : CARDINAL;
BEGIN
    rc := errNone;
    IF fileExists(useLFN,S) THEN
        IF OVERWRITE THEN
            IF fileIsRO(useLFN,S) THEN
                IF IGNORERO THEN
                    fileSetRW(useLFN,S);
                    fileErase(useLFN,S);
                ELSE
                    rc := errReadOnly;
                END;
            ELSE
                fileErase(useLFN,S);
            END;
        ELSE
            rc := errExists;
        END;
    END;
    RETURN rc;
END chkFile;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    minparm = 1;
    maxparm = 3;
CONST
    ndxfile = minparm;
    ndxeven = minparm+1;
    ndxodd  = minparm+2;
VAR
    lastparm,parmcount,i,opt,rc : CARDINAL;
    S,R                : pathtype;
    parm : ARRAY [minparm..maxparm] OF pathtype;
    cmd                : (undefined,split,create);
    DEBUG,useLFN,OVERWRITE,IGNORERO,EYECANDY,USEHEADER,altdisplay : BOOLEAN;
    source,datafileEven,datafileOdd,target:pathtype;
    HE,HO : EOheaderType;
    HEname,HOname:pathtype;
    HEheader,HOheader:BOOLEAN;
    HEfsize,HOfsize:LONGCARD;
    Z:str1024;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    WrLn;

    DEBUG     := FALSE;
    useLFN    := TRUE;
    OVERWRITE := FALSE;
    IGNORERO  := FALSE;
    EYECANDY  := FALSE;
    USEHEADER := TRUE;
    altdisplay:= FALSE;

    cmd       := undefined;

    lastparm := minparm-1;
    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S); cleantabs(R);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "S"+delim+"SPLIT"+delim+
                                   "B"+delim+"BUILD"+delim+
                                   "O"+delim+"OVERWRITE"+delim+
                                   "R"+delim+"READONLY"+delim+
                                   "OO"+delim+
                                   "V"+delim+"VERBOSE"+delim+
                                   "I"+delim+"NOHEADER"+delim+
                                   "X"+delim+"LFN"+delim+
                                   "DEBUG"+delim+
                                   "C"+delim+"CREATE"+delim+
                                   "SS"+delim+"SO"+delim+
                                   "SSS"+delim+"SOR"+delim+"SOO"+delim+
                                   "CC"+delim+"CO"+delim+
                                   "CCC"+delim+"COR"+delim+"COO"+delim+
                                   "A"+delim+"ALTERNATE"
                               );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5:
                IF cmd=create THEN abort(errNotBoth,"");END;
                cmd := split;
            | 6,7:
                IF cmd=split THEN abort(errNotBoth,"");END;
                cmd := create;
            | 8,9:
                OVERWRITE := TRUE;
            | 10,11:
                IGNORERO := TRUE;
            | 12:
                OVERWRITE := TRUE;
                IGNORERO := TRUE;
            | 13,14:
                EYECANDY := TRUE;
            | 15,16:
                USEHEADER := FALSE;
            | 17,18:
                useLFN    := FALSE;
            | 19:
                DEBUG := TRUE;
            | 20,21:
                IF cmd=split THEN abort(errNotBoth,"");END;
                cmd := create;

            | 22,23:
                IF cmd=create THEN abort(errNotBoth,"");END;
                cmd := split;
                OVERWRITE := TRUE;
            | 24,25,26:
                IF cmd=create THEN abort(errNotBoth,"");END;
                cmd := split;
                OVERWRITE := TRUE;
                IGNORERO := TRUE;
            | 27,28:
                IF cmd=split THEN abort(errNotBoth,"");END;
                cmd := create;
                OVERWRITE := TRUE;
            | 29,30,31:
                IF cmd=split THEN abort(errNotBoth,"");END;
                cmd := create;
                OVERWRITE := TRUE;
                IGNORERO := TRUE;
            | 32,33:
                altdisplay := TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errParmOverflow,S);END;
            parm[lastparm]:=S;
        END;
    END;
    IF cmd   = undefined THEN abort(errMissingCommand,"");END;
    IF lastparm < minparm THEN abort(errMissingParms,"");END;

    useLFN := (useLFN AND fileSupportLFN() );

    CASE cmd OF
    | split:
        CASE lastparm OF
        | minparm+1:
            abort(errSplitSyntax,"");
        ELSE
            source:=parm[ndxfile];
            IF chkJoker(source) THEN abort(errNoJoker,source);END;
            S:=getExtension(source);
            IF (zesame(S,extEVEN) OR zesame(S,extODD)) THEN abort(errReservedExt,source);END;
            IF fileExists(useLFN,source)=FALSE THEN abort(errNotFound,source);END;

            IF lastparm = minparm THEN
                buildnewfilename(datafileEven, source,extEVEN,DEBUG,alwaysforceNEWEXT);
                buildnewfilename(datafileOdd,  source,extODD,DEBUG,alwaysforceNEWEXT);
            ELSE
                buildnewfilename(datafileEven, parm[ndxeven],extEVEN,DEBUG,forceNEWEXTifNone);
                buildnewfilename(datafileOdd,  parm[ndxodd],extODD,DEBUG,forceNEWEXTifNone);
                IF chkJoker(datafileEven) THEN abort(errNoJoker,datafileEven);END;
                IF chkJoker(datafileOdd) THEN abort(errNoJoker,datafileOdd);END;
            END;
            IF zesame(source,datafileEven) THEN abort(errCollision,"");END;
            IF zesame(source,datafileOdd) THEN abort(errCollision,"");END;
            IF zesame(datafileEven,datafileOdd) THEN abort(errCollision,"");END;
        END;
        rc :=chkFile(datafileEven,useLFN,OVERWRITE,IGNORERO);
        IF rc # errNone THEN abort(rc,datafileEven);END;
        rc :=chkFile(datafileOdd,useLFN,OVERWRITE,IGNORERO);
        IF rc # errNone THEN abort(rc,datafileOdd);END;

        WrStr(banner);WrLn;
        WrLn;

        doSplitEO(DEBUG,useLFN,EYECANDY,USEHEADER,source,datafileEven,datafileOdd);

        IF altdisplay THEN
            Z:='+++ "|" was split to "|" and "|"';
            Str.Subst(Z,vbar,source);
            Str.Subst(Z,vbar,datafileEven);
            Str.Subst(Z,vbar,datafileOdd);
            WrStr(Z);WrLn;

            IF USEHEADER=FALSE THEN
                WrLn;
                WrStr("::: Note split files have been created headerless !");WrLn;
            END;
        ELSE
            dmpstr ("::: Source    ",source);
            dmpstr ("+++ Even bytes",datafileEven);
            dmpstr ("+++ Odd bytes ",datafileOdd);
            dmpbool("::: Header    ",USEHEADER);
        END;

    | create:
        CASE lastparm OF
        | minparm+1:
            abort(errBuildSyntax,"");
        ELSE
            target:=parm[ndxfile];
            IF chkJoker(target) THEN abort(errNoJoker,target);END;
            (*
            S:=getExtension(S);
            IF (zesame(S,dot) OR zesame(S,"")) THEN
            ELSE
            END;
            *)
            IF lastparm = minparm THEN
                buildnewfilename(datafileEven, target,extEVEN,DEBUG,alwaysforceNEWEXT);
                buildnewfilename(datafileOdd, target,extODD,DEBUG,alwaysforceNEWEXT);
            ELSE
                buildnewfilename(datafileEven, parm[ndxeven],extEVEN,DEBUG,forceNEWEXTifNone);
                buildnewfilename(datafileOdd, parm[ndxodd],extODD,DEBUG,forceNEWEXTifNone);
                IF chkJoker(datafileEven) THEN abort(errNoJoker,datafileEven);END;
                IF chkJoker(datafileOdd) THEN abort(errNoJoker,datafileOdd);END;
            END;
            IF zesame(target,datafileEven) THEN abort(errCollision,"");END;
            IF zesame(target,datafileOdd) THEN abort(errCollision,"");END;
            IF zesame(datafileEven,datafileOdd) THEN abort(errCollision,"");END;
        END;

        IF fileExists(useLFN,datafileEven)=FALSE THEN abort(errNotFound,datafileEven);END;
        HEheader:= getEOheader(HE,HEname, DEBUG,useLFN,datafileEven);
        IF HEheader THEN
            IF HE.isEven=FALSE THEN abort(errNotEOeven,datafileEven);END;
        END;

        IF fileExists(useLFN,datafileOdd)=FALSE THEN abort(errNotFound,datafileOdd);END;
        HOheader:= getEOheader(HO,HOname, DEBUG,useLFN,datafileOdd);
        IF HOheader THEN
            IF HO.isEven THEN abort(errNotEOodd,datafileOdd);END;
        END;

        HEfsize:=fileGetFileSize(useLFN,datafileEven);
        HOfsize:=fileGetFileSize(useLFN,datafileOdd);

        IF (HEfsize = (HOfsize+1)) OR (HEfsize = HOfsize) THEN
            ;
        ELSE
            abort(errBadDelta,"");
        END;

        IF HEheader # HOheader THEN abort(errHeaderMismatch,"");END;

        USEHEADER := (HEheader AND HOheader);
        IF USEHEADER THEN
            IF HE.orgdt # HO.orgdt THEN abort(errDTmismatch,"");END;
            IF HE.orgfsize # HO.orgfsize THEN abort(errFsizeMismatch,"");END;
            IF zesame(HEname,HOname)=FALSE THEN abort(errNAMEmismatch,"");END;

            buildnewfilename(target, target,getExtension(HEname),DEBUG,forceNEWEXTifNone);
        END;

        rc :=chkFile(target,useLFN,OVERWRITE,IGNORERO);
        IF rc # errNone THEN abort(rc,target);END;

        WrStr(banner);WrLn;
        WrLn;

        doRebuildEO(DEBUG,useLFN,EYECANDY,USEHEADER,datafileEven,datafileOdd,target);

        IF altdisplay THEN
            Z:='+++ "|" was created from "|" and "|"';
            Str.Subst(Z,vbar,target);
            Str.Subst(Z,vbar,datafileEven);
            Str.Subst(Z,vbar,datafileOdd);
            WrStr(Z);WrLn;
        ELSE
            dmpstr ("::: Even bytes",datafileEven);
            dmpstr ("::: Odd bytes ",datafileOdd);
            dmpstr ("+++ Target    ",target);
        END;

    END;

    abort(errNone,"");
END EvenOdd.
