(* ---------------------------------------------------------------
Title         Q&D free space on hard disk(s)
Author        PhG
Overview
Notes         minimal error messages and checking, etc.
Bugs          even with HUGECARDs, formula does not work with > 4 Gb disks !
              we don't care about CD-ROM and removeable units

              XP claims any unit is invalid and does not support DPB :
              could not find the reason why
              anyway XP is so console-hostile we just give up
              (besides, WE don't do XP, but only DOS and 98SE, so why bother ?)
              we just add a warning in help screen
              note that from XP, getunitfreetotal() is ok for small disks
              but nonsense for huge ones !

Wish List     are you kidding ? but well, isn't it already a joke
              to write such a little DOS (f)utility nowadays ? :-(
              well, should have thought of concatenated units syntax

              model is small but QD_LFN could use a better one...

              Mb and Gb would benefit from 3 digits after comma

--------------------------------------------------------------- *)

MODULE HDfree;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;
IMPORT SYSTEM;
IMPORT IO;

(* filter out duplicates found IN QD_TEXT *)
FROM QD_ASCII IMPORT dash, slash, nullchar, tabchar, (* cr, lf, nl, *)
space, dot, deg, doublequote, quote, colon, percent, vbar,
(* bs, *) blank, equal, dquote, charnull, singlequote, antislash, dollar,
star, backslash, coma, question, underscore, tabul, hbar,
comma, semicolon, diese, pound,
stardotstar, dotdot, escCh, escSet, letters, digits;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits, metaproc, getCli, argc, argv;

FROM QD_Text IMPORT
colortype, cursorshapetype, scrolltype,
ff, cr, lf, bs, tab, nl,
BW40, CO40, BW80, CO80, CO80x43, CO80x50, MONO,
vesa80x60, vesa132x25, vesa132x43, vesa132x50, vesa132x60,
selectCursorEmulation,
setCursorShape,
handleVesa, setBrightPaper, setBlinkMode,
setFillChar, setFillInk, setFillPaper,
setFillInkPaper, setTxtInk, setTxtPaper, setTxtInkPaper, setWrapMode,
setUseBiosMode, setTabWidth, getScreenData, setWindow,
setMode, restoreMode,
gotoXY, xyToHtabVtab, home, setVisualPage, setActivePage,
scrollWindow, fillTextAttr, cls, writeStr, writeLn, getScreenWidth,
getScreenHeight, getScreenMinX, getScreenMinY, getScreenMaxX, getScreenMaxY,
getMinHtab, getMaxHtab, getMinVtab, getMaxVtab,
initScreenConsole,
findInkPaperAtStartup, getInkAtStartup, getPaperAtStartup;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XsupportLFN;

(* ------------------------------------------------------------ *)

TYPE
    HUGECARD = LONGREAL;
CONST
    HUGEZERO = LONGREAL(0.0);
CONST
    CONSOLE = TRUE; (* if FALSE, do not use QD_Text library *)

(*%F CONSOLE  *)

PROCEDURE vidinit ( useBios:BOOLEAN );
BEGIN
END vidinit;

PROCEDURE print (S : ARRAY OF CHAR  );
BEGIN
    IO.WrStr(S);
END print;

PROCEDURE newline (  );
BEGIN
    IO.WrLn;
END newline;

PROCEDURE colorheader ();
BEGIN
END colorheader;

PROCEDURE colorhelp ();
BEGIN
END colorhelp;

PROCEDURE colortext ();
BEGIN
END colortext;

PROCEDURE colorwarning ();
BEGIN
END colorwarning;

(*%E  *)

(*%T CONSOLE  *)

PROCEDURE vidinit ( useBios:BOOLEAN  );
BEGIN
    (* handleVesa; *) (* useless, because we won't change video mode *)
    setUseBiosMode ( useBios );
    findInkPaperAtStartup();
END vidinit;

PROCEDURE print (S : ARRAY OF CHAR  );
BEGIN
    writeStr(S);
END print;

PROCEDURE newline (  );
BEGIN
    writeLn;
END newline;

PROCEDURE colorhelp ();
BEGIN
    setTxtInk(getInkAtStartup());      (* was green *)
    setTxtPaper(getPaperAtStartup());  (* was black *)
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colorhelp;

PROCEDURE colorheader ();
BEGIN
    setTxtInk(yellow);
    setTxtPaper(black);
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colorheader;

PROCEDURE colortext ();
BEGIN
    setTxtInk(cyan);
    setTxtPaper(black);
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colortext;

PROCEDURE colorwarning ();
BEGIN
    setTxtInk(red);
    setTxtPaper(white);
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colorwarning;

(*%E  *)

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "HDFREE";
    ProgTitle     = "Q&D free space on hard disk(s)";
    ProgVersion   = "v1.0k";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    extEXE        = ".EXE";
    extINI        = ".INI";
    chUsed        = CHR(176);  chUsedTxt = "+";
    chFree        = CHR(219);  chFreeTxt = "-";
    sigma         = CHR(228);
    graphdash     = CHR(196);
    graphbar      = CHR(205);
    msgWarning    = "Remember results include lost clusters and DELWATCHed files !";
CONST
    errNone             = 0;
    errHelp             = 1;
    errOption           = 2;
    errBadUnitSpec      = 3;
    errTooManyUnits     = 4;
    errAlreadySpecified = 5;
    errNotFound         = 6;
    errNoUnitSpecified  = 7;
    errPoorDOSsupportHere=8;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" <u[u]...>:... [option]..."+nl+
nl+
"This program shows free space left on specified hard disk(s)."+nl+
nl+
"-i    show unit(s) geometry"+nl+
"-w    add warning to report"+nl+
"-q    quiet mode (no percentage bar graph)"+nl+
"-s    do not show sum of all disks"+nl+
"-a[a] do not use graphics separator lines (-aa = -a -t)"+nl+
"-t    do not use graphics characters in bar graph"+nl+
"-u    show used space instead of free space"+nl+
"-k[k] show rounded kilobytes (-kk = -rk = mathematical kilobytes)"+nl+
"-m[m] show rounded megabytes (-mm = -rm = mathematical megabytes)"+nl+
"-g[g] show rounded gigabytes (-gg = -rg = mathematical gigabytes)"+nl+
"-e    english group and decimal separators (default is french separators)"+nl+
"-x    disable FAT32 support even if available"+nl+
(*%T CONSOLE  *)
"-b    monochrome BIOS output (no colors)"+nl+
(*%E  *)
nl+
"a) If program is run without any parameter, command line will be read from"+nl+
"   "+ProgEXEname+extINI+", if such a file exists in "+ProgEXEname+extEXE+" directory."+nl+
"b) From Win 9X, program will call DOS interrupt $21 with AX=$7303 ;"+nl+
"   if -x option was specified, it will be with regular AH=$36."+nl+
"c) From Win XP, program will abort (required DOS functions are not available)."+nl+
"d) Results include lost clusters and DELWATCHed files (DR-DOS and Novell DOS)."+nl+
"e) Warning : results will not be significant for CD-ROM and network drives."+nl;
VAR
    S : str256;
BEGIN
    colorhelp;
    CASE e OF
    | errHelp :
        newline;
        print(msgHelp);
    | errOption :
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errBadUnitSpec:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," unit specification !");
    | errTooManyUnits:
        Str.Concat(S,"Overflow with ",einfo);Str.Append(S," unit specification !");
    | errAlreadySpecified:
        Str.Concat(S,"Duplicate ",einfo);Str.Append(S," unit specification !");
    | errNotFound:
        Str.Concat(S,"File ",einfo);Str.Append(S," does not exist !");
    | errNoUnitSpecified:
        S := "No unit specified !";
    | errPoorDOSsupportHere:
        S := "required DOS functions are no longer supported with WinXP ! :-(";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp :
        ;
    ELSE
        newline;
        print(ProgEXEname+" : "); print(S);
        newline;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE str (v:LONGCARD;wi:CARDINAL   ) : str16;
VAR
    S:str16;
    ok:BOOLEAN;
BEGIN
    Str.CardToStr( v,S,10,ok);
    WHILE Str.Length(S) < wi DO
        Str.Prepend(S," ");
    END;
    RETURN S;
END str;

(* ------------------------------------------------------------ *)

TYPE
    extendedFreeSpaceType = RECORD
        strucsize                : CARDINAL;
        version                  : CARDINAL; (* called with 0 *)
        sectorsPerCluster        : LONGCARD; (* adjusted for compression *)
        bytesPerSector           : LONGCARD;
        freeClusters             : LONGCARD; (* availableClusters *)
        totalClusters            : LONGCARD;
        availablePhysicalSectors : LONGCARD; (* not adjusted for compression *)
        totalPhysicalSectors     : LONGCARD; (* not adjusted for compression *)
        availableAllocationUnits : LONGCARD; (* not adjusted for compression *)
        totalAllocationUnits     : LONGCARD; (* not adjusted for compression *)
        reserved                 : ARRAY [1..8] OF BYTE;
    END;

(* u should be UPPERCASE but we handle it anyway *)

PROCEDURE getUnitFreeTotal (DEBUG,assumeFAT32,verbose:BOOLEAN; u:CHAR;
                           VAR freebytes,totalbytes:HUGECARD):BOOLEAN;
CONST
    wiinfo = 9; (* was 5 for P233 2Gb drive, but with P4 15Gb... *)
VAR
    r : SYSTEM.Registers;
    sectorsPerCluster, freeClusters, bytesPerSector, totalClusters,v : LONGCARD;
    S           : str128;
    i,count     : CARDINAL;
    strucFAT32  : extendedFreeSpaceType;
    unitFAT32   : str16; (* oversized *)
BEGIN
    u:=CAP(u);
    freebytes  :=HUGEZERO;
    totalbytes :=HUGEZERO;

    IF assumeFAT32 THEN
        Str.Concat(unitFAT32,u,colon+backslash);
        unitFAT32[Str.Length(unitFAT32)]:=charnull; (* safety for ASCIZ *)
        strucFAT32.version:=0;

        r.AX := 07303H;  (* FAT32 - GET EXTENDED FREE SPACE ON DRIVE *)
        r.DS := Seg( unitFAT32 );
        r.DX := Ofs( unitFAT32 );
        r.ES := Seg( strucFAT32 );
        r.DI := Ofs( strucFAT32 );
        r.CX := SIZE(strucFAT32);
        Lib.Dos(r);
        IF DEBUG = FALSE THEN
            IF (SYSTEM.CarryFlag IN r.Flags) THEN RETURN FALSE; END;
        END;
        sectorsPerCluster := strucFAT32.sectorsPerCluster;
        freeClusters      := strucFAT32.freeClusters;
        bytesPerSector    := strucFAT32.bytesPerSector;
        totalClusters     := strucFAT32.totalClusters;

        freebytes := HUGECARD(bytesPerSector);
        totalbytes:= HUGECARD(bytesPerSector);
        freebytes := freebytes  * HUGECARD(strucFAT32.availablePhysicalSectors);
        totalbytes:= totalbytes * HUGECARD(strucFAT32.totalPhysicalSectors);
    ELSE
        r.AH := 036H;  (* DOS 2+ - GET FREE DISK SPACE *)
        r.DL := BYTE( ORD(u)-ORD("A")+1 ); (* $00=default, $01=A:, etc. *)
        Lib.Dos(r);
        IF DEBUG = FALSE THEN
            IF r.AX = 0FFFFH THEN RETURN FALSE; END;
        END;
        sectorsPerCluster := LONGCARD(r.AX); (* IF $FFFF, invalid drive *)
        freeClusters      := LONGCARD(r.BX);
        bytesPerSector    := LONGCARD(r.CX);
        totalClusters     := LONGCARD(r.DX);

        freebytes  := HUGECARD(sectorsPerCluster) * HUGECARD(bytesPerSector);
        totalbytes := HUGECARD(sectorsPerCluster) * HUGECARD(bytesPerSector);
        freebytes  := freebytes  * HUGECARD(freeClusters);
        totalbytes := totalbytes * HUGECARD(totalClusters);
    END;

    IF verbose THEN (* unit was a valid one *)
        newline;
        newline;
        IF assumeFAT32 THEN
            count:=8;
        ELSE
            count:=4;
        END;
        FOR i:=1 TO count DO
            CASE i OF
            | 1: v:=bytesPerSector;    S:="bytes per sectors  ";
            | 2: v:=sectorsPerCluster; S:="sectors per cluster";
            | 3: v:=totalClusters;     S:="total clusters     ";
            | 4: v:=freeClusters;      S:="free clusters      ";
            | 5: v:=strucFAT32.availablePhysicalSectors;
                                       S:="available sectors  ";
            | 6: v:=strucFAT32.totalPhysicalSectors;
                                       S:="total sectors      ";
            | 7: v:=strucFAT32.availableAllocationUnits;
                                       S:="free allocation    ";
            | 8: v:=strucFAT32.totalAllocationUnits;
                                       S:="total allocation   ";
            END;
            Str.Prepend(S,"    ");Str.Append(S," : ");
            Str.Append(S,str(v,wiinfo));
            print (S);newline;
        END;
    END;
    RETURN TRUE;
END getUnitFreeTotal;

(* ------------------------------------------------------------ *)

TYPE
    DOS_DriveParameterBlockType = RECORD
        driveNum          : BYTE;     (* drive number (00h = A:, 01h = B:, etc) *)
        unitNumber        : BYTE;     (* unit number within device driver *)
        bytesPerSector    : CARDINAL; (* bytes per sector *)
        highestSectNum    : BYTE;     (* highest sector number within a cluster *)
        shiftCount        : BYTE;     (* shift count to convert clusters into sectors *)
        reservedSectors   : CARDINAL; (* number of reserved sectors at beginning of drive *)
        numberOfFATs      : BYTE;     (* number of FATs *)
        rootentries       : CARDINAL; (* number of root directory entries *)
        userdatafirstsector:CARDINAL; (* number of first sector containing user data *)
        highestclusterNum : CARDINAL; (* highest cluster number (number of data clusters + 1)
                                      16-bit FAT if greater than 0FF6h, else 12-bit FAT *)
        (* DOS 4.0-6.0 specific *)
        sectorsPerFAT     : CARDINAL; (* number of sectors per FAT *)
        firstdirsector    : CARDINAL; (* sector number of first directory sector *)
        devdrvaddr        : LONGCARD; (* address of device driver header *)
        mediaID           : BYTE;     (* media ID BYTE *)

        busydisk          : BYTE;     (* 00h if disk accessed, FFh if NOT *)
        nextDPBptr        : LONGCARD; (* pointer to next DPB *)
        searchfromcluster : CARDINAL; (* cluster at which to start search for free space when writing,
                                      usually the last cluster allocated *)
        freeClusters      : CARDINAL; (* number of free clusters on drive, FFFFh = unknown *)
    END;

    FSItype = RECORD
        sig : LONGCARD;          (* signature 61417272h *)
        freeclusters : LONGCARD; (* number of free clusters (FFFFFFFFh if unknown) *)
        lastallocated: LONGCARD; (* most recently allocated cluster *)
        rsv : ARRAY [0..11] OF BYTE;
    END;

    extDPBbufferType = RECORD
        datalen           : CARDINAL; (* must be $3D *)

        (* now is extended DPB structure beginning with 24 bytes OF DOS DPB *)
        driveNum          : BYTE;     (* drive number (00h = A:, 01h = B:, etc) *)
        unitNumber        : BYTE;     (* unit number within device driver *)
        bytesPerSector    : CARDINAL; (* bytes per sector *)
        highestSectNum    : BYTE;     (* highest sector number within a cluster *)
        shiftCount        : BYTE;     (* shift count to convert clusters into sectors *)
        reservedSectors   : CARDINAL; (* number of reserved sectors at beginning of drive *)
        numberOfFATs      : BYTE;     (* number of FATs *)
        rootentries       : CARDINAL; (* number of root directory entries *)
        userdatafirstsector:CARDINAL; (* number of first sector containing user data *)
        highestclusterNum : CARDINAL; (* highest cluster number (number of data clusters + 1)
                                      16-bit FAT if greater than 0FF6h, else 12-bit FAT *)
        sectorsPerFAT     : CARDINAL; (* number of sectors per FAT *)
        firstdirsector    : CARDINAL; (* sector number of first directory sector *)
        devdrvaddr        : LONGCARD; (* address of device driver header *)
        mediaID           : BYTE;     (* media ID BYTE *)

        (* extension begins here at offset $18  *)
        dpb_flags         : BYTE;     (* undocumented : FFh force media check *)
        fsiPtr            : LONGCARD; (* pointer to next DPB *)
        searchfromcluster : CARDINAL; (* cluster at which to start search for free space when writing,
                                      usually the last cluster allocated *)

        freeClustersLo    : CARDINAL; (* number of free clusters on drive, FFFFh = unknown *)
        freeClustersHi    : CARDINAL; (* high word of free cluster count *)
        (* freeClustersLoHi  : LONGCARD; *)

        FATflag           : CARDINAL; (* active FAT/mirroring
                                      bit 7: do not mirror active FAT to inactive FATs
                                      bits 6-4: reserved (0)
                                      bits 3-0: the 0-based FAT number of the active FAT
                                      (only meaningful if mirroring disabled) *)
        FSinfosector      : CARDINAL; (* sector number of file system information sector, or
                                      FFFFh for none *)
        backupbootsector  : CARDINAL; (* sector number of backup boot sector, or FFFFh for none *)
        firstclustersector: LONGCARD; (* first sector number of the first cluster *)
        maxCluster        : LONGCARD; (* maximum cluster number *)
        FATinSectors      : LONGCARD; (* number of sectors occupied by FAT *)
        rootdircluster    : LONGCARD; (* cluster number of start of root directory *)
        freespacecluster  : LONGCARD; (* cluster number at which to start searching for free space *)
    END;

(* u should be UPPERCASE but we handle it anyway -- DOS 4.0+ assumed *)

PROCEDURE getUnitDPB (DEBUG,assumeFAT32,verbose:BOOLEAN; u:CHAR;
                     VAR freebytes,totalbytes:HUGECARD):BOOLEAN;
CONST
    wiinfo = 9; (* was 5 for P233 2Gb drive, but with P4 15Gb... *)
VAR
    r : SYSTEM.Registers;
    S       : str128;
    i       : CARDINAL;
    a       : FarADDRESS;
    DOS_DPB : DOS_DriveParameterBlockType;
    extDPBbuffer: extDPBbufferType;
    sectorsPerCluster, freeClusters, bytesPerSector, totalClusters,v : LONGCARD;
BEGIN
    u:=CAP(u);
    freebytes  :=HUGEZERO;
    totalbytes :=HUGEZERO;

    IF assumeFAT32 THEN
        i:= SIZE(extDPBbufferType) - SIZE (extDPBbuffer.datalen);
        extDPBbuffer.datalen := i;
        r.AX := 07302H; (* FAT32 - "Get_ExtDPB" - GET EXTENDED DPB *)
        r.DL := BYTE( ORD(u)-ORD("A")+1 ); (* $00=default, $01=A:, etc. *)
        r.ES := Seg(extDPBbuffer);
        r.DI := Ofs(extDPBbuffer);
        r.CX := SIZE(extDPBbuffer); (* 3Fh *)
        r.SI := 0F1A6H;             (* undocumented *)
        Lib.Dos(r);
        IF DEBUG=FALSE THEN
            IF (SYSTEM.CarryFlag IN r.Flags) THEN RETURN FALSE; END; (* AX = error code, 0018h bad buffer length *)
        END;

        bytesPerSector    := LONGCARD( extDPBbuffer.bytesPerSector);
        sectorsPerCluster := LONGCARD( 1 << CARDINAL( extDPBbuffer.shiftCount) );
        totalClusters     := extDPBbuffer.maxCluster;
        DEC(totalClusters);

        (* nonsense ! *)

        freeClusters      := LONGCARD(extDPBbuffer.freeClustersHi) << 16;
                             INC(freeClusters,LONGCARD(extDPBbuffer.freeClustersLo));
    ELSE
        r.AH := 032H; (* DOS 2+ - GET DOS DRIVE PARAMETER BLOCK FOR SPECIFIC DRIVE *)
        r.DL := BYTE( ORD(u)-ORD("A")+1 ); (* $00=default, $01=A:, etc. *)
        Lib.Dos(r);
        IF DEBUG=FALSE THEN
            IF r.AL # 00H THEN RETURN FALSE; END; (* FF = invalid or network drive *)
        END;
        a:=[ r.DS:r.BX ];
        Lib.FarMove( a, FarADR(DOS_DPB),SIZE (DOS_DPB) );

        totalClusters     := LONGCARD(DOS_DPB.highestclusterNum);
        DEC(totalClusters);
        freeClusters      := LONGCARD(DOS_DPB.freeClusters);

    END;

    IF verbose THEN (* unit was a valid one *)
        newline;
        newline;
        FOR i:=1 TO 4 DO
            CASE i OF
            | 1: v:=bytesPerSector;    S:="bytes per sectors  ";
            | 2: v:=sectorsPerCluster; S:="sectors per cluster";
            | 3: v:=totalClusters;     S:="total clusters     ";
            | 4: v:=freeClusters;      S:="free clusters      ";
            END;
            Str.Prepend(S,"    ");Str.Append(S," : ");
            Str.Append(S,str(v,wiinfo));
            print (S);newline;
        END;
    END;
    RETURN TRUE;
END getUnitDPB;

(* ------------------------------------------------------------ *)

PROCEDURE getsepgroup (fr:BOOLEAN ):CHAR;
BEGIN
    IF fr THEN RETURN dot; END;
    RETURN comma;
END getsepgroup;

PROCEDURE getsepdec (fr:BOOLEAN ):CHAR;
BEGIN
    IF fr THEN RETURN comma; END;
    RETURN dot;
END getsepdec;

(* ------------------------------------------------------------ *)

PROCEDURE fmtstring (S:ARRAY OF CHAR; pad:CHAR; n:INTEGER ) : str80;
VAR
    R : str80;
BEGIN
    Str.Copy(R,S);
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(n) THEN EXIT; END;
        IF n < 0 THEN
            Str.Append(R,pad); (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtstring;

PROCEDURE fmtlc (v : LONGCARD; pad:CHAR; sep:CHAR; field:INTEGER) : str80;
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr(v,S,10,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtlc;

PROCEDURE fmtpercent (v:LONGREAL;pad:CHAR;sep:CHAR;field:INTEGER;digits:CARDINAL):str80;
VAR
    R : str80;
    ok: BOOLEAN;
BEGIN
    Str.FixRealToStr(v,digits,R,ok);
    Str.Subst(R,dot,sep);
    RETURN fmtstring(R,pad,field);
END fmtpercent;

PROCEDURE fmtbar (percentused:LONGREAL;used,free:CHAR;field:CARDINAL):str80;
VAR
    R : str80;
    p,i : CARDINAL;
BEGIN
    percentused := (percentused / 100.0 ) * LONGREAL(field);
    p := CARDINAL(percentused + 0.5 ); (* round ! *)
    R := "";
    FOR i := 1 TO field DO
        IF i <= p THEN
           Str.Append(R,used);
        ELSE
           Str.Append(R,free);
        END;
    END;
    RETURN R;
END fmtbar;

PROCEDURE HUGEINC (VAR r:HUGECARD;n:HUGECARD );
BEGIN
    r := r + n;
END HUGEINC;

PROCEDURE fmthc (v : HUGECARD; pad:CHAR; sepgroup:CHAR; field:INTEGER) : str80;
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.FixRealToStr( LONGREAL(v), 0 ,S,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sepgroup);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmthc;

PROCEDURE fmthcdec (v : HUGECARD; pad:CHAR; sepgroup:CHAR; field:INTEGER; zedigits:CARDINAL) : str80;
VAR
    S,R   : str80;
    len,i,p,zelen,wi : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
    isfr:BOOLEAN;
    sepdec : CHAR;
    Z:str16;
BEGIN
    Str.FixRealToStr( LONGREAL(v), zedigits ,S,ok);

    len:=Str.Length(S);
    R := "";
    wi:=CARDINAL ( ABS(field) );

    p:=Str.CharPos(S,dot);
    IF p # MAX(CARDINAL ) THEN
        zelen := p;
        DEC(wi, 1+zedigits ); (* sepdec and digits after *)
    ELSE
        zelen := len;
    END;

    FOR i := 1 TO zelen DO
        Str.Prepend(R,S[zelen-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sepgroup);
            END;
        END;
    END;

    LOOP
        IF Str.Length(R) >= wi THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    IF p # MAX(CARDINAL) THEN
        isfr := (sepgroup = getsepgroup(TRUE) );
        sepdec:=getsepdec(isfr);
        Str.Append(R,sepdec);
        Str.Slice( Z, S,p+1,len-p);
        Str.Append(R,Z);
    END;
    RETURN R;
END fmthcdec;

CONST
    kKB       = HUGECARD (1024);
    kMB       = HUGECARD (kKB * kKB);
    kGB       = HUGECARD (kMB * kKB);
    krealKB   = HUGECARD (1000);
    krealMB   = HUGECARD (krealKB * krealKB);
    krealGB   = HUGECARD (krealMB * krealKB);
TYPE
    showAsType = (bytes, kilobytes, megabytes, gigabytes,
                 realkilobytes, realmegabytes, realgigabytes);

PROCEDURE fmthcAs (v : HUGECARD; pad:CHAR; sep:CHAR; field:INTEGER;
                  as : showAsType) : str80;
VAR
    R : str80;
    z : str16;
    ugly : INTEGER;
    di: HUGECARD;
BEGIN
    CASE as OF
    | bytes :         z:=""   ; di := HUGECARD(1);
    | kilobytes :     z:=" Kb"; di := kKB;
    | megabytes :     z:=" Mb"; di := kMB;
    | gigabytes :     z:=" Gb"; di := kGB;
    | realkilobytes : z:=" kB"; di := krealKB;
    | realmegabytes : z:=" mB"; di := krealMB;
    | realgigabytes : z:=" gB"; di := krealGB;
    END;
    ugly := Str.Length(z);
    v:= v / di;
    CASE as OF
    | bytes,kilobytes,realkilobytes:
        Str.Concat(R, fmthc   (v,pad,sep,field-ugly), z); (* yes, suffix here is a really ugly hack *)
    ELSE
        Str.Concat(R, fmthcdec(v,pad,sep,field-ugly,1), z); (* yes, suffix here is a really ugly hack *)
    END;
    RETURN R;
END fmthcAs;

(* ------------------------------------------------------------ *)

(* ripped from QD_Box *)

PROCEDURE runFromWinXP (  ):BOOLEAN;
CONST
    WinXPconsoleMajor = 5;
    WinXPconsoleMinor = 50;
VAR
    major,minor:CARDINAL;
BEGIN
    w9XgetTrueDOSversion (major,minor);
    IF major = WinXPconsoleMajor THEN
        IF minor = WinXPconsoleMinor THEN RETURN TRUE; END; (* risky business ! *)
    END;
    RETURN FALSE;
END runFromWinXP;

CONST
    allletters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

(* assume S is already in uppercase *)

PROCEDURE isUnitSpec ( S : ARRAY OF CHAR ) : BOOLEAN;
BEGIN
    IF Str.Length(S) # 2 THEN RETURN FALSE; END; (* not xx *)
    IF S[1] # colon THEN RETURN FALSE; END;      (* not x: *)
    RETURN Str.CharPos(allletters, CAP(S[0]) ) # MAX(CARDINAL);
END isUnitSpec;

PROCEDURE isConcatenatedUnits (S:ARRAY OF CHAR   ):CARDINAL ;
VAR
    i,len,rc : CARDINAL;
BEGIN
    rc:=MAX(CARDINAL);
    len:=Str.Length(S);
    IF len < 2 THEN RETURN rc; END; (* "?:" or more required *)
    IF S[len-1] # colon THEN RETURN rc; END;
    FOR i:=1 TO len-1 DO
        IF Str.CharPos(allletters, CAP(S[i-1]) ) = MAX(CARDINAL) THEN RETURN rc;END;
    END;
    RETURN (len-1);
END isConcatenatedUnits;

(* ------------------------------------------------------------ *)

CONST
    (*
                "u:    ###,###,###,###  ###,###,###,###  ###,#  ###,#  "
                "----  ---------------  ---------------  -----  -----  --------------------"
    *)
    sHeader1a = "Unit             Free            Total  %Used  %Free";
    sHeader1b =                                                     "  Used=$        Free=$";
    sHeader2a = "----  ---------------  ---------------  -----  -----";
    sHeader2b =                                                     "  --------------------";
    sInvalid  =       "                                                ** INVALID DRIVE! **";
    chsymbol  = "$";
    chdash    = "-";
    sFree     = "Free"; (* same as sHeader1a *)
    sUsed     = "Used"; (* same length as sFree *)
    wihuge    = 12+3;   (* digits and inner commas *)
    wipercent = 3+1+1;
    wibar     = 20;
    zedigits  = 1;
CONST
    firstUnit = 1;
    maxUnit   = 26; (* A..Z at most *)
VAR
    unit      : ARRAY [firstUnit..maxUnit] OF CHAR;
    lastUnit  : CARDINAL;
    sUnits    : str80;
VAR
    parmcount : CARDINAL;
    i         : CARDINAL;
    S         : str128;
    R         : str128;
    opt       : CARDINAL;
    useCLI    : BOOLEAN;
    cli       : str256; (* false cli, oversized just in case *)
    hnd       : FIO.File;
    freespace,usedspace,totalspace: HUGECARD;
    sumfree,sumused,sumtotal:HUGECARD;
    percentused,percentfree:LONGREAL;
    warn,verbose:BOOLEAN;
    showsum,graphchars,semigraphics,showfree,showgeometry,xpanyway:BOOLEAN;
    DEBUG,showdpb,assumeFAT32 : BOOLEAN;
    charUsed,charFree:CHAR;
    showAs : showAsType;
    lastletter,zeletter:CARDINAL;
    U:str2;
    sepgroup,sepdec:CHAR;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    vidinit ( IsRedirected() );

    parmcount := Lib.ParamCount();
    useCLI    := TRUE;

    IF parmcount = 0 THEN
        Lib.ParamStr(S,0); (* argh ! no longer okay when qd_text is used ! *)
        UpperCase(S); (* useless ! *)
        Str.Subst(S,extEXE,extINI);
        IF FIO.Exists(S)=FALSE THEN
            (* abort(errNotFound,S); *)
            abort(errHelp,"");
        END;
        hnd:=FIO.OpenRead(S);
        FIO.RdStr(hnd,cli);
        FIO.Close(hnd);
        LtrimBlanks(cli);
        RtrimBlanks(cli);
        parmcount := argc(cli,FALSE); (* FALSE because already trimed *)
        useCLI := FALSE;
    END;

    lastUnit     := firstUnit-1;
    sUnits       := "";
    warn         := FALSE;
    verbose      := TRUE;
    showsum      := TRUE;
    sumfree      := HUGEZERO;
    sumtotal     := HUGEZERO;
    graphchars   := TRUE;
    semigraphics := TRUE;
    showfree     := TRUE;
    showgeometry := FALSE;
    showdpb      := FALSE;
    assumeFAT32  := TRUE;
    showAs       := bytes;
    xpanyway     := FALSE;
    sepgroup     :=getsepgroup(TRUE);
    sepdec       :=getsepdec(TRUE);
    DEBUG        := FALSE;

    FOR i := 1 TO parmcount DO
        IF useCLI THEN
            Lib.ParamStr(S,i);
        ELSE
            argv(S,cli,i,FALSE); (* FALSE because already trimed *)
        END;
        Str.Copy(R,S);
        UpperCase(R);
        cleantabs(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "I"+delim+"GEOMETRY"+delim+
                                  "W"+delim+"WARNING"+delim+
                                  "Q"+delim+"QUIET"+delim+
                                  "S"+delim+"SUM"+delim+
                                  "A"+delim+"ASCII"+delim+
                                  "X"+delim+"NOFAT32"+delim+
                                  "U"+delim+"USED"+delim+
                                  "T"+delim+"TEXT"+delim+
                                  "DEBUGGG"+delim+"DEBUGII"+delim+
                                  "DEBUGI"+delim+"DEBUGDPB"+delim+

                                  "K"+delim+"KB"+delim+
                                  "RK"+delim+"KK"+delim+
                                  "M"+delim+"MB"+delim+
                                  "RM"+delim+"MM"+delim+
                                  "G"+delim+"GB"+delim+
                                  "RG"+delim+"GG"+delim+
                                  "XP"+delim+
                                  "DEBUG"+delim+
                                  "E"+delim+"US"+delim+"UK"+delim+
                                  "AA"
(*%T CONSOLE  *)
                                                   +delim+
                                  "B"+delim+"BIOS"
(*%E  *)
                              );
            CASE opt OF
            | 1,2,3 :  abort(errHelp,"");
            | 4,5   :  showgeometry := TRUE;
            | 6,7   :  warn := TRUE;
            | 8,9   :  verbose:=FALSE;
            | 10,11 :  showsum:=FALSE;
            | 12,13 :  graphchars:=FALSE;
            | 14,15 :  assumeFAT32:=FALSE;
            | 16,17 :  showfree := FALSE;
            | 18,19 :  semigraphics:=FALSE;
            | 20,21 :  showgeometry := TRUE; showdpb := TRUE;
            | 22,23 :                        showdpb := TRUE;

            | 24,25 : showAs :=     kilobytes;
            | 26,27 : showAs := realkilobytes;
            | 28,29 : showAs :=     megabytes;
            | 30,31 : showAs := realmegabytes;
            | 32,33 : showAs :=     gigabytes;
            | 34,35 : showAs := realgigabytes;
            | 36    : xpanyway:= TRUE;
            | 37    : DEBUG := TRUE;
            | 38,39,40: sepgroup:=getsepgroup(FALSE);
                        sepdec  :=getsepdec(FALSE);
            | 41    :  graphchars:=FALSE; semigraphics:=FALSE;
(*%T CONSOLE  *)
            | 42,43 :  vidinit( TRUE);
(*%E  *)
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            lastletter:=isConcatenatedUnits(R); (* ?[?...]: *)
            IF lastletter = MAX(CARDINAL) THEN abort(errBadUnitSpec,S);END;
            FOR zeletter := 1 TO lastletter DO
                Str.Concat(U, R[zeletter-1], colon);
                IF isUnitSpec(U) = FALSE THEN abort(errBadUnitSpec,S); END;
                IF Str.CharPos(sUnits,U[0]) # MAX(CARDINAL) THEN
                    ;(* abort(errAlreadySpecified,S); (* we could just ignore it, but... *) *)
                ELSE
                    INC(lastUnit);
                    IF lastUnit > maxUnit THEN abort(errTooManyUnits,S); END; (* extremely unlikely and even impossible ! *)
                    unit[lastUnit] := U[0]; (* keep uppercase *)
                    Str.Append(sUnits,U[0]);
                END;
            END;
        END;
    END;

    IF lastUnit < firstUnit THEN abort(errNoUnitSpecified,""); END;

    IF lastUnit = firstUnit THEN showsum := FALSE; END;

    IF NOT(xpanyway) THEN
        IF runFromWinXP() THEN abort(errPoorDOSsupportHere,"");END;
    END;

    newline; (* here for pretty output *)

    assumeFAT32 := ( assumeFAT32 AND w9XsupportLFN() );

    (*
    print(Banner);
    newline;
    newline;
    *)

    IF showgeometry THEN
        FOR i := firstUnit TO lastUnit DO
            colorheader;
            Str.Concat(S,unit[i],colon);Str.Append(S," unit geometry");
            print(S);
            colortext;
            IF getUnitFreeTotal(DEBUG,assumeFAT32,TRUE,unit[i],freespace,totalspace)=FALSE THEN
               colorheader;
               print(" is not available !"); newline;
            END;
            IF i < lastUnit THEN newline; END;
        END;
    END;
    IF showdpb THEN
        IF showgeometry THEN newline; END;
        FOR i := firstUnit TO lastUnit DO
            colorheader;
            Str.Concat(S,unit[i],colon);
            Str.Append(S," unit DPB geometry");
            print(S);
            colortext;
            IF getUnitDPB(DEBUG,assumeFAT32,TRUE,unit[i],freespace,totalspace)=FALSE THEN
               colorheader;
               print(" could not be retrieved !"); newline;
            END;
            IF i < lastUnit THEN newline; END;
        END;
    END;
    IF (showgeometry OR showdpb) THEN abort(errNone,""); END;

    (* neither -g nor -i *)

    S := sHeader1a; IF verbose THEN Str.Append(S,sHeader1b);END;
    R := sHeader2a; IF verbose THEN Str.Append(R,sHeader2b);END;

    IF semigraphics THEN
        charUsed:=chUsed;     charFree:=chFree;
    ELSE
        charUsed:=chUsedTxt;  charFree:=chFreeTxt;
    END;
    Str.Subst(S,chsymbol,charUsed);
    Str.Subst(S,chsymbol,charFree);

    IF graphchars THEN ReplaceChar(R,chdash,graphdash); END;

    IF NOT (showfree) THEN Str.Subst(S,sFree,sUsed);END;

    colorheader;

    print(S);newline;
    print(R);newline;

    colortext;

    FOR i := firstUnit TO lastUnit DO
        Str.Concat(S,unit[i],colon);
        Str.Copy(S,fmtstring(S,blank,2+2));
        Str.Append(S,"  ");
        IF getUnitFreeTotal(DEBUG,assumeFAT32,FALSE,unit[i],freespace,totalspace) THEN
            HUGEINC(sumtotal,totalspace);
            HUGEINC(sumfree,freespace);
            usedspace := totalspace-freespace;
            HUGEINC(sumused,usedspace);

            IF showfree THEN
                Str.Append(S,fmthcAs(freespace,blank,sepgroup,wihuge,showAs));
            ELSE
                Str.Append(S,fmthcAs(usedspace,blank,sepgroup,wihuge,showAs));
            END;
            Str.Append(S,"  ");
            Str.Append(S,fmthcAs(totalspace,blank,sepgroup,wihuge,showAs));
            Str.Append(S,"  ");
            percentfree := (LONGREAL(freespace) / LONGREAL(totalspace) ) * 100.0;
            percentused := 100.0 - percentfree;
            Str.Append(S,fmtpercent(percentused,blank,sepdec,wipercent,zedigits));
            (* Str.Append(S,"%"); *)
            Str.Append(S,"  ");
            Str.Append(S,fmtpercent(percentfree,blank,sepdec,wipercent,zedigits));
            (* Str.Append(S,"%"); *)
            IF verbose THEN
                Str.Append(S,"  ");
                Str.Append(S,fmtbar(percentused,charUsed,charFree,wibar));
            END;
        ELSE
            Str.Append(S,sInvalid);
        END;
        print(S);
        newline;
    END;

    colorheader;

    IF showsum THEN
        IF lastUnit > firstUnit THEN
            IF graphchars THEN
                ReplaceChar(R,graphdash,graphbar);
            ELSE
                ReplaceChar(R,"-","=");
            END;
            print(R);newline; (* we did not change R separator ! *)
            freespace := sumfree;
            totalspace:= sumtotal;
            usedspace := sumused;
            Str.Concat(S,"all",colon);
            Str.Copy(S,fmtstring(S,blank,2+2));
            Str.Append(S,"  ");
            IF showfree THEN
                Str.Append(S,fmthcAs(freespace,blank,sepgroup,wihuge,showAs));
            ELSE
                Str.Append(S,fmthcAs(usedspace,blank,sepgroup,wihuge,showAs));
            END;
            Str.Append(S,"  ");
            Str.Append(S,fmthcAs(totalspace,blank,sepgroup,wihuge,showAs));
            Str.Append(S,"  ");
            percentfree := (LONGREAL(freespace) / LONGREAL(totalspace) ) * 100.0;
            percentused := 100.0 - percentfree;
            Str.Append(S,fmtpercent(percentused,blank,sepdec,wipercent,zedigits));
            (* Str.Append(S,"%"); *)
            Str.Append(S,"  ");
            Str.Append(S,fmtpercent(percentfree,blank,sepdec,wipercent,zedigits));
            (* Str.Append(S,"%"); *)
            IF verbose THEN
                Str.Append(S,"  ");
                Str.Append(S,fmtbar(percentused,charUsed,charFree,wibar));
            END;
            print(S);
            newline;
        END;
    END;

    colorwarning;

    IF warn THEN
        newline;
        print(msgWarning);newline;
    END;

    abort(errNone,"");
END HDfree.

