(* ---------------------------------------------------------------
Title         Q&D Make Path
Overview      tsk tsk...
Usage         see help
Notes         I'm probably the only programmer (well : among the very last)
              in the world still writing/updating little utilities for DOS...

              in messages, note we only add trailing "\" to existing dirs

              deltree and xdel best left to DD utility

Bugs          still the ugly Abort,Retry,Fail DOS error message
              when trying to access an empty or a phantom drive
              we are still able to create directories on nonexisting drives
Wish List     check drive exist (we are able to create a directory on a phantom unit !)
              better ?:\ check/trap

--------------------------------------------------------------- *)

MODULE MakePath;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;
IMPORT DOSErr;

FROM IO IMPORT WrStr, WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose;

(* ------------------------------------------------------------ *)

CONST
    cr        = CHR(13);
    lf        = CHR(10);
    nl        = cr+lf;
    letters   = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    backslash = "\";
    netslash  = "\\";
    colon     = ":";
    dquote    = '"';
CONST
    placeholder = "~"; (* substitute filename here *)
CONST
    sINFO    = "::: ";
    sPROBLEM = "--- ";
    sOK      = "+++ ";
CONST
    progEXEname   = "MAKEPATH";
    progTitle     = "Q&D Make Path";
    progVersion   = "v1.2b";
    progCopyright = "by PhG";
    banner        = progTitle+" "+progVersion+" "+progCopyright;
CONST
    errNone            = 0;
    errHelp            = 1;
    errUnknownOption   = 2;
    errTooManyPaths    = 3;
    errMissingPath     = 4;
    errJoker           = 5;
    errPath            = 6;
    errOnlyOnePath     = 7;
    errMissingDirectory= 8;
    errOnlyOneDirectory= 9;
    errConflict        = 10;
    errOnlyOneDirToKill= 11;
    errFile            = 12;
    errOnlyOneChangeDir= 13;
    errCannotHappenHere= 14;

    (* only below 16 because terminate() uses rcPhantom = 16 *)

    errPhantom         = 64; (* will become rcDirNotFound in (now obsolete) -c[c] mode *)
    (* no abort() message -- errPhantom becomes rcDirNotFound *)
    rcDirFound         = 128; msgDirFound    = sOK+"Return code is 128";
    rcDirNotFound      = 255; msgDirNotFound = sPROBLEM+"Return code is 255";
CONST
    rcEmpty   = 255; msgEmpty    = sOK+'Return code is 255 (~ is empty)'+nl;
    rcNotEmpty= 128; msgNotEmpty = sOK+'Return code is 128 (~ is not empty)'+nl;
    rcNotDir  =  64; msgNotDir   = sINFO+'Return code is 64 (~ is not a directory)'+nl;
    rcNotFound=  32; msgNotFound = sPROBLEM+'Return code is 32 (~ does not exist)'+nl;
    rcPhantom =  16; msgPhantom  = sPROBLEM+'Return code is 16 (~ does not refer to a valid unit)'+nl;
CONST
    rcEmptyKilled   = rcEmpty;       msgEmptyKilled=sOK+'Return code is 255 (~ was deleted)'+nl;
    rcEmptyNotKilled= rcNotEmpty+64; msgEmptyNotKilled=sPROBLEM+'Return code is 192 (~ was not deleted)'+nl;
CONST
    rcNotDirCD  = 128; msgNotDirCD   = sPROBLEM+'Return code is 128 (~ is not a directory)'+nl;
    rcNotFoundCD= 160; msgNotFoundCD = sPROBLEM+'Return code is 160 (~ does not exist)'+nl;
    rcPhantomCD = 192; msgPhantomCD  = sPROBLEM+'Return code is 192 (~ does not refer to a valid unit)'+nl;
    rcBadPathCD = 224; msgBadPathCD  = sPROBLEM+'Return code is 224 (unsupported ~ path form)'+nl;
    rcOKCD      = 0;   msgOKCD       = sINFO+'~'+nl; (* very short ! *)

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)

errmsg =
banner+nl+
nl+
"Syntax 1 : "+progEXEname+" <directory>... [-b] [-l] [-q] [-w] [-d]"+nl+
"Syntax 2 : "+progEXEname+" <directory> <-i[i]> [-l] [-x] [-v]"+nl+
"Syntax 3 : "+progEXEname+" <directory> <-c[c]> [-l]"+nl+
"Syntax 4 : "+progEXEname+" <directory> <-k> [-l]"+nl+
"Syntax 5 : "+progEXEname+" <directory> <-g> [-q] [-l]"+nl+
nl+
"-b    build directory (default command)"+nl+
"-i[i] emulate ISEMPTY utility (-ii = -i -v)"+nl+
"-c[c] check if directory exists (-cc = -c -v)"+nl+
"-k    delete directory if empty"+nl+
"-g[g] make directory default only if it already exist (-gg = -g -q)"+nl+
"-q    do not display message if directory already exists"+nl+
"-w    merely warn if directory does not exist (default is to create it)"+nl+
"-d    make last newly created directory default"+nl+
"-x    exclude floppy and CDROM units"+nl+
"-v    verbose"+nl+
"-l    disable LFN support even if available"+nl+
nl+
"a) Syntax 1 checks for a directory existence, creating it if required,"+nl+
"   merely warning about its absence. Multiple directories are allowed."+nl+
"   Return code is 255 if unit was not a valid hard disk."+nl+
"b) Syntax 2 emulates ISEMPTY utility. Return codes are :"+nl+
"   255 if <directory> is empty, 128 if <directory> is not empty,"+nl+
"   64 if <directory> is a file, 32 if <directory> does not exist,"+nl+
"   16 if <directory> does not refer to a valid unit."+nl+
"c) Syntax 3 is obsolete and kept for legacy batches only. Return codes are :"+nl+
"   255 if <directory> does not exist, 128 if it does."+nl+
"d) Syntax 4 deletes existing directory. Return codes are :"+nl+
"   255 if delete operation was a success, 192 if it was a failure."+nl+
"e) Syntax 5 makes <directory> default only if it already exists."+nl+
'   Note <directory> must be specified in canonical form ("[u:]\path[\]").'+nl+
"   Any return code above 127 flags an error or a problem."+nl+
"f) Except with syntax 5, <directory> should be specified in canonical form"+nl+
'   ("u:\path[\]") ; however, "[u:][\]path[\]" forms are supported.'+nl+
"g) Other error codes are always below the smallest documented code."+nl+
"h) Options specific to one syntax are ignored by the others."+nl+
nl+
"Examples : "+progEXEname+" c:\fun\fortune"+nl+
"           "+progEXEname+" d:foo\bar"+nl+
"           "+progEXEname+" foo\bar"+nl+
"           "+progEXEname+" -ii c:\z"+nl+
"           "+progEXEname+' -k "c:\mes documents\mes images"'+nl;

VAR
    S  : str1024; (* in case we get a pathtype *)
BEGIN
    CASE e OF
    | errHelp :
        WrStr(errmsg);
    | errUnknownOption:
        S:="Unknown ~ option !";Str.Subst(S,placeholder,einfo);
    | errTooManyPaths:
        S:='Path "~" is just one too many !';Str.Subst(S,placeholder,einfo);
    | errMissingPath:
        S:= "Missing path specification !";
    | errJoker:
        S:='At least one illegal joker in "~" path !';Str.Subst(S,placeholder,einfo);
    | errPath:
        S:='Required command does not support "~" path form !';Str.Subst(S,placeholder,einfo);
    | errOnlyOnePath:
        S:="-c[c] option requires one directory only !";
    | errMissingDirectory:
        S := "Missing <directory> specification !";
    | errOnlyOneDirectory:
        S:="-i[i] option requires one directory only !";
    | errConflict:
        S:="-b, -i[i], -c[c], -k and -g commands are mutually exclusive !";
    | errOnlyOneDirToKill:
        S:="-k option requires one directory only !";
    | errFile:
        S:='"~" is not a directory !';Str.Subst(S,placeholder,einfo);
    | errOnlyOneChangeDir:
        S:="-g option requires one directory only !";

    | errPhantom:
        S:='Illegal or phantom unit in "~" path !';Str.Subst(S,placeholder,einfo);
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp,rcDirFound,rcDirNotFound :
        ;
    | errFile:
        ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;
    CASE e OF
    | errPhantom: e:=rcDirNotFound;
    | errFile:    e:=rcNotDir;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE nice (enclose:BOOLEAN;S:ARRAY OF CHAR):str1024;
VAR
    R:str1024;
BEGIN
    IF enclose THEN
        Str.Concat(R,dquote,S);Str.Append(R,dquote);
    ELSE
        Str.Copy(R,S);
    END;
    RETURN R;
END nice;

(* current is "\" or "\*\" *)

PROCEDURE buildParent (VAR parent:pathtype; current:pathtype):BOOLEAN;
VAR
    p:CARDINAL;
BEGIN
    IF Str.Match(current,"\") THEN RETURN FALSE; END;
    unfixDirectory(current);
    p:=Str.RCharPos(current,"\");
    Str.Slice(parent,current,0,p+1); (* keep final "\" *)
    RETURN TRUE;
END buildParent;

PROCEDURE doGetCurrent (useLFN:BOOLEAN;drive:SHORTCARD;
                       VAR unit:str2; VAR current:pathtype);
VAR
    rc:CARDINAL;
    longform:pathtype;
BEGIN
    Str.Concat(unit, CHR( ORD("A")-1+ORD(drive) ),colon);

    FIO.GetDir(drive,current); (* \path without u: nor trailing \ except at root *)
    IF current[1] # colon THEN Str.Prepend(current,unit); END; (* safety *)
    IF useLFN THEN
        IF w9XshortToLong(current,rc,longform) THEN (* if error, keep DOS current *)
            Str.Copy(current,longform);
        END;
    END;
    (* LFN function seems to always return "u:\*" form except at root *)
    IF current[1] = colon THEN Str.Delete(current,0,2);END; (* safety *)
    fixDirectory(current);
END doGetCurrent;

(*
    adapted from DD v1.0h chkFixSpec()

    remember dirs can have an extension, and LFNs can have inner dots
    we handle (whether u: or not) :

    *\\*     network           NOPE
    .        current           NOPE unless justchecking
    ..       parent            NOPE unless justchecking
    \        root              NOPE unless justchecking
    ""       empty spec        NOPE -- "u:" here because "" is trapped earlier

    .\xxx    current\xxx       F/D
    ..\xxx   parent\xxx        F/D

    xxx\     current\xxx\
    xxx\.    current\xxx\
    xxx      current\xxx       F/D

    \xxx\    \xxx\
    \xxx     \xxx              F/D
*)

CONST
    retNone            = 1000; (*  *)
    retPhantomUnit     = 1001;
    retBadUnit         = 1002;
    retColon           = 1003;
    retNoParent        = 1004;
    retInnerParent     = 1005;
    retEntryIsFile     = 1006; (*  *)
    retEntryNotFound   = 1007; (*  *)
    retDirJoker        = 1008;
    retNetSlash        = 1009;
    retBadPath         = 1010;

PROCEDURE chkfixDirSpec (VAR newpath:pathtype;
                        DEBUG,useLFN,justchecking:BOOLEAN;orgS:pathtype;allowedLetters:ARRAY OF CHAR):CARDINAL;
CONST
    defspec = ""; (* was "*.*" *)
VAR
    pb,p,len,rc:CARDINAL;
    drive:SHORTCARD;
    u:CHAR;
    unit:str2;
    current,parent,S,base,spec:pathtype;
    ok:BOOLEAN;
BEGIN
IF DEBUG THEN
    WrStr("       orgpath = ");WrStr(nice(TRUE,orgS));WrLn;
END;
    Str.Copy(S,orgS);
    IF Str.Pos(S,"\\") # MAX(CARDINAL) THEN RETURN retNetSlash;END;
    pb:=0;
  IF justchecking = FALSE THEN
    IF same(S,".")        THEN INC(pb);END;
    IF same(S,"..")       THEN INC(pb);END;
    IF Str.Match(S,"?:\") THEN INC(pb);END;
  END;
    IF Str.Match(S,"?:")  THEN INC(pb);END;

    IF pb # 0 THEN RETURN retBadPath;END;

    (* process u: in S *)

    CASE CharCount(S,colon) OF
    | 0 :
        drive := FIO.GetDrive();
        rc:=retNone;
    | 1 :
        IF Str.CharPos(S,colon) = 1 THEN
            u:=CAP( S[0] );
            CASE u OF
            | "A".."Z" :
                IF verifyString(u,allowedLetters) THEN
                    drive := SHORTCARD( ORD(u) - ORD("A") +1 );
                    Str.Delete(S,0,2); (* remove u: *)
                    rc:=retNone;
                ELSE
                    rc:=retPhantomUnit;
                END;
            ELSE
                rc:=retBadUnit;
            END;
        ELSE
            rc:=retColon;
        END;
    ELSE
        rc:=retColon;
    END;
    IF rc # retNone THEN RETURN rc; END;

    (* note S no longer has u: *)

    doGetCurrent(useLFN,drive, unit,current); (* "u:" and "\" or "\*\" *)
    ok:=buildParent(parent, current);

    IF Str.Match(S,".\*") THEN Str.Subst(S,".\",current); END;
    IF Str.Match(S,"..\*") THEN
        IF ok THEN Str.Subst(S,"..\",parent) ELSE RETURN retNoParent;END;
    END;
    IF Str.Match(S,"\*")=FALSE THEN Str.Prepend(S,current);END;
    IF Str.Match(S,"*\.") THEN
        (* S[Str.Length(S)-1]:=0C; *)
        len:=Str.Length(S);
        Str.Delete(S,len-1,1);
    END;
    (* we don't want inner or trailing ".." now *)
    IF Str.Pos(S,"..") # MAX(CARDINAL) THEN RETURN retInnerParent;END;

    (* base = "u:\xxx\" and spec = "xxx" *)

    IF Str.Match(S,"*\") THEN
        Str.Concat(base,unit,S);
        Str.Copy(spec,defspec);
    ELSE
        Str.Prepend(S,unit);
        (* S is u:[\xxx]... without trailing "\" *)
        len:=Str.Length(S);
        p:=Str.RCharPos(S,"\");
        Str.Slice(base,S,0,p+1);
        Str.Slice(spec,S,p+1,len-p);
        IF chkJoker(spec)=FALSE THEN (* if spec has joker(s), assume files *)
            (* spec has no joker : dir or file ? *)
            IF fileIsDirectorySpec(useLFN,S) THEN
                Str.Copy(base,S);
                fixDirectory(base); (* safety *)
                Str.Copy(spec,defspec);
            ELSE
                (* //FIXED hopefully : either entry not found, or found a file *)
                IF fileExists(useLFN,S) THEN
                    IF Str.RCharPos(spec,".")=MAX(CARDINAL) THEN
                        Str.Append(spec,"."); (* file extension *)
                    END;
                    rc:= retEntryIsFile;
                ELSE
                    rc:= retEntryNotFound;
                END;
                Str.Concat(newpath,base,spec);
                RETURN rc;
            END;
        END;
    END;
    IF chkJoker(base) THEN RETURN retDirJoker; END;
    (* //FIXED hopefully *)
    IF Str.Length(base) > 3 THEN (* "u:\" is assumed to always exist *)
        unfixDirectory(base);
        IF fileExists(useLFN,base)=FALSE THEN
            Str.Concat(newpath,base,spec);
            RETURN retEntryNotFound;
        END;
        fixDirectory(base);
    END;
    Str.Concat(newpath,base,spec);
IF DEBUG THEN
    WrStr("       newpath = ");WrStr(nice(TRUE,newpath));WrLn;
END;
    RETURN retNone;
END chkfixDirSpec;

PROCEDURE dmprc ( rc:CARDINAL  );
VAR
    S:str80;
BEGIN
    CASE rc OF
    | retNone          :  S:="retNone";
    | retPhantomUnit   :  S:="retPhantomUnit";
    | retBadUnit       :  S:="retBadUnit";
    | retColon         :  S:="retColon";
    | retNoParent      :  S:="retNoParent";
    | retInnerParent   :  S:="retInnerParent";
    | retEntryIsFile   :  S:="retEntryIsFile";
    | retEntryNotFound :  S:="retEntryNotFound";
    | retDirJoker      :  S:="retDirJoker";
    | retNetSlash      :  S:="retNetSlash";
    | retBadPath       :  S:="retBadPath";
    ELSE
                          S:="ret???";
    END;
    WrStr("            rc = ");WrStr(S);WrLn;
END dmprc;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE doGetDir (DEBUG,useLFN:BOOLEAN;currdrive:SHORTCARD;
                   VAR currdir: pathtype);
VAR
    longform:pathtype;
    rc:CARDINAL;
BEGIN
    FIO.GetDir(currdrive,currdir); (* we could use 0 for default drive *)
    IF useLFN THEN
        IF w9XshortToLong(currdir,rc,longform) THEN
            Str.Copy(currdir,longform);
            (* seems this function always returns "u:\*" form  *)
IF DEBUG THEN
WrStr("  LFN doGetDir : ");WrStr(currdir);WrLn;
END;
            IF currdir[1]=colon THEN Str.Delete(currdir,0,2);END;
        END;
    END;
IF DEBUG THEN
WrStr(" exit doGetDir : ");WrStr(currdir);WrLn;
END;
END doGetDir;

PROCEDURE doChDir (DEBUG,useLFN:BOOLEAN;dir:pathtype ):BOOLEAN;
VAR
    rc:CARDINAL;
    S:pathtype;
    ok:BOOLEAN;
BEGIN
IF DEBUG THEN
WrStr("enter doChDir  : ");WrStr(dir);WrLn;
END;
    IF useLFN THEN
        IF w9XlongToShort(dir,rc,S) THEN
            Str.Copy(dir,S);
        END;
    END;
    FIO.ChDir(dir);
    ok:= (FIO.IOresult()=DOSErr.NO_ERROR); (* true if directory found *)
IF DEBUG THEN
WrStr(" exit doChDir  : ");WrStr(dir);
IF ok THEN
    WrStr(" ::: OK");
ELSE
    WrStr(" ::: ERROR");
END;
WrLn;
END;
    RETURN ok; (* true if directory found *)
END doChDir;

PROCEDURE doMkDir (DEBUG,useLFN:BOOLEAN;S:pathtype  );
VAR
    rc:CARDINAL;
    ok:BOOLEAN;
BEGIN
IF DEBUG THEN
WrStr("enter doMkDir  : ");WrStr(S);WrLn;
END;
    IF useLFN THEN
        ok:=w9XmakeDir(S,rc);
    ELSE
        FIO.MkDir(S);
    END;
IF DEBUG THEN
WrStr(" exit doMkDir  : ");WrStr(S);WrLn;
END;
END doMkDir;

PROCEDURE doRemDir (DEBUG,useLFN:BOOLEAN;dir:pathtype):BOOLEAN;
VAR
    rc:CARDINAL;
    S:pathtype;
    ok:BOOLEAN;
BEGIN
IF DEBUG THEN
WrStr("enter doRemDir : ");WrStr(dir);WrLn;
END;
    IF useLFN THEN
        IF w9XlongToShort(dir,rc,S) THEN
            Str.Copy(dir,S);
        END;
    END;
    FIO.RmDir(dir); (* DOS path *)
    ok:= (FIO.IOresult()=DOSErr.NO_ERROR); (* true if directory found *)
IF DEBUG THEN
WrStr(" exit doRemDir : ");WrStr(dir);
IF ok THEN
    WrStr(" ::: OK");
ELSE
    WrStr(" ::: ERROR");
END;
WrLn;
END;
    RETURN ok; (* true if directory deleted *)
END doRemDir;

(* ------------------------------------------------------------ *)

(* "u:\xxx[\xxx]...", assume everything goes ok ! *)

PROCEDURE makemydir (S:pathtype;DEBUG,useLFN,setasdefault:BOOLEAN ):BOOLEAN ;
VAR
    i,pb : CARDINAL;
    path : pathtype; (* was str128 *)
    R    : pathtype;
    ok:BOOLEAN;
BEGIN
    pb := 0;

    isoleItemS(path,S,"\",0);
    FOR i:= 1 TO CharCount(S,"\") DO
        isoleItemS(R, S, "\", i);
        Str.Append(path,"\");
        Str.Append(path,R);
        doMkDir(DEBUG,useLFN,path);

        (*
        WrStr(path);WrLn;
        Lib.WrDosError(SHORTCARD(FIO.IOresult()));WrLn;
        CASE FIO.IOresult() OF
        | DOSErr.NO_ERROR, DOSErr.ERROR_ACCESS_DENIED: ;
        ELSE
            INC(pb);
        END;
        *)
    END;

    IF setasdefault THEN
        IF pb=0 THEN ok:=doChDir(DEBUG,useLFN,S); END;
    END;

    RETURN (pb=0);
END makemydir;

PROCEDURE info (useLFN:BOOLEAN;S0,S1,S2:ARRAY OF CHAR);
BEGIN
    WrStr(S0);
    IF useLFN THEN WrStr(dquote);END;
    WrStr(S1);
    IF useLFN THEN WrStr(dquote);END;
    WrStr(S2);
    WrLn;
END info;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* adapted from IsEmpty v1.0d code dated 12 Oct 06 *)
(* portions adapted from QD_BOX.MOD dated 4 Oct 03 *)

(* terminate() takes care of double quotes around "~" placeholder if LFN *)

CONST
    star        = "*";
    dot         = ".";
    stardotstar = star+dot+star;
    dotdot      = dot+dot;

(* isEmpty won't use abort() *)

PROCEDURE terminate(useLFN,verbose:BOOLEAN; rc:CARDINAL; msg,dirspec:ARRAY OF CHAR);
VAR
    S:str1024; (* was str128 *)
BEGIN
    IF verbose THEN
        Str.Copy(S,msg);
        IF useLFN THEN
            Str.Subst(S,placeholder,dquote+placeholder+dquote);
        END;
        Str.Subst(S,placeholder,dirspec);
        WrStr(S);
    END;
    Lib.SetReturnCode( SHORTCARD(rc) );
    HALT;
END terminate;

(*
PROCEDURE existence (useLFN:BOOLEAN; S:pathtype):BOOLEAN;
VAR
    entry:FIO.DirEntry;
    found:BOOLEAN;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    rc : BOOLEAN;
BEGIN
    unfixDirectory(S); (* no DOS loves trailing backslash *)
    IF useLFN THEN
        found := w9XfindFirst (S,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
        rc:=w9XfindClose(w9Xhandle,errcode);
    ELSE
        found:= FIO.ReadFirstEntry(S,everything,entry);
    END;
    RETURN found;
END existence;
*)

PROCEDURE isDirEntry (S : ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isDirEntry;

(* anyone storing more than 65536 files in a single directory is a madman ! *)

PROCEDURE countFiles (DEBUG,useLFN:BOOLEAN;spec:pathtype  ):CARDINAL;
VAR
    n:CARDINAL;
    found:BOOLEAN;
    entry:FIO.DirEntry;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    fname:pathtype;
    rc:BOOLEAN;
BEGIN
IF DEBUG THEN
WrStr("enter countFiles   : ");WrStr(spec);WrLn;
END;
    n:=0;

    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(fname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(fname,entry.Name);
        END;
        IF isDirEntry(fname)=FALSE THEN (* skip . AND .. *)
            IF DEBUG THEN
                IF useLFN THEN WrStr(dquote);END;
                WrStr(fname);
                IF useLFN THEN WrStr(dquote);END;
                WrLn;
            END;
            INC(n); (* we count files and directories *)
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;

    RETURN n;
IF DEBUG THEN
WrStr(" exit countFiles");WrLn;
END;
END countFiles;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    cmdtype = (none,build,check,chkempty,killempty,changedir);

PROCEDURE newcmd (VAR cmd:cmdtype;wanted:cmdtype):BOOLEAN;
VAR
    ok:BOOLEAN;
BEGIN
    ok:=TRUE;
    IF cmd=none THEN
        cmd:=wanted;
    ELSIF cmd=wanted THEN
        ;
    ELSE
        ok:=FALSE;
    END;
    RETURN ok;
END newcmd;

CONST
    firstpath = 1;
    maxpath   = 16; (* why 16 ? why NOT, eh ! *)
VAR
    flagCREATE,flagVERBOSE,flagDEFAULT,verbose,useLFN,justchecking,DEBUG:BOOLEAN;
    dirfound,ok : BOOLEAN;
    lastpath   : CARDINAL;
    parm       : ARRAY[firstpath..maxpath] OF pathtype;
    fullpath   : ARRAY[firstpath..maxpath] OF pathtype;
    includeAll:BOOLEAN;
    dirspec:pathtype;
VAR
    i,opt,parmcount : CARDINAL;
    S,R             : pathtype; (* was str128 *)
    currdrive       : SHORTCARD;
    currdir         : pathtype; (* was str128 *)
    legalForMake    : str80; (* oversized, make on floppy/hd *)
    legalForCheck   : str80; (* oversized, check floppy/hd/CDROM *)
    legalForIsEmpty : str80; (* oversized, check floppy/hd/CDROM *)
    legalForKill    : str80; (* oversized, kill on floppy/hd *)
    legalForChangeDir:str80; (* oversized, allow floppy/hd/CDROM *)
    sLegal          : str80;
    cmd:cmdtype;
    rc:CARDINAL;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    flagCREATE  := TRUE;
    flagVERBOSE := TRUE;
    flagDEFAULT := FALSE;
    cmd         := none; (* build *)
    useLFN      := TRUE;
    includeAll  := TRUE;
    DEBUG       := FALSE;
    lastpath    := firstpath-1; (* 1-1 is 0 *)
    verbose     := verbose; (* yep, we don't init *)

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "W"+delim+"WARN"+delim+
                                  "Q"+delim+"QUIET"+delim+
                                  "D"+delim+"DEFAULT"+delim+
                                  "C"+delim+"CHECK"+delim+
                                  "CC"+delim+
                                  "L"+delim+"LFN"+delim+
                                  "DEBUG"+delim+"DBG"+delim+
                                  "I"+delim+"INFO"+delim+"ISEMPTY"+delim+
                                  "II"+delim+
                                  "X"+delim+"EXCLUDE"+delim+
                                  "V"+delim+"VERBOSE"+delim+
                                  "K"+delim+"KILL"+delim+
                                  "B"+delim+"BUILD"+delim+
                                  "G"+delim+"GO"+delim+"CHDIR"+delim+"CD"+delim+"GOTODIR"+delim+
                                  "GG"+delim+"GQ"
                              );
            CASE opt OF
            | 1,2,3 :  abort(errHelp,"");
            | 4,5:     flagCREATE  := FALSE;
            | 6,7:     flagVERBOSE := FALSE;
            | 8,9:     flagDEFAULT := TRUE;
            |10,11:    IF newcmd(cmd,check)=FALSE THEN abort(errConflict,"");END;
                       verbose:=FALSE;
            |12:       IF newcmd(cmd,check)=FALSE THEN abort(errConflict,"");END;
                       verbose:=TRUE;
            |13,14:    useLFN      := FALSE;
            |15,16:    DEBUG       := TRUE;
            |17,18,19: IF newcmd(cmd,chkempty)=FALSE THEN abort(errConflict,"");END;
                       verbose:=FALSE;
            |20 :      IF newcmd(cmd,chkempty)=FALSE THEN abort(errConflict,"");END;
                       verbose:=TRUE;
            |21,22:    includeAll  := FALSE;
            |23,24:    verbose     := TRUE;
            |25,26:    IF newcmd(cmd,killempty)=FALSE THEN abort(errConflict,"");END;
                       verbose     := TRUE;
            |27,28:    IF newcmd(cmd,build)=FALSE THEN abort(errConflict,"");END;
            |29,30,31,32,33: IF newcmd(cmd,changedir)=FALSE THEN abort(errConflict,"");END;
            |34,35:          IF newcmd(cmd,changedir)=FALSE THEN abort(errConflict,"");END;
                      flagVERBOSE:=FALSE;
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            INC(lastpath);
            IF lastpath > maxpath THEN abort(errTooManyPaths,S);END;
            fixDirectory(R);
            IF chkJoker(R) THEN abort(errJoker,S);END; (* check *? early *)
            Str.Copy(parm[lastpath],S); (* store original case *)
        END;
    END;
    useLFN := (useLFN AND w9XsupportLFN() );

    IF cmd=none THEN cmd:=build;END;

    IF lastpath < firstpath THEN
        CASE cmd OF
        | chkempty:
            abort(errMissingDirectory,"");
        ELSE
            abort(errMissingPath,"");
        END;
    END;

    IF useLFN = FALSE THEN
        FOR i:=firstpath TO lastpath DO
            UpperCaseAlt( parm[i] ); (* amerika hates accents ! *)
        END;
    END;

    (* anchor *)
    currdrive := FIO.GetDrive(); (* 1=A, etc. *)
    doGetDir(DEBUG,useLFN,currdrive,currdir); (* we could use 0 for default drive *)
                  (* okfloppy   okHD okCDROM  *)
    getAllLegalUnits(TRUE,      TRUE,TRUE,      legalForCheck);
    getAllLegalUnits(TRUE,      TRUE,FALSE,     legalForMake);
    getAllLegalUnits(includeAll,TRUE,includeAll,legalForIsEmpty);
    getAllLegalUnits(TRUE,      TRUE,FALSE,     legalForKill);
    getAllLegalUnits(includeAll,TRUE,includeAll,legalForChangeDir);

    justchecking := TRUE; (* default is to allow ".", "..", "u:\" *)

    CASE cmd OF
    | build:

        justchecking:=FALSE; (* v1.2a *)

        sLegal:=legalForMake;
        FOR i:=firstpath TO lastpath DO
            rc:= chkfixDirSpec( fullpath[i],   DEBUG,useLFN,justchecking,parm[i],sLegal );
IF DEBUG THEN dmprc(rc);END;
            CASE rc OF
            | retPhantomUnit,retBadUnit:
                abort(errPhantom,parm[i]);  (* 255 *)
            | retNone, retEntryNotFound:
                ;
            | retEntryIsFile :
                info(useLFN,sINFO,parm[i]," is not a directory.");
                abort(errFile,parm[i]);
            ELSE
                abort(errPath,parm[i]);
            END;
        END;

        FOR i:=firstpath TO lastpath DO
            Str.Copy(S,fullpath[i]);
            unfixDirectory(S); (* FIO.ChDir does not like trailing "\" ! *)
            IF doChDir(DEBUG,useLFN,S) THEN
                IF flagVERBOSE THEN
                    info(useLFN,sINFO,S," already exists.");
                END;
            ELSE
                (* here, code is almost certainly PATH_NOT_FOUND or INVALID_DRIVE *)
                IF flagCREATE THEN
                    IF makemydir(S,DEBUG,useLFN,flagDEFAULT) THEN
                        info(useLFN,sOK,S," was created.");
                    ELSE
                        info(useLFN,sPROBLEM,S," could not be created !");
                    END;
                ELSE
                    info(useLFN,sINFO,S," does not exist.");
                END;
            END;
        END;

        IF NOT(flagDEFAULT) THEN
            (* back to harbor *)
            i:=CARDINAL ( FIO.SetDrive(currdrive) );
            ok:=doChDir(DEBUG,useLFN,currdir); (* handles unit but not trailing "\" !!! *)
        END;
        abort(errNone,"");

    | chkempty: (* isEmpty *)
        IF lastpath > firstpath THEN abort(errOnlyOneDirectory,"");END;

        i:=firstpath;
        sLegal:=legalForIsEmpty;
        rc:= chkfixDirSpec( dirspec,   DEBUG,useLFN,justchecking,parm[i],sLegal );
IF DEBUG THEN dmprc(rc);END;
        CASE rc OF
        | retPhantomUnit,retBadUnit:
            terminate(useLFN,verbose,rcPhantom,msgPhantom,parm[i]);   (* 16 *)
        | retEntryNotFound:
            terminate(useLFN,verbose,rcNotFound,msgNotFound,parm[i]); (* 32 *)
        | retEntryIsFile:
            terminate(useLFN,verbose,rcNotDir,msgNotDir,parm[i]);     (* 64 *)
        | retNone :
            ;
        ELSE
            abort(errPath,parm[i]); (* all others *)
        END;

        fixDirectory(dirspec);
        Str.Copy(R,dirspec);
        Str.Append(R,stardotstar);

        i:=countFiles(DEBUG,useLFN,R);
        CASE i OF
        | 0 :
            terminate(useLFN,verbose,rcEmpty,msgEmpty,dirspec);       (* 255 *)
        ELSE
            terminate(useLFN,verbose,rcNotEmpty,msgNotEmpty,dirspec); (* 128 *)
        END;

    | check: (* obsolete now, but kept all for those legacy batches we're too lazy to rewrite *)
        IF lastpath > firstpath THEN abort(errOnlyOnePath,"");END;

        i:=firstpath;
        sLegal:=legalForCheck;
        rc:= chkfixDirSpec( S,   DEBUG,useLFN,justchecking,parm[i],sLegal );
IF DEBUG THEN dmprc(rc);END;
        CASE rc OF
        | retPhantomUnit,retBadUnit:
            terminate(useLFN,verbose,rcPhantom,msgPhantom,parm[i]); (* 16 *)
        | retEntryIsFile:
            terminate(useLFN,verbose,rcNotDir,msgNotDir,parm[i]);   (* 64 *)
        | retNone:
            ;
        | retEntryNotFound:
            IF verbose THEN info(useLFN,msgDirNotFound+" (",parm[i]," does not exist)");END;
            abort(rcDirNotFound,"");                                 (* 255 *)
        ELSE
            abort(errPath,parm[i]);
        END;

        unfixDirectory(S); (* FIO.ChDir does not like trailing "\" ! *)

        dirfound:=doChDir(DEBUG,useLFN,S); (* we could use FIO.Exists too ! *)

        (* back to harbor *)
        i:=CARDINAL ( FIO.SetDrive(currdrive) );
        ok:=doChDir(DEBUG,useLFN,currdir); (* handles unit but not trailing "\" !!! *)

        IF dirfound THEN
            IF verbose THEN info(useLFN,msgDirFound+" (",S," exists)");END;
            abort(rcDirFound,"");                                    (* 128 *)
        ELSE
            IF verbose THEN info(useLFN,msgDirNotFound+" (",S," does not exist)");END;
            abort(rcDirNotFound,"");                                 (* 255 *)
        END;

    | killempty:
        IF lastpath > firstpath THEN abort(errOnlyOneDirToKill,"");END;

        justchecking:=FALSE; (* v1.2a *)

        i:=firstpath;
        sLegal:=legalForKill;
        rc:= chkfixDirSpec( dirspec,   DEBUG,useLFN,justchecking,parm[i],sLegal );
IF DEBUG THEN dmprc(rc);END;
        CASE rc OF
        | retPhantomUnit,retBadUnit:
            terminate(useLFN,verbose,rcPhantom,msgPhantom,parm[i]);   (* 16 *)
        | retEntryNotFound:
            terminate(useLFN,verbose,rcNotFound,msgNotFound,parm[i]); (* 32 *)
        | retEntryIsFile:
            terminate(useLFN,verbose,rcNotDir,msgNotDir,parm[i]);     (* 64 *)
        | retNone :
            ;
        ELSE
            abort(errPath,parm[i]); (* all others *)
        END;

        fixDirectory(dirspec);
        Str.Copy(R,dirspec);
        Str.Append(R,stardotstar);

        i:=countFiles(DEBUG,useLFN,R);
        CASE i OF
        | 0 :
            unfixDirectory(dirspec); (* FIO.RmDir does not like trailing "\" ! *)
            ok:=doRemDir(DEBUG,useLFN,dirspec);
            IF ok THEN
            terminate(useLFN,verbose,rcEmptyKilled,msgEmptyKilled,dirspec);       (* 255 *)
            ELSE
            terminate(useLFN,verbose,rcEmptyNotKilled,msgEmptyNotKilled,dirspec); (* 192 *)
            END;
        ELSE
            terminate(useLFN,verbose,rcNotEmpty,msgNotEmpty,dirspec);             (* 128 *)
        END;
    | changedir:
        verbose := TRUE; (* ignore -q *)
        justchecking := TRUE;

        IF lastpath > firstpath THEN abort(errOnlyOneChangeDir,"");END;

        i:=firstpath;
        sLegal:=legalForChangeDir;
        rc:= chkfixDirSpec( fullpath[i],   DEBUG,useLFN,justchecking,parm[i],sLegal );
IF DEBUG THEN dmprc(rc);END;
        CASE rc OF
        | retPhantomUnit,retBadUnit:
            terminate(useLFN,verbose,rcPhantomCD,msgPhantomCD,parm[i]);
        | retEntryIsFile:
            terminate(useLFN,verbose,rcNotDirCD,msgNotDirCD,parm[i]);
        | retEntryNotFound:
            terminate(useLFN,verbose,rcNotFoundCD,msgNotFoundCD,parm[i]);
        | retNone:
            verbose:=flagVERBOSE; (* -q only here *)

            Str.Copy(S,fullpath[i]);
            unfixDirectory(S); (* FIO.ChDir does not like trailing "\" ! *)
            ok:=doChDir(DEBUG,useLFN,S);

            currdrive := FIO.GetDrive(); (* 1=A, etc. *)
            doGetDir(DEBUG,useLFN,currdrive,currdir); (* we could use 0 for default drive *)
            Str.Concat(S,CHR(ORD("A")-1+currdrive),colon);
            Str.Append(S,currdir);
            terminate(useLFN,verbose,rcOKCD,msgOKCD,S);

        ELSE
            terminate(useLFN,verbose,rcBadPathCD,msgBadPathCD,parm[i]);
        END;

    END;
    abort(errCannotHappenHere,"");
END MakePath.




