(* ---------------------------------------------------------------
Title         Q&D XOR
Overview      tsk tsk...
Usage         see help
Notes         too much time...
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE XOR;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;

FROM IO IMPORT WrStr, WrLn;

FROM QD_ASCII IMPORT dash, slash, nullchar, tabchar, cr, lf, nl,
space, dot, deg, doublequote, quote, colon, percent, vbar,
bs, blank, equal, dquote, charnull, singlequote, antislash, dollar,
star, backslash, coma, question, underscore,
stardotstar,dotdot,escCh, escSet, letters, digits;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits, metaproc;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileExistsAlt,
fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose, fileSupportLFN;

(* ------------------------------------------------------------ *)

CONST
    progEXEname   = "XOR";
    progTitle     = "Q&D XOR";
    progVersion   = "v2.0a";
    progCopyright = "by PhG";
    Banner        = progTitle+" "+progVersion+" "+progCopyright;
CONST
    errNone       = 0;
    errHelp       = 1;
    errOption     = 2;
    errParameterOverflow = 3;
    errExpected   = 4;
    errJoker      = 5;
    errNotFound   = 6;
    errRO         = 7;
    errVal        = 8;
    errFpos       = 9;
    errFlen       = 10;
    errPassphrase = 11;
    errRange      = 12;
    errPosCountTwice= 13;
CONST
    hexadigits    =           "ABCDEF";

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL;einfo:ARRAY OF CHAR);
CONST
     placeholder = "|";
     hlpMsg = Banner+nl+
nl+
"Syntax : "+progEXEname+" <source> <target> <passphrase> [option]..."+nl+
nl+
"  -o[o]       overwrite existing <target> (-oo = overwrite read-only)"+nl+
"  -p:#<,|..># specify start,count or start..end file positions range"+nl+
"  -f:#        process <source> from specified file position (0-based)"+nl+
"  -l:#        process <source> for specified length"+nl+
"  -q          quiet mode"+nl+
nl+
"This program applies XOR operation to <source> in order to create <target>."+nl+
nl+
'a) <passphrase> is either a hex string (with "$" prefix) or a text string.'+nl+
"b) Text string can contain the following metacharacters :"+nl+
'   "' + escCh + 'n" for $0d0a, "' + escCh + 'p" for "%", "' + escCh+ 'q" for double quote, "' +
"  "+escCh + '[' + escSet + ']" for symbol,'+nl+
'   "' + escCh + "[$|x]#[" + escCh + ']" for hex/dec value ($00 value not allowed).'+nl+
"c) Range can be specified in either decimal or hexadecimal ("+dquote+dollar+dquote+" prefix)."+nl+
"d) If range is specified, <target> size will match extracted portion."+nl+
nl+
"Examples : "+progEXEname+" src dst $11223344 /p:$8 /l:4"+nl+
"           "+progEXEname+" src dst foobar"+nl;


VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(hlpMsg);
    | errOption:             S := "Unknown "+placeholder+" option !";
    | errParameterOverflow : S := placeholder + " is one parameter too many !";
    | errExpected   :        S := placeholder + " parameter expected !";
    | errJoker:              S := placeholder + " should not contain any joker !";
    | errNotFound:           S := placeholder + " does not exist !";
    | errRO:                 S := placeholder + " <target> is read-only !";
    | errVal:                S := "Illegal "+placeholder+" value !";
    | errFpos:               S := "Specified file position is beyond <source> filesize !";
    | errFlen:               S := "Specified length would go beyond <source> filesize !";
    | errPassphrase:         S := "Illegal "+placeholder+" <passphrase> !";
    | errRange:              S := "Illegal "+placeholder+" file positions range !";
    | errPosCountTwice:      S := "Range defined more than once !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp :
        ; (* nada *)
    ELSE
        Str.Subst(S,placeholder,einfo);
        WrStr(progEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType    = ARRAY[firstBufferByte..lastBufferByte] OF BYTE;
VAR
    ioBufferSource, ioBufferTarget : ioBufferType;

CONST
    dataBufferSize      = 256;
    firstDataBufferByte = 0;
    firstpasschar       = firstDataBufferByte;
    maxDataBufferByte   = dataBufferSize-1;
TYPE
    dataBufferType      = ARRAY [firstDataBufferByte..maxDataBufferByte] OF BYTE;
VAR
    databuffer , passphrasebuffer : dataBufferType;
    lastpasschar : CARDINAL;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE opXOR (b1,b2 : CARDINAL) : CARDINAL;
BEGIN
    RETURN CARDINAL ( (BITSET (b1) / BITSET (b2)) );
END opXOR;

PROCEDURE getval ( VAR lc:LONGCARD; S:ARRAY OF CHAR  ):BOOLEAN;
VAR
    ok:BOOLEAN;
    V:str80; (* oversized *)
    base,le:CARDINAL;
BEGIN
    GetString(S,V);
    IF Str.Length(V)=0 THEN RETURN FALSE; END;
    IF    Str.Match(V,"$*") THEN
        base := 16;
        le   := 1;
    ELSIF Str.Match(V,"0X*") THEN
        base := 16;
        le   := 2;
    ELSE
        base := 10;
        le   := 0;
    END;
    Str.Delete(V,0,le);
    Str.Caps(V); (* done by caller but who knows ? *)
    lc:=Str.StrToCard(V,base,ok);
    RETURN ok;
END getval;

PROCEDURE fmtnum (v:LONGCARD;base,wi:CARDINAL):str16;
VAR
    R:str16;
    ok:BOOLEAN;
    i:CARDINAL;
BEGIN
    Str.CardToStr(v,R,base,ok);
    IF ok THEN
        IF base = 16 THEN
            Str.Lows(R);
            FOR i:=Str.Length(R)+1 TO wi DO Str.Prepend(R,"0");END;
        END;
    ELSE
        R:="<ERROR>";
    END;
    RETURN R;
END fmtnum;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE parsePassphrase (VAR b : ARRAY OF BYTE; S:ARRAY OF CHAR):CARDINAL ;
VAR
    v:LONGCARD;
    i,last, rc : CARDINAL;
    R : str128;
    str:str2;
    ok:BOOLEAN;
BEGIN
    rc := MAX(CARDINAL);
    IF Str.Length(S) = 0 THEN RETURN rc;END;
    last := firstpasschar;
    Str.Copy(R,S);
    CASE S[0] OF
    | dollar:
        Str.Delete(R,0,1);
        Str.Caps(R);
        IF ODD ( Str.Length(R) ) THEN RETURN rc;END;
        FOR i:=1 TO Str.Length(R) BY 2 DO
            Str.Slice(str,R,i-1,2);
            v:=Str.StrToCard(str,16,ok);
            IF ok = FALSE THEN RETURN rc; END;
            b[last] := BYTE(v);
            INC(last);
        END;
    ELSE
        IF metaproc (R)=FALSE THEN RETURN rc; END;
        FOR i:=1 TO Str.Length(R) DO
            b[last] := BYTE ( ORD ( R[i-1] ) );
            INC(last);
        END;
    END;
    RETURN last-1;
END parsePassphrase;

(* ------------------------------------------------------------ *)

PROCEDURE getlc (VAR v:LONGCARD;S:ARRAY OF CHAR):BOOLEAN;
VAR
    base:CARDINAL;
    ok:BOOLEAN;
BEGIN
    IF S[0]=dollar THEN
        Str.Delete(S,0,1);
        base := 16;
    ELSE
        base := 10;
    END;
    v:=Str.StrToCard(S,base,ok);
    RETURN ok;
END getlc;

PROCEDURE parserangealt (VAR startpos,count:LONGCARD;S:ARRAY OF CHAR ):BOOLEAN;
VAR
    ok,iscount:BOOLEAN;
    p,l:CARDINAL;
    Z:str16;
    endpos:LONGCARD;
BEGIN
    Str.Caps(S); (* [$]#<,|..>[$]# *)
    ok:=verifyString(S,digits+hexadigits+dot+coma+dollar);
    IF NOT(ok) THEN RETURN ok;END;

    ok:=FALSE;
    IF CharCount(S,coma)=1 THEN
        p:=Str.CharPos(S,coma); l:=1;    iscount:=TRUE;
    ELSIF Str.Pos(S,dotdot) # MAX(CARDINAL) THEN
        p:=Str.Pos(S,dotdot);   l:=2;    iscount:=FALSE;
    ELSE
        RETURN ok;
    END;
    Str.Slice(Z,S,0,p);
    Str.Delete(S,0,p+l);
(* WrStr(Z);WrLn; *)
    ok:=getlc(startpos,Z);
    IF NOT(ok) THEN RETURN ok;END;

(* WrStr(S);WrLn; *)
    ok:=getlc(endpos,S);
    IF NOT(ok) THEN RETURN ok;END;

    IF iscount THEN INC(endpos,startpos);DEC(endpos,1); END;

(* IO.WrLngCard(startpos,1);WrStr("  ..  ");IO.WrLngCard(endpos,1);WrLn; *)

    ok:=(startpos <= endpos);
    IF ok THEN count:=endpos-startpos+1; END;
    RETURN ok;
END parserangealt;

(* ------------------------------------------------------------ *)

CONST
    msgWorking= "Working, please wait...";
    UNDEFINED = MAX(LONGCARD);
    firstparm = 1;
    maxparm   = 3; (* src dst pass *)
VAR
    i,parmcount,lastparm,opt,wanted,got,currpasschar : CARDINAL;
    S,R,T,source,target:pathtype;
    useLFN,overwrite,overwriteRO,verbose, DEBUG,testing : BOOLEAN;
    parm : ARRAY[firstparm..maxparm] OF pathtype;
    hin,hout:FIO.File;
    fpos,flen,fsize,flast,remaining:LONGCARD;
    b1,b2,br : BYTE;
    poslenspecified,rangespecified:CARDINAL;
BEGIN
    FIO.IOcheck := FALSE; (* don't let topspeed handle problems *)
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)
    Lib.DisableBreakCheck();
    WrLn;

    overwrite       := FALSE;
    overwriteRO     := FALSE;
    verbose         := TRUE;
    testing         := FALSE;
    DEBUG           := FALSE;
    fpos            := UNDEFINED;
    flen            := UNDEFINED;
    lastparm        := firstparm-1;
    poslenspecified := 0;
    rangespecified  := 0;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "DEBUG"+delim+
                                  "O"+delim+"OVERWRITE"+delim+
                                  "OO"+delim+
                                  "F:"+delim+"POS:"+delim+"FPOS:"+delim+
                                  "L:"+delim+"LEN:"+delim+"LENGTH:"+delim+
                                  "Q"+delim+"QUIET"+delim+
                                  "TEST"+delim+"TESTING"+delim+"NOXOR"+delim+
                                  "P:"+delim+"POS:"

                              );
            CASE opt OF
            | 1,2,3   : abort(errHelp,"");
            | 4       : DEBUG:=TRUE;
            | 5,6     : overwrite:=TRUE;
            | 7       : overwrite:=TRUE; overwriteRO:=TRUE;
            | 8,9,10  : IF getval(fpos,R)=FALSE THEN abort(errVal,S);END;
                        INC(poslenspecified);
            |11,12,13 : IF getval(flen,R)=FALSE THEN abort(errVal,S);END;
                        INC(poslenspecified);
            |14,15    : verbose := FALSE;
            |16,17,18 : testing:=TRUE; (* undocumented *)
            | 19,20   : GetString(S,T);
                        IF parserangealt(fpos,flen,T)=FALSE THEN abort(errRange,S);END;
                        INC(rangespecified);
            ELSE
                abort(errOption,S);
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errParameterOverflow,"");END;
            Str.Copy(parm[lastparm],S); (* keep case *)
        END;
    END;
    CASE lastparm OF
    | firstparm -1 : abort(errExpected,"<source>");
    | firstparm    : abort(errExpected,"<target>");
    | firstparm +1 : abort(errExpected,"<passphrase>");
    | firstparm +2 : S := parm[firstparm+2];
                     lastpasschar := parsePassphrase( passphrasebuffer, S );
                     IF lastpasschar = MAX(CARDINAL) THEN abort(errPassphrase,S);END;
    END;

    useLFN:=fileSupportLFN();

    source := parm[firstparm];
    target := parm[firstparm+1];

    IF chkJoker(source) THEN abort(errJoker,source);END;
    IF chkJoker(target) THEN abort(errJoker,target);END;

    IF fileExists(useLFN,source)=FALSE THEN abort(errNotFound,source);END;
    IF fileExists(useLFN,target) THEN
        IF fileIsRO(useLFN,target) THEN
            IF overwriteRO=FALSE THEN abort(errRO,target);END;
            fileSetRO(useLFN,target);
        END;
    END;

    IF ( (rangespecified # 0) AND (poslenspecified # 0) ) THEN abort(errPosCountTwice,"");END;

    fsize:=fileGetFileSize(useLFN,source);
    IF fpos # UNDEFINED THEN
        IF fpos >= fsize THEN abort(errFpos,""); END; (* 0..9 10 *)
        IF flen # UNDEFINED THEN
            flast := fpos + flen -1; (* 0..9 8+2 8..9 *)
            IF flast >= fsize THEN abort(errFlen,"");END;
        END;
    END;

    IF DEBUG THEN
        WrStr("Passphrase (hex) :");
        FOR i:=firstpasschar TO lastpasschar DO
            WrStr(" ");
            WrStr(fmtnum( LONGCARD( passphrasebuffer[i] ) , 16,2) );
        END;
        WrLn;
        WrStr("fpos             : ");
        IF fpos = UNDEFINED THEN
            R:="0 (default)";
        ELSE
            Str.Copy(R, fmtnum(fpos,10,1)) ;
        END;
        WrStr(R);WrLn;
        WrStr("flen             : ");
        IF flen = UNDEFINED THEN
            R:="~ (default)";
            Str.Subst(R,"~",fmtnum(fsize,10,1));
        ELSE
            Str.Copy(R, fmtnum(flen,10,1)) ;
        END;
        WrStr(R);WrLn;
    END;

    hin:=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hin,ioBufferSource);
    hout:=fileCreate(useLFN,target);
    FIO.AssignBuffer(hout,ioBufferTarget);

    FIO.EOF:=FALSE; (* useless safety *)

    IF fpos = UNDEFINED THEN
        IF flen = UNDEFINED THEN
            remaining := fsize;
        ELSE
            remaining := flen;
        END;
    ELSE
        FIO.Seek(hin,fpos);
        IF flen = UNDEFINED THEN
            remaining := fsize - fpos;
        ELSE
            remaining := flen;
        END;
    END;
    IF DEBUG THEN
        WrStr("remaining        : ");
        Str.Copy(R,fmtnum(remaining,10,1) );
        WrStr(R);WrLn;
    END;
    IF verbose THEN video(msgWorking,TRUE);END;

    currpasschar :=  firstpasschar;
    LOOP
        IF remaining = 0 THEN EXIT; END;
        IF remaining > dataBufferSize THEN
            wanted := dataBufferSize;
            DEC(remaining,dataBufferSize);
        ELSE
            wanted := CARDINAL(remaining);
            remaining := 0;
        END;
        got := FIO.RdBin(hin,databuffer,wanted);
        IF NOT(testing) THEN
            FOR i:=1 TO got DO
                b1 := databuffer[i-1];
                b2 := passphrasebuffer [currpasschar];
                br := BYTE( opXOR( CARDINAL(b1), CARDINAL(b2) ) );
(*
S:="~ : ~ xor ~ = ~";
Str.Subst(S,"~",fmtnum(LONGCARD (i),10,1));
Str.Subst(S,"~",fmtnum(LONGCARD(b1),16,2));
Str.Subst(S,"~",fmtnum(LONGCARD(b2),16,2));
Str.Subst(S,"~",fmtnum(LONGCARD(br),16,2));
WrStr(S);WrLn;
*)
                databuffer[i-1] := br;
                INC(currpasschar);
                IF currpasschar > lastpasschar THEN currpasschar := firstpasschar; END;
            END;
        END;
        FIO.WrBin(hout,databuffer,got);
    END;

    IF verbose THEN video(msgWorking,FALSE);END;
    fileClose(useLFN,hout);
    fileClose(useLFN,hin);

    (*
    S:= "+++ Source : ~"+nl+
        "+++ Target : ~";
    Str.Subst(S,"~",source);
    Str.Subst(S,"~",target);
    *)
    S:= '+++ "~" has been created.';
    Str.Subst(S,"~",target);
    WrStr(S);WrLn;

    abort (errNone,"");
END XOR.


