(* ---------------------------------------------------------------
Title         Q&D DLL Finder/Lister
Overview      Yet Another Completely Useless Program
Usage         see help
Notes
Bugs          a TopSpeed executable can be seen as an unknown WinEXE !
              some weird PE such as \windows\unisbt32.exe
              won't be analyzed (borland linker related bug)
              anyway, import_list will crash too...
              though pe_map will do fine !
Wish List     scan for m$ version infos whether ascii or unicrap
              (or leave it to peek ?)
              detect more packers ?

              reverse mode : looking for all programs using specified dll
              (we wrote such a thing aeons ago in PDS 7.0 as USING utility :
              ah, those were the Win16 days...)

              one of these days, remove //FIXHARD hard-coded values (passim)

              while searching modules without extension (win16 normally),
              we should check they're exe
              (for now, any $.* is a match, whether executable or not)

              maybe we should also display filesize and timestamp too ?

              if anything like windows in path,
              automagically try system[32] subdirs too ?

              include version infos (almost forgot them !)

              try and fix info parsing which is really NOT clever at all
              (too many assumptions, not handling complex cases
              such as multi languages : we should probably check version
              in specific order : US, FR, whatever...)

              check Win32 UPXed !

--------------------------------------------------------------- *)

MODULE DLLfind;

IMPORT Str;
IMPORT Lib;
IMPORT FIO;

FROM IO IMPORT WrStr, WrLn;

FROM Storage IMPORT Available,ALLOCATE,DEALLOCATE;

FROM QD_ASCII IMPORT dash, slash, nullchar, tabchar, cr, lf, nl, bs,
space, dot, deg, doublequote, quote, colon, percent, vbar,
blank, equal, dquote, charnull, singlequote, antislash, dollar,
star, backslash, coma, question, underscore, tabul, hbar,
comma, semicolon, diese, pound, openbracket, closebracket, tilde, exclam,
stardotstar, dotdot, escCh, escSet, letters, digits,
lettersUpp, lettersLow, openbrace, closebrace;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits, metaproc, getCli, argc, argv;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileExistsAlt,
fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileIsDirectorySpec,
fileClose;

(* ------------------------------------------------------------ *)

CONST
    arobas      = "@";
    extLST      = ".LST";
    extCOM      = ".COM";
    extINI      = ".INI";
    extEXE      = ".EXE";
    strPATH     = "PATH";
CONST
    strKERNEL   = "KERNEL";
    strKRNL386  = "KRNL386";   (* .exe *)
    strKRNL286  = "KRNL286";
    strKERNEL32 = "KERNEL32";  (* .dll *)
CONST
    patQuoted   = doublequote+star+doublequote;
    specSWP     = "*.SWP";
    specPAR     = "*.PAR";
    specPAGEFILE= "*\PAGEFILE.SYS"; (* was "?:\PAGEFILE.SYS" *)
    TOOMANY     = MAX(CARDINAL);

    sepa      = " : ";

CONST
    progEXEname   = "DLLFIND";
    progTitle     = "Q&D DLL Finder/Lister";
    progVersion   = "v1.1j";
    progCopyright = "by PhG";
    banner        = progTitle+" "+progVersion+" "+progCopyright;
CONST
    errNone            = 0;
    errHelp            = 1;
    errUnknownOption   = 2;
    errTooManyParms    = 3;
    errMissingSpec     = 4;
    errNotFound        = 5;
    errNotFile         = 6;
    errJokerList       = 7;
    errAborted         = 8;
    errNoMatch         = 9;
    errTooMany         = 10;
    errJokerPath       = 11;
    errShow            = 12;
    errNonsenseShowImports=13;
    errTooManySearchDirs=14;
    errWinOnly         = 15;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)

errmsg = nl+
banner+nl+
nl+
"Syntax : "+progEXEname+" <filespec|@filelist["+extLST+"]> [option]..."+nl+
nl+
"This program finds and lists (almost) all modules required by a Win<16|32>"+nl+
"executable (be it DLL, EXE, DRV, 386, SCR, FON, etc.)."+nl+
nl+
"  -d[d]   list only DOS executables (-dd = include DOS "+extCOM+" format programs)"+nl+
"  -w[w]   list only Win16 executables (-ww = -w -i)"+nl+
"  -p[p]   list only Win32 executables (-pp = -p -i)"+nl+
(* ///
'  -v[v]   list only Win<16|32> executables version data (-vv = "FileVersion" only)'+nl+
*)
"  -e[e]   list only executables (-ee = -e -t)"+nl+
"  -x      list only non-executables (-t forced, -i ignored)"+nl+
"  -n[n]   alternate display, keeping CRLFs to a minimum (-nn = -n -t)"+nl+
"  -t[t]   alternate display, triming leading spaces (-tt = -t -n)"+nl+
"  -q      do not list import libraries"+nl+
"  -i[i|k] show import libraries location (-ii = -ik = -i -k)"+nl+
"  -k      disable "+strKERNEL+" search for "+strKRNL386+", "+strKRNL286+" and "+strKERNEL32+" aliases"+nl+
"  -s      list path(s) searched in when -i option is specified, then terminate"+nl+
"  -![!]   create default "+progEXEname+extINI+" in current directory then terminate"+nl+
"          (-!! = overwrite existing "+progEXEname+extINI+", if any)"+nl+
"  -l      disable LFN support even if available"+nl+
nl+
(* "Support for Win32 PE executables is experimental, but it should work."+nl+
nl+
*)
"a) Note the list may not be complete, for a Windows executable"+nl+
"   can dynamically load a DLL not registered in import list."+nl+
"b) A filelist should contain either canonical pathnames,"+nl+
"   or mere filenames to be searched for in current directory."+nl+
"   Jokers are not allowed in filelist."+nl+
"c) -i option searches for import libraries in current directory,"+nl+
"   then in directories specified in "+strPATH+" environment variable,"+nl+
"   then in directories specified in "+progEXEname+extINI+nl+
"   if such a file is located in "+progEXEname+extEXE+" directory."+nl+
"   Duplicate directories are filtered out."+nl+
'   "'+dot+star+'" is appended to any module name without an extension.'+nl+
"d) "+progEXEname+extINI+" format is one directory per line :"+nl+
"   entries enclosed with double quotes are used with LFN support only,"+nl+
"   entries not enclosed with double quotes are used for DOS only."+nl+
"e) If module name is "+strKERNEL+" and if -i option was specified,"+nl+
"   program searches for "+strKRNL386+", "+strKRNL286+" and "+strKERNEL32+","+nl+
"   unless -k option was specified too."+nl+
"f) For obvious reasons, program will not try and analyze files matching"+nl+
"   "+specSWP+", "+specPAR+" and "+specPAGEFILE+" specifications."+nl;
(* ///
"f) -v[v] option is an experimental feature."+nl;
*)

VAR
    S  : str256; (* we may get a LFN *)
BEGIN
    CASE e OF
    | errHelp :
        WrStr(errmsg);
    | errUnknownOption:
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errTooManyParms:
        Str.Concat(S,einfo," is one parameter too many !");
    | errMissingSpec:
        S := "Missing <filespec> or <@filelist["+extLST+"]> !";
    | errNotFound:
        Str.Concat(S,einfo," does not exist !");
    | errNotFile:
        Str.Concat(S,einfo," looks like a directory !");
    | errJokerList:
        S := "Jokers are not allowed in <filelist["+extLST+"]> !";
    | errAborted:
        S := "Aborted by user !";
    | errNoMatch:
        S := "No file matches <filespec>";
    | errTooMany:
        S := "Storage.ALLOCATE() failure !"; (* or 65535 matches ! *)
        S := "Too many files !";
    | errJokerPath:
        S := "Jokers are not allowed in path !";
    | errShow:
        S := "-d[d], -w[w], -p[p], -e and -x options are mutually exclusive !";
    | errNonsenseShowImports:
        S := "-t and -i options are mutually exclusive !";
    | errTooManySearchDirs:
        S := "Storage.ALLOCATE() failure !"; (* or 65535 matches ! *)
        S := "Too many directories !";
    | errWinOnly:
        S := "-v[v] option requires either -w[w] option or -p[p] option !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    showtype = (showall,showDOS,showWin16,showWin32,showNotEXE,showDOSexecom,showAllEXECUTABLE);

PROCEDURE chkcmd (VAR show:showtype; wanted:showtype):BOOLEAN;
VAR
    rc:BOOLEAN;
BEGIN
    rc:=TRUE;
    IF show = showall THEN
        show:=wanted;
    ELSE
        IF show # wanted THEN rc:=FALSE; END;
    END;
    RETURN rc;
END chkcmd;

PROCEDURE chkJokerPath (spec:pathtype  ):BOOLEAN;
VAR
    S,u,d,n,e:pathtype;
BEGIN
    Lib.SplitAllPath(spec,u,d,n,e);
    Lib.MakeAllPath(S,u,d,"","");
    RETURN chkJoker(S);
END chkJokerPath;

(* Str.Match is not case sensitive *)

PROCEDURE isReservedPattern (S:ARRAY OF CHAR):BOOLEAN;
BEGIN
    IF Str.Match(S,specSWP) THEN RETURN TRUE; END;
    IF Str.Match(S,specPAR) THEN RETURN TRUE; END;
    RETURN Str.Match(S,specPAGEFILE);
END isReservedPattern;

PROCEDURE isReservedEntry (S : ARRAY OF CHAR) : BOOLEAN; (* assume uppercase *)
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    IF same(S,dotdot) THEN RETURN TRUE; END;
    RETURN isReservedPattern(S);
END isReservedEntry;

PROCEDURE fmtbignum (v:LONGCARD; base:CARDINAL;wi:INTEGER; pad:CHAR ):str16;
VAR
    S:str16;
    ok:BOOLEAN;
    i : CARDINAL;
BEGIN
    Str.CardToStr( v, S, base,ok);
    FOR i:=Str.Length(S)+1 TO ABS(wi) DO
         IF wi < 0 THEN
             Str.Append(S,pad);
         ELSE
             Str.Prepend(S,pad);
         END;
    END;
    IF base=16 THEN Str.Lows(S);END;
    RETURN S;
END fmtbignum;

PROCEDURE fmtnum ( v:CARDINAL; base:CARDINAL;wi:INTEGER; pad:CHAR ):str16;
BEGIN
    RETURN fmtbignum( LONGCARD(v),base,wi,pad);
END fmtnum;

(* ------------------------------------------------------------ *)

CONST
    firstEntry = 1; (* 1..count *)
TYPE
    ptrToEntry = POINTER TO entryType;
    entryType = RECORD
        next   : ptrToEntry;
        slen   : CARDINAL; (* a SHORTCARD would do fine in almost all cases  *)
        string : CHAR;      (* here, after other data, because variable length *)
    END;

PROCEDURE store (VAR newInList,anchor:ptrToEntry; VAR lastEntry:CARDINAL;
                S:pathtype):BOOLEAN ;
VAR
    len,needed:CARDINAL;
    rc:BOOLEAN;
BEGIN
    INC(lastEntry);
    IF lastEntry=TOOMANY THEN RETURN FALSE;END; (* too many files but fake storage ALLOCATE failure here *)

    len:=Str.Length(S);
    needed:=SIZE(entryType)-SIZE(CHAR)+len;
    rc:= Available(needed);
    IF rc THEN
        CASE lastEntry OF
        | firstEntry :
            ALLOCATE( anchor,needed);
            newInList := anchor;
        ELSE
            ALLOCATE(newInList^.next,needed);
            newInList :=newInList^.next;
        END;
        Lib.FastMove( ADR(S),ADR(newInList^.string),len);
        newInList^.slen := len;
        newInList^.next := NIL;
    END;
    RETURN rc;
END store;

PROCEDURE buildMatchList (VAR anchor:ptrToEntry;
                          useLFN:BOOLEAN;spec:pathtype):CARDINAL;
VAR
    S,u,d,n,e,dirbase,filespec:pathtype; (* some are oversized but safety first ! *)
    newInList : ptrToEntry;
    lastEntry: CARDINAL;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    DOSentry     : FIO.DirEntry;
    rc,found:BOOLEAN;
    dosattr:FIO.FileAttr;
BEGIN
    Lib.SplitAllPath(spec,u,d,n,e);
    Lib.MakeAllPath(dirbase,u,d,"","");
    fixDirectory(dirbase);
    Lib.MakeAllPath(filespec,"","",n,e);

    lastEntry:=firstEntry-1;
    anchor:=NIL;

    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,everything,DOSentry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(S,w9Xentry.fullfilename);
        ELSE
            Str.Copy(S,DOSentry.Name);
        END;
        IF isReservedEntry(S) THEN (* skip "." ".." "*.SWP" "*.PAR" *)
            ; (* silently ignore this spec *)
        ELSE
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=DOSentry.attr;
            END;
            IF NOT (aD IN dosattr) THEN
                Str.Prepend(S,dirbase);
                IF store(newInList,anchor,lastEntry,S)=FALSE THEN
                    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN TOOMANY; (* storage ALLOCATE failure or too many files *)
                END;
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(DOSentry);
        END;
    END;
    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN lastEntry;
END buildMatchList;

PROCEDURE freeMatchList (anchor:ptrToEntry);
VAR
    len,needed      : CARDINAL;
    firstInList,newInList   : ptrToEntry;
BEGIN
    firstInList := anchor;
    newInList := firstInList;
    WHILE newInList # NIL DO
        len         := CARDINAL(newInList^.slen);
        needed      := SIZE(entryType)-SIZE(CHAR)+len;
        firstInList := firstInList^.next;
        DEALLOCATE (newInList,needed);
        newInList := firstInList;
    END
END freeMatchList;

PROCEDURE getMatchEntry (VAR R:pathtype;
                         n:CARDINAL; anchor:ptrToEntry);
VAR
    i,len:CARDINAL;
    newInList:ptrToEntry;
    S:pathtype;
BEGIN
    newInList := anchor;
    DEC(n); (* trick to force to anchor if 1, and locate correct string if > 1 *)
    FOR i:=firstEntry TO n DO
         newInList := newInList^.next;
    END;
    len         := newInList^.slen;
    Lib.FastMove( ADR(newInList^.string),ADR(S),len);
    S[len]      := nullchar; (* REQUIRED safety ! *)
    Str.Copy(R,S); (* yep, compiler won't let us fill R directly *)
END getMatchEntry;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ioBufferSize      = (8 * 512) + FIO.BufferOverhead;
    firstioBufferByte = 1;
    lastioBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstioBufferByte..lastioBufferByte] OF BYTE;
VAR
    ioBufferList,ioBufferIn : ioBufferType; (* iobufferlist used for ini and list *)

(* ------------------------------------------------------------ *)

PROCEDURE showstr (plusnl:BOOLEAN; S,R:ARRAY OF CHAR):str128;
CONST
    wi = 20;
VAR
    i : CARDINAL;
    Z: str128;
BEGIN
    Str.Copy(Z,S);
    FOR i:=Str.Length(S)+1 TO wi DO Str.Append(Z," ");END;
    Str.Append(Z,sepa);
    Str.Append(Z,R);
    IF plusnl THEN Str.Append(Z,nl); END;
    RETURN Z;
END showstr;

PROCEDURE showval (plusnl:BOOLEAN;  v:LONGCARD;S:ARRAY OF CHAR  ):str128;
VAR
    R:str128;
BEGIN
    Str.Concat(R,"$", fmtbignum(v,16,8,"0") );
    RETURN showstr(plusnl,S,R);
END showval;

PROCEDURE showaddr ( plusnl:BOOLEAN; h:FIO.File; S:ARRAY OF CHAR ):str128;
VAR
    addr:LONGCARD;
BEGIN
    addr:=FIO.GetPos(h);
    RETURN showval(plusnl,addr,S);
END showaddr;

(* ------------------------------------------------------------ *)

PROCEDURE readStringZ (hin:FIO.File;pos:LONGCARD;VAR R:ARRAY OF CHAR);
VAR
    wanted,got : CARDINAL;
    ch  : CHAR;
BEGIN
    wanted:=SIZE(ch);
    FIO.Seek(hin,pos);
    Str.Copy(R,"");
    LOOP
        got:=FIO.RdBin(hin,ch,wanted);
        IF got # wanted THEN ch:=nullchar;END; (* hide error *)
        Str.Append(R,ch);
        IF ch=nullchar THEN EXIT; END;
    END;
END readStringZ;

PROCEDURE readStringZU (hin:FIO.File;pos:LONGCARD;VAR R:ARRAY OF CHAR);
VAR
    wanted,got : CARDINAL;
    ch  : CHAR;
BEGIN
    wanted:=SIZE(ch);
    FIO.Seek(hin,pos);
    Str.Copy(R,"");
    LOOP
        got:=FIO.RdBin(hin,ch,wanted);
        IF got # wanted THEN ch:=nullchar;END; (* hide error *)
        Str.Append(R,ch);
        IF ch=nullchar THEN EXIT; END;
        got:=FIO.RdBin(hin,ch,wanted); (* $00 *)
        IF got # wanted THEN EXIT;END;
    END;
END readStringZU;

PROCEDURE readString (hin:FIO.File;pos:LONGCARD;len:CARDINAL;VAR R:ARRAY OF CHAR);
VAR
    got : CARDINAL;
BEGIN
    FIO.Seek(hin,pos);
    got:=FIO.RdBin(hin,R,len);
    IF got = len THEN
        R[got]:=nullchar; (* brutal ! *)
    ELSE
        Str.Copy(R,""); (* error *)
    END;
END readString;

PROCEDURE readByte (hin:FIO.File; pos:LONGCARD):BYTE;
VAR
    b:BYTE;
    wanted,got:CARDINAL;
BEGIN
    wanted:=SIZE(b);
    FIO.Seek(hin,pos);
    got:=FIO.RdBin(hin,b,wanted);
    IF got # wanted THEN b:=0;END; (* ignore errors *)
    RETURN b;
END readByte;

PROCEDURE readWord (hin:FIO.File; pos:LONGCARD):WORD;
VAR
    w:WORD;
    wanted,got:CARDINAL;
BEGIN
    wanted:=SIZE(w);
    FIO.Seek(hin,pos);
    got:=FIO.RdBin(hin,w,wanted);
    IF got # wanted THEN w:=0;END; (* ignore errors *)
    RETURN w;
END readWord;

PROCEDURE readDword (hin:FIO.File; pos:LONGCARD):LONGWORD;
VAR
    d:LONGWORD;
    wanted,got:CARDINAL;
BEGIN
    wanted:=SIZE(d);
    FIO.Seek(hin,pos);
    got:=FIO.RdBin(hin,d,wanted);
    IF got # wanted THEN d:=0;END; (* ignore errors *)
    RETURN d;
END readDword;

(* ------------------------------------------------------------ *)

PROCEDURE readCurrStringZU (hin:FIO.File;DEBUG:BOOLEAN; VAR R:ARRAY OF CHAR);
VAR
    wanted,got : CARDINAL;
    ch,unicrap  : CHAR;
BEGIN
IF DEBUG THEN WrStr( showval( TRUE, FIO.GetPos(hin),"readstrZU") );END;
    wanted:=SIZE(ch);
    Str.Copy(R,"");
    LOOP
        got:=FIO.RdBin(hin,ch,wanted);
        IF got # wanted THEN ch:=nullchar;END; (* hide error *)
        Str.Append(R,ch);
        got:=FIO.RdBin(hin,unicrap,wanted); (* $00 *)
        IF got # wanted THEN EXIT;END;
        IF ch=nullchar THEN EXIT; END;
    END;
END readCurrStringZU;

PROCEDURE readCurrStringU (hin:FIO.File;DEBUG:BOOLEAN; len:CARDINAL; VAR R:ARRAY OF CHAR);
VAR
    i,wanted,got : CARDINAL;
    ch,unicrap  : CHAR;
BEGIN
IF DEBUG THEN WrStr( showval( TRUE, FIO.GetPos(hin),"readstrU start") );END;
    wanted:=SIZE(ch);
    Str.Copy(R,"");
    FOR i:= 1 TO len DO
        got:=FIO.RdBin(hin,ch,wanted);
        IF got # wanted THEN ch:=nullchar;END; (* hide error *)
        Str.Append(R,ch);
        got:=FIO.RdBin(hin,unicrap,wanted); (* $00 *)
        IF got # wanted THEN RETURN;END;
        IF ch=nullchar THEN RETURN; END;
    END;
IF DEBUG THEN WrStr( showval( TRUE, FIO.GetPos(hin),"readstrU end") );END;
END readCurrStringU;

PROCEDURE readCurrWord (hin:FIO.File;DEBUG:BOOLEAN):WORD;
VAR
    w:WORD;
    wanted,got:CARDINAL;
BEGIN
IF DEBUG THEN WrStr( showval( TRUE, FIO.GetPos(hin),"readcurrword") );END;
    wanted:=SIZE(w);
    got:=FIO.RdBin(hin,w,wanted);
    IF got # wanted THEN w:=0;END; (* ignore errors *)
    RETURN w;
END readCurrWord;

PROCEDURE readCurrByte (hin:FIO.File):BYTE;
VAR
    b:BYTE;
    wanted,got:CARDINAL;
BEGIN
    wanted:=SIZE(b);
    got:=FIO.RdBin(hin,b,wanted);
    IF got # wanted THEN b:=0;END; (* ignore errors *)
    RETURN b;
END readCurrByte;

(* ------------------------------------------------------------ *)

CONST
    idNotEXE          = 1; (* maybe COM format *)
    idNotPackedDOSexe = 2; (* almost certainly a DOS executable *)
    idUnknownWinEXE   = 3; (* almost certainly a packed DOS executable *)
    idNE              = 4;
    idLE              = 5;
    idW3              = 6;
    idW4              = 7;
    idPE              = 8;
    idCOM             = 9;
    idLZ090           = 10;
    idLZ091           = 11;
    idPKLITE          = 12;
    idLHASFX          = 13;
    idTScrunch        = 14;
    idUPXdos          = 15;
    idUPXwin          = 16;

PROCEDURE getdesc (id:CARDINAL; VAR R:ARRAY OF CHAR);
VAR
    S:str128;
BEGIN
    CASE id OF
    | idNotEXE :         S:="Not an executable";
    | idNotPackedDOSexe: S:="DOS executable (probably not packed)";
    | idUnknownWinEXE:   S:="DOS executable (probably packed)";
    | idNE:              S:="NE Win16 executable";
    | idLE:              S:="LE Win16 VxD";
    | idW3:              S:="W3 Win16 collection of VxDs";
    | idW4:              S:="W4 Win9x VxD";
    | idPE:              S:="PE Win32 executable";
    | idCOM:             S:="DOS program (COM format)"; (* assumption based upon file extension ! *)
    | idLZ090:           S:="DOS executable (packed with LZEXE 0.90)";
    | idLZ091:           S:="DOS executable (packed with LZEXE 0.91)";
    | idPKLITE:          S:="DOS executable (packed with PKLITE)";
    | idLHASFX:          S:="DOS executable (LHA 2.x self-extracting archive)";
    | idTScrunch:        S:="DOS executable (packed with TopSpeed CRUNCH)";
    | idUPXdos:          S:="DOS executable (packed with UPX)";
    | idUPXwin:          S:="Win executable (packed with UPX)";
    ELSE
                         S:="???";
    END;
    Str.Copy(R,S);
END getdesc;

PROCEDURE chkEXE (hin:FIO.File; VAR winheaderpos:LONGCARD):CARDINAL ;
CONST
    sigMZ = ( ORD("M") + (ORD("Z") << 8) );
    sigZM = ( ORD("Z") + (ORD("M") << 8) );
    sigNE = ( ORD("N") + (ORD("E") << 8) );
    sigLE = ( ORD("L") + (ORD("E") << 8) );
    sigW3 = ( ORD("W") + (ORD("3") << 8) );
    sigW4 = ( ORD("W") + (ORD("4") << 8) );
    sigPE = ( ORD("P") + (ORD("E") << 8) );
CONST
    jpimagic1 = 0001H;
    jpimagic2 = 018AH;
    jpimagic3 = 1565H;
VAR
    tsmagic:ARRAY[1..3] OF CARDINAL;
    id,magic,addr:CARDINAL;
    R:str16;
BEGIN
    magic:=readWord(hin,000H);
    CASE magic OF
    | sigMZ,sigZM:
        addr:=readWord(hin,018H); (* //FIXHARD *)
        IF addr < 040H THEN
            readString (hin, 01CH, 4, R);
            IF same(R,"LZ09") THEN RETURN idLZ090; END;
            IF same(R,"LZ91") THEN RETURN idLZ091; END;
            readString(hin, 01EH, 6, R);
            IF same(R,"PKLITE") THEN RETURN idPKLITE; END;
            readString(hin, 024H, 10, R); Str.Caps(R);
            IF same(R,"LHA'S SFX ") THEN RETURN idLHASFX; END;
            readString(hin, 055H,  3, R);
            IF same(R,"UPX") THEN RETURN idUPXdos; END;

            id:=idNotPackedDOSexe; (* default *)

            tsmagic[1]:=readWord(hin, 01CH);
            tsmagic[2]:=readWord(hin, 01EH);
            tsmagic[3]:=readWord(hin, 020H);
            IF tsmagic[1] = jpimagic1 THEN
                IF tsmagic[2] = jpimagic2 THEN
                    IF tsmagic[3] = jpimagic3 THEN id:=idTScrunch; END;
                END;
            END;
        ELSE
            winheaderpos:=readDword(hin,03CH); (* //FIXHARD *)
            IF winheaderpos=0 THEN (* unlikely *)
                id:=idNotPackedDOSexe;
            ELSE
                magic:=readWord(hin,winheaderpos);
                CASE magic OF
                | sigNE: id:=idNE; (* NE Windows or OS/2 1.x segmented ("new") executable *)
                | sigLE: id:=idLE; (* LE Windows virtual device driver (VxD) linear executable *)
                | sigW3: id:=idW3; (* W3 Windows WIN386.EXE file; a collection of LE files *)
                | sigW4: id:=idW4; (* W4 Windows95 VMM32.VXD file *)
                | sigPE: id:=idPE; (* PE Win32 (Windows NT and Win32s) portable executable based on Unix COFF *)
                ELSE
                    (* a few DOS packers can have addr >= 40H, so we must test them here too *)
                    readString(hin, 01EH, 6, R);
                    IF same(R,"PKLITE") THEN RETURN idPKLITE; END;
                    (* check upx just in case *)
                    readString(hin, 055H,  3, R);
                    IF same(R,"UPX") THEN RETURN idUPXdos; END;
                    id:=idUnknownWinEXE; (* default *)
                    tsmagic[1]:=readWord(hin, 01CH);
                    tsmagic[2]:=readWord(hin, 01EH);
                    tsmagic[3]:=readWord(hin, 020H);
                    IF tsmagic[1] = jpimagic1 THEN
                        IF tsmagic[2] = jpimagic2 THEN
                            IF tsmagic[3] = jpimagic3 THEN id:=idTScrunch; END;
                        END;
                    END;
                END;
            END;
        END;
    ELSE
        id:=idNotEXE;
    END;
    RETURN id;
END chkEXE;

(* ------------------------------------------------------------ *)

CONST
    sERR      = "--- ";
    sOK       = "+++ ";
    sINFO     = "::: ";
    sPrefix   = "    ";
    sPrefixLong=sPrefix; (* was +sPrefix *)
    sACHTUNG  = ":!: WARNING ! ";
    sBANG     = ":-: WARNING ! ";
    sBAR      = ":+: ";
    sJoker    = "Joker(s) ";
    sDir      = "Directory";
    sFNF      = "Not found";
    sMod      = sPrefixLong;
    sNoModule = sACHTUNG+"No explicitely referenced module !";
    sModPathFound   = sMod+sPrefix+sBAR; (* "Found : " *)
    sModPathNotFound= sMod+sPrefix+sBANG+
                      "Module was not found in any of searched paths !";

PROCEDURE dmperrmsg (addNL:BOOLEAN; S1,S2,S3:ARRAY OF CHAR);
BEGIN
    WrStr(S1);WrStr(S2);WrStr(sepa);
    WrStr(doublequote); WrStr(S3); WrStr(doublequote);WrLn;
    IF addNL THEN WrLn; END;
END dmperrmsg;

PROCEDURE msg (S1,S2:ARRAY OF CHAR );
BEGIN
    WrStr(S1); WrStr(doublequote); WrStr(S2); WrStr(doublequote); WrLn;
END msg;

PROCEDURE dmp (addNL,dotrim:BOOLEAN; S1,S2:ARRAY OF CHAR );
VAR
    S : str1024;
BEGIN
    IF dotrim THEN
        Str.Concat(S,S1,S2);
        LtrimBlanks(S);
        WrStr(S);WrLn;
    ELSE
        WrStr(S1);WrStr(S2);WrLn;
    END;
    IF addNL THEN WrLn;END;
END dmp;

(* ------------------------------------------------------------ *)

PROCEDURE dmpMod (lastsearchdir:CARDINAL;diranchor:ptrToEntry;
                 showlibpath,useLFN,addNL,dotrim:BOOLEAN; S1,S2:ARRAY OF CHAR);
VAR
    i,found:CARDINAL;
    D,S:pathtype;
BEGIN
    dmp(addNL,dotrim,S1,S2);

    IF showlibpath THEN
        IF Str.RCharPos(S2,dot)=MAX(CARDINAL) THEN (* win16 *)
            Str.Append(S2,dot+star);
        END;
        found:=0;
        FOR i:=firstEntry TO lastsearchdir DO
            getMatchEntry (D, i,diranchor); (* trailing "\" already here *)
            Str.Concat(S,D,S2);
            IF fileExistsAlt(useLFN,S) THEN
                INC(found);
                WrStr(sModPathFound);
                WrStr(doublequote);WrStr(S);WrStr(doublequote);WrLn; (* was D *)
            END;
        END;
        IF found = 0 THEN WrStr(sModPathNotFound);WrLn; END;
    END;
END dmpMod;

PROCEDURE dmpThisMod (VAR kernelhere:CARDINAL;
                     lastsearchdir:CARDINAL;diranchor:ptrToEntry;
                     showlibpath,fixkernel,useLFN,addNL,dotrim:BOOLEAN;
                     sMod,moduleName:ARRAY OF CHAR);
VAR
    ok:BOOLEAN;
BEGIN
    ok:=TRUE;
    IF showlibpath THEN
        IF same(moduleName,strKERNEL) THEN
            INC(kernelhere);
            ok:=NOT(fixkernel);
        END;
    END;
    IF ok THEN
        dmpMod(lastsearchdir,diranchor,showlibpath,useLFN,FALSE,dotrim,sMod,moduleName);
    END;
END dmpThisMod;

PROCEDURE kernelKludge (kernelhere:CARDINAL;
                     lastsearchdir:CARDINAL;diranchor:ptrToEntry;
                     showlibpath,fixkernel,useLFN,addNL,dotrim:BOOLEAN;
                     sMod,moduleName:ARRAY OF CHAR);
BEGIN
    IF kernelhere # 0 THEN
        IF fixkernel THEN
            Str.Copy(moduleName,strKRNL386);
	        dmpMod(lastsearchdir,diranchor,showlibpath,useLFN,FALSE,dotrim,sMod,moduleName);
            Str.Copy(moduleName,strKRNL286);
	        dmpMod(lastsearchdir,diranchor,showlibpath,useLFN,FALSE,dotrim,sMod,moduleName);
            Str.Copy(moduleName,strKERNEL32);
	        dmpMod(lastsearchdir,diranchor,showlibpath,useLFN,FALSE,dotrim,sMod,moduleName);
        END;
    END;
END kernelKludge;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE displayModules16 (hin:FIO.File; winheaderpos:LONGCARD;
                           addNL,dotrim,showlibpath,fixkernel,useLFN,DEBUG:BOOLEAN;
                           lastsearchdir:CARDINAL; diranchor:ptrToEntry);
VAR
    n,mcount,modulesCount:CARDINAL;
    TableDesReferences,TableDesNomsImportes:CARDINAL;
    decalage,longueur : CARDINAL;
    tableau,modules:LONGCARD;
    S,moduleName:str128;
    kernelhere:CARDINAL;
BEGIN
    kernelhere:=0;
    modulesCount:=readWord(hin,winheaderpos + 01EH); (* //FIXHARD *)
    IF modulesCount = 0 THEN
	    dmp(addNL,dotrim,sPrefix,sNoModule); (* or unlikely read error but who cares ? *)
	    RETURN;
    END;
    TableDesReferences := readWord(hin, winheaderpos + 028H);
    TableDesNomsImportes:=readWord(hin, winheaderpos + 02AH);
    tableau:= winheaderpos+ LONGCARD(TableDesReferences);
    modules:= winheaderpos+ LONGCARD(TableDesNomsImportes);

    mcount:=0; (* restart for empty names such as found in a few Win32 executables *)
    FOR n := 1 TO modulesCount DO
	    decalage:=readWord(hin, tableau + LONGCARD((n - 1) << 1) );
	    longueur:=CARDINAL(readByte(hin, modules + LONGCARD(decalage)));
        readString(hin,modules+LONGCARD(decalage)+1,longueur,moduleName);
        IF same(moduleName,"")=FALSE THEN
            INC(mcount);
            dmpThisMod(kernelhere, lastsearchdir,diranchor,showlibpath,fixkernel,useLFN,FALSE,dotrim,sMod,moduleName);
        END;
    END;
    kernelKludge (kernelhere,lastsearchdir,diranchor,
                 showlibpath,fixkernel,useLFN,FALSE,dotrim,sMod,moduleName);
    IF mcount = 0 THEN (* different VAR here ! *)
	    dmp(addNL,dotrim,sPrefix,sNoModule); (* or unlikely read error but who cares ? *)
    END;
    IF addNL THEN WrLn; END;
END displayModules16;

(* ------------------------------------------------------------ *)

TYPE
    PEfileHeaderType = RECORD
        signature            : LONGCARD; (* 50 45 00 00 at $40 *)
        Machine              : CARDINAL;
        NumberOfSections     : CARDINAL; (* useful  *)
        TimeDateStamp        : LONGCARD;
        PointerToSymbolTable : LONGCARD;
        NumberOfSymbols      : LONGCARD;
        SizeOfOptionalHeader : CARDINAL;
        Characteristics      : CARDINAL;
    END;

TYPE
    PEoptionalHeaderType = RECORD
        Magic                       : CARDINAL;
        MajorLinkerVersion          : SHORTCARD;
        MinorLinkerVersion          : SHORTCARD;
        SizeOfCode                  : LONGCARD;
        SizeOfInitializedData       : LONGCARD;
        SizeOfUninitializedData     : LONGCARD;
        AddressOfEntryPoint         : LONGCARD;
        BaseOfCode                  : LONGCARD;
        BaseOfData                  : LONGCARD;
        ImageBase                   : LONGCARD;
        SectionAlignment            : LONGCARD;
        FileAlignment               : LONGCARD;
        MajorOperatingSystemVersion : CARDINAL;
        MinorOperatingSystemVersion : CARDINAL;
        MajorImageVersion           : CARDINAL;
        MinorImageVersion           : CARDINAL;
        MajorSubsystemVersion       : CARDINAL;
        MinorSubsystemVersion       : CARDINAL;
        Win32VersionValue           : LONGCARD;
        SizeOfImage                 : LONGCARD;
        SizeOfHeaders               : LONGCARD;
        CheckSum                    : LONGCARD;
        Subsystem                   : CARDINAL;
        DllCharacteristics          : CARDINAL;
        SizeOfStackReserve          : LONGCARD;
        SizeOfStackCommit           : LONGCARD;
        SizeOfHeapReserve           : LONGCARD;
        SizeOfHeapCommit            : LONGCARD;
        LoaderFlags                 : LONGCARD;
        NumberOfRvaAndSizes         : LONGCARD;
    END;

TYPE
    PEimageDirectoryType = RECORD
        strucaddr : LONGCARD;
        strucsize : LONGCARD;
    END;

CONST
    (* from WIN32 API headers *)
    IMAGE_DIRECTORY_ENTRY_EXPORT       =  0;   (* Export Directory *)
    IMAGE_DIRECTORY_ENTRY_IMPORT       =  1;   (* Import Directory *)
    IMAGE_DIRECTORY_ENTRY_RESOURCE     =  2;   (* Resource Directory *)
    IMAGE_DIRECTORY_ENTRY_EXCEPTION    =  3;   (* Exception Directory *)
    IMAGE_DIRECTORY_ENTRY_SECURITY     =  4;   (* Security Directory *)
    IMAGE_DIRECTORY_ENTRY_BASERELOC    =  5;   (* Base Relocation Table *)
    IMAGE_DIRECTORY_ENTRY_DEBUG        =  6;   (* Debug Directory *)
    IMAGE_DIRECTORY_ENTRY_COPYRIGHT    =  7;   (* Description String *)
    IMAGE_DIRECTORY_ENTRY_GLOBALPTR    =  8;   (* Machine Value (MIPS GP) *)
    IMAGE_DIRECTORY_ENTRY_TLS          =  9;   (* TLS Directory *)
    IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG  = 10;   (* Load Configuration Directory *)
    IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT = 11;   (* Bound Import Directory in headers *)
    IMAGE_DIRECTORY_ENTRY_IAT          = 12;   (* Import Address Table *)
    IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT   = 13; (* Delay Load Import Descriptors *)
    IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR = 14; (* COM Runtime descriptor *)

CONST
    (* image directory entries *)
    firstdirindex = 0;
    lastdirindex  = 15; (* not 14 ! *)
    IMPORTindex   = IMAGE_DIRECTORY_ENTRY_IMPORT;
    RESOURCEindex = IMAGE_DIRECTORY_ENTRY_RESOURCE;

TYPE
    PEdataDirectoriesType = ARRAY [firstdirindex..lastdirindex] OF PEimageDirectoryType;

TYPE
    PEsectionHeaderType = RECORD
        Name                 : ARRAY [0..7] OF CHAR; (* 0 terminated or 8 chars *)
        VirtualSize          : LONGCARD;
        VirtualAddress       : LONGCARD;
        SizeOfRawData        : LONGCARD;
        PointerToRawData     : LONGCARD; (* file offset *)
        PointerToRelocations : LONGCARD;
        PointerToLinenumbers : LONGCARD;
        NumberOfRelocations  : CARDINAL;
        NumberOfLinenumbers  : CARDINAL;
        Characteristics      : LONGCARD;
    END;

TYPE
    PEimageImportDescriptorType = RECORD
        OriginalFirstThunk : LONGCARD;
        TimeDateStamp      : LONGCARD;
        ForwarderChain     : LONGCARD;
        Name               : LONGCARD; (* // ASCIIZ *)
        FirstThunk         : LONGCARD;
    END;

(* last in structure is entirely zero according to PE.TXT *)

PROCEDURE isLastImportDesc (d:PEimageImportDescriptorType):BOOLEAN;
VAR
    n:CARDINAL;
BEGIN
    n:=5;
    IF d.OriginalFirstThunk=0 THEN DEC(n);END;
    IF d.TimeDateStamp=0      THEN DEC(n);END;
    IF d.ForwarderChain=0     THEN DEC(n);END;
    IF d.Name=0               THEN DEC(n);END;
    IF d.FirstThunk=0         THEN DEC(n);END;
    RETURN (n=0);
END isLastImportDesc;

PROCEDURE displayModules32 (hin:FIO.File; winheaderpos:LONGCARD;
                           addNL,dotrim,showlibpath,fixkernel,useLFN,DEBUG:BOOLEAN;
                           lastsearchdir:CARDINAL;diranchor:ptrToEntry );
VAR
    pefileheader     : PEfileHeaderType;
    peoptionalheader : PEoptionalHeaderType; (* required "optional" : go figure ! *)
    pedirindex       : PEdataDirectoriesType;
    pesectionheader  : PEsectionHeaderType;
    peimportdesc     : PEimageImportDescriptorType;
    i,got,wanted:CARDINAL;
    sectioncount : CARDINAL;
    importaddr,where,anchor,fpos,filealignment,sectionalignment  : LONGCARD;
    moduleName : str128; (* oversized *)
    modulesCount,kernelhere:CARDINAL;
BEGIN
    kernelhere:= 0;
    FIO.Seek(hin,winheaderpos);

IF DEBUG THEN WrStr(showaddr( TRUE, hin,"winheaderpos") ); END;
    wanted:=SIZE(pefileheader);
    got := FIO.RdBin(hin,pefileheader,wanted);
    IF got # wanted THEN RETURN; END; (* don't say anything about read error *)
    sectioncount:=pefileheader.NumberOfSections;
    IF sectioncount=0 THEN RETURN; END; (* problem ! *)

IF DEBUG THEN WrStr( showaddr( TRUE, hin,"peoptionalheader") ); END;
    wanted:=SIZE(peoptionalheader);
    got := FIO.RdBin(hin,peoptionalheader,wanted);
    IF got # wanted THEN RETURN; END;

    filealignment := peoptionalheader.FileAlignment;
    sectionalignment:=peoptionalheader.SectionAlignment;

IF DEBUG THEN WrStr( showaddr( TRUE, hin,"pedirindex") ); END;
    wanted:=SIZE(pedirindex);
    got := FIO.RdBin(hin,pedirindex,wanted);
    IF got # wanted THEN RETURN; END;

    importaddr:=pedirindex[IMPORTindex].strucaddr;

IF DEBUG THEN
WrStr( showval( TRUE, filealignment,"file alignment") );
WrStr( showval( TRUE, sectionalignment,"section alignment") );
WrStr( showaddr( TRUE, hin,"sections headers") );
END;

    i:=0;
    LOOP
        IF i >= sectioncount THEN EXIT; END; (* = is enough but... *)
        wanted:=SIZE(pesectionheader);
        got := FIO.RdBin(hin,pesectionheader,wanted);
        IF got # wanted THEN RETURN; END; (* file image problem ! abort ! *)
IF DEBUG THEN WrStr( showstr( TRUE, "section header name",pesectionheader.Name) );END;
        IF pesectionheader.VirtualAddress<=importaddr THEN
            IF importaddr < (pesectionheader.VirtualAddress+pesectionheader.SizeOfRawData) THEN
                (* WrStr(".rdata ! TAKE ME !");WrLn; *)
                EXIT;
            END;
        END;
        INC(i);
    END;
    IF i >= sectioncount THEN
        dmp(addNL,dotrim,sPrefix,sNoModule); (* or unlikely read error but who cares ? *)
        RETURN;
    END; (* problem ! abort ! *)

    (* now dump imports using current pesectionheader *)
    where:=importaddr-pesectionheader.VirtualAddress;
    INC(where,pesectionheader.PointerToRawData);
IF DEBUG THEN
WrStr( showval( TRUE, importaddr                      ,"import address") );
WrStr( showval( TRUE, pesectionheader.VirtualAddress  ,"Virtual address"));
WrStr( showval( TRUE, pesectionheader.SizeOfRawData   ,"Size of raw data"));
WrStr( showval( TRUE, pesectionheader.PointerToRawData,"Pointer to raw data"));
WrStr( showval( TRUE, where,"where") );
END;
    FIO.Seek(hin,where);

    modulesCount:=0;
    LOOP
        wanted:=SIZE(peimportdesc);
        got:=FIO.RdBin(hin,peimportdesc,wanted);
        IF got # wanted THEN EXIT; END;

        (* //FIXME! bad test, but zero length string is NOT better *)
        IF isLastImportDesc(peimportdesc) THEN WrLn;EXIT;END;

IF DEBUG THEN WrStr( showval( TRUE, peimportdesc.Name,"name") ); END;
        anchor:=FIO.GetPos(hin);

        fpos:=peimportdesc.Name-importaddr+where;
IF DEBUG THEN WrStr( showval( TRUE, fpos,"real name fpos") ); END;
        readStringZ(hin,fpos,moduleName);
        IF same(moduleName,"")=FALSE THEN
            INC(modulesCount);
            dmpThisMod(kernelhere, lastsearchdir,diranchor,showlibpath,fixkernel,useLFN,FALSE,dotrim,sMod,moduleName);
        END;
        (*
        yes, we could dump individual functions too...
        but we're not interested in them for now
        moreover, there are already many very good tools to do so
        *)

        FIO.Seek(hin,anchor);
    END;
    kernelKludge (kernelhere,lastsearchdir,diranchor,
                 showlibpath,fixkernel,useLFN,FALSE,dotrim,sMod,moduleName);
    IF modulesCount = 0 THEN
	    dmp(addNL,dotrim,sPrefix,sNoModule); (* or unlikely read error but who cares ? *)
    END;
END displayModules32;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE displayVersion (bits:CARDINAL;hin:FIO.File; winheaderpos:LONGCARD;
                           addNL,dotrim,showversiononly,DEBUG:BOOLEAN);
CONST
    sVersionInfosNotFound= sACHTUNG+"Version informations structure do not exist !";
VAR
    anchor:LONGCARD;
    ok:BOOLEAN;
BEGIN
    dmp(addNL,dotrim,sPrefixLong,"MaybeWare ! ;-)");
END displayVersion;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE checkit (fixkernel,useLFN,addNL,dotrim,showimports,showlibpath,
                  showversion,showversiononly,DEBUG:BOOLEAN;
                  lastsearchdir:CARDINAL;diranchor:ptrToEntry;
                  cmd:showtype;S:pathtype );
VAR
    oldEOF,ok:BOOLEAN;
    hin:FIO.File;
    rc:CARDINAL;
    desc:str128;
    winheaderpos:LONGCARD;
    id:CARDINAL;
BEGIN
    IF chkJoker(S) THEN
        dmperrmsg(addNL,sERR,sJoker,S);
        RETURN;
    END;
    IF fileIsDirectorySpec(useLFN,S) THEN
        dmperrmsg(addNL,sERR,sDir,S);
        RETURN;
    END;
    IF fileExists(useLFN,S)= FALSE THEN
        dmperrmsg(addNL,sERR,sFNF,S);
        RETURN;
    END;

    oldEOF:=FIO.EOF;

    hin:=fileOpenRead(useLFN,S);
    FIO.AssignBuffer(hin,ioBufferIn);

    id:=chkEXE(hin, winheaderpos);
    IF id = idNotEXE THEN (* further check needed *)
        (* assume file extension is correct ! we could check first byte is a JMP too *)
        IF Str.Match(S,star+extCOM) THEN (* case-insensitive *)
            id:=idCOM;
        END;
    END;
    getdesc(id,desc);

    ok:=FALSE;
    CASE cmd OF
    | showall:
        ok:=TRUE;
    | showDOS:
        CASE id OF
        | idNotPackedDOSexe,idLZ090,idLZ091,idPKLITE,
          idLHASFX,idTScrunch,idUPXdos,
          idUnknownWinEXE:
            ok:=TRUE;
        END;
    | showDOSexecom:
        CASE id OF
        | idNotPackedDOSexe,idLZ090,idLZ091,idPKLITE,
          idLHASFX,idTScrunch,idUPXdos,
          idUnknownWinEXE, idCOM:
            ok:=TRUE;
        END;
    | showWin16:
        CASE id OF
        | idNE, idLE, idW3:
            ok:=TRUE;
        END;
    | showWin32:
        CASE id OF
        | idW4,idPE:
            ok:=TRUE;
        END;
    | showNotEXE:
        CASE id OF
        | idNotEXE:
            ok:=TRUE;
        END;
    | showAllEXECUTABLE:
        CASE id OF
        | idNotEXE:
            ;
        ELSE
            ok:=TRUE;
        END;
    END;

    IF ok THEN msg(sOK,S); dmp(addNL,dotrim,sINFO,desc); END;
    CASE id OF
    | idNotEXE:
        ;
    | idNotPackedDOSexe,idLZ090,idLZ091,idPKLITE,
      idLHASFX,idTScrunch,idUPXdos, idCOM:
        ;
    | idUnknownWinEXE:
        ;
    | idNE, idLE, idW3:
		IF ok THEN
		    IF showversion THEN
                displayVersion (16,hin,winheaderpos,addNL,dotrim,showversiononly,DEBUG);
		    ELSE
		        IF showimports THEN
		            displayModules16 (hin,winheaderpos,addNL,dotrim,
		                             showlibpath,fixkernel,useLFN,DEBUG,
		                             lastsearchdir,diranchor);
		        END;
		    END;
		END;
    | idW4:
        ;
    | idPE:
        IF ok THEN
            IF showversion THEN
                displayVersion (32,hin,winheaderpos,addNL,dotrim,showversiononly,DEBUG);
            ELSE
                IF showimports THEN
                    displayModules32 (hin,winheaderpos,addNL,dotrim,showlibpath,
                                     fixkernel,useLFN,DEBUG,
                                     lastsearchdir,diranchor);
                END;
            END;
        END;
    END;

    FIO.Close(hin);
    FIO.EOF:=oldEOF;
END checkit;

(* ------------------------------------------------------------ *)

(* assume non-zero length *)

PROCEDURE unquote (VAR wasquoted:BOOLEAN; VAR S:pathtype);
BEGIN
    wasquoted:=Str.Match(S,patQuoted);
    IF wasquoted THEN ReplaceChar(S,doublequote,"");END;
END unquote;

PROCEDURE chkList (fixkernel,useLFN,addNL,dotrim,showimports,showlibpath,
                  showversion,showversiononly,DEBUG:BOOLEAN;
                  cmd:showtype; lastsearchdir:CARDINAL;diranchor:ptrToEntry;
                  list:pathtype  ):BOOLEAN;
VAR
    hlist:FIO.File;
    S:pathtype; (* more than oversized *)
    flagAbort,wasquoted:BOOLEAN;
BEGIN
    flagAbort:=FALSE;
    FIO.EOF:=FALSE;
    hlist:=fileOpenRead(useLFN,list);
    FIO.AssignBuffer(hlist,ioBufferList);
    LOOP
        IF FIO.EOF THEN EXIT; END;
        FIO.RdStr(hlist,S);
        IF FIO.EOF THEN EXIT; END;
        LtrimBlanks(S);
        RtrimBlanks(S);
        CASE S[0] OF
        | nullchar,semicolon,pound:
            ;
        ELSE
            unquote(wasquoted,S);
            IF isReservedEntry(S) = FALSE THEN
                checkit (fixkernel,useLFN,addNL,dotrim,showimports,showlibpath,
                        showversion,showversiononly,DEBUG,
                        lastsearchdir,diranchor, cmd,S);
            END;
        END;
        flagAbort:=ChkEscape();
        IF flagAbort THEN EXIT; END;
    END;
    fileClose(useLFN,hlist);
    RETURN flagAbort;
END chkList;

PROCEDURE chkMatches (fixkernel,useLFN,addNL,dotrim,showimports,showlibpath,
                     showversion,showversiononly,DEBUG:BOOLEAN;
                     cmd:showtype; lastfile,lastsearchdir:CARDINAL;anchor,diranchor:ptrToEntry):BOOLEAN;
VAR
    S:pathtype;
    flagAbort:BOOLEAN;
    i:CARDINAL;
BEGIN
    flagAbort:=FALSE;
    i:=firstEntry-1;
    LOOP
        INC(i);
        IF i > lastfile THEN EXIT; END;
        getMatchEntry(S, i,anchor);
        checkit (fixkernel,useLFN,addNL,dotrim,showimports,showlibpath,
                showversion,showversiononly,DEBUG,
                lastsearchdir,diranchor, cmd,S);
        flagAbort:=ChkEscape();
        IF flagAbort THEN EXIT; END;
    END;
    RETURN flagAbort;
END chkMatches;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE showpath (VAR dumped:CARDINAL;
                   flag:BOOLEAN;ndx:CARDINAL;diranchor:ptrToEntry;msg:ARRAY OF CHAR);
CONST
    wi = 4+3;
VAR
    S:pathtype;
BEGIN
    IF flag THEN
        IF dumped = 0 THEN WrLn;WrStr(sINFO);WrStr(msg);WrStr(" : ");WrLn;WrLn;END;
        INC(dumped);

        getMatchEntry (S, ndx,diranchor);
        WrStr(fmtnum(ndx,10,wi," ")); WrStr(" : ");WrStr(S);WrLn;
    END;
END showpath;

PROCEDURE chkNotDuplicate (diranchor:ptrToEntry;lastsearchdir:CARDINAL;
                          Z:pathtype):BOOLEAN;
VAR
    i:CARDINAL;
    S:pathtype;
BEGIN
    UpperCase(Z);
    FOR i:=firstEntry TO lastsearchdir DO
        getMatchEntry (S, i,diranchor);
        UpperCase(S);
        IF same(Z,S) THEN RETURN FALSE;END;
    END;
    RETURN TRUE;
END chkNotDuplicate;

(* VAR to speed process although we won't change string *)

PROCEDURE processme (VAR S : ARRAY OF CHAR ):BOOLEAN;
VAR
    ok:BOOLEAN;
BEGIN
    CASE S[0] OF
    | nullchar,semicolon,pound:
        ok:=FALSE;
    ELSE
        ok:=TRUE;
    END;
    RETURN ok;
END processme;

(* "u:\" or "u:\*\" *)

PROCEDURE doGetCurrentDir (useLFN:BOOLEAN; VAR current:pathtype);
VAR
    rc:CARDINAL;
    longform:pathtype;
    drive:SHORTCARD;
    unit:str2;
BEGIN
    drive := FIO.GetDrive();

    Str.Concat(unit, CHR( ORD("A")-1+ORD(drive) ),colon);

    FIO.GetDir(drive,current); (* \path without u: nor trailing \ except at root *)
    IF current[1] # colon THEN Str.Prepend(current,unit); END; (* safety *)
    IF useLFN THEN
        IF w9XshortToLong(current,rc,longform) THEN (* if error, keep DOS current *)
            Str.Copy(current,longform);
        END;
    END;
    (* LFN function seems to always return "u:\*" form except at root *)
    IF current[1] = colon THEN Str.Delete(current,0,2);END; (* safety *)
    fixDirectory(current);
    Str.Prepend(current,unit);
END doGetCurrentDir;

PROCEDURE buildSearchList (VAR diranchor:ptrToEntry;
                          useLFN,showlist:BOOLEAN ):CARDINAL;
VAR
    i,n,lastsearchdir:CARDINAL;
    S,F:pathtype;
    newInList:ptrToEntry;
    hin:FIO.File;
    keepme,wasquoted:BOOLEAN;
    dumped:CARDINAL;
BEGIN
    diranchor:=NIL;
    lastsearchdir:=firstEntry-1;

    (* there's always a first entry : current directory *)

    doGetCurrentDir(useLFN,S);
    IF store(newInList,diranchor,lastsearchdir,S)=FALSE THEN
        RETURN TOOMANY;
    END;
    dumped:=0;
    showpath(dumped,showlist,lastsearchdir,diranchor,"Current directory");

    (* now parse PATH if existing *)

    dumped:=0;
    Lib.EnvironmentFind(strPATH,F);
    LtrimBlanks(F);
    RtrimBlanks(F); (* probably useless *)
    Str.Append(F,semicolon); (* in case there's only one dir here *)
    n:=CharCount(F,semicolon);
    FOR i:=0 TO n DO (* 0-based ! too late to fix this quirk *)
        isoleItemS(S, F,semicolon,i);
        IF same(S,"")=FALSE THEN
            fixDirectory(S);
            IF store(newInList,diranchor,lastsearchdir,S)=FALSE THEN
                RETURN TOOMANY;
            END;
            showpath(dumped,showlist,lastsearchdir,diranchor,strPATH+" environment variable");
        END;
    END;

    (* now parse DLLFIND.INI if existing : quoted = LFNs only, else DOS only *)

    dumped:=0;
    Lib.ParamStr(F,0);
    Str.Caps(F); (* useless *)
    Str.Subst(F,extEXE,extINI);
    IF FIO.Exists(F) THEN
        FIO.EOF:=FALSE;
        hin:=FIO.OpenRead(F);
        FIO.AssignBuffer(hin,ioBufferList);
        LOOP
            IF FIO.EOF THEN EXIT; END;
            FIO.RdStr(hin,S);
            IF FIO.EOF THEN EXIT; END;
            LtrimBlanks(S);
            RtrimBlanks(S);
            IF processme(S) THEN
                unquote(wasquoted,S);
                IF wasquoted THEN
                    keepme:=useLFN;
                ELSE
                    keepme:=(useLFN=FALSE);
                END;
                IF keepme THEN
                    fixDirectory(S);
                    IF NOT(useLFN) THEN Str.Caps(S);END;
                    keepme:=chkNotDuplicate(diranchor,lastsearchdir,S);
                    IF keepme THEN
                        IF store(newInList,diranchor,lastsearchdir,S)=FALSE THEN
                            RETURN TOOMANY;
                        END;
                        showpath(dumped,showlist,lastsearchdir,diranchor,F);
                    END;
                END;
            END;
        END;
        FIO.Close(hin);
    END;
(*
IF DEBUG THEN
    FOR i:=firstEntry TO lastsearchdir DO
        getMatchEntry (S, i,diranchor);
        WrStr("::: Searched ");
        WrStr(fmtnum(i,10,3," ")); WrStr(" : ");WrStr(S);WrLn;
    END;
    WrLn;
END;
*)
    RETURN lastsearchdir;
END buildSearchList;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    defaultIni =
"; searched directories are :"+nl+
"; 1) current directory ;"+nl+
"; 2) directories found in PATH environment variable ;"+nl+
"; 3) directories specified in DLLFIND.INI"+nl+
nl+
"; without double quotes : DOS only"+nl+
nl+
"c:\dos\"+nl+
"c:\bat\"+nl+
"c:\windows"+nl+
"c:\windows\system"+nl+
nl+
"; with double quotes : LFN only"+nl+
nl+
'"c:\windows"'+nl+
'"c:\windows\system"'+nl+
'"c:\windows\system32"'+nl+
nl;

PROCEDURE genDefault (overwrite:BOOLEAN  ):BOOLEAN;
VAR
    hnd:FIO.File;
    S : str128;
BEGIN
    Str.Copy(S,progEXEname+extINI);
    IF NOT(overwrite) THEN
        IF FIO.Exists(S) THEN
            WrStr("--- ");WrStr(S);WrStr(" already exists !");WrLn;
            RETURN FALSE;
        END;
    END;
    hnd:=FIO.Create(S);
    FIO.WrStr(hnd,defaultIni);
    FIO.Close(hnd);
    WrStr("+++ ");WrStr(S);WrStr(" has been created.");WrLn;
    RETURN TRUE;
END genDefault;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE chkOpt (delim:CHAR;parmcount:CARDINAL; strOptions:ARRAY OF CHAR):BOOLEAN;
VAR
    i,opt,n:CARDINAL;
    S,R:pathtype; (* oversized but same as main parsing code *)
BEGIN
    n:=CharCount(strOptions,delim);
    INC(n);

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        UpperCase(S);
        IF isOption(S) THEN
            opt := GetOptIndex(S, strOptions);
            IF ( (opt < 1) OR (opt > n) ) THEN
                ;
            ELSE
                RETURN TRUE; (* 1..n : specified *)
            END;
        END;
    END;
    RETURN FALSE;
END chkOpt;

(* ------------------------------------------------------------ *)

CONST
    firstparm = 1;
    maxparm   = 1;
VAR
    parmcount,i,opt,lastparm:CARDINAL;
    S,R,spec:pathtype;
    cmd:showtype;
    fixkernel,useLFN,addNL,dotrim,showimports:BOOLEAN;
    showlibpath,showversion,showversiononly:BOOLEAN;
    DEBUG:BOOLEAN;
    parm:ARRAY [firstparm..maxparm] OF pathtype;
    anchor,diranchor:ptrToEntry;
    alcatraz,ok:BOOLEAN;
    lastfile,lastsearchdir:CARDINAL;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE; (* don't let topspeed handle problems *)
    (* WrLn; cancelled for -v *)

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    lastparm    := firstparm-1;
    useLFN      := TRUE;
    addNL       := TRUE;
    dotrim      := FALSE;
    showimports := TRUE;
    showlibpath   := FALSE;
    showversion := FALSE; (* PE32 only *)
    showversiononly := FALSE; (* PE32 only *)
    fixkernel   := TRUE;
    cmd         := showall; (* default is to show everything *)
    DEBUG       := FALSE;

    (* kludge ON : options and strings must match main parsing code, of course *)

    IF chkOpt ( delim,parmcount,
                "S"+delim+"SEARCHED"+delim+"VIEW"+delim+"VIEWLIST") THEN
        IF chkOpt(delim,parmcount,"L"+delim+"LFN") THEN useLFN:=FALSE; END;
        useLFN:=( useLFN AND w9XsupportLFN() );
        i:=buildSearchList(diranchor,useLFN, TRUE );
        freeMatchList(diranchor);
        abort(errNone,"");
    END;

    (* kludge OFF *)

    WrLn; (* ok here *)
    useLFN := TRUE; (* reset default *)

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "L"+delim+"LFN"+delim+
                                  "N"+delim+"CRLF"+delim+
                                  "Q"+delim+"NOLIST"+delim+
                                  "D"+delim+"DOS"+delim+
                                  "W"+delim+"WIN16"+delim+
                                  "P"+delim+"WIN32"+delim+
                                  "X"+delim+"NOTEXE"+delim+
                                  "DD"+delim+
                                  "I"+delim+"VERBOSE"+delim+
                                  "WW"+delim+
                                  "PP"+delim+
                                  "E"+delim+"EXE"+delim+
                                  "EE"+delim+
                                  "V"+delim+"VERSION"+delim+"VER"+delim+"SHOWVERSION"+delim+
                                  "VV"+delim+"SHOWVERSIONONLY"+delim+
                                  "T"+delim+"TRIM"+delim+
                                  "NN"+delim+"TT"+delim+"NT"+delim+"TN"+delim+
                                  "!"+delim+"GENINI"+delim+
                                  "!!"+delim+
                                  "K"+delim+"KERNEL"+delim+
                                  "IK"+delim+"II"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5:    useLFN    := FALSE;
            | 6,7:    addNL     := FALSE;
            | 8,9:    showimports   := FALSE;
            | 10,11:  IF chkcmd(cmd,showDOS)=FALSE THEN abort(errShow,"-d");END;
            | 12,13:  IF chkcmd(cmd,showWin16)=FALSE THEN abort(errShow,"-w");END;
            | 14,15:  IF chkcmd(cmd,showWin32)=FALSE THEN abort(errShow,"-p");END;
            | 16,17:  IF chkcmd(cmd,showNotEXE)=FALSE THEN abort(errShow,"-x");END;
            | 18:     IF chkcmd(cmd,showDOSexecom)=FALSE THEN abort(errShow,"-dd");END;
            | 19,20:  showlibpath :=TRUE;
            | 21:     IF chkcmd(cmd,showWin16)=FALSE THEN abort(errShow,"-w");END;
                      showlibpath :=TRUE;
            | 22:     IF chkcmd(cmd,showWin32)=FALSE THEN abort(errShow,"-p");END;
                      showlibpath :=TRUE;
            | 23,24:  IF chkcmd(cmd,showAllEXECUTABLE)=FALSE THEN abort(errShow,"-e");END;
            | 25   :  IF chkcmd(cmd,showAllEXECUTABLE)=FALSE THEN abort(errShow,"-e");END;
                      showlibpath :=TRUE;
            | 26,27,28,29: showversion:=TRUE;
            | 30,31:       showversion:=TRUE;
                           showversiononly:=TRUE;
            | 32,33:  dotrim := TRUE;
            | 34,35,36,37:
                      addNL  := FALSE;
                      dotrim := TRUE;
            | 38,39:  ok:=genDefault(FALSE);
                      abort(errNone,""); (* yes, we could RETURN an error IF FALSE... *)
            | 40 :    ok:=genDefault(TRUE);
                      abort(errNone,"");
            | 41,42 : fixkernel:=FALSE;
            | 43,44 : showlibpath:=TRUE;
                      fixkernel:=FALSE;
            | 45:     DEBUG     := TRUE;
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errTooManyParms,S);END;
            Str.Copy(parm[lastparm],S); (* keep case *)
        END;
    END;
    IF lastparm < firstparm THEN abort(errMissingSpec,"");END;

    CASE cmd OF
    | showWin16,showWin32:
        ;
    ELSE
        IF showversion THEN abort(errWinOnly,"");END;
    END;

    CASE cmd OF
    | showall,showWin16,showWin32:
        IF (showlibpath AND (showimports=FALSE)) THEN abort(errNonsenseShowImports,"");END;
    | showDOS,showDOSexecom:
        showimports:= FALSE;
        showlibpath  := FALSE;
    | showNotEXE :
        showimports:= FALSE;
        showlibpath  := FALSE;
    | showAllEXECUTABLE:
        ;
    END;

    useLFN:=( useLFN AND w9XsupportLFN() );
    IF useLFN=FALSE THEN
        FOR i:=firstparm TO lastparm DO
            UpperCase( parm[i] );
        END;
    END;
    Str.Copy(spec,parm[firstparm]);

    lastsearchdir:=buildSearchList(diranchor,useLFN, (DEBUG=TRUE) );
    IF lastsearchdir = TOOMANY THEN abort(errTooManySearchDirs,""); END;

    CASE spec[0] OF
    | arobas:
        Str.Delete(spec,0,1);
        IF Str.RCharPos(spec,dot)=MAX(CARDINAL) THEN Str.Append(spec,extLST);END;
        IF chkJoker(spec) THEN abort(errJokerList,spec);END;
        IF fileIsDirectorySpec(useLFN,spec) THEN abort(errNotFile,spec);END;
        IF fileExists(useLFN,spec)=FALSE THEN abort(errNotFound,spec);END;
        alcatraz:= chkList (fixkernel,useLFN,addNL,dotrim,showimports,showlibpath,
                           showversion,showversiononly,DEBUG,
                           cmd,lastsearchdir,diranchor,spec);
    ELSE
        IF same(spec,dot) THEN Str.Copy(spec,stardotstar);END;
        IF chkJokerPath(spec) THEN abort(errJokerPath,spec);END;
        lastfile:=buildMatchList (anchor, useLFN,spec);
        CASE lastfile OF
        | firstEntry-1:
            abort(errNoMatch,S);
        | TOOMANY:
            abort(errTooMany,S);
        ELSE
            alcatraz:=chkMatches (fixkernel,useLFN,addNL,dotrim,showimports,showlibpath,
                                 showversion,showversiononly,DEBUG,
                                 cmd,lastfile,lastsearchdir,anchor,diranchor);
        END;
        freeMatchList(anchor);
    END;

    freeMatchList(diranchor);
    IF alcatraz THEN abort(errAborted,"");END;

    abort(errNone,"");
END DLLfind.
