(* ---------------------------------------------------------------
Title         Q&D Peek
Author        PhG
Overview      extracts ASCII strings
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.

              seems mysterious "isl 342" compilation error has something
              to do with code size/complexity in a procedure (not flagged, of course)
              thanks again, TopSpeed team, for not being informative !!!

              paging would be overkill here : let MORE handle it !

Bugs          yes, we know it : Unicode is a Q&D hack for most PE executables
              tables for ASCII and OEM have not yet been fully checked

              ah, crappy Unicode nonsense strikes again :
              for example, single quote can be $19 $20 !

              anyway, we feel it's not worth rewriting the stuff

              dosbios should definitely be checked... but what for ? :-(

Wish List     take upper/lower ratio into account ?
              build from @filelist ?
              rewrite unicode scanning grabbing next byte and shifting ?
              show non-unicode, partially unicode, full unicode ?

              filter according to percentage of accents ?
              allow user-defined legal charset ? (for unicode !)

--------------------------------------------------------------- *)

MODULE Peek;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;

FROM IO IMPORT WrStr, WrLn;

FROM Storage IMPORT ALLOCATE, DEALLOCATE, Available;

FROM FIO IMPORT FIXEDLIBS;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileIsDirectorySpec;

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "PEEK";
    ProgTitle     = "Q&D Peek";
    ProgVersion   = "v1.2e";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    txtLOG        = "LOG";
    extLOG        = "."+txtLOG;
    extNUM        = "._##";
    dot           = ".";
    dotdot        = dot+dot;
    CR            = CHR(13);
    LF            = CHR(10);
    nl            = CR+LF;
    TAB           = CHR(9);
    SPACE         = " ";
    nullchar      = 0C; (* CHR(0) *)
    dollar        = "$";
    doublequote   = '"';
    star          = "*";
    stardotstar   = star+dot+star;
    chFiller      = CHR(46); (* was prettier CHR(249) *)
    dummyDOSname  = "_DEL_ME_.TMP"; (* extremely unlikely to exist ! will be created/deleted *)
    digits = "0123456789";
CONST
    minUnicodeCharLen = 2; (* "$00??" or "$?? $00" *)
CONST
    sTAB          = "<TAB>";
    sNL           = "<CRLF>";
    sCR           = "<CR>";
    sLF           = "<LF>";
    sASCIItype    = "(A)";
    sUNICODEtype  = "(u)";
CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errTooManyParms = 3;
    errMissingName  = 4;
    errTooManyFiles = 5;
    errNotFound     = 6;
    errSeqRange     = 7;
    errBadNumber    = 8;
    errMatchRange   = 9;
    errEmptyExt     = 10;
    errLongExt      = 11;
    errLanguage     = 12;
    errTargetRules  = 13;
    errAZ09range    = 14;
    errAbout        = 15;
    errXlat         = 16;

    errAbortedByUser= 255;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
msghelp=
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" <file(s)> [option]..."+nl+
nl+
"This program tries and extracts strings from <file(s)>."+nl+
nl+
"  -c       filter as to keep only seemingly C ($00 terminated) strings"+nl+
'  -d       filter as to keep only seemingly DOS/BIOS ("$" terminated) strings'+nl+
"  -i[i][n] filter as to keep only strings about program and copyright"+nl+
'           (-u forced, -ii = ignore "#.#[.#] and "#,[ ]#,[ ]#" patterns).'+nl+
"  -w[w]    search using Win16 character set (-ww = -w -y)"+nl+
"  -u[u]    search using Win32 Unicode character set (-uu = -u -y)"+nl+
"  -fr      use French character set tables"+nl+
"  -f       filtered character set producing less noise (not recommended)"+nl+
"  -y       remap output from OEM to ASCII (XLAT WIN2PC emulation)"+nl+
"  -z       remap output from ASCII to OEM (XLAT PC2WIN emulation)"+nl+
"  -m:#     minimum string length required [2..128], default is 3"+nl+
"  -s:#     maximum length of sequence [3..16384], default is 4096"+nl+
"  -p:#     minimum percentage of letters and digits required, default is 0"+nl+
"  -x       show string hexadecimal representation"+nl+
'  -s       show string type ("'+sASCIItype+'" for ASCII, "'+sUNICODEtype+'" for Unicode)'+nl+
'  -a[a]    display string offset in file (-aa = -a -s)'+nl+
"  -e       exact raw output (no CR added for very long sequences)"+nl+
"  -v       verbatim (no CR added at all)"+nl+
"  -q       enclose each string with double quotes"+nl+
'  -j       prepend "'+sTAB+'", "'+sNL+'", "'+sCR+'" or "'+sLF+'" to matching sequences'+nl+
"  -t       terse mode"+nl+
'  -e:$     log file extension (default is "'+txtLOG+'")'+nl+
"  -o       overwrite any existing log file"+nl+
"  -r       try and avoid collisions by renaming results to "+extNUM+" if possible"+nl+
"  -b       beep when finished"+nl+
"  -n       dump data to screen without creating log (-t forced)"+nl+
"  -lfn     disable LFN support even if available"+nl+
nl+
"a) Strings may contain CRs, LFs and TABs."+nl+
"b) Program will scan for $?? and $?? $00 ($00??) Unicode characters."+nl+
"c) Without -n option, program creates *"+extLOG+" logs in current directory."+nl+
"d) -y and -z options emulate XLAT utility."+nl+
'e) -i option keeps only strings containing these substrings :'+nl+
'   "copyright", "copr.", "(C)", "company", "revision", " by " ;'+nl+
'   "version", "ver.", "ver", "v.", "v" + any number of spaces +'+nl+
'   "#[.#[.#]]" (where # is any number of digits) ; "#.#[.#]", "#,[ ]#,[ ]#".'+nl+
"f) Paging with -n option can be handled by MORE filter command."+nl+
"g) Note -c alone, -u alone and -c -u together may give different logs."+nl+
"h) Note Unicode strings may look corrupt when they just have unexpected chars"+nl+
"   (the single quote character being coded as $2019 instead of $0027, etc.) :"+nl+
"   preprocess any such file with OLDNEW utility in binary mode."+nl+
(*%F FIXEDLIBS  *)
nl+
"Unfortunately, thanks to a fatal bug in TopSpeed Modula-2 FIO library,"+nl+
"paths are limited to 65 characters (longer ones will NOT be found). :-(")+nl+
(*%E  *)
"";
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msghelp);
    | errOption :
        Str.Concat(S,"Unknown ",einfo);
        Str.Append(S," option !");
    | errTooManyParms :
        Str.Concat(S,einfo," is just one parameter too far !");
    | errMissingName :
        S := "Missing file specification !";
    | errTooManyFiles :
        Str.Concat(S,einfo," specification is matched by too many files !");
    | errNotFound :
        Str.Concat(S,"No file matches ",einfo);
        Str.Append(S," specification !");
    | errSeqRange:
        S:="Maximum length of sequence must be in the [3..16384] range !";
    | errBadNumber:
        Str.Concat(S,"Illegal number in ",einfo);
        Str.Append(S," parameter !");
    | errMatchRange:
        S:="Minimum string length required must be in the [2..128] range !";
    | errEmptyExt:
        S:="New log file extension is empty !";
    | errLongExt:
        S:="New log file extension is too long !";
    | errLanguage:
        S:="-c, -p and -d options are mutually exclusive !";
    | errTargetRules:
        S:="-o and -r options are mutually exclusive !";
    | errAZ09range:
        S:="Minimum AZ09 percentage must be in the [0..100] range !";
    | errAbout:
        S:="-i and -p:# options are mutually exclusive !";
    | errXlat:
        S:="-y and -z options are mutually exclusive !";
    | errAbortedByUser:
        S := "Aborted by user !";
    ELSE
        (* S := "How Can Such A Thing B(i)e(rce) ???"; *)
        S:="This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp:
        ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    pFname = POINTER TO fnameType;
    fnameType = RECORD
        next      : pFname;
        slen      : SHORTCARD;
        str       : CHAR;
    END;

PROCEDURE initList (VAR anchor : pFname );
BEGIN
    anchor := NIL;
END initList;

PROCEDURE freeList (anchor : pFname);
VAR
    needed : CARDINAL;
    p      : pFname;
BEGIN
    (* p:=anchor; *)
    WHILE anchor # NIL DO
        needed := SIZE(fnameType) - SIZE(anchor^.str) + CARDINAL(anchor^.slen);
        p := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=p;
    END
END freeList;

PROCEDURE buildNewPtr (VAR anchor,p:pFname; len:CARDINAL):BOOLEAN;
VAR
    needed : CARDINAL;
BEGIN
    needed := SIZE(fnameType) - SIZE(p^.str) + len;
    IF Available(needed)=FALSE THEN RETURN FALSE; END;
    IF anchor = NIL THEN
        ALLOCATE(anchor,needed);
        p:=anchor;
    ELSE
        p:=anchor;
        WHILE p^.next # NIL DO
            p:=p^.next;
        END;
        ALLOCATE(p^.next,needed);
        p:=p^.next;
    END;
    p^.next := NIL;
    RETURN TRUE;
END buildNewPtr;

(* assume p is valid *)

PROCEDURE getStr (VAR S : pathtype; p:pFname);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(p^.slen);
    Lib.FastMove( ADR(p^.str),ADR(S),len);
    S[len] := nullchar; (* REQUIRED safety ! *)
END getStr;

(* ------------------------------------------------------------ *)

PROCEDURE isReservedEntry (S:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isReservedEntry;

PROCEDURE buildFileList (VAR anchor:pFname;useLFN:BOOLEAN;spec:pathtype):CARDINAL;
VAR
    count:CARDINAL; (* should do ! *)
    ok,found:BOOLEAN;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    entry : FIO.DirEntry;
    dosattr:FIO.FileAttr;
    entryname:pathtype;
    len : CARDINAL;
    pp:pFname;
BEGIN
    count:=0;
    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        IF isReservedEntry (entryname) = FALSE THEN (* skip "." AND ".." *)
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=entry.attr;
            END;
            IF NOT (aD IN dosattr) THEN
                (* if file has no extension, add it as a marker *)
                IF Str.RCharPos(entryname,".")=MAX(CARDINAL) THEN
                    Str.Append(entryname,".");
                END;
                len:=Str.Length(entryname);
                IF buildNewPtr(anchor,pp,len)=FALSE THEN
                    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN MAX(CARDINAL); (* errStorage *)
                END;
                INC(count);
                pp^.slen      := SHORTCARD(len);
                Lib.FastMove ( ADR(entryname),ADR(pp^.str),len );
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN count;
END buildFileList;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* ripped and adapted from old PC2WIN v1.0a dated 29 Apr *)

TYPE
    chardef   = RECORD
                    Code    : BYTE;
                    Flag    : CHAR;
                    MapChar : BYTE;
                END;
    CharTable = ARRAY [0..255] OF chardef;

CONST
    TpcTOwin  = CharTable (
    chardef(000H, "=", 000H),
    chardef(001H, "=", 001H),
    chardef(002H, "=", 002H),
    chardef(003H, "=", 003H),
    chardef(004H, "=", 004H),
    chardef(005H, "=", 005H),
    chardef(006H, "=", 006H),
    chardef(007H, "=", 007H),
    chardef(008H, "=", 008H),
    chardef(009H, "!", 009H),
    chardef(00AH, "=", 00AH),
    chardef(00BH, "=", 00BH),
    chardef(00CH, "=", 00CH),
    chardef(00DH, "=", 00DH),
    chardef(00EH, "=", 00EH),
    chardef(00FH, "=", 00FH),
    chardef(010H, "=", 010H),
    chardef(011H, "=", 011H),
    chardef(012H, "=", 012H),
    chardef(013H, "=", 013H),
    chardef(014H, "!", 0B6H),
    chardef(015H, "!", 0A7H),
    chardef(016H, "=", 016H),
    chardef(017H, "=", 017H),
    chardef(018H, "=", 018H),
    chardef(019H, "=", 019H),
    chardef(01AH, "=", 01AH),
    chardef(01BH, "=", 01BH),
    chardef(01CH, "=", 01CH),
    chardef(01DH, "=", 01DH),
    chardef(01EH, "=", 01EH),
    chardef(01FH, "=", 01FH),
    chardef(020H, "=",  " "),
    chardef(021H, "=",  "!"),
    chardef(022H, "=",  '"'),
    chardef(023H, "=",  "#"),
    chardef(024H, "=",  "$"),
    chardef(025H, "=",  "%"),
    chardef(026H, "=",  "&"),
    chardef(027H, "=",  "'"),
    chardef(028H, "=",  "("),
    chardef(029H, "=",  ")"),
    chardef(02AH, "=",  "*"),
    chardef(02BH, "=",  "+"),
    chardef(02CH, "=",  ","),
    chardef(02DH, "=",  "-"),
    chardef(02EH, "=",  "."),
    chardef(02FH, "=",  "/"),
    chardef(030H, "=",  "0"),
    chardef(031H, "=",  "1"),
    chardef(032H, "=",  "2"),
    chardef(033H, "=",  "3"),
    chardef(034H, "=",  "4"),
    chardef(035H, "=",  "5"),
    chardef(036H, "=",  "6"),
    chardef(037H, "=",  "7"),
    chardef(038H, "=",  "8"),
    chardef(039H, "=",  "9"),
    chardef(03AH, "=",  ":"),
    chardef(03BH, "=",  ";"),
    chardef(03CH, "=",  "<"),
    chardef(03DH, "=",  "="),
    chardef(03EH, "=",  ">"),
    chardef(03FH, "=",  "?"),
    chardef(040H, "=",  "@"),
    chardef(041H, "=",  "A"),
    chardef(042H, "=",  "B"),
    chardef(043H, "=",  "C"),
    chardef(044H, "=",  "D"),
    chardef(045H, "=",  "E"),
    chardef(046H, "=",  "F"),
    chardef(047H, "=",  "G"),
    chardef(048H, "=",  "H"),
    chardef(049H, "=",  "I"),
    chardef(04AH, "=",  "J"),
    chardef(04BH, "=",  "K"),
    chardef(04CH, "=",  "L"),
    chardef(04DH, "=",  "M"),
    chardef(04EH, "=",  "N"),
    chardef(04FH, "=",  "O"),
    chardef(050H, "=",  "P"),
    chardef(051H, "=",  "Q"),
    chardef(052H, "=",  "R"),
    chardef(053H, "=",  "S"),
    chardef(054H, "=",  "T"),
    chardef(055H, "=",  "U"),
    chardef(056H, "=",  "V"),
    chardef(057H, "=",  "W"),
    chardef(058H, "=",  "X"),
    chardef(059H, "=",  "Y"),
    chardef(05AH, "=",  "Z"),
    chardef(05BH, "=",  "["),
    chardef(05CH, "=",  "\"),
    chardef(05DH, "=",  "]"),
    chardef(05EH, "=",  "^"),
    chardef(05FH, "=",  "_"),
    chardef(060H, "=",  "`"),
    chardef(061H, "=",  "a"),
    chardef(062H, "=",  "b"),
    chardef(063H, "=",  "c"),
    chardef(064H, "=",  "d"),
    chardef(065H, "=",  "e"),
    chardef(066H, "=",  "f"),
    chardef(067H, "=",  "g"),
    chardef(068H, "=",  "h"),
    chardef(069H, "=",  "i"),
    chardef(06AH, "=",  "j"),
    chardef(06BH, "=",  "k"),
    chardef(06CH, "=",  "l"),
    chardef(06DH, "=",  "m"),
    chardef(06EH, "=",  "n"),
    chardef(06FH, "=",  "o"),
    chardef(070H, "=",  "p"),
    chardef(071H, "=",  "q"),
    chardef(072H, "=",  "r"),
    chardef(073H, "=",  "s"),
    chardef(074H, "=",  "t"),
    chardef(075H, "=",  "u"),
    chardef(076H, "=",  "v"),
    chardef(077H, "=",  "w"),
    chardef(078H, "=",  "x"),
    chardef(079H, "=",  "y"),
    chardef(07AH, "=",  "z"),
    chardef(07BH, "=",  "{"),
    chardef(07CH, "=",  "|"),
    chardef(07DH, "=",  "}"),
    chardef(07EH, "=",  "~"),
    chardef(07FH, "?",  " "),
    chardef(080H, "=", 0C7H),
    chardef(081H, "=", 0FCH),
    chardef(082H, "=", 0E9H),
    chardef(083H, "=", 0E2H),
    chardef(084H, "=", 0E4H),
    chardef(085H, "=", 0E0H),
    chardef(086H, "=", 0E5H),
    chardef(087H, "=", 0E7H),
    chardef(088H, "=", 0EAH),
    chardef(089H, "=", 0EBH),
    chardef(08AH, "=", 0E8H),
    chardef(08BH, "=", 0EFH),
    chardef(08CH, "=", 0EEH),
    chardef(08DH, "=", 0ECH),
    chardef(08EH, "=", 0C4H),
    chardef(08FH, "=", 0C5H),
    chardef(090H, "=", 0C9H),
    chardef(091H, "=", 0E6H),
    chardef(092H, "=", 0C6H),
    chardef(093H, "=", 0F4H),
    chardef(094H, "=", 0F6H),
    chardef(095H, "=", 0F2H),
    chardef(096H, "=", 0FBH),
    chardef(097H, "=", 0F9H),
    chardef(098H, "=", 0FFH),
    chardef(099H, "=", 0D6H),
    chardef(09AH, "=", 0DCH),
    chardef(09BH, "=", 0A2H),
    chardef(09CH, "=", 0A3H),
    chardef(09DH, "=", 0A5H),
    chardef(09EH, "?",  " "),
    chardef(09FH, "?",  " "),
    chardef(0A0H, "=", 0E1H),
    chardef(0A1H, "=", 0EDH),
    chardef(0A2H, "=", 0F3H),
    chardef(0A3H, "=", 0FAH),
    chardef(0A4H, "=", 0F1H),
    chardef(0A5H, "=", 0D1H),
    chardef(0A6H, "=", 0AAH),
    chardef(0A7H, "=", 0BAH),
    chardef(0A8H, "=", 0BFH),
    chardef(0A9H, "?",  " "),
    chardef(0AAH, "=", 0ACH),
    chardef(0ABH, "=", 0BDH),
    chardef(0ACH, "=", 0BCH),
    chardef(0ADH, "=", 0A1H),
    chardef(0AEH, "=", 0ABH),
    chardef(0AFH, "=", 0BBH),
    chardef(0B0H, "@",  " "),
    chardef(0B1H, "@",  " "),
    chardef(0B2H, "@",  " "),
    chardef(0B3H, "@",  " "),
    chardef(0B4H, "@",  " "),
    chardef(0B5H, "@",  " "),
    chardef(0B6H, "@",  " "),
    chardef(0B7H, "@",  " "),
    chardef(0B8H, "@",  " "),
    chardef(0B9H, "@",  " "),
    chardef(0BAH, "@",  " "),
    chardef(0BBH, "@",  " "),
    chardef(0BCH, "@",  " "),
    chardef(0BDH, "@",  " "),
    chardef(0BEH, "@",  " "),
    chardef(0BFH, "@",  " "),
    chardef(0C0H, "@",  " "),
    chardef(0C1H, "@",  " "),
    chardef(0C2H, "@",  " "),
    chardef(0C3H, "@",  " "),
    chardef(0C4H, "@",  " "),
    chardef(0C5H, "@",  " "),
    chardef(0C6H, "@",  " "),
    chardef(0C7H, "@",  " "),
    chardef(0C8H, "@",  " "),
    chardef(0C9H, "@",  " "),
    chardef(0CAH, "@",  " "),
    chardef(0CBH, "@",  " "),
    chardef(0CCH, "@",  " "),
    chardef(0CDH, "@",  " "),
    chardef(0CEH, "@",  " "),
    chardef(0CFH, "@",  " "),
    chardef(0D0H, "@",  " "),
    chardef(0D1H, "@",  " "),
    chardef(0D2H, "@",  " "),
    chardef(0D3H, "@",  " "),
    chardef(0D4H, "@",  " "),
    chardef(0D5H, "@",  " "),
    chardef(0D6H, "@",  " "),
    chardef(0D7H, "@",  " "),
    chardef(0D8H, "@",  " "),
    chardef(0D9H, "@",  " "),
    chardef(0DAH, "@",  " "),
    chardef(0DBH, "@",  " "),
    chardef(0DCH, "@",  " "),
    chardef(0DDH, "@",  " "),
    chardef(0DEH, "@",  " "),
    chardef(0DFH, "@",  " "),
    chardef(0E0H, "?",  " "),
    chardef(0E1H, "=", 0DFH),
    chardef(0E2H, "?",  " "),
    chardef(0E3H, "?",  " "),
    chardef(0E4H, "?",  " "),
    chardef(0E5H, "?",  " "),
    chardef(0E6H, "=", 0B5H),
    chardef(0E7H, "?",  " "),
    chardef(0E8H, "?",  " "),
    chardef(0E9H, "?",  " "),
    chardef(0EAH, "?",  " "),
    chardef(0EBH, "?",  " "),
    chardef(0ECH, "?",  " "),
    chardef(0EDH, "=", 0D8H),
    chardef(0EEH, "?",  " "),
    chardef(0EFH, "?",  " "),
    chardef(0F0H, "?",  " "),
    chardef(0F1H, "=", 0B1H),
    chardef(0F2H, "?",  " "),
    chardef(0F3H, "?",  " "),
    chardef(0F4H, "?",  " "),
    chardef(0F5H, "?",  " "),
    chardef(0F6H, "=", 0F7H),
    chardef(0F7H, "?",  " "),
    chardef(0F8H, "=", 0B0H),
    chardef(0F9H, "?",  " "),
    chardef(0FAH, "?",  " "),
    chardef(0FBH, "?",  " "),
    chardef(0FCH, "?",  " "),
    chardef(0FDH, "=", 0B2H),
    chardef(0FEH, "?",  " "),
    chardef(0FFH, "=",  " "));

(* ripped and adapted from old WIN2PC v1.0a dated 29 Apr *)

CONST
    TwinTOpc  = CharTable(
    chardef(000H, "=", 000H),
    chardef(001H, "=", 001H),
    chardef(002H, "=", 002H),
    chardef(003H, "=", 003H),
    chardef(004H, "=", 004H),
    chardef(005H, "=", 005H),
    chardef(006H, "=", 006H),
    chardef(007H, "=", 007H),
    chardef(008H, "=", 008H),
    chardef(009H, "!", 009H),
    chardef(00AH, "=", 00AH),
    chardef(00BH, "=", 00BH),
    chardef(00CH, "=", 00CH),
    chardef(00DH, "=", 00DH),
    chardef(00EH, "=", 00EH),
    chardef(00FH, "=", 00FH),
    chardef(010H, "=", 010H),
    chardef(011H, "=", 011H),
    chardef(012H, "=", 012H),
    chardef(013H, "=", 013H),
    chardef(014H, "=", 014H),
    chardef(015H, "=", 015H),
    chardef(016H, "=", 016H),
    chardef(017H, "=", 017H),
    chardef(018H, "=", 018H),
    chardef(019H, "=", 019H),
    chardef(01AH, "=", 01AH),
    chardef(01BH, "=", 01BH),
    chardef(01CH, "=", 01CH),
    chardef(01DH, "=", 01DH),
    chardef(01EH, "=", 01EH),
    chardef(01FH, "=", 01FH),
    chardef(020H, "=",  " "),
    chardef(021H, "=",  "!"),
    chardef(022H, "=",  '"'),
    chardef(023H, "=",  "#"),
    chardef(024H, "=",  "$"),
    chardef(025H, "=",  "%"),
    chardef(026H, "=",  "&"),
    chardef(027H, "=",  "'"),
    chardef(028H, "=",  "("),
    chardef(029H, "=",  ")"),
    chardef(02AH, "=",  "*"),
    chardef(02BH, "=",  "+"),
    chardef(02CH, "=",  ","),
    chardef(02DH, "=",  "-"),
    chardef(02EH, "=",  "."),
    chardef(02FH, "=",  "/"),
    chardef(030H, "=",  "0"),
    chardef(031H, "=",  "1"),
    chardef(032H, "=",  "2"),
    chardef(033H, "=",  "3"),
    chardef(034H, "=",  "4"),
    chardef(035H, "=",  "5"),
    chardef(036H, "=",  "6"),
    chardef(037H, "=",  "7"),
    chardef(038H, "=",  "8"),
    chardef(039H, "=",  "9"),
    chardef(03AH, "=",  ":"),
    chardef(03BH, "=",  ";"),
    chardef(03CH, "=",  "<"),
    chardef(03DH, "=",  "="),
    chardef(03EH, "=",  ">"),
    chardef(03FH, "=",  "?"),
    chardef(040H, "=",  "@"),
    chardef(041H, "=",  "A"),
    chardef(042H, "=",  "B"),
    chardef(043H, "=",  "C"),
    chardef(044H, "=",  "D"),
    chardef(045H, "=",  "E"),
    chardef(046H, "=",  "F"),
    chardef(047H, "=",  "G"),
    chardef(048H, "=",  "H"),
    chardef(049H, "=",  "I"),
    chardef(04AH, "=",  "J"),
    chardef(04BH, "=",  "K"),
    chardef(04CH, "=",  "L"),
    chardef(04DH, "=",  "M"),
    chardef(04EH, "=",  "N"),
    chardef(04FH, "=",  "O"),
    chardef(050H, "=",  "P"),
    chardef(051H, "=",  "Q"),
    chardef(052H, "=",  "R"),
    chardef(053H, "=",  "S"),
    chardef(054H, "=",  "T"),
    chardef(055H, "=",  "U"),
    chardef(056H, "=",  "V"),
    chardef(057H, "=",  "W"),
    chardef(058H, "=",  "X"),
    chardef(059H, "=",  "Y"),
    chardef(05AH, "=",  "Z"),
    chardef(05BH, "=",  "["),
    chardef(05CH, "=",  "\"),
    chardef(05DH, "=",  "]"),
    chardef(05EH, "=",  "^"),
    chardef(05FH, "=",  "_"),
    chardef(060H, "=",  "`"),
    chardef(061H, "=",  "a"),
    chardef(062H, "=",  "b"),
    chardef(063H, "=",  "c"),
    chardef(064H, "=",  "d"),
    chardef(065H, "=",  "e"),
    chardef(066H, "=",  "f"),
    chardef(067H, "=",  "g"),
    chardef(068H, "=",  "h"),
    chardef(069H, "=",  "i"),
    chardef(06AH, "=",  "j"),
    chardef(06BH, "=",  "k"),
    chardef(06CH, "=",  "l"),
    chardef(06DH, "=",  "m"),
    chardef(06EH, "=",  "n"),
    chardef(06FH, "=",  "o"),
    chardef(070H, "=",  "p"),
    chardef(071H, "=",  "q"),
    chardef(072H, "=",  "r"),
    chardef(073H, "=",  "s"),
    chardef(074H, "=",  "t"),
    chardef(075H, "=",  "u"),
    chardef(076H, "=",  "v"),
    chardef(077H, "=",  "w"),
    chardef(078H, "=",  "x"),
    chardef(079H, "=",  "y"),
    chardef(07AH, "=",  "z"),
    chardef(07BH, "=",  "{"),
    chardef(07CH, "=",  "|"),
    chardef(07DH, "=",  "}"),
    chardef(07EH, "=",  "~"),
    chardef(07FH, "x",  " "),
    chardef(080H, "x",  " "),
    chardef(081H, "x",  " "),
    chardef(082H, "x",  " "),
    chardef(083H, "x",  " "),
    chardef(084H, "x",  " "),
    chardef(085H, "x",  " "),
    chardef(086H, "x",  " "),
    chardef(087H, "x",  " "),
    chardef(088H, "x",  " "),
    chardef(089H, "x",  " "),
    chardef(08AH, "x",  " "),
    chardef(08BH, "x",  " "),
    chardef(08CH, "x",  " "),
    chardef(08DH, "x",  " "),
    chardef(08EH, "x",  " "),
    chardef(08FH, "x",  " "),
    chardef(090H, "x",  " "),
    chardef(091H, "=",  "'"),
    chardef(092H, "=",  "'"),
    chardef(093H, "x",  " "),
    chardef(094H, "x",  " "),
    chardef(095H, "x",  " "),
    chardef(096H, "x",  " "),
    chardef(097H, "x",  " "),
    chardef(098H, "x",  " "),
    chardef(099H, "x",  " "),
    chardef(09AH, "x",  " "),
    chardef(09BH, "x",  " "),
    chardef(09CH, "x",  " "),
    chardef(09DH, "x",  " "),
    chardef(09EH, "x",  " "),
    chardef(09FH, "x",  " "),
    chardef(0A0H, "=",  " "),
    chardef(0A1H, "=",  ""),
    chardef(0A2H, "=",  ""),
    chardef(0A3H, "=",  ""),
    chardef(0A4H, "=",  ""),
    chardef(0A5H, "=",  ""),
    chardef(0A6H, "=",  "|"),
    chardef(0A7H, "!", 015H),
    chardef(0A8H, "?",  " "),
    chardef(0A9H, "!",  ""),
    chardef(0AAH, "=",  ""),
    chardef(0ABH, "=",  ""),
    chardef(0ACH, "=",  ""),
    chardef(0ADH, "=",  "-"),
    chardef(0AEH, "!",  ""),
    chardef(0AFH, "!",  "-"),
    chardef(0B0H, "=",  ""),
    chardef(0B1H, "=",  ""),
    chardef(0B2H, "=",  ""),
    chardef(0B3H, "?",  " "),
    chardef(0B4H, "?",  " "),
    chardef(0B5H, "=",  ""),
    chardef(0B6H, "!", 014H),
    chardef(0B7H, "?",  " "),
    chardef(0B8H, "?",  " "),
    chardef(0B9H, "?",  " "),
    chardef(0BAH, "=",  ""),
    chardef(0BBH, "=",  ""),
    chardef(0BCH, "=",  ""),
    chardef(0BDH, "=",  ""),
    chardef(0BEH, "?",  " "),
    chardef(0BFH, "=",  ""),
    chardef(0C0H, "=",  "A"),
    chardef(0C1H, "=",  "A"),
    chardef(0C2H, "=",  "A"),
    chardef(0C3H, "=",  "A"),
    chardef(0C4H, "=",  ""),
    chardef(0C5H, "=",  ""),
    chardef(0C6H, "=",  ""),
    chardef(0C7H, "=",  ""),
    chardef(0C8H, "=",  "E"),
    chardef(0C9H, "=",  ""),
    chardef(0CAH, "=",  "E"),
    chardef(0CBH, "=",  "E"),
    chardef(0CCH, "=",  "I"),
    chardef(0CDH, "=",  "I"),
    chardef(0CEH, "=",  "I"),
    chardef(0CFH, "=",  "I"),
    chardef(0D0H, "?",  " "),
    chardef(0D1H, "=",  ""),
    chardef(0D2H, "=",  "O"),
    chardef(0D3H, "=",  "O"),
    chardef(0D4H, "=",  "O"),
    chardef(0D5H, "=",  "O"),
    chardef(0D6H, "=",  ""),
    chardef(0D7H, "=",  "X"),
    chardef(0D8H, "=",  "O"),
    chardef(0D9H, "=",  "U"),
    chardef(0DAH, "=",  "U"),
    chardef(0DBH, "=",  "U"),
    chardef(0DCH, "=",  ""),
    chardef(0DDH, "=",  "Y"),
    chardef(0DEH, "?",  " "),
    chardef(0DFH, "=",  ""),
    chardef(0E0H, "=",  ""),
    chardef(0E1H, "=",  ""),
    chardef(0E2H, "=",  ""),
    chardef(0E3H, "=",  "a"),
    chardef(0E4H, "=",  ""),
    chardef(0E5H, "=",  ""),
    chardef(0E6H, "=",  ""),
    chardef(0E7H, "=",  ""),
    chardef(0E8H, "=",  ""),
    chardef(0E9H, "=",  ""),
    chardef(0EAH, "=",  ""),
    chardef(0EBH, "=",  ""),
    chardef(0ECH, "=",  ""),
    chardef(0EDH, "=",  ""),
    chardef(0EEH, "=",  ""),
    chardef(0EFH, "=",  ""),
    chardef(0F0H, "?",  " "),
    chardef(0F1H, "=",  ""),
    chardef(0F2H, "=",  ""),
    chardef(0F3H, "=",  ""),
    chardef(0F4H, "=",  ""),
    chardef(0F5H, "=",  "o"),
    chardef(0F6H, "=",  ""),
    chardef(0F7H, "=",  ""),
    chardef(0F8H, "=",  "o"),
    chardef(0F9H, "=",  ""),
    chardef(0FAH, "=",  ""),
    chardef(0FBH, "=",  ""),
    chardef(0FCH, "=",  ""),
    chardef(0FDH, "=",  "y"),
    chardef(0FEH, "?",  " "),
    chardef(0FFH, "=",  ""));

(* we don't care about flag here *)

PROCEDURE remap2ascii (ch:CHAR):CHAR;
BEGIN
    RETURN TwinTOpc[ ORD(ch) ].MapChar;
END remap2ascii;

PROCEDURE remap2oem (ch:CHAR):CHAR;
BEGIN
    RETURN TpcTOwin[ ORD(ch) ].MapChar;
END remap2oem;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    forbidden = SPACE;

CONST

(*
        ""
        ""
        ""
        "$"
*)

    (*
    FIXME : what about uppercase  and the like ?
    bah, fed up with coding/checking today... :-(
    v1.0u : french dos and win should be ok now
    *)

    tlegaldos=
        "         $$  $                  "+
        " !"+
          '"#$%&'+
               "'()*+,-./0123456789:;<=>?"+
        "@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_"+
        " abcdefghijklmnopqrstuvwxyz{|}~ "+
        "              "+
        "                             "+
        "                                "+
        "                               ";

    tlegaldosFR=
        "         $$  $                  "+
        " !"+
          '"#$%&'+
               "'()*+,-./0123456789:;<=>?"+
        "@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_"+
        " abcdefghijklmnopqrstuvwxyz{|}~ "+
        "      "+
        "                           "+
        "                           "+
        "                             ";

    tlegalwin=
        "         $$  $                  "+
        " !"+
          '"#$%&'+
               "'()*+,-./0123456789:;<=>?"+
        "@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_"+
        " abcdefghijklmnopqrstuvwxyz{|}~ "+
        "                              "+
        "                          "+
        "                                "+
        "               ";

    tlegalwinFR=
        "         $$  $                  "+
        " !"+
          '"#$%&'+
               "'()*+,-./0123456789:;<=>?"+
        "@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_"+
        " abcdefghijklmnopqrstuvwxyz{|}~ "+
        "                       "+
        "                         "+
        "              "+
        "             ";

    tlegaldosstrict=
        "         $$  $                  "+
        " !"+
          '"  %&'+
               "'()*+,-./0123456789:; = ?"+
        " ABCDEFGHIJKLMNOPQRSTUVWXYZ[\] _"+
        " abcdefghijklmnopqrstuvwxyz     "+
        "                                "+
        "                                "+
        "                                "+
        "                                ";

    tlegalwinstrict=
        "         $$  $                  "+
        " !"+
          '"  %&'+
               "'()*+,-./0123456789:; =  "+
        " ABCDEFGHIJKLMNOPQRSTUVWXYZ[\] _"+
        " abcdefghijklmnopqrstuvwxyz     "+
        "                                "+
        "                                "+
        "                                "+
        "                                ";

    tAZ09dos=
        "                                "+
        "                0123456789      "+
        " ABCDEFGHIJKLMNOPQRSTUVWXYZ     "+
        " abcdefghijklmnopqrstuvwxyz     "+
        "               "+
        "                                "+
        "                                "+
        "                                ";

    tAZ09dosFR=
        "                                "+
        "                0123456789      "+
        " ABCDEFGHIJKLMNOPQRSTUVWXYZ     "+
        " abcdefghijklmnopqrstuvwxyz     "+
        "       "+
        "                              "+
        "                           "+
        "                              ";

    tAZ09win=
        "                                "+
        "                0123456789      "+
        " ABCDEFGHIJKLMNOPQRSTUVWXYZ     "+
        " abcdefghijklmnopqrstuvwxyz     "+
        "                                "+
        "                               "+
        "                                "+
        "                ";

    tAZ09winFR=
        "                                "+
        "                0123456789      "+
        " ABCDEFGHIJKLMNOPQRSTUVWXYZ     "+
        " abcdefghijklmnopqrstuvwxyz     "+
        "                             "+
        "                               "+
        "              "+
        "             ";

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE fmtHex (v : LONGWORD;digits:CARDINAL;
                  uppercase:BOOLEAN;prefix,suffix:ARRAY OF CHAR):str16;
CONST
    pad = "0";
VAR
    ok   : BOOLEAN;
    len  : CARDINAL;
    S    : str16;
BEGIN
    Str.CardToStr(v,S,16,ok);
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    IF uppercase=FALSE THEN
        Str.Lows(S);
    END;
    Str.Prepend(S,prefix);
    Str.Append(S,suffix);
    RETURN S;
END fmtHex;

PROCEDURE c2hex (c:CHAR;uppercase:BOOLEAN):str16;
VAR
    v:LONGCARD;
BEGIN
    v:=LONGCARD ( ORD(c) );
    RETURN fmtHex(v,2,uppercase,"","");
END c2hex;

(* ------------------------------------------------------------ *)

CONST
    firstInSequence = 0; (* 0-based as all strings *)
    maxInSequence   = 16384-1; (* was 1023 *)
VAR (* program does NOT like these huge structures as local variables ! *)
    Sequence : ARRAY [firstInSequence..maxInSequence+1] OF CHAR; (* account for last CHR(0) if needed *)
    PAT      : ARRAY [firstInSequence..maxInSequence+1] OF CHAR; (* for -i *)
    hugeStr  : ARRAY [firstInSequence..maxInSequence*4] OF CHAR; (* should do ! *)

(* ------------------------------------------------------------ *)

TYPE
    charsettype = (dos,win,unicode,strictdos,strictwin,strictunicode,
                   dosFR,winFR,unicodeFR,strictdosFR,strictwinFR,strictunicodeFR);
    languagetype= (cberk,dosbios,neutral);
    replacetype = (metanone,metaplain);
    xlattype    = (xlatnone,xlatoemtoascii,xlatasciitooem);
CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    bufferIn : ioBufferType;
    bufferOut: ioBufferType;

(* ------------------------------------------------------------ *)

(* use globerks *)

PROCEDURE dmpSeq (hout:FIO.File;addquotes:BOOLEAN;xlatmode:xlattype;tabcrlf:replacetype);
VAR
    ch:CHAR;
    i,len:CARDINAL;
    mytab,mycrlf,mycr,mylf:str16;
BEGIN
    hugeStr:="";
    IF addquotes THEN Str.Append(hugeStr,doublequote);END;
    Str.Append(hugeStr,Sequence);
    IF addquotes THEN Str.Append(hugeStr,doublequote);END;

    CASE tabcrlf OF
    | metaplain:
        mytab  :=sTAB;
        mycrlf :=sNL;
        mycr   :=sCR;
        mylf   :=sLF;
    END;

    CASE tabcrlf OF
    | metaplain:
        len:=Str.Length(hugeStr);
        i:=1;
        LOOP
            IF i > len THEN EXIT; END;
            ch:=hugeStr[i-1];
            CASE ch OF
            | TAB:
                FIO.WrStr(hout,mytab);
                FIO.WrStr(hout,TAB);
            | CR:
                IF hugeStr[i]=LF THEN
                    FIO.WrStr(hout,mycrlf);
                    FIO.WrStr(hout,nl);
                    INC(i);
                ELSE
                    FIO.WrStr(hout,mycr);
                    FIO.WrStr(hout,CR);   (* nl *)
                END;
            | LF:
                FIO.WrStr(hout,mylf);
                FIO.WrStr(hout,LF);       (* nl *)
            ELSE
                CASE xlatmode OF
                | xlatnone:
                    ;
                | xlatoemtoascii:
                    ch:=remap2ascii(ch);
                | xlatasciitooem:
                    ch:=remap2oem(ch);
                END;
                FIO.WrChar(hout,ch);
            END;
            INC(i);
        END;
    | metanone:
        CASE xlatmode OF
        | xlatnone:
            ;
        | xlatoemtoascii:
            FOR i:=1 TO Str.Length(hugeStr) DO
                ch:=hugeStr[i-1];
                hugeStr[i-1]:=remap2ascii(ch);
            END;
        | xlatasciitooem:
            FOR i:=1 TO Str.Length(hugeStr) DO
                ch:=hugeStr[i-1];
                hugeStr[i-1]:=remap2oem(ch);
            END;
        END;
        FIO.WrStr(hout,hugeStr);
    END;
END dmpSeq;

PROCEDURE dmpSeqHex (hout:FIO.File;unicount:CARDINAL);
VAR
    i:CARDINAL;
    ch:CHAR;
    R:str16;
BEGIN
    Str.Copy(hugeStr,Sequence);
    FOR i:=1 TO Str.Length(hugeStr) DO
        ch:=hugeStr[i-1];
        CASE i OF
        | 1 : R:="$";
        ELSE  R:=" ";
        END;
        Str.Append(R, c2hex(ch,FALSE));
        IF unicount >= minUnicodeCharLen THEN Str.Append(R," 00");END;
        FIO.WrStr(hout,R);
    END;
    FIO.WrLn(hout);
    FIO.WrLn(hout); (* add comfort to reading *)
END dmpSeqHex;


(* use globerks too *)

PROCEDURE chkAZ09 (charset:charsettype;requiredAZ09percentage:CARDINAL):BOOLEAN ;
VAR
    count,percentage:LONGCARD;
    len,i,code:CARDINAL;
    ch:CHAR;
    isAZ09:BOOLEAN;
BEGIN
    len:=Str.Length(Sequence);
    IF len=0 THEN RETURN FALSE;END; (* v1.2e Q&D fix *)
    count:=0;
    FOR i:=1 TO len DO
        ch:=Sequence[i-1];
        IF ch=SPACE THEN
            isAZ09:=TRUE; (* well... *)
        ELSE
            code:=ORD(ch);
            CASE charset OF
            | dos,strictdos:
                isAZ09:= ( tAZ09dos[ code ] # forbidden );
            | win,unicode,strictwin,strictunicode:
                isAZ09:= ( tAZ09win[ code ] # forbidden );
            | dosFR,strictdosFR:
                isAZ09:= ( tAZ09dosFR[ code ] # forbidden );
            | winFR,unicodeFR,strictwinFR,strictunicodeFR:
                isAZ09:= ( tAZ09winFR[ code ] # forbidden );
            END;
        END;
        IF isAZ09 THEN INC(count);END;
    END;
    percentage:=(count * 100) DIV LONGCARD(len); (* roughly speaking ! ;-) *)
    RETURN (percentage >= LONGCARD(requiredAZ09percentage) );
END chkAZ09;

(* ------------------------------------------------------------ *)

(* we start after a digit : now, track "#,[ ]#,[ ]#" *)

PROCEDURE grabversionAlt ( ):CARDINAL;
CONST
    maxcommas= 2;
    comma = ",";
VAR
    p,ncommas,nums:CARDINAL;
    state:(gotdigit,gotcomma,gotspace);
    ch:CHAR;
    S:str128;
BEGIN
    nums:=0;    (* number of nums *)
    ncommas:=0;
    p:=0;
    state:=gotdigit; (* fake the single digit we just killed *)
    LOOP
        ch:=PAT[p];
        IF ch=nullchar THEN EXIT; END;
        CASE state OF
        | gotdigit:
            IF verifyString(ch,digits) THEN  (* ## *)
                ;
            ELSIF ch=comma THEN              (* #, *)
                INC(nums);
                INC(ncommas); IF ncommas > maxcommas THEN EXIT; END;
                state:=gotcomma;
            ELSE                             (* #? *)
                INC(nums);
                EXIT;
            END;
        | gotcomma:
            IF verifyString(ch,digits) THEN  (* ,# *)
                state:=gotdigit;
            ELSIF ch=SPACE THEN              (* ,_ *)
                state:=gotspace;
            ELSE                             (* ,? *)
                EXIT;
            END;
        | gotspace :
            IF verifyString(ch,digits) THEN  (* _# *)
                state:=gotdigit;
            ELSIF ch=SPACE THEN              (* __ *)
                ;
            ELSE                             (* _? *)
                EXIT;
            END;
        END;
        INC(p);
    END;
    CASE state OF
    | gotdigit: (* #? *)
        IF ncommas < 2 THEN p:=MAX(CARDINAL); END;
    | gotcomma: (* ,? *)
        IF ncommas < 2 THEN p:=MAX(CARDINAL); END;
    | gotspace: (* _? *)
        IF ncommas < 2 THEN p:=MAX(CARDINAL); END;
    END;
    RETURN p;
END grabversionAlt;

(* wanted=digit : scan for "#, #, #" with any number of spaces and digits *)

PROCEDURE subpatAlt (wanted:ARRAY OF CHAR  ):BOOLEAN ;
VAR
    len,p:CARDINAL;
BEGIN
    len:=Str.Length(wanted);
    Str.Copy(PAT,Sequence);
    Str.Caps(PAT);
    Str.Caps(wanted);
    LOOP
        p:=Str.Pos(PAT,wanted);
        IF p = MAX(CARDINAL) THEN RETURN FALSE; END;
        Str.Delete(PAT,0,p+len);
        p:=grabversionAlt();
        IF p # MAX(CARDINAL) THEN RETURN TRUE; END;
    END;
    RETURN FALSE; (* completely useless except for cosmetic reasons ! *)
END subpatAlt;

(* ------------------------------------------------------------ *)

(*
    if normal, scan for (blanks)+"#[.#[.#]]" ? where # is any number of digits
    else, fake # and scan for remaining ".#[.#]"
    damn, we may still get ugly C format strings
*)

PROCEDURE grabversion (normal:BOOLEAN):CARDINAL ;
CONST
    maxdots= 2;
    blanks = SPACE+TAB;
VAR
    p,ndots,espaces:CARDINAL;
    state:(waiting,gotdot,gotdigit);
    ch:CHAR;
    S:str128;
BEGIN
    espaces:=0;
    ndots:=0;
    p:=0;
    IF normal THEN
        state:=waiting;
    ELSE
        state:=gotdigit; (* fake the single digit we just killed *)
    END;
    LOOP
        ch:=PAT[p];
        IF ch=nullchar THEN EXIT; END;
        CASE state OF
        | waiting:
            IF verifyString(ch,digits) THEN
                state:=gotdigit;
            ELSIF verifyString(ch,blanks) THEN
                INC(espaces);
            ELSE
                EXIT;
            END;
        | gotdigit:
            IF verifyString(ch,digits) THEN
                ;
            ELSIF ch=dot THEN
                INC(ndots); IF ndots > maxdots THEN EXIT; END;
                state:=gotdot;
            ELSE
                EXIT;
            END;
        | gotdot:
            IF verifyString(ch,digits) THEN
                state:=gotdigit;
            ELSE
                EXIT;
            END;
        END;
        INC(p);
    END;
    CASE state OF
    | waiting :
        p:= MAX (CARDINAL);
    | gotdigit:                   (*  #x  #.#x  #.#.#x  *)
        IF normal THEN
            ;
        ELSE
            IF ((ndots < 1) OR (espaces # 0) ) THEN p:=MAX(CARDINAL); END;
        END;
    | gotdot:                     (* #.x  #.#.x  #.#.#.x  *)
        IF normal THEN
            ;
        ELSE
            IF (ndots < 2) THEN p:=MAX(CARDINAL);END; (* filter out #.x *)
        END;
    END;
    RETURN p;
END grabversion;

(* wanted+space(s)+"#[.#[.#]]" where # is any number of digits *)

PROCEDURE subpat (normal:BOOLEAN; wanted:ARRAY OF CHAR  ):BOOLEAN ;
VAR
    len,p:CARDINAL;
BEGIN
    len:=Str.Length(wanted);
    Str.Copy(PAT,Sequence);
    Str.Caps(PAT);
    Str.Caps(wanted);
    LOOP
        p:=Str.Pos(PAT,wanted);
        IF p = MAX(CARDINAL) THEN RETURN FALSE; END;
        Str.Delete(PAT,0,p+len);
        p:=grabversion(normal);
        IF p # MAX(CARDINAL) THEN RETURN TRUE; END;
    END;
    RETURN FALSE; (* completely useless except for cosmetic reasons ! *)
END subpat;

PROCEDURE chkPatterns (about,aboutdigits:BOOLEAN):BOOLEAN;
VAR
    i:CARDINAL;
BEGIN
    IF about THEN
        (* glad Str.Match is not case-sensitive*)
        IF Str.Match(Sequence, "*copyright*") THEN RETURN TRUE; END;
        IF Str.Match(Sequence, "*copr.*"    ) THEN RETURN TRUE; END;
        IF Str.Match(Sequence, "*(c)*"      ) THEN RETURN TRUE; END;
        IF Str.Match(Sequence, "*company*"  ) THEN RETURN TRUE; END;
        IF Str.Match(Sequence, "*revision*" ) THEN RETURN TRUE; END;
        IF Str.Match(Sequence, "* by *"     ) THEN RETURN TRUE; END;
        (* in case there's no number following ! *)
        IF Str.Match(Sequence, "*version*"  ) THEN RETURN TRUE; END;
        (* order matters here ! *)
        IF subpat(   TRUE,     "version"    ) THEN RETURN TRUE; END;
        IF subpat(   TRUE,     "ver."       ) THEN RETURN TRUE; END;
        IF subpat(   TRUE,     "ver"        ) THEN RETURN TRUE; END;
        IF subpat(   TRUE,     "v."         ) THEN RETURN TRUE; END;
        IF subpat(   TRUE,     "v"          ) THEN RETURN TRUE; END;
        (* last try : scan for #.#[.#] pattern *)
        IF aboutdigits THEN
            FOR i:= ORD("0") TO ORD("9") DO
                IF subpat( FALSE, CHR(i) ) THEN RETURN TRUE; END;
            END;
            FOR i:= ORD("0") TO ORD("9") DO
                IF subpatAlt( CHR(i) ) THEN RETURN TRUE;END;
            END;
        END;
        RETURN FALSE;
    ELSE
        RETURN TRUE; (* we're not filtering *)
    END;
END chkPatterns;

(* ------------------------------------------------------------ *)

(* code moved out to separate procedure in order to avoid weird isl:342 compilation error *)

PROCEDURE dumpheader (hout:FIO.File;source:ARRAY OF CHAR;
                     charset:charsettype;language:languagetype;
                     minMatch,requiredAZ09percentage:CARDINAL;
                     about,aboutdigits:BOOLEAN);
CONST
    headersrc = "; Source file     : ";
    headernum = "; Minimum match   : ";
    headerset = "; Character set   : ";
    headerlng = "; Language filter : ";
    headerabout='; "About" filter  : ';
    headerAZ09= "; AZ09 threshold  : ";
CONST
    sIgnorePat= ' (ignoring "#.#[.#]" pattern)';
    sFull     = " (full)";
    sSubset   = " (subset)";
    sDOS      = "DOS";
    sWin      = "Win16";
    sUnicode  = "Win32";
    sFR       = "French ";
VAR
    S:str128;
BEGIN
    Str.Concat(S,headersrc,source);
    FIO.WrStr(hout,S);FIO.WrLn(hout);

    FIO.WrStr(hout,headernum);FIO.WrCard(hout,minMatch,1);
    FIO.WrStr(hout," characters or more");FIO.WrLn(hout); (* was "ASCII codes" *)

    CASE charset OF
    | dos:              S:=sDOS+sFull;
    | win:              S:=sWin+sFull;
    | unicode:          S:=sUnicode+sFull;
    | strictdos:        S:=sDOS+sSubset;
    | strictwin:        S:=sWin+sSubset;
    | strictunicode:    S:=sUnicode+sSubset;
    | dosFR:            S:=sFR+sDOS+sFull;
    | winFR:            S:=sFR+sWin+sFull;
    | unicodeFR:        S:=sFR+sUnicode+sFull;
    | strictdosFR:      S:=sFR+sDOS+sSubset;
    | strictwinFR:      S:=sFR+sWin+sSubset;
    | strictunicodeFR:  S:=sFR+sUnicode+sSubset;
    END;
    Str.Prepend(S,headerset);FIO.WrStr(hout,S);FIO.WrLn(hout);

    CASE language OF
    | cberk       : S:= "C ($00 terminated)";
    |dosbios      : S:= 'DOS/BIOS ("$" terminated)';
    |neutral      : S:= "none";
    END;
    Str.Prepend(S,headerlng);FIO.WrStr(hout,S);FIO.WrLn(hout);

    FIO.WrStr(hout,headerabout);
    IF about THEN
        S:="YES";
        IF NOT(aboutdigits) THEN Str.Append (S,sIgnorePat);END;
    ELSE
        S:="no";
    END;
    FIO.WrStr(hout,S);FIO.WrLn(hout);

    FIO.WrStr(hout,headerAZ09);
    FIO.WrCard(hout,requiredAZ09percentage,1);FIO.WrStr(hout,"%");
    FIO.WrLn(hout);

    FIO.WrLn(hout); (* blank line as a separator *)
END dumpheader;

PROCEDURE dmpPrefix ( showaddr,showtype : BOOLEAN;
                     here:LONGCARD;unicount:CARDINAL;hout:FIO.File);
CONST
    sepaddr   = " : ";
VAR
               (*  123456789012345      12345678901      123456        *)
    R : str16; (* "(?) $$$$$$$$ : " -- "$$$$$$$$ : " -- "(?) : " -- "" *)
BEGIN
    IF showtype THEN
        IF unicount < minUnicodeCharLen THEN
            R:=sASCIItype;
        ELSE
            R:=sUNICODEtype;
        END;
        IF showaddr THEN
            Str.Append(R," ");
        ELSE
            Str.Append(R,sepaddr);
        END;
    ELSE
        R:="";
    END;
    IF showaddr THEN Str.Append(R, fmtHex(here,8,FALSE,"",sepaddr) ); END;
    FIO.WrStr(hout,R);
END dmpPrefix;

PROCEDURE doGetASCII (useLFN:BOOLEAN;source,log : pathtype;
                      lastInSequence,minMatch,requiredAZ09percentage:CARDINAL;
                      charset:charsettype;
                      doNotAddCR,verbatim,showaddr,verbose,
                      addquotes,about,aboutdigits,showtype,eyesonly,showhex:BOOLEAN;
                      xlatmode:xlattype;tabcrlf:replacetype; language:languagetype);
VAR
    hin : FIO.File;
    hout: FIO.File;
    match    : CARDINAL;
    code,nextcode : BYTE;
    got      : CARDINAL;
    allowed  : BOOLEAN;
    ch       : CHAR;
    addr,lastaddr,here     : LONGCARD;
    processed,authorized,dumpit   : BOOLEAN;
    fsize,portion,lastportion,currportion : LONGCARD;
    steps    : CARDINAL;
    letsgo,available : BOOLEAN;
    unicount:CARDINAL;
BEGIN
    IF eyesonly THEN verbose:=FALSE;END; (* done earlier by caller, but safety first ! *)
    steps := 10;
    fsize := fileGetFileSize(useLFN,source);
    portion:=fsize DIV LONGCARD(steps); INC(portion); (* avoid DIV 0 ! *)
    lastportion := LONGCARD(steps+1);

    DEC(lastInSequence); (* remember ! *)

    (* Work(cmdInit); *)
    IF verbose THEN animInit(steps, "[", "]", chFiller, "", "\/" ); END;

    hin :=fileOpenRead(useLFN,source);
    FIO.AssignBuffer(hin,bufferIn);
    IF eyesonly THEN
        hout:=FIO.StandardOutput; (* verbose is set to FALSE earlier by caller *)
    ELSE
        hout:=fileCreate(useLFN,log); (* logs are created in current directory *)
        FIO.AssignBuffer(hout,bufferOut);
    END;

    (* code moved out to separate procedure in order to avoid weird isl:342 compilation error *)

    dumpheader(hout,source,charset,language,minMatch,requiredAZ09percentage,about,aboutdigits);

    Sequence  := "";
    match     := 0;
    unicount  := 0;

    addr      := 0;
    here      := 0; (* safety *)
    available := FALSE;

    LOOP
        lastaddr:=addr;
        IF available THEN
            code:=nextcode;
            available:=FALSE;
        ELSE
            got:=FIO.RdBin(hin,code,1);
            IF got # 1 THEN EXIT;END;
            INC(addr);
        END;
        CASE charset OF
        | dos :
            allowed :=( tlegaldos[CARDINAL(code)] # forbidden );
        | win :
            allowed :=( tlegalwin[CARDINAL(code)] # forbidden );
        | strictdos,strictdosFR :
            allowed :=( tlegaldosstrict[CARDINAL(code)] # forbidden );
        | strictwin,strictwinFR :
            allowed :=( tlegalwinstrict[CARDINAL(code)] # forbidden );
        | dosFR :
            allowed :=( tlegaldosFR[CARDINAL(code)] # forbidden );
        | winFR :
            allowed :=( tlegalwinFR[CARDINAL(code)] # forbidden );
        | unicode :
            allowed :=( tlegalwin[CARDINAL(code)] # forbidden );
        | strictunicode,strictunicodeFR :
            allowed :=( tlegalwinstrict[CARDINAL(code)] # forbidden );
        | unicodeFR :
            allowed :=( tlegalwinFR[CARDINAL(code)] # forbidden );
        END;
        ch := CHR(code);

        CASE charset OF
        | unicode,strictunicode,unicodeFR,strictunicodeFR:
            IF ( allowed OR (ch = SPACE) ) THEN (* don't forget space is legal ! *)
                got:=FIO.RdBin(hin,nextcode,1);
                IF got # 1 THEN EXIT; END;
                INC(addr);
                available:= NOT ( nextcode=BYTE(00H) );
                IF NOT(available) THEN INC(unicount);END;
            END;
        END;

        CASE language OF
        | dosbios:
            allowed := ( ch # dollar );
        END;

        authorized := ( allowed OR (ch = SPACE) );

        IF authorized THEN
            IF match=0 THEN here:=lastaddr;END;
            Sequence[match] := ch;
            INC (match);
            IF match > lastInSequence THEN
                Sequence[match] := nullchar;

                letsgo:=chkAZ09(charset,requiredAZ09percentage);
                letsgo:= ( letsgo AND chkPatterns(about,aboutdigits) );
                IF letsgo THEN
                    dmpPrefix(showaddr,showtype,here,unicount,hout);
                    dmpSeq(hout,addquotes,xlatmode,tabcrlf);
                    IF ((doNotAddCR=FALSE) OR (verbatim=FALSE)) THEN (* doNotAddCR valid only for sequences *)
                        FIO.WrLn(hout); (* added just for editor safety ! *)
                    END;
                    IF showhex THEN
                        dmpPrefix(showaddr,showtype,here,unicount,hout);
                        dmpSeqHex(hout,unicount);
                    END;
                END;

                Sequence := "";
                match    := 0; (* well... ;-) *)
                unicount := 0;
            END;
        ELSE
            (* latest character was not in our allowed set : check for C strings *)
            CASE language OF
            | cberk:
                dumpit := (ch=nullchar);
            | dosbios:
                dumpit := (ch=dollar);
            | neutral:
                dumpit := TRUE;
            END;
            IF ((match >= minMatch) AND dumpit) THEN
                Sequence[match] := nullchar;

                letsgo:=chkAZ09(charset,requiredAZ09percentage);
                letsgo:= ( letsgo AND chkPatterns(about,aboutdigits) );
                IF letsgo THEN
                    dmpPrefix(showaddr,showtype,here,unicount,hout);
                    dmpSeq(hout,addquotes,xlatmode,tabcrlf);

                    IF verbatim=FALSE THEN
                        FIO.WrLn(hout); (* we'll have another entry after that one *)
                    END;
                    IF showhex THEN
                        dmpPrefix(showaddr,showtype,here,unicount,hout);
                        dmpSeqHex(hout,unicount);
                    END;
                END;
            END;

            Sequence := "";
            match    := 0;
            unicount := 0;
        END;

        (* Work(cmdShow); *)
        IF verbose THEN
            anim(animShow);
            currportion:=addr DIV portion;
            IF currportion # lastportion THEN
                anim(animAdvance);
                lastportion:=currportion;
            END;
        END;
    END;
    CASE language OF
    | cberk:
        dumpit := (ch=nullchar);
    | dosbios:
        dumpit := (ch=dollar);
    | neutral:
        dumpit := TRUE;
    END;
    IF ((match >= minMatch) AND dumpit) THEN
        Sequence[match] := nullchar;

        letsgo:=chkAZ09(charset,requiredAZ09percentage);
        letsgo:= ( letsgo AND chkPatterns(about,aboutdigits) );
        IF letsgo THEN
            dmpPrefix(showaddr,showtype,here,unicount,hout);
            dmpSeq(hout,addquotes,xlatmode,tabcrlf);
            IF verbatim=FALSE THEN
                FIO.WrLn(hout);
            END;
            IF showhex THEN
                dmpPrefix(showaddr,showtype,here,unicount,hout);
                dmpSeqHex(hout,unicount);
            END;
        END;
    END;

    IF eyesonly THEN
        ;
    ELSE
        FIO.Flush(hout);
        FIO.Close(hout);
    END;
    FIO.Close(hin);

    (* Work(cmdStop); *)
    IF verbose THEN anim(animEnd);anim(animClear); END;
END doGetASCII;

(* ------------------------------------------------------------ *)

PROCEDURE newname (useLFN:BOOLEAN;charnum:CHAR;ext:ARRAY OF CHAR;VAR S : pathtype):BOOLEAN;
VAR
    extpattern,num,newext:str16; (* should do even with LFNs *)
    wi,i,j,maxtries:CARDINAL;
    u,d,n,e  : pathtype;
    ok:BOOLEAN;
    newfile:pathtype;
BEGIN
    Str.Copy(extpattern,ext);
    IF CharCount(extpattern,dot)=0 THEN Str.Prepend(extpattern,dot);END;
    wi := CharCount(ext,charnum);
    IF wi = 0 THEN
        Str.Copy(extpattern,dot+"?");
        wi:=3;
    ELSE
        Str.Subst(extpattern,charnum,"?");
        ReplaceChar(extpattern,charnum,"");
    END;
    maxtries:=1;FOR j:=1 TO wi DO maxtries:=maxtries*10;END;DEC(maxtries);
    Lib.SplitAllPath(S,u,d,n,e);
    i:=0;
    LOOP
        Str.CardToStr( LONGCARD(i),num,10,ok);
        FOR j := 1 TO wi DO
            IF Str.Length(num)< wi THEN Str.Prepend(num,"0");END;
        END;

        Str.Copy(newext,extpattern);
        Str.Subst(newext,"?",num);
        Lib.MakeAllPath(newfile,u,d,n,newext);
        IF fileExists(useLFN,newfile)=FALSE THEN
            Str.Copy(S,newfile);
            RETURN TRUE;
        END;
        INC(i);
        IF i > maxtries THEN EXIT; END;
    END;
    RETURN FALSE;
END newname;

PROCEDURE buildPath (VAR path:pathtype; spec:pathtype);
VAR
    u,d,n,e:pathtype;
BEGIN
    Lib.SplitAllPath(spec, u,d,n,e);
    Str.Concat(path, u,d);
    fixDirectory(path); (* safety *)
END buildPath;

PROCEDURE newExtension (VAR R:pathtype;ext:str16); (* use expected types here *)
VAR
    p:CARDINAL;
    S:pathtype;
BEGIN
    p := Str.RCharPos(R,dot);
    IF p # MAX(CARDINAL) THEN
        Str.Slice(S,R,0,p);
        Str.Copy(R,S);
    END;
    Str.Append(R,ext);
END newExtension;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    minseq       = 3;
    maxseq       = maxInSequence+1;
    defaultseq   = 4096;
CONST
    minmatch     = 2; (* was 3 *)
    maxmatch     = 128;
    defaultmatch = 3;
CONST
    minAZ09                = 0;
    maxAZ09                = 100;
    defaultAZ09percentage  = minAZ09; (* this MUST be 0 ! especially with -i *)
    undefinedAZ09percentage= MAX(CARDINAL);
VAR
    lastinsequence: CARDINAL;
    minMatch      : CARDINAL;
    requiredAZ09percentage  : CARDINAL;
    flagBeep      : BOOLEAN;
    flagOverwrite : BOOLEAN;
    charset       : charsettype;
    flagRaw       : BOOLEAN;
    flagVerbatim  : BOOLEAN;
    flagShowOffset: BOOLEAN;
    flagstrictcharset:BOOLEAN;
    language      : languagetype;
    flagVerbose   : BOOLEAN;
    flagQuotes    : BOOLEAN;
    flagAutorename: BOOLEAN;
    flagAbout     : BOOLEAN;
    flagAboutDigits:BOOLEAN;
    flagFrench    : BOOLEAN;
    flagShowtype  : BOOLEAN;
    flagEyesOnly  : BOOLEAN;
    flagShowHex   : BOOLEAN;
    doReplace     : replacetype;
    useLFN        : BOOLEAN;
    ext           : str16;    (* should do even with LFNs *)
    countFile     : CARDINAL;
    anchor,ptr    : pFname;
    xlatmode      : xlattype;
VAR
    parmcount, i, opt : CARDINAL;
    S,R               : pathtype;
    spec, path,info,F : pathtype;
    state     : (waiting,gotSpec);

    action    : (GoGoGo,skipExisting,skipRO,skipOneself,skipNewname,
                 GoGoGoEyesOnly);

    p    : CARDINAL;
    v    : LONGCARD;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)

    WrLn;

    useLFN := TRUE;

    requiredAZ09percentage := undefinedAZ09percentage;
    lastinsequence:= defaultseq;
    minMatch      := defaultmatch;
    flagBeep      := FALSE;
    flagOverwrite := FALSE;
    charset       := dos;
    flagRaw       := FALSE;
    flagVerbatim  := FALSE;
    flagShowOffset:= FALSE;
    flagShowtype  := FALSE;
    flagstrictcharset := FALSE; (* reduced or full charset *)
    language      := neutral;
    flagVerbose   := TRUE;
    flagQuotes    := FALSE;
    flagAutorename:= FALSE;
    flagAbout     := FALSE;
    flagAboutDigits:=FALSE;
    flagFrench    := FALSE;
    flagEyesOnly  := FALSE;
    flagShowHex   := FALSE;
    xlatmode      := xlatnone;
    doReplace     := (metanone);
    Str.Copy(ext,extLOG);

    state:=waiting;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R); cleantabs(R); (* YATB ! *)
        IF isOption(R) THEN
            opt :=GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                 "B"+delim+
                                 "O"+delim+
                                 "W"+delim+
                                 "U"+delim+
                                 "M:"+delim+
                                 "E"+delim+
                                 "V"+delim+
                                 "A"+delim+
                                 "F"+delim+
                                 "C"+delim+
                                 "S:"+delim+
                                 "E:"+delim+
                                 "T"+delim+
                                 "S"+delim+
                                 "AA"+delim+
                                 "D"+delim+"$"+delim+
                                 "Q"+delim+
                                 "J"+delim+"REPLACE"+delim+
                                 "R"+delim+
                                 "P:"+delim+
                                 "L"+delim+"LFN"+delim+
                                 "I"+delim+"ABOUT"+delim+
                                 "II"+delim+

                                 "WW"+delim+
                                 "UU"+delim+
                                 "FR"+delim+"FRENCH"+delim+
                                 "Y"+delim+"WIN2PC"+delim+
                                 "Z"+delim+"PC2WIN"+delim+

                                 "N"+delim+"NOLOG"+delim+
                                 "IN"+delim+
                                 "IIN"+delim+"III"+delim+
                                 "X"+delim+"HEX"+delim+"HEXA"
                                 );
            CASE opt OF
            | 1,2,3: abort(errHelp,"");
            | 4 :    flagBeep:=TRUE;
            | 5 :    flagOverwrite:=TRUE;
            | 6 :    charset:=win;
            | 7 :    charset:=unicode;
            | 8 :
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S);END;
                IF (v < LONGCARD(minmatch)) OR (v > LONGCARD(maxmatch)) THEN abort(errMatchRange,"");END;
                minMatch:=CARDINAL(v);
            | 9 :    flagRaw :=TRUE;
            | 10:    flagVerbatim:=TRUE;
            | 11:    flagShowOffset:=TRUE;
            | 12:    flagstrictcharset:=TRUE;
            | 13:    CASE language OF
                     | neutral,cberk:language:=cberk;
                     ELSE
                         abort(errLanguage,"");
                     END;
            | 14:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S);END;
                IF (v < LONGCARD(minseq)) OR (v > LONGCARD(maxseq)) THEN abort(errSeqRange,"");END;
                lastinsequence:=CARDINAL(v);
            | 15:
                GetString(S,R);
                IF same(R,"") THEN abort(errEmptyExt,""); END;
                IF R[0] <> dot THEN Str.Prepend(R,dot);END;
                IF Str.Length(R) > 1+3 THEN abort(errLongExt,R);END;
                UpperCase(R);
                Str.Copy(ext,R);
            | 16:    flagVerbose:=FALSE;

            | 17:                         flagShowtype := TRUE;
            | 18:    flagShowOffset:=TRUE;flagShowtype := TRUE;

            | 19,20: CASE language OF
                     | neutral,dosbios:language:=dosbios;
                     ELSE
                         abort(errLanguage,"");
                     END;
            | 21:    flagQuotes:=TRUE;
            | 22,23: CASE doReplace OF
                     | metanone,metaplain: doReplace:=metaplain;
                     ELSE
                         doReplace := metaplain; (* was unused errMeta *)
                     END;
            | 24:    flagAutorename:=TRUE;
            | 25:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S);END;
                IF (v < LONGCARD(minAZ09)) OR (v > LONGCARD(maxAZ09)) THEN
                    abort(errAZ09range,"");
                END;
                requiredAZ09percentage:=CARDINAL(v);
            | 26,27: useLFN := FALSE;
            | 28,29: flagAbout       := TRUE;
                     flagAboutDigits := TRUE;
                     charset := unicode;        (* force -u *)
            | 30:    flagAbout       := TRUE;
                     flagAboutDigits := FALSE;
                     charset := unicode;        (* force -u *)

            | 31:    charset:=win;
                     CASE xlatmode OF
                     | xlatnone,xlatoemtoascii: xlatmode:=xlatoemtoascii;
                     ELSE
                         abort(errXlat,"");
                     END;
            | 32:    charset:=unicode;
                     CASE xlatmode OF
                     | xlatnone,xlatoemtoascii: xlatmode:=xlatoemtoascii;
                     ELSE
                         abort(errXlat,"");
                     END;
            | 33,34: flagFrench:=TRUE;
            | 35,36:
                     CASE xlatmode OF
                     | xlatnone,xlatoemtoascii: xlatmode:=xlatoemtoascii;
                     ELSE
                         abort(errXlat,"");
                     END;
            | 37,38:
                     CASE xlatmode OF
                     | xlatnone,xlatasciitooem: xlatmode:=xlatasciitooem;
                     ELSE
                         abort(errXlat,"");
                     END;
            | 39,40:
                     flagEyesOnly:=TRUE;
            | 41:    flagAbout       := TRUE;
                     flagAboutDigits := TRUE;
                     charset := unicode;        (* force -u *)
                     flagEyesOnly:=TRUE;
            | 42,43: flagAbout       := TRUE;
                     flagAboutDigits := FALSE;
                     charset := unicode;        (* force -u *)
                     flagEyesOnly:=TRUE;
            | 44,45,46: flagShowHex     := TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE state OF
            | waiting:
                Str.Copy(spec,S); UpperCaseAlt(S); (* keep accents *)
            ELSE
                abort(errTooManyParms,S);
            END;
            INC(state);
        END;
    END;

    useLFN := ( useLFN AND w9XsupportLFN() );

    (* check nonsense *)

    IF state=waiting THEN abort(errMissingName,""); END;
    IF (flagOverwrite AND flagAutorename) THEN abort(errTargetRules,"");END;

    IF requiredAZ09percentage=undefinedAZ09percentage THEN
        requiredAZ09percentage:=defaultAZ09percentage; (* must be 0 by default *)
    ELSE
        IF flagAbout THEN abort(errAbout,"");END;
    END;

    IF same(spec,dot) THEN Str.Copy(spec, stardotstar);END;

    initList(anchor);
    countFile:=buildFileList(anchor,useLFN,spec);
    IF countFile=MAX(CARDINAL) THEN abort(errTooManyFiles,spec);END; (* errStorage *)
    IF countFile=0 THEN abort(errNotFound,spec); END;

    buildPath(path,  spec);

    (* step 1 *)

    IF flagstrictcharset THEN
        CASE charset OF
        | dos :    charset:=strictdos;
        | win :    charset:=strictwin;
        | unicode: charset:=strictunicode;
        END;
    END;

    (* step 2 *)

    IF flagFrench THEN
        CASE charset OF
        | dos:            charset:=dosFR;
        | win:            charset:=winFR;
        | unicode:        charset:=unicodeFR;
        | strictdos:      charset:=strictdosFR;
        | strictwin:      charset:=strictwinFR;
        | strictunicode:  charset:=strictunicodeFR;
        END;
    END;

    IF flagEyesOnly THEN
        ;
    ELSE
        WrStr(Banner);WrLn;
        WrLn;
    END;

    ptr:=anchor;
    WHILE ptr # NIL DO
        getStr(R,ptr);
        newExtension(R,ext);

        getStr(S,ptr);
        Str.Prepend(S,path);

        action:=GoGoGo;
        IF flagEyesOnly THEN
            flagVerbose:=FALSE; (* force -t *)
            action:=GoGoGoEyesOnly;
        ELSE
            action:=GoGoGo;
            IF fileExists(useLFN,R) THEN
                CASE flagOverwrite OF
                | TRUE:
                    IF fileIsRO(useLFN,R) THEN action:=skipRO; END;
                    (* yes, in fact, we should check current dir with source... *)
                    getStr(F,ptr);
                    IF same(R, F) THEN action:=skipOneself;END;
                | FALSE :
                    IF flagAutorename THEN
                        IF newname(useLFN,"#",extNUM,R)=FALSE THEN action:=skipNewname; END;
                    ELSE
                        action:=skipExisting;
                    END;
                END;
            END;

            (* was "Processing " ", please wait..." *)
            Str.Concat(info,":: ",S);
            IF flagVerbose THEN
                Str.Append(info," ");
            ELSE
                Str.Append(info," ...");
            END;
            video(info,TRUE);
        END;

        CASE action OF
        | GoGoGo,GoGoGoEyesOnly:
            doGetASCII (useLFN,S,R, lastinsequence,minMatch,requiredAZ09percentage,
                       charset, flagRaw,flagVerbatim,flagShowOffset,
                       flagVerbose,flagQuotes,flagAbout,flagAboutDigits,
                       flagShowtype,flagEyesOnly,flagShowHex,
                       xlatmode, doReplace,language);
            Str.Prepend(R,"++ ");
            Str.Append(R," created from ");
            Str.Append(R,S);
        | skipExisting: Str.Concat(R,"-- ",S);Str.Append(R," skipped (target log already exists)");
        | skipRO:       Str.Concat(R,"-- ",S);Str.Append(R," skipped (target log is read-only)");
        | skipOneself:  Str.Concat(R,"-- ",S);Str.Append(R," skipped (target log would share the same name)");
        | skipNewname:  Str.Concat(R,"-- ",S);Str.Append(R," skipped (autorename failure)");
        END;
        CASE action OF
        | GoGoGoEyesOnly :
            IF ptr^.next # NIL THEN WrLn;END;
        ELSE
            video(info,FALSE);
            WrStr(R);WrLn;
        END;

        IF ChkEscape() THEN
            freeList(anchor); (* cleaner *)
            abort(errAbortedByUser,"");
        END;

        ptr:=ptr^.next;
    END;

    IF flagBeep THEN
        Lib.Sound (400);
        Lib.Delay (200);
        Lib.NoSound;
    END;

    freeList(anchor);

    abort(errNone,"");
END Peek.


