(* ---------------------------------------------------------------
Title         Q&D Picture Finder
Author        PhG
Overview
Usage         see help
Notes         P4 2.4G really required for such a slow program !
              and it began on a mere DX33...
              anyway, let's do as every programmer does now :
              rely on faster hardware to justify our lazyness

              YATSF (Yet Another TopSpeed Feature) :
              because of precedence, shift operations do require parenthesis
              as not to have << 6 instead of << 6+5

              model should no longer be small (useless safety for QD_LFN)

              compute time spent showing pic in many memory models

              yes, the whole thing would benefit from a complete rewrite
              yet, it's useful enough for me, eh eh...

              according to (name withheld), newer video cards
              such as GTS450 may exhibit strange quirks
              (probably due to poor VESA support)

              yes, we could show filename somewhere in help screen
              yes, yes, we could have a better directory listing / pickfile
              yes, yes, yes, we should pack more infos in help and status

Bugs          program won't process files beyong 2Gb thinking it's 0 : DOS strikes !
              we should not rely on user not setting too high a video mode
              (anyway, seems VESA does not go beyond 1600)
              fix palette quirks
Wish List     a better BYTE/WORD dump ? bah...
              43/50 lines
              we support only 256 and 16M modes : 32K and 64K later on ?
              write screen to another format than than plain, simple, good old Targa ?

              force "?" in "RGB?" quad to 0 ?

              why not allow width increase beyond screen ?
              support 320x200x8 and/or modes X ?

              reorg pixel format as single/duplet/triplet/quadruplet
              and variations rgba ? (would be more rational)

              fix other kinds of planar formats
              add an intermediary cache to speed up things ? (argh, full rewrite in sight !)

              other weird format seen in nVidia DDS tools : r12 g12 b8

              add functions to change gamma ? mirror h & v ?
              look for DXT and unpack accordingly ?
              zoom ? rotate ? flip ? interlace ?

              enter value without going back to text mode

              fed up with palette tweaking...

              support 2048 using some form of window ?

--------------------------------------------------------------- *)

MODULE picFind;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;

FROM IO IMPORT WrStr,WrLn,WrCard;

FROM QD_ASCII IMPORT dash, slash, nullchar, tabchar, cr, lf, nl, bs,
space, dot, deg, doublequote, quote, colon, percent, vbar,
blank, equal, dquote, charnull, singlequote, antislash, dollar,
star, backslash, coma, question, underscore, tabul, hbar,
comma, semicolon, diese, pound, openbracket, closebracket, tilde, exclam,
stardotstar, dotdot, escCh, escSet, letters, digits,
lettersUpp, lettersLow, openbrace, closebrace;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;

FROM QD_VESA IMPORT vesa640x480x8, vesa800x600x8,
vesa640x480x32, vesa800x600x32, vesa1024x768x8, vesa1280x1024x8,
vesa1024x768x32, vesa1280x1024x32, vesa1600x1200x8,
paltriplettype, minpalndx, maxpalndx,
isMonoMode, waitVGAretrace, setDAC,
resetDAC, getDAC, savesystempal, restoresystempal,
SetVesaMode, initVESAlookup, getVESAmodeInfos,
setVESAbank, VESAgetpixel8, VESAgetpixel32, VESAputpixel8,
VESAputpixel32, initVESAhline, updateVESAhline, VESAputpixel8hline,
VESAputpixel32hline, initVESAmode, getVESAgeometry, chkVESAhere,
isModeHere, set80x25, set80x50, getTextmodeDimensions, textclearscreen,
getModeFromList;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XsupportLFN;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    useINLINE     = TRUE; (* darn, no visible effect ! *)
CONST
    PLANAR = TRUE; (* if TRUE, model can no longer be small *)
TYPE
    pathtype = path9X;
    hugestr  = str4096;
CONST
    ProgEXEname   = "PICFIND";
    ProgTitle     = "Q&D Picture Finder";
    ProgVersion   = "v1.0t"
(*%F PLANAR *)
    + "-";        (* show we're lacking a feature *)
(*%E  *)
(*%T PLANAR *)
    ;
(*%E *)
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    hexprefix     = dollar;
    extTGA        = ".TGA";
    extPAL        = ".PAL";
    extLOG        = ".LOG";
    extINI        = ".INI";
    extEXE        = ".EXE";
    picFmt        = "Targa";
    basePIC       = "PIC"; (* 3 chars *)
    basePAL       = "PAL"; (* 3 chars *)
    MINNUM        = 1;
    MAXNUM        = 99999; (* "???#####" *)
    defaultKMUL   = 8;
    maxKMUL       = 128;
    sDefaultKmul  = "8";
    sMaxKmul      = "128";
    modeplaceholder    = "*";
    altmodeplaceholder = dollar;
CONST
    key10a = "1"; key10b = "&";
    key20a = "2"; key20b = "";
    key30a = "3"; key30b = '"';
    key40a = "4"; key40b = "'";
    key50a = "5"; key50b = "("; (* 5 was conflict *)
    key60a = "6"; key60b = "-"; (* - would be conflict *)
    key70a = "7"; key70b = "";
    key80a = "8"; key80b = "_";
    key90a = "9"; key90b = "";
CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errParam        = 3;
    errValue        = 4;
    errBPP          = 5;
    errJoker        = 6;
    errNotFound     = 7;
    errSyntax       = 8;
    errBios         = 9;
    errUnsupported  = 10;
    errSet          = 11;
    errCall         = 12;
    errGranularity  = 13;
    errRange        = 14;
    errBPPmismatch  = 15;
    errNoPalette    = 16;
    errEmptyFile    = 17;
    errLFN          = 18;
    errIniNotFound  = 19;
    errHelper       = 20;

(* ------------------------------------------------------------ *)

CONST
    msgAnykey = "Hit any key to return to previous display... ";

    helpKeys = (* 17 lines *)
"[J][/][*][L] [alt-W] window width / specify new window width"+nl+
"[I][-][+][K] [alt-H] window height / specify new window height"+nl+
"[0][.] [PgUp][PgDn]  move one byte / move (half-)window height"+nl+ (* [Return] *)
"[arrow_keys]         move # pixels/lines (shift=1)"+nl+
"[alt--][alt-+]       decrease or increase # count of pixels and lines"+nl+
"[Home] [End] [alt-P] start of file / end of file / enter new file position"+nl+
(*%T PLANAR *)
"[[shift-]Tab]        888A A888 888 565 555 444A A444 palette planar ([F1..F9])"+nl+
(*%E *)
(*%F PLANAR *)
"[[shift-]Tab]        888A A888 888 565 555 444A A444 palette ([F1..F8])"+nl+
(*%E *)
"[alt-G] [alt-O]      text mode (toggle) / text mode video retrace (toggle)"+nl+
"[B][W][Q] [1..9]     hexadecimal dump (bytes, words, double words) / percentage"+nl+
"[^R] [V] [X]         restore system pal / show pal / fix pal (RGB DIV 4)"+nl+
"[P][Delete] [)][=]   read or rewind 768 / read or rewind 1024"+nl+
"[Y] [U] [alt-Y]      read 768 & rewind 767 / read 1024 & rewind 1023 / user pal"+nl+
"[R] [^F] [^E]        negative (toggle) / flip (toggle) / endian mode (toggle)"+nl+
"[^V] [^B] [^N]       brightness (decrease / reset / increase)"+nl+
"[^S] [^P] [alt-L]    save window or 768 bytes RGB palette to file / user file"+nl+ (* no longer remind about current dir *)
"[^L] [F]             25|50 lines (toggle) / half|full window motion (toggle)"+nl+
"[?] [,] [^F10] [Esc] show help / show parameters / shell to DOS / quit to DOS"+nl;

    msgHelpHexKeys =
"[Left][Right][Up][Down][PgUp][PgDn][Return][Home][End][alt-O][B][W][Q][Esc]";

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp =
Banner+nl+
nl+
"Syntax 1 : "+ProgEXEname+" <mode|"+modeplaceholder+"|"+altmodeplaceholder+"> <file> [option]..."+nl+
"Syntax 2 : "+ProgEXEname+" <-l>"+nl+
nl+
"-l   list compatible VESA modes (8 BPP and 32 BPP) then terminate"+nl+
"-s   safer and slower display (default is faster)"+nl+
"-m:# 16 or 32 bits color mode (default is 1)"+nl+
"     1=RGBA 8:8:8:8, 2=BGRA 8:8:8:8, 3=ARGB 8:8:8:8, 4=ABGR 8:8:8:8,"+nl+
"     5=RGB 8:8:8, 6=BGR 8:8:8, 7=RGB 5:6:5, 8=BGR 5:6:5,"+nl+
"     9=RGB 5:5:5, 10=BGR 5:5:5,"+nl+
"     11=RGBA 4:4:4:4, 12=BGRA 4:4:4:4, 13=ARGB 4:4:4:4, 14=ABGR 4:4:4:4"+
(*%T PLANAR *)
                                                                       ","+nl+
"     15=RGB planar, 16=BGR planar"+nl+
(*%E *)
(*%F PLANAR  *)
      nl+
(*%E  *)
"-a:# palette mode (1=RGB, 2=BGR), default is 1"+nl+
"-x   fix palette dividing RGB components by 4 ([$00..$ff] --> [$00..$3f])"+nl+
"-p:# position in <file> [0..filesize-1]"+nl+
"-w:# window width [1..screenwidth], default is screen width"+nl+
"-h:# window height [1..screenheight], default is screen height"+nl+
"-k:# motion multiplier [1.."+sMaxKmul+"], default is "+sDefaultKmul+nl+
"-d   half-window height motion (default is full window height)"+nl+
"-k   enable keyboard buffer"+nl+
"-e   assume big-endian Motorola data (default is little-endian Intel data)"+nl+
"-r   negative image"+nl+
"-f   flip image"+nl+
"-t   do not fix palette RGB components when saving to "+picFmt+" 256 colors"+nl+
"-2   force 25 lines text mode"+nl+
"-5   force 50 lines text mode"+nl+
"-g   force text mode for help and hexadecimal dump (default is graphics screen)"+nl+
"-w   do not wait for video retrace when clearing text screen"+nl+
"-v   display current parameters at program exit"+nl+
"-n   disable LFN support even if available"+nl+
"-??  more help"+nl+
nl+
"a) This program does require a VESA BIOS... and a VERY fast processor."+nl+
'b) VESA <mode> can be specified as a (hexa)decimal ("'+hexprefix+'" prefix) value'+nl+
'   or as WIDTHxHEIGHTxBPP. If specified as "'+modeplaceholder+'" or as "'+altmodeplaceholder+'",'+nl+
"   program will get mode from optional "+ProgEXEname+extINI+" in executable directory."+nl+
"c) Directory listings (DOS f8.e3 format) apply to current directory only ;"+nl+
"   due to FAT limitations, <file> will not be processed if longer than 2Gb."+nl+
"d) Pictures and 768 bytes RGB palettes are saved to current directory :"+nl+
"   pictures as "+basePIC+"*"+extTGA+", palettes as "+basePAL+"*"+extPAL+"."+nl+
"e) All write operation parameters are appended to "+ProgEXEname+extLOG+" logfile."+nl+
"f) If graphics screen cannot fit 25*80 characters, -g option is forced."+nl+
"g) When entering a value or shelling to DOS, text mode is forced."+nl+
"h) Hexadecimal dump moves depend upon selected data size."+nl+
"i) Endian toggling applies to 2 and 4 bytes pixel sizes only."+nl+
(*%T PLANAR *)
"j) Planar mode viewing requires picture width and height to be correct."+nl+
(*%E *)
nl+
"Examples : "+ProgEXEname+" 800x600x32 beach /w:256 /h:256 /p:$69992d /m:2"+nl+
"           "+ProgEXEname+" $103 dungeon /w:256 /h:256 /p:$5488aa8"+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msgHelp);
    | errHelper:
        WrStr(msgHelp);
        WrStr(nl+
              "Here are keys available while viewing <file> :"+nl+
              nl);
        WrStr(helpKeys);
        (*
        WrLn;
        WrStr(msgHelpHexKeys);
        *)
        e:=errHelp;
    | errOption :
        Str.Concat(S,'Unknown "',einfo);Str.Append(S,'" option !');
    | errParam :
        Str.Concat(S,'Unexpected "',einfo);Str.Append(S,'" parameter !');
    | errValue:
        Str.Concat(S,'Illegal "',einfo);Str.Append(S,'" value !');
    | errBPP   :
        Str.Concat(S,'Illegal "',einfo);Str.Append(S,'" <bpp> value !');
    | errJoker:
        Str.Concat(S,'Illegal joker(s) in "',einfo);Str.Append(S,'" !');
    | errNotFound:
        Str.Concat(S,'"',einfo);Str.Append(S,'" does not exist !');
    | errSyntax:
        S := "Syntax error, check help screen !";
    | errBios:
        S := "No VESA BIOS available !";
    | errUnsupported:
        S := "Unsupported video mode !";
    | errSet:
        Str.Concat(S,"BIOS would not set ",einfo);Str.Append(S," video mode !");
    | errCall:
        Str.Concat(S,einfo," call failure !");
    | errGranularity:
        S := "Unsupported granularityKB value !";
    | errRange:
        Str.Concat(S,"Specified ",einfo);Str.Append(S," is out of legal range !");
    | errBPPmismatch:
        S := "True color mode is a nonsense with 256 colors video mode !";
    | errNoPalette:
        S := "Palette order is a nonsense with true color video mode !";
    | errEmptyFile:
        Str.Concat(S,'"',einfo);Str.Append(S,'" is 0-length !');
    | errLFN:
        Str.Concat(S,'"',einfo);Str.Append(S,'" LFN unresolvable or not found !');
    | errIniNotFound:
        Str.Concat(S,'"',einfo);Str.Append(S,'" does not exist !');
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp :
        ;
    ELSE
        WrStr(ProgEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    ioBufferIn : ioBufferType;
    ioBufferOut: ioBufferType;

PROCEDURE sound (freq,duration:CARDINAL);
BEGIN
    Lib.Sound(freq);
    Lib.Delay(duration);
    Lib.NoSound();
END sound;

PROCEDURE soundDone (  );
BEGIN
    sound(222,20);
END soundDone;

PROCEDURE soundLimit (  );
BEGIN
    sound(222,50); (* was 55,300 *)
END soundLimit;

PROCEDURE soundBadKey (  );
BEGIN
    sound(55,50);
END soundBadKey;

PROCEDURE soundIrrelevant (  );
BEGIN
    sound(55,100);
END soundIrrelevant;

PROCEDURE soundKant();
BEGIN
    sound(55,300);
END soundKant;

PROCEDURE getCardValue (VAR v:CARDINAL;S:ARRAY OF CHAR):BOOLEAN;
VAR
    n:LONGCARD;
    p,base:CARDINAL;
    ok:BOOLEAN;
BEGIN
    Str.Caps(S); (* just in case ! *)
    base:=10;
    n:=Str.StrToCard(S,base,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF n > MAX(CARDINAL) THEN RETURN FALSE; END;
    v:=CARDINAL(n);
    RETURN TRUE;
END getCardValue;

PROCEDURE waitkeypress (  );
VAR
    c1,c2:CHAR;
BEGIN
    BiosFlushkey;
    BiosWaitkey(c1,c2);
END waitkeypress;

PROCEDURE fmtnum (v:LONGCARD;base:CARDINAL;padwi:INTEGER;padchar:CHAR):str16;
VAR
    R:str16;
    ok:BOOLEAN;
    i:CARDINAL;
BEGIN
    Str.CardToStr(v,R,base,ok);
    IF base=16 THEN Str.Lows(R);END;
    FOR i:=Str.Length(R)+1 TO ABS(padwi) DO
        IF padwi < 0 THEN
            Str.Append(R,padchar);
        ELSE
            Str.Prepend(R,padchar);
        END;
    END;
    RETURN R;
END fmtnum;

PROCEDURE getLongCardValue (VAR v:LONGCARD;S:ARRAY OF CHAR):BOOLEAN;
VAR
    p,base:CARDINAL;
    ok:BOOLEAN;
BEGIN
    Str.Caps(S); (* just in case ! *)
    IF Str.Match(S,hexprefix+"*") THEN
        Str.Delete(S,0,1);
        base:=16;
    ELSIF Str.Match(S,"0X*") THEN
        Str.Delete(S,0,2);
        base:=16;
    ELSIF Str.Match(S,"*H") THEN
        p:=Str.Length(S);
        Str.Delete(S,p-1,1);
        base:=16;
    ELSE
        base:=10;
    END;
    v:=Str.StrToCard(S,base,ok);
    RETURN ok;
END getLongCardValue;

PROCEDURE parseWHBPP (VAR w,h,bpp:CARDINAL; S:ARRAY OF CHAR   ):BOOLEAN;
CONST
    star="*";
    mul="X";
    pat="*"+mul+"*"+mul+"*";
VAR
    len,p,q:CARDINAL;
    str:str16;
BEGIN
    Str.Caps(S); (* just in CASE *)
    ReplaceChar(S,star,mul);
    IF Str.Match(S,pat)=FALSE THEN RETURN FALSE;END;
    len:=Str.Length(S);
    p:=Str. CharPos(S,mul);
    q:=Str.RCharPos(S,mul);
    IF p=0 THEN RETURN FALSE;END;
    IF q=(len-1) THEN RETURN FALSE;END;
    Str.Slice(str,S,0,p);
    IF getCardValue(w,str)=FALSE THEN RETURN FALSE;END;
    Str.Slice(str,S,p+1,q-p-1);
    IF getCardValue(h,str)=FALSE THEN RETURN FALSE;END;
    Str.Slice(str,S,q+1,len-q);
    IF getCardValue(bpp,str)=FALSE THEN RETURN FALSE;END;
    RETURN TRUE;
END parseWHBPP;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* assume f8 is 3 chars *)

PROCEDURE buildname (f8,e3:ARRAY OF CHAR;
                    VAR num:CARDINAL; VAR F:ARRAY OF CHAR):BOOLEAN;
VAR
    wi,ndx:CARDINAL;
    ok:BOOLEAN;
BEGIN
    ok:=TRUE;
    ndx:=1;
    wi:=8-Str.Length(f8);
    LOOP
        Str.Concat(F,f8, fmtnum (LONGCARD(num),10,wi,"0"));
        Str.Append(F,e3);
        IF FIO.Exists(F)=FALSE THEN EXIT; END;
        INC(num);
        IF num > MAXNUM THEN num:=MINNUM; INC(ndx);END;
        IF ndx > 2 THEN ok:=FALSE; EXIT; END;
    END;
    RETURN ok;
END buildname;

PROCEDURE screenToFile (VAR picnum:CARDINAL; VAR F: ARRAY OF CHAR;
                       bpp,xmin,ymin,wi,he:CARDINAL; targaquirk:BOOLEAN );
CONST
    egashift = 2;
TYPE
    TGAheaderType = RECORD
	    imgidlen                  : BYTE; (* should be 0 to avoid imgidstring *)
	    colormaptype              : BYTE; (* 0=no map, 1=256 entry palette *)
	    imgtype                   : BYTE; (* 1=uncompressed color mapped, 2=uncompressed rgb *)

	    indexoffirstcolormapentry : CARDINAL; (* ex:1024 entries but only 72 needed, start at position 342 *)
	    countofcolormapentries    : CARDINAL;
	    bitspercolormapentry      : BYTE; (* 15, 16, 24, 32 *)

	    lowerleftcornerX          : CARDINAL; (* x origin *)
	    lowerleftcornerY          : CARDINAL; (* y origin *)
	    imgwidth                  : CARDINAL;
	    imgheight                 : CARDINAL;
	    bitsperpixel              : BYTE; (* number of bits in a stored pixel index 8,16,24,32 *)
	    imgdescriptor             : BYTE;
	                                (*
	                                bits 3..0=number of attribute bits for each pixel
						            0 or 1 for targa16, 0 for targa24, 8 for targa32
					                bit 4=left to right ordering
						            bit 5=top to bottom ordering 0 for origin lower left, 1 for origin upper left
                                    this byte should be $00
                                    *)
    END;
    (*
    then possible color map data
    according to bitspercolor map entry
    4=B G R Attr
    3=B G R
    2=ARRRRRGG GGGGBBBBB (hi lo)
    then image data
    width x height colormap indices
    *)
VAR
    hout:FIO.File;
    h : TGAheaderType;
    ink,r,g,b:SHORTCARD;
    i,x,y:CARDINAL;
BEGIN
    IF buildname(basePIC,extTGA,  picnum,F)=FALSE THEN soundKant; RETURN;END;
    hout:=FIO.Create(F);
    FIO.AssignBuffer(hout,ioBufferOut);
    CASE bpp OF
    | 8:
        h.imgidlen                  := 0;
        h.colormaptype              := 1; (* map *)
        h.imgtype                   := 1; (* uncompressed color mapped *)
        h.indexoffirstcolormapentry := minpalndx; (* 0 *)
        h.countofcolormapentries    := maxpalndx-minpalndx+1; (* 256 *)
        h.bitspercolormapentry      := 3*8;
        h.lowerleftcornerX          := 0;
        h.lowerleftcornerY          := 0;
        h.imgwidth                  := wi;
        h.imgheight                 := he;
        h.bitsperpixel              := 8;
        h.imgdescriptor             := 0;
    |32:
	    h.imgidlen                  := 0;
	    h.colormaptype              := 0; (* no map *)
	    h.imgtype                   := 2; (* uncompressed rgb *)
	    h.indexoffirstcolormapentry := 0;
	    h.countofcolormapentries    := 0;
	    h.bitspercolormapentry      := 0;
	    h.lowerleftcornerX          := 0;
	    h.lowerleftcornerY          := 0;
	    h.imgwidth                  := wi;
	    h.imgheight                 := he;
	    h.bitsperpixel              := 3*8;
	    h.imgdescriptor             := 0;
	    (*
        h.imgdescriptor:=BYTE(CARDINAL(h.imgdescriptor) OR 16); (*  bit 5 : spr picture is flipped *)
        *)
    END;

    FIO.WrBin(hout,h,SIZE(h));

    CASE bpp OF
    | 8:
        FOR i:=minpalndx TO maxpalndx DO
            getDAC(i,r,g,b);
            IF targaquirk THEN (* $00..$3f to $00..$ff *)
                r:=r << egashift;
                g:=g << egashift;
                b:=b << egashift;
            END;
            FIO.WrBin(hout,b,1);
            FIO.WrBin(hout,g,1);
            FIO.WrBin(hout,r,1);
        END;
        FOR y :=(he-1) TO ymin BY -1 DO
	        FOR x := xmin TO (wi-1) DO
	            VESAgetpixel8(x,y,ink);
    	        FIO.WrBin(hout,ink,1);
            END;
        END;
    | 32:
        FOR y:=(he-1) TO ymin BY -1 DO
	        FOR x := xmin TO (wi-1) DO
    	        VESAgetpixel32(x,y, r,g,b);
			    FIO.WrBin(hout,b,1);
			    FIO.WrBin(hout,g,1);
                FIO.WrBin(hout,r,1);
            END;
        END;
    END;

    FIO.Flush(hout);
    FIO.Close(hout);

    soundDone;
END screenToFile;

PROCEDURE palToFile (VAR palnum:CARDINAL; bpp:CARDINAL);
VAR
    hout:FIO.File;
    F:str128;
    i : CARDINAL;
    thepal : ARRAY [minpalndx..maxpalndx] OF paltriplettype;
BEGIN
    IF bpp # 8 THEN soundIrrelevant; RETURN; END;
    IF buildname(basePAL,extPAL,  palnum,F)=FALSE THEN soundKant;RETURN;END;
    FOR i:=minpalndx TO maxpalndx DO
        getDAC(i,thepal[i].r,thepal[i].g,thepal[i].b);
    END;
    hout:=FIO.Create(F);
    FIO.WrBin(hout,thepal,SIZE(thepal));
    FIO.Close(hout);
    soundDone;
END palToFile;

(* ------------------------------------------------------------ *)

CONST
    lumenstep= 16;
    maxlumen = MAX(SHORTCARD); (* 255 *)
    nolumen  = MIN(SHORTCARD); (* 0 *)
    minlumen = -maxlumen;      (* -255 *)

PROCEDURE newlumen (VAR v:INTEGER; k:INTEGER);
BEGIN
    INC(v,k);
    IF v > maxlumen THEN
        v:=maxlumen;
    ELSIF v < minlumen THEN
        v:=minlumen;
    END;
END newlumen;

(*%T useINLINE  *)
(*# save                         *)
(*# call (inline_max => 49152)   *)
(*# call (inline=>on)            *)
(*%E  *)

PROCEDURE fixcomponent (VAR b:SHORTCARD; k:INTEGER);
VAR
    v:INTEGER ;
BEGIN
    v:=INTEGER(b);
    INC(v,k);
    IF v > maxlumen THEN
        v:=maxlumen;
    ELSIF v < nolumen THEN
        v:=nolumen;
    END;
    b:=SHORTCARD(v);
END fixcomponent;

(*%T useINLINE  *)
(*# restore                      *)
(*%E  *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    viewmodetype = (undefinedmode,
                   palmode,
                   rgb8888,bgr8888,
                   rgb8888alt,bgr8888alt,
                   rgb888,bgr888,
                   rgb565,bgr565,
                   rgb555,bgr555,
                   rgb4444,bgr4444,
                   rgb4444alt,bgr4444alt,
                   planarRGB,planarBGR);
    palordertype = (undefinedorder,rgbpal,bgrpal);
    triplettype = RECORD
        r,g,b:SHORTCARD;
    END;
    quadruplettype = RECORD
        r,g,b,alpha:SHORTCARD; (* RGBA *)
    END;
    duplettype = RECORD
        packed:CARDINAL;
    END;
    singletype = SHORTCARD;
    palquadruplettype = RECORD
        r,g,b, padding :SHORTCARD; (* see qd_vesa.def *)
    END;
CONST
    palsize     = (maxpalndx-minpalndx+1) * SIZE(paltriplettype);
    palquadsize = (maxpalndx-minpalndx+1) * SIZE(palquadruplettype);
    firstvmode32= ORD(rgb8888);
(*%T PLANAR *)
    lastvmode32 = ORD(planarBGR);
(*%E  *)
(*%F PLANAR *)
    lastvmode32 = ORD(bgr4444alt);
(*%E  *)

    zblack   = 0;  (* black *)
    zwhite   = 15; (* white *)

(* ------------------------------------------------------------ *)

(*
    expand 5 or 6 bits pixel to 8 bits with best rounding
    shift = 0 is automagically handled
    yes, we could use an array of constants
    and yes, we could try not to use floats either... -- see basic code infra
    and yes, we know about Bresenham method to solve such a problem
    ... but we no longer care ! :-(
    besides, we were already using floats somewhere else in code ;-)

    bfi gives 0..248/252
    ints is better but still gives a few discrepancies
    floats is best thanks to M2 autorounding

  0,   8,  16,  25,  33,  41,  49,  58,
 66,  74,  82,  90,  99, 107, 115, 123,
132, 140, 148, 156, 165, 173, 181, 189,
197, 206, 214, 222, 230, 239, 247, 255

  0,   4,   8,  12,  16,  20,  24,  28,
 32,  36,  40,  45,  49,  53,  57,  61,
 65,  69,  73,  77,  81,  85,  89,  93,
 97, 101, 105, 109, 113, 117, 121, 125,
130, 134, 138, 142, 146, 150, 154, 158,
162, 166, 170, 174, 178, 182, 186, 190,
194, 198, 202, 206, 210, 215, 219, 223,
227, 231, 235, 239, 243, 247, 251, 255

*)

CONST
    firstmask = 0;
    mask4     = 00FH; (* %00001111 =  15 *)
    mask5     = 01FH; (* %00011111 =  31 *)
    mask6     = 03FH; (* %00111111 =  63 *)
    mask8     = 0FFH; (* %11111111 = 255 *)
VAR
    gBestfit4to8 : ARRAY [firstmask..mask4] OF SHORTCARD;
    gBestfit5to8 : ARRAY [firstmask..mask5] OF SHORTCARD;
    gBestfit6to8 : ARRAY [firstmask..mask6] OF SHORTCARD;
    gBestfit8to6 : ARRAY [firstmask..mask8] OF SHORTCARD;

PROCEDURE initBestfitTables ();
CONST
    k4 = LONGREAL(mask8) / LONGREAL(mask4);
    k5 = LONGREAL(mask8) / LONGREAL(mask5);
    k6 = LONGREAL(mask8) / LONGREAL(mask6);
CONST
    nk8= LONGREAL(mask6) / LONGREAL(mask8);
VAR
    i,v : CARDINAL;
BEGIN
    FOR i:=firstmask TO mask4 DO
        v:=i << 4;
        v:=(i*mask8) DIV mask4;
        v:= CARDINAL( LONGREAL(i) * k4 + 0.5);
        gBestfit4to8[i]:=SHORTCARD(v);
        (* WrCard(i,12);WrCard(v,12);WrLn; *)
    END;
    FOR i:=firstmask TO mask5 DO
        v:=i << 3;
        v:=(i*mask8) DIV mask5;
        v:= CARDINAL( LONGREAL(i) * k5 + 0.5);
        gBestfit5to8[i]:=SHORTCARD(v);
        (* WrCard(i,12);WrCard(v,12);WrLn; *)
    END;
    FOR i:=firstmask TO mask6 DO
        v:=i << 2;              (* bfi : 0..252 *)
        v:=(i*mask8) DIV mask6;
        v:= CARDINAL( LONGREAL(i) * k6 + 0.5);
        gBestfit6to8[i]:=SHORTCARD(v);
        (* WrCard(i,12);WrCard(v,12);WrLn; *)
    END;
    (* used for palette fixing : complicated way to divide by 4 ! *)
    FOR i:=firstmask TO mask8 DO
        v:=i >> 2; (* seems better after all... *)
        (*
        v:=(i*mask6) DIV mask8;
        v:= CARDINAL( LONGREAL(i) * nk8 + 0.5);
        *)
        gBestfit8to6[i]:=SHORTCARD(v);
        (* WrCard(i,12);WrCard(v,12);WrLn; *)
    END;
END initBestfitTables;

(*%T useINLINE  *)
(*# save                         *)
(*# call (inline_max => 49152)   *)
(*# call (inline=>on)            *)
(*%E  *)

PROCEDURE b4to8 (v,shift:CARDINAL):SHORTCARD;
BEGIN
    v := (v >> shift) AND mask4;
    RETURN  gBestfit4to8[v] ;
END b4to8;

PROCEDURE b5to8 (v,shift:CARDINAL):SHORTCARD;
BEGIN
    v := (v >> shift) AND mask5;
    RETURN gBestfit5to8[v] ;
END b5to8;

PROCEDURE b6to8 (v,shift:CARDINAL):SHORTCARD;
BEGIN
    v := (v >> shift) AND mask6;
    RETURN gBestfit6to8[v] ;
END b6to8;

PROCEDURE b8to6 (v:SHORTCARD):SHORTCARD;
BEGIN
    RETURN gBestfit8to6[ CARDINAL(v) ];
END b8to6;

(*%T useINLINE  *)
(*# restore                      *)
(*%E  *)

VAR
    tmppal: ARRAY [1..2] OF triplettype;

PROCEDURE palOp (dopush:BOOLEAN;viewmode:viewmodetype;zblack,zwhite:CARDINAL);
VAR
    i,ndx:CARDINAL;
    n:SHORTCARD;
BEGIN
    IF viewmode # palmode THEN RETURN; END;
    (* waitVGAretrace; *)
    FOR i:=1 TO 2 DO
        CASE i OF
        | 1: ndx:=zblack; n:=0;
        | 2: ndx:=zwhite; n:=255;
        END;
        IF dopush THEN
           getDAC(ndx,tmppal[i].r,tmppal[i].g,tmppal[i].b);
           setDAC(ndx,n,n,n);
        ELSE
           setDAC(ndx,tmppal[i].r,tmppal[i].g,tmppal[i].b);
        END;
    END;
END palOp;

(* ------------------------------------------------------------ *)

PROCEDURE VESAcls (viewmode:viewmodetype;fastput:BOOLEAN; paper:SHORTCARD;
                  xmin,ymin,xcount,ycount:CARDINAL);
VAR
    x,y:CARDINAL;
BEGIN
    FOR y:=ymin TO ycount-1 DO

        IF fastput THEN initVESAhline(xcount,paper); END;

        FOR x:=xmin TO xcount-1 DO
            CASE viewmode OF
            | palmode:
                IF fastput THEN
                    VESAputpixel8hline(x,y, paper);
                ELSE
                    VESAputpixel8     (x,y, paper);
                END;
            ELSE
                IF fastput THEN
                    VESAputpixel32hline(x,y, 0,0,0);
                ELSE
                    VESAputpixel32     (x,y, 0,0,0);
                END;
            END;
        END;

        IF fastput THEN updateVESAhline(xcount,y); END;

    END;
END VESAcls;

CONST
    maxpixelwidth = 2048; (* was 1600, should do : anyway, I never use more than 1024 *)
    minpixelbyte  = 0;
    maxpixelbyte  = maxpixelwidth*SIZE(quadruplettype);
TYPE
    linebufferType = ARRAY[minpixelbyte..maxpixelbyte] OF BYTE; (* outside proc for usual reasons *)
VAR
    buf        : linebufferType;
(*%T PLANAR *)
    bufplanar1,bufplanar2 : linebufferType;
(*%E *)

(*
                   0   1                  0   1   2   3
little  $1234 -> $34 $12   $12345678 -> $78 $56 $34 $12
big     $1234 -> $12 $34   $12345678 -> $12 $34 $56 $78
*)

PROCEDURE flipbuf (VAR lb : linebufferType; wi,pixelsize:CARDINAL );
VAR
    i,j,xbuf:CARDINAL;
    b : BYTE;
BEGIN
    IF ODD ( pixelsize ) THEN RETURN; END; (* 1,3 = ignore *)
    xbuf:=minpixelbyte;
    FOR i:=1 TO wi DO
         CASE pixelsize OF
         | 2:
             b          := lb[xbuf];
             lb[xbuf]   := lb[xbuf+1];
             lb[xbuf+1] := b;
         | 4:
             b          := lb[xbuf];
             lb[xbuf]   := lb[xbuf+3];
             lb[xbuf+3] := b;
             b          := lb[xbuf+1];
             lb[xbuf+1] := lb[xbuf+2];
             lb[xbuf+2] := b;
         END;
         INC(xbuf,pixelsize);
    END;
END flipbuf;

PROCEDURE showpic (hin:FIO.File;viewmode:viewmodetype;fpos:LONGCARD;
                  wi,he,xmin,ymin,xcount,ycount,vesamode:CARDINAL;
                  fastput,negative,flipme,bigendian:BOOLEAN;
                  fixluminosity:INTEGER);
VAR
    w,h,x,y,got,xbuf,pixelsize,wanted,zeroed,yyy:CARDINAL;
    v:INTEGER;
    ink,r,g,b:SHORTCARD;
    rc : BOOLEAN;
    t  : triplettype;
    qu : quadruplettype;
    du : duplettype;
    o  : singletype;
    here,planpos,plansize:LONGCARD;
    special : (notplanar,globalplanar);
BEGIN

(*%T useINLINE  *)
(*# save                         *)
(*# call (inline_max => 49152)   *)
(*# call (inline=>on)            *)
(*%E  *)

    (*
       we don't clear screen by resetting VESA mode because it would :
       a) be slow ; b) lose palette

       we could fill background with palette fade
    *)

    CASE viewmode OF
    | palmode:                pixelsize:=SIZE(ink);
    | rgb8888,bgr8888:        pixelsize:=SIZE(qu);
    | rgb8888alt,bgr8888alt:  pixelsize:=SIZE(qu);
    | rgb888,bgr888:          pixelsize:=SIZE(t);
    | rgb565,bgr565:          pixelsize:=SIZE(du);
    | rgb555,bgr555:          pixelsize:=SIZE(du);
    | rgb4444,bgr4444:        pixelsize:=SIZE(du);
    | rgb4444alt,bgr4444alt:  pixelsize:=SIZE(du);
    | planarRGB,planarBGR:    pixelsize:=SIZE(o);
    END;
    wanted:=pixelsize * wi;

    CASE viewmode OF
    | planarRGB,planarBGR:
        (* wanted:=wanted * 1; (* trick : RGBrgbRGB = RrRGgGBbB *) *)
        special  := globalplanar;
        plansize := LONGCARD(wanted)*LONGCARD(he); (* pixelsize*wi*he *)
    ELSE
        special  := notplanar;
    END;

    zeroed := SIZE(linebufferType); (* probably overkill : wanted could do *)

    FIO.Seek(hin,fpos);

    y:=ymin;
    h:=1;
    LOOP

        IF fastput THEN initVESAhline(xcount,zblack); END;

        w:=1;

        x:=xmin;
        xbuf:=minpixelbyte;

(*%T PLANAR *)
        IF special = globalplanar THEN
            Lib.Fill( ADR(bufplanar1),zeroed,zblack); (* default to $00 *)
            Lib.Fill( ADR(bufplanar2),zeroed,zblack); (* default to $00 *)

            here:=FIO.GetPos(hin);

            planpos:=here+plansize;
            FIO.Seek(hin,planpos);
            got:=FIO.RdBin(hin,bufplanar1, wanted);

            INC(planpos,plansize);
            FIO.Seek(hin,planpos);
            got:=FIO.RdBin(hin,bufplanar2, wanted);

            FIO.Seek(hin,here);

            IF bigendian THEN
                flipbuf(bufplanar1,wi,pixelsize);
                flipbuf(bufplanar2,wi,pixelsize);
            END;
        END;
(*%E *)

        Lib.Fill( ADR(buf),zeroed,zblack); (* default to $00 *)
        got:=FIO.RdBin(hin,buf, wanted);
        IF bigendian THEN flipbuf(buf,wi,pixelsize);END;

        IF flipme THEN
            yyy:=ycount-1-y;
        ELSE
            yyy:=y;
        END;

        LOOP

            (* r:=0;g:=0;b:=0; *) (* default, useless now *)

            CASE viewmode OF
            | palmode:
                Lib.Move( ADR(buf[xbuf]), ADR(ink),pixelsize);
            | rgb8888:
                Lib.Move( ADR(buf[xbuf]), ADR(qu),pixelsize);
                r:=qu.r; g:=qu.g; b:=qu.b;
            | bgr8888:
                Lib.Move( ADR(buf[xbuf]), ADR(qu),pixelsize);
                r:=qu.b; g:=qu.g; b:=qu.r;
            | rgb8888alt:
                (*
                    r g b a is org struct
                    a r g b is alt struct
                *)
                Lib.Move( ADR(buf[xbuf]), ADR(qu),pixelsize);
                r:=qu.g; g:=qu.b; b:=qu.alpha; (* //LSL *)
            | bgr8888alt:
                Lib.Move( ADR(buf[xbuf]), ADR(qu),pixelsize);
                r:=qu.alpha; g:=qu.b; b:=qu.g; (* //LSL *)
            | rgb888:
                Lib.Move( ADR(buf[xbuf]), ADR(t),pixelsize);
                r:=t.r; g:=t.g; b:=t.b;
            | bgr888:
                Lib.Move( ADR(buf[xbuf]), ADR(t),pixelsize);
                r:=t.b; g:=t.g; b:=t.r;
            | rgb565:
                (*
                    5432109876543210
                    RRRRRGGGGGGBBBBB 5+6+5
                *)
                Lib.Move( ADR(buf[xbuf]), ADR(du),pixelsize);
                r:=b5to8( du.packed, 6+5);
                g:=b6to8( du.packed,   5);
                b:=b5to8( du.packed,   0);
            | bgr565:
                Lib.Move( ADR(buf[xbuf]), ADR(du),pixelsize);
                b:=b5to8( du.packed, 6+5);
                g:=b6to8( du.packed,   5);
                r:=b5to8( du.packed,   0);
            | rgb555:
                (*
                    5432109876543210
                    xRRRRRGGGGGBBBBB 1+5+5+5
                *)
                Lib.Move( ADR(buf[xbuf]), ADR(du),pixelsize);
                r:=b5to8( du.packed, 5+5);
                g:=b5to8( du.packed,   5);
                b:=b5to8( du.packed,   0);
            | bgr555:
                Lib.Move( ADR(buf[xbuf]), ADR(du),pixelsize);
                b:=b5to8( du.packed, 5+5);
                g:=b5to8( du.packed,   5);
                r:=b5to8( du.packed,   0);
            | rgb4444:
                (*
                    5432109876543210
                    xxxxRRRRGGGGBBBB 4+4+4+4
                *)
                Lib.Move( ADR(buf[xbuf]), ADR(du),pixelsize);
                r:=b4to8( du.packed, 4+4);
                g:=b4to8( du.packed,   4);
                b:=b4to8( du.packed,   0);
            | bgr4444:
                Lib.Move( ADR(buf[xbuf]), ADR(du),pixelsize);
                b:=b4to8( du.packed, 4+4);
                g:=b4to8( du.packed,   4);
                r:=b4to8( du.packed,   0);
            | rgb4444alt:
                (*
                    5432109876543210
                    RRRRGGGGBBBBxxxx 4+4+4+4     //LSL
                *)
                Lib.Move( ADR(buf[xbuf]), ADR(du),pixelsize);
                r:=b4to8( du.packed, 4+4+4);
                g:=b4to8( du.packed,   4+4);
                b:=b4to8( du.packed,   0+4);
            | bgr4444alt:
                Lib.Move( ADR(buf[xbuf]), ADR(du),pixelsize);
                b:=b4to8( du.packed, 4+4+4);
                g:=b4to8( du.packed,   4+4);
                r:=b4to8( du.packed,   0+4);
(*%T PLANAR *)
            | planarRGB:
                r:=buf[xbuf];
                g:=bufplanar1[xbuf];
                b:=bufplanar2[xbuf];
            | planarBGR:
                b:=buf[xbuf];
                g:=bufplanar1[xbuf];
                r:=bufplanar2[xbuf];
(*%E *)
            END;
            INC(xbuf,pixelsize);

            IF negative THEN
                CASE viewmode OF
                | palmode:
                    ink:=MAX(SHORTCARD)-ink;
                ELSE
                    r:=MAX(SHORTCARD)-r;
                    g:=MAX(SHORTCARD)-g;
                    b:=MAX(SHORTCARD)-b;
                END;
            END;

            IF fixluminosity # nolumen THEN
                CASE viewmode OF
                | palmode:
                    ;
                ELSE
                    fixcomponent(r,fixluminosity);
                    fixcomponent(g,fixluminosity);
                    fixcomponent(b,fixluminosity);
                END;
            END;

            CASE viewmode OF
            | palmode:
                IF fastput THEN
                    VESAputpixel8hline(x,yyy, ink);
                ELSE
                    VESAputpixel8     (x,yyy, ink);
                END;
            ELSE
                IF fastput THEN
                    VESAputpixel32hline(x,yyy, r,g,b);
                ELSE
                    VESAputpixel32     (x,yyy, r,g,b);
                END;
            END;
            INC(x);
            INC(w);
            IF w > wi THEN EXIT; END;
        END;

        LOOP
            IF w > xcount THEN EXIT; END;

            CASE viewmode OF
            | palmode :
                IF fastput THEN
                    VESAputpixel8hline(x,yyy, zblack);
                ELSE
                    VESAputpixel8     (x,yyy, zblack);
                END;
            ELSE
                IF fastput THEN
                    VESAputpixel32hline(x,yyy, 0,0,0);
                ELSE
                    VESAputpixel32     (x,yyy, 0,0,0);
                END;
            END;
            INC(x);
            INC(w);
        END;

        IF fastput THEN updateVESAhline(xcount,yyy); END; (* //V10R *)

        INC(y);
        INC(h);
        IF h > he THEN EXIT; END;
    END;

    LOOP
        IF h > ycount THEN EXIT; END;

        IF fastput THEN initVESAhline(xcount,zblack); END;

        IF flipme THEN
            yyy:=ycount-1-y;
        ELSE
            yyy:=y;
        END;

        x:=xmin;
        FOR w:=1 TO xcount DO


            CASE viewmode OF
            | palmode :
                IF fastput THEN
                    VESAputpixel8hline(x,yyy, zblack);
                ELSE
                    VESAputpixel8     (x,yyy, zblack);
                END;
            ELSE
                IF fastput THEN
                    VESAputpixel32hline(x,yyy, 0,0,0);
                ELSE
                    VESAputpixel32     (x,yyy, 0,0,0);
                END;
            END;
            INC(x);
        END;

        IF fastput THEN updateVESAhline(xcount,yyy); END; (* //V10R *)

        INC(y);
        INC(h);
    END;

    FIO.Seek(hin,fpos);

(*%T useINLINE  *)
(*# restore                      *)
(*%E  *)

END showpic;

(* ------------------------------------------------------------ *)

PROCEDURE showpal (viewmode:viewmodetype;
                  xmin,ymin,xcount,ycount,vesamode:CARDINAL;fastput:BOOLEAN);
CONST
    shiftdiv = 4; (* DIV 16 *)
VAR
    rc,shifted:BOOLEAN;
    ch1,ch2:CHAR;
    x,y,ink,h,v,xx,yy:CARDINAL;
    hbox,vbox:CARDINAL; (* were 32 and 12 then 16 and 8 *)
BEGIN
    IF viewmode # palmode THEN soundIrrelevant; RETURN; END;

    hbox:=xcount >> shiftdiv;
    vbox:=ycount >> shiftdiv;

    (*
       we don't clear screen by resetting VESA mode because this would...
       a) ...be too slow ; b) ...and cause palette lost
    *)
    VESAcls( viewmode,fastput,zblack,xmin,ymin,xcount,ycount);

    ink:=minpalndx;
    y:=ymin;
    FOR v:=1 TO 16 DO

        x:=xmin;
        FOR h:=1 TO 16 DO
            FOR yy:=1 TO vbox DO
                FOR xx:=1 TO hbox DO
                    VESAputpixel8(x+xx-1,y+yy-1,SHORTCARD(ink));
                END;
            END;
            INC(x,hbox);
            INC(ink);
        END;

        INC(y,vbox);
    END;
    (*
    x:=xmin;
    FOR ink := minpalndx TO maxpalndx DO
        FOR y := ycount DIV 2 TO ycount-1 DO
            VESAputpixel8(x,y,SHORTCARD(ink));
        END;
        INC(x);
    END;
    *)
    BiosWaitkeyShifted(ch1,ch2,shifted); (* globerk as too many things here... *)
END showpal;

PROCEDURE readpal (VAR fpos:LONGCARD;
                  hin:FIO.File; entrysize:CARDINAL;fixpal:BOOLEAN;
                  palorder:palordertype;viewmode:viewmodetype);
VAR
    got,i,wanted:CARDINAL;
    newpal     : ARRAY [minpalndx..maxpalndx] OF paltriplettype;
    newpalquad : ARRAY [minpalndx..maxpalndx] OF palquadruplettype;
    stdpal     : BOOLEAN;
    r,g,b:SHORTCARD;
BEGIN
    IF viewmode # palmode THEN soundIrrelevant; RETURN; END;

    CASE entrysize OF
    | palsize:
        stdpal:=TRUE;
        wanted:=SIZE(newpal);
        got:=FIO.RdBin(hin,newpal,wanted);
    | palquadsize:
        stdpal:=FALSE;
        wanted:=SIZE(newpalquad);
        got:=FIO.RdBin(hin,newpalquad,wanted);
    ELSE
        soundIrrelevant; RETURN;
    END;

    IF got = wanted THEN
        FOR i:=minpalndx TO maxpalndx DO
            IF stdpal THEN
                r:=newpal[i].r;
                g:=newpal[i].g;
                b:=newpal[i].b;
            ELSE
                r:=newpalquad[i].r;
                g:=newpalquad[i].g;
                b:=newpalquad[i].b;
            END;
            IF fixpal THEN (* [$00..$ff] to [$00..$3f] : a mere ">> 2 " would do ! *)
                r:=b8to6(r);
                g:=b8to6(g);
                b:=b8to6(b);
            END;
            CASE palorder OF
            | rgbpal: setDAC(i,r,g,b);
            | bgrpal: setDAC(i,b,g,r);
            END;
        END;
        fpos:=FIO.GetPos(hin);
    ELSE
        soundLimit;
    END;
END readpal;

PROCEDURE restoresystempalette (viewmode:viewmodetype);
BEGIN
    IF viewmode = palmode THEN
        restoresystempal();
    ELSE
        soundIrrelevant;
    END;
END restoresystempalette;

(* ------------------------------------------------------------ *)

PROCEDURE newfilepos (VAR fpos:LONGCARD;  fsize:LONGCARD;percentage:CARDINAL);
CONST
    k100 = LONGREAL(100.0);
VAR
    p : LONGREAL;
BEGIN
    p:=LONGREAL(fsize) * LONGREAL(percentage) / k100;
    fpos:= LONGCARD(p);
END newfilepos;

PROCEDURE newpos (VAR fpos:LONGCARD;
                 kmul,maxi:LONGCARD;pixelsize,wi:CARDINAL;motion:INTEGER;doMult:BOOLEAN);
VAR
    k:LONGCARD;
    limit:BOOLEAN;
BEGIN
    limit:=FALSE;
    k:= LONGCARD(wi*pixelsize);
    k:= k * LONGCARD (ABS(motion));
    IF doMult THEN k:=k*kmul;END;
    IF motion < 0 THEN
        IF fpos>=k THEN (* 0-based *)
            DEC(fpos,k);
        ELSE
            limit:=TRUE;
        END;
    ELSE
        IF (fpos+k)<maxi THEN
            INC(fpos,k);
        ELSE
            limit:=TRUE;
        END;
    END;
    IF limit THEN soundLimit; END;
END newpos;

PROCEDURE newval (VAR v:CARDINAL;
                 kmul,maxi:CARDINAL;motion:INTEGER;doMult:BOOLEAN);
VAR
    k:CARDINAL;
    limit:BOOLEAN;
BEGIN
    limit:=FALSE;
    k:=ABS(motion);
    IF doMult THEN k:=k*kmul;END;
    IF motion < 0 THEN
        IF v>k THEN (* 1-based *)
            DEC(v,k);
        ELSE
            limit:=TRUE;
        END;
    ELSE
        IF (v+k)<=maxi THEN
            INC(v,k);
        ELSE
            limit:=TRUE;
        END;
    END;
    IF limit THEN soundLimit; END;
END newval;

PROCEDURE getPixelsize (viewmode:viewmodetype  ):CARDINAL ;
VAR
    w:CARDINAL;
BEGIN
    CASE viewmode OF
    | palmode:                w:=1;
    | rgb8888,bgr8888:        w:=4;
    | rgb8888alt,bgr8888alt:  w:=4;
    | rgb888,bgr888:          w:=3;
    | rgb565,bgr565:          w:=2;
    | rgb555,bgr555:          w:=2;
    | rgb4444,bgr4444:        w:=2;
    | rgb4444alt,bgr4444alt:  w:=2;
    | planarRGB,planarBGR:    w:=1;
    END;
    RETURN w;
END getPixelsize;

PROCEDURE newmode (VAR viewmode:viewmodetype;
                  shifted:BOOLEAN   );
BEGIN
    IF shifted THEN
        CASE viewmode OF
        | palmode : ;
        | viewmodetype(firstvmode32): viewmode:=viewmodetype(lastvmode32);
        ELSE
            DEC(viewmode);
        END;
    ELSE
        CASE viewmode OF
        | palmode : ;
        | viewmodetype(lastvmode32) : viewmode:=viewmodetype(firstvmode32);
        ELSE
            INC(viewmode);
        END;
    END;
END newmode;

PROCEDURE setnewmode (VAR viewmode:viewmodetype; wantedmode:viewmodetype );
BEGIN
    CASE viewmode OF
    | palmode : soundIrrelevant;
    ELSE
        viewmode:=wantedmode;
    END;
END setnewmode;

(* only two legal values for now : rgb, bgr -- shifted is overkill here ! *)

PROCEDURE neworder (VAR palorder:palordertype;shifted:BOOLEAN);
BEGIN
    IF shifted THEN
        CASE palorder OF
        | rgbpal : INC(palorder);
        | bgrpal : DEC(palorder);
        END;
    ELSE
        CASE palorder OF
        | rgbpal : INC(palorder);
        | bgrpal : DEC(palorder);
        END;
    END;
END neworder;

PROCEDURE setneworder (VAR palorder:palordertype;
                      viewmode:viewmodetype;wantedorder:palordertype );
BEGIN
    CASE viewmode OF
    | palmode: palorder:=wantedorder;
    ELSE
        soundIrrelevant;
    END;
END setneworder;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* globerk but who cares ? the Code Police ? ah ! *)

VAR
    savpal : ARRAY [minpalndx..maxpalndx] OF paltriplettype;

PROCEDURE textON (wantedlines:CARDINAL);
VAR
    i : CARDINAL;
BEGIN
    FOR i:=minpalndx TO maxpalndx DO
        getDAC(i,savpal[i].r,savpal[i].g,savpal[i].b);
    END;
    CASE wantedlines OF
    | 25 : set80x25();
    | 50 : set80x50();
    END;
END textON;

PROCEDURE textOFF (vesamode:CARDINAL);
VAR
    i : CARDINAL;
    rc:BOOLEAN;
BEGIN
    rc:=SetVesaMode(vesamode);

    FOR i:=minpalndx TO maxpalndx DO
        setDAC(i,savpal[i].r,savpal[i].g,savpal[i].b);
    END;
END textOFF;

PROCEDURE textCLS (wantedlines:CARDINAL;vsync:BOOLEAN);
CONST
    clsattr = 00H; (* black ink, black paper *)
VAR
    i:CARDINAL;
BEGIN
    (*

    boy, this is ugly :
    why not dump successive nl while we're in BFI bozo mode ? ;-)
    well, yes, we'll clear screen this C-lib way :
    changing mode again was too slow

    CASE wantedlines OF
    | 25 : set80x25();
    | 50 : set80x50();
    END;

    FOR i:=1 TO wantedlines DO WrLn;END;

    *)

    IF vsync THEN waitVGAretrace; END;

    textclearscreen( clsattr );

END textCLS;

PROCEDURE shelldos (vesamode,wantedlines:CARDINAL);
CONST
    warn = nl+nl+
"****************************************************"+nl+
"*                                                  *"+nl+
"* This is a PICFIND shell : remember to type EXIT  *"+nl+
"* when you're done to go back to calling program ! *"+nl+
"*                                                  *"+nl+
"****************************************************"+nl;
VAR
    R,oldpmt,newpmt:str128;
    i : CARDINAL;
BEGIN
    textON(wantedlines);

    (*
    Lib.EnvironmentFind("PROMPT",oldpmt);

    Str.Concat(newpmt,"PROMPT ","Remember to type EXIT to return to "+ProgEXEname+" !$_$p$g");
    i:=Lib.ExecCmd(newpmt);
    *)

    WrStr(warn);

    Lib.EnvironmentFind("COMSPEC",R);
    i:=Lib.Exec(R,"",NIL);

    (*
    Str.Concat(newpmt,"PROMPT ",oldpmt);
    i:=Lib.ExecCmd(newpmt);
    *)

    textOFF(vesamode);
END shelldos;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str16;
BEGIN
    RETURN fmtnum( LONGCARD(n), 10, digits,pad );
END using;

(*
Year stored relative to 1980 (ex. 1988 stores as 8)
    year      month    day   

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

PROCEDURE fmtDate (datedata:CARDINAL) : str128;
CONST
    yyMask=BITSET{9..15};
    yyShft=9;
    mmMask=BITSET{5..8};
    mmShft=5;
    ddMask=BITSET{0..4};
    ddShft=0;
CONST
    separator = dash;
    paddays=blank;
    pad="0";
    baseyear = 1980;
    tmonths ="Jan Fv Mar Avr Mai Jun Jui Ao Sep Oct Nov Dc ???";
    tmonths2="Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ???";
VAR
    y,m,d : CARDINAL;
    R : str128;
BEGIN
    y := CARDINAL(BITSET(datedata) * yyMask) >> yyShft;
    m := CARDINAL(BITSET(datedata) * mmMask) >> mmShft;
    d := CARDINAL(BITSET(datedata) * ddMask) >> ddShft;

    IF ((m < 1) OR (m > 12)) THEN m := 13; END;
    Str.ItemS(R,tmonths2," ",m-1);
    Str.Prepend(R,separator);
    Str.Prepend(R,using(d,2,paddays));
    Str.Append(R,separator);
    Str.Append(R,using(baseyear+y,4,pad));
    RETURN R;
END fmtDate;

(*
Seconds are 0 to 29 -- DOS stores nearest even / 2
  hours    minutes   seconds 

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

PROCEDURE fmtTime (timedata:CARDINAL) : str128;
CONST
    hhMask=BITSET{11..15};
    hhShft=11;
    mmMask=BITSET{5..10};
    mmShft=5;
    ssMask=BITSET{0..4};
    ssShft=0;
CONST
    separator = colon;
    padhours = blank;
    pad="0";
VAR
    h,m,s : CARDINAL;
    R : str128;
BEGIN
    h := CARDINAL(BITSET(timedata) * hhMask) >> hhShft;
    m := CARDINAL(BITSET(timedata) * mmMask) >> mmShft;
    s := CARDINAL(BITSET(timedata) * ssMask) >> ssShft;
    s := s << 1; (* yes, yes, "* 2" works too... *)
    Str.Copy(R,using(h,2,padhours) );
    Str.Append(R,separator);
    Str.Append(R,using(m,2,pad));
    Str.Append(R,separator);
    Str.Append(R,using(s,2,pad));
    RETURN R;
END fmtTime;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* taken from NEWFONT *)

CONST
    wichar = 8; (* native mode X and or our 8x8 font *)
    hechar = 8;
    hebeautifier = hechar DIV 4;
    wilimit = 80 * wichar;                  (* 80 chars *)
    helimit = 25 * (hechar+hebeautifier);   (* 25 lines *)
CONST
    fontsize50       = 2048;
    firstdatasmall   = 0;
    lastdatasmall    = fontsize50-1;
    middatasmall     = fontsize50 DIV 2; (* modeX splits fonts in 2 128 chars *)
TYPE
    smallFontDef = ARRAY [firstdatasmall..lastdatasmall] OF BYTE;

CONST
    (* apple8.fon *)
    smallFontAPPLE = smallFontDef(
    000H,000H,000H,000H,000H,000H,000H,000H,
    0F7H,0EFH,093H,001H,003H,003H,001H,093H,
    0F7H,0EFH,093H,07DH,07BH,07BH,02DH,093H,
    06CH,0FEH,0FEH,0FEH,07CH,038H,010H,000H,
    010H,038H,07CH,0FEH,07CH,038H,010H,000H,
    038H,07CH,038H,0FEH,0FEH,07CH,038H,07CH,
    010H,010H,038H,07CH,0FEH,07CH,038H,07CH,
    000H,000H,018H,03CH,03CH,018H,000H,000H,
    0FFH,0FFH,0E7H,0C3H,0C3H,0E7H,0FFH,0FFH,
    000H,03CH,066H,042H,042H,066H,03CH,000H,
    0FFH,0C3H,099H,0BDH,0BDH,099H,0C3H,0FFH,
    00FH,007H,00FH,07DH,0CCH,0CCH,0CCH,078H,
    03CH,066H,066H,066H,03CH,018H,07EH,018H,
    03FH,033H,03FH,030H,030H,070H,0F0H,0E0H,
    07FH,063H,07FH,063H,063H,067H,0E6H,0C0H,
    099H,05AH,03CH,0E7H,0E7H,03CH,05AH,099H,
    080H,0E0H,0F8H,0FEH,0F8H,0E0H,080H,000H,
    002H,00EH,03EH,0FEH,03EH,00EH,002H,000H,
    018H,03CH,07EH,018H,018H,07EH,03CH,018H,
    066H,066H,066H,066H,066H,000H,066H,000H,
    07FH,0DBH,0DBH,07BH,01BH,01BH,01BH,000H,
    03EH,063H,038H,06CH,06CH,038H,0CCH,078H,
    000H,000H,000H,000H,07EH,07EH,07EH,000H,
    018H,03CH,07EH,018H,07EH,03CH,018H,0FFH,
    018H,03CH,07EH,018H,018H,018H,018H,000H,
    018H,018H,018H,018H,07EH,03CH,018H,000H,
    000H,018H,00CH,0FEH,00CH,018H,000H,000H,
    000H,030H,060H,0FEH,060H,030H,000H,000H,
    000H,000H,0C0H,0C0H,0C0H,0FEH,000H,000H,
    000H,024H,066H,0FFH,066H,024H,000H,000H,
    000H,018H,03CH,07EH,0FFH,0FFH,000H,000H,
    000H,0FFH,0FFH,07EH,03CH,018H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    010H,010H,010H,010H,010H,000H,010H,000H,
    028H,028H,028H,000H,000H,000H,000H,000H,
    028H,028H,07CH,028H,07CH,028H,028H,000H,
    010H,03CH,050H,038H,014H,078H,010H,000H,
    060H,064H,008H,010H,020H,04CH,00CH,000H,
    020H,050H,050H,020H,054H,048H,034H,000H,
    010H,010H,010H,000H,000H,000H,000H,000H,
    010H,020H,040H,040H,040H,020H,010H,000H,
    010H,008H,004H,004H,004H,008H,010H,000H,
    010H,054H,038H,010H,038H,054H,010H,000H,
    000H,010H,010H,07CH,010H,010H,000H,000H,
    000H,000H,000H,000H,010H,010H,020H,000H,
    000H,000H,000H,07CH,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,010H,000H,
    000H,004H,008H,010H,020H,040H,000H,000H,
    038H,044H,04CH,054H,064H,044H,038H,000H,
    010H,030H,010H,010H,010H,010H,038H,000H,
    038H,044H,004H,018H,020H,040H,07CH,000H,
    07CH,004H,008H,018H,004H,044H,038H,000H,
    008H,018H,028H,048H,07CH,008H,008H,000H,
    07CH,040H,078H,004H,004H,044H,038H,000H,
    01CH,020H,040H,078H,044H,044H,038H,000H,
    07CH,004H,008H,010H,020H,020H,020H,000H,
    038H,044H,044H,038H,044H,044H,038H,000H,
    038H,044H,044H,03CH,004H,008H,070H,000H,
    000H,000H,010H,000H,010H,000H,000H,000H,
    000H,000H,010H,000H,010H,010H,020H,000H,
    008H,010H,020H,040H,020H,010H,008H,000H,
    000H,000H,07CH,000H,07CH,000H,000H,000H,
    020H,010H,008H,004H,008H,010H,020H,000H,
    038H,044H,008H,010H,010H,000H,010H,000H,
    038H,044H,054H,05CH,058H,040H,03CH,000H,
    010H,028H,044H,044H,07CH,044H,044H,000H,
    078H,044H,044H,078H,044H,044H,078H,000H,
    038H,044H,040H,040H,040H,044H,038H,000H,
    078H,044H,044H,044H,044H,044H,078H,000H,
    07CH,040H,040H,078H,040H,040H,07CH,000H,
    07CH,040H,040H,078H,040H,040H,040H,000H,
    03CH,040H,040H,040H,04CH,044H,03CH,000H,
    044H,044H,044H,07CH,044H,044H,044H,000H,
    038H,010H,010H,010H,010H,010H,038H,000H,
    004H,004H,004H,004H,004H,044H,038H,000H,
    044H,048H,050H,060H,050H,048H,044H,000H,
    040H,040H,040H,040H,040H,040H,07CH,000H,
    044H,06CH,054H,054H,044H,044H,044H,000H,
    044H,044H,064H,054H,04CH,044H,044H,000H,
    038H,044H,044H,044H,044H,044H,038H,000H,
    078H,044H,044H,078H,040H,040H,040H,000H,
    038H,044H,044H,044H,054H,048H,034H,000H,
    078H,044H,044H,078H,050H,048H,044H,000H,
    038H,044H,040H,038H,004H,044H,038H,000H,
    07CH,010H,010H,010H,010H,010H,010H,000H,
    044H,044H,044H,044H,044H,044H,038H,000H,
    044H,044H,044H,044H,044H,028H,010H,000H,
    044H,044H,044H,054H,054H,06CH,044H,000H,
    044H,044H,028H,010H,028H,044H,044H,000H,
    044H,044H,028H,010H,010H,010H,010H,000H,
    07CH,004H,008H,010H,020H,040H,07CH,000H,
    07CH,060H,060H,060H,060H,060H,07CH,000H,
    000H,040H,020H,010H,008H,004H,000H,000H,
    07CH,00CH,00CH,00CH,00CH,00CH,07CH,000H,
    000H,000H,010H,028H,044H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,07CH,
    020H,010H,008H,000H,000H,000H,000H,000H,
    000H,000H,038H,004H,03CH,044H,03CH,000H,
    040H,040H,078H,044H,044H,044H,078H,000H,
    000H,000H,03CH,040H,040H,040H,03CH,000H,
    004H,004H,03CH,044H,044H,044H,03CH,000H,
    000H,000H,038H,044H,07CH,040H,03CH,000H,
    018H,024H,020H,078H,020H,020H,020H,000H,
    000H,000H,038H,044H,044H,03CH,004H,038H,
    040H,040H,078H,044H,044H,044H,044H,000H,
    010H,000H,030H,010H,010H,010H,038H,000H,
    008H,000H,018H,008H,008H,008H,048H,030H,
    040H,040H,044H,048H,070H,048H,044H,000H,
    030H,010H,010H,010H,010H,010H,038H,000H,
    000H,000H,06CH,054H,054H,054H,044H,000H,
    000H,000H,078H,044H,044H,044H,044H,000H,
    000H,000H,038H,044H,044H,044H,038H,000H,
    000H,000H,078H,044H,044H,078H,040H,040H,
    000H,000H,03CH,044H,044H,03CH,004H,004H,
    000H,000H,05CH,060H,040H,040H,040H,000H,
    000H,000H,03CH,040H,038H,004H,078H,000H,
    020H,020H,078H,020H,020H,024H,018H,000H,
    000H,000H,044H,044H,044H,04CH,034H,000H,
    000H,000H,044H,044H,044H,028H,010H,000H,
    000H,000H,044H,044H,054H,054H,06CH,000H,
    000H,000H,044H,028H,010H,028H,044H,000H,
    000H,000H,044H,044H,044H,03CH,004H,038H,
    000H,000H,07CH,008H,010H,020H,07CH,000H,
    01CH,030H,030H,060H,030H,030H,01CH,000H,
    010H,010H,010H,010H,010H,010H,010H,010H,
    070H,018H,018H,00CH,018H,018H,070H,000H,
    034H,058H,000H,000H,000H,000H,000H,000H,
    000H,054H,028H,054H,028H,054H,000H,000H,
    038H,044H,040H,040H,040H,044H,038H,010H,
    044H,000H,044H,044H,044H,04CH,034H,000H,
    00CH,000H,038H,044H,07CH,040H,03CH,000H,
    07CH,000H,038H,004H,03CH,044H,03CH,000H,
    044H,000H,038H,004H,03CH,044H,03CH,000H,
    060H,000H,038H,004H,03CH,044H,03CH,000H,
    010H,000H,038H,004H,03CH,044H,03CH,000H,
    000H,000H,03CH,040H,040H,040H,03CH,008H,
    07CH,000H,038H,044H,07CH,040H,03CH,000H,
    044H,000H,038H,044H,07CH,040H,03CH,000H,
    060H,000H,038H,044H,07CH,040H,03CH,000H,
    044H,000H,030H,010H,010H,010H,038H,000H,
    07CH,000H,030H,010H,010H,010H,038H,000H,
    060H,000H,030H,010H,010H,010H,038H,000H,
    044H,000H,010H,028H,044H,07CH,044H,000H,
    010H,000H,010H,028H,044H,07CH,044H,000H,
    008H,010H,07CH,040H,078H,040H,07CH,000H,
    000H,000H,06CH,012H,07EH,090H,07EH,000H,
    02EH,058H,088H,08EH,0F8H,088H,08EH,000H,
    07CH,000H,038H,044H,044H,044H,038H,000H,
    044H,000H,038H,044H,044H,044H,038H,000H,
    060H,000H,038H,044H,044H,044H,038H,000H,
    07CH,000H,044H,044H,044H,04CH,034H,000H,
    060H,000H,044H,044H,044H,04CH,034H,000H,
    044H,000H,044H,044H,044H,03CH,004H,038H,
    044H,038H,044H,044H,044H,044H,038H,000H,
    044H,000H,044H,044H,044H,044H,038H,000H,
    018H,018H,07EH,0C0H,0C0H,07EH,018H,018H,
    038H,06CH,064H,0F0H,060H,0E6H,0FCH,000H,
    0CCH,0CCH,078H,0FCH,030H,0FCH,030H,030H,
    0F8H,0CCH,0CCH,0FAH,0C6H,0CFH,0C6H,0C7H,
    00EH,01BH,018H,03CH,018H,018H,0D8H,070H,
    00CH,000H,038H,004H,03CH,044H,03CH,000H,
    00CH,000H,030H,010H,010H,010H,038H,000H,
    00CH,000H,038H,044H,044H,044H,038H,000H,
    00CH,000H,044H,044H,044H,04CH,034H,000H,
    07CH,000H,078H,044H,044H,044H,044H,000H,
    07CH,000H,044H,064H,054H,04CH,044H,000H,
    03CH,06CH,06CH,03EH,000H,07EH,000H,000H,
    038H,06CH,06CH,038H,000H,07CH,000H,000H,
    030H,000H,030H,060H,0C0H,0CCH,078H,000H,
    000H,000H,000H,0FCH,0C0H,0C0H,000H,000H,
    000H,000H,000H,0FCH,00CH,00CH,000H,000H,
    0C3H,0C6H,0CCH,0DEH,033H,066H,0CCH,00FH,
    0C3H,0C6H,0CCH,0DBH,037H,06FH,0CFH,003H,
    010H,010H,000H,010H,010H,010H,010H,000H,
    000H,022H,044H,088H,044H,022H,000H,000H,
    000H,088H,044H,022H,044H,088H,000H,000H,
    022H,088H,022H,088H,022H,088H,022H,088H,
    055H,0AAH,055H,0AAH,055H,0AAH,055H,0AAH,
    0DBH,077H,0DBH,0EEH,0DBH,077H,0DBH,0EEH,
    018H,018H,018H,018H,018H,018H,018H,018H,
    018H,018H,018H,018H,0F8H,018H,018H,018H,
    018H,018H,0F8H,018H,0F8H,018H,018H,018H,
    036H,036H,036H,036H,0F6H,036H,036H,036H,
    000H,000H,000H,000H,0FEH,036H,036H,036H,
    000H,000H,0F8H,018H,0F8H,018H,018H,018H,
    036H,036H,0F6H,006H,0F6H,036H,036H,036H,
    036H,036H,036H,036H,036H,036H,036H,036H,
    000H,000H,0FEH,006H,0F6H,036H,036H,036H,
    036H,036H,0F6H,006H,0FEH,000H,000H,000H,
    036H,036H,036H,036H,0FEH,000H,000H,000H,
    018H,018H,0F8H,018H,0F8H,000H,000H,000H,
    000H,000H,000H,000H,0F8H,018H,018H,018H,
    018H,018H,018H,018H,01FH,000H,000H,000H,
    018H,018H,018H,018H,0FFH,000H,000H,000H,
    000H,000H,000H,000H,0FFH,018H,018H,018H,
    018H,018H,018H,018H,01FH,018H,018H,018H,
    000H,000H,000H,000H,0FFH,000H,000H,000H,
    018H,018H,018H,018H,0FFH,018H,018H,018H,
    018H,018H,01FH,018H,01FH,018H,018H,018H,
    036H,036H,036H,036H,037H,036H,036H,036H,
    036H,036H,037H,030H,03FH,000H,000H,000H,
    000H,000H,03FH,030H,037H,036H,036H,036H,
    036H,036H,0F7H,000H,0FFH,000H,000H,000H,
    000H,000H,0FFH,000H,0F7H,036H,036H,036H,
    036H,036H,037H,030H,037H,036H,036H,036H,
    000H,000H,0FFH,000H,0FFH,000H,000H,000H,
    036H,036H,0F7H,000H,0F7H,036H,036H,036H,
    018H,018H,0FFH,000H,0FFH,000H,000H,000H,
    036H,036H,036H,036H,0FFH,000H,000H,000H,
    000H,000H,0FFH,000H,0FFH,018H,018H,018H,
    000H,000H,000H,000H,0FFH,036H,036H,036H,
    036H,036H,036H,036H,03FH,000H,000H,000H,
    018H,018H,01FH,018H,01FH,000H,000H,000H,
    000H,000H,01FH,018H,01FH,018H,018H,018H,
    000H,000H,000H,000H,03FH,036H,036H,036H,
    036H,036H,036H,036H,0FFH,036H,036H,036H,
    018H,018H,0FFH,018H,0FFH,018H,018H,018H,
    018H,018H,018H,018H,0F8H,000H,000H,000H,
    000H,000H,000H,000H,01FH,018H,018H,018H,
    0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,
    000H,000H,000H,000H,0FFH,0FFH,0FFH,0FFH,
    0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,
    00FH,00FH,00FH,00FH,00FH,00FH,00FH,00FH,
    0FFH,0FFH,0FFH,0FFH,000H,000H,000H,000H,
    000H,000H,076H,0DCH,0C8H,0DCH,076H,000H,
    000H,078H,0CCH,0F8H,0CCH,0F8H,0C0H,0C0H,
    000H,0FCH,0CCH,0C0H,0C0H,0C0H,0C0H,000H,
    000H,0FEH,06CH,06CH,06CH,06CH,06CH,000H,
    0FCH,0CCH,060H,030H,060H,0CCH,0FCH,000H,
    000H,000H,07EH,0D8H,0D8H,0D8H,070H,000H,
    000H,066H,066H,066H,066H,07CH,060H,0C0H,
    000H,076H,0DCH,018H,018H,018H,018H,000H,
    0FCH,030H,078H,0CCH,0CCH,078H,030H,0FCH,
    038H,06CH,0C6H,0FEH,0C6H,06CH,038H,000H,
    038H,06CH,0C6H,0C6H,06CH,06CH,0EEH,000H,
    01CH,030H,018H,07CH,0CCH,0CCH,078H,000H,
    000H,000H,07EH,0DBH,0DBH,07EH,000H,000H,
    006H,00CH,07EH,0DBH,0DBH,07EH,060H,0C0H,
    038H,060H,0C0H,0F8H,0C0H,060H,038H,000H,
    078H,0CCH,0CCH,0CCH,0CCH,0CCH,0CCH,000H,
    000H,0FCH,000H,0FCH,000H,0FCH,000H,000H,
    030H,030H,0FCH,030H,030H,000H,0FCH,000H,
    060H,030H,018H,030H,060H,000H,0FCH,000H,
    018H,030H,060H,030H,018H,000H,0FCH,000H,
    00EH,01BH,01BH,018H,018H,018H,018H,018H,
    018H,018H,018H,018H,018H,0D8H,0D8H,070H,
    030H,030H,000H,0FCH,000H,030H,030H,000H,
    000H,076H,0DCH,000H,076H,0DCH,000H,000H,
    038H,06CH,06CH,038H,000H,000H,000H,000H,
    000H,000H,000H,018H,018H,000H,000H,000H,
    000H,000H,000H,000H,018H,000H,000H,000H,
    00FH,00CH,00CH,00CH,0ECH,06CH,03CH,01CH,
    078H,06CH,06CH,06CH,06CH,000H,000H,000H,
    070H,018H,030H,060H,078H,000H,000H,000H,
    000H,000H,03CH,03CH,03CH,03CH,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H
    );

PROCEDURE doPrintAt (viewmode:viewmodetype;x,y,ink,paper:CARDINAL;S:ARRAY OF CHAR);
TYPE
    bitmasktype = ARRAY[1..8] OF CARDINAL;
CONST
    charsize = (wichar DIV 8 ) * wichar;
    bitmask = bitmasktype( 80H,40H,20H,10H, 08H,04H,02H,01H);
VAR
    i,p,wi,he,xx,yy,mask,xorg:CARDINAL;
    vink,vpaper:BYTE;
BEGIN
    xorg:=x;
    vink := BYTE(ink);
    vpaper:=BYTE(paper);
    FOR i:=1 TO Str.Length(S) DO
        CASE S[i-1] OF
        | cr:  INC(y,hechar+hebeautifier);
        | lf:  x:=xorg;
        ELSE
            p  :=ORD( S[i-1] ) * charsize;
            yy :=y;
            FOR he := 1 TO wichar DO
                xx := x;
                mask:=CARDINAL ( smallFontAPPLE[p] );
                FOR wi:=1 TO 8 DO
                    IF ( mask AND bitmask[wi] ) # 0 THEN
                        CASE viewmode OF
                        | palmode : VESAputpixel8(xx,yy,vink);
                        ELSE
                                    VESAputpixel32     (xx,yy, 255,255,255);
                        END;
                    ELSE
                        CASE viewmode OF
                        | palmode : VESAputpixel8(xx,yy,vpaper);
                        ELSE
                                    VESAputpixel32     (xx,yy, 0,0,0);
                        END;
                    END;
                    INC(xx);
                END;
                INC(p);
                INC(yy);
            END;
            INC(x,wichar);
        END;
    END;
END doPrintAt;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* 9x quirk : file just created is sometimes not found ! *)

PROCEDURE logParms (fpos:LONGCARD;vesamode,wi,he:CARDINAL;negative,flipme,fixpal:BOOLEAN;
                   viewmode:viewmodetype;palorder:palordertype;F:ARRAY OF CHAR);
CONST
    winum = 10; (* MAX(LONGCARD) width in decimal *)
    maxretries = 3;
VAR
    hout:FIO.File;
    S,R:str128;
    entry:FIO.DirEntry;
    attr :FIO.FileAttr;
    found:BOOLEAN;
    retries:CARDINAL;
BEGIN
    retries:=1; (* 9X quirkfix *)
    LOOP
        found := FIO.ReadFirstEntry(F,attr,entry);
        IF found THEN EXIT;END;
        INC(retries);
        IF retries>maxretries THEN EXIT; END;
    END;

    Str.Concat(S,ProgEXEname,extLOG);
    IF FIO.Exists(S) THEN
        hout:=FIO.Append(S);
    ELSE
        hout:=FIO.Create(S);
    END;

    Str.Concat(S,"# ",F);
    IF found THEN (* safety against 9X quirk *)
        Str.Append(S,"    ");Str.Append(S,fmtnum( entry.size,10,winum," "));
        Str.Append(S,"    ");Str.Append(S,fmtDate(entry.date));
        Str.Append(S,"  ");  Str.Append(S,fmtTime(entry.time));
    ELSE
        Str.Append(S," (NOT FOUND !)");
    END;

    FIO.WrLn(hout);
    FIO.WrStr(hout,S); FIO.WrLn(hout);

    Str.Copy(S,"; ");
    Str.Append(S," $");   Str.Append(S, fmtnum(LONGCARD(vesamode),16,4,"0"));

    CASE viewmode OF
    | palmode:
        CASE palorder OF
        | rgbpal : R:="-a:1";
        | bgrpal : R:="-a:2";
        END;
    | rgb8888:     R:="-m:1";
    | bgr8888:     R:="-m:2";
    | rgb8888alt:  R:="-m:3";
    | bgr8888alt:  R:="-m:4";
    | rgb888:      R:="-m:5";
    | bgr888:      R:="-m:6";
    | rgb565:      R:="-m:7";
    | bgr565:      R:="-m:8";
    | rgb555:      R:="-m:9";
    | bgr555:      R:="-m:10";
    | rgb4444:     R:="-m:11";
    | bgr4444:     R:="-m:12";
    | rgb4444alt:  R:="-m:13";
    | bgr4444alt:  R:="-m:14";
    | planarRGB:   R:="-m:15";
    | planarBGR:   R:="-m:16";
    END;
    Str.Append(S," ");Str.Append(S,R);

    Str.Append(S," -p:$");Str.Append(S, fmtnum(fpos,16,8,"0"));
    Str.Append(S," -w:"); Str.Append(S, fmtnum(LONGCARD(wi),10,1," "));
    Str.Append(S," -h:"); Str.Append(S, fmtnum(LONGCARD(he),10,1," "));
    IF negative THEN Str.Append(S," -r");END;
    IF flipme   THEN Str.Append(S," -f");END;
    IF fixpal   THEN Str.Append(S," -x");END;
    FIO.WrStr(hout,S); FIO.WrLn(hout);

    FIO.Flush(hout);
    FIO.Close(hout);
END logParms;

PROCEDURE fposToPercent(fsize,fpos:LONGCARD):LONGCARD;
VAR
    percentage:LONGREAL; (* huge card here ! *)
    percent:LONGCARD;
BEGIN
    IF fsize <= 1 THEN (* avoid divide by 0 -- 0-length file is already filtered but... *)
        percent    := 0; (* ugly ! *)
    ELSE
        percentage := LONGREAL(fpos+1)*LONGREAL(100.0);
        percentage := percentage / LONGREAL(fsize);
        percent    := VAL(LONGCARD,percentage); (* (fpos*100) DIV (fsize-1) *)
    END;
    RETURN percent;
END fposToPercent;

PROCEDURE statbool (VAR Z:ARRAY OF CHAR;tf:BOOLEAN;ST,SF,S:ARRAY OF CHAR);
VAR
    R:str80;
BEGIN
    IF tf THEN
        Str.Copy(R,ST);
    ELSE
        Str.Copy(R,SF);
    END;
    Str.Append(R,S);
    Str.Append(Z,R);
END statbool;

(* assume R is a really huge string *)

PROCEDURE fmtParms (VAR R : ARRAY OF CHAR;
                   viewmode:viewmodetype;fsize,fpos:LONGCARD;
                   wi,he,kmul,wantedlines:CARDINAL;palorder:palordertype;
                   negative,flipme,fixpal,halfwindow,textMode,vsync,bigendian:BOOLEAN;
                   fixluminosity:INTEGER);
CONST
    placeholder = "~";
CONST
(*
window status should always be less than 80 chars
                 $ffff0000 / $ffff0000 = 4333222111 / 4333222111 = 100%
*)
    msgStatus   =
"File position : $~ / $~ = ~ / ~ = ~%"+nl+
"View mode     : ~"+nl+
"Window        : ~ x ~ (motion count = ~, paging by ~ window)"+nl+
"Status        : ~"+nl;
VAR
    S:str80;
    percent:LONGCARD;
BEGIN
    percent:=fposToPercent(fsize,fpos);
    Str.Copy(R,msgStatus);
    Str.Subst(R,placeholder, fmtnum(fpos,16,8,"0"));
    Str.Subst(R,placeholder, fmtnum(fsize-1,16,8,"0"));
    Str.Subst(R,placeholder, fmtnum(fpos,10,1," "));
    Str.Subst(R,placeholder, fmtnum(fsize-1,10,1," "));
    Str.Subst(R,placeholder, fmtnum(percent,10,1," "));

    CASE viewmode OF
    | palmode: S:="256 colors palette ([$00..$~f])";
               IF fixpal THEN
                   Str.Subst(S,placeholder,"3");
               ELSE
                   Str.Subst(S,placeholder,"f");
               END;
               CASE palorder OF
               | rgbpal : Str.Append(S," in RGB order");
               | bgrpal : Str.Append(S," in BGR order");
               END;
    | rgb8888:        S:="RGBA 8:8:8:8 quadruplets";
    | bgr8888:        S:="BGRA 8:8:8:8 quadruplets";
    | rgb8888alt:     S:="ARGB 8:8:8:8 quadruplets";
    | bgr8888alt:     S:="ABGR 8:8:8:8 quadruplets";
    | rgb888:         S:="RGB 8:8:8 triplets";
    | bgr888:         S:="BGR 8:8:8 triplets";
    | rgb565 :        S:="RGB 5:6:5 duplets";
    | bgr565 :        S:="BGR 5:6:5 duplets";
    | rgb555 :        S:="RGB 5:5:5 duplets";
    | bgr555 :        S:="BGR 5:5:5 duplets";
    | rgb4444:        S:="RGBA 4:4:4:4 duplets";
    | bgr4444:        S:="BGRA 4:4:4:4 duplets";
    | rgb4444alt:     S:="ARGB 4:4:4:4 duplets";
    | bgr4444alt:     S:="ABGR 4:4:4:4 duplets";
    | planarRGB:      S:="global planar RGB";
    | planarBGR:      S:="global planar BGR";
    END;
    IF negative  THEN Str.Append(S," +negative");END;
    IF flipme    THEN Str.Append(S," +flip");END;
    IF bigendian THEN Str.Append(S," +big-endian");END;
    IF fixluminosity # nolumen THEN
        Str.Append(S," +B=");
        IF fixluminosity < 0 THEN
            Str.Append(S,"-");
        ELSE
            Str.Append(S,"+");
        END;
        Str.Append(S,fmtnum( LONGCARD( ABS(fixluminosity) ),10,1,"") );
    END;
    Str.Subst(R,placeholder,S); (* we should never go past 80 chars here *)

    Str.Subst(R,placeholder, fmtnum(LONGCARD(wi),10,1," "));
    Str.Subst(R,placeholder, fmtnum(LONGCARD(he),10,1," "));

    Str.Concat(S, fmtnum(LONGCARD(kmul),10,1," "), " pixel");
    IF kmul > 1 THEN Str.Append(S,"s");END;
    Str.Subst(R,placeholder, S);

    IF halfwindow THEN
        S:="half";
    ELSE
        S:="full";
    END;
    Str.Subst(R,placeholder,S);

    S:="";
    statbool(S,textMode         , "text"  , "graphics" , " mode, ");
    statbool(S,(wantedlines=25) , "25"    , "50"       , " lines (text mode, ");
    statbool(S,vsync            , "waiting for","ignoring" , " video retrace)");

    Str.Subst(R,placeholder,S);
END fmtParms;

PROCEDURE showhelp (vesamode,kmul,wantedlines:CARDINAL;
          viewmode:viewmodetype;fsize,fpos:LONGCARD;wi,he:CARDINAL;
          xmin,ymin,xcount,ycount:CARDINAL;  fastput:BOOLEAN;
          palorder:palordertype;
          negative,flipme,fixpal,halfwindow,textMode,vsync,bigendian:BOOLEAN;
          fixluminosity:INTEGER);
VAR
    ch1,ch2:CHAR;
    shifted:BOOLEAN;
    y,x:CARDINAL;
    bigS : hugestr;
BEGIN
    (* lines : 4 + 1 + 17 + 1 + 1  *)
    fmtParms (bigS,viewmode,fsize,fpos,wi,he,kmul,wantedlines,
             palorder,negative,flipme,fixpal,
             halfwindow,textMode,vsync,bigendian,fixluminosity);
    Str.Append(bigS,nl+helpKeys+nl+msgAnykey);

IF textMode THEN
    textON(wantedlines);

    WrStr(bigS);

    BiosWaitkeyShifted(ch1,ch2,shifted); (* globerk as too many things here... *)

    textOFF(vesamode);
ELSE
    palOp(TRUE,viewmode,zblack,zwhite);
    (*
       we don't clear screen by resetting VESA mode because this would...
       a) ...be too slow ; b) ...and cause palette lost
    *)
    VESAcls( viewmode,fastput,zblack,xmin,ymin,xcount,ycount);
    doPrintAt (viewmode,xmin,ymin,zwhite,zblack,bigS);
    BiosWaitkeyShifted(ch1,ch2,shifted); (* globerk as too many things here... *)
    palOp(FALSE,viewmode,zblack,zwhite);
END;
END showhelp;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE enternewval (VAR v:CARDINAL;
                      what,maxi,vesamode,wantedlines:CARDINAL);
CONST
    msgIn  = "Enter new value : ";
    msgW   = "Width           : ";
    msgH   = "Height          : ";
VAR
    S: str128;
    lc:LONGCARD;
BEGIN
    textON(wantedlines);
    (* Flushkey(); *)
    LOOP
        CASE what OF
        | 1 : S:=msgW;
        | 2 : S:=msgH;
        END;
        Str.Append(S, fmtnum(LONGCARD(v),10,1," "));
        WrStr(S);WrLn;
        WrLn;
        WrStr(msgIn);TerminalReadString(S);
        LtrimBlanks(S);
        RtrimBlanks(S);
        IF same(S,"") THEN EXIT; END;
        IF getLongCardValue(lc,S) THEN
            IF lc >= 1 THEN (* 1-based *)
                IF lc <= LONGCARD(maxi) THEN v:=CARDINAL(lc);EXIT; END;
            END;
        END;
        WrLn;
        soundLimit;
    END;
    textOFF(vesamode);
END enternewval;

PROCEDURE percentToFpos (VAR p:LONGCARD; fsize:LONGCARD):BOOLEAN;
VAR
    v:LONGREAL;
BEGIN
    IF p < 0   THEN RETURN FALSE; END; (* never ! *)
    IF p > 100 THEN RETURN FALSE; END;

    IF fsize <= 1 THEN (* avoid divide by 0 -- 0-length file is already filtered but... *)
        p:=0;
    ELSE
        CASE CARDINAL(p) OF
        | 0   : p:=0;
        | 100 : p:=fsize-1;
        ELSE
                v:=LONGREAL(p) / LONGREAL(100.0);
                v:=v * LONGREAL(fsize-1); (* fsize is at least 2 *)
                p:=VAL(LONGCARD,v);
        END;
    END;
    RETURN TRUE;
END percentToFpos;

PROCEDURE enternewpos (VAR fpos:LONGCARD;
                      fsize:LONGCARD;vesamode,wantedlines:CARDINAL);
CONST
    placeholder = "~";
    msgIn       = "Enter new value : ";
    msgCurr     = "File position   : $~ / $~ = ~ / ~ = ~%";
VAR
    S: str128;
    percent,lc:LONGCARD;
BEGIN
    textON(wantedlines);
    (* Flushkey(); *)
    LOOP
        percent:=fposToPercent(fsize,fpos);
        S:=msgCurr;
        Str.Subst(S,placeholder, fmtnum(fpos,16,8,"0"));
        Str.Subst(S,placeholder, fmtnum(fsize-1,16,8,"0"));
        Str.Subst(S,placeholder, fmtnum(fpos,10,1," "));
        Str.Subst(S,placeholder, fmtnum(fsize-1,10,1," "));
        Str.Subst(S,placeholder, fmtnum(percent,10,1," "));
        WrStr(S);WrLn;
        WrLn;
        WrStr(msgIn);TerminalReadString(S);
        LtrimBlanks(S);
        RtrimBlanks(S);
        IF same(S,"") THEN EXIT; END;
        IF Str.Match(S,"*%") THEN
            Str.Subst(S,"%","");
            IF getLongCardValue(lc,S) THEN
                IF percentToFpos(lc,fsize) THEN fpos:=lc; EXIT; END;
            END;
        ELSIF getLongCardValue(lc,S) THEN
            IF lc < fsize THEN fpos:=lc; EXIT; END;
        END;
        WrLn;
        soundLimit;
    END;
    textOFF(vesamode);
END enternewpos;

PROCEDURE listfiles (anyfsize,allowzerolen:BOOLEAN;requiredfsize:LONGCARD;
                    wantedlines:CARDINAL;pattern:ARRAY OF CHAR):CARDINAL;
CONST
    namesPerLine    = 5;      (* (12+3)*4 + (12+3) = 75 chars *)
    nameMaxWidth    = 8+1+3;
    blanksep        = "   ";
    msgHitAnyKey    = "Hit any key to continue, or [Escape] to abort listing : ";
    msgCountOfLines = 1+1+1 +1  +1+1+1; (* include filename prompt so we don't lose first names *)
VAR
    n,i,currline:CARDINAL;
    found,ok:BOOLEAN;
    entry:FIO.DirEntry;
    fsize:LONGCARD;
    F:str16;
    ch1,ch2:CHAR;
    continue,shifted:BOOLEAN;
    linesPerScreen:CARDINAL;
    msg:str16;
BEGIN
    linesPerScreen := wantedlines - msgCountOfLines;
    n:=0;
    currline:=0;
    continue:=TRUE;
    found:=FIO.ReadFirstEntry(pattern,allfiles, entry);
    WHILE found DO
        fsize := entry.size;
        ok:=anyfsize;
        IF NOT(ok) THEN ok := ( fsize = requiredfsize ); END;
        IF NOT (allowzerolen ) THEN ok := ( ok AND (fsize # 0) ); END;
        IF ok THEN
            INC(n);
            Str.Copy(F,entry.Name);
            (*
            Str.Caps(F); (* useless safety *)
            Str.Subst(F,extPAL,"");
            *)
            Str.Lows(F);
            FOR i:=(Str.Length(F)+1) TO nameMaxWidth DO Str.Prepend(F,blank);END;
            IF (n MOD namesPerLine) # 1 THEN WrStr(blanksep);END;
            WrStr(F);
            IF (n MOD namesPerLine) = 0 THEN
                WrLn;
                INC(currline);
                IF currline > linesPerScreen THEN
                    currline:=0;
                    WrLn;
                    WrStr (msgHitAnyKey);
                    BiosWaitkeyShifted(ch1,ch2,shifted); (* globerk as too many things here... *)
                    CASE ch1 OF
                    | CHR(27):
                        msg:="[Escape]";  continue:= FALSE;
                    ELSE
                        msg:="[*]";
                    END;
                    WrStr(msg); WrLn; (* end prompt line *)
                    WrLn; (* separ *)
                END;
            END;
        END;
        found:=FIO.ReadNextEntry(entry);
        found:= (found AND continue);
    END;
    IF (n MOD namesPerLine) # 0 THEN WrLn;END;
    WrLn;
    RETURN n;
END listfiles;

PROCEDURE getuserpal768 (fixpal:BOOLEAN;palorder:palordertype;
                       viewmode:viewmodetype;vesamode,wantedlines:CARDINAL);
CONST
    pattern = "*"+extPAL;
    msgNada = 'No match for "'+pattern+'" (768 bytes long) in current directory !';
    msgIn   = "Enter palette name, then hit [Return] : ";
    maxf8   = 8;
    maxe3   = 3+1; (* dot ! *)
VAR
    i,got,wanted : CARDINAL;
    newpal : ARRAY [minpalndx..maxpalndx] OF paltriplettype; (* standard 768 bytes *)
    r,g,b:SHORTCARD;
    S:str128;
    hin:FIO.File;
    ok,remap:BOOLEAN;
    ch1,ch2:CHAR;
    shifted:BOOLEAN;
    uu,dd,nn,ee:str128;
BEGIN
    IF viewmode # palmode THEN soundIrrelevant; RETURN; END;

    remap:=FALSE;

    textON(wantedlines);
    wanted:=SIZE(newpal);
    got:=listfiles( FALSE, FALSE, LONGCARD( wanted ), wantedlines, pattern );
    IF got = 0 THEN
        WrStr(msgNada);WrLn;
        WrLn;
        WrStr (msgAnykey);
        BiosWaitkeyShifted(ch1,ch2,shifted);
    ELSE
        (* Flushkey(); *)
        LOOP
            WrStr(msgIn);TerminalReadString(S);
            LtrimBlanks(S);
            RtrimBlanks(S);
            IF same(S,"") THEN EXIT; END;
            Str.Caps(S);
            IF Str.CharPos(S,dot)=MAX(CARDINAL) THEN Str.Append(S,extPAL); END;
            (* more checks : unit, f8, e3 ? bah... *)
            Lib.SplitAllPath(S,uu,dd,nn,ee);
            IF same(ee,"") THEN Str.Copy(ee,dot);END;
            ok:=  ( Str.Length(nn) <= maxf8 );
            ok:=( ( Str.Length(ee) <= maxe3 ) AND ok );
            IF ok THEN
                IF FIO.Exists(S) THEN
                    hin:=FIO.OpenRead(S);
                    got:=FIO.RdBin(hin,newpal,wanted);
                    FIO.Close(hin);
                    IF got = wanted THEN remap:=TRUE; EXIT; END;
                END;
            END;
            WrLn;
            soundLimit;
        END;
    END;
    textOFF(vesamode); (* saved graphics palette has been reset *)
    IF remap THEN
        FOR i:=minpalndx TO maxpalndx DO
            r:=newpal[i].r;
            g:=newpal[i].g;
            b:=newpal[i].b;

            (* this was NOT a good idea !
            IF fixpal THEN (* [$00..$ff] to [$00..$3f] : a mere ">> 2 " would do ! *)
                r:=b8to6(r);
                g:=b8to6(g);
                b:=b8to6(b);
            END;
            CASE palorder OF
            | rgbpal: setDAC(i,r,g,b);
            | bgrpal: setDAC(i,b,g,r);
            END;
            *)

            setDAC(i,r,g,b);
        END;
    END;
END getuserpal768;

PROCEDURE getuserfile (VAR fsize:LONGCARD; VAR F:ARRAY OF CHAR;
                      vesamode,wantedlines:CARDINAL):BOOLEAN;
CONST
    pattern = stardotstar;
    msgNada = 'No match for "'+pattern+'" in current directory !';
    msgIn   = "Enter file name, then hit [Return] : ";
    maxf8   = 8;
    maxe3   = 3+1; (* dot ! *)
VAR
    i,got,wanted : CARDINAL;
    S:str128;
    hin:FIO.File;
    ok,remap:BOOLEAN;
    ch1,ch2:CHAR;
    gotfile,shifted:BOOLEAN;
    uu,dd,nn,ee:str128;
BEGIN
    gotfile:=FALSE;
    textON(wantedlines);
    got:=listfiles( TRUE, FALSE, 0 , wantedlines, pattern );
    IF got = 0 THEN
        WrStr(msgNada);WrLn;
        WrLn;
        WrStr (msgAnykey);
        BiosWaitkeyShifted(ch1,ch2,shifted);
    ELSE
        (* Flushkey(); *)
        LOOP
            WrStr(msgIn);TerminalReadString(S);
            LtrimBlanks(S);
            RtrimBlanks(S);
            IF same(S,"") THEN EXIT; END;
            Str.Caps(S);
            IF Str.CharPos(S,dot)=MAX(CARDINAL) THEN Str.Append(S,dot); END;
            (* more checks : unit, f8, e3 ? bah... *)
            Lib.SplitAllPath(S,uu,dd,nn,ee);
            IF same(ee,"") THEN Str.Copy(ee,dot);END;
            ok:=  ( Str.Length(nn) <= maxf8 );
            ok:=( ( Str.Length(ee) <= maxe3 ) AND ok );
            IF ok THEN
                IF FIO.Exists(S) THEN
                    gotfile:=TRUE;
                    Str.Copy(F,S);
                    fsize:=getFileSize(F);
                    EXIT;
                END;
            END;
            WrLn;
            soundLimit;
        END;
    END;
    textOFF(vesamode); (* saved graphics palette has been reset *)
    RETURN gotfile;
END getuserfile;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    byteSize = SIZE(SHORTCARD);
    wordSize = SIZE(CARDINAL);
    quadSize = SIZE(LONGCARD);

PROCEDURE Filter (c : CHAR) : CHAR;
BEGIN
    IF ( (ORD(c) < ORD(blank)) OR (ORD(c) = 255) ) THEN
        RETURN ".";
    ELSE
        RETURN c;
    END;
END Filter;

PROCEDURE hexdump (VAR fpos:LONGCARD; VAR vsync:BOOLEAN;
                  fsize:LONGCARD; hin:FIO.File;
                  vesamode,wantedlines,datasize,xmin,ymin,xcount,ycount:CARDINAL;
                  fastput,textMode,flushkb:BOOLEAN;viewmode:viewmodetype);
CONST
    reservedlines = 2; (* nl+msg *)
    xmul          = 1; (* won't be used *)
VAR
    wanted,got,x,y,i,hcount,vcount:CARDINAL;
    S,ASC:str128;
    HEX,hexpad:str16;
    ch1,ch2:CHAR;
    shifted:BOOLEAN;
    buf:ARRAY [1..16] OF SHORTCARD;
    p:LONGCARD;
    b:SHORTCARD;
    bigS:hugestr;
    loopstate : (waitcmd,continue,quit);
    wi:CARDINAL;
    nlines:INTEGER;
BEGIN
    IF textMode THEN
        textON(wantedlines); (* once here *)  (* change mode... *)
        getTextmodeDimensions(hcount,vcount); (* ... then get dimensions *)
    ELSE
        vcount:=ycount DIV (hechar+hebeautifier);
        IF (80*vcount) >= SIZE(hugestr) THEN
            vcount:=SIZE(hugestr) DIV 80;
        END;
        palOp(TRUE,viewmode,zblack,zwhite);
    END;

    DEC(vcount,reservedlines);
    hexpad  := "  "; (* "##" *)

    nlines:=INTEGER(vcount);

    LOOP
        FIO.Seek(hin,fpos);
        p:=fpos;

        bigS := "";
        wanted:=16;
        FOR y:=1 TO vcount DO
            got:=FIO.RdBin( hin,buf,wanted);
            CASE got OF
            | 0, MAX(CARDINAL): (* undocumented 65535 if we try and read beyond EOF *)
                S:="";
            ELSE
                FOR x:=(got+1) TO wanted DO buf[x]:=0; END;
                Str.Concat(S,fmtnum( p,16,8,"0")," : ");
                ASC:=": ";
                x:=1;
                LOOP
                    HEX:="";
                    FOR i:=1 TO datasize DO
                        IF x > got THEN
                            Str.Prepend(HEX,hexpad);
                            Str.Append(ASC," ");
                        ELSE
                            b:=buf[x+i-1];
                            Str.Prepend(HEX, fmtnum( LONGCARD(b),16,2,"0"));
                            Str.Append(ASC,Filter( CHR(b)) );
                        END;
                    END;
                    Str.Append(S,HEX);Str.Append(S," ");
                    INC(x,datasize);
                    IF x > wanted THEN EXIT; END;
                END;
                Str.Append(S,ASC);
            END;
            Str.Append(bigS,S);Str.Append(bigS,nl);
            INC (p,LONGCARD(got) );
        END;

        Str.Append(bigS,nl);
        Str.Append(bigS,msgHelpHexKeys);

        IF textMode THEN
            textCLS(wantedlines,vsync);
            WrStr(bigS);
        ELSE
            VESAcls( viewmode,fastput,zblack,xmin,ymin,xcount,ycount);
            doPrintAt (viewmode,xmin,ymin,zwhite,zblack,bigS);
        END;

        LOOP
            wi := (wanted DIV datasize);
            loopstate:=continue;
            IF flushkb THEN BiosFlushkey();END;
            BiosWaitkeyShifted(ch1,ch2,shifted); (* globerk as too many things here... *)
            ch1:=CAP(ch1);
            CASE ch1 OF

            | CHR(27): loopstate:=quit;

            | "B"    : datasize := byteSize;
            | "W"    : datasize := wordSize;
            | "Q"    : datasize := quadSize;

            | key10a : newfilepos (fpos, fsize,10);
            | key20a : newfilepos (fpos, fsize,20);
            | key30a : newfilepos (fpos, fsize,30);
            | key40a : newfilepos (fpos, fsize,40);
            | key50a : newfilepos (fpos, fsize,50);
            | key60a : newfilepos (fpos, fsize,60);
            | key70a : newfilepos (fpos, fsize,70);
            | key80a : newfilepos (fpos, fsize,80);
            | key90a : newfilepos (fpos, fsize,90);

            | CHR(13)  : newpos(fpos,xmul,fsize,datasize,wi, vcount,FALSE); (* cr=pagedn *)

            | CHR(0) : (* CHR(0) was... unpractical ! see Waitkey *)
                CASE ch2 OF
                (* left right : one unit *)
                | CHR(75)  : newpos(fpos,xmul,fsize,datasize, 1,-1,FALSE);
                | CHR(77)  : newpos(fpos,xmul,fsize,datasize, 1, 1,FALSE);
                (* up down : one line *)
                | CHR(72)  : newpos(fpos,xmul,fsize,datasize,wi,-1,FALSE);
                | CHR(80)  : newpos(fpos,xmul,fsize,datasize,wi, 1,FALSE);
                (* pageup pagedown *)
                | CHR(73)  : newpos(fpos,xmul,fsize,datasize,wi,-nlines,FALSE);
                | CHR(81)  : newpos(fpos,xmul,fsize,datasize,wi, nlines,FALSE);

                | CHR(71)  : fpos:=0;       (* home *)
                | CHR(79)  : fpos:=fsize-1; (* end *)

                | CHR(24)  : vsync:=NOT(vsync); (* alt-O *)

                ELSE
                    loopstate:=waitcmd;
                END;
            ELSE
                loopstate:=waitcmd;
            END;
            IF loopstate # waitcmd THEN EXIT; END;
            soundBadKey;
            BiosFlushkey();
        END;
        IF loopstate = quit THEN EXIT; END;
    END;

    IF textMode THEN
        textOFF(vesamode);
    ELSE
        palOp(FALSE,viewmode,zblack,zwhite);
        VESAcls( viewmode,fastput,zblack,xmin,ymin,xcount,ycount);
    END;
END hexdump;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE LFNtoShort(VAR canonical:ARRAY OF CHAR;lfn:pathtype):BOOLEAN;
CONST
    dbg=FALSE;
VAR
    R,short:pathtype;
    errcode:CARDINAL;
    rc:BOOLEAN;
BEGIN
(*%T dbg *) WrStr("spec     : ");WrStr(lfn);WrLn; (*%E *)
    rc:= w9XtrueName(lfn, errcode,R);
    IF rc=FALSE THEN RETURN rc; END;
(*%T dbg *) WrStr("truename : ");WrStr(R);WrLn; (*%E *)
    rc:= w9XlongToShort (R, errcode, short);
    IF rc=FALSE THEN RETURN rc; END;
(*%T dbg *) WrStr("canonical: ");WrStr(short);WrLn; (*%E *)
    Str.Copy(canonical,short);
(*%T dbg *) HALT; (*%E *)
    RETURN TRUE;
END LFNtoShort;

PROCEDURE doDumpParms ( viewmode:viewmodetype;fsize,fpos:LONGCARD;
                      wi,he,kmul,wantedlines:CARDINAL;palorder:palordertype;
                      negative,flipme,fixpal,
                      halfwindow,textMode,vsync,bigendian:BOOLEAN;fixluminosity:INTEGER);
VAR
    bigS:hugestr;
BEGIN
    fmtParms (bigS,viewmode,fsize,fpos,wi,he,kmul,wantedlines,
             palorder,negative,flipme,fixpal,
             halfwindow,textMode,vsync,bigendian,fixluminosity);
    WrStr(bigS);
END doDumpParms;

PROCEDURE newmul (VAR kmul:CARDINAL;VAR xmul:LONGCARD; n:INTEGER):BOOLEAN;
CONST
    mini = INTEGER(1);
    maxi = INTEGER(maxKMUL);
VAR
    v:INTEGER;
BEGIN
    v:=INTEGER(kmul);
    v:=v+n;
    IF v < mini THEN RETURN FALSE;END;
    IF v > maxi THEN RETURN FALSE;END;
    kmul:=CARDINAL(v);
    xmul:=LONGCARD(kmul);
    RETURN TRUE;
END newmul;

(* we do expect a legal entry ! R is ini if not found, or raw input *)

PROCEDURE readFromIni (VAR R,S:ARRAY OF CHAR):BOOLEAN;
VAR
    ok:BOOLEAN;
    hin:FIO.File;
BEGIN
    Lib.ParamStr(R,0);
    Str.Caps(R); (* useless safety *)
    Str.Subst(R,extEXE,extINI);
    ok:=FIO.Exists(R);
    IF ok THEN
        FIO.EOF:=FALSE;
        hin:=FIO.OpenRead(R);
        LOOP
            IF FIO.EOF THEN EXIT; END;
            FIO.RdStr(hin,S);
            IF FIO.EOF THEN EXIT; END;
            LtrimBlanks(S);
            RtrimBlanks(S);
            CASE S[0] OF
            | nullchar,semicolon,pound:
                ;
            ELSE
                Str.Copy(R,S);
                Str.Caps(S);
                EXIT;
            END;
        END;
        FIO.Close(hin);
    END;
    RETURN ok;
END readFromIni;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    placeholder = "~";
    firstparm = 1;
    maxparm   = 2;
VAR
    orginfile:pathtype;
    infile:str128;
    xcount,ycount,bpp,bitsum,vesamode,wantedlines,kmul:CARDINAL;
    xmin,ymin,xmax,ymax:CARDINAL;
    x,y,wi,he:CARDINAL;
    ink,rr,gg,bb:SHORTCARD;
    picnum,palnum,pixelsize:CARDINAL;
    flushkb,targaquirk,verbose,useLFN:BOOLEAN;
    halfwindow,fastput,negative,flipme,fixpal,bigendian:BOOLEAN;
    fixluminosity:INTEGER;
    textMode,vsync:BOOLEAN;
    palorder:palordertype;
    scr:INTEGER; (* for pageup/pagedown *)
    xmul:LONGCARD;
    wantedx,wantedy,wantedbpp:CARDINAL;
VAR
    i,opt,parmcount : CARDINAL;
    S,R:str128;
    hin:FIO.File;
    fpos,fsize,lc:LONGCARD;
    loopstate : (waitcmd,continue,quit);
    viewmode  : viewmodetype;
    cmd       : (cmdnone,cmdwork,cmdlist);
    ch1,ch2:CHAR;
    rc,ok,shifted:BOOLEAN;
    parmraw    : ARRAY [firstparm..maxparm] OF str128;
    parmcooked : ARRAY [firstparm..maxparm] OF str128;
    lastparm   : CARDINAL;
BEGIN
    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;

    fpos     := MAX(LONGCARD);
    wi       := MAX(CARDINAL);
    he       := MAX(CARDINAL);
    kmul     := MAX(CARDINAL);
    wantedlines:=MAX(CARDINAL);
    flushkb  := TRUE;
    viewmode := undefinedmode;
    palorder := undefinedorder;
    targaquirk:=TRUE;
    halfwindow:=FALSE;
    verbose  := FALSE;
    fastput  := TRUE;
    negative := FALSE;
    flipme   := FALSE;
    fixpal   := FALSE;
    textMode := FALSE;
    vsync    := TRUE;
    bigendian:= FALSE;
    useLFN   := w9XsupportLFN();
    vesamode := MAX(CARDINAL);
    fixluminosity:=nolumen;

    cmd      := cmdnone;

    lastparm := firstparm-1;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "P:"+delim+"POSITION:"+delim+
                                  "W:"+delim+"WIDTH:"+delim+
                                  "H:"+delim+"HEIGHT:"+delim+
                                  "K"+delim+"KEYBOARD"+delim+
                                  "L"+delim+"LIST"+delim+
                                  "M:"+delim+"TRUECOLORMODE:"+delim+
                                  "A:"+delim+"PALETTE:"+delim+
                                  "T"+delim+"TARGAPALETTE"+delim+
                                  "V"+delim+"VERBOSE"+delim+
                                  "N"+delim+"LFN"+delim+
                                  "2"+delim+"25"+delim+
                                  "5"+delim+"50"+delim+
                                  "K:"+delim+
                                  "D"+delim+"HALF"+delim+
                                  "S"+delim+"SAFE"+delim+
                                  "R"+delim+"NEGATIVE"+delim+
                                  "X"+delim+"FIXPAL"+delim+
                                  "G"+delim+"TEXTMODE"+delim+
                                  "W"+delim+"RETRACE"+delim+"VSYNC"+delim+
                                  "E"+delim+"ENDIAN"+delim+"BIGENDIAN"+delim+
                                  "F"+delim+"FLIP"+delim+
                                  "??"
                                  );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5 :   GetString(S,R);
                      IF getLongCardValue(lc,R)=FALSE THEN abort(errValue,S);END;
                      fpos:=lc;
            | 6,7 :   IF GetLongCard(R,lc)=FALSE THEN abort(errValue,S);END;
                      IF lc > MAX(CARDINAL) THEN abort(errValue,S);END;
                      wi:=CARDINAL(lc);
            | 8,9 :   IF GetLongCard(R,lc)=FALSE THEN abort(errValue,S);END;
                      IF lc > MAX(CARDINAL) THEN abort(errValue,S);END;
                      he:=CARDINAL(lc);
            | 10,11:  flushkb:=FALSE;
            | 12,13:  cmd:=cmdlist;
            | 14,15:  IF GetLongCard(R,lc)=FALSE THEN abort(errValue,S);END;
                      IF lc > MAX(CARDINAL) THEN abort(errValue,S);END;
                      CASE CARDINAL(lc) OF
                      | 1: viewmode:=rgb8888;
                      | 2: viewmode:=bgr8888;
                      | 3: viewmode:=rgb8888alt;
                      | 4: viewmode:=bgr8888alt;
                      | 5: viewmode:=rgb888;
                      | 6: viewmode:=bgr888;
                      | 7: viewmode:=rgb565;
                      | 8: viewmode:=bgr565;
                      | 9: viewmode:=rgb555;
                      | 10:viewmode:=bgr555;
                      | 11:viewmode:=rgb4444;
                      | 12:viewmode:=bgr4444;
                      | 13:viewmode:=rgb4444alt;
                      | 14:viewmode:=bgr4444alt;
(*%T PLANAR *)
                      | 15:viewmode:=planarRGB;
                      | 16:viewmode:=planarBGR;
(*%E *)
                      ELSE
                          abort(errValue,S);
                      END;
            | 16,17:  IF GetLongCard(R,lc)=FALSE THEN abort(errValue,S);END;
                      IF lc > MAX(CARDINAL) THEN abort(errValue,S);END;
                      CASE CARDINAL(lc) OF
                      | 1 : palorder:=rgbpal;
                      | 2 : palorder:=bgrpal;
                      ELSE
                          abort(errValue,S);
                      END;
            | 18,19:  targaquirk:=FALSE;
            | 20,21:  verbose:=TRUE;
            | 22,23:  useLFN:=FALSE;
            | 24,25:  wantedlines:=25;
            | 26,27:  wantedlines:=50;
            | 28:     IF GetLongCard(R,lc)=FALSE THEN abort(errValue,S);END;
                      IF lc > MAX(CARDINAL) THEN abort(errValue,S);END;
                      kmul:=CARDINAL(lc);
            | 29,30:  halfwindow:=TRUE;
            | 31,32:  fastput:=FALSE;
            | 33,34:  negative:=TRUE;
            | 35,36:  fixpal:=TRUE;
            | 37,38:  textMode:=TRUE;
            | 39,40,41:vsync:=TRUE;
            | 42,43,44:bigendian := TRUE;
            | 45,46:  flipme:=TRUE;
            | 47:     abort(errHelper,"");
            ELSE
                      abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errParam,S);END;
            parmraw   [lastparm]:=S; (* keep case *)
            parmcooked[lastparm]:=R;
        END;
    END;

    CASE cmd OF
    | cmdnone:
        IF lastparm # maxparm THEN abort(errSyntax,"");END;

        R:=parmraw[firstparm];
        S:=parmcooked[firstparm];

        IF ( same(R,modeplaceholder) OR same(R,altmodeplaceholder) ) THEN
            IF readFromIni(R,S)=FALSE THEN abort(errIniNotFound,R);END;
        END;

        IF getLongCardValue(lc,R) THEN
            IF lc > MAX(CARDINAL) THEN abort(errValue,S);END;
            vesamode:=CARDINAL(lc);
        ELSE
           IF parseWHBPP(wantedx,wantedy,wantedbpp,R)=FALSE THEN abort(errValue,S);END;
           CASE wantedbpp OF
           | 8,32:
               ;
           ELSE
               abort(errBPP,S);
           END;
        END;

        R:=parmraw[firstparm+1];
        Str.Copy ( orginfile , R ); (* may be a LFN *)
        IF chkJoker(R) THEN abort(errJoker,R);END;

        cmd:=cmdwork;
    | cmdlist:
        (* IF lastparm >= firstparm THEN abort(errSyntax,"");END; *)
        IF chkVESAhere()=FALSE THEN abort(errBios,"");END;
        rc:=getModeFromList(TRUE, vesamode);
        WHILE rc DO
            IF getVESAmodeInfos(vesamode) THEN
                getVESAgeometry (xmin,ymin,xmax,ymax,bpp,bitsum);
                CASE bpp OF
                | 8,32 :
                    S:="$~ (~) : ~x~x~";

                    Str.Subst(S,placeholder,fmtnum( LONGCARD(vesamode),16,4,"0"));
                    Str.Subst(S,placeholder,fmtnum( LONGCARD(vesamode),10,3," "));
                    Str.Subst(S,placeholder,fmtnum( LONGCARD(xmax-xmin+1),10,1," "));
                    Str.Subst(S,placeholder,fmtnum( LONGCARD(ymax-ymin+1),10,1," "));
                    Str.Subst(S,placeholder,fmtnum( LONGCARD(bpp),10,1," "));
                    WrStr(S);WrLn;
                END;
            (*
            ELSE
                abort(errCall,"$104f01"); END;
            *)
            END;
            rc:=getModeFromList(FALSE,vesamode);
        END;
        abort(errNone,"");
    END;

    (* ------------------------------------------------------------ *)

    IF useLFN THEN
        IF LFNtoShort(infile,orginfile)=FALSE THEN abort(errLFN,orginfile);END;
    ELSE
        Str.Copy(infile,orginfile);
        IF FIO.Exists(infile)=FALSE THEN abort(errNotFound,orginfile);END;
    END;
    fsize:=getFileSize(infile);
    IF fsize=0 THEN abort(errEmptyFile,infile);END;

    IF fpos = MAX(LONGCARD) THEN
        fpos:=0;
    ELSE
        IF fpos >= fsize THEN abort(errRange,"file position");END;
    END;

    IF chkVESAhere()=FALSE THEN abort(errBios,"");END;

    ok:=FALSE;
    rc:=getModeFromList(TRUE, i);
    LOOP
        IF rc=FALSE THEN EXIT; END;
        CASE vesamode OF
        | MAX(CARDINAL) :
            IF getVESAmodeInfos(i) THEN
                getVESAgeometry (xmin,ymin,xmax,ymax,bpp,bitsum);
                IF (xmax-xmin+1)=wantedx THEN
                    IF (ymax-ymin+1)=wantedy THEN
                        IF bpp=wantedbpp THEN vesamode:=i;ok:=TRUE; EXIT; END;
                    END;
                END;
            END;
        ELSE
            IF i=vesamode THEN
                IF getVESAmodeInfos(i) THEN
                    getVESAgeometry (xmin,ymin,xmax,ymax,bpp,bitsum);
                    CASE bpp OF
                    | 8,32 : ok:=TRUE; EXIT;
                    END;
                END;
            END;
        END;
        rc:=getModeFromList(FALSE,i);
    END;
    IF NOT(ok) THEN abort(errUnsupported,"");END;

    xcount:=xmax-xmin+1;
    ycount:=ymax-ymin+1;

    IF wi = MAX(CARDINAL) THEN
        wi:=xcount;
    ELSE
        IF wi < 1 THEN abort(errRange,"width");END;
        IF wi > xcount THEN abort(errRange,"width");END;
    END;

    IF he = MAX(CARDINAL) THEN
        he:=ycount;
    ELSE
        IF he < 1 THEN abort(errRange,"height");END;
        IF he > ycount THEN abort(errRange,"height");END;
    END;

    IF kmul=MAX(CARDINAL) THEN kmul:=defaultKMUL; END;
    ok:=newmul(kmul,xmul,0);
    IF NOT(ok) THEN abort(errRange,"motionmultiplier");END;

    IF wantedlines=MAX(CARDINAL) THEN wantedlines:=25; END;


    CASE bpp OF
    | 8 :
        IF viewmode # undefinedmode THEN abort(errBPPmismatch,"");END;
        viewmode:=palmode;
        IF palorder=undefinedorder THEN palorder:=rgbpal;END;
    | 32:
        IF palorder # undefinedorder THEN abort(errNoPalette,"");END;
        IF viewmode = undefinedmode THEN viewmode := viewmodetype(firstvmode32); END;
    END;

    IF NOT(textMode) THEN
        IF ( (xcount < wilimit) OR (ycount < helimit) ) THEN textMode:=TRUE; END;
    END;

    picnum:=MINNUM;
    palnum:=MINNUM;

    IF SetVesaMode(vesamode) = FALSE THEN set80x25; abort(errSet,S); END;
    savesystempal;
    IF initVESAmode(1)=FALSE THEN set80x25; abort(errSet,"$104f05"); END;
    IF initVESAmode(2)=FALSE THEN set80x25; abort(errGranularity,""); END;

    initBestfitTables(); (* do it once whatever mode then forget about it *)

    hin:=FIO.OpenRead(infile);
    FIO.AssignBuffer(hin,ioBufferIn);
    LOOP
        IF halfwindow THEN
            scr:=INTEGER(he DIV 2); IF scr=0 THEN INC(scr);END;
        ELSE
            scr:=INTEGER(he);
        END;
        pixelsize:=getPixelsize(viewmode);
        (* perform seek and reseek *)
        showpic (hin,viewmode,fpos,wi,he,xmin,ymin,xcount,ycount,
                vesamode,fastput,negative,flipme,bigendian,fixluminosity);

        LOOP
            loopstate:=continue;
            IF flushkb THEN BiosFlushkey();END;
            BiosWaitkeyShifted(ch1,ch2,shifted); (* globerk as too many things here... *)
            ch1:=CAP(ch1);
            CASE ch1 OF
            | "/","J": newval(wi,kmul,xcount,-1,NOT(shifted));
            | "*","L": newval(wi,kmul,xcount, 1,NOT(shifted));
            | "-","I": newval(he,kmul,ycount,-1,NOT(shifted));
            | "+","K": newval(he,kmul,ycount, 1,NOT(shifted));

            | "0"    : newpos(fpos,xmul,fsize,            1,1,-1,FALSE); (* force one byte *)
            | "."    : newpos(fpos,xmul,fsize,            1,1, 1,FALSE); (* force one byte *)
            | CHR(8) : newpos(fpos,xmul,fsize,      palsize,1,-1,FALSE); (* delete *)
            | "="    : newpos(fpos,xmul,fsize,  palquadsize,1,-1,FALSE);

            | "V"    : showpal(viewmode,xmin,ymin,xcount,ycount,vesamode,fastput);
            | "P"    : readpal(fpos,hin,palsize    ,fixpal,palorder,viewmode);
            | ")"    : readpal(fpos,hin,palquadsize,fixpal,palorder,viewmode);
            | "Y"    :
                   IF (fpos+1) <= fsize THEN
                       readpal(fpos,hin,palsize    ,fixpal,palorder,viewmode);
                       newpos(fpos,xmul,fsize,    palsize-1,1,-1,FALSE); (* back 767 *)
                   END;
            | "U"    :
                   IF (fpos+1) <= fsize THEN
                       readpal(fpos,hin,palquadsize,fixpal,palorder,viewmode);
                       newpos(fpos,xmul,fsize,palquadsize-1,1,-1,FALSE); (* back 1023 *)
                   END;
            | "X"    : fixpal := NOT(fixpal);
            | CHR(18): restoresystempalette(viewmode);          (* ^R *)

            | CHR(9) : CASE viewmode OF                         (* tab *)
                       | palmode : neworder(palorder,FALSE);
                       ELSE newmode(viewmode,FALSE);
                       END;

            | "?",",": showhelp(vesamode,kmul,wantedlines,viewmode,fsize,fpos,wi,he,
                       xmin,ymin,xcount,ycount,  fastput,
                       palorder,negative,flipme,fixpal,
                       halfwindow,textMode,vsync,bigendian,fixluminosity);

            | CHR(19): screenToFile(picnum, R,bpp,xmin,ymin,wi,he,targaquirk);  (* ^S *)
                       logParms (fpos, vesamode,wi,he, negative,flipme,fixpal,viewmode,palorder,R);
                       (* BiosFlushkey(); *) (* prevent too many saves in succession *)
            | CHR(16): palToFile(palnum,bpp);                                   (* ^P *)
                       (* BiosFlushkey(); *) (* prevent too many saves in succession *)
            | CHR(5) : bigendian := NOT(bigendian);             (* ^E *)
            | CHR(27): loopstate:=quit;

            | "B"    : hexdump (fpos,vsync,
                               fsize,hin,vesamode,wantedlines,
                               byteSize,xmin,ymin,xcount,ycount,
                               fastput,textMode,flushkb, viewmode);
            | "W"    : hexdump (fpos,vsync,
                               fsize,hin,vesamode,wantedlines,
                               wordSize,xmin,ymin,xcount,ycount,
                               fastput,textMode,flushkb, viewmode);
            | "Q"    : hexdump (fpos,vsync,
                               fsize,hin,vesamode,wantedlines,
                               quadSize,xmin,ymin,xcount,ycount,
                               fastput,textMode,flushkb, viewmode);

            | "F"    : halfwindow:=NOT(halfwindow);

            | "R"    : negative:=NOT(negative);

            | CHR(6) : flipme:=NOT(flipme);

            | CHR(22): newlumen(fixluminosity,-lumenstep); (* ctrl V *)
            | CHR(2) : fixluminosity:=nolumen;             (* ctrl B *)
            | CHR(14): newlumen(fixluminosity,lumenstep);  (* ctrl N *)

            | CHR(13): newpos(fpos,xmul,fsize,pixelsize,wi, scr,FALSE); (* cr=pagedn *)

            | key10a : newfilepos (fpos, fsize,10);
            | key20a : newfilepos (fpos, fsize,20);
            | key30a : newfilepos (fpos, fsize,30);
            | key40a : newfilepos (fpos, fsize,40);
            | key50a : newfilepos (fpos, fsize,50);
            | key60a : newfilepos (fpos, fsize,60);
            | key70a : newfilepos (fpos, fsize,70);
            | key80a : newfilepos (fpos, fsize,80);
            | key90a : newfilepos (fpos, fsize,90);

            | CHR(12) : CASE wantedlines OF (* was "5", now Ctrl-L *)
                        | 25 : opt:= 50;
                        | 50 : opt:= 25;
                        END;
                        wantedlines:=opt;

            | CHR(0) : (* CHR(0) was... unpractical ! see Waitkey *)
                CASE ch2 OF
                (* left right up down *)
                | CHR(75)  : newpos(fpos,xmul,fsize,pixelsize, 1,-1,NOT(shifted));
                | CHR(77)  : newpos(fpos,xmul,fsize,pixelsize, 1, 1,NOT(shifted));
                | CHR(72)  : newpos(fpos,xmul,fsize,pixelsize,wi,-1,NOT(shifted));
                | CHR(80)  : newpos(fpos,xmul,fsize,pixelsize,wi, 1,NOT(shifted));
                (* pageup pagedown *)
                | CHR(73)  : newpos(fpos,xmul,fsize,pixelsize,wi,-scr,FALSE);
                | CHR(81)  : newpos(fpos,xmul,fsize,pixelsize,wi, scr,FALSE);

                | CHR(71)  : fpos:=0;       (* home *)
                | CHR(79)  : fpos:=fsize-1; (* end *)

                | CHR(15)  : CASE viewmode OF (* shift-tab *)
                             |  palmode : neworder(palorder,TRUE);
                             ELSE newmode(viewmode,TRUE);
                             END;

                | CHR(103) : shelldos(vesamode,wantedlines); (* ^F10 *)
                | CHR(17)  : enternewval(wi,1,xcount,vesamode,wantedlines); (* alt-W 1-based *)
                | CHR(35)  : enternewval(he,2,ycount,vesamode,wantedlines); (* alt-H 1-based *)
                | CHR(25)  : enternewpos(fpos,fsize,vesamode,wantedlines);  (* alt-P 0-based *)
                | CHR(21)  : getuserpal768(fixpal,palorder,viewmode,vesamode,wantedlines); (* alt-Y 768 bytes palette *)

                | CHR(38)  : IF getuserfile (fsize,infile,
                                            vesamode,wantedlines) THEN  (* alt-L *)
                                 (* we know infile exists and its fsize is not 0, thanks to listfiles() *)
                                 FIO.Close(hin);
                                 hin:=FIO.OpenRead(infile);
                                 FIO.AssignBuffer(hin,ioBufferIn);
                                 fpos:=0;
                             END;
                | CHR(24)  : vsync:=NOT(vsync); (* alt-O *)
                (* F1..F7 *)
                | CHR(59) : setnewmode(viewmode,rgb8888);
                | CHR(60) : setnewmode(viewmode,rgb8888alt);
                | CHR(61) : setnewmode(viewmode,rgb888);
                | CHR(62) : setnewmode(viewmode,rgb565);
                | CHR(63) : setnewmode(viewmode,rgb555);
                | CHR(64) : setnewmode(viewmode,rgb4444);
                | CHR(65) : setnewmode(viewmode,bgr4444alt);
                (* F8 *)
                | CHR(66): setneworder(palorder,viewmode,rgbpal);
(*%T PLANAR *)
                (* F9 *)
                | CHR(67) : setnewmode(viewmode,planarRGB);
(*%E *)
                (* F11..F12 *)
                | CHR(133): setneworder(palorder,viewmode,rgbpal);
                | CHR(134): setneworder(palorder,viewmode,bgrpal);
                (* shift + F1..F2 *)
(*%T PLANAR *)
                | CHR(84): setnewmode(viewmode,planarRGB);
                | CHR(85): setnewmode(viewmode,planarBGR);
(*%E *)
                | CHR (34): IF textMode THEN (* alt-G *)
                                IF NOT( (xcount < wilimit) OR (ycount < helimit) ) THEN
                                    textMode:=FALSE;
                                END;
                            ELSE
                                textMode:=TRUE;
                            END;
                (* alt- & alt+ *)
                | CHR(74) : IF newmul(kmul,xmul,-1)=FALSE THEN soundLimit; END;
                | CHR(78) : IF newmul(kmul,xmul, 1)=FALSE THEN soundLimit; END;

                ELSE
                    loopstate:=waitcmd;
                END;
            ELSE
                loopstate:=waitcmd;
            END;
            IF loopstate # waitcmd THEN EXIT; END;
            soundBadKey;
            BiosFlushkey();
        END;
        IF loopstate = quit THEN EXIT; END;
    END;

    FIO.Close(hin);
    textON(wantedlines);
    IF verbose THEN
        doDumpParms (viewmode,fsize,fpos,wi,he,kmul,wantedlines,
                    palorder,negative,flipme,fixpal,
                    halfwindow,textMode,vsync,bigendian,fixluminosity);
    END;
    abort(errNone,"");

END picFind.




(*
DEFINT A-Z

DIM v5to8(0 TO 31)
DIM ex(0 TO 31)
RESTORE
FOR i = 0 TO 31
READ v5to8(i)
NEXT

FOR i = 0 TO 31
        ex(i) = i * 8          ' bfi
        ex(i) = (i * 255) \ 31 ' better but a few discrepancies
        ex(i) = INT(255 / 31 * i + .5)' perfect but floats !
NEXT

n = 0
FOR i = 0 TO 31
        v1 = v5to8(i)
        V2 = ex(i)
        PRINT i, v1, V2;
        IF v1 <> V2 THEN
                n = n + 1
                PRINT " ###"
        ELSE
                PRINT
        END IF
NEXT
IF n <> 0 THEN PRINT : PRINT n; " difference(s)"

DATA    0,   8,  16,  25,  33,  41,  49,  58
DATA   66,  74,  82,  90,  99, 107, 115, 123
DATA  132, 140, 148, 156, 165, 173, 181, 189
DATA  197, 206, 214, 222, 230, 239, 247, 255

*)

