(* ---------------------------------------------------------------
Title         Q&D Box
Author        PhG
Overview      some use(d|ful) subroutines for Q&D tools
Notes         now requiring QD_ASCII !
Bugs          for cosmetic reasons, animation() advances immediately...
              thus waiting twice at end !
              isDirectory() is not clever enough but who cares ?
              note for now, it thinks "\" is not a directory
Wish List     rewrite isValidHDunit() so it no longer accesses unit

--------------------------------------------------------------- *)

IMPLEMENTATION MODULE QD_Box;

IMPORT SYSTEM;
IMPORT Lib;
IMPORT Str;
IMPORT IO;
IMPORT FIO;
IMPORT BiosIO;

FROM QD_ASCII IMPORT dash, slash, nullchar, tabchar, cr, lf, nl,
space, dot, deg, doublequote, quote, colon, percent, vbar,
bs, blank, equal, dquote, charnull, singlequote, antislash, dollar,
star, backslash, coma, question, underscore,
stardotstar,dotdot,escCh, escSet, letters, digits;

(* ------------------------------------------------------------ *)

(* this algo is OK *)

    CONST
        bsblankbs= bs+blank+bs;
        act      = ".";
        firstdot = 1;
        lastdot  = 10;
    VAR                 (* feront office de variables statiques *)
        currdot : INTEGER; (* was CARDINAL *)
        motion  : INTEGER; (* was CARDINAL set to -1 !!! *)
        counter : CARDINAL;

    PROCEDURE vidWrStr (s : ARRAY OF CHAR);
    CONST
        (* stderr        = 02H;  (* write to stderr as not to write control chars to possible redirected file *) *)
        stderr        = FIO.ErrorOutput;
        writeToHandle = 40H;
    VAR
        r : SYSTEM.Registers;
    BEGIN
        r.BX := stderr;
        r.CX := Str.Length(s);
        r.DS := Seg(s);
        r.DX := Ofs(s);
        r.AH := writeToHandle; (* AH, eh ! ax would require 4000H ! *)
        Lib.Dos(r);
    END vidWrStr;

    PROCEDURE Work (cmd : CARDINAL);
    CONST
        rounds = 256; (* was 16 *)
    BEGIN
        CASE cmd OF
        | cmdInit :
            currdot := firstdot;
            motion  := 1;
            counter := 0;
        | cmdShow,cmdSHOW : (* use SHOW if called unfrequently *)
            IF cmd = cmdShow THEN
                INC (counter);
                IF (counter MOD rounds) <> 0 THEN RETURN; END;
            END;
            counter := 0;
            INC (currdot,motion);
            CASE motion OF
            | 1 :
                IF currdot > lastdot THEN
                    vidWrStr(act);
                    motion := -1;
                ELSE
                    vidWrStr(act);
                END;
            | -1 :
                IF currdot = firstdot THEN
                   vidWrStr(bsblankbs);
                   motion := 1;
                ELSE
                   vidWrStr(bsblankbs);
                END;
            END;
        | cmdStop :
            WHILE currdot > firstdot DO
                vidWrStr(bsblankbs);
                DEC(currdot);
            END;
        END;
    END Work;

    PROCEDURE primitiveAnimation (cmd : CARDINAL;
                                  msgAnim:ARRAY OF CHAR;lastChar:INTEGER);
    CONST
        firstChar = 0;
        rounds = 1;
    VAR
        ch : CHAR;
    BEGIN
        CASE cmd OF
        | cmdInit :
            currdot := firstChar;
            counter := 0;
            vidWrStr(msgAnim[currdot]);
        | cmdShow,cmdSHOW : (* use SHOW if called unfrequently *)
            IF cmd = cmdShow THEN
                INC (counter);
                IF (counter MOD rounds) <> 0 THEN RETURN; END;
            END;
            counter := 0;
            INC(currdot);
            IF currdot > lastChar THEN
                currdot := firstChar;
            END;
            ch := msgAnim[currdot];
            vidWrStr(bs);
            vidWrStr(ch);
        | cmdStop :
            vidWrStr(bsblankbs);
        END;
    END primitiveAnimation;

    PROCEDURE Animation (cmd : CARDINAL);
    CONST
        msgAnim   = "-\|/"; (* 0..3 *)
        lastchar  = 3;
    BEGIN
        primitiveAnimation(cmd,msgAnim,lastchar);
    END Animation;

    PROCEDURE AltAnimation (cmd : CARDINAL);
    CONST
        msgAnim   = ""; (*  249,254,219,254 *)
        lastchar  = 3;
    BEGIN
        primitiveAnimation(cmd,msgAnim,lastchar);
    END AltAnimation;

    PROCEDURE video (S : ARRAY OF CHAR; flag:BOOLEAN);
    VAR
        len : CARDINAL;
        i   : CARDINAL;
    BEGIN
        len := Str.Length(S);
        CASE flag OF
        | TRUE :
            vidWrStr(S);
        | FALSE:
            FOR i := 1 TO len DO
                vidWrStr(bsblankbs);
            END;
        END;
    END video;

    (* oui, on sait : simplement hh:mm SO WHAT ? ;-) *)

    VAR
        orgTimer : LONGINT; (* because 24*60*60 = 86400 seconds *)

    PROCEDURE Elapsed (cmd : CARDINAL);
    CONST
        rounds = 256; (* was 16 *)
        depart = "00:00"; (* always FIVE chars mm:ss *)
        maxTimer=LONGINT(24*60*60);
    VAR
        hh,mm,ss,ssss:CARDINAL;
        newTimer,delta,imm,iss:LONGINT;
        sSS,sMM:ARRAY[0..1] OF CHAR;
        ok:BOOLEAN;
    BEGIN
        CASE cmd OF
        | cmdInit :
            Lib.GetTime(hh,mm,ss,ssss);
            orgTimer:=LONGINT(hh*60+mm)*60+LONGINT(ss);
            video(depart,TRUE);
            counter := 0;
        | cmdShow,cmdSHOW : (* use SHOW if called unfrequently *)
            IF cmd = cmdShow THEN
                INC (counter);
                IF (counter MOD rounds) <> 0 THEN RETURN; END;
            END;
            Lib.GetTime(hh,mm,ss,ssss);
            newTimer:=LONGINT(hh*60+mm)*60+LONGINT(ss);
            delta:=newTimer-orgTimer;
            IF delta < 0 THEN INC(delta,maxTimer); END;
            iss:=delta MOD 60;
            imm:=(delta DIV 60) MOD 60;
            Str.IntToStr(iss,sSS,10,ok);
            Str.IntToStr(imm,sMM,10,ok);
            video(depart,FALSE);
            IF imm < 10 THEN video("0",TRUE); END;
            video(sMM,TRUE);
            video(":",TRUE);
            IF iss < 10 THEN video("0",TRUE); END;
            video(sSS,TRUE);
            counter := 0;
        | cmdStop :
            video(depart,FALSE);
        END;
    END Elapsed;

    (* animation which can show steps *)
    (*
    animInit(n, "[", "]", "*", "", "\/" );

    anim(animShow);
    anim(animAdvance);

    anim(animEnd);
    anim(animClear);
    *)

    VAR
        animLastStep, animCurrStep :CARDINAL;
        animLastAnim, animCurrAnim : CARDINAL;
        animClose, animEmpty, animDone : CHAR;
        animAnim : str16;
        animSempty, animSdone : str80;
        animCounter : CARDINAL;

    PROCEDURE animInit (steps:CARDINAL;open,close,empty,done:CHAR;
                        whirl:ARRAY OF CHAR);
    CONST
        defaultEmpty= "-";
        defaultDone = "+";
        defaultAnim = "-\|/";
    VAR
        i: CARDINAL;
    BEGIN
        animLastStep := steps-1;
        animCurrStep := 0;
        animClose    := close;
        animEmpty    := empty;
        IF same(animEmpty,"") THEN animEmpty:=defaultEmpty;END;
        animDone     := done;
        IF same(animDone,"") THEN animDone:=defaultDone;END;
        Str.Copy(animAnim,whirl);
        IF same(animAnim,"") THEN Str.Copy(animAnim,defaultAnim);END;
        animLastAnim := Str.Length(animAnim)-1;
        animCurrAnim  := 0;

        Str.Copy(animSempty,open);
        Str.Copy(animSdone,open);
        FOR i := 0 TO animLastStep DO
            Str.Append(animSempty,animEmpty);
            Str.Append(animSdone,animDone);
        END;
        Str.Append(animSempty,close);
        Str.Append(animSdone,close);

        vidWrStr(animSempty);

        IF same(animClose,"")=FALSE THEN vidWrStr(bs);END;
        FOR i:=0 TO animLastStep DO
            vidWrStr(bs);
        END;

        animCounter := 0;
    END animInit;

    PROCEDURE animGetSdone ( VAR R : ARRAY OF CHAR  );
    BEGIN
        Str.Copy(R,animSdone);
    END animGetSdone;

    PROCEDURE anim (cmd:CARDINAL);
    CONST
        rounds = 256; (* was 16 *)
    VAR
        i : CARDINAL;
    BEGIN
        CASE cmd OF
        | animShow,animSHOW:
            IF cmd=animShow THEN
                INC (animCounter);
                IF (animCounter MOD rounds) <> 0 THEN RETURN; END;
            END;
            animCounter := 0;
            vidWrStr(animAnim[animCurrAnim]);
            vidWrStr(bs);
            INC(animCurrAnim);
            IF animCurrAnim > animLastAnim THEN animCurrAnim:=0;END;
        | animAdvance:
            IF animCurrStep < animLastStep THEN
                vidWrStr(animDone);
                INC(animCurrStep);
            END;
        | animEnd:
            LOOP
                IF animCurrStep > animLastStep THEN EXIT; END;
                vidWrStr(animDone);
                INC(animCurrStep);
                (* Lib.Delay(1000); *)
            END;
            IF same(animClose,"")=FALSE THEN
                vidWrStr(animClose);
            END;
        | animClear:
            video(animSdone,FALSE);
        END;
    END anim;

    (* show percent completed from two longcards *)

    VAR
       completedTotal : LONGCARD;
       completedPrev,completedCounter : CARDINAL;
       completedStr   : str16;
       completedUseCard: BOOLEAN;

    PROCEDURE completed (cmd:CARDINAL;info:LONGCARD);

        PROCEDURE NumToStr3( spos, n : CARDINAL );
        VAR
            cH,cD,cU : CHAR;
        BEGIN
            cH := CHR( n DIV 100          + ORD('0') );
            cD := CHR((n MOD 100) DIV 10  + ORD('0') );
            cU := CHR( n MOD 10           + ORD('0') );

            IF cH = '0' THEN
                cH := " ";
                IF cD = '0' THEN cD := " ";END;
            END;

            completedStr[spos]   := cH;
            completedStr[spos+1] := cD;
            completedStr[spos+2] := cU;
        END NumToStr3;

    CONST
        rounds     = 10;
        percentStr = "  0%"; (* "###%" *)
    VAR
        ratio:CARDINAL;
        divisor:LONGCARD;
    BEGIN
        CASE cmd OF
        | completedInit:
            completedTotal := info;
            completedPrev  := 0;
            Str.Copy(completedStr,percentStr);
            video(completedStr,TRUE);
            completedCounter := 0;
            completedUseCard := ( info < (MAX(LONGCARD) DIV 100) );
        | completedShow,completedSHOW:
            (* ugly, really ugly... *)
            IF completedUseCard THEN
                ratio:=CARDINAL( (info * 100) DIV completedTotal );
            ELSE
                (*
                we could use

                ratio:=CARDINAL( (LONGREAL(info)*100.0) / LONGREAL(completedTotal) );

                but we'll try and avoid using floats
                *)

                divisor:=completedTotal DIV 100;
                IF divisor = 0 THEN divisor:=1; END; (* safety *)
                ratio:=CARDINAL( info DIV divisor );
            END;
            IF ratio # completedPrev THEN
                completedPrev:=ratio;
                IF cmd=completedSHOW THEN
                    INC (completedCounter);
                    IF (completedCounter MOD rounds) <> 0 THEN RETURN; END;
                    completedCounter := 0;
                END;
                video(completedStr,FALSE);
                NumToStr3(0,ratio);
                video(completedStr,TRUE);
            END;
        | completedEnd:
            video(completedStr,FALSE);
        END;
    END completed;

(* ------------------------------------------------------------ *)

PROCEDURE map (c : CHAR ;table : ARRAY OF CHAR) : CHAR;
BEGIN
    RETURN table [ ORD (c) ];
END map;

CONST
    ignore = " ";
    Tupper = "                                "+
             "                                "+
             " ABCDEFGHIJKLMNOPQRSTUVWXYZ     "+
             " ABCDEFGHIJKLMNOPQRSTUVWXYZ     "+
             "CUEAAAACEEEIIIAAEOOOUUYOU     "+ (* use "ae" *)
             "AIOUNN                          "+
             "                                "+
             "                               ";

    Tlower = "                                "+
             "                                "+
             " abcdefghijklmnopqrstuvwxyz     "+
             " abcdefghijklmnopqrstuvwxyz     "+
             "ueaaaaeeeiiiaaeooouuyou     "+
             "aiounn                          "+
             "                                "+
             "                               ";

    TupperA= "                                "+
             "                                "+
             " ABCDEFGHIJKLMNOPQRSTUVWXYZ     "+
             " ABCDEFGHIJKLMNOPQRSTUVWXYZ     "+
             "AAEEEIIIOOUUY     "+
             "AIOU                          "+
             "                                "+
             "                                ";

    TlowerA= "                                "+
             "                                "+
             " abcdefghijklmnopqrstuvwxyz     "+
             " abcdefghijklmnopqrstuvwxyz     "+
             "     "+
             "                          "+
             "                                "+
             "                               ";

(*
    Tasc   = "                                "+
             ' !"'+
                "#$%&'()*+,-./0123456789:;<=>?"+
             "@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_"+
             "`abcdefghijklmnopqrstuvwxyz{|}~"+
             ""+
             ""+
             ""+
             "";
*)

(* ------------------------------------------------------------ *)

PROCEDURE Ltrim (VAR S : ARRAY OF CHAR; c:CHAR);
VAR
    i,len : CARDINAL;
BEGIN
    len := Str.Length (S);
    i   := 0;
    LOOP
        IF i = len THEN EXIT; END;
        IF S[i] # c THEN EXIT; END;
        INC (i);
    END;
    Str.Delete (S,0,i); (* procedure handles removal of i=0 *)
END Ltrim;

(* ------------------------------------------------------------ *)

PROCEDURE Rtrim (VAR S : ARRAY OF CHAR; c:CHAR);
VAR
    i,len : CARDINAL;
BEGIN
    len := Str.Length (S);
    i   := len;
    LOOP
        IF i = 0 THEN EXIT; END;
        IF S[i-1] # c THEN EXIT; END;
        DEC (i);
    END;
    Str.Delete (S,i,len-i);
END Rtrim;

(* ------------------------------------------------------------ *)

PROCEDURE UpperCase (VAR S : ARRAY OF CHAR);
VAR
    len : CARDINAL;
    i   : CARDINAL;
    c   : CHAR;
    ch  : CHAR;
BEGIN
    len := Str.Length(S);
    IF len = 0 THEN RETURN; END;         (* this WAS a problem ! *)
    FOR i := 0 TO (len - 1) DO
        c  := S[i];
        ch := map(c,Tupper);
        IF ch # ignore THEN S[i] := ch; END;
    END;
END UpperCase;

PROCEDURE LowerCase (VAR S : ARRAY OF CHAR);
VAR
    len : CARDINAL;
    i   : CARDINAL;
    c   : CHAR;
    ch  : CHAR;
BEGIN
    len := Str.Length(S);
    IF len = 0 THEN RETURN; END;         (* this WAS a problem ! *)
    FOR i := 0 TO (len - 1) DO
        c  := S[i];
        ch := map(c,Tlower);
        IF ch # ignore THEN S[i] := ch; END;
    END;
END LowerCase;

PROCEDURE UpperCaseAlt (VAR S : ARRAY OF CHAR);
VAR
    len : CARDINAL;
    i   : CARDINAL;
    c   : CHAR;
    ch  : CHAR;
BEGIN
    len := Str.Length(S);
    IF len = 0 THEN RETURN; END;         (* this WAS a problem ! *)
    FOR i := 0 TO (len - 1) DO
        c  := S[i];
        ch := map(c,TupperA);
        IF ch # ignore THEN S[i] := ch; END;
    END;
END UpperCaseAlt;

PROCEDURE LowerCaseAlt (VAR S : ARRAY OF CHAR);
VAR
    len : CARDINAL;
    i   : CARDINAL;
    c   : CHAR;
    ch  : CHAR;
BEGIN
    len := Str.Length(S);
    IF len = 0 THEN RETURN; END;         (* this WAS a problem ! *)
    FOR i := 0 TO (len - 1) DO
        c  := S[i];
        ch := map(c,TlowerA);
        IF ch # ignore THEN S[i] := ch; END;
    END;
END LowerCaseAlt;

(* ------------------------------------------------------------ *)

PROCEDURE ReplaceChar (VAR S : ARRAY OF CHAR;
                       oldchar, newchar : CHAR);
VAR
    p : CARDINAL;
BEGIN
    IF oldchar=newchar THEN RETURN; END; (* silly... *)
    LOOP
        p := Str.CharPos(S,oldchar);
        IF p = MAX(CARDINAL) THEN EXIT; END;
        IF newchar = "" THEN
            Str.Delete(S,p,1);
        ELSE
            S[p]:=newchar;
        END;
    END;
END ReplaceChar;

(* ------------------------------------------------------------ *)

PROCEDURE ChkEscape (  ) : BOOLEAN;
CONST
    escape  = CHR(27);
    special = CHR(0);
VAR
    ch : CHAR;
BEGIN
    IF IO.KeyPressed() = TRUE THEN
        ch := IO.RdKey();
        CASE ch OF
        | escape :
            RETURN TRUE;
        | special :
            ch := IO.RdKey();
            RETURN FALSE;
        ELSE
            RETURN FALSE;
        END;
    ELSE
        RETURN FALSE;
    END;
END ChkEscape;

(* ------------------------------------------------------------ *)

PROCEDURE Waitkey () : str2;
VAR
    ch : str2;
BEGIN
    Str.Copy (ch,IO.RdKey());
    IF ch = str2(CHR(0)) THEN
        (* appending to CHR(0) is NOT a good idea if we need functions keys *)
        (* change special char to CHR(255) instead *)
        ch:=str2(CHR(255));
        Str.Append (ch,IO.RdKey());
        RETURN ch;
    ELSE
        RETURN ch;
    END;
END Waitkey;

(* ------------------------------------------------------------ *)

PROCEDURE WaitkeyDelay (default : str2; pause : CARDINAL) : str2;
CONST
    localdelay = 50;
VAR
    ch      : str2;
    counter : CARDINAL;
    rounds  : CARDINAL;
BEGIN
    rounds  := pause DIV localdelay;
    counter := 0;
    LOOP
        IF IO.KeyPressed()=TRUE THEN
            ch := Waitkey();
            RETURN ch;
        END;
        Lib.Delay(localdelay);
        INC(counter);
        IF counter >= rounds THEN EXIT; END;
    END;
    RETURN default;
END WaitkeyDelay;

(* ------------------------------------------------------------ *)

PROCEDURE Flushkey ();
VAR
    ch : str2;
BEGIN
    WHILE ( IO.KeyPressed()=TRUE ) DO
        ch := Waitkey();
    END;
END Flushkey;

(* ------------------------------------------------------------ *)

PROCEDURE IsRedirected() : BOOLEAN;
VAR
    r    : SYSTEM.Registers;
    flag : CARDINAL; (* wants bitwise M2 operator ON, here *)
BEGIN
    r.AX := 4400H;   (* get ioctl info *)
    r.BX := 01H;     (* FIO.StandardOutput is always 1 *)
    Lib.Dos(r);
    flag := r.DX;
    IF (flag AND 80H ) = 80H THEN (* bit 7 set = periph, else file *)
       RETURN FALSE;
    ELSE
       RETURN TRUE;
    END;
END IsRedirected;

(* ------------------------------------------------------------ *)

PROCEDURE chkJoker (S : ARRAY OF CHAR) : BOOLEAN;
CONST
    star     = "*";
    question = "?";
VAR
    p : CARDINAL;
BEGIN
    IF Str.CharPos(S,star) # MAX(CARDINAL) THEN RETURN TRUE; END;
    IF Str.CharPos(S,question) # MAX(CARDINAL) THEN RETURN TRUE; END;
    RETURN FALSE;
END chkJoker;

(* ------------------------------------------------------------ *)

PROCEDURE isOption (S : ARRAY OF CHAR) : BOOLEAN;
BEGIN
CASE S[0] OF
| slash, dash :
    RETURN TRUE;
ELSE
    RETURN FALSE;
END;
END isOption;

(* ------------------------------------------------------------ *)

PROCEDURE GetOptIndex (S : ARRAY OF CHAR; options : ARRAY OF CHAR) : CARDINAL;
VAR
    i   : CARDINAL;
    str : str80; (* option tested against s *)
BEGIN
    Str.Delete(S,0,1); (* remove leading - or / because we arrive if option *)
    Str.Append(options,delim);

    Str.Subst(S,equal,colon); (* command line option xxx= becomes xxx: *)
    ReplaceChar(options,equal,colon); (* all possibles option xxx= become xxx: *)

    i := 0;
    LOOP
        Str.ItemS(str,options,delim,i);
        IF Str.Length(str)=0 THEN RETURN 0; END;
        IF Str.CharPos(str,colon)=MAX(CARDINAL) THEN (* normal option *)
             IF Str.Compare(str,S)=0 THEN RETURN (i+1); END;
        ELSE (* option with a number *)
             Str.Append(str,"*"); (* match any number after : *)
             IF Str.Match(S, str )=TRUE THEN RETURN (i+1); END;
        END;
        INC(i);
    END;
END GetOptIndex;

PROCEDURE GetLongCard (s : ARRAY OF CHAR; VAR value : LONGCARD) : BOOLEAN;
VAR
    p  : CARDINAL;
    v  : LONGCARD;
    ok : BOOLEAN;
BEGIN
    Str.Subst(s,equal,colon); (* command line option xxx= becomes xxx: *)
    p := Str.CharPos(s,colon); (* exclude MAX(CARDINAL) here! ;-) *)
    Str.Delete(s,0,p+1);
    v := Str.StrToCard(s,10,ok);
    value := v;
    RETURN ok;
END GetLongCard;

PROCEDURE GetLongInt (s : ARRAY OF CHAR; VAR value : LONGINT) : BOOLEAN;
VAR
    p  : CARDINAL;
    v  : LONGINT;
    ok : BOOLEAN;
BEGIN
    Str.Subst(s,equal,colon); (* command line option xxx= becomes xxx: *)
    p := Str.CharPos(s,colon); (* exclude MAX(CARDINAL) here! ;-) *)
    Str.Delete(s,0,p+1);
    v := Str.StrToInt(s,10,ok);
    value := v;
    RETURN ok;
END GetLongInt;

PROCEDURE GetString (s : ARRAY OF CHAR; VAR r : ARRAY OF CHAR);
VAR
    p : CARDINAL;
BEGIN
    Str.Subst(s,equal,colon); (* command line option xxx= becomes xxx: *)
    p := Str.CharPos(s,colon); (* exclude MAX(CARDINAL) here! ;-) *)
    Str.Delete(s,0,p+1);
    Str.Copy (r, s);
END GetString;

(* ------------------------------------------------------------ *)

PROCEDURE CharCount (S : ARRAY OF CHAR; what : CHAR) : CARDINAL;
VAR
    n    : CARDINAL;
    oldp : CARDINAL;
    nxtp : CARDINAL;
    len  : CARDINAL;
BEGIN
    n    := 0;
    len  := Str.Length(S);
    oldp := 0;
    LOOP
        nxtp := Str.NextPos(S,what,oldp);
        IF nxtp = MAX(CARDINAL) THEN EXIT; END;
        INC(n);
        oldp := nxtp+1;
        IF oldp >= len THEN EXIT; END;
    END;
    RETURN n;
END CharCount;

(* ------------------------------------------------------------ *)

PROCEDURE same(S1,S2 : ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF Str.Compare(S1,S2)=0 THEN RETURN TRUE; END;
    RETURN FALSE;
END same;

(* ------------------------------------------------------------ *)

PROCEDURE fixDirectory (VAR S : ARRAY OF CHAR);
VAR
    len : CARDINAL;
BEGIN
    len := Str.Length(S);
    IF len=0 THEN RETURN; END;
    IF S[len-1] = antislash THEN RETURN; END;
    Str.Append(S,antislash);
END fixDirectory;

(* take care of "\" or "u:\" *)

PROCEDURE unfixDirectory (VAR S : ARRAY OF CHAR);
VAR
    len : CARDINAL;
BEGIN
    len := Str.Length(S);
    IF len=0 THEN RETURN; END;
    IF S[len-1] # antislash THEN RETURN; END;
    IF same(S,"\") THEN RETURN;END;
    IF Str.Match(S,"?:\") THEN RETURN;END;
    S[len-1] := CHR(0);
END unfixDirectory;

PROCEDURE isDirectory (S : ARRAY OF CHAR) : BOOLEAN;
VAR
    entry : FIO.DirEntry;
    found : BOOLEAN;
BEGIN
    unfixDirectory(S);
    CASE Str.Length(S) OF
    | 2 : (* avoid "u:" alone ! but what about "*.", eh ? *)
        IF S[1]=colon THEN RETURN TRUE; END; (* always but we do not check for its real life *)
    | 3 : (* avoid "u:\" alone ! *)
        IF S[1]=colon THEN
            IF S[2]=antislash THEN RETURN TRUE; END; (* always but we do not check for its real life *)
        END;
    END;
    found := FIO.ReadFirstEntry(S,everything,entry);
    IF found = FALSE THEN RETURN FALSE; END;
    RETURN (aD IN entry.attr);
END isDirectory;

(* ------------------------------------------------------------ *)

PROCEDURE FixAE (VAR S : ARRAY OF CHAR);
CONST
    ae = ""; (* 145 *)
VAR
    p : CARDINAL;
BEGIN
    LOOP
        p:=Str.CharPos(S,ae);
        IF p=MAX(CARDINAL) THEN EXIT; END;
        Str.Subst(S,ae,"ae");
    END;
END FixAE;

(* ------------------------------------------------------------ *)

CONST
    voyelles         = "aeiouy";
    voyellesfortes   = "aou";
    voyellesfaibles  = "eiy";
    consonnes        = "bcdfghjklmnpqrstvwxz"; (* c cdille aussi *)

PROCEDURE Belongs (S : ARRAY OF CHAR; c:CHAR  ) : BOOLEAN;
BEGIN
    IF Str.CharPos(S,c)=MAX(CARDINAL) THEN
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END Belongs;

PROCEDURE IsVoyelle (c : CHAR  ) :BOOLEAN;
BEGIN
    RETURN Belongs(voyelles,c);
END IsVoyelle;

PROCEDURE IsVoyelleForte (c:CHAR ):BOOLEAN;
BEGIN
    RETURN Belongs(voyellesfortes,c);
END IsVoyelleForte;

PROCEDURE IsVoyelleFaible (c:CHAR ):BOOLEAN;
BEGIN
    RETURN Belongs(voyellesfaibles,c);
END IsVoyelleFaible;

PROCEDURE IsConsonne (c : CHAR  ) :BOOLEAN;
BEGIN
    RETURN Belongs(consonnes,c);
END IsConsonne;

PROCEDURE Replace (VAR S:ARRAY OF CHAR;p,n:CARDINAL;R:ARRAY OF CHAR );
BEGIN
    Str.Delete(S,p,n);
    Str.Insert(S,R,p);
END Replace;

(* ------------------------------------------------------------ *)

(*
alternate for soundex (loosely based on WordConjug documentation)
assume already lower case
*)

PROCEDURE CodePhonetic (S : ARRAY OF CHAR; VAR R : ARRAY OF CHAR);
TYPE
    str2 = ARRAY [0..1] OF CHAR;
    str3 = ARRAY [0..2] OF CHAR;
VAR
    len:CARDINAL;
    prev:CHAR;
    p : CARDINAL;
    c1,c2,c3,c4 : CHAR;
    c12 : str2;
    c123: str3;
BEGIN
    Str.Copy(R,"");
    IF Str.Length(S)=0 THEN RETURN; END;
    prev:="";
    p:=0;
    LOOP
        len:=Str.Length(S); (* length CAN vary so force reevaluation *)
        IF p >= len THEN EXIT; END;
        c1:=S[p];
        c2:=""; IF (p+1) <len THEN c2:=S[p+1]; END;
        c3:=""; IF (p+2) <len THEN c3:=S[p+2]; END;
        c4:=""; IF (p+3) <len THEN c4:=S[p+3]; END;
        Str.Concat(c12,c1,c2);
        Str.Concat(c123,c12,c3);

        IF (c1="h") AND (prev="") THEN
            INC(p);
        ELSIF (c1="h") AND (Belongs("bdglmnrtx",prev)) THEN (* added M in string *)
            INC(p);
        ELSIF (c12=str2("sh")) AND (IsVoyelle(c3)) THEN
            Replace(S,p,2,"ch");
        ELSIF (c1="h") AND (prev="c") AND (IsConsonne(c2)) THEN
            INC(p);
        ELSIF (c1="h") AND (IsVoyelle(prev)) AND (c2="") THEN (* added *)
            INC(p);
        ELSIF c12 = str2("ph") THEN
            Replace(S,p,2,"f");
        ELSIF (Belongs("bdfglmnrptx",c1)) AND (c1=prev) THEN
            INC(p);
        ELSIF (c1="c") AND (prev="c") AND (IsVoyelleForte(c2)) THEN
            INC(p);
        ELSIF (c12=str2("cc")) AND (IsVoyelleFaible(c3)) THEN
            Replace(S,p,2,"x");
        ELSIF (c1="z") AND (IsVoyelle(prev)) AND (IsVoyelle(c2)) THEN
            Replace(S,p,1,"s");
        ELSIF (c1="c") AND (prev="x") AND (IsVoyelleFaible(c2)) THEN
            INC(p);
        ELSIF (c12=str2("ss")) AND (IsVoyelleFaible(c3)) THEN
            Replace(S,p,2,"s");
        ELSIF (c12=str2("sc")) AND (IsVoyelleFaible(c3)) THEN
            Replace(S,p,2,"s");
        ELSIF (c1="") AND (IsVoyelle(c2)) THEN
            Replace(S,p,1,"s");
        ELSIF (c1="u") AND (prev="g") AND (IsVoyelleForte(c2)) THEN
            INC(p);
        ELSIF (c1="g") AND (IsVoyelleFaible(c2)) THEN
            Replace(S,p,1,"j");
        ELSIF (c12=str2("ge")) AND (IsVoyelleForte(c3)) THEN
            Replace(S,p,2,"je");
        ELSIF (c12=str2("au")) THEN
            Replace(S,p,2,"o");
        ELSIF (c123=str3("eau")) THEN
            Replace(S,p,3,"o");
        ELSIF (c12=str2("en")) AND (IsConsonne(c3)) THEN
            Replace(S,p,2,"an");
        ELSIF (c12=str2("em")) AND (IsConsonne(c3)) THEN
            Replace(S,p,2,"an");
        ELSIF (c12=str2("am")) AND (IsConsonne(c3)) THEN
            Replace(S,p,2,"an");
        ELSIF (c12=str2("im")) AND (IsConsonne(c3)) THEN
            Replace(S,p,2,"in");
        ELSIF (c12=str2("yn")) AND (IsConsonne(c3)) THEN
            Replace(S,p,2,"in");
        ELSIF (c12=str2("ym")) AND (IsConsonne(c3)) THEN
            Replace(S,p,2,"in");
        ELSIF (c12=str2("un")) AND (IsConsonne(c3)) THEN
            Replace(S,p,2,"in");
        ELSIF (c12=str2("um")) AND (IsConsonne(c3)) THEN
            Replace(S,p,2,"in");
        ELSIF (c123=str3("ain")) AND (IsConsonne(c4)) THEN
            Replace(S,p,3,"in");
        ELSIF (c123=str3("ein")) AND (IsConsonne(c4)) THEN
            Replace(S,p,3,"in");
        ELSIF (c12=str2("om")) AND (IsConsonne(c3)) THEN
            Replace(S,p,2,"on");
        ELSIF (c123=str3("ill")) AND (IsVoyelle(prev)) THEN
            Replace(S,p,3,"y");
        ELSIF (c1="y") THEN
            Replace(S,p,1,"i");
        ELSIF (c123=str3("cqu")) THEN
            Replace(S,p,3,"qu");
        ELSIF (c1="k") AND (IsVoyelleForte(prev)) AND (IsVoyelleForte(c2)) THEN
            Replace(S,p,1,"c");
        ELSE
            Str.Append(R,c1);
            prev:=c1;
            INC(p);
        END;
    END;
END CodePhonetic;

(* ------------------------------------------------------------ *)

(*
surprising results sometimes so beware : MoNaCo=MaNChe for instance
try SoundexAlt first and then compute Soundex ?
*)

PROCEDURE CodeSoundex (S : ARRAY OF CHAR; VAR R : ARRAY OF CHAR);
CONST
    Letters="abcdefghijklmnopqrstuvwxyz";
    Table = "017301800824550126730107077"; (* modified *)
VAR
    i,len,p : CARDINAL;
    char,prevcode,currcode : CHAR;
BEGIN
    len := Str.Length(S);
    IF len = 0 THEN
        Str.Copy(R,"");
        RETURN;
    END;
    Str.Copy(R,S[0]);
    prevcode := "";
    FOR i := 2 TO len DO
        char:=S[i-1];
        p:=Str.CharPos(Letters,char);
        IF p # MAX(CARDINAL) THEN
            currcode:=Table[p];
            (* ignore vowels and runs of identical codes *)
            IF (currcode # "0") AND (currcode # prevcode) THEN
                Str.Append(R,currcode);
                prevcode:=currcode;
            END;
        END;
    END;
END CodeSoundex;

(* ------------------------------------------------------------ *)

PROCEDURE CodeSoundexOrg (S : ARRAY OF CHAR; VAR R : ARRAY OF CHAR);
CONST
    Letters="abcdefghijklmnopqrstuvwxyz";
    Table = "012301200224550126230102022";
VAR
    i,len,p : CARDINAL;
    char,prevcode,currcode : CHAR;
BEGIN
    len := Str.Length(S);
    IF len = 0 THEN
        Str.Copy(R,"");
        RETURN;
    END;
    Str.Copy(R,S[0]);
    prevcode := "";
    FOR i := 2 TO len DO
        char:=S[i-1];
        p:=Str.CharPos(Letters,char);
        IF p # MAX(CARDINAL) THEN
            currcode:=Table[p];
            IF (currcode # "0") AND (currcode # prevcode) THEN
                Str.Append(R,currcode);
                prevcode:=currcode;
            END;
        END;
    END;
    (* original soundex is 4 chars long *)
    Str.Append(R,"0000");
    Str.Slice(R,R,0,4);
    UpperCase(R);
END CodeSoundexOrg;

(* ------------------------------------------------------------ *)

PROCEDURE isReadOnly (S : ARRAY OF CHAR) : BOOLEAN;
VAR
    entry : FIO.DirEntry;
    found : BOOLEAN;
BEGIN
    found := FIO.ReadFirstEntry(S,allfiles,entry);
    IF found = FALSE THEN RETURN FALSE; END;
    RETURN (aR IN entry.attr);
END isReadOnly;

(* ------------------------------------------------------------ *)

PROCEDURE LtrimBlanks (VAR S : ARRAY OF CHAR);
CONST
    espace=ORD(" ");
VAR
    i,len : CARDINAL;
BEGIN
    len := Str.Length (S);
    i   := 0;
    LOOP
        IF i = len THEN EXIT; END;
        IF ORD(S[i]) > espace THEN EXIT; END;
        INC (i);
    END;
    Str.Delete (S,0,i); (* procedure handles removal of i=0 *)
END LtrimBlanks;

(* ------------------------------------------------------------ *)

PROCEDURE RtrimBlanks (VAR S : ARRAY OF CHAR);
CONST
    espace=ORD(" ");
VAR
    i,len : CARDINAL;
BEGIN
    len := Str.Length (S);
    i   := len;
    LOOP
        IF i = 0 THEN EXIT; END;
        IF ORD(S[i-1]) > espace THEN EXIT; END;
        DEC (i);
    END;
    Str.Delete (S,i,len-i);
END RtrimBlanks;

(* ------------------------------------------------------------ *)

PROCEDURE getStrIndex (delimiter:CHAR;what,list: ARRAY OF CHAR) : CARDINAL;
VAR
    i   : CARDINAL;
    str : str80; (* option tested against s *)
    myList:str1024; (* long just in case *)
BEGIN
    Str.Concat(myList,list,delimiter);

    i := 0;
    LOOP
        Str.ItemS(str,myList,delimiter,i);
        IF Str.Length(str)=0 THEN RETURN 0; END;
        IF same(str,what) THEN RETURN (i+1); END;
        INC(i);
    END;
END getStrIndex;

(* ------------------------------------------------------------ *)

PROCEDURE BiosWaitkey (VAR c1,c2:CHAR);
BEGIN
    c1:=BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2:=BiosIO.RdKey();
    END;
END BiosWaitkey;

PROCEDURE BiosWaitkeyShifted (VAR c1,c2:CHAR;VAR shifted:BOOLEAN);
VAR
    pressed:CARDINAL;
BEGIN
    c1:=BiosIO.RdKey();

    pressed:=0;
    IF (BiosIO.RShift IN BiosIO.KBFlags()) OR (BiosIO.LShift IN BiosIO.KBFlags()) THEN
        INC(pressed);
    END;

    IF c1 = CHR(0) THEN
        c2:=BiosIO.RdKey();
    END;

    IF pressed # 0 THEN
        shifted:=TRUE;
    ELSE
        shifted:=FALSE;
    END;
END BiosWaitkeyShifted;

PROCEDURE BiosFlushkey ();
VAR
    c1,c2 : CHAR;
BEGIN
    WHILE ( BiosIO.KeyPressed() ) DO
        BiosWaitkey(c1,c2);
    END;
END BiosFlushkey;

(* ------------------------------------------------------------ *)

TYPE
    SetOfChars = SET OF CHAR;

PROCEDURE isoleItem(VAR R: ARRAY OF CHAR;
                    S: ARRAY OF CHAR; T: SetOfChars; N: CARDINAL);

VAR
    len,i,j,k:CARDINAL;
BEGIN
    len := Str.Length(S);
    i   := 0;
    WHILE ( (i<len) AND (N > 0) ) DO
        IF (S[i] IN T) THEN DEC(N); END;
        INC(i);
    END;
    (* i is at first char after separator *)
    j := i;
    WHILE ( (j<len) AND NOT (S[j] IN T) ) DO
        INC(j);
    END;
    k := 0;
    WHILE (i<j) DO
        R[k] := S[i];
        INC(k);
        INC(i);
    END;
    R[k]:=CHR(0);
END isoleItem;

(* now we can safely parse "a,b,c,,e" ! what about ",,c,d,e" ? *)
(* first element is 0 *)

PROCEDURE isoleItemS(VAR R: ARRAY OF CHAR;
                     S: ARRAY OF CHAR; T: ARRAY OF CHAR; N: CARDINAL);
VAR
    CS  : SetOfChars;
    len : CARDINAL;
BEGIN
    len := Str.Length(T);
    CS := SetOfChars{};
    WHILE len > 0 DO
        DEC(len);
        INCL(CS,T[len]);
    END;
    isoleItem(R,S,CS,N);
END isoleItemS;

(* ------------------------------------------------------------ *)

(*
    use dmpTTX this way :

    continue:=dmpTTX(Z,width,S,TRUE);
    WHILE continue DO
        WrStr(S);WrLn;
        continue:=dmpTTX(Z,width,S,FALSE);
    END;
*)

VAR
    basePos:CARDINAL;
    baseLen:CARDINAL;

PROCEDURE dmpTTX (paragraph:ARRAY OF CHAR;width:CARDINAL;
                  VAR S:ARRAY OF CHAR;firstcall:BOOLEAN) : BOOLEAN;
CONST
    blank=" ";
VAR
    len,count:CARDINAL;
BEGIN
    IF firstcall THEN
        basePos := 0;
        baseLen := Str.Length(paragraph); (* do not recalc it each time *)
    END;

    IF basePos = baseLen THEN RETURN FALSE; END; (* we're done now *)

    count:=width;
    IF (basePos+count) < baseLen THEN (* more than 'width' remaining chars *)
        LOOP
            IF paragraph[basePos+count]=blank THEN
                EXIT;
            END;
            DEC(count);
            IF count=0 THEN (* no space at all in string to get *)
                count:=width;
                EXIT;
            END;
        END;
        Str.Slice(S,paragraph,basePos,count); (* slice required portion *)
        INC(basePos,count); (* advance *)
        IF paragraph[basePos] = blank THEN INC(basePos); END; (* skip possible first space *)
    ELSE (* remaining chars are just 'width' or less *)
        Str.Slice(S,paragraph,basePos,baseLen-basePos);
        basePos:=baseLen; (* right on nullchar *)
    END;
    RETURN TRUE;
END dmpTTX;

(* ------------------------------------------------------------ *)

(* because IO.RdStr is limited to 80 chars !!! *)

PROCEDURE TerminalReadString(VAR string: ARRAY OF CHAR);
CONST
    maxLen = 256-2-1; (* better safe than sorry *)
VAR
    R : SYSTEM.Registers;
    H : CARDINAL;
    I : CARDINAL;
    InputBuffer : RECORD
       maxChars : BYTE;   (* maximum characters buffer can hold *)
       count    : BYTE;   (* number of characters actually read excluding CR *)
       Buffer   : str256; (* actual chars read including final CR *)
    END;
BEGIN

    H := HIGH(string); (* this is 0-based last useable INDEX, i.e. [2..6] gives 4 *)
    IF H > maxLen THEN
        InputBuffer.maxChars := BYTE(maxLen);
    ELSE
        InputBuffer.maxChars := BYTE(H);
    END;
    INC(InputBuffer.maxChars,2); (* size of full structure ! *)
    InputBuffer.count := BYTE(0);

    R.DS := Seg(InputBuffer);
    R.DX := Ofs(InputBuffer);
    R.AH := 0AH;
    Lib.Dos(R);

    I := CARDINAL(InputBuffer.count);
    IF I <= H  THEN
        string[I] := CHR(0);
    END;
    WHILE (I>0) DO
       DEC(I);
       string[I] := InputBuffer.Buffer[I];
    END;
    IO.WrLn;
END TerminalReadString;

(* ------------------------------------------------------------ *)

(*
   alternate to undocumented Lib.QueryDosVersion which returns a CARDINAL
   in BCD form, e.g. 600H for Novell DOS 7.0, 70AH pour Win95 DOS 7.10
*)

PROCEDURE getDosVersion ():CARDINAL; (* 6.00 is returned as 600H *)
VAR
    R             : SYSTEM.Registers;
    currmajor     : CARDINAL;
    currminor     : CARDINAL;
BEGIN
    R.AX := 3306H; (* get TRUE version number *)
    Lib.Dos(R);
    currmajor := CARDINAL(R.BL);
    currminor := CARDINAL(R.BH);
    RETURN ((currmajor << 8) + currminor);
END getDosVersion;

(* combine major and minor DOS version for comparison with getDosVersion *)

PROCEDURE DosVersion (major,minor:CARDINAL  ) : CARDINAL;
BEGIN
    RETURN ((major << 8) + minor);
END DosVersion;

PROCEDURE warning95 (  ) : BOOLEAN;
BEGIN
    RETURN (getDosVersion() >= DosVersion(7,0));
END warning95;

PROCEDURE runningWindows ():BOOLEAN;
VAR
    R  : SYSTEM.Registers;
BEGIN
    R.AX := 1600H;
    Lib.Intr(R,2FH);
    IF R.AL = 0 THEN RETURN FALSE; END;   (* neither Win3.X nor Win2.X running *)
    IF R.AL = 80H THEN RETURN FALSE; END; (* XMS 1.0 installed but no Windows running *)
    RETURN TRUE;
END runningWindows;

(* ------------------------------------------------------------ *)

(* use BIOS values to check if screen is 25x40, 25x80 or 43/50x80 *)

PROCEDURE chkClassicTextMode (  ) : BOOLEAN;
CONST
    minCol = 1;
    maxCol = 80;
    minRow = 1;
    maxRow = 50;
VAR
    vcols  [00040H:004AH] : CARDINAL;
    vrows  [00040H:0084H] : SHORTCARD; (* add 1 *)
    lastCol : CARDINAL;
    lastRow : CARDINAL;
    pb      : CARDINAL;
BEGIN
    lastCol := vcols;
    lastRow := CARDINAL(vrows)+1;
    pb := 0;
    CASE lastCol OF
    | 40,80 : (* ok *)
    ELSE
        INC(pb);
    END;
    CASE lastRow OF
    | 25,43,50 : (* ok *)
    ELSE
        INC(pb);
    END;
    RETURN (pb=0);
END chkClassicTextMode;

(*
    set video mode $03 just in case (see inter56)

 03h = T  80x25	 8x8   640x200	 16	  4   B800 CGA,PCjr,Tandy
     = T  80x25	 8x14  640x350	 16/64	  8   B800 EGA
     = T  80x25	 8x16  640x400	 16	  8   B800 MCGA
     = T  80x25	 9x16  720x400	 16	  8   B800 VGA
     = T  80x43	 8x8   640x350	 16	  4   B800 EGA,VGA [17]
     = T  80x50	 8x8   640x400	 16	  4   B800 VGA [17]
*)

PROCEDURE setClassicTextMode ( );
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AH := 00H;                (* SET VIDEO MODE *)
    R.AL := 03H;                (* video mode *)
    Lib.Intr(R,10H);            (* VIDEO interrupt *)
END setClassicTextMode;

(* ------------------------------------------------------------ *)

PROCEDURE getCurrentDirectory (VAR R : ARRAY OF CHAR);
VAR
    drive : SHORTCARD;
    unit  : CHAR;
BEGIN
    drive := FIO.GetDrive();
    unit  := CHR(drive + ORD("A") -1 );
    FIO.GetDir(drive,R); (* \path without trailing slash nor leading u: *)
    Str.Prepend(R,colon);
    Str.Prepend(R,unit); (* u:\path *)
    fixDirectory(R);     (* u:\path\ *)
END getCurrentDirectory;

PROCEDURE setReadWrite (S:ARRAY OF CHAR );
VAR
    R : SYSTEM.Registers;
    filename : str256;
    attribute : CARDINAL;
BEGIN
    Str.Copy(filename,S);
    filename[Str.Length(filename)] := CHR(0); (* silly safety for asciiz ! *)

    R.AX := 4300H;                            (* get file attributes *)
    R.DS := Seg(filename);
    R.DX := Ofs(filename);
    Lib.Dos(R);
    attribute := R.CX;
    (* assume everything goes without error ! *)

    (* clear bit 0 -- read-only --- : %1111111111111110 is $FFFE *)
    attribute := (attribute AND 0FFFEH);
    R.AX := 4301H;
    R.DS := Seg(filename);
    R.DX := Ofs(filename);
    R.CX := attribute;
    Lib.Dos(R);
END setReadWrite;

PROCEDURE setReadOnly (S:ARRAY OF CHAR );
VAR
    R : SYSTEM.Registers;
    filename : str256;
    attribute : CARDINAL;
BEGIN
    Str.Copy(filename,S);
    filename[Str.Length(filename)] := CHR(0); (* silly safety for asciiz ! *)

    R.AX := 4300H;                            (* get file attributes *)
    R.DS := Seg(filename);
    R.DX := Ofs(filename);
    Lib.Dos(R);
    attribute := R.CX;
    (* assume everything goes without error ! *)

    (* set bit 0 -- read-only --- : %0000000000000001 is $0001 *)
    attribute := (attribute OR 00001H);
    R.AX := 4301H;
    R.DS := Seg(filename);
    R.DX := Ofs(filename);
    R.CX := attribute;
    Lib.Dos(R);
END setReadOnly;

PROCEDURE getFileSize (S : ARRAY OF CHAR) : LONGCARD;
VAR
    hnd : FIO.File;
    fsize : LONGCARD;
BEGIN
    hnd := FIO.OpenRead (S);
    fsize := FIO.Size(hnd);
    FIO.Close(hnd);
    RETURN fsize;
END getFileSize;

(* ------------------------------------------------------------ *)

PROCEDURE verifyString (S,allowed:ARRAY OF CHAR):BOOLEAN;
VAR
    i,mismatches : CARDINAL;
    ch : CHAR;
BEGIN
    mismatches := 0;
    FOR i := 1 TO Str.Length(S) DO
        ch := S[i-1];
        IF Belongs(allowed,ch)=FALSE THEN INC(mismatches);END;
    END;
    RETURN (mismatches=0);
END verifyString;

(* ------------------------------------------------------------ *)

(* try and fix TopSpeed bug when tabs are in command line *)

PROCEDURE cleantabs (VAR S : ARRAY OF CHAR);
CONST
    tab=CHR(9);
VAR
    p : CARDINAL;
BEGIN
    LOOP
        p:=Str.CharPos(S,tab);
        IF p = MAX(CARDINAL) THEN EXIT; END;
        Str.Delete(S,p,1); (* delete unwanted tabulation *)
    END;
END cleantabs;

(* ------------------------------------------------------------ *)

PROCEDURE removeDups (VAR R : ARRAY OF CHAR);
VAR
    S : str80;
    u : CHAR;
    i : CARDINAL;
BEGIN
    Str.Copy(S,"");
    FOR i:=1 TO Str.Length(R) DO
        u:=R[i-1];
        IF Str.CharPos(S,u)=MAX(CARDINAL) THEN Str.Append(S,u);END;
    END;
    Str.Copy(R,S);
END removeDups;

(*
    we check if drive is OK thanks to GET FREE DISK SPACE -- see TOTAL.MOD
    in spite of its name, this procedure also finds valid CDROM units
    we don't avoid ugly DOS abort/retry/fail if there's no media in CDROM unit

PROCEDURE isValidHDunit (u:CHAR):BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AH := 036H;  (* DOS 2+ - GET FREE DISK SPACE *)
    R.DL := BYTE( ORD( CAP(u) )-ORD("A")+1 ); (* $00=default, $01=A:, etc. *)
    Lib.Dos(R);
    RETURN (R.AX # 0FFFFH);
END isValidHDunit;

*)

(*
    always returns $ff from Win9X : we'd have to use Win9X getExtDPB instead
    intlist says we'd get same unit access problem as GetFreeDiskSpace anyway...

PROCEDURE isValidHDunit (u:CHAR):BOOLEAN;
VAR
    R : SYSTEM.Registers;
    rc: BOOLEAN;
BEGIN
    R.AH := 32H; (* DOS 2+ - GET DOS DRIVE PARAMETER BLOCK FOR SPECIFIC DRIVE *)
    R.DL := BYTE( ORD( CAP(u) )-ORD("A")+1 ); (* $00=default, $01=A:, etc. *)
    Lib.Dos(R);
    CASE CARDINAL(R.AL) OF
    | 000H : rc:=TRUE; (* DS:BX -> Drive Parameter Block (DPB) *)
    | 0FFH : rc:=FALSE; (* invalid or network *)
    ELSE
             rc:=FALSE; (* should NOT happen *)
    END;
IO.WrStr(u); IO.WrStr(" $"); IO.WrHex( CARDINAL(R.AL),2));IO.WrLn;
    RETURN rc;
END isValidHDunit;

*)

(* a better idea might be to check $2152 list of lists *)

PROCEDURE isValidHDunit (u:CHAR):BOOLEAN;
VAR
    R : SYSTEM.Registers;
    rc: BOOLEAN;
BEGIN
    R.AX := 4408H; (* DOS 3.0+ - IOCTL - CHECK IF BLOCK DEVICE REMOVABLE *)
    R.BL := BYTE( ORD( CAP(u) )-ORD("A")+1 ); (* $00=default, $01=A:, etc. *)
    Lib.Dos(R);
    IF NOT(SYSTEM.CarryFlag IN R.Flags) THEN
        (* AX=0=removable, AX=1=fixed *)
        rc:=TRUE;
    ELSE
        rc:=FALSE;
    END;
(* IO.WrStr(u); IF rc THEN IO.WrStr("+");ELSE IO.WrStr("-"); END;IO.WrLn; *)
    RETURN rc;
END isValidHDunit;

PROCEDURE removePhantoms (VAR R : ARRAY OF CHAR);
VAR
    S : str80;
    i : CARDINAL;
    u : CHAR;
BEGIN
    Str.Copy(S,"");
    FOR i:=1 TO Str.Length(R) DO
        u:=CAP ( R[i-1] ); (* already done but... *)
        IF isValidHDunit( u ) THEN Str.Append(S, u ); END;
    END;
    Str.Copy(R,S); (* we may still get cdrom but eh... *)
END removePhantoms;

(* assume uppercase *)

PROCEDURE removeFloppies (VAR R : ARRAY OF CHAR);
BEGIN
    Str.Subst(R, "A","");
    Str.Subst(R, "B","");
END removeFloppies;

(* ripped from CDCMD *)

CONST
    multiplex = 02FH;

PROCEDURE getCDROMunits (VAR units:CARDINAL;VAR firstunit:CHAR);
VAR
    R : SYSTEM.Registers;
BEGIN
    units     := 0;
    firstunit := "?";
    R.AX      := 01500H;
    R.BX      := 00000H;
    Lib.Intr( R, multiplex);
    units     := R.BX;
    firstunit := CHR( ORD("A") + R.CX );
END getCDROMunits;

PROCEDURE getCDROMletters (VAR cdcount:CARDINAL; VAR firstunit:CHAR;
                          VAR S:ARRAY OF CHAR);
TYPE
    buftype = ARRAY [0..26-1] OF BYTE;
VAR
    buf:buftype;
VAR
    R : SYSTEM.Registers;
    i,v:CARDINAL;
    ch:CHAR;
BEGIN
    Str.Copy(S,"");

    getCDROMunits(cdcount,firstunit); (* safety *)
    IF cdcount < 1 THEN RETURN; END;

    R.AX := 0150DH;
    R.ES := Seg( buf[0] ); (* ADR() does not work ! weird... *)
    R.BX := Ofs( buf[0] );
    Lib.Intr( R, multiplex);
    FOR i:=1 TO cdcount DO
        ch:=CHR( ORD("A") + CARDINAL(buf[i-1]) );
        Str.Append(S,ch);
    END;
END getCDROMletters;

PROCEDURE removeCDROMs (VAR R:ARRAY OF CHAR);
VAR
    cdcount:CARDINAL;
    cdfirst:CHAR;
    sCDROMletters:str80;
    i : CARDINAL;
BEGIN
    getCDROMunits(cdcount,cdfirst);
    IF cdcount < 1 THEN RETURN; END;

    getCDROMletters(cdcount,cdfirst,sCDROMletters); (* uppercased *)
    FOR i:=1 TO cdcount DO
        Str.Subst(R, sCDROMletters[i-1],"");
    END;
END removeCDROMs;

(* filter out floppy/CDROM units *)

PROCEDURE getAllHDunits (VAR R : ARRAY OF CHAR);
VAR
    S:str80;
    i : CARDINAL;
BEGIN
    Str.Copy(S,"");
    FOR i:=ORD("A") TO ORD("Z") DO
        Str.Append(S, CHR(i) );
    END;
    removeFloppies (S);
    removeCDROMs   (S);
    removePhantoms (S);
    Str.Copy(R,S);
END getAllHDunits;

PROCEDURE getAllLegalUnits (okFloppy,okHD,okCDROM:BOOLEAN; VAR R : ARRAY OF CHAR);
VAR
    SF,ShD,SCD:str80;
    i:CARDINAL;
    u:CHAR;
    cdcount:CARDINAL;
    cdfirst:CHAR;
BEGIN
    SF:="AB"; (* assume A: and B: are always available *)

    getAllHDunits(ShD);

    getCDROMletters(cdcount,cdfirst,SCD); (* uppercased *)

    Str.Copy(R,"");
    IF okFloppy THEN Str.Append(R, SF); END;
    IF okHD     THEN Str.Append(R,ShD); END;
    IF okCDROM  THEN Str.Append(R,SCD); END;
END getAllLegalUnits;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(*
shame on you not to have thought of more than one value at a time !
shame on you for relying on an external library to parse a mere hex value !
really gone is your Apple ][ genius... :-(
bah, old age is coming faster than end of the world...
*)

(* assume : digits already filtered and uppercased, base = 10 or 16, hex=## *)

PROCEDURE charvalToStr (VAR R:ARRAY OF CHAR; base:CARDINAL; digits:ARRAY OF CHAR):BOOLEAN;

    MODULE hxhelper;

    EXPORT hx;

    PROCEDURE hx (ch:CHAR):CARDINAL;
    CONST
        val0 = ORD("0");
        valA = ORD("A");
    VAR
        v:CARDINAL;
    BEGIN
        v:=ORD(ch);
        IF v < valA THEN
            DEC(v, val0 );
        ELSE
            DEC(v, valA );
            INC(v, 10);
        END;
        RETURN v;
    END hx;

    END hxhelper;

CONST
    maxcharval = MAX(SHORTCARD);
VAR
    rc : BOOLEAN;
    i,len,v: CARDINAL;
BEGIN
    rc := TRUE;
    len:= Str.Length(digits);
    Str.Copy(R,"");
    CASE base OF
    | 10: (* filtered for 0..9 *)
        v:=0;
        i:=1;
        LOOP
            IF i > len THEN EXIT;END;
            v := (v * 10);
            INC( v , ( ORD( digits[i-1] ) - ORD("0") ) );
            rc := ( v <= maxcharval ); IF NOT(rc) THEN EXIT; END;
            INC(i);
        END;
        IF rc THEN rc := (v # 0); END;
        IF rc THEN Str.Copy( R, CHR(v) );END;
    | 16: (* filtered for 0..9 A..F *)
        (* IF len < 2 THEN Str.Prepend(digits,"0"); INC(len);END; done by caller *)
        IF ODD(len) THEN
            rc:=FALSE;
        ELSE
            i:=1;
            LOOP
                IF i > len THEN EXIT; END;
                v:=  ( hx(digits[i-1]) << 4 );
                INC(i);
                INC(v, hx(digits[i-1]) );
                INC(i);
                rc := (v # 0);
                IF NOT(rc) THEN EXIT; END;
                Str.Append(R, CHR(v) );
            END;
        END;
    END;
    RETURN rc;
END charvalToStr;

(*

n  p  q  -  /  '  

###    $##    x##

*)

PROCEDURE metaproc (VAR S : ARRAY OF CHAR):BOOLEAN;
VAR
    ch:CHAR;
    c2:str80; (* really oversized for safety *)
    len,i,base:CARDINAL;
    R,orgS:str128;
    str:str128; (* in case we overflow ! *)
    state : (waiting,gotesc,grabhex,grabdec);
    rc:BOOLEAN;
BEGIN
    Str.Copy(orgS,S); (* in case of an error, return original unmodified string *)
    len := Str.Length(S);
    R   := "";
    i   := 1;
    rc  := TRUE;
    state := waiting;
    LOOP
        IF i > len THEN EXIT; END;
        ch := S[i-1];
        CASE state OF
        | waiting:
            CASE ch OF
            | escCh :
                state := gotesc;
            ELSE
                Str.Append(R,ch);
            END;
        | gotesc:
            CASE ch OF
            | "x","X","$":Str.Copy(str,"");         state:=grabhex; base:=16;
            | "0".."9" :  Str.Copy(str,ch);         state:=grabdec; base:=10;
            | "n","N" :   Str.Append(R,nl);         state:=waiting;
            | "p","P" :   Str.Append(R,percent);    state:=waiting;
            | "q","Q" :   Str.Append(R,doublequote);state:=waiting;
            | "b","B" :   Str.Append(R,vbar);       state:=waiting;
            ELSE
                IF Str.CharPos(escSet,ch) = MAX(CARDINAL) THEN
                    DEC(i); (* esc+verbatim : go back to make verbatim the next *)
                ELSE
                    Str.Append(R,ch); (* esc+reserved char *)
                END;
                state:=waiting;
            END;
        | grabhex:
            CASE ch OF
            | "0".."9", "A".."F", "a".."f" :
                Str.Append(str, CAP(ch) ); (* uppercase ! *)
            | escCh:
                IF Str.Length(str) < 2 THEN Str.Prepend(str,"0");END; (* one char fix *)
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                state:=waiting; (* //FIX was gotesc *)
            ELSE
                IF Str.Length(str) < 2 THEN Str.Prepend(str,"0");END; (* one char fix *)
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                DEC(i); (* go back one char now to make it next *)
                state:=waiting;
            END;
        | grabdec:
            CASE ch OF
            | "0".."9" :
                Str.Append(str,ch);
            | escCh:
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                state:=waiting; (* //FIX was gotesc *)
            ELSE
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                DEC(i); (* go back one char now to make it next *)
                state:=waiting;
            END;
        END;
        INC(i);
    END;
    CASE state OF
    | grabhex:
        IF Str.Length(str) < 2 THEN Str.Prepend(str,"0");END; (* one char fix *)
        rc:=charvalToStr(c2,base,str);
        IF rc THEN Str.Append(R,c2); END;
    | grabdec:
        rc:=charvalToStr(c2,base,str);
        IF rc THEN Str.Append(R,c2); END;
    END;
    IF rc THEN
        Str.Copy(S,R);
    ELSE
        Str.Copy(S,orgS); (* restore original *)
    END;
    RETURN rc;
END metaproc;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE getCli (VAR S : ARRAY OF CHAR);
CONST
    nullchar = CHR(0);
VAR
    i : CARDINAL;
BEGIN
    i := 0;
    LOOP
        S[i] := Lib.CommandLine^[i];
        IF S[i] = nullchar THEN EXIT; END;
        INC(i);
    END;
    cleantabs(S); (* always remove tabs *)
END getCli;

(* we could use VAR cli as to go a little faster : nay, not even really faster in fact ! *)

PROCEDURE argc (cli : ARRAY OF CHAR; clean : BOOLEAN) : CARDINAL;
VAR
    state    : (empty,intoken,instring);
    cliLen   : CARDINAL;
    cliPos   : CARDINAL;
    argCount : CARDINAL;
    ch       : CHAR;
    code     : CARDINAL;
    arg      : str128;
    sdelim   : CARDINAL;
BEGIN
    IF clean THEN
        LtrimBlanks(cli);
        RtrimBlanks(cli);
    END;
    cliLen   := Str.Length(cli);
    cliPos   := 1;
    argCount := 0;
    state    := empty;
    LOOP
        IF cliPos > cliLen THEN EXIT; END;
        ch := cli[cliPos-1];
        code := ORD(ch);
        CASE state OF
        | empty :
            IF ( (code = ORD(doublequote)) OR (code=ORD(singlequote)) ) THEN
                sdelim:= code;
                state := instring;        (* begin new string *)
                Str.Copy(arg,ch);
                INC(argCount);
            ELSIF code > ORD(blank) THEN  (* quote already trapped *)
                state := intoken;         (* begin new token *)
                Str.Copy(arg,ch);
                INC(argCount);
            END;
        | intoken :
            IF ( (code = ORD(doublequote)) OR (code=ORD(singlequote)) ) THEN (* quote in token *)
                sdelim:= code; (* fix *)
                state := instring;        (* if string in parameter *)
                Str.Append(arg,ch);
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,ch);
            ELSE
                state := empty;           (* end of token *)
            END;
        | instring :
            IF code = sdelim THEN
                Str.Append(arg,ch);
                state := empty;           (* end of string *)
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,ch);
            ELSE
                Str.Append(arg,blank);    (* remove TAB and controls if any *)
            END;
        END;
        INC(cliPos);
    END;
    RETURN argCount;
END argc;

PROCEDURE argv (VAR argument : ARRAY OF CHAR;
                cli : ARRAY OF CHAR; n : CARDINAL; clean:BOOLEAN);
VAR
    state    : (empty,intoken,instring);
    cliLen   : CARDINAL;
    cliPos   : CARDINAL;
    argCount : CARDINAL;
    ch     : CHAR;
    code     : CARDINAL;
    arg      : str128;
    sdelim   : CARDINAL;
BEGIN
    IF ( (n < 1) OR (n > argc(cli,clean)) ) THEN
        Str.Copy(argument,"");
        RETURN;
    END;
    IF clean THEN
        LtrimBlanks(cli);
        RtrimBlanks(cli);
    END;
    cliLen   := Str.Length(cli);
    cliPos   := 1;
    argCount := 0;
    state    := empty;
    LOOP
        IF cliPos > cliLen THEN EXIT; END;
        ch := cli[cliPos-1];
        code := ORD(ch);
        CASE state OF
        | empty :
            IF n = argCount THEN EXIT; END; (* argV$ test *)
            IF ( (code = ORD(doublequote)) OR (code=ORD(singlequote)) ) THEN
                sdelim:= code;
                state := instring;        (* begin new string *)
                Str.Copy(arg,ch);
                INC(argCount);
            ELSIF code > ORD(blank) THEN  (* quote already trapped *)
                state := intoken;         (* begin new token *)
                Str.Copy(arg,ch);
                INC(argCount);
            END;
        | intoken :
            IF ( (code = ORD(doublequote)) OR (code=ORD(singlequote)) ) THEN (* quote in token *)
                sdelim:= code; (* fix *)
                state := instring;        (* if string in parameter *)
                Str.Append(arg,ch);
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,ch);
            ELSE
                state := empty;           (* end of token *)
            END;
        | instring :
            IF code = sdelim THEN
                Str.Append(arg,ch);
                state := empty;           (* end of string *)
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,ch);
            ELSE
                Str.Append(arg,blank);    (* remove TAB and controls if any *)
            END;
        END;
        INC(cliPos);
    END;
    Str.Copy(argument,arg);
END argv;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

BEGIN
    FIO.IOcheck:=FALSE; (* avoid nasty problem with file functions errors ! *)
END QD_Box.



(*

(* using list of list to access DPB should avoid unit access *)

PROCEDURE isValidHDunitwip (u:CHAR):BOOLEAN;
TYPE
    partialDPB = RECORD
        drivenumber           : BYTE; (* offset 00h : 00h = A:, 01h = B:, etc. *)
        unitnumber            : BYTE;
        bytespersector        : WORD;
        maxsectorwithincluser : BYTE;
        shiftcount            : BYTE;
        reservedsectors       : WORD;
        FATs                  : BYTE;
        rootentries           : WORD;
        firstusersector       : WORD;
        highestcluster        : WORD;
        sectorsperFAT         : BYTE;
        firstdirsector        : WORD;
        devdriveraddr         : FarADDRESS; (* DWORD *)
        mediaIDbyte           : BYTE;
        accessed              : BYTE;
        ptrNextDPB            : FarADDRESS; (* DWORD offset 18h	*)
        (* don't care about other data *)
    END;
VAR
    R : SYSTEM.Registers;
    rc: BOOLEAN;
BEGIN
    R.AH := 52H; (* DOS 2+ internal - "SYSVARS" - GET LIST OF LISTS *)
    Lib.Dos(R);
    (* ES:BX -> DOS list of lists : offset 00 is DWORD POINTER to first DPB *)
    (* now walk DPBs looking for specified unit *)
    //TODO
    RETURN rc;
END isValidHDunitwip;

*)
