(* ---------------------------------------------------------------
Title         Q&D MD5
Author        PhG
Overview      self-explanatory !
Notes         >= 386 !

              - assign fio buffer does not make program faster
              - increasing databuffer size does not make program faster

              vb30.arj

              md5c     16.92s
              md5test  17.46s
              mdx       1.75s  written in assembly or heavily optimized !
              md5demo  13.68s

              - differences between move/fastmove/wordmove are hardly noticeable
                at least on P4, whether from windowed 98SE or from text ND7 :
                8086 opt gives nothing OF course, but 80486 does NOT either !
                3 or 4% gain is not worth recompling anything

                           (windowed P4/98SE)        (P4/ND7 but different iterations and files)

                8086       = strings =   = files =    = strings =   = files =

              - move     : 35.59         10.16        6.86          28.29
              - fastmove : 35.59         10.27        6.87          28.28
              - wordmove : 35.59         10.21        6.87          28.29

                80486      = strings =   = files =

              - move     : 35.26          9.84
              - fastmove : 35.32          9.78
              - wordmove : 35.27          9.78

              curiouser and curiouser : in a real-world app (DD),
              WORDMOVE is 20% SLOWER than MOVE !!! go figure...

              - using inline code, MD5transform is slightly faster
              (4.29s vs 4.50s) but takes 12Kb more

Bugs
Wish List     assembly ? ah ah, only serious !

--------------------------------------------------------------- *)

IMPLEMENTATION MODULE QD_MD5;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;

(* ------------------------------------------------------------ *)

CONST
    useINLINE     = FALSE; (* T=slightly faster but more memory-hungry : about 12Kb taken *)
CONST
    useMOVE       = TRUE;
    useFASTMOVE   = FALSE;
    useWORDMOVE   = FALSE;

(* ------------------------------------------------------------ *)

TYPE
    statetype = RECORD
        CASE : BOOLEAN OF
        | TRUE : a,b,c,d: LONGCARD;
        | FALSE: digest : MD5digestType;
        END;
    END;
    count64type = RECORD
        lo,hi:LONGCARD;
    END;
    blocktype = ARRAY [0..15] OF LONGCARD; (* 0..63 BYTE *)
    pblock = POINTER TO blocktype; (* no generic POINTER TYPE ! *)
    MD5contextType = RECORD
        state : statetype;   (* ABCD *)
        count : count64type; (* bits modulo 2^64, lsb first *)
    END;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize      = (8 * 512) + FIO.BufferOverhead;
    firstioBufferByte = 1;
    lastioBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstioBufferByte..lastioBufferByte] OF BYTE;
VAR
    sourceBuffer : ioBufferType;

CONST
    firstDataByte = 0;
    lastDataByte  = 8*512-1; (* 4Kb + 64 *)
    dataBufferSize= lastDataByte - firstDataByte + 1;
TYPE
    dataBufferType = ARRAY [firstDataByte..lastDataByte+SIZE(blocktype)] OF BYTE; (* 8Kb+64 *)
VAR
    dataBuffer : dataBufferType; (* globerk *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    maphex = "0123456789abcdef"; (* already beautified for readability *)

(* 16 bytes to 32 chars *)

PROCEDURE MD5toString (VAR R:MD5str; digest:MD5digestType);
VAR
    i,v : CARDINAL;
    lo,hi:CHAR;
BEGIN
    Str.Copy(R,"");
    FOR i:=MD5firstDigestNdx TO MD5lastDigestNdx DO
        v:=CARDINAL( digest[i] );
        lo:=maphex[ v AND 0FH];
        hi:=maphex[ v >> 4 ];
        Str.Append(R,hi);
        Str.Append(R,lo);
    END;
END MD5toString;

(* assume legal 32 hex chars string has been checked to [0..9a..f] ! *)

PROCEDURE stringToMD5 (S:MD5str):MD5digestType;
VAR
    digest:MD5digestType;
    i,ndx,v,vlo,vhi:CARDINAL;
BEGIN
    Str.Lows(S); (* safety *)
    ndx:=0;
    FOR i:=MD5firstDigestNdx TO MD5lastDigestNdx DO
        vlo:=Str.CharPos(maphex,S[ndx]);    INC(ndx);
        vhi:=Str.CharPos(maphex,S[ndx+1]);  INC(ndx);
        v:=(vhi << 4 ) + vlo;
        digest[i]:=BYTE(v);
    END;
    RETURN digest;
END stringToMD5;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE MD5init (VAR ctx:MD5contextType;bytecount:LONGCARD);
BEGIN
    ctx.state.a := 067452301H;
    ctx.state.b := 0EFCDAB89H;
    ctx.state.c := 098BADCFEH;
    ctx.state.d := 010325476H;
    ctx.count.lo:=bytecount << 3;      (* x8 : bytes to bits *)
    ctx.count.hi:=bytecount >> (32-3); (* keep 3 upper bits *)
END MD5init;

(*# save *)
(*# call (inline_max => 8192)  *)
(*# call (inline=>on)  *)

PROCEDURE xor (v1,v2 : LONGCARD  ) : LONGCARD;
TYPE
    dBITSET = SET OF [0..31];
BEGIN
    RETURN LONGCARD( dBITSET(v1) / dBITSET(v2) );
END xor;

PROCEDURE ROTATE_LEFT( x, n: LONGCARD):LONGCARD ;
BEGIN
    RETURN  ( (x << n) OR (x >> (32-n)) );
END ROTATE_LEFT;

PROCEDURE FF (VAR a: LONGCARD; b,c,d,x,s,ac:LONGCARD);
BEGIN
    INC(a,  ( (b AND c) OR ((NOT (b)) AND d) )  +x+ac);
    a:=ROTATE_LEFT (a,s);
    INC(a,b);
END FF;

PROCEDURE GG (VAR a: LONGCARD; b,c,d,x,s,ac:LONGCARD);
BEGIN
    INC(a, ( (b AND d) OR (c AND (NOT (d))) ) +x+ac);
    a:=ROTATE_LEFT (a,s);
    INC(a,b);
END GG;

PROCEDURE HH (VAR a: LONGCARD; b,c,d,x,s,ac:LONGCARD);
BEGIN
    INC(a, xor(xor(b,c),d) +x+ac);
    a:=ROTATE_LEFT (a,s);
    INC(a,b);
END HH;

PROCEDURE II (VAR a: LONGCARD; b,c,d,x,s,ac:LONGCARD);
BEGIN
    INC(a, xor(c, (b OR (NOT (d)))) +x +ac);
    a:=ROTATE_LEFT (a,s);
    INC(a,b);
END II;

(*# restore *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(*%T useINLINE *)

CONST
    S11 = 7;
    S12 =12;
    S13 =17;
    S14 =22;
    S21 = 5;
    S22 = 9;
    S23 =14;
    S24 =20;
    S31 = 4;
    S32 =11;
    S33 =16;
    S34 =23;
    S41 = 6;
    S42 =10;
    S43 =15;
    S44 =21;

PROCEDURE MD5round1 (VAR a,b,c,d : LONGCARD; p:pblock);
BEGIN
(*# save *)
(*# call (inline_max => 8192)  *)
(*# call (inline=>on)  *)
    (* Round 1 *)
    FF (a, b, c, d, p^[ 0], S11, 0D76AA478H); (*  1 *)
    FF (d, a, b, c, p^[ 1], S12, 0E8C7B756H); (*  2 *)
    FF (c, d, a, b, p^[ 2], S13, 0242070DBH); (*  3 *)
    FF (b, c, d, a, p^[ 3], S14, 0C1BDCEEEH); (*  4 *)
    FF (a, b, c, d, p^[ 4], S11, 0F57C0FAFH); (*  5 *)
    FF (d, a, b, c, p^[ 5], S12, 04787C62AH); (*  6 *)
    FF (c, d, a, b, p^[ 6], S13, 0A8304613H); (*  7 *)
    FF (b, c, d, a, p^[ 7], S14, 0FD469501H); (*  8 *)
    FF (a, b, c, d, p^[ 8], S11, 0698098D8H); (*  9 *)
    FF (d, a, b, c, p^[ 9], S12, 08B44F7AFH); (* 10 *)
    FF (c, d, a, b, p^[10], S13, 0FFFF5BB1H); (* 11 *)
    FF (b, c, d, a, p^[11], S14, 0895CD7BEH); (* 12 *)
    FF (a, b, c, d, p^[12], S11, 06B901122H); (* 13 *)
    FF (d, a, b, c, p^[13], S12, 0FD987193H); (* 14 *)
    FF (c, d, a, b, p^[14], S13, 0A679438EH); (* 15 *)
    FF (b, c, d, a, p^[15], S14, 049B40821H); (* 16 *)
(*# restore *)
END MD5round1;

PROCEDURE MD5round2 (VAR a,b,c,d : LONGCARD; p:pblock);
BEGIN
(*# save *)
(*# call (inline_max => 8192)  *)
(*# call (inline=>on)  *)
    (* Round 2 *)
    GG (a, b, c, d, p^[ 1], S21, 0F61E2562H); (* 17 *)
    GG (d, a, b, c, p^[ 6], S22, 0C040B340H); (* 18 *)
    GG (c, d, a, b, p^[11], S23, 0265E5A51H); (* 19 *)
    GG (b, c, d, a, p^[ 0], S24, 0E9B6C7AAH); (* 20 *)
    GG (a, b, c, d, p^[ 5], S21, 0D62F105DH); (* 21 *)
    GG (d, a, b, c, p^[10], S22, 002441453H); (* 22 *)
    GG (c, d, a, b, p^[15], S23, 0D8A1E681H); (* 23 *)
    GG (b, c, d, a, p^[ 4], S24, 0E7D3FBC8H); (* 24 *)
    GG (a, b, c, d, p^[ 9], S21, 021E1CDE6H); (* 25 *)
    GG (d, a, b, c, p^[14], S22, 0C33707D6H); (* 26 *)
    GG (c, d, a, b, p^[ 3], S23, 0F4D50D87H); (* 27 *)
    GG (b, c, d, a, p^[ 8], S24, 0455A14EDH); (* 28 *)
    GG (a, b, c, d, p^[13], S21, 0A9E3E905H); (* 29 *)
    GG (d, a, b, c, p^[ 2], S22, 0FCEFA3F8H); (* 30 *)
    GG (c, d, a, b, p^[ 7], S23, 0676F02D9H); (* 31 *)
    GG (b, c, d, a, p^[12], S24, 08D2A4C8AH); (* 32 *)
(*# restore *)
END MD5round2;

PROCEDURE MD5round3 (VAR a,b,c,d : LONGCARD; p:pblock);
BEGIN
(*# save *)
(*# call (inline_max => 8192)  *)
(*# call (inline=>on)  *)
    (* Round 3 *)
    HH (a, b, c, d, p^[ 5], S31, 0FFFA3942H); (* 33 *)
    HH (d, a, b, c, p^[ 8], S32, 08771F681H); (* 34 *)
    HH (c, d, a, b, p^[11], S33, 06D9D6122H); (* 35 *)
    HH (b, c, d, a, p^[14], S34, 0FDE5380CH); (* 36 *)
    HH (a, b, c, d, p^[ 1], S31, 0A4BEEA44H); (* 37 *)
    HH (d, a, b, c, p^[ 4], S32, 04BDECFA9H); (* 38 *)
    HH (c, d, a, b, p^[ 7], S33, 0F6BB4B60H); (* 39 *)
    HH (b, c, d, a, p^[10], S34, 0BEBFBC70H); (* 40 *)
    HH (a, b, c, d, p^[13], S31, 0289B7EC6H); (* 41 *)
    HH (d, a, b, c, p^[ 0], S32, 0EAA127FAH); (* 42 *)
    HH (c, d, a, b, p^[ 3], S33, 0D4EF3085H); (* 43 *)
    HH (b, c, d, a, p^[ 6], S34, 004881D05H); (* 44 *)
    HH (a, b, c, d, p^[ 9], S31, 0D9D4D039H); (* 45 *)
    HH (d, a, b, c, p^[12], S32, 0E6DB99E5H); (* 46 *)
    HH (c, d, a, b, p^[15], S33, 01FA27CF8H); (* 47 *)
    HH (b, c, d, a, p^[ 2], S34, 0C4AC5665H); (* 48 *)
(*# restore *)
END MD5round3;

PROCEDURE MD5round4 (VAR a,b,c,d : LONGCARD; p:pblock);
BEGIN
(*# save *)
(*# call (inline_max => 8192)  *)
(*# call (inline=>on)  *)
    (* Round 4 *)
    II (a, b, c, d, p^[ 0], S41, 0F4292244H); (* 49 *)
    II (d, a, b, c, p^[ 7], S42, 0432AFF97H); (* 50 *)
    II (c, d, a, b, p^[14], S43, 0AB9423A7H); (* 51 *)
    II (b, c, d, a, p^[ 5], S44, 0FC93A039H); (* 52 *)
    II (a, b, c, d, p^[12], S41, 0655B59C3H); (* 53 *)
    II (d, a, b, c, p^[ 3], S42, 08F0CCC92H); (* 54 *)
    II (c, d, a, b, p^[10], S43, 0FFEFF47DH); (* 55 *)
    II (b, c, d, a, p^[ 1], S44, 085845DD1H); (* 56 *)
    II (a, b, c, d, p^[ 8], S41, 06FA87E4FH); (* 57 *)
    II (d, a, b, c, p^[15], S42, 0FE2CE6E0H); (* 58 *)
    II (c, d, a, b, p^[ 6], S43, 0A3014314H); (* 59 *)
    II (b, c, d, a, p^[13], S44, 04E0811A1H); (* 60 *)
    II (a, b, c, d, p^[ 4], S41, 0F7537E82H); (* 61 *)
    II (d, a, b, c, p^[11], S42, 0BD3AF235H); (* 62 *)
    II (c, d, a, b, p^[ 2], S43, 02AD7D2BBH); (* 63 *)
    II (b, c, d, a, p^[ 9], S44, 0EB86D391H); (* 64 *)
(*# restore *)
END MD5round4;

PROCEDURE MD5Transform (VAR state:statetype; p:pblock);
VAR
    a,b,c,d:LONGCARD;
BEGIN
    a:= state.a;
    b:= state.b;
    c:= state.c;
    d:= state.d;

    (* ts won't complain with its nasty isl pool problem now *)

    MD5round1 (a,b,c,d,p);
    MD5round2 (a,b,c,d,p);
    MD5round3 (a,b,c,d,p);
    MD5round4 (a,b,c,d,p);

    INC(state.a,a);
    INC(state.b,b);
    INC(state.c,c);
    INC(state.d,d);
END MD5Transform;

(*%E *)

(* ------------------------------------------------------------ *)

(*%F useINLINE *)

PROCEDURE MD5Transform (VAR state:statetype; p:pblock);
CONST
    S11 = 7;
    S12 =12;
    S13 =17;
    S14 =22;
    S21 = 5;
    S22 = 9;
    S23 =14;
    S24 =20;
    S31 = 4;
    S32 =11;
    S33 =16;
    S34 =23;
    S41 = 6;
    S42 =10;
    S43 =15;
    S44 =21;
VAR
    a,b,c,d:LONGCARD;
BEGIN
    a:= state.a;
    b:= state.b;
    c:= state.c;
    d:= state.d;

    (* Round 1 *)
    FF (a, b, c, d, p^[ 0], S11, 0D76AA478H); (*  1 *)
    FF (d, a, b, c, p^[ 1], S12, 0E8C7B756H); (*  2 *)
    FF (c, d, a, b, p^[ 2], S13, 0242070DBH); (*  3 *)
    FF (b, c, d, a, p^[ 3], S14, 0C1BDCEEEH); (*  4 *)
    FF (a, b, c, d, p^[ 4], S11, 0F57C0FAFH); (*  5 *)
    FF (d, a, b, c, p^[ 5], S12, 04787C62AH); (*  6 *)
    FF (c, d, a, b, p^[ 6], S13, 0A8304613H); (*  7 *)
    FF (b, c, d, a, p^[ 7], S14, 0FD469501H); (*  8 *)
    FF (a, b, c, d, p^[ 8], S11, 0698098D8H); (*  9 *)
    FF (d, a, b, c, p^[ 9], S12, 08B44F7AFH); (* 10 *)
    FF (c, d, a, b, p^[10], S13, 0FFFF5BB1H); (* 11 *)
    FF (b, c, d, a, p^[11], S14, 0895CD7BEH); (* 12 *)
    FF (a, b, c, d, p^[12], S11, 06B901122H); (* 13 *)
    FF (d, a, b, c, p^[13], S12, 0FD987193H); (* 14 *)
    FF (c, d, a, b, p^[14], S13, 0A679438EH); (* 15 *)
    FF (b, c, d, a, p^[15], S14, 049B40821H); (* 16 *)

    (* Round 2 *)
    GG (a, b, c, d, p^[ 1], S21, 0F61E2562H); (* 17 *)
    GG (d, a, b, c, p^[ 6], S22, 0C040B340H); (* 18 *)
    GG (c, d, a, b, p^[11], S23, 0265E5A51H); (* 19 *)
    GG (b, c, d, a, p^[ 0], S24, 0E9B6C7AAH); (* 20 *)
    GG (a, b, c, d, p^[ 5], S21, 0D62F105DH); (* 21 *)
    GG (d, a, b, c, p^[10], S22, 002441453H); (* 22 *)
    GG (c, d, a, b, p^[15], S23, 0D8A1E681H); (* 23 *)
    GG (b, c, d, a, p^[ 4], S24, 0E7D3FBC8H); (* 24 *)
    GG (a, b, c, d, p^[ 9], S21, 021E1CDE6H); (* 25 *)
    GG (d, a, b, c, p^[14], S22, 0C33707D6H); (* 26 *)
    GG (c, d, a, b, p^[ 3], S23, 0F4D50D87H); (* 27 *)
    GG (b, c, d, a, p^[ 8], S24, 0455A14EDH); (* 28 *)
    GG (a, b, c, d, p^[13], S21, 0A9E3E905H); (* 29 *)
    GG (d, a, b, c, p^[ 2], S22, 0FCEFA3F8H); (* 30 *)
    GG (c, d, a, b, p^[ 7], S23, 0676F02D9H); (* 31 *)
    GG (b, c, d, a, p^[12], S24, 08D2A4C8AH); (* 32 *)

    (* Round 3 *)
    HH (a, b, c, d, p^[ 5], S31, 0FFFA3942H); (* 33 *)
    HH (d, a, b, c, p^[ 8], S32, 08771F681H); (* 34 *)
    HH (c, d, a, b, p^[11], S33, 06D9D6122H); (* 35 *)
    HH (b, c, d, a, p^[14], S34, 0FDE5380CH); (* 36 *)
    HH (a, b, c, d, p^[ 1], S31, 0A4BEEA44H); (* 37 *)
    HH (d, a, b, c, p^[ 4], S32, 04BDECFA9H); (* 38 *)
    HH (c, d, a, b, p^[ 7], S33, 0F6BB4B60H); (* 39 *)
    HH (b, c, d, a, p^[10], S34, 0BEBFBC70H); (* 40 *)
    HH (a, b, c, d, p^[13], S31, 0289B7EC6H); (* 41 *)
    HH (d, a, b, c, p^[ 0], S32, 0EAA127FAH); (* 42 *)
    HH (c, d, a, b, p^[ 3], S33, 0D4EF3085H); (* 43 *)
    HH (b, c, d, a, p^[ 6], S34, 004881D05H); (* 44 *)
    HH (a, b, c, d, p^[ 9], S31, 0D9D4D039H); (* 45 *)
    HH (d, a, b, c, p^[12], S32, 0E6DB99E5H); (* 46 *)
    HH (c, d, a, b, p^[15], S33, 01FA27CF8H); (* 47 *)
    HH (b, c, d, a, p^[ 2], S34, 0C4AC5665H); (* 48 *)

    (* Round 4 *)
    II (a, b, c, d, p^[ 0], S41, 0F4292244H); (* 49 *)
    II (d, a, b, c, p^[ 7], S42, 0432AFF97H); (* 50 *)
    II (c, d, a, b, p^[14], S43, 0AB9423A7H); (* 51 *)
    II (b, c, d, a, p^[ 5], S44, 0FC93A039H); (* 52 *)
    II (a, b, c, d, p^[12], S41, 0655B59C3H); (* 53 *)
    II (d, a, b, c, p^[ 3], S42, 08F0CCC92H); (* 54 *)
    II (c, d, a, b, p^[10], S43, 0FFEFF47DH); (* 55 *)
    II (b, c, d, a, p^[ 1], S44, 085845DD1H); (* 56 *)
    II (a, b, c, d, p^[ 8], S41, 06FA87E4FH); (* 57 *)
    II (d, a, b, c, p^[15], S42, 0FE2CE6E0H); (* 58 *)
    II (c, d, a, b, p^[ 6], S43, 0A3014314H); (* 59 *)
    II (b, c, d, a, p^[13], S44, 04E0811A1H); (* 60 *)
    II (a, b, c, d, p^[ 4], S41, 0F7537E82H); (* 61 *)
    II (d, a, b, c, p^[11], S42, 0BD3AF235H); (* 62 *)
    II (c, d, a, b, p^[ 2], S43, 02AD7D2BBH); (* 63 *)
    II (b, c, d, a, p^[ 9], S44, 0EB86D391H); (* 64 *)

    INC(state.a,a);
    INC(state.b,b);
    INC(state.c,c);
    INC(state.d,d);
END MD5Transform;

(*%E *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* assume file exists ! *)

PROCEDURE ComputeMD5 (VAR digest:MD5digestType;S:ARRAY OF CHAR);
VAR
    hin:FIO.File;
    ndx:CARDINAL; (* assume less than 64Kb buffer *)
    got:CARDINAL;
    done:BOOLEAN;
    ctx:MD5contextType;
BEGIN
    hin:=FIO.OpenRead(S);
    FIO.AssignBuffer(hin,sourceBuffer);
    done:=FALSE;
    MD5init(ctx, FIO.Size(hin));
    REPEAT
         got:=FIO.RdBin(hin,dataBuffer,dataBufferSize);
         IF got # dataBufferSize THEN
             dataBuffer[got]:= 080H;
             INC(got);
             WHILE (got MOD 64) # 56 DO
                 dataBuffer[ got ] := 0;
                 INC(got);
             END;

             (*%T useMOVE  *)
             Lib.Move(     ADR(ctx.count), ADR(dataBuffer[got]), 8);
             (*%E  *)
             (*%T useFASTMOVE  *)
             Lib.FastMove( ADR(ctx.count), ADR(dataBuffer[got]), 8);
             (*%E  *)
             (*%T useWORDMOVE  *)
             Lib.WordMove( ADR(ctx.count), ADR(dataBuffer[got]), 8 DIV 2);
             (*%E  *)

             INC(got,8);
             done:=TRUE;
         END;
         ndx:=0;
         REPEAT
             MD5Transform( ctx.state, ADR(dataBuffer[ndx]) );
             INC(ndx, SIZE(blocktype));
         UNTIL ndx=got;
    UNTIL done;
    FIO.Close(hin);
    digest:=ctx.state.digest;
END ComputeMD5;

(* ------------------------------------------------------------ *)

(*

PROCEDURE MD5hashbuffer (VAR ctx:MD5contextType; count:CARDINAL);
VAR
    ndx:CARDINAL; (* assume less than 64Kb buffer *)
BEGIN
    MD5init(ctx, LONGCARD(count));
    dataBuffer[count]:=080H; (* always pad with at least a binary 1 *)
    INC(count);
    WHILE (count MOD 64) # 56 DO
         dataBuffer[count]:=0;
         INC(count);
    END;

    (*%T useMOVE *)
    Lib.Move     ( ADR(ctx.count), ADR(dataBuffer[count]), SIZE(ctx.count) );
    (*%E  *)
    (*%T useFASTMOVE *)
    Lib.FastMove ( ADR(ctx.count), ADR(dataBuffer[count]), SIZE(ctx.count) );
    (*%E  *)
    (*%T useWORDMOVE *)
    Lib.WordMove ( ADR(ctx.count), ADR(dataBuffer[count]), SIZE(ctx.count) DIV 2);
    (*%E  *)

    ndx:=0;
    INC(count,8);
    REPEAT
         MD5Transform( ctx.state, ADR(dataBuffer[ndx]) );
         INC(ndx, SIZE(blocktype));
    UNTIL ndx = count;
END MD5hashbuffer;

PROCEDURE MD5hashString (VAR digest:MD5digestType;S:ARRAY OF CHAR);
VAR
    count:BOOLEAN;
    ctx:MD5contextType;
BEGIN
    count:=Str.Length(S);
    Lib.Move( ADR(S), ADR(dataBuffer), count);
    MD5hashbuffer(ctx,count);
    digest:=ctx.state.digest;
END MD5hashString;

*)

(* ------------------------------------------------------------ *)

BEGIN
END QD_MD5.





