(* ---------------------------------------------------------------
Title         Q&D Day Month
Author        PhG
Overview
Notes         minimal error messages and checking, etc.
              shamelessly ripped public domain databases found everywhere
              (CDs, Internet, etc.)
Bugs
Wish List     are you kidding ? but well, isn't it already a joke to
              write such a little DOS (f)utility nowadays ? :-(

--------------------------------------------------------------- *)

MODULE DayMonth;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;
IMPORT IO;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_Text IMPORT
colortype, cursorshapetype, scrolltype,
ff, cr, lf, bs, tab, nl, mincolor, maxcolor,
BW40, CO40, BW80, CO80, CO80x43, CO80x50, MONO,
vesa80x60, vesa132x25, vesa132x43, vesa132x50, vesa132x60,
selectCursorEmulation,
setCursorShape,
handleVesa, setBrightPaper, setBlinkMode,
setFillChar, setFillInk, setFillPaper,
setFillInkPaper, setTxtInk, setTxtPaper, setTxtInkPaper, setWrapMode,
setUseBiosMode, setTabWidth, getScreenData, setWindow,
setMode, restoreMode,
gotoXY, xyToHtabVtab, home, setVisualPage, setActivePage,
scrollWindow, fillTextAttr, cls, writeStr, writeLn, getScreenWidth,
getScreenHeight, getScreenMinX, getScreenMinY, getScreenMaxX, getScreenMaxY,
getMinHtab, getMaxHtab, getMinVtab, getMaxVtab,
getWindowWidth, getWindowHeight,
initScreenConsole,
findInkPaperAtStartup, getInkAtStartup, getPaperAtStartup;

(* ------------------------------------------------------------ *)

CONST
    (* aliases for our own procedures *)
    WrStr ::= writeStr;
    WrLn  ::= writeLn;
    WrChar::= writeStr;
CONST
    inktext   = cyan;
    papertext = black;
    inktitle  = yellow;
    papertitle= black;

PROCEDURE colorhelp ();
BEGIN
    setTxtInk(getInkAtStartup());      (* was green *)
    setTxtPaper(getPaperAtStartup());  (* was black *)
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colorhelp;

PROCEDURE color (ink,paper:CARDINAL );
BEGIN
    setTxtInk   (VAL(colortype,ink));
    setTxtPaper (VAL(colortype,paper));
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END color;

(* ------------------------------------------------------------ *)

TYPE
    str160 = ARRAY [0..160-1] OF CHAR;
CONST
    ProgEXEname   = "DAYMONTH";
    ProgTitle     = "Q&D Day Month";
    ProgVersion   = "v1.1e";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    DATheader     = "DAYM_"; (* header for data files *)
    sEGO          = "EGO";
    sCAL          = "CAL";
    extEXE        = ".EXE";
    extDAT1       = ".DM";   (* normal data *)
    extDAT2       = ".DMX";  (* huge data, was ".DM_" *)
    today         = "*";
    dquote        = '"';
    msgWait       = "Hit any key to continue... ";
    kbdmsg        = "Hit any key to continue or Escape to abort... ";
    newlinemarker = "\n"; (* tss... *)
    markerlen     = 2;
    comment       = ";";
    rem           = "*";
CONST
    dash          = "-";
    space         = " ";
    semicolon     = ";";
    exclamation   = "!";
    question      = "?";
    comma         = ",";
CONST
    initpagingcounter = 1; (* account for message *)

(* ------------------------------------------------------------ *)

CONST
    errNone             = 0;
    errHelp             = 1;
    errOption           = 2;
    errParameter        = 3;
    errBadNumber        = 4;
    errInkRange         = 5;
    errPaperRange       = 6;
    errBadDMY           = 7;
    errMissingDate      = 8;
    errMissingFile      = 9;
    errNonsense         = 10;
    errWidthRange       = 11;
    errPaganEgotist     = 12;
    errPaganEgotistHuge = 13;
    errAborted          = 14;
    errMoreHelp         = 128;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" <"+today+"|date> [option]..."+nl+
nl+
"This program displays any birthday or event which occurred on specified date."+nl+
"The data files should be considered public domain, for they were gathered from"+nl+
"many contradictory and unchecked sources, filled with duplicates and errors."+nl+
nl+
"-k     paging (ignored if output redirected)"+nl+
"-w[w]  wait for final keypress (ignored if output redirected, -ww = -k -w)"+nl+
"-n     add a newline (CR+LF) in order to beautify display (useful with PEXEC)"+nl+
"-ni:#  normal ink [0..15] -- default is cyan"+nl+
"-np:#  normal paper [0..15] -- default is black"+nl+
"-hi:#  hilighted ink [0..15] -- default is yellow"+nl+
"-hp:#  hilighted paper [0..15] -- default is black"+nl+
"-b     monochrome BIOS output (no colors)"+nl+
"-fr    display date in French (useless, for data files are in English !)"+nl+
"-s     sort output by year"+nl+
"-nb    ignore birthdays"+nl+
"-nd    ignore deaths"+nl+
"-ne    ignore events"+nl+
"-a     use all entries found (including "+'"b", "d" and "s" prefixes)'+nl+
"-e     personal data only ("+DATheader+sEGO+" required)"+nl+
"-p[p]  pagan calendar ("+DATheader+sCAL+" required, -k ignored)"+nl+
"-l     add Latin date (-p option only, -pp = -p -l)"+nl+
'-x     use extra huge "'+extDAT2+'" files instead of normal "'+extDAT1+'" files'+nl+
"-f:#   frame type (0=none, 1=single, 2=double, 3=raw), default is 2"+nl+
"-w:#   set line width, default is screen width"+nl+
"-??    verbose help, including data file format"+nl+
nl+
"Dark [0..7] : black, blue, green, cyan, red, magenta, brown and gray."+nl+
"Bright [8..15] : gray, blue, green, cyan, red, magenta, yellow and white."+nl+
nl+
"Date may be specified as "+dquote+today+dquote+" for today (system date),"+nl+
'or as "day-month", "day/month" or "day month", the month being either a number'+nl+
"in the [1..12] range or the first three letters of its name."+nl+
nl+
'All "*'+extDAT1+'" and/or "*'+extDAT2+'" files must be located in '+ProgEXEname+extEXE+" directory :"+nl+
DATheader+"???"+" for the 12 months, "+DATheader+sEGO+" for personal data (optional), and"+nl+
DATheader+sCAL+" for pagan data (optional)."+nl+
nl+
"Options irrelevant to selected display (normal, huge or pagan) will be ignored."+nl+
nl+
"With DR-DOS 6.0 or Novell DOS 7.0, "+ProgEXEname+" can be called after each"+nl+
"external command by setting SET PEXEC=path\"+ProgEXEname+extEXE+" "+today+" -n and PROMPT $x$p$g"+nl;

    msgMoreHelp=nl+
"(* "+DATheader+"??? and "+DATheader+sEGO+" file format *)"+nl+
nl+
'Lines beginning with ";" are treated as remarks and ignored.'+nl+
'Date format is specified using either "*ddmmyyyy" or "*mmddyyyy".'+nl+
'First character is a code : "B" (birth), "S" (event) or "D" (death).'+nl+
"-a option forces lines beginning with a lower case code to be displayed."+nl+
nl+
"    Example :"+nl+
nl+
"    *mmddyyyy"+nl+
"    S1231     Last day of the year"+nl+
"    *ddmmyyyy"+nl+
"    B19 31928 Patrick McGoohan, acteur"+nl+
nl+
"(* "+DATheader+sCAL+" file format *)"+nl+
nl+
'Lines beginning with ";" are treated as remarks and ignored.'+nl+
'Each line is in "ddmm:text" format. In "text", "\n" code stands for a newline.'+nl+
nl+
"    Example :"+nl+
nl+
"    0101:Kalends of January, New Year's Day\n\nNew year's day."+nl;

VAR
    S : str256;
BEGIN
    colorhelp;
    CASE e OF
    | errHelp,errMoreHelp :
        WrStr(msgHelp);
        IF e=errMoreHelp THEN
            WrStr(msgMoreHelp);
            e:=errHelp;
        END;
    | errOption :
        Str.Concat(S,"Unknown "+dquote,einfo);Str.Append(S,dquote+" option !");
    | errParameter :
        Str.Concat(S,dquote,einfo);Str.Append(S,dquote+" is just one parameter too many !");
    | errBadNumber:
        Str.Concat(S,"Illegal value in "+dquote,einfo);Str.Append(S,dquote+" option !");
    | errInkRange:
        S := "Ink range is [0..15] !";
    | errPaperRange:
        S := "Paper range is [0..15] !";
    | errBadDMY:
        Str.Concat(S,"Illegal "+dquote,einfo);Str.Append(S,dquote+" date format !");
    | errMissingDate:
        S := "Missing required date parameter !";
    | errMissingFile:
        Str.Concat(S,"Missing "+dquote,einfo);Str.Append(S,dquote+" data file !");
    | errNonsense:
        S := "-nb, -nd and -ne options are mutually exclusive !";
    | errWidthRange:
        S := "Illegal line width !";
    | errPaganEgotist:
        S := "-p and -e options are mutually exclusive !";
    | errPaganEgotistHuge:
        S := "-p, -e and -x options are mutually exclusive !";
    | errAborted:
        S := "Aborted by user !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp : ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(*
    gregorian calendar rule : leap 366 years if divisible by 4
    but centurial years NOT divisible by 4 are common
    Leap years are divisible by 400, or by 4 and not by 100
    1900 is common, 2000 is leap
*)

PROCEDURE getDaysInFebruary (annee:CARDINAL):CARDINAL;
CONST
    common = 28;
    leap   = 29;
BEGIN
    IF (annee MOD 400) = 0 THEN RETURN leap; END;
    IF (((annee MOD 4) = 0) AND ((annee MOD 100) # 0)) THEN RETURN leap; END;
    RETURN common;
END getDaysInFebruary;

PROCEDURE getDaysInMonth (mois,annee:INTEGER):INTEGER;
TYPE
    daysinmonthtype = ARRAY [1..12] OF INTEGER;
CONST
    (*                    JanFevMarAprMayJunJulAugSepOctNovDec *)
    (*                     1  2  3  4  5  6  7  8  9 10 11 12  *)
    dpm = daysinmonthtype(31, 0,31,30,31,30,31,31,30,31,30,31);
VAR
    m : INTEGER;
BEGIN
    m:= dpm[mois];
    IF m=0 THEN m:=getDaysInFebruary(annee);END;
    RETURN m;
END getDaysInMonth;

PROCEDURE latinDate (jour,mois,annee:CARDINAL):str80;
CONST
    calendes = 1;
    nones    = 5;
    ides     = 13;
    veille   = "PRID.";
    sKAL     = "KAL.";
    sNON     = "NON.";
    sID      = "ID.";
CONST
    (* 31-13=18 so go to 20 for safety *)
    countLAT= veille+" III IV V VI VII VIII IX "+
              "X XI XII XIII XIV XV XVI XVII XVIII XIX XX";
    moisLAT = "IAN. FEB. MART. APR. MAI. IUN. "+
              "IUL. AUG. SEPT. OCT. NOV. DEC.";
VAR
    j,m,R:str80;
    v:CARDINAL;
BEGIN
    v:=mois-1;
    Str.ItemS(m,moisLAT," ",v);

    CASE jour OF
    | calendes :
        j:=sKAL;
    | calendes+1..nones-1:
        Str.Prepend(m,sNON);
        v:=(nones-jour)-1;
        Str.ItemS(j,countLAT," ",v);
        IF same(j,veille)=FALSE THEN Str.Prepend(j,"A.D."); END;
    | nones :
        j:=sNON;
    | nones+1..ides-1 :
        Str.Prepend(m,sID);
        v:=(ides-jour)-1;
        Str.ItemS(j,countLAT," ",v);
        IF same(j,veille)=FALSE THEN Str.Prepend(j,"A.D."); END;
    | ides :
        j:=sID;
    ELSE
        v:=getDaysInMonth(mois,annee);
        IF v < jour THEN
            j:="???";
        ELSE
            v:=((v+1)-jour)-1;
            Str.ItemS(j,countLAT," ",v);
        END;
        IF same(j,veille)=FALSE THEN Str.Prepend(j,"A.D."); END;
        INC(mois);
        IF mois > 12 THEN mois := 1; END;
        v:=mois-1;
        Str.ItemS(m,moisLAT," ",v);
        Str.Prepend(m,sKAL);
    END;
    IF j[Str.Length(j)-1] # "." THEN Str.Append(j," ");END;
    Str.Concat(R,j,m);
    RETURN R;
END latinDate;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    languagetype = (french,english);
    datetype = RECORD
        day   : CARDINAL;
        month : CARDINAL;
        year  : CARDINAL;
        dayOfWeek  : Lib.DayType;
    END;
    timetype = RECORD
        hours   : CARDINAL;
        minutes : CARDINAL;
        seconds : CARDINAL;
    END;

PROCEDURE getDateNow (VAR d : datetype);
VAR
    dayOfWeek : Lib.DayType;
BEGIN
    Lib.GetDate(d.year,d.month,d.day,d.dayOfWeek);
END getDateNow;

PROCEDURE getTimeNow (VAR t : timetype);
VAR
    hundredth : CARDINAL;
BEGIN
    Lib.GetTime(t.hours,t.minutes,t.seconds,hundredth);
END getTimeNow;

CONST
    jours = "Dimanche Lundi Mardi Mercredi Jeudi Vendredi Samedi";
    mois  = "janvier fvrier mars avril mai juin "+
            "juillet aot septembre octobre novembre dcembre";
    joursUS = "Sunday Monday Tuesday Wednesday Thursday Friday Saturday";
    moisUS  = "January February March April May June "+
              "July August September October November December";

CONST
    alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    digits   = "0123456789";
    slash    = "/";
    colon    = ":";
    dot      = ".";
    blank    = " ";
    zero     = "0";

PROCEDURE parseDate (S : ARRAY OF CHAR;
                     VAR date : datetype) : BOOLEAN;
CONST
    century  = 1900; (* should it be really 2000 now ? ;-) *)
CONST
    separator=dash;
    legaldateset = digits+separator+alphabet;
    mindd=1;
    maxdd=31;
    minmm=1;
    maxmm=12;
    minyy=1600; (* in case a very old event ! *)
    maxyy=2399; (* ah ah ! *)
VAR
    i : CARDINAL;
    R : str80;
    v : LONGCARD;
    ok: BOOLEAN;
BEGIN
    UpperCase(S); (* in case months would be letters *)

    ReplaceChar(S,slash,separator);
    IF CharCount(S,separator)=1 THEN (* "dd/mm", not "dd/mm/yy" *)
        (* bugfix : force current year, not our unfortunate birth year *)
        getDateNow(date);
        Str.CardToStr( LONGCARD(date.year), R, 10, ok);
        Str.Append(S,separator);
        Str.Append(S,R);         (* force current year, not our unfortunate birth year *)
    END;

    FOR i := 0 TO (Str.Length(S)-1) DO
        IF Str.CharPos(legaldateset,S[i])=MAX(CARDINAL) THEN RETURN FALSE; END;
    END;
    IF CharCount(S,separator) # 2 THEN RETURN FALSE; END;

    Str.ItemS(R,S,separator,0);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF (v < mindd) OR (v > maxdd) THEN RETURN FALSE; END;
    date.day := CARDINAL(v);

    Str.ItemS(R,S,separator,1);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN
        R[3]:=CHR(0); (* ignore after first three letters if any *)
        Str.Prepend(R,dash); (* fake command line parameter ! *)
        i := GetOptIndex(R,"JAN"+delim+"JAN"+delim+
                           "FEB"+delim+"FEV"+delim+
                           "MAR"+delim+"MAR"+delim+
                           "APR"+delim+"AVR"+delim+
                           "MAY"+delim+"MAI"+delim+
                           "JUN"+delim+"JUN"+delim+
                           "JUL"+delim+"JUI"+delim+
                           "AUG"+delim+"AOU"+delim+
                           "SEP"+delim+"SEP"+delim+
                           "OCT"+delim+"OCT"+delim+
                           "NOV"+delim+"NOV"+delim+
                           "DEC"+delim+"DEC");
        CASE i OF
        | 1..24 :
            v := LONGCARD(i+1) DIV 2;
        ELSE
            RETURN FALSE;
        END;
    END;
    IF (v < minmm) OR (v > maxmm) THEN RETURN FALSE; END;
    date.month := CARDINAL(v);

    Str.ItemS(R,S,separator,2);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF v < 100 THEN INC(v,century); END;
    IF (v < minyy) OR (v > maxyy) THEN RETURN FALSE; END;
    date.year := CARDINAL(v);
    RETURN TRUE;
END parseDate;

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str80;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str80;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    IF pad="" THEN RETURN S; END;
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

PROCEDURE substring (S1,S2:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    Str.Caps(S2);
    IF Str.Pos(S1,S2) # MAX(CARDINAL) THEN RETURN TRUE; END;
    Str.Lows(S2);
    IF Str.Pos(S1,S2) # MAX(CARDINAL) THEN RETURN TRUE; END;
    RETURN FALSE;
END substring;

PROCEDURE newstring (VAR R:ARRAY OF CHAR; old,new:ARRAY OF CHAR);
BEGIN
    Str.Caps(old);
    IF Str.Pos(R,old) # MAX(CARDINAL) THEN
        Str.Subst(R,old,new);
    ELSE
        Str.Lows(old);
        IF Str.Pos(R,old) = MAX(CARDINAL) THEN RETURN; END;
        Str.Subst(R,old,new);
    END;
END newstring;

PROCEDURE oldnew (sOld,sNew:ARRAY OF CHAR;VAR R:ARRAY OF CHAR);
BEGIN
    LOOP
        IF substring(R,sOld)=FALSE THEN EXIT;END;
        newstring(R,sOld,sNew);
    END;
END oldnew;

(*
    $dd     lundi..dimanche / monday..sunday
    $d      1..31 (ordinal)
    $0d     01..31
    $mm     janvier..dcembre / january..december
    $m      1..12
    $0m     01..12

    $yyyy   ####
    $yy     00..99

    !d      1er..31 (cardinal)
    !0d     1er..31

    $!      Latin date

*)

PROCEDURE formatDate(format:ARRAY OF CHAR;language:languagetype;
                     dmy:datetype;
                     VAR R : ARRAY OF CHAR  );
VAR
    S,T    : str16;
    pad    : CHAR;
    v      : CARDINAL;
BEGIN
    Str.Copy(R,format);

    v := ORD(dmy.dayOfWeek);
    CASE language OF
    | french:   Str.ItemS(T,jours," ",v);
    | english:  Str.ItemS(T,joursUS," ",v);
    END;
    oldnew("$dd",T,R);

    v:=dmy.day;
    pad := "";   oldnew("$d",    using(v,2,pad), R);
    pad := "0";  oldnew("$0d",   using(v,2,pad), R);

    IF v=1 THEN
    pad := "";   oldnew("!d",    "1er"         , R);
    pad := "0";  oldnew("!0d",   "1er"         , R);
    ELSE
    pad := "";   oldnew("!d",    using(v,2,pad), R);
    pad := "0";  oldnew("!0d",   using(v,2,pad), R);
    END;

    v := dmy.month-1;
    CASE language OF
    | french:   Str.ItemS(T,mois," ",v);
    | english:  Str.ItemS(T,moisUS," ",v);
    END;
    oldnew("$mm",T,R);

    v := dmy.month;
    pad := "";  oldnew("$m",    using(v,2,pad), R);
    pad := "0"; oldnew("$0m",   using(v,2,pad), R);

    v := dmy.year;
    pad := "";  oldnew("$yyyy", using(v,4,pad), R);
    pad := "0";
    IF v >= 1900 THEN (* always here *)
        v  := dmy.year - 1900;IF v > 100 THEN DEC(v,100);END;
    END;
                oldnew("$yy",   using(v,2,pad), R);

    oldnew ("$!", latinDate(dmy.day,dmy.month,dmy.year), R);

END formatDate;

(*
    h      0..23
    0h     00..23
    m      0..59
    0m     00..59
    s      0..59
    0s     00..59
*)

PROCEDURE formatTime (format:ARRAY OF CHAR;language:languagetype;
                      hms:timetype;
                      VAR R : ARRAY OF CHAR  );
VAR
    S,T    : str16;
    pad    : CHAR;
    v      : CARDINAL;
BEGIN

    v := hms.hours;
    pad := "";   oldnew("h",    using(v,2,pad), R);
    pad := "0";  oldnew("0h",   using(v,2,pad), R);

    v := hms.minutes;
    pad := "";   oldnew("m",    using(v,2,pad), R);
    pad := "0";  oldnew("0m",   using(v,2,pad), R);

    v := hms.seconds;
    pad := "";   oldnew("s",    using(v,2,pad), R);
    pad := "0";  oldnew("0s",   using(v,2,pad), R);

END formatTime;

PROCEDURE formatNowFormat (format:ARRAY OF CHAR;language:languagetype;
                           dmy:datetype;
                           VAR R : ARRAY OF CHAR);
VAR
    hms:timetype;
BEGIN
    formatDate(format,language,dmy,R);
    getTimeNow(hms); (* let's hope we don't cross midnight ! ;-) maybe we should reread date ! *)
    formatTime(format,language,hms,R);
END formatNowFormat;

PROCEDURE fmtHeader (language:languagetype;dmy:datetype;
                     usebirths,useevents:BOOLEAN ):str80;
CONST
    pad = "0";
    defaultFmtFR  = "!d $mm";
    defaultFmtUS  = "$mm $d";
VAR
    R : str80;
BEGIN
    Str.Copy(R,"");
    CASE language OF
    | french:
        formatDate(defaultFmtFR,french,dmy,R);
        IF usebirths AND NOT(useevents) THEN
            Str.Prepend(R,"Qui est n le ");
        ELSE
            Str.Prepend(R,"Qu'est-il arriv le ");
        END;
    | english:
        formatDate(defaultFmtUS,english,dmy,R);
        IF usebirths AND NOT(useevents) THEN
            Str.Prepend(R,"Who was born on ");
        ELSE
            Str.Prepend(R,"What happened on ");
        END;
    END;
    Str.Append(R," ?");
    RETURN R;
END fmtHeader;

(* ------------------------------------------------------------ *)

(*
winalw *.dat format is :

*mmddyyyy Birthdays
*-------- ------------------------------------------------------------
B01011735 Paul Revere
B0105     Sherlock Holmes
B01061811 Charles Sumner, leading Reconstruction Senator
B01101877 Frederick Gardner Cottrell, invented the elecrostatic
B01101877Cprecipitator, used for polution control and air ionizers.
B01111755 Alexander Hamilton, the 1st Secretary of the US Treasury
*mmddyyyy Events
*-------- ------------------------------------------------------------
S01011934 Alcatraz officially becomes a Federal Prison.
S0101     The start of a new year!
S0101     Independence Day, celebrated in Haiti and Sudan
S01031852 first Chinese arrive in Hawaii.
S01061914 Stock brokerage firm of Merrill Lynch founded.
S0106    SArizona becomes the 47th state.
S0106     Epiphany (Twelfth Night in England)
S01071610 Galileo discovers the 4 major moons of Jupiter.

some codes will be ignored (but Continuation is handled)
*)

CONST
    IObufferSize = (8 * 512) + FIO.BufferOverhead;
VAR
    IObuffer : ARRAY [1..IObufferSize] OF BYTE;

TYPE
    str8   = ARRAY [0..7] OF CHAR;
    linetype = RECORD (* almost oversized strings anyway ! *)
        s1 : str8;
        s2 : str8;
        s3 : str160; (* was str80 but we allow long data now, str256 was too much *)
    END;
CONST
    firstEntry = 1;
    maxEntry   = 350; (* was 100, then 240 : pointers needed now ! *)
VAR
    line : ARRAY [firstEntry..maxEntry] OF linetype;

PROCEDURE less (i,j:CARDINAL):BOOLEAN ;
BEGIN
    RETURN (Str.Compare(line[i].s2,line[j].s2) < 0);
END less;

PROCEDURE swap (i,j:CARDINAL);
VAR
    tmp : linetype;
BEGIN
    tmp := line[i];
    line[i]:=line[j];
    line[j]:=tmp;
END swap;

PROCEDURE waitAndSee (VAR rowcount:CARDINAL; lastRow:CARDINAL):BOOLEAN;
CONST
    funckey = CHR(0);
    echapkey= CHR(27);
VAR
    c1,c2:CHAR;
BEGIN
    INC(rowcount);
    IF rowcount >= lastRow THEN (* = is enough but who knows what evil lurks in the heart of BIOS *)
        rowcount := initpagingcounter;
        video(kbdmsg,TRUE);
        Flushkey;
        BiosWaitkey(c1,c2);
        video(kbdmsg,FALSE);
        IF c1 = echapkey THEN
            RETURN FALSE;
        END;
    END;
    RETURN TRUE;
END waitAndSee;

(* ------------------------------------------------------------ *)

PROCEDURE dmpData ( paging,sort,fullbase,
                    usebirths,usedeaths,useevents,egotist,redirection:BOOLEAN;
                    datafile,privatefile:ARRAY OF CHAR;dmy:datetype;
                    language:languagetype;
                    ink,paper,hiink,hipaper,LineWidth:CARDINAL) : BOOLEAN;
CONST (* lucky english is sometimes so compact ! *)
    usformat     = rem+"MMDDYYYY";
    frformat     = rem+"DDMMYYYY";
    sDiedUS      = "Died ";
    sBornUS      = "Born ";
    sInUS        = "  In ";
    sDiedFR      = "Mort ";
    sBornFR      = "++++ "; (* n(e) ou naissance won't fit 4 chars ! *)
    sInFR        = "  En ";
    sPadContinue = "     ";
    sYYYYempty   = "    ";
    sYYYYunknown = "????";

    sThisUS      = "It's ";
    sThisFR      = "  De ";
    sIsUS        = "also";
    sIsFR        = "plus";

    sRienFR      = "Rien  afficher !"; (* "Rien." was royal but did not fit birthdays ! *)
    sRienUS      = "No data to display !";
VAR
    md   : str16;
    mmdd,yyyy : str16;
    s1,s2 : str8; (* enough room for "born " and "yyyy "*)
    s3,S,R  : str256; (* we may need a long original string *)
    hnd  : FIO.File;	
    firsttime,include,glue,overflow,done,rc:BOOLEAN;
    i,p,lastentry,dumped,lastRow,rowcount : CARDINAL;
    dateformat : (mmddyyyy,ddmmyyyy);
    msgBorn,msgDied,msgIn,msgThis,msgIs:str8;
    msgRien:str80;
BEGIN
    lastRow  := getWindowHeight();
    rowcount := initpagingcounter;

    CASE language OF
    | english:
        msgBorn :=sBornUS;
        msgDied :=sDiedUS;
        msgIn   :=sInUS;
        msgThis :=sThisUS;
        msgIs   :=sIsUS;
        msgRien :=sRienUS;
    | french:
        msgBorn :=sBornFR;
        msgDied :=sDiedFR;
        msgIn   :=sInFR;
        msgThis :=sThisFR;
        msgIs   :=sIsFR;
        msgRien :=sRienFR;
    END;

    Str.Concat(md,using(dmy.month,2,zero),using(dmy.day,2,zero));

    IF sort THEN
        lastentry := firstEntry - 1;
        overflow  := FALSE;
    END;

    dumped := 0;

    firsttime := TRUE;

                    IF firsttime THEN
                        color(hiink,hipaper);
                        Str.Copy(s3,fmtHeader(language,dmy,usebirths,useevents));
                        WrStr(s3);
                        color(ink,paper);
                        WrLn;
                        rc:=waitAndSee(rowcount,lastRow);
                        IF rc=FALSE THEN RETURN FALSE;END;
                        WrLn;
                        rc:=waitAndSee(rowcount,lastRow);
                        IF rc=FALSE THEN RETURN FALSE;END;

                        firsttime:=FALSE;
                    END;

    IF egotist THEN
        i:=2; (* directly start with personal data file *)
    ELSE
        i:=1;
    END;


    LOOP
        IF i > 2 THEN EXIT; END;
        CASE i OF
        | 1 : Str.Copy(S,datafile);
        | 2 : IF FIO.Exists(privatefile)=FALSE THEN EXIT; END;
              Str.Copy(S,privatefile);
        END;
        dateformat := mmddyyyy; (* default is obviously US *)
        hnd := FIO.OpenRead(S);
        FIO.AssignBuffer(hnd,IObuffer);
        FIO.EOF := FALSE;
        LOOP
            IF FIO.EOF THEN EXIT;END;
            FIO.RdStr(hnd,S); (* "?mmddyyyy ..." *)
            LtrimBlanks(S);
            RtrimBlanks(S);
            CASE S[0] OF
            | CHR(0) : ;(* nada *)
            | comment : ;(* nada either *)
            | rem :
                Str.Caps(S);
                IF Str.Pos(S,usformat)=0 THEN
                    dateformat := mmddyyyy;
                ELSIF Str.Pos(S,frformat)=0 THEN
                    dateformat := ddmmyyyy;
                END;
            ELSE
                IF dateformat = mmddyyyy THEN
                    Str.Slice(mmdd,S,1,4);
                ELSIF dateformat = ddmmyyyy THEN
                    Str.Slice(s1,S,3,2);
                    Str.Slice(s2,S,1,2);
                    Str.Concat(mmdd,s1,s2);
                END;
                ReplaceChar(mmdd,blank,zero); (* just in case... *)
                Str.Slice(yyyy,S,5,4);
                ReplaceChar(yyyy,dash,question); (* just in case... *)
                IF same(mmdd,md) THEN
                    (* we no longer remain silent when no data is available !
                    IF firsttime THEN
                        color(hiink,hipaper);
                        Str.Copy(s3,fmtHeader(language,dmy,usebirths,useevents));
                        WrStr(s3);
                        color(ink,paper);
                        WrLn;
                        rc:=waitAndSee(rowcount,lastRow);
                        IF rc=FALSE THEN RETURN FALSE;END;
                        WrLn;
                        rc:=waitAndSee(rowcount,lastRow);
                        IF rc=FALSE THEN RETURN FALSE;END;

                        firsttime:=FALSE;
                    END;
                    *)
                    include:=TRUE;
                    glue   :=FALSE;
                    CASE S[9] OF
                    | "C" :          (* continue *)
                        s1 := sPadContinue;
                        s2 := sYYYYempty;
                        glue := TRUE;
                        (* avoid glueing to previous entry : check 15 June ! *)
                        CASE S[0] OF
                        | "B","b" : IF NOT(usebirths)  THEN include:=FALSE;END;
                        | "D","d" : IF NOT(usedeaths)  THEN include:=FALSE;END;
                        | "S","s" : IF NOT(useevents)  THEN include:=FALSE;END;
                        END;
                        IF NOT(fullbase) THEN
                            CASE S[0] OF
                            | "b","d","s": include:=FALSE;
                            END;
                        END;
                    | " " :          (* new entry *)
                        Str.Copy(s2,yyyy);
                        CASE S[0] OF
                        | "B","b" :
                            s1 := msgBorn;
                            IF same(yyyy,sYYYYempty) THEN s2:=sYYYYunknown;END;
                            IF NOT(usebirths) THEN include:=FALSE;END;
                        | "D","d" :
                            s1 := msgDied;
                            IF same(yyyy,sYYYYempty) THEN s2:=sYYYYunknown;END;
                            IF NOT(usedeaths) THEN include:=FALSE;END;
                        | "S","s" :
                            s1 := msgIn;
                            IF same(yyyy,sYYYYempty) THEN s1:=msgThis;s2:=msgIs;END;
                            IF NOT(useevents) THEN include:=FALSE;END;
                        END;
                        IF NOT(fullbase) THEN
                            CASE S[0] OF
                            | "b","d","s": include:=FALSE;
                            END;
                        END;
                    ELSE             (* ignore day -- 6=friday, etc. *)
                        include:=FALSE;
                    END;
                    IF include THEN
                        Str.Delete(S,0,10);
                        LtrimBlanks(S); (* just in case *)
                        RtrimBlanks(S);
                        IF sort THEN
                            IF lastentry < maxEntry THEN
                                IF glue THEN
                                    Str.Append(line[lastentry].s3,newlinemarker);
                                    Str.Append(line[lastentry].s3,S);
                                ELSE
                                    INC(lastentry);
                                    Str.Copy(line[lastentry].s1,s1);
                                    Str.Copy(line[lastentry].s2,s2);
                                    Str.Copy(line[lastentry].s3,S);
                                END;
                            ELSE
                                overflow:=TRUE;
                            END;
                        ELSE
                            color(ink,paper);
                            WrStr(s1);
                            color(hiink,hipaper);
                            WrStr(s2);
                            color(ink,paper);
                            WrStr(" ");
                            WrStr(S);

                            IF redirection THEN
                                WrLn;
                            ELSE
                                Str.Concat(R,s1,s2);Str.Append(R,S);
                                (* R+space vs screen, # and not < *)
                                IF (Str.Length(R)+1) # LineWidth THEN WrLn; END;
                            END;
                        END;
                        INC(dumped); (* whether stored or sent to screen *)
                        IF NOT(sort) THEN
                            IF paging THEN
                                rc:=waitAndSee(rowcount, lastRow);
                                IF rc=FALSE THEN
                                    FIO.Close(hnd);
                                    RETURN FALSE;
                                END;
                            END;
                        END;
                    END;
                END;
            END;
        END;
        FIO.Close(hnd);
        INC(i);
    END;
    IF (sort AND (lastentry > firstEntry)) THEN
        IF overflow=FALSE THEN Lib.QSort(lastentry,less,swap); END;
        FOR i := firstEntry TO lastentry DO
             (* too bad if original data contained \n ! ;-) *)
             Str.Copy(s1,line[i].s1);
             Str.Copy(s2,line[i].s2);
             Str.Copy(S ,line[i].s3);
             REPEAT
                 p:=Str.Pos(S,newlinemarker);
                 IF p = MAX(CARDINAL) THEN
                     done:=TRUE;
                     Str.Copy(s3,S);
                 ELSE
                     done:=FALSE;
                     Str.Slice(s3,S,0,p);
                     Str.Delete(S,0,p+markerlen);
                 END;

                 color(ink,paper);     WrStr(s1);
                 color(hiink,hipaper); WrStr(s2);
                 color(ink,paper);     WrStr(" "); WrStr(s3);

                 IF redirection THEN
                     WrLn;
                 ELSE
                     Str.Concat(R,s1,s2);Str.Append(R,S);
                     (* R+space vs screen, # and not < *)
                     IF (Str.Length(R)+1) # LineWidth THEN WrLn; END;
                 END;

                 IF paging THEN
                     rc:=waitAndSee(rowcount, lastRow);
                     IF rc=FALSE THEN RETURN FALSE;END;
                 END;

                 Str.Copy(s1,sPadContinue);
                 Str.Copy(s2,sYYYYempty);
             UNTIL done;
        END;
        IF overflow THEN
             WrLn;WrStr("Warning ! There was not enough room for all data !");WrLn;
        END;
    END;
    IF dumped = 0 THEN
        WrStr(msgRien);WrLn;
    END;
    RETURN TRUE;
END dmpData;

(* ------------------------------------------------------------ *)

PROCEDURE pack (VAR S : ARRAY OF CHAR;older,newer:ARRAY OF CHAR);
BEGIN
    LOOP
        IF Str.Pos(S,older)=MAX(CARDINAL) THEN EXIT; END;
        Str.Subst(S,older,newer);
    END;
END pack;

(*
    almost useless, for data was already verified,
    but as our dmpTTX proc does not check punctuation marks...
*)

PROCEDURE cleanstring (VAR S : ARRAY OF CHAR);
BEGIN
    pack(S,space+space      ,space);
    pack(S,space+semicolon  ,semicolon);
    pack(S,space+exclamation,exclamation);
    pack(S,space+question   ,question);
    pack(S,space+comma      ,comma);
END cleanstring;

CONST
    mincolumns  = 1+1+1+1+1;
    frameNone   = 0;
    frameSingle = 1;
    frameDouble = 2;
    frameRaw    = 3;
    minframe    = frameNone;
    maxframe    = frameRaw;
    (*            012345     *)
    sSingle    = "ڳ";
    sDouble    = "ɺͼ";
    sNone      = "      ";
    wiHORIZ    = 4; (* bar, space, ... , space, bar *)
    wiHORIZalt = 2; (* space, ... , space *)
CONST
    firstline = firstEntry;
    maxline   = maxEntry;

PROCEDURE formatSentence (LineWidth,doFrame:CARDINAL;
                          VAR lastline,longest:CARDINAL;S:ARRAY OF CHAR):BOOLEAN;
VAR
    tmplen            : CARDINAL;
    tmp               : str256;   (* could be str128 but... *)
    splitagain        : BOOLEAN;
    p                 : CARDINAL;
    Z                 : str2048;  (* just in case *)
BEGIN
    cleanstring(S);

    CASE doFrame OF
    | frameRaw :
        ;
    | frameNone:
        DEC(LineWidth,wiHORIZalt);  (* string + 2 spaces *)
    ELSE
        DEC(LineWidth,wiHORIZ);     (* string + 2 spaces + 2 bars *)
    END;

    lastline  := firstline-1;
    longest   := 0;

    LOOP
        p:=Str.Pos(S,newlinemarker);
        IF p = MAX(CARDINAL) THEN EXIT; END;
        Str.Slice(Z,S,0,p);
        Str.Delete(S,0,p+1+1); (* "\n" CRLF marker takes two characters *)

        splitagain:=dmpTTX(Z,LineWidth,tmp,TRUE);
        WHILE splitagain DO
            Str.Copy(line[firstline+lastline].s3,tmp);
            tmplen:=Str.Length(tmp);
            IF tmplen > longest THEN longest := tmplen; END;
            INC(lastline);
            IF lastline >= maxline THEN RETURN FALSE; END;
            splitagain:=dmpTTX(Z,LineWidth,tmp,FALSE);
        END;
        IF Str.Pos(S,newlinemarker)=0 THEN
            Str.Copy(line[firstline+lastline].s3, "");
            INC(lastline);
            IF lastline >= maxline THEN RETURN FALSE; END;
        END;
    END;

        splitagain:=dmpTTX(S,LineWidth,tmp,TRUE);
        WHILE splitagain DO
            Str.Copy(line[firstline+lastline].s3,tmp);
            tmplen:=Str.Length(tmp);
            IF tmplen > longest THEN longest := tmplen; END;
            INC(lastline);
            IF lastline >= maxline THEN RETURN FALSE; END;
            splitagain:=dmpTTX(S,LineWidth,tmp,FALSE);
        END;

    RETURN TRUE;
END formatSentence;

PROCEDURE dmpSentence (redirection:BOOLEAN;
                       doFrame,screenwidth,LineWidth,lastline,longest,
                       ink,paper,hiink,hipaper:CARDINAL);
VAR
    plus,len,i,j,k    : CARDINAL;
    frameChars   : str16;
    S            : str128;
    neednl       : BOOLEAN;
BEGIN
    color(ink,paper);

    len := longest;

    CASE doFrame OF
    | frameNone   : frameChars := sNone;   plus:=0;
    | frameSingle : frameChars := sSingle; plus:=2;
    | frameDouble : frameChars := sDouble; plus:=2;
    END;

    CASE doFrame OF
    | frameRaw :
        (* WrLn; *)
        FOR j:=firstline TO lastline DO
            IF j=firstline THEN color(hiink,hipaper); END;
            WrStr(line[j].s3);
            IF j=firstline THEN color(ink,paper);END;
            neednl :=( Str.Length(line[j].s3) < LineWidth );
            neednl :=(neednl OR redirection);
            neednl :=(neednl OR (LineWidth # screenwidth) ); (* < *)
            IF neednl THEN WrLn; END;
        END;
    ELSE
        neednl := ((1+len+plus+1) < LineWidth );
        neednl := (neednl OR redirection);
        neednl := (neednl OR (LineWidth # screenwidth) ); (* < *)

        (* WrLn; *)
        WrChar(frameChars[0]);
        FOR i:=1 TO (len+plus) DO WrChar(frameChars[4]); END;
        WrStr(frameChars[2]);
        IF neednl THEN WrLn; END;

        IF doFrame # frameNone THEN
            WrChar(frameChars[1]);
            FOR i:=1 TO (len+plus) DO WrChar(space); END;
            WrStr(frameChars[1]);
            IF neednl THEN WrLn; END;
        END;
        FOR j:=firstline TO lastline DO
            WrStr(frameChars[1]);
            IF doFrame # frameNone THEN WrChar(space); END;
            IF j=firstline THEN color(hiink,hipaper); END;
            WrStr(line[j].s3);
            IF j=firstline THEN color(ink,paper); END;
            FOR k:=Str.Length(line[j].s3)+1 TO len DO
                WrStr(space);
            END;
            IF doFrame # frameNone THEN WrChar(space); END;
            WrStr(frameChars[1]);
            IF neednl THEN WrLn; END;
        END;

        IF doFrame # frameNone THEN
            WrStr(frameChars[1]);
            FOR i:=1 TO (len+plus) DO WrStr(space); END;
            WrStr(frameChars[1]);
            IF neednl THEN WrLn; END;
        END;

        WrStr(frameChars[3]);
        FOR i:=1 TO (len+plus) DO WrStr(frameChars[4]); END;
        WrStr(frameChars[5]);
        IF neednl THEN WrLn; END;
    END;
END dmpSentence;

PROCEDURE dmpPagan ( doLatin,redirection:BOOLEAN;
                     shortday:BOOLEAN;datafile : ARRAY OF CHAR;dmy:datetype;
                     screenwidth,LineWidth,doFrame:CARDINAL;
                     language:languagetype;
                     ink,paper,hiink,hipaper:CARDINAL) : BOOLEAN;
CONST
    defaultFmtFR  = "$dd !d $mm $yyyy  0hh 0mmn 0ss";
    defaultShortFR= "Calendrier paen pour le !d $mm";
    defaultFmtUS  = "$dd, $mm $d, $yyyy at 0h:0m:0s";
    defaultShortUS= "Pagan calendar for $mm $d";
    defaultNadaFR = "Aucun rite  observer, aucune remarque  formuler.";
    defaultNadaUS = "No observance today.";
    errmsgFR      = "ERREUR !";
    errmsgUS      = "ERROR WHILE PROCESSING DATA !";
VAR
    dm,ddmm : str16;
    S : str1024; (* max length is about 730 chars, so... *)
    dt : str128;
    found:BOOLEAN;
    hnd:FIO.File;
    format:str80;
    lastline,longest,p:CARDINAL;
BEGIN
    Str.Concat(dm,using(dmy.day,2,zero),using(dmy.month,2,zero));
    found:=FALSE;
    hnd := FIO.OpenRead(datafile);
    FIO.AssignBuffer(hnd,IObuffer);
    FIO.EOF := FALSE;
    LOOP
        IF FIO.EOF THEN EXIT;END;
        FIO.RdStr(hnd,S); (* "ddmm:..." *)
        LtrimBlanks(S);
        RtrimBlanks(S);
        CASE S[0] OF
        | CHR(0) : ;  (* nada *)
        | comment : ; (* nada either *)
        ELSE
            Str.Slice(ddmm,S,0,4);
            ReplaceChar(ddmm,blank,zero); (* just in case... *)
            IF same(ddmm,dm) THEN
                found:=TRUE;
                EXIT;
            END;
        END;
    END;
    FIO.Close(hnd);
    IF found THEN
        (* we could directly remove "####:" header but just to be sure... *)
        Str.Delete(S,0,4); (* first, we remove "ddmm" *)
        p:=Str.CharPos(S,":"); (* should always be 0 ! *)
        IF p # MAX(CARDINAL) THEN
            Str.Delete(S,0,p+1);
        END;
        LtrimBlanks(S);
    ELSE
        CASE language OF
        | french : Str.Copy(S,defaultNadaFR);
        | english: Str.Copy(S,defaultNadaUS);
        END;
    END;
    CASE language OF
    | french  :
        IF shortday THEN
            Str.Copy(format,defaultShortFR);
        ELSE
            Str.Copy(format,defaultFmtFR);
        END;
    | english :
        IF shortday THEN
            Str.Copy(format,defaultShortUS);
        ELSE
            Str.Copy(format,defaultFmtUS);
        END;
    END;
    IF doLatin THEN Str.Append(format," ($!)");END;
    formatNowFormat(format,language,dmy,dt);
    Str.Prepend(S,newlinemarker+newlinemarker);
    Str.Prepend(S,dt);
    IF formatSentence (LineWidth,doFrame,  lastline,longest,S)=FALSE THEN
        Str.Concat(S,dt,newlinemarker+newlinemarker);
        CASE language OF
        | french:  Str.Append(S,errmsgFR);
        | english: Str.Append(S,errmsgUS);
        END;
        (* assume always ok here ! *)
        found:=formatSentence(LineWidth,doFrame,  lastline,longest,S);
    END;
    dmpSentence (redirection,doFrame,screenwidth,LineWidth,lastline,longest,ink,paper,hiink,hipaper);
    RETURN TRUE;
END dmpPagan;

(* ------------------------------------------------------------ *)

PROCEDURE buildDataFilePath (VAR data,private,pagan: ARRAY OF CHAR;
                             n : CARDINAL;hugedata:BOOLEAN);
CONST
    mois = "JAN FEB MAR APR MAY JUN JUL AUG SEP OCT NOV DEC"+
           " "+sEGO+" "+sCAL; (* upper case *)
VAR
    exe,u,d,f8,e3:str128;
    extDAT,S : str16;
BEGIN
    IF hugedata THEN
        extDAT:=extDAT2;
    ELSE
        extDAT:=extDAT1;
    END;

    Lib.ParamStr(exe,0);
    UpperCase(exe); (* useless but... *)
    Lib.SplitAllPath(exe,u,d,f8,e3);
    (* well, some genius may have renamed our executable : let's hard code name ! :-( *)
    Str.Copy(f8,DATheader);

    Str.ItemS(S,mois," ",n-1);
    Str.Prepend(S,f8);
    Lib.MakeAllPath(data,u,d,S,extDAT);

    Str.ItemS(S,mois," ",13-1);
    Str.Prepend(S,f8);
    Lib.MakeAllPath(private,u,d,S,extDAT);

    Str.ItemS(S,mois," ",14-1);
    Str.Prepend(S,f8);
    Lib.MakeAllPath(pagan,u,d,S,extDAT);

END buildDataFilePath;

(* ------------------------------------------------------------ *)

VAR
    parmcount : CARDINAL;
    i         : CARDINAL;
    opt       : CARDINAL;
    S         : str128;
    R         : str128;

    doWait    : BOOLEAN;
    doBeautify: BOOLEAN;
    doSort    : BOOLEAN;
    doFull    : BOOLEAN;
    doPaging  : BOOLEAN;
    doBirths,doDeaths,doEvents,doEgotist: BOOLEAN;
    doPagan,doLatin : BOOLEAN;
    normalink,normalpaper : CARDINAL;
    hilightedink,hilightedpaper : CARDINAL;
    doFrame,LineWidth,maxcolumns,screenwidth:CARDINAL;
    dmy       : datetype;
    language  : languagetype;
    shortday,hugedata,redirection  : BOOLEAN;
    data, private, pagan: str128;
    parm1,parm2:str128;

    state     : (waiting,gotparm1,gotmonth);
    v         : LONGCARD;
    c1,c2     : CHAR;
    rc        : BOOLEAN;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck:=FALSE;

    (* handleVesa; *) (* useless, because we won't change video mode *)
    setUseBiosMode ( IsRedirected() );
    findInkPaperAtStartup();
    colorhelp;
    WrLn; (* here to beautify display *)

    redirection := IsRedirected();

    screenwidth  := getWindowWidth(); (* no longer -1, 80 no longer becomes 79 *)
    LineWidth    := screenwidth;
    maxcolumns   := screenwidth;

    doWait          := FALSE;
    doPaging        := FALSE;
    doBeautify      := FALSE;
    doSort          := FALSE;
    doFull          := FALSE;
    doBirths        := TRUE;
    doDeaths        := TRUE;
    doEvents        := TRUE;
    doPagan         := FALSE;
    doFrame         := frameDouble;
    doEgotist       := FALSE;
    doLatin         := FALSE;
    normalink       := ORD(inktext);
    normalpaper     := ORD(papertext);
    hilightedink    := ORD(inktitle);
    hilightedpaper  := ORD(papertitle);

    language        := english;
    hugedata        := FALSE;

    state     := waiting;
    parmcount := Lib.ParamCount();

    IF parmcount = 0 THEN abort(errHelp,""); END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        RtrimBlanks(S); (* thank you, TopSpeed runtime library ! *)
        Str.Copy(R,S);
        UpperCase(R); cleantabs(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "W"+delim+"WAIT"+delim+
                                 "N"+delim+"NEWLINE"+delim+"CR"+delim+"CRLF"+delim+
                                 "NI:"+delim+"INK1:"+delim+
                                 "NP:"+delim+"PAPER1:"+delim+
                                 "HI:"+delim+"INK2:"+delim+
                                 "HP:"+delim+"PAPER2:"+delim+
                                 "B"+delim+"BIOS"+delim+
                                 "FR"+delim+"FRENCH"+delim+
                                 "S"+delim+"SORT"+delim+
                                 "A"+delim+"ALL"+delim+
                                 "NB"+delim+"NOBIRTHS"+delim+
                                 "NE"+delim+"NOEVENTS"+delim+
                                 "P"+delim+"PAGAN"+delim+
                                 "F:"+delim+"FRAME:"+delim+
                                 "W:"+delim+"WIDTH:"+delim+
                                 "X"+delim+"EXTRA"+delim+"XL"+delim+"XXL"+delim+
                                 "ND"+delim+"NODEATHS"+delim+
                                 "E"+delim+"EGO"+delim+
                                 "L"+delim+"LATIN"+delim+
                                 "PP"+delim+"PL"+delim+
                                 "K"+delim+"PAGING"+delim+
                                 "WW"+delim+"WK"+delim+"KW"+delim+"KK"+delim+
                                 "??"
                              );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5 :   doWait  := TRUE;
            | 6,7,8,9:doBeautify  := TRUE;
            | 10,11:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolor) OR (v > maxcolor) ) THEN abort(errInkRange,"");END;
                normalink:=CARDINAL(v);
            | 12,13:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolor) OR (v > maxcolor) ) THEN abort(errPaperRange,"");END;
                normalpaper:=CARDINAL(v);
            | 14,15:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolor) OR (v > maxcolor) ) THEN abort(errInkRange,"");END;
                hilightedink:=CARDINAL(v);
            | 16,17:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolor) OR (v > maxcolor) ) THEN abort(errPaperRange,"");END;
                hilightedpaper:=CARDINAL(v);
            | 18,19:  setUseBiosMode ( TRUE );
            | 20,21:  language := french;
            | 22,23:  doSort := TRUE;
            | 24,25:  doFull := TRUE;
            | 26,27:  doBirths := FALSE;
            | 28,29:  doEvents := FALSE;
            | 30,31:  doPagan := TRUE;
            | 32,33:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < minframe) OR (v > maxframe) ) THEN abort(errBadNumber,S); END;
                doFrame:=CARDINAL(v);
            | 34,35:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolumns) OR (v > LONGCARD(maxcolumns)) ) THEN abort(errWidthRange,"");END;
                LineWidth:=CARDINAL(v);
            | 36,37,38,39: hugedata:=TRUE;
            | 40,41:  doDeaths:=FALSE;
            | 42,43:  doEgotist:=TRUE;
            | 44,45: doLatin := TRUE;
            | 46,47: doPagan := TRUE; doLatin:=TRUE;
            | 48,49: doPaging:= TRUE;
            | 50,51,52,53: doPaging:=TRUE; doWait:=TRUE;
            | 54:    abort(errMoreHelp,"");
            ELSE
                abort(errOption,S);
            END;
        ELSE
            CASE state OF
            | waiting :
                Str.Copy(parm1,R);
            | gotparm1:
                Str.Copy(parm2,R);
            | gotmonth :
                abort(errParameter,S);
            END;
            INC(state);
        END;
    END;
    CASE state OF
    | waiting : abort(errMissingDate,"");
    | gotparm1:
         IF same(parm1,"?") THEN abort(errHelp,""); END;
         IF same(parm1,today) THEN
             getDateNow(dmy);
         ELSE
             IF parseDate(parm1,dmy)=FALSE THEN abort(errBadDMY,parm1);END;
         END;
    | gotmonth:
         Str.Append(parm1,dash);
         Str.Append(parm1,parm2);
         IF parseDate(parm1,dmy)=FALSE THEN abort(errBadDMY,parm1);END;
    END;
    IF ((doBirths=FALSE) AND (doDeaths=FALSE) AND (doEvents=FALSE)) THEN abort(errNonsense,"");END;
    IF (doPagan AND doEgotist) THEN abort(errPaganEgotist,"");END;
    IF (doPagan OR doEgotist) THEN
        IF hugedata THEN abort(errPaganEgotistHuge,"");END;
    END;

    IF redirection THEN
        doWait := FALSE;
        doPaging:=FALSE;
    END;

    buildDataFilePath(data,private,pagan,dmy.month,hugedata);
    IF doPagan THEN
        doPaging := FALSE; (* useless but... *)
        shortday := (state=gotmonth);
        IF FIO.Exists(pagan)=FALSE THEN abort(errMissingFile,pagan);END;
        rc:=dmpPagan( doLatin,redirection,shortday, pagan, dmy,
                      screenwidth,LineWidth,doFrame, language,
                      normalink,normalpaper,hilightedink,hilightedpaper);
    ELSE
        IF NOT(doEgotist) THEN
            IF FIO.Exists(data)=FALSE THEN abort(errMissingFile,data);END;
        END;
        rc:=dmpData( doPaging,doSort,doFull,
                     doBirths,doDeaths,doEvents,doEgotist,redirection,
                     data,private,dmy,language,
                     normalink,normalpaper,hilightedink,hilightedpaper,LineWidth);
    END;
    colorhelp;
    IF rc=FALSE THEN abort(errAborted,"");END;

    IF doBeautify THEN WrLn; END;
    IF doWait THEN
        video(msgWait,TRUE);
        BiosWaitkey(c1,c2);
        video(msgWait,FALSE);
    END;

    abort(errNone,"");
END DayMonth.

(*

B=Birthdays
D=Passings

H=Holidays

I=Interesting events... hem, silly religious dates !
S=Special events

*)


