(* ---------------------------------------------------------------
Title         Q&D Fortune Cookie
Author        PhG
Overview      another useless program
Notes         minimal error messages and checking, etc.
              too many globerks... ;-)
Bugs          when building an index, cookies count is always count-1
              (eof is not seen as terminator)
              bah, who cares ? not even me, now...
              just warn about trailing separator needed !
Wish List     are we kidding ? ah ah, only serious !

              run from readonly device ? bof...
              a more clever sentence concatenation ? bof... (bis)
              resist improving, for we'd rewrite the whole stuff !

--------------------------------------------------------------- *)

MODULE Fortune;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;
IMPORT SYSTEM;
IMPORT BiosIO;
IMPORT MsMouse;

IMPORT IO;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetString, CharCount, same,
aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows, str16,
setReadWrite,cleantabs;

FROM QD_rand IMPORT InitRnd, GetRnd, GetRndCardRange;

FROM QD_Text IMPORT
colortype, cursorshapetype, scrolltype,
ff, cr, lf, bs, tab, nl, mincolor, maxcolor,
BW40, CO40, BW80, CO80, CO80x43, CO80x50, MONO,
vesa80x60, vesa132x25, vesa132x43, vesa132x50, vesa132x60,
selectCursorEmulation,
setCursorShape,
handleVesa, setBrightPaper, setBlinkMode,
setFillChar, setFillInk, setFillPaper,
setFillInkPaper, setTxtInk, setTxtPaper, setTxtInkPaper, setWrapMode,
setUseBiosMode, setTabWidth, getScreenData, setWindow,
setMode, restoreMode,
gotoXY, xyToHtabVtab, home, setVisualPage, setActivePage,
scrollWindow, fillTextAttr, cls, writeStr, writeLn, getScreenWidth,
getScreenHeight, getScreenMinX, getScreenMinY, getScreenMaxX, getScreenMaxY,
getMinHtab, getMaxHtab, getMinVtab, getMaxVtab,
getWindowWidth, getWindowHeight,
initScreenConsole,
findInkPaperAtStartup, getInkAtStartup, getPaperAtStartup;

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "FORTUNE";
    ProgTitle     = "Q&D Fortune Cookies";
    ProgVersion   = "v1.1e";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    extEXE        = ".EXE";
    extTXT        = ".TXT";
    extNDX        = ".NDX";

    extBAK        = ".BK!";
    extCOM        = ".COM";
    extDLL        = ".DLL";
    extOVR        = ".OVR";
    extOVL        = ".OVL";
    extDRV        = ".DRV";
    extSYS        = ".SYS";
    extBIN        = ".BIN";
    extBAT        = ".BAT";
    extensions    = extBAK+delim+extCOM+delim+extEXE+delim+extBAT+delim+
                    extDLL+delim+extOVR+delim+extOVL+delim+extDRV+delim+
                    extSYS+delim+extBIN+delim+extNDX;

    dot           = ".";
    space         = " ";
    dquote        = '"';
    cmdANSI       = CHR(27)+"["; (* ANSI.SYS command *)
    colon         = ":";
    backslash     = "\";
    star          = "*";
    stardotstar   = star+dot+star;

CONST
    DUMPED        = MAX(LONGCARD);  (* impossible fpos will do for "already dumped" flag *)
    UNSPECIFIED   = MAX(CARDINAL);

    minCookie     = 0;              (* will contain count of cookies *)
    countCookie   = minCookie;      (* alias *)
    firstCookie   = minCookie+1;    (* 1.. *)
    maxCookie     = MAX(CARDINAL)-2; (* ..65533, was MAX(CARDINAL) DIV SIZE(LONGCARD)-2 *)

    sMAX          = "65533rd";
VAR
    (* YAUG -- Yet Another Ugly Globerk *)
    (* we split fpos LONGCARD to 4 bytes : yes, we're NOT proud of it *)
    entryA  : ARRAY [minCookie..maxCookie] OF SHORTCARD;
    entryB  : ARRAY [minCookie..maxCookie] OF SHORTCARD;
    entryC  : ARRAY [minCookie..maxCookie] OF SHORTCARD;
    entryD  : ARRAY [minCookie..maxCookie] OF SHORTCARD;

TYPE
    tricktype = RECORD
        CASE : BOOLEAN OF
        | TRUE:
            a,b,c,d:SHORTCARD; (* 4 bytes *)
        | FALSE:
            lc:LONGCARD;       (* 4 bytes too -- surprise ! *)
        END;
    END;
    str144 = ARRAY [0..144-1] OF CHAR; (* 128+16 just in case *)
CONST
    firstString   = 1;
    maxString     = 100; (* was 64, should be more than enough *)
VAR
    string : ARRAY [firstString..maxString] OF str144; (* was str128 *)
    slen   : ARRAY [firstString..maxString] OF CARDINAL;
    lastString:CARDINAL;
    longest   :CARDINAL;
CONST
    frameNone   = 0;
    frameSingle = 1;
    frameDouble = 2;
    frameAscii  = 3;
    frameRaw    = 4;
    minframe    = frameNone;
    maxframe    = frameRaw;
    msgWait       = "Hit any key to continue... ";
    msgWaitMouse  = "Hit any key or click any mouse button to continue... ";
    msgWaitFR     = "Appuyez sur une touche pour continuer... ";
    msgWaitMouseFR= "Appuyez sur une touche ou sur un bouton pour continuer... ";
CONST
    minpause     = 0;
    maxpause     = 30;
    defaultpause = 1;
    defaultalwayspause  = 10; (* always pause 1 seconds PLUS # s per line *)
CONST
    (*            012345     *)
    sSingle    = "ڳ";
    sDouble    = "ɺͼ";
    sAscii     = "+!++-+";
    sNone      = "      ";
CONST
    wiHORIZ    = 4; (* bar, space, ... , space, bar *)
    wiVERTI    = 4; (* line, filler, ... , filler, line *)
    wiHORIZalt = 2; (* space, ... , space *)
    wiVERTIalt = 2; (* filler, ... , filler *)

(* ------------------------------------------------------------ *)

CONST
    (* aliases for our own procedures *)
    WrStr ::= writeStr;
    WrLn  ::= writeLn;
    WrChar::= writeStr;
CONST
    progink   = cyan;
    progpaper = darkblue;

PROCEDURE colorhelp ();
BEGIN
    setTxtInk(getInkAtStartup());      (* was green *)
    setTxtPaper(getPaperAtStartup());  (* was black *)
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colorhelp;

PROCEDURE colortext (ink,paper:CARDINAL );
BEGIN
    setTxtInk   (VAL(colortype,ink));
    setTxtPaper (VAL(colortype,paper));
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colortext;

(* ------------------------------------------------------------ *)

CONST
    errNone           = 0;
    errHelp           = 1;
    errOption         = 2;
    errParameter      = 3;
    errNotFound       = 4;
    errBadNumber      = 5;
    errNotFoundReally = 6;
    errNotInNormalMode= 7;
    errInkRange       = 8;
    errPaperRange     = 9;
    errWidthRange     = 10;
    errTabRange       = 11;
    errPauseRange     = 12;
    errNotInSaverMode = 13;
    errTooManyFiles   = 14;
    errCookieVal      = 15;
    errCookieRange    = 16;
    errNotWithMultifile=17;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
00000000011111111112222222222333333333344444444445555555555666666666677777777778
1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg=nl+
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [file["+extTXT+"]] [option]..."+nl+
nl+
"  file   Data file (default is "+ProgEXEname+extTXT+")"+nl+
"         File specification should be unambiguous. Jokers are allowed."+nl+
'         "'+dot+'" and "'+star+'" specifications are replaced with "'+star+extTXT+'".'+nl+
"         If specified in 8+3 format (without a path), data file is searched for"+nl+
"         first in executable directory, then in current directory."+nl+
"         If data file's first line is not a single character separator,"+nl+
"         tagline mode (single line entries) is assumed."+nl+
"         Data file's last line must be the single character separator,"+nl+
"         unless, of course, lines are taglines."+nl+
"         Entries above "+sMAX+" will be ignored."+nl+
"  -n:#   display cookie or tagline number # whatever its state (updated anyway)"+nl+
"  -i     reinit index file (no cookie will be displayed twice in a cycle)"+nl+
"  -f:#   frame type (0=none, 1=single, 2=double, 3=ascii, 4=raw), default is 0"+nl+
"  -w[w]  wait for keypress or mouseclick (-ww = -w -m)"+nl+
"  -m     ignore mouse if present"+nl+
"  -p[p]  -w[w] with French prompt"+nl+
"  -n     add a newline (CR+LF) in order to beautify display (useful with PEXEC)"+nl+
"  -t:#   tab width [1..64], default is 8"+nl+
"  -i:#   ink [0..15], default is cyan"+nl+
"  -p:#   paper [0..15], default is dark blue"+nl+
"  -b     monochrome BIOS output (no colors)"+nl+
"  -x[x]  show index statistics, ignoring any other option (-xx = alternate)"+nl+
"  -o     reverse 8+3 format directory search sequence (current then executable)"+nl+
"  -w:#   set line width, default is screen width"+nl+
"  -s[s]  screensaver mode, next = Enter, quit = Escape (-ss = -s -c)"+nl+
"  -s:#   in screensaver mode, pause [0..30] in seconds per line, default is 1"+nl+
"  -m:#   in screensaver mode, minimum pause [0..30] in seconds, default is 10"+nl+
"  -z     in screensaver mode, next = left click, quit = right click"+nl+
"  -r     in screensaver mode, randomize position, default is center"+nl+
"  -c     in screensaver mode, do not clear screen at exit"+nl+
nl+
"Program will not handle more than 200 files, always excluding from processing"+nl+
"all files matching *<"+extensions+">."+nl+
nl+
"Dark [0..7] : black, blue, green, cyan, red, magenta, brown and gray."+nl+
"Bright [8..15] : gray, blue, green, cyan, red, magenta, yellow and white."+nl+
nl+
"With DR-DOS 6.0 or Novell DOS 7.0, "+ProgEXEname+" can be called after each"+nl+
"external command by setting SET PEXEC=path\"+ProgEXEname+extEXE+" -n and PROMPT $x$p$g"+nl+
nl+
"NEVER forget Murphy's Law : "+dquote+"If anything CAN go wrong, it WILL !"+dquote+" ;-)"+nl;

VAR
    S : str256;
BEGIN
    colorhelp();
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errOption :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," option !");
    | errParameter :
        Str.Concat(S,einfo," is just one parameter too many !");
    | errNotFound:
        Str.Concat(S,"No file matches ",einfo);Str.Append(S," specification !");
    | errBadNumber:
        Str.Concat(S,"Illegal value in ",einfo); Str.Append(S," option !");
    | errNotFoundReally:
        Str.Concat(S,"No file matches ",einfo);Str.Append(S," specification anywhere !");
    | errNotInNormalMode:
        Str.Copy(S,einfo);
    | errInkRange:
        S := "Ink range is [0..15] !";
    | errPaperRange:
        S := "Paper range is [0..15] !";
    | errWidthRange:
        S := "Illegal width !";
    | errTabRange:
        S := "Tab width range is [1..64] !";
    | errPauseRange   :
        S := "Pause range is [0..30] !";
    | errNotInSaverMode:
        Str.Copy(S,einfo);
    | errTooManyFiles:
        Str.Concat(S,"Too many files match ",einfo);
        Str.Append(S," specification !");
    | errCookieVal:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," cookie value !");
    | errCookieRange:
        Str.Copy(S,einfo);
    | errNotWithMultifile:
        S := "-n:# option requires only one datafile !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp:
        ;
    ELSE
        WrLn;
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE fmtbignum (v:LONGCARD; base:CARDINAL;wi:INTEGER; pad:CHAR ):str16;
VAR
    S:str16;
    ok:BOOLEAN;
    i : CARDINAL;
BEGIN
    Str.CardToStr( v, S, base,ok);
    FOR i:=Str.Length(S)+1 TO ABS(wi) DO
         IF wi < 0 THEN
             Str.Append(S,pad);
         ELSE
             Str.Prepend(S,pad);
         END;
    END;
    IF base=16 THEN Str.Lows(S);END;
    RETURN S;
END fmtbignum;

(* <s|g>etEntry require entry[A|B|C|D] globerks *)

PROCEDURE setEntry (i:CARDINAL; fpos:LONGCARD);
VAR
    trick : tricktype;
BEGIN
    trick.lc  := fpos;
    entryA[i] := trick.a;
    entryB[i] := trick.b;
    entryC[i] := trick.c;
    entryD[i] := trick.d;
END setEntry;

PROCEDURE getEntry (i:CARDINAL ):LONGCARD;
VAR
    trick : tricktype;
BEGIN
    trick.a := entryA[i];
    trick.b := entryB[i];
    trick.c := entryC[i];
    trick.d := entryD[i];
    RETURN trick.lc;
END getEntry;

PROCEDURE retrieveEntries (hin:FIO.File;DEBUG:BOOLEAN);
VAR
    i,got,count:CARDINAL;
    trick:tricktype;
    lc:LONGCARD;
    fpos:LONGCARD;
BEGIN
    setEntry(countCookie,0); (* safety *)
    count:=CARDINAL ( FIO.Size(hin) >> 2 ); (* faster DIV 4 *)
    IF count=0 THEN RETURN; END; (* safety *)

    FOR i:= firstCookie-1 TO count DO (* 0.. will include count *)
        got:=FIO.RdBin(hin, trick, SIZE(trick));
        setEntry(i,trick.lc);
    END;

    IF DEBUG THEN
        lc := getEntry(countCookie);
        WrLn;
        WrStr(fmtbignum( lc,10,5,space));
        WrStr(" entr");
        IF count = 1 THEN
            WrStr("y");
        ELSE
            WrStr("ies");
        END;
        WrLn;
        WrLn;
        count := CARDINAL (lc);
        FOR i:=firstCookie TO count DO (* 1.. *)
            fpos:=getEntry(i);
            WrStr( fmtbignum(LONGCARD(i),10,5,space));
            WrStr(" -- $");
            WrStr( fmtbignum(fpos,16,8,"0"));
            IF fpos = DUMPED THEN WrStr(" (used)"); END;
            WrLn;
        END;
        WrLn;
    END;

END retrieveEntries;

(*
PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;
*)

CONST
    delai       = 100; (* 0.1 second *)
    delaimickey = 300; (* avoid too fast a change with a mouseclick *)
TYPE
    mousebuttonstype = SET OF (leftbutton,rightbutton,middlebutton);
VAR
    which : mousebuttonstype;

PROCEDURE mouseclick ( ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    which:=mousebuttonstype{};
    IF msdata.left_pressed   THEN INCL(which,leftbutton); END;
    IF msdata.right_pressed  THEN INCL(which,rightbutton); END;
    IF msdata.middle_pressed THEN INCL(which,middlebutton);END;
    RETURN (which # mousebuttonstype{} );
END mouseclick;

PROCEDURE getLastPressed (  ):mousebuttonstype;
BEGIN
    Lib.Delay(delaimickey); (* force a small delay *)
    RETURN which;
END getLastPressed;

CONST
    keyEscape  = 01B00H;
    keySpace   = 02000H;
    keyCR      = 00D00H;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE detab (tabwidth:CARDINAL;S:ARRAY OF CHAR; VAR R : ARRAY OF CHAR  );
VAR
    i,j,add: CARDINAL;
    c : CHAR;
BEGIN
    Str.Copy(R,"");
    j:=0; (* yes, 0 and not 1 ! *)
    FOR i:=1 TO Str.Length(S) DO
        c := S[i-1];
        IF c = tab THEN
            add := tabwidth - (j MOD tabwidth);
            WHILE add > 0 DO
                Str.Append(R,space); INC(j);
                DEC(add);
            END;
        ELSE
            Str.Append(R,c); INC(j);
        END;
    END;
END detab;

PROCEDURE stripANSI (VAR S : ARRAY OF CHAR);
VAR
    p : CARDINAL;
BEGIN
    LOOP
        p:=Str.Pos(S,cmdANSI);
        IF p = MAX(CARDINAL) THEN EXIT; END;
        S[p]:="["; (* neutralize ! *)
    END;
END stripANSI;

PROCEDURE stripchar (ch:CHAR;  VAR S : ARRAY OF CHAR   );
VAR
    p:CARDINAL;
BEGIN
    LOOP
        p:=Str.CharPos(S,ch);
        IF p = MAX(CARDINAL) THEN EXIT; END;
        Str.Delete(S,p,1);
    END;
END stripchar;

PROCEDURE isTaglineFile (hnd:FIO.File;VAR separator:CHAR):BOOLEAN ;
VAR
    rc : BOOLEAN;
    S  : str2048; (* oversized *)
BEGIN
    LOOP
        FIO.RdStr(hnd,S);
        LtrimBlanks(S);
        RtrimBlanks(S);
        CASE Str.Length(S) OF
        | 0 : ;
        | 1 :
            separator:=S[0];
            rc:=FALSE;
            EXIT;
        ELSE
            rc:=TRUE;
            EXIT;
        END;
        IF FIO.EOF THEN
            rc:=TRUE;
            EXIT;
        END;
    END;
    IF rc THEN FIO.Seek(hnd,0); END; (* not a fortune file : let's rewind ! *)
    RETURN rc;
END isTaglineFile;

CONST
    IObufferSize = (8 * 512) + FIO.BufferOverhead;
VAR
    IObuffer , IObufferx : ARRAY [1..IObufferSize] OF BYTE;

(*
    data file structure :

    separator single character
    text
    separator single character
    text
    ...
    separator character

    or
    single line tagline
    single line tagline
    ...


    index file structure (all LONGCARDs)
    - number of entries
    - offset for tagline1
    - offset for tagline2...

    max(longcard) means already dumped

    if wantedcookie # UNSPECIFIED :
    - just update this cookie address in RAM ARRAY
    - lastCookie will be wrong

    eh eh, bug : last cookie is never counted nor displayed,
    because eof may happen without last separator
    yes, we could fake it but we don't care...
    if we begin, we'd rewrite everything !
*)

PROCEDURE buildIndex (datafile,indexfile:ARRAY OF CHAR;
                     verbose:BOOLEAN;wantedcookie:CARDINAL;
                     VAR lastCookie:CARDINAL);
VAR
    S       : str2048; (* oversized *)
    pos     : LONGCARD;
    separator:CHAR;
    taglinemode:BOOLEAN;
    hnd,hndx:FIO.File;
BEGIN
    IF wantedcookie # UNSPECIFIED THEN verbose:=FALSE;END; (* added safety *)

    IF verbose THEN
        WrStr("Building "); WrStr(indexfile); WrStr(" index file... ");
        Animation(cmdInit);
    END;

    hnd := FIO.OpenRead(datafile);
    FIO.AssignBuffer(hnd,IObuffer);
    taglinemode := isTaglineFile(hnd,separator);

    lastCookie := 0;
    IF wantedcookie = UNSPECIFIED THEN
        hndx := FIO.Create(indexfile);
        FIO.AssignBuffer(hndx,IObufferx);
        FIO.WrBin(hndx,LONGCARD(lastCookie),SIZE(LONGCARD)); (* force first entry *)
    END;

    FIO.EOF:=FALSE;
    LOOP
        IF FIO.EOF THEN EXIT; END;
        pos := FIO.GetPos(hnd);
        LOOP
            FIO.RdStr(hnd,S);
            IF verbose THEN Animation(cmdShow); END;
            IF taglinemode THEN
                LtrimBlanks(S);
                RtrimBlanks(S);
                IF Str.Length(S) > 0 THEN EXIT; END; (* skip empty taglines *)
            ELSE
                LtrimBlanks(S);
                RtrimBlanks(S);
                IF Str.Length(S) = 1 THEN (* stricter *)
                    IF S[0]=separator THEN EXIT;END;
                END;
            END;
            IF FIO.EOF THEN EXIT;END; (* avoid infinite loop *)
        END;
        IF FIO.EOF THEN EXIT; END; (* avoid adding unecessary last entry *)

        IF wantedcookie = UNSPECIFIED THEN
            FIO.WrBin(hndx,pos,SIZE(LONGCARD));
        END;
        INC(lastCookie);

        IF wantedcookie # UNSPECIFIED THEN
            IF wantedcookie = lastCookie THEN
                setEntry(wantedcookie, pos);
                EXIT;
            END;
        END;

        IF lastCookie >= maxCookie THEN EXIT; END;

    END;

    IF wantedcookie = UNSPECIFIED THEN
        FIO.Seek(hndx,0);
        FIO.WrBin(hndx,LONGCARD(lastCookie),SIZE(LONGCARD));
        FIO.Flush(hndx);
        FIO.Close(hndx);
    END;

    FIO.Close(hnd);

    IF verbose THEN
        Animation(cmdStop);
        WrStr( fmtbignum( LONGCARD(lastCookie),10,1," " ) );
        IF taglinemode THEN
            WrStr(" tagline");
        ELSE
            WrStr(" cookie");
        END;
        IF lastCookie > 1 THEN WrChar("s"); END;
        WrStr(" found !"); WrLn;
    END;
END buildIndex;

PROCEDURE getCookie (datafile,indexfile:ARRAY OF CHAR;
                     doframe, tabwidth, LineWidth, wantedcookie:CARDINAL;
                     DEBUG:BOOLEAN;
                     VAR lastcookie:CARDINAL):BOOLEAN;
CONST
    maxiter = LONGCARD(maxCookie) << 4;
VAR
    pos     : LONGCARD;
    cookid  : CARDINAL;
    separator:CHAR;
    freecookid:CARDINAL;
    iter:LONGCARD;
    S       : str2048; (* oversized *)
    R,R2    : str2048;

    splitagain : BOOLEAN;
    tmp        : str256;
    len        : CARDINAL;
    tmplen     : CARDINAL;
    stop       : BOOLEAN;
    taglinemode: BOOLEAN;
    hnd,hndx:FIO.File;
BEGIN
    CASE doframe OF
    | frameRaw : ;
    | frameNone:
        DEC(LineWidth,wiHORIZalt); (* string + 2 spaces *)
    ELSE
        DEC(LineWidth,wiHORIZ);    (* string + 2 spaces + 2 bars *)
    END;

    hnd := FIO.OpenRead(datafile);
    FIO.AssignBuffer(hnd,IObuffer);
    taglinemode := isTaglineFile(hnd,separator);

    IF wantedcookie # UNSPECIFIED THEN (* assume index already loaded *)
        pos:=getEntry(wantedcookie);
    END;

    hndx := FIO.Open(indexfile);
    FIO.AssignBuffer(hndx,IObufferx);
    retrieveEntries(hndx,DEBUG);
    lastcookie := CARDINAL( getEntry(countCookie) );

    IF wantedcookie = UNSPECIFIED THEN

        (* check all Cookies have not been displayed *)

        cookid:=1;
        LOOP
            pos:=getEntry(cookid);
            IF pos # DUMPED THEN freecookid:=cookid; EXIT; END;
            INC(cookid);
            IF cookid > lastcookie THEN
               FIO.Close(hndx);
               FIO.Close(hnd);
               RETURN FALSE;
            END;
        END;

        (* now find a not yet displayed Cookie, preventing impossible infinite loop *)

        iter:=0;
        LOOP
            cookid := GetRndCardRange(firstCookie,lastcookie);
            INC(iter);
            IF iter > maxiter THEN cookid:=freecookid; END; (* we're already waiting too long *)
            pos:=getEntry(cookid);
            IF pos # DUMPED THEN EXIT; END;
        END;

    END;

    (* get it *)

    FIO.EOF:=FALSE; (* force it *)
    FIO.Seek(hnd,pos);

    lastString:= 0;
    longest   := 0;
    LOOP
        FIO.RdStr(hnd,R);
        IF NOT(taglinemode) THEN
            Str.Copy(S,R);
            LtrimBlanks(S);
            RtrimBlanks(S);
            IF Str.Length(S) = 1 THEN (* stricter *)
                IF S[0]=separator THEN EXIT;END;
            END;
        END;

        stripANSI(R);
        stripchar(bs,R);

        detab (tabwidth,R,R2);
        Str.Copy(R,R2);
        len:=Str.Length(R);

        IF len > LineWidth THEN
            stop:=FALSE;
            splitagain:=dmpTTX(R,LineWidth,tmp,TRUE);
            WHILE splitagain DO
                Str.Copy(string[firstString+lastString],tmp);
                tmplen:=Str.Length(tmp);
                slen[firstString+lastString]:=tmplen;
                IF tmplen > longest THEN longest := tmplen; END;
                INC(lastString);
                IF lastString >= maxString THEN stop:=TRUE; EXIT; END;
                splitagain:=dmpTTX(R,LineWidth,tmp,FALSE);
            END;
            IF stop THEN EXIT; END;
        ELSE
            Str.Copy(string[firstString+lastString],R);
            slen[firstString+lastString]:=len;
            IF len > longest THEN longest := len; END;
            INC(lastString);
            IF lastString >= maxString THEN EXIT; END;
        END;

        IF taglinemode THEN EXIT; END;
        IF FIO.EOF THEN EXIT; END;
    END;

    (* mark it as used *)

    pos:=LONGCARD(cookid) * SIZE(LONGCARD);
    FIO.Seek(hndx,pos);

    pos:=DUMPED;
    FIO.WrBin(hndx,pos,SIZE(LONGCARD));

    FIO.Flush(hndx);
    FIO.Close(hndx);
    FIO.Close(hnd);
    RETURN TRUE;
END getCookie;

PROCEDURE newExtension (VAR index:ARRAY OF CHAR ;ext:ARRAY OF CHAR);
VAR
    u,d,n,e : str128;
BEGIN
    Lib.SplitAllPath(index,u,d,n,e);
    Lib.MakeAllPath(index,u,d,n,ext);
END newExtension;

PROCEDURE dmpCookie (screenwidth,linewidth,doFrame:CARDINAL;redirected,doBeautify:BOOLEAN);
VAR
    len,plus   : CARDINAL;
    frameChars : str128;
    i,j,k      : CARDINAL;
    S          : str128;
    neednl     : BOOLEAN;
BEGIN
    len := longest;
    (*
    IF doFrame # frameRaw THEN
        IF getWindowWidth() <= (len+wiHORIZ) THEN doFrame:=frameRaw; END; (* string + 2 spaces + 2 bars *) (* BUGFIX : was < *)
        IF getWindowWidth() <= (len+wiHORIZ+1) THEN doFrame:=frameRaw; END; (* string + 2 spaces + 2 bars + 1 for exactly 80 columns *) (* CAKE bugfix *)
    END;
    *)
    CASE doFrame OF
    | frameNone   : frameChars := sNone;   plus:=0;
    | frameSingle : frameChars := sSingle; plus:=2;
    | frameDouble : frameChars := sDouble; plus:=2;
    | frameAscii  : frameChars := sAscii;  plus:=2;
    END;

    CASE doFrame OF
    | frameRaw :
        WrLn;
        FOR j:=firstString TO lastString DO
            WrStr(string[j]);
            neednl :=( slen[j] < linewidth );
            neednl :=(neednl OR redirected);
            neednl :=(neednl OR (linewidth # screenwidth) ); (* < *)
            IF neednl THEN WrLn; END;
        END;

    ELSE

        neednl := ((1+len+plus+1) < linewidth );
        neednl := (neednl OR redirected );
        neednl := (neednl OR (linewidth # screenwidth) ); (* < *)

        WrLn;
        WrChar(frameChars[0]);
        FOR i:=1 TO (len+plus) DO WrChar(frameChars[4]); END;
        WrChar(frameChars[2]);
        IF neednl THEN WrLn; END;

        IF doFrame # frameNone THEN
            WrChar(frameChars[1]);
            FOR i:=1 TO (len+plus) DO WrChar(space); END;
            WrChar(frameChars[1]);
            IF neednl THEN WrLn; END;
        END;

        FOR j:=firstString TO lastString DO
            WrChar(frameChars[1]);
            IF doFrame # frameNone THEN WrChar(space); END;
            WrStr(string[j]);
            FOR k:=Str.Length(string[j])+1 TO len DO
                WrChar(space);
            END;
            IF doFrame # frameNone THEN WrChar(space); END;
            WrChar(frameChars[1]);
            IF neednl THEN WrLn; END;
        END;

        IF doFrame # frameNone THEN
            WrChar(frameChars[1]);
            FOR i:=1 TO (len+plus) DO WrChar(space); END;
            WrChar(frameChars[1]);
            IF neednl THEN WrLn; END;
        END;

        WrChar(frameChars[3]);
        FOR i:=1 TO (len+plus) DO WrChar(frameChars[4]); END;
        WrChar(frameChars[5]);
        IF neednl THEN WrLn; END;
    END;
    IF doBeautify THEN WrLn; END;
END dmpCookie;

PROCEDURE forcepause (stopmouse:BOOLEAN; alwayspause,pause,first,last:CARDINAL );
VAR
    i,j:CARDINAL;
BEGIN
    FOR i := 1 TO alwayspause*10 DO
        IF BiosIO.KeyPressed() THEN RETURN;END;
        IF stopmouse THEN
            IF mouseclick() THEN RETURN;  END;
        END;
        Lib.Delay(delai);
    END;
    FOR j:=first TO last DO
        FOR i := 1 TO pause*10 DO
            IF BiosIO.KeyPressed() THEN RETURN; END;
            IF stopmouse THEN
                IF mouseclick() THEN RETURN; END;
            END;
            Lib.Delay(delai);
        END;
    END;
END forcepause;

(*
    yes, yes, we know we should have rewritten dmpCookie in a more general way...
    useless here to check linelength against linewidth
*)

PROCEDURE dmpCookieAt (doFrame:CARDINAL;
                       alwayspause,pause:CARDINAL;atrandompos,stopmouse:BOOLEAN );
VAR
    len,i,j,k,plus : CARDINAL;
    frameChars     : str16;
    S              : str128;
VAR
    mini,maxi,wi,ws,v,htab,vtab : CARDINAL;
BEGIN
    mini := getMinHtab(); (* 0.. *)
    maxi := getMaxHtab();
    wi := maxi-mini+1;
    ws := longest;
    CASE doFrame OF
    | frameRaw : ;
    | frameNone:
        INC(ws,wiHORIZalt);
    ELSE
        INC(ws,wiHORIZ);
    END;
    IF wi > ws THEN
        IF atrandompos THEN
            v:=GetRndCardRange(1,wi-ws) -1;
        ELSE
            v:=(wi-ws) DIV 2;
        END;
    ELSE
        v := 0;
    END;
    htab := mini+v;

    mini := getMinVtab(); (* 0.. *)
    maxi := getMaxVtab();
    wi := maxi-mini+1;
    ws := lastString-firstString+1;
    CASE doFrame OF
    | frameRaw : ;
    | frameNone:
        INC(ws,wiVERTIalt);
    ELSE
        INC(ws,wiVERTI);
    END;
    IF wi > ws THEN
        IF atrandompos THEN
            v:=GetRndCardRange(1,wi-ws) -1;
        ELSE
            v:=(wi-ws) DIV 2;
        END;
    ELSE
        v := 0;
    END;
    vtab := mini+v;

    len := longest;
    CASE doFrame OF
    | frameNone   : frameChars := sNone;   plus:=0;
    | frameSingle : frameChars := sSingle; plus:=2;
    | frameDouble : frameChars := sDouble; plus:=2;
    | frameAscii  : frameChars := sAscii;  plus:=2;
    END;

    CASE doFrame OF
    | frameRaw :
        FOR j:=firstString TO lastString DO
            gotoXY(htab,vtab);
            WrStr(string[j]);
            INC(vtab);
        END;
    ELSE
        gotoXY(htab,vtab);
        WrChar(frameChars[0]);
        FOR i:=1 TO (len+plus) DO WrChar(frameChars[4]); END;
        WrChar(frameChars[2]);
        INC(vtab);

        IF doFrame # frameNone THEN
            gotoXY(htab,vtab);
            WrChar(frameChars[1]);
            FOR i:=1 TO (len+plus) DO WrChar(space); END;
            WrChar(frameChars[1]);
            INC(vtab);
        END;

        FOR j:=firstString TO lastString DO
            gotoXY(htab,vtab);
            WrChar(frameChars[1]);
            IF doFrame # frameNone THEN WrChar(space); END;
            WrStr(string[j]);
            FOR k:=Str.Length(string[j])+1 TO len DO
                WrChar(space);
            END;
            IF doFrame # frameNone THEN WrChar(space); END;
            WrChar(frameChars[1]);
            INC(vtab);
        END;

        IF doFrame # frameNone THEN
            gotoXY(htab,vtab);
            WrChar(frameChars[1]);
            FOR i:=1 TO (len+plus) DO WrChar(space); END;
            WrChar(frameChars[1]);
            INC(vtab);
        END;

        gotoXY(htab,vtab);
        WrChar(frameChars[3]);
        FOR i:=1 TO (len+plus) DO WrChar(frameChars[4]); END;
        WrChar(frameChars[5]);
        INC(vtab);
    END;
    forcepause(stopmouse,alwayspause,pause,firstString,lastString);
END dmpCookieAt;

(* ------------------------------------------------------------ *)

PROCEDURE showIndexStatistics (indexfile:ARRAY OF CHAR; flagWide,DEBUG:BOOLEAN);
VAR
    total,used,unused   : CARDINAL;
VAR
    i       : CARDINAL;
    pos     : LONGCARD;
    count   : CARDINAL;
    percent : LONGREAL;
    S       : str128;
    ok      : BOOLEAN;
    hndx:FIO.File;
BEGIN
    hndx := FIO.Open(indexfile);
    FIO.AssignBuffer(hndx,IObufferx);
    retrieveEntries(hndx,DEBUG);
    FIO.Close(hndx);
    total := CARDINAL( getEntry(countCookie) );

    used  := 0;
    unused:= 0;
    FOR i := firstCookie TO total DO
        pos:= getEntry(i);
        IF pos = DUMPED THEN
            INC(used);
        ELSE
            INC(unused);
        END;
    END;

    CASE flagWide OF
    | FALSE:
        WrLn;
        WrStr("Index file     : "); WrStr(indexfile); WrLn;
        WrStr("Total entries  : "); WrStr(fmtbignum( LONGCARD(total ),10,5,space));WrLn;
        WrStr("Used entries   : "); WrStr(fmtbignum( LONGCARD(used  ),10,5,space));WrLn;
        WrStr("Unused entries : "); WrStr(fmtbignum( LONGCARD(unused),10,5,space));WrLn;
        WrLn;
    | TRUE:
        IF total = 0 THEN
            percent := 0.0;
        ELSE
            (* warning ! here, we need to sync bios, dos and our crt ! *)
            percent := (LONGREAL(used) / LONGREAL(total) ) * 100.0;
        END;
        WrStr(fmtbignum( LONGCARD(used ),10,5,space));
        Str.FixRealToStr(percent,1,S,ok);
        FOR i := Str.Length(S)+1 TO 3+1+1 DO
            Str.Prepend(S," ");
        END;
        WrStr(" ("); WrStr(S); WrStr("%) used out of ");
        WrStr(fmtbignum( LONGCARD(total),10,5,space));
        WrStr(" in "); WrStr(indexfile); WrLn;
    END;
END showIndexStatistics;

(* ------------------------------------------------------------ *)

(* q&d check : any "\" or ":" means a path *)

PROCEDURE f8e3format (S:ARRAY OF CHAR):BOOLEAN;
BEGIN
    IF Str.CharPos(S,backslash) # MAX(CARDINAL) THEN RETURN FALSE; END;
    RETURN ( Str.CharPos(S,colon)=MAX(CARDINAL) );
END f8e3format;

PROCEDURE prependexepath (exe:ARRAY OF CHAR;  VAR dat : ARRAY OF CHAR);
VAR
    u,d,f8,e3:str128;
    uz,dz,f8z,e3z:str128;
BEGIN
    Lib.SplitAllPath(exe,u,d,f8,e3);
    Lib.SplitAllPath(dat,uz,dz,f8z,e3z);
    Lib.MakeAllPath(dat,u,d,f8z,e3z);
END prependexepath;

PROCEDURE initFileNames (VAR exe,dat:ARRAY OF CHAR);
VAR
    u,d,f8,e3:str128;
BEGIN
    Lib.ParamStr(exe,0);
    UpperCase(exe); (* useless but... *)
    Lib.SplitAllPath(exe,u,d,f8,e3);
    Lib.MakeAllPath(dat,"","",f8,e3);
    Str.Subst(dat,extEXE,extTXT);
END initFileNames;

(* ------------------------------------------------------------ *)

TYPE
    f8e3 = ARRAY [0..8+1+3-1] OF CHAR;
CONST
    firstfile = 1;
    maxfile   = 200; (* should do *)
VAR
    fileArray : ARRAY [firstfile..maxfile] OF f8e3;

PROCEDURE legalextension (S:ARRAY OF CHAR):BOOLEAN;
VAR
    e3 : str16;
    n:CARDINAL;
    rc:BOOLEAN;
BEGIN

    Str.Caps(S); (* ah, lowercase LFNs... *)

    rc:=TRUE;
    n:=0;
    LOOP
        isoleItemS(e3, extensions,delim,n);
        IF same(e3,"") THEN EXIT; END;
        IF Str.Pos(S,e3) # MAX(CARDINAL) THEN rc:=FALSE;EXIT; END;
        INC(n);
    END;
    RETURN rc;
END legalextension;

PROCEDURE makebase (spec:ARRAY OF CHAR;VAR basepath:ARRAY OF CHAR );
CONST
    defaultdrive = SHORTCARD(0);
VAR
    u,d,n,e:str128;
BEGIN
    Lib.SplitAllPath(spec,u,d,n,e);
    Str.Concat(basepath,u,d);
    IF same(basepath,"") THEN
        Str.Concat(basepath, CHAR( ORD("A")-1+ FIO.GetDrive()), ":");
        FIO.GetDir(defaultdrive,d);
        Str.Append(basepath,d);
        fixDirectory(basepath); (* in case *)
    END;
END makebase;

PROCEDURE readDirectory (DEBUG:BOOLEAN;orgspec: ARRAY OF CHAR;
                         VAR basepath:ARRAY OF CHAR) : CARDINAL;
CONST
    dbgSpec = "::: Spec  : ";
    dbgEntry= "::: Entry : ";
    dbgYep  = "+++ Included !"+nl;
    dbgNope = "--- Excluded !"+nl;
VAR
    fentry    : FIO.DirEntry;
    count     : CARDINAL;
    found     : BOOLEAN;
    spec      : str128;
BEGIN
    Str.Copy(spec,orgspec);
    UpperCase(spec);
    makebase (spec,basepath);

    IF DEBUG THEN WrStr(dbgSpec);WrStr(spec);WrLn;END;

    count := 0;
    found := FIO.ReadFirstEntry(spec,allfiles,fentry);
    WHILE found DO
        IF count = (maxfile-firstfile+1) THEN RETURN MAX(CARDINAL);END;
        IF DEBUG THEN WrStr(dbgEntry);WrStr(fentry.Name);WrLn;END;
        IF legalextension(fentry.Name) THEN (* skip *.bk!, *.com and *.exe entries *)
            IF DEBUG THEN WrStr(dbgYep);END;
            fileArray[firstfile+count]:=f8e3(fentry.Name);
            Str.Caps(fileArray[firstfile+count]); (* useless ! *)
            INC (count);
        ELSE
            IF DEBUG THEN WrStr(dbgNope);END;
        END;
        found :=FIO.ReadNextEntry(fentry);
    END;
    RETURN count;
END readDirectory;

(* ripped from MPAUSE *)

PROCEDURE MouseDriverHere ( ) : BOOLEAN;
CONST
    MouseInt   = 033H;
CONST
    InstallChk = 00000H;
VAR
    R : SYSTEM.Registers;
BEGIN
    (*
    R.AX := InstallChk;
    Lib.Intr(R,MouseInt);
    RETURN (R.AX # 0);
    *)
    RETURN (MsMouse.Reset() # MAX(INTEGER) ); (* InstallChk is Reset ! *)
END MouseDriverHere;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    mincolumns  = 1+1+1+1+1;
    mintabwidth = 1;
    maxtabwidth = 64;
VAR
    parmcount,i,opt : CARDINAL;
    S,R             : str128;
    spec,basepath,exefile,datafile,indexfile : str128;
    cmdIndex,doWait, doBeautify, cmdStats, doStatsWide : BOOLEAN;
    doFrame, tabwidth,maxcolumns,LineWidth,screenwidth:CARDINAL;
    tagcount  : LONGCARD;
    state     : (waiting,gotDatafile);
    v         : LONGCARD;
    c1,c2     : CHAR;
    ink,paper,lastcookie,wantedcookie,rc,filecount : CARDINAL;
    savermode,stopmouse,atrandompos,docls,FRprompt,usemouse,exedirfirst:BOOLEAN;
    pause,alwayspause:CARDINAL;
    redirected,ok,chk:BOOLEAN;
    keycode:CARDINAL;
    mousebuttons:mousebuttonstype;
    DEBUG:BOOLEAN;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck:=FALSE;

    (* handleVesa; *) (* useless, because we won't change video mode *)
    setUseBiosMode ( IsRedirected() );
    findInkPaperAtStartup();
    colorhelp;

    redirected:=IsRedirected();

    screenwidth := getWindowWidth(); (* no longer -1, 80 no longer becomes 79 *)

    InitRnd();

    initFileNames(exefile,spec);

    cmdIndex   := FALSE;
    doFrame    := frameNone;
    doWait     := FALSE;
    doBeautify := FALSE;
    cmdStats   := FALSE;
    ink        := ORD(progink);
    paper      := ORD(progpaper);
    LineWidth  := screenwidth;
    maxcolumns := screenwidth;
    tabwidth   := 8;
    savermode  := FALSE;
    stopmouse  := FALSE;
    atrandompos:= FALSE;
    pause      := defaultpause;
    alwayspause:= defaultalwayspause;
    docls      := FALSE;
    wantedcookie:=UNSPECIFIED;
    FRprompt   := FALSE;
    usemouse   := TRUE;
    exedirfirst:= TRUE;
    DEBUG      := FALSE;

    state      := waiting;
    parmcount  := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);
        cleantabs(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "I"+delim+"INIT"+delim+
                                 "F:"+delim+"FRAME:"+delim+
                                 "W"+delim+"WAIT"+delim+
                                 "N"+delim+"NEWLINE"+delim+"CR"+delim+"CRLF"+delim+
                                 "I:"+delim+"INK:"+delim+
                                 "P:"+delim+"PAPER:"+delim+
                                 "B"+delim+"BIOS"+delim+
                                 "T:"+delim+"TAB:"+delim+
                                 "X"+delim+
                                 "XX"+delim+
                                 "W:"+delim+"WIDTH:"+delim+
                                 "S"+delim+"SAVER"+delim+"SHOW"+delim+
                                 "S:"+delim+"PAUSE:"+delim+
                                 "Z"+delim+"MOUSECLICK"+delim+
                                 "R"+delim+"RANDOMPOS"+delim+
                                 "C"+delim+
                                 "M:"+delim+"MINIMUM:"+delim+
                                 "SS"+delim+"SC"+delim+
                                 "N:"+delim+"NUMBER:"+delim+
                                 "M"+delim+"MOUSE"+delim+
                                 "WW"+delim+"WM"+delim+
                                 "P"+delim+
                                 "PP"+delim+
                                 "O"+delim+"ORDER"+delim+
                                 "DEBUG"
                              );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5 :
                cmdIndex := TRUE;
            | 6,7 :
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < minframe) OR (v > maxframe) ) THEN abort(errBadNumber,S); END;
                doFrame:=CARDINAL(v);
            | 8,9 :
                doWait  := TRUE;
            | 10,11,12,13:
                doBeautify  := TRUE;
            | 14,15:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolor) OR (v > maxcolor) ) THEN abort(errInkRange,"");END;
                ink:=CARDINAL(v);
            | 16,17:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolor) OR (v > maxcolor) ) THEN abort(errPaperRange,"");END;
                paper:=CARDINAL(v);
            | 18,19:
                setUseBiosMode ( TRUE );
            | 20,21:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mintabwidth) OR (v > maxtabwidth) ) THEN abort(errTabRange,"");END;
                tabwidth :=CARDINAL(v);
            | 22:
                cmdStats:=TRUE; doStatsWide := TRUE;
            | 23:
                cmdStats:=TRUE; doStatsWide := FALSE;
            | 24,25 :
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolumns) OR (v > LONGCARD(maxcolumns)) ) THEN abort(errWidthRange,"");END;
                LineWidth:=CARDINAL(v);
            | 26,27,28:
                savermode:=TRUE;
            | 29,30:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < minpause) OR (v > maxpause) ) THEN abort(errPauseRange,"");END;
                pause:=CARDINAL(v);
            | 31,32:
                stopmouse := TRUE;
            | 33,34:
                atrandompos:=TRUE;
            | 35:
                docls := TRUE;
            | 36,37:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < minpause) OR (v > maxpause) ) THEN abort(errPauseRange,"");END;
                alwayspause:=CARDINAL(v);
            | 38,39:
                savermode :=TRUE;
                docls     :=TRUE;
            | 40,41:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < firstCookie) OR (v > maxCookie) ) THEN abort(errCookieVal,S);END;
                wantedcookie:=CARDINAL(v);
            | 42,43:
                usemouse:=FALSE;
            | 44,45:
                doWait:=TRUE; usemouse:=FALSE;
            | 46:
                doWait:=TRUE;                  FRprompt:=TRUE;
            | 47:
                doWait:=TRUE; usemouse:=FALSE; FRprompt:=TRUE;
            | 48,49:
                exedirfirst:=FALSE;
            | 50:
                DEBUG:=TRUE;
            ELSE
                abort(errOption,S);
            END;
        ELSE
            CASE state OF
            | waiting :
                IF same(R,"?") THEN abort(errHelp,""); END;
                Str.Copy(spec,R); (* keep upper case here *)
            | gotDatafile :
                abort(errParameter,S);
            END;
            INC(state);
        END;
    END;

    IF same(spec,dot) THEN Str.Copy(spec,star+extTXT);END;
    IF same(spec,star) THEN Str.Copy(spec,star+extTXT);END;

    IF Str.CharPos(spec,dot)=MAX(CARDINAL) THEN Str.Append(spec,extTXT); END;

    IF f8e3format(spec) THEN (* try exe path *)
        Str.Copy(R,spec); (* R=original spec *)
        IF exedirfirst THEN prependexepath(exefile,spec); END;
        filecount := readDirectory(DEBUG,spec,basepath);
        CASE filecount OF
        | 0 :
            Str.Copy(spec,R);
            IF NOT(exedirfirst) THEN prependexepath(exefile,spec); END;
            filecount := readDirectory(DEBUG,spec,basepath);
            CASE filecount OF
            | 0 :
                abort(errNotFoundReally,spec);
            | MAX(CARDINAL) :
                abort(errTooManyFiles,spec);
            END;
        | MAX(CARDINAL) :
            abort(errTooManyFiles,spec);
        END;
    ELSE
        filecount := readDirectory(DEBUG,spec,basepath);
        CASE filecount OF
        | 0 :
            abort(errNotFound,spec); (* we had a full path *)
        | MAX(CARDINAL):
            abort(errTooManyFiles,spec);
        END;
    END;

    (* ------------------------------------------------------------ *)

    IF cmdStats THEN
        WrLn;
        FOR i:=firstfile TO (firstfile+filecount-1) DO
            Str.Concat(datafile,basepath,fileArray[i]);
            Str.Copy(indexfile,datafile);
            newExtension(indexfile,extNDX);
            IF FIO.Exists(indexfile)=FALSE THEN
                Str.Concat(S,"--- Index not found : ",indexfile);
                WrStr(S);WrLn;
            ELSE
                showIndexStatistics(indexfile,doStatsWide,DEBUG);
            END;
        END;
        abort(errNone,"");
    END;

    (* ------------------------------------------------------------ *)

    IF cmdIndex THEN
        WrLn;
        FOR i:=firstfile TO (firstfile+filecount-1) DO
            Str.Concat(datafile,basepath,fileArray[i]);
            Str.Copy(indexfile,datafile);
            newExtension(indexfile,extNDX);
            IF isReadOnly(indexfile) THEN (* of course, RW if file does not exist *)
                (*
                Str.Concat(S,"--- Index is read-only : ",indexfile);
                WrStr(S);WrLn;
                *)
                setReadWrite(S);
            ELSE
                buildIndex(datafile,indexfile,TRUE,UNSPECIFIED,lastcookie);
            END;
        END;
        abort(errNone,"");
    END;

    (* ------------------------------------------------------------ *)

    (* well, just serve us a cookie *)

    i:=GetRndCardRange(firstfile,firstfile+filecount-1);
    Str.Concat(datafile,basepath,fileArray[i]);
    Str.Copy(indexfile,datafile);
    newExtension(indexfile,extNDX);

    IF FIO.Exists(indexfile)=FALSE THEN
        buildIndex(datafile,indexfile,FALSE,UNSPECIFIED,lastcookie);
    ELSE
        IF isReadOnly(indexfile) THEN (* of course, RW if file does not exist *)
            (* abort(errReadOnlyIndex,indexfile); *)
            setReadWrite(indexfile);
        END;
    END;

    CASE savermode OF
    | FALSE:
        IF atrandompos THEN
            abort(errNotInNormalMode,"-r option is a nonsense without -s option !");
        END;
        IF stopmouse THEN
            abort(errNotInNormalMode,"-z option is a nonsense without -s option !");
        END;
        IF wantedcookie # UNSPECIFIED THEN
            IF filecount # 1 THEN abort(errNotWithMultifile,"");END;
            buildIndex(datafile,indexfile,FALSE,wantedcookie,lastcookie);
            IF ( (wantedcookie < firstCookie) OR (wantedcookie > lastcookie) ) THEN
                Str.Copy(S, fmtbignum( LONGCARD(lastcookie), 10,1," ") );
                Str.Prepend(S," valid range is [1..");
                Str.Append(S,"] !");
                Str.Prepend(S,datafile);
                abort(errCookieRange,S);
            END;
        END;
        IF getCookie(datafile,indexfile,doFrame,tabwidth,LineWidth,wantedcookie,DEBUG,lastcookie) = FALSE THEN
            (* tags' well is dry, ressource it ! *)
            buildIndex(datafile,indexfile,FALSE,UNSPECIFIED,lastcookie);
            ok:=getCookie(datafile,indexfile,doFrame,tabwidth,LineWidth,UNSPECIFIED,DEBUG,lastcookie); (* should always be TRUE *)
        END;

        colortext( ink,paper );
        dmpCookie(screenwidth,LineWidth,doFrame,redirected,doBeautify);
        colorhelp;

        IF doWait THEN
            IF usemouse THEN usemouse:=MouseDriverHere();END;
            IF usemouse THEN
                IF FRprompt THEN
                    S:=msgWaitMouseFR;
                ELSE
                    S:=msgWaitMouse;
                END;
            ELSE
                IF FRprompt THEN
                    S:=msgWaitFR;
                ELSE
                    S:=msgWait;
                END;
            END;
            video(S,TRUE);
            (* BiosWaitkey(c1,c2); *)
            LOOP
                IF usemouse THEN
                    IF mouseclick() THEN EXIT; END;
                END;
                IF getKeyboardCode(keycode) THEN EXIT; END;
            END;
            video(S,FALSE);
        END;
    | TRUE:
        IF wantedcookie # UNSPECIFIED THEN
            abort(errNotInSaverMode,"-n:# option is a nonsense in screensaver mode !");
        END;
        IF redirected THEN
             abort(errNotInSaverMode,"Redirection is a nonsense in screensaver mode !");
        END;
        flushKeyboard;
        setCursorShape(invisiblecursor);
        IF stopmouse THEN stopmouse:=MouseDriverHere();END;
        LOOP
            colorhelp;
            cls;
            colortext( ink,paper );
            IF getCookie (datafile,indexfile,doFrame,tabwidth,LineWidth,UNSPECIFIED,DEBUG,lastcookie)=FALSE THEN
                (* tags' well is dry, ressource it ! *)
                 buildIndex(datafile,indexfile,FALSE,UNSPECIFIED,lastcookie);
                 ok:=getCookie(datafile,indexfile,doFrame,tabwidth,LineWidth, UNSPECIFIED,DEBUG,lastcookie); (* should always be TRUE *)
            END;
            colortext( ink,paper );
            dmpCookieAt(doFrame,alwayspause,pause,atrandompos,stopmouse);
            chk:=getKeyboardCode(keycode);
            IF chk THEN
                CASE keycode OF
                | keyEscape     : EXIT;
             (* | keyCR         : EXIT; *)
                END;
            END;
            IF stopmouse THEN
                (* IF mouseclick() THEN *)
                    mousebuttons:=getLastPressed();
                    IF (rightbutton IN mousebuttons) THEN EXIT; END;
                (* END; *)
            END;

            i:=GetRndCardRange(firstfile,firstfile+filecount-1);
            Str.Concat(datafile,basepath,fileArray[i]);
            Str.Copy(indexfile,datafile);
            newExtension(indexfile,extNDX);

            IF FIO.Exists(indexfile)=FALSE THEN
                buildIndex(datafile,indexfile,FALSE,UNSPECIFIED,lastcookie);
            ELSE
                IF isReadOnly(indexfile) THEN (* of course, RW if file does not exist *)
                   (* abort(errReadOnlyIndex,indexfile); *)
                   setReadWrite(indexfile);
                END;
            END;

        END;
        colorhelp;
        IF docls THEN  cls; ELSE WrLn; END;
        setCursorShape(oldcursor);
    END;

    abort(errNone,"");
END Fortune.

(*

using Linux Red Hat 5.1 fortune cookie FORTUNES.ZIP (about 12000)

art
ascii-ar
computer
cookie
definiti
drugs
educatio
ethnic
food
fortunes
goedel
humorist
kids
law
linuxcoo
literatu
love
magic
medicine
men-wome
miscella
news
people
pets
platitud
politics
riddles
science
songs-po
sports
startrek
translat
wisdom
work

*)
