(* ---------------------------------------------------------------
Title         Q&D Yi King
Author        PhG
Overview
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE YiKing;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT BiosIO;
IMPORT SYSTEM;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetString, CharCount, same,
aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode, str16,
getCurrentDirectory, cleantabs;

FROM QD_rand IMPORT InitRnd, GetRnd, GetRndCardRange;

FROM QD_Text IMPORT
colortype, cursorshapetype, scrolltype,
ff, cr, lf, bs, tab, nl, mincolor, maxcolor,
BW40, CO40, BW80, CO80, CO80x43, CO80x50, MONO,
vesa80x60, vesa132x25, vesa132x43, vesa132x50, vesa132x60,
selectCursorEmulation,
setCursorShape,
handleVesa, setBrightPaper, setBlinkMode,
setFillChar, setFillInk, setFillPaper,
setFillInkPaper, setTxtInk, setTxtPaper, setTxtInkPaper, setWrapMode,
setUseBiosMode, setTabWidth, getScreenData, setWindow,
setMode, restoreMode,
gotoXY, xyToHtabVtab, home, setVisualPage, setActivePage,
scrollWindow, fillTextAttr, cls, writeStr, writeLn, getScreenWidth,
getScreenHeight, getScreenMinX, getScreenMinY, getScreenMaxX, getScreenMaxY,
getMinHtab, getMaxHtab, getMinVtab, getMaxVtab, getUseBiosMode,
getMinHtab, getMaxHtab, getMinVtab, getMaxVtab, getHtab, getVtab,
getWindowWidth, getWindowHeight,
initScreenConsole,
findInkPaperAtStartup, getInkAtStartup, getPaperAtStartup;

(* ------------------------------------------------------------ *)

CONST
    WrStr  ::= writeStr;
    WrLn   ::= writeLn;
    WrChar ::= writeStr;

PROCEDURE vidinit ( redirected:BOOLEAN );
BEGIN
    (* handleVesa; *) (* useless, because we won't change video mode *)
    setUseBiosMode ( redirected );
    findInkPaperAtStartup();
    setTxtInk(getInkAtStartup());      (* was green *)
    setTxtPaper(getPaperAtStartup());  (* was black *)
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END vidinit;

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "YIKING";
    ProgTitle     = "Q&D Yi King";
    ProgVersion   = "v1.0c";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    extEXE        = ".EXE";
    extDAT        = ".DAT";
    extRPT        = ".RPT";
    extTMP        = ".$$$";
    workfile      = ProgEXEname+extTMP;
    reportfile    = ProgEXEname+extRPT;

    blank         = " ";
    dot           = ".";
    escape        = CHR(27);

CONST
    errNone             = 0;
    errHelp             = 1;
    errOption           = 2;
    errTooManyParameters= 3;
    errBadNumber        = 4;
    errBadRange         = 5;
    errEitherOr         = 6;
    errNotFound         = 7;
    errAborted          = 8;
    errSilly            = 9;
    errRedirected       = 10;

    errImpossible       = 128;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
00000000011111111112222222222333333333344444444445555555555666666666677777777778
1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp =
Banner+nl+
nl+
"Syntax 1 : "+ProgEXEname+" <s|c> [-w] [-r]"+nl+
"Syntax 2 : "+ProgEXEname+" <hexagram> [hexagram] [-w] [-r]"+nl+
nl+
"This program casts (syntax 1) and/or explains (syntax 2) a Yi King hexagram."+nl+
'With syntax 1, "S" stands for yarrow sticks toss, and "C" for coins toss.'+nl+
nl+
"-w  do not wait for keypress"+nl+
"-r  do not create "+reportfile+" report file in current directory"+nl+
nl+
"Of course, this computerized method cannot replace real yarrow sticks ! ;-)"+nl+
nl+
"Examples : "+ProgEXEname+" s"+nl+
"           "+ProgEXEname+" c -w"+nl+
"           "+ProgEXEname+" 63 -r"+nl+
"           "+ProgEXEname+" 42 3"+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msgHelp);
    | errOption :
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errTooManyParameters:
        Str.Concat(S,einfo," is just one parameter too many !");
    | errBadNumber :
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," number !");
    | errBadRange:
        Str.Concat(S,einfo," is not in legal [1..64] range !");
    | errEitherOr:
        S:="You must either cast a hexagram or explain a hexagram !";
    | errNotFound:
        Str.Concat(S,"Interpretation file ",einfo);Str.Append(S," does not exist !");
    | errAborted:
        S := "Aborted by user !";
    | errSilly:
        S := "Source and target hexagrams must be different !";
    | errRedirected:
        S := "Redirection is a bad idea here !";

    | errImpossible :
        S := "Impossible (!) problem in the cast algorithm !";

    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp :
        ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
VAR
    ioBuffer        : ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    hin,hout        : FIO.File; (* globerk *)

PROCEDURE print (tofile:BOOLEAN;S:ARRAY OF CHAR);
BEGIN
    WrStr(S);
    IF tofile THEN FIO.WrStr(hout,S);END;
END print;

PROCEDURE newline (tofile:BOOLEAN);
BEGIN
    WrLn;
    IF tofile THEN FIO.WrLn(hout);END;
END newline;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE withinRange (v,mini,maxi:LONGCARD):BOOLEAN;
BEGIN
    IF v < mini THEN RETURN FALSE;END;
    RETURN (v <= maxi);
END withinRange;

(*
PROCEDURE fmtstring (S:ARRAY OF CHAR; pad:CHAR; n:INTEGER ) : str80;
VAR
    R : str80;
BEGIN
    Str.Copy(R,S);
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(n) THEN EXIT; END;
        IF n < 0 THEN
            Str.Append(R,pad); (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtstring;
*)

PROCEDURE fmtlc (v : LONGCARD; pad:CHAR; sep:CHAR; field:INTEGER) : str16;
VAR
    S,R   : str16;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr(v,S,10,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtlc;

PROCEDURE fmtc (v : CARDINAL; pad:CHAR; sep:CHAR; field:INTEGER) : str16;
BEGIN
    RETURN fmtlc (LONGCARD(v),pad,sep,field);
END fmtc;

(* ------------------------------------------------------------ *)

PROCEDURE WaitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END WaitVGAretrace;

PROCEDURE retrace ();
VAR
    i:CARDINAL;
BEGIN
    FOR i:=1 TO 4 DO
        WaitVGAretrace;
    END;
END retrace;


CONST
    backspace = CHR(8);
    anim      = "-\|/";
    firstAnim = 0;
    lastAnim  = 3;
VAR
    indexW : CARDINAL;

PROCEDURE InitWorking (  );
BEGIN
    setCursorShape(invisiblecursor);
    indexW := firstAnim;
END InitWorking;

PROCEDURE ShowWorking (  );
VAR
    ch : CHAR;
BEGIN
    retrace;
    ch := anim[indexW];
    WrStr(ch);
    WrStr(backspace);
    INC(indexW);
    IF indexW > lastAnim THEN
        indexW := firstAnim;
    END;
END ShowWorking;

PROCEDURE CloseWorking (  );
BEGIN
    WrStr(blank);
    WrStr(backspace);
    setCursorShape(oldcursor);
END CloseWorking;

(* ------------------------------------------------------------ *)

PROCEDURE RdKey (anim:BOOLEAN;VAR c1,c2:CHAR);
VAR
    r  : REAL;
BEGIN
    IF anim THEN InitWorking; END;
    WHILE ( BiosIO.KeyPressed () = FALSE ) DO
        r := GetRnd();
        IF anim THEN ShowWorking; END;
    END;
    IF anim THEN CloseWorking; END;
    c1:=BiosIO.RdKey();
    c2:=CHR(0);
    IF c1 = CHR(0) THEN c2:=BiosIO.RdKey();END;
END RdKey;

PROCEDURE waitForKey (anim:BOOLEAN) : str2;
VAR
    c1,c2:CHAR;
    ch : str2;
BEGIN
    RdKey(anim,c1,c2);
    IF c1=CHR(0) THEN
        Str.Concat(ch,c2,c2);
    ELSE
        Str.Copy(ch,c1);
    END;
    RETURN ch;
END waitForKey;

PROCEDURE hitanykey (doit:BOOLEAN );
CONST
    msg = "Hit (almost) any key to continue... ";
VAR
    i : CARDINAL;
    ch: str2;
BEGIN
    IF NOT(doit) THEN RETURN; END;
    WrStr(msg);
    ch:=waitForKey(FALSE);
    FOR i:=1 TO Str.Length(msg) DO
        WrStr(backspace+blank+backspace);
    END;
END hitanykey;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    VieuxYang = 9; (* -------- *)
    VieuxYin  = 6; (* --- x --- *)
    JeuneYang = 7; (* --------- *)
    JeuneYin  = 8; (* ---   --- *)
CONST
    firstLine = 1;
    lastLine  = 6;
    sourceHexagram  = 1;
    targetHexagram  = 2;
VAR
    castLine : ARRAY[firstLine..lastLine],[sourceHexagram..targetHexagram] OF CARDINAL;
    strLine  : ARRAY[firstLine..lastLine],[sourceHexagram..targetHexagram] OF str80;

PROCEDURE getTrait ( value : CARDINAL ) : str80;
CONST
    hline      = CHR(196);
    tobesplit  = CHR(197);
    tobefilled = CHR(249);
VAR
    s : str80;
    i : CARDINAL;
BEGIN
    CASE value OF
    | VieuxYang :
        s := "----0----"; (* 9 *)
    | VieuxYin :
        s := "--- x ---"; (* 6 *)
    | JeuneYang :
        s := "---------";
    | JeuneYin :
        s := "---   ---";
    END;
    LOOP
        i := Str.CharPos(s,"-");
        IF i = MAX(CARDINAL) THEN EXIT; END;
        Str.Subst(s,"-",hline);
    END;
    Str.Subst(s,"0",tobesplit);
    Str.Subst(s,"x",tobefilled);
    RETURN s;
END getTrait;

PROCEDURE Ordinal (v : CARDINAL ) : str80;
VAR
    s : str80;
BEGIN
    CASE v OF
    | 1 : s:= " at the beginning";
    | 2 : s:= " at second line";
    | 3 : s:= " at third line";
    | 4 : s:= " at fourth line";
    | 5 : s:= " at fifth line"
    | 6 : s:= " at the top";
    END;
    RETURN s;
END Ordinal;

CONST
    sep2 = "  ";
    sep4 = "    ";

PROCEDURE getsepwidth():CARDINAL;
CONST
    smax = "--- x ---"+sep2+"(# at the beginning)"+sep4;
BEGIN
    RETURN Str.Length(smax);
END getsepwidth;

PROCEDURE transformation (VAR v:CARDINAL);
BEGIN
    CASE v OF
    | VieuxYang : v:= JeuneYin;    (* 9 --> 8 *)
    | VieuxYin :  v:= JeuneYang;   (* 6 --> 7 *)
    END;
END transformation;

(* we simulate the real hand process here ! *)

PROCEDURE Process ( tas : CARDINAL  ) : CARDINAL;
BEGIN
    WHILE tas > 4 DO
        DEC(tas,4);
    END;
    RETURN tas;
END Process;

PROCEDURE CastSticks (VAR tirage:CARDINAL) : BOOLEAN;
CONST
    totalSticks = 50;
    block       = CHR(254);
VAR
    sticks    : CARDINAL;
    gauche    : CARDINAL;
    droite    : CARDINAL;
    splitat   : CARDINAL;
    reste     : CARDINAL;
    i         : CARDINAL;
    ch        : str2;
BEGIN
    sticks := totalSticks;
    DEC (sticks);
    tirage := 0;
    FOR i := 1 TO 3 DO
        BiosFlushkey;
        ch := waitForKey(TRUE);
        IF ch = str2(escape) THEN
            (* IF i > 1 THEN WrStr(" "); END;
            WrStr("Cancelled !"); *)
            RETURN FALSE;
        END;
        WrStr(block+block+block);
        splitat := GetRndCardRange(1,sticks);
        gauche := sticks - splitat;
        droite := sticks - gauche;
        DEC (droite);
        reste := 1;
        INC (reste, Process(gauche));
        INC (reste, Process(droite));
        DEC (sticks,reste);
        CASE reste OF
        | 5,4 :
             reste := 3;
        | 9,8 :
             reste := 2;
        ELSE
             abort(errImpossible,"");
        END;
        INC (tirage,reste);
    END;
    RETURN TRUE;
END CastSticks;

PROCEDURE CastCoins (VAR tirage : CARDINAL) : BOOLEAN;
CONST
    coteGrave = 0;
    coteLisse = 1;
VAR
    i    : CARDINAL;
    face : CARDINAL;
    ch   : str2;
BEGIN
    tirage := 0;
    FOR i := 1 TO 3 DO
        BiosFlushkey;
        ch := waitForKey(TRUE);
        IF ch = str2(escape) THEN
            (* IF i > 1 THEN WrStr(" "); END;
            WrStr("Cancelled !"); *)
            RETURN FALSE;
        END;
        WrStr(CHR(254));
        face := GetRndCardRange(0,1);
        CASE face OF
        | coteGrave :
            face := 2;
        | coteLisse :
            face := 3;
        END;
        INC (tirage,face);
    END;
    RETURN TRUE;
END CastCoins;

CONST
    firstTrigram  = 1;
    lastTrigram   = 8;
    trigramCount  = lastTrigram-firstTrigram+1;
    firstHexagram = 1;
    lastHexagram  = 64;
TYPE
    hexarraytype = ARRAY [firstHexagram..lastHexagram] OF CARDINAL;
CONST
    hexarray = hexarraytype (
          1, 34,  5, 26, 11,  9, 14, 43,
         25, 51,  3, 27, 24, 42, 21, 17,
          6, 40, 29,  4,  7, 59, 64, 47,
         33, 62, 39, 52, 15, 53, 56, 31,
         12, 16,  8, 23,  2, 20, 35, 45,
         44, 32, 48, 18, 46, 57, 50, 28,
         13, 55, 63, 22, 36, 37, 30, 49,
         10, 54, 60, 41, 19, 61, 38, 58);

(* Code Police definitely should have a look at this ugly code ! ;-) *)

TYPE
    trigramtype = ARRAY [1..3] OF CARDINAL;
CONST
    plein = JeuneYang;
    creux = JeuneYin;
    tri1  = trigramtype(plein,plein,plein); (* K'ien *)
    tri2  = trigramtype(creux,creux,plein); (* Tchen *)
    tri3  = trigramtype(creux,plein,creux); (* K'an *)
    tri4  = trigramtype(plein,creux,creux); (* Ken *)
    tri5  = trigramtype(creux,creux,creux); (* K'ouen *)
    tri6  = trigramtype(plein,plein,creux); (* Souen *)
    tri7  = trigramtype(plein,creux,plein); (* Li *)
    tri8  = trigramtype(creux,plein,plein); (* Touei *)

PROCEDURE getTrigram (l1,l2,l3:CARDINAL):CARDINAL;
VAR
    trigram : trigramtype;
    i : CARDINAL;
BEGIN
    trigram[1]:=l1;
    trigram[2]:=l2;
    trigram[3]:=l3;
    (* here, convert moving lines to static ones *)
    FOR i:= 1 TO 3 DO
        CASE trigram[i] OF
        | VieuxYang : trigram[i]:=JeuneYang;
        | VieuxYin  : trigram[i]:=JeuneYin;
        END;
    END;
    IF trigram = tri1 THEN RETURN 1;END;
    IF trigram = tri2 THEN RETURN 2;END;
    IF trigram = tri3 THEN RETURN 3;END;
    IF trigram = tri4 THEN RETURN 4;END;
    IF trigram = tri5 THEN RETURN 5;END;
    IF trigram = tri6 THEN RETURN 6;END;
    IF trigram = tri7 THEN RETURN 7;END;
    IF trigram = tri8 THEN RETURN 8;END;
    RETURN 0; (* cannot happen ! *)
END getTrigram;

PROCEDURE getHexagram (superior,inferior:CARDINAL ):CARDINAL ;
VAR
    i : CARDINAL;
BEGIN
    DEC(superior,firstTrigram); (* 1..8 -> 0..7 *)
    DEC(inferior,firstTrigram);
    i := inferior * trigramCount + superior;
    RETURN hexarray[firstHexagram+i];
END getHexagram;

PROCEDURE gettrigramshape (n:CARDINAL) : trigramtype;
BEGIN
    CASE n OF
    | 1 : RETURN tri1;
    | 2 : RETURN tri2;
    | 3 : RETURN tri3;
    | 4 : RETURN tri4;
    | 5 : RETURN tri5;
    | 6 : RETURN tri6;
    | 7 : RETURN tri7;
    | 8 : RETURN tri8;
    END;
END gettrigramshape;

PROCEDURE dumpHexagram (n:CARDINAL;tofile:BOOLEAN);
VAR
    superior,inferior,i,line:CARDINAL;
    S : str128;
    trigram : trigramtype;
BEGIN
    i := firstHexagram;
    LOOP
        IF n = hexarray[i] THEN EXIT; END;
        INC(i);
        IF i > lastHexagram THEN EXIT; END; (* argh... *)
    END;
    DEC(i,firstHexagram);
    superior := i MOD trigramCount;
    inferior := i DIV trigramCount;
    INC(superior,firstTrigram);
    INC(inferior,firstTrigram);
    line := lastLine;
    trigram:=gettrigramshape(superior);
    FOR i := 1 TO 3 DO
        Str.Concat(S,"Line ",fmtc(line,blank,dot,1));
        Str.Append(S,sep2);
        (* Str.Copy(S,""); *)
        CASE trigram[i] OF
        | plein : Str.Append(S,getTrait(JeuneYang));
        | creux : Str.Append(S,getTrait(JeuneYin));
        END;
        print(tofile,S);newline(tofile);
        DEC(line);
    END;
    trigram:=gettrigramshape(inferior);
    FOR i := 1 TO 3 DO
        Str.Concat(S,"Line ",fmtc(line,blank,dot,1));
        Str.Append(S,sep2);
        (* Str.Copy(S,""); *)
        CASE trigram[i] OF
        | plein : Str.Append(S,getTrait(JeuneYang));
        | creux : Str.Append(S,getTrait(JeuneYin));
        END;
        print(tofile,S);newline(tofile);
        DEC(line);
    END;
    newline(tofile);
END dumpHexagram;

(* ------------------------------------------------------------ *)

PROCEDURE dumpThis (R : ARRAY OF CHAR;header:ARRAY OF CHAR;tofile:BOOLEAN);
CONST
    wi = 8;
VAR
    tmp        : str256;
    splitagain : BOOLEAN;
    LineWidth  : CARDINAL;
BEGIN
    LineWidth := getWindowWidth()-wi-Str.Length(header);
    splitagain:=dmpTTX(R,LineWidth,tmp,TRUE);
    WHILE splitagain DO
        print(tofile,header);print(tofile,tmp);newline(tofile);
        splitagain:=dmpTTX(R,LineWidth,tmp,FALSE);
    END;
    newline(tofile);
END dumpThis;

PROCEDURE dumpText (hexnum:CARDINAL;hexastr,file:ARRAY OF CHAR;
                    tofile:BOOLEAN;index:CARDINAL;
                    VAR pos:LONGCARD );
CONST
    (*        Text for hexagram ## *)
    dashes = "--------------------";
    id     = "0=";
VAR
    hugestr : str1024;
    section : str16;
    state   : (waiting,found);
    S1,S2   : str80;
    i       : CARDINAL;
BEGIN
    Str.Copy(S2,dashes);
    IF hexastr[1] = CHR(0) THEN Str.Delete(S2,0,1);END;
    Str.Concat(S1,"Text for hexagram ",hexastr);
    print(tofile,S2);newline(tofile);
    print(tofile,S1);newline(tofile);
    print(tofile,S2);newline(tofile);
    newline(tofile);

    IF hexnum = 0 THEN (* interactive mode *)
        IF tofile THEN
            FOR i := lastLine TO firstLine BY -1 DO (* // bugfix : was firstLine TO lastLine !!! *)

                FIO.WrStr(hout,"Line ");
                FIO.WrStr(hout,fmtc(i,blank,dot,1));
                FIO.WrStr(hout,sep2);

                FIO.WrStr(hout,strLine[i,index]);FIO.WrLn(hout);
            END;
            FIO.WrLn(hout);
        END;
    ELSE
        dumpHexagram(hexnum,tofile);
    END;

    Str.Concat(section,"[",hexastr);Str.Append(section,"]");
    hin:=FIO.OpenRead(file);
    FIO.AssignBuffer(hin,ioBuffer);
    state := waiting;
    FIO.EOF:=FALSE;
    LOOP
        IF FIO.EOF THEN EXIT;END;
        FIO.RdStr(hin,hugestr);
        IF FIO.EOF THEN EXIT; END;
        LtrimBlanks(hugestr); (* useless ! *)
        RtrimBlanks(hugestr); (* useless too ! *)
        CASE state OF
        | waiting:
            IF same(hugestr,section) THEN state := found; END;
        | found:
            IF Str.Pos(hugestr,id)#0 THEN EXIT; END;
            pos:=FIO.GetPos(hin); (* keep next line position *)
            Str.Subst(hugestr,id,"");
            dumpThis(hugestr,"",tofile);
        END;
    END;
    FIO.Close(hin);
    IF state = waiting THEN
        print(tofile,"Ooops, I think my datafile is corrupted !");newline(tofile);
        newline(tofile);
    END;
END dumpText;

PROCEDURE dumpSpecial (line,at:CARDINAL;filepos:LONGCARD;file:ARRAY OF CHAR;
                       hypothese,tofile:BOOLEAN);
VAR
    hugestr : str1024;
    id      : str16;
BEGIN
    id := fmtc(at,blank,dot,1); Str.Append(id,"=");

    hin:=FIO.OpenRead(file);
    FIO.AssignBuffer(hin,ioBuffer); FIO.Seek(hin,filepos);
    FIO.EOF:=FALSE;
    LOOP
        IF FIO.EOF THEN EXIT;END;
        FIO.RdStr(hin,hugestr);
        IF FIO.EOF THEN EXIT; END;
        LtrimBlanks(hugestr); (* useless ! *)
        RtrimBlanks(hugestr); (* useless too ! *)
        IF Str.Pos(hugestr,id) = 0 THEN EXIT; END;
    END;
    FIO.Close(hin);
    IF hypothese THEN
        Str.Delete(hugestr,0,2); (* remove "#=" header *)
        Str.Prepend(hugestr," : ");
        Str.Prepend(hugestr,Ordinal(at));
        Str.Prepend(hugestr,"If moving line");
    ELSE
        Str.Subst(hugestr,id,"");
        Str.Prepend(hugestr," : ");
        Str.Prepend(hugestr,Ordinal(at));
        Str.Prepend(hugestr,fmtc(line,blank,dot,1));
    END;
    dumpThis(hugestr,sep4,tofile);
END dumpSpecial;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    sMethods      = "C"+delim+"COINS"+delim+
                    "S"+delim+"STICKS"+delim+
                    "P"+delim+"PIECES"+delim+
                    "T"+delim+"TIGES";
    firsthexagram = 1;
    lasthexagram  = 64;
VAR
    report               : BOOLEAN;
    pause                : BOOLEAN;
VAR
    parm1,parm2,datafile : str128;
    cmd                  : (usecoins,usesticks,explainOne,explainTwo);
    hexagram1,hexagram2  : CARDINAL;
    mutate               : CARDINAL;
    htab,vtab            : CARDINAL;
    rc                   : BOOLEAN;
    superiortrigram,inferiortrigram : CARDINAL;
    mainhexagram,secondaryhexagram  : CARDINAL;
    mainhexStr,secondaryhexStr      : str16;
    v1,v2,v3             : CARDINAL;
    filepos              : LONGCARD;
VAR
    parmcount, i, opt    : CARDINAL;
    S, R                 : str128;
    state                : (waiting,gotparm1,gotparm2);
    v                    : LONGCARD;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    vidinit( IsRedirected() );
    pause     := TRUE;
    report    := TRUE;

    WrLn; (* here for pretty output *)

    (* IF IsRedirected() THEN abort(errRedirected,"");END; done later now *)

    InitRnd();

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    state := waiting;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R)=TRUE THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "W"+delim+"NOWAIT"+delim+
                                 "R"+delim+"NOREPORT"
                              );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5:
                pause:=FALSE;
            | 6,7:
                report:=FALSE;
            ELSE
                abort(errOption,S);
            END;
        ELSE
            CASE state OF
            | waiting :
                IF same(R,"?") THEN abort(errHelp,""); END;
                Str.Copy(parm1,R); (* keep upper case here *)
            | gotparm1 :
                Str.Copy(parm2,R); (* keep upper case here *)
            ELSE
                abort(errTooManyParameters,S);
            END;
            INC(state);
        END;
    END;

    CASE state OF
    | waiting : abort(errHelp,"");
    | gotparm1,gotparm2:
        i:=getStrIndex(delim,parm1,sMethods);
        CASE i OF
        | 1,2:
            cmd := usecoins;
        | 3,4:
            cmd := usesticks;
        | 5,6:
            cmd := usecoins;
        | 7,8:
            cmd := usesticks;
        ELSE
            IF GetLongCard(parm1,v)=FALSE THEN
                abort(errBadNumber,parm1);
            END;
            IF withinRange(v,LONGCARD(firsthexagram),LONGCARD(lasthexagram))=FALSE THEN
                abort(errBadRange,parm1);
            END;
            hexagram1 := CARDINAL(v);
            cmd       := explainOne;
        END;
    END;

    IF state=gotparm2 THEN
        CASE cmd OF
        | usecoins,usesticks:
            abort(errEitherOr,"");
        | explainOne:
            IF GetLongCard(parm2,v)=FALSE THEN
                abort(errBadNumber,parm2);
            END;
            IF withinRange(v,LONGCARD(firsthexagram),LONGCARD(lasthexagram))=FALSE THEN
                abort(errBadRange,parm2);
            END;
            hexagram2 := CARDINAL(v);
            cmd       := explainTwo;
        END;
    END;

    Lib.ParamStr(datafile,0);
    UpperCase(datafile); (* useless but... *)
    Str.Subst(datafile,extEXE,extDAT);
    IF FIO.Exists(datafile)=FALSE THEN abort(errNotFound,datafile);END;
    CASE cmd OF
    | explainOne,explainTwo:
        IF hexagram1=hexagram2 THEN abort(errSilly,"");END;
    END;

    IF IsRedirected() THEN abort(errRedirected,"");END;

    IF report THEN
        getCurrentDirectory(S);
        Str.Append(S,workfile);
        IF FIO.Exists(S) THEN FIO.Erase(S);END;
        hout:=FIO.Create(S); (* it is unlikely it will be readonly ! *)
        FIO.WrLn(hout);
    END;

    CASE cmd OF
    | usecoins,usesticks:
        S:="Casting a Yi King hexagram using ";
        IF cmd=usesticks THEN
            R:="yarrow sticks";
        ELSE
            R:="coins toss";
        END;
        Str.Append(S,R);Str.Append(S,". Think about your question now !"+nl);
        WrStr(S);
        WrLn;
        WrStr("(For each line, hit any key three times, or Escape to abort.)"+nl);
        WrLn;
        FOR i:=firstLine TO lastLine DO
            WrLn;
        END;
        vtab:=getVtab();
        mutate := 0;
        i := firstLine;
        LOOP
            gotoXY(getMinHtab(),vtab-i);
            Str.Concat(S,"Line ",fmtc(i,blank,dot,1));
            Str.Append(S,sep2);
            WrStr(S);
            htab := getHtab();
            IF cmd=usesticks THEN
                rc:= CastSticks(opt);
            ELSE
                rc:= CastCoins(opt);
            END;
            IF rc=FALSE THEN EXIT; END;
            castLine[i,sourceHexagram]:=opt;
            gotoXY(htab,vtab-i);
            Str.Copy(S,getTrait(opt));
            CASE opt OF
            | VieuxYang,VieuxYin :
                Str.Append(S,sep2);
                Str.Append(S,"(");
                Str.Append(S,fmtc(opt,blank,dot,1));
                Str.Append(S,Ordinal(i));
                Str.Append(S,")");
                INC(mutate);
            END;
            WrStr(S);
            Str.Copy(strLine[i,sourceHexagram],S);

            INC(i);
            IF i > lastLine THEN EXIT; END;
        END;
        IF ((mutate # 0) AND rc) THEN
            INC(htab,getsepwidth());
            FOR i:=firstLine TO lastLine DO
                gotoXY(htab,vtab-i);
                Str.Concat(S,"Line ",fmtc(i,blank,dot,1));
                Str.Append(S,sep2);
                WrStr(S);
                opt:=castLine[i,sourceHexagram];
                transformation(opt);
                castLine[i,targetHexagram]:=opt;
                Str.Copy(S,getTrait(opt));
                WrStr(S);
                Str.Copy(strLine[i,targetHexagram],S);
            END;
        END;
        gotoXY(getMinHtab(),vtab);
        WrLn;
        IF rc=FALSE THEN
            IF report THEN
                FIO.Close(hout);
                FIO.Erase(workfile);
            END;
            abort(errAborted,"");
        END;

        i:=sourceHexagram;
        v1:=castLine[6,i]; v2:=castLine[5,i]; v3:=castLine[4,i];
        superiortrigram:=getTrigram(v1,v2,v3);
        v1:=castLine[3,i]; v2:=castLine[2,i]; v3:=castLine[1,i];
        inferiortrigram:=getTrigram(v1,v2,v3);
        mainhexagram:=getHexagram(superiortrigram,inferiortrigram);
        IF mutate # 0 THEN
            i:=targetHexagram;
            v1:=castLine[6,i]; v2:=castLine[5,i]; v3:=castLine[4,i];
            superiortrigram:=getTrigram(v1,v2,v3);
            v1:=castLine[3,i]; v2:=castLine[2,i]; v3:=castLine[1,i];
            inferiortrigram:=getTrigram(v1,v2,v3);
            secondaryhexagram:=getHexagram(superiortrigram,inferiortrigram);
        END;

        gotoXY(getMinHtab(),getVtab());
        mainhexStr := fmtc(mainhexagram,blank,dot,1);
        Str.Concat(S,"Hexagram ",mainhexStr); WrStr(S);
        IF mutate # 0 THEN
            gotoXY(htab,getVtab());
            secondaryhexStr:=fmtc(secondaryhexagram,blank,dot,1);
            Str.Concat(S,"Hexagram ",secondaryhexStr); WrStr(S);
        END;
        WrLn;
        WrLn; (* required blank line ! *)
        hitanykey(pause);
        dumpText(0,mainhexStr,datafile,report,sourceHexagram,filepos);
        FOR i := firstLine TO lastLine DO
            opt := castLine[i,sourceHexagram];
            CASE opt OF
            | VieuxYang,VieuxYin:
                dumpSpecial(opt,i,filepos,datafile,FALSE,report);
            END;
        END;

        IF mutate # 0 THEN
            hitanykey(pause);
            dumpText(0,secondaryhexStr,datafile,report,targetHexagram,filepos);
        END;
    | explainOne,explainTwo:
        mainhexStr := fmtc(hexagram1,blank,dot,1);
        dumpText(hexagram1,mainhexStr,datafile,report,sourceHexagram,filepos);
        hitanykey(pause);
        FOR i := firstLine TO lastLine DO
            dumpSpecial(i,i,filepos,datafile,TRUE,report);
        END;

        IF cmd= explainTwo THEN
            secondaryhexStr:=fmtc(hexagram2,blank,dot,1);
            hitanykey(pause);
            dumpText(hexagram2,secondaryhexStr,datafile,report,targetHexagram,filepos);
        END;
    END;
    (* gotoXY(getMinHtab(),getVtab()-1); (* prevent ugly exit *) *)
    IF report THEN
        FIO.Close(hout);
        getCurrentDirectory(S);
        Str.Concat(R,S,reportfile);
        Str.Append(S,workfile);
        IF FIO.Exists(R) THEN FIO.Erase(R);END;
        FIO.Rename(S,R);
        Str.Append(R," report file has been written.");
        WrStr(R);WrLn;
        WrLn;
    END;
    WrStr("Remember to check texts in Wilhelm & Perrot's bible !");WrLn;

    BiosFlushkey; (* just in case *)
    abort(errNone,"");
END YiKing.

