
(* ---------------------------------------------------------------
Title         Q&D Is Empty
Overview      check for directory existence and/or emptiness
Usage         see help
Notes
              note that under Win9X, hard disks other than C: are NOT seen
              before GUI was loaded : directly going to DOS,
              we are informed D:, E:, F: are phantom drives (our code 16),
              and DOS cannot even see them !
Bugs
Wish List     LFN support ? ah ah, only serious !

--------------------------------------------------------------- *)

MODULE isEmpty;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XsupportLFN;

(* ------------------------------------------------------------ *)

TYPE
    pathtype = path9X;

CONST
    exe         = "ISEMPTY";
CONST
    nl          = CHR(13)+CHR(10);
    star        = "*";
    dot         = ".";
    stardotstar = star+dot+star;
    dotdot      = dot+dot;
    dquote      = '"';
    colon       = ":";
    backslash   = "\";
CONST
    msgHelp     =
"Q&D IsEmpty v1.0d by PhG"+nl+
nl+
"Syntax : "+exe+" <directory> [-verbose] [-lfn] [-x]"+nl+
nl+
"-x option excludes floppy and CDROM units. Program returns an error code :"+nl+
"255 if <directory> is empty, 128 if <directory> is not empty,"+nl+
"64 if <directory> is not a directory, 32 if <directory> does not exist,"+nl+
"16 if <directory> does not refer to a valid unit.";

    placeholder = "$";
    rcEmpty   = 255; msgEmpty    ="Return code 255 ($ is empty)"+nl;
    rcNotEmpty= 128; msgNotEmpty ="Return code 128 ($ is not empty)"+nl;
    rcNotDir  =  64; msgNotDir   ="Return code 64 ($ is not a directory)"+nl;
    rcNotFound=  32; msgNotFound ="Return code 32 ($ does not exist)"+nl;
    rcPhantom =  16; msgPhantom  ="Return code 16 ($ does not refer to a valid unit)"+nl;

PROCEDURE abort (rc:CARDINAL;S:ARRAY OF CHAR);
BEGIN
    IF same(S,"")=FALSE THEN WrStr(S);WrLn;END;
    Lib.SetReturnCode( SHORTCARD(rc) );
    HALT;
END abort;

PROCEDURE terminate(useLFN,verbose:BOOLEAN; rc:CARDINAL; msg,dirspec:ARRAY OF CHAR);
VAR
    S:str1024; (* was str128 *)
BEGIN
    IF verbose THEN
        Str.Copy(S,msg);
        IF useLFN THEN
            Str.Subst(S,placeholder,dquote+placeholder+dquote);
        END;
        Str.Subst(S,placeholder,dirspec);
        WrStr(S);
    END;
    abort(rc,"");
END terminate;

(* ------------------------------------------------------------ *)


CONST
    w9XnothingRequired = FIO.FileAttr{};

PROCEDURE w9XisDirectory (S : pathtype) : BOOLEAN;
VAR
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    found,rc : BOOLEAN;
    dosattr:FIO.FileAttr;
BEGIN
    unfixDirectory(S);
    CASE Str.Length(S) OF
    | 2 : (* avoid "u:" alone ! *)
        IF S[1]=colon THEN RETURN TRUE; END; (* always but we do not check for its real life *)
    | 3 : (* avoid "u:\" alone ! *)
        IF S[1]=colon THEN
            IF S[2]=backslash THEN RETURN TRUE; END; (* always but we do not check for its real life *)
        END;
    END;
    found := w9XfindFirst (S,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                          unicodeconversion,w9Xentry,w9Xhandle,errcode);
    rc:=w9XfindClose(w9Xhandle,errcode);
    IF found = FALSE THEN RETURN FALSE; END;
    dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
    RETURN (aD IN dosattr);
END w9XisDirectory;

(* ------------------------------------------------------------ *)

PROCEDURE isDirectorySpec ( useLFN:BOOLEAN;dirspec:pathtype):BOOLEAN;
BEGIN
    IF useLFN THEN
        RETURN w9XisDirectory(dirspec);
    ELSE
        RETURN isDirectory(dirspec);
    END;
END isDirectorySpec;

(* ------------------------------------------------------------ *)

PROCEDURE isDirEntry (S : ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isDirEntry;

PROCEDURE existence (useLFN:BOOLEAN; S:pathtype):BOOLEAN;
VAR
    entry:FIO.DirEntry;
    found:BOOLEAN;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    rc : BOOLEAN;
BEGIN
    unfixDirectory(S); (* no DOS loves trailing backslash *)
    IF useLFN THEN
        found := w9XfindFirst (S,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
        rc:=w9XfindClose(w9Xhandle,errcode);
    ELSE
        found:= FIO.ReadFirstEntry(S,everything,entry);
    END;
    RETURN found;
END existence;

PROCEDURE countFiles (DEBUG,useLFN:BOOLEAN;spec:pathtype  ):CARDINAL;
VAR
    n:CARDINAL;
    found:BOOLEAN;
    entry:FIO.DirEntry;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    fname:pathtype;
    rc:BOOLEAN;
BEGIN
    n:=0;

    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(fname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(fname,entry.Name);
        END;
        IF isDirEntry(fname)=FALSE THEN (* skip . AND .. *)
            IF DEBUG THEN
                IF useLFN THEN WrStr(dquote);END;
                WrStr(fname);
                IF useLFN THEN WrStr(dquote);END;
                WrLn;
            END;
            INC(n);
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;

    RETURN n;
END countFiles;

PROCEDURE chkUnit (flag:BOOLEAN;S:pathtype):BOOLEAN;
VAR
    u,d,n,e:pathtype;
    ch:CHAR;
    ok:BOOLEAN;
    sHD:str80;
BEGIN
    getAllLegalUnits(flag,TRUE,flag,sHD);
    Lib.SplitAllPath(S,u,d,n,e);
    IF same(u,"") THEN
        ch:=CHAR ( FIO.GetDrive() + ORD("A") -1 );
    ELSE
        IF Str.Match(u,"?:") THEN
            ch:=CAP (u[0]);
        ELSE
            ch:=" "; (* force error *)
        END;
    END;
    RETURN Belongs( sHD, ch );
END chkUnit;

(* ------------------------------------------------------------ *)

VAR
    S,R,dirspec:pathtype;
    verbose,useLFN,includeAll,DEBUG:BOOLEAN;
    opt,i,parmcount,n:CARDINAL;
    state:(waiting,gotparm);
BEGIN
    WrLn;

    verbose:=FALSE;
    useLFN:=TRUE;
    includeAll:=TRUE;
    DEBUG:=FALSE;
    parmcount := Lib.ParamCount();
    state:=waiting;
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "V"+delim+"VERBOSE"+delim+
                                  "L"+delim+"LFN"+delim+
                                  "X"+delim+"EXCLUDE"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            | 1,2,3   : abort(1,msgHelp);
            | 4,5     : verbose:=TRUE;
            | 6,7     : useLFN:=FALSE;
            | 8,9     : includeAll:=FALSE;
            | 10      : DEBUG:=TRUE;
            ELSE
                abort(2,"Unknown option !");
            END;
        ELSE
            CASE state OF
            | waiting:
                Str.Copy(dirspec,S);
            ELSE
                abort(3,"More than one parameter !");
            END;
            INC(state);
        END;
    END;
    IF state = waiting THEN abort(1,msgHelp);END;

    IF chkJoker(dirspec) THEN abort(4,"Jokers not allowed !");END;

    useLFN:=( useLFN AND w9XsupportLFN() );

    IF useLFN=FALSE THEN UpperCase(dirspec);END;

    IF chkUnit(includeAll,dirspec)=FALSE THEN
        terminate(useLFN,verbose,rcPhantom,msgPhantom,dirspec);
    END;

    IF existence(useLFN,dirspec)=FALSE THEN
        terminate(useLFN,verbose,rcNotFound,msgNotFound,dirspec);
    END;

    IF isDirectorySpec(useLFN,dirspec)=FALSE THEN
        terminate(useLFN,verbose,rcNotDir,msgNotDir,dirspec);
    END;

    fixDirectory(dirspec);
    Str.Copy(R,dirspec);
    Str.Append(R,stardotstar);

    n:=countFiles(DEBUG,useLFN,R);

    CASE n OF
    | 0 :
        terminate(useLFN,verbose,rcEmpty,msgEmpty,dirspec);
    ELSE
        terminate(useLFN,verbose,rcNotEmpty,msgNotEmpty,dirspec);
    END;
END isEmpty.

