
(* ---------------------------------------------------------------
Title         Q&D Check Columns and Rows
Overview      self-explanatory !
Notes         yes, a mere batch would do
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE ChkCR;

IMPORT Lib;
IMPORT Str;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory, cleantabs,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim,
completedInit, completedShow, completedSHOW, completedEnd, completed;

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "CHKCR";
    ProgTitle     = "Q&D Check Columns and Rows";
    ProgVersion   = "v1.0";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

(* ------------------------------------------------------------ *)

CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errBadValue     = 3;

    errMatch        = 128;
    errMismatch     = 255;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [-v] <number of columns> <number of rows>"+nl+
nl+
"Return code is 128 if screen dimensions match specified values, and 255 if not."+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrLn;
        WrStr(helpmsg);
    | errOption :
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," option !");
    | errBadValue:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," value !");

    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp, errMatch, errMismatch: ;
    ELSE
        WrLn;
        WrStr(ProgEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

PROCEDURE getCard (S:ARRAY OF CHAR) : CARDINAL;
CONST
    lower = 1;
    upper = MAX(CARDINAL)-1;
VAR
    lc : LONGCARD;
    ok : BOOLEAN;
BEGIN
    lc := Str.StrToCard(S,10,ok);
    IF ok THEN
        IF ( (lc < lower) OR (lc > upper) ) THEN ok:=FALSE; END;
    END;
    IF ok=FALSE THEN RETURN MAX(CARDINAL); END;
    RETURN CARDINAL(lc);
END getCard;

PROCEDURE getShortCard (S:ARRAY OF CHAR) : SHORTCARD;
CONST
    lower = 1;
    upper = MAX(SHORTCARD)-1;
VAR
    lc : LONGCARD;
    ok : BOOLEAN;
BEGIN
    lc := Str.StrToCard(S,10,ok);
    IF ok THEN
        IF ( (lc < lower) OR (lc > upper) ) THEN ok:=FALSE; END;
    END;
    IF ok=FALSE THEN RETURN MAX(SHORTCARD); END;
    RETURN SHORTCARD(lc);
END getShortCard;

(* ------------------------------------------------------------ *)

CONST
    segBIOSdata = 040H;
VAR
    columnsOnScreen [segBIOSdata:004AH] : CARDINAL; (* a WORD *)
    rowsOnScreen    [segBIOSdata:0084H] : SHORTCARD; (* a byte minus 1 *)
CONST
    msgMatch    = "+++ Current screen dimensions match specified values !";
    msgMismatch = "--- Current screen dimensions do not match specified values !";
VAR
    parmcount,i,opt : CARDINAL;
    S,R             : str128;
    verbose         : BOOLEAN;
    state           : (waiting,gotcolumns,gotrows);
    chkrows         : SHORTCARD;
    chkcols         : CARDINAL;
    rc              : CARDINAL;
BEGIN
    state   := waiting;
    verbose := FALSE;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R,"?"+delim+"H"+delim+"HELP"+delim+
                                  "V"+delim+"VERBOSE"
                               );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5   : verbose := TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE state OF
            | waiting:
                chkcols:=getCard(R);
                IF chkcols=MAX(CARDINAL) THEN abort(errBadValue,S);END;
            | gotcolumns:
                chkrows:=getShortCard(R);
                IF chkrows=MAX(SHORTCARD) THEN abort(errBadValue,S);END;
                DEC(chkrows); (* remember BIOS screen rows is -1 *)
            | gotrows:
                abort(errHelp,"");
            END;
            INC(state);
        END;
    END;
    IF state # gotrows THEN abort(errHelp,"");END;

    IF verbose THEN WrLn;WrStr(Banner);WrLn;WrLn;END;

    rc:=0;
    IF rowsOnScreen = chkrows THEN INC(rc);END;
    IF columnsOnScreen = chkcols THEN INC(rc); END;

    IF rc # 2 THEN
        IF verbose THEN WrStr(msgMismatch);WrLn;END;
        rc := errMismatch;
    ELSE
        IF verbose THEN WrStr(msgMatch);WrLn;END;
        rc := errMatch;
    END;

    abort(rc,"");
END ChkCR.
