
(* ---------------------------------------------------------------
Title         Q&D Check Rows
Overview      self-explanatory !
Notes
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE ChkRows;

IMPORT Lib;
IMPORT Str;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory, cleantabs,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim,
completedInit, completedShow, completedSHOW, completedEnd, completed;

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "CHKROWS";
    ProgTitle     = "Q&D Check Rows";
    ProgVersion   = "v1.0";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

(* ------------------------------------------------------------ *)

CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errTooManyParms = 3;
    errBadValue     = 4;

    errMatch        = 128;
    errMismatch     = 255;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [-v] <number of rows>..."+nl+
nl+
"Return code is 128 if row count is any of specified values, and 255 if not."+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrLn;
        WrStr(helpmsg);
    | errOption :
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," option !");
    | errTooManyParms:
        Str.Concat(S,einfo," is one parameter too many !");
    | errBadValue:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," value !");

    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp, errMatch, errMismatch: ;
    ELSE
        WrLn;
        WrStr(ProgEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

PROCEDURE getShortCard (S:ARRAY OF CHAR) : SHORTCARD;
CONST
    lower = 1;
    upper = MAX(SHORTCARD)-1;
VAR
    lc : LONGCARD;
    ok : BOOLEAN;
BEGIN
    lc := Str.StrToCard(S,10,ok);
    IF ok THEN
        IF ( (lc < lower) OR (lc > upper) ) THEN ok:=FALSE; END;
    END;
    IF ok=FALSE THEN RETURN MAX(SHORTCARD); END;
    RETURN SHORTCARD(lc);
END getShortCard;

(* ------------------------------------------------------------ *)

CONST
    segBIOSdata = 040H;
VAR
    rowsOnScreen [segBIOSdata:0084H] : SHORTCARD; (* a byte minus 1 *)
CONST
    firstval    = 1;
    maxval      = 32;
    msgMatch    = "+++ Current number of rows matches one of specified values !";
    msgMismatch = "--- Current number of rows does not match specified values !";
VAR
    value : ARRAY [firstval..maxval] OF SHORTCARD;
VAR
    parmcount,i,opt : CARDINAL;
    S,R             : str128;
    lastval,rc      : CARDINAL;
    verbose         : BOOLEAN;
BEGIN
    lastval := firstval-1;
    verbose := FALSE;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R,"?"+delim+"H"+delim+"HELP"+delim+
                                  "V"+delim+"VERBOSE"
                               );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5   : verbose := TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            INC(lastval);
            IF lastval > maxval THEN abort(errTooManyParms,S);END;
            value[lastval]:=getShortCard(R);
            IF value[lastval]=MAX(SHORTCARD) THEN abort(errBadValue,S);END;
            DEC(value[lastval]); (* remember BIOS screen rows is -1 *)
        END;
    END;
    IF lastval < firstval THEN abort(errHelp,""); END;

    IF verbose THEN WrLn;WrStr(Banner);WrLn;WrLn;END;

    rc:=0;
    FOR i := firstval TO lastval DO
        IF rowsOnScreen = value[i] THEN INC(rc); END;
    END;

    IF rc = 0 THEN
        IF verbose THEN WrStr(msgMismatch);WrLn;END;
        rc := errMismatch;
    ELSE
        IF verbose THEN WrStr(msgMatch);WrLn;END;
        rc := errMatch;
    END;

    abort(rc,"");
END ChkRows.
